fn approx_sqrt(x: f32) -> f32 {
    let mentisa = (x.to_bits() & 0x007f_ffff);
    let ilog = (x.to_bits() >> 23) as i32 - 127;
    let ilog_half = ilog / 2;
    let bits = mentisa | (((ilog_half + 127) as u32) << 23);
    f32::from_bits(bits)
}

fn main() {
    for i in 0..=64 {
        let x = i as f32 / 64.0;
        let exact = x.sqrt();
        let approx = approx_sqrt(x);
        println!("{:.7}  {:.7}  {:.7}  {:.7}",
                 x, exact, approx, (exact - approx).abs())
    }
}
