/*
 * CDE - Common Desktop Environment
 *
 * Copyright (c) 1993-2012, The Open Group. All rights reserved.
 *
 * These libraries and programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * These libraries and programs are distributed in the hope that
 * they will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with these libraries and programs; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
/* $XConsortium: dtb_utils.h /main/3 1995/11/06 16:18:28 rswiston $ */
/*
 * File: dtb_utils.h
 * CDE Application Builder General Utility Functions
 *
 * This file was generated by dtcodegen, from project dtmailopts
 *
 *    ** DO NOT MODIFY BY HAND - ALL MODIFICATIONS WILL BE LOST **
 */
#ifndef _DTB_UTILS_H_
#define _DTB_UTILS_H_

#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

/*
 * Function type for client session save callback
 */
typedef Boolean (*DtbClientSessionSaveCB) (
    Widget,
    char *,
    char ***,
    int *
);
typedef struct {
    char	*help_text;
    char	*help_volume;
    char	*help_locationID;
} DtbObjectHelpDataRec, *DtbObjectHelpData;

/*
 * Returns answer value for modal MessageBox
 */
typedef enum {
    DTB_ANSWER_NONE,
    DTB_ANSWER_ACTION1,
    DTB_ANSWER_ACTION2,
    DTB_ANSWER_ACTION3,
    DTB_ANSWER_CANCEL,
    DTB_ANSWER_HELP
} DTB_MODAL_ANSWER;

/*
 * Values for MessageBox default button
 */
typedef enum {
    DTB_ACTION1_BUTTON,
    DTB_ACTION2_BUTTON,
    DTB_ACTION3_BUTTON,
    DTB_CANCEL_BUTTON,
    DTB_NONE
} DTB_BUTTON;

/*
 * Types/ways of centering an object
 */
typedef enum {
    DTB_CENTER_NONE,
    DTB_CENTER_POSITION_VERT,
    DTB_CENTER_POSITION_HORIZ,
    DTB_CENTER_POSITION_BOTH
} DTB_CENTERING_TYPES;

/*
 * Types of group layout
 */
typedef enum {
    DTB_GROUP_NONE,
    DTB_GROUP_ROWS,
    DTB_GROUP_COLUMNS,
    DTB_GROUP_ROWSCOLUMNS
} DTB_GROUP_TYPES;

/*
 * Types/ways of aligning the children of a group
 */
typedef enum {
    DTB_ALIGN_NONE,
    DTB_ALIGN_TOP,
    DTB_ALIGN_RIGHT,
    DTB_ALIGN_BOTTOM,
    DTB_ALIGN_LEFT,
    DTB_ALIGN_VCENTER,
    DTB_ALIGN_HCENTER,
    DTB_ALIGN_LABELS
} DTB_ALIGN_TYPES;

/*
 * Structure to store attributes of a group
 */
typedef struct {
    DTB_GROUP_TYPES     group_type;
    DTB_ALIGN_TYPES     row_align;
    DTB_ALIGN_TYPES     col_align;
    int                 margin;
    int                 num_rows;
    int                 num_cols;
    int                 hoffset;
    int                 voffset;
    Widget              ref_widget;
} DtbGroupInfo;



/*
 * Application Builder utility functions
 */
int dtb_cvt_file_to_pixmap(
    String	fileName,
    Widget	widget,
    Pixmap	*pixmapReturnPtr
);
int dtb_set_label_pixmaps(
    Widget	widget,
    Pixmap	labelPixmap,
    Pixmap	labelInsensitivePixmap
);
int dtb_set_label_from_bitmap_data(
    Widget		widget,
    int			width,
    int			height,
    unsigned char	*bitmapData
);
Boolean dtb_file_has_extension(
    String	fileName, 
    String	extension
);
int dtb_cvt_filebase_to_pixmap(
    Widget	widget,
    String	fileBase,
    String	extension,
    Pixmap	*pixmap_ptr
);
int dtb_cvt_image_file_to_pixmap(
		Widget	widget,
		String	fileName,
		Pixmap	*pixmap
);
int dtb_set_label_from_image_file(
		Widget	widget,
		String	fileName
);
unsigned long dtb_cvt_resource_from_string(
    Widget		parent,
    String		res_type,
    unsigned int	size_of_type,
    String		res_str_value,
    unsigned long	error_value
);
Pixmap dtb_create_greyed_pixmap(
    Widget	widget,
    Pixmap	pixmap
);
void dtb_save_toplevel_widget(
    Widget	toplevel
);
Widget dtb_get_toplevel_widget();
void dtb_save_command(
    char	*argv0
);
char *  dtb_get_command();
String dtb_get_exe_dir(void);
#ifdef DEAD_WOOD
void dtb_help_dispatch(
    Widget 	widget,
    XtPointer 	clientData,
    XtPointer 	callData
);
#endif /* DEAD_WOOD */
void dtb_more_help_dispatch(
    Widget 	widget,
    XtPointer 	clientData,
    XtPointer 	callData
);
void dtb_help_back_hdlr(
    Widget 	widget,
    XtPointer 	clientData,
    XtPointer 	callData
);
#ifdef DEAD_WOOD
void dtb_do_onitem_help();
#endif /* DEAD_WOOD */
int dtb_show_help_volume_info(
    char	*volume_name,
    char	*location_id
);
#ifdef DEAD_WOOD
void  dtb_call_help_callback(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
);
void dtb_children_center(
    Widget		form,
    DTB_CENTERING_TYPES	type
);
void dtb_children_uncenter(
    Widget		form,
    DTB_CENTERING_TYPES	type
);
#endif /* DEAD_WOOD */
void dtb_center(
    Widget		form_child,
    DTB_CENTERING_TYPES	type
);
void dtb_uncenter(
    Widget		form_child,
    DTB_CENTERING_TYPES	type
);
void dtb_children_align(
    Widget		parent,
    DTB_GROUP_TYPES	group_type,
    DTB_ALIGN_TYPES	row_align,
    DTB_ALIGN_TYPES	col_align,
    int			margin,
    int			num_rows,
    int			num_cols,
    int			hoffset,
    int			voffset
);
void dtb_session_save(
    Widget 	widget,
    XtPointer 	clientData,
    XtPointer 	callData
);
DtbClientSessionSaveCB dtb_get_client_session_saveCB();


#define dtb_cvt_string_to_pixel(parent, str) \
        ((Pixel)dtb_cvt_resource_from_string( \
                   (parent), XtRPixel, sizeof(Pixel), (str), 0))

#endif /* _DTB_UTILS_H_ */
