/*
 * CDE - Common Desktop Environment
 *
 * Copyright (c) 1993-2012, The Open Group. All rights reserved.
 *
 * These libraries and programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * These libraries and programs are distributed in the hope that
 * they will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with these libraries and programs; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
/* $TOG: PropUi.hh /main/9 1998/02/17 13:45:35 mgreess $ */
/*
 *+SNOTICE
 *
 *	RESTRICTED CONFIDENTIAL INFORMATION:
 *	
 *	The information in this document is subject to special
 *	restrictions in a confidential disclosure agreement bertween
 *	HP, IBM, Sun, USL, SCO and Univel.  Do not distribute this
 *	document outside HP, IBM, Sun, USL, SCO, or Univel wihtout
 *	Sun's specific written approval.  This documment and all copies
 *	and derivative works thereof must be returned or destroyed at
 *	Sun's request.
 *
 *	Copyright 1993 Sun Microsystems, Inc.  All rights reserved.
 *
 *+ENOTICE
 */

#include "PropSource.hh"

#ifndef _PROPUI_HH
#define _PROPUI_HH

// This class is the 'glue' between the mail back end and the Props GUI as 
// generated by dtbuilder


// defines the type of item one wishes to create
typedef enum {
  _ANTICHECKBOX_ITEM,
  _CHECKBOX_ITEM,
  _TEXTFIELD_ITEM,
  _LIST_ITEM,
  _SPINBOX_ITEM,
  _SCALE_ITEM,
  _INDEXED_OPTIONMENU_ITEM
  } PROP_UI_ITEM_TYPE;

// defines the possible sources for props variables
typedef enum { 
  _FROM_MAILRC,
  _FROM_XRDB,
   _FROM_FILE
  } PROP_SOURCES;

// CLASS PropUiItem
// Base class for Prop sheet item glue list elements
///////////////////////////////////////////////////////////
class PropUiItem {

public:
  typedef char* (*PropUiCallback)(PropUiItem*, void*);
  
  PropUiItem(
	Widget w,
	int source,
	char *search_key,
	PropUiCallback validator = NULL,
	void * validator_data = NULL);
  virtual ~PropUiItem();
  
  Widget	getWidget(){ return prop_widget; };
  virtual char	* uiValueIsValid();
  virtual void	 writeFromUiToSource() = 0;
  virtual void	 writeFromSourceToUi() = 0;
  Boolean	 getDirtyBit(){ return dirty_bit; };
  void		 setDirtyBit(Boolean db) { dirty_bit = db; };
  char		*getKey(){ return key; };
  PropSource 	*getPropSource(){ return prop_source; };

protected:

  Boolean	 dirty_bit;
  PropSource	*prop_source;

private:

  Widget 	 prop_widget;
  char 		*key;
  PropUiCallback _uiValueValidator;
  void		*_uiValueValidatorData;

};

#endif
