// enve - 2D animations software
// Copyright (C) 2016-2020 Maurycy Liebner

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef TIMELINESETTINGSWIDGET_H
#define TIMELINESETTINGSWIDGET_H

#include "settingswidget.h"

#include <QCheckBox>

class ColorAnimatorButton;

class TimelineSettingsWidget : public SettingsWidget {
public:
    explicit TimelineSettingsWidget(QWidget *parent = nullptr);

    void applySettings();
    void updateSettings();
private:
    QCheckBox* mAlternateRowCheck = nullptr;
    ColorAnimatorButton* mAlternateRowColor = nullptr;

    QCheckBox* mHighlightRowCheck = nullptr;
    ColorAnimatorButton* mHighlightRowColor = nullptr;

    ColorAnimatorButton* mObjectKeyframeColor = nullptr;
    ColorAnimatorButton* mPropertyGroupKeyframeColor = nullptr;
    ColorAnimatorButton* mPropertyKeyframeColor = nullptr;
    ColorAnimatorButton* mSelectedKeyframeColor = nullptr;

    ColorAnimatorButton* mVisibilityRangeColor = nullptr;
    ColorAnimatorButton* mSelectedVisibilityRangeColor = nullptr;
    ColorAnimatorButton* mAnimationRangeColor = nullptr;
};

#endif // TIMELINESETTINGSWIDGET_H
