// enve - 2D animations software
// Copyright (C) 2016-2020 Maurycy Liebner

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef PATHBOXRENDERDATA_H
#define PATHBOXRENDERDATA_H
#include "boxrenderdata.h"
#include "Animators/paintsettingsanimator.h"

struct CORE_EXPORT PathBoxRenderData : public BoxRenderData {
    PathBoxRenderData(BoundingBox * const parentBox);

    SkPath fEditPath;
    SkPath fPath;
    SkPath fFillPath;
    SkPath fOutlineBasePath;
    SkPath fOutlinePath;
    SkStroke fStroker;
    UpdatePaintSettings fPaintSettings;
    UpdateStrokeSettings fStrokeSettings;

    void updateRelBoundingRect();
    QPointF getCenterPosition();
protected:
    void setupRenderData();
    void drawSk(SkCanvas * const canvas);
    void drawOnParentLayer(SkCanvas * const canvas, SkPaint &paint);
    void copyFrom(BoxRenderData *src);
private:
    void setupDirectDraw();

    bool mDirectDraw = false;
};

#endif // PATHBOXRENDERDATA_H
