// enve - 2D animations software
// Copyright (C) 2016-2020 Maurycy Liebner

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef CUSTOMPATHEFFECT_H
#define CUSTOMPATHEFFECT_H
#include "patheffect.h"
#include "../customidentifier.h"

class CORE_EXPORT CustomPathEffect : public PathEffect {
public:
    CustomPathEffect(const QString& name);

    virtual CustomIdentifier getIdentifier() const = 0;
private:
    void writeIdentifier(eWriteStream& dst) const final;
    void writeIdentifierXEV(QDomElement& ele) const final;
};

#endif // CUSTOMPATHEFFECT_H
