#ifndef _ENVENTOR_OBJECT_EO_H_
#define _ENVENTOR_OBJECT_EO_H_

#ifndef _ENVENTOR_OBJECT_EO_CLASS_TYPE
#define _ENVENTOR_OBJECT_EO_CLASS_TYPE

typedef Eo Enventor_Object;

#endif

#ifndef _ENVENTOR_OBJECT_EO_TYPES
#define _ENVENTOR_OBJECT_EO_TYPES


#endif
#define ENVENTOR_OBJECT_CLASS enventor_object_class_get()

EWAPI const Eo_Class *enventor_object_class_get(void);

EOAPI void enventor_obj_part_highlight_set(Eo *obj, Eina_Bool part_highlight);

EOAPI Eina_Bool enventor_obj_part_highlight_get(const Eo *obj);

EOAPI void enventor_obj_live_view_scale_set(Eo *obj, double scale);

EOAPI double enventor_obj_live_view_scale_get(const Eo *obj);

EOAPI void enventor_obj_dummy_parts_set(Eo *obj, Eina_Bool dummy_parts);

EOAPI Eina_Bool enventor_obj_dummy_parts_get(const Eo *obj);

EOAPI void enventor_obj_wireframes_set(Eo *obj, Eina_Bool wireframe);

EOAPI Eina_Bool enventor_obj_wireframes_get(const Eo *obj);

EOAPI void enventor_obj_mirror_mode_set(Eo *obj, Eina_Bool mirror_mode);

EOAPI Eina_Bool enventor_obj_mirror_mode_get(const Eo *obj);

EOAPI void enventor_obj_auto_complete_set(Eo *obj, Eina_Bool auto_complete);

EOAPI Eina_Bool enventor_obj_auto_complete_get(const Eo *obj);

EOAPI void enventor_obj_auto_indent_set(Eo *obj, Eina_Bool auto_indent);

EOAPI Eina_Bool enventor_obj_auto_indent_get(const Eo *obj);

EOAPI void enventor_obj_ctxpopup_set(Eo *obj, Eina_Bool ctxpopup);

EOAPI Eina_Bool enventor_obj_ctxpopup_get(const Eo *obj);

EOAPI void enventor_obj_focus_set(Eo *obj, Eina_Bool focus);

EOAPI Eina_Bool enventor_obj_focus_get(const Eo *obj);

EOAPI void enventor_obj_font_scale_set(Eo *obj, double font_scale);

EOAPI double enventor_obj_font_scale_get(const Eo *obj);

EOAPI void enventor_obj_linenumber_set(Eo *obj, Eina_Bool linenumber);

EOAPI Eina_Bool enventor_obj_linenumber_get(const Eo *obj);

EOAPI void enventor_obj_smart_undo_redo_set(Eo *obj, Eina_Bool smart_undo_redo);

EOAPI Eina_Bool enventor_obj_smart_undo_redo_get(const Eo *obj);

EOAPI Eina_Bool enventor_obj_path_set(Eo *obj, Enventor_Path_Type type, const Eina_List *pathes);

EOAPI const Eina_List *enventor_obj_path_get(Eo *obj, Enventor_Path_Type type);

EOAPI Eina_List *enventor_obj_programs_list_get(Eo *obj);

EOAPI Eina_List *enventor_obj_part_states_list_get(Eo *obj, const char *type);

EOAPI Eina_List *enventor_obj_parts_list_get(Eo *obj);

EOAPI Efl_Canvas_Object *enventor_obj_live_view_get(Eo *obj);

EOAPI void enventor_obj_programs_stop(Eo *obj);

EOAPI void enventor_obj_program_run(Eo *obj, const char *program);

EOAPI void enventor_obj_syntax_color_set(Eo *obj, Enventor_Syntax_Color_Type color_type, const char *val);

EOAPI const char *enventor_obj_syntax_color_get(Eo *obj, Enventor_Syntax_Color_Type color_type);

EOAPI Eina_Bool enventor_obj_ctxpopup_visible_get(Eo *obj);

EOAPI void enventor_obj_ctxpopup_dismiss(Eo *obj);

EOAPI void enventor_obj_disabled_set(Eo *obj, Eina_Bool disabled);

EOAPI void enventor_obj_live_view_size_set(Eo *obj, Evas_Coord w, Evas_Coord h);

EOAPI void enventor_obj_live_view_size_get(Eo *obj, Evas_Coord *w, Evas_Coord *h);

EOAPI Edje_Part_Type enventor_obj_part_type_get(Eo *obj, const char *part_name);

EOAPI void enventor_obj_font_set(Eo *obj, const char *font_name, const char *font_style);

EOAPI void enventor_obj_font_get(Eo *obj, const char **font_name, const char **font_style);

EOAPI void enventor_obj_auto_complete_list_show(Eo *obj);

EOAPI void enventor_obj_keyword_reference_show(Eo *obj);

EOAPI double enventor_obj_base_scale_get(Eo *obj);

EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_CURSOR_LINE_CHANGED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_CURSOR_GROUP_CHANGED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_LIVE_VIEW_UPDATED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_LIVE_VIEW_LOADED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_LIVE_VIEW_CURSOR_MOVED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_LIVE_VIEW_RESIZED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_MAX_LINE_CHANGED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_COMPILE_ERROR;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_CTXPOPUP_ACTIVATED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_CTXPOPUP_CHANGED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_CTXPOPUP_DISMISSED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_EDC_MODIFIED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_FOCUSED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJ_EVENT_FILE_OPEN_REQUESTED;

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_CURSOR_LINE_CHANGED (&(_ENVENTOR_OBJ_EVENT_CURSOR_LINE_CHANGED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_CURSOR_GROUP_CHANGED (&(_ENVENTOR_OBJ_EVENT_CURSOR_GROUP_CHANGED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_LIVE_VIEW_UPDATED (&(_ENVENTOR_OBJ_EVENT_LIVE_VIEW_UPDATED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_LIVE_VIEW_LOADED (&(_ENVENTOR_OBJ_EVENT_LIVE_VIEW_LOADED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_LIVE_VIEW_CURSOR_MOVED (&(_ENVENTOR_OBJ_EVENT_LIVE_VIEW_CURSOR_MOVED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_LIVE_VIEW_RESIZED (&(_ENVENTOR_OBJ_EVENT_LIVE_VIEW_RESIZED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_MAX_LINE_CHANGED (&(_ENVENTOR_OBJ_EVENT_MAX_LINE_CHANGED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_COMPILE_ERROR (&(_ENVENTOR_OBJ_EVENT_COMPILE_ERROR))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_CTXPOPUP_ACTIVATED (&(_ENVENTOR_OBJ_EVENT_CTXPOPUP_ACTIVATED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_CTXPOPUP_CHANGED (&(_ENVENTOR_OBJ_EVENT_CTXPOPUP_CHANGED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_CTXPOPUP_DISMISSED (&(_ENVENTOR_OBJ_EVENT_CTXPOPUP_DISMISSED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_EDC_MODIFIED (&(_ENVENTOR_OBJ_EVENT_EDC_MODIFIED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_FOCUSED (&(_ENVENTOR_OBJ_EVENT_FOCUSED))

/**
 * No description
 */
#define ENVENTOR_OBJ_EVENT_FILE_OPEN_REQUESTED (&(_ENVENTOR_OBJ_EVENT_FILE_OPEN_REQUESTED))

#endif
