#!/bin/sh

rm -rf autom4te.cache
rm -f aclocal.m4 ltmain.sh

if [ -d ".git" ]; then
    echo "Getting all submodules"
    if [ $(git submodule status | cut -c1 | grep "-") ]; then
        echo "A few submodules are not initializied."
        echo "Calling 'git submodule update --init --recursive'"
        git submodule update --init --recursive
    fi
fi
echo "Running autopoint..." ; autopoint -f || :
echo "Running aclocal..." ; aclocal -I m4 $ACLOCAL_FLAGS || exit 1
echo "Running autoconf..." ; autoconf || exit 1
echo "Running autoheader..." ; autoheader || exit 1
echo "Running libtoolize..." ; (libtoolize --copy --automake || glibtoolize --automake) || exit 1
echo "Running automake..." ; automake --add-missing --copy --gnu || exit 1

if [ -z "$NOCONFIGURE" ]; then
  ./configure "$@"
fi
