#include <Elementary.h>
#include <Elementary_Cursor.h>
#include "extra_private.h"
#include "../lib/extra.h"

static Evas_Object *_selector;

static Elm_Gengrid_Item_Class *_item_class_basic;

static Extra_Ui_Small_Preview_Accessor acc = {
    ((Extra_ui_preview_get*) extra_background_preview_get),
    ((Extra_ui_preview_download*) extra_background_preview_download),
};

static void
_background_installed(void *data EINA_UNUSED)
{
    /*TODO FIND A WAY TO REMOTE OPEN ENLIGHTENMENT BACKGROUND SELECTOR*/
}

static void
_install_background(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
   Extra_Background *b = data;
   Extra_Progress *p;

   p = extra_ui_progress_popup_show("Installing background", _background_installed, b);
   extra_background_download(p, b);
}

static void
_uninstall_background(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
   Extra_Background *b = data;

   extra_background_delete(b);
}

static void
_fullscreen_background(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
   Extra_Background *b = data;
   char *path;

   path = extra_background_preview_get(b);
   if (!path) return;

   extra_ui_fullscreen_preview(path);
}

static void
_show_tooltip(Extra_Background *b)
{
    Evas_Object *box, *o, *icon;

    box = elm_box_add(_ui.win);
    elm_box_horizontal_set(box, EINA_TRUE);

    o = elm_button_add(box);
    icon = elm_icon_add(o);

    if (extra_background_installed(b))
      {
         elm_object_text_set(o, "Uninstall");
         elm_icon_standard_set(icon, "edit-delete");
         evas_object_smart_callback_add(o, "clicked", _uninstall_background, b);
      }
    else
      {
         elm_object_text_set(o, "Install");
         elm_icon_standard_set(icon, "emblem-downloads");
         evas_object_smart_callback_add(o, "clicked", _install_background, b);
      }
    elm_object_part_content_set(o, "icon", icon);
    elm_box_pack_end(box, o);
    evas_object_show(o);

    //view-fullscreen
    o = elm_button_add(box);
    elm_object_text_set(o, "Show fullscreen");
    evas_object_smart_callback_add(o, "clicked", _fullscreen_background , b);
    elm_box_pack_end(box, o);
    evas_object_show(o);
    icon = elm_icon_add(o);
    elm_icon_standard_set(icon, "view-fullscreen");
    elm_object_part_content_set(o, "icon", icon);

    extra_ui_show_popup_toolbar(box);
}

static void
_fill_backgrounds(void)
{
   Eina_List *backgrounds, *n;
   Extra_Background *b;

   backgrounds = extra_backgrounds_list();

   EINA_LIST_FOREACH(backgrounds, n, b)
     {
        elm_gengrid_item_append(_selector, _item_class_basic, b, NULL, NULL);
     }
}

static Evas_Object*
_content_basic_get(void *data, Evas_Object *obj, const char *source)
{
   if (!strcmp(source, "elm.swallow.end"))
     return NULL;

   return extra_ui_small_preview_new(acc, obj, data);
}

static char*
_text_basic_get(void *data, Evas_Object *obj EINA_UNUSED, const char *source EINA_UNUSED)
{
   Extra_Background *t = data;

   return strdup(t->name);
}

static void
_item_selected(void *data EINA_UNUSED, Evas_Object *obj EINA_UNUSED, void *event_info)
{

   Elm_Widget_Item *it = event_info;
   _show_tooltip(elm_object_item_data_get(it));
}

static void
_selector_hide(void *data EINA_UNUSED, Evas *e EINA_UNUSED, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
   if (_ui.popup_toolbar)
     {
        evas_object_del(_ui.popup_toolbar);
        _ui.popup_toolbar = NULL;
     }
}

Evas_Object*
extra_background_selector_create(void)
{
   Evas_Object *grid;

   _item_class_basic = elm_gengrid_item_class_new();
   _item_class_basic->item_style = "thumb";
   _item_class_basic->func.content_get = _content_basic_get;
   _item_class_basic->func.text_get = _text_basic_get;

   _selector = grid = elm_gengrid_add(_ui.win);
   elm_gengrid_select_mode_set(grid, ELM_OBJECT_SELECT_MODE_ALWAYS);
   elm_gengrid_multi_select_set(grid, EINA_FALSE);
   evas_object_size_hint_weight_set(grid, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
   evas_object_size_hint_align_set(grid, EVAS_HINT_FILL, EVAS_HINT_FILL);
   elm_gengrid_item_size_set(grid, 300, 300);
   evas_object_smart_callback_add(grid, "selected", _item_selected, _ui.win);
   evas_object_show(grid);

   _fill_backgrounds();

   evas_object_event_callback_add(grid, EVAS_CALLBACK_HIDE, _selector_hide, NULL);

   return grid;
}