#ifndef EXTRA_PRIVATE_H_
# define EXTRA_PRIVATE_H_

#include "../lib/extra.h"

typedef struct {
   Evas_Object *win;
   Evas_Object *background_selector;
   Evas_Object *theme_selector;
   Evas_Object *popup_toolbar;
} Ui;

extern Ui _ui;

Evas_Object* extra_theme_selector_create(void);
Evas_Object* extra_background_selector_create(void);

void         extra_ui_theme_ask_for_default(Extra_Theme *theme);
Extra_Progress* extra_ui_progress_popup_show(const char *title, Extra_Done_Cb done, void *data);

typedef char *(Extra_ui_preview_get)(void *obj);
typedef Extra_Request *(Extra_ui_preview_download)(Extra_Progress *progress, void *obj);

typedef struct {
    Extra_ui_preview_get *preview_get;
    Extra_ui_preview_download *preview_download;
} Extra_Ui_Small_Preview_Accessor;

Evas_Object* extra_ui_small_preview_new(Extra_Ui_Small_Preview_Accessor acc, Evas_Object *par, void *data);
void extra_ui_fullscreen_preview(char *path);
void extra_ui_show_popup_toolbar(Evas_Object *content);

#endif
