/*
This file is part of FAgram Desktop,
the unofficial desktop client based on Telegram Desktop.

For license and copyright information please follow this link:
https://github.com/fajox1/fagramdesktop/blob/master/LEGAL
*/
#pragma once

#include "ui/rp_widget.h"
#include "ui/userpic_view.h"
#include "ui/effects/animations.h"

class PeerData;
class Image;

namespace Data {
class PhotoMedia;
} // namespace Data

namespace Calls {

class Userpic final {
public:
	Userpic(
		not_null<QWidget*> parent,
		not_null<PeerData*> peer,
		rpl::producer<bool> muted);
	~Userpic();

	void setVisible(bool visible);
	void setGeometry(int x, int y, int size);
	void setMuteLayout(QPoint position, int size, int stroke);

	[[nodiscard]] rpl::lifetime &lifetime() {
		return _content.lifetime();
	}

private:
	void setup(rpl::producer<bool> muted);

	void paint();
	void setMuted(bool muted);
	[[nodiscard]] int size() const;

	void processPhoto();
	void refreshPhoto();
	[[nodiscard]] bool isGoodPhoto(PhotoData *photo) const;
	void createCache(Image *image);

	Ui::RpWidget _content;

	not_null<PeerData*> _peer;
	Ui::PeerUserpicView _userpic;
	std::shared_ptr<Data::PhotoMedia> _photo;
	Ui::Animations::Simple _mutedAnimation;
	QPixmap _userPhoto;
	PhotoId _userPhotoId = 0;
	QPoint _mutePosition;
	int _muteSize = 0;
	int _muteStroke = 0;
	bool _userPhotoFull = false;
	bool _muted = false;

};

} // namespace Calls
