/*
This file is part of FAgram Desktop,
the unofficial desktop client based on Telegram Desktop.

For license and copyright information please follow this link:
https://github.com/fajox1/fagramdesktop/blob/master/LEGAL
*/
#include "data/data_peer_bot_commands.h"

namespace Data {

ChatBotCommands::Changed ChatBotCommands::update(
		const std::vector<BotCommands> &list) {
	auto changed = false;
	if (list.empty()) {
		changed = (list.empty() != empty());
		clear();
	} else {
		for (const auto &commands : list) {
			if (commands.commands.empty()) {
				changed |= remove(commands.userId);
			} else {
				auto &value = operator[](commands.userId);
				const auto isEqual = ranges::equal(value, commands.commands);
				changed |= !isEqual;
				if (!isEqual) {
					value = commands.commands;
				}
			}
		}
	}
	return changed;
}

BotCommands BotCommandsFromTL(const MTPBotInfo &result) {
	return result.match([](const MTPDbotInfo &data) {
		const auto userId = data.vuser_id()
			? UserId(*data.vuser_id())
			: UserId();
		if (!data.vcommands()) {
			return BotCommands{ .userId = userId };
		}
		auto commands = ranges::views::all(
			data.vcommands()->v
		) | ranges::views::transform(BotCommandFromTL) | ranges::to_vector;
		return BotCommands{
			.userId = userId,
			.commands = std::move(commands),
		};
	});
}

} // namespace Data
