/*
This file is part of FAgram Desktop,
the unofficial desktop client based on Telegram Desktop.

For license and copyright information please follow this link:
https://github.com/fajox1/fagramdesktop/blob/master/LEGAL
*/
#pragma once

#include "ui/chat/message_bar.h"

#include <tuple>

namespace Main {
class Session;
} // namespace Main

namespace Ui {
class IconButton;
class PlainShadow;
struct MessageBarContent;
} // namespace Ui

namespace HistoryView {

[[nodiscard]] rpl::producer<Ui::MessageBarContent> MessageBarContentByItemId(
	not_null<Main::Session*> session,
	FullMsgId id,
	Fn<void()> repaint);

enum class PinnedIdType;
struct PinnedId {
	FullMsgId message;
	int index = 0;
	int count = 1;

	bool operator<(const PinnedId &other) const {
		return std::tie(message, index, count)
			< std::tie(other.message, other.index, other.count);
	}
	bool operator==(const PinnedId &other) const {
		return std::tie(message, index, count)
			== std::tie(other.message, other.index, other.count);
	}
	bool operator!=(const PinnedId &other) const {
		return !(*this == other);
	}
};
[[nodiscard]] rpl::producer<Ui::MessageBarContent> PinnedBarContent(
	not_null<Main::Session*> session,
	rpl::producer<PinnedId> id,
	Fn<void()> repaint);

[[nodiscard]] rpl::producer<HistoryItem*> PinnedBarItemWithReplyMarkup(
	not_null<Main::Session*> session,
	rpl::producer<PinnedId> id);

} // namespace HistoryView
