/*
This file is part of FAgram Desktop,
the unofficial desktop client based on Telegram Desktop.

For license and copyright information please follow this link:
https://github.com/fajox1/fagramdesktop/blob/master/LEGAL
*/
#pragma once

#include "ui/rp_widget.h"
#include "ui/layers/box_content.h"
#include "history/admin_log/history_admin_log_item.h"
#include "history/view/history_view_element.h"
#include "history/history.h"

namespace Main {
class Session;
} // namespace Main

namespace Window {
class SessionController;
} // namespace Window

namespace Ui {
class ScrollArea;
class InputField;
class ChatStyle;
} // namespace Ui

namespace Support {

struct Contact {
	QString comment;
	QString phone;
	QString firstName;
	QString lastName;
};

class Autocomplete final : public Ui::RpWidget {
public:
	Autocomplete(QWidget *parent, not_null<Main::Session*> session);

	void activate(not_null<Ui::InputField*> field);
	void deactivate();
	void setBoundings(QRect rect);

	rpl::producer<QString> insertRequests() const;
	rpl::producer<Contact> shareContactRequests() const;

protected:
	void keyPressEvent(QKeyEvent *e) override;

private:
	void setupContent();
	void submitValue(const QString &value);

	not_null<Main::Session*> _session;
	Fn<void()> _activate;
	Fn<void()> _deactivate;
	Fn<void(int delta)> _moveSelection;

	rpl::event_stream<QString> _insertRequests;
	rpl::event_stream<Contact> _shareContactRequests;

};

class ConfirmContactBox
	: public Ui::BoxContent
	, public HistoryView::SimpleElementDelegate {
public:
	ConfirmContactBox(
		QWidget*,
		not_null<Window::SessionController*> controller,
		not_null<History*> history,
		const Contact &data,
		Fn<void(Qt::KeyboardModifiers)> submit);

	using Element = HistoryView::Element;
	HistoryView::Context elementContext() override;

protected:
	void prepare() override;
	void paintEvent(QPaintEvent *e) override;
	void keyPressEvent(QKeyEvent *e) override;

private:
	std::unique_ptr<Ui::ChatStyle> _chatStyle;
	AdminLog::OwnedItem _comment;
	AdminLog::OwnedItem _contact;
	Fn<void(Qt::KeyboardModifiers)> _submit;

};

} //namespace Support
