/*************************************************************************
*                                                                        *
*  Copyright (c) 2014 Torben Bruchhaus                                   *
*  http://ffqueue.bruchhaus.dk/                                          *
*  File: FFQLang.h                                                       *
*                                                                        *
*  This file is part of FFQueue.                                         *
*                                                                        *
*  FFQueue is free software: you can redistribute it and/or modify       *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation, either version 3 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
*  FFQueue is distributed in the hope that it will be useful,            *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*  GNU General Public License for more details.                          *
*                                                                        *
*  You should have received a copy of the GNU General Public License     *
*  along with FFQueue.  If not, see <http://www.gnu.org/licenses/>.      *
*                                                                        *
*************************************************************************/

#ifndef FFQLANG_H
#define FFQLANG_H

//#include "wx_pch.h"

#include <vector>
#include <wx/string.h>
#include <wx/vector.h>
#include <wx/datetime.h>
#include <wx/window.h>
#include "FFQConst.h"

//Type used for string id's
typedef uint16_t FFQ_SID;

//String constants

//Basic messages & formatting
const FFQ_SID SID_BASIC_BASE                        = 0;
const FFQ_SID SID_ERROR                             = SID_BASIC_BASE + 0;
const FFQ_SID SID_WARNING                           = SID_BASIC_BASE + 1;
const FFQ_SID SID_INFORMATION                       = SID_BASIC_BASE + 2;
const FFQ_SID SID_CONFIRM                           = SID_BASIC_BASE + 3;
const FFQ_SID SID_BAD_STRING_ID                     = SID_BASIC_BASE + 4;
const FFQ_SID SID_DATE_TIME_FORMAT                  = SID_BASIC_BASE + 5;
const FFQ_SID SID_FFPROBE_BAD_OUTPUT                = SID_BASIC_BASE + 6;
const FFQ_SID SID_FFMPEG_INACTIVE                   = SID_BASIC_BASE + 7;
const FFQ_SID SID_UNKNOWN_TIME_REMAINS              = SID_BASIC_BASE + 8;
const FFQ_SID SID_TIME_REMAINS                      = SID_BASIC_BASE + 9;
const FFQ_SID SID_TIME_ELAPSED_TOTAL                = SID_BASIC_BASE + 10;
const FFQ_SID SID_STATUS_MESSAGE                    = SID_BASIC_BASE + 11;
const FFQ_SID SID_COMMAND                           = SID_BASIC_BASE + 12;
const FFQ_SID SID_PRESET                            = SID_BASIC_BASE + 13;
const FFQ_SID SID_INVALID_PRESET                    = SID_BASIC_BASE + 14;
const FFQ_SID SID_SAVE_JOBS_ERROR                   = SID_BASIC_BASE + 15;
const FFQ_SID SID_JOBS_REMOVED                      = SID_BASIC_BASE + 16;
const FFQ_SID SID_OVERWRITE_OUTPUT_FILE             = SID_BASIC_BASE + 17;
const FFQ_SID SID_OVERWRITE_OUTPUT_FILES            = SID_BASIC_BASE + 18;
const FFQ_SID SID_DELETE_SELECTED                   = SID_BASIC_BASE + 19;
const FFQ_SID SID_JOB_HAS_NO_PRESET                 = SID_BASIC_BASE + 20;
const FFQ_SID SID_TASK_ABORTED                      = SID_BASIC_BASE + 21;
const FFQ_SID SID_COMMAND_COMPLETED                 = SID_BASIC_BASE + 22;
const FFQ_SID SID_QUEUE_COMPLETED                   = SID_BASIC_BASE + 23;
const FFQ_SID SID_PLEASE_STOP_TASK                  = SID_BASIC_BASE + 24;
const FFQ_SID SID_NO_FILES_OR_NO_PRESET             = SID_BASIC_BASE + 25;
const FFQ_SID SID_NO_CONTENT_SELECTED               = SID_BASIC_BASE + 26;
const FFQ_SID SID_OUTPUT_FORMAT_REQUIRED            = SID_BASIC_BASE + 27;
const FFQ_SID SID_OUTPUT_PATH_EXIST_OR_EMPTY        = SID_BASIC_BASE + 28;
const FFQ_SID SID_START_POSITION                    = SID_BASIC_BASE + 29;
const FFQ_SID SID_LIMIT_LENGTH                      = SID_BASIC_BASE + 30;
const FFQ_SID SID_THE_BEGINNING                     = SID_BASIC_BASE + 31;
const FFQ_SID SID_NO_LIMIT                          = SID_BASIC_BASE + 32;
const FFQ_SID SID_INPUT_FILE_MUST_EXIST             = SID_BASIC_BASE + 33;
const FFQ_SID SID_INPUT_FILE_NOT_FOUND              = SID_BASIC_BASE + 34;
const FFQ_SID SID_SELECT_AT_LEAST_ONE_STREAM        = SID_BASIC_BASE + 35;
const FFQ_SID SID_OUTPUT_FILE_REQUIRED              = SID_BASIC_BASE + 36;
const FFQ_SID SID_OUTPUT_FILE_NOT_EQUAL_INPUT       = SID_BASIC_BASE + 37;
const FFQ_SID SID_COMMAND_LINE_INVALID              = SID_BASIC_BASE + 38;
const FFQ_SID SID_JOB_FOR_FILE_ALREADY_QUEUED       = SID_BASIC_BASE + 39;
const FFQ_SID SID_STREAM_INFORMATION                = SID_BASIC_BASE + 40;
const FFQ_SID SID_FFPROBE_FAILED_ON_FILES           = SID_BASIC_BASE + 41;
const FFQ_SID SID_PRESET_REQUIRED                   = SID_BASIC_BASE + 42;
const FFQ_SID SID_COPY_VIDEO_NOT_ALLOWED            = SID_BASIC_BASE + 43;
const FFQ_SID SID_TWO_PASS_NOT_ALLOWED              = SID_BASIC_BASE + 44;
const FFQ_SID SID_FF_BINARIES_NOT_FOUND             = SID_BASIC_BASE + 45;
const FFQ_SID SID_CUSTOM_TEMP_PATH_NOT_FOUND        = SID_BASIC_BASE + 46;
const FFQ_SID SID_OPEN_CLIPBOARD_ERROR              = SID_BASIC_BASE + 47;
const FFQ_SID SID_COPY_PRESET_SUCCESS               = SID_BASIC_BASE + 48;
const FFQ_SID SID_COPY_PRESET_ERROR                 = SID_BASIC_BASE + 49;
const FFQ_SID SID_PASTE_PRESET_SUCCESS              = SID_BASIC_BASE + 50;
const FFQ_SID SID_PASTE_PRESET_NONE                 = SID_BASIC_BASE + 51;
const FFQ_SID SID_CONFIRM_DELETE_PRESETS            = SID_BASIC_BASE + 52;
const FFQ_SID SID_THUMBS_OR_MOSAICS_REQUIRED        = SID_BASIC_BASE + 53;
const FFQ_SID SID_IMAGE_FORMAT_REQUIRED             = SID_BASIC_BASE + 54;
const FFQ_SID SID_MUST_BE_A_POSITIVE_NUMBER         = SID_BASIC_BASE + 55;
const FFQ_SID SID_THUMB_WIDTH                       = SID_BASIC_BASE + 56;
const FFQ_SID SID_THUMB_INTERVAL                    = SID_BASIC_BASE + 57;
const FFQ_SID SID_ROW_AND_COLUMN_TOO_SMALL          = SID_BASIC_BASE + 58;
const FFQ_SID SID_CREATE_FIRST_THUMB_FROM           = SID_BASIC_BASE + 59;
const FFQ_SID SID_TIME_VALUE_NAMES                  = SID_BASIC_BASE + 60;
const FFQ_SID SID_AND                               = SID_BASIC_BASE + 61;
const FFQ_SID SID_INVALID_STREAM_MAP_ENDODING       = SID_BASIC_BASE + 62;
const FFQ_SID SID_STREAM_INDEX_OUT_OF_BOUNDS        = SID_BASIC_BASE + 63;
const FFQ_SID SID_PROBE_INFO_IS_INVALID             = SID_BASIC_BASE + 64;
const FFQ_SID SID_KILL_FFMPEG_FAILED                = SID_BASIC_BASE + 65;
const FFQ_SID SID_ACTIVE_CANNOT_SET_COMMAND         = SID_BASIC_BASE + 66;
const FFQ_SID SID_PROCESS_ALREADY_RUNNING           = SID_BASIC_BASE + 67;
const FFQ_SID SID_EXECUTE_COMMAND_ERROR             = SID_BASIC_BASE + 68;
const FFQ_SID SID_FONT_CONF_NOT_FOUND               = SID_BASIC_BASE + 69;
const FFQ_SID SID_CREATE_WRITE_FILE_ERROR           = SID_BASIC_BASE + 70;
const FFQ_SID SID_FONT_CONF_CREATE_SUCCESS          = SID_BASIC_BASE + 71;
const FFQ_SID SID_FFPLAY_NOT_FOUND                  = SID_BASIC_BASE + 72;
const FFQ_SID SID_PRESET_MGR_NOT_INITIALIZED        = SID_BASIC_BASE + 73;
const FFQ_SID SID_LOAD_CONFIG_ERROR                 = SID_BASIC_BASE + 74;
const FFQ_SID SID_SAVE_CONFIG_ERROR                 = SID_BASIC_BASE + 75;
const FFQ_SID SID_INVALID_CONFIG_HEADER             = SID_BASIC_BASE + 76;
const FFQ_SID SID_INVALID_PRESET_IN_CONFIG          = SID_BASIC_BASE + 77;
const FFQ_SID SID_OPEN_FILE_ERROR                   = SID_BASIC_BASE + 78;
const FFQ_SID SID_CREATE_DIRECTORY_ERROR            = SID_BASIC_BASE + 79;
const FFQ_SID SID_INVALID_STRING_ARRAY_SIZE         = SID_BASIC_BASE + 80;
const FFQ_SID SID_LANGUAGE_OUTDATED                 = SID_BASIC_BASE + 81;
const FFQ_SID SID_DISABLED                          = SID_BASIC_BASE + 82;
const FFQ_SID SID_ITEM_CANNOT_BE_EDITED             = SID_BASIC_BASE + 83;
const FFQ_SID SID_ITEM_CANNOT_BE_CLONED             = SID_BASIC_BASE + 84;
const FFQ_SID SID_TOOL_JOB                          = SID_BASIC_BASE + 85;
const FFQ_SID SID_DUPLICATE_JOB_FOR_OUTPUT          = SID_BASIC_BASE + 86;
const FFQ_SID SID_SOURCE_EQUALS_OUTPUT              = SID_BASIC_BASE + 87;
const FFQ_SID SID_PATH_NOT_FOUND                    = SID_BASIC_BASE + 88;
const FFQ_SID SID_SAVE_JOBS_SUCCESS                 = SID_BASIC_BASE + 89;
const FFQ_SID SID_INVALID_INPUT_NOT_ALLOWED         = SID_BASIC_BASE + 90;
const FFQ_SID SID_NOTHING_QUEUED                    = SID_BASIC_BASE + 91;
const FFQ_SID SID_INVALID_CONSOLE_COMMAND           = SID_BASIC_BASE + 92;
const FFQ_SID SID_CANNOT_SAVE_ACTIVE_QUEUE_ITEM     = SID_BASIC_BASE + 93;
const FFQ_SID SID_INLINE_SHELL_CODE_WARNING         = SID_BASIC_BASE + 94;
const FFQ_SID SID_ADVANCED_CUTS_WARNING             = SID_BASIC_BASE + 95;
const FFQ_SID SID_CONFIRM_SORT_PRESETS              = SID_BASIC_BASE + 96;
const FFQ_SID SID_BAD_COMMAND_LINE_ARG              = SID_BASIC_BASE + 97;



//Log messages
const FFQ_SID SID_LOG_BASE                          = 800;
const FFQ_SID SID_LOG_FILE_ERROR                    = SID_LOG_BASE + 0;
const FFQ_SID SID_LOG_CLIPPING_WARNING              = SID_LOG_BASE + 1;
const FFQ_SID SID_LOG_FFMPEG_RUNTIME                = SID_LOG_BASE + 2;
const FFQ_SID SID_LOG_JOB_ABORTED                   = SID_LOG_BASE + 3;
const FFQ_SID SID_LOG_COMMAND_ABORTED               = SID_LOG_BASE + 4;
const FFQ_SID SID_LOG_FFPROBE_ERROR                 = SID_LOG_BASE + 5;
const FFQ_SID SID_LOG_EXEC_COMMAND                  = SID_LOG_BASE + 6;
const FFQ_SID SID_LOG_JOB_REMOVED                   = SID_LOG_BASE + 7;
const FFQ_SID SID_LOG_STARTING_FFMPEG               = SID_LOG_BASE + 8;
const FFQ_SID SID_LOG_FOR_FIRST_PASS                = SID_LOG_BASE + 9;
const FFQ_SID SID_LOG_FOR_SECOND_PASS               = SID_LOG_BASE + 10;
const FFQ_SID SID_LOG_WRITE_DEST_ERROR              = SID_LOG_BASE + 11;
const FFQ_SID SID_LOG_EXECUTE_ERROR                 = SID_LOG_BASE + 12;
const FFQ_SID SID_LOG_SECOND_PASS_FAIL              = SID_LOG_BASE + 13;
const FFQ_SID SID_LOG_COMPLETED_OK                  = SID_LOG_BASE + 14;
const FFQ_SID SID_LOG_COMPLETED_IRREG               = SID_LOG_BASE + 15;
const FFQ_SID SID_LOG_FFMPEG_FOUND                  = SID_LOG_BASE + 16;
const FFQ_SID SID_LOG_FFMPEG_NOT_FOUND              = SID_LOG_BASE + 17;
const FFQ_SID SID_LOG_FFPROBE_INFO_FOR              = SID_LOG_BASE + 18;
const FFQ_SID SID_LOG_EXEC_PREVIEW_CMD              = SID_LOG_BASE + 19;
const FFQ_SID SID_LOG_PREVIEW_CMD_FAIL              = SID_LOG_BASE + 20;
const FFQ_SID SID_LOG_ALREADY_QUEUED                = SID_LOG_BASE + 21;
const FFQ_SID SID_LOG_MAKE_JOB_FOR                  = SID_LOG_BASE + 22;
const FFQ_SID SID_LOG_CONTENT_NOT_FOUND             = SID_LOG_BASE + 23;
const FFQ_SID SID_LOG_LOW_CONTRAST_WARNING          = SID_LOG_BASE + 24;
const FFQ_SID SID_LOG_TOTAL_JOB_TIME                = SID_LOG_BASE + 25;
const FFQ_SID SID_LOG_PRESET_WAS_CHANGED            = SID_LOG_BASE + 26;

const FFQ_SID SID_LOG_QUEUE_STARTED                 = SID_LOG_BASE + 27;
const FFQ_SID SID_LOG_QUEUE_ENDED                   = SID_LOG_BASE + 28;
const FFQ_SID SID_LOG_JOB_TAB_STARTED               = SID_LOG_BASE + 29;
const FFQ_SID SID_LOG_JOB_TAB_ENDED                 = SID_LOG_BASE + 30;
const FFQ_SID SID_LOG_JOB_TAB_FAILED                = SID_LOG_BASE + 31;
const FFQ_SID SID_LOG_JOB_TAB_ABORTED               = SID_LOG_BASE + 32;


//Common UI strings
const FFQ_SID SID_COMMON_BASE                       = 1500;
const FFQ_SID SID_COMMON_MOVE_UP                    = SID_COMMON_BASE + 0;
const FFQ_SID SID_COMMON_MOVE_DOWN                  = SID_COMMON_BASE + 1;
const FFQ_SID SID_COMMON_SELECT_INPUT_FILE          = SID_COMMON_BASE + 2;
const FFQ_SID SID_COMMON_SELECT_OUTPUT_FILE         = SID_COMMON_BASE + 3;
const FFQ_SID SID_COMMON_SELECT_FILE                = SID_COMMON_BASE + 4;
const FFQ_SID SID_COMMON_SELECT_FILES               = SID_COMMON_BASE + 5;
const FFQ_SID SID_COMMON_VIDEO                      = SID_COMMON_BASE + 6;
const FFQ_SID SID_COMMON_AUDIO                      = SID_COMMON_BASE + 7;
const FFQ_SID SID_COMMON_SUBTITLES                  = SID_COMMON_BASE + 8;
const FFQ_SID SID_COMMON_CANCEL                     = SID_COMMON_BASE + 9;
const FFQ_SID SID_COMMON_CLOSE                      = SID_COMMON_BASE + 10;
const FFQ_SID SID_COMMON_OK                         = SID_COMMON_BASE + 11;
const FFQ_SID SID_COMMON_REFRESH                    = SID_COMMON_BASE + 12;
const FFQ_SID SID_COMMON_SAVE_LOG                   = SID_COMMON_BASE + 13;
const FFQ_SID SID_COMMON_SAVE_JOB                   = SID_COMMON_BASE + 14;
const FFQ_SID SID_COMMON_ADD                        = SID_COMMON_BASE + 15;
const FFQ_SID SID_COMMON_NEW                        = SID_COMMON_BASE + 16;
const FFQ_SID SID_COMMON_REMOVE                     = SID_COMMON_BASE + 17;
const FFQ_SID SID_COMMON_DELETE                     = SID_COMMON_BASE + 18;
const FFQ_SID SID_COMMON_EDIT                       = SID_COMMON_BASE + 19;
const FFQ_SID SID_COMMON_PREVIEW                    = SID_COMMON_BASE + 20;
const FFQ_SID SID_COMMON_SORT                       = SID_COMMON_BASE + 21;
const FFQ_SID SID_COMMON_COPY                       = SID_COMMON_BASE + 22;
const FFQ_SID SID_COMMON_PASTE                      = SID_COMMON_BASE + 23;
const FFQ_SID SID_COMMON_DEST_FOLDER                = SID_COMMON_BASE + 24;
const FFQ_SID SID_COMMON_CLEAR                      = SID_COMMON_BASE + 25;
const FFQ_SID SID_COMMON_UNDEFINED                  = SID_COMMON_BASE + 26;
const FFQ_SID SID_COMMON_INPUT                      = SID_COMMON_BASE + 27;
const FFQ_SID SID_COMMON_OUTPUT                     = SID_COMMON_BASE + 28;
const FFQ_SID SID_COMMON_DEFAULTS                   = SID_COMMON_BASE + 29;
const FFQ_SID SID_COMMON_UPDATE                     = SID_COMMON_BASE + 30;
const FFQ_SID SID_COMMON_DRY_RUN                    = SID_COMMON_BASE + 31;
const FFQ_SID SID_COMMON_ATTACHMENT                 = SID_COMMON_BASE + 32;
const FFQ_SID SID_COMMON_DATA                       = SID_COMMON_BASE + 33;
const FFQ_SID SID_COMMON_HELP                       = SID_COMMON_BASE + 34;


//Main frame UI
const FFQ_SID SID_MAINFRAME_BASE                    = 2500;

//Status names
const FFQ_SID SID_MAINFRAME_QUEUE_STATUS_NAMES      = SID_MAINFRAME_BASE + 0;

//Toolbar
const FFQ_SID SID_MAINFRAME_TB_BATCH                = SID_MAINFRAME_BASE + 10;
const FFQ_SID SID_MAINFRAME_TB_START                = SID_MAINFRAME_BASE + 11;
const FFQ_SID SID_MAINFRAME_TB_STOP                 = SID_MAINFRAME_BASE + 12;
const FFQ_SID SID_MAINFRAME_TB_TOOLS                = SID_MAINFRAME_BASE + 13;
const FFQ_SID SID_MAINFRAME_TB_OPTIONS              = SID_MAINFRAME_BASE + 14;
const FFQ_SID SID_MAINFRAME_TB_ABOUT                = SID_MAINFRAME_BASE + 15;
const FFQ_SID SID_MAINFRAME_TB_PRESETS              = SID_MAINFRAME_BASE + 16;

//ListView menu
const FFQ_SID SID_MAINFRAME_LVM_EDIT_JOB            = SID_MAINFRAME_BASE + 50;
const FFQ_SID SID_MAINFRAME_LVM_EDIT_PRESET         = SID_MAINFRAME_BASE + 51;
const FFQ_SID SID_MAINFRAME_LVM_REMOVE_JOB          = SID_MAINFRAME_BASE + 52;
const FFQ_SID SID_MAINFRAME_LVM_RUN_FFPROBE         = SID_MAINFRAME_BASE + 53;
const FFQ_SID SID_MAINFRAME_LVM_START_ALL           = SID_MAINFRAME_BASE + 54;
const FFQ_SID SID_MAINFRAME_LVM_START_SEL           = SID_MAINFRAME_BASE + 55;
const FFQ_SID SID_MAINFRAME_LVM_CLONE_JOB           = SID_MAINFRAME_BASE + 56;
const FFQ_SID SID_MAINFRAME_LVM_STOP_ALL            = SID_MAINFRAME_BASE + 57;
const FFQ_SID SID_MAINFRAME_LVM_STOP_SEL            = SID_MAINFRAME_BASE + 58;
const FFQ_SID SID_MAINFRAME_LVM_SHOW_COMMAND        = SID_MAINFRAME_BASE + 59;

//ListView columns
const FFQ_SID SID_MAINFRAME_LVC_FILE                = SID_MAINFRAME_BASE + 100;
const FFQ_SID SID_MAINFRAME_LVC_COMMAND             = SID_MAINFRAME_BASE + 101;
const FFQ_SID SID_MAINFRAME_LVC_STATUS              = SID_MAINFRAME_BASE + 102;

//Tools menu
const FFQ_SID SID_MAINFRAME_TM_THUMBTOOL            = SID_MAINFRAME_BASE + 120;
const FFQ_SID SID_MAINFRAME_TM_SLIDESHOWTOOL        = SID_MAINFRAME_BASE + 121;
const FFQ_SID SID_MAINFRAME_TM_CONCATTOOL           = SID_MAINFRAME_BASE + 122;

//Notebook / text consoles
const FFQ_SID SID_MAINFRAME_NB_DEFAULT              = SID_MAINFRAME_BASE + 200;
const FFQ_SID SID_MAINFRAME_NB_FOR_JOB              = SID_MAINFRAME_BASE + 201;


//Batch maker UI
const FFQ_SID SID_BATCHMAKE_BASE                    = 3500;
const FFQ_SID SID_BATCHMAKE_TITLE                   = SID_BATCHMAKE_BASE + 0;
const FFQ_SID SID_BATCHMAKE_DEFINE_PROPERTIES       = SID_BATCHMAKE_BASE + 1;
const FFQ_SID SID_BATCHMAKE_SEL_CONTENT             = SID_BATCHMAKE_BASE + 2;
const FFQ_SID SID_BATCHMAKE_PREF_AUDIO_CODEC        = SID_BATCHMAKE_BASE + 3;
const FFQ_SID SID_BATCHMAKE_DEST_FORMAT             = SID_BATCHMAKE_BASE + 4;
const FFQ_SID SID_BATCHMAKE_SELECT_PRESET           = SID_BATCHMAKE_BASE + 5;
const FFQ_SID SID_BATCHMAKE_MAKE_JOBS               = SID_BATCHMAKE_BASE + 6;
const FFQ_SID SID_BATCHMAKE_MAKE_JOBS_FOR           = SID_BATCHMAKE_BASE + 7;
const FFQ_SID SID_BATCHMAKE_MATCH_INVERSE           = SID_BATCHMAKE_BASE + 8;
const FFQ_SID SID_BATCHMAKE_PREF_SUBS_CODEC         = SID_BATCHMAKE_BASE + 9;
const FFQ_SID SID_BATCHMAKE_NOFAIL_CONTENT          = SID_BATCHMAKE_BASE + 10;
const FFQ_SID SID_BATCHMAKE_ALSO_INCLUDE            = SID_BATCHMAKE_BASE + 11;



//Job editor UI
const FFQ_SID SID_JOBEDIT_BASE                      = 4000;
const FFQ_SID SID_JOBEDIT_TITLE                     = SID_JOBEDIT_BASE + 0;
const FFQ_SID SID_JOBEDIT_INPUT_FILES               = SID_JOBEDIT_BASE + 1;
const FFQ_SID SID_JOBEDIT_INPUT_NO_1                = SID_JOBEDIT_BASE + 2;
const FFQ_SID SID_JOBEDIT_INPUT_NO_2                = SID_JOBEDIT_BASE + 3;
const FFQ_SID SID_JOBEDIT_SELECT_STREAMS            = SID_JOBEDIT_BASE + 4;
const FFQ_SID SID_JOBEDIT_DBLCLK_FOR_INFO           = SID_JOBEDIT_BASE + 5;
const FFQ_SID SID_JOBEDIT_OUTPUT_FILE               = SID_JOBEDIT_BASE + 6;
const FFQ_SID SID_JOBEDIT_OUTPUT_ENCODING           = SID_JOBEDIT_BASE + 7;
const FFQ_SID SID_JOBEDIT_COMMAND_LINE              = SID_JOBEDIT_BASE + 8;
const FFQ_SID SID_JOBEDIT_PRESET                    = SID_JOBEDIT_BASE + 9;
const FFQ_SID SID_JOBEDIT_NO_PRESET                 = SID_JOBEDIT_BASE + 10;

//Job editor advanced UI (used in combination with items above)
const FFQ_SID SID_JOBEDIT_ADV_BASE                  = 4300;
const FFQ_SID SID_JOBEDIT_ADV_ITSOFFSET             = SID_JOBEDIT_ADV_BASE + 0;
const FFQ_SID SID_JOBEDIT_ADV_MILLISECONDS          = SID_JOBEDIT_ADV_BASE + 1;
const FFQ_SID SID_JOBEDIT_ADV_FRAMERATE             = SID_JOBEDIT_ADV_BASE + 2;
const FFQ_SID SID_JOBEDIT_ADV_FPS                   = SID_JOBEDIT_ADV_BASE + 3;
const FFQ_SID SID_JOBEDIT_ADV_DISCARDCORRUPT        = SID_JOBEDIT_ADV_BASE + 4;
const FFQ_SID SID_JOBEDIT_ADV_GENPTS                = SID_JOBEDIT_ADV_BASE + 5;
const FFQ_SID SID_JOBEDIT_ADV_IGNOREDTS             = SID_JOBEDIT_ADV_BASE + 6;
const FFQ_SID SID_JOBEDIT_ADV_IGNOREIDX             = SID_JOBEDIT_ADV_BASE + 7;
const FFQ_SID SID_JOBEDIT_ADV_ADD_INPUT             = SID_JOBEDIT_ADV_BASE + 8;
const FFQ_SID SID_JOBEDIT_ADV_DEL_INPUT             = SID_JOBEDIT_ADV_BASE + 9;
const FFQ_SID SID_JOBEDIT_ADV_ADD_SECONDARY         = SID_JOBEDIT_ADV_BASE + 10;
const FFQ_SID SID_JOBEDIT_ADV_MORE                  = SID_JOBEDIT_ADV_BASE + 11;
const FFQ_SID SID_JOBEDIT_ADV_INPUT_SETTINGS        = SID_JOBEDIT_ADV_BASE + 12;
const FFQ_SID SID_JOBEDIT_ADV_MORE_TOOLTIP          = SID_JOBEDIT_ADV_BASE + 13;
const FFQ_SID SID_JOBEDIT_ADV_FRAMERATE_SWITCH      = SID_JOBEDIT_ADV_BASE + 14;

const FFQ_SID SID_JOBEDIT_ADV_CUTS                  = SID_JOBEDIT_ADV_BASE + 15;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_TITLE            = SID_JOBEDIT_ADV_BASE + 16;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_LIST_TITLE       = SID_JOBEDIT_ADV_BASE + 17;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_TOOLS_TITLE      = SID_JOBEDIT_ADV_BASE + 18;

const FFQ_SID SID_JOBEDIT_ADV_CUTS_FROM             = SID_JOBEDIT_ADV_BASE + 19;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_TO               = SID_JOBEDIT_ADV_BASE + 20;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_BAD_TIME         = SID_JOBEDIT_ADV_BASE + 21;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_OVERLAP_TIME     = SID_JOBEDIT_ADV_BASE + 22;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_DURATION         = SID_JOBEDIT_ADV_BASE + 23;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_FRAME_CONV       = SID_JOBEDIT_ADV_BASE + 24;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_BAD_FRAME        = SID_JOBEDIT_ADV_BASE + 25;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_TIME_DETAILS     = SID_JOBEDIT_ADV_BASE + 26;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_BAD_TIME_2       = SID_JOBEDIT_ADV_BASE + 27;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_TRIM_MODE        = SID_JOBEDIT_ADV_BASE + 28;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_SET_FROM         = SID_JOBEDIT_ADV_BASE + 29;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_SET_TO           = SID_JOBEDIT_ADV_BASE + 30;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_INPUT_INFO       = SID_JOBEDIT_ADV_BASE + 31;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_PREVIEW          = SID_JOBEDIT_ADV_BASE + 32;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_PREVIEW_CFG      = SID_JOBEDIT_ADV_BASE + 33;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_CFG_ACCURACY     = SID_JOBEDIT_ADV_BASE + 34;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_CFG_DELAY        = SID_JOBEDIT_ADV_BASE + 35;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_CFG_PLACEMENT    = SID_JOBEDIT_ADV_BASE + 36;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_QUICK_CUT        = SID_JOBEDIT_ADV_BASE + 37;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_OVERLAP_REMOVE   = SID_JOBEDIT_ADV_BASE + 38;
const FFQ_SID SID_JOBEDIT_ADV_CUTS_MENU_ITEMS       = SID_JOBEDIT_ADV_BASE + 39;

const FFQ_SID SID_JOBEDIT_ADV_LOOP_STREAMS          = SID_JOBEDIT_ADV_BASE + 40;
const FFQ_SID SID_JOBEDIT_ADV_LOOP_STREAMS_INFO     = SID_JOBEDIT_ADV_BASE + 41;

//Concat tool UI
const FFQ_SID SID_CONCAT_BASE                       = 4500;
const FFQ_SID SID_CONCAT_TITLE                      = SID_CONCAT_BASE + 0;
const FFQ_SID SID_CONCAT_VIDEO_FROM_IMAGES          = SID_CONCAT_BASE + 1;
const FFQ_SID SID_CONCAT_MERGE_FILES                = SID_CONCAT_BASE + 2;
const FFQ_SID SID_CONCAT_SOURCE_FRAMES              = SID_CONCAT_BASE + 3;
const FFQ_SID SID_CONCAT_FIRST_IMAGE                = SID_CONCAT_BASE + 4;
const FFQ_SID SID_CONCAT_SCALE_AND_PAD              = SID_CONCAT_BASE + 5;
const FFQ_SID SID_CONCAT_SIZE                       = SID_CONCAT_BASE + 6;
const FFQ_SID SID_CONCAT_FILL_COLOR                 = SID_CONCAT_BASE + 7;
const FFQ_SID SID_CONCAT_SCALE_INFORMATION          = SID_CONCAT_BASE + 8;
const FFQ_SID SID_CONCAT_FRAME_TIME                 = SID_CONCAT_BASE + 9;
const FFQ_SID SID_CONCAT_SECONDS                    = SID_CONCAT_BASE + 10;
const FFQ_SID SID_CONCAT_FORCE_PTS                  = SID_CONCAT_BASE + 11;
const FFQ_SID SID_CONCAT_AUDIO_TRACK                = SID_CONCAT_BASE + 12;
const FFQ_SID SID_CONCAT_LOOP_FRAMES                = SID_CONCAT_BASE + 13;
const FFQ_SID SID_CONCAT_DESTINATION                = SID_CONCAT_BASE + 14;
const FFQ_SID SID_CONCAT_FILE_NAME                  = SID_CONCAT_BASE + 15;
const FFQ_SID SID_CONCAT_PRESET                     = SID_CONCAT_BASE + 16;
const FFQ_SID SID_CONCAT_SOURCE_FILES               = SID_CONCAT_BASE + 17;
const FFQ_SID SID_CONCAT_CONTENT_TYPES              = SID_CONCAT_BASE + 18;
const FFQ_SID SID_CONCAT_FORCE_ASPECT               = SID_CONCAT_BASE + 19;
const FFQ_SID SID_CONCAT_IMAGES_FOUND               = SID_CONCAT_BASE + 20;
const FFQ_SID SID_CONCAT_VIDEO_ITEM                 = SID_CONCAT_BASE + 21;
const FFQ_SID SID_CONCAT_AUDIO_ITEM                 = SID_CONCAT_BASE + 22;
const FFQ_SID SID_CONCAT_TWO_FILES_MINIMUM          = SID_CONCAT_BASE + 23;
const FFQ_SID SID_CONCAT_CONTENT_MISSING            = SID_CONCAT_BASE + 24;
const FFQ_SID SID_CONCAT_NO_IMAGES_FOUND            = SID_CONCAT_BASE + 25;
const FFQ_SID SID_CONCAT_MIN_WIDTH_AND_EVEN         = SID_CONCAT_BASE + 26;
const FFQ_SID SID_CONCAT_MIN_HEIGHT_AND_EVEN        = SID_CONCAT_BASE + 27;
const FFQ_SID SID_CONCAT_TEMP_FOLDER_ERROR          = SID_CONCAT_BASE + 28;
const FFQ_SID SID_CONCAT_FRAME_TIME_POSITIVE        = SID_CONCAT_BASE + 29;
const FFQ_SID SID_CONCAT_AUDIO_TRACK_ERROR          = SID_CONCAT_BASE + 30;
const FFQ_SID SID_CONCAT_SIMPLE                     = SID_CONCAT_BASE + 31;
const FFQ_SID SID_CONCAT_UNEQUAL_FILES              = SID_CONCAT_BASE + 32;
const FFQ_SID SID_CONCAT_PADDING                    = SID_CONCAT_BASE + 33;
const FFQ_SID SID_CONCAT_LOOP_ERROR                 = SID_CONCAT_BASE + 34;
const FFQ_SID SID_CONCAT_EXPLICIT_MAP               = SID_CONCAT_BASE + 35;
const FFQ_SID SID_CONCAT_IMAGE_LIST_FOUND           = SID_CONCAT_BASE + 36;


//Preset editor UI
const FFQ_SID SID_PRESET_BASE                       = 5000;
const FFQ_SID SID_PRESET_TITLE                      = SID_PRESET_BASE + 0;
const FFQ_SID SID_PRESET_SELECT_PREVIEW_FILE        = SID_PRESET_BASE + 1;
const FFQ_SID SID_PRESET_PRESET_NAME                = SID_PRESET_BASE + 2;
const FFQ_SID SID_PRESET_TEMPORARY_PRESET           = SID_PRESET_BASE + 3;
//const FFQ_SID SID_PRESET_ENCODING                   = SID_PRESET_BASE + 4;
const FFQ_SID SID_PRESET_FILTERS                    = SID_PRESET_BASE + 5;
const FFQ_SID SID_PRESET_METADATA                   = SID_PRESET_BASE + 6;
const FFQ_SID SID_PRESET_THUMBS                     = SID_PRESET_BASE + 7;
const FFQ_SID SID_PRESET_MISCELLANEOUS              = SID_PRESET_BASE + 8;
//const FFQ_SID SID_PRESET_VIDEO_ENCODING             = SID_PRESET_BASE + 9;
const FFQ_SID SID_PRESET_CODEC                      = SID_PRESET_BASE + 10;
const FFQ_SID SID_PRESET_BITRATE                    = SID_PRESET_BASE + 11;
const FFQ_SID SID_PRESET_FRAMERATE                  = SID_PRESET_BASE + 12;
const FFQ_SID SID_PRESET_FPS                        = SID_PRESET_BASE + 13;
const FFQ_SID SID_PRESET_TWO_PASS_ENCODING          = SID_PRESET_BASE + 14;
const FFQ_SID SID_PRESET_FIRST_PASS_NULL_TARGET     = SID_PRESET_BASE + 15;
const FFQ_SID SID_PRESET_VIDEO_SYNC                 = SID_PRESET_BASE + 16;
//const FFQ_SID SID_PRESET_AUDIO_ENCODING             = SID_PRESET_BASE + 17;
const FFQ_SID SID_PRESET_NUM_AUDIO_CHANNELS         = SID_PRESET_BASE + 18;
//const FFQ_SID SID_PRESET_SUBTITLE_ENCODING          = SID_PRESET_BASE + 19;
const FFQ_SID SID_PRESET_FILTER_INFO                = SID_PRESET_BASE + 20;
const FFQ_SID SID_PRESET_METADATA_DEFINE            = SID_PRESET_BASE + 21;
const FFQ_SID SID_PRESET_METADATA_KEY               = SID_PRESET_BASE + 22;
const FFQ_SID SID_PRESET_METADATA_VALUE             = SID_PRESET_BASE + 23;
const FFQ_SID SID_PRESET_DEFINE_FOURCC              = SID_PRESET_BASE + 24;
const FFQ_SID SID_PRESET_FOURCC_VIDS                = SID_PRESET_BASE + 25;
const FFQ_SID SID_PRESET_FOURCC_AUDS                = SID_PRESET_BASE + 26;
const FFQ_SID SID_PRESET_BURN_IN_SUBTITLES          = SID_PRESET_BASE + 27;
const FFQ_SID SID_PRESET_SUBTITLE_TYPE              = SID_PRESET_BASE + 28;
const FFQ_SID SID_PRESET_SUBTITLE_TYPE_TEXT         = SID_PRESET_BASE + 29;
const FFQ_SID SID_PRESET_SUBTITLE_TYPE_BITMAP       = SID_PRESET_BASE + 30;
const FFQ_SID SID_PRESET_SUBTITLE_SCALE             = SID_PRESET_BASE + 31;
const FFQ_SID SID_PRESET_SUBTITLE_SIZE              = SID_PRESET_BASE + 32;
const FFQ_SID SID_PRESET_SUBTITLE_SIZE_DEFAULT      = SID_PRESET_BASE + 33;
const FFQ_SID SID_PRESET_SUBTITLE_SIZE_PAL          = SID_PRESET_BASE + 34;
const FFQ_SID SID_PRESET_SUBTITLE_SIZE_CUSTOM       = SID_PRESET_BASE + 35;
//const FFQ_SID SID_PRESET_PIXELS_AND_ASPECTS         = SID_PRESET_BASE + 36; //Might not be used anymore
const FFQ_SID SID_PRESET_PIXEL_FORMAT               = SID_PRESET_BASE + 37;
const FFQ_SID SID_PRESET_ASPECT_RATIO               = SID_PRESET_BASE + 38;
const FFQ_SID SID_PRESET_CUSTOM_CMDLINE_ARGS        = SID_PRESET_BASE + 39;
const FFQ_SID SID_PRESET_MANAGER_TITLE              = SID_PRESET_BASE + 40;
const FFQ_SID SID_PRESET_DELETE_FILTERS             = SID_PRESET_BASE + 41;
const FFQ_SID SID_PRESET_ONLY_ONE_DEINTERLACE       = SID_PRESET_BASE + 42;
const FFQ_SID SID_PRESET_NAME_IS_REQUIRED           = SID_PRESET_BASE + 43;
const FFQ_SID SID_PRESET_INVALID_FRAME_RATE         = SID_PRESET_BASE + 44;
const FFQ_SID SID_PRESET_INVALID_FILTERS_ADDED      = SID_PRESET_BASE + 45;
const FFQ_SID SID_PRESET_INVALID_METADATA           = SID_PRESET_BASE + 46;
const FFQ_SID SID_PRESET_NO_PREVIEWABLE_FILTERS     = SID_PRESET_BASE + 47;
const FFQ_SID SID_PRESET_PREVIEW_FAILED             = SID_PRESET_BASE + 48;
const FFQ_SID SID_PRESET_INVALID_QSCALE             = SID_PRESET_BASE + 49;
const FFQ_SID SID_PRESET_INVALID_SUBTITLE_SIZE      = SID_PRESET_BASE + 50;
const FFQ_SID SID_PRESET_QUALITY                    = SID_PRESET_BASE + 51;
const FFQ_SID SID_PRESET_QUALITY_SCALE              = SID_PRESET_BASE + 52;
const FFQ_SID SID_PRESET_CONSTANT_RATE              = SID_PRESET_BASE + 53;
const FFQ_SID SID_PRESET_MIN_CONSTANT_RATE          = SID_PRESET_BASE + 54;
const FFQ_SID SID_PRESET_QUANTIZER_MIN              = SID_PRESET_BASE + 55;
const FFQ_SID SID_PRESET_QUANTIZER_MAX              = SID_PRESET_BASE + 56;
const FFQ_SID SID_PRESET_QUANTIZER_MAX_DIFF         = SID_PRESET_BASE + 57;
const FFQ_SID SID_PRESET_BITRATE_DECLARED_AS        = SID_PRESET_BASE + 58;
const FFQ_SID SID_PRESET_AVERAGE_BITRATE            = SID_PRESET_BASE + 59;
const FFQ_SID SID_PRESET_MINIMUM_BITRATE            = SID_PRESET_BASE + 60;
const FFQ_SID SID_PRESET_MAXIMUM_BITRATE            = SID_PRESET_BASE + 61;
const FFQ_SID SID_PRESET_BUFFER_SIZE                = SID_PRESET_BASE + 62;
const FFQ_SID SID_PRESET_BUFFER_SIZE_REQUIRED       = SID_PRESET_BASE + 63;
const FFQ_SID SID_PRESET_KEYFRAMES                  = SID_PRESET_BASE + 64;
const FFQ_SID SID_PRESET_KEYFRAME_MINIMUM           = SID_PRESET_BASE + 65;
const FFQ_SID SID_PRESET_KEYFRAME_MAXIMUM           = SID_PRESET_BASE + 66;
const FFQ_SID SID_PRESET_KEYFRAME_INFO              = SID_PRESET_BASE + 67;
const FFQ_SID SID_PRESET_MOTION_EST_METHOD          = SID_PRESET_BASE + 68;
const FFQ_SID SID_PRESET_SCENE_CHANGE_SENSITIVITY   = SID_PRESET_BASE + 69;
const FFQ_SID SID_PRESET_SCENE_CHANGE_SENS_INFO     = SID_PRESET_BASE + 70;
const FFQ_SID SID_PRESET_LOW                        = SID_PRESET_BASE + 71;
const FFQ_SID SID_PRESET_HIGH                       = SID_PRESET_BASE + 72;
const FFQ_SID SID_PRESET_OTHER                      = SID_PRESET_BASE + 73;
const FFQ_SID SID_PRESET_THREADS                    = SID_PRESET_BASE + 74;
const FFQ_SID SID_PRESET_TRELLIS                    = SID_PRESET_BASE + 75;
const FFQ_SID SID_PRESET_TRELLIS_LIST               = SID_PRESET_BASE + 76;
const FFQ_SID SID_PRESET_SPEED_PRESET               = SID_PRESET_BASE + 77;
const FFQ_SID SID_PRESET_CUSTOM_ARGS_PASS_1         = SID_PRESET_BASE + 78;
const FFQ_SID SID_PRESET_CUSTOM_ARGS_PASS_2         = SID_PRESET_BASE + 79;
const FFQ_SID SID_PRESET_AUDIO_PROFILE              = SID_PRESET_BASE + 80;
const FFQ_SID SID_PRESET_AUDIO_FILTERS_COMPLEX      = SID_PRESET_BASE + 81;
const FFQ_SID SID_PRESET_MOVFLAGS_FASTSTART         = SID_PRESET_BASE + 82;
const FFQ_SID SID_PRESET_KEYFRAME_MAX_B_FRAMES      = SID_PRESET_BASE + 83;
const FFQ_SID SID_PRESET_KEYFRAME_MAX_B_FRAME_ITEMS = SID_PRESET_BASE + 84;
const FFQ_SID SID_PRESET_KEYFRAME_MAX_P_REFS        = SID_PRESET_BASE + 85;
const FFQ_SID SID_PRESET_OUTPUT_FORMAT              = SID_PRESET_BASE + 86;
const FFQ_SID SID_PRESET_MODIFY_ACTIVE_ERROR        = SID_PRESET_BASE + 87;
const FFQ_SID SID_PRESET_KEEP_FILETIME              = SID_PRESET_BASE + 88;
const FFQ_SID SID_PRESET_SUBTITLE_CHARENC           = SID_PRESET_BASE + 89;
const FFQ_SID SID_PRESET_SEGMENTING                 = SID_PRESET_BASE + 90;
const FFQ_SID SID_PRESET_SEGMENTING_LEN             = SID_PRESET_BASE + 91;
const FFQ_SID SID_PRESET_SEGMENTING_LEN_TYPE        = SID_PRESET_BASE + 92;
const FFQ_SID SID_PRESET_SEGMENTING_LIST_FILE       = SID_PRESET_BASE + 94;
const FFQ_SID SID_PRESET_SEGMENTING_LIST_TYPE       = SID_PRESET_BASE + 95;
const FFQ_SID SID_PRESET_SEGMENTING_BREAK_BFRAMES   = SID_PRESET_BASE + 96;
const FFQ_SID SID_PRESET_SEGMENTING_INCREMENT_TIME  = SID_PRESET_BASE + 97;
const FFQ_SID SID_PRESET_SEGMENTING_STREAMING       = SID_PRESET_BASE + 98;
const FFQ_SID SID_PRESET_SEGMENTING_RESET_TIME      = SID_PRESET_BASE + 99;
const FFQ_SID SID_PRESET_USE_CLOSED_GOP             = SID_PRESET_BASE + 100;
const FFQ_SID SID_PRESET_HWDECODE                   = SID_PRESET_BASE + 101;
const FFQ_SID SID_PRESET_HWDECODE_ACCEL             = SID_PRESET_BASE + 102;
const FFQ_SID SID_PRESET_HWDECODE_CODEC             = SID_PRESET_BASE + 103;
const FFQ_SID SID_PRESET_HWDECODE_DEVICE            = SID_PRESET_BASE + 104;
const FFQ_SID SID_PRESET_HWDECODE_DEVICE_INIT       = SID_PRESET_BASE + 105;
const FFQ_SID SID_PRESET_ERROR_NO_COMMA_ALLOWED     = SID_PRESET_BASE + 106;
const FFQ_SID SID_PRESET_VIDEO_TUNING               = SID_PRESET_BASE + 107;
const FFQ_SID SID_PRESET_METADATA_FOR               = SID_PRESET_BASE + 108;
const FFQ_SID SID_PRESET_METADATA_FOR_ITEMS         = SID_PRESET_BASE + 109;
const FFQ_SID SID_PRESET_DISPOSITION                = SID_PRESET_BASE + 110;
const FFQ_SID SID_PRESET_DISPOSITION_UNSET          = SID_PRESET_BASE + 111;
const FFQ_SID SID_PRESET_METADATA_STREAM            = SID_PRESET_BASE + 112;
const FFQ_SID SID_PRESET_SKIP_ENCODE_SAME           = SID_PRESET_BASE + 113;
const FFQ_SID SID_PRESET_STOP_ENCODE_SHORTEST       = SID_PRESET_BASE + 114;
const FFQ_SID SID_PRESET_NO_QUALITY_DEFINED         = SID_PRESET_BASE + 115;


//Video sync modes
const FFQ_SID SID_PRESET_VIDEO_SYNC_AUTO        = SID_PRESET_BASE + 400;
const FFQ_SID SID_PRESET_VIDEO_SYNC_PASSTHROUGH = SID_PRESET_BASE + 401;
const FFQ_SID SID_PRESET_VIDEO_SYNC_CFR         = SID_PRESET_BASE + 402;
const FFQ_SID SID_PRESET_VIDEO_SYNC_VFR         = SID_PRESET_BASE + 403;
const FFQ_SID SID_PRESET_VIDEO_SYNC_DROP        = SID_PRESET_BASE + 404;

//Bit rate modes
const FFQ_SID SID_PRESET_BITRATE_BIT_SEC        = SID_PRESET_BASE + 420;
const FFQ_SID SID_PRESET_BITRATE_KBIT_SEC       = SID_PRESET_BASE + 421;
const FFQ_SID SID_PRESET_BITRATE_MBIT_SEC       = SID_PRESET_BASE + 422;
const FFQ_SID SID_PRESET_BITRATE_BYTE_SEC       = SID_PRESET_BASE + 423;
const FFQ_SID SID_PRESET_BITRATE_KBYTE_SEC      = SID_PRESET_BASE + 424;
const FFQ_SID SID_PRESET_BITRATE_MBYTE_SEC      = SID_PRESET_BASE + 425;
const FFQ_SID SID_PRESET_BITRATE_QSCALE         = SID_PRESET_BASE + 426;


//Options edit UI
const FFQ_SID SID_OPTIONS_BASE                  = 6000;
const FFQ_SID SID_OPTIONS_TITLE                 = SID_OPTIONS_BASE + 0;
const FFQ_SID SID_OPTIONS_FFMPEG_PATH           = SID_OPTIONS_BASE + 1;
const FFQ_SID SID_OPTIONS_TEMPORARY_PATH        = SID_OPTIONS_BASE + 2;
const FFQ_SID SID_OPTIONS_TEMP_SYS_DEFAULT      = SID_OPTIONS_BASE + 3;
const FFQ_SID SID_OPTIONS_TEMP_DEST_PATH        = SID_OPTIONS_BASE + 4;
const FFQ_SID SID_OPTIONS_TEMP_CUSTOM           = SID_OPTIONS_BASE + 5;
const FFQ_SID SID_OPTIONS_FIND_2ND_INPUT_EXTS   = SID_OPTIONS_BASE + 6;
const FFQ_SID SID_OPTIONS_SAVE_JOBS_ON_EXIT     = SID_OPTIONS_BASE + 7;
const FFQ_SID SID_OPTIONS_REMOVE_FINISHED_JOBS  = SID_OPTIONS_BASE + 8;
const FFQ_SID SID_OPTIONS_LIMIT_STATISTICS      = SID_OPTIONS_BASE + 9;
const FFQ_SID SID_OPTIONS_SHOW_BANNER_INFO      = SID_OPTIONS_BASE + 10;
const FFQ_SID SID_OPTIONS_EDIT_LANGUAGE         = SID_OPTIONS_BASE + 11;
const FFQ_SID SID_OPTIONS_SAVE_WINDOW_POS       = SID_OPTIONS_BASE + 12;
const FFQ_SID SID_OPTIONS_FULL_CODEC_LIST       = SID_OPTIONS_BASE + 13;
const FFQ_SID SID_OPTIONS_ALWAYS_UNIQUE_NAMES   = SID_OPTIONS_BASE + 14;
const FFQ_SID SID_OPTIONS_CUSTOM_PLAYER         = SID_OPTIONS_BASE + 15;
const FFQ_SID SID_OPTIONS_KEEP_CONSOLE_OPEN     = SID_OPTIONS_BASE + 16;
const FFQ_SID SID_OPTIONS_CUSTOM_CONSOLE_CMD    = SID_OPTIONS_BASE + 17;
const FFQ_SID SID_OPTIONS_SILENT_QUEUE_FINISH   = SID_OPTIONS_BASE + 18;
const FFQ_SID SID_OPTIONS_SAVE_JOBS_ON_MODIFY   = SID_OPTIONS_BASE + 19;
const FFQ_SID SID_OPTIONS_VALIDATE_ON_LOAD      = SID_OPTIONS_BASE + 20;
const FFQ_SID SID_OPTIONS_OUTPUT_NAME_PATTERN   = SID_OPTIONS_BASE + 21;
const FFQ_SID SID_OPTIONS_CONFIRM_DELETE_JOBS   = SID_OPTIONS_BASE + 22;
const FFQ_SID SID_OPTIONS_PREVIEW_MAP_SUBS      = SID_OPTIONS_BASE + 23;
const FFQ_SID SID_OPTIONS_NUM_ENCODING_SLOTS    = SID_OPTIONS_BASE + 24;
const FFQ_SID SID_OPTIONS_DONT_SAVE_FFMPEG      = SID_OPTIONS_BASE + 25;


//Thumb maker UI
const FFQ_SID SID_THUMBS_BASE                   = 6500;
const FFQ_SID SID_THUMBS_TITLE                  = SID_THUMBS_BASE + 0;
const FFQ_SID SID_THUMBS_INPUT_FILE             = SID_THUMBS_BASE + 1;
const FFQ_SID SID_THUMBS_MAKE                   = SID_THUMBS_BASE + 2;
const FFQ_SID SID_THUMBS_CREATE_THUMBS          = SID_THUMBS_BASE + 3;
const FFQ_SID SID_THUMBS_CREATE_MOSAICS         = SID_THUMBS_BASE + 4;
const FFQ_SID SID_THUMBS_DEST_NEW_UNIQUE        = SID_THUMBS_BASE + 5;
const FFQ_SID SID_THUMBS_DEST_SAME              = SID_THUMBS_BASE + 6;
const FFQ_SID SID_THUMBS_DEST_THUMBS            = SID_THUMBS_BASE + 7;
const FFQ_SID SID_THUMBS_IMAGE_FORMAT           = SID_THUMBS_BASE + 8;
const FFQ_SID SID_THUMBS_WIDTH                  = SID_THUMBS_BASE + 9;
const FFQ_SID SID_THUMBS_HEIGHT_INFO            = SID_THUMBS_BASE + 10;
const FFQ_SID SID_THUMBS_INTERVAL               = SID_THUMBS_BASE + 11;
const FFQ_SID SID_THUMBS_INTERVAL_FRAME         = SID_THUMBS_BASE + 12;
const FFQ_SID SID_THUMBS_INTERVAL_SECOND        = SID_THUMBS_BASE + 13;
const FFQ_SID SID_THUMBS_INTERVAL_MINUTE        = SID_THUMBS_BASE + 14;
const FFQ_SID SID_THUMBS_SCENE_CHANGE           = SID_THUMBS_BASE + 15;
const FFQ_SID SID_THUMBS_MAX_THUMBS             = SID_THUMBS_BASE + 16;
const FFQ_SID SID_THUMBS_MAX_MOSAICS            = SID_THUMBS_BASE + 17;
const FFQ_SID SID_THUMBS_MOSAIC_ROWS            = SID_THUMBS_BASE + 18;
const FFQ_SID SID_THUMBS_MOSAIC_COLS            = SID_THUMBS_BASE + 19;


//Time edit UI
const FFQ_SID SID_TIMEEDIT_BASE                 = 6800;
const FFQ_SID SID_TIMEEDIT_TITLE                = SID_TIMEEDIT_BASE + 0;
const FFQ_SID SID_TIMEEDIT_ENTER_VALUE          = SID_TIMEEDIT_BASE + 1;
const FFQ_SID SID_TIMEEDIT_HOURS                = SID_TIMEEDIT_BASE + 2;
const FFQ_SID SID_TIMEEDIT_MINUTES              = SID_TIMEEDIT_BASE + 3;
const FFQ_SID SID_TIMEEDIT_SECONDS              = SID_TIMEEDIT_BASE + 4;
const FFQ_SID SID_TIMEEDIT_MILLISECONDS         = SID_TIMEEDIT_BASE + 5;
const FFQ_SID SID_TIMEEDIT_SUBTRACT_VALUES      = SID_TIMEEDIT_BASE + 6;
const FFQ_SID SID_TIMEEDIT_SUBTRACT_TIME        = SID_TIMEEDIT_BASE + 7;
const FFQ_SID SID_TIMEEDIT_NOT_AVAILABLE        = SID_TIMEEDIT_BASE + 8;


//About box UI
const FFQ_SID SID_ABOUT_BASE                    = 6900;
const FFQ_SID SID_ABOUT_TITLE                   = SID_ABOUT_BASE + 0;


//FFQVidStab UI
const FFQ_SID SID_VIDSTAB_BASE                  = 7000;
const FFQ_SID SID_VIDSTAB_TITLE                 = SID_VIDSTAB_BASE + 0;
const FFQ_SID SID_VIDSTAB_SHAKINESS             = SID_VIDSTAB_BASE + 1;
const FFQ_SID SID_VIDSTAB_ACCURACY              = SID_VIDSTAB_BASE + 2;
const FFQ_SID SID_VIDSTAB_STEP_SIZE             = SID_VIDSTAB_BASE + 3;
const FFQ_SID SID_VIDSTAB_MIN_CONTRAST          = SID_VIDSTAB_BASE + 4;
const FFQ_SID SID_VIDSTAB_TRIPOD_REF_FRAME      = SID_VIDSTAB_BASE + 5;
const FFQ_SID SID_VIDSTAB_1ST_PASS              = SID_VIDSTAB_BASE + 6;
const FFQ_SID SID_VIDSTAB_2ND_PASS              = SID_VIDSTAB_BASE + 7;
const FFQ_SID SID_VIDSTAB_IN_FILE               = SID_VIDSTAB_BASE + 8;
const FFQ_SID SID_VIDSTAB_DESTINATION           = SID_VIDSTAB_BASE + 9;
const FFQ_SID SID_VIDSTAB_SMOOTHING             = SID_VIDSTAB_BASE + 10;
const FFQ_SID SID_VIDSTAB_MAX_SHIFT             = SID_VIDSTAB_BASE + 11;
const FFQ_SID SID_VIDSTAB_MAX_ANGLE             = SID_VIDSTAB_BASE + 12;
const FFQ_SID SID_VIDSTAB_OPT_ALGO              = SID_VIDSTAB_BASE + 13;
const FFQ_SID SID_VIDSTAB_OPT_ALGO_ITEMS        = SID_VIDSTAB_BASE + 14;
const FFQ_SID SID_VIDSTAB_CROP_FILL_BLACK       = SID_VIDSTAB_BASE + 15;
const FFQ_SID SID_VIDSTAB_INVERT                = SID_VIDSTAB_BASE + 16;
const FFQ_SID SID_VIDSTAB_RELATIVE              = SID_VIDSTAB_BASE + 17;
const FFQ_SID SID_VIDSTAB_VIRTUAL_TRIPOD        = SID_VIDSTAB_BASE + 18;
const FFQ_SID SID_VIDSTAB_INTERPOLATION         = SID_VIDSTAB_BASE + 19;
const FFQ_SID SID_VIDSTAB_INTERPOLATION_ITEMS   = SID_VIDSTAB_BASE + 20;
const FFQ_SID SID_VIDSTAB_OPT_ZOOM              = SID_VIDSTAB_BASE + 21;
const FFQ_SID SID_VIDSTAB_OPT_ZOOM_ITEMS        = SID_VIDSTAB_BASE + 22;
const FFQ_SID SID_VIDSTAB_ZOOM                  = SID_VIDSTAB_BASE + 23;
const FFQ_SID SID_VIDSTAB_ZOOM_SPEED            = SID_VIDSTAB_BASE + 24;
const FFQ_SID SID_VIDSTAB_ONLY_1ST_PASS         = SID_VIDSTAB_BASE + 25;
const FFQ_SID SID_VIDSTAB_ONLY_2ND_PASS         = SID_VIDSTAB_BASE + 26;
const FFQ_SID SID_VIDSTAB_KEEP_TRANSFORMS       = SID_VIDSTAB_BASE + 27;
const FFQ_SID SID_VIDSTAB_VERBOSE               = SID_VIDSTAB_BASE + 28;
const FFQ_SID SID_VIDSTAB_OTHER_OPTIONS         = SID_VIDSTAB_BASE + 29;
const FFQ_SID SID_VIDSTAB_FILE_INFO             = SID_VIDSTAB_BASE + 30;

//VideoToGIF UI
const FFQ_SID SID_VIDEO2GIF_BASE                = 7100;
const FFQ_SID SID_VIDEO2GIF_TITLE               = SID_VIDEO2GIF_BASE + 0;
const FFQ_SID SID_VIDEO2GIF_PROPERTIES          = SID_VIDEO2GIF_BASE + 1;
const FFQ_SID SID_VIDEO2GIF_WIDTH               = SID_VIDEO2GIF_BASE + 2;
const FFQ_SID SID_VIDEO2GIF_HEIGHT              = SID_VIDEO2GIF_BASE + 3;
const FFQ_SID SID_VIDEO2GIF_TWOPASS             = SID_VIDEO2GIF_BASE + 4;
const FFQ_SID SID_VIDEO2GIF_START_FROM          = SID_VIDEO2GIF_BASE + 5;
const FFQ_SID SID_VIDEO2GIF_VIDEO_INFO          = SID_VIDEO2GIF_BASE + 6;
const FFQ_SID SID_VIDEO2GIF_NO_VIDEO            = SID_VIDEO2GIF_BASE + 7;
const FFQ_SID SID_VIDEO2GIF_BEYOND_END_OF_VID   = SID_VIDEO2GIF_BASE + 8;
const FFQ_SID SID_VIDEO2GIF_PRECISE_CUTS        = SID_VIDEO2GIF_BASE + 9;

//FullSpec UI
const FFQ_SID SID_FULLSPEC_BASE                 = 7200;
const FFQ_SID SID_FULLSPEC_TITLE                = SID_FULLSPEC_BASE + 0;
const FFQ_SID SID_FULLSPEC_REQUIRED_FIELD       = SID_FULLSPEC_BASE + 1;
const FFQ_SID SID_FULLSPEC_COLON_NOT_ALLOWED    = SID_FULLSPEC_BASE + 2;
const FFQ_SID SID_FULLSPEC_TEST                 = SID_FULLSPEC_BASE + 3;
const FFQ_SID SID_FULLSPEC_BAD_ID               = SID_FULLSPEC_BASE + 4;
//const FFQ_SID SID_FULLSPEC_SELECT_FILE          = SID_FULLSPEC_BASE + 5;

//Filter editor UI
const FFQ_SID SID_FILTER_BASE                   = 30000;
const FFQ_SID SID_FILTER_DEFINE_PROPERTIES      = SID_FILTER_BASE + 0;
const FFQ_SID SID_FILTER_INVALID_ID             = SID_FILTER_BASE + 1;

//Common filter strings (base panel)
const FFQ_SID SID_FILTER_TIME_LIMIT             = SID_FILTER_BASE + 100;
const FFQ_SID SID_FILTER_TIME_LIMIT_FROM        = SID_FILTER_BASE + 101;
const FFQ_SID SID_FILTER_TIME_LIMIT_TO          = SID_FILTER_BASE + 102;
const FFQ_SID SID_FILTER_TIME_LIMIT_START       = SID_FILTER_BASE + 103;
const FFQ_SID SID_FILTER_TIME_LIMIT_END         = SID_FILTER_BASE + 104;
const FFQ_SID SID_FILTER_TIME_LIMIT_FRIENDLY    = SID_FILTER_BASE + 105;
const FFQ_SID SID_FILTER_TIME_LIMIT_ERROR       = SID_FILTER_BASE + 106;
const FFQ_SID SID_FILTER_POSITION_LEFT          = SID_FILTER_BASE + 107;
const FFQ_SID SID_FILTER_POSITION_TOP           = SID_FILTER_BASE + 108;
const FFQ_SID SID_FILTER_POSITION_WIDTH         = SID_FILTER_BASE + 109;
const FFQ_SID SID_FILTER_POSITION_HEIGHT        = SID_FILTER_BASE + 110;
const FFQ_SID SID_FILTER_WIDTH_HEIGHT_REQUIRED  = SID_FILTER_BASE + 111;
const FFQ_SID SID_FILTER_THIS                   = SID_FILTER_BASE + 112;
//Subtitle burn in
const FFQ_SID SID_SUBSBURNIN_USERFRIENDLY       = SID_FILTER_BASE + 113;
const FFQ_SID SID_SUBSBURNIN_EDIT_DEL_INFO      = SID_FILTER_BASE + 114;
//Subtitle end
const FFQ_SID SID_FILTER_UNEDITABLE             = SID_FILTER_BASE + 115;

//BoxblurFilterPanel
const FFQ_SID SID_BOXBLUR_USERFRIENDLY          = SID_FILTER_BASE + 200;
const FFQ_SID SID_BOXBLUR_ALPHA                 = SID_FILTER_BASE + 201;
const FFQ_SID SID_BOXBLUR_CHROMA                = SID_FILTER_BASE + 202;
const FFQ_SID SID_BOXBLUR_LUMA                  = SID_FILTER_BASE + 203;
const FFQ_SID SID_BOXBLUR_RADIUS                = SID_FILTER_BASE + 204;
const FFQ_SID SID_BOXBLUR_POWER                 = SID_FILTER_BASE + 205;
const FFQ_SID SID_BOXBLUR_RADIUS_ERROR          = SID_FILTER_BASE + 206;
const FFQ_SID SID_BOXBLUR_POWER_ERROR           = SID_FILTER_BASE + 207;

//ChannelMapFilterPanel
const FFQ_SID SID_CHMAP_USERFRIENDLY            = SID_FILTER_BASE + 250;
const FFQ_SID SID_CHMAP_CHANNEL_LAYOUT          = SID_FILTER_BASE + 251;
const FFQ_SID SID_CHMAP_CHANNEL_REMAPPINGS      = SID_FILTER_BASE + 252;
const FFQ_SID SID_CHMAP_SOURCE_CHANNEL          = SID_FILTER_BASE + 253;
const FFQ_SID SID_CHMAP_DESTINATION_CHANNEL     = SID_FILTER_BASE + 254;

//ColorbalanceFilterPanel
const FFQ_SID SID_CLRBAL_USERFRIENDLY           = SID_FILTER_BASE + 300;
const FFQ_SID SID_CLRBAL_SHADOW_ADJUST          = SID_FILTER_BASE + 301;
const FFQ_SID SID_CLRBAL_HIGHLIGHT_ADJUST       = SID_FILTER_BASE + 302;
const FFQ_SID SID_CLRBAL_MIDTONE_ADJUST         = SID_FILTER_BASE + 303;
const FFQ_SID SID_CLRBAL_LOCK_IN_GROUPS         = SID_FILTER_BASE + 304;
const FFQ_SID SID_CLRBAL_LOCK_ACROSS_GROUPS     = SID_FILTER_BASE + 305;
const FFQ_SID SID_CLRBAL_RED                    = SID_FILTER_BASE + 306;
const FFQ_SID SID_CLRBAL_GREEN                  = SID_FILTER_BASE + 307;
const FFQ_SID SID_CLRBAL_BLUE                   = SID_FILTER_BASE + 308;

//ColorFilterPanel
const FFQ_SID SID_COLOR_USERFRIENDLY            = SID_FILTER_BASE + 350;
const FFQ_SID SID_COLOR_PICK_COLOR              = SID_FILTER_BASE + 351;
const FFQ_SID SID_COLOR_VISIBILITY              = SID_FILTER_BASE + 352;
const FFQ_SID SID_COLOR_VISIBILITY_NONE         = SID_FILTER_BASE + 353;
const FFQ_SID SID_COLOR_VISIBILITY_OPAQUE       = SID_FILTER_BASE + 354;
const FFQ_SID SID_COLOR_POSITION                = SID_FILTER_BASE + 355;
const FFQ_SID SID_COLOR_SIZE                    = SID_FILTER_BASE + 356;
const FFQ_SID SID_COLOR_SIZE_ERROR              = SID_FILTER_BASE + 357;

//ColorMatrixFilterPanel
const FFQ_SID SID_CLRMATRIX_USERFRIENDLY        = SID_FILTER_BASE + 400;
const FFQ_SID SID_CLRMATRIX_SRC_MATRIX          = SID_FILTER_BASE + 401;
const FFQ_SID SID_CLRMATRIX_DST_MATRIX          = SID_FILTER_BASE + 402;
const FFQ_SID SID_CLRMATRIX_ERROR               = SID_FILTER_BASE + 403;

//CropFilterPanel
const FFQ_SID SID_CROP_USERFRIENDLY             = SID_FILTER_BASE + 450;
const FFQ_SID SID_CROP_LEFT                     = SID_FILTER_BASE + 451;
const FFQ_SID SID_CROP_TOP                      = SID_FILTER_BASE + 452;
const FFQ_SID SID_CROP_RIGHT                    = SID_FILTER_BASE + 453;
const FFQ_SID SID_CROP_BOTTOM                   = SID_FILTER_BASE + 454;
const FFQ_SID SID_CROP_ERROR                    = SID_FILTER_BASE + 455;

//CurvesFilterPanel
const FFQ_SID SID_CURVES_USERFRIENDLY           = SID_FILTER_BASE + 500;
const FFQ_SID SID_CURVES_PRESET                 = SID_FILTER_BASE + 501;
const FFQ_SID SID_CURVES_MASTER_KEYS            = SID_FILTER_BASE + 502;
const FFQ_SID SID_CURVES_RED_KEYS               = SID_FILTER_BASE + 503;
const FFQ_SID SID_CURVES_GREEN_KEYS             = SID_FILTER_BASE + 504;
const FFQ_SID SID_CURVES_BLUE_KEYS              = SID_FILTER_BASE + 505;
const FFQ_SID SID_CURVES_ALL_KEYS               = SID_FILTER_BASE + 506;
const FFQ_SID SID_CURVES_ERROR                  = SID_FILTER_BASE + 507;
const FFQ_SID SID_CURVES_PRESET_BASE            = SID_FILTER_BASE + 530;

//CustomFilterPanel
const FFQ_SID SID_CUSTFLTR_USERFRIENDLY         = SID_FILTER_BASE + 550;
const FFQ_SID SID_CUSTFLTR_TYPE                 = SID_FILTER_BASE + 551;
const FFQ_SID SID_CUSTFLTR_VALUE                = SID_FILTER_BASE + 552;
const FFQ_SID SID_CUSTFLTR_ERROR                = SID_FILTER_BASE + 553;

//DeinterlaceFilterPanel
const FFQ_SID SID_DEINTER_USERFRIENDLY          = SID_FILTER_BASE + 600;
const FFQ_SID SID_DEINTER_MODE_NAME             = SID_FILTER_BASE + 601;
const FFQ_SID SID_DEINTER_MODE_VALUES           = SID_FILTER_BASE + 602;
const FFQ_SID SID_DEINTER_MODE_FRIENDLY         = SID_FILTER_BASE + 603;
const FFQ_SID SID_DEINTER_PARITY_NAME           = SID_FILTER_BASE + 604;
const FFQ_SID SID_DEINTER_PARITY_VALUES         = SID_FILTER_BASE + 605;
const FFQ_SID SID_DEINTER_PARITY_FRIENDLY       = SID_FILTER_BASE + 606;
const FFQ_SID SID_DEINTER_DEINTERLACE_NAME      = SID_FILTER_BASE + 607;
const FFQ_SID SID_DEINTER_DEINTERLACE_VALUES    = SID_FILTER_BASE + 608;
const FFQ_SID SID_DEINTER_DEINTERLACE_FRIENDLY  = SID_FILTER_BASE + 609;
//KernDeint (part of DeinterlaceFilterPanel)
const FFQ_SID SID_DEINTER_FILTER_TYPE           = SID_FILTER_BASE + 610;
const FFQ_SID SID_DEINTER_FILTER_TYPE_NAMES     = SID_FILTER_BASE + 611;
const FFQ_SID SID_DEINTER_KDEINT_USERFRIENDLY   = SID_FILTER_BASE + 612;
const FFQ_SID SID_DEINTER_KDEINT_TRESH          = SID_FILTER_BASE + 613;
const FFQ_SID SID_DEINTER_KDEINT_MAP            = SID_FILTER_BASE + 614;
const FFQ_SID SID_DEINTER_KDEINT_ORDER          = SID_FILTER_BASE + 615;
const FFQ_SID SID_DEINTER_KDEINT_SHARP          = SID_FILTER_BASE + 616;
const FFQ_SID SID_DEINTER_KDEINT_TWOWAY         = SID_FILTER_BASE + 617;


//-------------- IKKE TESTET

//DejudderFilterPanel
const FFQ_SID SID_DEJUDDER_USERFRIENDLY         = SID_FILTER_BASE + 650;
const FFQ_SID SID_DEJUDDER_FILM_2_NTSC          = SID_FILTER_BASE + 651;
const FFQ_SID SID_DEJUDDER_PAL_2_NTSC           = SID_FILTER_BASE + 652;
const FFQ_SID SID_DEJUDDER_MIX_OF_BOTH          = SID_FILTER_BASE + 653;
const FFQ_SID SID_DEJUDDER_CUSTOM               = SID_FILTER_BASE + 654;
const FFQ_SID SID_DEJUDDER_CUSTOM_ERROR         = SID_FILTER_BASE + 655;

//DelogoFilterPanel
const FFQ_SID SID_DELOGO_USERFRIENDLY           = SID_FILTER_BASE + 700;
const FFQ_SID SID_DELOGO_POSITION               = SID_FILTER_BASE + 701;
const FFQ_SID SID_DELOGO_SIZE                   = SID_FILTER_BASE + 702;
const FFQ_SID SID_DELOGO_SIZE_ERROR             = SID_FILTER_BASE + 703;
const FFQ_SID SID_DELOGO_BLUR_EDGE              = SID_FILTER_BASE + 704;
const FFQ_SID SID_DELOGO_USE_IMG_MASK           = SID_FILTER_BASE + 705;
const FFQ_SID SID_DELOGO_IMG_MASK_ERROR         = SID_FILTER_BASE + 706;

//-------------- SLUT IKKE TESTET

//DeshakeFilterPanel
const FFQ_SID SID_DESHAKE_USERFRIENDLY          = SID_FILTER_BASE + 750;
const FFQ_SID SID_DESHAKE_DETECT_FRAME_1        = SID_FILTER_BASE + 751;
const FFQ_SID SID_DESHAKE_DETECT_FRAME_2        = SID_FILTER_BASE + 752;
const FFQ_SID SID_DESHAKE_DETECT_POSITION       = SID_FILTER_BASE + 753;
const FFQ_SID SID_DESHAKE_DETECT_SIZE           = SID_FILTER_BASE + 754;
const FFQ_SID SID_DESHAKE_DETECT_ENTIRE_FRAME   = SID_FILTER_BASE + 755;
const FFQ_SID SID_DESHAKE_MAX_SHAKE             = SID_FILTER_BASE + 756;
const FFQ_SID SID_DESHAKE_HORZ                  = SID_FILTER_BASE + 757;
const FFQ_SID SID_DESHAKE_VERT                  = SID_FILTER_BASE + 758;
const FFQ_SID SID_DESHAKE_FILL_EDGE             = SID_FILTER_BASE + 759;
const FFQ_SID SID_DESHAKE_FILL_EDGE_VALUES      = SID_FILTER_BASE + 760;
const FFQ_SID SID_DESHAKE_FILL_EDGE_FRIENDLY    = SID_FILTER_BASE + 761;
const FFQ_SID SID_DESHAKE_BLOCK_SIZE            = SID_FILTER_BASE + 762;
const FFQ_SID SID_DESHAKE_BLOCK_SIZE_ERROR      = SID_FILTER_BASE + 763;
const FFQ_SID SID_DESHAKE_MIN_CONTRAST          = SID_FILTER_BASE + 764;
const FFQ_SID SID_DESHAKE_MIN_CONTRAST_ERROR    = SID_FILTER_BASE + 765;
const FFQ_SID SID_DESHAKE_SEARCH                = SID_FILTER_BASE + 766;
const FFQ_SID SID_DESHAKE_SEARCH_VALUES         = SID_FILTER_BASE + 767;
const FFQ_SID SID_DESHAKE_OPENCL                = SID_FILTER_BASE + 768;
const FFQ_SID SID_DESHAKE_USE_OPENCL            = SID_FILTER_BASE + 769;


//-------------- IKKE TESTET


//EchoFilterPanel
const FFQ_SID SID_ECHO_USERFRIENDLY             = SID_FILTER_BASE + 800;
const FFQ_SID SID_ECHO_GAIN                     = SID_FILTER_BASE + 801;
const FFQ_SID SID_ECHO_GAIN_INPUT               = SID_FILTER_BASE + 802;
const FFQ_SID SID_ECHO_GAIN_OUTPUT              = SID_FILTER_BASE + 803;
const FFQ_SID SID_ECHO_GAIN_ERROR               = SID_FILTER_BASE + 804;
const FFQ_SID SID_ECHO_DELAYS                   = SID_FILTER_BASE + 805;
const FFQ_SID SID_ECHO_DECAYS                   = SID_FILTER_BASE + 806;
const FFQ_SID SID_ECHO_DELAY_DECAY_ERROR        = SID_FILTER_BASE + 807;

//EqualizerFilterPanel
const FFQ_SID SID_EQUALIZER_USERFRIENDLY        = SID_FILTER_BASE + 850;
const FFQ_SID SID_EQUALIZER_ERROR               = SID_FILTER_BASE + 851;
const FFQ_SID SID_EQUALIZER_BAND_WIDTH          = SID_FILTER_BASE + 852;

//FlangerFilterPanel
const FFQ_SID SID_FLANGER_USERFRIENDLY          = SID_FILTER_BASE + 900;
const FFQ_SID SID_FLANGER_DELAY                 = SID_FILTER_BASE + 901;
const FFQ_SID SID_FLANGER_DEPTH                 = SID_FILTER_BASE + 902;
const FFQ_SID SID_FLANGER_REGENERATION          = SID_FILTER_BASE + 903;
const FFQ_SID SID_FLANGER_WIDTH                 = SID_FILTER_BASE + 904;
const FFQ_SID SID_FLANGER_SPEED                 = SID_FILTER_BASE + 905;
const FFQ_SID SID_FLANGER_PHASE                 = SID_FILTER_BASE + 906;
const FFQ_SID SID_FLANGER_SHAPE                 = SID_FILTER_BASE + 907;
const FFQ_SID SID_FLANGER_SHAPE_SIN             = SID_FILTER_BASE + 908;
const FFQ_SID SID_FLANGER_SHAPE_TRI             = SID_FILTER_BASE + 909;
const FFQ_SID SID_FLANGER_INTERPOLATION         = SID_FILTER_BASE + 910;
const FFQ_SID SID_FLANGER_INTERPOLATION_LINE    = SID_FILTER_BASE + 911;
const FFQ_SID SID_FLANGER_INTERPOLATION_QUAD    = SID_FILTER_BASE + 912;

//FlipFilterPanel
const FFQ_SID SID_FLIP_USERFRIENDLY             = SID_FILTER_BASE + 950;
const FFQ_SID SID_FLIP_HORZ                     = SID_FILTER_BASE + 951;
const FFQ_SID SID_FLIP_VERT                     = SID_FILTER_BASE + 952;
const FFQ_SID SID_FLIP_ERROR                    = SID_FILTER_BASE + 953;

//HighLowBandPassFilterPanel
const FFQ_SID SID_BANDPASS_USERFRIENDLY         = SID_FILTER_BASE + 1000;
const FFQ_SID SID_BANDPASS_FREQUENCY            = SID_FILTER_BASE + 1001;
const FFQ_SID SID_BANDPASS_HERZ                 = SID_FILTER_BASE + 1002;
const FFQ_SID SID_BANDPASS_SKIRT_GAIN           = SID_FILTER_BASE + 1003;
const FFQ_SID SID_BANDPASS_SKIRT_GAIN_FRIENDLY  = SID_FILTER_BASE + 1004;
const FFQ_SID SID_BANDPASS_POLES                = SID_FILTER_BASE + 1005;
const FFQ_SID SID_BANDPASS_BAND_WIDTH           = SID_FILTER_BASE + 1006;
const FFQ_SID SID_BANDPASS_BAND_WIDTH_TYPES     = SID_FILTER_BASE + 1007;
const FFQ_SID SID_BANDPASS_BAD_FILTERTYPE       = SID_FILTER_BASE + 1008;

//PadFilterPanel
const FFQ_SID SID_PAD_USERFRIENDLY              = SID_FILTER_BASE + 1050;
const FFQ_SID SID_PAD_COLOR                     = SID_FILTER_BASE + 1051;
const FFQ_SID SID_PAD_SIZE                      = SID_FILTER_BASE + 1052;
const FFQ_SID SID_PAD_BLUR                      = SID_FILTER_BASE + 1053;
const FFQ_SID SID_PAD_USERFRIENDLY_BLUR         = SID_FILTER_BASE + 1054;

//PhaserFilterPanel
const FFQ_SID SID_PHASER_USERFRIENDLY           = SID_FILTER_BASE + 1100;
const FFQ_SID SID_PHASER_DECAY                  = SID_FILTER_BASE + 1101;
const FFQ_SID SID_PHASER_TYPE                   = SID_FILTER_BASE + 1102;
const FFQ_SID SID_PHASER_ERROR                  = SID_FILTER_BASE + 1103;

//ResampleFilterPanel
const FFQ_SID SID_RESAMPLE_USERFRIENDLY         = SID_FILTER_BASE + 1150;
const FFQ_SID SID_RESAMPLE_SAMPLE_RATE          = SID_FILTER_BASE + 1151;
const FFQ_SID SID_RESAMPLE_SAMPLE_RATE_ERROR    = SID_FILTER_BASE + 1152;
const FFQ_SID SID_RESAMPLE_AUDIO_SYNC           = SID_FILTER_BASE + 1153;
const FFQ_SID SID_RESAMPLE_MATRIX_ENCODING      = SID_FILTER_BASE + 1154;
const FFQ_SID SID_RESAMPLE_MATRIX_ENC_NAMES     = SID_FILTER_BASE + 1155;
const FFQ_SID SID_RESAMPLE_FILTER_TYPE          = SID_FILTER_BASE + 1156;
const FFQ_SID SID_RESAMPLE_FILTER_TYPE_NAMES    = SID_FILTER_BASE + 1157;
const FFQ_SID SID_RESAMPLE_DITHER_METHOD        = SID_FILTER_BASE + 1158;
const FFQ_SID SID_RESAMPLE_DITHER_METHOD_NAMES  = SID_FILTER_BASE + 1159;
const FFQ_SID SID_RESAMPLE_FORCE_RESAMPLE       = SID_FILTER_BASE + 1160;
const FFQ_SID SID_RESAMPLE_INTERPOLATION        = SID_FILTER_BASE + 1161;
const FFQ_SID SID_RESAMPLE_CUSTOM_VALUES        = SID_FILTER_BASE + 1162;
const FFQ_SID SID_RESAMPLE_CUSTOM_VALUE_NAMES   = SID_FILTER_BASE + 1163;
const FFQ_SID SID_RESAMPLE_VALUE                = SID_FILTER_BASE + 1164;
const FFQ_SID SID_RESAMPLE_EMPTY_ERROR          = SID_FILTER_BASE + 1165;
const FFQ_SID SID_RESAMPLE_KEEP_ORIGINAL_RATE   = SID_FILTER_BASE + 1166;

//RotateFilterPanel
const FFQ_SID SID_ROTATE_USERFRIENDLY           = SID_FILTER_BASE + 1200;
const FFQ_SID SID_ROTATE_FILL_COLOR             = SID_FILTER_BASE + 1201;
const FFQ_SID SID_ROTATE_ROTATE_ANGLE           = SID_FILTER_BASE + 1202;
const FFQ_SID SID_ROTATE_ROTATE_ANGLE_ERROR     = SID_FILTER_BASE + 1203;
const FFQ_SID SID_ROTATE_BILINEAR_INTERPOLATE   = SID_FILTER_BASE + 1204;
const FFQ_SID SID_ROTATE_ROTATE_CCW             = SID_FILTER_BASE + 1205;

//ScaleFilterPanel
const FFQ_SID SID_SCALE_USERFRIENDLY            = SID_FILTER_BASE + 1250;
const FFQ_SID SID_SCALE_EMPTY_INFO              = SID_FILTER_BASE + 1251;
const FFQ_SID SID_SCALE_RESIZE_TO               = SID_FILTER_BASE + 1252;
const FFQ_SID SID_SCALE_PERCENTAGE              = SID_FILTER_BASE + 1253;
const FFQ_SID SID_SCALE_ALGORITHM               = SID_FILTER_BASE + 1254;
const FFQ_SID SID_SCALE_ALGORITHM_NAMES         = SID_FILTER_BASE + 1255;
const FFQ_SID SID_SCALE_DITHER                  = SID_FILTER_BASE + 1256;
const FFQ_SID SID_SCALE_DITHER_NAMES            = SID_FILTER_BASE + 1257;
const FFQ_SID SID_SCALE_ACCURATE_ROUNDING       = SID_FILTER_BASE + 1258;
const FFQ_SID SID_SCALE_FULL_CHROMA_INTERPOLATE = SID_FILTER_BASE + 1259;
const FFQ_SID SID_SCALE_FULL_CHROMA_INPUT       = SID_FILTER_BASE + 1260;
const FFQ_SID SID_SCALE_BIT_EXACT_OUTPUT        = SID_FILTER_BASE + 1261;
const FFQ_SID SID_SCALE_SIZE_ERROR              = SID_FILTER_BASE + 1262;
const FFQ_SID SID_SCALE_NEGATIVE_NUMBER_ERROR   = SID_FILTER_BASE + 1263;
const FFQ_SID SID_SCALE_PERCENTAGE_ERROR        = SID_FILTER_BASE + 1264;
const FFQ_SID SID_SCALE_INTERLACE_AWARE         = SID_FILTER_BASE + 1265;
const FFQ_SID SID_SCALE_INTERLACE_AWARE_NAMES   = SID_FILTER_BASE + 1266;
const FFQ_SID SID_SCALE_COLOR_SPACE             = SID_FILTER_BASE + 1267;
const FFQ_SID SID_SCALE_SAMPLE_RANGE            = SID_FILTER_BASE + 1269;
const FFQ_SID SID_SCALE_FIT_RECT                = SID_FILTER_BASE + 1270;
const FFQ_SID SID_SCALE_FIT_RECT_ERROR          = SID_FILTER_BASE + 1271;

//UnsharpFilterPanel
const FFQ_SID SID_UNSHARP_USERFRIENDLY          = SID_FILTER_BASE + 1300;
const FFQ_SID SID_UNSHARP_SHARPEN_AMOUNT        = SID_FILTER_BASE + 1301;
const FFQ_SID SID_UNSHARP_LUMA_SIZE             = SID_FILTER_BASE + 1302;
const FFQ_SID SID_UNSHARP_CHROMA_SIZE           = SID_FILTER_BASE + 1303;
const FFQ_SID SID_UNSHARP_SHARPEN_ERROR         = SID_FILTER_BASE + 1304;
const FFQ_SID SID_UNSHARP_GROUP_LABELS          = SID_FILTER_BASE + 1305;

//VignetteFilterPanel
const FFQ_SID SID_VIGNETTE_USERFRIENDLY         = SID_FILTER_BASE + 1350;
const FFQ_SID SID_VIGNETTE_ANGLE                = SID_FILTER_BASE + 1351;
const FFQ_SID SID_VIGNETTE_ANGLE_ERROR          = SID_FILTER_BASE + 1352;
const FFQ_SID SID_VIGNETTE_ORIGIN               = SID_FILTER_BASE + 1353;
const FFQ_SID SID_VIGNETTE_CALC_CENTER_COORDS   = SID_FILTER_BASE + 1354;
const FFQ_SID SID_VIGNETTE_FORWARD              = SID_FILTER_BASE + 1355;
const FFQ_SID SID_VIGNETTE_CALC_EACH_FRAME      = SID_FILTER_BASE + 1356;
const FFQ_SID SID_VIGNETTE_APPLY_FLICKER        = SID_FILTER_BASE + 1357;
const FFQ_SID SID_VIGNETTE_REDUCE_BANDING       = SID_FILTER_BASE + 1358;

//VolumeAndToneFilterPanel
const FFQ_SID SID_VOLTONE_USERFRIENDLY          = SID_FILTER_BASE + 1400;
const FFQ_SID SID_VOLTONE_VOLUME                = SID_FILTER_BASE + 1401;
const FFQ_SID SID_VOLTONE_BASS                  = SID_FILTER_BASE + 1402;
const FFQ_SID SID_VOLTONE_TREBLE                = SID_FILTER_BASE + 1403;
const FFQ_SID SID_VOLTONE_ERROR                 = SID_FILTER_BASE + 1404;

//WatermarkFilterPanel
const FFQ_SID SID_WATERMARK_USERFRIENDLY        = SID_FILTER_BASE + 1450;
const FFQ_SID SID_WATERMARK_FILE                = SID_FILTER_BASE + 1451;
const FFQ_SID SID_WATERMARK_FILE_ERROR          = SID_FILTER_BASE + 1452;
const FFQ_SID SID_WATERMARK_POSITION            = SID_FILTER_BASE + 1453;
const FFQ_SID SID_WATERMARK_SCALE_TO            = SID_FILTER_BASE + 1454;
const FFQ_SID SID_WATERMARK_ASPECT_INFO         = SID_FILTER_BASE + 1455;
const FFQ_SID SID_WATERMARK_FADE_IN_OUT         = SID_FILTER_BASE + 1456;
const FFQ_SID SID_WATERMARK_FADE_INSTANT        = SID_FILTER_BASE + 1457;
const FFQ_SID SID_WATERMARK_FADE_SLOW           = SID_FILTER_BASE + 1458;
const FFQ_SID SID_WATERMARK_ALPHA_CHANNEL_INFO  = SID_FILTER_BASE + 1459;

//NegateFilterPanel
const FFQ_SID SID_NEGATE_USERFRIENDLY           = SID_FILTER_BASE + 1500;
const FFQ_SID SID_NEGATE_ALPHA_CHANNEL          = SID_FILTER_BASE + 1501;
const FFQ_SID SID_NEGATE_ALPHA                  = SID_FILTER_BASE + 1502;
const FFQ_SID SID_NEGATE_IMAGE                  = SID_FILTER_BASE + 1503;

//ElbgFilterPanel
const FFQ_SID SID_ELBG_USERFRIENDLY             = SID_FILTER_BASE + 1550;
const FFQ_SID SID_ELBG_COLORS                   = SID_FILTER_BASE + 1551;
const FFQ_SID SID_ELBG_ITERATIONS               = SID_FILTER_BASE + 1552;
const FFQ_SID SID_ELBG_ERROR                    = SID_FILTER_BASE + 1553;

//AudioDelayFilterPanel
const FFQ_SID SID_ADELAY_USERFRIENDLY           = SID_FILTER_BASE + 1600;
const FFQ_SID SID_ADELAY_CHANNEL_NUMBER         = SID_FILTER_BASE + 1601;
const FFQ_SID SID_ADELAY_DELAY_MILLIS           = SID_FILTER_BASE + 1602;
const FFQ_SID SID_ADELAY_ERROR                  = SID_FILTER_BASE + 1603;

//AudioTempoFilterPanel
const FFQ_SID SID_ATEMPO_USERFRIENDLY           = SID_FILTER_BASE + 1650;
const FFQ_SID SID_ATEMPO_HALF_SPEED             = SID_FILTER_BASE + 1651;
const FFQ_SID SID_ATEMPO_DOUBLE_SPEED           = SID_FILTER_BASE + 1652;
const FFQ_SID SID_ATEMPO_ERROR                  = SID_FILTER_BASE + 1653;

//DecimateFilterPanel
const FFQ_SID SID_DECIMATE_USERFRIENDLY         = SID_FILTER_BASE + 1700;
const FFQ_SID SID_DECIMATE_CYCLE                = SID_FILTER_BASE + 1701;
const FFQ_SID SID_DECIMATE_DUP_THRESHOLD        = SID_FILTER_BASE + 1702;
const FFQ_SID SID_DECIMATE_SC_THRESHOLD         = SID_FILTER_BASE + 1703;
const FFQ_SID SID_DECIMATE_BLOCK_SIZE           = SID_FILTER_BASE + 1704;
const FFQ_SID SID_DECIMATE_MAIN_PREPROCESSED    = SID_FILTER_BASE + 1705;
const FFQ_SID SID_DECIMATE_CHROMA_METRIC        = SID_FILTER_BASE + 1706;
const FFQ_SID SID_DECIMATE_CYCLE_ERROR          = SID_FILTER_BASE + 1707;
const FFQ_SID SID_DECIMATE_BLOCK_SIZE_ERROR     = SID_FILTER_BASE + 1708;

//InterlaceFilterPanel
const FFQ_SID SID_INTERLACE_USERFRIENDLY        = SID_FILTER_BASE + 1750;
const FFQ_SID SID_INTERLACE_SCAN                = SID_FILTER_BASE + 1751;
const FFQ_SID SID_INTERLACE_EVEN                = SID_FILTER_BASE + 1752;
const FFQ_SID SID_INTERLACE_ODD                 = SID_FILTER_BASE + 1753;
const FFQ_SID SID_INTERLACE_LOWPASS             = SID_FILTER_BASE + 1754;
const FFQ_SID SID_INTERLACE_FILTER_TYPE         = SID_FILTER_BASE + 1755;
const FFQ_SID SID_INTERLACE_FILTER_TYPE_NAMES   = SID_FILTER_BASE + 1756;
const FFQ_SID SID_INTERLACE_TINTRL_MODE         = SID_FILTER_BASE + 1757;
const FFQ_SID SID_INTERLACE_TINTRL_MODE_NAMES   = SID_FILTER_BASE + 1758;

//FramestepFilterPanel
const FFQ_SID SID_FRAMESTEP_USERFRIENDLY        = SID_FILTER_BASE + 1800;
const FFQ_SID SID_FRAMESTEP_SELECT              = SID_FILTER_BASE + 1801;
const FFQ_SID SID_FRAMESTEP_FRAMES              = SID_FILTER_BASE + 1802;
const FFQ_SID SID_FRAMESTEP_ERROR               = SID_FILTER_BASE + 1803;

//Hqdn3dFilterPanel
const FFQ_SID SID_HQDN3D_USERFRIENDLY           = SID_FILTER_BASE + 1850;
const FFQ_SID SID_HQDN3D_LUMA_SPARTIAL          = SID_FILTER_BASE + 1851;
const FFQ_SID SID_HQDN3D_CHROMA_SPARTIAL        = SID_FILTER_BASE + 1852;
const FFQ_SID SID_HQDN3D_LUMA_TEMP              = SID_FILTER_BASE + 1853;
const FFQ_SID SID_HQDN3D_CHROMA_TEMP            = SID_FILTER_BASE + 1854;

//HueFilterPanel
const FFQ_SID SID_HUE_USERFRIENDLY              = SID_FILTER_BASE + 1900;
const FFQ_SID SID_HUE_HUE                       = SID_FILTER_BASE + 1901;
const FFQ_SID SID_HUE_SATURATION                = SID_FILTER_BASE + 1902;
const FFQ_SID SID_HUE_BRIGHTNESS                = SID_FILTER_BASE + 1903;
const FFQ_SID SID_HUE_ERROR                     = SID_FILTER_BASE + 1904;

//LenscorrectionFilterPanel
const FFQ_SID SID_LENSCORRECTION_USERFRIENDLY   = SID_FILTER_BASE + 1950;
const FFQ_SID SID_LENSCORRECTION_CX             = SID_FILTER_BASE + 1951;
const FFQ_SID SID_LENSCORRECTION_CY             = SID_FILTER_BASE + 1952;
const FFQ_SID SID_LENSCORRECTION_CX_CY_TEXT     = SID_FILTER_BASE + 1953;
const FFQ_SID SID_LENSCORRECTION_K1             = SID_FILTER_BASE + 1954;
const FFQ_SID SID_LENSCORRECTION_K2             = SID_FILTER_BASE + 1955;
const FFQ_SID SID_LENSCORRECTION_K1_K2_TEXT     = SID_FILTER_BASE + 1956;
const FFQ_SID SID_LENSCORRECTION_ERROR          = SID_FILTER_BASE + 1957;

//NoiseFilterPanel
const FFQ_SID SID_NOISE_USERFRIENDLY            = SID_FILTER_BASE + 2000;
const FFQ_SID SID_NOISE_SEED                    = SID_FILTER_BASE + 2001;
const FFQ_SID SID_NOISE_STRENGTH                = SID_FILTER_BASE + 2002;
const FFQ_SID SID_NOISE_FLAGS                   = SID_FILTER_BASE + 2003;
const FFQ_SID SID_NOISE_COMPONENT_NAMES         = SID_FILTER_BASE + 2004;
const FFQ_SID SID_NOISE_FLAG_NAMES              = SID_FILTER_BASE + 2005;
const FFQ_SID SID_NOISE_SEED_ERROR              = SID_FILTER_BASE + 2006;
const FFQ_SID SID_NOISE_FLAGS_ERROR             = SID_FILTER_BASE + 2007;
const FFQ_SID SID_NOISE_STRENGTH_ERROR          = SID_FILTER_BASE + 2008;

//PerspectiveFilterPanel
const FFQ_SID SID_PERSPECTIVE_USERFRIENDLY      = SID_FILTER_BASE + 2050;
const FFQ_SID SID_PERSPECTIVE_LEFT              = SID_FILTER_BASE + 2051;
const FFQ_SID SID_PERSPECTIVE_RIGHT             = SID_FILTER_BASE + 2052;
const FFQ_SID SID_PERSPECTIVE_TOP               = SID_FILTER_BASE + 2053;
const FFQ_SID SID_PERSPECTIVE_BOTTOM            = SID_FILTER_BASE + 2054;
const FFQ_SID SID_PERSPECTIVE_SQUEEZE           = SID_FILTER_BASE + 2055;
const FFQ_SID SID_PERSPECTIVE_STRETCH           = SID_FILTER_BASE + 2056;
const FFQ_SID SID_PERSPECTIVE_INTERPOL_CUBIC    = SID_FILTER_BASE + 2057;
const FFQ_SID SID_PERSPECTIVE_ERROR             = SID_FILTER_BASE + 2058;

//TransposeFilterPanel
const FFQ_SID SID_TRANSPOSE_USERFRIENDLY        = SID_FILTER_BASE + 2100;
const FFQ_SID SID_TRANSPOSE_DIRECTION           = SID_FILTER_BASE + 2101;
const FFQ_SID SID_TRANSPOSE_CLOCKWISE           = SID_FILTER_BASE + 2102;
const FFQ_SID SID_TRANSPOSE_COUNTER_CLOCKWISE   = SID_FILTER_BASE + 2103;
const FFQ_SID SID_TRANSPOSE_FLIP                = SID_FILTER_BASE + 2104;

//DynaudnormFilterPanel
const FFQ_SID SID_DYNAUDNORM_USERFRIENDLY       = SID_FILTER_BASE + 2200;
const FFQ_SID SID_DYNAUDNORM_FRAME_LENGTH       = SID_FILTER_BASE + 2201;
const FFQ_SID SID_DYNAUDNORM_GAUS_WND_SIZE      = SID_FILTER_BASE + 2202;
const FFQ_SID SID_DYNAUDNORM_TARGET_PEAK_VALUE  = SID_FILTER_BASE + 2203;
const FFQ_SID SID_DYNAUDNORM_MAX_GAIN_FACTOR    = SID_FILTER_BASE + 2204;
const FFQ_SID SID_DYNAUDNORM_TARGET_RMS         = SID_FILTER_BASE + 2205;
const FFQ_SID SID_DYNAUDNORM_CHANNEL_COUPLING   = SID_FILTER_BASE + 2206;
const FFQ_SID SID_DYNAUDNORM_DC_BIAS_CORRECT    = SID_FILTER_BASE + 2207;
const FFQ_SID SID_DYNAUDNORM_BOUNDARY_MODE      = SID_FILTER_BASE + 2208;
const FFQ_SID SID_DYNAUDNORM_COMPRESS_FACTOR    = SID_FILTER_BASE + 2209;

//DeflickerFilterPanel
const FFQ_SID SID_DEFLICKER_USERFRIENDLY        = SID_FILTER_BASE + 2300;
const FFQ_SID SID_DEFLICKER_SAMPLE_COUNT        = SID_FILTER_BASE + 2301;
const FFQ_SID SID_DEFLICKER_AVG_MODE            = SID_FILTER_BASE + 2302;
const FFQ_SID SID_DEFLICKER_AVG_MODES           = SID_FILTER_BASE + 2303;

//FramesPerSecondFilterPanel
const FFQ_SID SID_FRAMESPERSECOND_USERFRIENDLY  = SID_FILTER_BASE + 2400;
const FFQ_SID SID_FRAMESPERSECOND_FPS           = SID_FILTER_BASE + 2401;
const FFQ_SID SID_FRAMESPERSECOND_STARTTIME     = SID_FILTER_BASE + 2402;
const FFQ_SID SID_FRAMESPERSECOND_RND_METHOD    = SID_FILTER_BASE + 2403;
const FFQ_SID SID_FRAMESPERSECOND_RND_METHODS   = SID_FILTER_BASE + 2404;
const FFQ_SID SID_FRAMESPERSECOND_EOF_ACTION    = SID_FILTER_BASE + 2405;
const FFQ_SID SID_FRAMESPERSECOND_EOF_ACTIONS   = SID_FILTER_BASE + 2406;

//Constants used for strings that defines roots for enum typedefs
const FFQ_SID SID_ENUM_BASE             = 60000;


//Root of filter panel names
const FFQ_SID SID_FILTER_NAME_BASE      = SID_ENUM_BASE + 00;


//Types for string hash (SHA1) and flags (a byte)
typedef uint8_t STR_HASH[20];
typedef uint8_t STR_FLAG;

//Flags used with FFQ_STRING
const STR_FLAG SF_STORED = 1; //The string is stored in file (if not the string is new)
const STR_FLAG SF_MODIFIED = 2; //Set if the original string has been modified since last store
const STR_FLAG SF_TRANSLATED = 4; //Set if the string has been translated

typedef struct FFQ_STRING
{

    FFQ_SID sid; //String id
    wxString str; //String value
    STR_HASH str_hash, //Hash of "str"
             org_hash; //Hash of the translated string (read from file to detect any changes in the internal strings)
    STR_FLAG flags; //Flags for the string (see STR_FLAG values above)
    FFQ_STRING(FFQ_SID id, wxString st) { sid = id; str = st; str.Shrink(); flags = 0; } //Default constructor

} FFQ_STRING, *LPFFQ_STRING;

//Helper functions
void HashString(const wxString &str, STR_HASH &hash);
void EncBuf(uint8_t *buf, uint32_t len, STR_HASH &key);

//Message functions
bool DoConfirm(wxString msg);
bool DoConfirm(wxWindow *focus, wxString msg, unsigned int icon = 0);
bool ShowError(wxString msg);
bool ShowError(wxWindow *focus, wxString msg);
bool ShowInfo(wxString msg);
bool ShowInfo(wxWindow *focus, wxString msg);
bool ShowWarning(wxString msg);
bool ShowWarning(wxWindow *focus, wxString msg);

//The language class
class FFQLang
{

    public:

        static const unsigned short TIME_VALUE_COUNT;
        static const unsigned short AUDIO_CHANNEL_COUNT;

        wxString *QUEUE_STATUS_NAMES, *FILTER_NAMES, *TIME_VALUE_NAMES, *AUDIO_CHANNEL_NAMES;

        static FFQLang* GetInstance();

        FFQLang(bool loadFile = true);
        ~FFQLang();

        void LibAVify();
        void LibAVify(wxString &str);
        void ChangePassword(wxString pwd);
        bool CheckPassword(wxString pwd);
        LPFFQ_STRING FindString(FFQ_SID sid);
        const wxString& GetAtIndex(unsigned int index);
        LPFFQ_STRING GetPtrAtIndex(unsigned int index);
        const unsigned int GetCount();
        const wxString& GetDescription();
        const wxString& GetFFQVersion();
        const unsigned int GetFlagCount(STR_FLAG flag);
        const wxString& GetLoadedFileName();
        const unsigned int GetNumberOfSkippedStringsInFile();
        wxString* GetStringArray(FFQ_SID sid, unsigned int requiredSize, wxUniChar separator = '|');
        const wxString& GetString(FFQ_SID sid);
        const wxString& GetDateTimeString();
        bool HasPassword();
        bool LoadLanguage();
        bool SaveLanguage();
        void SetDescription(wxString &desc);
        void SetString(FFQ_SID sid, wxString str);

    protected:

    private:

        static FFQLang *m_Instance;

        unsigned int m_SkipCount;
        STR_HASH m_PasswordHash;
        wxVector<LPFFQ_STRING> *m_Strings;
        wxString m_Description, m_Temp, m_DateTimeFmt, m_BadStrID, m_LoadName, m_FFQVersion;

        void InitStringVars();
        void ValidateStrings();

};

//Macros for fast access
#define FFQDT() FFQLang::GetInstance()->GetDateTimeString()
#define FFQL() FFQLang::GetInstance()
#define FFQS(sid) FFQLang::GetInstance()->GetString(sid)
#define FFQSF(sid, ...) wxString::Format(FFQLang::GetInstance()->GetString(sid), __VA_ARGS__)

//Macro for comparing hashes
#define CMPHASH(h1, h2) (memcmp(h1, h2, sizeof(STR_HASH)) == 0)

#endif // FFQLANG_H
