/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jaudiotagger.audio.dff.BaseChunk;
import org.jaudiotagger.audio.dff.DffChunkType;
import org.jaudiotagger.audio.generic.Utils;

public class ChnlChunk
extends BaseChunk {
    private short numChannels;
    String[] IDs;

    public ChnlChunk(ByteBuffer dataBuffer) {
        super(dataBuffer);
    }

    @Override
    public void readDataChunch(FileChannel fc) throws IOException {
        super.readDataChunch(fc);
        ByteBuffer audioData = Utils.readFileDataIntoBufferLE(fc, 2);
        this.numChannels = Short.reverseBytes(audioData.getShort());
        this.IDs = new String[this.numChannels];
        for (int i = 0; i < this.numChannels; ++i) {
            audioData = Utils.readFileDataIntoBufferLE(fc, 4);
            this.IDs[i] = Utils.readFourBytesAsChars(audioData);
        }
        this.skipToChunkEnd(fc);
    }

    public Short getNumChannels() {
        return this.numChannels;
    }

    public String toString() {
        return DffChunkType.CHNL.getCode();
    }
}

