/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.jaudiotagger.audio.dff.BaseChunk;
import org.jaudiotagger.audio.dff.DffChunkType;
import org.jaudiotagger.audio.generic.Utils;

public class CmprChunk
extends BaseChunk {
    private String compression;
    private String description;

    public CmprChunk(ByteBuffer dataBuffer) {
        super(dataBuffer);
    }

    @Override
    public void readDataChunch(FileChannel fc) throws IOException {
        super.readDataChunch(fc);
        ByteBuffer audioData = Utils.readFileDataIntoBufferLE(fc, 4);
        this.compression = Utils.readFourBytesAsChars(audioData);
        audioData = Utils.readFileDataIntoBufferLE(fc, 1);
        byte b = audioData.get();
        int blen = b & 0xFF;
        audioData = Utils.readFileDataIntoBufferLE(fc, blen);
        byte[] buff = new byte[blen];
        audioData.get(buff);
        this.description = new String(buff, StandardCharsets.ISO_8859_1);
        this.skipToChunkEnd(fc);
    }

    public String getCompression() {
        return this.compression;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return DffChunkType.CMPR.getCode();
    }
}

