/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.aiff;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jaudiotagger.audio.iff.ChunkSummary;
import org.jaudiotagger.logging.Hex;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v22Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.id3.Id3SupportingTag;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.reference.ID3V2Version;

public class AiffTag
implements Tag,
Id3SupportingTag {
    private List<ChunkSummary> chunkSummaryList = new ArrayList<ChunkSummary>();
    private long fileSize;
    private long formSize;
    private boolean lastChunkSizeExtendsPastFormSize = false;
    private boolean isIncorrectlyAlignedTag = false;
    private boolean isExistingId3Tag = false;
    private AbstractID3v2Tag id3Tag;
    private String loggingFilename = "";

    public void addChunkSummary(ChunkSummary cs) {
        this.chunkSummaryList.add(cs);
    }

    public List<ChunkSummary> getChunkSummaryList() {
        return this.chunkSummaryList;
    }

    public boolean isExistingId3Tag() {
        return this.isExistingId3Tag;
    }

    public void setExistingId3Tag(boolean isExistingId3Tag) {
        this.isExistingId3Tag = isExistingId3Tag;
    }

    public AiffTag(String loggingFilename) {
        this.loggingFilename = loggingFilename;
    }

    public AiffTag() {
    }

    public AiffTag(AbstractID3v2Tag t) {
        this.id3Tag = t;
    }

    @Override
    public AbstractID3v2Tag getID3Tag() {
        return this.id3Tag;
    }

    @Override
    public void setID3Tag(AbstractID3v2Tag t) {
        this.id3Tag = t;
    }

    @Override
    public void addField(TagField field) throws FieldDataInvalidException {
        this.id3Tag.addField(field);
    }

    @Override
    public List<TagField> getFields(String id) {
        return this.id3Tag.getFields(id);
    }

    @Override
    public List<String> getAll(FieldKey genericKey) throws KeyNotFoundException {
        return this.id3Tag.getAll(genericKey);
    }

    @Override
    public boolean hasCommonFields() {
        return this.id3Tag.hasCommonFields();
    }

    @Override
    public boolean isEmpty() {
        return this.id3Tag == null || this.id3Tag.isEmpty();
    }

    @Override
    public void setField(FieldKey genericKey, String ... value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.setField(tagfield);
    }

    @Override
    public void addField(FieldKey genericKey, String ... value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.addField(tagfield);
    }

    @Override
    public void setField(TagField field) throws FieldDataInvalidException {
        this.id3Tag.setField(field);
    }

    @Override
    public TagField createField(FieldKey genericKey, String ... value) throws KeyNotFoundException, FieldDataInvalidException {
        return this.id3Tag.createField(genericKey, value);
    }

    @Override
    public String getFirst(String id) {
        return this.id3Tag.getFirst(id);
    }

    @Override
    public String getValue(FieldKey id, int index) throws KeyNotFoundException {
        return this.id3Tag.getValue(id, index);
    }

    @Override
    public String getFirst(FieldKey id) throws KeyNotFoundException {
        return this.getValue(id, 0);
    }

    @Override
    public TagField getFirstField(String id) {
        return this.id3Tag.getFirstField(id);
    }

    @Override
    public TagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return this.id3Tag.getFirstField(genericKey);
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        this.id3Tag.deleteField(fieldKey);
    }

    @Override
    public void deleteField(String id) throws KeyNotFoundException {
        this.id3Tag.deleteField(id);
    }

    @Override
    public Iterator<TagField> getFields() {
        return this.id3Tag.getFields();
    }

    @Override
    public int getFieldCount() {
        return this.id3Tag.getFieldCount();
    }

    @Override
    public int getFieldCountIncludingSubValues() {
        return this.getFieldCount();
    }

    @Override
    public boolean setEncoding(Charset enc) throws FieldDataInvalidException {
        return this.id3Tag.setEncoding(enc);
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        return this.id3Tag.createField(artwork);
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        this.id3Tag.setField(artwork);
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        this.id3Tag.addField(artwork);
    }

    @Override
    public List<Artwork> getArtworkList() {
        return this.id3Tag.getArtworkList();
    }

    @Override
    public List<TagField> getFields(FieldKey id) throws KeyNotFoundException {
        return this.id3Tag.getFields(id);
    }

    @Override
    public Artwork getFirstArtwork() {
        return this.id3Tag.getFirstArtwork();
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        this.id3Tag.deleteArtworkField();
    }

    @Override
    public boolean hasField(FieldKey genericKey) {
        return this.id3Tag.hasField(genericKey);
    }

    @Override
    public boolean hasField(String id) {
        return this.id3Tag.hasField(id);
    }

    @Override
    public TagField createCompilationField(boolean value) throws KeyNotFoundException, FieldDataInvalidException {
        return this.createField(FieldKey.IS_COMPILATION, String.valueOf(value));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileSize:" + Hex.asDecAndHex(this.fileSize) + "\n");
        sb.append("FORMSize:" + Hex.asDecAndHex(this.formSize + 8L) + "\n");
        if (this.lastChunkSizeExtendsPastFormSize) {
            sb.append("Last Chunk extends past Form stated size\n");
        } else if (this.fileSize > this.formSize + 8L) {
            sb.append("Non Iff Data at End of File:" + (this.fileSize - (this.formSize + 8L)) + " bytes\n");
        }
        sb.append("Chunks:\n");
        for (ChunkSummary cs : this.chunkSummaryList) {
            sb.append("\t" + cs.toString() + "\n");
        }
        if (this.id3Tag != null) {
            sb.append("Aiff ID3 Tag:\n");
            if (this.isExistingId3Tag()) {
                if (this.isIncorrectlyAlignedTag) {
                    sb.append("\tincorrectly starts as odd byte\n");
                }
                sb.append("\tstartLocation:" + Hex.asDecAndHex(this.getStartLocationInFileOfId3Chunk()) + "\n");
                sb.append("\tendLocation:" + Hex.asDecAndHex(this.getEndLocationInFileOfId3Chunk()) + "\n");
            }
            sb.append(this.id3Tag.toString() + "\n");
            return sb.toString();
        }
        return "tag:empty";
    }

    public long getSizeOfID3TagOnly() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.id3Tag.getEndLocationInFile() - this.id3Tag.getStartLocationInFile();
    }

    public long getSizeOfID3TagIncludingChunkHeader() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.getSizeOfID3TagOnly() + 8L;
    }

    public long getStartLocationInFileOfId3Chunk() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.id3Tag.getStartLocationInFile() - 8L;
    }

    public long getEndLocationInFileOfId3Chunk() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.id3Tag.getEndLocationInFile();
    }

    public boolean equals(Object obj) {
        return this.id3Tag.equals(obj);
    }

    public boolean isIncorrectlyAlignedTag() {
        return this.isIncorrectlyAlignedTag;
    }

    public void setIncorrectlyAlignedTag(boolean isIncorrectlyAlignedTag) {
        this.isIncorrectlyAlignedTag = isIncorrectlyAlignedTag;
    }

    public static AbstractID3v2Tag createDefaultID3Tag() {
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V24) {
            return new ID3v24Tag();
        }
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V23) {
            return new ID3v23Tag();
        }
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V22) {
            return new ID3v22Tag();
        }
        return new ID3v23Tag();
    }

    public long getFormSize() {
        return this.formSize;
    }

    public void setFormSize(long formSize) {
        this.formSize = formSize;
    }

    public boolean isLastChunkSizeExtendsPastFormSize() {
        return this.lastChunkSizeExtendsPastFormSize;
    }

    public void setLastChunkSizeExtendsPastFormSize(boolean lastChunkSizeExtendsPastFormSize) {
        this.lastChunkSizeExtendsPastFormSize = lastChunkSizeExtendsPastFormSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }
}

