/*
 * Created by Angel Leon (@gubatron), Alden Torres (aldenml),
 *            Grzesiek Rzaca (grzesiekrzaca)
 * Copyright (c) 2011-2017, FrostWire(R). All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.settings.ConnectionSettings;

import javax.swing.*;

public class VPNBitTorrentDisabledWarningLabel extends JLabel implements VPNStatusRefresher.VPNStatusListener {
    private boolean vpnIsOn;

    boolean shouldBeShown() {
        return ConnectionSettings.VPN_DROP_PROTECTION.getValue() && !vpnIsOn;
    }

    @Override
    public void onStatusUpdated(boolean vpnIsOn) {
        this.vpnIsOn = vpnIsOn;
    }
}
