// Copyright (c) 2025 Tulir Asokan
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

package main

import (
	"encoding/json"
	"fmt"
	"os"
	"strings"

	"go.mau.fi/util/exbytes"
	"go.mau.fi/util/exerrors"
	"go.mau.fi/util/exslices"
	"maunium.net/go/mautrix/event"

	"go.mau.fi/gomuks/pkg/hicli/cmdspec"
)

const typescriptTemplate = `// AUTOGENERATED by pkg/hicli/cmdspec/print; do not edit.

import type { BotCommandsEventContent } from "./mxtypes.ts"

export type CommandName =
	%s

export default BotCommandsEventContent
`

func main() {
	output := exerrors.Must(json.Marshal(&event.BotCommandsEventContent{
		Sigil:    "/",
		Commands: cmdspec.CommandDefinitions,
	}))
	if len(os.Args) > 1 && os.Args[1] != "-" {
		exerrors.PanicIfNotNil(os.WriteFile(os.Args[1], output, 0644))
		if len(os.Args) > 2 {
			cmdNames := strings.Join(exslices.CastFunc(cmdspec.CommandDefinitions, func(from *event.BotCommand) string {
				return fmt.Sprintf("%q", from.Syntax)
			}), "\n\t| ")

			exerrors.PanicIfNotNil(os.WriteFile(os.Args[2], []byte(fmt.Sprintf(typescriptTemplate, cmdNames)), 0644))
		}
	} else {
		fmt.Println(exbytes.UnsafeString(output))
	}
}
