/*
** memarena.h
**
**---------------------------------------------------------------------------
** Copyright 2010 Randy Heit
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
**
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 3. The name of the author may not be used to endorse or promote products
**    derived from this software without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
** INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
** NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
** THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**---------------------------------------------------------------------------
**
*/

#ifndef __MEMARENA_H
#define __MEMARENA_H

#include "zstring.h"

// A general purpose arena.
class FMemArena
{
public:
	FMemArena(size_t blocksize = 10*1024);
	~FMemArena();

	void *Alloc(size_t size);
	void FreeAll();
	void FreeAllBlocks();
	void DumpInfo();
	void DumpData(FILE *f);

protected:
	struct Block;

	Block *AddBlock(size_t size);
	void FreeBlockChain(Block *&top);
	void *iAlloc(size_t size);

	Block *TopBlock;
	Block *FreeBlocks;
	size_t BlockSize;
};

// An arena specializing in storage of FStrings. It knows how to free them,
// but this means it also should never be used for allocating anything else.
// Identical strings all return the same pointer.
class FSharedStringArena : public FMemArena
{
public:
	FSharedStringArena();
	~FSharedStringArena();
	void FreeAll();

	class FString *Alloc(const FString &source);
	class FString *Alloc(const char *source);
	class FString *Alloc(const char *source, size_t strlen);

protected:
	struct Node
	{
		Node *Next;
		FString String;
		unsigned int Hash;
	};
	Node *Buckets[256];

	Node *FindString(const char *str, size_t strlen, unsigned int &hash);
private:
	void *Alloc(size_t size) { return NULL; }	// No access to FMemArena::Alloc for outsiders.
};


#endif
