<img align="left" src="https://user-images.githubusercontent.com/28951144/190144379-364185ea-3e3e-4f41-87fd-9581acfc7f7f.png" width="64" height="64"></img>

<h1 align="left">Harmonoid</h1>

**🎵 Plays & manages your music library. Looks beautiful & juicy.**

[Website](https://harmonoid.com) • [Download](https://harmonoid.com/downloads) • [Discord](https://discord.gg/2Rc3edFWd8) • Available for Windows, Linux & Android!

![](https://github.com/harmonoid/harmonoid/blob/assets/windows/0.webp?raw=true)
![](https://github.com/harmonoid/harmonoid/blob/assets/windows/1.webp?raw=true)
![](https://github.com/harmonoid/harmonoid/blob/assets/windows/2.webp?raw=true)
![](https://github.com/harmonoid/harmonoid/blob/assets/windows/3.webp?raw=true)
![](https://github.com/harmonoid/harmonoid/blob/assets/windows/4.webp?raw=true)

## Videos

Enjoy that 🧈 buttery experience.

https://user-images.githubusercontent.com/28951144/180613629-942ae758-2179-48a8-825f-fc3e918aba0d.mp4

https://user-images.githubusercontent.com/28951144/180613641-baf7a246-08ba-496f-9952-7792a0117177.mp4

## Features

- Music library management based on metadata tags.
- Capable of indexing 30+ files/second & saves cache for future app start-ups.
- Very strictly follows Material Design guidelines for UI & animations.
- mpv based music playback for strong format support (on Linux & Windows) using `dart:ffi`.
- Taskbar & System Media Transport Controls for Windows.
- D-Bus MPRIS controls for Linux.
- Small installer (≈ 35 MB) & low RAM usage (≈ 150 MB).
- Time synced lyrics for all your music.
- Ability to create persistent or "Now playing" playlists.
- Context menu integrations & file associations (exclusive to setup version).
- Discord RPC integration with album art support & "Find"/"Listen" buttons.
- Portable (if you wish).
- Pitch shifting.
- Volume boost.
- Speed adjustment.
- Details editor.
- Cross-platform (currently aiming Windows, Linux & Android).
- Does not use electron.js.
- Music visuals.
- Metadata reader.
- Gapless playback.
- Multiple artist support.
- Online URLs player.
- .LRC file compatibility (mannual loading or automatic lookup in folder).
- Fallback cover support. e.g. `cover.jpg`, `Folder.jpg` etc.
- Built-in YouTube Music client.

## Why

It's really hard to find software with good design & animations on desktop. It's almost like desktop app developers don't have faith in adding animations to their UI. Other music players, which look kind-of good don't work properly, refuse to support an audio format, read tags incorrectly, don't have my favorite feature or simply use [electron.js](https://electronjs.org).

Harmonoid very strictly implements [Material Design](https://user-images.githubusercontent.com/28951144/187515841-265b2f6e-4ee3-4db5-b06d-0f7f5d684da9.webm) to be a consistent, cohesive & modern music player for all platforms.

There are no inconsistent paddings, spacings or weird alignments to make me feel uncomfortable. It's built with care & proper time is given to everything. Learn more about the project on [official website](https://harmonoid.com/) [until I can afford this domain].

## Supporters

### GitHub Sponsors

- [Taylor](https://github.com/tskinn) • 10$ per month.

### Patreons

- [Oleks](https://www.patreon.com/user/creators?u=28979760) • 5$ per month.
- [Benjamin Kranz](https://twitter.com/RisuDesign) • Checkout their [YouTube](https://www.youtube.com/c/RapidzDE)! • 5$ per month.
- [Mohammed Abutaki](https://www.patreon.com/user/creators?u=27366405) • 5$ per month.

## Support

If you enjoy using this music player, please consider buying me a coffee.

- [PayPal](https://paypal.me/alexmercerind)
- [Patreon](https://patreon.com/harmonoid)
- [GitHub Sponsors](https://github.com/sponsors/alexmercerind)

## Planned Features

- Folders view.
- Material You / Material Design 3 implementation.
- libmpv flags & IPC support.
- Window position & state save/restore.
- Genre tab.
- Third-party themes support.
- Equalizer.
- Music sensitive visualizers.
- macOS version (adaptation & dependencies-configuration).
- Mini-window mode.
- Minimization to system tray.
- Last.fm scrobbling.
- Plugin API.
- Windows 11 IExplorerCommand integration.
- Video playback & library management (???)
- Publishing to FlatHub, Microsoft Store & other places.
- Desktop app controller for Android.
- Cross-platform syncing & mutual playlist with friends (once we are mature).

## Mobile

<table>
  <tr>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/0.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/1.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/2.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/3.webp?raw=true'>
    </td>
  </tr>
  <tr>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/4.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/5.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/6.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/7.webp?raw=true'>
    </td>
  </tr>
</table>

## Translate

You can help me by adding or updating translations for Harmonoid at [harmonoid/translations](https://github.com/harmonoid/translations) repository.

## License

Harmonoid & the source code in this repository is under [End-User License Agreement for Harmonoid](https://github.com/harmonoid/harmonoid/blob/master/EULA.txt?raw=true).
