To add type safety to Electron's IPC system, we've made the following changes to what you'd usually see in an Electron app:

- Since `contextIsolation` is turned on, you cannot simply use `ipcRenderer.send`/`ipcRenderer.invoke` in the frontend to make IPC calls to the backend. Instead, we define a helper function for each IPC channel in `src/backend/api/`, which will be injected into the frontend on load. It'll then be available as `window.api.yourFunction`. See [Context Isolation](https://www.electronjs.org/docs/latest/tutorial/context-isolation) for more details
- To make sure that the parameters passed to & value returned from the callback of an `ipcMain.on`/`ipcMain.handle` call are correct, every IPC channel has to be defined in `src/common/typedefs/ipcBridge.d.ts` (adding new channels either to `SyncIPCFunctions` or `AsyncIPCFunctions`). This will also result in your callback's parameters automatically getting type annotations, and your helper function in `src/backend/api/` getting type-checked as well
