/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.Serializable;
import java.util.Arrays;
import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;
import org.ejml.data.ReshapeMatrix;

public class DenseD2Matrix64F
implements Serializable,
ReshapeMatrix,
DMatrix {
    public double[][] data;
    public int numRows;
    public int numCols;

    public DenseD2Matrix64F(int numRows, int numCols) {
        this.data = new double[numRows][numCols];
        this.numRows = numRows;
        this.numCols = numCols;
    }

    public void reshape(int numRows, int numCols) {
        if (numRows > this.data.length) {
            throw new IllegalArgumentException("Requested number of rows is too great.");
        }
        this.numRows = numRows;
        if (numCols > this.data[0].length) {
            throw new IllegalArgumentException("Requested number of columns is too great.");
        }
        this.numCols = numCols;
    }

    public void zero() {
        for (int i = 0; i < this.numRows; ++i) {
            Arrays.fill(this.data[i], 0, this.numCols, 0.0);
        }
    }

    public double get(int row, int col) {
        return this.data[row][col];
    }

    public void set(int row, int col, double val) {
        this.data[row][col] = val;
    }

    public double unsafe_get(int row, int col) {
        return this.get(row, col);
    }

    public void unsafe_set(int row, int col, double val) {
        this.set(row, col, val);
    }

    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public void print() {
    }

    public void print(String format) {
    }

    public <T extends Matrix> T copy() {
        throw new RuntimeException("Not supported");
    }

    public DenseD2Matrix64F createLike() {
        return new DenseD2Matrix64F(this.numRows, this.numCols);
    }

    public DenseD2Matrix64F create(int numRows, int numCols) {
        return new DenseD2Matrix64F(numRows, numCols);
    }

    public void set(Matrix original) {
        throw new RuntimeException("Not yet supported");
    }

    public MatrixType getType() {
        return MatrixType.UNSPECIFIED;
    }
}

