/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition.svd;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.decomposition.bidiagonal.BidiagonalDecompositionRow_DDRM;
import org.ejml.dense.row.decomposition.svd.SvdImplicitQrAlgorithmSmart;
import org.ejml.dense.row.decomposition.svd.implicitqr.SvdImplicitQrAlgorithm_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.jetbrains.annotations.Nullable;

public class SvdImplicitQrDecompose_UltimateS
implements SingularValueDecomposition_F64<DMatrixRMaj> {
    private int numRows;
    private int numCols;
    private int smallSide;
    private BidiagonalDecompositionRow_DDRM bidiag = new BidiagonalDecompositionRow_DDRM();
    private SvdImplicitQrAlgorithm_DDRM qralg = new SvdImplicitQrAlgorithmSmart();
    private double[] diag;
    private double[] off;
    private DMatrixRMaj Ut;
    private DMatrixRMaj Vt;
    private double[] singularValues;
    private int numSingular;
    private boolean compact;
    private boolean computeU;
    private boolean computeV;
    private boolean prefComputeU;
    private boolean prefComputeV;
    private double[] diagOld;
    private double[] offOld;
    private DMatrixRMaj A_mod = new DMatrixRMaj(1, 1);

    public SvdImplicitQrDecompose_UltimateS(boolean compact, boolean computeU, boolean computeV) {
        this.compact = compact;
        this.prefComputeU = computeU;
        this.prefComputeV = computeV;
    }

    public double[] getSingularValues() {
        return this.singularValues;
    }

    public int numberOfSingularValues() {
        return this.numSingular;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public DMatrixRMaj getU(@Nullable DMatrixRMaj U, boolean transpose) {
        if (!this.prefComputeU) {
            throw new IllegalArgumentException("As requested U was not computed.");
        }
        if (transpose) {
            return this.Ut;
        }
        U = new DMatrixRMaj(this.Ut.numCols, this.Ut.numRows);
        CommonOps_DDRM.transpose((DMatrixRMaj)this.Ut, (DMatrixRMaj)U);
        return U;
    }

    public DMatrixRMaj getV(@Nullable DMatrixRMaj V, boolean transpose) {
        if (!this.prefComputeV) {
            throw new IllegalArgumentException("As requested V was not computed.");
        }
        if (transpose) {
            return this.Vt;
        }
        V = new DMatrixRMaj(this.Vt.numCols, this.Vt.numRows);
        CommonOps_DDRM.transpose((DMatrixRMaj)this.Vt, (DMatrixRMaj)V);
        return V;
    }

    public DMatrixRMaj getW(@Nullable DMatrixRMaj W) {
        int n;
        int m = this.compact ? this.numSingular : this.numRows;
        int n2 = n = this.compact ? this.numSingular : this.numCols;
        if (W == null) {
            W = new DMatrixRMaj(m, n);
        } else {
            W.reshape(m, n, false);
            W.zero();
        }
        for (int i = 0; i < this.numSingular; ++i) {
            W.data[i * W.numCols + i] = this.singularValues[i];
        }
        return W;
    }

    public boolean decompose(DMatrixRMaj orig) {
        boolean transposed = orig.numCols > orig.numRows;
        this.init(orig, transposed);
        if (this.computeSingularValues(orig, transposed)) {
            return false;
        }
        if ((this.computeU || this.computeV) && this.computeUandV(transposed)) {
            return false;
        }
        this.makeSingularPositive();
        return true;
    }

    public boolean inputModified() {
        return false;
    }

    private void init(DMatrixRMaj orig, boolean transposed) {
        if (transposed) {
            this.computeU = this.prefComputeV;
            this.computeV = this.prefComputeU;
        } else {
            this.computeU = this.prefComputeU;
            this.computeV = this.prefComputeV;
        }
        this.numRows = orig.numRows;
        this.numCols = orig.numCols;
        this.smallSide = Math.min(this.numRows, this.numCols);
        if (this.diagOld == null || this.diagOld.length < this.smallSide) {
            this.diagOld = new double[this.smallSide];
            this.offOld = new double[this.smallSide - 1];
            this.diag = new double[this.smallSide];
            this.off = new double[this.smallSide - 1];
        }
    }

    private boolean computeUandV(boolean transposed) {
        long pointA = System.currentTimeMillis();
        if (this.computeU) {
            this.Ut = this.bidiag.getU(this.Ut, true, this.compact);
        }
        if (this.computeV) {
            this.Vt = this.bidiag.getV(this.Vt, true, this.compact);
        }
        if (transposed) {
            this.qralg.initParam(this.numCols, this.numRows);
        } else {
            this.qralg.initParam(this.numRows, this.numCols);
        }
        this.diagOld = this.qralg.swapDiag(this.diagOld);
        this.offOld = this.qralg.swapOff(this.offOld);
        this.qralg.setFastValues(false);
        if (this.computeU) {
            this.qralg.setUt(this.Ut);
        }
        if (this.computeV) {
            this.qralg.setVt(this.Vt);
        }
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.Ut);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.Vt);
        long pointB = System.currentTimeMillis();
        if (!this.qralg.process(this.diagOld)) {
            return true;
        }
        long pointC = System.currentTimeMillis();
        System.out.println("  bidiag UV " + (pointB - pointA) + " qr UV " + (pointC - pointB));
        if (transposed) {
            DMatrixRMaj temp = this.Vt;
            this.Vt = this.Ut;
            this.Ut = temp;
        }
        return false;
    }

    private boolean computeSingularValues(DMatrixRMaj orig, boolean transposed) {
        long pointA = System.currentTimeMillis();
        if (this.bidiagonalization(orig, transposed)) {
            return false;
        }
        long pointB = System.currentTimeMillis();
        this.bidiag.getDiagonal(this.diag, this.off);
        this.qralg.setMatrix(this.numRows, this.numCols, this.diag, this.off);
        System.arraycopy(this.diag, 0, this.diagOld, 0, this.smallSide);
        System.arraycopy(this.off, 0, this.offOld, 0, this.smallSide - 1);
        this.qralg.setFastValues(true);
        this.qralg.setUt(null);
        this.qralg.setVt(null);
        boolean ret = !this.qralg.process();
        long pointC = System.currentTimeMillis();
        System.out.println("  bidiag " + (pointB - pointA) + " qr W " + (pointC - pointB));
        return ret;
    }

    private boolean bidiagonalization(DMatrixRMaj orig, boolean transposed) {
        if (transposed) {
            this.A_mod.reshape(orig.numCols, orig.numRows, false);
            CommonOps_DDRM.transpose((DMatrixRMaj)orig, (DMatrixRMaj)this.A_mod);
        } else {
            this.A_mod.reshape(orig.numRows, orig.numCols, false);
            this.A_mod.set((DMatrixD1)orig);
        }
        return !this.bidiag.decompose(this.A_mod);
    }

    private void makeSingularPositive() {
        this.numSingular = this.qralg.getNumberOfSingularValues();
        this.singularValues = this.qralg.getSingularValues();
        for (int i = 0; i < this.numSingular; ++i) {
            double val = this.singularValues[i];
            if (!(val < 0.0)) continue;
            this.singularValues[i] = -val;
            if (!this.computeU) continue;
            int start = i * this.Ut.numCols;
            int stop = start + this.Ut.numCols;
            for (int j = start; j < stop; ++j) {
                this.Ut.data[j] = -this.Ut.data[j];
            }
        }
    }

    public int numRows() {
        return this.numRows;
    }

    public int numCols() {
        return this.numCols;
    }
}

