// lxmed - LXDE Main Menu Editor
// Copyright (C) 2011  Marko Čičak
//
// This file is part of lxmed.
//
// lxmed is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// lxmed is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with lxmed.  If not, see <http://www.gnu.org/licenses/>.
package net.sourceforge.lxmed.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;
import net.sourceforge.lxmed.model.MenuItem;
import net.sourceforge.lxmed.persistence.ModelLoader;

/**
 * Dialog for manualy editing menu item's code.
 *
 * @author <a href="mailto:cicakmarko@yahoo.com">Marko Čičak</a>
 */
public class CodeEditDialog extends javax.swing.JDialog {

    /**
     * Menu item to edit.
     */
    private MenuItem mi;
    /**
     * Menu item dialog which is a parent for this dialog.
     */
    private MenuItemDialog mid;
    /**
     * Menu item's editable state.
     */
    boolean editable = true;

    /**
     * Creates new form CodeEditDialog.
     *
     * @param parent parent frame
     * @param mi menu item to edit
     * @param editable menu item's editable state
     * @param mid menu item dialog from whom is this dialog called
     */
    public CodeEditDialog(java.awt.Frame parent, MenuItem mi, boolean editable, MenuItemDialog mid) {
        super(parent, true);
        this.mi = mi;
        this.editable = editable;
        this.mid = mid;

        setTitle("Original desktop code");

        initComponents();
        setLocationRelativeTo(null);

        lblTitle.setText("Original code for " + mi.getName());
        txtCode.setText(mi.getDesktopCode());


        if (!editable) {
            setReadOnly();
        }

        // close on Esc
        this.getRootPane().getActionMap().put("close", new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                btnCancelActionPerformed(e);
            }
        });
        InputMap map = this.getRootPane().getInputMap(
                JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        map.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "close");
    }

    /**
     * Sets a readonly status for menu item. Disables text editing and transforms
     * Ok button to Close button.
     */
    private void setReadOnly() {
        txtCode.setEditable(false);
        btnCancel.setVisible(false);
        btnOk.setText("Close");
        btnOk.setMnemonic('c');
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblTitle = new JLabel();
        btnOk = new JButton();
        btnCancel = new JButton();
        spCode = new JScrollPane();
        txtCode = new JTextArea();

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

        lblTitle.setDisplayedMnemonic('r');
        lblTitle.setFont(lblTitle.getFont().deriveFont(lblTitle.getFont().getStyle() | Font.BOLD, lblTitle.getFont().getSize()-1));
        lblTitle.setText("lblTitle");

        btnOk.setFont(btnOk.getFont().deriveFont(btnOk.getFont().getStyle() & ~Font.BOLD, btnOk.getFont().getSize()-1));
        btnOk.setIcon(new ImageIcon(getClass().getResource("/net/sourceforge/lxmed/images/dialogs/ok.png"))); // NOI18N
        btnOk.setMnemonic('o');
        btnOk.setText("Ok");
        btnOk.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                btnOkActionPerformed(evt);
            }
        });

        btnCancel.setFont(btnCancel.getFont().deriveFont(btnCancel.getFont().getStyle() & ~Font.BOLD, btnCancel.getFont().getSize()-1));
        btnCancel.setIcon(new ImageIcon(getClass().getResource("/net/sourceforge/lxmed/images/dialogs/cancel.png"))); // NOI18N
        btnCancel.setMnemonic('c');
        btnCancel.setText("Cancel");
        btnCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });

        txtCode.setColumns(20);
        txtCode.setFont(new Font("Monospaced", 0, 13));
        txtCode.setRows(5);
        spCode.setViewportView(txtCode);

        GroupLayout layout = new GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(Alignment.LEADING)
                    .addComponent(spCode, GroupLayout.DEFAULT_SIZE, 576, Short.MAX_VALUE)
                    .addComponent(lblTitle)
                    .addGroup(Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(btnCancel)
                        .addPreferredGap(ComponentPlacement.RELATED, 392, Short.MAX_VALUE)
                        .addComponent(btnOk)))
                .addContainerGap())
        );

        layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {btnCancel, btnOk});

        layout.setVerticalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblTitle)
                .addGap(18, 18, 18)
                .addComponent(spCode, GroupLayout.DEFAULT_SIZE, 266, Short.MAX_VALUE)
                .addPreferredGap(ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(Alignment.BASELINE)
                    .addComponent(btnOk)
                    .addComponent(btnCancel))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnCancelActionPerformed(ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed
        dispose();
    }//GEN-LAST:event_btnCancelActionPerformed

    private void btnOkActionPerformed(ActionEvent evt) {//GEN-FIRST:event_btnOkActionPerformed
        if (!editable) {
            mid = null;
            dispose();
            return;
        }

        MenuItem newMenuItem = ModelLoader.loadData(txtCode.getText());
        newMenuItem.setReadOnly(false);
        mid.getMenuItem().cloneData(newMenuItem);
        mid.updateGui();

        mid = null;

        dispose();
    }//GEN-LAST:event_btnOkActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JButton btnCancel;
    private JButton btnOk;
    private JLabel lblTitle;
    private JScrollPane spCode;
    private JTextArea txtCode;
    // End of variables declaration//GEN-END:variables
}
