#include "Helpers.hpp"
#include <MellowPlayer/Domain/Player/IPlayer.hpp>
#include <QDebug>
#include <QtCore/QFile>

using namespace MellowPlayer::Domain;

QMap<QString, QVariant> getSongVariantMap(QString title, QString uniqueId, bool playing, QString artist)
{
    QVariantMap map;
    map["position"] = 1.0;
    map["playbackStatus"] = static_cast<int>(playing ? PlaybackStatus::Playing : PlaybackStatus::Paused);
    map["canSeek"] = true;
    map["canGoNext"] = true;
    map["canGoPrevious"] = true;
    map["canAddToFavorites"] = true;
    map["songId"] = uniqueId;
    map["songTitle"] = title;
    map["artistName"] = artist;
    map["albumTitle"] = "albumTitle";
    map["artUrl"] = "artUrl";
    map["isFavorite"] = true;
    map["volume"] = 0.5;
    map["duration"] = 350.0;
    return map;
}

QString readFile(const QString& path)
{
    QFile file(path);

    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return "";

    QTextStream in(&file);
    return in.readAll();
}

bool writeFile(const QString& path, const QString& content)
{
    QFile file(path);

    if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
        return false;

    qDebug() << "Writing file: " << path;

    QTextStream stream(&file);
    stream << content;
    return true;
}

QByteArray getValidReplyData()
{
    static const QByteArray validReplyData = {"[\n"
                                              "  {\n"
                                              "    \"url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "7051822\",\n"
                                              "    \"assets_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "7051822/assets\",\n"
                                              "    \"upload_url\": "
                                              "\"https://uploads.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "7051822/assets{?name,label}\",\n"
                                              "    \"html_url\": "
                                              "\"https://github.com/ColinDuquesnoy/MellowPlayer/releases/tag/"
                                              "Continuous\",\n"
                                              "    \"id\": 7051822,\n"
                                              "    \"tag_name\": \"Continuous\",\n"
                                              "    \"target_commitish\": "
                                              "\"515349c6e2e76a58ea9cf78d17c9a63dc524cfdb\",\n"
                                              "    \"name\": \"Continuous\",\n"
                                              "    \"draft\": false,\n"
                                              "    \"author\": {\n"
                                              "      \"login\": \"ColinDuquesnoy\",\n"
                                              "      \"id\": 1681217,\n"
                                              "      \"avatar_url\": "
                                              "\"https://avatars6.githubusercontent.com/u/1681217?v=4\",\n"
                                              "      \"gravatar_id\": \"\",\n"
                                              "      \"url\": \"https://api.github.com/users/ColinDuquesnoy\",\n"
                                              "      \"html_url\": \"https://github.com/ColinDuquesnoy\",\n"
                                              "      \"followers_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/followers\",\n"
                                              "      \"following_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/following{/"
                                              "other_user}\",\n"
                                              "      \"gists_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/gists{/gist_id}\",\n"
                                              "      \"starred_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/starred{/owner}{/"
                                              "repo}\",\n"
                                              "      \"subscriptions_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/subscriptions\",\n"
                                              "      \"organizations_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/orgs\",\n"
                                              "      \"repos_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/repos\",\n"
                                              "      \"events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/events{/privacy}\",\n"
                                              "      \"received_events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/received_events\",\n"
                                              "      \"type\": \"User\",\n"
                                              "      \"site_admin\": false\n"
                                              "    },\n"
                                              "    \"prerelease\": true,\n"
                                              "    \"created_at\": \"2017-07-15T00:59:35Z\",\n"
                                              "    \"published_at\": \"2017-07-15T10:09:58Z\",\n"
                                              "    \"assets\": [\n"
                                              "      {\n"
                                              "        \"url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "assets/4334926\",\n"
                                              "        \"id\": 4334926,\n"
                                              "        \"name\": _\"MellowPlayer-x8664.AppImage\",\n"
                                              "        \"label\": \"\",\n"
                                              "        \"uploader\": {\n"
                                              "          \"login\": \"ColinDuquesnoy\",\n"
                                              "          \"id\": 1681217,\n"
                                              "          \"avatar_url\": "
                                              "\"https://avatars6.githubusercontent.com/u/1681217?v=4\",\n"
                                              "          \"gravatar_id\": \"\",\n"
                                              "          \"url\": \"https://api.github.com/users/ColinDuquesnoy\",\n"
                                              "          \"html_url\": \"https://github.com/ColinDuquesnoy\",\n"
                                              "          \"followers_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/followers\",\n"
                                              "          \"following_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/following{/"
                                              "other_user}\",\n"
                                              "          \"gists_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/gists{/gist_id}\",\n"
                                              "          \"starred_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/starred{/owner}{/"
                                              "repo}\",\n"
                                              "          \"subscriptions_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/subscriptions\",\n"
                                              "          \"organizations_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/orgs\",\n"
                                              "          \"repos_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/repos\",\n"
                                              "          \"events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/events{/privacy}\",\n"
                                              "          \"received_events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/received_events\",\n"
                                              "          \"type\": \"User\",\n"
                                              "          \"site_admin\": false\n"
                                              "        },\n"
                                              "        \"content_type\": \"application/json\",\n"
                                              "        \"state\": \"uploaded\",\n"
                                              "        \"size\": 88292184,\n"
                                              "        \"download_count\": 0,\n"
                                              "        \"created_at\": \"2017-07-15T10:09:58Z\",\n"
                                              "        \"updated_at\": \"2017-07-15T10:10:01Z\",\n"
                                              "        \"browser_download_url\": "
                                              "\"https://github.com/ColinDuquesnoy/MellowPlayer/releases/download/"
                                              "Continuous/MellowPlayer-x86_64.AppImage\"\n"
                                              "      },\n"
                                              "      {\n"
                                              "        \"url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "assets/4334931\",\n"
                                              "        \"id\": 4334931,\n"
                                              "        \"name\": \"MellowPlayer.dmg\",\n"
                                              "        \"label\": \"\",\n"
                                              "        \"uploader\": {\n"
                                              "          \"login\": \"ColinDuquesnoy\",\n"
                                              "          \"id\": 1681217,\n"
                                              "          \"avatar_url\": "
                                              "\"https://avatars6.githubusercontent.com/u/1681217?v=4\",\n"
                                              "          \"gravatar_id\": \"\",\n"
                                              "          \"url\": \"https://api.github.com/users/ColinDuquesnoy\",\n"
                                              "          \"html_url\": \"https://github.com/ColinDuquesnoy\",\n"
                                              "          \"followers_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/followers\",\n"
                                              "          \"following_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/following{/"
                                              "other_user}\",\n"
                                              "          \"gists_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/gists{/gist_id}\",\n"
                                              "          \"starred_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/starred{/owner}{/"
                                              "repo}\",\n"
                                              "          \"subscriptions_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/subscriptions\",\n"
                                              "          \"organizations_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/orgs\",\n"
                                              "          \"repos_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/repos\",\n"
                                              "          \"events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/events{/privacy}\",\n"
                                              "          \"received_events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/received_events\",\n"
                                              "          \"type\": \"User\",\n"
                                              "          \"site_admin\": false\n"
                                              "        },\n"
                                              "        \"content_type\": \"application/json\",\n"
                                              "        \"state\": \"uploaded\",\n"
                                              "        \"size\": 80175504,\n"
                                              "        \"download_count\": 0,\n"
                                              "        \"created_at\": \"2017-07-15T10:13:28Z\",\n"
                                              "        \"updated_at\": \"2017-07-15T10:13:33Z\",\n"
                                              "        \"browser_download_url\": "
                                              "\"https://github.com/ColinDuquesnoy/MellowPlayer/releases/download/"
                                              "Continuous/MellowPlayer.dmg\"\n"
                                              "      },\n"
                                              "      {\n"
                                              "        \"url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "assets/4334940\",\n"
                                              "        \"id\": 4334940,\n"
                                              "        \"name\": _\"MellowPlayerSetup.exe\",\n"
                                              "        \"label\": \"\",\n"
                                              "        \"uploader\": {\n"
                                              "          \"login\": \"ColinDuquesnoy\",\n"
                                              "          \"id\": 1681217,\n"
                                              "          \"avatar_url\": "
                                              "\"https://avatars6.githubusercontent.com/u/1681217?v=4\",\n"
                                              "          \"gravatar_id\": \"\",\n"
                                              "          \"url\": \"https://api.github.com/users/ColinDuquesnoy\",\n"
                                              "          \"html_url\": \"https://github.com/ColinDuquesnoy\",\n"
                                              "          \"followers_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/followers\",\n"
                                              "          \"following_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/following{/"
                                              "other_user}\",\n"
                                              "          \"gists_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/gists{/gist_id}\",\n"
                                              "          \"starred_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/starred{/owner}{/"
                                              "repo}\",\n"
                                              "          \"subscriptions_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/subscriptions\",\n"
                                              "          \"organizations_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/orgs\",\n"
                                              "          \"repos_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/repos\",\n"
                                              "          \"events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/events{/privacy}\",\n"
                                              "          \"received_events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/received_events\",\n"
                                              "          \"type\": \"User\",\n"
                                              "          \"site_admin\": false\n"
                                              "        },\n"
                                              "        \"content_type\": \"application/json\",\n"
                                              "        \"state\": \"uploaded\",\n"
                                              "        \"size\": 63181390,\n"
                                              "        \"download_count\": 0,\n"
                                              "        \"created_at\": \"2017-07-15T10:17:54Z\",\n"
                                              "        \"updated_at\": \"2017-07-15T10:17:56Z\",\n"
                                              "        \"browser_download_url\": "
                                              "\"https://github.com/ColinDuquesnoy/MellowPlayer/releases/download/"
                                              "Continuous/MellowPlayer_Setup.exe\"\n"
                                              "      }\n"
                                              "    ],\n"
                                              "    \"tarball_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/tarball/"
                                              "Continuous\",\n"
                                              "    \"zipball_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/zipball/"
                                              "Continuous\",\n"
                                              "    \"body\": \"## Description\\n\\nThis release contains the artifacts "
                                              "of a continuous build.\\n\\n**While this is not an official release, "
                                              "this build is considered stable as all unit tests and integration tests "
                                              "passed. Use it if you want to try the latest features!**\\n\\n\\nTravis "
                                              "CI build log: "
                                              "https://travis-ci.org/ColinDuquesnoy/MellowPlayer/builds/253886375/\"\n"
                                              "  },\n"
                                              "  {\n"
                                              "    \"url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "6823484\",\n"
                                              "    \"assets_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "6823484/assets\",\n"
                                              "    \"upload_url\": "
                                              "\"https://uploads.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "6823484/assets{?name,label}\",\n"
                                              "    \"html_url\": "
                                              "\"https://github.com/ColinDuquesnoy/MellowPlayer/releases/tag/"
                                              "2.95.0\",\n"
                                              "    \"id\": 6823484,\n"
                                              "    \"tag_name\": \"2.95.0\",\n"
                                              "    \"target_commitish\": \"develop\",\n"
                                              "    \"name\": \"2.95.0\",\n"
                                              "    \"draft\": false,\n"
                                              "    \"author\": {\n"
                                              "      \"login\": \"ColinDuquesnoy\",\n"
                                              "      \"id\": 1681217,\n"
                                              "      \"avatar_url\": "
                                              "\"https://avatars6.githubusercontent.com/u/1681217?v=4\",\n"
                                              "      \"gravatar_id\": \"\",\n"
                                              "      \"url\": \"https://api.github.com/users/ColinDuquesnoy\",\n"
                                              "      \"html_url\": \"https://github.com/ColinDuquesnoy\",\n"
                                              "      \"followers_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/followers\",\n"
                                              "      \"following_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/following{/"
                                              "other_user}\",\n"
                                              "      \"gists_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/gists{/gist_id}\",\n"
                                              "      \"starred_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/starred{/owner}{/"
                                              "repo}\",\n"
                                              "      \"subscriptions_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/subscriptions\",\n"
                                              "      \"organizations_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/orgs\",\n"
                                              "      \"repos_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/repos\",\n"
                                              "      \"events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/events{/privacy}\",\n"
                                              "      \"received_events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/received_events\",\n"
                                              "      \"type\": \"User\",\n"
                                              "      \"site_admin\": false\n"
                                              "    },\n"
                                              "    \"prerelease\": true,\n"
                                              "    \"created_at\": \"2017-06-24T09:48:13Z\",\n"
                                              "    \"published_at\": \"2017-06-24T09:52:36Z\",\n"
                                              "    \"assets\": [\n"
                                              "      {\n"
                                              "        \"url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "assets/4174285\",\n"
                                              "        \"id\": 4174285,\n"
                                              "        \"name\": _\"MellowPlayer-x8664.AppImage\",\n"
                                              "        \"label\": \"\",\n"
                                              "        \"uploader\": {\n"
                                              "          \"login\": \"ColinDuquesnoy\",\n"
                                              "          \"id\": 1681217,\n"
                                              "          \"avatar_url\": "
                                              "\"https://avatars6.githubusercontent.com/u/1681217?v=4\",\n"
                                              "          \"gravatar_id\": \"\",\n"
                                              "          \"url\": \"https://api.github.com/users/ColinDuquesnoy\",\n"
                                              "          \"html_url\": \"https://github.com/ColinDuquesnoy\",\n"
                                              "          \"followers_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/followers\",\n"
                                              "          \"following_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/following{/"
                                              "other_user}\",\n"
                                              "          \"gists_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/gists{/gist_id}\",\n"
                                              "          \"starred_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/starred{/owner}{/"
                                              "repo}\",\n"
                                              "          \"subscriptions_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/subscriptions\",\n"
                                              "          \"organizations_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/orgs\",\n"
                                              "          \"repos_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/repos\",\n"
                                              "          \"events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/events{/privacy}\",\n"
                                              "          \"received_events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/received_events\",\n"
                                              "          \"type\": \"User\",\n"
                                              "          \"site_admin\": false\n"
                                              "        },\n"
                                              "        \"content_type\": \"application/json\",\n"
                                              "        \"state\": \"uploaded\",\n"
                                              "        \"size\": 87144984,\n"
                                              "        \"download_count\": 43,\n"
                                              "        \"created_at\": \"2017-06-24T10:04:05Z\",\n"
                                              "        \"updated_at\": \"2017-06-24T10:04:09Z\",\n"
                                              "        \"browser_download_url\": "
                                              "\"https://github.com/ColinDuquesnoy/MellowPlayer/releases/download/"
                                              "2.95.0/MellowPlayer-x86_64.AppImage\"\n"
                                              "      },\n"
                                              "      {\n"
                                              "        \"url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "assets/4174301\",\n"
                                              "        \"id\": 4174301,\n"
                                              "        \"name\": \"MellowPlayer.dmg\",\n"
                                              "        \"label\": \"\",\n"
                                              "        \"uploader\": {\n"
                                              "          \"login\": \"ColinDuquesnoy\",\n"
                                              "          \"id\": 1681217,\n"
                                              "          \"avatar_url\": "
                                              "\"https://avatars6.githubusercontent.com/u/1681217?v=4\",\n"
                                              "          \"gravatar_id\": \"\",\n"
                                              "          \"url\": \"https://api.github.com/users/ColinDuquesnoy\",\n"
                                              "          \"html_url\": \"https://github.com/ColinDuquesnoy\",\n"
                                              "          \"followers_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/followers\",\n"
                                              "          \"following_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/following{/"
                                              "other_user}\",\n"
                                              "          \"gists_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/gists{/gist_id}\",\n"
                                              "          \"starred_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/starred{/owner}{/"
                                              "repo}\",\n"
                                              "          \"subscriptions_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/subscriptions\",\n"
                                              "          \"organizations_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/orgs\",\n"
                                              "          \"repos_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/repos\",\n"
                                              "          \"events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/events{/privacy}\",\n"
                                              "          \"received_events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/received_events\",\n"
                                              "          \"type\": \"User\",\n"
                                              "          \"site_admin\": false\n"
                                              "        },\n"
                                              "        \"content_type\": \"application/json\",\n"
                                              "        \"state\": \"uploaded\",\n"
                                              "        \"size\": 80780649,\n"
                                              "        \"download_count\": 6,\n"
                                              "        \"created_at\": \"2017-06-24T10:16:45Z\",\n"
                                              "        \"updated_at\": \"2017-06-24T10:16:50Z\",\n"
                                              "        \"browser_download_url\": "
                                              "\"https://github.com/ColinDuquesnoy/MellowPlayer/releases/download/"
                                              "2.95.0/MellowPlayer.dmg\"\n"
                                              "      },\n"
                                              "      {\n"
                                              "        \"url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "assets/4174296\",\n"
                                              "        \"id\": 4174296,\n"
                                              "        \"name\": _\"MellowPlayerSetup.exe\",\n"
                                              "        \"label\": \"\",\n"
                                              "        \"uploader\": {\n"
                                              "          \"login\": \"ColinDuquesnoy\",\n"
                                              "          \"id\": 1681217,\n"
                                              "          \"avatar_url\": "
                                              "\"https://avatars6.githubusercontent.com/u/1681217?v=4\",\n"
                                              "          \"gravatar_id\": \"\",\n"
                                              "          \"url\": \"https://api.github.com/users/ColinDuquesnoy\",\n"
                                              "          \"html_url\": \"https://github.com/ColinDuquesnoy\",\n"
                                              "          \"followers_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/followers\",\n"
                                              "          \"following_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/following{/"
                                              "other_user}\",\n"
                                              "          \"gists_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/gists{/gist_id}\",\n"
                                              "          \"starred_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/starred{/owner}{/"
                                              "repo}\",\n"
                                              "          \"subscriptions_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/subscriptions\",\n"
                                              "          \"organizations_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/orgs\",\n"
                                              "          \"repos_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/repos\",\n"
                                              "          \"events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/events{/privacy}\",\n"
                                              "          \"received_events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/received_events\",\n"
                                              "          \"type\": \"User\",\n"
                                              "          \"site_admin\": false\n"
                                              "        },\n"
                                              "        \"content_type\": \"application/json\",\n"
                                              "        \"state\": \"uploaded\",\n"
                                              "        \"size\": 63107117,\n"
                                              "        \"download_count\": 12,\n"
                                              "        \"created_at\": \"2017-06-24T10:10:26Z\",\n"
                                              "        \"updated_at\": \"2017-06-24T10:10:31Z\",\n"
                                              "        \"browser_download_url\": "
                                              "\"https://github.com/ColinDuquesnoy/MellowPlayer/releases/download/"
                                              "2.95.0/MellowPlayer_Setup.exe\"\n"
                                              "      }\n"
                                              "    ],\n"
                                              "    \"tarball_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/tarball/"
                                              "2.95.0\",\n"
                                              "    \"zipball_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/zipball/"
                                              "2.95.0\",\n"
                                              "    \"body\": \"## MellowPlayer 3 Beta Version\\r\\n\\r\\n### New "
                                              "features\\r\\n\\r\\n- ported to QML + Material Design theme\\r\\n- "
                                              "adaptive theme that follows the theme of the currently running "
                                              "streaming service\\r\\n- fast switching between running services "
                                              "(Ctrl+Tab/Ctrl+Shift+Tab)\\r\\n- optional listening history, disabled "
                                              "by default\\r\\n- added a button to quickly turn off/on "
                                              "notifications\\r\\n- added support for self hosted "
                                              "services\\r\\n\\r\\n### Planned features:\\r\\n\\r\\nSee the [list of "
                                              "features](https://github.com/ColinDuquesnoy/MellowPlayer/"
                                              "issues?q=is%3Aopen+is%3Aissue+milestone%3A3.0+label%3Afeature) we plan "
                                              "to get into the final 3.0 release.\\r\\n\\r\\n\"\n"
                                              "  },\n"
                                              "  {\n"
                                              "    \"url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "6746800\",\n"
                                              "    \"assets_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "6746800/assets\",\n"
                                              "    \"upload_url\": "
                                              "\"https://uploads.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "6746800/assets{?name,label}\",\n"
                                              "    \"html_url\": "
                                              "\"https://github.com/ColinDuquesnoy/MellowPlayer/releases/tag/2.2.5\",\n"
                                              "    \"id\": 6746800,\n"
                                              "    \"tag_name\": \"2.2.5\",\n"
                                              "    \"target_commitish\": \"develop\",\n"
                                              "    \"name\": \"2.2.5\",\n"
                                              "    \"draft\": false,\n"
                                              "    \"author\": {\n"
                                              "      \"login\": \"ColinDuquesnoy\",\n"
                                              "      \"id\": 1681217,\n"
                                              "      \"avatar_url\": "
                                              "\"https://avatars6.githubusercontent.com/u/1681217?v=4\",\n"
                                              "      \"gravatar_id\": \"\",\n"
                                              "      \"url\": \"https://api.github.com/users/ColinDuquesnoy\",\n"
                                              "      \"html_url\": \"https://github.com/ColinDuquesnoy\",\n"
                                              "      \"followers_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/followers\",\n"
                                              "      \"following_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/following{/"
                                              "other_user}\",\n"
                                              "      \"gists_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/gists{/gist_id}\",\n"
                                              "      \"starred_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/starred{/owner}{/"
                                              "repo}\",\n"
                                              "      \"subscriptions_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/subscriptions\",\n"
                                              "      \"organizations_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/orgs\",\n"
                                              "      \"repos_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/repos\",\n"
                                              "      \"events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/events{/privacy}\",\n"
                                              "      \"received_events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/received_events\",\n"
                                              "      \"type\": \"User\",\n"
                                              "      \"site_admin\": false\n"
                                              "    },\n"
                                              "    \"prerelease\": false,\n"
                                              "    \"created_at\": \"2017-06-17T13:37:15Z\",\n"
                                              "    \"published_at\": \"2017-06-17T13:39:36Z\",\n"
                                              "    \"assets\": [\n"
                                              "\n"
                                              "    ],\n"
                                              "    \"tarball_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/tarball/"
                                              "2.2.5\",\n"
                                              "    \"zipball_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/zipball/"
                                              "2.2.5\",\n"
                                              "    \"body\": \"Fix broken soundcloud integration plugin\"\n"
                                              "  },\n"
                                              "  {\n"
                                              "    \"url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "6232430\",\n"
                                              "    \"assets_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "6232430/assets\",\n"
                                              "    \"upload_url\": "
                                              "\"https://uploads.github.com/repos/ColinDuquesnoy/MellowPlayer/releases/"
                                              "6232430/assets{?name,label}\",\n"
                                              "    \"html_url\": "
                                              "\"https://github.com/ColinDuquesnoy/MellowPlayer/releases/tag/2.2.4\",\n"
                                              "    \"id\": 6232430,\n"
                                              "    \"tag_name\": \"2.2.4\",\n"
                                              "    \"target_commitish\": \"develop\",\n"
                                              "    \"name\": \"2.2.4\",\n"
                                              "    \"draft\": false,\n"
                                              "    \"author\": {\n"
                                              "      \"login\": \"ColinDuquesnoy\",\n"
                                              "      \"id\": 1681217,\n"
                                              "      \"avatar_url\": "
                                              "\"https://avatars6.githubusercontent.com/u/1681217?v=4\",\n"
                                              "      \"gravatar_id\": \"\",\n"
                                              "      \"url\": \"https://api.github.com/users/ColinDuquesnoy\",\n"
                                              "      \"html_url\": \"https://github.com/ColinDuquesnoy\",\n"
                                              "      \"followers_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/followers\",\n"
                                              "      \"following_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/following{/"
                                              "other_user}\",\n"
                                              "      \"gists_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/gists{/gist_id}\",\n"
                                              "      \"starred_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/starred{/owner}{/"
                                              "repo}\",\n"
                                              "      \"subscriptions_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/subscriptions\",\n"
                                              "      \"organizations_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/orgs\",\n"
                                              "      \"repos_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/repos\",\n"
                                              "      \"events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/events{/privacy}\",\n"
                                              "      \"received_events_url\": "
                                              "\"https://api.github.com/users/ColinDuquesnoy/received_events\",\n"
                                              "      \"type\": \"User\",\n"
                                              "      \"site_admin\": false\n"
                                              "    },\n"
                                              "    \"prerelease\": false,\n"
                                              "    \"created_at\": \"2017-04-29T18:36:30Z\",\n"
                                              "    \"published_at\": \"2017-04-29T18:42:07Z\",\n"
                                              "    \"assets\": [\n"
                                              "\n"
                                              "    ],\n"
                                              "    \"tarball_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/tarball/"
                                              "2.2.4\",\n"
                                              "    \"zipball_url\": "
                                              "\"https://api.github.com/repos/ColinDuquesnoy/MellowPlayer/zipball/"
                                              "2.2.4\",\n"
                                              "    \"body\": \"Fix broken spotify integration plugin (due to "
                                              "redirection to open.spotify.com).\\r\\n\\r\\nNote that **Widevine** "
                                              "plugin is needed to use spotify.\"\n"
                                              "  }\n"
                                              "]"};

    if (validReplyData.count() > 65535)
        throw std::runtime_error("Too big");

    return validReplyData;
}
