# Contributing to Nuclear

Welcome, and thank you for your interest in contributing to Nuclear!

There are many ways in which you can contribute, beyond writing code. The goal of this document is to provide a high-level overview of how you can get involved.

## Reporting Issues

### Before reporting a new issue or feature request

Have you identified a reproducible problem in nuclear? Have a feature request? We want to hear about it! Here's how you can make reporting your issue as effective as possible.

Before you create a new issue, please do a search in [open issues](https://github.com/nukeop/nuclear/issues) to see if the issue or feature request has already been filed.

If you find your issue already exists, make relevant comments and add your reaction. Use a reaction in place of a "+1" comment:

* 👍 - upvote
* 👎 - downvote

If you cannot find an existing issue that describes your bug or feature, create a new issue using the guidelines below.

### Writing Good Bug Reports and Feature Requests

File a single issue per problem and feature request. Do not enumerate multiple bugs or feature requests in the same issue.

Do not add your issue as a comment to an existing issue unless it's for the identical input. Many issues look similar, but have different causes.

The more information you can provide, the more likely someone will be successful at reproducing the issue and finding a fix.

Please include the following with each issue:

* Version of nuclear (written under the main logo) 

* Your operating system  

* Reproducible steps (1... 2... 3...) that cause the issue

* What you expected to see, versus what you actually saw

* Images, animations, or a link to a video showing the issue occurring

* A code snippet that demonstrates the issue or a link to a code repository the developers can easily pull down to recreate the issue locally

  * **Note:** Because the developers need to copy and paste the code snippet, including a code snippet as a media file (i.e. .gif) is not sufficient.


## Contributing Code

If you are interested in writing code to fix issues or add features, 
please see How to [Contribute](https://nukeop.gitbook.io/nuclear/contributing/contribution-guidelines) in the docs.

We also appreciate [converting existing JS code to Typescript](https://nukeop.gitbook.io/nuclear/contributing/converting-to-typescript), and raising test coverage.

# Thank You!

Your contributions to open source, large or small, make great projects like this possible. Thank you for taking the time to contribute.
