# ![nuclear](https://i.imgur.com/oT1006i.png) 
[![Manutenibilità](https://api.codeclimate.com/v1/badges/a15c4888a63c900f6cc1/maintainability)](https://codeclimate.com/github/nukeop/nuclear/maintainability) [![Codacy Badge](https://api.codacy.com/project/badge/Grade/30750586202742279fa8958a12e519ed)](https://www.codacy.com/app/nukeop/nuclear?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=nukeop/nuclear&amp;utm_campaign=Badge_Grade) [![nuclear](https://snapcraft.io//nuclear/badge.svg)](https://snapcraft.io/nuclear) ![Travis](https://api.travis-ci.org/nukeop/nuclear.svg?branch=master)

Lettore musicale desktop incentrato sullo streaming da fonti gratuite 

![Showcase](https://i.imgur.com/G9BqIHl.png)

# Links

[Sito Ufficiale](https://nuclear.js.org)

[Mastodon](https://fosstodon.org/@nuclearplayer)

[Twitter](https://twitter.com/nuclear_player)

Canale di supporto (Matrix): `#nuclear:matrix.org`

Canale Discord: https://discord.gg/JqPjKxE

Traduzione Documentazione: 

<kbd>[<img title="Deutsch" alt="Deutsch" src="https://cdn.statically.io/gh/hjnilsson/country-flags/master/svg/de.svg" width="22">](docs/README-de.md)</kbd>
<kbd>[<img title="Português" alt="Português" src="https://cdn.statically.io/gh/hjnilsson/country-flags/master/svg/br.svg" width="22">](README-ptbr.md)</kbd>
<kbd>[<img title="Svenska" alt="Svenska" src="https://cdn.statically.io/gh/hjnilsson/country-flags/master/svg/se.svg" width="22">](README-se.md)</kbd>
<kbd>[<img title="English" alt="English" src="https://cdn.statically.io/gh/hjnilsson/country-flags/master/svg/us.svg" width="22">](../README.md)</kbd>
<kbd>[<img title="Hebrew" alt="Hebrew" src="https://cdn.statically.io/gh/hjnilsson/country-flags/master/svg/il.svg" width="22">](README-he.md)</kbd>
<kbd>[<img title="Italiano" alt="Italiano" src="https://cdn.statically.io/gh/hjnilsson/country-flags/master/svg/it.svg" width="22">](README-it.md)</kbd>
<kbd>[<img title="Indonesia" alt="Indonesia" src="https://cdn.statically.io/gh/hjnilsson/country-flags/master/svg/id.svg" width="22">](docs/README-id.md)</kbd>
<kbd>[<img title="Français" alt="Français" src="https://cdn.statically.io/gh/hjnilsson/country-flags/master/svg/fr.svg" width="22">](docs/README-fr.md)</kbd>

## Cos'è Nuclear?
Nuclear è un programma di streaming musicale gratuito che estrae contenuti da fonti gratuite su Internet.

Se conosci [mps-youtube](https://github.com/mps-youtube/mps-youtube), questo è un lettore musicale simile ma con una GUI.
Inoltre si focalizza maggiormente sull'audio. Immagina Spotify non a pagamento e con una libreria più grande.

## E se fossi religiosamente contrario a Electron?
Leggi [questo](docs/electron.md).

## Caratteristiche

- Ricerca e riproduzione di musica da YouTube (inclusa l'integrazione con le playlist e [SponsorBlock](https://sponsor.ajay.app/)), Jamendo, Audius e SoundCloud
- Ricerca di album (alimentato da Last.fm e Discogs), visualizzazione album, ricerca automatica dei brani in base all'artista e al nome della traccia (in corso, a volte può causare problemi)
- Coda di brani, che può essere esportata come playlist
- Caricamento di playlist salvate (memorizzate in file json)
- Scrobbling su last.fm (insieme all'aggiornamento dello stato "in riproduzione")
- Ultime uscite con recensioni: brani e album
- Navigazione per genere
- Modalità radio (accoda automaticamente brani simili)
- Download illimitati (alimentato da youtube)
- Testi in tempo reale
- Navigazione per popolarità
- Elenco dei brani preferiti
- Ascolto dalla biblioteca locale
- Nessun account
- Nessuna pubblicità
- No CoC (Codice di condotta)
- No CLA

## Manuale e documentazione
https://nuclearmusic.rtfd.io/

## Pacchetti gestiti dalla comunità

Di seguito è riportato un elenco di pacchetti dei vari gestori, la maggior parte dei quali sono gestiti da parti terze. Vorremmo ringraziare i manutentori per il loro lavoro.

| Package type   | Link                                                               | Maintainer                                    |
|:--------------:|:------------------------------------------------------------------:|:---------------------------------------------:|
| AUR (Arch)     | https://aur.archlinux.org/packages/nuclear-player-bin/             | [mikelpint](https://github.com/mikelpint)     |
| Choco (Win)    | https://chocolatey.org/packages/nuclear/                           | [JourneyOver](https://github.com/JourneyOver) |
| GURU (Gentoo)  | https://github.com/gentoo/guru/tree/master/media-sound/nuclear-bin | [scardracs](https://github.com/scardracs)     |
| Homebrew (Mac) | https://formulae.brew.sh/cask/nuclear                              | Homebrew                                      |
| Snap           | https://snapcraft.io/nuclear                                       | [nukeop](https://github.com/nukeop)           |
| Flatpak        | https://flathub.org/apps/details/org.js.nuclear.Nuclear            | [advaithm](https://github.com/advaithm)       |

Grazie mille a [ayyeve](https://github.com/ayyEve) per avermi (advaithm) permesso di usare il suo server come macchina di compilazione.
## Traduzioni
Nuclear è già stato tradotto in diverse lingue e siamo sempre alla ricerca di nuovi collaboratori che vorrebbero aggiungerne altri. Di seguito è riportato un elenco delle lingue attualmente disponibili, insieme ai collaboratori che hanno contribuito a tradurre Nuclear in quella lingua.

| Language             | Contributor                                                                                          |
|:--------------------:|:----------------------------------------------------------------------------------------------------:|
| English              | N/A                                                                                                  |
| French               | [charjac](https://github.com/charjac), [Zalax](https://github.com/Zalaxx)                            |
| Dutch                | [Vistaus](https://github.com/Vistaus)                                                                |
| Danish               | [Hansen1992](https://github.com/Hansen1992)                                                          |
| Spanish              | [mlucas94](https://github.com/mlucas94), [emlautarom1](https://github.com/emlautarom1)               |
| Polish               | [kazimierczak-robert](https://github.com/kazimierczak-robert), [gradzka](https://github.com/gradzka) |
| German               | [schippas](https://github.com/schippas)                                                              |
| Russian              | [ramstore07](https://github.com/ramstore07), [dmtrshat](https://github.com/dmtrshat)                 |
| Brazilian Portuguese | [JoaoPedroMoraes](https://github.com/JoaoPedroMoraes)                                                |
| Turkish              | [3DShark](https://github.com/3DShark)                                                                |
| Italian              | [gello94](https://github.com/gello94), [scardracs](https://github.com/scardracs)                     |
| Slovak               | [MartinT](https://github.com/MartinTuroci)                                                           |
| Czech                | [PetrTodorov](https://github.com/PetrTodorov)                                                        |
| Tagalog              | [giftofgrub](https://github.com/giftofgrub)                                                          |
| Traditional Chinese  | [oxygen-TW](https://github.com/oxygen-TW)                                                            |
| Swedish              | [PalleKarlsson](https://github.com/PalleKarlsson), [nonew-star](https://github.com/nonew-star)       |
| Greek                | [Shuin-San](https://github.com/Shuin-San)                                                            |

## Processo di sviluppo

Prima di tutto, assicurati di controllare la [Pagina Wiki Contribuzioni] (https://github.com/nukeop/nuclear/wiki/Contributing).

Usa npm:
```shell
$ npm install # installs dependencies
$ npm start
```

Dovrebbe aprirsi una nuova finestra che caricherà l'app Web ed eseguirà Nuclear.

---
Per sviluppare nel sistema operativo corrente:
```shell
$ lerna bootstrap
$ npm run build
```

Invece di `build` puoi usare` build: all` per compilare per tutti i sistemi operativi. I binari saranno in `packages / app / release`

---
È anche possibile eseguire l'ambiente di sviluppo utilizzando i contenitori Docker, ma questo dovrebbe essere considerato sperimentale.

Avrai bisogno di docker e docker-compose. È necessario consentire all'utente root di connettersi al display X11, quindi è possibile eseguire docker-compose:

```shell
$ xhost SI:localuser:root
$ sudo docker-compose up dev
```
A partire da ora puoi anche creare una versione flatpak. Dovrai installare gobject-introspection e flatpak-builder. Dopodiché dovrai installare i runtime e le dipendenze richiesti da flatpak-builder per il processo di compilazione. Avrai bisogno della versione 19.08 di questi flatpaks.
```shell
$ flatpak install flathub org.freedesktop.Platform
$ flatpak install flathub org.freedesktop.Sdk
$ flatpak install flathub io.atom.electron.BaseApp
```
Successivamente, per costruire il progetto (usa il flag `--verbose` per ottenere più output):
```shell
$ flatpak-builder build-dir org.js.nuclear.Nuclear.json
```
Per eseguire l'app costruita:
```shell
$ flatpak-builder --run build-dir org.js.nuclear.Nuclear.json run.sh
```
Puoi trasformare l'app in un repository locale. attualmente il file crea l'ultima versione.

## Screenshots
Questo verrà aggiornato man mano che il programma si evolve.

![Ricerca Album](https://i.imgur.com/idFVnAF.png)

![Mostra Album](https://i.imgur.com/Kvzo3q7.png)

![Vedi Artista](https://i.imgur.com/imBLYl3.png)

![Pannello di controllo Recenti brani migliori](https://i.imgur.com/bMDrR4M.png)

![Pannello di controllo Generi](https://i.imgur.com/g0aCmKx.png)

![Vedi Playlists](https://i.imgur.com/2VMXHDC.png)

![Vedi Lyrics](https://i.imgur.com/7e3DJKJ.png)

![Vedi Equalizzatore](https://i.imgur.com/WreRL0w.png)

## Licenza

Questo programma è un software libero: puoi ridistribuirlo e / o modificarlo secondo i termini della GNU Affero General Public License come pubblicata dalla Free Software Foundation, versione 3 della licenza o (a tua scelta) qualsiasi versione successiva.
