/*
 * This Document defines the Language Identifiers for 'highlightjs'
 * That is the string used after a code block delimiter to define
 * what programming language is within the code block.
 *
 * 'highlightjs' is a Syntax Highlighting Engine used widely across the web,
 * and is the default syntax highlighting engine for `markdown-it`:
 * https://highlightjs.org/
 *
 * This file can be updated here:
 * https://github.com/highlightjs/highlight.js/blob/main/SUPPORTED_LANGUAGES.md
 * Which helpfully lists the available aliases of each supported language.
 */

module.exports = {
  shell: 'source.shell',
  console: 'source.shell',
  bash: 'source.shell',
  sh: 'source.shell',
  zsh: 'source.shell',
  powershell: 'source.powershell',
  ps: 'source.powershell',
  ps1: 'source.powershell',
  c: 'source.c',
  h: 'source.c',
  cpp: 'source.cpp',
  hpp: 'source.cpp',
  cc: 'source.cpp',
  hh: 'source.cpp',
  'c++': 'source.cpp',
  'h++': 'source.cpp',
  cxx: 'source.cpp',
  hxx: 'source.cpp',
  coffeescript: 'source.coffee',
  coffee: 'source.coffee',
  cson: 'source.coffee',
  iced: 'source.coffee',
  csharp: 'source.cs',
  cs: 'source.cs',
  css: 'source.css',
  clojure: 'source.clojure',
  clj: 'source.clojure',
  scss: 'source.scss',
  erlang: 'source.erl',
  erl: 'source.erl',
  go: 'source.go',
  golang: 'source.go',
  html: 'text.html.basic',
  xhtml: 'text.html.basic',
  rss: 'text.xml',
  atom: 'text.xml',
  xml: 'text.xml',
  xsd: 'text.xml',
  xsl: 'text.xml',
  plist: 'text.xml.plist',
  hbs: 'text.html.handlebars',
  'html.hbs': 'text.html.handlebars',
  'html.handlebars': 'text.html.handlebars',
  htmlbars: 'text.html.handlebars',
  handlebars: 'text.html.handlebars',
  java: 'source.java',
  jsp: 'text.html.jsp',
  properties: 'source.java-properties',
  javascript: 'source.js',
  js: 'source.js',
  jsx: 'source.js',
  json: 'source.json',
  less: 'source.css.less',
  objectivec: 'source.objc',
  mm: 'source.objc',
  objc: 'source.objc',
  'obj-c': 'source.objc',
  'obj-c++': 'source.objcpp',
  'objective-c++': 'source.objcpp',
  php: 'text.html.php',
  python: 'source.python',
  py: 'source.python',
  gyp: 'source.python',
  pycon: 'text.python.console',
  ruby: 'source.ruby',
  rb: 'source.ruby',
  gemspec: 'source.ruby',
  podspec: 'source.ruby',
  thor: 'source.ruby',
  irb: 'source.ruby',
  plaintext: 'text.plain',
  txt: 'text.plain',
  text: 'text.plain',
  toml: 'source.toml',
  typescript: 'source.ts',
  ts: 'source.ts',
  tsx: 'source.ts',
  mts: 'source.ts',
  cts: 'source.ts',
  yaml: 'source.yaml',
  yml: 'source.yaml',
  makefile: 'source.makefile',
  mk: 'source.makefile',
  mak: 'source.makefile',
  make: 'source.makefile',
  perl: 'source.perl',
  pl: 'source.perl',
  pm: 'source.perl',
  sql: 'source.sql'
};
