import type { CSSProperties } from 'react';
import { useId } from 'react';

type FailureImageProps = {
  st3?: string;
  st15?: string;
  st11?: string;
  st1?: string;
  st14?: string;
  st12?: string;
  st2?: string;
  st23?: string;
  st22?: string;
  st21?: string;
  st20?: string;
  st8?: string;
  st19?: string;
  st4?: string;
  st13?: string;
  style?: CSSProperties;
};

export const FailureImage = ({
  st3 = '#030C1A',
  st15 = '#030D19',
  st11 = '#0B182B',
  st1 = '#15273F',
  st14 = '#1A324C',
  st12 = '#384A66',
  st2 = '#E3CEC8',
  st23 = '#E4C8BA',
  st22 = '#E6B793',
  st21 = '#EA9B57',
  st20 = '#ED8A30',
  st8 = '#EF4848',
  st19 = '#FF5050',
  st4 = '#FFCD52',
  st13 = '#FFFFFF',
  ...props
}: FailureImageProps) => {
  const a = useId();
  const b = useId();
  const c = useId();
  const e = useId();

  return (
    <svg viewBox='0 0 1366 768' preserveAspectRatio='xMidYMid slice' {...props}>
      <linearGradient
        id={a}
        x1={1047}
        x2={1047}
        y1={213.43}
        y2={287.03}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor={st3} offset={0} />
        <stop stopColor={st12} offset={1} />
      </linearGradient>
      <linearGradient
        id={b}
        x1={102.96}
        x2={111.7}
        y1={47.165}
        y2={217.07}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor={st3} offset={0} />
        <stop stopColor={st11} offset={1} />
      </linearGradient>
      <clipPath id={c}>
        <circle opacity={0.3} cx={553.49} cy={544.5} r={146.44} />
      </clipPath>
      <linearGradient
        id={e}
        x1={510.48}
        x2={295.77}
        y1={-59.124}
        y2={-273.83}
        gradientTransform='matrix(.9862 -.1655 .1655 .9862 138.97 743.69)'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor={st20} offset={0} />
        <stop stopColor={st21} stopOpacity={0.7848} offset={0.2152} />
        <stop stopColor={st22} stopOpacity={0.4148} offset={0.5852} />
        <stop stopColor={st23} stopOpacity={0.1427} offset={0.8573} />
        <stop stopColor={st2} stopOpacity={0} offset={1} />
      </linearGradient>
      <g>
        <path
          fill={st1}
          d='m1010.2 530.88l1.15 2.74-59.34 8.99s-3.95-2.99-5.67-4.67-2.3-3.16-2.3-3.16c0.62 0.89 7.43 2.92 8.35 2.72 0.93-0.2 0.44-0.43-1.18-1.09s-1.3-1.04-1.3-1.04c2.51-0.77 9.91 1.39 9.91 1.39 0.06-0.65-4.52-2.51-4.12-2.59 0.4-0.07 1.67 0.31 1.79 0.16s-0.33-0.77-0.33-0.77c1.73-0.44 7.41 2.54 7.41 2.54 0.15-0.55-3.81-2.76-3.07-3.07s3.93 1.46 3.92 0.99c-0.01-0.48-1.94-1.87-1-1.79 0.95 0.08 3.72 2.56 4.01 2.1s-1.5-2.54-1.5-2.54 2.91 1.32 3.04 1.5 3.04 0.59 3.1 0.18c0.07-0.41-1.31-0.94-1.54-1.03s-2.76-0.51-0.92-0.81 8.87 2.12 8.94 1.94-1.75-1.52-2-2.13c-0.26-0.61-0.45-1.06-0.45-1.06 0.86 0.55 5.67 3.18 5.67 3.18s-2.43-3.43-1.88-2.56 5.23 2.19 5.23 2.19c-1.46-0.85-3.86-3.5-3.86-3.5 2.06 1.42 9.28 2.68 9.28 2.68-0.28-0.89-2.59-1.57-2.59-1.57 1.63-1.79 6.49 0.84 6.49 0.84 0.3-0.59-0.62-1.48-0.62-1.48 0.89-0.28 2.08 0.59 2.08 0.59-0.49-1.17-2.74-2.14-2.74-2.14 4.13-1.93 9.24 3.43 9.24 3.43-1.29-1.1-2.57-4.14-2.57-4.14 0.77 0.96 5 2.29 5 2.29 1.25-0.07 3.6 0.5 3.6 0.5'
        />
        <ellipse fill={st2} cx={144.81} cy={487.93} rx={1.1} ry={1.08} />
        <ellipse fill={st2} cx={322.32} cy={468.93} rx={1.1} ry={1.08} />
        <rect fill={st3} x={-0.45} y={0.09} width={1366.1} height={768.2} />
        <circle fill={st4} cx={553.49} cy={544.5} r={146.44} />
        <circle fill={`url(#${e})`} cx={553.49} cy={544.5} r={146.44} />
        <g opacity={0.3}>
          <g clipPath={`url(#${c})`}>
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 409c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 415.34c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 421.69c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 428.03c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 434.37c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 440.71c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 447.05c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 453.39c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 459.73c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 466.07c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 472.42c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 478.76c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 485.1c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 491.44c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 497.78c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 504.12c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 510.46c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 516.81c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 523.15c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 529.49c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 535.83c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 542.17c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 548.51c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 554.85c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 561.2c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 567.54c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 573.88c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 580.22c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 586.56c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 592.9c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 599.24c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 605.59c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 611.93c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 618.27c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 624.61c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 630.95c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 637.29c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 643.63c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 649.98c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 656.32c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 662.66c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 669c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 675.34c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 681.68c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 688.02c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
            <path
              fill='none'
              stroke={st8}
              strokeWidth={5}
              strokeMiterlimit='10'
              d='m370.72 694.37c11.94-0.42 11.81-4.14 23.74-4.56 11.94-0.42 12.07 3.29 24.01 2.86 11.94-0.42 12.05 2.82 23.99 2.4s11.84-3.33 23.77-3.75c11.94-0.42 12 1.42 23.94 1s11.78-4.89 23.72-5.31 12.06 2.94 23.99 2.52c11.94-0.42 11.86-2.76 23.79-3.18 11.94-0.42 11.92-1.06 23.85-1.49 11.94-0.42 12.11 4.29 24.05 3.87s11.95-0.12 23.89-0.54 11.83-3.44 23.77-3.87c11.94-0.42 11.86-2.59 23.8-3.01s11.96 0.05 23.9-0.37 12.06 2.97 24 2.55'
            />
          </g>
        </g>
        <ellipse
          opacity={0.4}
          fill={st2}
          cx={283.6}
          cy={237.73}
          rx={0.4}
          ry={0.4}
        />
        <ellipse fill={st2} cx={389.76} cy={200.29} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={349.31} cy={275.3} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={256.38} cy={147.67} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={262.02} cy={281.11} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={432.63} cy={177.54} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={455.4} cy={267.47} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={125.11} cy={193.86} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={73.45} cy={246.47} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={-0.25} cy={155.85} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={69.35} cy={188.63} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={307.88} cy={153.4} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={36.75} cy={225.7} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={995.65} cy={400.05} rx={0.4} ry={0.4} />
        <ellipse
          opacity={0.4}
          fill={st2}
          cx={1101.8}
          cy={362.6}
          rx={0.4}
          ry={0.4}
        />
        <ellipse fill={st2} cx={1061.4} cy={437.62} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={968.43} cy={309.99} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={974.07} cy={443.42} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1144.7} cy={339.85} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={1167.4} cy={429.79} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={837.16} cy={356.18} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={785.5} cy={408.78} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={711.8} cy={318.17} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={781.4} cy={350.94} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1019.9} cy={315.71} rx={0.41} ry={0.4} />
        <ellipse
          opacity={0.2}
          fill={st2}
          cx={748.8}
          cy={388.01}
          rx={0.41}
          ry={0.4}
        />
        <ellipse fill={st2} cx={1034.2} cy={81.83} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={928.01} cy={119.28} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={968.46} cy={44.26} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={1061.4} cy={171.89} rx={0.41} ry={0.4} />
        <ellipse
          opacity={0.2}
          fill={st2}
          cx={1055.8}
          cy={38.45}
          rx={0.41}
          ry={0.4}
        />
        <ellipse fill={st2} cx={885.14} cy={142.02} rx={0.4} ry={0.4} />
        <ellipse
          opacity={0.2}
          fill={st2}
          cx={862.37}
          cy={52.09}
          rx={0.4}
          ry={0.4}
        />
        <ellipse fill={st2} cx={1192.7} cy={125.7} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1244.3} cy={73.09} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1318} cy={163.71} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1248.4} cy={130.94} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1009.9} cy={166.17} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1281} cy={93.87} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={190.59} cy={348.72} rx={0.4} ry={0.4} />
        <ellipse
          opacity={0.2}
          fill={st2}
          cx={84.44}
          cy={386.17}
          rx={0.4}
          ry={0.4}
        />
        <ellipse fill={st2} cx={124.88} cy={311.15} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={217.81} cy={438.78} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={212.17} cy={305.35} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={41.57} cy={408.92} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={18.79} cy={318.98} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={349.08} cy={392.59} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={400.74} cy={339.99} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={474.44} cy={430.6} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={404.84} cy={397.83} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={166.31} cy={433.06} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={437.44} cy={360.76} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={226.03} cy={108.04} rx={0.4} ry={0.4} />
        <ellipse
          opacity={0.4}
          fill={st2}
          cx={119.88}
          cy={145.49}
          rx={0.4}
          ry={0.4}
        />
        <ellipse
          opacity={0.4}
          fill={st2}
          cx={160.32}
          cy={70.47}
          rx={0.4}
          ry={0.4}
        />
        <ellipse fill={st2} cx={253.25} cy={198.1} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={247.61} cy={64.67} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={77.01} cy={168.24} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={54.24} cy={78.3} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={384.52} cy={151.91} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={436.19} cy={99.31} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={509.88} cy={189.92} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={440.29} cy={157.15} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={201.76} cy={192.38} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={472.89} cy={120.08} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={964.3} cy={331.86} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={858.15} cy={369.3} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={898.59} cy={294.29} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={991.52} cy={421.92} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={985.88} cy={288.48} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={815.28} cy={392.05} rx={0.4} ry={0.4} />
        <ellipse
          opacity={0.2}
          fill={st2}
          cx={792.51}
          cy={302.12}
          rx={0.4}
          ry={0.4}
        />
        <ellipse
          opacity={0.4}
          fill={st2}
          cx={1122.8}
          cy={375.73}
          rx={0.41}
          ry={0.4}
        />
        <ellipse fill={st2} cx={1248.2} cy={413.74} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1178.6} cy={380.96} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={940.03} cy={416.2} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={891.34} cy={343.89} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1280.3} cy={261.81} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={1274.1} cy={359.15} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={1346} cy={299.38} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={1253.1} cy={171.75} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1287.8} cy={309.99} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1317} cy={336.4} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={1339.7} cy={426.33} rx={0.4} ry={0.4} />
        <ellipse fill={st2} cx={1121.8} cy={217.94} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1070.2} cy={270.55} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={996.46} cy={179.93} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1087.3} cy={232.81} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1304.6} cy={177.47} rx={0.41} ry={0.4} />
        <ellipse fill={st2} cx={1033.4} cy={249.77} rx={0.41} ry={0.4} />
        <path
          fill={st11}
          d='m165.42 477.46l40.53-20.74c1.87-0.96 4.15-0.49 5.49 1.13l0.6 0.72c2.65 3.2 7.23 4.01 10.83 1.92l9.13-5.3c1.93-1.12 4.11-1.71 6.34-1.71h4.2c3.4 0 6.74-0.8 9.78-2.32l63.19-31.82c3.57-1.8 7.81-1.71 11.3 0.24 5.1 2.85 11.27 3.05 16.54 0.54l18.22-8.66c2.41-1.15 5.21-1.13 7.61 0.05l37.6 18.42c2.51 1.23 4.95 2.59 7.31 4.08l85.67 54.1c4.22 2.67 9.12 4.08 14.11 4.08h3.45c3.75 0 7.47-0.8 10.89-2.35l40.57-18.34c2-0.9 4.3-0.81 6.21 0.26l31.49 17.54c2.75 1.53 5.85 2.34 9 2.34h42.15c2.91 0 5.76 0.8 8.26 2.3l17.53 10.59c3.19 1.93 6.96 2.66 10.64 2.07l6.92-1.12c3.86-0.62 7.81-0.35 11.55 0.79 2.63 0.8 5.47 0.54 7.92-0.71l79.31-40.81c2.86-1.47 6.23-1.54 9.15-0.18l107.75 50.18c3.52 1.64 7.55 1.8 11.19 0.43l20.87-7.83c2.62-0.98 5.52-0.95 8.12 0.1l15.4 6.23c5.92 2.4 12.26 3.63 18.65 3.63h4.78c6.26 0 12.46-1.18 18.28-3.48l22.75-8.99c3.53-1.39 7.48-1.26 10.91 0.36l6.25 2.96 13.57 0.79s8.43 0.95 20.42 0.81c8.33-0.1 16.64-1.03 24.78-2.77l100.25-21.4c12.3-2.63 25.14-0.79 36.21 5.18l74.97 40.4 41.65-3.85-0.76 105.66-1041.5-52.72-323.76-7.08-0.1-32.28 165.86-63.44z'
        />
        <path
          fill={st1}
          d='m318.54 418.13l8.85 7.19c0.86 0.7 2.05 0.86 3.07 0.41l6.62-3.75s-3.56-0.6-8.6-1.57c-1.58-0.31-2.84-1.96-4.3-2.28-2.26-0.49-4.54 0.38-5.64 0z'
        />
        <path
          fill={st1}
          d='m515.64 507.4c-29.11-5.86-44.37-12.17-51.19-15.63-1.16-0.59-0.7-2.35 0.6-2.29 2.92 0.12 5.14 0.08 6.74-0.01 0.88-0.05 1.12-1.24 0.32-1.63-31.96-15.4-106.45-77.23-106.45-77.23 15.38 3.2 26.38 11.37 26.38 11.37 22.05 12.03 36 20.18 64.02 36.26 0 0 58.44 39.83 62.67 42.22 2.5 1.41 12.31 5.77 19.92 9.1 1.25 0.55 0.66 2.42-0.68 2.16l-22.33-4.32z'
        />
        <path
          fill={st1}
          d='m657.62 491.64l18.37 21.2c2.64 3.05 6.94 4.05 10.66 2.49l24.11-10.14s-3.76-0.42-8.66 0.14c-5.15 0.59-11.52 2.15-14.31 1.24-5.45-1.76-20.32-11.85-22.6-13.02-3.72-1.91-7.57-1.91-7.57-1.91z'
        />
        <path
          fill={st1}
          d='m207.49 456.26s-8.45 8.58-2.01 8.92 14.81-3.71 14.81-3.71-4.61 0.14-8.26-2.9c0.01 0-1.95-2.68-4.54-2.31z'
        />
        <path
          fill={st12}
          d='m1096.4 455.05c0-0.49-1.3-4.37-1.3-4.37s-1.46-3.4-1.46-5.67-1.3-6.32-1.3-6.96c0-0.21-4.1-10.14-6.15-12.31-1.76-1.85-4.88-3.12-7.24-3.86-0.06-0.05-0.1-0.09-0.1-0.09 3-2.28 4.77-4.55 4.53-9.38-0.11-2.2-1.1-5.58-3.26-7.95-1.79-1.95-4.48-3.5-8.12-4.14-8.04-1.41-11.95 3.78-13.31 9.17s1.01 9.21 1.01 9.21c-0.48 0-0.8 0.57-0.99 1.06-0.58-1.21-1.21-2.66-1.31-3.43-0.19-1.48-1.98-3.37-2.01-4.78-0.04-1.41-1.25-2.09-1.48-2.66s-0.8-2.93-0.79-3.61-0.88-1.86-0.88-3.76-0.42-2.51-0.42-3.88-0.23-1.9-0.23-2.55-0.68-1.89-0.68-2.34l-0.08-2.28-0.31-1.65-0.58-0.93c0.32-0.48 0.73-1.03 0.85-1.22 0.22-0.33 0.99-2.01 0.99-2.12 0-0.08 0.23-1.03 0.35-1.5 0.04-0.17 0.05-0.35 0.04-0.53-0.07-0.65-0.25-2.28-0.25-2.43 0-0.09-0.1-0.57-0.3-1.1-0.07-0.18-0.15-0.37-0.24-0.55-0.22-0.45-0.52-0.85-0.87-0.97-0.91-0.3-1.13 0.39-1.13 0.39l-0.8-0.17h-0.99s-0.83 0.47-1.27 0.47-1.87 0.72-1.9 0.85c-0.03 0.14-1.82 0.96-1.82 0.96s-0.58 0.41-0.58 0.5c0 0.08-0.41 0.94-0.41 1.16s0.55 1.93 0.63 2.23 0.83 2.89 0.83 2.89 0.03 0.06 0.07 0.15c-0.03 0.27-0.07 0.55-0.13 0.84-0.04 0.21 0.27 0.49 0.48 0.75-0.06 0.25-0.12 0.52-0.12 0.61 0 0.17-0.11 1.53-0.11 1.53h0.16c-0.2 0.73-0.46 1.24-0.52 1.49-0.25 1-0.45 9.77-0.61 10.75-0.16 0.97 1.13 4.7 1.13 5.18s1.3 4.37 1.3 4.37 1.46 3.4 1.46 5.67 1.3 6.32 1.3 6.96c0 0.65 3.33 9.06 6.41 12.29 0.26 1.66 0.48 2.94 0.48 3.08 0 0.33 2.05 4.68 2.05 5.18 0 0.49 1.15 6.16 1.15 7.07 0 0.9-1.23 2.79-1.23 6.33 0 3.53 0.08 3.37 0.08 6.82s-1.31 6.33-1.31 8.05c0 1.73-0.16 11.09-0.16 11.09l0.58 1.81v3.86s-0.49 3.53-0.49 4.44c0 0.9-0.9 3.61-1.06 6.16s1.06 2.05 1.06 4.68 0.82 3.2 0.82 5.67c0 2.46-0.33 1.89-0.33 2.79s-0.74 3.53-0.74 5.83 0.49 3.86 0.49 4.6 0.33 1.48 0.33 2.22 1.15 1.73 1.4 1.81 0.58 1.73 0.58 1.73-2.22-1.07-3.37 2.38 2.3 5.92 2.3 5.92c6.16-0.33 10.19-2.38 10.19-2.38l-0.33-3.29s-0.82-3.04-1.12-3.61c-0.3-0.58 0.39-2.71 0.1-3.29-0.28-0.58 0.12-2.14 0.04-2.71-0.08-0.58 0-3.86 0-3.86s0.9-2.46 0.9-3.94 0.82-4.68 0.9-5.34 0.82-4.52 0.91-5.26 1.06-5.34 1.06-6.41-0.25-4.85-0.33-5.67-0.08-1.97 0-3.94 1.07-8.38 1.07-8.38v5.42s0.99 3.62 0.99 6.16c0 2.55 2.46 3.86 2.63 5.18 0.16 1.31 0.9 2.88 0.99 4.44 0.08 1.56 0.9 2.3 0.9 3.04s1.48 2.38 1.48 3.45 0.66 3.29 0.66 5.42c0 2.14 0.33 2.46 0.33 4.93s0.82 2.46 0.9 3.53-0.41 2.38-0.41 2.63 0.49 7.39 1.23 8.38 3.94 0.58 5.92 0c1.97-0.58 1.89-4.03 1.89-4.6 0-0.58-0.41-4.68-0.7-6.66-0.29-1.97 0.86-10.93 0.86-10.93s0.16-3.12 0.16-3.61-0.41-3.37-0.41-6.33-0.49-6.41-0.62-7.31c-0.12-0.9-0.21-2.71 0-5.75s-0.29-2.3-0.53-6.65c-0.25-4.35-1.24-13.66-1.24-13.66s-0.34-1.1-0.38-2.47-0.87-1.82-0.87-2.09c0-0.12-0.12-0.72-0.26-1.47l1.56-0.02c0.46-0.01 0.83-0.38 0.83-0.84v-6.97c0.05 0.07 0.1 0.14 0.12 0.21 0.23 0.57 0.8 2.93 0.79 3.61s0.88 1.86 0.88 3.76 0.42 2.51 0.42 3.88 0.23 1.9 0.23 2.55-0.23 2.01-0.23 2.47v3.27c0 0.84 0.46 3.5 0.38 4.37s1.37 1.18 1.52 0.27 1.29-2.01 1.29-2.01 0.49 0.68 0.53 1.41c0.04 0.72-1.25 2.58-1.41 3.57-0.15 0.99 0.27 1.25 0.27 1.25 1.29 0.42 2.58-0.34 2.58-0.34-0.15 0.95 0.87 0.72 0.87 0.72 0.68-0.34 1.25-1.82 1.25-1.82 0.49 0.15 0.88-0.2 0.88-0.2 1.16-2.08 0.5-8.99 0.75-9.98 0.12-0.5 0.24-2.94 0.34-5.38s0.19-4.88 0.27-5.36c0.14-0.99-1.15-4.71-1.15-5.2z'
        />
        <polygon
          fill={st13}
          points='1082.8 430.84 1063.1 430.38 1066.6 432.89 1086.5 433.13'
        />
        <path
          fill={st14}
          d='m1049.6 378.77s0.15-0.9 0.6-0.9 0.9 0.14 1.56 1.56c0 0-0.47-2.01-1.48-2s-1.05 0.78-1.05 0.78 0.43 0.26 0.37 0.56z'
        />
        <path
          fill={st1}
          d='m479.68 600.45s-22.25-1.3-31.46-2.68c-0.3-0.04-0.47 0.32-0.25 0.53 0.73 0.67 1.98 1.67 3.45 2.26 0 0-10.45-1-18.85-3.27-0.6-0.16-0.94 0.66-0.4 0.97 3.71 2.12 9.54 5.14 14.95 6.72l32.56-4.53z'
        />
        <path
          fill={st1}
          d='m446.55 604.8s6.98 1.81 11.25 1.41c0 0-8.13 1.07-16.13-0.8l4.88-0.61z'
        />
        <path
          fill={st1}
          d='m155 617.06s-21.51-5.83-30.25-9.06c-0.28-0.1-0.53 0.22-0.35 0.46 0.57 0.8 1.59 2.04 2.91 2.91 0 0-7.88-2.45-15.07-5.75-0.98-0.45-1.81 0.85-0.98 1.55 3.07 2.57 7.04 5.57 10.94 7.65l32.8 2.24z'
        />
        <path
          fill={st1}
          d='m121.68 614.52s6.46 3.2 10.72 3.68c0 0-8.18-0.62-15.63-4.09l4.91 0.41z'
        />
        <path
          fill={st1}
          d='m194.08 618.35l-12.07-0.31s-4.39-2.44-8.64-2.87c-0.14-0.01-0.18 0.18-0.05 0.23 0.88 0.32 2.07 0.86 1.96 1.43l-8.99-0.6c-0.8-0.05-1.59-0.17-2.36-0.34-2.67-0.6-9.03-2.03-9.69-2.32-0.84-0.36 1.83 1.3 3.67 1.86 0 0-4.85-0.42-9.67-3.7 0 0 0.59 1.33 2.1 2.46 0.79 0.59 1.49 1.3 2.11 2.07l0.86 1.05 39.19 2.14 1.58-1.1z'
        />
        <path
          fill={st1}
          d='m354.34 614.48s-2.26-0.1-6.89 0.69-20.6 1.2-25.47-0.56c0 0 0.25 1.29 1.32 1.9 0 0-17.64 0.74-23.2 0.68s-9.5 0.18-12.26-1.24c0 0 1.12 1.38 2.1 1.73 0.61 0.22-1.52-0.33-3.72-1.14-1.32-0.48-2.66-1.06-3.45-1.61 0 0 2.39 2.89 4.37 3.41l-6.93 0.14-8.48-3.81s-1.61-6.34-4.15-5.61c-2.53 0.73 2.11 4.45 2.11 4.45s-5.5-2.53-8.32-2.91c0 0-0.4-4.32-2.45-4.48s1.08 3.95 1.08 3.95l-3.02-0.31-0.06 0.61 4.3 1.25s-0.86 1.19-2.19 1.7c-1.33 0.5 0.03 2.66 1.81 2 1.79-0.66 1.76-3.32 1.76-3.32s5.59 1.21 7.23 2.5c0 0-0.47 1.23-1.71 1.3-0.8 0.05-0.43 0.94 0.49 1.18 0.98 0.26 1.95-0.46 2.08-1.46l0.09-0.73 6.24 4.03 10.95 2.98 61.05-1.58 5.32-5.74z'
        />
        <path
          fill={st1}
          d='m725.93 567.47s-2.28-0.55-3.55-0.5c-0.04 0-0.07 0-0.1-0.01-0.36-0.12-2.6-0.85-3.98-1.58-0.28-0.15-0.58 0.15-0.44 0.43 0.49 0.98 1.27 2.35 2.05 3.02 0 0-4.52-4.75-8.5-3.7-0.28 0.07-0.32 0.46-0.07 0.6 0.3 0.16 0.66 0.38 1.01 0.63 0.28 0.21 0.07 0.64-0.27 0.57h-0.02c-0.28-0.05-0.49 0.27-0.32 0.5 0.07 0.1 0.13 0.21 0.18 0.33 0.12 0.28-0.18 0.55-0.45 0.42-1.12-0.53-3.9-1.7-5.44-0.99-0.26 0.12-0.25 0.5 0.02 0.6 0.36 0.14 0.84 0.34 1.24 0.58 0.31 0.19 0.13 0.67-0.23 0.6-1.56-0.31-4.62-0.96-6.7-1.73-0.33-0.12-0.59 0.29-0.34 0.53 0.36 0.36 0.77 0.75 1.18 1.11 0.27 0.23 0.02 0.66-0.32 0.55-1.39-0.46-3.15-1.13-3.48-1.65s0.41 0.5 1.06 1.41c0.2 0.28-0.12 0.64-0.42 0.47-1.07-0.59-2.59-1.43-3.58-2-0.27-0.16-0.58 0.12-0.46 0.41l0.06 0.15c0.26 0.61 2.08 1.96 2 2.13s-7.09-2.24-8.94-1.94c-1.84 0.3 0.69 0.72 0.92 0.81s1.61 0.62 1.54 1.03-2.98 0.01-3.1-0.18c-0.07-0.1-1-0.55-1.81-0.94-0.3-0.14-0.6 0.21-0.4 0.49 0.42 0.59 0.82 1.25 0.67 1.48-0.29 0.46-3.06-2.02-4.01-2.1s0.99 1.31 1 1.79-3.19-1.3-3.92-0.99c-0.39 0.17 0.57 0.88 1.52 1.6 0.31 0.23 0.02 0.72-0.33 0.56-1.55-0.71-3.68-1.59-4.95-1.66-0.25-0.01-0.42 0.24-0.31 0.47 0.07 0.15 0.12 0.29 0.06 0.35-0.13 0.15-1.39-0.23-1.79-0.16-0.26 0.05 1.6 0.86 2.9 1.59 0.33 0.19 0.13 0.69-0.24 0.6-2.13-0.54-6.07-1.43-8.06-1.09-0.28 0.05-0.36 0.4-0.14 0.58 0.19 0.15 0.52 0.34 1.05 0.55 1.62 0.66 2.1 0.89 1.18 1.09-0.74 0.16-5.25-1.11-7.34-2.07-0.29-0.14-0.59 0.2-0.41 0.47 0.36 0.56 0.91 1.28 1.69 2.05 1.55 1.51 4.92 4.1 5.56 4.59 0.07 0.05 0.16 0.07 0.24 0.06l58.8-8.91c0.21-0.03 0.33-0.25 0.25-0.45l-0.99-2.35'
        />
        <path
          fill={st13}
          d='m1081.1 504.92c-0.45-1.23-1.38-2.2-2.16-3.25s-1.43-2.33-1.19-3.61c0.17-0.9 0.78-1.7 0.83-2.62 0.09-2-2.45-3.32-2.53-5.32-0.05-1.31 1-2.61 0.53-3.83-0.06-0.15-0.14-0.29-0.14-0.45-0.03-0.54 0.66-0.75 1.18-0.9 0.85-0.25 1.64-0.83 1.97-1.65 0.33-0.83 0.2-1.85-0.9-2.12-2.08-0.08-4.16-0.16-6.25-0.24-0.64-0.02-1.18-0.14-1.76-0.2-0.35-0.03-0.72-0.24-0.89 0.06l0.08 4.31c0.08 0.28-0.15 0.82-0.08 1.11 0.29 1.12 0.38 1.94 0.73 3.15 0.18 1.04 0.33 2.19 0.33 3.18 0 2.55 2.46 3.86 2.63 5.18 0.16 1.31 0.9 2.88 0.99 4.44 0.08 1.56 0.9 2.3 0.9 3.04s1.48 2.38 1.48 3.45 0.66 3.29 0.66 5.42c0 2.14 0.33 2.46 0.33 4.93 0 1.36 0.25 1.96 0.49 2.42 1.33-0.65 2.21-2.24 2.44-3.78 0.29-1.92-0.11-3.87 0.03-5.8 0.17-2.33 1.1-4.73 0.3-6.92z'
        />
        <path
          fill={st14}
          d='m1069.8 483.07c0.02-0.14 0.04-0.27 0.06-0.4-0.02 0.13-0.05 0.26-0.06 0.4z'
        />
        <path
          fill={st13}
          d='m1059.5 456.91c-0.46-3.49 0.2-7.03 0.05-10.55-0.06-1.32-0.27-2.67-0.67-3.95 0.08-0.19 0.14-0.39 0.16-0.61 0.09-0.8-0.26-1.57-0.6-2.29l-4.17-8.82c-2.59-5.49-5.24-11.24-5.03-17.3 0.06-1.65 0.26-3.52-0.86-4.74-0.97-1.07-2.92-1.73-2.63-3.15 0.1-0.5 0.48-0.88 0.71-1.34 1.1-2.16-1.52-4.41-1.71-6.82-0.2-2.59 2.44-5.15 1.29-7.48l-0.51-0.34c0.41 0 0.82-0.01 1.24-0.03 0.2-0.01 0.24-0.29 0.05-0.36-0.58-0.21-1.17-0.42-1.75-0.62-0.35-0.12-0.72-0.27-0.9-0.6-0.26-0.48 0.06-1.05 0.22-1.57 0.16-0.51 0.17-1.06 0.04-1.57-0.2-0.76-0.73-1.46-0.66-2.24 0.03-0.33 0.16-0.64 0.3-0.94 0.43-0.98 0.98-2.07 2-2.4 0.26-0.09 0.55-0.12 0.76-0.29 0.22-0.17 0.3-0.55 0.07-0.7-0.09-0.06-0.22-0.07-0.33-0.06-0.64 0.02-1.25 0.31-1.83 0.59l-0.06 0.03c-0.2 0.11-0.34 0.21-0.35 0.25-0.03 0.14-1.82 0.96-1.82 0.96s-0.58 0.41-0.58 0.5c0 0.08-0.41 0.94-0.41 1.16s0.55 1.93 0.63 2.23 0.83 2.89 0.83 2.89 0.03 0.06 0.07 0.15c-0.03 0.27-0.07 0.55-0.13 0.84-0.04 0.21 0.27 0.49 0.48 0.75-0.06 0.25-0.12 0.52-0.12 0.61v0.08c0.09 0.07 0.18 0.13 0.27 0.2-0.13 1.34-0.65 2.3-0.74 2.66-0.25 1-0.45 9.77-0.61 10.75-0.16 0.97 1.13 4.7 1.13 5.18s1.3 4.37 1.3 4.37 1.46 3.4 1.46 5.67 1.3 6.32 1.3 6.96c0 0.65 3.33 9.06 6.41 12.29 0.26 1.66 0.48 2.94 0.48 3.08 0 0.22 0.89 2.19 1.5 3.64h0.01c0.34 0.82 0.62 1.51 0.62 1.69 0 0.49 1.15 6.16 1.15 7.07 0 0.9-1.23 2.79-1.23 6.33 0 3.53 0.08 3.37 0.08 6.82s-1.31 6.33-1.31 8.05c0 1.73-0.16 11.09-0.16 11.09l0.58 1.81v3.86s-0.49 3.53-0.49 4.44c0 0.9-0.9 3.61-1.06 6.16-0.15 2.55 1.06 2.05 1.06 4.68s0.82 3.2 0.82 5.67c0 2.46-0.33 1.89-0.33 2.79s-0.74 3.53-0.74 5.83c0 0.37 0.01 0.73 0.04 1.06 0.92 0.36 1.86 3.85 2.74 3.43 1.79-0.85 2.41-6.62 2.23-8.59-0.26-2.94-1.53-5.76-1.45-8.7 0.08-3.04 1.58-5.9 1.67-8.94 0.1-3.04-1.21-5.98-1.27-9.02-0.05-2.7 0.9-5.36 0.68-8.05-0.17-2.13-1.07-4.17-1.05-6.3 0.02-3.23 2.1-6.12 2.44-9.34 0.31-3.01-0.91-5.93-1.31-8.91z'
        />
        <path
          fill={st3}
          d='m526.44 649.42s-3.01-1.59-4.81-1.97c-0.05-0.01-0.09-0.03-0.14-0.05-0.47-0.29-3.35-2.11-5.02-3.64-0.34-0.31-0.87 0-0.78 0.45 0.34 1.55 0.93 3.74 1.79 4.95 0 0-4.64-8.26-10.62-8.21-0.42 0-0.62 0.53-0.31 0.81 0.36 0.34 0.8 0.77 1.19 1.25 0.32 0.39-0.13 0.92-0.59 0.7-0.01 0-0.02-0.01-0.03-0.01-0.38-0.18-0.78 0.2-0.64 0.59 0.06 0.17 0.11 0.35 0.14 0.52 0.07 0.43-0.45 0.71-0.79 0.43-1.38-1.15-4.87-3.77-7.3-3.33-0.41 0.07-0.53 0.61-0.19 0.85 0.46 0.32 1.05 0.77 1.53 1.26 0.37 0.38-0.06 0.98-0.54 0.76-2.09-0.99-6.15-2.99-8.79-4.81-0.42-0.29-0.94 0.19-0.68 0.63 0.38 0.63 0.81 1.32 1.25 1.97 0.29 0.42-0.21 0.94-0.64 0.66-1.79-1.15-4.02-2.71-4.29-3.54-0.27-0.84 0.4 0.85 0.98 2.35 0.18 0.47-0.4 0.85-0.76 0.51-1.29-1.21-3.13-2.93-4.31-4.07-0.32-0.31-0.86-0.04-0.8 0.41l0.03 0.23c0.14 0.95 2.21 3.48 2.05 3.7s-9.16-5.67-11.86-5.91 0.71 1.25 1 1.47c0.29 0.21 2.03 1.44 1.79 1.99s-4.19-1.05-4.3-1.36c-0.06-0.17-1.2-1.13-2.2-1.96-0.38-0.31-0.92 0.08-0.74 0.54 0.38 0.97 0.7 2.04 0.41 2.31-0.57 0.54-3.58-3.92-4.88-4.37s0.91 2.19 0.75 2.86-4.02-2.95-5.16-2.78c-0.61 0.09 0.48 1.44 1.56 2.78 0.35 0.44-0.23 1.01-0.67 0.66-1.92-1.55-4.6-3.53-6.36-4.09-0.34-0.11-0.68 0.19-0.61 0.54 0.05 0.23 0.06 0.44-0.04 0.51-0.24 0.16-1.88-0.82-2.47-0.86-0.39-0.03 1.93 1.77 3.5 3.27 0.4 0.38-0.07 1.02-0.55 0.75-2.8-1.52-8.02-4.16-10.93-4.4-0.4-0.03-0.65 0.44-0.4 0.76 0.22 0.28 0.61 0.66 1.27 1.15 2.04 1.5 2.64 2 1.27 1.94-1.1-0.04-6.98-3.42-9.56-5.52-0.36-0.3-0.89 0.07-0.75 0.51 0.31 0.92 0.81 2.12 1.63 3.47 1.63 2.67 5.43 7.48 6.16 8.4 0.08 0.1 0.19 0.16 0.32 0.17l85.9 8.55c0.31 0.03 0.56-0.23 0.52-0.54l-0.54-3.64'
        />
        <path fill={st15} d='m1328.3 878.69' />
        <path
          fill={st15}
          d='m1058.3 413.82s-2.7-10.71 8.57-13.78h2.07l-0.56 6.33-5.11 7.45h-4.97z'
        />
        <path
          fill={st13}
          d='m1080.1 404.14c-1.79-1.95-4.48-3.5-8.12-4.14-3.4-0.6-6.06-0.01-8.11 1.27 0.77-0.34 1.63-0.62 2.6-0.81l-0.13 4.42c-0.01 0.24-0.07 0.47-0.19 0.68l-3.34 6.04c-0.16 0.3-0.42 0.53-0.74 0.66l-3.77 1.56c0.12 1.19 0.38 2.2 0.65 2.95 0.52 0.91 1.17 1.74 1.98 2.41 3.11 2.59 7.61 2.41 11.64 2.1-2.3-0.26-4.56-0.84-6.7-1.71-0.53-0.21-1.14-0.61-1.05-1.17 0.12-0.77 1.36-0.76 1.77-1.42 0.27-0.43 0.1-0.99 0.1-1.49 0.01-1.43 1.43-2.46 2.81-2.79 1.39-0.33 2.86-0.19 4.24-0.54s2.77-1.45 2.7-2.87c-0.03-0.64-0.35-1.23-0.49-1.86s-0.02-1.41 0.55-1.7c0.31-0.16 0.69-0.13 1.04-0.1 1.3 0.13 2.6 0.25 3.91 0.38-0.37-0.67-0.83-1.3-1.35-1.87z'
        />
        <path
          fill={st13}
          d='m1090.6 467.98c-0.14-0.54-0.35-1.06-0.45-1.61-0.1-0.61-0.04-1.24 0.01-1.86 0.15-1.59 0.29-3.18 0.44-4.78 0.1-1.13 0.19-2.35-0.35-3.34-0.41-0.74-1.14-1.33-1.55-2.04-0.46-0.79-1.13-1.43-1.94-1.87l-0.12-0.07c-0.37 0.54-0.56 1.16-0.63 1.8 0.23 0.57 0.8 2.93 0.79 3.61s0.88 1.86 0.88 3.76 0.42 2.51 0.42 3.88 0.23 1.9 0.23 2.55-0.23 2.01-0.23 2.47v3.27c0 0.84 0.46 3.5 0.38 4.37-0.06 0.68 0.79 1.01 1.25 0.7 0.11-0.45 0.07-1.01 0.03-1.48-0.25-3.14 1.61-6.29 0.84-9.36z'
        />
        <path
          fill={st15}
          d='m1064.6 461.83s13.08 8.42 20.51 8.49c0 0 0.1-4.61-1.77-8.49h-18.74z'
        />
        <path
          fill={st15}
          d='m1088.5 453.36c0.38-0.88 0.28-1.89 0.18-2.84-0.22-2.07-0.32-9.4-0.55-11.47 0 0-0.21-2.83-1.03-4.68-0.34-1-0.64-1.23-0.64-1.23l-0.74 20.88 0.67 3.19-0.34 5.67v1.78c0.63-1.34 1.27-2.67 1.9-4.01 0.27-0.56 0.54-1.15 0.5-1.77-0.06-0.84-0.68-1.56-0.96-2.34 0.05-0.58 0.1-1.15 0.15-1.71 0.25-0.5 0.63-0.96 0.86-1.47z'
        />
        <path
          fill={st13}
          d='m1066.9 400.04s-4.15 0-7.61 5.6c0 0 3.81-4.92 7.61-4.96'
        />
        <path
          fill={st15}
          d='m1070.2 423.79s7.57 2.54 15.97 1.95c0 0-1.71-2.8-7.34-3.95 0.01 0-1.6 1.91-8.63 2z'
        />
        <path
          fill={st13}
          d='m1091.2 476.38s1.47 0.86 1.43 1.76-1.03 1.89-1.03 2.31c0 0.43-1.39 1.46-0.63 2.25 0 0-1.14-0.02-0.53-1.75s1.25-2.17 1.3-3.16c-0.01-0.01-0.22-1.26-0.54-1.41z'
        />
        <path
          fill={st1}
          d='m1048.1 381.34h-0.38c-0.67 0-1.21-0.54-1.21-1.21v-8.07h2.8v8.07c0 0.67-0.54 1.21-1.21 1.21z'
        />
        <path
          fill={st1}
          d='m1049.6 374.06h-3.34c-0.09 0-0.16-0.07-0.16-0.16v-8.72c1.2-0.29 2.46-0.29 3.66 0v8.72c0 0.09-0.07 0.16-0.16 0.16z'
        />
        <path
          fill={st13}
          d='m1049.7 367.77s-2.68 1.21-3.66 3.42v-6.01s2.05-0.47 3.66 0v2.59z'
        />
        <polygon
          fill={st15}
          points='1046.2 374.06 1049.3 376.53 1049.3 374.06'
        />
        <path
          fill={st15}
          d='m1046.4 420.75s2.37-4.79 10.64-5.34l-0.01-0.06c-0.1-0.59-0.39-1.13-0.84-1.54 0 0-6.94 0.52-10.1 5.27l0.31 1.67z'
        />
        <path
          fill={st12}
          d='m1046.5 420.71c0.14-0.25 1-1.73 3.11-3.06-0.09-0.53-0.16-1.06-0.21-1.59-1.19 0.73-2.32 1.69-3.18 2.95 0.06 0.54 0.16 1.12 0.28 1.7z'
        />
        <path
          fill={st15}
          d='m1046.1 417.73s1.32-4.7 9.6-5.24v-0.02c0.07-0.56-0.05-1.13-0.34-1.61 0 0-6.4 0.46-9.57 5.2l0.31 1.67z'
        />
        <path
          fill={st12}
          d='m1046.1 417.73c0.14-0.25 1.11-2.19 3.23-3.53-0.09-0.53-0.12-0.84 0.01-1.41-1.19 0.73-2.59 1.86-3.45 3.12 0.06 0.54 0.1 1.24 0.21 1.82z'
        />
        <path
          fill={st15}
          d='m1086.5 439.06s1.19 0.27 5.84-1.02l0.29 1.41s-2.14 0.95-6.39 1.03'
        />
        <path
          fill={st15}
          d='m1086.5 442.12s1.07 0.35 6.5-0.94l0.31 1.46s-2.14 0.83-7.11 0.92'
        />
        <path
          fill={st11}
          d='m1055.5 509.2s4.4 2.4 11.65 1.24l-0.36 1.78s-5.43 1.16-11.03-1.15l-0.26-1.87z'
        />
        <path
          fill={st12}
          d='m1058.6 510.27c-1.73-0.39-2.8-0.89-3.07-1.03 0.14 0.55 0.26 1.12 0.3 1.89 1.08 0.44 2.15 0.74 3.17 0.96-0.15-0.61-0.29-1.21-0.4-1.82z'
        />
        <path
          fill={st11}
          d='m1055.3 513.25s4.4 2.4 11.65 1.24l-0.36 1.78s-5.43 1.16-11.03-1.15l-0.26-1.87z'
        />
        <path
          fill={st12}
          d='m1059.6 514.54c-1.77-0.48-3.7-0.98-3.97-1.11 0.14 0.55-0.17 0.82-0.22 1.71 1.08 0.44 2.22 0.81 4.44 1.18-0.15-0.6-0.14-1.17-0.25-1.78z'
        />
        <path
          fill={st11}
          d='m1077.1 510.67s5.54 1.23 10.47-0.2l0.04 0.12c0.16 0.53 0.09 1.1-0.19 1.58 0 0-3.34 1.19-10.08 0l-0.24-1.5z'
        />
        <path
          fill={st14}
          d='m1109.2 471.74c0.02-0.14 0.04-0.27 0.06-0.4-0.03 0.13-0.05 0.26-0.06 0.4z'
        />
        <path
          fill={st12}
          d='m1077.3 512.17c1.25 0.22 2.38 0.36 3.39 0.43 0-0.26 0.01-0.51 0.03-0.77 0.02-0.24 0.04-0.47 0.07-0.71-1.98-0.1-3.45-0.39-3.73-0.45 0.09 0.47 0.17 0.98 0.24 1.5z'
        />
        <path
          fill={st11}
          d='m1077.1 513.97s5.54 1.23 10.47-0.2l0.04 0.12c0.16 0.53 0.09 1.1-0.19 1.58 0 0-3.34 1.19-10.08 0l-0.24-1.5z'
        />
        <path
          fill={st12}
          d='m1077.6 515.5c1.25 0.22 2.28 0.33 3.3 0.4 0-0.26-0.12-0.52-0.1-0.77 0.02-0.24 0.02-0.47 0.05-0.71-2.13-0.17-3.04-0.32-3.32-0.38-0.02 0.54 0 0.94 0.07 1.46z'
        />
        <polygon
          fill={st3}
          points='-0.34 573.18 -0.34 883.11 1365.6 883.11 1365.7 527.29'
        />
        <g opacity={0.2}>
          <path
            fill={st1}
            d='m156.09 436.44c12.66 59.38 12.01 93.03 12.01 93.03s-86.39-107.38-82.63-193.64c0 0 57.96 41.23 70.62 100.61z'
          />
        </g>
        <path
          fill={st1}
          d='m746.19 558.61c0.04 0.07 0.11 0.14 0.2 0.22-0.26-0.36-0.39-0.51-0.2-0.22z'
        />
        <path
          fill={st1}
          d='m804.73 550.47c0.04 0.07 0.11 0.14 0.2 0.22-0.26-0.36-0.38-0.51-0.2-0.22z'
        />
        <path
          fill={st1}
          d='m868.12 545.71c0.04 0.06 0.1 0.13 0.18 0.19-0.24-0.31-0.35-0.45-0.18-0.19z'
        />
        <path
          fill={st1}
          d='m505.88 592.32c0.04 0.07 0.11 0.14 0.2 0.21-0.26-0.35-0.39-0.5-0.2-0.21z'
        />
        <path
          fill={st1}
          d='m540.41 585c0.05 0.08 0.12 0.15 0.22 0.24-0.29-0.39-0.42-0.56-0.22-0.24z'
        />
        <path
          fill={st1}
          d='m604.31 576.12c0.05 0.08 0.12 0.15 0.22 0.24-0.29-0.39-0.42-0.56-0.22-0.24z'
        />
        <path
          fill={st1}
          d='m466.1 604.37c0.06 0.05 0.15 0.1 0.25 0.14-0.35-0.25-0.52-0.35-0.25-0.14z'
        />
        <path
          fill={st1}
          d='m674.29 567.24c0.05 0.08 0.12 0.15 0.22 0.24-0.29-0.4-0.43-0.57-0.22-0.24z'
        />
        <path
          fill={st1}
          d='m1030.4 523.59c0.04 0.06 0.1 0.13 0.18 0.2-0.23-0.33-0.34-0.47-0.18-0.2z'
        />
        <path
          fill={st1}
          d='m967.32 530.28c0.05 0.09 0.13 0.18 0.24 0.27-0.31-0.44-0.46-0.64-0.24-0.27z'
        />
        <path
          fill={st1}
          d='m1097 517.07c0.04 0.06 0.1 0.13 0.18 0.2-0.24-0.33-0.35-0.47-0.18-0.2z'
        />
        <path
          fill={st1}
          d='m1150.1 510.39c0.04 0.06 0.1 0.13 0.18 0.2-0.23-0.32-0.34-0.47-0.18-0.2z'
        />
        <path
          fill={st1}
          d='m1208.1 503.78c0.04 0.06 0.1 0.13 0.18 0.2-0.23-0.32-0.34-0.47-0.18-0.2z'
        />
        <path
          fill={st1}
          d='m1246.4 496.86c0.04 0.06 0.1 0.13 0.18 0.2-0.23-0.33-0.34-0.47-0.18-0.2z'
        />
        <path
          fill={st1}
          d='m1299.4 490.19c0.04 0.06 0.1 0.13 0.18 0.2-0.24-0.33-0.35-0.47-0.18-0.2z'
        />
        <path
          fill={st1}
          d={`
				m1365.7
				486.72v-0.9h-0.01l0.01-3.86s-0.92-0.26-2.25-0.2c-0.04
				0-0.07
				0-0.11-0.01-0.38-0.11-2.71-0.83-4.13-1.57-0.29-0.15-0.62
				0.15-0.48
				0.44
				0.42
				0.85
				1.04
				1.98
				1.72
				2.71-1.12-1.05-4.93-4.26-8.47-3.34-0.3
				0.08-0.36
				0.47-0.09
				0.6
				0.31
				0.16
				0.68
				0.38
				1.04
				0.63
				0.29
				0.21
				0.05
				0.64-0.3
				0.58h-0.02c-0.3-0.05-0.52
				0.27-0.36
				0.51
				0.07
				0.1
				0.13
				0.21
				0.18
				0.33
				0.12
				0.28-0.21
				0.56-0.49
				0.43-1.16-0.53-4.04-1.69-5.69-0.96-0.28
				0.12-0.28
				0.5
				0
				0.6
				0.38
				0.14
				0.87
				0.33
				1.28
				0.58
				0.32
				0.19
				0.11
				0.67-0.26
				0.61-1.63-0.3-4.82-0.93-6.98-1.69-0.34-0.12-0.63
				0.29-0.38
				0.54
				0.37
				0.36
				0.78
				0.75
				1.2
				1.11
				0.27
				0.23
				0
				0.67-0.35
				0.56-1.27-0.4-2.83-0.96-3.41-1.44
				0.23
				0.31
				0.56
				0.77
				0.88
				1.22
				0.2
				0.28-0.15
				0.65-0.46
				0.48-1.1-0.59-2.68-1.42-3.69-1.99-0.28-0.15-0.62
				0.13-0.5
				0.42l0.06
				0.15c0.25
				0.61
				2.11
				1.96
				2.03
				2.13-0.08
				0.18-7.38-2.21-9.33-1.89-1.95
				0.31
				0.7
				0.72
				0.94
				0.81s1.67
				0.61
				1.58
				1.03c-0.08
				0.42-3.13
				0.03-3.25-0.16-0.07-0.1-1.03-0.55-1.87-0.93-0.31-0.14-0.64
				0.22-0.44
				0.49
				0.42
				0.59
				0.82
				1.25
				0.66
				1.49-0.32
				0.46-3.15-2.02-4.14-2.09s0.99
				1.32
				0.98
				1.8-3.31-1.28-4.09-0.96c-0.42
				0.17
				0.57
				0.89
				1.54
				1.6
				0.32
				0.23
				0
				0.72-0.37
				0.56-1.6-0.71-3.81-1.57-5.14-1.63-0.26-0.01-0.45
				0.25-0.35
				0.47
				0.07
				0.15
				0.11
				0.29
				0.06
				0.35-0.14
				0.15-1.46-0.22-1.88-0.14-0.27
				0.05
				1.53
				0.8
				2.87
				1.52-0.27
				0.08-0.32
				0.45-0.07
				0.59
				0.04
				0.02
				0.08
				0.05
				0.12
				0.07-0.06
				0.02-0.12
				0.03-0.2
				0.01-2.22-0.53-6.33-1.39-8.43-1.04-0.29
				0.05-0.39
				0.41-0.17
				0.58
				0.2
				0.15
				0.53
				0.34
				1.08
				0.55
				1.68
				0.65
				2.18
				0.88
				1.2
				1.09-0.78
				0.17-5.48-1.07-7.64-2.03-0.3-0.13-0.62
				0.21-0.45
				0.48
				0.36
				0.56
				0.91
				1.29
				1.7
				2.05
				0.52
				0.5
				1.24
				1.11
				2
				1.73-1.16-0.41-2.5-0.95-3.02-1.4
				0.22
				0.31
				0.55
				0.78
				0.86
				1.22
				0.2
				0.28-0.13
				0.64-0.43
				0.47-1.06-0.6-2.57-1.47-3.55-2.04-0.27-0.16-0.58
				0.11-0.47
				0.4l0.06
				0.15c0.25
				0.61
				2.05
				1.98
				1.98
				2.16-0.07
				0.17-7.07-2.33-8.91-2.06-1.85
				0.27
				0.68
				0.73
				0.91
				0.82
				0.23
				0.1
				1.6
				0.64
				1.53
				1.05s-2.98-0.03-3.1-0.22c-0.07-0.1-0.99-0.57-1.8-0.96-0.3-0.15-0.6
				0.2-0.41
				0.48
				0.42
				0.59
				0.81
				1.26
				0.66
				1.49-0.29
				0.45-3.04-2.06-3.98-2.15-0.95-0.09
				0.97
				1.33
				0.97
				1.8
				0
				0.48-3.17-1.34-3.91-1.04-0.4
				0.16
				0.56
				0.89
				1.5
				1.62
				0.31
				0.24
				0.01
				0.72-0.34
				0.55-1.54-0.73-3.66-1.63-4.93-1.72-0.25-0.02-0.43
				0.24-0.32
				0.46
				0.07
				0.15
				0.11
				0.29
				0.06
				0.35-0.13
				0.15-1.39-0.25-1.79-0.18-0.26
				0.04
				1.58
				0.88
				2.88
				1.63
				0.33
				0.19
				0.12
				0.69-0.25
				0.6-2.13-0.57-6.05-1.5-8.04-1.19-0.28
				0.04-0.36
				0.4-0.15
				0.57
				0.19
				0.15
				0.51
				0.34
				1.04
				0.56
				1.47
				0.62
				1.99
				0.87
				1.38
				1.05-0.71-0.24-2.53-0.9-3.71-1.55-0.28-0.15-0.59
				0.14-0.45
				0.43
				0.05
				0.11
				0.11
				0.22
				0.17
				0.33-1.3-0.41-2.64-0.89-3.53-1.32-0.23-0.11-0.46
				0.07-0.46
				0.29-0.86-0.22-1.75-0.28-2.62-0.06-0.28
				0.07-0.33
				0.46-0.08
				0.6
				0.3
				0.17
				0.66
				0.39
				1
				0.65
				0.28
				0.21
				0.06
				0.64-0.28
				0.57h-0.02c-0.28-0.06-0.49
				0.26-0.33
				0.5
				0.07
				0.1
				0.13
				0.21
				0.18
				0.33
				0.12
				0.28-0.19
				0.55-0.46
				0.42-1.12-0.55-3.88-1.75-5.43-1.06-0.26
				0.12-0.26
				0.5
				0.01
				0.6
				0.36
				0.14
				0.83
				0.35
				1.23
				0.6
				0.31
				0.2
				0.12
				0.67-0.24
				0.6-1.56-0.33-4.61-1.02-6.67-1.82-0.33-0.13-0.6
				0.28-0.35
				0.53
				0.36
				0.36
				0.76
				0.76
				1.16
				1.12
				0.26
				0.24
				0.01
				0.66-0.32
				0.55-1.21-0.42-2.71-1.01-3.28-1.49
				0.22
				0.31
				0.55
				0.78
				0.86
				1.22
				0.2
				0.28-0.13
				0.64-0.43
				0.47-1.06-0.6-2.57-1.47-3.55-2.04-0.27-0.16-0.58
				0.11-0.47
				0.4l0.06
				0.15c0.25
				0.61
				2.05
				1.98
				1.98
				2.16-0.07
				0.17-7.07-2.33-8.91-2.06-1.85
				0.27
				0.68
				0.73
				0.91
				0.82
				0.23
				0.1
				1.6
				0.64
				1.53
				1.05s-2.98-0.03-3.1-0.22c-0.07-0.1-0.99-0.57-1.8-0.96-0.3-0.15-0.6
				0.2-0.41
				0.48
				0.42
				0.59
				0.81
				1.26
				0.66
				1.49-0.29
				0.45-3.04-2.06-3.98-2.15-0.95-0.09
				0.97
				1.33
				0.97
				1.8
				0
				0.48-3.17-1.34-3.91-1.04-0.4
				0.16
				0.56
				0.89
				1.5
				1.62
				0.31
				0.24
				0.01
				0.72-0.34
				0.55-1.54-0.73-3.66-1.63-4.93-1.72-0.25-0.02-0.43
				0.24-0.32
				0.46
				0.07
				0.15
				0.11
				0.29
				0.06
				0.35-0.13
				0.15-1.39-0.25-1.79-0.18-0.24
				0.04
				1.32
				0.76
				2.59
				1.46-0.53-0.04-1.06-0.01-1.58
				0.12-0.11
				0.03-0.18
				0.1-0.21
				0.18-2.1-0.49-4.7-0.96-6.2-0.73-0.28
				0.04-0.36
				0.4-0.15
				0.57
				0.19
				0.15
				0.51
				0.34
				1.04
				0.57
				1.61
				0.68
				2.09
				0.92
				1.17
				1.1-0.74
				0.15-5.23-1.17-7.31-2.17-0.29-0.14-0.59
				0.19-0.42
				0.47
				0.36
				0.57
				0.89
				1.3
				1.66
				2.07l0.24
				0.24c-0.32-0.11-0.62-0.21-0.9-0.32-0.33-0.13-0.6
				0.28-0.35
				0.53
				0.36
				0.36
				0.76
				0.76
				1.16
				1.12
				0.01
				0.01
				0.01
				0.02
				0.02
				0.02-0.44
				0.06-0.88
				0.11-1.33
				0.17-0.95-0.36-1.87-0.77-2.29-1.13
				0.22
				0.31
				0.55
				0.78
				0.86
				1.22
				0.02
				0.03
				0.03
				0.06
				0.04
				0.08-0.31
				0.04-0.62
				0.08-0.94
				0.12-1.01-0.57-2.24-1.28-3.08-1.78-0.27-0.16-0.58
				0.11-0.47
				0.4l0.06
				0.15c0.15
				0.37
				0.84
				1
				1.37
				1.49-0.43
				0.05-0.86
				0.11-1.3
				0.16-2.23-0.67-5.77-1.73-7.01-1.55-1.85
				0.27
				0.68
				0.73
				0.91
				0.82s1.6
				0.64
				1.53
				1.05-2.98-0.03-3.1-0.22c-0.07-0.1-0.99-0.57-1.8-0.96-0.3-0.15-0.6
				0.2-0.41
				0.48
				0.42
				0.59
				0.81
				1.26
				0.66
				1.49-0.02
				0.03-0.04
				0.04-0.08
				0.05h-0.02c-0.57
				0.07-3.01-2.12-3.89-2.2-0.95-0.09
				0.97
				1.33
				0.97
				1.8
				0
				0.48-3.17-1.34-3.91-1.04-0.4
				0.16
				0.56
				0.89
				1.5
				1.62
				0.18
				0.14
				0.15
				0.36
				0.03
				0.49-0.13
				0.02-0.27
				0.03-0.4
				0.05-1.54-0.73-3.64-1.62-4.9-1.71-0.25-0.02-0.43
				0.24-0.32
				0.46
				0.07
				0.15
				0.11
				0.29
				0.06
				0.35-0.11
				0.12-0.97-0.12-1.5-0.18
				0.85-1.63
				1.82-3.2
				2.85-4.71
				3-4.38
				6.53-8.41
				9.23-12.98
				0.34-0.57
				0.5-1.54-0.14-1.68-8.03
				5.73-16.66
				12.36-18.73
				21.99-0.02-0.01-0.04-0.01-0.07-0.02-1.35-7.76
				0.91-15.75
				4.34-22.85
				3.45-7.15
				8.06-13.68
				11.75-20.72-13.04
				8.02-20.97
				23.43-20.59
				38.66-0.92-3.6-2.83-7.08-4.74-10.31-3.15-5.33-6.46-10.65-10.82-15.05-4.37-4.39-9.92-7.85-16.07-8.66
				4.88
				2.56
				9.34
				5.93
				13.13
				9.93
				6.78
				7.17
				11.24
				16.1
				15.16
				25.22-5.03-3.91-10.2-7.66-15.48-11.23
				3.39
				5.48
				7.25
				10.67
				11.52
				15.5-0.16
				0.08-0.24
				0.3-0.13
				0.47
				0.07
				0.1
				0.13
				0.21
				0.18
				0.33
				0.06
				0.13
				0.02
				0.26-0.07
				0.35-0.14
				0.02-0.28
				0.03-0.41
				0.05-1.13-0.55-3.86-1.73-5.4-1.05-0.26
				0.12-0.26
				0.49
				0.01
				0.6
				0.36
				0.14
				0.83
				0.35
				1.23
				0.6
				0.14
				0.09
				0.17
				0.23
				0.14
				0.36-0.32
				0.04-0.63
				0.08-0.95
				0.12-1.65-0.36-4.27-0.98-6.1-1.69-0.33-0.13-0.6
				0.28-0.35
				0.53
				0.36
				0.36
				0.76
				0.76
				1.16
				1.12
				0.26
				0.24
				0.01
				0.66-0.32
				0.55-1.21-0.42-2.71-1.01-3.28-1.49
				0.22
				0.31
				0.55
				0.78
				0.86
				1.22
				0.2
				0.28-0.13
				0.64-0.43
				0.47-1.06-0.6-2.57-1.47-3.55-2.04-0.27-0.16-0.58
				0.11-0.47
				0.4l0.06
				0.15c0.23
				0.57
				1.78
				1.78
				1.96
				2.09l-0.24
				0.03c-1.28-0.31-7.01-2.27-8.66-2.03-1.85
				0.27
				0.68
				0.73
				0.91
				0.82
				0.23
				0.1
				1.6
				0.64
				1.53
				1.05s-2.98-0.03-3.1-0.22c-0.07-0.1-0.99-0.57-1.8-0.96-0.3-0.15-0.6
				0.2-0.41
				0.48
				0.42
				0.59
				0.81
				1.26
				0.66
				1.49-0.29
				0.45-3.04-2.06-3.98-2.15-0.95-0.09
				0.97
				1.33
				0.97
				1.8
				0
				0.48-3.17-1.34-3.91-1.04-0.4
				0.16
				0.56
				0.89
				1.5
				1.62
				0.31
				0.24
				0.01
				0.72-0.34
				0.55-1.54-0.73-3.66-1.63-4.93-1.72-0.25-0.02-0.43
				0.24-0.32
				0.46
				0.07
				0.15
				0.11
				0.29
				0.06
				0.35-0.13
				0.15-1.39-0.25-1.79-0.18-0.26
				0.04
				1.58
				0.88
				2.88
				1.63
				0.33
				0.19
				0.12
				0.69-0.25
				0.6-2.13-0.57-6.05-1.5-8.04-1.19-0.28
				0.04-0.36
				0.4-0.15
				0.57
				0.19
				0.15
				0.51
				0.34
				1.04
				0.57
				0.98
				0.41
				1.54
				0.66
				1.62
				0.84-0.21
				0.03-0.41
				0.05-0.62
				0.08-0.85-0.3-2.32-0.86-3.33-1.42-0.28-0.15-0.59
				0.14-0.45
				0.43
				0.05
				0.11
				0.11
				0.22
				0.17
				0.33-1.3-0.41-2.64-0.89-3.53-1.32-0.23-0.11-0.46
				0.07-0.46
				0.29-0.86-0.22-1.75-0.28-2.62-0.06-0.28
				0.07-0.33
				0.46-0.08
				0.6
				0.3
				0.17
				0.66
				0.39
				1
				0.65
				0.28
				0.21
				0.06
				0.64-0.28
				0.57h-0.02c-0.28-0.06-0.49
				0.26-0.33
				0.5
				0.07
				0.1
				0.13
				0.21
				0.18
				0.33
				0.06
				0.14
				0.01
				0.27-0.08
				0.36-0.13
				0.02-0.27
				0.03-0.4
				0.05-1.13-0.55-3.87-1.74-5.41-1.05-0.26
				0.12-0.26
				0.49
				0.01
				0.6
				0.36
				0.14
				0.83
				0.35
				1.23
				0.6
				0.14
				0.09
				0.17
				0.24
				0.14
				0.36-0.31
				0.04-0.62
				0.08-0.92
				0.12-1.65-0.36-4.28-0.98-6.12-1.7-0.33-0.13-0.6
				0.28-0.35
				0.53
				0.36
				0.36
				0.76
				0.76
				1.16
				1.12
				0.26
				0.24
				0.01
				0.66-0.32
				0.55-1.21-0.42-2.71-1.01-3.28-1.49
				0.22
				0.31
				0.55
				0.78
				0.86
				1.22
				0.2
				0.28-0.13
				0.64-0.43
				0.47-1.06-0.6-2.57-1.47-3.55-2.04-0.27-0.16-0.58
				0.11-0.47
				0.4l0.06
				0.15c0.23
				0.57
				1.82
				1.81
				1.97
				2.11-0.07
				0.01-0.14
				0.02-0.21
				0.03-1.2-0.28-7.03-2.28-8.69-2.03-1.85
				0.27
				0.68
				0.73
				0.91
				0.82
				0.23
				0.1
				1.6
				0.64
				1.53
				1.05s-2.98-0.03-3.1-0.22c-0.07-0.1-0.99-0.57-1.8-0.96-0.3-0.15-0.6
				0.2-0.41
				0.48
				0.42
				0.59
				0.81
				1.26
				0.66
				1.49-0.29
				0.45-3.04-2.06-3.98-2.15-0.95-0.09
				0.97
				1.33
				0.97
				1.8
				0
				0.48-3.17-1.34-3.91-1.04-0.4
				0.16
				0.56
				0.89
				1.5
				1.62
				0.31
				0.24
				0.01
				0.72-0.34
				0.55-1.54-0.73-3.66-1.63-4.93-1.72-0.25-0.02-0.43
				0.24-0.32
				0.46
				0.07
				0.15
				0.11
				0.29
				0.06
				0.35-0.13
				0.15-1.39-0.25-1.79-0.18-0.26
				0.04
				1.58
				0.88
				2.88
				1.63
				0.33
				0.19
				0.12
				0.69-0.25
				0.6-2.13-0.57-6.05-1.5-8.04-1.19-0.28
				0.04-0.36
				0.4-0.15
				0.57
				0.19
				0.15
				0.51
				0.34
				1.04
				0.56
				1.03
				0.44
				1.6
				0.69
				1.63
				0.86-0.44
				0.06-0.87
				0.11-1.31
				0.17-1.6-0.29-4.8-1.3-6.46-2.1-0.29-0.14-0.59
				0.19-0.42
				0.47
				0.36
				0.57
				0.89
				1.3
				1.66
				2.07l0.2
				0.2c-0.95
				0.12-1.89
				0.24-2.84
				0.36l-0.11-0.27-0.76-0.21s-2.28-0.58-3.54-0.54c-0.04
				0-0.07
				0-0.1-0.01-0.36-0.12-2.59-0.88-3.96-1.64-0.28-0.15-0.59
				0.14-0.45
				0.43
				0.41
				0.85
				1.03
				1.99
				1.69
				2.72-1.09-1.06-4.78-4.32-8.13-3.48-0.28
				0.07-0.33
				0.46-0.08
				0.6
				0.3
				0.17
				0.66
				0.39
				1
				0.65
				0.28
				0.21
				0.06
				0.64-0.28
				0.57h-0.02c-0.28-0.06-0.49
				0.26-0.33
				0.5
				0.07
				0.1
				0.13
				0.21
				0.18
				0.33
				0.12
				0.28-0.19
				0.55-0.46
				0.42-1.12-0.55-3.88-1.75-5.43-1.06-0.26
				0.12-0.26
				0.49
				0.01
				0.6
				0.36
				0.14
				0.83
				0.35
				1.23
				0.6
				0.31
				0.2
				0.12
				0.67-0.24
				0.6-1.56-0.33-4.61-1.02-6.67-1.82-0.33-0.13-0.6
				0.28-0.35
				0.53
				0.36
				0.36
				0.76
				0.76
				1.16
				1.12
				0.26
				0.24
				0.01
				0.66-0.32
				0.55-1.21-0.42-2.71-1.01-3.28-1.49
				0.22
				0.31
				0.55
				0.78
				0.86
				1.22
				0.2
				0.28-0.13
				0.64-0.43
				0.47-1.06-0.6-2.57-1.47-3.55-2.04-0.27-0.16-0.58
				0.11-0.47
				0.4l0.06
				0.15c0.25
				0.61
				2.05
				1.98
				1.98
				2.16-0.07
				0.17-7.07-2.33-8.91-2.06-1.85
				0.27
				0.68
				0.73
				0.91
				0.82
				0.23
				0.1
				1.6
				0.64
				1.53
				1.05s-2.98-0.03-3.1-0.22c-0.07-0.1-0.99-0.57-1.8-0.96-0.3-0.15-0.6
				0.2-0.41
				0.48
				0.42
				0.59
				0.81
				1.26
				0.66
				1.49-0.29
				0.45-3.04-2.06-3.98-2.15-0.95-0.09
				0.97
				1.33
				0.97
				1.8
				0
				0.48-3.17-1.34-3.91-1.04-0.4
				0.16
				0.56
				0.89
				1.5
				1.62
				0.31
				0.24
				0.01
				0.72-0.34
				0.55-1.54-0.73-3.66-1.63-4.93-1.72-0.25-0.02-0.43
				0.24-0.32
				0.46
				0.07
				0.15
				0.11
				0.29
				0.06
				0.35-0.13
				0.15-1.39-0.25-1.79-0.18-0.26
				0.04
				1.58
				0.88
				2.88
				1.63
				0.33
				0.19
				0.12
				0.69-0.25
				0.6-2.13-0.57-6.05-1.5-8.04-1.19-0.28
				0.04-0.36
				0.4-0.15
				0.57
				0.19
				0.15
				0.51
				0.34
				1.04
				0.57
				1.61
				0.68
				2.09
				0.92
				1.17
				1.1-0.74
				0.15-5.23-1.17-7.31-2.17-0.29-0.14-0.59
				0.19-0.42
				0.47
				0.01
				0.01
				0.01
				0.02
				0.02
				0.03-0.34-0.13-0.66
				0.23-0.49
				0.59
				0.54
				1.12
				1.33
				2.61
				2.17
				3.63h-0.02c-1.55-1.57-6.27-5.88-10.45-4.87-0.36
				0.09-0.41
				0.6-0.08
				0.8
				0.39
				0.24
				0.86
				0.55
				1.3
				0.91
				0.36
				0.29
				0.1
				0.87-0.34
				0.76-0.01
				0-0.02
				0-0.03-0.01-0.36-0.09-0.62
				0.34-0.41
				0.67
				0.09
				0.14
				0.18
				0.29
				0.24
				0.45
				0.16
				0.38-0.22
				0.74-0.57
				0.55-1.45-0.78-5.04-2.5-7.01-1.62-0.33
				0.15-0.31
				0.66
				0.04
				0.81
				0.47
				0.2
				1.08
				0.5
				1.6
				0.85
				0.4
				0.27
				0.18
				0.91-0.28
				0.8-2.01-0.49-5.95-1.53-8.63-2.68-0.42-0.18-0.75
				0.36-0.43
				0.71
				0.47
				0.5
				1
				1.05
				1.53
				1.56
				0.35
				0.33
				0.04
				0.9-0.4
				0.73-1.57-0.61-3.52-1.45-4.26-2.13
				0.29
				0.42
				0.73
				1.07
				1.15
				1.68
				0.26
				0.39-0.14
				0.86-0.53
				0.62-1.38-0.85-3.35-2.07-4.63-2.88-0.35-0.22-0.75
				0.14-0.59
				0.53l0.08
				0.21c0.34
				0.84
				2.7
				2.75
				2.61
				2.98s-9.15-3.39-11.51-3.08
				0.9
				1.01
				1.19
				1.15c0.3
				0.14
				2.07
				0.92
				2
				1.47-0.08
				0.55-3.82-0.14-3.99-0.4-0.09-0.14-1.29-0.8-2.34-1.36-0.39-0.21-0.76
				0.26-0.51
				0.64
				0.55
				0.82
				1.08
				1.73
				0.89
				2.04-0.36
				0.6-3.97-2.89-5.19-3.04-1.22-0.16
				1.29
				1.82
				1.31
				2.47
				0.02
				0.64-4.12-1.91-5.06-1.53-0.5
				0.21
				0.74
				1.22
				1.98
				2.24
				0.41
				0.33
				0.04
				0.97-0.42
				0.73-2-1.04-4.75-2.33-6.38-2.49-0.32-0.03-0.54
				0.31-0.39
				0.62
				0.09
				0.2
				0.16
				0.39
				0.09
				0.47-0.16
				0.2-1.79-0.38-2.31-0.3-0.34
				0.05
				2.06
				1.24
				3.75
				2.3
				0.43
				0.27
				0.18
				0.94-0.3
				0.8-2.75-0.84-7.82-2.24-10.37-1.88-0.35
				0.05-0.45
				0.53-0.17
				0.77
				0.25
				0.21
				0.67
				0.48
				1.35
				0.8
				2.1
				0.97
				2.72
				1.31
				1.53
				1.53-0.08
				0.02-0.2
				0.01-0.35
				0-0.46-0.19-0.85-0.39-1.14-0.59
				0
				0
				0.17
				0.18
				0.43
				0.47-2.05-0.44-6.23-1.92-8.4-3.05-0.38-0.2-0.75
				0.24-0.52
				0.62
				0.48
				0.78
				1.19
				1.78
				2.2
				2.85
				0.79
				0.83
				1.93
				1.89
				3.09
				2.92-1.64-0.42-6.89-2.11-8.45-1.86-1.84
				0.3
				0.69
				0.72
				0.92
				0.81s1.61
				0.62
				1.54
				1.03-2.98
				0.01-3.1-0.18c-0.13-0.19-3.04-1.5-3.04-1.5s1.79
				2.08
				1.5
				2.54-3.06-2.02-4.01-2.1
				0.99
				1.31
				1
				1.79-3.19-1.3-3.92-0.99c-0.61
				0.26
				2.02
				1.83
				2.84
				2.67-0.15
				0.02-0.3
				0.04-0.45
				0.06-1.56-0.77-5.37-2.54-6.73-2.19
				0
				0
				0.46
				0.62
				0.33
				0.77s-1.39-0.23-1.79-0.16c-0.33
				0.06
				2.71
				1.33
				3.77
				2.14-0.29
				0.04-0.58
				0.07-0.86
				0.11-2.21-0.57-6.82-1.64-8.69-1.06
				0
				0-0.32
				0.38
				1.3
				1.04
				0.9
				0.37
				1.45
				0.6
				1.6
				0.77-0.52
				0.07-1.04
				0.13-1.56
				0.2-2.23-0.44-6.71-1.89-7.21-2.6
				0
				0
				0.49
				1.24
				1.88
				2.74-0.4-0.13-2.6-0.85-3.96-1.58-0.28-0.15-0.58
				0.15-0.44
				0.43
				0.32
				0.64
				0.76
				1.44
				1.24
				2.1-0.05
				0.01-0.11
				0.01-0.16
				0.02-1.54-1.32-4.68-3.56-7.54-2.8-0.28
				0.07-0.32
				0.46-0.07
				0.6
				0.3
				0.16
				0.66
				0.38
				1.01
				0.63
				0.28
				0.21
				0.07
				0.64-0.27
				0.57h-0.02c-0.28-0.05-0.49
				0.27-0.32
				0.5
				0.07
				0.1
				0.13
				0.21
				0.18
				0.33
				0.12
				0.28-0.18
				0.55-0.45
				0.42-1.12-0.53-3.9-1.7-5.44-0.99-0.26
				0.12-0.25
				0.5
				0.02
				0.6
				0.36
				0.14
				0.84
				0.34
				1.24
				0.58
				0.31
				0.19
				0.13
				0.67-0.23
				0.6-1.56-0.31-4.62-0.96-6.7-1.73-0.33-0.12-0.59
				0.29-0.34
				0.53
				0.36
				0.36
				0.77
				0.75
				1.18
				1.11
				0.27
				0.24
				0.02
				0.66-0.32
				0.55-1.22-0.41-2.72-0.97-3.29-1.45
				0.23
				0.3
				0.56
				0.77
				0.88
				1.21
				0.2
				0.28-0.12
				0.64-0.42
				0.47-1.07-0.59-2.59-1.43-3.58-2-0.27-0.15-0.58
				0.12-0.46
				0.41l0.06
				0.15c0.26
				0.61
				2.08
				1.96
				2
				2.13-0.07
				0.17-7.09-2.24-8.94-1.94-1.84
				0.3
				0.69
				0.72
				0.92
				0.81s1.61
				0.62
				1.54
				1.03-2.98
				0.01-3.1-0.18c-0.07-0.1-1-0.55-1.81-0.94-0.3-0.14-0.6
				0.21-0.4
				0.49
				0.42
				0.59
				0.82
				1.25
				0.67
				1.48-0.29
				0.46-3.06-2.02-4.01-2.1s0.99
				1.31
				1
				1.79-3.19-1.3-3.92-0.99c-0.39
				0.17
				0.57
				0.88
				1.52
				1.6
				0.31
				0.23
				0.02
				0.72-0.33
				0.56-1.55-0.71-3.68-1.59-4.95-1.66-0.25-0.01-0.42
				0.24-0.31
				0.47
				0.07
				0.15
				0.12
				0.29
				0.06
				0.35-0.13
				0.15-1.39-0.23-1.79-0.16-0.26
				0.05
				1.6
				0.86
				2.9
				1.59
				0.33
				0.19
				0.13
				0.69-0.24
				0.6-2.13-0.54-6.07-1.43-8.06-1.09-0.28
				0.05-0.36
				0.4-0.14
				0.58
				0.19
				0.15
				0.52
				0.34
				1.05
				0.55
				1.62
				0.66
				2.1
				0.89
				1.18
				1.09-0.25
				0.05-0.92-0.05-1.79-0.26l-0.68-1.61-0.85-0.23s-2.53-0.61-3.92-0.55c-0.04
				0-0.07
				0-0.11-0.01-0.4-0.13-2.88-0.94-4.4-1.75-0.31-0.16-0.65
				0.16-0.49
				0.48
				0.47
				0.93
				1.16
				2.17
				1.89
				2.97-1.23-1.17-5.34-4.7-9.03-3.73-0.31
				0.08-0.36
				0.51-0.08
				0.66
				0.33
				0.18
				0.73
				0.42
				1.11
				0.7
				0.31
				0.23
				0.08
				0.71-0.3
				0.63h-0.02c-0.31-0.06-0.54
				0.29-0.36
				0.56
				0.08
				0.11
				0.15
				0.24
				0.2
				0.36
				0.14
				0.31-0.2
				0.61-0.5
				0.47-1.24-0.59-4.31-1.88-6.02-1.1-0.29
				0.13-0.28
				0.55
				0.02
				0.66
				0.4
				0.15
				0.93
				0.37
				1.37
				0.65
				0.34
				0.21
				0.14
				0.74-0.25
				0.66-1.73-0.34-5.11-1.06-7.41-1.91-0.36-0.14-0.65
				0.32-0.38
				0.59
				0.4
				0.4
				0.85
				0.83
				1.3
				1.23
				0.29
				0.26
				0.02
				0.73-0.35
				0.61-1.35-0.45-3.01-1.08-3.64-1.6
				0.25
				0.34
				0.62
				0.85
				0.97
				1.34
				0.22
				0.31-0.13
				0.71-0.47
				0.52-1.18-0.65-2.87-1.58-3.96-2.21-0.3-0.17-0.64
				0.13-0.51
				0.45l0.07
				0.17c0.29
				0.68
				2.3
				2.17
				2.22
				2.36s-7.85-2.48-9.89-2.15
				0.76
				0.79
				1.02
				0.9c0.26
				0.1
				1.78
				0.68
				1.7
				1.14-0.07
				0.46-3.29
				0.01-3.43-0.2-0.08-0.11-1.1-0.61-2-1.04-0.34-0.16-0.66
				0.24-0.44
				0.54
				0.47
				0.65
				0.91
				1.38
				0.75
				1.64-0.32
				0.51-3.39-2.24-4.44-2.33s1.09
				1.45
				1.1
				1.98-3.53-1.43-4.34-1.09c-0.44
				0.18
				0.63
				0.98
				1.68
				1.77
				0.35
				0.26
				0.03
				0.79-0.37
				0.61-1.71-0.79-4.07-1.76-5.47-1.84-0.28-0.02-0.47
				0.27-0.35
				0.52
				0.08
				0.16
				0.13
				0.32
				0.07
				0.38-0.14
				0.17-1.54-0.25-1.99-0.17-0.29
				0.05
				1.77
				0.95
				3.21
				1.76
				0.37
				0.21
				0.14
				0.77-0.27
				0.66-2.36-0.6-6.71-1.58-8.91-1.21-0.3
				0.05-0.4
				0.45-0.15
				0.64
				0.22
				0.17
				0.57
				0.37
				1.16
				0.61
				1.63
				0.66
				2.22
				0.93
				1.54
				1.14-0.79-0.26-2.81-0.96-4.13-1.66-0.31-0.16-0.65
				0.16-0.49
				0.48
				0.06
				0.12
				0.12
				0.24
				0.19
				0.37-1.44-0.43-2.93-0.95-3.92-1.41-0.26-0.12-0.51
				0.09-0.51
				0.33-0.96-0.23-1.94-0.28-2.9-0.03-0.31
				0.08-0.36
				0.51-0.08
				0.66
				0.33
				0.18
				0.73
				0.42
				1.11
				0.7
				0.31
				0.23
				0.08
				0.71-0.3
				0.63h-0.02c-0.31-0.06-0.54
				0.29-0.36
				0.56
				0.08
				0.11
				0.15
				0.23
				0.2
				0.36
				0.14
				0.31-0.2
				0.61-0.5
				0.47-1.24-0.59-4.31-1.88-6.02-1.1-0.29
				0.13-0.28
				0.55
				0.02
				0.66
				0.4
				0.15
				0.93
				0.37
				1.37
				0.65
				0.34
				0.21
				0.14
				0.74-0.25
				0.66-1.73-0.34-5.11-1.06-7.41-1.91-0.36-0.14-0.65
				0.32-0.38
				0.59
				0.4
				0.4
				0.85
				0.83
				1.3
				1.23
				0.29
				0.26
				0.02
				0.73-0.35
				0.61-1.35-0.45-3.01-1.08-3.64-1.6
				0.25
				0.34
				0.62
				0.85
				0.97
				1.34
				0.22
				0.31-0.13
				0.71-0.47
				0.52-1.18-0.65-2.87-1.58-3.96-2.21-0.3-0.17-0.64
				0.13-0.51
				0.45l0.07
				0.17c0.29
				0.68
				2.3
				2.17
				2.22
				2.36s-7.85-2.48-9.89-2.15
				0.76
				0.79
				1.02
				0.9c0.26
				0.1
				1.78
				0.68
				1.7
				1.14s-3.29
				0.01-3.43-0.2c-0.08-0.11-1.1-0.61-2-1.04-0.34-0.16-0.66
				0.24-0.44
				0.54
				0.47
				0.65
				0.91
				1.38
				0.75
				1.64-0.32
				0.51-3.39-2.24-4.44-2.33s1.09
				1.45
				1.1
				1.98-3.53-1.43-4.34-1.09c-0.44
				0.18
				0.63
				0.98
				1.68
				1.77
				0.35
				0.26
				0.03
				0.79-0.37
				0.61-1.71-0.79-4.07-1.76-5.47-1.84-0.28-0.02-0.47
				0.27-0.35
				0.52
				0.08
				0.16
				0.13
				0.32
				0.07
				0.38-0.14
				0.17-1.54-0.25-1.99-0.17-0.29
				0.05
				1.77
				0.95
				3.21
				1.76
				0.37
				0.21
				0.14
				0.77-0.27
				0.66-2.36-0.6-6.71-1.58-8.91-1.21-0.3
				0.05-0.4
				0.45-0.15
				0.64
				0.21
				0.17
				0.57
				0.37
				1.16
				0.61
				1.8
				0.73
				2.33
				0.98
				1.3
				1.2-0.82
				0.18-5.8-1.22-8.11-2.29-0.32-0.15-0.65
				0.22-0.45
				0.52
				0.4
				0.62
				1
				1.42
				1.87
				2.26
				0.16
				0.16
				0.34
				0.32
				0.53
				0.5-0.71-0.16-2.78-0.6-4.04-0.55-0.04
				0-0.08
				0-0.12-0.02-0.44-0.14-3.14-1.02-4.81-1.91-0.34-0.18-0.7
				0.18-0.53
				0.52
				0.51
				1.01
				1.27
				2.37
				2.07
				3.25-1.35-1.28-5.83-5.13-9.86-4.07-0.34
				0.09-0.39
				0.55-0.08
				0.72
				0.36
				0.2
				0.8
				0.46
				1.22
				0.77
				0.34
				0.25
				0.08
				0.77-0.33
				0.69-0.01
				0-0.02
				0-0.03-0.01-0.34-0.06-0.59
				0.32-0.39
				0.61
				0.08
				0.12
				0.16
				0.26
				0.22
				0.39
				0.15
				0.33-0.22
				0.67-0.55
				0.51-1.36-0.65-4.71-2.06-6.57-1.2-0.32
				0.15-0.3
				0.6
				0.02
				0.72
				0.44
				0.17
				1.01
				0.41
				1.49
				0.7
				0.38
				0.23
				0.16
				0.81-0.28
				0.72-1.89-0.37-5.58-1.15-8.08-2.09-0.4-0.15-0.71
				0.35-0.41
				0.65
				0.44
				0.43
				0.93
				0.9
				1.42
				1.34
				0.32
				0.28
				0.02
				0.8-0.38
				0.67-1.47-0.49-3.29-1.17-3.98-1.75
				0.27
				0.37
				0.68
				0.93
				1.06
				1.46
				0.24
				0.34-0.14
				0.77-0.51
				0.57-1.29-0.71-3.13-1.73-4.32-2.41-0.33-0.19-0.7
				0.15-0.56
				0.49l0.08
				0.18c0.31
				0.74
				2.51
				2.36
				2.42
				2.57s-8.57-2.71-10.79-2.35c-2.23
				0.36
				0.83
				0.87
				1.11
				0.98s1.94
				0.75
				1.86
				1.25-3.59
				0.01-3.75-0.22c-0.08-0.12-1.2-0.67-2.18-1.13-0.37-0.17-0.72
				0.26-0.48
				0.59
				0.51
				0.71
				0.99
				1.51
				0.81
				1.79-0.35
				0.55-3.7-2.44-4.84-2.54s1.19
				1.59
				1.2
				2.16c0.01
				0.58-3.85-1.56-4.74-1.19-0.48
				0.2
				0.69
				1.07
				1.83
				1.93
				0.38
				0.28
				0.03
				0.87-0.4
				0.67-1.87-0.86-4.44-1.92-5.98-2-0.3-0.02-0.51
				0.29-0.38
				0.56
				0.09
				0.18
				0.14
				0.35
				0.08
				0.42-0.16
				0.18-1.68-0.28-2.17-0.19-0.32
				0.06
				1.93
				1.03
				3.5
				1.92
				0.4
				0.23
				0.15
				0.84-0.29
				0.72-2.57-0.66-7.33-1.72-9.73-1.32-0.33
				0.06-0.43
				0.49-0.17
				0.7
				0.23
				0.18
				0.62
				0.41
				1.26
				0.67
				1.96
				0.8
				2.54
				1.07
				1.42
				1.31-0.89
				0.19-6.34-1.33-8.86-2.5-0.35-0.16-0.71
				0.24-0.49
				0.57
				0.15
				0.23
				0.33
				0.49
				0.53
				0.76-0.53-0.22-1.06-0.46-1.5-0.7-0.34-0.18-0.7
				0.18-0.53
				0.52
				0.51
				1.01
				1.27
				2.37
				2.07
				3.25-1.35-1.28-5.83-5.13-9.86-4.07-0.34
				0.09-0.39
				0.55-0.08
				0.72
				0.36
				0.2
				0.8
				0.46
				1.22
				0.77
				0.34
				0.25
				0.08
				0.77-0.33
				0.69h-0.03c-0.34-0.06-0.59
				0.32-0.39
				0.61
				0.08
				0.12
				0.16
				0.26
				0.22
				0.39
				0.15
				0.33-0.22
				0.67-0.55
				0.51-1.36-0.65-4.71-2.06-6.57-1.2-0.32
				0.15-0.3
				0.6
				0.02
				0.72
				0.44
				0.17
				1.01
				0.41
				1.49
				0.7
				0.38
				0.23
				0.16
				0.81-0.28
				0.72-1.89-0.37-5.58-1.15-8.08-2.09-0.4-0.15-0.71
				0.35-0.41
				0.65
				0.44
				0.43
				0.93
				0.9
				1.42
				1.34
				0.32
				0.28
				0.02
				0.8-0.38
				0.67-1.47-0.49-3.29-1.17-3.98-1.75
				0.27
				0.37
				0.68
				0.93
				1.06
				1.46
				0.24
				0.34-0.14
				0.77-0.51
				0.57-1.29-0.71-3.13-1.73-4.32-2.41-0.33-0.19-0.7
				0.15-0.56
				0.49l0.08
				0.18c0.31
				0.74
				2.51
				2.36
				2.42
				2.57s-8.57-2.71-10.79-2.35c-2.23
				0.36
				0.83
				0.87
				1.11
				0.98s1.94
				0.75
				1.86
				1.25-3.59
				0.01-3.75-0.22c-0.08-0.12-1.2-0.67-2.18-1.13-0.37-0.17-0.72
				0.26-0.48
				0.59
				0.51
				0.71
				0.99
				1.51
				0.81
				1.79-0.35
				0.55-3.7-2.44-4.84-2.54s1.19
				1.59
				1.2
				2.16c0.01
				0.58-3.85-1.56-4.74-1.19-0.48
				0.2
				0.69
				1.07
				1.83
				1.93
				0.38
				0.28
				0.03
				0.87-0.4
				0.67-1.87-0.86-4.44-1.92-5.98-2-0.3-0.02-0.51
				0.29-0.38
				0.56
				0.09
				0.18
				0.14
				0.35
				0.08
				0.42-0.16
				0.18-1.68-0.28-2.17-0.19-0.32
				0.06
				1.93
				1.03
				3.5
				1.92
				0.4
				0.23
				0.15
				0.84-0.29
				0.72-2.58-0.66-7.33-1.72-9.73-1.32-0.33
				0.06-0.43
				0.49-0.17
				0.69
				0.23
				0.18
				0.62
				0.41
				1.26
				0.67
				1.78
				0.72
				2.42
				1.02
				1.68
				1.25-0.86-0.28-3.07-1.05-4.51-1.81-0.34-0.18-0.7
				0.18-0.53
				0.52
				0.06
				0.13
				0.13
				0.26
				0.2
				0.4-1.57-0.47-3.2-1.04-4.28-1.54-0.28-0.13-0.55
				0.1-0.55
				0.36-1.04-0.25-2.12-0.31-3.16-0.03-0.34
				0.09-0.39
				0.55-0.08
				0.72
				0.36
				0.2
				0.8
				0.46
				1.22
				0.77
				0.34
				0.25
				0.09
				0.77-0.33
				0.69h-0.03c-0.34-0.06-0.59
				0.32-0.39
				0.61
				0.08
				0.12
				0.16
				0.26
				0.22
				0.39
				0.15
				0.33-0.22
				0.67-0.55
				0.51-1.36-0.65-4.71-2.06-6.57-1.2-0.32
				0.15-0.3
				0.6
				0.02
				0.72
				0.44
				0.17
				1.01
				0.41
				1.49
				0.7
				0.38
				0.23
				0.16
				0.81-0.28
				0.72-1.89-0.37-5.58-1.15-8.08-2.09-0.4-0.15-0.71
				0.35-0.41
				0.65
				0.44
				0.43
				0.93
				0.9
				1.42
				1.34
				0.32
				0.28
				0.02
				0.8-0.38
				0.67-1.47-0.49-3.29-1.17-3.98-1.75
				0.27
				0.37
				0.68
				0.93
				1.06
				1.46
				0.24
				0.34-0.14
				0.77-0.51
				0.57-1.29-0.71-3.13-1.73-4.32-2.41-0.33-0.19-0.7
				0.15-0.56
				0.49l0.08
				0.18c0.31
				0.74
				2.51
				2.36
				2.42
				2.57s-8.57-2.71-10.79-2.35c-2.23
				0.36
				0.83
				0.87
				1.11
				0.98s1.94
				0.75
				1.86
				1.25-3.59
				0.01-3.75-0.22c-0.08-0.12-1.2-0.67-2.18-1.13-0.37-0.17-0.72
				0.26-0.48
				0.59
				0.51
				0.71
				0.99
				1.51
				0.81
				1.79-0.35
				0.55-3.7-2.44-4.84-2.54s1.19
				1.59
				1.2
				2.16c0.01
				0.58-3.85-1.56-4.74-1.19-0.48
				0.2
				0.69
				1.07
				1.83
				1.93
				0.38
				0.28
				0.03
				0.87-0.4
				0.67-1.87-0.86-4.44-1.92-5.98-2-0.3-0.02-0.51
				0.29-0.38
				0.56
				0.09
				0.18
				0.14
				0.35
				0.08
				0.42-0.16
				0.18-1.68-0.28-2.17-0.19-0.32
				0.06
				1.93
				1.03
				3.5
				1.92
				0.4
				0.23
				0.15
				0.84-0.29
				0.72-2.57-0.66-7.33-1.72-9.73-1.32-0.33
				0.06-0.43
				0.49-0.17
				0.7
				0.23
				0.18
				0.62
				0.41
				1.26
				0.67
				1.68
				0.68
				2.34
				0.98
				1.8
				1.21-0.12-0.07-0.22-0.14-0.3-0.21
				0.06
				0.08
				0.12
				0.16
				0.19
				0.25-0.07
				0.02-0.16
				0.04-0.26
				0.07-0.39
				0.08-1.66-0.16-3.17-0.56-0.06-0.03-0.12-0.07-0.17-0.1-0.1-0.06-0.2-0.06-0.28-0.03-1.84-0.51-3.93-1.21-5.24-1.82-0.35-0.16-0.71
				0.24-0.49
				0.57
				0.44
				0.68
				1.1
				1.55
				2.04
				2.47
				0.1
				0.1
				0.2
				0.19
				0.31
				0.3-1.79-0.45-3.52-0.81-4.33-0.67-2.01
				0.33
				0.75
				0.78
				1
				0.89
				0.09
				0.03
				0.32
				0.12
				0.58
				0.24l-0.74
				0.05s-1.05
				0.09-2.14
				0.29c-0.38-0.2-0.9-0.44-1.38-0.67-0.33-0.16-0.65
				0.23-0.44
				0.53
				0.12
				0.16
				0.23
				0.33
				0.33
				0.49-0.07
				0.02-0.15
				0.05-0.22
				0.07-0.04
				0.01-0.07
				0.02-0.11
				0.02-0.17
				0-0.69
				0.01-1.36-0.01-0.88-0.59-1.8-1.21-2.29-1.25-0.68-0.06
				0
				0.58
				0.55
				1.18-0.55-0.04-1.09-0.09-1.56-0.17-0.19-0.03-0.34
				0.09-0.39
				0.24-0.76-0.28-1.49-0.49-1.8-0.36-0.43
				0.18
				0.62
				0.97
				1.66
				1.74
				0.05
				0.04
				0.08
				0.08
				0.1
				0.12-0.86-0.24-1.82-0.44-2.79-0.5-1.14-0.43-2.27-0.78-3.07-0.82-0.27-0.02-0.46
				0.27-0.34
				0.51
				0.08
				0.16
				0.13
				0.31
				0.07
				0.38-0.14
				0.16-1.52-0.25-1.96-0.17-0.18
				0.03
				0.57
				0.4
				1.51
				0.87-0.07
				0.04-0.13
				0.08-0.2
				0.12-0.26
				0.17-0.18
				0.59
				0.13
				0.64
				0.37
				0.06
				0.82
				0.16
				1.26
				0.31
				0.22
				0.07
				0.27
				0.28
				0.21
				0.45-2.33-0.59-6.62-1.56-8.79-1.19-0.3
				0.05-0.39
				0.44-0.15
				0.63
				0.21
				0.17
				0.56
				0.37
				1.14
				0.6
				1.77
				0.72
				2.3
				0.97
				1.29
				1.19-0.81
				0.17-5.73-1.21-8.01-2.26-0.32-0.15-0.64
				0.22-0.45
				0.51
				0.4
				0.61
				0.99
				1.4
				1.84
				2.23
				0.82
				0.8
				2.11
				1.88
				3.31
				2.84-0.87
				0.05-1.73
				0.07-2.5
				0.04-0.38-0.01-0.51
				0.5-0.17
				0.67
				0.49
				0.24
				1.05
				0.51
				1.59
				0.74
				0.35
				0.15
				0.25
				0.68-0.14
				0.68-1.4
				0-3.15-0.06-3.9-0.36
				0.34
				0.24
				0.84
				0.6
				1.32
				0.95
				0.3
				0.22
				0.1
				0.7-0.27
				0.63-1.31-0.24-3.17-0.58-4.38-0.83-0.33-0.07-0.56
				0.33-0.34
				0.58l0.12
				0.13c0.47
				0.54
				2.81
				1.3
				2.8
				1.51-0.01
				0.2-8.1
				0.14-9.91
				1.08s0.96
				0.5
				1.23
				0.52
				1.87
				0.08
				1.94
				0.53-3.08
				1.03-3.27
				0.89c-0.11-0.08-1.22-0.23-2.19-0.34-0.36-0.04-0.55
				0.43-0.25
				0.64
				0.64
				0.46
				1.27
				1
				1.2
				1.3-0.14
				0.57-3.85-1.03-4.86-0.78-1.01
				0.24
				1.47
				1.01
				1.64
				1.5s-3.74-0.24-4.39
				0.34c-0.35
				0.31
				0.89
				0.72
				2.11
				1.12
				0.4
				0.13
				0.27
				0.73-0.16
				0.69-1.84-0.2-4.35-0.37-5.68
				0-0.26
				0.07-0.36
				0.4-0.17
				0.59
				0.12
				0.12
				0.22
				0.25
				0.18
				0.34-0.08
				0.2-1.52
				0.25-1.91
				0.46-0.25
				0.14
				1.94
				0.33
				3.54
				0.64
				0.41
				0.08
				0.37
				0.67-0.05
				0.7-2.39
				0.17-6.76
				0.62-8.7
				1.66-0.27
				0.14-0.23
				0.54
				0.05
				0.64
				0.25
				0.09
				0.65
				0.17
				1.27
				0.21
				1.9
				0.12
				2.48
				0.19
				1.59
				0.71-0.71
				0.42-5.8
				0.67-8.29
				0.39-0.35-0.04-0.54
				0.41-0.26
				0.63
				0.57
				0.45
				1.38
				1.01
				2.44
				1.53
				0.82
				0.4
				1.97
				0.86
				3.12
				1.3-0.44
				0.58-0.8
				1.15-1.05
				1.72
				1.19
				1.34
				2.33
				2.64
				2.67
				2.32
				0.32-0.3-0.03-1.48-0.45-2.55-0.2-0.5
				0.4-0.93
				0.81-0.59
				1.1
				0.91
				2.36
				1.97
				2.43
				2.15
				0.12
				0.34
				4.47
				2.11
				4.73
				1.5
				0.27-0.61-1.65-1.96-1.97-2.2-0.19-0.14-1.56-0.76-2.06-1.2l0.83-0.42c0.04
				0
				0.08
				0.01
				0.12
				0.01
				2.98
				0.27
				12.89
				6.75
				13.07
				6.51s-2.1-3.03-2.26-4.08l-0.04-0.26c-0.07-0.49
				0.52-0.79
				0.88-0.45
				1.3
				1.26
				3.32
				3.16
				4.74
				4.49
				0.4
				0.38
				1.04-0.05
				0.84-0.57-0.31-0.8-0.65-1.65-0.87-2.21
				0.69
				0.96
				2.8
				2.43
				4.53
				3.53
				0.48
				0.31
				1.03-0.26
				0.71-0.73-0.49-0.72-0.97-1.48-1.38-2.17-0.29-0.48
				0.28-1.01
				0.74-0.69
				2.9
				2.01
				7.38
				4.21
				9.68
				5.3
				0.53
				0.25
				1-0.42
				0.59-0.83-0.52-0.54-1.17-1.03-1.68-1.39-0.38-0.26-0.25-0.85
				0.21-0.93
				2.68-0.48
				6.51
				2.41
				8.04
				3.67
				0.37
				0.31
				0.95
				0
				0.87-0.47-0.03-0.2-0.09-0.39-0.16-0.58-0.16-0.43
				0.29-0.84
				0.7-0.65
				0.01
				0
				0.02
				0.01
				0.03
				0.01
				0.5
				0.24
				1-0.35
				0.65-0.77-0.43-0.53-0.91-1-1.31-1.37-0.34-0.31-0.12-0.89
				0.34-0.89
				5.52-0.05
				10
				6.34
				11.31
				8.41-0.74-1.38-1.26-3.36-1.58-4.82-0.11-0.49
				0.48-0.83
				0.86-0.49
				1.84
				1.68
				5.02
				3.69
				5.54
				4.01
				0.05
				0.03
				0.1
				0.05
				0.15
				0.06
				0.87
				0.18
				1.99
				0.62
				2.97
				1.05-0.03-0.07-0.05-0.15-0.07-0.21-0.16-0.49
				0.42-0.89
				0.82-0.56
				0.98
				0.8
				2.39
				1.76
				3.87
				2.69l3.64-9.06c1.52-3.78
				5.18-6.26
				9.26-6.26h8.44l12.89
				5.7
				1.96
				6.9h8.49l9.19
				5.7
				1.51
				3.62c0.85
				0.65
				1.86
				1.33
				2.76
				1.9
				0.3
				0.19
				0.62
				0.04
				0.75-0.21-0.76-1.05-1.45-2.07-1.96-2.9-0.91-1.48-1.46-2.81-1.8-3.82-0.16-0.49
				0.42-0.89
				0.82-0.56
				2.85
				2.32
				9.33
				6.04
				10.54
				6.09
				0.17
				0.01
				0.3
				0
				0.42
				0
				0.03-0.01
				0.06-0.03
				0.1-0.03
				0.05-0.01
				0.11-0.01
				0.16-0.02
				0.47-0.18-0.31-0.79-2.07-2.09-0.73-0.54-1.16-0.95-1.4-1.26-0.27-0.35
				0-0.87
				0.44-0.83
				3.21
				0.26
				8.96
				3.17
				12.05
				4.85
				0.17
				0.09
				0.34
				0.08
				0.48
				0.02-0.29-0.31-0.57-0.59-0.83-0.83-0.27-0.25-0.18-0.65
				0.09-0.82-1.59-1.43-3.34-2.82-2.99-2.79
				0.65
				0.04
				2.46
				1.13
				2.72
				0.95
				0.11-0.07
				0.09-0.31
				0.04-0.56-0.08-0.39
				0.29-0.72
				0.67-0.6
				1.94
				0.61
				4.89
				2.8
				7.01
				4.51
				0.48
				0.39
				1.13-0.24
				0.74-0.73-1.19-1.47-2.39-2.96-1.72-3.06
				1.26-0.19
				5.51
				3.8
				5.68
				3.06
				0.18-0.74-2.26-3.65-0.83-3.15s4.75
				5.41
				5.37
				4.82c0.32-0.3-0.03-1.48-0.45-2.55-0.2-0.5
				0.4-0.93
				0.81-0.59
				1.1
				0.91
				2.36
				1.97
				2.43
				2.15
				0.12
				0.34
				4.47
				2.11
				4.73
				1.5
				0.27-0.61-1.65-1.96-1.97-2.2s-4.08-1.88-1.1-1.61
				12.89
				6.75
				13.07
				6.51-2.1-3.03-2.26-4.08l-0.04-0.26c-0.07-0.49
				0.52-0.79
				0.88-0.45
				1.3
				1.26
				3.32
				3.16
				4.74
				4.49
				0.4
				0.38
				1.04-0.05
				0.84-0.56-0.23-0.58-0.46-1.19-0.66-1.69l-6.02-5.29-7.06-11.72-0.75
				1.13c-1.03
				1.56-3.23
				1.96-4.63
				0.74-1.32-1.15-1.2-2.92
				0.16-2.35
				2.11
				0.89
				3.88-0.77
				3.88-0.77-1.66-3.48-9.93-10.01-9.93-10.01s-2.12
				4.42-5.61
				4.06c-3.49-0.37-3.99-5.03-1.38-4.79s5-1.03
				5-1.03l-6.11-5.55
				0.6-0.96
				4.75
				2.96s-1.85-9.33
				1.42-7.41c3.27
				1.93
				0.42
				9.4
				0.42
				9.4
				4.35
				2.92
				11.41
				11.56
				11.41
				11.56s-4.67-9.92
				0.12-9.07
				2.31
				12.66
				2.31
				12.66l10.94
				13.19
				11.58
				5.39c-2.86-2.47-4.47-9.19-4.47-9.19
				0.87
				1.56
				2.62
				3.6
				4.41
				5.47
				1.12
				1.17
				2.24
				2.26
				3.18
				3.14
				0.34
				0.03
				0.69
				0.1
				1.04
				0.2-0.68-1.42-1.05-3-1.05-3
				1.78
				2.38
				4.45
				4.28
				7.87
				6.21
				0.01-0.06
				0.01-0.11
				0-0.18-0.03-0.2-0.09-0.39-0.16-0.58-0.16-0.43
				0.29-0.84
				0.7-0.65
				0.01
				0
				0.02
				0.01
				0.03
				0.01
				0.5
				0.24
				1-0.35
				0.65-0.77-0.43-0.53-0.91-1-1.31-1.37-0.34-0.31-0.12-0.89
				0.35-0.89
				5.52-0.05
				10
				6.34
				11.31
				8.41-0.74-1.38-1.26-3.36-1.58-4.82-0.11-0.49
				0.48-0.83
				0.86-0.49
				1.84
				1.68
				5.02
				3.69
				5.54
				4.01
				0.05
				0.03
				0.1
				0.05
				0.15
				0.06
				0.46
				0.1
				0.99
				0.27
				1.54
				0.47-0.58-0.8-1.11-1.58-1.49-2.2-0.68-1.11-1.1-2.11-1.35-2.87-0.12-0.37
				0.32-0.67
				0.62-0.42
				2.14
				1.74
				7.01
				4.54
				7.92
				4.57
				1.14
				0.04
				0.65-0.36-1.05-1.61-0.55-0.41-0.87-0.72-1.05-0.95-0.2-0.26
				0-0.65
				0.33-0.63
				2.42
				0.2
				6.74
				2.38
				9.06
				3.65
				0.4
				0.22
				0.79-0.31
				0.46-0.62-1.3-1.24-3.22-2.73-2.9-2.71
				0.49
				0.03
				1.85
				0.85
				2.04
				0.71
				0.08-0.06
				0.07-0.23
				0.03-0.42-0.06-0.29
				0.22-0.54
				0.5-0.45
				1.46
				0.46
				3.68
				2.11
				5.27
				3.39
				0.36
				0.29
				0.85-0.18
				0.55-0.55-0.89-1.11-1.8-2.22-1.29-2.3
				0.95-0.14
				4.14
				2.86
				4.27
				2.3s-1.7-2.74-0.62-2.37
				3.57
				4.07
				4.04
				3.62c0.24-0.23-0.02-1.11-0.34-1.92-0.15-0.37
				0.3-0.7
				0.61-0.44
				0.83
				0.68
				1.77
				1.48
				1.82
				1.62
				0.09
				0.25
				3.36
				1.58
				3.56
				1.13
				0.2-0.46-1.24-1.47-1.48-1.65s-3.06-1.41-0.83-1.21c2.24
				0.2
				9.69
				5.08
				9.83
				4.9
				0.13-0.18-1.58-2.28-1.7-3.06l-0.03-0.19c-0.06-0.37
				0.39-0.6
				0.66-0.34
				0.98
				0.94
				2.5
				2.37
				3.57
				3.37
				0.3
				0.28
				0.78-0.04
				0.63-0.42-0.23-0.6-0.49-1.24-0.66-1.66
				0.52
				0.72
				2.1
				1.82
				3.4
				2.65
				0.36
				0.23
				0.77-0.2
				0.53-0.55-0.37-0.54-0.73-1.11-1.04-1.63-0.22-0.36
				0.21-0.76
				0.56-0.52
				2.18
				1.51
				5.55
				3.17
				7.28
				3.98
				0.4
				0.19
				0.75-0.31
				0.45-0.63-0.39-0.4-0.88-0.78-1.26-1.04-0.28-0.2-0.18-0.64
				0.16-0.7
				2.01-0.36
				4.9
				1.81
				6.04
				2.76
				0.28
				0.23
				0.71
				0
				0.65-0.36-0.02-0.15-0.07-0.3-0.12-0.43-0.12-0.32
				0.22-0.63
				0.53-0.49
				0.01
				0
				0.02
				0.01
				0.02
				0.01
				0.38
				0.18
				0.75-0.26
				0.49-0.58-0.32-0.4-0.68-0.75-0.98-1.03-0.25-0.24-0.09-0.67
				0.26-0.67
				3.06-0.03
				5.7
				2.58
				7.27
				4.58
				0.22
				0.14
				0.45
				0.27
				0.67
				0.4-0.27-0.78-0.48-1.6-0.62-2.28-0.08-0.37
				0.36-0.62
				0.64-0.37
				0.5
				0.46
				1.14
				0.95
				1.77
				1.4
				0.07-0.06
				0.17-0.1
				0.28-0.1
				2.42
				0.2
				6.74
				2.38
				9.06
				3.65
				0.4
				0.22
				0.79-0.31
				0.46-0.62-1.3-1.24-3.22-2.73-2.9-2.71
				0.49
				0.03
				1.85
				0.85
				2.04
				0.71
				0.08-0.06
				0.07-0.23
				0.03-0.42-0.06-0.29
				0.22-0.54
				0.5-0.45
				1.46
				0.46
				3.68
				2.1
				5.27
				3.39
				0.36
				0.29
				0.85-0.18
				0.55-0.54-0.89-1.11-1.8-2.22-1.29-2.3
				0.95-0.14
				4.14
				2.86
				4.27
				2.3s-1.7-2.74-0.62-2.37
				3.57
				4.07
				4.04
				3.62c0.24-0.23-0.02-1.11-0.34-1.92-0.15-0.37
				0.3-0.7
				0.61-0.44
				0.83
				0.68
				1.77
				1.48
				1.82
				1.62
				0.09
				0.25
				3.36
				1.58
				3.56
				1.13
				0.2-0.46-1.24-1.47-1.48-1.65s-3.06-1.41-0.83-1.21c2.24
				0.2
				9.69
				5.08
				9.83
				4.9
				0.13-0.18-1.58-2.28-1.7-3.06l-0.03-0.19c-0.06-0.37
				0.39-0.6
				0.66-0.34
				0.98
				0.94
				2.5
				2.37
				3.57
				3.37
				0.3
				0.28
				0.78-0.04
				0.63-0.42-0.23-0.6-0.49-1.24-0.66-1.66
				0.52
				0.72
				2.1
				1.82
				3.4
				2.66
				0.36
				0.23
				0.77-0.2
				0.53-0.55-0.37-0.54-0.73-1.11-1.04-1.63-0.22-0.36
				0.21-0.76
				0.56-0.52
				2.18
				1.51
				5.55
				3.17
				7.28
				3.98
				0.4
				0.19
				0.75-0.31
				0.45-0.63-0.39-0.4-0.88-0.78-1.26-1.04-0.28-0.2-0.19-0.64
				0.16-0.7
				2.01-0.36
				4.9
				1.81
				6.04
				2.76
				0.28
				0.23
				0.71
				0
				0.65-0.36-0.02-0.15-0.07-0.3-0.12-0.43-0.12-0.32
				0.22-0.63
				0.53-0.49
				0.01
				0
				0.02
				0.01
				0.02
				0.01
				0.38
				0.18
				0.75-0.26
				0.48-0.58-0.32-0.39-0.68-0.75-0.98-1.03-0.25-0.24-0.09-0.67
				0.26-0.67
				4.16-0.04
				7.54
				4.79
				8.51
				6.33-0.56-1.04-0.96-2.53-1.2-3.63-0.08-0.37
				0.36-0.62
				0.64-0.37
				0
				0
				4.77
				6.56
				7.7
				9.45
				0.74
				0.39
				1.22
				0.78
				1.42
				1.17
				0.74
				1.44-2.34
				2.86-10.02
				4.27-23.27
				4.26-18.35
				10.43
				0.74
				16.8-0.08-0.1-0.09-0.16
				0-0.15
				0.53
				0.04
				1.65
				0.61
				2.49
				0.96
				0.29
				0.09
				0.58
				0.18
				0.88
				0.27
				0.05
				0
				0.09-0.01
				0.11-0.02
				0.14-0.09
				0.12-0.4
				0.05-0.72-0.11-0.5
				0.37-0.92
				0.86-0.76
				1.69
				0.53
				3.98
				2
				6.13
				3.58
				1.14
				0.31
				2.31
				0.62
				3.51
				0.94-1.43-1.77-2.75-3.47-1.94-3.59
				1.61-0.24
				7.04
				4.86
				7.27
				3.92s-2.89-4.66-1.06-4.03c1.83
				0.64
				6.07
				6.92
				6.87
				6.16
				0.41-0.39-0.04-1.89-0.58-3.26-0.25-0.64
				0.51-1.19
				1.04-0.75
				1.41
				1.16
				3.02
				2.52
				3.1
				2.76
				0.16
				0.43
				5.71
				2.69
				6.05
				1.92
				0.34-0.78-2.11-2.5-2.53-2.81-0.41-0.3-5.21-2.41-1.41-2.06
				3.8
				0.34
				16.49
				8.64
				16.72
				8.33s-2.68-3.88-2.88-5.21l-0.05-0.33c-0.09-0.63
				0.67-1.02
				1.12-0.57
				1.66
				1.61
				4.25
				4.03
				6.07
				5.74
				0.52
				0.48
				1.33-0.07
				1.07-0.72-0.4-1.03-0.83-2.12-1.12-2.83
				0.89
				1.23
				3.58
				3.1
				5.79
				4.52
				0.61
				0.39
				1.31-0.33
				0.91-0.93-0.63-0.92-1.23-1.89-1.77-2.78-0.37-0.61
				0.36-1.29
				0.95-0.88
				3.71
				2.57
				9.44
				5.39
				12.38
				6.78
				0.67
				0.32
				1.28-0.53
				0.76-1.07-0.67-0.69-1.5-1.32-2.15-1.77-0.48-0.34-0.31-1.09
				0.27-1.19
				3.42-0.62
				8.33
				3.08
				10.28
				4.7
				0.48
				0.39
				1.21
				0
				1.11-0.61-0.04-0.25-0.12-0.5-0.2-0.74-0.2-0.55
				0.37-1.08
				0.9-0.83
				0.01
				0.01
				0.03
				0.01
				0.04
				0.02
				0.64
				0.3
				1.27-0.44
				0.83-0.99-0.55-0.67-1.16-1.28-1.67-1.76-0.43-0.4-0.15-1.14
				0.44-1.14
				7.06-0.06
				12.79
				8.1
				14.46
				10.75-0.94-1.76-1.61-4.29-2.02-6.16-0.14-0.63
				0.62-1.06
				1.1-0.63
				2.35
				2.15
				6.42
				4.72
				7.08
				5.13
				0.06
				0.04
				0.12
				0.06
				0.19
				0.08
				0.64
				0.14
				1.4
				0.38
				2.16
				0.67-1.15-1.58-2.23-3.14-2.99-4.37-1.16-1.9-1.87-3.59-2.3-4.88-0.21-0.62
				0.54-1.14
				1.05-0.72
				3.64
				2.96
				11.93
				7.72
				13.47
				7.78
				1.93
				0.07
				1.1-0.62-1.78-2.74-0.94-0.69-1.48-1.22-1.79-1.61-0.35-0.45
				0-1.11
				0.57-1.06
				4.11
				0.34
				11.46
				4.06
				15.4
				6.2
				0.68
				0.37
				1.34-0.52
				0.78-1.06-2.21-2.11-5.48-4.64-4.94-4.6
				0.83
				0.06
				3.14
				1.44
				3.48
				1.21
				0.14-0.09
				0.12-0.4
				0.05-0.72-0.11-0.5
				0.37-0.92
				0.86-0.76
				2.48
				0.78
				6.26
				3.58
				8.96
				5.76
				0.62
				0.5
				1.44-0.31
				0.94-0.93-1.52-1.88-3.06-3.78-2.19-3.91
				1.61-0.24
				7.04
				4.86
				7.27
				3.92
				0.22-0.94-2.89-4.66-1.06-4.03
				1.83
				0.64
				6.07
				6.92
				6.87
				6.16
				0.41-0.39-0.04-1.89-0.58-3.26-0.25-0.64
				0.51-1.19
				1.04-0.75
				1.41
				1.16
				3.02
				2.52
				3.1
				2.76
				0.16
				0.43
				5.71
				2.69
				6.05
				1.92
				0.34-0.78-2.11-2.5-2.53-2.81-0.41-0.3-5.21-2.41-1.41-2.06
				3.8
				0.34
				16.49
				8.64
				16.72
				8.33s-2.68-3.88-2.88-5.21l-0.05-0.33c-0.09-0.63
				0.67-1.02
				1.12-0.57
				1.66
				1.61
				4.25
				4.03
				6.07
				5.74
				0.52
				0.48
				1.33-0.07
				1.07-0.72-0.4-1.03-0.83-2.12-1.12-2.83
				0.89
				1.23
				3.58
				3.1
				5.79
				4.52
				0.61
				0.39
				1.31-0.33
				0.91-0.93-0.63-0.92-1.23-1.89-1.77-2.78-0.37-0.61
				0.36-1.29
				0.95-0.88
				3.71
				2.57
				9.44
				5.39
				12.38
				6.78
				0.67
				0.32
				1.28-0.53
				0.76-1.07-0.67-0.68-1.5-1.32-2.15-1.77-0.48-0.34-0.31-1.09
				0.27-1.19
				3.42-0.62
				8.33
				3.08
				10.28
				4.7
				0.48
				0.39
				1.21
				0
				1.11-0.61-0.04-0.25-0.12-0.5-0.2-0.74-0.2-0.55
				0.37-1.08
				0.9-0.83
				0.01
				0.01
				0.03
				0.01
				0.04
				0.02
				0.64
				0.3
				1.27-0.44
				0.83-0.99-0.55-0.67-1.16-1.28-1.67-1.76-0.43-0.4-0.15-1.14
				0.44-1.14
				6.45-0.05
				11.79
				6.75
				13.93
				9.94
				0.05
				0
				0.1
				0.01
				0.14
				0.01-0.74-1.67-1.29-3.77-1.64-5.37-0.14-0.63
				0.62-1.06
				1.1-0.63
				2.35
				2.15
				6.42
				4.72
				7.08
				5.13
				0.05
				0.03
				0.1
				0.05
				0.16
				0.07-8.16-9.15-13.81-20.57-15.86-32.66
				11.75
				8.92
				21.9
				19.94
				29.82
				32.38-2.57-10.81-3.54-22.01-2.87-33.11
				0.29-4.73
				1.07-9.86
				4.5-13.12
				10.59
				13.64
				10.81
				32.39
				10.57
				49.66
				8.09-2.9
				16.44-5.07
				24.92-6.47-2.6
				3.99-5.72
				7.63-9.26
				10.82
				59.7
				11.21
				95.77
				29.89
				74.72
				36.46-7.61
				2.37-8.63
				6.89-2.85
				12.31-0.48-1.3-1.48-3.53-1.43-4.44l0.02-0.32c0.04-0.6
				0.82-0.81
				1.15-0.31
				1.23
				1.82
				3.16
				4.58
				4.52
				6.52
				0.38
				0.55
				1.25
				0.2
				1.14-0.46-0.17-1.03-0.35-2.13-0.48-2.85-0.08-0.18-0.13-0.35-0.15-0.49-0.06-0.61
				0.01-0.27
				0.15
				0.49
				0.58
				1.32
				2.72
				3.58
				4.49
				5.33
				0.49
				0.48
				1.29-0.05
				1.03-0.69-0.4-0.98-0.78-2-1.1-2.93-0.22-0.64
				0.59-1.13
				1.06-0.63
				2.95
				3.12
				7.72
				6.86
				10.18
				8.73
				0.56
				0.43
				1.29-0.25
				0.91-0.84-0.48-0.77-1.14-1.52-1.65-2.07-0.38-0.41-0.08-1.07
				0.48-1.06
				3.3
				0.09
				7.14
				4.5
				8.63
				6.38
				0.36
				0.46
				1.13
				0.24
				1.15-0.35
				0.01-0.24-0.01-0.49-0.04-0.72-0.08-0.55
				0.55-0.93
				1-0.6
				0.01
				0.01
				0.02
				0.02
				0.03
				0.02
				0.53
				0.41
				1.27-0.16
				0.96-0.76-0.38-0.73-0.83-1.42-1.21-1.96-0.32-0.46
				0.08-1.09
				0.63-0.98
				6.57
				1.33
				10.3
				10.04
				11.33
				12.82-0.53-1.82-0.66-4.31-0.67-6.12
				0-0.61
				0.78-0.87
				1.14-0.37
				1.77
				2.46
				5.05
				5.64
				5.58
				6.15
				0.05
				0.05
				0.1
				0.08
				0.16
				0.11
				1.57
				0.69
				3.74
				2.31
				4.92
				3.23-0.91-1.27-1.74-2.49-2.35-3.48-1.1-1.8-1.78-3.41-2.19-4.64-0.2-0.59
				0.51-1.08
				1-0.68
				3.46
				2.81
				11.33
				7.33
				12.8
				7.39
				1.84
				0.07
				1.04-0.59-1.69-2.6-0.89-0.66-1.41-1.16-1.7-1.53-0.33-0.43
				0-1.06
				0.54-1.01
				3.9
				0.32
				10.88
				3.85
				14.63
				5.89
				0.65
				0.35
				1.27-0.5
				0.74-1.01-2.1-2-5.21-4.41-4.69-4.37
				0.79
				0.05
				2.99
				1.37
				3.3
				1.15
				0.13-0.09
				0.11-0.38
				0.05-0.68-0.1-0.47
				0.35-0.87
				0.82-0.73
				2.35
				0.74
				5.94
				3.4
				8.51
				5.47
				0.59
				0.48
				1.37-0.29
				0.89-0.88-1.44-1.79-2.91-3.59-2.08-3.72
				1.53-0.23
				6.69
				4.62
				6.9
				3.72s-2.75-4.43-1.01-3.83
				5.77
				6.57
				6.53
				5.85c0.39-0.37-0.04-1.8-0.55-3.1-0.24-0.6
				0.49-1.13
				0.99-0.72
				1.34
				1.1
				2.87
				2.39
				2.95
				2.62
				0.15
				0.41
				5.43
				2.56
				5.75
				1.82s-2.01-2.38-2.4-2.67-4.95-2.29-1.34-1.96c3.61
				0.32
				15.66
				8.2
				15.88
				7.91s-2.55-3.68-2.74-4.95l-0.05-0.31c-0.09-0.6
				0.63-0.96
				1.07-0.55
				1.58
				1.53
				4.03
				3.83
				5.76
				5.45
				0.49
				0.46
				1.26-0.06
				1.02-0.69-0.38-0.97-0.79-2.01-1.06-2.69-0.12-0.16-0.2-0.32-0.25-0.45-0.19-0.58-0.04-0.26
				0.25
				0.45
				0.84
				1.17
				3.4
				2.95
				5.5
				4.29
				0.58
				0.37
				1.25-0.32
				0.86-0.88-0.6-0.87-1.17-1.8-1.68-2.64-0.35-0.58
				0.34-1.22
				0.9-0.84
				3.53
				2.44
				8.97
				5.12
				11.76
				6.44
				0.64
				0.3
				1.21-0.51
				0.72-1.01-0.63-0.65-1.43-1.25-2.04-1.68-0.46-0.32-0.3-1.03
				0.25-1.13
				3.25-0.59
				7.91
				2.93
				9.76
				4.46
				0.45
				0.37
				1.15
				0
				1.06-0.58-0.04-0.24-0.11-0.48-0.19-0.7-0.19-0.52
				0.35-1.03
				0.86-0.79
				0.01
				0.01
				0.03
				0.01
				0.04
				0.02
				0.61
				0.29
				1.21-0.42
				0.78-0.94-0.52-0.64-1.1-1.22-1.59-1.67-0.41-0.38-0.14-1.08
				0.42-1.09
				6.7-0.06
				12.15
				7.7
				13.74
				10.21-0.75-1.4-1.32-3.32-1.71-4.95-0.31-0.42-0.6-0.83-0.85-1.2-1.19-1.74-1.94-3.32-2.41-4.53-0.23-0.58
				0.46-1.1
				0.96-0.73
				3.6
				2.64
				11.68
				6.77
				13.15
				6.76
				1.84-0.02
				1.01-0.64-1.82-2.51-0.92-0.61-1.46-1.09-1.77-1.45-0.35-0.41-0.05-1.05
				0.49-1.04
				3.91
				0.13
				11.06
				3.32
				14.9
				5.17
				0.66
				0.32
				1.25-0.56
				0.69-1.04-2.2-1.9-5.42-4.15-4.9-4.14
				0.79
				0.02
				3.05
				1.22
				3.35
				0.99
				0.12-0.1
				0.09-0.38
				0.01-0.68-0.12-0.47
				0.31-0.89
				0.78-0.76
				2.39
				0.63
				6.1
				3.11
				8.77
				5.05
				0.61
				0.45
				1.35-0.36
				0.85-0.92-1.53-1.72-3.08-3.45-2.26-3.61
				1.52-0.3
				6.91
				4.29
				7.08
				3.38s-2.96-4.29-1.19-3.77
				6.08
				6.28
				6.81
				5.53c0.37-0.39-0.13-1.79-0.7-3.07-0.27-0.59
				0.43-1.15
				0.95-0.76
				1.39
				1.04
				2.98
				2.25
				3.07
				2.47
				0.17
				0.4
				5.54
				2.29
				5.83
				1.54s-2.12-2.28-2.53-2.55c-0.4-0.27-5.06-2.04-1.43-1.89s16.04
				7.43
				16.25
				7.13c0.2-0.3-2.73-3.55-2.98-4.81l-0.06-0.31c-0.12-0.59
				0.58-0.99
				1.04-0.6
				1.65
				1.45
				4.22
				3.63
				6.02
				5.16
				0.51
				0.43
				1.26-0.12
				0.99-0.74-0.43-0.96-0.88-1.97-1.19-2.63-0.13-0.16-0.22-0.31-0.27-0.44-0.22-0.57-0.06-0.26
				0.27
				0.44
				0.9
				1.13
				3.54
				2.78
				5.7
				4.02
				0.6
				0.34
				1.23-0.38
				0.82-0.92-0.64-0.84-1.26-1.74-1.8-2.55-0.38-0.56
				0.28-1.24
				0.86-0.88
				2.28
				1.42
				5.32
				2.9
				7.97
				4.09l0.45-330.18h0.02c0-0.01-0.01-0.01-0.02
				0zm-654.51
				82.34c-0.21
				0.03-0.43
				0.06-0.64
				0.08l-0.39-0.93c0.34
				0.29
				0.69
				0.57
				1.03
				0.85zm-213.83
				25.96c-0.01
				0.04-0.04
				0.08-0.1
				0.11l-0.77-0.88c0.45
				0.22
				0.91
				0.52
				0.87
				0.77zm480.01
				129.23c-0.14-0.44-0.03-0.2
				0.19
				0.34-0.09-0.12-0.16-0.24-0.19-0.34zm208.34-216.02c-0.6
				0.07-1.19
				0.15-1.79
				0.22-0.47-0.11-0.96-0.22-1.47-0.33
				0.2-0.44
				0.41-0.87
				0.63-1.3
				0.49
				0.3
				1.69
				0.87
				2.63
				1.41z
			`}
        />
        <path
          fill={st1}
          d='m1337.2 482.78c0.04 0.06 0.1 0.13 0.18 0.2-0.23-0.33-0.35-0.47-0.18-0.2z'
        />
        <path
          fill={st1}
          d='m1300.2 823.88l0.02 0.13c5.64 0.29 11.41 0.54 17.32 0.74l-17.34-0.87z'
        />
        <path
          fill={st1}
          d='M-0.34,600.6c-0.03-0.01-0.07-0.01-0.1-0.02v25.4l0.1,257.12V600.6z'
        />
        <path
          fill={st1}
          d='m663.8 662.51v0.02c0.59 0.05 1.19 0.11 1.78 0.16l-1.78-0.18z'
        />
        <polygon
          fill={st1}
          points='1365.6 881.97 1365.6 827.18 1365.5 827.18'
        />
        <path
          fill={`url(#${b})`}
          d='m86.14 335.89s57.96 41.23 70.62 100.61c3.36 15.77 5.79 29.72 7.53 41.71l1.79-0.69 40.53-20.74c0.49-0.25 1.01-0.4 1.54-0.46l0.36-0.03h0.24c0.1 0 0.21 0.01 0.31 0.02h0.03c1.14 0.11 2.23 0.66 3.01 1.6l0.32 0.39c0.17 0.2 0.27 0.33 0.27 0.33 3.48 2.91 7.84 2.91 8.23 2.9 0.89-0.18 1.77-0.5 2.6-0.98l2.53-1.47c-0.87-1.2-1.75-2.4-2.65-3.6-19.21-25.54-25.95-58.65-43.59-85.3-21.32-32.21-53.98-57.97-65.24-94.92-11.55-37.9 2.16-79.17-4.34-118.26-8.51-51.24-46.7-104.56-56.01-155.66h-54.67c-0.82 107.69 32.6 157.47 38.57 232.7 3.47 43.76-4.86 89.02 8.1 130.97 7.91 25.63 23.32 48.26 33.47 73.09 8.6 21.02 13.32 43.3 17.92 65.61l41.92-16.03c-24.68-39.18-55.67-99.39-53.39-151.79z'
        />
        <g opacity={0.2}>
          <path
            fill={st11}
            d='m212.71 458.63l-0.27-0.33c-0.52-0.59-1.76-1.79-3.33-1.99h-0.03c-0.1-0.01-0.21-0.02-0.31-0.02h-0.24c-0.12 0-0.24 0.01-0.36 0.03 0 0-8.45 8.58-2.01 8.92s14.81-3.71 14.81-3.71-0.01 0-0.03 0c-3 0.6-6.18-0.44-8.23-2.9z'
          />
        </g>
        <path
          fill={st3}
          d='m1056.5 520.12c0.11 0.31 0.25 0.65 0.42 1.02 1.02 0.96 2.04 1.89 2.93 2.69 0.1-0.14 0.29-0.2 0.45-0.09 1.64 1.17 3.79 4.59 4.9 6.49 0.19 0.33 0.69 0.12 0.59-0.25-0.4-1.45-1.13-3.34-0.91-3.18 0.33 0.23 0.96 1.4 1.15 1.38 0.08-0.01 0.15-0.14 0.2-0.29 0.08-0.24 0.39-0.29 0.55-0.11 0.84 0.95 1.72 3.08 2.31 4.68 0.13 0.37 0.68 0.23 0.63-0.16-0.16-1.18-0.33-2.37 0.06-2.2 0.74 0.3 1.73 3.82 2.06 3.48s-0.04-2.7 0.57-1.97 0.8 4.45 1.33 4.33c0.27-0.06 0.46-0.81 0.58-1.52 0.06-0.33 0.51-0.37 0.63-0.06 0.3 0.84 0.63 1.82 0.61 1.94-0.04 0.22 1.72 2.57 2.06 2.33s-0.26-1.59-0.35-1.82c-0.1-0.23-1.58-2.32-0.07-1.23 1.51 1.1 4.74 7.79 4.92 7.71 0.17-0.07-0.15-2.31 0.1-2.92l0.06-0.15c0.12-0.29 0.53-0.26 0.61 0.04 0.29 1.1 0.77 2.77 1.1 3.95 0.09 0.33 0.57 0.31 0.63-0.04 0.09-0.53 0.19-1.1 0.24-1.48-0.01-0.1-0.01-0.19 0.01-0.27 0.07-0.31 0.05-0.13-0.01 0.27 0.06 0.74 0.72 2.21 1.29 3.36 0.16 0.32 0.64 0.19 0.61-0.16-0.03-0.55-0.04-1.11-0.04-1.62 0-0.35 0.48-0.45 0.62-0.13 0.91 2.02 2.6 4.65 3.49 5.97 0.2 0.3 0.67 0.1 0.59-0.26-0.11-0.46-0.3-0.93-0.46-1.29-0.12-0.26 0.14-0.54 0.41-0.44 1.59 0.6 2.72 3.39 3.13 4.56 0.1 0.29 0.51 0.3 0.62 0.02 0.05-0.12 0.08-0.24 0.1-0.36 0.06-0.28 0.43-0.36 0.59-0.12 0 0.01 0.01 0.01 0.01 0.02 0.19 0.29 0.65 0.13 0.6-0.21-0.06-0.42-0.16-0.83-0.26-1.16-0.08-0.28 0.22-0.52 0.47-0.37 2.17 1.27 2.94 4.22 3.22 6.32 0.13 0.09 0.27 0.18 0.4 0.26 0.13-0.54 0.3-1.08 0.45-1.52 0.1-0.3 0.53-0.29 0.62 0.01 0.04 0.13 0.08 0.26 0.13 0.4 0.08 0.02 0.15 0.06 0.21 0.15 0.61 1.01 1.7 2.45 2.72 3.65 0.81 0.52 1.62 1.04 2.42 1.55-0.15-0.25-0.35-0.55-0.6-0.92-0.32-0.48-0.48-0.81-0.56-1.04-0.09-0.27 0.18-0.51 0.44-0.4 1.83 0.84 4.6 3.78 6.06 5.42 0.25 0.28 0.7-0.02 0.54-0.36-0.67-1.34-1.75-3.06-1.51-2.95 0.37 0.16 1.21 1.19 1.4 1.14 0.08-0.02 0.12-0.16 0.14-0.32 0.03-0.25 0.32-0.36 0.52-0.21 1.01 0.77 2.28 2.69 3.16 4.15 0.2 0.33 0.71 0.1 0.59-0.27-0.39-1.12-0.78-2.26-0.36-2.17 0.78 0.16 2.43 3.42 2.69 3.02s-0.56-2.64 0.18-2.04 1.64 4.21 2.14 3.99c0.25-0.11 0.29-0.88 0.27-1.61-0.01-0.34 0.43-0.47 0.6-0.18 0.46 0.77 0.97 1.66 0.97 1.79 0 0.23 2.18 2.19 2.47 1.89s-0.56-1.51-0.7-1.72-2-1.98-0.3-1.19c1.69 0.79 6.15 6.73 6.31 6.63s-0.59-2.24-0.46-2.89l0.03-0.16c0.06-0.31 0.47-0.36 0.61-0.08 0.5 1.02 1.28 2.57 1.84 3.66 0.16 0.31 0.62 0.19 0.61-0.16-0.01-0.54-0.03-1.12-0.04-1.5-0.03-0.1-0.04-0.19-0.04-0.26 0.01-0.32 0.02-0.14 0.04 0.26 0.2 0.72 1.13 2.03 1.91 3.05 0.22 0.28 0.66 0.06 0.57-0.28-0.14-0.53-0.25-1.08-0.35-1.58-0.07-0.34 0.38-0.54 0.58-0.25 1.28 1.8 3.45 4.06 4.57 5.19 0.26 0.26 0.68-0.04 0.53-0.37-0.19-0.43-0.47-0.86-0.7-1.18-0.17-0.24 0.04-0.56 0.32-0.51 1.68 0.28 3.32 2.81 3.95 3.88 0.15 0.26 0.56 0.2 0.61-0.1 0.02-0.12 0.03-0.25 0.03-0.37 0-0.29 0.35-0.44 0.55-0.24l0.02 0.02c0.24 0.25 0.66 0.01 0.54-0.32-0.14-0.4-0.32-0.79-0.48-1.09-0.13-0.26 0.12-0.55 0.39-0.46 0.52 0.18 0.98 0.45 1.4 0.79 0.12-0.01 0.24 0.03 0.31 0.15 0.05 0.09 0.11 0.19 0.18 0.28 0.62 0.61 1.12 1.36 1.53 2.13 0.47 0.61 0.97 1.21 1.44 1.73 0.03-0.32 0.06-0.62 0.1-0.9 0.04-0.31 0.46-0.39 0.61-0.11 0.32 0.6 0.77 1.3 1.2 1.92-0.14-0.22-0.31-0.48-0.51-0.78-0.32-0.48-0.48-0.81-0.56-1.04-0.09-0.27 0.18-0.51 0.44-0.4 1.83 0.84 4.6 3.78 6.06 5.42 0.25 0.28 0.7-0.02 0.54-0.36-0.67-1.34-1.75-3.06-1.51-2.95 0.37 0.16 1.21 1.19 1.4 1.14 0.08-0.02 0.12-0.16 0.14-0.32 0.03-0.25 0.32-0.36 0.52-0.21 1.01 0.77 2.28 2.69 3.16 4.15 0.2 0.33 0.71 0.1 0.59-0.27-0.39-1.12-0.78-2.26-0.36-2.17 0.78 0.16 2.43 3.42 2.69 3.02s-0.56-2.64 0.18-2.04 1.64 4.21 2.14 3.99c0.25-0.11 0.29-0.88 0.27-1.61-0.01-0.34 0.43-0.47 0.6-0.18 0.46 0.77 0.97 1.66 0.97 1.79 0 0.23 2.18 2.19 2.47 1.89s-0.56-1.51-0.7-1.72-2-1.98-0.3-1.19c0.65 0.3 3.03 2.48 5.63 4.95-0.12-0.14-0.25-0.27-0.37-0.41l0.75 0.56c0.17 0.13 0.41 0.06 0.5-0.13l0.06-0.15c-0.45-0.57-0.73-0.97-0.71-1.07l0.03-0.16c0.06-0.31 0.47-0.36 0.61-0.08 0.04 0.07 0.08 0.15 0.11 0.23l0.26 0.37 0.62-1.49-0.39-0.69s-1.21-2.02-2.13-2.88c-0.03-0.02-0.05-0.05-0.06-0.08-0.17-0.34-1.22-2.45-1.66-3.95-0.09-0.3-0.52-0.31-0.62-0.01-0.31 0.89-0.67 2.14-0.72 3.12-0.03-1.52-0.35-6.43-3.32-8.2-0.25-0.15-0.55 0.09-0.47 0.37 0.09 0.33 0.19 0.74 0.25 1.16 0.05 0.34-0.41 0.5-0.6 0.21 0-0.01-0.01-0.01-0.01-0.02-0.04-0.06-0.09-0.09-0.14-0.12-0.22-0.27-0.44-0.52-0.64-0.71-0.03-0.02-0.05-0.05-0.06-0.08-0.17-0.34-1.22-2.45-1.66-3.95-0.09-0.3-0.52-0.31-0.62-0.01-0.14 0.4-0.28 0.86-0.41 1.34-0.15-0.15-0.32-0.27-0.48-0.38-0.3-2.07-1.08-4.82-3.15-6.04-0.25-0.15-0.55 0.09-0.47 0.37 0.09 0.33 0.19 0.74 0.25 1.16 0.05 0.34-0.41 0.5-0.6 0.21 0-0.01-0.01-0.01-0.01-0.02-0.13-0.2-0.4-0.18-0.53-0.01-0.19-0.16-0.53-0.05-0.53 0.25v0.44c-0.11-0.02-0.21-0.09-0.25-0.22-0.41-1.18-1.52-3.97-3.11-4.58-0.27-0.1-0.53 0.17-0.41 0.43 0.16 0.35 0.35 0.83 0.45 1.29 0.02 0.1 0 0.19-0.05 0.26-0.17-0.6-0.32-1.19-0.45-1.66-0.08-0.3-0.49-0.33-0.61-0.04l-0.06 0.15c-0.05 0.12-0.08 0.29-0.09 0.5-0.9-1.41-2.08-3.36-2.78-4.94-0.14-0.32-0.62-0.22-0.62 0.13 0 0.45 0 0.94 0.02 1.42-0.57-0.89-1.11-1.62-1.53-1.93-0.04-0.03-0.07-0.05-0.1-0.07-0.14-0.4-0.23-0.75-0.25-1.01-0.03 0.21-0.08 0.49-0.13 0.79-0.26-0.1-0.22 0.12-0.07 0.43-0.02 0.09-0.03 0.17-0.05 0.26-0.06 0.34-0.54 0.37-0.63 0.03-0.33-1.18-0.79-2.85-1.08-3.95-0.08-0.3-0.49-0.33-0.61-0.04l-0.06 0.15c-0.26 0.61 0.06 2.85-0.12 2.92-0.06 0.03-0.52-0.83-1.15-1.98-0.14-0.67-0.29-1.27-0.5-1.52-0.18-0.21-0.27-0.16-0.32 0.02-1-1.79-2.16-3.71-2.91-4.26-1.5-1.11-0.03 0.99 0.06 1.23 0.07 0.17 0.42 0.99 0.45 1.48-0.09 0.02-0.13 0.15-0.15 0.35-0.42 0.07-2.05-2.13-2-2.35 0.02-0.12-0.3-1.1-0.6-1.95-0.11-0.32-0.57-0.28-0.63 0.05-0.12 0.71-0.31 1.46-0.59 1.52-0.05 0.01-0.09-0.01-0.13-0.05-0.02-0.03-0.05-0.07-0.07-0.1-0.38-0.7-0.59-3.55-1.11-4.18-0.61-0.73-0.25 1.62-0.58 1.96s-1.31-3.18-2.05-3.49c-0.39-0.16-0.24 0.98-0.09 2.13-0.32-0.72-0.65-1.55-0.86-2.24-0.09-0.3-0.52-0.31-0.62-0.01l-0.06 0.18c-0.43-0.97-0.9-1.86-1.37-2.39-0.09-0.1-0.23-0.13-0.34-0.1-0.49-1.13-1.21-2.15-2.27-2.77-0.25-0.15-0.55 0.09-0.47 0.37 0.09 0.33 0.19 0.74 0.25 1.16 0.05 0.34-0.41 0.5-0.6 0.21 0-0.01-0.01-0.01-0.01-0.02-0.12-0.18-0.35-0.18-0.48-0.06-0.82-1.15-1.69-2.21-2.46-2.8-0.43-0.58-0.92-1.06-1.47-1.27-0.27-0.1-0.53 0.17-0.41 0.43 0.12 0.28 0.26 0.63 0.37 0.99-0.32-0.26-0.64-0.53-0.95-0.79-0.57-1.1-1.09-2.24-1.39-3.08-0.11-0.3-0.55-0.28-0.62 0.04-0.02 0.08-0.04 0.17-0.06 0.26-0.35-0.64-0.68-1.28-0.94-1.86-0.14-0.32-0.62-0.22-0.62 0.13 0 0.49 0 1.03 0.03 1.56-0.38-0.31-0.76-0.62-1.14-0.92-0.38-0.86-0.7-1.72-0.74-2.23-0.06 0.37-0.15 0.92-0.24 1.44-0.28-0.22-0.56-0.45-0.84-0.67-0.3-1.07-0.64-2.33-0.88-3.21-0.08-0.3-0.49-0.33-0.61-0.04l-0.06 0.15c-0.14 0.33-0.11 1.14-0.08 1.82-0.41-0.32-0.81-0.63-1.22-0.95-1.11-2.05-2.74-4.99-3.69-5.69-1.5-1.11-0.03 0.99 0.06 1.23 0.1 0.23 0.68 1.58 0.34 1.82-0.06 0.04-0.17 0-0.31-0.1-0.01-0.01-0.02-0.01-0.03-0.02-0.62-0.47-1.75-2.04-1.71-2.22 0.02-0.12-0.3-1.1-0.6-1.95-0.11-0.32-0.57-0.28-0.63 0.05-0.12 0.71-0.31 1.45-0.58 1.52-0.07-0.05-0.13-0.1-0.2-0.14-0.39-0.69-0.59-3.55-1.11-4.19-0.61-0.73-0.25 1.62-0.58 1.96s-1.31-3.18-2.05-3.49c-0.4-0.16-0.23 1.03-0.08 2.2 0.05 0.39-0.5 0.52-0.63 0.15-0.58-1.6-1.45-3.74-2.28-4.69-0.16-0.19-0.47-0.13-0.55 0.1-0.05 0.15-0.12 0.28-0.2 0.29-0.2 0.01-0.81-1.15-1.15-1.39-0.22-0.15 0.51 1.74 0.9 3.19 0.05 0.2-0.07 0.35-0.23 0.4-0.15-0.1-0.3-0.19-0.45-0.29-1.13-1.93-3.19-5.22-4.78-6.37-0.23-0.16-0.54 0.03-0.51 0.3 0.03 0.24 0.12 0.6 0.34 1.13 0.56 1.36 0.77 1.93 0.36 1.77l-1.87-3.06c-0.16-0.09-0.32-0.18-0.47-0.27-0.65-1.23-1.28-2.56-1.62-3.52-0.11-0.3-0.55-0.28-0.62 0.04-0.15 0.65-0.28 1.55-0.28 2.64 0 0.18 0 0.36 0.01 0.56-0.57-0.41-1.12-0.82-1.56-1.14-0.25-0.19-0.59 0.05-0.51 0.35l0.05 0.16c0.18 0.64 1.83 2.19 1.74 2.36-0.09 0.16-6.78-3.07-8.64-3-1.87 0.08 0.6 0.8 0.82 0.92s1.52 0.81 1.41 1.21-2.95-0.35-3.06-0.55c-0.06-0.11-0.92-0.67-1.68-1.15-0.28-0.18-0.62 0.14-0.46 0.43 0.35 0.63 0.67 1.34 0.49 1.55-0.34 0.42-2.8-2.37-3.73-2.57-0.93-0.19 0.82 1.42 0.77 1.9-0.05 0.47-3.01-1.67-3.78-1.45-0.41 0.12 0.46 0.95 1.32 1.77 0.28 0.27-0.06 0.72-0.4 0.51-1.45-0.89-3.46-2.02-4.72-2.24-0.25-0.04-0.45 0.19-0.37 0.43 0.05 0.15 0.08 0.3 0.02 0.35-0.15 0.13-1.36-0.39-1.76-0.37-0.27 0.02 1.48 1.04 2.69 1.93 0.31 0.23 0.04 0.7-0.31 0.57-2.05-0.8-5.86-2.14-7.87-2.04-0.28 0.01-0.4 0.36-0.21 0.55 0.17 0.17 0.47 0.4 0.97 0.67 1.53 0.85 1.98 1.13 1.04 1.22-0.6 0.05-3.43-1.06-5.55-2.12-0.35 0.32-0.41 0.64-0.1 0.93 0.07-0.29 0.51-0.32 0.62-0.01z'
        />
        <path
          fill={st15}
          d='m1060.2 526.79c0.76 0.49 0.63 0.05 0.03-1.39l-0.98 0.14c0.4 0.65 0.75 1.12 0.95 1.25z'
        />
        <path
          fill={st1}
          d='m47.03 711.45c0.12-0.12 0.2-0.23 0.26-0.34 0.22-0.45 0.06-0.21-0.26 0.34z'
        />
        <path
          fill={st1}
          d='m143.25 716.85c-3.15 1.88-10.07 4.63-11.27 4.5-1.5-0.16-0.77-0.6 1.69-1.92 0.8-0.43 1.28-0.77 1.56-1.05 0.32-0.31 0.13-0.86-0.32-0.89-3.2-0.2-9.29 1.85-12.58 3.06-0.57 0.21-0.97-0.56-0.48-0.91 1.95-1.38 4.75-2.97 4.33-3.01-0.65-0.05-2.59 0.76-2.82 0.54-0.09-0.09-0.05-0.32 0.04-0.56 0.14-0.37-0.18-0.75-0.57-0.69-2 0.33-5.23 2.07-7.56 3.45-0.53 0.32-1.07-0.4-0.62-0.82 1.39-1.29 2.79-2.58 2.14-2.78-1.21-0.37-5.98 2.97-6.05 2.21-0.06-0.76 2.76-3.28 1.28-3-1.49 0.29-5.47 4.67-6 4-0.27-0.35 0.25-1.46 0.82-2.46 0.27-0.46-0.26-0.98-0.72-0.7-1.22 0.74-2.61 1.61-2.71 1.78-0.07 0.14-0.99 0.43-2.01 0.67 0.65-0.69 1.25-1.36 1.72-1.92 1.11-1.34 1.85-2.57 2.33-3.52 0.23-0.46-0.29-0.94-0.73-0.68-3.15 1.88-10.07 4.63-11.27 4.5-1.5-0.16-0.77-0.6 1.69-1.92 0.8-0.43 1.28-0.77 1.56-1.05 0.32-0.31 0.13-0.86-0.32-0.89-3.2-0.2-9.29 1.85-12.58 3.06-0.57 0.21-0.97-0.56-0.48-0.91 1.95-1.38 4.75-2.97 4.33-3.01-0.65-0.05-2.59 0.76-2.82 0.54-0.09-0.09-0.05-0.32 0.04-0.56 0.14-0.37-0.18-0.75-0.57-0.69-2 0.33-5.23 2.07-7.56 3.45-0.53 0.32-1.07-0.4-0.62-0.82 1.39-1.29 2.79-2.58 2.14-2.78-1.21-0.37-5.98 2.97-6.05 2.21-0.06-0.76 2.76-3.28 1.28-3-1.49 0.29-5.47 4.67-6 4-0.27-0.35 0.25-1.46 0.82-2.46 0.27-0.46-0.26-0.98-0.72-0.7-1.22 0.74-2.61 1.61-2.71 1.78-0.1 0.19-1.84 0.69-3.22 0.9-0.33 0.01-0.65 0.04-0.98 0.09-0.39 0.01-0.65-0.05-0.69-0.19-0.17-0.64 1.92-1.7 2.27-1.89s4.29-1.27 1.32-1.44-13.69 4.83-13.83 4.56c-0.14-0.26 2.51-2.7 2.82-3.71l0.08-0.25c0.14-0.47-0.4-0.86-0.8-0.57-1.46 1.06-3.73 2.64-5.33 3.76-0.45 0.31-1.02-0.2-0.74-0.68 0.43-0.75 0.88-1.55 1.19-2.07-0.82 0.85-3.11 2-4.98 2.84-0.51 0.23-0.97-0.41-0.59-0.82 0.59-0.64 1.17-1.33 1.68-1.95 0.35-0.43-0.13-1.04-0.63-0.79-3.15 1.57-7.89 3.11-10.31 3.85-0.56 0.17-0.92-0.56-0.46-0.91 0.59-0.46 1.31-0.85 1.86-1.13 0.41-0.21 0.37-0.81-0.07-0.95-2.56-0.87-6.77 1.44-8.45 2.48-0.41 0.25-0.93-0.14-0.79-0.6 0.06-0.19 0.15-0.38 0.24-0.55 0.22-0.4-0.16-0.88-0.6-0.75-0.01 0-0.02 0.01-0.03 0.01-0.53 0.16-0.93-0.49-0.52-0.86 0.5-0.46 1.04-0.86 1.49-1.17 0.38-0.26 0.25-0.86-0.21-0.94-5.43-0.84-10.78 4.83-12.37 6.69 0.93-1.26 1.74-3.14 2.26-4.54 0.18-0.47-0.36-0.89-0.77-0.61-2.06 1.4-5.49 2.93-6.04 3.17-0.05 0.02-0.1 0.03-0.16 0.04-2.01 0.13-5.53 1.38-5.53 1.38l-2.38 0.89 0.01 1.12h-0.01l-0.1 57.87c0.51-0.32-0.08-1.78 1.77-3.45 0.37-0.34 0.96 0.01 0.85 0.5-0.2 0.88-0.48 1.96-0.83 2.97h0.5c2.04-2.68 5.74-6.56 10.04-6.49 0.46 0.01 0.68 0.59 0.34 0.9-0.4 0.37-0.88 0.84-1.31 1.36-0.35 0.43 0.14 1.01 0.64 0.78 0.01 0 0.02-0.01 0.03-0.01 0.42-0.19 0.85 0.23 0.7 0.66-0.07 0.18-0.13 0.38-0.16 0.58-0.08 0.47 0.49 0.79 0.86 0.48 1.53-1.26 5.37-4.12 8.03-3.62 0.45 0.09 0.58 0.67 0.2 0.93-0.51 0.35-1.16 0.84-1.69 1.38-0.41 0.41 0.06 1.08 0.58 0.84 2.3-1.07 6.78-3.25 9.68-5.24 0.46-0.32 1.02 0.22 0.73 0.7-0.42 0.69-0.9 1.45-1.39 2.16-0.32 0.46 0.22 1.03 0.7 0.73 1.73-1.1 3.84-2.55 4.54-3.5 0.24-0.59 0.36-0.85 0.21-0.37-0.04 0.11-0.11 0.24-0.21 0.37-0.23 0.56-0.57 1.41-0.89 2.21-0.2 0.51 0.43 0.95 0.83 0.57 1.43-1.32 3.46-3.21 4.76-4.46 0.36-0.34 0.95-0.03 0.87 0.46l-0.04 0.26c-0.16 1.04-2.46 3.82-2.28 4.06s10.11-6.18 13.07-6.43-0.79 1.37-1.11 1.61c-0.32 0.23-2.25 1.57-1.99 2.18s4.6-1.13 4.73-1.47c0.07-0.19 1.33-1.24 2.43-2.14 0.42-0.34 1 0.1 0.81 0.6-0.43 1.07-0.79 2.24-0.47 2.55 0.62 0.6 3.96-4.3 5.39-4.78s-1.02 2.41-0.85 3.15 4.43-3.22 5.68-3.03c0.67 0.11-0.54 1.58-1.74 3.05-0.39 0.48 0.24 1.12 0.73 0.73 2.12-1.69 5.08-3.86 7.01-4.46 0.38-0.12 0.75 0.21 0.66 0.6-0.06 0.25-0.07 0.49 0.03 0.56 0.26 0.18 2.07-0.89 2.71-0.93 0.42-0.03-2.14 1.93-3.88 3.57-0.18 0.17-0.2 0.38-0.13 0.56 4.46-1.64 7.57-4.2 6.41-6.7s-6.07-4.26-9.81-6.21c-3.41-1.78-5.91-4.43-3.58-6.4 0.23-0.19 0.5-0.38 0.82-0.55 0.04-0.02 0.09-0.05 0.13-0.07 1.67-1.08 5.11-3.2 6.58-3.5 0.06-0.01 0.1-0.03 0.15-0.06 0.51-0.32 3.7-2.31 5.55-3.97 0.37-0.34 0.96 0.01 0.85 0.5-0.29 1.3-0.75 3-1.37 4.32 0.03-0.01 0.06-0.01 0.09-0.02 1.64-2.43 5.9-7.91 11-7.83 0.46 0.01 0.68 0.59 0.34 0.9-0.4 0.37-0.88 0.84-1.31 1.36-0.35 0.43 0.14 1.01 0.64 0.78 0.01 0 0.02-0.01 0.03-0.01 0.42-0.19 0.85 0.23 0.7 0.66-0.07 0.18-0.13 0.38-0.16 0.58-0.08 0.47 0.49 0.79 0.86 0.48 1.53-1.26 5.37-4.12 8.03-3.62 0.45 0.09 0.58 0.67 0.2 0.93-0.51 0.35-1.16 0.84-1.69 1.38-0.35 0.35-0.06 0.88 0.35 0.89 0.06-0.01 0.13-0.02 0.19-0.04 0.01-0.01 0.03-0.01 0.04-0.02 2.3-1.07 6.78-3.25 9.68-5.24 0.46-0.32 1.02 0.22 0.73 0.7-0.42 0.69-0.9 1.45-1.39 2.16-0.18 0.25-0.09 0.54 0.1 0.7 0.31-0.06 0.62-0.11 0.93-0.17 1.66-1.07 3.56-2.4 4.21-3.3 0.24-0.59 0.36-0.85 0.21-0.37-0.04 0.11-0.11 0.24-0.21 0.37-0.23 0.56-0.57 1.41-0.89 2.21-0.07 0.17-0.04 0.34 0.04 0.47 0.38-0.07 0.75-0.14 1.13-0.21 1.4-1.29 3.22-2.99 4.42-4.14 0.36-0.34 0.95-0.03 0.87 0.46l-0.04 0.26c-0.1 0.61-0.91 1.8-1.54 2.74 0.29-0.05 0.59-0.11 0.88-0.16 0.57-0.1 1.14-0.21 1.7-0.32 3.22-1.85 7.87-4.47 9.74-4.62 2.96-0.25-0.79 1.37-1.11 1.61-0.23 0.17-1.28 0.9-1.77 1.53 1.91-0.5 3.7-1.08 5.25-1.79 0.23-0.1 0.44-0.21 0.66-0.32 0.33-0.28 0.69-0.57 1.03-0.85 0.16-0.13 0.35-0.14 0.51-0.08 0.79-0.57 1.4-1.19 1.78-1.82 0.3-0.36 0.61-0.78 0.95-1.29 0.71-1.07 5.84-5.53 8.04-8.19 1.11-1.34 1.85-2.57 2.33-3.52 0.28-0.39-0.23-0.87-0.68-0.61z'
        />
        <path
          fill={st1}
          d='m101.59 624.76l10.17-0.74c0.49-0.04 0.52-0.73 0.04-0.82-2.19-0.38-5.76-0.6-10.36 0.51-0.64 0.17-0.5 1.1 0.15 1.05z'
        />
        <path
          fill={st1}
          d='m121.22 625.97h-11.21c-0.67 0-0.76 0.97-0.11 1.09 2.46 0.46 6.24 0.65 11.38-0.49 0.36-0.07 0.31-0.6-0.06-0.6z'
        />
        <path
          fill={st1}
          d='m298.66 807.41h-22.9s0.66-4.2 11.61-4.2 11.29 4.2 11.29 4.2z'
        />
        <path
          fill={st1}
          d='m258.07 831.42h-22.9s0.66-4.2 11.61-4.2 11.29 4.2 11.29 4.2z'
        />
        <path
          fill={st1}
          d='m389.67 616.01h-11.45s0.33-2.1 5.8-2.1 5.65 2.1 5.65 2.1z'
        />
        <path
          fill={st1}
          d='m403.05 620.86h-11.45s0.33-2.1 5.8-2.1 5.65 2.1 5.65 2.1z'
        />
        <path
          fill={st1}
          d='m148.87 682.48h-11.7s0.34-2.15 5.93-2.15 5.77 2.15 5.77 2.15z'
        />
        <path
          fill={st1}
          d='m167.44 684.63h-11.7s0.34-2.15 5.93-2.15c5.6 0 5.77 2.15 5.77 2.15z'
        />
        <path
          fill={st1}
          d='m190.44 678.7h-11.7s0.34-2.15 5.93-2.15c5.6 0.01 5.77 2.15 5.77 2.15z'
        />
        <path
          fill={st1}
          d='m180.11 674.74h-11.7s0.34-2.15 5.93-2.15 5.77 2.15 5.77 2.15z'
        />
        <path
          fill={st1}
          d='m399.93 606.8h-9.43s0.27-1.77 4.78-1.77 4.65 1.77 4.65 1.77z'
        />
        <path
          fill={st1}
          d='m414.9 608.57h-9.43s0.27-1.77 4.78-1.77 4.65 1.77 4.65 1.77z'
        />
        <path
          fill={st1}
          d='m433.44 603.68h-9.43s0.27-1.77 4.78-1.77 4.65 1.77 4.65 1.77z'
        />
        <path
          fill={st1}
          d='m425.11 600.41h-9.43s0.27-1.77 4.78-1.77 4.65 1.77 4.65 1.77z'
        />
        <path
          fill={st1}
          d='m799.75 464.74s-58.68 52.53-113.1 50.59l24.11-10.14s6.32 2.1 13.1-1.39l75.89-39.06z'
        />
        <path
          fill={st1}
          d='m920.77 515.38l14.11 4.48c2.14 0.68 4.49 0.12 6.09-1.45l12.03-11.77c0.01 0-24.11 9.85-32.23 8.74z'
        />
        <path
          fill={st1}
          d='m225.4 459.02s-8.03 5.16-13.35-0.46c0 0-1.74-5.74-12.81 1.59l-34.94 18.05c4.27 19.87 3.8 51.26 3.8 51.26l-28.08-42.29-43.08 16.48s10.95 62.7 20.31 72.63l162.7 3.04c-0.01-0.01-17.31-78.78-54.55-120.3z'
        />
        <path
          fill={st12}
          d='m174.53 630.89c0.96-0.29 1.96-0.3 2.91-0.42-1.83-3.06-4.07-6.5-6.76-10.16 10.57 4.01 25.8 8.1 45.61 9.27 1.71 1.47 3.42 2.92 5.13 4.35 0.49 0.1 0.92 0.2 1.27 0.32 1.84 0.6 3.76 0.9 5.69 0.86 3.45-0.08 5.03-0.41 10.76-0.27 8.55 0.21 17.08 1.14 25.63 1.02 8.06-0.11 16.25-1.21 23.57-4.53 0.56-0.25 0.58-1.04 0.03-1.32l-0.47-0.25c-0.77-0.4-0.68-1.53 0.13-1.82 1.21-0.44 2.47-0.75 3.75-0.93 2.01-0.29 2.81-2.75 1.33-4.14-12.51-11.74-26.41-23.65-41.7-35.19-5.12-18.94-12.83-32.93-19.52-42.41 15.15 6.97 26.85 8.95 26.85 8.95s-18.17-46.79-67.58-64.28c-4.1 3.16-7.45 7.14-9.83 11.68 7.61 12.43 17.08 22.02 26.75 29.4 6.26 13.45 4.43 23.43 2.29 28.88-11.98-7.21-24.61-14.05-37.87-20.35-8.91 5.59-15.78 13.76-19.69 23.39 8.69 11.31 17.78 21.92 27.11 31.88-5.86 2.56-17.06 5.39-33.24 0.75-8.45-6.54-18.51-12.46-30.37-16.7l-0.19 0.15c-3.94 3.02-7.15 6.84-9.43 11.2l-0.11 0.21c12.85 20.82 30.87 33.73 46.29 41.55 8.18 1.29 13.78 1.29 21.66-1.09z'
        />
        <path
          fill={st1}
          d='m301.74 625.5c0.93 1.27 0.66 3.28-7.79 4.81-0.11 0.02-0.09 0.18 0.02 0.18 4.61-0.33 16.73-1.58 8.16-5.44-0.29-0.13-0.58 0.2-0.39 0.45z'
        />
        <path
          fill={st1}
          d='m202.06 634.27c10.52 3.57 42.94 11.95 97.09 3.18 0.37-0.06 0.49 0.48 0.12 0.57-16.55 4.09-63.3 13.27-97.39-3.31-0.27-0.13-0.11-0.54 0.18-0.44z'
        />
        <path
          fill={st1}
          d='m208.39 642.34c7.94 2.98 29.79 9.05 66.28 3.74 0.3-0.04 0.38 0.39 0.09 0.46-13.18 2.97-47.56 9.01-66.76-3.43-0.43-0.28-0.09-0.95 0.39-0.77z'
        />
        <path
          fill={st1}
          d='m139.86 636.31s48.59 3.11 45.35-3.03c0 0 9.53 9.23-45.35 3.03z'
        />
        <path
          fill={st13}
          d='m188.61 492.09s6.76 1.37 11.62 5.11 7.52 5.82 11.46 6.52c3.94 0.69 9.34 4.16 11.7 8.04s5.55 8.83 8.87 10.03 6.79 4.46 7.76 7.68 0.42 5.03 4.58 8.49c4.16 3.47 7.63 5.82 7.76 8.04s6.38 8.21 6.38 8.21-9.1-24.7-34.5-45.5c0 0-16.93-13.85-33.09-18.78l-2.54 2.16z'
        />
        <path
          fill={st13}
          d='m172.49 539.54s69.1 31.23 120.62 83.32c0 0 2.42 3.21-1.33 4.14s-10.56-8.27-12.99-10.88-7.84-3.08-12.31-4.85c-2.27-0.9-9.79-8.09-13.84-13.03-4.04-4.94-17.73-7.98-21.74-13.5s-3.01-8.52-9.53-9.03c-6.52-0.5-11.53-9.15-15.29-11.28s-8.27-7.77-14.42-9.15-12.29-10.03-14.54-10.53-4.63-5.21-4.63-5.21z'
        />
        <path
          fill={st13}
          d='m116.31 578.86s36.27 10.48 61.13 51.62l-2.91 0.42s-5.44-2.19-5.44-5.57-0.35-4.8-2.76-7.11-8.9-4.27-9.65-6.91-4.26-5.88-7.02-5.76-6.39-2.77-8.02-5.78-2.38-5.89-5.77-6.77c-3.38-0.88-5.26-4.76-7.15-5.77-1.88-1-3.62-2.38-7.2-3.26-3.57-0.9-5.21-5.11-5.21-5.11z'
        />
        <path
          fill={st11}
          d='m208.07 531.01s12.44 7.61 23.82 14.25c2.97 1.73 7.27 11.67 7.27 11.67s-8.51-5.45-11.07-9.14c-2.57-3.7-5.96-2.46-9.55-5.24-3.59-2.77-5.53-3.69-7.54-3.59l-2.93-7.95z'
        />
        <path
          fill={st3}
          d='m179.91 594.81s20.39 22.55 36.37 34.78c0 0-6.2-0.19-13.01-1.25-2.08-0.32-3.9-1.28-5.41-2.45-2.99-2.31-5.02-5.66-5.8-9.35-0.72-3.4-2.61-8.91-7.47-11.67-7.34-4.16-4.68-10.06-4.68-10.06z'
        />
        <path
          fill={st11}
          d='m200.22 493.5s-6.96 1.46-14.21 15.12l1.45 1.94s4.87-11.25 14.8-16.06l-2.04-1z'
        />
        <path
          fill={st12}
          d='m196.95 495.12c0.71 0.37 1.42 0.79 2.11 1.25 1-0.69 2.07-1.33 3.2-1.88l-2.03-0.99c-0.01 0-1.27 0.26-3.28 1.62z'
        />
        <path
          fill={st11}
          d='m113.85 600.75s2.71-12.01 15.15-16.46l2.45 1.32s-9.93 2.68-15.96 17.15l-1.64-2.01z'
        />
        <path
          fill={st12}
          d='m131.62 585.61c-0.03-0.02-0.06-0.03-0.08-0.05l-2.37-1.27c-1.09 0.39-2.11 0.84-3.05 1.34 0.89 0.47 1.65 0.95 2.41 1.38 1.84-1.06 3.07-1.4 3.09-1.4z'
        />
        <path
          fill={st11}
          d='m160.94 573.18s7.25-18.85 24.96-27.01l-5.53-2.89-7.88-3.74s-14.72 8.27-19.69 23.39l8.14 10.25z'
        />
        <path
          fill={st12}
          d='m177.4 544.73c0.93 0.21 2.52 1.8 4.5 3.7 1.35-0.83 2.77-1.6 4.27-2.29-3.67-1.91-6.7-3.42-8.94-4.51l-4.47-2.12s2.38 4.72 4.64 5.22z'
        />
        <path
          fill={`url(#${a})`}
          d='m1047.7 360.89h0.68l2.86-40.53c0.12-1.74 0.01-3.49-0.31-5.21-0.35-1.87-0.62-4.89 0.04-8.57 1.14-6.31 1.69-18.01 1.25-21.99-0.32-2.89-0.87-7.93-1.14-10.44-0.11-1.01 0-2.03 0.32-2.99l0.67-2.03c0.32-0.98 0.31-2.06-0.12-3.01-0.03-0.07-0.06-0.14-0.1-0.21-0.27-0.52-0.37-1.11-0.34-1.7l0.19-4.28c0.02-0.47-0.02-0.93-0.14-1.38l-0.47-1.91c-0.15-0.62-0.17-1.27-0.06-1.9l0.53-2.87c0.14-0.76 0-1.55-0.4-2.21l-0.24-0.4c-0.58-0.98-0.82-2.12-0.67-3.25l0.17-1.33c0.07-0.52-0.03-1.04-0.27-1.5l-0.65-1.22c-0.57-1.08-0.76-2.32-0.52-3.52l0.47-2.4c0.13-0.67 0.07-1.37-0.16-2.01l-0.33-0.88c-0.33-0.89-0.48-1.84-0.43-2.79l0.23-4.61c0.05-1.02-0.25-2.02-0.85-2.84-0.64-0.87-0.76-2-0.34-2.99 0.35-0.81 0.28-1.74-0.18-2.49l-0.54-0.87c-0.36-0.58-0.4-1.3-0.12-1.92l0.66-1.43c0.29-0.64 0.29-1.37-0.02-2l-1.64-3.41-4.14-0.98 2.19 4.76c0.36 0.79 0.26 1.72-0.27 2.41-0.45 0.58-0.54 1.36-0.25 2.04l1.06 2.45c0.24 0.56 0.29 1.18 0.13 1.77l-0.37 1.37c-0.23 0.87-0.07 1.8 0.45 2.53l0.03 0.04c0.58 0.81 0.86 1.79 0.81 2.79l-0.15 2.91c-0.07 1.32 0.25 2.64 0.9 3.79l0.46 0.82c0.37 0.66 0.36 1.46-0.04 2.1-0.49 0.8-0.66 1.76-0.45 2.68l1.18 5.28c0.16 0.7 0.12 1.43-0.1 2.11-0.14 0.42-0.14 0.88 0 1.3 0.49 1.5 1.64 5.06 1.64 5.06l-0.14 3.72c-0.02 0.45 0.09 0.9 0.3 1.3 0.56 1.04 0.65 2.26 0.27 3.37l-0.12 0.33c-0.17 0.5-0.22 1.03-0.15 1.55l0.25 1.77c0.05 0.32 0.05 0.65 0.01 0.97l-0.57 4.44c-0.12 0.95-0.05 1.91 0.2 2.83 0.88 3.22 2.87 11.77 2.01 20.32l-1.79 16.29c-0.15 1.36-0.06 2.73 0.27 4.06l0.23 0.92c0.49 2 0.69 4.05 0.58 6.11l-0.38 7.24-1.03 19.65-1.05 12.99z'
        />
        <polygon
          fill={st3}
          points='1045.3 230.55 1047 226.42 1048.6 229.5 1049.6 219.43 1044.5 220.24'
        />
        <path
          fill={st19}
          d='m1043.6 180.97l-0.43 6.06c-0.02 0.33-0.49 0.37-0.57 0.05l-0.2-0.84c-0.06-0.26-0.45-0.22-0.45 0.05v4.94c0 0.29-0.4 0.38-0.52 0.11l-3.29-7.7c-0.13-0.3-0.58-0.16-0.52 0.16l1.6 7.92c0.06 0.3-0.34 0.45-0.5 0.2l-3.41-5.57c-0.17-0.28-0.59-0.08-0.49 0.23l2.02 5.82c0.1 0.29-0.28 0.5-0.47 0.26l-5.13-6.44c-0.2-0.25-0.59-0.01-0.46 0.28l2.66 6.12c0.12 0.27-0.23 0.51-0.44 0.3l-5.64-5.55c-0.24-0.23-0.61 0.08-0.41 0.35l4.94 6.76c0.17 0.24-0.1 0.54-0.35 0.39l-0.74-0.43c-0.28-0.16-0.56 0.2-0.34 0.43l2.24 2.37c0.21 0.22-0.04 0.58-0.32 0.44l-5.5-2.62c-0.29-0.14-0.55 0.25-0.3 0.46l4.9 4.2c0.23 0.2 0.02 0.57-0.27 0.48l-7.94-2.5c-0.32-0.1-0.51 0.35-0.22 0.51l5.66 3.08c0.25 0.14 0.16 0.52-0.13 0.52h-8.03c-0.32 0-0.39 0.45-0.09 0.54l4.97 1.6c0.3 0.1 0.23 0.54-0.09 0.54h-0.38c-0.31 0-0.39 0.44-0.09 0.54l4.97 1.77c0.38 0.13 0.33 0.69-0.07 0.75l-5.12 0.77c-0.45 0.07-0.43 0.73 0.02 0.77l4.39 0.39c0.39 0.04 0.49 0.57 0.13 0.73l-6.77 3.18c-0.41 0.19-0.21 0.82 0.24 0.73l7.02-1.37c0.4-0.08 0.63 0.44 0.31 0.69l-2.36 1.81c-0.35 0.27-0.04 0.83 0.37 0.67l4.95-1.9c0.34-0.13 0.62 0.28 0.39 0.55l-6.85 7.85c-0.26 0.3 0.1 0.73 0.44 0.52l8.54-5.26c0.3-0.19 0.65 0.14 0.49 0.46l-3.09 5.87c-0.19 0.37 0.31 0.71 0.58 0.38l4.02-4.85c0.24-0.28 0.69-0.05 0.6 0.31l-1.19 4.77c-0.1 0.39 0.43 0.61 0.64 0.26l2.28-3.91c0.18-0.31 0.65-0.18 0.65 0.18l-0.1 9.28c0 0.4 0.56 0.49 0.68 0.11l2.3-7.24c0.11-0.36 0.64-0.31 0.68 0.07l0.24 2.18c0.04 0.39 0.59 0.42 0.68 0.04l1.07-4.53c0.08-0.33 0.54-0.36 0.66-0.05l3.54 9.1c0.16 0.42 0.79 0.27 0.75-0.18l-0.65-6.48c-0.04-0.4 0.47-0.59 0.7-0.26l1.41 1.98c0.22 0.31 0.7 0.15 0.7-0.22v-1.22c0-0.39 0.51-0.54 0.72-0.21l3.78 5.95c0.25 0.4 0.86 0.09 0.69-0.35l-3.38-8.75c-0.12-0.3 0.25-0.56 0.49-0.34l2.77 2.49c0.26 0.24 0.65-0.08 0.47-0.39l-1.82-3.04c-0.17-0.29 0.17-0.6 0.44-0.41l6.98 4.96c0.3 0.21 0.65-0.18 0.41-0.45l-4.77-5.56c-0.21-0.25 0.06-0.61 0.36-0.48l7.37 3.19c0.33 0.14 0.6-0.31 0.31-0.53l-7.15-5.45c-0.26-0.2-0.07-0.61 0.25-0.55l3.67 0.78c0.35 0.07 0.52-0.4 0.21-0.57l-4.25-2.37c-0.25-0.14-0.14-0.52 0.14-0.51l11.57 0.32c0.32 0.01 0.39-0.44 0.08-0.53l-12.75-3.67c-0.27-0.08-0.26-0.47 0.02-0.53l5.44-1.06c0.32-0.06 0.28-0.54-0.05-0.54h-0.39c-0.3 0-0.38-0.41-0.1-0.52l4.21-1.74c0.52-0.21 0.33-0.99-0.22-0.95l-6.2 0.46c-0.49 0.04-0.72-0.58-0.34-0.88l5.95-4.61c0.44-0.34 0.07-1.03-0.46-0.85l-4.22 1.43c-0.5 0.17-0.88-0.46-0.49-0.82l0.94-0.88c0.25-0.24-0.03-0.64-0.34-0.48l-4.3 2.23c-0.29 0.15-0.57-0.21-0.36-0.45l6.75-7.96c0.22-0.26-0.1-0.63-0.39-0.44l-8.76 5.67c-0.26 0.17-0.57-0.12-0.42-0.39l4.65-8.4c0.15-0.27-0.21-0.54-0.43-0.32l-4.35 4.44c-0.21 0.21-0.56-0.02-0.44-0.29l3-7.11c0.13-0.3-0.29-0.53-0.47-0.25l-5.35 8.19c-0.48 0.74-1.63 0.33-1.54-0.55l0.57-5.62c0.05-0.47-0.61-0.64-0.79-0.2l-2.77 6.73c-0.08 0.18-0.35 0.14-0.36-0.06l-0.18-4.97c-0.01-0.25-0.36-0.28-0.42-0.04l-0.64 2.72c-0.11 0.45-0.76 0.43-0.84-0.03l-1.22-7.24c-0.04-0.51-0.75-0.48-0.79 0.02z'
        />
        <circle fill={st3} cx={1045.9} cy={212.6} r={2.02} />
        <polygon
          fill={st3}
          points='1047.2 209.2 1044.6 209.2 1043.9 195.71 1047.9 195.71'
        />
        <path
          fill={st1}
          d='m1282.7 654.07c0.04 0.07 0.11 0.14 0.2 0.21-0.26-0.35-0.38-0.5-0.2-0.21z'
        />
        <path
          fill={st1}
          d='m1317.2 646.76c0.05 0.08 0.12 0.15 0.22 0.24-0.29-0.4-0.43-0.57-0.22-0.24z'
        />
        <path
          fill={st1}
          d='m1242.9 666.12c0.06 0.05 0.15 0.1 0.25 0.14-0.35-0.25-0.52-0.35-0.25-0.14z'
        />
        <path
          fill={st1}
          d='m1373.8 661.19c0.04 0.07 0.11 0.14 0.2 0.21-0.26-0.35-0.38-0.51-0.2-0.21z'
        />
        <path
          fill={st1}
          d='m1334 673.24c0.06 0.05 0.15 0.1 0.25 0.14-0.35-0.25-0.51-0.36-0.25-0.14z'
        />
      </g>
    </svg>
  );
};
