/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2005-2009 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License v1.0 which accompanies this    **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl Development Team - initial API and implementation             **
 **                                                                          **
 **  **********************************************************************  */

package org.rssowl.core.internal.persist.dao;

import org.rssowl.core.internal.persist.Description;
import org.rssowl.core.persist.dao.IPersistableDAO;

/**
 * A data-access-object for <code>Description</code>s.
 */
public interface IDescriptionDAO extends IPersistableDAO<Description> {

  /**
   * @param newsId the identifier of the news the description belongs to
   * @return the resolved {@link Description} object with textual content.
   */
  public Description load(long newsId);

  /**
   * @param newsId the identifier of the news the description belongs to
   * @return the textual content of the resolved {@link Description}.
   */
  public String loadValue(long newsId);
}