/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.ole.win32;

import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.win32.OS;

public class ITypeInfo
extends IUnknown {
    public ITypeInfo(long address) {
        super(address);
    }

    public int GetDocumentation(int index, String[] name, String[] docString, int[] pdwHelpContext, String[] helpFile) {
        int subindex;
        char[] buffer;
        int size;
        long[] pBstrName = null;
        if (name != null) {
            pBstrName = new long[1];
        }
        long[] pBstrDocString = null;
        if (docString != null) {
            pBstrDocString = new long[1];
        }
        long[] pBstrHelpFile = null;
        if (helpFile != null) {
            pBstrHelpFile = new long[1];
        }
        int rc = COM.VtblCall(12, this.address, index, pBstrName, pBstrDocString, pdwHelpContext, pBstrHelpFile);
        if (name != null && pBstrName[0] != 0L) {
            size = COM.SysStringByteLen(pBstrName[0]);
            if (size > 0) {
                buffer = new char[(size + 1) / 2];
                OS.MoveMemory(buffer, pBstrName[0], size);
                name[0] = new String(buffer);
                subindex = name[0].indexOf("\u0000");
                if (subindex > 0) {
                    name[0] = name[0].substring(0, subindex);
                }
            }
            COM.SysFreeString(pBstrName[0]);
        }
        if (docString != null && pBstrDocString[0] != 0L) {
            size = COM.SysStringByteLen(pBstrDocString[0]);
            if (size > 0) {
                buffer = new char[(size + 1) / 2];
                OS.MoveMemory(buffer, pBstrDocString[0], size);
                docString[0] = new String(buffer);
                subindex = docString[0].indexOf("\u0000");
                if (subindex > 0) {
                    docString[0] = docString[0].substring(0, subindex);
                }
            }
            COM.SysFreeString(pBstrDocString[0]);
        }
        if (helpFile != null && pBstrHelpFile[0] != 0L) {
            size = COM.SysStringByteLen(pBstrHelpFile[0]);
            if (size > 0) {
                buffer = new char[(size + 1) / 2];
                OS.MoveMemory(buffer, pBstrHelpFile[0], size);
                helpFile[0] = new String(buffer);
                subindex = helpFile[0].indexOf("\u0000");
                if (subindex > 0) {
                    helpFile[0] = helpFile[0].substring(0, subindex);
                }
            }
            COM.SysFreeString(pBstrHelpFile[0]);
        }
        return rc;
    }

    public int GetFuncDesc(int index, long[] ppFuncDesc) {
        return OS.VtblCall(5, this.address, index, ppFuncDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetIDsOfNames(String[] rgszNames, int cNames, int[] pMemId) {
        int size = rgszNames.length;
        long hHeap = OS.GetProcessHeap();
        long ppNames = OS.HeapAlloc(hHeap, 8, size * C.PTR_SIZEOF);
        long[] memTracker = new long[size];
        try {
            for (int i = 0; i < size; ++i) {
                int nameSize = rgszNames[i].length();
                char[] buffer = new char[nameSize + 1];
                rgszNames[i].getChars(0, nameSize, buffer, 0);
                long pName = OS.HeapAlloc(hHeap, 8, buffer.length * 2);
                OS.MoveMemory(pName, buffer, buffer.length * 2);
                OS.MoveMemory(ppNames + (long)(C.PTR_SIZEOF * i), new long[]{pName}, C.PTR_SIZEOF);
                memTracker[i] = pName;
            }
            int n = COM.VtblCall(10, this.address, ppNames, cNames, pMemId);
            return n;
        }
        finally {
            for (int i = 0; i < memTracker.length; ++i) {
                OS.HeapFree(hHeap, 0, memTracker[i]);
            }
            OS.HeapFree(hHeap, 0, ppNames);
        }
    }

    public int GetImplTypeFlags(int index, int[] pImplTypeFlags) {
        return OS.VtblCall(9, this.address, index, pImplTypeFlags);
    }

    public int GetNames(int memid, String[] names, int cMaxNames, int[] pcNames) {
        int nameSize = names.length;
        long[] rgBstrNames = new long[nameSize];
        int rc = COM.VtblCall(7, this.address, memid, rgBstrNames, nameSize, pcNames);
        if (rc == 0) {
            for (int i = 0; i < pcNames[0]; ++i) {
                int size = COM.SysStringByteLen(rgBstrNames[i]);
                if (size > 0) {
                    char[] buffer = new char[(size + 1) / 2];
                    OS.MoveMemory(buffer, rgBstrNames[i], size);
                    names[i] = new String(buffer);
                    int subindex = names[i].indexOf("\u0000");
                    if (subindex > 0) {
                        names[i] = names[i].substring(0, subindex);
                    }
                }
                COM.SysFreeString(rgBstrNames[i]);
            }
        }
        return rc;
    }

    public int GetRefTypeInfo(int hRefType, long[] ppTInfo) {
        return OS.VtblCall(14, this.address, hRefType, ppTInfo);
    }

    public int GetRefTypeOfImplType(int index, int[] pRefType) {
        return OS.VtblCall(8, this.address, index, pRefType);
    }

    public int GetTypeAttr(long[] ppTypeAttr) {
        return OS.VtblCall(3, this.address, ppTypeAttr);
    }

    public int GetVarDesc(int index, long[] ppVarDesc) {
        return OS.VtblCall(6, this.address, index, ppVarDesc);
    }

    public int ReleaseFuncDesc(long pFuncDesc) {
        return OS.VtblCall(20, this.address, pFuncDesc);
    }

    public int ReleaseTypeAttr(long pTypeAttr) {
        return OS.VtblCall(19, this.address, pTypeAttr);
    }

    public int ReleaseVarDesc(long pVarDesc) {
        return OS.VtblCall(21, this.address, pVarDesc);
    }
}

