/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.nodes.filter.IllegalFilterStateException;
import com.github.weisj.jsvg.util.ConstantProvider;
import com.github.weisj.jsvg.util.LazyProvider;
import com.github.weisj.jsvg.util.Provider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class ChannelStorage<T> {
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull Provider<T>> storage = new HashMap<String, Provider<T>>();

    public void addResult(@NotNull Object key, @NotNull T value) {
        this.storage.put(key.toString(), new ConstantProvider<T>(value));
    }

    public void addResult(@NotNull DefaultFilterChannel key, @NotNull Supplier<T> value) {
        this.storage.put(key.toString(), new LazyProvider<T>(value));
    }

    public void addResult(@NotNull DefaultFilterChannel key, @NotNull T value) {
        this.storage.put(key.toString(), new ConstantProvider<T>(value));
    }

    @NotNull
    public T get(@NotNull Object key) {
        Provider<T> provider = this.storage.get(key.toString());
        if (provider == null) {
            throw new IllegalFilterStateException();
        }
        return provider.get();
    }
}

