/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;

public final class GraphicsUtil {
    private GraphicsUtil() {
    }

    public static void safelySetPaint(@NotNull Graphics2D g, @NotNull Paint paint) {
        g.setPaint(GraphicsUtil.setupPaint(g.getPaint(), paint));
    }

    @NotNull
    public static Paint setupPaint(@NotNull Paint current, @NotNull Paint paint) {
        if (current instanceof WrappingPaint) {
            ((WrappingPaint)((Object)current)).setPaint(paint);
            return current;
        }
        return paint;
    }

    @NotNull
    public static Graphics2D createGraphics(@NotNull BufferedImage image) {
        Graphics2D g = image.createGraphics();
        g.clipRect(0, 0, image.getWidth(), image.getHeight());
        return g;
    }

    public static interface WrappingPaint {
        public void setPaint(@NotNull Paint var1);
    }
}

