/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.util;

import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.prototype.Instantiator;
import com.github.weisj.jsvg.renderer.GraphicsUtil;
import com.github.weisj.jsvg.renderer.NodeRenderer;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlittableImage {
    @NotNull
    private final BufferedImage image;
    @NotNull
    private final RenderContext context;
    @NotNull
    private final Rectangle2D boundsInUserSpace;
    @NotNull
    private final UnitType contentUnits;

    private BlittableImage(@NotNull BufferedImage image, @NotNull RenderContext context, @NotNull Rectangle2D boundsInUserSpace, @NotNull UnitType contentUnits) {
        this.image = image;
        this.context = context;
        this.boundsInUserSpace = boundsInUserSpace;
        this.contentUnits = contentUnits;
    }

    @NotNull
    public static BlittableImage create(@NotNull BufferSurfaceSupplier bufferSurfaceSupplier, @NotNull RenderContext context, @Nullable Rectangle2D clipBounds, @NotNull Rectangle2D bounds, @NotNull Rectangle2D objectBounds, @NotNull UnitType contentUnits) {
        Rectangle2D boundsInUserSpace = GeometryUtil.containingBoundsAfterTransform(context.userSpaceTransform(), bounds);
        Rectangle2D boundsInRootSpace = GeometryUtil.containingBoundsAfterTransform(context.rootTransform(), boundsInUserSpace);
        if (clipBounds != null) {
            Rectangle2D clipBoundsInUserSpace = GeometryUtil.containingBoundsAfterTransform(context.userSpaceTransform(), clipBounds);
            Rectangle2D clipBoundsInRootSpace = GeometryUtil.containingBoundsAfterTransform(context.rootTransform(), clipBoundsInUserSpace);
            Rectangle2D.intersect(clipBoundsInRootSpace, boundsInRootSpace, boundsInRootSpace);
        }
        int imgX = (int)Math.floor(boundsInRootSpace.getX());
        int imgY = (int)Math.floor(boundsInRootSpace.getY());
        int imgWidth = (int)Math.ceil(boundsInRootSpace.getX() + boundsInRootSpace.getWidth()) - imgX;
        int imgHeight = (int)Math.ceil(boundsInRootSpace.getY() + boundsInRootSpace.getHeight()) - imgY;
        Rectangle2D adjustedUserSpaceBounds = new Rectangle2D.Double(imgX, imgY, imgWidth, imgHeight);
        try {
            adjustedUserSpaceBounds = GeometryUtil.containingBoundsAfterTransform(context.rootTransform().createInverse(), adjustedUserSpaceBounds);
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        BufferedImage img = bufferSurfaceSupplier.createBufferSurface(null, imgWidth, imgHeight);
        RenderContext imageContext = RenderContext.createInitial(context.targetComponent(), contentUnits.deriveMeasure(context.measureContext()));
        AffineTransform rootTransform = new AffineTransform();
        Rectangle2D ub = adjustedUserSpaceBounds;
        rootTransform.translate(boundsInRootSpace.getX() - (double)imgX, boundsInRootSpace.getY() - (double)imgY);
        if (contentUnits == UnitType.ObjectBoundingBox) {
            rootTransform.scale(objectBounds.getWidth() * (double)img.getWidth() / ub.getWidth(), objectBounds.getWidth() * (double)img.getHeight() / ub.getHeight());
        } else {
            rootTransform.scale((double)img.getWidth() / ub.getWidth(), (double)img.getHeight() / ub.getHeight());
            rootTransform.translate(-ub.getX(), -ub.getY());
        }
        imageContext.setRootTransform(rootTransform, context.userSpaceTransform());
        return new BlittableImage(img, imageContext, ub, contentUnits);
    }

    @NotNull
    public Rectangle2D boundsInUserSpace() {
        return this.boundsInUserSpace;
    }

    @NotNull
    public BufferedImage image() {
        return this.image;
    }

    @NotNull
    public Graphics2D createGraphics() {
        Graphics2D g = GraphicsUtil.createGraphics(this.image);
        g.transform(this.context.rootTransform());
        if (this.contentUnits == UnitType.UserSpaceOnUse) {
            g.transform(this.context.userSpaceTransform());
        } else {
            this.context.setRootTransform(this.context.rootTransform(), new AffineTransform());
        }
        return g;
    }

    public void renderNode(@NotNull Graphics2D parentGraphics, @NotNull SVGNode node, @NotNull Instantiator instantiator) {
        Graphics2D imgGraphics = this.createGraphics();
        imgGraphics.setRenderingHints(parentGraphics.getRenderingHints());
        try (NodeRenderer.Info info = NodeRenderer.createRenderInfo(node, this.context, imgGraphics, instantiator);){
            if (info != null) {
                info.renderable.render(info.context, info.graphics());
            }
        }
        imgGraphics.dispose();
    }

    public void prepareForBlitting(@NotNull Graphics2D g, @NotNull RenderContext parentContext) {
        g.setTransform(parentContext.rootTransform());
        g.translate(this.boundsInUserSpace.getX(), this.boundsInUserSpace.getY());
        g.scale(this.boundsInUserSpace.getWidth() / (double)this.image.getWidth(), this.boundsInUserSpace.getHeight() / (double)this.image.getHeight());
    }

    public void blitTo(@NotNull Graphics2D g, @NotNull RenderContext parentContext) {
        Graphics2D gg = (Graphics2D)g.create();
        this.prepareForBlitting(g, parentContext);
        gg.drawImage(this.image, 0, 0, this.image.getWidth(), this.image.getHeight(), null, null);
        gg.dispose();
    }

    @FunctionalInterface
    public static interface BufferSurfaceSupplier {
        @NotNull
        public BufferedImage createBufferSurface(@Nullable AffineTransform var1, double var2, double var4);
    }
}

