/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AntiAliasedRoundRectangle;
import application.Shutter;
import application.Utils;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.MatteBorder;
import library.MEDIAINFO;

public class Informations {
    public static JFrame frame;
    private static JPanel topPanel;
    private boolean drag = false;
    private JLabel quit;
    private JLabel reduce;
    private JLabel topImage;
    private JLabel bottomImage;
    public static JPanel tabPanel;
    public static JLabel lblWait;
    public static JLabel lblArrows;
    public static JTabbedPane infoTabbedPane;
    private static int MousePositionX;
    private static int MousePositionY;

    static {
        infoTabbedPane = new JTabbedPane(1);
    }

    public Informations() {
        frame = new JFrame();
        frame.getContentPane().setBackground(new Color(30, 30, 35));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameInformations"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(600, 670);
        frame.setResizable(false);
        frame.setUndecorated(true);
        Area shape1 = new Area(new AntiAliasedRoundRectangle(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
        Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
        shape1.add(shape2);
        frame.setShape(shape1);
        frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
        frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle winSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Shutter.taskBarHeight = (int)(dim.getHeight() - (double)winSize.height);
        frame.setLocation(dim.width / 2 - Informations.frame.getSize().width / 2, dim.height / 2 - Informations.frame.getSize().height / 2);
        lblWait = new JLabel(Shutter.language.getProperty("lblWait"));
        lblWait.setFont(new Font(Shutter.freeSansFont, 0, 20));
        lblWait.setForeground(Color.WHITE);
        lblWait.setSize(Informations.lblWait.getPreferredSize().width, 40);
        lblWait.setLocation(Informations.frame.getSize().width / 2 - Informations.lblWait.getSize().width / 2, Informations.frame.getSize().height / 2);
        lblWait.setVisible(true);
        frame.getContentPane().add(lblWait);
        lblArrows = new JLabel("\u25b2\u25bc");
        lblArrows.setHorizontalAlignment(0);
        lblArrows.setFont(new Font(Shutter.freeSansFont, 0, 20));
        lblArrows.setSize(new Dimension(Informations.frame.getSize().width, 20));
        lblArrows.setLocation(0, Informations.frame.getSize().height - Informations.lblArrows.getSize().height);
        lblArrows.setVisible(false);
        frame.getContentPane().add(lblArrows);
        this.topPanel();
        frame.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Informations.this.drag && Informations.frame.getSize().height > 90 && !MEDIAINFO.isRunning) {
                    frame.setSize(Informations.frame.getSize().width, e.getY() + 10);
                    lblArrows.setLocation(0, Informations.frame.getSize().height - Informations.lblArrows.getSize().height);
                    tabPanel.setBounds(0, Informations.topPanel.getSize().height, Informations.frame.getSize().width, Informations.frame.getSize().height - Informations.topPanel.getSize().height - 20);
                    infoTabbedPane.setBounds(tabPanel.getBounds());
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MouseInfo.getPointerInfo().getLocation().y - Informations.frame.getLocation().y > Informations.frame.getSize().height - 20 && infoTabbedPane.getTabCount() > 0 && !MEDIAINFO.isRunning) {
                    frame.setCursor(Cursor.getPredefinedCursor(9));
                } else if (!Informations.this.drag && infoTabbedPane.getTabCount() > 0 && !MEDIAINFO.isRunning) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (frame.getCursor().getType() == 9) {
                    Informations.this.drag = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Informations.this.drag = false;
                if (!MEDIAINFO.isRunning) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
                Area shape1 = new Area(new AntiAliasedRoundRectangle(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
                Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
                shape1.add(shape2);
                frame.setShape(shape1);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (Informations.frame.getSize().height <= 90) {
                    frame.setSize(Informations.frame.getSize().width, 100);
                    lblArrows.setLocation(0, Informations.frame.getSize().height - Informations.lblArrows.getSize().height);
                    tabPanel.setBounds(0, Informations.topPanel.getSize().height, Informations.frame.getSize().width, Informations.frame.getSize().height - Informations.topPanel.getSize().height - 20);
                    infoTabbedPane.setBounds(tabPanel.getBounds());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (frame.getCursor().getType() == 9) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (infoTabbedPane.getTabCount() > 1) {
                    if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                        infoTabbedPane.remove(infoTabbedPane.getSelectedIndex());
                    }
                } else if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                    infoTabbedPane.removeAll();
                    Utils.changeFrameVisibility(frame, true);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        infoTabbedPane.addKeyListener(keyListener);
        frame.addKeyListener(keyListener);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                if (System.getProperty("os.name").contains("Mac") && Informations.this.drag) {
                    frame.setShape(null);
                } else {
                    Area shape1 = new Area(new AntiAliasedRoundRectangle(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
                    Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
                    shape1.add(shape2);
                    frame.setShape(shape1);
                }
            }
        });
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeiconified(WindowEvent we) {
                frame.toFront();
            }
        });
    }

    public static void addTabControl() {
        tabPanel = new JPanel();
        tabPanel.setBackground(new Color(35, 255, 35));
        tabPanel.setFont(new Font("SansSerif", 0, 12));
        tabPanel.setLayout(null);
        tabPanel.setBounds(0, Informations.topPanel.getSize().height, Informations.frame.getSize().width, Informations.frame.getSize().height - Informations.topPanel.getSize().height - 20);
        infoTabbedPane.setBounds(tabPanel.getBounds());
        infoTabbedPane.setForeground(Color.WHITE);
        frame.getContentPane().add(infoTabbedPane);
    }

    private void topPanel() {
        topPanel = new JPanel();
        topPanel.setLayout(null);
        topPanel.setBackground(new Color(30, 30, 35));
        topPanel.setBounds(0, 0, Informations.frame.getSize().width, 28);
        this.quit = new JLabel(new FlatSVGIcon("contents/quit.svg", 15, 15));
        this.quit.setBounds(Informations.frame.getSize().width - 20, 4, 15, 15);
        this.reduce = new JLabel(new FlatSVGIcon("contents/reduce.svg", 15, 15));
        this.reduce.setHorizontalAlignment(0);
        this.reduce.setBounds(this.quit.getLocation().x - 20, 4, 15, 15);
        this.reduce.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Informations.this.reduce.setIcon(new FlatSVGIcon("contents/reduce_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    frame.setState(1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Informations.this.reduce.setIcon(new FlatSVGIcon("contents/reduce_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Informations.this.reduce.setIcon(new FlatSVGIcon("contents/reduce.svg", 15, 15));
                this.accept = false;
            }
        });
        this.bottomImage = new JLabel();
        this.bottomImage.setBackground(new Color(35, 35, 40));
        this.bottomImage.setOpaque(true);
        this.bottomImage.setBorder(new MatteBorder(1, 0, 1, 0, new Color(65, 65, 65)));
        this.bottomImage.setBounds(0, 1, Informations.frame.getSize().width, 24);
        JLabel title = new JLabel(Shutter.language.getProperty("frameInformations"));
        title.setHorizontalAlignment(0);
        title.setBounds(0, 1, frame.getWidth(), 24);
        title.setFont(new Font(Shutter.magnetoFont, 0, 17));
        topPanel.add(title);
        this.topImage = new JLabel();
        this.topImage.setBackground(new Color(35, 35, 40));
        this.topImage.setOpaque(true);
        this.topImage.setBorder(new MatteBorder(1, 0, 1, 0, new Color(65, 65, 65)));
        this.topImage.setBounds(title.getBounds());
        topPanel.add(this.quit);
        topPanel.add(this.reduce);
        topPanel.add(this.topImage);
        topPanel.add(this.bottomImage);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Informations.this.quit.setIcon(new FlatSVGIcon("contents/quit_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    infoTabbedPane.removeAll();
                    Utils.changeFrameVisibility(frame, true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Informations.this.quit.setIcon(new FlatSVGIcon("contents/quit_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Informations.this.quit.setIcon(new FlatSVGIcon("contents/quit.svg", 15, 15));
                this.accept = false;
            }
        });
        topPanel.setBounds(0, 0, Informations.frame.getSize().width, 28);
        frame.getContentPane().add(topPanel);
        this.bottomImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePositionX = down.getPoint().x;
                MousePositionY = down.getPoint().y;
                frame.toFront();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.bottomImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePositionX, MouseInfo.getPointerInfo().getLocation().y - MousePositionY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }
}

