/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Settings;
import application.Utils;
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.TransferHandler;

class OutputTransferHandler
extends TransferHandler {
    OutputTransferHandler() {
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] arg1) {
        int i = 0;
        while (i < arg1.length) {
            DataFlavor flavor = arg1[i];
            if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                if (comp.getName().equals("lblDestination1")) {
                    if (!Settings.lastUsedOutput1.isSelected()) {
                        Settings.lblDestination1.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
                        return true;
                    }
                    return false;
                }
                if (comp.getName().equals("lblDestination2")) {
                    if (!Settings.lastUsedOutput2.isSelected()) {
                        Settings.lblDestination2.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
                        return true;
                    }
                    return false;
                }
                if (comp.getName().equals("lblDestination3")) {
                    if (!Settings.lastUsedOutput3.isSelected()) {
                        Settings.lblDestination3.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
                        return true;
                    }
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        DataFlavor[] flavors = t.getTransferDataFlavors();
        int i = 0;
        while (i < flavors.length) {
            DataFlavor flavor = flavors[i];
            try {
                if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                    List l = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : l) {
                        if (System.getProperty("os.name").contains("Windows") && file.toString().substring(0, 2).equals("\\\\")) {
                            file = Utils.UNCPath(file);
                        }
                        if (file.getName().contains(".")) {
                            ((JLabel)comp).setText(file.getParent());
                            continue;
                        }
                        ((JLabel)comp).setText(file.getAbsolutePath());
                    }
                    Settings.lblDestination1.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 0));
                    Settings.lblDestination2.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 0));
                    Settings.lblDestination3.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 0));
                    return true;
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
            ++i;
        }
        return false;
    }
}

