/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Shutter;
import application.SubtitlesTimeline;
import application.Utils;
import application.VideoPlayer;
import com.formdev.flatlaf.ui.FlatLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class SubtitlesEdit {
    public static JFrame frame;
    public static int textPosition;
    private static JScrollBar scrollBar;
    private static int lastScrollBarValue;
    private static int scrollValue;
    private static long keyboardTime;
    private static boolean keyboardLoop;
    public static boolean isWriting;
    private boolean drag = false;
    private static boolean refreshSubs;

    static {
        scrollValue = 0;
        keyboardLoop = false;
        isWriting = false;
        refreshSubs = false;
    }

    public SubtitlesEdit() {
        textPosition = 12;
        frame = new JFrame();
        frame.setAlwaysOnTop(true);
        frame.setResizable(false);
        frame.getContentPane().setLayout(null);
        frame.setSize(620, 640);
        frame.setAlwaysOnTop(true);
        frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        frame.getContentPane().setBackground(new Color(30, 30, 35));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameSubtitlesEdit"));
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(dim.width / 2 - SubtitlesEdit.frame.getSize().width / 2, dim.height / 2 - SubtitlesEdit.frame.getSize().height / 2);
        scrollBar = new JScrollBar();
        scrollBar.setBackground(new Color(30, 30, 35));
        scrollBar.setOrientation(1);
        frame.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (scrollBar.isVisible()) {
                    scrollBar.setValue(scrollBar.getValue() + e.getWheelRotation() * 10);
                }
            }
        });
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                SubtitlesTimeline.setSubtitles(SubtitlesTimeline.srt);
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        frame.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int i = 0;
                int posY = 0;
                Component[] componentArray = frame.getContentPane().getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JTextPane) {
                        i = c.getY() + c.getHeight() + 60 - frame.getHeight();
                        posY = c.getY() + c.getHeight() + 36;
                    }
                    ++n2;
                }
                if (i > 0) {
                    scrollBar.setVisible(true);
                    scrollBar.setMaximum(i);
                    frame.getContentPane().add(scrollBar);
                } else {
                    scrollBar.setVisible(false);
                    frame.getContentPane().remove(scrollBar);
                }
                SubtitlesEdit.this.drag = e.getY() <= posY;
                if (SubtitlesEdit.this.drag && SubtitlesEdit.frame.getSize().height > 90) {
                    frame.setSize(SubtitlesEdit.frame.getSize().width, e.getY() + 10);
                    if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                        scrollBar.setBounds(frame.getWidth() - 17, 0, 17, frame.getHeight() - 35);
                    } else {
                        scrollBar.setBounds(frame.getWidth() - 34, 0, 17, frame.getHeight() - 40);
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MouseInfo.getPointerInfo().getLocation().y - SubtitlesEdit.frame.getLocation().y > SubtitlesEdit.frame.getSize().height - 20) {
                    frame.setCursor(Cursor.getPredefinedCursor(9));
                } else if (!SubtitlesEdit.this.drag) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (frame.getCursor().getType() == 9) {
                    SubtitlesEdit.this.drag = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SubtitlesEdit.this.drag = false;
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SubtitlesEdit.frame.getSize().height <= 90) {
                    frame.setSize(SubtitlesEdit.frame.getSize().width, 100);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (frame.getCursor().getType() == 9) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                int scrollIncrement = scrollBar.getValue() - scrollValue;
                Component[] componentArray = frame.getContentPane().getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (!(c instanceof JButton || c instanceof JScrollBar || c instanceof JPanel)) {
                        c.setLocation(c.getLocation().x, c.getLocation().y - scrollIncrement);
                    }
                    ++n2;
                }
                scrollValue = scrollBar.getValue();
            }
        });
        frame.setVisible(true);
        frame.repaint();
    }

    private static JTextPane addText(String subContent) {
        final JTextPane text = new JTextPane();
        text.setText(subContent);
        text.setCaretColor(Color.BLACK);
        text.setBounds(180, textPosition, 400, 48);
        textPosition += 60;
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                keyboardTime = System.currentTimeMillis();
                boolean control = false;
                boolean shift = false;
                if ((e.getModifiersEx() & 0x100) != 0 || (e.getModifiersEx() & 0x80) != 0) {
                    control = true;
                    if (e.getKeyCode() == 16) {
                        shift = true;
                    }
                }
                if (control) {
                    if (e.getKeyCode() == 90 && !shift) {
                        SubtitlesTimeline.loadBackupSubtitles();
                    } else if (e.getKeyCode() == 90 && shift || e.getKeyCode() == 89) {
                        SubtitlesTimeline.loadRestoreSubtitles();
                    }
                }
                text.requestFocus();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.keyboardSaveTime();
            }

            private void keyboardSaveTime() {
                if (!keyboardLoop) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            do {
                                keyboardLoop = true;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (keyboardTime + 1000L > System.currentTimeMillis());
                            SubtitlesEdit.updateTimeline();
                            keyboardLoop = false;
                        }
                    });
                    t.start();
                }
            }
        });
        text.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                isWriting = true;
                int selectedSub = 0;
                Component[] componentArray = frame.getContentPane().getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JTextPane) {
                        ++selectedSub;
                        if (c.getY() == text.getY()) break;
                    }
                    ++n2;
                }
                int currentSubtitle = 0;
                Component[] componentArray2 = SubtitlesTimeline.timeline.getComponents();
                int n3 = componentArray2.length;
                n = 0;
                while (n < n3) {
                    Component c = componentArray2[n];
                    if (c instanceof JTextPane && ++currentSubtitle == selectedSub) {
                        SubtitlesTimeline.cursor.setLocation(c.getX(), SubtitlesTimeline.cursor.getY());
                        VideoPlayer.sliderChange = true;
                        if (c.getX() <= 0) {
                            SubtitlesTimeline.cursor.setLocation(0, SubtitlesTimeline.cursor.getLocation().y);
                            VideoPlayer.slider.setValue(0);
                        } else {
                            SubtitlesTimeline.cursor.setLocation(c.getX(), SubtitlesTimeline.cursor.getLocation().y);
                            VideoPlayer.slider.setValue((int)((double)c.getX() / SubtitlesTimeline.zoom / (double)VideoPlayer.inputFramerateMS));
                        }
                        VideoPlayer.sliderChange = false;
                        VideoPlayer.getTimePoint(VideoPlayer.playerCurrentFrame - 1.0f);
                        break;
                    }
                    ++n;
                }
            }
        });
        return text;
    }

    private static JTextField addInPoint(String subIn) {
        JTextField in = new JTextField();
        in.setText(subIn);
        in.setBorder(new FlatLineBorder(new Insets(0, 0, 0, 0), new Color(55, 55, 55), 1.0f, 5));
        in.setForeground(Utils.themeColor);
        in.setFont(new Font(Shutter.montserratFont, 0, 12));
        in.setBounds(77, textPosition - 2, 94, 25);
        in.setBackground(new Color(30, 30, 35));
        in.setHorizontalAlignment(0);
        in.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                keyboardTime = System.currentTimeMillis();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.keyboardSaveTime();
            }

            private void keyboardSaveTime() {
                if (!keyboardLoop) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            do {
                                keyboardLoop = true;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (keyboardTime + 1000L > System.currentTimeMillis());
                            SubtitlesEdit.updateTimeline();
                            keyboardLoop = false;
                        }
                    });
                    t.start();
                }
            }
        });
        in.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                isWriting = true;
            }
        });
        return in;
    }

    private static JTextField addOutPoint(String subOut) {
        JTextField out = new JTextField();
        out.setText(subOut);
        out.setBorder(new FlatLineBorder(new Insets(0, 0, 0, 0), new Color(55, 55, 55), 1.0f, 5));
        out.setForeground(Utils.themeColor);
        out.setFont(new Font(Shutter.montserratFont, 0, 12));
        out.setBounds(77, textPosition + 24, 94, 25);
        out.setBackground(new Color(30, 30, 35));
        out.setHorizontalAlignment(0);
        out.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                keyboardTime = System.currentTimeMillis();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.keyboardSaveTime();
            }

            private void keyboardSaveTime() {
                if (!keyboardLoop) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            do {
                                keyboardLoop = true;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (keyboardTime + 1000L > System.currentTimeMillis());
                            SubtitlesEdit.updateTimeline();
                            keyboardLoop = false;
                        }
                    });
                    t.start();
                }
            }
        });
        out.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                isWriting = true;
            }
        });
        return out;
    }

    private static JLabel addNumber(int number) {
        JLabel nb = new JLabel(String.valueOf(number));
        nb.setFont(new Font(Shutter.montserratFont, 0, 12));
        nb.setHorizontalAlignment(0);
        nb.setBounds(9, textPosition + 16, 61, 16);
        return nb;
    }

    private static void addSubtitles() {
        BufferedReader reader = null;
        try {
            try {
                if (SubtitlesTimeline.srt.exists()) {
                    String line;
                    reader = Files.newBufferedReader(Paths.get(SubtitlesTimeline.srt.toString(), new String[0]), StandardCharsets.UTF_8);
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.replace("\ufeff", "")).matches("[0-9]+")) {
                            frame.getContentPane().add(SubtitlesEdit.addNumber(Integer.valueOf(line)));
                            continue;
                        }
                        if (line.isEmpty()) continue;
                        String[] s = line.split(" ");
                        frame.getContentPane().add(SubtitlesEdit.addInPoint(s[0]));
                        frame.getContentPane().add(SubtitlesEdit.addOutPoint(s[2]));
                        StringBuilder subContent = new StringBuilder();
                        while ((line = reader.readLine()) != null && !line.isEmpty()) {
                            subContent.append(line + System.lineSeparator());
                        }
                        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                            frame.getContentPane().add(SubtitlesEdit.addText(subContent.toString().substring(0, subContent.length() - 1)));
                            continue;
                        }
                        frame.getContentPane().add(SubtitlesEdit.addText(subContent.toString().substring(0, subContent.length() - 2)));
                    }
                }
            }
            catch (Exception exception) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                frame.repaint();
                frame.getContentPane().repaint();
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            frame.repaint();
            frame.getContentPane().repaint();
        }
    }

    public static void refreshSubtitles() {
        if (frame != null && frame.isVisible() && !VideoPlayer.playerIsPlaying() && !VideoPlayer.sliderChange && !refreshSubs) {
            refreshSubs = true;
            Thread refresh = new Thread(new Runnable(){

                @Override
                public void run() {
                    Component[] componentArray = frame.getContentPane().getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component c = componentArray[n2];
                        if (!(c instanceof JScrollBar)) {
                            frame.remove(c);
                        }
                        ++n2;
                    }
                    textPosition = 12;
                    scrollBar.setValue(0);
                    SubtitlesEdit.addSubtitles();
                    if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                        scrollBar.setBounds(frame.getWidth() - 17, 0, 17, frame.getHeight() - 35);
                    } else {
                        scrollBar.setBounds(frame.getWidth() - 34, 0, 17, frame.getHeight() - 40);
                    }
                    int i = 0;
                    Component[] componentArray2 = frame.getContentPane().getComponents();
                    int n3 = componentArray2.length;
                    n = 0;
                    while (n < n3) {
                        Component c = componentArray2[n];
                        if (c instanceof JTextPane) {
                            i = c.getY() + c.getHeight() + 60 - frame.getHeight();
                        }
                        ++n;
                    }
                    if (i > 0) {
                        scrollBar.setVisible(true);
                        scrollBar.setMaximum(i);
                        frame.getContentPane().add(scrollBar);
                        int currentSubtitle = 0;
                        boolean subExists = false;
                        Component[] componentArray3 = SubtitlesTimeline.timeline.getComponents();
                        int n4 = componentArray3.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            Component c = componentArray3[n5];
                            if (c instanceof JTextPane) {
                                ++currentSubtitle;
                                if (SubtitlesTimeline.cursor.getLocation().x >= c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x < c.getLocation().x + c.getWidth()) {
                                    subExists = true;
                                    break;
                                }
                            }
                            ++n5;
                        }
                        if (subExists) {
                            int currentText = 0;
                            int currentTextPosY = 0;
                            Component[] componentArray4 = frame.getContentPane().getComponents();
                            int n6 = componentArray4.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                Component c = componentArray4[n7];
                                if (c instanceof JTextPane && ++currentText == currentSubtitle) {
                                    currentTextPosY = c.getY() - 12;
                                    break;
                                }
                                ++n7;
                            }
                            if (currentTextPosY < scrollBar.getMaximum()) {
                                scrollBar.setValue(currentTextPosY);
                            } else {
                                scrollBar.setValue(scrollBar.getMaximum());
                            }
                            lastScrollBarValue = scrollBar.getValue();
                        } else {
                            scrollBar.setValue(lastScrollBarValue);
                        }
                    } else {
                        scrollBar.setVisible(false);
                        frame.getContentPane().remove(scrollBar);
                    }
                    frame.repaint();
                    refreshSubs = false;
                }
            });
            refresh.start();
        }
    }

    private static void updateTimeline() {
        BufferedWriter writer = null;
        try {
            try {
                writer = Files.newBufferedWriter(Paths.get(SubtitlesTimeline.srt.toString(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
                boolean isInPoint = true;
                Component[] componentArray = frame.getContentPane().getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JLabel) {
                        if (((JLabel)c).getText().matches("[0-9]+")) {
                            if (((JLabel)c).getText().equals("1")) {
                                writer.write(((JLabel)c).getText() + System.lineSeparator());
                            } else {
                                writer.write(System.lineSeparator() + System.lineSeparator() + ((JLabel)c).getText() + System.lineSeparator());
                            }
                        }
                    } else if (c instanceof JTextField) {
                        if (isInPoint) {
                            writer.write(((JTextField)c).getText() + " --> ");
                            isInPoint = false;
                        } else {
                            writer.write(((JTextField)c).getText() + System.lineSeparator());
                            isInPoint = true;
                        }
                    } else if (c instanceof JTextPane) {
                        writer.write(((JTextPane)c).getText());
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                try {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException2) {
                        SubtitlesTimeline.timeline.removeAll();
                        SubtitlesTimeline.setSubtitles(SubtitlesTimeline.srt);
                    }
                }
                finally {
                    SubtitlesTimeline.timeline.removeAll();
                    SubtitlesTimeline.setSubtitles(SubtitlesTimeline.srt);
                }
            }
        }
        finally {
            block31: {
                try {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        SubtitlesTimeline.timeline.removeAll();
                        SubtitlesTimeline.setSubtitles(SubtitlesTimeline.srt);
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    SubtitlesTimeline.timeline.removeAll();
                    SubtitlesTimeline.setSubtitles(SubtitlesTimeline.srt);
                    throw throwable;
                }
                SubtitlesTimeline.timeline.removeAll();
                SubtitlesTimeline.setSubtitles(SubtitlesTimeline.srt);
            }
        }
    }
}

