/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.nodes.container.ContainerNode;
import com.github.weisj.jsvg.nodes.filter.Channel;
import com.github.weisj.jsvg.nodes.filter.FeMergeNode;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitiveBase;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.GraphicsUtil;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.FilterPrimitive})
@PermittedContent(anyOf={FeMergeNode.class})
public final class FeMerge
extends ContainerNode
implements FilterPrimitive {
    public static final String TAG = "feMerge";
    private FilterPrimitiveBase filterPrimitiveBase;
    private Object[] inputChannels;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.filterPrimitiveBase = new FilterPrimitiveBase(attributeNode);
        List<FeMergeNode> nodes = this.childrenOfType(FeMergeNode.class);
        this.inputChannels = new Object[nodes.size()];
        for (int i = 0; i < this.inputChannels.length; ++i) {
            this.inputChannels[i] = nodes.get(i).inputChannel();
        }
    }

    @Override
    public boolean isValid() {
        return this.inputChannels.length > 0;
    }

    @Override
    @NotNull
    public Length x() {
        return this.filterPrimitiveBase.x;
    }

    @Override
    @NotNull
    public Length y() {
        return this.filterPrimitiveBase.y;
    }

    @Override
    @NotNull
    public Length width() {
        return this.filterPrimitiveBase.width;
    }

    @Override
    @NotNull
    public Length height() {
        return this.filterPrimitiveBase.height;
    }

    @Override
    public void layoutFilter(@NotNull RenderContext context, @NotNull FilterLayoutContext filterLayoutContext) {
        if (this.inputChannels.length == 0) {
            this.filterPrimitiveBase.saveLayoutResult(filterLayoutContext.resultChannels().get((Object)DefaultFilterChannel.SourceGraphic), filterLayoutContext);
            return;
        }
        Rectangle2D in = filterLayoutContext.resultChannels().get(this.inputChannels[0]);
        Rectangle2D result = in.getBounds2D();
        for (int i = 1; i < this.inputChannels.length; ++i) {
            Rectangle2D channelBounds = filterLayoutContext.resultChannels().get(this.inputChannels[i]);
            Rectangle2D.union(channelBounds, result, result);
        }
        this.filterPrimitiveBase.saveLayoutResult(result, filterLayoutContext);
    }

    @Override
    public void applyFilter(@NotNull RenderContext context, @NotNull FilterContext filterContext) {
        Channel in;
        if (this.inputChannels.length == 0) {
            this.filterPrimitiveBase.saveResult(this.filterPrimitiveBase.channel((Object)DefaultFilterChannel.SourceGraphic, filterContext), filterContext);
            return;
        }
        Channel result = in = this.filterPrimitiveBase.channel(this.inputChannels[0], filterContext);
        if (this.inputChannels.length > 1) {
            BufferedImage dst = in.toBufferedImageNonAliased(context);
            Graphics2D imgGraphics = GraphicsUtil.createGraphics(dst);
            for (int i = 1; i < this.inputChannels.length; ++i) {
                Channel channel = this.filterPrimitiveBase.channel(this.inputChannels[i], filterContext);
                imgGraphics.drawImage(context.createImage(channel.producer()), null, context.targetComponent());
            }
            result = new ImageProducerChannel(dst.getSource());
        }
        this.filterPrimitiveBase.saveResult(result, filterContext);
    }
}

