/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Ftp;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import functions.AudioNormalization;
import java.io.File;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;
import settings.InputAndOutput;
import settings.Transitions;

public class AudioEncoders
extends Shutter {
    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int i = 0;
                while (i < liste.getSize()) {
                    block64: {
                        File file;
                        block65: {
                            if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) break block65;
                            boolean isSelected = false;
                            for (String input : Shutter.fileList.getSelectedValuesList()) {
                                if (!((String)liste.getElementAt(i)).equals(input)) continue;
                                isSelected = true;
                            }
                            if (!isSelected) break block64;
                        }
                        if ((file = FunctionUtils.setInputFile(new File((String)liste.getElementAt(i)))) == null) break;
                        try {
                            String fileOutputName;
                            File fileOut;
                            String fileName = file.getName();
                            String extension = fileName.substring(fileName.lastIndexOf("."));
                            lblCurrentEncoding.setText(fileName);
                            if (!FunctionUtils.analyze(file, false)) break block64;
                            VideoPlayer.getFileList(file.toString());
                            InputAndOutput.getInputAndOutput();
                            String labelOutput = FunctionUtils.setOutputDestination("", file);
                            String extensionName = "";
                            if (btnExtension.isSelected()) {
                                extensionName = FunctionUtils.setSuffix(txtExtension.getText(), false);
                            }
                            String DRC = "";
                            if (FFPROBE.audioCodec != null && FFPROBE.audioCodec.equals("ac3") && !caseDRC.isSelected()) {
                                DRC = " -drc_scale 0";
                            }
                            Object audioCodec = "";
                            Object container = "";
                            String noVideo = " -vn";
                            if (FFPROBE.attachedPic) {
                                noVideo = "";
                            }
                            boolean stereoOutput = false;
                            switch (comboFonctions.getSelectedItem().toString()) {
                                case "AAC": {
                                    audioCodec = System.getProperty("os.name").contains("Mac") ? "aac_at -b:a " + comboFilter.getSelectedItem().toString() + "k -vn -write_id3v2 1" : "aac -b:a " + comboFilter.getSelectedItem().toString() + "k -vn -write_id3v2 1";
                                    container = ".m4a";
                                    stereoOutput = false;
                                    break;
                                }
                                case "AC3": {
                                    audioCodec = "ac3 -b:a " + comboFilter.getSelectedItem().toString() + "k -write_id3v2 1";
                                    container = ".ac3";
                                    stereoOutput = true;
                                    break;
                                }
                                case "AIFF": {
                                    audioCodec = comboFilter.getSelectedItem().toString().contains("Float") ? "pcm_f" + comboFilter.getSelectedItem().toString().replace(" Float", "") + "be" + noVideo + " -write_id3v2 1" : "pcm_s" + comboFilter.getSelectedItem().toString().replace(" Bits", "") + "be" + noVideo + " -write_id3v2 1";
                                    stereoOutput = true;
                                    container = ".aif";
                                    break;
                                }
                                case "FLAC": {
                                    audioCodec = "flac -compression_level " + comboFilter.getSelectedItem().toString() + noVideo + " -write_id3v2 1";
                                    container = ".flac";
                                    stereoOutput = true;
                                    break;
                                }
                                case "ALAC": {
                                    audioCodec = "alac -sample_fmt s" + comboFilter.getSelectedItem().toString().replace(" Bits", "").replace("24", "32") + "p -vn -write_id3v2 1";
                                    container = ".m4a";
                                    stereoOutput = true;
                                    break;
                                }
                                case "Vorbis": {
                                    audioCodec = "libvorbis -b:a " + comboFilter.getSelectedItem().toString() + "k" + noVideo + " -write_id3v2 1";
                                    container = ".oga";
                                    stereoOutput = true;
                                    break;
                                }
                                case "Dolby Digital Plus": {
                                    audioCodec = "eac3 -b:a " + comboFilter.getSelectedItem().toString() + "k" + noVideo + " -write_id3v2 1";
                                    container = ".eac3";
                                    stereoOutput = true;
                                    break;
                                }
                                case "Dolby TrueHD": {
                                    audioCodec = "truehd -strict -2";
                                    container = ".thd";
                                    stereoOutput = true;
                                    break;
                                }
                                case "Opus": {
                                    audioCodec = "libopus -b:a " + comboFilter.getSelectedItem().toString() + "k" + noVideo + " -write_id3v2 1";
                                    if (FFPROBE.surround && FFPROBE.channelLayout != "") {
                                        audioCodec = (String)audioCodec + " -channel_layout " + FFPROBE.channelLayout;
                                    }
                                    container = ".opus";
                                    stereoOutput = false;
                                    break;
                                }
                                case "MP3": {
                                    audioCodec = "libmp3lame -b:a " + comboFilter.getSelectedItem().toString() + "k" + noVideo + " -write_id3v2 1";
                                    container = ".mp3";
                                    stereoOutput = true;
                                    break;
                                }
                                case "WAV": {
                                    audioCodec = comboFilter.getSelectedItem().toString().contains("Float") ? "pcm_f" + comboFilter.getSelectedItem().toString().replace(" Float", "") + "le" + noVideo + " -write_bext 1 -write_id3v2 1" : "pcm_s" + comboFilter.getSelectedItem().toString().replace(" Bits", "") + "le" + noVideo + " -write_bext 1 -write_id3v2 1";
                                    container = ".wav";
                                    stereoOutput = true;
                                }
                            }
                            if (VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("splitMode"))) {
                                container = "_%03d" + (String)container;
                            }
                            if ((fileOut = new File(fileOutputName = labelOutput.replace("\\", "/") + "/" + fileName.replace(extension, extensionName + (String)container))).exists() && (fileOut = FunctionUtils.fileReplacement(labelOutput, fileName, extension, extensionName + "_", (String)container)) == null) {
                                cancelled = true;
                                break;
                            }
                            String concat = FunctionUtils.setConcat(file, labelOutput);
                            if (Settings.btnSetBab.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode"))) {
                                file = new File(labelOutput.replace("\\", "/") + "/" + fileName.replace(extension, ".txt"));
                            }
                            String audio = AudioEncoders.setAudio((String)audioCodec, stereoOutput, file);
                            if (caseNormalizeAudio.isSelected() && caseNormalizeAudio.isVisible()) {
                                if (cancelled) break;
                                lblCurrentEncoding.setText(file.getName());
                            }
                            if (caseSplitAudio.isSelected()) {
                                if (FFPROBE.surround) {
                                    if (lblSplit.getText().equals(language.getProperty("mono"))) {
                                        cmd = " -filter_complex \"channelsplit=channel_layout=5.1[FL][FR][FC][LFE][BL][BR]\" -y ";
                                        FFMPEG.run(InputAndOutput.inPoint + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + (String)cmd + " -map \"[FL]\" \"" + fileOut.toString().replace((CharSequence)container, "_FL" + (String)container) + "\" -map \"[FR]\" \"" + fileOut.toString().replace((CharSequence)container, "_FR" + (String)container) + "\" -map \"[FC]\" \"" + fileOut.toString().replace((CharSequence)container, "_FC" + (String)container) + "\" -map \"[LFE]\" \"" + fileOut.toString().replace((CharSequence)container, "_LFE" + (String)container) + "\" -map \"[BL]\" \"" + fileOut.toString().replace((CharSequence)container, "_BL" + (String)container) + "\" -map \"[BR]\" \"" + fileOut.toString().replace((CharSequence)container, "_BR" + (String)container) + "\"");
                                    } else if (lblSplit.getText().equals(language.getProperty("stereo"))) {
                                        cmd = " -af \"pan=stereo|c0=FL|c1=FR\" -y ";
                                        FFMPEG.run(InputAndOutput.inPoint + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + (String)cmd + "\"" + String.valueOf(fileOut) + "\"");
                                    }
                                } else {
                                    AudioEncoders.splitAudio((String)audioCodec, fileName, extension, file, labelOutput, (String)container, DRC);
                                }
                            } else if (caseMixAudio.isSelected() && lblMix.getText().equals("2.1")) {
                                cmd = " " + audio + "-y ";
                                FFMPEG.run(InputAndOutput.inPoint + concat + DRC + " -i \"" + (String)liste.getElementAt(0) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)liste.getElementAt(1) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)liste.getElementAt(2) + "\"" + InputAndOutput.outPoint + (String)cmd + "\"" + String.valueOf(fileOut) + "\"");
                            } else if (caseMixAudio.isSelected() && lblMix.getText().equals("5.1")) {
                                cmd = " " + audio + "-y ";
                                FFMPEG.run(InputAndOutput.inPoint + concat + DRC + " -i \"" + (String)liste.getElementAt(0) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)liste.getElementAt(1) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)liste.getElementAt(2) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)liste.getElementAt(3) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)liste.getElementAt(4) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)liste.getElementAt(5) + "\"" + InputAndOutput.outPoint + (String)cmd + "\"" + String.valueOf(fileOut) + "\"");
                            } else {
                                cmd = " " + audio + "-y ";
                                FFMPEG.run(InputAndOutput.inPoint + concat + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + (String)cmd + "\"" + String.valueOf(fileOut) + "\"");
                            }
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.runProcess.isAlive());
                            if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && caseMixAudio.isSelected() && !FFPROBE.surround || (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && !caseSplitAudio.isSelected() || !FFMPEG.saveCode && Settings.btnSetBab.isSelected() || !FFMPEG.saveCode && VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode"))) && AudioEncoders.lastActions(file, fileName, fileOut, labelOutput)) {
                                break;
                            }
                        }
                        catch (InterruptedException e) {
                            FFMPEG.error = true;
                        }
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    AudioEncoders.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    private static String setAudio(String codec, boolean stereoOutput, File file) {
        Object audio = "";
        Object audioFiltering = "";
        if (Transitions.setAudioFadeIn(false) != "") {
            audioFiltering = (String)audioFiltering + "," + Transitions.setAudioFadeIn(false);
        }
        if (Transitions.setAudioFadeOut(false) != "") {
            audioFiltering = (String)audioFiltering + "," + Transitions.setAudioFadeOut(false);
        }
        if (Transitions.setAudioSpeed() != "") {
            audioFiltering = (String)audioFiltering + "," + Transitions.setAudioSpeed();
        }
        if (caseNormalizeAudio.isSelected() && caseNormalizeAudio.isVisible()) {
            AudioNormalization.main(file);
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (AudioNormalization.thread.isAlive());
            lblCurrentEncoding.setText(file.getName());
            audioFiltering = (String)audioFiltering + ",volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB";
        }
        if (caseMixAudio.isSelected() && lblMix.getText().equals(language.getProperty("stereo")) && FFPROBE.surround) {
            audio = (String)audio + "-af \"pan=stereo|FL=FC+0.30*FL+0.30*BL|FR=FC+0.30*FR+0.30*BR\" ";
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals(language.getProperty("stereo"))) {
            int n = 1;
            while (n < liste.size()) {
                audio = (String)audio + "-i \"" + (String)liste.elementAt(n) + "\" ";
                ++n;
            }
            if (FFPROBE.stereo) {
                audio = (String)audio + "-filter_complex amerge=inputs=" + liste.size() + (String)audioFiltering + " -ac 2 ";
            } else {
                audio = (String)audio + "-filter_complex \"";
                Object left = "";
                int cl = 0;
                Object right = "";
                int cr = 0;
                int n2 = 0;
                while (n2 < liste.size()) {
                    if (n2 % 2 == 0) {
                        left = (String)left + "[" + n2 + ":0]";
                        ++cl;
                    } else {
                        right = (String)right + "[" + n2 + ":0]";
                        ++cr;
                    }
                    ++n2;
                }
                audio = (String)audio + (String)left + "amerge=inputs=" + cl + ",channelmap=map=FL[left];" + (String)right + "amerge=inputs=" + cr + ",channelmap=map=FR[right];";
                audio = (String)audio + "[left][right]amerge=inputs=2" + (String)audioFiltering + "[out]\" -map \"[out]\" -ac 2 ";
            }
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals("2.1")) {
            audio = "-filter_complex \"[0:a][1:a][2:a]join=inputs=3:channel_layout=2.1" + (String)audioFiltering + "[a]\" -map \"[a]\" ";
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals("5.1")) {
            audio = "-filter_complex \"[0:a][1:a][2:a][3:a][4:a][5:a]join=inputs=6:channel_layout=5.1" + (String)audioFiltering + "[a]\" -map \"[a]\" ";
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals(language.getProperty("mono"))) {
            int n = 1;
            while (n < liste.size()) {
                audio = (String)audio + "-i \"" + (String)liste.elementAt(n) + "\" ";
                ++n;
            }
            audio = (String)audio + "-filter_complex amerge=inputs=" + liste.size() + (String)audioFiltering + " -ac 1 ";
        } else if (FFPROBE.stereo) {
            if (audioFiltering != "") {
                audio = ((String)audioFiltering).replaceFirst(",", " -filter_complex ") + " ";
            }
        } else if (FFPROBE.channels > 1) {
            audio = stereoOutput ? "-filter_complex \"[0:a:0][0:a:1]amerge=inputs=2" + (String)audioFiltering + "[a]\" -map \"[a]\" " : ((String)audioFiltering).replaceFirst(",", " -filter_complex ") + " -map a? ";
        } else if (audioFiltering != "") {
            audio = (String)audio + ((String)audioFiltering).replaceFirst(",", " -filter_complex ") + " ";
        }
        audio = (String)audio + "-c:a " + codec + " ";
        if (caseSampleRate.isSelected()) {
            audio = (String)audio + "-ar " + lbl48k.getSelectedItem().toString() + " ";
        }
        return audio;
    }

    private static void splitAudio(String codec, String fileName, String extension, File file, String output, String container, String DRC) throws InterruptedException {
        Object audioFilter = "";
        if (Transitions.setAudioFadeIn(false) != "") {
            audioFilter = (String)audioFilter + "," + Transitions.setAudioFadeIn(false);
        }
        if (Transitions.setAudioFadeOut(false) != "") {
            audioFilter = (String)audioFilter + "," + Transitions.setAudioFadeOut(false);
        }
        if (Transitions.setAudioSpeed() != "") {
            audioFilter = (String)audioFilter + "," + Transitions.setAudioSpeed();
        }
        Object sampleRate = "";
        if (caseSampleRate.isSelected()) {
            sampleRate = " -ar " + lbl48k.getSelectedItem().toString();
        }
        if (FFPROBE.channels == 1 && lblSplit.getText().equals(language.getProperty("mono"))) {
            int i = 1;
            while (i < 3) {
                String yesno = " -y ";
                File fileOut = new File(output + "/" + fileName.replace(extension, "_Audio_" + i + container));
                if (fileOut.exists() && (fileOut = FunctionUtils.fileReplacement(output, fileName, extension, "_Audio_" + i + "_", container)) == null) {
                    yesno = " -n ";
                }
                String cmd = " -filter_complex \"[a:0]pan=1c|c0=c" + (i - 1) + (String)audioFilter + "[a" + (i - 1) + "]\" -map \"[a" + (i - 1) + "]\" -c:a " + codec + (String)sampleRate + yesno;
                FFMPEG.run(InputAndOutput.inPoint + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd + "\"" + String.valueOf(fileOut) + "\"");
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AudioEncoders.lastActions(file, fileName, fileOut, output)) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (FFPROBE.channels == 1 && lblSplit.getText().equals(Shutter.language.getProperty("stereo"))) {
            JOptionPane.showMessageDialog(Shutter.frame, Shutter.language.getProperty("theFile") + " " + fileName + " " + Shutter.language.getProperty("isAlreadyStereo"), Shutter.language.getProperty("cantSplitAudio"), 0);
        } else if (FFPROBE.channels > 1 && lblSplit.getText().equals(language.getProperty("mono"))) {
            int i = 1;
            while (i < FFPROBE.channels + 1) {
                String yesno = " -y ";
                File fileOut = new File(output + "/" + fileName.replace(extension, "_Audio_" + i + container));
                if (fileOut.exists() && (fileOut = FunctionUtils.fileReplacement(output, fileName, extension, "_Audio_" + i + "_", container)) == null) {
                    yesno = " -n ";
                }
                if (audioFilter != "") {
                    audioFilter = ((String)audioFilter).replaceFirst(",", " -filter_complex ");
                }
                String cmd = (String)audioFilter + " -map a:" + (i - 1) + " -c:a " + codec + (String)sampleRate + yesno;
                FFMPEG.run(InputAndOutput.inPoint + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd + "\"" + String.valueOf(fileOut) + "\"");
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AudioEncoders.lastActions(file, fileName, fileOut, output)) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (FFPROBE.channels > 1 && lblSplit.getText().equals(Shutter.language.getProperty("stereo"))) {
            int number = 1;
            int i = 1;
            while (i < FFPROBE.channels + 1) {
                String yesno = " -y ";
                File fileOut = new File(output + "/" + fileName.replace(extension, "_Audio_" + number + container));
                if (fileOut.exists() && (fileOut = FunctionUtils.fileReplacement(output, fileName, extension, "_Audio_" + number + "_", container)) == null) {
                    yesno = " -n ";
                }
                String cmd = " -filter_complex \"[0:a:" + (i - 1) + "][0:a:" + i + "]amerge=inputs=2" + (String)audioFilter + "[a]\" -map \"[a]\" -c:a " + codec + (String)sampleRate + yesno;
                FFMPEG.run(InputAndOutput.inPoint + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd + "\"" + String.valueOf(fileOut) + "\"");
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AudioEncoders.lastActions(file, fileName, fileOut, output)) {
                    ++number;
                    i += 2;
                    continue;
                }
                break;
            }
        } else {
            FFMPEG.errorList.append(fileName);
            FFMPEG.errorList.append(System.lineSeparator());
        }
    }

    private static boolean lastActions(File file, String fileName, File fileOut, String output) {
        if (FunctionUtils.cleanFunction(fileName, fileOut, output)) {
            return true;
        }
        FunctionUtils.addFileForMail(fileName);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Settings.btnSetBab.isSelected()) {
            return true;
        }
        if (caseMixAudio.isSelected() && !FFPROBE.surround) {
            return true;
        }
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            AudioEncoders.main();
            return true;
        }
        return false;
    }
}

