/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Ftp;
import application.Shutter;
import application.Utils;
import java.io.File;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;

public class AudioNormalization
extends Shutter {
    public static Thread thread;
    private static int audioTracks;

    public static void main(final File input) {
        thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int i = 0;
                while (i < liste.getSize()) {
                    File file = FunctionUtils.setInputFile(new File((String)liste.getElementAt(i)));
                    if (!language.getProperty("functionNormalization").equals(comboFonctions.getSelectedItem().toString())) {
                        file = input;
                    }
                    if (file == null) break;
                    try {
                        String fileName = file.getName();
                        String extension = fileName.substring(fileName.lastIndexOf("."));
                        lblCurrentEncoding.setText(Shutter.language.getProperty("analyzing") + " " + fileName);
                        if (FunctionUtils.analyze(file, false)) {
                            String cmd;
                            String filterComplex = AudioNormalization.setFilterComplex();
                            String labelOutput = FunctionUtils.setOutputDestination("", file);
                            String extensionName = "";
                            if (btnExtension.isSelected()) {
                                extensionName = FunctionUtils.setSuffix(txtExtension.getText(), false);
                            }
                            String fileOutputName = labelOutput.replace("\\", "/") + "/" + fileName.replace(extension, extensionName + extension);
                            String audio = AudioNormalization.setAudio(extension);
                            File fileOut = new File(fileOutputName);
                            if (fileOut.exists() && (fileOut = FunctionUtils.fileReplacement(labelOutput, fileName, extension, extensionName + "_", extension)) == null) {
                                cancelled = true;
                                break;
                            }
                            if (!caseTruePeak.isSelected() && !caseLRA.isSelected()) {
                                cmd = System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux") ? " -vn" + filterComplex + " -f null -" : " -vn" + filterComplex + " -f null -\"";
                                FFMPEG.run(" -i \"" + file.toString() + "\"" + cmd);
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive());
                            }
                            if (!language.getProperty("functionNormalization").equals(comboFonctions.getSelectedItem().toString())) break;
                            lblCurrentEncoding.setText(fileName);
                            if (!cancelled) {
                                String normalization = "volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB";
                                if (caseTruePeak.isSelected() && caseLRA.isSelected()) {
                                    normalization = "loudnorm=i=" + comboFilter.getSelectedItem().toString().replace(" LUFS", "") + ":tp=" + comboTruePeak.getSelectedItem().toString().replace(" dBFS", "") + ":lra=" + comboLRA.getSelectedItem().toString().replace(" LU", "");
                                } else if (caseTruePeak.isSelected()) {
                                    normalization = "loudnorm=i=" + comboFilter.getSelectedItem().toString().replace(" LUFS", "") + ":tp=" + comboTruePeak.getSelectedItem().toString().replace(" dBFS", "");
                                } else if (caseLRA.isSelected()) {
                                    normalization = "loudnorm=i=" + comboFilter.getSelectedItem().toString().replace(" LUFS", "") + ":lra=" + comboLRA.getSelectedItem().toString().replace(" LU", "");
                                }
                                cmd = FFPROBE.stereo ? " -af " + normalization + " -c:v copy -c:s copy" + audio + " -y " : (FFPROBE.channels > 1 ? (FFPROBE.channels >= 4 ? (audioTracks == 0 ? " -filter_complex \"[0:a:0]" + normalization + "[a1];[0:a:1]" + normalization + "[a2]\" -c:v copy -c:s copy" + audio.replace("-map a?", "-map [a1] -map [a2] -map 0:a:2? -map 0:a:3? -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7?") + " -y " : " -filter_complex \"[0:a:2]" + normalization + "[a3];[0:a:3]" + normalization + "[a4]\" -c:v copy -c:s copy" + audio.replace("-map a?", "-map 0:a:0 -map 0:a:1 -map [a3] -map [a4] -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7?") + " -y ") : " -filter_complex \"[0:a:0]" + normalization + "[a1];[0:a:1]" + normalization + "[a2]\" -c:v copy -c:s copy" + audio.replace("-map a?", "-map [a1] -map [a2] -map 0:a:2? -map 0:a:3? -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7?") + " -y ") : " -af " + normalization + " -c:v copy -c:s copy" + audio + " -y ");
                                FFMPEG.run(" -i \"" + file.toString() + "\"" + cmd + "\"" + String.valueOf(fileOut) + "\"");
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive());
                                if (FFMPEG.error) {
                                    String AACencoder = "aac";
                                    if (System.getProperty("os.name").contains("Mac")) {
                                        AACencoder = "aac_at";
                                    }
                                    cmd = FFPROBE.stereo ? " -af " + normalization + " -c:v copy -c:s copy -c:a " + AACencoder + " -ar " + lbl48k.getSelectedItem().toString() + " -b:a 320k -map v:0? -map a? -map s? -y " : (FFPROBE.channels > 1 ? (FFPROBE.channels >= 4 ? (audioTracks == 0 ? " -filter_complex \"[0:a:0]" + normalization + "[a1];[0:a:1]" + normalization + "[a2]\" -c:v copy -c:s copy -c:a " + AACencoder + " -ar " + lbl48k.getSelectedItem().toString() + " -b:a 320k -map v:0? -map [a1] -map [a2] -map 0:a:2? -map 0:a:3? -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7? -map s? -y " : " -filter_complex \"[0:a:2]" + normalization + "[a3];[0:a:3]" + normalization + "[a4]\" -c:v copy -c:s copy -c:a " + AACencoder + " -ar " + lbl48k.getSelectedItem().toString() + " -b:a 320k -map v:0? -map 0:a:0 -map 0:a:1 -map [a3] -map [a4] -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7? -map s? -y ") : " -filter_complex \"[0:a:0]" + normalization + "[a1];[0:a:1]" + normalization + "[a2]\" -c:v copy -c:s copy -c:a " + AACencoder + " -ar " + lbl48k.getSelectedItem().toString() + " -b:a 320k -map v:0? -map [a1] -map [a2] -map 0:a:2? -map 0:a:3? -map 0:a:4? -map 0:a:5? -map 0:a:6? -map 0:a:7? -map s? -y ") : " -af " + normalization + " -c:v copy -c:s copy -c:a " + AACencoder + " -ar " + lbl48k.getSelectedItem().toString() + " -b:a 320k -map v:0? -map a? -map s? -y ");
                                    FFMPEG.run(" -i \"" + file.toString() + "\"" + cmd + "\"" + String.valueOf(fileOut) + "\"");
                                }
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive());
                            }
                            if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && AudioNormalization.lastActions(file, fileName, fileOut, labelOutput)) {
                                break;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && language.getProperty("functionNormalization").equals(comboFonctions.getSelectedItem().toString())) {
                    AudioNormalization.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    private static String setFilterComplex() {
        if (FFPROBE.stereo) {
            return " -af ebur128=peak=true";
        }
        if (FFPROBE.channels > 1) {
            if (FFPROBE.channels >= 4) {
                Object[] options = new String[]{"A1 & A2", "A3 & A4"};
                audioTracks = JOptionPane.showOptionDialog(frame, language.getProperty("ChooseMultitrack"), language.getProperty("multitrack"), -1, 1, null, options, options[0]);
                if (audioTracks == 0) {
                    return " -filter_complex \"[0:a:0][0:a:1]amerge=inputs=2[a];[a]ebur128=peak=true\"";
                }
                return " -filter_complex \"[0:a:2][0:a:3]amerge=inputs=2[a];[a]ebur128=peak=true\"";
            }
            return " -filter_complex \"[0:a:0][0:a:1]amerge=inputs=2[a];[a]ebur128=peak=true\"";
        }
        return " -af ebur128=peak=true";
    }

    private static String setAudio(String ext) {
        block42: {
            block41: {
                if (!caseChangeAudioCodec.isSelected()) break block41;
                if (comboAudioCodec.getSelectedItem().toString().contains("PCM")) {
                    switch (comboAudioCodec.getSelectedIndex()) {
                        case 0: {
                            return " -c:a pcm_f32le -ar " + lbl48k.getSelectedItem().toString() + " -b:a 1536k -map v:0? -map a? -map s?";
                        }
                        case 1: {
                            return " -c:a pcm_s32le -ar " + lbl48k.getSelectedItem().toString() + " -b:a 1536k -map v:0? -map a? -map s?";
                        }
                        case 2: {
                            return " -c:a pcm_s24le -ar " + lbl48k.getSelectedItem().toString() + " -b:a 1536k -map v:0? -map a? -map s?";
                        }
                        case 3: {
                            return " -c:a pcm_s16le -ar " + lbl48k.getSelectedItem().toString() + " -b:a 1536k -map v:0? -map a? -map s?";
                        }
                    }
                } else {
                    if (comboAudioCodec.getSelectedItem().toString().equals("AAC")) {
                        if (System.getProperty("os.name").contains("Mac")) {
                            return " -c:a aac_at -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k -map v:0? -map a? -map s?";
                        }
                        return " -c:a aac -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k -map v:0? -map a? -map s?";
                    }
                    if (comboAudioCodec.getSelectedItem().toString().equals("MP3")) {
                        return " -c:a libmp3lame -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k -map v:0? -map a? -map s?";
                    }
                    if (comboAudioCodec.getSelectedItem().toString().equals("AC3")) {
                        return " -c:a ac3 -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k -map v:0? -map a? -map s?";
                    }
                    if (comboAudioCodec.getSelectedItem().toString().equals("Opus")) {
                        return " -c:a libopus -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                    }
                    if (comboAudioCodec.getSelectedItem().toString().equals("Vorbis")) {
                        return " -c:a libvorbis -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                    }
                    if (comboAudioCodec.getSelectedItem().toString().equals("Dolby Digital Plus")) {
                        return " -c:a eac3 -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                    }
                }
                break block42;
            }
            switch (ext.toLowerCase()) {
                case ".mp4": {
                    if (System.getProperty("os.name").contains("Mac")) {
                        return " -c:a aac_at -ar " + lbl48k.getSelectedItem().toString() + " -b:a 256k -map v:0? -map a? -map s?";
                    }
                    return " -c:a aac -ar " + lbl48k.getSelectedItem().toString() + " -b:a 256k -map v:0? -map a? -map s?";
                }
                case ".mp3": {
                    return " -c:a mp3 -ar " + lbl48k.getSelectedItem().toString() + " -b:a 256k -map v:0? -map a? -map s?";
                }
                case ".wmv": {
                    return " -c:a wmav2 -ar " + lbl48k.getSelectedItem().toString() + " -b:a 256k -map v:0? -map a? -map s?";
                }
                case ".mpg": {
                    return " -c:a mp2 -ar " + lbl48k.getSelectedItem().toString() + " -b:a 256k -map v:0? -map a? -map s?";
                }
                case ".av1": 
                case ".ogv": 
                case ".webm": {
                    return " -c:a libopus -ar " + lbl48k.getSelectedItem().toString() + " -b:a 192k -map v:0? -map a? -map s?";
                }
            }
        }
        if (FFPROBE.qantization == 24) {
            return " -c:a pcm_s24le -ar " + FFPROBE.audioSampleRate + " -map v:0? -map a? -map s?";
        }
        if (FFPROBE.qantization == 32) {
            return " -c:a pcm_s32le -ar " + FFPROBE.audioSampleRate + " -map v:0? -map a? -map s?";
        }
        return " -c:a pcm_s16le -ar " + FFPROBE.audioSampleRate + " -map v:0? -map a? -map s?";
    }

    private static boolean lastActions(File file, String fileName, File fileOut, String output) {
        if (FunctionUtils.cleanFunction(fileName, fileOut, output)) {
            return true;
        }
        FunctionUtils.addFileForMail(fileName);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            AudioNormalization.main(new File(""));
            return true;
        }
        return false;
    }
}

