/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Ftp;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import java.io.File;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;

public class Extract
extends Shutter {
    private static int subStream = 0;
    private static int audioStream = 0;
    private static boolean extractComplete = false;

    public static void main() {
        extractComplete = false;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                audioStream = 0;
                subStream = 0;
                int i = 0;
                while (i < liste.getSize()) {
                    File file = FunctionUtils.setInputFile(new File((String)liste.getElementAt(i)));
                    if (file == null) break;
                    try {
                        if (FunctionUtils.analyze(file, false)) {
                            String fileName = file.getName();
                            String extension = fileName.substring(fileName.lastIndexOf("."));
                            lblCurrentEncoding.setText(fileName);
                            String mapping = Extract.setMapping();
                            String labelOutput = FunctionUtils.setOutputDestination("", file);
                            Object extensionName = "";
                            if (comboFilter.getSelectedItem().toString().equals(language.getProperty("video"))) {
                                extensionName = "_" + Shutter.language.getProperty("video");
                                if (btnExtension.isSelected()) {
                                    extensionName = FunctionUtils.setSuffix(txtExtension.getText(), false);
                                }
                            } else if (comboFilter.getSelectedItem().toString().equals(language.getProperty("audio"))) {
                                extensionName = "_" + Shutter.language.getProperty("audio") + "_" + (audioStream + 1);
                                if (btnExtension.isSelected()) {
                                    extensionName = FunctionUtils.setSuffix(txtExtension.getText(), false) + "_" + (audioStream + 1);
                                }
                            } else if (comboFilter.getSelectedItem().toString().equals(language.getProperty("subtitles"))) {
                                extensionName = "_" + Shutter.language.getProperty("subtitles") + "_" + (subStream + 1);
                                if (btnExtension.isSelected()) {
                                    extensionName = FunctionUtils.setSuffix(txtExtension.getText(), false) + "_" + (subStream + 1);
                                }
                            }
                            String container = extension;
                            if (comboFilter.getSelectedItem().toString().equals(language.getProperty("audio"))) {
                                FFPROBE.audioCodec = FFPROBE.audioCodecs[audioStream];
                                if (FFPROBE.audioCodec.contains("pcm")) {
                                    container = ".wav";
                                } else if (FFPROBE.audioCodec.contains("aac")) {
                                    container = ".m4a";
                                } else if (FFPROBE.audioCodec.contains("ac3")) {
                                    container = ".ac3";
                                } else if (FFPROBE.audioCodec.contains("opus")) {
                                    container = ".opus";
                                } else if (FFPROBE.audioCodec.contains("vorbis")) {
                                    container = ".oga";
                                } else if (FFPROBE.audioCodec.contains("eac3")) {
                                    container = ".eac3";
                                } else if (FFPROBE.audioCodec.contains("wma")) {
                                    container = ".wma";
                                } else if (FFPROBE.audioCodec.contains("mp3")) {
                                    container = ".mp3";
                                } else if (FFPROBE.audioCodec.contains("mp2")) {
                                    container = ".mp2";
                                }
                            } else if (comboFilter.getSelectedItem().toString().equals(language.getProperty("subtitles"))) {
                                container = ".srt";
                            }
                            String fileOutputName = labelOutput.replace("\\", "/") + "/" + fileName.replace(extension, (String)extensionName + container);
                            File fileOut = new File(fileOutputName);
                            if (fileOut.exists() && (fileOut = FunctionUtils.fileReplacement(labelOutput, fileName, extension, (String)extensionName + "_", container)) == null) {
                                cancelled = true;
                                break;
                            }
                            String cmd = mapping + " -y ";
                            FFMPEG.run(" -i \"" + file.toString() + "\"" + cmd + "\"" + String.valueOf(fileOut) + "\"");
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.runProcess.isAlive());
                            if ((!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || FFMPEG.saveCode && VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode"))) && Extract.lastActions(file, fileName, fileOut, labelOutput)) break;
                            if (comboFilter.getSelectedItem().toString().equals(language.getProperty("audio"))) {
                                if (audioStream < FFPROBE.audioStreams - 1) {
                                    ++audioStream;
                                    --i;
                                } else {
                                    audioStream = 0;
                                }
                            }
                            if (comboFilter.getSelectedItem().toString().equals(language.getProperty("subtitles"))) {
                                if (subStream < FFPROBE.subtitleStreams - 1) {
                                    ++subStream;
                                    --i;
                                } else {
                                    subStream = 0;
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    Extract.enfOfFunction();
                }
                extractComplete = true;
            }
        });
        thread.start();
    }

    public static void extractAll() {
        Thread wait = new Thread(new Runnable(){

            @Override
            public void run() {
                comboFilter.setSelectedItem(language.getProperty("video"));
                Extract.main();
                if (!cancelled && !FFMPEG.error) {
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!cancelled && !FFMPEG.error && !extractComplete);
                }
                if (FFPROBE.audioStreams > 0 && !cancelled && !FFMPEG.error) {
                    comboFilter.setSelectedItem(language.getProperty("audio"));
                    Extract.main();
                    if (!cancelled && !FFMPEG.error) {
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (!cancelled && !FFMPEG.error && !extractComplete);
                    }
                }
                if (FFPROBE.subtitleStreams > 0 && !cancelled && !FFMPEG.error) {
                    comboFilter.setSelectedItem(language.getProperty("subtitles"));
                    Extract.main();
                    if (!cancelled && !FFMPEG.error) {
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (!cancelled && !FFMPEG.error && !extractComplete);
                    }
                }
                comboFilter.setSelectedItem(language.getProperty("setAll"));
            }
        });
        wait.start();
    }

    private static String setMapping() {
        if (comboFilter.getSelectedItem().toString().equals(language.getProperty("video"))) {
            return " -an -sn -c:v copy -map v:0?";
        }
        if (comboFilter.getSelectedItem().toString().equals(language.getProperty("audio"))) {
            return " -vn -sn -c:a copy -map a:" + audioStream + "?";
        }
        if (comboFilter.getSelectedItem().toString().equals(language.getProperty("subtitles"))) {
            return " -vn -an -map s:" + subStream + "?";
        }
        return " -c copy -map v:0? -map a? -map s?";
    }

    private static boolean lastActions(File file, String fileName, File fileOut, String output) {
        if (FunctionUtils.cleanFunction(fileName, fileOut, output)) {
            return true;
        }
        FunctionUtils.addFileForMail(fileName);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            Extract.main();
            return true;
        }
        return false;
    }
}

