/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Shutter;
import application.VideoPlayer;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JOptionPane;
import library.FFMPEG;
import settings.FunctionUtils;
import settings.InputAndOutput;

public class OfflineDetection
extends Shutter {
    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int i = 0;
                while (i < liste.getSize()) {
                    File file = FunctionUtils.setInputFile(new File((String)liste.getElementAt(i)));
                    if (file == null) break;
                    try {
                        String fileName = file.getName();
                        lblCurrentEncoding.setText(fileName);
                        if (FunctionUtils.analyze(file, false)) {
                            VideoPlayer.getFileList(file.toString());
                            InputAndOutput.getInputAndOutput();
                            Object stats_file = System.getProperty("os.name").contains("Windows") ? "stats_file" : Shutter.dirTemp + "stats_file";
                            String cmd = " -i \"" + Shutter.dirTemp + "offline.png\" -lavfi \"[0:v]scale=1920x1080[source];[1:v]scale=1920x1080[reference];[source][reference]psnr=" + (String)stats_file + "\" -an -f null -";
                            if (System.getProperty("os.name").contains("Windows")) {
                                cmd = cmd + "\"";
                            }
                            FFMPEG.run(InputAndOutput.inPoint + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd);
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.runProcess.isAlive());
                            if (!cancelled) {
                                OfflineDetection.showDetection(fileName);
                            }
                            if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && OfflineDetection.lastActions(file, fileName)) {
                                break;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    OfflineDetection.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    private static void showDetection(String fileName) {
        if (FFMPEG.mediaOfflineFrame.length() > 0 && !Shutter.cancelled && !FFMPEG.error) {
            JOptionPane.showMessageDialog(frame, FFMPEG.mediaOfflineFrame, Shutter.language.getProperty("functionOfflineDetection"), 0);
            int q = JOptionPane.showConfirmDialog(Shutter.frame, Shutter.language.getProperty("saveResult"), Shutter.language.getProperty("analyzeEnded"), 0, -1);
            if (q == 0) {
                FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("saveResult"), 1);
                dialog.setDirectory(System.getProperty("user.home") + "/Desktop");
                dialog.setVisible(true);
                if (dialog.getFile() != null) {
                    try {
                        PrintWriter writer = new PrintWriter(dialog.getDirectory() + dialog.getFile().replace(".txt", "") + ".txt", "UTF-8");
                        writer.println(Shutter.language.getProperty("analyzeOf") + " " + fileName);
                        writer.println("");
                        writer.println(FFMPEG.mediaOfflineFrame);
                        writer.close();
                    }
                    catch (FileNotFoundException | UnsupportedEncodingException iOException) {}
                }
            } else {
                cancelled = false;
            }
        } else {
            JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("noErrorDetected"), Shutter.language.getProperty("functionOfflineDetection"), 1);
        }
    }

    private static boolean lastActions(File file, String fileName) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fileName);
            FFMPEG.errorList.append(System.lineSeparator());
        }
        if (cancelled) {
            return true;
        }
        if (!FFMPEG.error) {
            ++FunctionUtils.completed;
        }
        lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
        FunctionUtils.addFileForMail(fileName);
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            OfflineDetection.main();
            return true;
        }
        return false;
    }
}

