/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Ftp;
import application.RecordInputDevice;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.imageio.ImageIO;
import library.DCRAW;
import library.FFMPEG;
import library.FFPROBE;
import library.NCNN;
import library.PDF;
import settings.Colorimetry;
import settings.Corrections;
import settings.Filter;
import settings.FunctionUtils;
import settings.Image;
import settings.InputAndOutput;
import settings.Overlay;

public class Picture
extends Shutter {
    public static void main(final boolean encode, final boolean videoPlayerCapture) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int i = 0;
                while (i < liste.getSize()) {
                    block85: {
                        File file;
                        block87: {
                            if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) break block87;
                            boolean isSelected = false;
                            for (String input : Shutter.fileList.getSelectedValuesList()) {
                                if (!((String)liste.getElementAt(i)).equals(input)) continue;
                                isSelected = true;
                            }
                            if (!isSelected) break block85;
                        }
                        if ((file = FunctionUtils.setInputFile(new File((String)liste.getElementAt(i)))) == null) break;
                        if (videoPlayerCapture) {
                            FunctionUtils.yesToAll = false;
                            screenshotIsRunning = true;
                            file = new File(VideoPlayer.videoPath);
                        }
                        try {
                            String fileName = file.getName();
                            lblCurrentEncoding.setText(fileName);
                            String extension = fileName.substring(fileName.lastIndexOf("."));
                            boolean isRaw = false;
                            switch (extension.toLowerCase()) {
                                case ".3fr": 
                                case ".arw": 
                                case ".cr2": 
                                case ".cr3": 
                                case ".crw": 
                                case ".dng": 
                                case ".kdc": 
                                case ".mrw": 
                                case ".nef": 
                                case ".nrw": 
                                case ".orf": 
                                case ".pef": 
                                case ".r3d": 
                                case ".ptx": 
                                case ".raf": 
                                case ".rw2": 
                                case ".srw": 
                                case ".x3f": {
                                    isRaw = true;
                                }
                            }
                            if (!FunctionUtils.analyze(file, isRaw) || !Filter.dateFilter(file)) break block85;
                            Object filterComplex = Picture.setDeinterlace(extension, isRaw);
                            filterComplex = Picture.setFramerate((String)filterComplex);
                            FFMPEG.isGPUCompatible = false;
                            filterComplex = Colorimetry.setLUT((String)filterComplex);
                            filterComplex = Colorimetry.setLevels((String)filterComplex);
                            filterComplex = Colorimetry.setColormatrix((String)filterComplex);
                            filterComplex = Image.setRotate((String)filterComplex);
                            filterComplex = Colorimetry.setColor((String)filterComplex);
                            filterComplex = Corrections.setDeflicker((String)filterComplex);
                            filterComplex = Corrections.setDeband((String)filterComplex);
                            filterComplex = Corrections.setDetails((String)filterComplex);
                            filterComplex = Corrections.setDenoiser((String)filterComplex);
                            filterComplex = Corrections.setSmoothExposure((String)filterComplex);
                            filterComplex = Overlay.setOverlay((String)filterComplex, false);
                            String logo = Overlay.setLogo();
                            filterComplex = Overlay.setWatermark((String)filterComplex);
                            filterComplex = Overlay.showTimecode((String)filterComplex, fileName.replace(extension, ""), videoPlayerCapture);
                            filterComplex = Image.setCrop((String)filterComplex, file);
                            if (Shutter.sliderZoom.getValue() != 0) {
                                filterComplex = Colorimetry.setZoom((String)filterComplex, true);
                            }
                            if (!comboResolution.getSelectedItem().toString().contains("AI")) {
                                filterComplex = Image.setScale((String)filterComplex, false);
                                filterComplex = Image.setPad((String)filterComplex, false);
                            }
                            if (comboFilter.getSelectedItem().toString().equals(".gif")) {
                                if (filterComplex != "") {
                                    filterComplex = (String)filterComplex + ",";
                                }
                                filterComplex = (String)filterComplex + "split[a][b];[a]palettegen[p];[b][p]paletteuse";
                            }
                            filterComplex = FunctionUtils.setFilterComplex((String)filterComplex, "", true);
                            if (FFPROBE.totalLength > 40) {
                                VideoPlayer.getFileList(file.toString());
                                InputAndOutput.getInputAndOutput();
                                if (videoPlayerCapture && VideoPlayer.waveformContainer.isVisible()) {
                                    InputAndOutput.inPoint = " -ss " + (long)(VideoPlayer.playerCurrentFrame * VideoPlayer.inputFramerateMS) + "ms";
                                }
                            }
                            String flags = Picture.setFlags();
                            String colorspace = Colorimetry.setColorspace();
                            String inputCodec = Colorimetry.setInputCodec(extension);
                            String compression = Picture.setCompression();
                            String labelOutput = FunctionUtils.setOutputDestination("", file);
                            String extensionName = "";
                            if (btnExtension.isSelected()) {
                                extensionName = FunctionUtils.setSuffix(txtExtension.getText(), false);
                            }
                            String container = Picture.setExtension();
                            String singleFrame = Picture.setFrame();
                            String fileOutputName = labelOutput.replace("\\", "/") + "/" + fileName.replace(extension, extensionName + container);
                            File fileOut = new File(fileOutputName);
                            if (fileOut.exists() && (fileOut = FunctionUtils.fileReplacement(labelOutput, fileName, extension, "_", container)) == null) {
                                cancelled = true;
                                break;
                            }
                            Object cmd = (String)filterComplex + singleFrame + colorspace + compression + flags + " -an -y ";
                            if (extension.toLowerCase().equals(".pdf")) {
                                int page = 0;
                                while (page < PDF.pagesCount) {
                                    if (!cancelled) {
                                        Process process;
                                        Picture.disableAll();
                                        PDF.run(file, page);
                                        do {
                                            Thread.sleep(10L);
                                        } while (PDF.isRunning);
                                        int n = 1;
                                        do {
                                            fileOut = new File(labelOutput + "/" + fileName.replace(extension, "_" + n + container));
                                            ++n;
                                        } while (fileOut.exists());
                                        if (System.getProperty("os.name").contains("Windows")) {
                                            pbv = new ProcessBuilder("\"" + FFMPEG.PathToFFMPEG + "\" -v quiet -hide_banner -i pipe:0" + logo + (String)cmd + "\"" + String.valueOf(fileOut) + "\"");
                                            process = pbv.start();
                                        } else {
                                            pbv = new ProcessBuilder("/bin/bash", "-c", FFMPEG.PathToFFMPEG + " -v quiet -hide_banner -i pipe:0" + logo + (String)cmd + "\"" + String.valueOf(fileOut) + "\"");
                                            process = pbv.start();
                                        }
                                        if (VideoPlayer.preview != null) {
                                            OutputStream outputStream = process.getOutputStream();
                                            ImageIO.write((RenderedImage)VideoPlayer.preview, "bmp", outputStream);
                                            outputStream.close();
                                        }
                                        ++page;
                                        continue;
                                    }
                                    break;
                                }
                            } else if (isRaw) {
                                btnStart.setEnabled(false);
                                Picture.disableAll();
                                DCRAW.run(" -v -w -c -q 3 -o 1 -6 -g 2.4 12.92 \"" + file.toString() + "\" | PathToFFMPEG -i -" + logo + (String)cmd + "\"" + String.valueOf(fileOut) + "\"");
                            } else if (inputDeviceIsRunning) {
                                String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(Calendar.getInstance().getTime());
                                if ((((String)liste.getElementAt(0)).equals("Capture.current.screen") || System.getProperty("os.name").contains("Mac")) && RecordInputDevice.audioDeviceIndex > 0) {
                                    cmd = ((String)cmd).replace("1:v", "2:v").replace("-map v:0", "-map 1:v").replace("0:v", "1:v");
                                }
                                FFMPEG.run(" " + RecordInputDevice.setInputDevices() + logo + (String)cmd + "\"" + fileOut.toString().replace("Capture.current", timeStamp).replace("Capture.input", timeStamp) + "\"");
                                fileOut = new File(fileOut.toString().replace("Capture.current", timeStamp).replace("Capture.input", timeStamp));
                            } else if (comboResolution.getSelectedItem().toString().contains("AI")) {
                                File upscaleFolder = new File(lblDestination1.getText() + "/upscale");
                                if (upscaleFolder.exists()) {
                                    File[] fileArray = upscaleFolder.listFiles();
                                    int n = fileArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        File f = fileArray[n2];
                                        f.delete();
                                        ++n2;
                                    }
                                } else {
                                    upscaleFolder.mkdir();
                                }
                                String ext = fileOut.getName().substring(fileOut.getName().lastIndexOf("."));
                                fileOut = new File(String.valueOf(upscaleFolder) + "/" + fileOut.getName().replace(ext, ".png"));
                                FFMPEG.run(InputAndOutput.inPoint + inputCodec + " -i \"" + file.toString() + "\"" + logo + InputAndOutput.outPoint + (String)filterComplex + singleFrame + colorspace + " -an -y \"" + String.valueOf(fileOut) + "\"");
                                do {
                                    Thread.sleep(10L);
                                } while (FFMPEG.runProcess.isAlive());
                                if (NCNN.isRunning && NCNN.process != null) {
                                    NCNN.process.destroy();
                                    do {
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    } while (NCNN.isRunning);
                                    lblCurrentEncoding.setText(fileName);
                                }
                                Picture.upscale(fileOut, compression, flags);
                            } else {
                                FFMPEG.run(InputAndOutput.inPoint + inputCodec + " -i \"" + file.toString() + "\"" + logo + InputAndOutput.outPoint + (String)cmd + "\"" + String.valueOf(fileOut) + "\"");
                            }
                            if (isRaw) {
                                do {
                                    Thread.sleep(100L);
                                } while (DCRAW.runProcess.isAlive());
                                btnStart.setEnabled(true);
                            } else {
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive());
                            }
                            if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && (Picture.lastActions(file, fileName, extension, fileOut, labelOutput) || videoPlayerCapture)) {
                                break;
                            }
                        }
                        catch (Exception e) {
                            FFMPEG.error = true;
                        }
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && encode) {
                    Picture.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    private static String setFramerate(String filterComplex) {
        if (caseCreateSequence.isSelected()) {
            if (filterComplex != "") {
                filterComplex = (String)filterComplex + ",";
            }
            filterComplex = (String)filterComplex + "fps=" + Float.parseFloat(comboInterpret.getSelectedItem().toString().replace(",", "."));
        }
        return filterComplex;
    }

    private static String setDeinterlace(String extension, boolean isRaw) {
        if (isRaw || extension.toLowerCase().equals(".pdf")) {
            return "";
        }
        if (FFPROBE.interlaced.equals("1")) {
            return "yadif=0:" + FFPROBE.fieldOrder + ":0";
        }
        return "";
    }

    private static String setFlags() {
        return " -sws_flags " + Settings.comboScale.getSelectedItem().toString();
    }

    private static String setCompression() {
        if (comboFonctions.getSelectedItem().equals("JPEG")) {
            int q = Math.round(31.0f - (float)Integer.valueOf(comboFilter.getSelectedItem().toString().replace("%", "")).intValue() * 31.0f / 100.0f);
            return " -q:v " + q;
        }
        if (comboFilter.getSelectedItem().toString().equals(".png")) {
            return " -compression_level " + comboImageOption.getSelectedItem().toString().replace("%", "");
        }
        if (comboFilter.getSelectedItem().toString().equals(".webp")) {
            return " -quality " + comboImageOption.getSelectedItem().toString().replace("%", "");
        }
        if (comboFilter.getSelectedItem().toString().equals(".avif")) {
            String encoder = " -c:v libsvtav1";
            if (!comboAccel.getSelectedItem().equals(language.getProperty("aucune").toLowerCase())) {
                if (comboAccel.getSelectedItem().equals("Nvidia NVENC")) {
                    encoder = " -c:v av1_nvenc";
                } else if (comboAccel.getSelectedItem().equals("Intel Quick Sync")) {
                    encoder = " -c:v av1_qsv";
                } else if (comboAccel.getSelectedItem().equals("AMD AMF Encoder")) {
                    encoder = " -c:v av1_amf";
                } else if (comboAccel.getSelectedItem().equals("OSX VideoToolbox")) {
                    encoder = " -c:v av1_videotoolbox";
                }
            }
            return encoder + " -crf " + Math.round(63.0f - (float)Integer.valueOf(comboImageOption.getSelectedItem().toString().replace("%", "")).intValue() * 63.0f / 100.0f);
        }
        if (comboFilter.getSelectedItem().toString().equals(".tif")) {
            return " -compression_algo " + comboImageOption.getSelectedItem().toString();
        }
        return " -q:v 0";
    }

    private static String setExtension() {
        if (comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture"))) {
            if (caseCreateSequence.isSelected()) {
                return "_%06d" + comboFilter.getSelectedItem().toString();
            }
            return comboFilter.getSelectedItem().toString();
        }
        if (comboFonctions.getSelectedItem().equals("JPEG") && caseCreateSequence.isSelected()) {
            return "_%06d.jpg";
        }
        return ".jpg";
    }

    private static String setFrame() {
        if (caseCreateSequence.isSelected()) {
            return "";
        }
        if (comboFilter.getSelectedItem().toString().equals(".gif")) {
            return " -loop 0 -r " + comboImageOption.getSelectedItem().toString().replace(",", ".").replace(" " + Shutter.language.getProperty("fps"), "");
        }
        if (comboFilter.getSelectedItem().toString().equals(".apng")) {
            return " -r " + comboImageOption.getSelectedItem().toString().replace(" " + Shutter.language.getProperty("fps"), "").replace(",", ".");
        }
        if (comboFilter.getSelectedItem().toString().equals(".webp")) {
            return " -loop 0";
        }
        return " -frames:v 1";
    }

    private static void upscale(File fileOut, String compression, String flags) throws InterruptedException {
        progressBar1.setValue(0);
        progressBar1.setMaximum(fileOut.getParentFile().listFiles().length);
        String model = "realesr-general-wdn-x4v3";
        if (Shutter.comboResolution.getSelectedItem().toString().contains("animation")) {
            model = "realesrgan-x4plus-anime";
        }
        if (caseCreateSequence.isSelected()) {
            NCNN.run(" -v -i \"" + String.valueOf(fileOut.getParentFile()) + "\" -m \"" + NCNN.modelsPath + "\" -n " + model + " -o \"" + String.valueOf(fileOut.getParentFile()) + "\"", false);
        } else {
            NCNN.run(" -v -i \"" + String.valueOf(fileOut) + "\" -m \"" + NCNN.modelsPath + "\" -n " + model + " -o \"" + String.valueOf(fileOut) + "\"", false);
        }
        do {
            Thread.sleep(100L);
        } while (NCNN.isRunning && !cancelled);
        progressBar1.setValue(0);
        int progressValue = 0;
        File upscaleFolder = new File(lblDestination1.getText() + "/upscale");
        File[] fileArray = upscaleFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            fileOut = comboFonctions.getSelectedItem().equals("JPEG") || !comboFonctions.getSelectedItem().equals("JPEG") && !comboFonctions.getSelectedItem().equals(language.getProperty("functionPicture")) ? new File(lblDestination1.getText() + "/" + file.getName().replace(".png", ".jpg")) : new File(lblDestination1.getText() + "/" + file.getName().replace(".png", comboFilter.getSelectedItem().toString()));
            if (!comboFilter.getSelectedItem().toString().equals(".png")) {
                Object scale = "";
                if (Shutter.comboResolution.getSelectedItem().toString().contains("2x")) {
                    scale = " -vf \"scale=iw*0.5:ih*0.5\"" + flags;
                }
                FFMPEG.run(" -i \"" + String.valueOf(file) + "\"" + (String)scale + compression + " -y \"" + String.valueOf(fileOut) + "\"");
                do {
                    Thread.sleep(10L);
                } while (FFMPEG.runProcess.isAlive());
            } else if (Shutter.comboResolution.getSelectedItem().toString().contains("2x")) {
                FFMPEG.run(" -i \"" + String.valueOf(file) + "\" -vf \"scale=iw*0.5:ih*0.5\"" + flags + " -y \"" + String.valueOf(fileOut) + "\"");
                do {
                    Thread.sleep(10L);
                } while (FFMPEG.runProcess.isAlive());
            } else {
                File newName = new File(lblDestination1.getText() + "/" + file.getName());
                file.renameTo(newName);
                do {
                    Thread.sleep(10L);
                } while (!newName.exists() && !cancelled);
            }
            progressBar1.setValue(++progressValue);
            if (cancelled) break;
            ++n2;
        }
        fileArray = upscaleFolder.listFiles();
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            f.delete();
            ++n2;
        }
        upscaleFolder.delete();
    }

    private static boolean lastActions(File file, String fileName, String extension, File fileOut, String output) {
        if (FunctionUtils.cleanFunction(fileName, fileOut, output)) {
            return true;
        }
        FunctionUtils.addFileForMail(fileName);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            Picture.main(true, false);
            return true;
        }
        return false;
    }
}

