/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Console;
import application.Ftp;
import application.Settings;
import application.Shutter;
import application.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Arrays;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;
import settings.InputAndOutput;

public class VideoInserts
extends Shutter {
    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int toExtension = ((String)liste.firstElement()).toString().lastIndexOf(46);
                String extension = ((String)liste.firstElement()).substring(toExtension);
                File concatList = new File("");
                try {
                    String[] listeFichiers = new String[liste.getSize()];
                    int i = 0;
                    while (i < liste.getSize()) {
                        File file;
                        if (Settings.btnWaitFileComplete.isSelected() && !FunctionUtils.waitFileCompleted(file = new File((String)liste.getElementAt(i)))) break;
                        FFPROBE.Data((String)liste.getElementAt(i));
                        do {
                            Thread.sleep(100L);
                        } while (FFPROBE.isRunning);
                        listeFichiers[i] = VideoInserts.tcInMs() + "=\"" + (String)liste.getElementAt(i) + "\"=" + (VideoInserts.tcInMs() + FFPROBE.totalLength);
                        ++i;
                    }
                    int temps = 0;
                    String fichierMaster = listeFichiers[0];
                    int i2 = 0;
                    while (i2 < liste.getSize()) {
                        String[] fichier = listeFichiers[i2].split("=");
                        FFPROBE.Data(fichier[1].replace("\"", ""));
                        do {
                            Thread.sleep(100L);
                        } while (FFPROBE.isRunning);
                        if (FFPROBE.totalLength > temps) {
                            fichierMaster = listeFichiers[i2];
                            temps = FFPROBE.totalLength;
                        }
                        ++i2;
                    }
                    Object[] array = new Integer[liste.getSize()];
                    int i3 = 0;
                    while (i3 < listeFichiers.length) {
                        String[] timeIn = listeFichiers[i3].split("=");
                        array[i3] = Integer.parseInt(timeIn[0]);
                        ++i3;
                    }
                    String[] master = fichierMaster.split("=");
                    String masterName = new File(master[1].replace("\"", "")).getName();
                    FFPROBE.FrameData(master[1].replace("\"", ""));
                    do {
                        Thread.sleep(100L);
                    } while (FFPROBE.isRunning);
                    String extensionName = "";
                    if (btnExtension.isSelected()) {
                        extensionName = FunctionUtils.setSuffix(txtExtension.getText(), false);
                    }
                    String labelOutput = FunctionUtils.setOutputDestination("", new File(master[1].replace("\"", "")));
                    String fileOutputName = labelOutput + "/" + masterName.replace(extension, extensionName + extension);
                    File temp = new File(labelOutput + "/inserts");
                    temp.mkdir();
                    File fileOut = new File(fileOutputName);
                    if (fileOut.exists() && (fileOut = FunctionUtils.fileReplacement(labelOutput, masterName, extension, extensionName + "_", extension)) == null) {
                        cancelled = true;
                    }
                    concatList = new File(fileOut.toString().replace(extension, ".txt"));
                    Arrays.sort(array);
                    String[] listeFichiersSorted = new String[liste.getSize()];
                    listeFichiersSorted[0] = fichierMaster;
                    int f = 1;
                    int i4 = 0;
                    while (i4 < array.length) {
                        int i22 = 0;
                        while (i22 < listeFichiers.length) {
                            String[] timeIn = listeFichiers[i22].split("=");
                            if (timeIn[0].equals(((Integer)array[i4]).toString()) && !listeFichiers[i22].equals(fichierMaster) && f < liste.getSize()) {
                                String[] s = listeFichiers[i22].split("=");
                                String withTempFolder = "\"" + temp.toString() + "/" + new File(s[1].replace("\"", "")).getName() + "\"";
                                if (!cancelled) {
                                    progressBar1.setMaximum((Integer.parseInt(s[2]) - Integer.parseInt(s[0])) / 1000);
                                    lblCurrentEncoding.setText(new File(s[1].replace("\"", "")).getName());
                                    FFMPEG.run(" -i " + s[1] + " -video_track_timescale " + FFPROBE.timeBase + " -c copy -map v:0? -map a? -map s? -y " + withTempFolder);
                                    do {
                                        Thread.sleep(100L);
                                    } while (FFMPEG.isRunning);
                                }
                                listeFichiersSorted[f] = listeFichiers[i22].replace(s[1], withTempFolder);
                                ++f;
                                break;
                            }
                            ++i22;
                        }
                        ++i4;
                    }
                    int timelineTC = Integer.parseInt(master[0]);
                    PrintWriter writer = new PrintWriter(concatList, "UTF-8");
                    int i5 = 0;
                    while (i5 < listeFichiersSorted.length) {
                        int pointIn;
                        if (i5 == 0) {
                            pointIn = Integer.parseInt(master[0]);
                        } else {
                            String[] coupeIn = listeFichiersSorted[i5].split("=");
                            pointIn = Integer.parseInt(coupeIn[2]);
                        }
                        int pointOut = 0;
                        if (i5 < listeFichiersSorted.length - 1) {
                            String[] coupeOut = listeFichiersSorted[i5 + 1].split("=");
                            pointOut = Integer.parseInt(coupeOut[0]);
                        }
                        int In = pointIn - timelineTC;
                        int Out = i5 == listeFichiersSorted.length - 1 ? -1 : pointOut - timelineTC;
                        VideoInserts.fonctionInOutInserts(In, Out);
                        Console.consoleFFMPEG.append(System.lineSeparator() + listeFichiersSorted[i5] + System.lineSeparator());
                        if (In == 0 && Out == 0) {
                            insert = listeFichiersSorted[i5 + 1].split("=");
                            writer.println("file " + insert[1].replace("\"", "'"));
                            Console.consoleFFMPEG.append(System.lineSeparator() + "file " + insert[1].replace("\"", "'"));
                        } else if (Out != -1) {
                            if (In != 0 && Out != 0) {
                                writer.println("file " + master[1].replace("\"", "'"));
                                Console.consoleFFMPEG.append(System.lineSeparator() + "file " + master[1].replace("\"", "'"));
                                writer.println("inpoint " + InputAndOutput.inPoint);
                                writer.println("outpoint " + InputAndOutput.outPoint);
                                insert = listeFichiersSorted[i5 + 1].split("=");
                                writer.println("file " + insert[1].replace("\"", "'"));
                                Console.consoleFFMPEG.append(System.lineSeparator() + "file " + insert[1].replace("\"", "'"));
                            } else if (In != 0) {
                                writer.println("file " + master[1].replace("\"", "'"));
                                Console.consoleFFMPEG.append(System.lineSeparator() + "file " + master[1].replace("\"", "'"));
                                writer.println("inpoint " + InputAndOutput.inPoint);
                                insert = listeFichiersSorted[i5 + 1].split("=");
                                writer.println("file " + insert[1].replace("\"", "'"));
                                Console.consoleFFMPEG.append(System.lineSeparator() + "file " + insert[1].replace("\"", "'"));
                            } else if (Out != 0) {
                                writer.println("file " + master[1].replace("\"", "'"));
                                Console.consoleFFMPEG.append(System.lineSeparator() + "file " + master[1].replace("\"", "'"));
                                writer.println("outpoint " + InputAndOutput.outPoint);
                                insert = listeFichiersSorted[i5 + 1].split("=");
                                writer.println("file " + insert[1].replace("\"", "'"));
                                Console.consoleFFMPEG.append(System.lineSeparator() + "file " + insert[1].replace("\"", "'"));
                            }
                        } else if (In != 0 && In < Integer.parseInt(master[2]) - timelineTC) {
                            writer.println("file " + master[1].replace("\"", "'"));
                            Console.consoleFFMPEG.append(System.lineSeparator() + "file " + master[1].replace("\"", "'"));
                            writer.println("inpoint " + InputAndOutput.inPoint);
                        }
                        ++i5;
                    }
                    writer.close();
                    String timecode = VideoInserts.getTimecode(timelineTC);
                    progressBar1.setMaximum(temps / 1000);
                    lblCurrentEncoding.setText(fileOut.getName());
                    if (!cancelled) {
                        String cmd = " -i " + master[1] + timecode + " -c:v copy -c:a copy -c:s copy -map v:0? -map 1:a? -map s? -y ";
                        FFMPEG.run(" -safe 0 -f concat -i \"" + concatList.toString() + "\"" + cmd + "\"" + fileOut.toString() + "\"");
                        do {
                            Thread.sleep(100L);
                        } while (FFMPEG.runProcess.isAlive());
                    }
                    if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                        VideoInserts.lastActions(fileOut, concatList, labelOutput, temp);
                    }
                }
                catch (FileNotFoundException | UnsupportedEncodingException | InterruptedException e) {
                    FFMPEG.error = true;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    VideoInserts.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    private static boolean deleteDirectory(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        String[] files = dir.list();
        int i = 0;
        int len = files.length;
        while (i < len) {
            File f = new File(dir, files[i]);
            if (f.isDirectory()) {
                VideoInserts.deleteDirectory(f);
            } else {
                f.delete();
            }
            ++i;
        }
        return dir.delete();
    }

    private static int tcInMs() {
        int heures = Integer.parseInt(FFPROBE.timecode1);
        int minutes = Integer.parseInt(FFPROBE.timecode2);
        int secondes = Integer.parseInt(FFPROBE.timecode3);
        int images = (int)((float)Integer.parseInt(FFPROBE.timecode4) * (1000.0f / FFPROBE.currentFPS));
        int totalMiliSecondes = heures * 3600000 + minutes * 60000 + secondes * 1000 + images;
        return totalMiliSecondes;
    }

    private static String getTimecode(int timecode) {
        int h = timecode / 3600000;
        int m = timecode / 60000 % 60;
        int s = timecode / 1000 % 60;
        int f = (int)((float)timecode / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS);
        DecimalFormat formatter = new DecimalFormat("00");
        return " -timecode " + formatter.format(h) + ":" + formatter.format(m) + ":" + formatter.format(s) + ":" + formatter.format(f);
    }

    private static void fonctionInOutInserts(int tcIn, int tcOut) {
        DecimalFormat formatter = new DecimalFormat("00");
        DecimalFormat formatFrame = new DecimalFormat("000");
        int h = tcIn / 3600000;
        int m = tcIn / 60000 % 60;
        int s = tcIn / 1000 % 60;
        int f = tcIn % 1000;
        int h2 = tcOut / 3600000;
        int m2 = tcOut / 60000 % 60;
        int s2 = tcOut / 1000 % 60;
        int f2 = tcOut % 1000;
        InputAndOutput.inPoint = h * 3600000 + m * 60000 + s * 1000 + f > 0 ? formatter.format(h) + ":" + formatter.format(m) + ":" + formatter.format(s) + "." + formatFrame.format(f) : "";
        InputAndOutput.outPoint = tcOut != -1 ? formatter.format(h2) + ":" + formatter.format(m2) + ":" + formatter.format(s2) + "." + formatFrame.format(f2) : "";
    }

    private static void lastActions(File fileOut, File listeBAB, String output, File temp) {
        VideoInserts.deleteDirectory(temp);
        FunctionUtils.cleanFunction(fileOut.toString(), fileOut, output);
        listeBAB.delete();
        FunctionUtils.addFileForMail(fileOut.toString());
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
    }
}

