/*
 * Decompiled with CFR 0.152.
 */
package library;

import application.Console;
import application.Functions;
import application.RecordInputDevice;
import application.RenderQueue;
import application.SceneDetection;
import application.Settings;
import application.Shutter;
import application.VideoPlayer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import library.FFPROBE;
import library.NCNN;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import settings.BitratesAdjustement;
import settings.Colorimetry;
import settings.FunctionUtils;
import settings.InputAndOutput;

public class FFMPEG
extends Shutter {
    public static String PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
    public static int fileLength = 0;
    public static boolean error = false;
    public static boolean isRunning = false;
    public static BufferedWriter writer;
    public static Thread runProcess;
    private static Thread displayThread;
    public static Process process;
    private static Process processAudio;
    public static Process waveformProcess;
    public static BufferedWriter waveformWriter;
    private static InputStream audio;
    private static AudioInputStream audioInputStream;
    private static SourceDataLine line;
    private static boolean showInputDeviceFrame;
    private static float directDisplayInputRatio;
    private static Image frameVideo;
    public static String analyseLufs;
    public static Float mseSensibility;
    public static float newVolume;
    public static StringBuilder shortTermValues;
    public static StringBuilder blackFrame;
    public static StringBuilder mediaOfflineFrame;
    public static String VMAFScore;
    public static String cropdetect;
    private static boolean firstInput;
    public static int firstScreenIndex;
    public static StringBuilder videoDevices;
    public static StringBuilder audioDevices;
    public static StringBuilder hwaccels;
    public static boolean isGPUCompatible;
    public static boolean cudaAvailable;
    public static boolean qsvAvailable;
    public static boolean videotoolboxAvailable;
    public static boolean vulkanAvailable;
    public static int differenceMax;
    private static int frame0;
    private static long time;
    public static long elapsedTime;
    public static int previousElapsedTime;
    private static int fps;
    private static StringBuilder getAll;
    public static StringBuilder errorLog;

    static {
        runProcess = new Thread();
        audio = null;
        audioInputStream = null;
        line = null;
        showInputDeviceFrame = false;
        directDisplayInputRatio = 1.777777f;
        mseSensibility = Float.valueOf(800.0f);
        firstInput = true;
        firstScreenIndex = -1;
        hwaccels = new StringBuilder();
        isGPUCompatible = false;
        cudaAvailable = false;
        qsvAvailable = false;
        videotoolboxAvailable = false;
        vulkanAvailable = false;
        frame0 = 0;
        time = 0L;
        elapsedTime = 0L;
        previousElapsedTime = 0;
        fps = 0;
        errorLog = new StringBuilder();
    }

    public static void getFFmpegPath() {
        if (System.getProperty("os.name").contains("Windows")) {
            PathToFFMPEG = PathToFFMPEG.substring(1, PathToFFMPEG.length() - 1);
            PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", " ") + "\\Library\\ffmpeg.exe";
        } else {
            PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
            PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ") + "/Library/ffmpeg";
        }
        if (Settings.btnCustomFFmpegPath.isSelected() && !Settings.txtCustomFFmpegPath.getText().equals("")) {
            PathToFFMPEG = Settings.txtCustomFFmpegPath.getText();
        }
    }

    public static void run(final String cmd) {
        time = 0L;
        fps = 0;
        elapsedTime = System.currentTimeMillis() - (long)previousElapsedTime;
        error = false;
        firstInput = true;
        Console.consoleFFMPEG.append(System.lineSeparator());
        Console.consoleFFMPEG.append(Shutter.language.getProperty("command") + " -strict -2 -hide_banner -threads " + Settings.txtThreads.getText() + cmd);
        getAll = new StringBuilder();
        if (saveCode) {
            if (!cmd.contains("-pass 2")) {
                FFMPEG.saveToXML(cmd);
            }
        } else if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && RenderQueue.btnStartRender.isEnabled() && !cmd.contains("image2pipe") && !cmd.contains("waveform.png") && !cmd.contains("preview.bmp") && !cmd.contains("preview.png")) {
            if (lblCurrentEncoding.getText().equals(Shutter.language.getProperty("lblEncodageEnCours"))) {
                lblCurrentEncoding.setText(RenderQueue.tableRow.getValueAt(RenderQueue.tableRow.getRowCount() - 1, 0).toString());
            }
            if (!caseChangeFolder1.isSelected()) {
                lblDestination1.setText(Shutter.language.getProperty("sameAsSource"));
            }
            if (caseChangeFolder3.isSelected() && caseChangeFolder2.isSelected()) {
                RenderQueue.tableRow.addRow(new Object[]{lblCurrentEncoding.getText(), "ffmpeg" + FFMPEG.checkList(cmd), lblDestination1.getText() + " | " + lblDestination2.getText() + " | " + lblDestination3.getText()});
            } else if (caseChangeFolder2.isSelected()) {
                RenderQueue.tableRow.addRow(new Object[]{lblCurrentEncoding.getText(), "ffmpeg" + FFMPEG.checkList(cmd), lblDestination1.getText() + " | " + lblDestination2.getText()});
            } else {
                RenderQueue.tableRow.addRow(new Object[]{lblCurrentEncoding.getText(), "ffmpeg" + FFMPEG.checkList(cmd), lblDestination1.getText()});
            }
            RenderQueue.frame.toFront();
            lblCurrentEncoding.setText(Shutter.language.getProperty("lblEncodageEnCours"));
            Console.consoleFFMPEG.append(System.lineSeparator());
        } else {
            isRunning = true;
            if (!(Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) || cmd.contains("image2pipe") || cmd.contains("waveform.png") || cmd.contains("preview.bmp") || cmd.contains("preview.png") || screenshotIsRunning)) {
                FFMPEG.disableAll();
            }
            runProcess = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            String line;
                            if (System.getProperty("os.name").contains("Windows")) {
                                if (cmd.contains("image2pipe") || cmd.contains("pipe:1") || cmd.contains("vidstabdetect") || cmd.contains("60000/1001") || cmd.contains("30000/1001") || cmd.contains("24000/1001") || caseEnableColorimetry.isSelected() && Colorimetry.setEQ(true) != "" || caseLUTs.isSelected() && grpColorimetry.isVisible() || caseForcerDAR.isSelected() || caseColormatrix.isSelected() && comboInColormatrix.getSelectedItem().toString().equals("HDR") && grpColorimetry.isVisible()) {
                                    pipe = "";
                                    if (cmd.contains("pipe:1")) {
                                        pipe = " | \"" + PathToFFMPEG + "\" -strict -2 -v quiet -i pipe:0 -an -c:v bmp -f image2pipe -";
                                    }
                                    PathToFFMPEG = "Library\\ffmpeg.exe";
                                    process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", PathToFFMPEG + " -strict -2 -hide_banner -threads " + Settings.txtThreads.getText() + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG) + (String)pipe});
                                    if (Settings.btnCustomFFmpegPath.isSelected() && !Settings.txtCustomFFmpegPath.getText().equals("")) {
                                        PathToFFMPEG = Settings.txtCustomFFmpegPath.getText();
                                    } else {
                                        PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                                        PathToFFMPEG = PathToFFMPEG.substring(1, PathToFFMPEG.length() - 1);
                                        PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", " ") + "\\Library\\ffmpeg.exe";
                                    }
                                } else {
                                    processFFMPEG = new ProcessBuilder("\"" + PathToFFMPEG + "\" -strict -2 -hide_banner -threads " + Settings.txtThreads.getText() + " " + cmd.replace("PathToFFMPEG", "\"" + PathToFFMPEG + "\""));
                                    process = processFFMPEG.start();
                                }
                            } else {
                                pipe = "";
                                if (cmd.contains("pipe:1")) {
                                    pipe = " | " + PathToFFMPEG + " -strict -2 -v quiet -i pipe:0 -an -c:v bmp -f image2pipe -";
                                }
                                processFFMPEG = new ProcessBuilder("/bin/bash", "-c", PathToFFMPEG + " -strict -2 -hide_banner -threads " + Settings.txtThreads.getText() + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG) + (String)pipe);
                                process = processFFMPEG.start();
                            }
                            if (!cmd.contains("cropdetect") && btnStart.getText().equals(Shutter.language.getProperty("btnPauseFunction")) || btnStart.getText().equals(Shutter.language.getProperty("btnStopRecording"))) {
                                VideoPlayer.resizeAll();
                            }
                            BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            InputStream video = process.getInputStream();
                            final BufferedInputStream videoInputStream = new BufferedInputStream(video);
                            OutputStream stdin = process.getOutputStream();
                            writer = new BufferedWriter(new OutputStreamWriter(stdin));
                            if (cmd.contains("pipe:1")) {
                                VideoPlayer.playerStop();
                                Thread playerThread = new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            do {
                                                if (!btnStart.getText().equals(language.getProperty("btnPauseFunction")) && !btnStart.getText().equals(language.getProperty("btnStopRecording"))) continue;
                                                VideoPlayer.frameVideo = ImageIO.read(videoInputStream);
                                                VideoPlayer.player.repaint();
                                            } while (VideoPlayer.frameVideo != null);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                });
                                playerThread.start();
                            }
                            Console.consoleFFMPEG.append(System.lineSeparator());
                            while ((line = input.readLine()) != null) {
                                getAll.append(line);
                                getAll.append(System.lineSeparator());
                                Console.consoleFFMPEG.append(line + System.lineSeparator());
                                FFMPEG.checkForErrors(line);
                                if (cancelled) break;
                                if (cmd.contains("-pass 2")) {
                                    FFMPEG.setProgress(line, true, cmd);
                                    continue;
                                }
                                FFMPEG.setProgress(line, false, cmd);
                            }
                            process.waitFor();
                            if (!cancelled) {
                                FFMPEG.postAnalyse();
                            }
                        }
                        catch (IOException processFFMPEG) {
                            isRunning = false;
                            caseRunInBackground.setEnabled(false);
                        }
                        catch (InterruptedException e) {
                            error = true;
                            isRunning = false;
                            caseRunInBackground.setEnabled(false);
                        }
                    }
                    finally {
                        isRunning = false;
                        caseRunInBackground.setEnabled(false);
                    }
                }
            });
            runProcess.start();
        }
    }

    public static void checkForErrors(String line) {
        if (line.contains("No such file or directory") || line.contains("Invalid data found when processing input") && !line.contains("unable to decode APP fields") || line.contains("No space left") || line.contains("does not contain any stream") || line.contains("Invalid argument") || line.contains("Error opening filters!") || line.contains("Error reinitializing filters!") || line.contains("matches no streams") || line.contains("Error while opening encoder") || line.contains("Decoder (codec none) not found") || line.contains("hwaccel initialisation returned error") || line.contains("Device setup failed for decoder") || line.contains("No device available for decoder") || line.contains("Error while decoding stream") || line.contains("Current pixel format is unsupported") || line.contains("Unknown encoder") || line.contains("Could not set video options") || line.contains("Could not find tag for codec") || line.contains("Input/output error") || line.contains("Operation not permitted") || line.contains("Permission denied") || line.contains("width not divisible by 2") || line.contains("integer multiple of the specified") || line.contains("is not multiple of 4") || line.contains("cannot be smaller than input dimensions")) {
            if (!line.contains("error code") && !line.contains("return code")) {
                errorLog.append(line + System.lineSeparator());
            }
            error = true;
        }
    }

    private static String checkList(String cmd) {
        if (cmd.contains("pass 2")) {
            return RenderQueue.tableRow.getValueAt(RenderQueue.tableRow.getRowCount() - 1, 1).toString().replace("ffmpeg", "").replace("pass 1", "pass 2");
        }
        String cmdFinale = cmd;
        String[] s = cmd.split("\"");
        String cmdFile = s[s.length - 1];
        int n = 0;
        int i = 0;
        while (i < RenderQueue.tableRow.getRowCount()) {
            String[] s2 = RenderQueue.tableRow.getValueAt(i, 1).toString().split("\"");
            String renduFile = s2[s2.length - 1];
            if (cmdFile.equals(renduFile)) {
                String[] s3 = cmd.split("\"");
                String ext = cmdFile.substring(cmdFile.lastIndexOf("."), cmdFile.lastIndexOf(".") + 4);
                String originalCmdFile = s3[s3.length - 1];
                cmdFile = originalCmdFile.replace(ext, "_" + ++n + ext);
            }
            ++i;
        }
        String[] s4 = cmd.split("\"");
        cmdFinale = cmd.replace(s4[s4.length - 1], cmdFile);
        return cmdFinale;
    }

    public static void toSDL(boolean isVideoPlayer) {
        if (fileList.getSelectedIndices().length > 1 && !isVideoPlayer) {
            Object input = "";
            Object filter = "";
            Object hstack = "";
            int n = fileList.getSelectedIndices().length;
            int i = 0;
            for (String video : fileList.getSelectedValuesList()) {
                input = (String)input + " -v quiet -i \"" + video + "\"";
                filter = (String)filter + "[" + i + ":v]scale=iw/" + n + ":ih/2[v" + i + "];";
                ++i;
            }
            int v = 0;
            while (v < i) {
                hstack = (String)hstack + "[v" + v + "]";
                ++v;
            }
            hstack = (String)hstack + "hstack=" + n + "[out]";
            FFMPEG.toFFPLAY(" -strict -2 -hwaccel " + Shutter.comboGPUDecoding.getSelectedItem().toString().replace(Shutter.language.getProperty("aucun"), "none") + (String)input + " -filter_complex \"" + (String)filter + (String)hstack + "\" -c:v rawvideo -map \"[out]\" -an -f nut pipe:1");
        } else {
            File inputFile = null;
            if (isVideoPlayer) {
                inputFile = new File(VideoPlayer.videoPath);
                InputAndOutput.getInputAndOutput();
            } else if (!inputDeviceIsRunning) {
                inputFile = new File((String)fileList.getSelectedValue());
                FFPROBE.Data((String)fileList.getSelectedValue());
            }
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException filter) {
                    // empty catch block
                }
            } while (FFPROBE.isRunning);
            Object channels = "";
            Object videoOutput = "";
            Object audioOutput = "";
            if (FFPROBE.audioOnly) {
                if (FFPROBE.channels > 1) {
                    i = 0;
                    while (i < FFPROBE.channels) {
                        channels = (String)channels + "[0:a:" + i + "]showvolume=f=0.001:b=4:w=720:h=12[a" + i + "];";
                        audioOutput = (String)audioOutput + "[a" + i + "]";
                        ++i;
                    }
                    audioOutput = (String)channels + (String)audioOutput + "vstack=" + i + "[volume]\" -map \"[volume]\"";
                } else if (FFPROBE.channels <= 1) {
                    audioOutput = "[0:a:0]showvolume=f=0.001:b=4:w=720:h=12[volume]\" -map \"[volume]\"";
                }
            } else {
                if (FFPROBE.channels > 1) {
                    if (inputDeviceIsRunning) {
                        channels = (String)channels + "[0:a]showvolume=f=0.001:b=4:w=1000:h=12[a0];";
                        channels = (String)channels + "[2:a]showvolume=f=0.001:b=4:w=1000:h=12[a2];";
                        audioOutput = (String)audioOutput + "[a0]";
                        audioOutput = (String)audioOutput + "[a2]";
                        audioOutput = (String)audioOutput + "vstack=3[volume]\" -map \"[volume]\"";
                    } else {
                        i = 0;
                        i = 0;
                        while (i < FFPROBE.channels) {
                            channels = (String)channels + "[0:a:" + i + "]showvolume=f=0.001:b=4:w=1000:h=12[a" + i + "];";
                            audioOutput = (String)audioOutput + "[a" + i + "]";
                            ++i;
                        }
                        audioOutput = (String)audioOutput + "vstack=" + (i + 1) + "[volume]\" -map \"[volume]\"";
                    }
                } else if (FFPROBE.channels == 1) {
                    if (inputDeviceIsRunning && RecordInputDevice.audioDeviceIndex > 0 && overlayDeviceIsRunning && RecordInputDevice.overlayAudioDeviceIndex > 0) {
                        channels = "[2:a]showvolume=f=0.001:b=4:w=1000:h=12[a0];";
                        audioOutput = "[a0]vstack[volume]\" -map \"[volume]\"";
                    } else if (inputDeviceIsRunning && overlayDeviceIsRunning && RecordInputDevice.overlayAudioDeviceIndex > 0) {
                        channels = "[1:a]showvolume=f=0.001:b=4:w=1000:h=12[a0];";
                        audioOutput = "[a0]vstack[volume]\" -map \"[volume]\"";
                    } else {
                        channels = "[0:a:0]showvolume=f=0.001:b=4:w=1000:h=12[a0];";
                        audioOutput = "[a0]vstack[volume]\" -map \"[volume]\"";
                    }
                }
                videoOutput = "[0:v]scale=1000:-1:sws_flags=fast_bilinear:sws_dither=none[v];" + (String)channels + "[v]";
                if (FFPROBE.channels == 0 || ((String)liste.getElementAt(0)).equals("Capture.input.device")) {
                    videoOutput = "scale=1000:-1:sws_flags=fast_bilinear:sws_dither=none\"";
                    audioOutput = "";
                }
            }
            if (inputDeviceIsRunning && overlayDeviceIsRunning) {
                videoOutput = RecordInputDevice.audioDeviceIndex > 0 ? "[2:v]scale=iw*" + (float)Integer.parseInt(Shutter.textWatermarkSize.getText()) / 100.0f + ":ih*" + (float)Integer.parseInt(Shutter.textWatermarkSize.getText()) / 100.0f + ",lut=a=val*" + (float)Integer.parseInt(Shutter.textWatermarkOpacity.getText()) / 100.0f + "[scaledwatermark];[1:v][scaledwatermark]overlay=" + Shutter.textWatermarkPosX.getText() + ":" + Shutter.textWatermarkPosY.getText() + "[v]" : "[1:v]scale=iw*" + (float)Integer.parseInt(Shutter.textWatermarkSize.getText()) / 100.0f + ":ih*" + (float)Integer.parseInt(Shutter.textWatermarkSize.getText()) / 100.0f + ",lut=a=val*" + (float)Integer.parseInt(Shutter.textWatermarkOpacity.getText()) / 100.0f + "[scaledwatermark];[0:v][scaledwatermark]overlay=" + Shutter.textWatermarkPosX.getText() + ":" + Shutter.textWatermarkPosY.getText() + "[v]";
                videoOutput = audioOutput != "" ? (String)videoOutput + ";" + (String)channels + "[v]" : (String)videoOutput + "\"";
            }
            String extension = "";
            String output = "";
            if (!inputDeviceIsRunning) {
                extension = inputFile.toString().substring(inputFile.toString().lastIndexOf("."));
                output = inputFile.getParent();
            }
            String concat = "";
            if (VideoPlayer.comboMode.getSelectedItem().toString().equals(Shutter.language.getProperty("removeMode"))) {
                concat = FunctionUtils.setConcat(inputFile, output);
                inputFile = new File(output.replace("\\", "/") + "/" + inputFile.getName().replace(extension, ".txt"));
            }
            Object cmd = " -filter_complex \"" + (String)videoOutput + (String)audioOutput + " -c:v rawvideo -an -f nut pipe:1";
            frame.setCursor(Cursor.getPredefinedCursor(3));
            String loop = FunctionUtils.setLoop(extension);
            if (isVideoPlayer) {
                FFMPEG.toFFPLAY(loop + InputAndOutput.inPoint + concat + " -hwaccel " + Shutter.comboGPUDecoding.getSelectedItem().toString().replace(Shutter.language.getProperty("aucun"), "none") + " -strict -2 -v quiet -i \"" + String.valueOf(inputFile) + "\"" + InputAndOutput.outPoint + (String)cmd);
            } else if (inputDeviceIsRunning) {
                if (((String)liste.getElementAt(0)).equals("Capture.current.screen") && RecordInputDevice.audioDeviceIndex > 0 || System.getProperty("os.name").contains("Mac") && ((String)liste.getElementAt(0)).equals("Capture.input.device") && RecordInputDevice.audioDeviceIndex > 0) {
                    cmd = ((String)cmd).replace("0:v", "1:v");
                }
                if (overlayDeviceIsRunning && audioOutput == "") {
                    cmd = ((String)cmd).replace("-an", "-map \"[v]\"");
                }
                if (overlayDeviceIsRunning) {
                    FFMPEG.toFFPLAY(" -strict -2 -v quiet " + RecordInputDevice.setInputDevices() + " " + RecordInputDevice.setOverlayDevice() + (String)cmd);
                } else {
                    FFMPEG.toFFPLAY(" -strict -2 -v quiet " + RecordInputDevice.setInputDevices() + (String)cmd);
                }
            } else {
                FFMPEG.toFFPLAY(loop + " -hwaccel " + Shutter.comboGPUDecoding.getSelectedItem().toString().replace(Shutter.language.getProperty("aucun"), "none") + " -strict -2 -v quiet -i \"" + String.valueOf(inputFile) + "\"" + (String)cmd);
            }
            progressBar1.setValue(0);
        }
    }

    public static void toFFPLAY(String cmd) {
        error = false;
        frame.setCursor(Cursor.getPredefinedCursor(3));
        isRunning = true;
        try {
            Object fps = " -r " + FFPROBE.currentFPS;
            if (Shutter.caseCreateSequence.isSelected()) {
                fps = " -r " + String.valueOf(Float.valueOf(Shutter.comboInterpret.getSelectedItem().toString().replace(",", ".")));
            } else if (inputDeviceIsRunning || RecordInputDevice.frame != null && RecordInputDevice.frame.isVisible()) {
                fps = "";
            }
            if (System.getProperty("os.name").contains("Windows")) {
                ProcessBuilder pbv = new ProcessBuilder("cmd.exe", "/c", "\"" + PathToFFMPEG + "\" -strict -2 -hide_banner -threads " + Settings.txtThreads.getText() + " " + cmd + " | \"" + PathToFFMPEG + "\" -v quiet -i pipe:0" + (String)fps + " -c:v bmp -an -f image2pipe -");
                process = pbv.start();
                if (FFPROBE.hasAudio) {
                    File inputFile = new File((String)fileList.getSelectedValue());
                    String concat = "";
                    if (VideoPlayer.comboMode.getSelectedItem().toString().equals(Shutter.language.getProperty("removeMode"))) {
                        String extension = inputFile.toString().substring(inputFile.toString().lastIndexOf("."));
                        concat = FunctionUtils.setConcat(inputFile, inputFile.getParent());
                        inputFile = new File(inputFile.getParent().replace("\\", "/") + "/" + inputFile.getName().replace(extension, ".txt"));
                    }
                    ProcessBuilder pba = new ProcessBuilder("cmd.exe", "/c", "\"" + PathToFFMPEG + "\"" + concat + " -v quiet " + InputAndOutput.inPoint + " -i \"" + String.valueOf(inputFile) + "\" -vn -c:a pcm_s16le -ar 48k -ac 1 -f wav -");
                    processAudio = pba.start();
                }
            } else {
                ProcessBuilder processFFMPEG = new ProcessBuilder("/bin/bash", "-c", PathToFFMPEG + " -strict -2 -hide_banner -threads " + Settings.txtThreads.getText() + " " + cmd + " | " + PathToFFMPEG + " -v quiet -i pipe:0" + (String)fps + " -c:v bmp -an -f image2pipe -");
                process = processFFMPEG.start();
                if (FFPROBE.hasAudio) {
                    File inputFile = new File((String)fileList.getSelectedValue());
                    String concat = "";
                    if (VideoPlayer.comboMode.getSelectedItem().toString().equals(Shutter.language.getProperty("removeMode"))) {
                        String extension = inputFile.toString().substring(inputFile.toString().lastIndexOf("."));
                        concat = FunctionUtils.setConcat(inputFile, inputFile.getParent());
                        inputFile = new File(inputFile.getParent().replace("\\", "/") + "/" + inputFile.getName().replace(extension, ".txt"));
                    }
                    ProcessBuilder pba = new ProcessBuilder("/bin/bash", "-c", PathToFFMPEG + concat + " -v quiet " + InputAndOutput.inPoint + " -i \"" + String.valueOf(inputFile) + "\" -vn -c:a pcm_s16le -ar 48k -ac 1 -f wav -");
                    processAudio = pba.start();
                }
            }
            Console.consoleFFPLAY.append(Shutter.language.getProperty("command") + " " + PathToFFMPEG + " -strict -2 -hide_banner -threads " + Settings.txtThreads.getText() + " " + cmd + " | " + PathToFFMPEG + " -v quiet -i pipe:0" + (String)fps + " -c:v bmp -an -f image2pipe -" + System.lineSeparator());
            final JFrame player = new JFrame();
            player.getContentPane().setBackground(new Color(42, 42, 47));
            player.setDefaultCloseOperation(2);
            player.setBackground(new Color(42, 42, 47));
            player.getContentPane().setLayout(null);
            player.setIconImage(frame.getIconImage());
            if (RecordInputDevice.frame != null && RecordInputDevice.frame.isVisible()) {
                RecordInputDevice.frame.setVisible(false);
                showInputDeviceFrame = true;
                player.setTitle(language.getProperty("preview"));
            } else {
                showInputDeviceFrame = false;
                player.setTitle(new File(Shutter.fileList.getSelectedValue()).getName());
            }
            player.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent arg0) {
                    isRunning = false;
                    process.destroy();
                    displayThread.interrupt();
                    if (FFPROBE.hasAudio) {
                        processAudio.destroy();
                    }
                    if (showInputDeviceFrame) {
                        RecordInputDevice.frame.setVisible(true);
                    }
                }
            });
            GraphicsConfiguration config = player.getGraphicsConfiguration();
            GraphicsDevice myScreen = config.getDevice();
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] allScreens = env.getScreenDevices();
            int screenIndex = -1;
            int i = 0;
            while (i < allScreens.length) {
                if (allScreens[i].equals(myScreen)) {
                    screenIndex = i;
                    break;
                }
                ++i;
            }
            final int screenWidth = allScreens[screenIndex].getDisplayMode().getWidth();
            final int screenHeight = allScreens[screenIndex].getDisplayMode().getHeight();
            final JPanel display = new JPanel(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2.setColor(Color.BLACK);
                    this.setSize(player.getContentPane().getWidth(), player.getContentPane().getHeight());
                    if (frameVideo != null) {
                        if (player.getHeight() > screenHeight) {
                            int newWidth = (int)((float)screenHeight * directDisplayInputRatio);
                            g2.drawImage(frameVideo, player.getContentPane().getWidth() / 2 - newWidth / 2, 0, newWidth, this.getHeight(), this);
                        } else {
                            g2.drawImage(frameVideo, player.getContentPane().getWidth() / 2 - this.getWidth() / 2, player.getContentPane().getHeight() / 2 - (int)((float)this.getWidth() / directDisplayInputRatio) / 2, this.getWidth(), (int)((float)this.getWidth() / directDisplayInputRatio), this);
                        }
                    } else {
                        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                }
            };
            display.setLayout(null);
            display.setBackground(Color.BLACK);
            player.add(display);
            player.setVisible(true);
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    KeyEvent ke = (KeyEvent)event;
                    if (ke.getID() == 401 && ke.getKeyCode() == 27) {
                        isRunning = false;
                        process.destroy();
                        displayThread.interrupt();
                        if (FFPROBE.hasAudio) {
                            processAudio.destroy();
                        }
                        if (showInputDeviceFrame) {
                            RecordInputDevice.frame.setVisible(true);
                        }
                        player.dispose();
                    }
                }
            }, 8L);
            final InputStream video = process.getInputStream();
            final BufferedInputStream videoInputStream = new BufferedInputStream(video);
            if (FFPROBE.hasAudio) {
                audio = processAudio.getInputStream();
                audioInputStream = AudioSystem.getAudioInputStream(audio);
                AudioFormat audioFormat = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(audioFormat);
                line.start();
            }
            displayThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            byte[] bytes = new byte[(int)Math.ceil(96000.0f / FFPROBE.currentFPS)];
                            int bytesRead = 0;
                            boolean getRatio = true;
                            float inputFramerateMS = 1000.0f / FFPROBE.currentFPS;
                            if (Shutter.caseCreateSequence.isSelected()) {
                                inputFramerateMS = 1000.0f / Float.valueOf(Shutter.comboInterpret.getSelectedItem().toString().replace(",", ".")).floatValue();
                            }
                            do {
                                long delay;
                                long startTime = System.nanoTime() + (long)((int)(inputFramerateMS * 1000000.0f));
                                if (FFPROBE.hasAudio) {
                                    try {
                                        bytesRead = audioInputStream.read(bytes, 0, bytes.length);
                                        line.write(bytes, 0, bytesRead);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                frameVideo = ImageIO.read(videoInputStream);
                                display.repaint();
                                if (frameVideo != null && frameVideo.toString().contains("width") && getRatio) {
                                    String info = frameVideo.toString();
                                    String[] w = info.substring(info.indexOf("width")).replace("width ", "").split(" ");
                                    String[] h = info.substring(info.indexOf("height")).replace("height ", "").split(" ");
                                    directDisplayInputRatio = (float)Integer.parseInt(w[1]) / (float)Integer.parseInt(h[1]);
                                    int borderWidth = player.getWidth() - player.getContentPane().getWidth();
                                    int borderHeight = player.getHeight() - player.getContentPane().getHeight();
                                    player.setSize(1000 + borderWidth, (int)(1000.0f / directDisplayInputRatio) + borderHeight);
                                    player.setLocation(screenWidth / 2 - player.getSize().width / 2, screenHeight / 2 - player.getSize().height / 2);
                                    display.setSize(player.getSize());
                                    frame.setCursor(Cursor.getPredefinedCursor(0));
                                    getRatio = false;
                                }
                                if ((delay = startTime - System.nanoTime()) <= 0L) continue;
                                try {
                                    Thread.sleep((int)(delay / 1500000L));
                                }
                                catch (InterruptedException h) {
                                    // empty catch block
                                }
                                delay = startTime - System.nanoTime();
                                long time = System.nanoTime();
                                while (System.nanoTime() - time < delay) {
                                }
                            } while (process.isAlive());
                            try {
                                video.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                videoInputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (audio != null) {
                                try {
                                    audio.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                try {
                                    audioInputStream.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                line.close();
                            }
                            if (player.isVisible()) {
                                player.dispose();
                            }
                        }
                        catch (Exception e) {
                            error = true;
                            if (VideoPlayer.comboMode.getSelectedItem().toString().equals(Shutter.language.getProperty("removeMode"))) {
                                File inputFile = new File(VideoPlayer.videoPath);
                                String extension = inputFile.toString().substring(inputFile.toString().lastIndexOf("."));
                                File listeBAB = new File(inputFile.getParent().replace("\\", "/") + "/" + inputFile.getName().replace(extension, ".txt"));
                                listeBAB.delete();
                            }
                            isRunning = false;
                        }
                    }
                    finally {
                        if (VideoPlayer.comboMode.getSelectedItem().toString().equals(Shutter.language.getProperty("removeMode"))) {
                            File inputFile = new File(VideoPlayer.videoPath);
                            String extension = inputFile.toString().substring(inputFile.toString().lastIndexOf("."));
                            File listeBAB = new File(inputFile.getParent().replace("\\", "/") + "/" + inputFile.getName().replace(extension, ".txt"));
                            listeBAB.delete();
                        }
                        isRunning = false;
                    }
                }
            });
            displayThread.setPriority(10);
            displayThread.start();
        }
        catch (Exception e) {
            error = true;
        }
    }

    public static void hwaccel(String cmd) {
        error = false;
        isRunning = true;
        try {
            try {
                if (System.getProperty("os.name").contains("Windows")) {
                    processFFMPEG = new ProcessBuilder("\"" + PathToFFMPEG + "\" -strict -2 -hide_banner " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                    process = processFFMPEG.start();
                } else {
                    processFFMPEG = new ProcessBuilder("/bin/bash", "-c", PathToFFMPEG + " -strict -2 -hide_banner " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                    process = processFFMPEG.start();
                }
                if (cmd.contains("-hwaccels")) {
                    String line;
                    InputStreamReader isr = new InputStreamReader(process.getInputStream());
                    BufferedReader br = new BufferedReader(isr);
                    hwaccels.append("auto" + System.lineSeparator());
                    while ((line = br.readLine()) != null) {
                        if (line.contains("Hardware acceleration methods") || line.equals("") || line == null) continue;
                        hwaccels.append(line + System.lineSeparator());
                    }
                    hwaccels.append(language.getProperty("aucun"));
                } else {
                    String line;
                    BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    while ((line = input.readLine()) != null) {
                        Console.consoleFFMPEG.append(line + System.lineSeparator());
                        FFMPEG.checkForErrors(line);
                    }
                    Console.consoleFFMPEG.append(System.lineSeparator());
                }
                process.waitFor();
            }
            catch (IOException processFFMPEG) {
                isRunning = false;
            }
            catch (InterruptedException e) {
                error = true;
                isRunning = false;
            }
        }
        finally {
            isRunning = false;
        }
    }

    public static void checkGPUCapabilities(String file) {
        frame.setCursor(Cursor.getPredefinedCursor(3));
        isGPUCompatible = false;
        cudaAvailable = false;
        qsvAvailable = false;
        videotoolboxAvailable = false;
        vulkanAvailable = false;
        if ((System.getProperty("os.name").contains("Windows") || System.getProperty("os.name").contains("Mac")) && !Shutter.comboGPUDecoding.getSelectedItem().toString().equals(Shutter.language.getProperty("aucun")) && !Shutter.comboGPUFilter.getSelectedItem().toString().equals(Shutter.language.getProperty("aucun")) || System.getProperty("os.name").contains("Windows") || System.getProperty("os.name").contains("Mac")) {
            String vcodec = "";
            if (FFPROBE.videoCodec != null && FFPROBE.totalLength > 40) {
                vcodec = FFPROBE.videoCodec.replace("video", "");
                String[] stringArray = Shutter.functionsList;
                int n = Shutter.functionsList.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (vcodec.toLowerCase().equals(s.replace(".", "").replace("-", "").toLowerCase()) || s.toLowerCase().contains(vcodec.toLowerCase())) {
                        vcodec = s;
                        break;
                    }
                    vcodec = vcodec.toUpperCase();
                    ++n2;
                }
            }
            if (vcodec.equals("H.264") || vcodec.equals("HEVC") || vcodec.equals("VP8") || vcodec.equals("VP9") || vcodec.equals("AV1") || vcodec.equals("MPEG-1") || vcodec.equals("MPEG-2")) {
                isGPUCompatible = true;
            }
            if (FFPROBE.imageDepth > 10) {
                isGPUCompatible = false;
            }
            if (isGPUCompatible) {
                try {
                    String bitDepth = "nv12";
                    if (FFPROBE.imageDepth == 10) {
                        bitDepth = "p010";
                    }
                    if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                        if (Shutter.comboGPUDecoding.getSelectedItem().toString().equals("auto")) {
                            if (System.getProperty("os.name").contains("Windows")) {
                                FFMPEG.gpuFilter(" -hwaccel cuda -hwaccel_output_format cuda -i \"" + file + "\" -vf scale_cuda=640:360,hwdownload,format=" + bitDepth + " -an -t 1 -f null -\"");
                                do {
                                    Thread.sleep(100L);
                                } while (runProcess.isAlive());
                                if (!error) {
                                    cudaAvailable = true;
                                }
                                FFMPEG.gpuFilter(" -hwaccel qsv -hwaccel_output_format qsv -i \"" + file + "\" -vf scale_qsv=640:360,hwdownload,format=" + bitDepth + " -an -t 1 -f null -\"");
                                do {
                                    Thread.sleep(100L);
                                } while (runProcess.isAlive());
                                if (!error) {
                                    qsvAvailable = true;
                                }
                                FFMPEG.gpuFilter(" -hwaccel vulkan -hwaccel_output_format vulkan -init_hw_device vulkan  -i \"" + file + "\" -vf scale_vulkan=640:360,hwdownload,format=" + bitDepth + " -an -t 1 -f null -\"");
                                do {
                                    Thread.sleep(100L);
                                } while (runProcess.isAlive());
                                if (!error) {
                                    vulkanAvailable = true;
                                }
                                if (!comboAccel.getSelectedItem().equals(language.getProperty("aucune").toLowerCase())) {
                                    if (comboAccel.getSelectedItem().equals("Intel Quick Sync") || comboAccel.getSelectedItem().equals("Vulkan Video")) {
                                        cudaAvailable = false;
                                    } else if (comboAccel.getSelectedItem().equals("Nvidia NVENC") || comboAccel.getSelectedItem().equals("Vulkan Video")) {
                                        qsvAvailable = false;
                                    } else if (comboAccel.getSelectedItem().equals("Intel Quick Sync") || comboAccel.getSelectedItem().equals("Nvidia NVENC")) {
                                        vulkanAvailable = false;
                                    }
                                }
                            } else {
                                FFMPEG.gpuFilter(" -hwaccel videotoolbox -hwaccel_output_format videotoolbox_vld -i \"" + file + "\" -vf scale_vt=640:360,hwdownload,format=" + bitDepth + " -an -t 1 -f null -");
                                do {
                                    Thread.sleep(100L);
                                } while (runProcess.isAlive());
                                if (!error) {
                                    videotoolboxAvailable = true;
                                }
                            }
                            if (!(cudaAvailable || qsvAvailable || videotoolboxAvailable || vulkanAvailable)) {
                                isGPUCompatible = false;
                            }
                        } else {
                            String device = "";
                            if (Shutter.comboGPUDecoding.getSelectedItem().toString().equals("vulkan")) {
                                device = " -init_hw_device vulkan";
                            }
                            FFMPEG.gpuFilter(" -hwaccel " + Shutter.comboGPUDecoding.getSelectedItem().toString().replace(Shutter.language.getProperty("aucun"), "none") + " -hwaccel_output_format " + Shutter.comboGPUFilter.getSelectedItem().toString() + device + " -i \"" + file + "\" -vf scale_" + Shutter.comboGPUFilter.getSelectedItem().toString() + "=640:360,hwdownload,format=" + bitDepth + " -an -t 1 -f null -\"");
                            do {
                                Thread.sleep(100L);
                            } while (runProcess.isAlive());
                            if (error) {
                                isGPUCompatible = false;
                                if (Shutter.comboGPUDecoding.getSelectedItem().equals("cuda")) {
                                    cudaAvailable = false;
                                } else if (Shutter.comboGPUDecoding.getSelectedItem().equals("qsv")) {
                                    qsvAvailable = false;
                                } else if (Shutter.comboGPUDecoding.getSelectedItem().equals("videotoolbox")) {
                                    videotoolboxAvailable = false;
                                } else if (Shutter.comboGPUDecoding.getSelectedItem().equals("vulkan")) {
                                    vulkanAvailable = false;
                                }
                            } else if (Shutter.comboGPUDecoding.getSelectedItem().equals("cuda")) {
                                cudaAvailable = true;
                            } else if (Shutter.comboGPUDecoding.getSelectedItem().equals("qsv")) {
                                qsvAvailable = true;
                            } else if (Shutter.comboGPUDecoding.getSelectedItem().equals("videotoolbox")) {
                                videotoolboxAvailable = true;
                            } else if (Shutter.comboGPUDecoding.getSelectedItem().equals("vulkan")) {
                                vulkanAvailable = true;
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                error = false;
                errorLog.setLength(0);
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public static void setCropDetect(File file) {
        cropdetect = "";
        String cmd = " -an -frames:v 5 -vf cropdetect -f null -\"";
        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
            cmd = " -an -frames:v 5 -vf cropdetect -f null -";
        }
        Object inputPoint = " -ss " + VideoPlayer.playerCurrentFrame * VideoPlayer.inputFramerateMS + "ms";
        if (FFPROBE.totalLength <= 40 || Shutter.caseEnableSequence.isSelected()) {
            inputPoint = " -loop 1";
        }
        screenshotIsRunning = true;
        FFMPEG.run((String)inputPoint + " -i \"" + String.valueOf(file) + "\"" + cmd);
        try {
            do {
                Thread.sleep(100L);
            } while (isRunning);
        }
        catch (Exception exception) {
            // empty catch block
        }
        screenshotIsRunning = false;
        if (cropdetect != "") {
            String[] c = cropdetect.split(":");
            textCropPosX.setText(c[2]);
            textCropWidth.setText(c[0]);
            textCropHeight.setText(c[1]);
            textCropPosY.setText(c[3]);
            int x = Math.round((float)(Integer.valueOf(textCropPosX.getText()) * VideoPlayer.player.getHeight()) / (float)FFPROBE.imageHeight);
            int y = Math.round((float)(Integer.valueOf(textCropPosY.getText()) * VideoPlayer.player.getWidth()) / (float)FFPROBE.imageWidth);
            int width = (int)Math.ceil((float)(Integer.valueOf(textCropWidth.getText()) * VideoPlayer.player.getHeight()) / (float)FFPROBE.imageHeight);
            int height = (int)Math.floor((float)(Integer.valueOf(textCropHeight.getText()) * VideoPlayer.player.getWidth()) / (float)FFPROBE.imageWidth);
            if (width > VideoPlayer.player.getWidth()) {
                width = VideoPlayer.player.getWidth();
            }
            if (height > VideoPlayer.player.getHeight()) {
                height = VideoPlayer.player.getHeight();
            }
            selection.setBounds(x, y, width, height);
        }
    }

    public static void gpuFilter(final String cmd) {
        error = false;
        runProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    if (System.getProperty("os.name").contains("Windows")) {
                        processFFMPEG = new ProcessBuilder("\"" + PathToFFMPEG + "\" " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                        process = processFFMPEG.start();
                    } else {
                        processFFMPEG = new ProcessBuilder("/bin/bash", "-c", PathToFFMPEG + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                        process = processFFMPEG.start();
                    }
                    BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    while ((line = input.readLine()) != null) {
                        FFMPEG.checkForErrors(line);
                    }
                    process.waitFor();
                }
                catch (IOException processFFMPEG) {
                }
                catch (InterruptedException e) {
                    error = true;
                }
            }
        });
        runProcess.start();
    }

    public static void devices(final String cmd) {
        error = false;
        isRunning = true;
        Console.consoleFFMPEG.append(Shutter.language.getProperty("command") + cmd);
        runProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        String line;
                        if (System.getProperty("os.name").contains("Windows")) {
                            processFFMPEG = new ProcessBuilder("\"" + PathToFFMPEG + "\" " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                            process = processFFMPEG.start();
                        } else {
                            processFFMPEG = new ProcessBuilder("/bin/bash", "-c", PathToFFMPEG + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                            process = processFFMPEG.start();
                        }
                        BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        boolean isVideoDevices = false;
                        boolean isAudioDevices = false;
                        if (!cmd.contains("openal")) {
                            videoDevices = new StringBuilder();
                            videoDevices.append(language.getProperty("noVideo"));
                        }
                        audioDevices = new StringBuilder();
                        audioDevices.append(language.getProperty("noAudio"));
                        Console.consoleFFMPEG.append(System.lineSeparator());
                        while ((line = input.readLine()) != null) {
                            String utf8EncodedString;
                            byte[] bytes;
                            String[] s;
                            Console.consoleFFMPEG.append(line + System.lineSeparator());
                            if (cmd.contains("avfoundation") && line.contains("]")) {
                                if (isAudioDevices && !line.contains("Error")) {
                                    s = line.split("\\]");
                                    bytes = s[2].substring(1, s[2].length()).getBytes(StandardCharsets.ISO_8859_1);
                                    utf8EncodedString = new String(bytes, StandardCharsets.UTF_8);
                                    audioDevices.append(":" + utf8EncodedString);
                                }
                                if (line.contains("AVFoundation audio devices")) {
                                    isAudioDevices = true;
                                }
                                if (isVideoDevices && !line.contains("Capture screen") && !isAudioDevices) {
                                    s = line.split("\\]");
                                    bytes = s[2].substring(1, s[2].length()).getBytes(StandardCharsets.ISO_8859_1);
                                    utf8EncodedString = new String(bytes, StandardCharsets.UTF_8);
                                    videoDevices.append(":" + utf8EncodedString);
                                }
                                if (line.contains("AVFoundation video devices")) {
                                    isVideoDevices = true;
                                }
                            }
                            if (cmd.contains("avfoundation") && line.contains("Capture screen") && firstScreenIndex == -1) {
                                s = line.split("\\[");
                                String[] s2 = s[2].split("\\]");
                                firstScreenIndex = Integer.parseInt(s2[0]);
                            }
                            if (cmd.contains("dshow")) {
                                if (line.contains("audio") && line.contains("\"") && !line.contains("Alternative name")) {
                                    s = line.split("\"");
                                    bytes = s[1].getBytes(StandardCharsets.ISO_8859_1);
                                    utf8EncodedString = new String(bytes, StandardCharsets.UTF_8);
                                    audioDevices.append(":" + utf8EncodedString);
                                }
                                if (line.contains("video") && line.contains("\"") && !line.contains("Alternative name") && !isAudioDevices) {
                                    s = line.split("\"");
                                    bytes = s[1].getBytes(StandardCharsets.ISO_8859_1);
                                    utf8EncodedString = new String(bytes, StandardCharsets.UTF_8);
                                    videoDevices.append(":" + utf8EncodedString);
                                }
                            }
                            FFMPEG.checkForErrors(line);
                        }
                        process.waitFor();
                        Console.consoleFFMPEG.append(System.lineSeparator());
                    }
                    catch (IOException processFFMPEG) {
                        isRunning = false;
                    }
                    catch (InterruptedException e) {
                        error = true;
                        isRunning = false;
                    }
                }
                finally {
                    isRunning = false;
                }
            }
        });
        runProcess.start();
    }

    public static void playerWaveform(String cmd) {
        try {
            if (System.getProperty("os.name").contains("Windows")) {
                ProcessBuilder processFFMPEG = new ProcessBuilder("\"" + PathToFFMPEG + "\"" + cmd + "\"");
                waveformProcess = processFFMPEG.start();
            } else {
                ProcessBuilder processFFMPEG = new ProcessBuilder("/bin/bash", "-c", PathToFFMPEG + cmd);
                waveformProcess = processFFMPEG.start();
            }
            OutputStream stdin = waveformProcess.getOutputStream();
            waveformWriter = new BufferedWriter(new OutputStreamWriter(stdin));
            InputStream is = waveformProcess.getInputStream();
            BufferedInputStream inputStream = new BufferedInputStream(is);
            VideoPlayer.waveform = ImageIO.read(inputStream);
            inputStream.close();
            waveformProcess.waitFor();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveToXML(String cmd) {
        FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("saveSettings"), 1);
        dialog.setDirectory(Functions.functionsFolder.toString());
        dialog.setLocation(FFMPEG.frame.getLocation().x - 50, FFMPEG.frame.getLocation().y + 50);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        if (dialog.getFile() != null) {
            try {
                DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element root = document.createElement("Shutter");
                document.appendChild(root);
                Element settings = document.createElement("settings");
                root.appendChild(settings);
                Attr attr = document.createAttribute("id");
                attr.setValue("10");
                settings.setAttributeNode(attr);
                String[] split = cmd.split("\"");
                String entree = split[1];
                int i = 0;
                while (++i < split.length) {
                }
                String sortie = split[i - 1];
                Element firstName = document.createElement("command");
                firstName.appendChild(document.createTextNode("ffmpeg" + cmd.replace(InputAndOutput.inPoint, "").replace(" -i ", "").replace("\"" + entree + "\"", "").replace("\"" + sortie + "\"", "").replace(" -y ", "").replace(" -n ", "")));
                settings.appendChild(firstName);
                Element lastname = document.createElement("pointIn");
                lastname.appendChild(document.createTextNode(InputAndOutput.inPoint));
                settings.appendChild(lastname);
                String ext = cmd.substring(cmd.lastIndexOf("."));
                Element email = document.createElement("extension");
                email.appendChild(document.createTextNode(ext.replace("\"", "")));
                settings.appendChild(email);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource domSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(String.valueOf(new File(dialog.getDirectory() + dialog.getFile().toString().replace(".enc", ""))) + ".enc");
                transformer.transform(domSource, streamResult);
            }
            catch (ParserConfigurationException | TransformerException exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReadable(File file) {
        try {
            String line;
            if (System.getProperty("os.name").contains("Windows")) {
                processFFMPEG = new ProcessBuilder("\"" + PathToFFMPEG + "\" -strict -2 -hide_banner -i \"" + String.valueOf(file) + "\" -t 5 -f null -\"");
                process = processFFMPEG.start();
            } else {
                processFFMPEG = new ProcessBuilder("/bin/bash", "-c", PathToFFMPEG + " -strict -2 -hide_banner -i \"" + String.valueOf(file) + "\" -t 5 -f null -");
                process = processFFMPEG.start();
            }
            Console.consoleFFMPEG.append(Shutter.language.getProperty("command") + " -strict -2 -hide_banner -i \"" + String.valueOf(file) + "\" -t 5 -f null -");
            BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            Console.consoleFFMPEG.append(System.lineSeparator());
            do {
                if ((line = input.readLine()) == null) {
                    Console.consoleFFMPEG.append(System.lineSeparator());
                    return true;
                }
                Console.consoleFFMPEG.append(line + System.lineSeparator());
                if (line.contains("No such file or directory")) return false;
                if (line.contains("Invalid data found")) return false;
                if (line.contains("moov atom not found")) return false;
                if (line.contains("Operation not permitted")) return false;
                if (line.contains("File ended prematurely")) return false;
                if (line.contains("Warning MVs not available")) return false;
                if (line.contains("broken or empty index")) return false;
                if (line.contains("corrupt decoded frame")) return false;
                if (line.contains("invalid new backstep")) return false;
                if (line.contains("Packet corrupt")) return false;
                if (line.contains("ac-tex damaged")) return false;
            } while (!line.contains("Error"));
            return false;
        }
        catch (IOException processFFMPEG) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void suspendProcess() {
        try {
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                if (NCNN.isRunning) {
                    Runtime.getRuntime().exec("kill -SIGSTOP " + NCNN.process.pid());
                } else {
                    Runtime.getRuntime().exec("kill -SIGSTOP " + process.pid());
                }
            } else {
                Object pausep = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                pausep = ((String)pausep).substring(1, ((String)pausep).length() - 1);
                pausep = "\"" + ((String)pausep).substring(0, ((String)pausep).lastIndexOf("/")).replace("%20", " ") + "/Library/pausep.exe\"";
                if (NCNN.isRunning) {
                    Runtime.getRuntime().exec((String)pausep + " " + NCNN.process.pid());
                } else {
                    Runtime.getRuntime().exec((String)pausep + " " + process.pid());
                }
            }
            if (System.getProperty("os.name").contains("Windows") && Taskbar.isTaskbarSupported()) {
                Taskbar.getTaskbar().setWindowProgressState(frame, Taskbar.State.PAUSED);
            }
        }
        catch (IOException | IllegalArgumentException | SecurityException exception) {
            // empty catch block
        }
    }

    public static void resumeProcess() {
        try {
            elapsedTime = System.currentTimeMillis() - (long)previousElapsedTime;
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                if (NCNN.isRunning) {
                    Runtime.getRuntime().exec("kill -SIGCONT " + NCNN.process.pid());
                } else {
                    Runtime.getRuntime().exec("kill -SIGCONT " + process.pid());
                }
            } else {
                Object pausep = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                pausep = ((String)pausep).substring(1, ((String)pausep).length() - 1);
                pausep = "\"" + ((String)pausep).substring(0, ((String)pausep).lastIndexOf("/")).replace("%20", " ") + "/Library/pausep.exe\"";
                if (NCNN.isRunning) {
                    Runtime.getRuntime().exec((String)pausep + " " + NCNN.process.pid() + " /r");
                } else {
                    Runtime.getRuntime().exec((String)pausep + " " + process.pid() + " /r");
                }
            }
            btnStart.setText(language.getProperty("btnPauseFunction"));
            if (System.getProperty("os.name").contains("Windows") && Taskbar.isTaskbarSupported()) {
                Taskbar.getTaskbar().setWindowProgressState(frame, Taskbar.State.NORMAL);
            }
        }
        catch (IOException | IllegalArgumentException | SecurityException exception) {
            // empty catch block
        }
    }

    private static void setProgress(String line, boolean pass2, String cmd) {
        String ffmpegTime;
        String[] split;
        String str;
        if (line.contains("Input #1")) {
            firstInput = false;
        }
        if (line.contains("Duration") && !line.contains("Duration: N/A") && !line.contains("<Duration>") && !line.contains("Segment-Durations-Ms") && firstInput) {
            float newFPS;
            str = line.substring(line.indexOf(":") + 2);
            split = str.split(",");
            ffmpegTime = split[0].replace(".", ":");
            fileLength = caseEnableSequence.isSelected() ? (int)((float)liste.getSize() / Float.parseFloat(caseSequenceFPS.getSelectedItem().toString().replace(",", "."))) : (FFPROBE.totalLength <= 40 ? Integer.parseInt(Settings.txtImageDuration.getText()) * 1000 : (VideoPlayer.playerInMark > 0 || VideoPlayer.playerOutMark < VideoPlayer.waveformContainer.getWidth() - 2 ? VideoPlayer.durationH * 3600 + VideoPlayer.durationM * 60 + VideoPlayer.durationS : FFMPEG.getTimeToSeconds(ffmpegTime)));
            if (caseConform.isSelected()) {
                newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
                if (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed"))) {
                    fileLength = (int)((float)fileLength * (FFPROBE.currentFPS / newFPS));
                } else if (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
                    fileLength = (int)((float)fileLength * (newFPS / FFPROBE.currentFPS));
                }
            }
            if (comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionConform"))) {
                newFPS = Float.parseFloat(comboFilter.getSelectedItem().toString().replace(" " + Shutter.language.getProperty("fps"), "").replace(",", "."));
                fileLength = (int)((float)fileLength * (FFPROBE.currentFPS / newFPS));
            }
            if (comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture")) && !comboFilter.getSelectedItem().toString().equals(".gif") && !Shutter.caseCreateSequence.isSelected()) {
                fileLength = 1;
            }
            if ((comboFonctions.getSelectedItem().toString().equals("H.264") || comboFonctions.getSelectedItem().toString().equals("H.265") || comboFonctions.getSelectedItem().toString().equals("H.266") || comboFonctions.getSelectedItem().toString().equals("WMV") || comboFonctions.getSelectedItem().toString().equals("MPEG-1") || comboFonctions.getSelectedItem().toString().equals("MPEG-2") || comboFonctions.getSelectedItem().toString().equals("WebM") || comboFonctions.getSelectedItem().toString().equals("AV1") || comboFonctions.getSelectedItem().toString().equals("Theora") || comboFonctions.getSelectedItem().toString().equals("MJPEG") || comboFonctions.getSelectedItem().toString().equals("Xvid") || comboFonctions.getSelectedItem().toString().equals("Blu-ray")) && case2pass.isSelected() || comboFonctions.getSelectedItem().toString().equals("DVD") && BitratesAdjustement.DVD2Pass) {
                fileLength *= 2;
            }
            if (cmd.contains("-loop")) {
                progressBar1.setMaximum(Integer.parseInt(Settings.txtImageDuration.getText()));
            } else if (!comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionInsert"))) {
                progressBar1.setMaximum(fileLength);
            }
        }
        if (!(!line.contains("time=") || line.contains("time=N/A") || lblCurrentEncoding.getText().equals(language.getProperty("lblEncodageEnCours")) || lblCurrentEncoding.getText().equals(language.getProperty("processCancelled")) || lblCurrentEncoding.getText().equals(language.getProperty("processEnded")))) {
            error = false;
            str = line.substring(line.indexOf(":") - 2);
            split = str.split("b");
            ffmpegTime = split[0].replace(".", ":").replace(" ", "");
            if (progressBar1.getString().equals("NaN") || inputDeviceIsRunning) {
                progressBar1.setStringPainted(false);
            } else {
                progressBar1.setStringPainted(true);
            }
            if (pass2) {
                progressBar1.setValue(fileLength / 2 + FFMPEG.getTimeToSeconds(ffmpegTime));
            } else {
                progressBar1.setValue(FFMPEG.getTimeToSeconds(ffmpegTime));
            }
        }
        previousElapsedTime = (int)(System.currentTimeMillis() - elapsedTime);
        int timeH = previousElapsedTime / 3600000 % 60;
        int timeMin = previousElapsedTime / 60000 % 60;
        int timeSec = previousElapsedTime / 1000 % 60;
        Object heures = "";
        Object minutes = "";
        Object secondes = "";
        heures = timeH >= 1 ? timeH + "h " : "";
        minutes = timeMin >= 1 ? timeMin + "min " : "";
        secondes = timeSec > 0 ? timeSec + "sec" : "0sec";
        tempsEcoule.setText(Shutter.language.getProperty("tempsEcoule") + " " + (String)heures + (String)minutes + (String)secondes);
        tempsEcoule.setSize(FFMPEG.tempsEcoule.getPreferredSize().width, 15);
        if ((line.contains("frame=") || line.contains("time=")) && !line.contains("time=N/A") && !comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture"))) {
            String[] split2 = line.split("=");
            int frames = 0;
            if (line.contains("frame=")) {
                frames = Integer.parseInt(split2[1].replace("fps", "").replace(" ", ""));
            } else if (line.contains("time=")) {
                String[] rawTime = split2[2].split(" ");
                String timecode = rawTime[0].replace(".", ":");
                String[] time = timecode.split(":");
                int h = Integer.parseInt(time[0]);
                int m = Integer.parseInt(time[1]);
                int s = Integer.parseInt(time[2]);
                int fps = Integer.parseInt(time[3]);
                frames = (int)((float)(h * 3600) * FFPROBE.currentFPS + (float)(m * 60) * FFPROBE.currentFPS + (float)s * FFPROBE.currentFPS + (float)fps);
            }
            if (time == 0L) {
                frame0 = frames;
                time = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - time >= 1000L && frames - frame0 > 0) {
                int total;
                if (fps == 0) {
                    fps = frames - frame0;
                } else if (frames - frame0 < fps - 100 || frames - frame0 > fps + 100) {
                    fps = frames - frame0;
                } else if (frames - frame0 > fps + 1) {
                    ++fps;
                } else if (frames - frame0 < fps - 1 && fps > 1) {
                    --fps;
                }
                time = 0L;
                if ((comboFonctions.getSelectedItem().toString().equals("H.264") || comboFonctions.getSelectedItem().toString().equals("H.265") || comboFonctions.getSelectedItem().toString().equals("H.266") || comboFonctions.getSelectedItem().toString().equals("WMV") || comboFonctions.getSelectedItem().toString().equals("MPEG-1") || comboFonctions.getSelectedItem().toString().equals("MPEG-2") || comboFonctions.getSelectedItem().toString().equals("WebM") || comboFonctions.getSelectedItem().toString().equals("AV1") || comboFonctions.getSelectedItem().toString().equals("Theora") || comboFonctions.getSelectedItem().toString().equals("MJPEG") || comboFonctions.getSelectedItem().toString().equals("Xvid") || comboFonctions.getSelectedItem().toString().equals("Blu-ray")) && case2pass.isSelected() || comboFonctions.getSelectedItem().toString().equals("DVD") && BitratesAdjustement.DVD2Pass) {
                    total = (int)((float)(fileLength / 2) * FFPROBE.currentFPS);
                } else if (caseConform.isSelected() && !comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion")) && !caseForcerEntrelacement.isSelected()) {
                    float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
                    total = (int)((float)fileLength * FFPROBE.currentFPS * (newFPS / FFPROBE.currentFPS));
                } else {
                    total = (int)((float)fileLength * FFPROBE.currentFPS);
                }
                int restant = (total - frames) / fps;
                if (!comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture")) && !comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSceneDetection"))) {
                    String pass = "";
                    if ((comboFonctions.getSelectedItem().toString().equals("H.264") || comboFonctions.getSelectedItem().toString().equals("H.265") || comboFonctions.getSelectedItem().toString().equals("H.266") || comboFonctions.getSelectedItem().toString().equals("WMV") || comboFonctions.getSelectedItem().toString().equals("MPEG-1") || comboFonctions.getSelectedItem().toString().equals("MPEG-2") || comboFonctions.getSelectedItem().toString().equals("WebM") || comboFonctions.getSelectedItem().toString().equals("AV1") || comboFonctions.getSelectedItem().toString().equals("Theora") || comboFonctions.getSelectedItem().toString().equals("MJPEG") || comboFonctions.getSelectedItem().toString().equals("Xvid") || comboFonctions.getSelectedItem().toString().equals("Blu-ray")) && case2pass.isSelected() || comboFonctions.getSelectedItem().toString().equals("DVD") && BitratesAdjustement.DVD2Pass) {
                        pass = !pass2 ? " - 1/2" : " - 2/2";
                    }
                    timeH = restant / 3600 % 60;
                    timeMin = restant / 60 % 60;
                    timeSec = restant % 60;
                    heures = timeH >= 1 ? timeH + "h " : "";
                    minutes = timeMin >= 1 ? timeMin + "min " : "";
                    secondes = timeSec > 0 ? timeSec + "sec" : "";
                    lblBy.setVisible(false);
                    tempsRestant.setText(Shutter.language.getProperty("tempsRestant") + " " + (String)heures + (String)minutes + (String)secondes + pass + " - " + fps + " " + Shutter.language.getProperty("fps"));
                    tempsRestant.setSize(FFMPEG.tempsRestant.getPreferredSize().width, 15);
                    if (heures != "" || minutes != "" || secondes != "") {
                        tempsEcoule.setVisible(false);
                        tempsRestant.setVisible(true);
                        if (tempsRestant.getX() + FFMPEG.tempsRestant.getSize().width > lblArrows.getX()) {
                            lblArrows.setVisible(false);
                        }
                    } else {
                        tempsRestant.setVisible(false);
                        lblBy.setVisible(true);
                    }
                }
            }
        }
        if (comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSceneDetection")) && line.contains("pts")) {
            DecimalFormat formatter = new DecimalFormat("00");
            String[] rawline = line.split(":");
            String[] fullTime = rawline[3].split(" ");
            int rawTime = (int)(Float.valueOf(fullTime[0]).floatValue() * 1000.0f);
            long rawFrames = Math.round((float)rawTime / (1000.0f / FFPROBE.currentFPS));
            String h = formatter.format(Math.round(rawFrames / (long)Math.round(FFPROBE.currentFPS)) / 3600);
            String m = formatter.format(Math.round(rawFrames / (long)Math.round(FFPROBE.currentFPS) / 60L) % 60);
            String s = formatter.format(Math.round(rawFrames / (long)Math.round(FFPROBE.currentFPS) % 60L));
            String f = formatter.format(rawFrames % (long)Math.round(FFPROBE.currentFPS));
            File imageName = new File(String.valueOf(SceneDetection.outputFolder) + "/" + SceneDetection.tableRow.getRowCount() + ".png");
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!imageName.exists());
            ImageIcon imageIcon = new ImageIcon(imageName.toString());
            ImageIcon icon = new ImageIcon(imageIcon.getImage().getScaledInstance(142, 80, 1));
            SceneDetection.tableRow.addRow(new Object[]{SceneDetection.tableRow.getRowCount() + 1, icon, h + ":" + m + ":" + s + ":" + f});
            SceneDetection.scrollPane.getVerticalScrollBar().setValue(SceneDetection.scrollPane.getVerticalScrollBar().getMaximum());
            SceneDetection.table.repaint();
        }
        if (line.contains("Parsed_cropdetect")) {
            cropdetect = line.substring(line.indexOf("crop=") + 5);
        }
    }

    private static void postAnalyse() {
        Object shortTermTC;
        String[] stringArray;
        if (comboFonctions.getSelectedItem().toString().equals("Loudness & True Peak") || comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionNormalization")) || caseNormalizeAudio.isSelected() && caseNormalizeAudio.isVisible()) {
            analyseLufs = "";
            stringArray = getAll.toString().substring(getAll.toString().lastIndexOf("Summary:") + 12).split(System.lineSeparator());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.contains("[out#")) break;
                analyseLufs = String.valueOf(analyseLufs) + line + System.lineSeparator();
                ++n2;
            }
            shortTermValues = new StringBuilder();
            float momentaryTerm = -1000.0f;
            Object momentaryTermTC = "";
            float shortTerm = -1000.0f;
            shortTermTC = "";
            String[] stringArray2 = getAll.toString().split(System.lineSeparator());
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String allValues = stringArray2[n4];
                if (allValues.contains("Parsed_ebur128") && !allValues.contains("Summary:")) {
                    String[] spliter = allValues.split(":");
                    DecimalFormat round = new DecimalFormat("0.##");
                    String[] splitTime = spliter[1].split(" ");
                    int temps = (int)(Float.parseFloat(round.format(Double.valueOf(splitTime[1].replace(",", ""))).replace(",", ".")) * 1000.0f);
                    DecimalFormat formatter = new DecimalFormat("00");
                    String h = formatter.format(temps / 3600000);
                    String m = formatter.format(temps / 60000 % 60);
                    String s = formatter.format(temps / 1000 % 60);
                    String f = formatter.format((int)((float)temps / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS));
                    String timecode = h + ":" + m + ":" + s + ":" + f;
                    String values = allValues.substring(allValues.indexOf("M"));
                    String[] v = values.split(":");
                    try {
                        float S;
                        float M = Float.parseFloat(v[1].replace(" S", ""));
                        if (M > momentaryTerm) {
                            momentaryTerm = M;
                            momentaryTermTC = timecode;
                        }
                        if ((S = Float.parseFloat(v[2].replace("     I", ""))) > shortTerm) {
                            shortTerm = S;
                            shortTermTC = timecode;
                        }
                        if ((double)S > -16.0) {
                            shortTermValues.append(timecode + ": Short-term: " + S + " LUFS" + System.lineSeparator());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n4;
            }
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "  Momentary max: " + momentaryTerm + " LUFS";
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "    Timecode:     " + (String)momentaryTermTC;
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator();
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "  Short-term max: " + shortTerm + " LUFS";
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "    Timecode:     " + (String)shortTermTC;
            if (shortTermValues.length() == 0) {
                shortTermValues.append(Shutter.language.getProperty("shortTerm"));
            }
            if (lblCurrentEncoding.getText().contains(Shutter.language.getProperty("analyzing"))) {
                String[] lufs = analyseLufs.split(":");
                String[] lufsFinal = lufs[2].split("L");
                String[] db = comboFilter.getSelectedItem().toString().split(" ");
                if (!comboFonctions.getSelectedItem().toString().equals("Loudness & True Peak") && !comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionNormalization"))) {
                    db = comboNormalizeAudio.getSelectedItem().toString().split(" ");
                }
                newVolume = Float.parseFloat(db[0]) - Float.parseFloat(lufsFinal[0].replace(" ", ""));
            }
        }
        if (comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionBlackDetection"))) {
            blackFrame = new StringBuilder();
            shortTermTC = getAll.toString().split(System.lineSeparator());
            int shortTerm = ((String[])shortTermTC).length;
            int momentaryTermTC = 0;
            while (momentaryTermTC < shortTerm) {
                String blackLine = shortTermTC[momentaryTermTC];
                if (blackLine.contains("blackdetect") && !blackLine.contains("black_start:0")) {
                    String blackdetect = blackLine.substring(blackLine.indexOf("black_start"));
                    String[] d = blackdetect.split(":");
                    String blackstart = d[1].replace(" black_end", "");
                    String[] bsDuree = blackstart.split("\\.");
                    int secondes = Integer.valueOf(bsDuree[0]);
                    int images = 0;
                    DecimalFormat formatter = new DecimalFormat("00");
                    String tcBlackFrame = formatter.format(secondes / 3600) + ":" + formatter.format(secondes / 60 % 60) + ":" + formatter.format(secondes % 60);
                    switch (bsDuree[1].length()) {
                        case 1: {
                            images = Integer.valueOf(bsDuree[1]) * 100;
                            break;
                        }
                        case 2: {
                            images = Integer.valueOf(bsDuree[1]) * 10;
                            break;
                        }
                        case 3: {
                            images = Integer.valueOf(bsDuree[1]);
                        }
                    }
                    tcBlackFrame = tcBlackFrame + ":" + formatter.format((int)((float)images / (1000.0f / FFPROBE.currentFPS)));
                    blackFrame.append(tcBlackFrame + System.lineSeparator());
                }
                ++momentaryTermTC;
            }
        }
        if (comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionOfflineDetection"))) {
            mediaOfflineFrame = new StringBuilder();
            File stats_file = System.getProperty("os.name").contains("Windows") ? new File("stats_file") : new File(Shutter.dirTemp + "stats_file");
            if (stats_file.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(stats_file.toString()));
                    boolean offline = false;
                    Float mseValue = Float.valueOf(0.0f);
                    String line = reader.readLine();
                    while (line != null) {
                        if (line.contains("mse_avg")) {
                            String[] s = line.split(":");
                            String[] m = s[2].split(" ");
                            Float mse = Float.valueOf(Float.parseFloat(m[0]));
                            String[] f = s[1].split(" ");
                            String frame = f[0];
                            int frameNumber = Integer.parseInt(frame) - 2;
                            if (mse.floatValue() <= mseSensibility.floatValue() && !offline) {
                                if (mseValue.floatValue() == mse.floatValue()) {
                                    offline = true;
                                    DecimalFormat formatter = new DecimalFormat("00");
                                    String tcOfflineFrame = formatter.format(Math.floor((float)frameNumber / FFPROBE.currentFPS) / 3600.0) + ":" + formatter.format(Math.floor((float)frameNumber / FFPROBE.currentFPS / 60.0f) % 60.0) + ":" + formatter.format(Math.floor((float)frameNumber / FFPROBE.currentFPS) % 60.0) + ":" + formatter.format((float)frameNumber % FFPROBE.currentFPS);
                                    mediaOfflineFrame.append(tcOfflineFrame + System.lineSeparator());
                                }
                                mseValue = mse;
                            } else if (mse.floatValue() > mseSensibility.floatValue()) {
                                offline = false;
                                mseValue = Float.valueOf(0.0f);
                            }
                        }
                        line = reader.readLine();
                    }
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                stats_file.delete();
            }
        }
        if (comboFonctions.getSelectedItem().toString().equals("VMAF")) {
            VMAFScore = "";
            stringArray = getAll.toString().split(System.lineSeparator());
            int n = stringArray.length;
            int n5 = 0;
            while (n5 < n) {
                String vmafLine = stringArray[n5];
                if (vmafLine.contains("VMAF score")) {
                    String[] s = vmafLine.split("\\]");
                    VMAFScore = s[1].substring(1);
                }
                ++n5;
            }
        }
    }

    public static int getTimeToSeconds(String time) {
        String[] t = time.split(":");
        int heures = Integer.parseInt(t[0]);
        int minutes = Integer.parseInt(t[1]);
        int secondes = Integer.parseInt(t[2]);
        int images = Integer.parseInt(t[3]);
        images /= 40;
        int totalSecondes = heures * 3600 + minutes * 60 + secondes;
        return totalSecondes;
    }
}

