/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.Shutter;
import java.io.File;
import library.FFMPEG;
import library.FFPROBE;
import settings.InputAndOutput;

public class Corrections
extends Shutter {
    public static File vidstab = null;

    public static String setStabilisation(String filterComplex, File file, String fichier, String concat) throws InterruptedException {
        if (Shutter.caseStabilisation.isSelected()) {
            vidstab = System.getProperty("os.name").contains("Windows") ? new File("vidstab.trf") : new File(Shutter.dirTemp + "vidstab.trf");
            lblCurrentEncoding.setText(Shutter.language.getProperty("analyzeOf") + " " + fichier);
            String cmd = System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux") ? " -an -pix_fmt yuv420p -f yuv4mpegpipe - | PathToFFMPEG -i pipe:0 -vf vidstabdetect=result=" + vidstab.toString() + " -y -f null -" : " -an -pix_fmt yuv420p -f yuv4mpegpipe - | PathToFFMPEG -i pipe:0 -vf vidstabdetect=result=" + vidstab.toString() + " -y -f null -\"";
            FFMPEG.run(InputAndOutput.inPoint + concat + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd);
            do {
                Thread.sleep(100L);
            } while (FFMPEG.runProcess.isAlive());
            if (filterComplex != "") {
                filterComplex = (String)filterComplex + ",";
            }
            filterComplex = (String)filterComplex + "vidstabtransform=input=" + vidstab.toString();
            lblCurrentEncoding.setText(fichier);
        }
        return filterComplex;
    }

    public static String setDeflicker(String filterComplex) {
        if (Shutter.caseDeflicker.isSelected()) {
            if (filterComplex != "") {
                filterComplex = (String)filterComplex + ",";
            }
            filterComplex = (String)filterComplex + "split[a][b];[b]setpts=PTS-STARTPTS+" + 1.0f / FFPROBE.currentFPS + "/TB,format=rgba,colorchannelmixer=aa=0.5[deflicker];[a][deflicker]overlay=shortest=1";
        }
        return filterComplex;
    }

    public static String setDeband(String filterComplex) {
        if (Shutter.caseBanding.isSelected()) {
            if (filterComplex != "") {
                filterComplex = (String)filterComplex + ",";
            }
            filterComplex = (String)filterComplex + "deband=r=32";
        }
        return filterComplex;
    }

    public static String setLimiter(String filterComplex) {
        if (Shutter.caseLimiter.isSelected()) {
            if (filterComplex != "") {
                filterComplex = (String)filterComplex + ",";
            }
            if (FFPROBE.imageDepth == 8) {
                filterComplex = (String)filterComplex + "limiter=16:235";
            } else if (FFPROBE.imageDepth == 10) {
                filterComplex = (String)filterComplex + "limiter=64:940";
            } else if (FFPROBE.imageDepth == 12) {
                filterComplex = (String)filterComplex + "limiter=256:3760";
            } else if (FFPROBE.imageDepth == 16) {
                filterComplex = (String)filterComplex + "limiter=4096:60160";
            }
        }
        return filterComplex;
    }

    public static String setDetails(String filterComplex) {
        if (Shutter.caseDetails.isSelected()) {
            float value = 0.0f - (float)Shutter.sliderDetails.getValue() / 10.0f;
            if (filterComplex != "") {
                filterComplex = (String)filterComplex + ",";
            }
            filterComplex = (String)filterComplex + "smartblur=1.0:" + value;
        }
        return filterComplex;
    }

    public static String setDenoiser(String filterComplex) {
        if (Shutter.caseDenoise.isSelected()) {
            int value = Shutter.sliderDenoise.getValue();
            if (filterComplex != "") {
                filterComplex = (String)filterComplex + ",";
            }
            filterComplex = (String)filterComplex + "hqdn3d=" + value + ":" + value + ":" + value + ":" + value;
        }
        return filterComplex;
    }

    public static String setSmoothExposure(String filterComplex) {
        if (Shutter.caseSmoothExposure.isSelected()) {
            int value = Shutter.sliderSmoothExposure.getValue();
            if (filterComplex != "") {
                filterComplex = (String)filterComplex + ",";
            }
            filterComplex = (String)filterComplex + "deflicker=s=" + Math.ceil(128 * value / 100 + 1);
        }
        return filterComplex;
    }
}

