(function(self) {
  var Module = self.Mp3LameEncoderConfig;

// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = (typeof Module !== 'undefined' ? Module : null) || {};

// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}

// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function' && !ENVIRONMENT_IS_WEB;
// Three configurations we can be running in:
// 1) We could be the application main() thread running in the main JS UI thread. (ENVIRONMENT_IS_WORKER == false and ENVIRONMENT_IS_PTHREAD == false)
// 2) We could be the application main() thread proxied to worker. (with Emscripten -s PROXY_TO_WORKER=1) (ENVIRONMENT_IS_WORKER == true, ENVIRONMENT_IS_PTHREAD == false)
// 3) We could be an application pthread running in a worker. (ENVIRONMENT_IS_WORKER == true and ENVIRONMENT_IS_PTHREAD == true)
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;

if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  if (!Module['print']) Module['print'] = function print(x) {
    process['stdout'].write(x + '\n');
  };
  if (!Module['printErr']) Module['printErr'] = function printErr(x) {
    process['stderr'].write(x + '\n');
  };

  var nodeFS = require('fs');
  var nodePath = require('path');

  Module['read'] = function read(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };

  Module['readBinary'] = function readBinary(filename) { return Module['read'](filename, true) };

  Module['load'] = function load(f) {
    globalEval(read(f));
  };

  if (!Module['thisProgram']) {
    if (process['argv'].length > 1) {
      Module['thisProgram'] = process['argv'][1].replace(/\\/g, '/');
    } else {
      Module['thisProgram'] = 'unknown-program';
    }
  }

  Module['arguments'] = process['argv'].slice(2);

  if (typeof module !== 'undefined') {
    module['exports'] = Module;
  }

  process['on']('uncaughtException', function(ex) {
    // suppress ExitStatus exceptions from showing an error
    if (!(ex instanceof ExitStatus)) {
      throw ex;
    }
  });

  Module['inspect'] = function () { return '[Emscripten Module object]'; };
}
else if (ENVIRONMENT_IS_SHELL) {
  if (!Module['print']) Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm

  if (typeof read != 'undefined') {
    Module['read'] = read;
  } else {
    Module['read'] = function read() { throw 'no read() available (jsc?)' };
  }

  Module['readBinary'] = function readBinary(f) {
    if (typeof readbuffer === 'function') {
      return new Uint8Array(readbuffer(f));
    }
    var data = read(f, 'binary');
    assert(typeof data === 'object');
    return data;
  };

  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

}
else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function read(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };

  if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

  if (typeof console !== 'undefined') {
    if (!Module['print']) Module['print'] = function print(x) {
      console.log(x);
    };
    if (!Module['printErr']) Module['printErr'] = function printErr(x) {
      console.log(x);
    };
  } else {
    // Probably a worker, and without console.log. We can do very little here...
    var TRY_USE_DUMP = false;
    if (!Module['print']) Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }

  if (ENVIRONMENT_IS_WORKER) {
    Module['load'] = importScripts;
  }

  if (typeof Module['setWindowTitle'] === 'undefined') {
    Module['setWindowTitle'] = function(title) { document.title = title };
  }
}
else {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}

function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] && Module['read']) {
  Module['load'] = function load(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
if (!Module['thisProgram']) {
  Module['thisProgram'] = './this.program';
}

// *** Environment setup code ***

// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];

// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];

// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}



// === Preamble library stuff ===

// Documentation for the public APIs defined in this file must be updated in: 
//    site/source/docs/api_reference/preamble.js.rst
// A prebuilt local version of the documentation is available at: 
//    site/build/text/docs/api_reference/preamble.js.txt
// You can also build docs locally as HTML or other formats in site/
// An online HTML version (which may be of a different version of Emscripten)
//    is up at http://kripken.github.io/emscripten-site/docs/api_reference/preamble.js.html

//========================================
// Runtime code shared with compiler
//========================================

var Runtime = {
  setTempRet0: function (value) {
    tempRet0 = value;
  },
  getTempRet0: function () {
    return tempRet0;
  },
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  getNativeTypeSize: function (type) {
    switch (type) {
      case 'i1': case 'i8': return 1;
      case 'i16': return 2;
      case 'i32': return 4;
      case 'i64': return 8;
      case 'float': return 4;
      case 'double': return 8;
      default: {
        if (type[type.length-1] === '*') {
          return Runtime.QUANTUM_SIZE; // A pointer
        } else if (type[0] === 'i') {
          var bits = parseInt(type.substr(1));
          assert(bits % 8 === 0);
          return bits/8;
        } else {
          return 0;
        }
      }
    }
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  STACK_ALIGN: 16,
  prepVararg: function (ptr, type) {
    if (type === 'double' || type === 'i64') {
      // move so the load is aligned
      if (ptr & 7) {
        assert((ptr & 7) === 4);
        ptr += 4;
      }
    } else {
      assert((ptr & 3) === 0);
    }
    return ptr;
  },
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (!vararg && (type == 'i64' || type == 'double')) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2*(1 + i);
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[sig]) {
      Runtime.funcWrappers[sig] = {};
    }
    var sigCache = Runtime.funcWrappers[sig];
    if (!sigCache[func]) {
      sigCache[func] = function dynCall_wrapper() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return sigCache[func];
  },
  getCompilerSetting: function (name) {
    throw 'You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work';
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = (((STACKTOP)+15)&-16); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = (((STATICTOP)+15)&-16); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = (((DYNAMICTOP)+15)&-16); if (DYNAMICTOP >= TOTAL_MEMORY) { var success = enlargeMemory(); if (!success) { DYNAMICTOP = ret; return 0; } }; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 16))*(quantum ? quantum : 16); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+((low>>>0)))+((+((high>>>0)))*4294967296.0)) : ((+((low>>>0)))+((+((high|0)))*4294967296.0))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}


Module['Runtime'] = Runtime;



//========================================
// Runtime essentials
//========================================

var __THREW__ = 0; // Used in checking for thrown exceptions.

var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;

var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD, tempDouble, tempFloat;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;

function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}

var globalScope = this;

// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  var func = Module['_' + ident]; // closure exported function
  if (!func) {
    try {
      func = eval('_' + ident); // explicit lookup
    } catch(e) {}
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}

var cwrap, ccall;
(function(){
  var JSfuncs = {
    // Helpers for cwrap -- it can't refer to Runtime directly because it might
    // be renamed by closure, instead it calls JSfuncs['stackSave'].body to find
    // out what the minified function name is.
    'stackSave': function() {
      Runtime.stackSave()
    },
    'stackRestore': function() {
      Runtime.stackRestore()
    },
    // type conversion from js to c
    'arrayToC' : function(arr) {
      var ret = Runtime.stackAlloc(arr.length);
      writeArrayToMemory(arr, ret);
      return ret;
    },
    'stringToC' : function(str) {
      var ret = 0;
      if (str !== null && str !== undefined && str !== 0) { // null string
        // at most 4 bytes per UTF-8 code point, +1 for the trailing '\0'
        ret = Runtime.stackAlloc((str.length << 2) + 1);
        writeStringToMemory(str, ret);
      }
      return ret;
    }
  };
  // For fast lookup of conversion functions
  var toC = {'string' : JSfuncs['stringToC'], 'array' : JSfuncs['arrayToC']};

  // C calling interface. 
  ccall = function ccallFunc(ident, returnType, argTypes, args, opts) {
    var func = getCFunc(ident);
    var cArgs = [];
    var stack = 0;
    if (args) {
      for (var i = 0; i < args.length; i++) {
        var converter = toC[argTypes[i]];
        if (converter) {
          if (stack === 0) stack = Runtime.stackSave();
          cArgs[i] = converter(args[i]);
        } else {
          cArgs[i] = args[i];
        }
      }
    }
    var ret = func.apply(null, cArgs);
    if (returnType === 'string') ret = Pointer_stringify(ret);
    if (stack !== 0) {
      if (opts && opts.async) {
        EmterpreterAsync.asyncFinalizers.push(function() {
          Runtime.stackRestore(stack);
        });
        return;
      }
      Runtime.stackRestore(stack);
    }
    return ret;
  }

  var sourceRegex = /^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;
  function parseJSFunc(jsfunc) {
    // Match the body and the return value of a javascript function source
    var parsed = jsfunc.toString().match(sourceRegex).slice(1);
    return {arguments : parsed[0], body : parsed[1], returnValue: parsed[2]}
  }
  var JSsource = {};
  for (var fun in JSfuncs) {
    if (JSfuncs.hasOwnProperty(fun)) {
      // Elements of toCsource are arrays of three items:
      // the code, and the return value
      JSsource[fun] = parseJSFunc(JSfuncs[fun]);
    }
  }

  
  cwrap = function cwrap(ident, returnType, argTypes) {
    argTypes = argTypes || [];
    var cfunc = getCFunc(ident);
    // When the function takes numbers and returns a number, we can just return
    // the original function
    var numericArgs = argTypes.every(function(type){ return type === 'number'});
    var numericRet = (returnType !== 'string');
    if ( numericRet && numericArgs) {
      return cfunc;
    }
    // Creation of the arguments list (["$1","$2",...,"$nargs"])
    var argNames = argTypes.map(function(x,i){return '$'+i});
    var funcstr = "(function(" + argNames.join(',') + ") {";
    var nargs = argTypes.length;
    if (!numericArgs) {
      // Generate the code needed to convert the arguments from javascript
      // values to pointers
      funcstr += 'var stack = ' + JSsource['stackSave'].body + ';';
      for (var i = 0; i < nargs; i++) {
        var arg = argNames[i], type = argTypes[i];
        if (type === 'number') continue;
        var convertCode = JSsource[type + 'ToC']; // [code, return]
        funcstr += 'var ' + convertCode.arguments + ' = ' + arg + ';';
        funcstr += convertCode.body + ';';
        funcstr += arg + '=' + convertCode.returnValue + ';';
      }
    }

    // When the code is compressed, the name of cfunc is not literally 'cfunc' anymore
    var cfuncname = parseJSFunc(function(){return cfunc}).returnValue;
    // Call the function
    funcstr += 'var ret = ' + cfuncname + '(' + argNames.join(',') + ');';
    if (!numericRet) { // Return type can only by 'string' or 'number'
      // Convert the result to a string
      var strgfy = parseJSFunc(function(){return Pointer_stringify}).returnValue;
      funcstr += 'ret = ' + strgfy + '(ret);';
    }
    if (!numericArgs) {
      // If we had a stack, restore it
      funcstr += JSsource['stackRestore'].body.replace('()', '(stack)') + ';';
    }
    funcstr += 'return ret})';
    return eval(funcstr);
  };
})();
Module["cwrap"] = cwrap;
Module["ccall"] = ccall;


function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[((ptr)>>0)]=value; break;
      case 'i8': HEAP8[((ptr)>>0)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math_abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math_min((+(Math_floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;


function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[((ptr)>>0)];
      case 'i8': return HEAP8[((ptr)>>0)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;

var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;

// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }

  var singleType = typeof types === 'string' ? types : null;

  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }

  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)>>0)]=0;
    }
    return ret;
  }

  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }

  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];

    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }

    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }

    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later

    setValue(ret+i, curr, type);

    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }

  return ret;
}
Module['allocate'] = allocate;

// Allocate memory during any stage of startup - static memory early on, dynamic memory later, malloc when ready
function getMemory(size) {
  if (!staticSealed) return Runtime.staticAlloc(size);
  if ((typeof _sbrk !== 'undefined' && !_sbrk.called) || !runtimeInitialized) return Runtime.dynamicAlloc(size);
  return _malloc(size);
}
Module['getMemory'] = getMemory;

function Pointer_stringify(ptr, /* optional */ length) {
  if (length === 0 || !ptr) return '';
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = 0;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))>>0)];
    hasUtf |= t;
    if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;

  var ret = '';

  if (hasUtf < 128) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  return Module['UTF8ToString'](ptr);
}
Module['Pointer_stringify'] = Pointer_stringify;

// Given a pointer 'ptr' to a null-terminated ASCII-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function AsciiToString(ptr) {
  var str = '';
  while (1) {
    var ch = HEAP8[((ptr++)>>0)];
    if (!ch) return str;
    str += String.fromCharCode(ch);
  }
}
Module['AsciiToString'] = AsciiToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in ASCII form. The copy will require at most str.length+1 bytes of space in the HEAP.

function stringToAscii(str, outPtr) {
  return writeAsciiToMemory(str, outPtr, false);
}
Module['stringToAscii'] = stringToAscii;

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the given array that contains uint8 values, returns
// a copy of that string as a Javascript String object.

function UTF8ArrayToString(u8Array, idx) {
  var u0, u1, u2, u3, u4, u5;

  var str = '';
  while (1) {
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    u0 = u8Array[idx++];
    if (!u0) return str;
    if (!(u0 & 0x80)) { str += String.fromCharCode(u0); continue; }
    u1 = u8Array[idx++] & 63;
    if ((u0 & 0xE0) == 0xC0) { str += String.fromCharCode(((u0 & 31) << 6) | u1); continue; }
    u2 = u8Array[idx++] & 63;
    if ((u0 & 0xF0) == 0xE0) {
      u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
    } else {
      u3 = u8Array[idx++] & 63;
      if ((u0 & 0xF8) == 0xF0) {
        u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | u3;
      } else {
        u4 = u8Array[idx++] & 63;
        if ((u0 & 0xFC) == 0xF8) {
          u0 = ((u0 & 3) << 24) | (u1 << 18) | (u2 << 12) | (u3 << 6) | u4;
        } else {
          u5 = u8Array[idx++] & 63;
          u0 = ((u0 & 1) << 30) | (u1 << 24) | (u2 << 18) | (u3 << 12) | (u4 << 6) | u5;
        }
      }
    }
    if (u0 < 0x10000) {
      str += String.fromCharCode(u0);
    } else {
      var ch = u0 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    }
  }
}
Module['UTF8ArrayToString'] = UTF8ArrayToString;

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function UTF8ToString(ptr) {
  return UTF8ArrayToString(HEAPU8, ptr);
}
Module['UTF8ToString'] = UTF8ToString;

// Copies the given Javascript String object 'str' to the given byte array at address 'outIdx',
// encoded in UTF8 form and null-terminated. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outU8Array: the array to copy to. Each index in this array is assumed to be one 8-byte element.
//   outIdx: The starting offset in the array to begin the copying.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=1, only the null terminator will be written and nothing else.
//                    maxBytesToWrite=0 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8Array(str, outU8Array, outIdx, maxBytesToWrite) {
  if (!(maxBytesToWrite > 0)) // Parameter maxBytesToWrite is not optional. Negative values, 0, null, undefined and false each don't write out any bytes.
    return 0;

  var startIdx = outIdx;
  var endIdx = outIdx + maxBytesToWrite - 1; // -1 for string null terminator.
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      if (outIdx >= endIdx) break;
      outU8Array[outIdx++] = u;
    } else if (u <= 0x7FF) {
      if (outIdx + 1 >= endIdx) break;
      outU8Array[outIdx++] = 0xC0 | (u >> 6);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0xFFFF) {
      if (outIdx + 2 >= endIdx) break;
      outU8Array[outIdx++] = 0xE0 | (u >> 12);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x1FFFFF) {
      if (outIdx + 3 >= endIdx) break;
      outU8Array[outIdx++] = 0xF0 | (u >> 18);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x3FFFFFF) {
      if (outIdx + 4 >= endIdx) break;
      outU8Array[outIdx++] = 0xF8 | (u >> 24);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else {
      if (outIdx + 5 >= endIdx) break;
      outU8Array[outIdx++] = 0xFC | (u >> 30);
      outU8Array[outIdx++] = 0x80 | ((u >> 24) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    }
  }
  // Null-terminate the pointer to the buffer.
  outU8Array[outIdx] = 0;
  return outIdx - startIdx;
}
Module['stringToUTF8Array'] = stringToUTF8Array;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF8 form. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8(str, outPtr, maxBytesToWrite) {
  return stringToUTF8Array(str, HEAPU8, outPtr, maxBytesToWrite);
}
Module['stringToUTF8'] = stringToUTF8;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF8 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF8(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      ++len;
    } else if (u <= 0x7FF) {
      len += 2;
    } else if (u <= 0xFFFF) {
      len += 3;
    } else if (u <= 0x1FFFFF) {
      len += 4;
    } else if (u <= 0x3FFFFFF) {
      len += 5;
    } else {
      len += 6;
    }
  }
  return len;
}
Module['lengthBytesUTF8'] = lengthBytesUTF8;

// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function UTF16ToString(ptr) {
  var i = 0;

  var str = '';
  while (1) {
    var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
    if (codeUnit == 0)
      return str;
    ++i;
    // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
    str += String.fromCharCode(codeUnit);
  }
}
Module['UTF16ToString'] = UTF16ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF16 form. The copy will require at most str.length*4+2 bytes of space in the HEAP.
// Use the function lengthBytesUTF16() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=2, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<2 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF16(str, outPtr, maxBytesToWrite) {
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 2) return 0;
  maxBytesToWrite -= 2; // Null terminator.
  var startPtr = outPtr;
  var numCharsToWrite = (maxBytesToWrite < str.length*2) ? (maxBytesToWrite / 2) : str.length;
  for (var i = 0; i < numCharsToWrite; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[((outPtr)>>1)]=codeUnit;
    outPtr += 2;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[((outPtr)>>1)]=0;
  return outPtr - startPtr;
}
Module['stringToUTF16'] = stringToUTF16;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF16(str) {
  return str.length*2;
}
Module['lengthBytesUTF16'] = lengthBytesUTF16;

function UTF32ToString(ptr) {
  var i = 0;

  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}
Module['UTF32ToString'] = UTF32ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF32 form. The copy will require at most str.length*4+4 bytes of space in the HEAP.
// Use the function lengthBytesUTF32() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=4, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<4 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF32(str, outPtr, maxBytesToWrite) {
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 4) return 0;
  var startPtr = outPtr;
  var endPtr = startPtr + maxBytesToWrite - 4;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++i);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[((outPtr)>>2)]=codeUnit;
    outPtr += 4;
    if (outPtr + 4 > endPtr) break;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[((outPtr)>>2)]=0;
  return outPtr - startPtr;
}
Module['stringToUTF32'] = stringToUTF32;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF32(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i);
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) ++i; // possibly a lead surrogate, so skip over the tail surrogate.
    len += 4;
  }

  return len;
}
Module['lengthBytesUTF32'] = lengthBytesUTF32;

function demangle(func) {
  var hasLibcxxabi = !!Module['___cxa_demangle'];
  if (hasLibcxxabi) {
    try {
      var buf = _malloc(func.length);
      writeStringToMemory(func.substr(1), buf);
      var status = _malloc(4);
      var ret = Module['___cxa_demangle'](buf, 0, 0, status);
      if (getValue(status, 'i32') === 0 && ret) {
        return Pointer_stringify(ret);
      }
      // otherwise, libcxxabi failed, we can try ours which may return a partial result
    } catch(e) {
      // failure when using libcxxabi, we can try ours which may return a partial result
    } finally {
      if (buf) _free(buf);
      if (status) _free(status);
      if (ret) _free(ret);
    }
  }
  var i = 3;
  // params, etc.
  var basicTypes = {
    'v': 'void',
    'b': 'bool',
    'c': 'char',
    's': 'short',
    'i': 'int',
    'l': 'long',
    'f': 'float',
    'd': 'double',
    'w': 'wchar_t',
    'a': 'signed char',
    'h': 'unsigned char',
    't': 'unsigned short',
    'j': 'unsigned int',
    'm': 'unsigned long',
    'x': 'long long',
    'y': 'unsigned long long',
    'z': '...'
  };
  var subs = [];
  var first = true;
  function dump(x) {
    //return;
    if (x) Module.print(x);
    Module.print(func);
    var pre = '';
    for (var a = 0; a < i; a++) pre += ' ';
    Module.print (pre + '^');
  }
  function parseNested() {
    i++;
    if (func[i] === 'K') i++; // ignore const
    var parts = [];
    while (func[i] !== 'E') {
      if (func[i] === 'S') { // substitution
        i++;
        var next = func.indexOf('_', i);
        var num = func.substring(i, next) || 0;
        parts.push(subs[num] || '?');
        i = next+1;
        continue;
      }
      if (func[i] === 'C') { // constructor
        parts.push(parts[parts.length-1]);
        i += 2;
        continue;
      }
      var size = parseInt(func.substr(i));
      var pre = size.toString().length;
      if (!size || !pre) { i--; break; } // counter i++ below us
      var curr = func.substr(i + pre, size);
      parts.push(curr);
      subs.push(curr);
      i += pre + size;
    }
    i++; // skip E
    return parts;
  }
  function parse(rawList, limit, allowVoid) { // main parser
    limit = limit || Infinity;
    var ret = '', list = [];
    function flushList() {
      return '(' + list.join(', ') + ')';
    }
    var name;
    if (func[i] === 'N') {
      // namespaced N-E
      name = parseNested().join('::');
      limit--;
      if (limit === 0) return rawList ? [name] : name;
    } else {
      // not namespaced
      if (func[i] === 'K' || (first && func[i] === 'L')) i++; // ignore const and first 'L'
      var size = parseInt(func.substr(i));
      if (size) {
        var pre = size.toString().length;
        name = func.substr(i + pre, size);
        i += pre + size;
      }
    }
    first = false;
    if (func[i] === 'I') {
      i++;
      var iList = parse(true);
      var iRet = parse(true, 1, true);
      ret += iRet[0] + ' ' + name + '<' + iList.join(', ') + '>';
    } else {
      ret = name;
    }
    paramLoop: while (i < func.length && limit-- > 0) {
      //dump('paramLoop');
      var c = func[i++];
      if (c in basicTypes) {
        list.push(basicTypes[c]);
      } else {
        switch (c) {
          case 'P': list.push(parse(true, 1, true)[0] + '*'); break; // pointer
          case 'R': list.push(parse(true, 1, true)[0] + '&'); break; // reference
          case 'L': { // literal
            i++; // skip basic type
            var end = func.indexOf('E', i);
            var size = end - i;
            list.push(func.substr(i, size));
            i += size + 2; // size + 'EE'
            break;
          }
          case 'A': { // array
            var size = parseInt(func.substr(i));
            i += size.toString().length;
            if (func[i] !== '_') throw '?';
            i++; // skip _
            list.push(parse(true, 1, true)[0] + ' [' + size + ']');
            break;
          }
          case 'E': break paramLoop;
          default: ret += '?' + c; break paramLoop;
        }
      }
    }
    if (!allowVoid && list.length === 1 && list[0] === 'void') list = []; // avoid (void)
    if (rawList) {
      if (ret) {
        list.push(ret + '?');
      }
      return list;
    } else {
      return ret + flushList();
    }
  }
  var parsed = func;
  try {
    // Special-case the entry point, since its name differs from other name mangling.
    if (func == 'Object._main' || func == '_main') {
      return 'main()';
    }
    if (typeof func === 'number') func = Pointer_stringify(func);
    if (func[0] !== '_') return func;
    if (func[1] !== '_') return func; // C function
    if (func[2] !== 'Z') return func;
    switch (func[3]) {
      case 'n': return 'operator new()';
      case 'd': return 'operator delete()';
    }
    parsed = parse();
  } catch(e) {
    parsed += '?';
  }
  if (parsed.indexOf('?') >= 0 && !hasLibcxxabi) {
    Runtime.warnOnce('warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling');
  }
  return parsed;
}

function demangleAll(text) {
  return text.replace(/__Z[\w\d_]+/g, function(x) { var y = demangle(x); return x === y ? x : (x + ' [' + y + ']') });
}

function jsStackTrace() {
  var err = new Error();
  if (!err.stack) {
    // IE10+ special cases: It does have callstack info, but it is only populated if an Error object is thrown,
    // so try that as a special-case.
    try {
      throw new Error(0);
    } catch(e) {
      err = e;
    }
    if (!err.stack) {
      return '(no stack trace available)';
    }
  }
  return err.stack.toString();
}

function stackTrace() {
  return demangleAll(jsStackTrace());
}
Module['stackTrace'] = stackTrace;

// Memory management

var PAGE_SIZE = 4096;

function alignMemoryPage(x) {
  if (x % 4096 > 0) {
    x += (4096 - (x % 4096));
  }
  return x;
}

var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;

var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk


function enlargeMemory() {
  abort('Cannot enlarge memory arrays. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value ' + TOTAL_MEMORY + ', (2) compile with ALLOW_MEMORY_GROWTH which adjusts the size at runtime but prevents some optimizations, or (3) set Module.TOTAL_MEMORY before the program runs.');
}


var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;

var totalMemory = 64*1024;
while (totalMemory < TOTAL_MEMORY || totalMemory < 2*TOTAL_STACK) {
  if (totalMemory < 16*1024*1024) {
    totalMemory *= 2;
  } else {
    totalMemory += 16*1024*1024
  }
}
if (totalMemory !== TOTAL_MEMORY) {
  Module.printErr('increasing TOTAL_MEMORY to ' + totalMemory + ' to be compliant with the asm.js spec (and given that TOTAL_STACK=' + TOTAL_STACK + ')');
  TOTAL_MEMORY = totalMemory;
}

// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'JS engine does not provide full typed array support');

var buffer;
buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);

// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');

Module['HEAP'] = HEAP;
Module['buffer'] = buffer;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;

function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}

var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited

var runtimeInitialized = false;
var runtimeExited = false;


function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}

function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}

function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}

function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
  runtimeExited = true;
}

function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}

function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module['addOnPreRun'] = Module.addOnPreRun = addOnPreRun;

function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module['addOnInit'] = Module.addOnInit = addOnInit;

function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module['addOnPreMain'] = Module.addOnPreMain = addOnPreMain;

function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module['addOnExit'] = Module.addOnExit = addOnExit;

function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module['addOnPostRun'] = Module.addOnPostRun = addOnPostRun;

// Tools


function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var len = length > 0 ? length : lengthBytesUTF8(stringy)+1;
  var u8array = new Array(len);
  var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
  if (dontAddNull) u8array.length = numBytesWritten;
  return u8array;
}
Module['intArrayFromString'] = intArrayFromString;

function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;

function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))>>0)]=chr;
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;

function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[((buffer++)>>0)]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;

function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; ++i) {
    HEAP8[((buffer++)>>0)]=str.charCodeAt(i);
  }
  // Null-terminate the pointer to the HEAP.
  if (!dontAddNull) HEAP8[((buffer)>>0)]=0;
}
Module['writeAsciiToMemory'] = writeAsciiToMemory;

function unSign(value, bits, ignore) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}


// check for imul support, and also for correctness ( https://bugs.webkit.org/show_bug.cgi?id=126345 )
if (!Math['imul'] || Math['imul'](0xffffffff, 5) !== -5) Math['imul'] = function imul(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];


if (!Math['clz32']) Math['clz32'] = function(x) {
  x = x >>> 0;
  for (var i = 0; i < 32; i++) {
    if (x & (1 << (31 - i))) return i;
  }
  return 32;
};
Math.clz32 = Math['clz32']

var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;
var Math_clz32 = Math.clz32;

// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled

function getUniqueRunDependency(id) {
  return id;
}

function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}
Module['removeRunDependency'] = removeRunDependency;

Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data



var memoryInitializer = null;



// === Body ===

var ASM_CONSTS = [];




STATIC_BASE = 8;

STATICTOP = STATIC_BASE + 96992;
  /* global initializers */  __ATINIT__.push();
  

/* memory initializer */ allocate([69,114,114,111,114,58,32,99,97,110,39,116,32,97,108,108,111,99,97,116,101,32,86,98,114,70,114,97,109,101,115,32,98,117,102,102,101,114,10,0,0,0,0,0,193,192,0,0,129,193,0,0,64,1,0,0,1,195,0,0,192,3,0,0,128,2,0,0,65,194,0,0,1,198,0,0,192,6,0,0,128,7,0,0,65,199,0,0,0,5,0,0,193,197,0,0,129,196,0,0,64,4,0,0,1,204,0,0,192,12,0,0,128,13,0,0,65,205,0,0,0,15,0,0,193,207,0,0,129,206,0,0,64,14,0,0,0,10,0,0,193,202,0,0,129,203,0,0,64,11,0,0,1,201,0,0,192,9,0,0,128,8,0,0,65,200,0,0,1,216,0,0,192,24,0,0,128,25,0,0,65,217,0,0,0,27,0,0,193,219,0,0,129,218,0,0,64,26,0,0,0,30,0,0,193,222,0,0,129,223,0,0,64,31,0,0,1,221,0,0,192,29,0,0,128,28,0,0,65,220,0,0,0,20,0,0,193,212,0,0,129,213,0,0,64,21,0,0,1,215,0,0,192,23,0,0,128,22,0,0,65,214,0,0,1,210,0,0,192,18,0,0,128,19,0,0,65,211,0,0,0,17,0,0,193,209,0,0,129,208,0,0,64,16,0,0,1,240,0,0,192,48,0,0,128,49,0,0,65,241,0,0,0,51,0,0,193,243,0,0,129,242,0,0,64,50,0,0,0,54,0,0,193,246,0,0,129,247,0,0,64,55,0,0,1,245,0,0,192,53,0,0,128,52,0,0,65,244,0,0,0,60,0,0,193,252,0,0,129,253,0,0,64,61,0,0,1,255,0,0,192,63,0,0,128,62,0,0,65,254,0,0,1,250,0,0,192,58,0,0,128,59,0,0,65,251,0,0,0,57,0,0,193,249,0,0,129,248,0,0,64,56,0,0,0,40,0,0,193,232,0,0,129,233,0,0,64,41,0,0,1,235,0,0,192,43,0,0,128,42,0,0,65,234,0,0,1,238,0,0,192,46,0,0,128,47,0,0,65,239,0,0,0,45,0,0,193,237,0,0,129,236,0,0,64,44,0,0,1,228,0,0,192,36,0,0,128,37,0,0,65,229,0,0,0,39,0,0,193,231,0,0,129,230,0,0,64,38,0,0,0,34,0,0,193,226,0,0,129,227,0,0,64,35,0,0,1,225,0,0,192,33,0,0,128,32,0,0,65,224,0,0,1,160,0,0,192,96,0,0,128,97,0,0,65,161,0,0,0,99,0,0,193,163,0,0,129,162,0,0,64,98,0,0,0,102,0,0,193,166,0,0,129,167,0,0,64,103,0,0,1,165,0,0,192,101,0,0,128,100,0,0,65,164,0,0,0,108,0,0,193,172,0,0,129,173,0,0,64,109,0,0,1,175,0,0,192,111,0,0,128,110,0,0,65,174,0,0,1,170,0,0,192,106,0,0,128,107,0,0,65,171,0,0,0,105,0,0,193,169,0,0,129,168,0,0,64,104,0,0,0,120,0,0,193,184,0,0,129,185,0,0,64,121,0,0,1,187,0,0,192,123,0,0,128,122,0,0,65,186,0,0,1,190,0,0,192,126,0,0,128,127,0,0,65,191,0,0,0,125,0,0,193,189,0,0,129,188,0,0,64,124,0,0,1,180,0,0,192,116,0,0,128,117,0,0,65,181,0,0,0,119,0,0,193,183,0,0,129,182,0,0,64,118,0,0,0,114,0,0,193,178,0,0,129,179,0,0,64,115,0,0,1,177,0,0,192,113,0,0,128,112,0,0,65,176,0,0,0,80,0,0,193,144,0,0,129,145,0,0,64,81,0,0,1,147,0,0,192,83,0,0,128,82,0,0,65,146,0,0,1,150,0,0,192,86,0,0,128,87,0,0,65,151,0,0,0,85,0,0,193,149,0,0,129,148,0,0,64,84,0,0,1,156,0,0,192,92,0,0,128,93,0,0,65,157,0,0,0,95,0,0,193,159,0,0,129,158,0,0,64,94,0,0,0,90,0,0,193,154,0,0,129,155,0,0,64,91,0,0,1,153,0,0,192,89,0,0,128,88,0,0,65,152,0,0,1,136,0,0,192,72,0,0,128,73,0,0,65,137,0,0,0,75,0,0,193,139,0,0,129,138,0,0,64,74,0,0,0,78,0,0,193,142,0,0,129,143,0,0,64,79,0,0,1,141,0,0,192,77,0,0,128,76,0,0,65,140,0,0,0,68,0,0,193,132,0,0,129,133,0,0,64,69,0,0,1,135,0,0,192,71,0,0,128,70,0,0,65,134,0,0,1,130,0,0,192,66,0,0,128,67,0,0,65,131,0,0,0,65,0,0,193,129,0,0,129,128,0,0,64,64,0,0,115,116,114,97,110,103,101,32,101,114,114,111,114,32,102,108,117,115,104,105,110,103,32,98,117,102,102,101,114,32,46,46,46,32,10,0,0,0,0,0,69,114,114,111,114,58,32,77,65,88,95,72,69,65,68,69,82,95,66,85,70,32,116,111,111,32,115,109,97,108,108,32,105,110,32,98,105,116,115,116,114,101,97,109,46,99,32,10,0,0,0,0,0,0,0,0,73,110,116,101,114,110,97,108,32,98,117,102,102,101,114,32,105,110,99,111,110,115,105,115,116,101,110,99,121,46,32,102,108,117,115,104,98,105,116,115,32,60,62,32,82,101,115,118,83,105,122,101,0,0,0,0,98,105,116,32,114,101,115,101,114,118,111,105,114,32,101,114,114,111,114,58,32,10,108,51,95,115,105,100,101,45,62,109,97,105,110,95,100,97,116,97,95,98,101,103,105,110,58,32,37,105,32,10,82,101,115,118,111,105,114,32,115,105,122,101,58,32,32,32,32,32,32,32,32,32,32,32,32,32,37,105,32,10,114,101,115,118,32,100,114,97,105,110,32,40,112,111,115,116,41,32,32,32,32,32,32,32,32,32,37,105,32,10,114,101,115,118,32,100,114,97,105,110,32,40,112,114,101,41,32,32,32,32,32,32,32,32,32,32,37,105,32,10,104,101,97,100,101,114,32,97,110,100,32,115,105,100,101,105,110,102,111,58,32,32,32,32,32,32,37,105,32,10,100,97,116,97,32,98,105,116,115,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,37,105,32,10,116,111,116,97,108,32,98,105,116,115,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,37,105,32,40,114,101,109,97,105,110,100,101,114,58,32,37,105,41,32,10,98,105,116,115,112,101,114,102,114,97,109,101,58,32,32,32,32,32,32,32,32,32,32,32,32,32,37,105,32,10,0,0,84,104,105,115,32,105,115,32,97,32,102,97,116,97,108,32,101,114,114,111,114,46,32,32,73,116,32,104,97,115,32,115,101,118,101,114,97,108,32,112,111,115,115,105,98,108,101,32,99,97,117,115,101,115,58,0,57,48,37,37,32,32,76,65,77,69,32,99,111,109,112,105,108,101,100,32,119,105,116,104,32,98,117,103,103,121,32,118,101,114,115,105,111,110,32,111,102,32,103,99,99,32,117,115,105,110,103,32,97,100,118,97,110,99,101,100,32,111,112,116,105,109,105,122,97,116,105,111,110,115,0,0,0,0,0,0,32,57,37,37,32,32,89,111,117,114,32,115,121,115,116,101,109,32,105,115,32,111,118,101,114,99,108,111,99,107,101,100,0,0,0,0,0,0,0,0,32,49,37,37,32,32,98,117,103,32,105,110,32,76,65,77,69,32,101,110,99,111,100,105,110,103,32,108,105,98,114,97,114,121,0,0,0,0,0,0,0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE);
/* memory initializer */ allocate([94,131,108,63,21,239,195,62,109,196,126,63,54,189,200,61,67,236,127,63,176,10,201,60,196,254,127,63,136,15,201,59,88,88,88,0,0,0,0,0,37,108,117,0,0,0,0,0,105,109,97,103,101,47,112,110,103,0,0,0,0,0,0,0,105,109,97,103,101,47,103,105,102,0,0,0,0,0,0,0,105,109,97,103,101,47,106,112,101,103,0,0,0,0,0,0,37,100,0,0,0,0,0,0,128,187,0,0,0,0,0,0,0,0,208,64,0,0,0,0,0,0,208,64,148,92,0,0,68,172,0,0,0,0,0,0,0,0,208,64,0,0,0,0,0,0,208,64,20,85,0,0,0,125,0,0,0,0,208,64,0,0,0,65,102,102,166,64,0,0,208,64,184,61,0,0,192,93,0,0,0,0,0,65,0,0,8,65,102,102,166,64,0,0,192,64,74,46,0,0,34,86,0,0,0,0,8,65,246,40,16,65,102,102,166,64,0,0,208,64,140,42,0,0,128,62,0,0,246,40,16,65,102,102,22,65,205,204,156,64,0,0,208,64,223,30,0,0,224,46,0,0,102,102,22,65,154,153,25,65,0,0,144,64,0,0,192,64,40,23,0,0,17,43,0,0,154,153,25,65,102,102,30,65,51,51,163,64,0,0,208,64,70,21,0,0,64,31,0,0,102,102,30,65,0,0,32,65,205,204,156,64,0,0,208,64,112,15,0,0,8,0,0,0,208,7,0,0,16,0,0,0,116,14,0,0,24,0,0,0,60,15,0,0,32,0,0,0,124,21,0,0,40,0,0,0,88,27,0,0,48,0,0,0,76,29,0,0,56,0,0,0,16,39,0,0,64,0,0,0,248,42,0,0,80,0,0,0,188,52,0,0,96,0,0,0,252,58,0,0,112,0,0,0,240,60,0,0,128,0,0,0,104,66,0,0,160,0,0,0,92,68,0,0,192,0,0,0,168,72,0,0,224,0,0,0,200,75,0,0,0,1,0,0,244,76,0,0,64,1,0,0,20,80,0,0,44,76,0,0,56,74,0,0,168,72,0,0,80,70,0,0,92,68,0,0,128,62,0,0,240,60,0,0,52,58,0,0,212,48,0,0,16,39,0,0,110,15,0,0,0,0,0,0,192,93,0,0,44,76,0,0,68,72,0,0,80,70,0,0,92,68,0,0,104,66,0,0,116,64,0,0,240,60,0,0,96,59,0,0,62,28,0,0,110,15,0,0,0,0,0,0,44,76,0,0,56,74,0,0,68,72,0,0,80,70,0,0,92,68,0,0,116,64,0,0,140,60,0,0,164,56,0,0,212,48,0,0,28,37,0,0,110,15,0,0,0,0,0,0,102,102,182,64,0,0,208,64,154,153,233,64,51,51,3,65,0,0,32,65,102,102,62,65,0,0,80,65,0,0,96,65,0,0,112,65,0,0,132,65,87,97,114,110,105,110,103,58,32,104,105,103,104,112,97,115,115,32,102,105,108,116,101,114,32,100,105,115,97,98,108,101,100,46,32,32,104,105,103,104,112,97,115,115,32,102,114,101,113,117,101,110,99,121,32,116,111,111,32,115,109,97,108,108,10,0,0,0,0,0,0,0,69,114,114,111,114,58,32,99,97,110,39,116,32,97,108,108,111,99,97,116,101,32,105,110,95,98,117,102,102,101,114,32,98,117,102,102,101,114,10,0,0,0,0,0,1,0,0,0,16,0,0,0,17,0,0,0,8,0,0,0,9,0,0,0,24,0,0,0,25,0,0,0,4,0,0,0,5,0,0,0,20,0,0,0,21,0,0,0,12,0,0,0,13,0,0,0,28,0,0,0,29,0,0,0,2,0,0,0,3,0,0,0,18,0,0,0,19,0,0,0,10,0,0,0,11,0,0,0,26,0,0,0,27,0,0,0,6,0,0,0,7,0,0,0,22,0,0,0,23,0,0,0,14,0,0,0,15,0,0,0,30,0,0,0,31,0,0,0,0,27,134,42,204,204,52,43,33,78,132,43,252,247,157,43,88,156,166,43,252,247,157,43,33,78,132,43,204,204,52,43,0,27,134,42,83,248,191,44,254,169,171,44,146,50,149,44,159,129,122,44,239,29,73,44,62,186,23,44,116,173,207,43,133,159,107,43,183,89,146,42,83,248,191,172,254,169,171,172,146,50,149,172,159,129,122,172,239,29,73,172,62,186,23,172,116,173,207,171,133,159,107,171,183,89,146,170,0,27,134,170,204,204,52,171,33,78,132,171,252,247,157,171,88,156,166,171,252,247,157,171,33,78,132,171,204,204,52,171,0,27,134,170,0,27,134,42,204,204,52,43,33,78,132,43,252,247,157,43,88,156,166,43,252,247,157,43,33,78,132,43,204,204,52,43,0,27,134,42,83,248,191,44,254,169,171,44,146,50,149,44,159,129,122,44,239,29,73,44,62,186,23,44,116,173,207,43,133,159,107,43,183,89,146,42,37,39,192,172,51,37,173,172,234,209,152,172,227,84,131,172,249,175,89,172,11,14,43,172,102,34,244,171,201,49,137,171,74,123,157,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,144,128,170,174,79,227,170,5,174,113,170,234,207,6,62,205,19,212,62,139,111,68,63,255,175,139,63,23,208,166,63,117,235,200,63,190,226,245,63,122,130,26,64,105,251,74,64,185,87,144,64,107,16,243,64,233,58,183,65,92,28,124,63,187,141,36,63,68,29,175,62,178,143,112,63,212,208,49,190,125,27,68,191,215,179,93,63,0,0,0,63,254,181,3,191,218,134,241,190,2,115,160,190,116,71,58,190,29,176,193,189,135,203,39,189,29,161,104,188,70,123,114,187,168,132,91,63,216,185,97,63,221,26,115,63,129,186,123,63,65,218,126,63,253,200,127,63,101,249,127,63,141,255,127,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,144,128,42,174,79,227,42,5,174,113,42,37,39,192,44,51,37,173,44,234,209,152,44,227,84,131,44,249,175,89,44,11,14,43,44,102,34,244,43,201,49,137,43,74,123,157,42,83,248,191,172,254,169,171,172,146,50,149,172,159,129,122,172,239,29,73,172,62,186,23,172,116,173,207,171,133,159,107,171,183,89,146,170,0,27,134,170,204,204,52,171,33,78,132,171,252,247,157,171,88,156,166,171,252,247,157,171,33,78,132,171,204,204,52,171,0,27,134,170,121,207,23,190,138,59,1,66,164,51,148,67,155,200,92,68,202,167,45,70,175,40,132,68,192,222,152,67,129,155,246,65,199,156,118,64,77,183,109,66,194,101,49,68,74,15,165,69,82,45,182,197,71,104,76,196,73,213,153,194,66,4,147,192,94,6,104,63,54,189,72,62,3,97,30,190,44,76,9,66,68,231,150,67,96,102,76,68,47,215,52,70,17,168,147,68,117,204,160,67,46,219,249,65,68,124,109,64,146,154,86,66,183,10,43,68,136,68,163,69,35,243,198,197,129,62,99,196,80,169,179,194,43,42,173,192,1,24,82,63,194,197,199,62,223,144,36,190,144,150,16,66,32,15,152,67,140,47,55,68,113,86,59,70,101,128,162,68,120,164,167,67,193,231,251,65,149,237,87,64,209,237,60,66,46,47,35,68,80,99,160,69,178,232,215,197,240,127,122,196,100,62,207,194,121,91,195,192,207,220,61,63,49,160,20,63,61,91,42,190,177,1,23,66,106,129,151,67,98,254,28,68,14,27,65,70,229,136,176,68,246,95,173,67,75,201,252,65,52,59,74,64,173,80,34,66,178,10,26,68,170,126,156,69,83,240,232,197,121,249,136,196,253,124,236,194,231,48,218,192,193,13,43,63,21,239,67,63,139,188,47,190,75,118,28,66,177,43,149,67,81,195,251,67,92,30,70,70,161,146,189,68,23,254,177,67,116,41,251,65,165,166,58,64,77,48,7,66,62,185,15,68,225,169,151,69,144,236,249,197,102,184,148,196,253,164,5,195,130,12,247,192,196,112,25,63,234,90,113,63,120,177,52,190,11,224,32,66,197,255,144,67,75,169,179,67,9,89,74,70,63,131,201,68,227,108,181,67,12,94,248,65,73,159,52,64,49,233,215,65,148,121,4,68,250,250,145,69,153,95,5,198,224,82,160,196,230,149,21,195,193,75,10,193,185,213,8,63,218,57,142,63,244,54,185,190,93,45,36,66,238,197,138,67,123,163,67,67,193,197,77,70,150,52,212,68,118,180,183,67,208,116,244,65,169,3,34,64,173,143,160,65,68,192,240,67,195,135,139,69,122,165,13,198,28,180,171,196,130,42,38,195,136,83,25,193,112,40,242,62,153,103,162,63,55,74,189,190,167,146,37,66,148,165,130,67,182,247,78,65,135,96,80,70,71,144,221,68,247,225,184,67,182,2,238,65,153,191,25,64,113,224,84,65,226,71,215,67,116,104,132,69,186,183,21,198,32,182,182,196,153,32,55,195,248,124,43,193,205,19,212,62,243,4,181,63,187,232,192,190,91,122,38,66,227,13,113,67,88,242,59,195,65,40,82,70,237,132,229,68,213,190,184,67,201,3,232,65,16,147,4,64,105,242,216,64,110,227,188,67,47,102,121,69,214,134,29,198,81,62,193,196,85,96,72,195,235,212,61,193,80,50,183,62,3,228,197,63,71,16,196,190,73,155,36,66,18,122,88,67,23,20,203,195,140,28,83,70,216,249,235,68,185,166,183,67,247,22,225,65,11,250,244,63,71,16,196,62,69,237,161,67,91,2,105,69,239,4,37,198,124,38,203,196,16,160,89,195,54,63,80,193,66,80,155,62,49,219,212,63,46,15,21,191,242,108,33,66,98,51,60,67,83,17,32,196,220,60,83,70,70,243,240,68,238,104,181,67,38,192,215,65,112,137,223,63,88,12,180,192,157,166,134,67,47,214,87,69,149,32,44,198,6,85,212,196,16,196,106,195,193,157,98,193,212,63,128,62,152,197,225,63,57,182,22,191,234,239,28,66,206,194,27,67,244,79,94,196,226,141,82,70,182,97,244,68,249,56,178,67,221,40,207,65,124,229,200,63,57,233,50,193,16,207,86,67,160,18,70,69,73,205,50,198,21,165,220,196,104,176,123,195,1,246,119,193,175,175,75,62,94,131,236,63,230,143,74,191,36,147,21,66,35,102,239,66,16,227,143,196,201,17,81,70,166,76,246,68,130,2,174,67,22,218,197,65,28,72,177,63,12,95,131,193,224,12,33,67,81,229,51,69,247,251,56,198,140,255,227,196,139,36,134,195,184,137,134,193,100,229,23,62,11,250,244,63,223,202,75,191,201,237,12,66,223,9,160,66,174,0,178,196,45,207,78,70,187,185,246,68,213,254,168,67,51,80,186,65,197,91,178,63,32,204,168,193,139,247,216,66,54,123,33,69,232,158,62,198,230,72,234,196,148,31,142,195,218,232,144,193,220,181,201,61,190,20,251,63,15,177,127,191,152,64,2,66,94,213,19,66,106,66,213,196,38,205,75,70,66,172,245,68,70,55,163,67,112,102,177,65,251,108,153,63,81,248,202,193,231,35,102,66,180,6,15,69,179,170,67,198,226,90,239,196,151,161,149,195,66,6,155,193,60,57,73,61,109,196,254,63,54,211,37,70,68,177,165,69,175,113,104,68,69,51,54,68,128,12,144,67,180,213,129,66,2,0,241,65,34,63,131,64,49,19,72,70,167,49,243,68,86,182,156,67,170,105,166,65,251,100,249,68,112,3,16,65,17,158,233,193,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,102,102,166,64,0,0,250,66,102,102,134,192,154,153,201,192,154,153,153,64,0,0,128,63,0,0,0,0,0,0,0,0,2,0,0,0,21,0,0,0,236,81,120,63,0,0,160,64,0,0,200,66,1,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,154,153,169,64,0,0,250,66,102,102,102,192,51,51,179,192,0,0,144,64,0,0,192,63,0,0,0,0,0,0,0,0,2,0,0,0,21,0,0,0,205,204,172,63,0,0,160,64,0,0,200,66,2,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,51,51,179,64,0,0,250,66,205,204,12,192,0,0,96,192,51,51,51,64,0,0,0,64,0,0,0,0,0,0,0,0,2,0,0,0,21,0,0,0,82,184,190,63,0,0,160,64,0,0,200,66,3,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,154,153,185,64,0,0,2,67,102,102,230,191,51,51,51,192,102,102,38,64,0,0,64,64,0,0,128,192,0,0,0,0,2,0,0,0,20,0,0,0,133,235,209,63,0,0,160,64,0,0,200,66,4,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,0,0,192,64,0,0,7,67,51,51,51,191,205,204,140,191,205,204,140,63,0,0,96,64,0,0,0,193,0,0,0,0,2,0,0,0,0,0,0,0,184,30,229,63,0,0,160,64,0,0,200,66,5,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,205,204,204,64,0,0,12,67,0,0,0,63,205,204,204,62,0,0,240,192,0,0,128,64,0,0,64,193,23,183,81,57,0,0,0,0,0,0,0,0,154,153,249,63,0,0,160,64,0,0,200,66,6,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,17,67,31,133,43,63,102,102,38,63,51,51,107,193,0,0,208,64,0,0,152,193,23,183,209,57,0,0,0,0,0,0,0,0,51,51,19,64,0,0,160,64,0,0,200,66,7,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,17,67,205,204,76,63,0,0,64,63,154,153,157,193,0,0,0,65,0,0,176,193,82,73,29,58,0,0,0,0,0,0,0,0,205,204,44,64,0,0,160,64,0,0,200,66,8,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,17,67,154,153,153,63,51,51,147,63,0,0,220,193,0,0,32,65,0,0,184,193,52,128,55,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,64,0,0,200,66,9,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,17,67,205,204,204,63,205,204,204,63,0,0,16,194,0,0,48,65,0,0,200,193,23,183,81,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,64,0,0,200,66,10,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,17,67,0,0,0,64,0,0,0,64,0,0,16,194,0,0,64,65,0,0,200,193,23,183,81,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,64,0,0,200,66,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,102,102,134,64,0,0,200,65,154,153,217,192,154,153,217,192,51,51,227,64,0,0,128,63,0,0,0,0,0,0,0,0,2,0,0,0,31,0,0,0,0,0,128,63,0,0,160,64,0,0,200,66,1,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,102,102,134,64,0,0,200,65,154,153,153,192,154,153,153,192,205,204,172,64,51,51,179,63,0,0,128,191,0,0,0,0,2,0,0,0,27,0,0,0,178,157,143,63,0,0,160,64,0,0,196,66,2,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,102,102,134,64,0,0,200,65,102,102,38,192,102,102,38,192,205,204,108,64,0,0,0,64,0,0,64,192,0,0,0,0,2,0,0,0,23,0,0,0,47,221,164,63,0,0,160,64,0,0,194,66,3,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,102,102,134,64,0,0,200,65,205,204,204,191,205,204,204,191,0,0,0,64,0,0,0,64,0,0,160,192,0,0,0,0,2,0,0,0,18,0,0,0,223,79,189,63,0,0,160,64,0,0,192,66,4,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,102,102,134,64,0,0,200,65,0,0,0,128,0,0,0,128,0,0,0,0,0,0,0,64,0,0,0,193,0,0,0,0,2,0,0,0,12,0,0,0,16,88,217,63,0,0,160,64,0,0,190,66,5,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,102,102,134,64,0,0,200,65,102,102,166,63,102,102,166,63,0,0,192,192,0,0,96,64,0,0,48,193,0,0,0,0,2,0,0,0,8,0,0,0,154,153,249,63,0,0,160,64,102,102,188,66,6,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,0,0,144,64,0,0,200,66,205,204,12,64,51,51,19,64,0,0,64,193,0,0,192,64,0,0,96,193,0,0,0,0,2,0,0,0,4,0,0,0,199,75,15,64,0,0,64,64,205,204,187,66,7,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,154,153,153,64,0,0,72,67,205,204,44,64,205,204,44,64,0,0,144,193,0,0,16,65,0,0,136,193,0,0,0,0,2,0,0,0,0,0,0,0,225,122,36,64,0,0,128,63,51,51,187,66,8,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,154,153,169,64,0,0,150,67,51,51,51,64,51,51,51,64,0,0,168,193,0,0,32,65,0,0,184,193,23,183,81,57,0,0,0,0,0,0,0,0,47,221,60,64,0,0,0,0,154,153,186,66,9,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,51,51,211,64,0,0,150,67,51,51,51,64,51,51,51,64,0,0,184,193,0,0,48,65,0,0,200,193,82,73,29,58,0,0,0,0,0,0,0,0,254,212,88,64,0,0,0,0,154,153,186,66,10,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,0,0,200,65,0,0,150,67,51,51,51,64,51,51,51,64,0,0,200,193,0,0,64,65,0,0,216,193,10,215,35,59,0,0,0,0,0,0,0,0,0,0,96,64,0,0,0,0,154,153,186,66,0,0,0,0,8,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,240,193,0,0,48,65,82,73,157,58,1,0,0,0,16,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,200,193,0,0,48,65,111,18,131,58,1,0,0,0,24,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,160,193,0,0,48,65,111,18,131,58,1,0,0,0,32,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,112,193,0,0,48,65,111,18,131,58,1,0,0,0,40,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,32,193,0,0,48,65,250,237,107,58,1,0,0,0,48,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,32,193,0,0,48,65,250,237,107,58,1,0,0,0,56,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,192,192,0,0,48,65,23,183,81,58,1,0,0,0,64,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,0,192,0,0,48,65,23,183,81,58,1,0,0,0,80,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,0,0,0,0,0,65,52,128,55,58,1,0,0,0,96,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,32,64,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,128,63,0,0,176,64,82,73,29,58,1,0,0,0,112,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,0,0,16,64,51,51,211,64,0,0,17,67,51,51,115,63,0,0,0,0,0,0,0,64,0,0,144,64,111,18,3,58,1,0,0,0,128,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,154,153,249,63,205,204,204,64,0,0,12,67,51,51,115,63,0,0,0,0,0,0,64,64,0,0,128,64,23,183,81,57,1,0,0,0,160,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,184,30,229,63,0,0,192,64,0,0,7,67,51,51,115,63,0,0,0,192,0,0,160,64,0,0,96,64,0,0,0,0,1,0,0,0,192,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,82,184,190,63,51,51,179,64,0,0,250,66,236,81,120,63,0,0,128,192,0,0,224,64,0,0,64,64,0,0,0,0,0,0,0,0,224,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,0,0,160,63,102,102,166,64,0,0,250,66,72,225,122,63,0,0,192,192,0,0,16,65,0,0,0,64,0,0,0,0,0,0,0,0,0,1,0,0,9,0,0,0,9,0,0,0,1,0,0,0,236,81,120,63,102,102,166,64,0,0,250,66,0,0,128,63,0,0,0,193,0,0,32,65,0,0,128,63,0,0,0,0,0,0,0,0,64,1,0,0,9,0,0,0,9,0,0,0,1,0,0,0,102,102,102,63,102,102,166,64,0,0,250,66,0,0,128,63,0,0,32,193,0,0,64,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,128,63,54,89,75,63,152,134,33,63,152,134,33,63,152,134,33,63,152,134,33,63,152,134,33,63,250,155,128,62,153,158,240,61,0,0,0,0,0,0,0,0,0,0,0,0,137,158,227,63,229,83,236,63,167,94,245,63,155,20,249,63,14,217,252,63,123,143,234,63,218,151,217,63,226,132,191,63,124,145,168,63,0,0,128,63,0,0,0,0,0,0,0,0,205,204,60,65,154,153,89,65,154,153,137,65,0,0,0,66,0,0,58,66,51,51,77,66,0,0,102,66,51,51,134,66,0,0,143,66,51,51,169,66,51,51,195,66,0,0,2,67,154,153,217,64,154,153,185,64,154,153,185,64,205,204,204,64,0,0,208,64,102,102,30,65,154,153,65,65,102,102,102,65,0,0,112,65,51,51,151,65,205,204,172,65,51,51,215,65,205,204,8,66,205,204,32,66,51,51,59,66,0,0,98,66,205,204,114,66,205,204,147,66,102,102,171,66,205,204,186,66,51,51,252,66,0,0,0,0,205,204,236,192,205,204,236,192,205,204,236,192,0,0,24,193,205,204,236,192,51,51,195,192,0,0,176,192,102,102,150,192,102,102,150,192,102,102,150,192,102,102,150,192,0,0,0,0,73,78,84,69,82,78,65,76,32,69,82,82,79,82,32,73,78,32,86,66,82,32,78,69,87,32,67,79,68,69,44,32,112,108,101,97,115,101,32,115,101,110,100,32,98,117,103,32,114,101,112,111,114,116,10,0,6,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,6,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,6,0,0,0,5,0,0,0,7,0,0,0,3,0,0,0,9,0,0,0,9,0,0,0,12,0,0,0,6,0,0,0,6,0,0,0,9,0,0,0,12,0,0,0,6,0,0,0,11,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,0,0,0,0,6,0,0,0,15,0,0,0,12,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,3,0,0,0,12,0,0,0,9,0,0,0,9,0,0,0,6,0,0,0,6,0,0,0,12,0,0,0,9,0,0,0,6,0,0,0,8,0,0,0,8,0,0,0,5,0,0,0,0,0,0,0,15,0,0,0,12,0,0,0,9,0,0,0,0,0,0,0,6,0,0,0,18,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,80,0,0,0,96,0,0,0,116,0,0,0,140,0,0,0,168,0,0,0,200,0,0,0,238,0,0,0,28,1,0,0,80,1,0,0,140,1,0,0,208,1,0,0,10,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,32,0,0,0,42,0,0,0,56,0,0,0,74,0,0,0,100,0,0,0,132,0,0,0,174,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,80,0,0,0,96,0,0,0,114,0,0,0,136,0,0,0,162,0,0,0,194,0,0,0,232,0,0,0,22,1,0,0,76,1,0,0,138,1,0,0,208,1,0,0,28,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,18,0,0,0,26,0,0,0,36,0,0,0,48,0,0,0,62,0,0,0,80,0,0,0,104,0,0,0,136,0,0,0,180,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,80,0,0,0,96,0,0,0,116,0,0,0,140,0,0,0,168,0,0,0,200,0,0,0,238,0,0,0,28,1,0,0,80,1,0,0,140,1,0,0,208,1,0,0,10,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,18,0,0,0,26,0,0,0,36,0,0,0,48,0,0,0,62,0,0,0,80,0,0,0,104,0,0,0,134,0,0,0,174,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,20,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,52,0,0,0,62,0,0,0,74,0,0,0,90,0,0,0,110,0,0,0,134,0,0,0,162,0,0,0,196,0,0,0,238,0,0,0,32,1,0,0,86,1,0,0,162,1,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,22,0,0,0,30,0,0,0,40,0,0,0,52,0,0,0,66,0,0,0,84,0,0,0,106,0,0,0,136,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,20,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,42,0,0,0,50,0,0,0,60,0,0,0,72,0,0,0,88,0,0,0,106,0,0,0,128,0,0,0,156,0,0,0,190,0,0,0,230,0,0,0,20,1,0,0,74,1,0,0,128,1,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,22,0,0,0,28,0,0,0,38,0,0,0,50,0,0,0,64,0,0,0,80,0,0,0,100,0,0,0,126,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,20,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,82,0,0,0,102,0,0,0,126,0,0,0,156,0,0,0,194,0,0,0,240,0,0,0,40,1,0,0,108,1,0,0,192,1,0,0,38,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,22,0,0,0,30,0,0,0,42,0,0,0,58,0,0,0,78,0,0,0,104,0,0,0,138,0,0,0,180,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,80,0,0,0,96,0,0,0,116,0,0,0,140,0,0,0,168,0,0,0,200,0,0,0,238,0,0,0,28,1,0,0,80,1,0,0,140,1,0,0,208,1,0,0,10,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,18,0,0,0,26,0,0,0,36,0,0,0,48,0,0,0,62,0,0,0,80,0,0,0,104,0,0,0,134,0,0,0,174,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,12,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,36,0,0,0,44,0,0,0,54,0,0,0,66,0,0,0,80,0,0,0,96,0,0,0,116,0,0,0,140,0,0,0,168,0,0,0,200,0,0,0,238,0,0,0,28,1,0,0,80,1,0,0,140,1,0,0,208,1,0,0,10,2,0,0,64,2,0,0,0,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,18,0,0,0,26,0,0,0,36,0,0,0,48,0,0,0,62,0,0,0,80,0,0,0,104,0,0,0,134,0,0,0,174,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,24,0,0,0,36,0,0,0,48,0,0,0,60,0,0,0,72,0,0,0,88,0,0,0,108,0,0,0,132,0,0,0,160,0,0,0,192,0,0,0,232,0,0,0,24,1,0,0,80,1,0,0,144,1,0,0,220,1,0,0,54,2,0,0,56,2,0,0,58,2,0,0,60,2,0,0,62,2,0,0,64,2,0,0,0,0,0,0,8,0,0,0,16,0,0,0,24,0,0,0,36,0,0,0,52,0,0,0,72,0,0,0,96,0,0,0,124,0,0,0,160,0,0,0,162,0,0,0,164,0,0,0,166,0,0,0,192], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+6448);
/* memory initializer */ allocate([1,4,3,5,0,0,0,0,1,5,5,7,5,8,7,9,5,7,7,9,7,9,9,10,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,192,72,1,0,56,65,1,0,3,0,0,0,0,0,0,0,200,72,1,0,224,72,1,0,3,0,0,0,0,0,0,0,240,72,1,0,8,73,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,24,73,1,0,56,73,1,0,4,0,0,0,0,0,0,0,72,73,1,0,104,73,1,0,6,0,0,0,0,0,0,0,120,73,1,0,192,73,1,0,6,0,0,0,0,0,0,0,232,73,1,0,48,74,1,0,6,0,0,0,0,0,0,0,88,74,1,0,160,74,1,0,8,0,0,0,0,0,0,0,200,74,1,0,72,75,1,0,8,0,0,0,0,0,0,0,136,75,1,0,8,76,1,0,8,0,0,0,0,0,0,0,72,76,1,0,200,76,1,0,16,0,0,0,0,0,0,0,8,77,1,0,8,79,1,0,0,0,0,0,0,0,0,0,0,0,0,0,8,80,1,0,16,0,0,0,0,0,0,0,8,81,1,0,8,83,1,0,1,0,0,0,1,0,0,0,8,84,1,0,8,86,1,0,2,0,0,0,3,0,0,0,8,84,1,0,8,86,1,0,3,0,0,0,7,0,0,0,8,84,1,0,8,86,1,0,4,0,0,0,15,0,0,0,8,84,1,0,8,86,1,0,6,0,0,0,63,0,0,0,8,84,1,0,8,86,1,0,8,0,0,0,255,0,0,0,8,84,1,0,8,86,1,0,10,0,0,0,255,3,0,0,8,84,1,0,8,86,1,0,13,0,0,0,255,31,0,0,8,84,1,0,8,86,1,0,4,0,0,0,15,0,0,0,8,87,1,0,8,89,1,0,5,0,0,0,31,0,0,0,8,87,1,0,8,89,1,0,6,0,0,0,63,0,0,0,8,87,1,0,8,89,1,0,7,0,0,0,127,0,0,0,8,87,1,0,8,89,1,0,8,0,0,0,255,0,0,0,8,87,1,0,8,89,1,0,9,0,0,0,255,1,0,0,8,87,1,0,8,89,1,0,11,0,0,0,255,7,0,0,8,87,1,0,8,89,1,0,13,0,0,0,255,31,0,0,8,87,1,0,8,89,1,0,0,0,0,0,0,0,0,0,8,90,1,0,64,65,1,0,0,0,0,0,0,0,0,0,40,90,1,0,80,65,1,0,4,0,1,0,5,0,5,0,7,0,7,0,8,0,9,0,9,0,10,0,10,0,10,0,10,0,11,0,11,0,11,0,11,0,12,0,12,0,12,0,12,0,12,0,12,0,13,0,12,0,13,0,12,0,13,0,13,0,14,0,10,0,10,0,5,0,4,0,6,0,6,0,7,0,8,0,8,0,9,0,9,0,10,0,10,0,11,0,10,0,11,0,11,0,11,0,11,0,12,0,11,0,12,0,12,0,12,0,12,0,13,0,12,0,14,0,12,0,13,0,12,0,14,0,10,0,10,0,7,0,7,0,7,0,8,0,8,0,9,0,9,0,10,0,9,0,11,0,10,0,11,0,10,0,12,0,11,0,12,0,11,0,13,0,11,0,12,0,11,0,13,0,12,0,13,0,12,0,13,0,12,0,14,0,13,0,14,0,9,0,11,0,8,0,9,0,8,0,9,0,9,0,10,0,9,0,11,0,10,0,11,0,10,0,12,0,10,0,12,0,11,0,12,0,11,0,13,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,9,0,12,0,9,0,10,0,9,0,10,0,9,0,11,0,10,0,11,0,10,0,12,0,10,0,12,0,10,0,13,0,11,0,13,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,13,0,15,0,9,0,11,0,10,0,10,0,9,0,10,0,10,0,11,0,10,0,11,0,10,0,12,0,10,0,13,0,11,0,13,0,11,0,14,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,16,0,9,0,12,0,10,0,11,0,10,0,11,0,10,0,11,0,10,0,12,0,10,0,13,0,11,0,13,0,11,0,13,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,13,0,16,0,9,0,12,0,11,0,11,0,10,0,11,0,10,0,12,0,10,0,12,0,11,0,13,0,11,0,13,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,15,0,13,0,17,0,13,0,17,0,10,0,12,0,11,0,11,0,11,0,12,0,11,0,12,0,11,0,13,0,11,0,13,0,11,0,13,0,11,0,14,0,11,0,14,0,11,0,15,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,16,0,13,0,16,0,13,0,16,0,10,0,12,0,11,0,12,0,11,0,12,0,11,0,12,0,11,0,13,0,11,0,13,0,11,0,14,0,11,0,14,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,16,0,13,0,15,0,13,0,16,0,13,0,15,0,10,0,13,0,12,0,12,0,11,0,13,0,11,0,12,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,16,0,12,0,16,0,13,0,16,0,13,0,17,0,13,0,17,0,13,0,16,0,10,0,12,0,12,0,13,0,12,0,13,0,11,0,13,0,11,0,13,0,11,0,14,0,12,0,14,0,12,0,15,0,12,0,16,0,12,0,16,0,12,0,16,0,12,0,16,0,13,0,16,0,13,0,16,0,13,0,15,0,13,0,16,0,10,0,13,0,12,0,13,0,12,0,14,0,12,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,15,0,12,0,17,0,13,0,16,0,13,0,16,0,13,0,16,0,13,0,16,0,13,0,18,0,10,0,13,0,12,0,15,0,12,0,14,0,12,0,14,0,12,0,14,0,12,0,15,0,12,0,15,0,12,0,16,0,12,0,16,0,13,0,16,0,13,0,18,0,13,0,17,0,13,0,17,0,13,0,17,0,13,0,19,0,13,0,17,0,10,0,13,0,13,0,14,0,12,0,15,0,12,0,13,0,12,0,14,0,12,0,16,0,12,0,16,0,12,0,15,0,13,0,16,0,13,0,16,0,13,0,17,0,13,0,18,0,13,0,17,0,13,0,19,0,13,0,17,0,13,0,16,0,10,0,13,0,9,0,10,0,9,0,10,0,9,0,10,0,9,0,11,0,9,0,11,0,9,0,12,0,9,0,12,0,9,0,12,0,9,0,13,0,9,0,13,0,9,0,13,0,10,0,13,0,10,0,13,0,10,0,13,0,10,0,13,0,6,0,10,0,2,0,1,0,3,0,4,0,7,0,7,0,4,0,4,0,4,0,5,0,7,0,7,0,6,0,6,0,7,0,7,0,8,0,8,0,0,0,0,0,3,0,1,0,4,0,4,0,6,0,7,0,8,0,8,0,4,0,4,0,4,0,5,0,6,0,8,0,7,0,9,0,5,0,7,0,6,0,8,0,7,0,9,0,8,0,10,0,7,0,8,0,7,0,8,0,8,0,9,0,9,0,10,0,0,0,0,0,8,0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,80,0,0,0,96,0,0,0,112,0,0,0,128,0,0,0,144,0,0,0,160,0,0,0,255,255,255,255,0,0,0,0,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,80,0,0,0,96,0,0,0,112,0,0,0,128,0,0,0,160,0,0,0,192,0,0,0,224,0,0,0,0,1,0,0,64,1,0,0,255,255,255,255,0,0,0,0,8,0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,6,0,0,0,11,0,0,0,16,0,0,0,21,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,1,0,2,0,1,0,3,0,1,0,1,0,3,0,2,0,0,0,0,0,0,0,0,0,1,4,7,4,5,7,6,7,8,0,0,0,0,0,0,0,3,0,2,0,1,0,1,0,1,0,1,0,3,0,2,0,0,0,0,0,0,0,0,0,2,3,7,4,4,7,6,7,8,0,0,0,0,0,0,0,1,0,2,0,6,0,5,0,3,0,1,0,4,0,4,0,7,0,5,0,7,0,1,0,6,0,1,0,1,0,0,0,1,4,7,8,4,5,8,9,7,8,9,10,8,8,9,10,7,0,3,0,5,0,1,0,6,0,2,0,3,0,2,0,5,0,4,0,4,0,1,0,3,0,3,0,2,0,0,0,3,4,6,8,4,4,6,7,5,6,7,8,7,7,8,9,1,0,2,0,10,0,19,0,16,0,10,0,3,0,3,0,7,0,10,0,5,0,3,0,11,0,4,0,13,0,17,0,8,0,4,0,12,0,11,0,18,0,15,0,11,0,2,0,7,0,6,0,9,0,14,0,3,0,1,0,6,0,4,0,5,0,3,0,2,0,0,0,1,4,7,9,9,10,4,6,8,9,9,10,7,7,9,10,10,11,8,9,10,11,11,11,8,9,10,11,11,12,9,10,11,12,12,12,0,0,0,0,3,0,4,0,6,0,18,0,12,0,5,0,5,0,1,0,2,0,16,0,9,0,3,0,7,0,3,0,5,0,14,0,7,0,3,0,19,0,17,0,15,0,13,0,10,0,4,0,13,0,5,0,8,0,11,0,5,0,1,0,12,0,4,0,4,0,1,0,1,0,0,0,2,4,7,9,9,10,4,4,6,10,10,10,7,6,8,10,10,11,9,10,10,11,11,12,9,9,10,11,12,12,10,10,11,11,13,13,0,0,0,0,7,0,5,0,9,0,14,0,15,0,7,0,6,0,4,0,5,0,5,0,6,0,7,0,7,0,6,0,8,0,8,0,8,0,5,0,15,0,6,0,9,0,10,0,5,0,1,0,11,0,7,0,9,0,6,0,4,0,1,0,14,0,4,0,6,0,2,0,6,0,0,0,3,4,6,7,9,10,4,5,6,7,8,10,5,6,7,8,9,10,7,7,8,9,9,10,8,8,9,9,10,11,9,9,10,10,11,11,0,0,0,0,1,0,2,0,10,0,23,0,35,0,30,0,12,0,17,0,3,0,3,0,8,0,12,0,18,0,21,0,12,0,7,0,11,0,9,0,15,0,21,0,32,0,40,0,19,0,6,0,14,0,13,0,22,0,34,0,46,0,23,0,18,0,7,0,20,0,19,0,33,0,47,0,27,0,22,0,9,0,3,0,31,0,22,0,41,0,26,0,21,0,20,0,5,0,3,0,14,0,13,0,10,0,11,0,16,0,6,0,5,0,1,0,9,0,8,0,7,0,8,0,4,0,4,0,2,0,0,0,1,4,7,9,10,10,10,11,4,6,8,9,10,11,10,10,7,8,9,10,11,12,11,11,8,9,10,11,12,12,11,12,9,10,11,12,12,12,12,12,10,11,12,12,13,13,12,13,9,10,11,12,12,12,13,13,10,10,11,12,12,13,13,13,3,0,4,0,10,0,24,0,34,0,33,0,21,0,15,0,5,0,3,0,4,0,10,0,32,0,17,0,11,0,10,0,11,0,7,0,13,0,18,0,30,0,31,0,20,0,5,0,25,0,11,0,19,0,59,0,27,0,18,0,12,0,5,0,35,0,33,0,31,0,58,0,30,0,16,0,7,0,5,0,28,0,26,0,32,0,19,0,17,0,15,0,8,0,14,0,14,0,12,0,9,0,13,0,14,0,9,0,4,0,1,0,11,0,4,0,6,0,6,0,6,0,3,0,2,0,0,0,2,4,6,8,9,10,9,10,4,5,6,8,10,10,9,10,6,7,8,9,10,11,10,10,8,8,9,11,10,12,10,11,9,10,10,11,11,12,11,12,9,10,11,12,12,13,12,13,9,9,9,10,11,12,12,12,9,9,10,11,12,12,12,12,9,0,6,0,16,0,33,0,41,0,39,0,38,0,26,0,7,0,5,0,6,0,9,0,23,0,16,0,26,0,11,0,17,0,7,0,11,0,14,0,21,0,30,0,10,0,7,0,17,0,10,0,15,0,12,0,18,0,28,0,14,0,5,0,32,0,13,0,22,0,19,0,18,0,16,0,9,0,5,0,40,0,17,0,31,0,29,0,17,0,13,0,4,0,2,0,27,0,12,0,11,0,15,0,10,0,7,0,4,0,1,0,27,0,12,0,8,0,12,0,6,0,3,0,1,0,0,0,4,4,6,8,9,10,10,10,4,5,6,7,9,9,10,10,6,6,7,8,9,10,9,10,7,7,8,8,9,10,10,10,8,8,9,9,10,10,10,11,9,9,10,10,10,11,10,11,9,9,9,10,10,11,11,12,10,10,10,11,11,11,11,12,1,0,5,0,14,0,21,0,34,0,51,0,46,0,71,0,42,0,52,0,68,0,52,0,67,0,44,0,43,0,19,0,3,0,4,0,12,0,19,0,31,0,26,0,44,0,33,0,31,0,24,0,32,0,24,0,31,0,35,0,22,0,14,0,15,0,13,0,23,0,36,0,59,0,49,0,77,0,65,0,29,0,40,0,30,0,40,0,27,0,33,0,42,0,16,0,22,0,20,0,37,0,61,0,56,0,79,0,73,0,64,0,43,0,76,0,56,0,37,0,26,0,31,0,25,0,14,0,35,0,16,0,60,0,57,0,97,0,75,0,114,0,91,0,54,0,73,0,55,0,41,0,48,0,53,0,23,0,24,0,58,0,27,0,50,0,96,0,76,0,70,0,93,0,84,0,77,0,58,0,79,0,29,0,74,0,49,0,41,0,17,0,47,0,45,0,78,0,74,0,115,0,94,0,90,0,79,0,69,0,83,0,71,0,50,0,59,0,38,0,36,0,15,0,72,0,34,0,56,0,95,0,92,0,85,0,91,0,90,0,86,0,73,0,77,0,65,0,51,0,44,0,43,0,42,0,43,0,20,0,30,0,44,0,55,0,78,0,72,0,87,0,78,0,61,0,46,0,54,0,37,0,30,0,20,0,16,0,53,0,25,0,41,0,37,0,44,0,59,0,54,0,81,0,66,0,76,0,57,0,54,0,37,0,18,0,39,0,11,0,35,0,33,0,31,0,57,0,42,0,82,0,72,0,80,0,47,0,58,0,55,0,21,0,22,0,26,0,38,0,22,0,53,0,25,0,23,0,38,0,70,0,60,0,51,0,36,0,55,0,26,0,34,0,23,0,27,0,14,0,9,0,7,0,34,0,32,0,28,0,39,0,49,0,75,0,30,0,52,0,48,0,40,0,52,0,28,0,18,0,17,0,9,0,5,0,45,0,21,0,34,0,64,0,56,0,50,0,49,0,45,0,31,0,19,0,12,0,15,0,10,0,7,0,6,0,3,0,48,0,23,0,20,0,39,0,36,0,35,0,53,0,21,0,16,0,23,0,13,0,10,0,6,0,1,0,4,0,2,0,16,0,15,0,17,0,27,0,25,0,20,0,29,0,11,0,17,0,12,0,16,0,8,0,1,0,1,0,0,0,1,0,1,5,7,8,9,10,10,11,10,11,12,12,13,13,14,14,4,6,8,9,10,10,11,11,11,11,12,12,13,14,14,14,7,8,9,10,11,11,12,12,11,12,12,13,13,14,15,15,8,9,10,11,11,12,12,12,12,13,13,13,13,14,15,15,9,9,11,11,12,12,13,13,12,13,13,14,14,15,15,16,10,10,11,12,12,12,13,13,13,13,14,13,15,15,16,16,10,11,12,12,13,13,13,13,13,14,14,14,15,15,16,16,11,11,12,13,13,13,14,14,14,14,15,15,15,16,18,18,10,10,11,12,12,13,13,14,14,14,14,15,15,16,17,17,11,11,12,12,13,13,13,15,14,15,15,16,16,16,18,17,11,12,12,13,13,14,14,15,14,15,16,15,16,17,18,19,12,12,12,13,14,14,14,14,15,15,15,16,17,17,17,18,12,13,13,14,14,15,14,15,16,16,17,17,17,18,18,18,13,13,14,15,15,15,16,16,16,16,16,17,18,17,18,18,14,14,14,15,15,15,17,16,16,19,17,17,17,19,18,18,13,14,15,16,16,16,17,16,17,17,18,18,21,20,21,18,1,5,7,9,10,10,11,11,12,12,12,13,13,13,14,11,4,6,8,9,10,11,11,11,12,12,12,13,14,13,14,11,7,8,9,10,11,11,12,12,13,12,13,13,13,14,14,12,9,9,10,11,11,12,12,12,13,13,14,14,14,15,15,13,10,10,11,11,12,12,13,13,13,14,14,14,15,15,15,12,10,10,11,11,12,13,13,14,13,14,14,15,15,15,16,13,11,11,11,12,13,13,13,13,14,14,14,14,15,15,16,13,11,11,12,12,13,13,13,14,14,15,15,15,15,17,17,13,11,12,12,13,13,13,14,14,15,15,15,15,16,16,16,13,12,12,12,13,13,14,14,15,15,15,15,16,15,16,15,14,12,13,12,13,14,14,14,14,15,16,16,16,17,17,16,13,13,13,13,13,14,14,15,16,16,16,16,16,16,15,16,14,13,14,14,14,14,15,15,15,15,17,16,16,16,16,18,14,15,14,14,14,15,15,16,16,16,18,17,17,17,19,17,14,14,15,13,14,16,16,15,16,16,17,18,17,19,17,16,14,11,11,11,12,12,13,13,13,14,14,14,14,14,14,14,12,7,0,12,0,18,0,53,0,47,0,76,0,124,0,108,0,89,0,123,0,108,0,119,0,107,0,81,0,122,0,63,0,13,0,5,0,16,0,27,0,46,0,36,0,61,0,51,0,42,0,70,0,52,0,83,0,65,0,41,0,59,0,36,0,19,0,17,0,15,0,24,0,41,0,34,0,59,0,48,0,40,0,64,0,50,0,78,0,62,0,80,0,56,0,33,0,29,0,28,0,25,0,43,0,39,0,63,0,55,0,93,0,76,0,59,0,93,0,72,0,54,0,75,0,50,0,29,0,52,0,22,0,42,0,40,0,67,0,57,0,95,0,79,0,72,0,57,0,89,0,69,0,49,0,66,0,46,0,27,0,77,0,37,0,35,0,66,0,58,0,52,0,91,0,74,0,62,0,48,0,79,0,63,0,90,0,62,0,40,0,38,0,125,0,32,0,60,0,56,0,50,0,92,0,78,0,65,0,55,0,87,0,71,0,51,0,73,0,51,0,70,0,30,0,109,0,53,0,49,0,94,0,88,0,75,0,66,0,122,0,91,0,73,0,56,0,42,0,64,0,44,0,21,0,25,0,90,0,43,0,41,0,77,0,73,0,63,0,56,0,92,0,77,0,66,0,47,0,67,0,48,0,53,0,36,0,20,0,71,0,34,0,67,0,60,0,58,0,49,0,88,0,76,0,67,0,106,0,71,0,54,0,38,0,39,0,23,0,15,0,109,0,53,0,51,0,47,0,90,0,82,0,58,0,57,0,48,0,72,0,57,0,41,0,23,0,27,0,62,0,9,0,86,0,42,0,40,0,37,0,70,0,64,0,52,0,43,0,70,0,55,0,42,0,25,0,29,0,18,0,11,0,11,0,118,0,68,0,30,0,55,0,50,0,46,0,74,0,65,0,49,0,39,0,24,0,16,0,22,0,13,0,14,0,7,0,91,0,44,0,39,0,38,0,34,0,63,0,52,0,45,0,31,0,52,0,28,0,19,0,14,0,8,0,9,0,3,0,123,0,60,0,58,0,53,0,47,0,43,0,32,0,22,0,37,0,24,0,17,0,12,0,15,0,10,0,2,0,1,0,71,0,37,0,34,0,30,0,28,0,20,0,17,0,26,0,21,0,16,0,10,0,6,0,8,0,6,0,2,0,0,0,3,5,6,8,8,9,10,10,10,11,11,12,12,12,13,14,5,5,7,8,9,9,10,10,10,11,11,12,12,12,13,13,6,7,7,8,9,9,10,10,10,11,11,12,12,13,13,13,7,8,8,9,9,10,10,11,11,11,12,12,12,13,13,13,8,8,9,9,10,10,11,11,11,11,12,12,12,13,13,13,9,9,9,10,10,10,11,11,11,11,12,12,13,13,13,14,10,9,10,10,10,11,11,11,11,12,12,12,13,13,14,14,10,10,10,11,11,11,11,12,12,12,12,12,13,13,13,14,10,10,10,11,11,11,11,12,12,12,12,13,13,14,14,14,10,10,11,11,11,11,12,12,12,13,13,13,13,14,14,14,11,11,11,11,12,12,12,12,12,13,13,13,13,14,15,14,11,11,11,11,12,12,12,12,13,13,13,13,14,14,14,15,12,12,11,12,12,12,13,13,13,13,13,13,14,14,15,15,12,12,12,12,12,13,13,13,13,14,14,14,14,14,15,15,13,13,13,13,13,13,13,13,14,14,14,14,15,15,14,15,13,13,13,13,13,13,13,14,14,14,14,14,15,15,15,15,1,0,5,0,14,0,44,0,74,0,63,0,110,0,93,0,172,0,149,0,138,0,242,0,225,0,195,0,120,1,17,0,3,0,4,0,12,0,20,0,35,0,62,0,53,0,47,0,83,0,75,0,68,0,119,0,201,0,107,0,207,0,9,0,15,0,13,0,23,0,38,0,67,0,58,0,103,0,90,0,161,0,72,0,127,0,117,0,110,0,209,0,206,0,16,0,45,0,21,0,39,0,69,0,64,0,114,0,99,0,87,0,158,0,140,0,252,0,212,0,199,0,131,1,109,1,26,0,75,0,36,0,68,0,65,0,115,0,101,0,179,0,164,0,155,0,8,1,246,0,226,0,139,1,126,1,106,1,9,0,66,0,30,0,59,0,56,0,102,0,185,0,173,0,9,1,142,0,253,0,232,0,144,1,132,1,122,1,189,1,16,0,111,0,54,0,52,0,100,0,184,0,178,0,160,0,133,0,1,1,244,0,228,0,217,0,129,1,110,1,203,2,10,0,98,0,48,0,91,0,88,0,165,0,157,0,148,0,5,1,248,0,151,1,141,1,116,1,124,1,121,3,116,3,8,0,85,0,84,0,81,0,159,0,156,0,143,0,4,1,249,0,171,1,145,1,136,1,127,1,215,2,201,2,196,2,7,0,154,0,76,0,73,0,141,0,131,0,0,1,245,0,170,1,150,1,138,1,128,1,223,2,103,1,198,2,96,1,11,0,139,0,129,0,67,0,125,0,247,0,233,0,229,0,219,0,137,1,231,2,225,2,208,2,117,3,114,3,183,1,4,0,243,0,120,0,118,0,115,0,227,0,223,0,140,1,234,2,230,2,224,2,209,2,200,2,194,2,223,0,180,1,6,0,202,0,224,0,222,0,218,0,216,0,133,1,130,1,125,1,108,1,120,3,187,1,195,2,184,1,181,1,192,6,4,0,235,2,211,0,210,0,208,0,114,1,123,1,222,2,211,2,202,2,199,6,115,3,109,3,108,3,131,13,97,3,2,0,121,1,113,1,102,0,187,0,214,2,210,2,102,1,199,2,197,2,98,3,198,6,103,3,130,13,102,3,178,1,0,0,12,0,10,0,7,0,11,0,10,0,17,0,11,0,9,0,13,0,12,0,10,0,7,0,5,0,3,0,1,0,3,0,1,5,7,9,10,10,11,11,12,12,12,13,13,13,14,10,4,6,8,9,10,11,11,11,12,12,12,13,14,13,14,10,7,8,9,10,11,11,12,12,13,12,13,13,13,14,14,11,9,9,10,11,11,12,12,12,13,13,14,14,14,15,15,12,10,10,11,11,12,12,13,13,13,14,14,14,15,15,15,11,10,10,11,11,12,13,13,14,13,14,14,15,15,15,16,12,11,11,11,12,13,13,13,13,14,14,14,14,15,15,16,12,11,11,12,12,13,13,13,14,14,15,15,15,15,17,17,12,11,12,12,13,13,13,14,14,15,15,15,15,16,16,16,12,12,12,12,13,13,14,14,15,15,15,15,16,15,16,15,13,12,13,12,13,14,14,14,14,15,16,16,16,17,17,16,12,13,13,13,13,14,14,15,16,16,16,16,16,16,15,16,13,13,14,14,14,14,15,15,15,15,17,16,16,16,16,18,13,15,14,14,14,15,15,16,16,16,18,17,17,17,19,17,13,14,15,13,14,16,16,15,16,16,17,18,17,19,17,16,13,10,10,10,11,11,12,12,12,13,13,13,13,13,13,13,10,15,0,13,0,46,0,80,0,146,0,6,1,248,0,178,1,170,1,157,2,141,2,137,2,109,2,5,2,8,4,88,0,14,0,12,0,21,0,38,0,71,0,130,0,122,0,216,0,209,0,198,0,71,1,89,1,63,1,41,1,23,1,42,0,47,0,22,0,41,0,74,0,68,0,128,0,120,0,221,0,207,0,194,0,182,0,84,1,59,1,39,1,29,2,18,0,81,0,39,0,75,0,70,0,134,0,125,0,116,0,220,0,204,0,190,0,178,0,69,1,55,1,37,1,15,1,16,0,147,0,72,0,69,0,135,0,127,0,118,0,112,0,210,0,200,0,188,0,96,1,67,1,50,1,29,1,28,2,14,0,7,1,66,0,129,0,126,0,119,0,114,0,214,0,202,0,192,0,180,0,85,1,61,1,45,1,25,1,6,1,12,0,249,0,123,0,121,0,117,0,113,0,215,0,206,0,195,0,185,0,91,1,74,1,52,1,35,1,16,1,8,2,10,0,179,1,115,0,111,0,109,0,211,0,203,0,196,0,187,0,97,1,76,1,57,1,42,1,27,1,19,2,125,1,17,0,171,1,212,0,208,0,205,0,201,0,193,0,186,0,177,0,169,0,64,1,47,1,30,1,12,1,2,2,121,1,16,0,79,1,199,0,197,0,191,0,189,0,181,0,174,0,77,1,65,1,49,1,33,1,19,1,9,2,123,1,115,1,11,0,156,2,184,0,183,0,179,0,175,0,88,1,75,1,58,1,48,1,34,1,21,1,18,2,127,1,117,1,110,1,10,0,140,2,90,1,171,0,168,0,164,0,62,1,53,1,43,1,31,1,20,1,7,1,1,2,119,1,112,1,106,1,6,0,136,2,66,1,60,1,56,1,51,1,46,1,36,1,28,1,13,1,5,1,0,2,120,1,114,1,108,1,103,1,4,0,108,2,44,1,40,1,38,1,32,1,26,1,17,1,10,1,3,2,124,1,118,1,113,1,109,1,105,1,101,1,2,0,9,4,24,1,22,1,18,1,11,1,8,1,3,1,126,1,122,1,116,1,111,1,107,1,104,1,102,1,100,1,0,0,43,0,20,0,19,0,17,0,15,0,13,0,11,0,9,0,7,0,6,0,4,0,7,0,5,0,3,0,1,0,3,0,4,5,7,8,9,10,10,11,11,12,12,12,12,12,13,10,5,6,7,8,9,10,10,11,11,11,12,12,12,12,12,10,7,7,8,9,9,10,10,11,11,11,11,12,12,12,13,9,8,8,9,9,10,10,10,11,11,11,11,12,12,12,12,9,9,9,9,10,10,10,10,11,11,11,12,12,12,12,13,9,10,9,10,10,10,10,11,11,11,11,12,12,12,12,12,9,10,10,10,10,10,11,11,11,11,12,12,12,12,12,13,9,11,10,10,10,11,11,11,11,12,12,12,12,12,13,13,10,11,11,11,11,11,11,11,11,11,12,12,12,12,13,13,10,11,11,11,11,11,11,11,12,12,12,12,12,13,13,13,10,12,11,11,11,11,12,12,12,12,12,12,13,13,13,13,10,12,12,11,11,11,12,12,12,12,12,12,13,13,13,13,10,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,10,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,10,13,12,12,12,12,12,12,13,13,13,13,13,13,13,13,10,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,6,1,0,10,0,8,0,20,0,12,0,20,0,16,0,32,0,14,0,12,0,24,0,0,0,28,0,16,0,24,0,16,0,15,0,28,0,26,0,48,0,22,0,40,0,36,0,64,0,14,0,24,0,20,0,32,0,12,0,16,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,8,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,16,0,0,0,16,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,4,0,0,0,8,0,0,0,0,0,0,0,18,0,0,0,36,0,0,0,54,0,0,0,51,0,0,0,35,0,0,0,53,0,0,0,71,0,0,0,52,0,0,0,70,0,0,0,88,0,0,0,69,0,0,0,87,0,0,0,105,0,0,0,104,0,0,0,122,0,0,0,0,0,0,0,18,0,0,0,36,0,0,0,54,0,0,0,54,0,0,0,36,0,0,0,54,0,0,0,72,0,0,0,54,0,0,0,72,0,0,0,90,0,0,0,72,0,0,0,90,0,0,0,108,0,0,0,108,0,0,0,126,0,0,0,0,0,0,0,10,0,0,0,20,0,0,0,30,0,0,0,33,0,0,0,21,0,0,0,31,0,0,0,41,0,0,0,32,0,0,0,42,0,0,0,52,0,0,0,43,0,0,0,53,0,0,0,63,0,0,0,64,0,0,0,74,0,0,0,15,0,0,0,15,0,0,0,7,0,0,0,7,0,0,0,15,0,0,0,15,0,0,0,7,0,0,0,0,0,0,0,7,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,31,0,0,0,31,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,3,0,0,0,4,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,4,0,0,0,5,0,0,0,4,0,0,0,6,0,0,0,5,0,0,0,6,0,0,0,5,0,0,0,6,0,0,0,5,0,0,0,7,0,0,0,6,0,0,0,7,0,0,0,6,0,0,0,7,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,5,0,0,0,7,0,0,0,7,0,0,0,10,0,0,0,10,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,0,0,0,0,8,0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,80,0,0,0,96,0,0,0,112,0,0,0,128,0,0,0,160,0,0,0,192,0,0,0,224,0,0,0,0,1,0,0,64,1], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+82224);
/* memory initializer */ allocate([51,46,57,57,46,53,0,0,93,61,127,102,158,160,230,63,0,0,0,0,0,136,57,61,68,23,117,250,82,176,230,63,0,0,0,0,0,0,216,60,254,217,11,117,18,192,230,63,0,0,0,0,0,120,40,189,191,118,212,221,220,207,230,63,0,0,0,0,0,192,30,61,41,26,101,60,178,223,230,63,0,0,0,0,0,0,216,188,227,58,89,152,146,239,230,63,0,0,0,0,0,0,188,188,134,147,81,249,125,255,230,63,0,0,0,0,0,216,47,189,163,45,244,102,116,15,231,63,0,0,0,0,0,136,44,189,195,95,236,232,117,31,231,63,0,0,0,0,0,192,19,61,5,207,234,134,130,47,231,63,0,0,0,0,0,48,56,189,82,129,165,72,154,63,231,63,0,0,0,0,0,192,0,189,252,204,215,53,189,79,231,63,0,0,0,0,0,136,47,61,241,103,66,86,235,95,231,63,0,0,0,0,0,224,3,61,72,109,171,177,36,112,231,63,0,0,0,0,0,208,39,189,56,93,222,79,105,128,231,63,0,0,0,0,0,0,221,188,0,29,172,56,185,144,231,63,0,0,0,0,0,0,227,60,120,1,235,115,20,161,231,63,0,0,0,0,0,0,237,188,96,208,118,9,123,177,231,63,0,0,0,0,0,64,32,61,51,193,48,1,237,193,231,63,0,0,0,0,0,0,160,60,54,134,255,98,106,210,231,63,0,0,0,0,0,144,38,189,59,78,207,54,243,226,231,63,0,0,0,0,0,224,2,189,232,195,145,132,135,243,231,63,0,0,0,0,0,88,36,189,78,27,62,84,39,4,232,63,0,0,0,0,0,0,51,61,26,7,209,173,210,20,232,63,0,0,0,0,0,0,15,61,126,205,76,153,137,37,232,63,0,0,0,0,0,192,33,189,208,66,185,30,76,54,232,63,0,0,0,0,0,208,41,61,181,202,35,70,26,71,232,63,0,0,0,0,0,16,71,61,188,91,159,23,244,87,232,63,0,0,0,0,0,96,34,61,175,145,68,155,217,104,232,63,0,0,0,0,0,196,50,189,149,163,49,217,202,121,232,63,0,0,0,0,0,0,35,189,184,101,138,217,199,138,232,63,0,0,0,0,0,128,42,189,0,88,120,164,208,155,232,63,0,0,0,0,0,0,237,188,35,162,42,66,229,172,232,63,0,0,0,0,0,40,51,61,250,25,214,186,5,190,232,63,0,0,0,0,0,180,66,61,131,67,181,22,50,207,232,63,0,0,0,0,0,208,46,189,76,102,8,94,106,224,232,63,0,0,0,0,0,80,32,189,7,120,21,153,174,241,232,63,0,0,0,0,0,40,40,61,14,44,40,208,254,2,233,63,0,0,0,0,0,176,28,189,150,255,145,11,91,20,233,63,0,0,0,0,0,224,5,189,249,47,170,83,195,37,233,63,0,0,0,0,0,64,245,60,74,198,205,176,55,55,233,63,0,0,0,0,0,32,23,61,174,152,95,43,184,72,233,63,0,0,0,0,0,0,9,189,203,82,200,203,68,90,233,63,0,0,0,0,0,104,37,61,33,111,118,154,221,107,233,63,0,0,0,0,0,208,54,189,42,78,222,159,130,125,233,63,0,0,0,0,0,0,1,189,163,35,122,228,51,143,233,63,0,0,0,0,0,0,45,61,4,6,202,112,241,160,233,63,0,0,0,0,0,164,56,189,137,255,83,77,187,178,233,63,0,0,0,0,0,92,53,61,91,241,163,130,145,196,233,63,0,0,0,0,0,184,38,61,197,184,75,25,116,214,233,63,0,0,0,0,0,0,236,188,142,35,227,25,99,232,233,63,0,0,0,0,0,208,23,61,2,243,7,141,94,250,233,63,0,0,0,0,0,64,22,61,77,229,93,123,102,12,234,63,0,0,0,0,0,0,245,188,246,184,142,237,122,30,234,63,0,0,0,0,0,224,9,61,39,46,74,236,155,48,234,63,0,0,0,0,0,216,42,61,93,10,70,128,201,66,234,63,0,0,0,0,0,240,26,189,155,37,62,178,3,85,234,63,0,0,0,0,0,96,11,61,19,98,244,138,74,103,234,63,0,0,0,0,0,136,56,61,167,179,48,19,158,121,234,63,0,0,0,0,0,32,17,61,141,46,193,83,254,139,234,63,0,0,0,0,0,192,6,61,210,252,121,85,107,158,234,63,0,0,0,0,0,184,41,189,184,111,53,33,229,176,234,63,0,0,0,0,0,112,43,61,129,243,211,191,107,195,234,63,0,0,0,0,0,0,217,60,128,39,60,58,255,213,234,63,0,0,0,0,0,0,228,60,163,210,90,153,159,232,234,63,0,0,0,0,0,144,44,189,103,243,34,230,76,251,234,63,0,0,0,0,0,80,22,61,144,183,141,41,7,14,235,63,0,0,0,0,0,212,47,61,169,137,154,108,206,32,235,63,0,0,0,0,0,112,18,61,75,26,79,184,162,51,235,63,0,0,0,0,0,71,77,61,231,71,183,21,132,70,235,63,0,0,0,0,0,56,56,189,58,89,229,141,114,89,235,63,0,0,0,0,0,0,152,60,106,197,241,41,110,108,235,63,0,0,0,0,0,208,10,61,80,94,251,242,118,127,235,63,0,0,0,0,0,128,222,60,178,73,39,242,140,146,235,63,0,0,0,0,0,192,4,189,3,6,161,48,176,165,235,63,0,0,0,0,0,112,13,189,102,111,154,183,224,184,235,63,0,0,0,0,0,144,13,61,255,193,75,144,30,204,235,63,0,0,0,0,0,160,2,61,111,161,243,195,105,223,235,63,0,0,0,0,0,120,31,189,184,29,215,91,194,242,235,63,0,0,0,0,0,160,16,189,233,178,65,97,40,6,236,63,0,0,0,0,0,64,17,189,224,82,133,221,155,25,236,63,0,0,0,0,0,224,11,61,238,100,250,217,28,45,236,63,0,0,0,0,0,64,9,189,47,208,255,95,171,64,236,63,0,0,0,0,0,208,14,189,21,253,250,120,71,84,236,63,0,0,0,0,0,102,57,61,203,208,87,46,241,103,236,63,0,0,0,0,0,16,26,189,182,193,136,137,168,123,236,63,0,0,0,0,128,69,88,189,51,231,6,148,109,143,236,63,0,0,0,0,0,72,26,189,223,196,81,87,64,163,236,63,0,0,0,0,0,0,203,60,148,144,239,220,32,183,236,63,0,0,0,0,0,64,1,61,137,22,109,46,15,203,236,63,0,0,0,0,0,32,240,60,18,196,93,85,11,223,236,63,0,0,0,0,0,96,243,60,59,171,91,91,21,243,236,63,0,0,0,0,0,144,6,189,188,137,7,74,45,7,237,63,0,0,0,0,0,160,9,61,250,200,8,43,83,27,237,63,0,0,0,0,0,224,21,189,133,138,13,8,135,47,237,63,0,0,0,0,0,40,29,61,3,162,202,234,200,67,237,63,0,0,0,0,0,160,1,61,145,164,251,220,24,88,237,63,0,0,0,0,0,0,223,60,161,230,98,232,118,108,237,63,0,0,0,0,0,160,3,189,78,131,201,22,227,128,237,63,0,0,0,0,0,216,12,189,144,96,255,113,93,149,237,63,0,0,0,0,0,192,244,60,174,50,219,3,230,169,237,63,0,0,0,0,0,144,255,60,37,131,58,214,124,190,237,63,0,0,0,0,0,128,233,60,69,180,1,243,33,211,237,63,0,0,0,0,0,32,245,188,191,5,28,100,213,231,237,63,0,0,0,0,0,112,29,189,236,154,123,51,151,252,237,63,0,0,0,0,0,20,22,189,94,125,25,107,103,17,238,63,0,0,0,0,0,72,11,61,231,163,245,20,70,38,238,63,0,0,0,0,0,206,64,61,92,238,22,59,51,59,238,63,0,0,0,0,0,104,12,61,180,63,139,231,46,80,238,63,0,0,0,0,0,48,9,189,104,109,103,36,57,101,238,63,0,0,0,0,0,0,229,188,68,76,199,251,81,122,238,63,0,0,0,0,0,248,7,189,38,183,205,119,121,143,238,63,0,0,0,0,0,112,243,188,232,144,164,162,175,164,238,63,0,0,0,0,0,208,229,60,228,202,124,134,244,185,238,63,0,0,0,0,0,26,22,61,13,104,142,45,72,207,238,63,0,0,0,0,0,80,245,60,20,133,24,162,170,228,238,63,0,0,0,0,0,64,198,60,19,90,97,238,27,250,238,63,0,0,0,0,0,128,238,188,6,65,182,28,156,15,239,63,0,0,0,0,0,136,250,188,99,185,107,55,43,37,239,63,0,0,0,0,0,144,44,189,117,114,221,72,201,58,239,63,0,0,0,0,0,0,170,60,36,69,110,91,118,80,239,63,0,0,0,0,0,240,244,188,253,68,136,121,50,102,239,63,0,0,0,0,0,128,202,60,56,190,156,173,253,123,239,63,0,0,0,0,0,188,250,60,130,60,36,2,216,145,239,63,0,0,0,0,0,96,212,188,142,144,158,129,193,167,239,63,0,0,0,0,0,12,11,189,17,213,146,54,186,189,239,63,0,0,0,0,0,224,192,188,148,113,143,43,194,211,239,63,0,0,0,0,128,222,16,189,238,35,42,107,217,233,239,63,0,0,0,0,0,67,238,60,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,190,188,90,250,26,11,240,63,0,0,0,0,0,64,179,188,3,51,251,169,61,22,240,63,0,0,0,0,0,23,18,189,130,2,59,20,104,33,240,63,0,0,0,0,0,64,186,60,108,128,119,62,154,44,240,63,0,0,0,0,0,152,239,60,202,187,17,46,212,55,240,63,0,0,0,0,0,64,199,188,137,127,110,232,21,67,240,63,0,0,0,0,0,48,216,60,103,84,246,114,95,78,240,63,0,0,0,0,0,63,26,189,90,133,21,211,176,89,240,63,0,0,0,0,0,132,2,189,149,31,60,14,10,101,240,63,0,0,0,0,0,96,241,60,26,247,221,41,107,112,240,63,0,0,0,0,0,36,21,61,45,168,114,43,212,123,240,63,0,0,0,0,0,160,233,188,208,155,117,24,69,135,240,63,0,0,0,0,0,64,230,60,200,7,102,246,189,146,240,63,0,0,0,0,0,120,0,189,131,243,198,202,62,158,240,63,0,0,0,0,0,0,152,188,48,57,31,155,199,169,240,63,0,0,0,0,0,160,255,60,252,136,249,108,88,181,240,63,0,0,0,0,0,200,250,188,138,108,228,69,241,192,240,63,0,0,0,0,0,192,217,60,22,72,114,43,146,204,240,63,0,0,0,0,0,32,5,61,216,93,57,35,59,216,240,63,0,0,0,0,0,208,250,188,243,209,211,50,236,227,240,63,0,0,0,0,0,172,27,61,166,169,223,95,165,239,240,63,0,0,0,0,0,232,4,189,240,210,254,175,102,251,240,63,0,0,0,0,0,48,13,189,75,35,215,40,48,7,241,63,0,0,0,0,0,80,241,60,91,91,18,208,1,19,241,63,0,0,0,0,0,0,236,60,249,42,94,171,219,30,241,63,0,0,0,0,0,188,22,61,213,49,108,192,189,42,241,63,0,0,0,0,0,64,232,60,125,4,242,20,168,54,241,63,0,0,0,0,0,208,14,189,233,45,169,174,154,66,241,63,0,0,0,0,0,224,232,60,56,49,79,147,149,78,241,63,0,0,0,0,0,64,235,60,113,142,165,200,152,90,241,63,0,0,0,0,0,48,5,61,223,195,113,84,164,102,241,63,0,0,0,0,0,56,3,61,17,82,125,60,184,114,241,63,0,0,0,0,0,212,40,61,159,187,149,134,212,126,241,63,0,0,0,0,0,208,5,189,147,141,140,56,249,138,241,63,0,0,0,0,0,136,28,189,102,93,55,88,38,151,241,63,0,0,0,0,0,240,17,61,167,203,111,235,91,163,241,63,0,0,0,0,0,72,16,61,227,135,19,248,153,175,241,63,0,0,0,0,0,57,71,189,84,93,4,132,224,187,241,63,0,0,0,0,0,228,36,61,67,28,40,149,47,200,241,63,0,0,0,0,0,32,10,189,178,185,104,49,135,212,241,63,0,0,0,0,0,128,227,60,49,64,180,94,231,224,241,63,0,0,0,0,0,192,234,60,56,217,252,34,80,237,241,63,0,0,0,0,0,144,1,61,247,205,56,132,193,249,241,63,0,0,0,0,0,120,27,189,143,141,98,136,59,6,242,63,0,0,0,0,0,148,45,61,30,168,120,53,190,18,242,63,0,0,0,0,0,0,216,60,65,221,125,145,73,31,242,63,0,0,0,0,0,52,43,61,35,19,121,162,221,43,242,63,0,0,0,0,0,248,25,61,231,97,117,110,122,56,242,63,0,0,0,0,0,200,25,189,39,20,130,251,31,69,242,63,0,0,0,0,0,48,2,61,2,166,178,79,206,81,242,63,0,0,0,0,0,72,19,189,176,206,30,113,133,94,242,63,0,0,0,0,0,112,18,61,22,125,226,101,69,107,242,63,0,0,0,0,0,208,17,61,15,224,29,52,14,120,242,63,0,0,0,0,0,238,49,61,62,99,245,225,223,132,242,63,0,0,0,0,0,192,20,189,48,187,145,117,186,145,242,63,0,0,0,0,0,216,19,189,9,223,31,245,157,158,242,63,0,0,0,0,0,176,8,61,155,14,209,102,138,171,242,63,0,0,0,0,0,124,34,189,58,218,218,208,127,184,242,63,0,0,0,0,0,52,42,61,249,26,119,57,126,197,242,63,0,0,0,0,0,128,16,189,217,2,228,166,133,210,242,63,0,0,0,0,0,208,14,189,121,21,100,31,150,223,242,63,0,0,0,0,0,32,244,188,207,46,62,169,175,236,242,63,0,0,0,0,0,152,36,189,34,136,189,74,210,249,242,63,0,0,0,0,0,48,22,189,37,182,49,10,254,6,243,63,0,0,0,0,0,54,50,189,11,165,238,237,50,20,243,63,0,0,0,0,128,223,112,189,184,215,76,252,112,33,243,63,0,0,0,0,0,72,34,189,162,233,168,59,184,46,243,63,0,0,0,0,0,152,37,189,102,23,100,178,8,60,243,63,0,0,0,0,0,208,30,61,39,250,227,102,98,73,243,63,0,0,0,0,0,0,220,188,15,159,146,95,197,86,243,63,0,0,0,0,0,216,48,189,185,136,222,162,49,100,243,63,0,0,0,0,0,200,34,61,57,170,58,55,167,113,243,63,0,0,0,0,0,96,32,61,254,116,30,35,38,127,243,63,0,0,0,0,0,96,22,189,56,216,5,109,174,140,243,63,0,0,0,0,0,224,10,189,195,62,113,27,64,154,243,63,0,0,0,0,0,114,68,189,32,160,229,52,219,167,243,63,0,0,0,0,0,32,8,61,149,110,236,191,127,181,243,63,0,0,0,0,0,128,62,61,242,168,19,195,45,195,243,63,0,0,0,0,0,128,239,60,34,225,237,68,229,208,243,63,0,0,0,0,0,160,23,189,187,52,18,76,166,222,243,63,0,0,0,0,0,48,38,61,204,78,28,223,112,236,243,63,0,0,0,0,0,166,72,189,140,126,172,4,69,250,243,63,0,0,0,0,0,220,60,189,187,160,103,195,34,8,244,63,0,0,0,0,0,184,37,61,149,46,247,33,10,22,244,63,0,0,0,0,0,192,30,61,70,70,9,39,251,35,244,63,0,0,0,0,0,96,19,189,32,169,80,217,245,49,244,63,0,0,0,0,0,152,35,61,235,185,132,63,250,63,244,63,0,0,0,0,0,0,250,60,25,137,97,96,8,78,244,63,0,0,0,0,0,192,246,188,1,210,167,66,32,92,244,63,0,0,0,0,0,192,11,189,22,0,29,237,65,106,244,63,0,0,0,0,0,128,18,189,38,51,139,102,109,120,244,63,0,0,0,0,0,224,48,61,0,60,193,181,162,134,244,63,0,0,0,0,0,64,45,189,4,175,146,225,225,148,244,63,0,0,0,0,0,32,12,61,114,211,215,240,42,163,244,63,0,0,0,0,0,80,30,189,1,184,109,234,125,177,244,63,0,0,0,0,0,128,7,61,225,41,54,213,218,191,244,63,0,0,0,0,0,128,19,189,50,193,23,184,65,206,244,63,0,0,0,0,0,128,0,61,219,221,253,153,178,220,244,63,0,0,0,0,0,112,44,61,150,171,216,129,45,235,244,63,0,0,0,0,0,224,28,189,2,45,157,118,178,249,244,63,0,0,0,0,0,32,25,61,193,49,69,127,65,8,245,63,0,0,0,0,0,192,8,189,42,102,207,162,218,22,245,63,0,0,0,0,0,0,250,188,234,81,63,232,125,37,245,63,0,0,0,0,0,8,74,61,218,78,157,86,43,52,245,63,0,0,0,0,0,216,38,189,26,172,246,244,226,66,245,63,0,0,0,0,0,68,50,189,219,148,93,202,164,81,245,63,0,0,0,0,0,60,72,61,107,17,233,221,112,96,245,63,0,0,0,0,0,176,36,61,222,41,181,54,71,111,245,63,0,0,0,0,0,90,65,61,14,196,226,219,39,126,245,63,0,0,0,0,0,224,41,189,111,199,151,212,18,141,245,63,0,0,0,0,0,8,35,189,76,11,255,39,8,156,245,63,0,0,0,0,0,236,77,61,39,84,72,221,7,171,245,63,0,0,0,0,0,0,196,188,244,122,168,251,17,186,245,63,0,0,0,0,0,8,48,61,11,70,89,138,38,201,245,63,0,0,0,0,0,200,38,189,63,142,153,144,69,216,245,63,0,0,0,0,0,154,70,61,225,32,173,21,111,231,245,63,0,0,0,0,0,64,27,189,202,235,220,32,163,246,245,63,0,0,0,0,0,112,23,61,184,220,118,185,225,5,246,63,0,0,0,0,0,248,38,61,21,247,205,230,42,21,246,63,0,0,0,0,0,0,1,61,49,85,58,176,126,36,246,63,0,0,0,0,0,208,21,189,181,41,25,29,221,51,246,63,0,0,0,0,0,208,18,189,19,195,204,52,70,67,246,63,0,0,0,0,0,128,234,188,250,142,188,254,185,82,246,63,0,0,0,0,0,96,40,189,151,51,85,130,56,98,246,63,0,0,0,0,0,254,113,61,142,50,8,199,193,113,246,63,0,0,0,0,0,32,55,189,126,169,76,212,85,129,246,63,0,0,0,0,0,128,230,60,113,148,158,177,244,144,246,63,0,0,0,0,0,120,41,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,0,0,0,0,0,0,40,110,117,108,108,41,0,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,0,0,0,0,0,105,110,102,0,0,0,0,0,73,78,70,0,0,0,0,0,110,97,110,0,0,0,0,0,78,65,78,0,0,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+91696);





/* no memory initializer */
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);

assert(tempDoublePtr % 8 == 0);

function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

}

function copyTempDouble(ptr) {

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];

  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];

  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];

  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];

}

// {{PRE_LIBRARY}}


  function _InitGainAnalysis() {
  Module['printErr']('missing function: InitGainAnalysis'); abort(-1);
  }

  function _AnalyzeSamples() {
  Module['printErr']('missing function: AnalyzeSamples'); abort(-1);
  }

   
  Module["_i64Subtract"] = _i64Subtract;

  var _fabsf=Math_abs;

  var _floorf=Math_floor;

   
  Module["_memset"] = _memset;

  var _BDtoILow=true;

  
  
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};
  
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};
  
  
  var ___errno_state=0;function ___setErrNo(value) {
      // For convenient setting and returning of errno.
      HEAP32[((___errno_state)>>2)]=value;
      return value;
    }function _strerror_r(errnum, strerrbuf, buflen) {
      if (errnum in ERRNO_MESSAGES) {
        if (ERRNO_MESSAGES[errnum].length > buflen - 1) {
          return ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          var msg = ERRNO_MESSAGES[errnum];
          writeAsciiToMemory(msg, strerrbuf);
          return 0;
        }
      } else {
        return ___setErrNo(ERRNO_CODES.EINVAL);
      }
    }function _strerror(errnum) {
      if (!_strerror.buffer) _strerror.buffer = _malloc(256);
      _strerror_r(errnum, _strerror.buffer, 256);
      return _strerror.buffer;
    }

  function _VBR_encode_frame() {
  Module['printErr']('missing function: VBR_encode_frame'); abort(-1);
  }

  function _abort() {
      Module['abort']();
    }

  function _init_xrpow_core_sse() {
  Module['printErr']('missing function: init_xrpow_core_sse'); abort(-1);
  }

  
  
  var PATH={splitPath:function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up--; up) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function (path) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var lastSlash = path.lastIndexOf('/');
        if (lastSlash === -1) return path;
        return path.substr(lastSlash+1);
      },extname:function (path) {
        return PATH.splitPath(path)[3];
      },join:function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join('/'));
      },join2:function (l, r) {
        return PATH.normalize(l + '/' + r);
      },resolve:function () {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            return ''; // an invalid portion invalidates the whole thing
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};
  
  var TTY={ttys:[],init:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
      },shutdown:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
      },register:function (dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function (stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function (stream) {
          // flush any pending line data
          stream.tty.ops.flush(stream.tty);
        },flush:function (stream) {
          stream.tty.ops.flush(stream.tty);
        },read:function (stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function (stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function (tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              // we will read data by chunks of BUFSIZE
              var BUFSIZE = 256;
              var buf = new Buffer(BUFSIZE);
              var bytesRead = 0;
  
              var fd = process.stdin.fd;
              // Linux and Mac cannot use process.stdin.fd (which isn't set up as sync)
              var usingDevice = false;
              try {
                fd = fs.openSync('/dev/stdin', 'r');
                usingDevice = true;
              } catch (e) {}
  
              bytesRead = fs.readSync(fd, buf, 0, BUFSIZE, null);
  
              if (usingDevice) { fs.closeSync(fd); }
              if (bytesRead > 0) {
                result = buf.slice(0, bytesRead).toString('utf-8');
              } else {
                result = null;
              }
  
            } else if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['print'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val); // val == 0 would cut text output off in the middle.
          }
        },flush:function (tty) {
          if (tty.output && tty.output.length > 0) {
            Module['print'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }},default_tty1_ops:{put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['printErr'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val);
          }
        },flush:function (tty) {
          if (tty.output && tty.output.length > 0) {
            Module['printErr'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }}};
  
  var MEMFS={ops_table:null,mount:function (mount) {
        return MEMFS.createNode(null, '/', 16384 | 511 /* 0777 */, 0);
      },createNode:function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (!MEMFS.ops_table) {
          MEMFS.ops_table = {
            dir: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                lookup: MEMFS.node_ops.lookup,
                mknod: MEMFS.node_ops.mknod,
                rename: MEMFS.node_ops.rename,
                unlink: MEMFS.node_ops.unlink,
                rmdir: MEMFS.node_ops.rmdir,
                readdir: MEMFS.node_ops.readdir,
                symlink: MEMFS.node_ops.symlink
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek
              }
            },
            file: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek,
                read: MEMFS.stream_ops.read,
                write: MEMFS.stream_ops.write,
                allocate: MEMFS.stream_ops.allocate,
                mmap: MEMFS.stream_ops.mmap,
                msync: MEMFS.stream_ops.msync
              }
            },
            link: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                readlink: MEMFS.node_ops.readlink
              },
              stream: {}
            },
            chrdev: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: FS.chrdev_stream_ops
            }
          };
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = MEMFS.ops_table.dir.node;
          node.stream_ops = MEMFS.ops_table.dir.stream;
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = MEMFS.ops_table.file.node;
          node.stream_ops = MEMFS.ops_table.file.stream;
          node.usedBytes = 0; // The actual number of bytes used in the typed array, as opposed to contents.buffer.byteLength which gives the whole capacity.
          // When the byte data of the file is populated, this will point to either a typed array, or a normal JS array. Typed arrays are preferred
          // for performance, and used by default. However, typed arrays are not resizable like normal JS arrays are, so there is a small disk size
          // penalty involved for appending file writes that continuously grow a file similar to std::vector capacity vs used -scheme.
          node.contents = null; 
        } else if (FS.isLink(node.mode)) {
          node.node_ops = MEMFS.ops_table.link.node;
          node.stream_ops = MEMFS.ops_table.link.stream;
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = MEMFS.ops_table.chrdev.node;
          node.stream_ops = MEMFS.ops_table.chrdev.stream;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },getFileDataAsRegularArray:function (node) {
        if (node.contents && node.contents.subarray) {
          var arr = [];
          for (var i = 0; i < node.usedBytes; ++i) arr.push(node.contents[i]);
          return arr; // Returns a copy of the original data.
        }
        return node.contents; // No-op, the file contents are already in a JS array. Return as-is.
      },getFileDataAsTypedArray:function (node) {
        if (!node.contents) return new Uint8Array;
        if (node.contents.subarray) return node.contents.subarray(0, node.usedBytes); // Make sure to not return excess unused bytes.
        return new Uint8Array(node.contents);
      },expandFileStorage:function (node, newCapacity) {
        // If we are asked to expand the size of a file that already exists, revert to using a standard JS array to store the file
        // instead of a typed array. This makes resizing the array more flexible because we can just .push() elements at the back to
        // increase the size.
        if (node.contents && node.contents.subarray && newCapacity > node.contents.length) {
          node.contents = MEMFS.getFileDataAsRegularArray(node);
          node.usedBytes = node.contents.length; // We might be writing to a lazy-loaded file which had overridden this property, so force-reset it.
        }
  
        if (!node.contents || node.contents.subarray) { // Keep using a typed array if creating a new storage, or if old one was a typed array as well.
          var prevCapacity = node.contents ? node.contents.buffer.byteLength : 0;
          if (prevCapacity >= newCapacity) return; // No need to expand, the storage was already large enough.
          // Don't expand strictly to the given requested limit if it's only a very small increase, but instead geometrically grow capacity.
          // For small filesizes (<1MB), perform size*2 geometric increase, but for large sizes, do a much more conservative size*1.125 increase to
          // avoid overshooting the allocation cap by a very large margin.
          var CAPACITY_DOUBLING_MAX = 1024 * 1024;
          newCapacity = Math.max(newCapacity, (prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2.0 : 1.125)) | 0);
          if (prevCapacity != 0) newCapacity = Math.max(newCapacity, 256); // At minimum allocate 256b for each file when expanding.
          var oldContents = node.contents;
          node.contents = new Uint8Array(newCapacity); // Allocate new storage.
          if (node.usedBytes > 0) node.contents.set(oldContents.subarray(0, node.usedBytes), 0); // Copy old data over to the new storage.
          return;
        }
        // Not using a typed array to back the file storage. Use a standard JS array instead.
        if (!node.contents && newCapacity > 0) node.contents = [];
        while (node.contents.length < newCapacity) node.contents.push(0);
      },resizeFileStorage:function (node, newSize) {
        if (node.usedBytes == newSize) return;
        if (newSize == 0) {
          node.contents = null; // Fully decommit when requesting a resize to zero.
          node.usedBytes = 0;
          return;
        }
        if (!node.contents || node.contents.subarray) { // Resize a typed array if that is being used as the backing store.
          var oldContents = node.contents;
          node.contents = new Uint8Array(new ArrayBuffer(newSize)); // Allocate new storage.
          if (oldContents) {
            node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes))); // Copy old data over to the new storage.
          }
          node.usedBytes = newSize;
          return;
        }
        // Backing with a JS array.
        if (!node.contents) node.contents = [];
        if (node.contents.length > newSize) node.contents.length = newSize;
        else while (node.contents.length < newSize) node.contents.push(0);
        node.usedBytes = newSize;
      },node_ops:{getattr:function (node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.usedBytes;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.resizeFileStorage(node, attr.size);
          }
        },lookup:function (parent, name) {
          throw FS.genericErrors[ERRNO_CODES.ENOENT];
        },mknod:function (parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        },rename:function (old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          old_node.parent = new_dir;
        },unlink:function (parent, name) {
          delete parent.contents[name];
        },rmdir:function (parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
          }
          delete parent.contents[name];
        },readdir:function (node) {
          var entries = ['.', '..']
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 511 /* 0777 */ | 40960, 0);
          node.link = oldpath;
          return node;
        },readlink:function (node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return node.link;
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= stream.node.usedBytes) return 0;
          var size = Math.min(stream.node.usedBytes - position, length);
          assert(size >= 0);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else {
            for (var i = 0; i < size; i++) buffer[offset + i] = contents[position + i];
          }
          return size;
        },write:function (stream, buffer, offset, length, position, canOwn) {
          if (!length) return 0;
          var node = stream.node;
          node.timestamp = Date.now();
  
          if (buffer.subarray && (!node.contents || node.contents.subarray)) { // This write is from a typed array to a typed array?
            if (canOwn) { // Can we just reuse the buffer we are given?
              node.contents = buffer.subarray(offset, offset + length);
              node.usedBytes = length;
              return length;
            } else if (node.usedBytes === 0 && position === 0) { // If this is a simple first write to an empty file, do a fast set since we don't need to care about old data.
              node.contents = new Uint8Array(buffer.subarray(offset, offset + length));
              node.usedBytes = length;
              return length;
            } else if (position + length <= node.usedBytes) { // Writing to an already allocated and used subrange of the file?
              node.contents.set(buffer.subarray(offset, offset + length), position);
              return length;
            }
          }
  
          // Appending to an existing file and we need to reallocate, or source data did not come as a typed array.
          MEMFS.expandFileStorage(node, position+length);
          if (node.contents.subarray && buffer.subarray) node.contents.set(buffer.subarray(offset, offset + length), position); // Use typed array write if available.
          else {
            for (var i = 0; i < length; i++) {
             node.contents[position + i] = buffer[offset + i]; // Or fall back to manual write if not.
            }
          }
          node.usedBytes = Math.max(node.usedBytes, position+length);
          return length;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.usedBytes;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return position;
        },allocate:function (stream, offset, length) {
          MEMFS.expandFileStorage(stream.node, offset + length);
          stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length);
        },mmap:function (stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if ( !(flags & 2) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer) ) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < stream.node.usedBytes) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = _malloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
            }
            buffer.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        },msync:function (stream, buffer, offset, length, mmapFlags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          if (mmapFlags & 2) {
            // MAP_PRIVATE calls need not to be synced back to underlying fs
            return 0;
          }
  
          var bytesWritten = MEMFS.stream_ops.write(stream, buffer, 0, length, offset, false);
          // should we check if bytesWritten and length are the same?
          return 0;
        }}};
  
  var IDBFS={dbs:{},indexedDB:function () {
        if (typeof indexedDB !== 'undefined') return indexedDB;
        var ret = null;
        if (typeof window === 'object') ret = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
        assert(ret, 'IDBFS used, but indexedDB not supported');
        return ret;
      },DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:function (mount) {
        // reuse all of the core MEMFS functionality
        return MEMFS.mount.apply(null, arguments);
      },syncfs:function (mount, populate, callback) {
        IDBFS.getLocalSet(mount, function(err, local) {
          if (err) return callback(err);
  
          IDBFS.getRemoteSet(mount, function(err, remote) {
            if (err) return callback(err);
  
            var src = populate ? remote : local;
            var dst = populate ? local : remote;
  
            IDBFS.reconcile(src, dst, callback);
          });
        });
      },getDB:function (name, callback) {
        // check the cache first
        var db = IDBFS.dbs[name];
        if (db) {
          return callback(null, db);
        }
  
        var req;
        try {
          req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION);
        } catch (e) {
          return callback(e);
        }
        req.onupgradeneeded = function(e) {
          var db = e.target.result;
          var transaction = e.target.transaction;
  
          var fileStore;
  
          if (db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)) {
            fileStore = transaction.objectStore(IDBFS.DB_STORE_NAME);
          } else {
            fileStore = db.createObjectStore(IDBFS.DB_STORE_NAME);
          }
  
          if (!fileStore.indexNames.contains('timestamp')) {
            fileStore.createIndex('timestamp', 'timestamp', { unique: false });
          }
        };
        req.onsuccess = function() {
          db = req.result;
  
          // add to the cache
          IDBFS.dbs[name] = db;
          callback(null, db);
        };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },getLocalSet:function (mount, callback) {
        var entries = {};
  
        function isRealDir(p) {
          return p !== '.' && p !== '..';
        };
        function toAbsolute(root) {
          return function(p) {
            return PATH.join2(root, p);
          }
        };
  
        var check = FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));
  
        while (check.length) {
          var path = check.pop();
          var stat;
  
          try {
            stat = FS.stat(path);
          } catch (e) {
            return callback(e);
          }
  
          if (FS.isDir(stat.mode)) {
            check.push.apply(check, FS.readdir(path).filter(isRealDir).map(toAbsolute(path)));
          }
  
          entries[path] = { timestamp: stat.mtime };
        }
  
        return callback(null, { type: 'local', entries: entries });
      },getRemoteSet:function (mount, callback) {
        var entries = {};
  
        IDBFS.getDB(mount.mountpoint, function(err, db) {
          if (err) return callback(err);
  
          var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readonly');
          transaction.onerror = function(e) {
            callback(this.error);
            e.preventDefault();
          };
  
          var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
          var index = store.index('timestamp');
  
          index.openKeyCursor().onsuccess = function(event) {
            var cursor = event.target.result;
  
            if (!cursor) {
              return callback(null, { type: 'remote', db: db, entries: entries });
            }
  
            entries[cursor.primaryKey] = { timestamp: cursor.key };
  
            cursor.continue();
          };
        });
      },loadLocalEntry:function (path, callback) {
        var stat, node;
  
        try {
          var lookup = FS.lookupPath(path);
          node = lookup.node;
          stat = FS.stat(path);
        } catch (e) {
          return callback(e);
        }
  
        if (FS.isDir(stat.mode)) {
          return callback(null, { timestamp: stat.mtime, mode: stat.mode });
        } else if (FS.isFile(stat.mode)) {
          // Performance consideration: storing a normal JavaScript array to a IndexedDB is much slower than storing a typed array.
          // Therefore always convert the file contents to a typed array first before writing the data to IndexedDB.
          node.contents = MEMFS.getFileDataAsTypedArray(node);
          return callback(null, { timestamp: stat.mtime, mode: stat.mode, contents: node.contents });
        } else {
          return callback(new Error('node type not supported'));
        }
      },storeLocalEntry:function (path, entry, callback) {
        try {
          if (FS.isDir(entry.mode)) {
            FS.mkdir(path, entry.mode);
          } else if (FS.isFile(entry.mode)) {
            FS.writeFile(path, entry.contents, { encoding: 'binary', canOwn: true });
          } else {
            return callback(new Error('node type not supported'));
          }
  
          FS.chmod(path, entry.mode);
          FS.utime(path, entry.timestamp, entry.timestamp);
        } catch (e) {
          return callback(e);
        }
  
        callback(null);
      },removeLocalEntry:function (path, callback) {
        try {
          var lookup = FS.lookupPath(path);
          var stat = FS.stat(path);
  
          if (FS.isDir(stat.mode)) {
            FS.rmdir(path);
          } else if (FS.isFile(stat.mode)) {
            FS.unlink(path);
          }
        } catch (e) {
          return callback(e);
        }
  
        callback(null);
      },loadRemoteEntry:function (store, path, callback) {
        var req = store.get(path);
        req.onsuccess = function(event) { callback(null, event.target.result); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },storeRemoteEntry:function (store, path, entry, callback) {
        var req = store.put(entry, path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },removeRemoteEntry:function (store, path, callback) {
        var req = store.delete(path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },reconcile:function (src, dst, callback) {
        var total = 0;
  
        var create = [];
        Object.keys(src.entries).forEach(function (key) {
          var e = src.entries[key];
          var e2 = dst.entries[key];
          if (!e2 || e.timestamp > e2.timestamp) {
            create.push(key);
            total++;
          }
        });
  
        var remove = [];
        Object.keys(dst.entries).forEach(function (key) {
          var e = dst.entries[key];
          var e2 = src.entries[key];
          if (!e2) {
            remove.push(key);
            total++;
          }
        });
  
        if (!total) {
          return callback(null);
        }
  
        var errored = false;
        var completed = 0;
        var db = src.type === 'remote' ? src.db : dst.db;
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readwrite');
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
  
        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return callback(err);
            }
            return;
          }
          if (++completed >= total) {
            return callback(null);
          }
        };
  
        transaction.onerror = function(e) {
          done(this.error);
          e.preventDefault();
        };
  
        // sort paths in ascending order so directory entries are created
        // before the files inside them
        create.sort().forEach(function (path) {
          if (dst.type === 'local') {
            IDBFS.loadRemoteEntry(store, path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeLocalEntry(path, entry, done);
            });
          } else {
            IDBFS.loadLocalEntry(path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeRemoteEntry(store, path, entry, done);
            });
          }
        });
  
        // sort paths in descending order so files are deleted before their
        // parent directories
        remove.sort().reverse().forEach(function(path) {
          if (dst.type === 'local') {
            IDBFS.removeLocalEntry(path, done);
          } else {
            IDBFS.removeRemoteEntry(store, path, done);
          }
        });
      }};
  
  var NODEFS={isWindows:false,staticInit:function () {
        NODEFS.isWindows = !!process.platform.match(/^win/);
      },mount:function (mount) {
        assert(ENVIRONMENT_IS_NODE);
        return NODEFS.createNode(null, '/', NODEFS.getMode(mount.opts.root), 0);
      },createNode:function (parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node = FS.createNode(parent, name, mode);
        node.node_ops = NODEFS.node_ops;
        node.stream_ops = NODEFS.stream_ops;
        return node;
      },getMode:function (path) {
        var stat;
        try {
          stat = fs.lstatSync(path);
          if (NODEFS.isWindows) {
            // On Windows, directories return permission bits 'rw-rw-rw-', even though they have 'rwxrwxrwx', so
            // propagate write bits to execute bits.
            stat.mode = stat.mode | ((stat.mode & 146) >> 1);
          }
        } catch (e) {
          if (!e.code) throw e;
          throw new FS.ErrnoError(ERRNO_CODES[e.code]);
        }
        return stat.mode;
      },realPath:function (node) {
        var parts = [];
        while (node.parent !== node) {
          parts.push(node.name);
          node = node.parent;
        }
        parts.push(node.mount.opts.root);
        parts.reverse();
        return PATH.join.apply(null, parts);
      },flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:function (flags) {
        if (flags in NODEFS.flagsToPermissionStringMap) {
          return NODEFS.flagsToPermissionStringMap[flags];
        } else {
          return flags;
        }
      },node_ops:{getattr:function (node) {
          var path = NODEFS.realPath(node);
          var stat;
          try {
            stat = fs.lstatSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          // node.js v0.10.20 doesn't report blksize and blocks on Windows. Fake them with default blksize of 4096.
          // See http://support.microsoft.com/kb/140365
          if (NODEFS.isWindows && !stat.blksize) {
            stat.blksize = 4096;
          }
          if (NODEFS.isWindows && !stat.blocks) {
            stat.blocks = (stat.size+stat.blksize-1)/stat.blksize|0;
          }
          return {
            dev: stat.dev,
            ino: stat.ino,
            mode: stat.mode,
            nlink: stat.nlink,
            uid: stat.uid,
            gid: stat.gid,
            rdev: stat.rdev,
            size: stat.size,
            atime: stat.atime,
            mtime: stat.mtime,
            ctime: stat.ctime,
            blksize: stat.blksize,
            blocks: stat.blocks
          };
        },setattr:function (node, attr) {
          var path = NODEFS.realPath(node);
          try {
            if (attr.mode !== undefined) {
              fs.chmodSync(path, attr.mode);
              // update the common node structure mode as well
              node.mode = attr.mode;
            }
            if (attr.timestamp !== undefined) {
              var date = new Date(attr.timestamp);
              fs.utimesSync(path, date, date);
            }
            if (attr.size !== undefined) {
              fs.truncateSync(path, attr.size);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },lookup:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          var mode = NODEFS.getMode(path);
          return NODEFS.createNode(parent, name, mode);
        },mknod:function (parent, name, mode, dev) {
          var node = NODEFS.createNode(parent, name, mode, dev);
          // create the backing node for this in the fs root as well
          var path = NODEFS.realPath(node);
          try {
            if (FS.isDir(node.mode)) {
              fs.mkdirSync(path, node.mode);
            } else {
              fs.writeFileSync(path, '', { mode: node.mode });
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return node;
        },rename:function (oldNode, newDir, newName) {
          var oldPath = NODEFS.realPath(oldNode);
          var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
          try {
            fs.renameSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },unlink:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.unlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },rmdir:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.rmdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readdir:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },symlink:function (parent, newName, oldPath) {
          var newPath = PATH.join2(NODEFS.realPath(parent), newName);
          try {
            fs.symlinkSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readlink:function (node) {
          var path = NODEFS.realPath(node);
          try {
            path = fs.readlinkSync(path);
            path = NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root), path);
            return path;
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        }},stream_ops:{open:function (stream) {
          var path = NODEFS.realPath(stream.node);
          try {
            if (FS.isFile(stream.node.mode)) {
              stream.nfd = fs.openSync(path, NODEFS.flagsToPermissionString(stream.flags));
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },close:function (stream) {
          try {
            if (FS.isFile(stream.node.mode) && stream.nfd) {
              fs.closeSync(stream.nfd);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },read:function (stream, buffer, offset, length, position) {
          if (length === 0) return 0; // node errors on 0 length reads
          // FIXME this is terrible.
          var nbuffer = new Buffer(length);
          var res;
          try {
            res = fs.readSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          if (res > 0) {
            for (var i = 0; i < res; i++) {
              buffer[offset + i] = nbuffer[i];
            }
          }
          return res;
        },write:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(buffer.subarray(offset, offset + length));
          var res;
          try {
            res = fs.writeSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return res;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              try {
                var stat = fs.fstatSync(stream.nfd);
                position += stat.size;
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
              }
            }
          }
  
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
  
          return position;
        }}};
  
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},handleFSError:function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + stackTrace();
        return ___setErrNo(e.errno);
      },lookupPath:function (path, opts) {
        path = PATH.resolve(FS.cwd(), path);
        opts = opts || {};
  
        if (!path) return { path: '', node: null };
  
        var defaults = {
          follow_mount: true,
          recurse_count: 0
        };
        for (var key in defaults) {
          if (opts[key] === undefined) {
            opts[key] = defaults[key];
          }
        }
  
        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }
  
        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);
  
        // start at the root
        var current = FS.root;
        var current_path = '/';
  
        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }
  
          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join2(current_path, parts[i]);
  
          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            if (!islast || (islast && opts.follow_mount)) {
              current = current.mounted.root;
            }
          }
  
          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH.resolve(PATH.dirname(current_path), link);
  
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;
  
              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
              }
            }
          }
        }
  
        return { path: current_path, node: current };
      },getPath:function (node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            var mount = node.mount.mountpoint;
            if (!path) return mount;
            return mount[mount.length-1] !== '/' ? mount + '/' + path : mount + path;
          }
          path = path ? node.name + '/' + path : node.name;
          node = node.parent;
        }
      },hashName:function (parentid, name) {
        var hash = 0;
  
  
        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
      },hashAddNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
      },hashRemoveNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next;
        } else {
          var current = FS.nameTable[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
          throw new FS.ErrnoError(err, parent);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          var nodeName = node.name;
          if (node.parent.id === parent.id && nodeName === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function (parent, name, mode, rdev) {
        if (!FS.FSNode) {
          FS.FSNode = function(parent, name, mode, rdev) {
            if (!parent) {
              parent = this;  // root node sets parent to itself
            }
            this.parent = parent;
            this.mount = parent.mount;
            this.mounted = null;
            this.id = FS.nextInode++;
            this.name = name;
            this.mode = mode;
            this.node_ops = {};
            this.stream_ops = {};
            this.rdev = rdev;
          };
  
          FS.FSNode.prototype = {};
  
          // compatibility
          var readMode = 292 | 73;
          var writeMode = 146;
  
          // NOTE we must use Object.defineProperties instead of individual calls to
          // Object.defineProperty in order to make closure compiler happy
          Object.defineProperties(FS.FSNode.prototype, {
            read: {
              get: function() { return (this.mode & readMode) === readMode; },
              set: function(val) { val ? this.mode |= readMode : this.mode &= ~readMode; }
            },
            write: {
              get: function() { return (this.mode & writeMode) === writeMode; },
              set: function(val) { val ? this.mode |= writeMode : this.mode &= ~writeMode; }
            },
            isFolder: {
              get: function() { return FS.isDir(this.mode); }
            },
            isDevice: {
              get: function() { return FS.isChrdev(this.mode); }
            }
          });
        }
  
        var node = new FS.FSNode(parent, name, mode, rdev);
  
        FS.hashAddNode(node);
  
        return node;
      },destroyNode:function (node) {
        FS.hashRemoveNode(node);
      },isRoot:function (node) {
        return node === node.parent;
      },isMountpoint:function (node) {
        return !!node.mounted;
      },isFile:function (mode) {
        return (mode & 61440) === 32768;
      },isDir:function (mode) {
        return (mode & 61440) === 16384;
      },isLink:function (mode) {
        return (mode & 61440) === 40960;
      },isChrdev:function (mode) {
        return (mode & 61440) === 8192;
      },isBlkdev:function (mode) {
        return (mode & 61440) === 24576;
      },isFIFO:function (mode) {
        return (mode & 61440) === 4096;
      },isSocket:function (mode) {
        return (mode & 49152) === 49152;
      },flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function (flag) {
        var accmode = flag & 2097155;
        var perms = ['r', 'w', 'rw'][accmode];
        if ((flag & 512)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function (node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES;
        }
        return 0;
      },mayLookup:function (dir) {
        var err = FS.nodePermissions(dir, 'x');
        if (err) return err;
        if (!dir.node_ops.lookup) return ERRNO_CODES.EACCES;
        return 0;
      },mayCreate:function (dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return ERRNO_CODES.EEXIST;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function (dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
          return err;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
            return ERRNO_CODES.EBUSY;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return 0;
      },mayOpen:function (node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
          if ((flags & 2097155) !== 0 ||  // opening for write
              (flags & 512)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },MAX_OPEN_FDS:4096,nextfd:function (fd_start, fd_end) {
        fd_start = fd_start || 0;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
      },getStream:function (fd) {
        return FS.streams[fd];
      },createStream:function (stream, fd_start, fd_end) {
        if (!FS.FSStream) {
          FS.FSStream = function(){};
          FS.FSStream.prototype = {};
          // compatibility
          Object.defineProperties(FS.FSStream.prototype, {
            object: {
              get: function() { return this.node; },
              set: function(val) { this.node = val; }
            },
            isRead: {
              get: function() { return (this.flags & 2097155) !== 1; }
            },
            isWrite: {
              get: function() { return (this.flags & 2097155) !== 0; }
            },
            isAppend: {
              get: function() { return (this.flags & 1024); }
            }
          });
        }
        // clone it, so we can return an instance of FSStream
        var newStream = new FS.FSStream();
        for (var p in stream) {
          newStream[p] = stream[p];
        }
        stream = newStream;
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function (fd) {
        FS.streams[fd] = null;
      },getStreamFromPtr:function (ptr) {
        return FS.streams[ptr - 1];
      },getPtrForStream:function (stream) {
        return stream ? stream.fd + 1 : 0;
      },chrdev_stream_ops:{open:function (stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function () {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }},major:function (dev) {
        return ((dev) >> 8);
      },minor:function (dev) {
        return ((dev) & 0xff);
      },makedev:function (ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function (dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function (dev) {
        return FS.devices[dev];
      },getMounts:function (mount) {
        var mounts = [];
        var check = [mount];
  
        while (check.length) {
          var m = check.pop();
  
          mounts.push(m);
  
          check.push.apply(check, m.mounts);
        }
  
        return mounts;
      },syncfs:function (populate, callback) {
        if (typeof(populate) === 'function') {
          callback = populate;
          populate = false;
        }
  
        var mounts = FS.getMounts(FS.root.mount);
        var completed = 0;
  
        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return callback(err);
            }
            return;
          }
          if (++completed >= mounts.length) {
            callback(null);
          }
        };
  
        // sync all mounts
        mounts.forEach(function (mount) {
          if (!mount.type.syncfs) {
            return done(null);
          }
          mount.type.syncfs(mount, populate, done);
        });
      },mount:function (type, opts, mountpoint) {
        var root = mountpoint === '/';
        var pseudo = !mountpoint;
        var node;
  
        if (root && FS.root) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        } else if (!root && !pseudo) {
          var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
          mountpoint = lookup.path;  // use the absolute path
          node = lookup.node;
  
          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
          }
  
          if (!FS.isDir(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
          }
        }
  
        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          mounts: []
        };
  
        // create a root node for the fs
        var mountRoot = type.mount(mount);
        mountRoot.mount = mount;
        mount.root = mountRoot;
  
        if (root) {
          FS.root = mountRoot;
        } else if (node) {
          // set as a mountpoint
          node.mounted = mount;
  
          // add the new mount to the current mount's children
          if (node.mount) {
            node.mount.mounts.push(mount);
          }
        }
  
        return mountRoot;
      },unmount:function (mountpoint) {
        var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
        if (!FS.isMountpoint(lookup.node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
  
        // destroy the nodes for this mount, and all its child mounts
        var node = lookup.node;
        var mount = node.mounted;
        var mounts = FS.getMounts(mount);
  
        Object.keys(FS.nameTable).forEach(function (hash) {
          var current = FS.nameTable[hash];
  
          while (current) {
            var next = current.name_next;
  
            if (mounts.indexOf(current.mount) !== -1) {
              FS.destroyNode(current);
            }
  
            current = next;
          }
        });
  
        // no longer a mountpoint
        node.mounted = null;
  
        // remove this mount from the child mounts
        var idx = node.mount.mounts.indexOf(mount);
        assert(idx !== -1);
        node.mount.mounts.splice(idx, 1);
      },lookup:function (parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function (path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        if (!name || name === '.' || name === '..') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.mayCreate(parent, name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function (path, mode) {
        mode = mode !== undefined ? mode : 438 /* 0666 */;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0);
      },mkdir:function (path, mode) {
        mode = mode !== undefined ? mode : 511 /* 0777 */;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0);
      },mkdev:function (path, mode, dev) {
        if (typeof(dev) === 'undefined') {
          dev = mode;
          mode = 438 /* 0666 */;
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev);
      },symlink:function (oldpath, newpath) {
        if (!PATH.resolve(oldpath)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        if (!parent) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        if (!old_dir || !new_dir) throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, 'w');
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        try {
          if (FS.trackingDelegate['willMovePath']) {
            FS.trackingDelegate['willMovePath'](old_path, new_path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: " + e.message);
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
        try {
          if (FS.trackingDelegate['onMovePath']) FS.trackingDelegate['onMovePath'](old_path, new_path);
        } catch(e) {
          console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: " + e.message);
        }
      },rmdir:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        try {
          if (FS.trackingDelegate['willDeletePath']) {
            FS.trackingDelegate['willDeletePath'](path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: " + e.message);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
        try {
          if (FS.trackingDelegate['onDeletePath']) FS.trackingDelegate['onDeletePath'](path);
        } catch(e) {
          console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: " + e.message);
        }
      },readdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
      },unlink:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
          // POSIX says unlink should set EPERM, not EISDIR
          if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        try {
          if (FS.trackingDelegate['willDeletePath']) {
            FS.trackingDelegate['willDeletePath'](path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: " + e.message);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
        try {
          if (FS.trackingDelegate['onDeletePath']) FS.trackingDelegate['onDeletePath'](path);
        } catch(e) {
          console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: " + e.message);
        }
      },readlink:function (path) {
        var lookup = FS.lookupPath(path);
        var link = lookup.node;
        if (!link) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return PATH.resolve(FS.getPath(lookup.node.parent), link.node_ops.readlink(link));
      },stat:function (path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
      },lstat:function (path) {
        return FS.stat(path, true);
      },chmod:function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function (path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
      },chown:function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function (path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
      },utime:function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function (path, flags, mode, fd_start, fd_end) {
        if (path === "") {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 438 /* 0666 */ : mode;
        if ((flags & 64)) {
          mode = (mode & 4095) | 32768;
        } else {
          mode = 0;
        }
        var node;
        if (typeof path === 'object') {
          node = path;
        } else {
          path = PATH.normalize(path);
          try {
            var lookup = FS.lookupPath(path, {
              follow: !(flags & 131072)
            });
            node = lookup.node;
          } catch (e) {
            // ignore
          }
        }
        // perhaps we need to create the node
        var created = false;
        if ((flags & 64)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 128)) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
            created = true;
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~512;
        }
        // check permissions, if this is not a file we just created now (it is ok to
        // create and write to a file with read-only permissions; it is read-only
        // for later use)
        if (!created) {
          var err = FS.mayOpen(node, flags);
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        // do truncation if necessary
        if ((flags & 512)) {
          FS.truncate(node, 0);
        }
        // we've already handled these, don't pass down to the underlying vfs
        flags &= ~(128 | 512);
  
        // register the stream with the filesystem
        var stream = FS.createStream({
          node: node,
          path: FS.getPath(node),  // we want the absolute path to the node
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        if (Module['logReadFiles'] && !(flags & 1)) {
          if (!FS.readFiles) FS.readFiles = {};
          if (!(path in FS.readFiles)) {
            FS.readFiles[path] = 1;
            Module['printErr']('read file: ' + path);
          }
        }
        try {
          if (FS.trackingDelegate['onOpenFile']) {
            var trackingFlags = 0;
            if ((flags & 2097155) !== 1) {
              trackingFlags |= FS.tracking.openFlags.READ;
            }
            if ((flags & 2097155) !== 0) {
              trackingFlags |= FS.tracking.openFlags.WRITE;
            }
            FS.trackingDelegate['onOpenFile'](path, trackingFlags);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: " + e.message);
        }
        return stream;
      },close:function (stream) {
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
      },llseek:function (stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        stream.position = stream.stream_ops.llseek(stream, offset, whence);
        stream.ungotten = [];
        return stream.position;
      },read:function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if (stream.flags & 1024) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        try {
          if (stream.path && FS.trackingDelegate['onWriteToFile']) FS.trackingDelegate['onWriteToFile'](stream.path);
        } catch(e) {
          console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: " + e.message);
        }
        return bytesWritten;
      },allocate:function (stream, offset, length) {
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
      },msync:function (stream, buffer, offset, length, mmapFlags) {
        if (!stream || !stream.stream_ops.msync) {
          return 0;
        }
        return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags);
      },munmap:function (stream) {
        return 0;
      },ioctl:function (stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
      },readFile:function (path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'r';
        opts.encoding = opts.encoding || 'binary';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
          ret = UTF8ArrayToString(buf, 0);
        } else if (opts.encoding === 'binary') {
          ret = buf;
        }
        FS.close(stream);
        return ret;
      },writeFile:function (path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'w';
        opts.encoding = opts.encoding || 'utf8';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var stream = FS.open(path, opts.flags, opts.mode);
        if (opts.encoding === 'utf8') {
          var buf = new Uint8Array(lengthBytesUTF8(data)+1);
          var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length);
          FS.write(stream, buf, 0, actualNumBytes, 0, opts.canOwn);
        } else if (opts.encoding === 'binary') {
          FS.write(stream, data, 0, data.length, 0, opts.canOwn);
        }
        FS.close(stream);
      },cwd:function () {
        return FS.currentPath;
      },chdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        if (!FS.isDir(lookup.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        var err = FS.nodePermissions(lookup.node, 'x');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        FS.currentPath = lookup.path;
      },createDefaultDirectories:function () {
        FS.mkdir('/tmp');
        FS.mkdir('/home');
        FS.mkdir('/home/web_user');
      },createDefaultDevices:function () {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function(stream, buffer, offset, length, pos) { return length; }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // setup /dev/[u]random
        var random_device;
        if (typeof crypto !== 'undefined') {
          // for modern web browsers
          var randomBuffer = new Uint8Array(1);
          random_device = function() { crypto.getRandomValues(randomBuffer); return randomBuffer[0]; };
        } else if (ENVIRONMENT_IS_NODE) {
          // for nodejs
          random_device = function() { return require('crypto').randomBytes(1)[0]; };
        } else {
          // default for ES5 platforms
          random_device = function() { return (Math.random()*256)|0; };
        }
        FS.createDevice('/dev', 'random', random_device);
        FS.createDevice('/dev', 'urandom', random_device);
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
      },createStandardStreams:function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops
  
        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }
  
        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        HEAP32[((_stdin)>>2)]=FS.getPtrForStream(stdin);
        assert(stdin.fd === 0, 'invalid handle for stdin (' + stdin.fd + ')');
  
        var stdout = FS.open('/dev/stdout', 'w');
        HEAP32[((_stdout)>>2)]=FS.getPtrForStream(stdout);
        assert(stdout.fd === 1, 'invalid handle for stdout (' + stdout.fd + ')');
  
        var stderr = FS.open('/dev/stderr', 'w');
        HEAP32[((_stderr)>>2)]=FS.getPtrForStream(stderr);
        assert(stderr.fd === 2, 'invalid handle for stderr (' + stderr.fd + ')');
      },ensureErrnoError:function () {
        if (FS.ErrnoError) return;
        FS.ErrnoError = function ErrnoError(errno, node) {
          this.node = node;
          this.setErrno = function(errno) {
            this.errno = errno;
            for (var key in ERRNO_CODES) {
              if (ERRNO_CODES[key] === errno) {
                this.code = key;
                break;
              }
            }
          };
          this.setErrno(errno);
          this.message = ERRNO_MESSAGES[errno];
        };
        FS.ErrnoError.prototype = new Error();
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        // Some errors may happen quite a bit, to avoid overhead we reuse them (and suffer a lack of stack info)
        [ERRNO_CODES.ENOENT].forEach(function(code) {
          FS.genericErrors[code] = new FS.ErrnoError(code);
          FS.genericErrors[code].stack = '<generic error, no stack>';
        });
      },staticInit:function () {
        FS.ensureErrnoError();
  
        FS.nameTable = new Array(4096);
  
        FS.mount(MEMFS, {}, '/');
  
        FS.createDefaultDirectories();
        FS.createDefaultDevices();
      },init:function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
  
        FS.ensureErrnoError();
  
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];
  
        FS.createStandardStreams();
      },quit:function () {
        FS.init.initialized = false;
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },getMode:function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },joinPath:function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
      },absolutePath:function (relative, base) {
        return PATH.resolve(base, relative);
      },standardizePath:function (path) {
        return PATH.normalize(path);
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },analyzePath:function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createFolder:function (parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
      },createPath:function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join2(parent, part);
          try {
            FS.mkdir(current);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function (parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(node, mode | 146);
          var stream = FS.open(node, 'w');
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(node, mode);
        }
        return node;
      },createDevice:function (parent, name, input, output) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },createLink:function (parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
            obj.usedBytes = obj.contents.length;
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
        function LazyUint8Array() {
          this.lengthKnown = false;
          this.chunks = []; // Loaded chunks. Index is the chunk number
        }
        LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
          if (idx > this.length-1 || idx < 0) {
            return undefined;
          }
          var chunkOffset = idx % this.chunkSize;
          var chunkNum = (idx / this.chunkSize)|0;
          return this.getter(chunkNum)[chunkOffset];
        }
        LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
          this.getter = getter;
        }
        LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
          // Find length
          var xhr = new XMLHttpRequest();
          xhr.open('HEAD', url, false);
          xhr.send(null);
          if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
          var datalength = Number(xhr.getResponseHeader("Content-length"));
          var header;
          var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
          var chunkSize = 1024*1024; // Chunk size in bytes
  
          if (!hasByteServing) chunkSize = datalength;
  
          // Function to get a range from the remote URL.
          var doXHR = (function(from, to) {
            if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
            if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
  
            // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url, false);
            if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
  
            // Some hints to the browser that we want binary data.
            if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
            if (xhr.overrideMimeType) {
              xhr.overrideMimeType('text/plain; charset=x-user-defined');
            }
  
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            if (xhr.response !== undefined) {
              return new Uint8Array(xhr.response || []);
            } else {
              return intArrayFromString(xhr.responseText || '', true);
            }
          });
          var lazyArray = this;
          lazyArray.setDataGetter(function(chunkNum) {
            var start = chunkNum * chunkSize;
            var end = (chunkNum+1) * chunkSize - 1; // including this byte
            end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
              lazyArray.chunks[chunkNum] = doXHR(start, end);
            }
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
            return lazyArray.chunks[chunkNum];
          });
  
          this._length = datalength;
          this._chunkSize = chunkSize;
          this.lengthKnown = true;
        }
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });
  
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
  
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // Add a function that defers querying the file size until it is asked the first time.
        Object.defineProperty(node, "usedBytes", {
            get: function() { return this.contents.length; }
        });
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function forceLoadLazyFile() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO);
          }
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn, preFinish) {
        Browser.init();
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;
        var dep = getUniqueRunDependency('cp ' + fullname); // might have several active requests for the same fullname
        function processData(byteArray) {
          function finish(byteArray) {
            if (preFinish) preFinish();
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency(dep);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency(dep);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency(dep);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_NAME:function () {
        return 'EM_FS_' + window.location.pathname;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
          console.log('creating db');
          var db = openRequest.result;
          db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path);
            putRequest.onsuccess = function putRequest_onsuccess() { ok++; if (ok + fail == total) finish() };
            putRequest.onerror = function putRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      },loadFilesFromDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
          } catch(e) {
            onerror(e);
            return;
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var getRequest = files.get(path);
            getRequest.onsuccess = function getRequest_onsuccess() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path);
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
              ok++;
              if (ok + fail == total) finish();
            };
            getRequest.onerror = function getRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      }};function _fflush(stream) {
      // int fflush(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fflush.html
  
      /*
      // Disabled, see https://github.com/kripken/emscripten/issues/2770
      stream = FS.getStreamFromPtr(stream);
      if (stream.stream_ops.flush) {
        stream.stream_ops.flush(stream);
      }
      */
    }

   
  Module["_strlen"] = _strlen;

  function _GetTitleGain() {
  Module['printErr']('missing function: GetTitleGain'); abort(-1);
  }

   
  Module["_i64Add"] = _i64Add;

  var _fabs=Math_abs;

  var _floor=Math_floor;

  var _sqrt=Math_sqrt;

  function _hip_set_errorf() {
  Module['printErr']('missing function: hip_set_errorf'); abort(-1);
  }

  var _llvm_pow_f32=Math_pow;

  
  
  function _emscripten_set_main_loop_timing(mode, value) {
      Browser.mainLoop.timingMode = mode;
      Browser.mainLoop.timingValue = value;
  
      if (!Browser.mainLoop.func) {
        return 1; // Return non-zero on failure, can't set timing mode when there is no main loop.
      }
  
      if (mode == 0 /*EM_TIMING_SETTIMEOUT*/) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler() {
          setTimeout(Browser.mainLoop.runner, value); // doing this each time means that on exception, we stop
        };
        Browser.mainLoop.method = 'timeout';
      } else if (mode == 1 /*EM_TIMING_RAF*/) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler() {
          Browser.requestAnimationFrame(Browser.mainLoop.runner);
        };
        Browser.mainLoop.method = 'rAF';
      }
      return 0;
    }function _emscripten_set_main_loop(func, fps, simulateInfiniteLoop, arg, noSetTiming) {
      Module['noExitRuntime'] = true;
  
      assert(!Browser.mainLoop.func, 'emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.');
  
      Browser.mainLoop.func = func;
      Browser.mainLoop.arg = arg;
  
      var thisMainLoopId = Browser.mainLoop.currentlyRunningMainloop;
  
      Browser.mainLoop.runner = function Browser_mainLoop_runner() {
        if (ABORT) return;
        if (Browser.mainLoop.queue.length > 0) {
          var start = Date.now();
          var blocker = Browser.mainLoop.queue.shift();
          blocker.func(blocker.arg);
          if (Browser.mainLoop.remainingBlockers) {
            var remaining = Browser.mainLoop.remainingBlockers;
            var next = remaining%1 == 0 ? remaining-1 : Math.floor(remaining);
            if (blocker.counted) {
              Browser.mainLoop.remainingBlockers = next;
            } else {
              // not counted, but move the progress along a tiny bit
              next = next + 0.5; // do not steal all the next one's progress
              Browser.mainLoop.remainingBlockers = (8*remaining + next)/9;
            }
          }
          console.log('main loop blocker "' + blocker.name + '" took ' + (Date.now() - start) + ' ms'); //, left: ' + Browser.mainLoop.remainingBlockers);
          Browser.mainLoop.updateStatus();
          setTimeout(Browser.mainLoop.runner, 0);
          return;
        }
  
        // catch pauses from non-main loop sources
        if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
  
        // Implement very basic swap interval control
        Browser.mainLoop.currentFrameNumber = Browser.mainLoop.currentFrameNumber + 1 | 0;
        if (Browser.mainLoop.timingMode == 1/*EM_TIMING_RAF*/ && Browser.mainLoop.timingValue > 1 && Browser.mainLoop.currentFrameNumber % Browser.mainLoop.timingValue != 0) {
          // Not the scheduled time to render this frame - skip.
          Browser.mainLoop.scheduler();
          return;
        }
  
        // Signal GL rendering layer that processing of a new frame is about to start. This helps it optimize
        // VBO double-buffering and reduce GPU stalls.
  
        if (Browser.mainLoop.method === 'timeout' && Module.ctx) {
          Module.printErr('Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!');
          Browser.mainLoop.method = ''; // just warn once per call to set main loop
        }
  
        Browser.mainLoop.runIter(function() {
          if (typeof arg !== 'undefined') {
            Runtime.dynCall('vi', func, [arg]);
          } else {
            Runtime.dynCall('v', func);
          }
        });
  
        // catch pauses from the main loop itself
        if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
  
        // Queue new audio data. This is important to be right after the main loop invocation, so that we will immediately be able
        // to queue the newest produced audio samples.
        // TODO: Consider adding pre- and post- rAF callbacks so that GL.newRenderingFrameStarted() and SDL.audio.queueNewAudioData()
        //       do not need to be hardcoded into this function, but can be more generic.
        if (typeof SDL === 'object' && SDL.audio && SDL.audio.queueNewAudioData) SDL.audio.queueNewAudioData();
  
        Browser.mainLoop.scheduler();
      }
  
      if (!noSetTiming) {
        if (fps && fps > 0) _emscripten_set_main_loop_timing(0/*EM_TIMING_SETTIMEOUT*/, 1000.0 / fps);
        else _emscripten_set_main_loop_timing(1/*EM_TIMING_RAF*/, 1); // Do rAF by rendering each frame (no decimating)
  
        Browser.mainLoop.scheduler();
      }
  
      if (simulateInfiniteLoop) {
        throw 'SimulateInfiniteLoop';
      }
    }var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:function () {
          Browser.mainLoop.scheduler = null;
          Browser.mainLoop.currentlyRunningMainloop++; // Incrementing this signals the previous main loop that it's now become old, and it must return.
        },resume:function () {
          Browser.mainLoop.currentlyRunningMainloop++;
          var timingMode = Browser.mainLoop.timingMode;
          var timingValue = Browser.mainLoop.timingValue;
          var func = Browser.mainLoop.func;
          Browser.mainLoop.func = null;
          _emscripten_set_main_loop(func, 0, false, Browser.mainLoop.arg, true /* do not set timing and call scheduler, we will do it on the next lines */);
          _emscripten_set_main_loop_timing(timingMode, timingValue);
          Browser.mainLoop.scheduler();
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        },runIter:function (func) {
          if (ABORT) return;
          if (Module['preMainLoop']) {
            var preRet = Module['preMainLoop']();
            if (preRet === false) {
              return; // |return false| skips a frame
            }
          }
          try {
            func();
          } catch (e) {
            if (e instanceof ExitStatus) {
              return;
            } else {
              if (e && typeof e === 'object' && e.stack) Module.printErr('exception thrown: ' + [e, e.stack]);
              throw e;
            }
          }
          if (Module['postMainLoop']) Module['postMainLoop']();
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers
  
        if (Browser.initted) return;
        Browser.initted = true;
  
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === 'undefined') {
          console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
          Module.noImageDecoding = true;
        }
  
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
  
        var imagePlugin = {};
        imagePlugin['canHandle'] = function imagePlugin_canHandle(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function imagePlugin_handle(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: Browser.getMimetype(name) });
              if (b.size !== byteArray.length) { // Safari bug #118630
                // Safari's Blob can only take an ArrayBuffer
                b = new Blob([(new Uint8Array(byteArray)).buffer], { type: Browser.getMimetype(name) });
              }
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function img_onload() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function img_onerror(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
  
        var audioPlugin = {};
        audioPlugin['canHandle'] = function audioPlugin_canHandle(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function audioPlugin_handle(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: Browser.getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function audio_onerror(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
  
        // Canvas event setup
  
        var canvas = Module['canvas'];
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas ||
                                document['msPointerLockElement'] === canvas;
        }
        if (canvas) {
          // forced aspect ratio can be enabled by defining 'forcedAspectRatio' on Module
          // Module['forcedAspectRatio'] = 4 / 3;
          
          canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                      canvas['mozRequestPointerLock'] ||
                                      canvas['webkitRequestPointerLock'] ||
                                      canvas['msRequestPointerLock'] ||
                                      function(){};
          canvas.exitPointerLock = document['exitPointerLock'] ||
                                   document['mozExitPointerLock'] ||
                                   document['webkitExitPointerLock'] ||
                                   document['msExitPointerLock'] ||
                                   function(){}; // no-op if function does not exist
          canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
  
  
          document.addEventListener('pointerlockchange', pointerLockChange, false);
          document.addEventListener('mozpointerlockchange', pointerLockChange, false);
          document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
          document.addEventListener('mspointerlockchange', pointerLockChange, false);
  
          if (Module['elementPointerLock']) {
            canvas.addEventListener("click", function(ev) {
              if (!Browser.pointerLock && canvas.requestPointerLock) {
                canvas.requestPointerLock();
                ev.preventDefault();
              }
            }, false);
          }
        }
      },createContext:function (canvas, useWebGL, setInModule, webGLContextAttributes) {
        if (useWebGL && Module.ctx && canvas == Module.canvas) return Module.ctx; // no need to recreate GL context if it's already been created for this canvas.
  
        var ctx;
        var contextHandle;
        if (useWebGL) {
          // For GLES2/desktop GL compatibility, adjust a few defaults to be different to WebGL defaults, so that they align better with the desktop defaults.
          var contextAttributes = {
            antialias: false,
            alpha: false
          };
  
          if (webGLContextAttributes) {
            for (var attribute in webGLContextAttributes) {
              contextAttributes[attribute] = webGLContextAttributes[attribute];
            }
          }
  
          contextHandle = GL.createContext(canvas, contextAttributes);
          if (contextHandle) {
            ctx = GL.getContext(contextHandle).GLctx;
          }
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
        } else {
          ctx = canvas.getContext('2d');
        }
  
        if (!ctx) return null;
  
        if (setInModule) {
          if (!useWebGL) assert(typeof GLctx === 'undefined', 'cannot set in module if GLctx is used, but we are a non-GL context that would replace it');
  
          Module.ctx = ctx;
          if (useWebGL) GL.makeContextCurrent(contextHandle);
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas, vrDevice) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        Browser.vrDevice = vrDevice;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;
        if (typeof Browser.vrDevice === 'undefined') Browser.vrDevice = null;
  
        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          var canvasContainer = canvas.parentNode;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement'] ||
               document['msFullScreenElement'] || document['msFullscreenElement'] ||
               document['webkitCurrentFullScreenElement']) === canvasContainer) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'] ||
                                      document['msExitFullscreen'] ||
                                      document['exitFullscreen'] ||
                                      function() {};
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else {
            
            // remove the full screen specific parent of the canvas again to restore the HTML structure from before going full screen
            canvasContainer.parentNode.insertBefore(canvas, canvasContainer);
            canvasContainer.parentNode.removeChild(canvasContainer);
            
            if (Browser.resizeCanvas) Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
          Browser.updateCanvasDimensions(canvas);
        }
  
        if (!Browser.fullScreenHandlersInstalled) {
          Browser.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
          document.addEventListener('MSFullscreenChange', fullScreenChange, false);
        }
  
        // create a new parent to ensure the canvas has no siblings. this allows browsers to optimize full screen performance when its parent is the full screen root
        var canvasContainer = document.createElement("div");
        canvas.parentNode.insertBefore(canvasContainer, canvas);
        canvasContainer.appendChild(canvas);
  
        // use parent of canvas as full screen root to allow aspect ratio correction (Firefox stretches the root to screen size)
        canvasContainer.requestFullScreen = canvasContainer['requestFullScreen'] ||
                                            canvasContainer['mozRequestFullScreen'] ||
                                            canvasContainer['msRequestFullscreen'] ||
                                           (canvasContainer['webkitRequestFullScreen'] ? function() { canvasContainer['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
  
        if (vrDevice) {
          canvasContainer.requestFullScreen({ vrDisplay: vrDevice });
        } else {
          canvasContainer.requestFullScreen();
        }
      },nextRAF:0,fakeRequestAnimationFrame:function (func) {
        // try to keep 60fps between calls to here
        var now = Date.now();
        if (Browser.nextRAF === 0) {
          Browser.nextRAF = now + 1000/60;
        } else {
          while (now + 2 >= Browser.nextRAF) { // fudge a little, to avoid timer jitter causing us to do lots of delay:0
            Browser.nextRAF += 1000/60;
          }
        }
        var delay = Math.max(Browser.nextRAF - now, 0);
        setTimeout(func, delay);
      },requestAnimationFrame:function requestAnimationFrame(func) {
        if (typeof window === 'undefined') { // Provide fallback to setTimeout if window is undefined (e.g. in Node.js)
          Browser.fakeRequestAnimationFrame(func);
        } else {
          if (!window.requestAnimationFrame) {
            window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                           window['mozRequestAnimationFrame'] ||
                                           window['webkitRequestAnimationFrame'] ||
                                           window['msRequestAnimationFrame'] ||
                                           window['oRequestAnimationFrame'] ||
                                           Browser.fakeRequestAnimationFrame;
          }
          window.requestAnimationFrame(func);
        }
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:function () {
        Browser.allowAsyncCallbacks = false;
      },resumeAsyncCallbacks:function () { // marks future callbacks as ok to execute, and synchronously runs any remaining ones right now
        Browser.allowAsyncCallbacks = true;
        if (Browser.queuedAsyncCallbacks.length > 0) {
          var callbacks = Browser.queuedAsyncCallbacks;
          Browser.queuedAsyncCallbacks = [];
          callbacks.forEach(function(func) {
            func();
          });
        }
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } else {
            Browser.queuedAsyncCallbacks.push(func);
          }
        });
      },safeSetTimeout:function (func, timeout) {
        Module['noExitRuntime'] = true;
        return setTimeout(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } else {
            Browser.queuedAsyncCallbacks.push(func);
          }
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        Module['noExitRuntime'] = true;
        return setInterval(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } // drop it on the floor otherwise, next interval will kick in
        }, timeout);
      },getMimetype:function (name) {
        return {
          'jpg': 'image/jpeg',
          'jpeg': 'image/jpeg',
          'png': 'image/png',
          'bmp': 'image/bmp',
          'ogg': 'audio/ogg',
          'wav': 'audio/wav',
          'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.')+1)];
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },getMouseWheelDelta:function (event) {
        var delta = 0;
        switch (event.type) {
          case 'DOMMouseScroll': 
            delta = event.detail;
            break;
          case 'mousewheel': 
            delta = event.wheelDelta;
            break;
          case 'wheel': 
            delta = event['deltaY'];
            break;
          default:
            throw 'unrecognized mouse wheel event: ' + event.type;
        }
        return delta;
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for Firefox bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }
          
          // check if SDL is available
          if (typeof SDL != "undefined") {
          	Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
          	Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
          } else {
          	// just add the mouse delta to the current absolut mouse position
          	// FIXME: ideally this should be clamped against the canvas size and zero
          	Browser.mouseX += Browser.mouseMovementX;
          	Browser.mouseY += Browser.mouseMovementY;
          }        
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
  
          // Neither .scrollX or .pageXOffset are defined in a spec, but
          // we prefer .scrollX because it is currently in a spec draft.
          // (see: http://www.w3.org/TR/2013/WD-cssom-view-20131217/)
          var scrollX = ((typeof window.scrollX !== 'undefined') ? window.scrollX : window.pageXOffset);
          var scrollY = ((typeof window.scrollY !== 'undefined') ? window.scrollY : window.pageYOffset);
  
          if (event.type === 'touchstart' || event.type === 'touchend' || event.type === 'touchmove') {
            var touch = event.touch;
            if (touch === undefined) {
              return; // the "touch" property is only defined in SDL
  
            }
            var adjustedX = touch.pageX - (scrollX + rect.left);
            var adjustedY = touch.pageY - (scrollY + rect.top);
  
            adjustedX = adjustedX * (cw / rect.width);
            adjustedY = adjustedY * (ch / rect.height);
  
            var coords = { x: adjustedX, y: adjustedY };
            
            if (event.type === 'touchstart') {
              Browser.lastTouches[touch.identifier] = coords;
              Browser.touches[touch.identifier] = coords;
            } else if (event.type === 'touchend' || event.type === 'touchmove') {
              var last = Browser.touches[touch.identifier];
              if (!last) last = coords;
              Browser.lastTouches[touch.identifier] = last;
              Browser.touches[touch.identifier] = coords;
            } 
            return;
          }
  
          var x = event.pageX - (scrollX + rect.left);
          var y = event.pageY - (scrollY + rect.top);
  
          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);
  
          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function xhr_onload() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        Browser.updateCanvasDimensions(canvas, width, height);
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        // check if SDL is available   
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        // check if SDL is available       
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },updateCanvasDimensions:function (canvas, wNative, hNative) {
        if (wNative && hNative) {
          canvas.widthNative = wNative;
          canvas.heightNative = hNative;
        } else {
          wNative = canvas.widthNative;
          hNative = canvas.heightNative;
        }
        var w = wNative;
        var h = hNative;
        if (Module['forcedAspectRatio'] && Module['forcedAspectRatio'] > 0) {
          if (w/h < Module['forcedAspectRatio']) {
            w = Math.round(h * Module['forcedAspectRatio']);
          } else {
            h = Math.round(w / Module['forcedAspectRatio']);
          }
        }
        if (((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
             document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
             document['fullScreenElement'] || document['fullscreenElement'] ||
             document['msFullScreenElement'] || document['msFullscreenElement'] ||
             document['webkitCurrentFullScreenElement']) === canvas.parentNode) && (typeof screen != 'undefined')) {
           var factor = Math.min(screen.width / w, screen.height / h);
           w = Math.round(w * factor);
           h = Math.round(h * factor);
        }
        if (Browser.resizeCanvas) {
          if (canvas.width  != w) canvas.width  = w;
          if (canvas.height != h) canvas.height = h;
          if (typeof canvas.style != 'undefined') {
            canvas.style.removeProperty( "width");
            canvas.style.removeProperty("height");
          }
        } else {
          if (canvas.width  != wNative) canvas.width  = wNative;
          if (canvas.height != hNative) canvas.height = hNative;
          if (typeof canvas.style != 'undefined') {
            if (w != wNative || h != hNative) {
              canvas.style.setProperty( "width", w + "px", "important");
              canvas.style.setProperty("height", h + "px", "important");
            } else {
              canvas.style.removeProperty( "width");
              canvas.style.removeProperty("height");
            }
          }
        }
      },wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:function () {
        var handle = Browser.nextWgetRequestHandle;
        Browser.nextWgetRequestHandle++;
        return handle;
      }};

  var _llvm_sqrt_f64=Math_sqrt;

  
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      Module['exit'](status);
    }function _exit(status) {
      __exit(status);
    }

  function _hip_decode_init() {
  Module['printErr']('missing function: hip_decode_init'); abort(-1);
  }

  function _hip_set_msgf() {
  Module['printErr']('missing function: hip_set_msgf'); abort(-1);
  }

  var _sin=Math_sin;

  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 30: return PAGE_SIZE;
        case 85: return totalMemory / PAGE_SIZE;
        case 132:
        case 133:
        case 12:
        case 137:
        case 138:
        case 15:
        case 235:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 149:
        case 13:
        case 10:
        case 236:
        case 153:
        case 9:
        case 21:
        case 22:
        case 159:
        case 154:
        case 14:
        case 77:
        case 78:
        case 139:
        case 80:
        case 81:
        case 82:
        case 68:
        case 67:
        case 164:
        case 11:
        case 29:
        case 47:
        case 48:
        case 95:
        case 52:
        case 51:
        case 46:
          return 200809;
        case 79:
          return 0;
        case 27:
        case 246:
        case 127:
        case 128:
        case 23:
        case 24:
        case 160:
        case 161:
        case 181:
        case 182:
        case 242:
        case 183:
        case 184:
        case 243:
        case 244:
        case 245:
        case 165:
        case 178:
        case 179:
        case 49:
        case 50:
        case 168:
        case 169:
        case 175:
        case 170:
        case 171:
        case 172:
        case 97:
        case 76:
        case 32:
        case 173:
        case 35:
          return -1;
        case 176:
        case 177:
        case 7:
        case 155:
        case 8:
        case 157:
        case 125:
        case 126:
        case 92:
        case 93:
        case 129:
        case 130:
        case 131:
        case 94:
        case 91:
          return 1;
        case 74:
        case 60:
        case 69:
        case 70:
        case 4:
          return 1024;
        case 31:
        case 42:
        case 72:
          return 32;
        case 87:
        case 26:
        case 33:
          return 2147483647;
        case 34:
        case 1:
          return 47839;
        case 38:
        case 36:
          return 99;
        case 43:
        case 37:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 28: return 32768;
        case 44: return 32767;
        case 75: return 16384;
        case 39: return 1000;
        case 89: return 700;
        case 71: return 256;
        case 40: return 255;
        case 2: return 100;
        case 180: return 64;
        case 25: return 20;
        case 5: return 16;
        case 6: return 6;
        case 73: return 4;
        case 84: {
          if (typeof navigator === 'object') return navigator['hardwareConcurrency'] || 1;
          return 1;
        }
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }

   
  Module["_bitshift64Lshr"] = _bitshift64Lshr;

  function _hip_decode_exit() {
  Module['printErr']('missing function: hip_decode_exit'); abort(-1);
  }

  var _atan=Math_atan;

  var _BDtoIHigh=true;

  var _ceil=Math_ceil;

  
  
  
  
  
  
  function _mkport() { throw 'TODO' }var SOCKFS={mount:function (mount) {
        // If Module['websocket'] has already been defined (e.g. for configuring
        // the subprotocol/url) use that, if not initialise it to a new object.
        Module['websocket'] = (Module['websocket'] && 
                               ('object' === typeof Module['websocket'])) ? Module['websocket'] : {};
  
        // Add the Event registration mechanism to the exported websocket configuration
        // object so we can register network callbacks from native JavaScript too.
        // For more documentation see system/include/emscripten/emscripten.h
        Module['websocket']._callbacks = {};
        Module['websocket']['on'] = function(event, callback) {
  	    if ('function' === typeof callback) {
  		  this._callbacks[event] = callback;
          }
  	    return this;
        };
  
        Module['websocket'].emit = function(event, param) {
  	    if ('function' === typeof this._callbacks[event]) {
  		  this._callbacks[event].call(this, param);
          }
        };
  
        // If debug is enabled register simple default logging callbacks for each Event.
  
        return FS.createNode(null, '/', 16384 | 511 /* 0777 */, 0);
      },createSocket:function (family, type, protocol) {
        var streaming = type == 1;
        if (protocol) {
          assert(streaming == (protocol == 6)); // if SOCK_STREAM, must be tcp
        }
  
        // create our internal socket structure
        var sock = {
          family: family,
          type: type,
          protocol: protocol,
          server: null,
          error: null, // Used in getsockopt for SOL_SOCKET/SO_ERROR test
          peers: {},
          pending: [],
          recv_queue: [],
          sock_ops: SOCKFS.websocket_sock_ops
        };
  
        // create the filesystem node to store the socket structure
        var name = SOCKFS.nextname();
        var node = FS.createNode(SOCKFS.root, name, 49152, 0);
        node.sock = sock;
  
        // and the wrapping stream that enables library functions such
        // as read and write to indirectly interact with the socket
        var stream = FS.createStream({
          path: name,
          node: node,
          flags: FS.modeStringToFlags('r+'),
          seekable: false,
          stream_ops: SOCKFS.stream_ops
        });
  
        // map the new stream to the socket structure (sockets have a 1:1
        // relationship with a stream)
        sock.stream = stream;
  
        return sock;
      },getSocket:function (fd) {
        var stream = FS.getStream(fd);
        if (!stream || !FS.isSocket(stream.node.mode)) {
          return null;
        }
        return stream.node.sock;
      },stream_ops:{poll:function (stream) {
          var sock = stream.node.sock;
          return sock.sock_ops.poll(sock);
        },ioctl:function (stream, request, varargs) {
          var sock = stream.node.sock;
          return sock.sock_ops.ioctl(sock, request, varargs);
        },read:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          var msg = sock.sock_ops.recvmsg(sock, length);
          if (!msg) {
            // socket is closed
            return 0;
          }
          buffer.set(msg.buffer, offset);
          return msg.buffer.length;
        },write:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          return sock.sock_ops.sendmsg(sock, buffer, offset, length);
        },close:function (stream) {
          var sock = stream.node.sock;
          sock.sock_ops.close(sock);
        }},nextname:function () {
        if (!SOCKFS.nextname.current) {
          SOCKFS.nextname.current = 0;
        }
        return 'socket[' + (SOCKFS.nextname.current++) + ']';
      },websocket_sock_ops:{createPeer:function (sock, addr, port) {
          var ws;
  
          if (typeof addr === 'object') {
            ws = addr;
            addr = null;
            port = null;
          }
  
          if (ws) {
            // for sockets that've already connected (e.g. we're the server)
            // we can inspect the _socket property for the address
            if (ws._socket) {
              addr = ws._socket.remoteAddress;
              port = ws._socket.remotePort;
            }
            // if we're just now initializing a connection to the remote,
            // inspect the url property
            else {
              var result = /ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);
              if (!result) {
                throw new Error('WebSocket URL must be in the format ws(s)://address:port');
              }
              addr = result[1];
              port = parseInt(result[2], 10);
            }
          } else {
            // create the actual websocket object and connect
            try {
              // runtimeConfig gets set to true if WebSocket runtime configuration is available.
              var runtimeConfig = (Module['websocket'] && ('object' === typeof Module['websocket']));
  
              // The default value is 'ws://' the replace is needed because the compiler replaces '//' comments with '#'
              // comments without checking context, so we'd end up with ws:#, the replace swaps the '#' for '//' again.
              var url = 'ws:#'.replace('#', '//');
  
              if (runtimeConfig) {
                if ('string' === typeof Module['websocket']['url']) {
                  url = Module['websocket']['url']; // Fetch runtime WebSocket URL config.
                }
              }
  
              if (url === 'ws://' || url === 'wss://') { // Is the supplied URL config just a prefix, if so complete it.
                var parts = addr.split('/');
                url = url + parts[0] + ":" + port + "/" + parts.slice(1).join('/');
              }
  
              // Make the WebSocket subprotocol (Sec-WebSocket-Protocol) default to binary if no configuration is set.
              var subProtocols = 'binary'; // The default value is 'binary'
  
              if (runtimeConfig) {
                if ('string' === typeof Module['websocket']['subprotocol']) {
                  subProtocols = Module['websocket']['subprotocol']; // Fetch runtime WebSocket subprotocol config.
                }
              }
  
              // The regex trims the string (removes spaces at the beginning and end, then splits the string by
              // <any space>,<any space> into an Array. Whitespace removal is important for Websockify and ws.
              subProtocols = subProtocols.replace(/^ +| +$/g,"").split(/ *, */);
  
              // The node ws library API for specifying optional subprotocol is slightly different than the browser's.
              var opts = ENVIRONMENT_IS_NODE ? {'protocol': subProtocols.toString()} : subProtocols;
  
              // If node we use the ws library.
              var WebSocket = ENVIRONMENT_IS_NODE ? require('ws') : window['WebSocket'];
              ws = new WebSocket(url, opts);
              ws.binaryType = 'arraybuffer';
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH);
            }
          }
  
  
          var peer = {
            addr: addr,
            port: port,
            socket: ws,
            dgram_send_queue: []
          };
  
          SOCKFS.websocket_sock_ops.addPeer(sock, peer);
          SOCKFS.websocket_sock_ops.handlePeerEvents(sock, peer);
  
          // if this is a bound dgram socket, send the port number first to allow
          // us to override the ephemeral port reported to us by remotePort on the
          // remote end.
          if (sock.type === 2 && typeof sock.sport !== 'undefined') {
            peer.dgram_send_queue.push(new Uint8Array([
                255, 255, 255, 255,
                'p'.charCodeAt(0), 'o'.charCodeAt(0), 'r'.charCodeAt(0), 't'.charCodeAt(0),
                ((sock.sport & 0xff00) >> 8) , (sock.sport & 0xff)
            ]));
          }
  
          return peer;
        },getPeer:function (sock, addr, port) {
          return sock.peers[addr + ':' + port];
        },addPeer:function (sock, peer) {
          sock.peers[peer.addr + ':' + peer.port] = peer;
        },removePeer:function (sock, peer) {
          delete sock.peers[peer.addr + ':' + peer.port];
        },handlePeerEvents:function (sock, peer) {
          var first = true;
  
          var handleOpen = function () {
  
            Module['websocket'].emit('open', sock.stream.fd);
  
            try {
              var queued = peer.dgram_send_queue.shift();
              while (queued) {
                peer.socket.send(queued);
                queued = peer.dgram_send_queue.shift();
              }
            } catch (e) {
              // not much we can do here in the way of proper error handling as we've already
              // lied and said this data was sent. shut it down.
              peer.socket.close();
            }
          };
  
          function handleMessage(data) {
            assert(typeof data !== 'string' && data.byteLength !== undefined);  // must receive an ArrayBuffer
            data = new Uint8Array(data);  // make a typed array view on the array buffer
  
  
            // if this is the port message, override the peer's port with it
            var wasfirst = first;
            first = false;
            if (wasfirst &&
                data.length === 10 &&
                data[0] === 255 && data[1] === 255 && data[2] === 255 && data[3] === 255 &&
                data[4] === 'p'.charCodeAt(0) && data[5] === 'o'.charCodeAt(0) && data[6] === 'r'.charCodeAt(0) && data[7] === 't'.charCodeAt(0)) {
              // update the peer's port and it's key in the peer map
              var newport = ((data[8] << 8) | data[9]);
              SOCKFS.websocket_sock_ops.removePeer(sock, peer);
              peer.port = newport;
              SOCKFS.websocket_sock_ops.addPeer(sock, peer);
              return;
            }
  
            sock.recv_queue.push({ addr: peer.addr, port: peer.port, data: data });
            Module['websocket'].emit('message', sock.stream.fd);
          };
  
          if (ENVIRONMENT_IS_NODE) {
            peer.socket.on('open', handleOpen);
            peer.socket.on('message', function(data, flags) {
              if (!flags.binary) {
                return;
              }
              handleMessage((new Uint8Array(data)).buffer);  // copy from node Buffer -> ArrayBuffer
            });
            peer.socket.on('close', function() {
              Module['websocket'].emit('close', sock.stream.fd);
            });
            peer.socket.on('error', function(error) {
              // Although the ws library may pass errors that may be more descriptive than
              // ECONNREFUSED they are not necessarily the expected error code e.g. 
              // ENOTFOUND on getaddrinfo seems to be node.js specific, so using ECONNREFUSED
              // is still probably the most useful thing to do.
              sock.error = ERRNO_CODES.ECONNREFUSED; // Used in getsockopt for SOL_SOCKET/SO_ERROR test.
              Module['websocket'].emit('error', [sock.stream.fd, sock.error, 'ECONNREFUSED: Connection refused']);
              // don't throw
            });
          } else {
            peer.socket.onopen = handleOpen;
            peer.socket.onclose = function() {
              Module['websocket'].emit('close', sock.stream.fd);
            };
            peer.socket.onmessage = function peer_socket_onmessage(event) {
              handleMessage(event.data);
            };
            peer.socket.onerror = function(error) {
              // The WebSocket spec only allows a 'simple event' to be thrown on error,
              // so we only really know as much as ECONNREFUSED.
              sock.error = ERRNO_CODES.ECONNREFUSED; // Used in getsockopt for SOL_SOCKET/SO_ERROR test.
              Module['websocket'].emit('error', [sock.stream.fd, sock.error, 'ECONNREFUSED: Connection refused']);
            };
          }
        },poll:function (sock) {
          if (sock.type === 1 && sock.server) {
            // listen sockets should only say they're available for reading
            // if there are pending clients.
            return sock.pending.length ? (64 | 1) : 0;
          }
  
          var mask = 0;
          var dest = sock.type === 1 ?  // we only care about the socket state for connection-based sockets
            SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport) :
            null;
  
          if (sock.recv_queue.length ||
              !dest ||  // connection-less sockets are always ready to read
              (dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {  // let recv return 0 once closed
            mask |= (64 | 1);
          }
  
          if (!dest ||  // connection-less sockets are always ready to write
              (dest && dest.socket.readyState === dest.socket.OPEN)) {
            mask |= 4;
          }
  
          if ((dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {
            mask |= 16;
          }
  
          return mask;
        },ioctl:function (sock, request, arg) {
          switch (request) {
            case 21531:
              var bytes = 0;
              if (sock.recv_queue.length) {
                bytes = sock.recv_queue[0].data.length;
              }
              HEAP32[((arg)>>2)]=bytes;
              return 0;
            default:
              return ERRNO_CODES.EINVAL;
          }
        },close:function (sock) {
          // if we've spawned a listen server, close it
          if (sock.server) {
            try {
              sock.server.close();
            } catch (e) {
            }
            sock.server = null;
          }
          // close any peer connections
          var peers = Object.keys(sock.peers);
          for (var i = 0; i < peers.length; i++) {
            var peer = sock.peers[peers[i]];
            try {
              peer.socket.close();
            } catch (e) {
            }
            SOCKFS.websocket_sock_ops.removePeer(sock, peer);
          }
          return 0;
        },bind:function (sock, addr, port) {
          if (typeof sock.saddr !== 'undefined' || typeof sock.sport !== 'undefined') {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already bound
          }
          sock.saddr = addr;
          sock.sport = port || _mkport();
          // in order to emulate dgram sockets, we need to launch a listen server when
          // binding on a connection-less socket
          // note: this is only required on the server side
          if (sock.type === 2) {
            // close the existing server if it exists
            if (sock.server) {
              sock.server.close();
              sock.server = null;
            }
            // swallow error operation not supported error that occurs when binding in the
            // browser where this isn't supported
            try {
              sock.sock_ops.listen(sock, 0);
            } catch (e) {
              if (!(e instanceof FS.ErrnoError)) throw e;
              if (e.errno !== ERRNO_CODES.EOPNOTSUPP) throw e;
            }
          }
        },connect:function (sock, addr, port) {
          if (sock.server) {
            throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
          }
  
          // TODO autobind
          // if (!sock.addr && sock.type == 2) {
          // }
  
          // early out if we're already connected / in the middle of connecting
          if (typeof sock.daddr !== 'undefined' && typeof sock.dport !== 'undefined') {
            var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
            if (dest) {
              if (dest.socket.readyState === dest.socket.CONNECTING) {
                throw new FS.ErrnoError(ERRNO_CODES.EALREADY);
              } else {
                throw new FS.ErrnoError(ERRNO_CODES.EISCONN);
              }
            }
          }
  
          // add the socket to our peer list and set our
          // destination address / port to match
          var peer = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
          sock.daddr = peer.addr;
          sock.dport = peer.port;
  
          // always "fail" in non-blocking mode
          throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS);
        },listen:function (sock, backlog) {
          if (!ENVIRONMENT_IS_NODE) {
            throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
          }
          if (sock.server) {
             throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already listening
          }
          var WebSocketServer = require('ws').Server;
          var host = sock.saddr;
          sock.server = new WebSocketServer({
            host: host,
            port: sock.sport
            // TODO support backlog
          });
          Module['websocket'].emit('listen', sock.stream.fd); // Send Event with listen fd.
  
          sock.server.on('connection', function(ws) {
            if (sock.type === 1) {
              var newsock = SOCKFS.createSocket(sock.family, sock.type, sock.protocol);
  
              // create a peer on the new socket
              var peer = SOCKFS.websocket_sock_ops.createPeer(newsock, ws);
              newsock.daddr = peer.addr;
              newsock.dport = peer.port;
  
              // push to queue for accept to pick up
              sock.pending.push(newsock);
              Module['websocket'].emit('connection', newsock.stream.fd);
            } else {
              // create a peer on the listen socket so calling sendto
              // with the listen socket and an address will resolve
              // to the correct client
              SOCKFS.websocket_sock_ops.createPeer(sock, ws);
              Module['websocket'].emit('connection', sock.stream.fd);
            }
          });
          sock.server.on('closed', function() {
            Module['websocket'].emit('close', sock.stream.fd);
            sock.server = null;
          });
          sock.server.on('error', function(error) {
            // Although the ws library may pass errors that may be more descriptive than
            // ECONNREFUSED they are not necessarily the expected error code e.g. 
            // ENOTFOUND on getaddrinfo seems to be node.js specific, so using EHOSTUNREACH
            // is still probably the most useful thing to do. This error shouldn't
            // occur in a well written app as errors should get trapped in the compiled
            // app's own getaddrinfo call.
            sock.error = ERRNO_CODES.EHOSTUNREACH; // Used in getsockopt for SOL_SOCKET/SO_ERROR test.
            Module['websocket'].emit('error', [sock.stream.fd, sock.error, 'EHOSTUNREACH: Host is unreachable']);
            // don't throw
          });
        },accept:function (listensock) {
          if (!listensock.server) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          var newsock = listensock.pending.shift();
          newsock.stream.flags = listensock.stream.flags;
          return newsock;
        },getname:function (sock, peer) {
          var addr, port;
          if (peer) {
            if (sock.daddr === undefined || sock.dport === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            }
            addr = sock.daddr;
            port = sock.dport;
          } else {
            // TODO saddr and sport will be set for bind()'d UDP sockets, but what
            // should we be returning for TCP sockets that've been connect()'d?
            addr = sock.saddr || 0;
            port = sock.sport || 0;
          }
          return { addr: addr, port: port };
        },sendmsg:function (sock, buffer, offset, length, addr, port) {
          if (sock.type === 2) {
            // connection-less sockets will honor the message address,
            // and otherwise fall back to the bound destination address
            if (addr === undefined || port === undefined) {
              addr = sock.daddr;
              port = sock.dport;
            }
            // if there was no address to fall back to, error out
            if (addr === undefined || port === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ);
            }
          } else {
            // connection-based sockets will only use the bound
            addr = sock.daddr;
            port = sock.dport;
          }
  
          // find the peer for the destination address
          var dest = SOCKFS.websocket_sock_ops.getPeer(sock, addr, port);
  
          // early out if not connected with a connection-based socket
          if (sock.type === 1) {
            if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            } else if (dest.socket.readyState === dest.socket.CONNECTING) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
  
          // create a copy of the incoming data to send, as the WebSocket API
          // doesn't work entirely with an ArrayBufferView, it'll just send
          // the entire underlying buffer
          var data;
          if (buffer instanceof Array || buffer instanceof ArrayBuffer) {
            data = buffer.slice(offset, offset + length);
          } else {  // ArrayBufferView
            data = buffer.buffer.slice(buffer.byteOffset + offset, buffer.byteOffset + offset + length);
          }
  
          // if we're emulating a connection-less dgram socket and don't have
          // a cached connection, queue the buffer to send upon connect and
          // lie, saying the data was sent now.
          if (sock.type === 2) {
            if (!dest || dest.socket.readyState !== dest.socket.OPEN) {
              // if we're not connected, open a new connection
              if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                dest = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
              }
              dest.dgram_send_queue.push(data);
              return length;
            }
          }
  
          try {
            // send the actual data
            dest.socket.send(data);
            return length;
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
        },recvmsg:function (sock, length) {
          // http://pubs.opengroup.org/onlinepubs/7908799/xns/recvmsg.html
          if (sock.type === 1 && sock.server) {
            // tcp servers should not be recv()'ing on the listen socket
            throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
          }
  
          var queued = sock.recv_queue.shift();
          if (!queued) {
            if (sock.type === 1) {
              var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
  
              if (!dest) {
                // if we have a destination address but are not connected, error out
                throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
              }
              else if (dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                // return null if the socket has closed
                return null;
              }
              else {
                // else, our socket is in a valid state but truly has nothing available
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
            } else {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
  
          // queued.data will be an ArrayBuffer if it's unadulterated, but if it's
          // requeued TCP data it'll be an ArrayBufferView
          var queuedLength = queued.data.byteLength || queued.data.length;
          var queuedOffset = queued.data.byteOffset || 0;
          var queuedBuffer = queued.data.buffer || queued.data;
          var bytesRead = Math.min(length, queuedLength);
          var res = {
            buffer: new Uint8Array(queuedBuffer, queuedOffset, bytesRead),
            addr: queued.addr,
            port: queued.port
          };
  
  
          // push back any unread data for TCP connections
          if (sock.type === 1 && bytesRead < queuedLength) {
            var bytesRemaining = queuedLength - bytesRead;
            queued.data = new Uint8Array(queuedBuffer, queuedOffset + bytesRead, bytesRemaining);
            sock.recv_queue.unshift(queued);
          }
  
          return res;
        }}};function _send(fd, buf, len, flags) {
      var sock = SOCKFS.getSocket(fd);
      if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      // TODO honor flags
      return _write(fd, buf, len);
    }
  
  function _pwrite(fildes, buf, nbyte, offset) {
      // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte, offset);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _write(fildes, buf, nbyte) {
      // ssize_t write(int fildes, const void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
  
  
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }
  
  function _fileno(stream) {
      // int fileno(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fileno.html
      stream = FS.getStreamFromPtr(stream);
      if (!stream) return -1;
      return stream.fd;
    }function _fwrite(ptr, size, nitems, stream) {
      // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
      var bytesToWrite = nitems * size;
      if (bytesToWrite == 0) return 0;
      var fd = _fileno(stream);
      var bytesWritten = _write(fd, ptr, bytesToWrite);
      if (bytesWritten == -1) {
        var streamObj = FS.getStreamFromPtr(stream);
        if (streamObj) streamObj.error = true;
        return 0;
      } else {
        return (bytesWritten / size)|0;
      }
    }
  
  
  function __reallyNegative(x) {
      return x < 0 || (x === 0 && (1/x) === -Infinity);
    }function __formatString(format, varargs) {
      assert((varargs & 3) === 0);
      var textIndex = format;
      var argIndex = 0;
      function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        argIndex = Runtime.prepVararg(argIndex, type);
        if (type === 'double') {
          ret = (HEAP32[((tempDoublePtr)>>2)]=HEAP32[(((varargs)+(argIndex))>>2)],HEAP32[(((tempDoublePtr)+(4))>>2)]=HEAP32[(((varargs)+((argIndex)+(4)))>>2)],(+(HEAPF64[(tempDoublePtr)>>3])));
          argIndex += 8;
        } else if (type == 'i64') {
          ret = [HEAP32[(((varargs)+(argIndex))>>2)],
                 HEAP32[(((varargs)+(argIndex+4))>>2)]];
  
          argIndex += 8;
        } else {
          assert((argIndex & 3) === 0);
          type = 'i32'; // varargs are always i32, i64, or double
          ret = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += 4;
        }
        return ret;
      }
  
      var ret = [];
      var curr, next, currArg;
      while(1) {
        var startTextIndex = textIndex;
        curr = HEAP8[((textIndex)>>0)];
        if (curr === 0) break;
        next = HEAP8[((textIndex+1)>>0)];
        if (curr == 37) {
          // Handle flags.
          var flagAlwaysSigned = false;
          var flagLeftAlign = false;
          var flagAlternative = false;
          var flagZeroPad = false;
          var flagPadSign = false;
          flagsLoop: while (1) {
            switch (next) {
              case 43:
                flagAlwaysSigned = true;
                break;
              case 45:
                flagLeftAlign = true;
                break;
              case 35:
                flagAlternative = true;
                break;
              case 48:
                if (flagZeroPad) {
                  break flagsLoop;
                } else {
                  flagZeroPad = true;
                  break;
                }
              case 32:
                flagPadSign = true;
                break;
              default:
                break flagsLoop;
            }
            textIndex++;
            next = HEAP8[((textIndex+1)>>0)];
          }
  
          // Handle width.
          var width = 0;
          if (next == 42) {
            width = getNextArg('i32');
            textIndex++;
            next = HEAP8[((textIndex+1)>>0)];
          } else {
            while (next >= 48 && next <= 57) {
              width = width * 10 + (next - 48);
              textIndex++;
              next = HEAP8[((textIndex+1)>>0)];
            }
          }
  
          // Handle precision.
          var precisionSet = false, precision = -1;
          if (next == 46) {
            precision = 0;
            precisionSet = true;
            textIndex++;
            next = HEAP8[((textIndex+1)>>0)];
            if (next == 42) {
              precision = getNextArg('i32');
              textIndex++;
            } else {
              while(1) {
                var precisionChr = HEAP8[((textIndex+1)>>0)];
                if (precisionChr < 48 ||
                    precisionChr > 57) break;
                precision = precision * 10 + (precisionChr - 48);
                textIndex++;
              }
            }
            next = HEAP8[((textIndex+1)>>0)];
          }
          if (precision < 0) {
            precision = 6; // Standard default.
            precisionSet = false;
          }
  
          // Handle integer sizes. WARNING: These assume a 32-bit architecture!
          var argSize;
          switch (String.fromCharCode(next)) {
            case 'h':
              var nextNext = HEAP8[((textIndex+2)>>0)];
              if (nextNext == 104) {
                textIndex++;
                argSize = 1; // char (actually i32 in varargs)
              } else {
                argSize = 2; // short (actually i32 in varargs)
              }
              break;
            case 'l':
              var nextNext = HEAP8[((textIndex+2)>>0)];
              if (nextNext == 108) {
                textIndex++;
                argSize = 8; // long long
              } else {
                argSize = 4; // long
              }
              break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
              argSize = 8;
              break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
              argSize = 4;
              break;
            default:
              argSize = null;
          }
          if (argSize) textIndex++;
          next = HEAP8[((textIndex+1)>>0)];
  
          // Handle type specifier.
          switch (String.fromCharCode(next)) {
            case 'd': case 'i': case 'u': case 'o': case 'x': case 'X': case 'p': {
              // Integer.
              var signed = next == 100 || next == 105;
              argSize = argSize || 4;
              var currArg = getNextArg('i' + (argSize * 8));
              var origArg = currArg;
              var argText;
              // Flatten i64-1 [low, high] into a (slightly rounded) double
              if (argSize == 8) {
                currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
              }
              // Truncate to requested size.
              if (argSize <= 4) {
                var limit = Math.pow(256, argSize) - 1;
                currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
              }
              // Format the number.
              var currAbsArg = Math.abs(currArg);
              var prefix = '';
              if (next == 100 || next == 105) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null); else
                argText = reSign(currArg, 8 * argSize, 1).toString(10);
              } else if (next == 117) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true); else
                argText = unSign(currArg, 8 * argSize, 1).toString(10);
                currArg = Math.abs(currArg);
              } else if (next == 111) {
                argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
              } else if (next == 120 || next == 88) {
                prefix = (flagAlternative && currArg != 0) ? '0x' : '';
                if (argSize == 8 && i64Math) {
                  if (origArg[1]) {
                    argText = (origArg[1]>>>0).toString(16);
                    var lower = (origArg[0]>>>0).toString(16);
                    while (lower.length < 8) lower = '0' + lower;
                    argText += lower;
                  } else {
                    argText = (origArg[0]>>>0).toString(16);
                  }
                } else
                if (currArg < 0) {
                  // Represent negative numbers in hex as 2's complement.
                  currArg = -currArg;
                  argText = (currAbsArg - 1).toString(16);
                  var buffer = [];
                  for (var i = 0; i < argText.length; i++) {
                    buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                  }
                  argText = buffer.join('');
                  while (argText.length < argSize * 2) argText = 'f' + argText;
                } else {
                  argText = currAbsArg.toString(16);
                }
                if (next == 88) {
                  prefix = prefix.toUpperCase();
                  argText = argText.toUpperCase();
                }
              } else if (next == 112) {
                if (currAbsArg === 0) {
                  argText = '(nil)';
                } else {
                  prefix = '0x';
                  argText = currAbsArg.toString(16);
                }
              }
              if (precisionSet) {
                while (argText.length < precision) {
                  argText = '0' + argText;
                }
              }
  
              // Add sign if needed
              if (currArg >= 0) {
                if (flagAlwaysSigned) {
                  prefix = '+' + prefix;
                } else if (flagPadSign) {
                  prefix = ' ' + prefix;
                }
              }
  
              // Move sign to prefix so we zero-pad after the sign
              if (argText.charAt(0) == '-') {
                prefix = '-' + prefix;
                argText = argText.substr(1);
              }
  
              // Add padding.
              while (prefix.length + argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad) {
                    argText = '0' + argText;
                  } else {
                    prefix = ' ' + prefix;
                  }
                }
              }
  
              // Insert the result into the buffer.
              argText = prefix + argText;
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 'f': case 'F': case 'e': case 'E': case 'g': case 'G': {
              // Float.
              var currArg = getNextArg('double');
              var argText;
              if (isNaN(currArg)) {
                argText = 'nan';
                flagZeroPad = false;
              } else if (!isFinite(currArg)) {
                argText = (currArg < 0 ? '-' : '') + 'inf';
                flagZeroPad = false;
              } else {
                var isGeneral = false;
                var effectivePrecision = Math.min(precision, 20);
  
                // Convert g/G to f/F or e/E, as per:
                // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
                if (next == 103 || next == 71) {
                  isGeneral = true;
                  precision = precision || 1;
                  var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                  if (precision > exponent && exponent >= -4) {
                    next = ((next == 103) ? 'f' : 'F').charCodeAt(0);
                    precision -= exponent + 1;
                  } else {
                    next = ((next == 103) ? 'e' : 'E').charCodeAt(0);
                    precision--;
                  }
                  effectivePrecision = Math.min(precision, 20);
                }
  
                if (next == 101 || next == 69) {
                  argText = currArg.toExponential(effectivePrecision);
                  // Make sure the exponent has at least 2 digits.
                  if (/[eE][-+]\d$/.test(argText)) {
                    argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                  }
                } else if (next == 102 || next == 70) {
                  argText = currArg.toFixed(effectivePrecision);
                  if (currArg === 0 && __reallyNegative(currArg)) {
                    argText = '-' + argText;
                  }
                }
  
                var parts = argText.split('e');
                if (isGeneral && !flagAlternative) {
                  // Discard trailing zeros and periods.
                  while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                         (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                    parts[0] = parts[0].slice(0, -1);
                  }
                } else {
                  // Make sure we have a period in alternative mode.
                  if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                  // Zero pad until required precision.
                  while (precision > effectivePrecision++) parts[0] += '0';
                }
                argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');
  
                // Capitalize 'E' if needed.
                if (next == 69) argText = argText.toUpperCase();
  
                // Add sign.
                if (currArg >= 0) {
                  if (flagAlwaysSigned) {
                    argText = '+' + argText;
                  } else if (flagPadSign) {
                    argText = ' ' + argText;
                  }
                }
              }
  
              // Add padding.
              while (argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                    argText = argText[0] + '0' + argText.slice(1);
                  } else {
                    argText = (flagZeroPad ? '0' : ' ') + argText;
                  }
                }
              }
  
              // Adjust case.
              if (next < 97) argText = argText.toUpperCase();
  
              // Insert the result into the buffer.
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 's': {
              // String.
              var arg = getNextArg('i8*');
              var argLength = arg ? _strlen(arg) : '(null)'.length;
              if (precisionSet) argLength = Math.min(argLength, precision);
              if (!flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              if (arg) {
                for (var i = 0; i < argLength; i++) {
                  ret.push(HEAPU8[((arg++)>>0)]);
                }
              } else {
                ret = ret.concat(intArrayFromString('(null)'.substr(0, argLength), true));
              }
              if (flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              break;
            }
            case 'c': {
              // Character.
              if (flagLeftAlign) ret.push(getNextArg('i8'));
              while (--width > 0) {
                ret.push(32);
              }
              if (!flagLeftAlign) ret.push(getNextArg('i8'));
              break;
            }
            case 'n': {
              // Write the length written so far to the next parameter.
              var ptr = getNextArg('i32*');
              HEAP32[((ptr)>>2)]=ret.length;
              break;
            }
            case '%': {
              // Literal percent sign.
              ret.push(curr);
              break;
            }
            default: {
              // Unknown specifiers remain untouched.
              for (var i = startTextIndex; i < textIndex + 2; i++) {
                ret.push(HEAP8[((i)>>0)]);
              }
            }
          }
          textIndex += 2;
          // TODO: Support a/A (hex float) and m (last error) specifiers.
          // TODO: Support %1${specifier} for arg selection.
        } else {
          ret.push(curr);
          textIndex += 1;
        }
      }
      return ret;
    }function _fprintf(stream, format, varargs) {
      // int fprintf(FILE *restrict stream, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var stack = Runtime.stackSave();
      var ret = _fwrite(allocate(result, 'i8', ALLOC_STACK), 1, result.length, stream);
      Runtime.stackRestore(stack);
      return ret;
    }function _vfprintf(s, f, va_arg) {
      return _fprintf(s, f, HEAP32[((va_arg)>>2)]);
    }

  
  function _emscripten_memcpy_big(dest, src, num) {
      HEAPU8.set(HEAPU8.subarray(src, src+num), dest);
      return dest;
    } 
  Module["_memcpy"] = _memcpy;

  var _log=Math_log;

  var _cos=Math_cos;

  var _llvm_pow_f64=Math_pow;

  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) {
        var success = self.alloc(bytes);
        if (!success) return -1 >>> 0; // sbrk failure code
      }
      return ret;  // Previous break location.
    }

   
  Module["_bitshift64Shl"] = _bitshift64Shl;

  function ___errno_location() {
      return ___errno_state;
    }

  var _BItoD=true;

  function _hip_set_debugf() {
  Module['printErr']('missing function: hip_set_debugf'); abort(-1);
  }

  var _exp=Math_exp;

  function _time(ptr) {
      var ret = (Date.now()/1000)|0;
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret;
      }
      return ret;
    }

  function _hip_decode1_unclipped() {
  Module['printErr']('missing function: hip_decode1_unclipped'); abort(-1);
  }

___errno_state = Runtime.staticAlloc(4); HEAP32[((___errno_state)>>2)]=0;
FS.staticInit();__ATINIT__.unshift(function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() });__ATMAIN__.push(function() { FS.ignorePermissions = false });__ATEXIT__.push(function() { FS.quit() });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;
__ATINIT__.unshift(function() { TTY.init() });__ATEXIT__.push(function() { TTY.shutdown() });
if (ENVIRONMENT_IS_NODE) { var fs = require("fs"); var NODEJS_PATH = require("path"); NODEFS.staticInit(); }
Module["requestFullScreen"] = function Module_requestFullScreen(lockPointer, resizeCanvas, vrDevice) { Browser.requestFullScreen(lockPointer, resizeCanvas, vrDevice) };
  Module["requestAnimationFrame"] = function Module_requestAnimationFrame(func) { Browser.requestAnimationFrame(func) };
  Module["setCanvasSize"] = function Module_setCanvasSize(width, height, noUpdates) { Browser.setCanvasSize(width, height, noUpdates) };
  Module["pauseMainLoop"] = function Module_pauseMainLoop() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function Module_resumeMainLoop() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function Module_getUserMedia() { Browser.getUserMedia() }
  Module["createContext"] = function Module_createContext(canvas, useWebGL, setInModule, webGLContextAttributes) { return Browser.createContext(canvas, useWebGL, setInModule, webGLContextAttributes) }
__ATINIT__.push(function() { SOCKFS.root = FS.mount(SOCKFS, {}, null); });
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);

staticSealed = true; // seal the static portion of memory

STACK_MAX = STACK_BASE + TOTAL_STACK;

DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);

assert(DYNAMIC_BASE < TOTAL_MEMORY, "TOTAL_MEMORY not big enough for stack");

 var cttz_i8 = allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0], "i8", ALLOC_DYNAMIC);


function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

Module.asmGlobalArg = { "Math": Math, "Int8Array": Int8Array, "Int16Array": Int16Array, "Int32Array": Int32Array, "Uint8Array": Uint8Array, "Uint16Array": Uint16Array, "Uint32Array": Uint32Array, "Float32Array": Float32Array, "Float64Array": Float64Array, "NaN": NaN, "Infinity": Infinity };
Module.asmLibraryArg = { "abort": abort, "assert": assert, "invoke_iiii": invoke_iiii, "invoke_iiiii": invoke_iiiii, "invoke_vii": invoke_vii, "invoke_iii": invoke_iii, "invoke_viiii": invoke_viiii, "_fabs": _fabs, "_sin": _sin, "_exp": _exp, "_llvm_pow_f64": _llvm_pow_f64, "_send": _send, "_VBR_encode_frame": _VBR_encode_frame, "_abort": _abort, "___setErrNo": ___setErrNo, "_vfprintf": _vfprintf, "_hip_set_debugf": _hip_set_debugf, "_floor": _floor, "_fflush": _fflush, "_pwrite": _pwrite, "_strerror_r": _strerror_r, "__exit": __exit, "_GetTitleGain": _GetTitleGain, "_emscripten_set_main_loop_timing": _emscripten_set_main_loop_timing, "_fabsf": _fabsf, "_sbrk": _sbrk, "_atan": _atan, "_llvm_pow_f32": _llvm_pow_f32, "_InitGainAnalysis": _InitGainAnalysis, "_emscripten_memcpy_big": _emscripten_memcpy_big, "_fileno": _fileno, "_hip_decode_exit": _hip_decode_exit, "_sysconf": _sysconf, "_cos": _cos, "_mkport": _mkport, "_floorf": _floorf, "_hip_set_errorf": _hip_set_errorf, "__reallyNegative": __reallyNegative, "_write": _write, "_emscripten_set_main_loop": _emscripten_set_main_loop, "_AnalyzeSamples": _AnalyzeSamples, "___errno_location": ___errno_location, "_log": _log, "_init_xrpow_core_sse": _init_xrpow_core_sse, "_hip_decode1_unclipped": _hip_decode1_unclipped, "_fwrite": _fwrite, "_time": _time, "_fprintf": _fprintf, "_strerror": _strerror, "_ceil": _ceil, "__formatString": __formatString, "_sqrt": _sqrt, "_hip_set_msgf": _hip_set_msgf, "_exit": _exit, "_hip_decode_init": _hip_decode_init, "_llvm_sqrt_f64": _llvm_sqrt_f64, "STACKTOP": STACKTOP, "STACK_MAX": STACK_MAX, "tempDoublePtr": tempDoublePtr, "ABORT": ABORT, "cttz_i8": cttz_i8, "_stderr": _stderr };
// EMSCRIPTEN_START_ASM
var asm = (function(global, env, buffer) {
  'use asm';
  
  var HEAP8 = new global.Int8Array(buffer);
  var HEAP16 = new global.Int16Array(buffer);
  var HEAP32 = new global.Int32Array(buffer);
  var HEAPU8 = new global.Uint8Array(buffer);
  var HEAPU16 = new global.Uint16Array(buffer);
  var HEAPU32 = new global.Uint32Array(buffer);
  var HEAPF32 = new global.Float32Array(buffer);
  var HEAPF64 = new global.Float64Array(buffer);


  var STACKTOP=env.STACKTOP|0;
  var STACK_MAX=env.STACK_MAX|0;
  var tempDoublePtr=env.tempDoublePtr|0;
  var ABORT=env.ABORT|0;
  var cttz_i8=env.cttz_i8|0;
  var _stderr=env._stderr|0;

  var __THREW__ = 0;
  var threwValue = 0;
  var setjmpId = 0;
  var undef = 0;
  var nan = global.NaN, inf = global.Infinity;
  var tempInt = 0, tempBigInt = 0, tempBigIntP = 0, tempBigIntS = 0, tempBigIntR = 0.0, tempBigIntI = 0, tempBigIntD = 0, tempValue = 0, tempDouble = 0.0;

  var tempRet0 = 0;
  var tempRet1 = 0;
  var tempRet2 = 0;
  var tempRet3 = 0;
  var tempRet4 = 0;
  var tempRet5 = 0;
  var tempRet6 = 0;
  var tempRet7 = 0;
  var tempRet8 = 0;
  var tempRet9 = 0;
  var Math_floor=global.Math.floor;
  var Math_abs=global.Math.abs;
  var Math_sqrt=global.Math.sqrt;
  var Math_pow=global.Math.pow;
  var Math_cos=global.Math.cos;
  var Math_sin=global.Math.sin;
  var Math_tan=global.Math.tan;
  var Math_acos=global.Math.acos;
  var Math_asin=global.Math.asin;
  var Math_atan=global.Math.atan;
  var Math_atan2=global.Math.atan2;
  var Math_exp=global.Math.exp;
  var Math_log=global.Math.log;
  var Math_ceil=global.Math.ceil;
  var Math_imul=global.Math.imul;
  var Math_min=global.Math.min;
  var Math_clz32=global.Math.clz32;
  var abort=env.abort;
  var assert=env.assert;
  var invoke_iiii=env.invoke_iiii;
  var invoke_iiiii=env.invoke_iiiii;
  var invoke_vii=env.invoke_vii;
  var invoke_iii=env.invoke_iii;
  var invoke_viiii=env.invoke_viiii;
  var _fabs=env._fabs;
  var _sin=env._sin;
  var _exp=env._exp;
  var _llvm_pow_f64=env._llvm_pow_f64;
  var _send=env._send;
  var _VBR_encode_frame=env._VBR_encode_frame;
  var _abort=env._abort;
  var ___setErrNo=env.___setErrNo;
  var _vfprintf=env._vfprintf;
  var _hip_set_debugf=env._hip_set_debugf;
  var _floor=env._floor;
  var _fflush=env._fflush;
  var _pwrite=env._pwrite;
  var _strerror_r=env._strerror_r;
  var __exit=env.__exit;
  var _GetTitleGain=env._GetTitleGain;
  var _emscripten_set_main_loop_timing=env._emscripten_set_main_loop_timing;
  var _fabsf=env._fabsf;
  var _sbrk=env._sbrk;
  var _atan=env._atan;
  var _llvm_pow_f32=env._llvm_pow_f32;
  var _InitGainAnalysis=env._InitGainAnalysis;
  var _emscripten_memcpy_big=env._emscripten_memcpy_big;
  var _fileno=env._fileno;
  var _hip_decode_exit=env._hip_decode_exit;
  var _sysconf=env._sysconf;
  var _cos=env._cos;
  var _mkport=env._mkport;
  var _floorf=env._floorf;
  var _hip_set_errorf=env._hip_set_errorf;
  var __reallyNegative=env.__reallyNegative;
  var _write=env._write;
  var _emscripten_set_main_loop=env._emscripten_set_main_loop;
  var _AnalyzeSamples=env._AnalyzeSamples;
  var ___errno_location=env.___errno_location;
  var _log=env._log;
  var _init_xrpow_core_sse=env._init_xrpow_core_sse;
  var _hip_decode1_unclipped=env._hip_decode1_unclipped;
  var _fwrite=env._fwrite;
  var _time=env._time;
  var _fprintf=env._fprintf;
  var _strerror=env._strerror;
  var _ceil=env._ceil;
  var __formatString=env.__formatString;
  var _sqrt=env._sqrt;
  var _hip_set_msgf=env._hip_set_msgf;
  var _exit=env._exit;
  var _hip_decode_init=env._hip_decode_init;
  var _llvm_sqrt_f64=env._llvm_sqrt_f64;
  var tempFloat = 0.0;

// EMSCRIPTEN_START_FUNCS
function stackAlloc(size) {
  size = size|0;
  var ret = 0;
  ret = STACKTOP;
  STACKTOP = (STACKTOP + size)|0;
  STACKTOP = (STACKTOP + 15)&-16;

  return ret|0;
}
function stackSave() {
  return STACKTOP|0;
}
function stackRestore(top) {
  top = top|0;
  STACKTOP = top;
}
function establishStackSpace(stackBase, stackMax) {
  stackBase = stackBase|0;
  stackMax = stackMax|0;
  STACKTOP = stackBase;
  STACK_MAX = stackMax;
}

function setThrew(threw, value) {
  threw = threw|0;
  value = value|0;
  if ((__THREW__|0) == 0) {
    __THREW__ = threw;
    threwValue = value;
  }
}
function copyTempFloat(ptr) {
  ptr = ptr|0;
  HEAP8[tempDoublePtr>>0] = HEAP8[ptr>>0];
  HEAP8[tempDoublePtr+1>>0] = HEAP8[ptr+1>>0];
  HEAP8[tempDoublePtr+2>>0] = HEAP8[ptr+2>>0];
  HEAP8[tempDoublePtr+3>>0] = HEAP8[ptr+3>>0];
}
function copyTempDouble(ptr) {
  ptr = ptr|0;
  HEAP8[tempDoublePtr>>0] = HEAP8[ptr>>0];
  HEAP8[tempDoublePtr+1>>0] = HEAP8[ptr+1>>0];
  HEAP8[tempDoublePtr+2>>0] = HEAP8[ptr+2>>0];
  HEAP8[tempDoublePtr+3>>0] = HEAP8[ptr+3>>0];
  HEAP8[tempDoublePtr+4>>0] = HEAP8[ptr+4>>0];
  HEAP8[tempDoublePtr+5>>0] = HEAP8[ptr+5>>0];
  HEAP8[tempDoublePtr+6>>0] = HEAP8[ptr+6>>0];
  HEAP8[tempDoublePtr+7>>0] = HEAP8[ptr+7>>0];
}

function setTempRet0(value) {
  value = value|0;
  tempRet0 = value;
}
function getTempRet0() {
  return tempRet0|0;
}

function _AddVbrFrame($gfc) {
 $gfc = $gfc|0;
 var $$pre$i = 0, $$pre2$i = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i$01$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($gfc)) + 84744|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($gfc)) + 16|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((83944 + ($3<<6)|0) + ($1<<2)|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($gfc)) + 85784|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = (($7) + 1)|0;
 HEAP32[$6>>2] = $8;
 $9 = ((($gfc)) + 85760|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = (($10) + ($5))|0;
 HEAP32[$9>>2] = $11;
 $12 = ((($gfc)) + 85764|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = (($13) + 1)|0;
 HEAP32[$12>>2] = $14;
 $15 = ((($gfc)) + 85768|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($14|0)<($16|0);
 if ($17) {
  return;
 }
 $18 = ((($gfc)) + 85772|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = ((($gfc)) + 85776|0);
 $21 = HEAP32[$20>>2]|0;
 $22 = ($19|0)<($21|0);
 if ($22) {
  $23 = ((($gfc)) + 85780|0);
  $24 = HEAP32[$23>>2]|0;
  $25 = (($24) + ($19<<2)|0);
  HEAP32[$25>>2] = $11;
  $26 = HEAP32[$18>>2]|0;
  $27 = (($26) + 1)|0;
  HEAP32[$18>>2] = $27;
  HEAP32[$12>>2] = 0;
  $$pre$i = HEAP32[$20>>2]|0;
  $28 = $27;$30 = $$pre$i;
 } else {
  $28 = $19;$30 = $21;
 }
 $29 = ($28|0)==($30|0);
 if (!($29)) {
  return;
 }
 $31 = ($30|0)>(1);
 if ($31) {
  $32 = ((($gfc)) + 85780|0);
  $33 = HEAP32[$32>>2]|0;
  $i$01$i = 1;
  while(1) {
   $34 = (($33) + ($i$01$i<<2)|0);
   $35 = HEAP32[$34>>2]|0;
   $36 = (($i$01$i|0) / 2)&-1;
   $37 = (($33) + ($36<<2)|0);
   HEAP32[$37>>2] = $35;
   $38 = (($i$01$i) + 2)|0;
   $39 = HEAP32[$20>>2]|0;
   $40 = ($38|0)<($39|0);
   if ($40) {
    $i$01$i = $38;
   } else {
    break;
   }
  }
  $$pre2$i = HEAP32[$18>>2]|0;
  $44 = $$pre2$i;
 } else {
  $44 = $30;
 }
 $41 = HEAP32[$15>>2]|0;
 $42 = $41 << 1;
 HEAP32[$15>>2] = $42;
 $43 = (($44|0) / 2)&-1;
 HEAP32[$18>>2] = $43;
 return;
}
function _InitVbrTag($gfp) {
 $gfp = $gfp|0;
 var $$ = 0, $$0 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $buffer = 0, $exitcond = 0, $i$02 = 0, $kbps_header$0 = 0, $kbps_header$1 = 0, $or$cond = 0, $vararg_buffer = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 2896|0;
 $vararg_buffer = sp;
 $buffer = sp + 8|0;
 $0 = ((($gfp)) + 288|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 16|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)==(1);
 if ($4) {
  $kbps_header$0 = 128;
 } else {
  $5 = ((($1)) + 64|0);
  $6 = HEAP32[$5>>2]|0;
  $7 = ($6|0)<(16000);
  $$ = $7 ? 32 : 64;
  $kbps_header$0 = $$;
 }
 $8 = ((($1)) + 104|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ($9|0)==(0);
 if ($10) {
  $11 = ((($1)) + 120|0);
  $12 = HEAP32[$11>>2]|0;
  $kbps_header$1 = $12;
 } else {
  $kbps_header$1 = $kbps_header$0;
 }
 $13 = ($3*72000)|0;
 $14 = (($13) + 72000)|0;
 $15 = Math_imul($14, $kbps_header$1)|0;
 $16 = ((($1)) + 64|0);
 $17 = HEAP32[$16>>2]|0;
 $18 = (($15|0) / ($17|0))&-1;
 $19 = ((($1)) + 24|0);
 $20 = HEAP32[$19>>2]|0;
 $21 = (($20) + 156)|0;
 $22 = ((($1)) + 85792|0);
 HEAP32[$22>>2] = $18;
 $23 = ($18|0)<($21|0);
 $24 = ($18|0)>(2880);
 $or$cond = $24 | $23;
 if ($or$cond) {
  $25 = ((($1)) + 156|0);
  HEAP32[$25>>2] = 0;
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $26 = ((($1)) + 85784|0);
 HEAP32[$26>>2] = 0;
 $27 = ((($1)) + 85788|0);
 HEAP32[$27>>2] = 0;
 $28 = ((($1)) + 85760|0);
 HEAP32[$28>>2] = 0;
 $29 = ((($1)) + 85764|0);
 HEAP32[$29>>2] = 0;
 $30 = ((($1)) + 85768|0);
 HEAP32[$30>>2] = 1;
 $31 = ((($1)) + 85772|0);
 HEAP32[$31>>2] = 0;
 $32 = ((($1)) + 85780|0);
 $33 = HEAP32[$32>>2]|0;
 $34 = ($33|0)==(0|0);
 do {
  if ($34) {
   $35 = (_malloc(1600)|0);
   HEAP32[$32>>2] = $35;
   $36 = ($35|0)==(0|0);
   $37 = ((($1)) + 85776|0);
   if (!($36)) {
    HEAP32[$37>>2] = 400;
    break;
   }
   HEAP32[$37>>2] = 0;
   _lame_errorf($1,8,$vararg_buffer);
   $38 = ((($1)) + 156|0);
   HEAP32[$38>>2] = 0;
   $$0 = -1;
   STACKTOP = sp;return ($$0|0);
  }
 } while(0);
 _memset(($buffer|0),0,2880)|0;
 _setLameTagFrameHeader($1,$buffer);
 $39 = HEAP32[$22>>2]|0;
 $40 = ($39|0)==(0);
 if (!($40)) {
  $i$02 = 0;
  while(1) {
   $41 = (($buffer) + ($i$02)|0);
   $42 = HEAP8[$41>>0]|0;
   _add_dummy_byte($1,$42,1);
   $43 = (($i$02) + 1)|0;
   $exitcond = ($43|0)==($39|0);
   if ($exitcond) {
    break;
   } else {
    $i$02 = $43;
   }
  }
 }
 $$0 = 0;
 STACKTOP = sp;return ($$0|0);
}
function _UpdateMusicCRC($crc,$buffer,$size) {
 $crc = $crc|0;
 $buffer = $buffer|0;
 $size = $size|0;
 var $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $i$01 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($size|0)>(0);
 if (!($0)) {
  return;
 }
 $$pre = HEAP16[$crc>>1]|0;
 $5 = $$pre;$i$01 = 0;
 while(1) {
  $1 = (($buffer) + ($i$01)|0);
  $2 = HEAP8[$1>>0]|0;
  $3 = $2&255;
  $4 = $5&65535;
  $6 = $5 ^ $3;
  $7 = $4 >>> 8;
  $8 = $6&65535;
  $9 = $8 & 255;
  $10 = (48 + ($9<<2)|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = $7 ^ $11;
  $13 = $12&65535;
  HEAP16[$crc>>1] = $13;
  $14 = (($i$01) + 1)|0;
  $exitcond = ($14|0)==($size|0);
  if ($exitcond) {
   break;
  } else {
   $5 = $13;$i$01 = $14;
  }
 }
 return;
}
function _setLameTagFrameHeader($gfc,$buffer) {
 $gfc = $gfc|0;
 $buffer = $buffer|0;
 var $$ = 0, $$masked = 0, $$masked1 = 0, $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0;
 var $112 = 0, $113 = 0, $114 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $bbyte$0 = 0;
 var $bitrate$0 = 0, $bitrate$1 = 0, $not$ = 0, $sext = 0, $sext2 = 0, $storemerge = 0, $storemerge$in = 0, label = 0, sp = 0;
 sp = STACKTOP;
 HEAP8[$buffer>>0] = -1;
 $0 = ((($buffer)) + 1|0);
 $1 = HEAP8[$0>>0]|0;
 $2 = $1&255;
 $3 = $2 << 3;
 $4 = $3 | 7;
 $5 = $4&255;
 HEAP8[$0>>0] = $5;
 $6 = $4 << 1;
 $7 = ((($gfc)) + 64|0);
 $8 = HEAP32[$7>>2]|0;
 $not$ = ($8|0)>(15999);
 $9 = $not$&1;
 $10 = $6 | $9;
 $11 = $10&255;
 HEAP8[$0>>0] = $11;
 $12 = $10 << 1;
 $13 = ((($gfc)) + 16|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = $14 & 1;
 $$masked = $12 & 62;
 $16 = $$masked | $15;
 $17 = $16 << 2;
 $18 = $17 | 1;
 $19 = $18&255;
 HEAP8[$0>>0] = $19;
 $20 = $18 << 1;
 $21 = ((($gfc)) + 160|0);
 $22 = HEAP32[$21>>2]|0;
 $23 = ($22|0)==(0);
 $24 = $23&1;
 $25 = $20 | $24;
 $26 = $25&255;
 HEAP8[$0>>0] = $26;
 $27 = ((($buffer)) + 2|0);
 $28 = HEAP8[$27>>0]|0;
 $29 = $28&255;
 $30 = $29 << 4;
 $31 = ((($gfc)) + 84744|0);
 $32 = HEAP32[$31>>2]|0;
 $33 = $32 & 15;
 $34 = $30 | $33;
 $35 = $34&255;
 HEAP8[$27>>0] = $35;
 $36 = $34 << 2;
 $37 = ((($gfc)) + 20|0);
 $38 = HEAP32[$37>>2]|0;
 $39 = $38 & 3;
 $$masked1 = $36 & 124;
 $40 = $$masked1 | $39;
 $41 = $40 << 1;
 $42 = $41&255;
 HEAP8[$27>>0] = $42;
 $43 = $40 << 2;
 $44 = ((($gfc)) + 172|0);
 $45 = HEAP32[$44>>2]|0;
 $46 = $45 & 1;
 $47 = $43 | $46;
 $48 = $47&255;
 HEAP8[$27>>0] = $48;
 $49 = ((($buffer)) + 3|0);
 $50 = HEAP8[$49>>0]|0;
 $51 = $50&255;
 $52 = $51 << 2;
 $53 = ((($gfc)) + 180|0);
 $54 = HEAP32[$53>>2]|0;
 $55 = $54 & 3;
 $56 = $52 | $55;
 $57 = $56&255;
 HEAP8[$49>>0] = $57;
 $58 = $56 << 2;
 $59 = ((($gfc)) + 84756|0);
 $60 = HEAP32[$59>>2]|0;
 $61 = $60 & 3;
 $62 = $58 | $61;
 $63 = $62&255;
 HEAP8[$49>>0] = $63;
 $64 = $62 << 1;
 $65 = ((($gfc)) + 164|0);
 $66 = HEAP32[$65>>2]|0;
 $67 = $66 & 1;
 $68 = $64 | $67;
 $69 = $68&255;
 HEAP8[$49>>0] = $69;
 $70 = $68 << 1;
 $71 = ((($gfc)) + 168|0);
 $72 = HEAP32[$71>>2]|0;
 $73 = $72 & 1;
 $74 = $70 | $73;
 $75 = $74&255;
 HEAP8[$49>>0] = $75;
 $76 = $74 << 2;
 $77 = ((($gfc)) + 176|0);
 $78 = HEAP32[$77>>2]|0;
 $79 = $78 & 3;
 $80 = $76 | $79;
 $81 = $80&255;
 HEAP8[$49>>0] = $81;
 HEAP8[$buffer>>0] = -1;
 $82 = HEAP32[$13>>2]|0;
 $83 = ($82|0)==(1);
 if ($83) {
  $bitrate$0 = 128;
 } else {
  $84 = HEAP32[$7>>2]|0;
  $85 = ($84|0)<(16000);
  $$ = $85 ? 32 : 64;
  $bitrate$0 = $$;
 }
 $86 = ((($gfc)) + 104|0);
 $87 = HEAP32[$86>>2]|0;
 $88 = ($87|0)==(0);
 if ($88) {
  $89 = ((($gfc)) + 120|0);
  $90 = HEAP32[$89>>2]|0;
  $bitrate$1 = $90;
 } else {
  $bitrate$1 = $bitrate$0;
 }
 $91 = ((($gfc)) + 152|0);
 $92 = HEAP32[$91>>2]|0;
 $93 = ($92|0)==(0);
 if ($93) {
  $94 = HEAP32[$7>>2]|0;
  $95 = (_BitrateIndex($bitrate$1,$82,$94)|0);
  $96 = $95 << 4;
  $97 = $96&255;
  $$pre = HEAP32[$13>>2]|0;
  $98 = $$pre;$bbyte$0 = $97;
 } else {
  $98 = $82;$bbyte$0 = 0;
 }
 $99 = ($98|0)==(1);
 $sext2 = $25 << 24;
 $sext = $sext2 >> 24;
 $100 = $sext & -15;
 if ($99) {
  $101 = $100 | 10;
  $102 = $101&255;
  HEAP8[$0>>0] = $102;
  $103 = HEAP8[$27>>0]|0;
  $104 = $103&255;
  $105 = $104 & 13;
  $106 = $bbyte$0 << 24 >> 24;
  $107 = $105 | $106;
  $storemerge$in = $107;
  $storemerge = $storemerge$in&255;
  HEAP8[$27>>0] = $storemerge;
  return;
 } else {
  $108 = $100 | 2;
  $109 = $108&255;
  HEAP8[$0>>0] = $109;
  $110 = HEAP8[$27>>0]|0;
  $111 = $110&255;
  $112 = $111 & 13;
  $113 = $bbyte$0&255;
  $114 = $112 | $113;
  $storemerge$in = $114;
  $storemerge = $storemerge$in&255;
  HEAP8[$27>>0] = $storemerge;
  return;
 }
}
function _getframebits($gfc) {
 $gfc = $gfc|0;
 var $$idx$val = 0, $$idx$val$pre = 0, $$idx1 = 0, $$idx1$val = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $bit_rate$0 = 0;
 var $bit_rate$0$in = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($gfc)) + 16|0);
 $1 = ((($gfc)) + 84744|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0);
 if ($3) {
  $6 = ((($gfc)) + 120|0);
  $$idx$val$pre = HEAP32[$0>>2]|0;
  $$idx$val = $$idx$val$pre;$bit_rate$0$in = $6;
 } else {
  $4 = HEAP32[$0>>2]|0;
  $5 = ((83944 + ($4<<6)|0) + ($2<<2)|0);
  $$idx$val = $4;$bit_rate$0$in = $5;
 }
 $bit_rate$0 = HEAP32[$bit_rate$0$in>>2]|0;
 $7 = ((($gfc)) + 84752|0);
 $8 = HEAP32[$7>>2]|0;
 $$idx1 = ((($gfc)) + 64|0);
 $$idx1$val = HEAP32[$$idx1>>2]|0;
 $9 = ($$idx$val*72000)|0;
 $10 = (($9) + 72000)|0;
 $11 = Math_imul($10, $bit_rate$0)|0;
 $12 = (($11|0) / ($$idx1$val|0))&-1;
 $13 = (($12) + ($8))|0;
 $14 = $13 << 3;
 return ($14|0);
}
function _get_max_frame_buffer_size_by_constraint($cfg,$constraint) {
 $cfg = $cfg|0;
 $constraint = $constraint|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cfg$idx2$val = 0, $cfg$idx3 = 0, $cfg$idx3$val = 0, $max_kbps$0 = 0, $max_kbps$0$in = 0, $maxmp3buf$0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($cfg)) + 104|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)>(320);
 if ($2) {
  $3 = ($constraint|0)==(1);
  $cfg$idx2$val = HEAP32[$cfg>>2]|0;
  if ($3) {
   $cfg$idx3 = ((($cfg)) + 48|0);
   $cfg$idx3$val = HEAP32[$cfg$idx3>>2]|0;
   $4 = ($cfg$idx2$val*72000)|0;
   $5 = (($4) + 72000)|0;
   $6 = Math_imul($5, $1)|0;
   $7 = (($6|0) / ($cfg$idx3$val|0))&-1;
   $8 = $7 << 3;
   $maxmp3buf$0 = $8;
   return ($maxmp3buf$0|0);
  } else {
   $9 = ($cfg$idx2$val*7680)|0;
   $10 = (($9) + 7680)|0;
   $maxmp3buf$0 = $10;
   return ($maxmp3buf$0|0);
  }
 }
 $11 = HEAP32[$cfg>>2]|0;
 if ((($constraint|0) == 2)) {
  $22 = ($11*7680)|0;
  $23 = (($22) + 7680)|0;
  $maxmp3buf$0 = $23;
  return ($maxmp3buf$0|0);
 } else if ((($constraint|0) == 1)) {
  $12 = ((($cfg)) + 48|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = ($13|0)<(16000);
  $15 = (((83944 + ($11<<6)|0)) + 32|0);
  $16 = (((83944 + ($11<<6)|0)) + 56|0);
  $max_kbps$0$in = $14 ? $15 : $16;
  $max_kbps$0 = HEAP32[$max_kbps$0$in>>2]|0;
  $17 = ($11*72000)|0;
  $18 = (($17) + 72000)|0;
  $19 = Math_imul($18, $max_kbps$0)|0;
  $20 = (($19|0) / ($13|0))&-1;
  $21 = $20 << 3;
  $maxmp3buf$0 = $21;
  return ($maxmp3buf$0|0);
 } else {
  $maxmp3buf$0 = 11520;
  return ($maxmp3buf$0|0);
 }
 return (0)|0;
}
function _CRC_writeheader($gfc,$header) {
 $gfc = $gfc|0;
 $header = $header|0;
 var $$$1$i = 0, $$$1$i10 = 0, $$$1$i2 = 0, $$$2$i = 0, $$$2$i11 = 0, $$$2$i3 = 0, $$$3$i = 0, $$$3$i12 = 0, $$$3$i4 = 0, $$$4$i = 0, $$$4$i13 = 0, $$$4$i5 = 0, $$$5$i = 0, $$$5$i14 = 0, $$$5$i6 = 0, $$$6$i = 0, $$$6$i15 = 0, $$$6$i7 = 0, $$$7$i = 0, $$$7$i16 = 0;
 var $$$7$i8 = 0, $$$i = 0, $$$i1 = 0, $$$i9 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0;
 var $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0;
 var $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0;
 var $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0;
 var $98 = 0, $99 = 0, $crc$0$lcssa = 0, $crc$017 = 0, $i$018 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($header)) + 2|0);
 $1 = HEAP8[$0>>0]|0;
 $2 = $1&255;
 $3 = $2 & 128;
 $4 = ($3|0)!=(0);
 $$$i = $4 ? 262140 : 196598;
 $5 = $2 << 10;
 $6 = $$$i ^ $5;
 $7 = $6 & 65536;
 $8 = ($7|0)==(0);
 $9 = $$$i ^ 32773;
 $$$1$i = $8 ? $$$i : $9;
 $10 = $2 << 11;
 $11 = $$$1$i << 1;
 $12 = $11 ^ $10;
 $13 = $12 & 65536;
 $14 = ($13|0)==(0);
 $15 = $11 ^ 32773;
 $$$2$i = $14 ? $11 : $15;
 $16 = $2 << 12;
 $17 = $$$2$i << 1;
 $18 = $17 ^ $16;
 $19 = $18 & 65536;
 $20 = ($19|0)==(0);
 $21 = $17 ^ 32773;
 $$$3$i = $20 ? $17 : $21;
 $22 = $2 << 13;
 $23 = $$$3$i << 1;
 $24 = $23 ^ $22;
 $25 = $24 & 65536;
 $26 = ($25|0)==(0);
 $27 = $23 ^ 32773;
 $$$4$i = $26 ? $23 : $27;
 $28 = $2 << 14;
 $29 = $$$4$i << 1;
 $30 = $29 ^ $28;
 $31 = $30 & 65536;
 $32 = ($31|0)==(0);
 $33 = $29 ^ 32773;
 $$$5$i = $32 ? $29 : $33;
 $34 = $2 << 15;
 $35 = $$$5$i << 1;
 $36 = $35 ^ $34;
 $37 = $36 & 65536;
 $38 = ($37|0)==(0);
 $39 = $35 ^ 32773;
 $$$6$i = $38 ? $35 : $39;
 $40 = $2 << 16;
 $41 = $$$6$i << 1;
 $42 = $41 ^ $40;
 $43 = $42 & 65536;
 $44 = ($43|0)==(0);
 $45 = $41 ^ 32773;
 $$$7$i = $44 ? $41 : $45;
 $46 = ((($header)) + 3|0);
 $47 = HEAP8[$46>>0]|0;
 $48 = $47&255;
 $49 = $48 << 9;
 $50 = $$$7$i << 1;
 $51 = $50 ^ $49;
 $52 = $51 & 65536;
 $53 = ($52|0)==(0);
 $54 = $50 ^ 32773;
 $$$i9 = $53 ? $50 : $54;
 $55 = $48 << 10;
 $56 = $$$i9 << 1;
 $57 = $56 ^ $55;
 $58 = $57 & 65536;
 $59 = ($58|0)==(0);
 $60 = $56 ^ 32773;
 $$$1$i10 = $59 ? $56 : $60;
 $61 = $48 << 11;
 $62 = $$$1$i10 << 1;
 $63 = $62 ^ $61;
 $64 = $63 & 65536;
 $65 = ($64|0)==(0);
 $66 = $62 ^ 32773;
 $$$2$i11 = $65 ? $62 : $66;
 $67 = $48 << 12;
 $68 = $$$2$i11 << 1;
 $69 = $68 ^ $67;
 $70 = $69 & 65536;
 $71 = ($70|0)==(0);
 $72 = $68 ^ 32773;
 $$$3$i12 = $71 ? $68 : $72;
 $73 = $48 << 13;
 $74 = $$$3$i12 << 1;
 $75 = $74 ^ $73;
 $76 = $75 & 65536;
 $77 = ($76|0)==(0);
 $78 = $74 ^ 32773;
 $$$4$i13 = $77 ? $74 : $78;
 $79 = $48 << 14;
 $80 = $$$4$i13 << 1;
 $81 = $80 ^ $79;
 $82 = $81 & 65536;
 $83 = ($82|0)==(0);
 $84 = $80 ^ 32773;
 $$$5$i14 = $83 ? $80 : $84;
 $85 = $48 << 15;
 $86 = $$$5$i14 << 1;
 $87 = $86 ^ $85;
 $88 = $87 & 65536;
 $89 = ($88|0)==(0);
 $90 = $86 ^ 32773;
 $$$6$i15 = $89 ? $86 : $90;
 $91 = $48 << 16;
 $92 = $$$6$i15 << 1;
 $93 = $92 ^ $91;
 $94 = $93 & 65536;
 $95 = ($94|0)==(0);
 $96 = $92 ^ 32773;
 $$$7$i16 = $95 ? $92 : $96;
 $97 = ((($gfc)) + 24|0);
 $98 = HEAP32[$97>>2]|0;
 $99 = ($98|0)>(6);
 if ($99) {
  $crc$017 = $$$7$i16;$i$018 = 6;
 } else {
  $crc$0$lcssa = $$$7$i16;
  $153 = $crc$0$lcssa >>> 8;
  $154 = $153&255;
  $155 = ((($header)) + 4|0);
  HEAP8[$155>>0] = $154;
  $156 = $crc$0$lcssa&255;
  $157 = ((($header)) + 5|0);
  HEAP8[$157>>0] = $156;
  return;
 }
 while(1) {
  $100 = (($header) + ($i$018)|0);
  $101 = HEAP8[$100>>0]|0;
  $102 = $101&255;
  $103 = $102 << 9;
  $104 = $crc$017 << 1;
  $105 = $103 ^ $104;
  $106 = $105 & 65536;
  $107 = ($106|0)==(0);
  $108 = $104 ^ 32773;
  $$$i1 = $107 ? $104 : $108;
  $109 = $102 << 10;
  $110 = $$$i1 << 1;
  $111 = $110 ^ $109;
  $112 = $111 & 65536;
  $113 = ($112|0)==(0);
  $114 = $110 ^ 32773;
  $$$1$i2 = $113 ? $110 : $114;
  $115 = $102 << 11;
  $116 = $$$1$i2 << 1;
  $117 = $116 ^ $115;
  $118 = $117 & 65536;
  $119 = ($118|0)==(0);
  $120 = $116 ^ 32773;
  $$$2$i3 = $119 ? $116 : $120;
  $121 = $102 << 12;
  $122 = $$$2$i3 << 1;
  $123 = $122 ^ $121;
  $124 = $123 & 65536;
  $125 = ($124|0)==(0);
  $126 = $122 ^ 32773;
  $$$3$i4 = $125 ? $122 : $126;
  $127 = $102 << 13;
  $128 = $$$3$i4 << 1;
  $129 = $128 ^ $127;
  $130 = $129 & 65536;
  $131 = ($130|0)==(0);
  $132 = $128 ^ 32773;
  $$$4$i5 = $131 ? $128 : $132;
  $133 = $102 << 14;
  $134 = $$$4$i5 << 1;
  $135 = $134 ^ $133;
  $136 = $135 & 65536;
  $137 = ($136|0)==(0);
  $138 = $134 ^ 32773;
  $$$5$i6 = $137 ? $134 : $138;
  $139 = $102 << 15;
  $140 = $$$5$i6 << 1;
  $141 = $140 ^ $139;
  $142 = $141 & 65536;
  $143 = ($142|0)==(0);
  $144 = $140 ^ 32773;
  $$$6$i7 = $143 ? $140 : $144;
  $145 = $102 << 16;
  $146 = $$$6$i7 << 1;
  $147 = $146 ^ $145;
  $148 = $147 & 65536;
  $149 = ($148|0)==(0);
  $150 = $146 ^ 32773;
  $$$7$i8 = $149 ? $146 : $150;
  $151 = (($i$018) + 1)|0;
  $152 = ($151|0)<($98|0);
  if ($152) {
   $crc$017 = $$$7$i8;$i$018 = $151;
  } else {
   $crc$0$lcssa = $$$7$i8;
   break;
  }
 }
 $153 = $crc$0$lcssa >>> 8;
 $154 = $153&255;
 $155 = ((($header)) + 4|0);
 HEAP8[$155>>0] = $154;
 $156 = $crc$0$lcssa&255;
 $157 = ((($header)) + 5|0);
 HEAP8[$157>>0] = $156;
 return;
}
function _flush_bitstream($gfc) {
 $gfc = $gfc|0;
 var $$$i = 0, $$1$i = 0, $$idx$val$i$i = 0, $$idx$val$pre$i$i = 0, $$idx1$i$i = 0, $$idx1$val$i$i = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0;
 var $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0;
 var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $bit_rate$0$i$i = 0, $bit_rate$0$in$i$i = 0, $flushbits$0$i = 0, $vararg_buffer = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $vararg_buffer = sp;
 $0 = ((($gfc)) + 52132|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($gfc)) + 52128|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = (($3) + -1)|0;
 $5 = ($3|0)==(0);
 $$$i = $5 ? 255 : $4;
 $6 = (((($gfc)) + 39840|0) + (($$$i*48)|0)|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($gfc)) + 292|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = (($7) - ($9))|0;
 $11 = ($10|0)>(-1);
 if ($11) {
  $12 = (1 - ($1))|0;
  $13 = (($$$i) + ($12))|0;
  $14 = ($$$i|0)<($1|0);
  $15 = (($13) + 256)|0;
  $$1$i = $14 ? $15 : $13;
  $16 = $$1$i << 3;
  $17 = ((($gfc)) + 24|0);
  $18 = HEAP32[$17>>2]|0;
  $19 = Math_imul($16, $18)|0;
  $20 = (($10) - ($19))|0;
  $flushbits$0$i = $20;
 } else {
  $flushbits$0$i = $10;
 }
 $21 = ((($gfc)) + 16|0);
 $22 = ((($gfc)) + 84744|0);
 $23 = HEAP32[$22>>2]|0;
 $24 = ($23|0)==(0);
 if ($24) {
  $27 = ((($gfc)) + 120|0);
  $$idx$val$pre$i$i = HEAP32[$21>>2]|0;
  $$idx$val$i$i = $$idx$val$pre$i$i;$bit_rate$0$in$i$i = $27;
 } else {
  $25 = HEAP32[$21>>2]|0;
  $26 = ((83944 + ($25<<6)|0) + ($23<<2)|0);
  $$idx$val$i$i = $25;$bit_rate$0$in$i$i = $26;
 }
 $bit_rate$0$i$i = HEAP32[$bit_rate$0$in$i$i>>2]|0;
 $28 = ((($gfc)) + 84752|0);
 $29 = HEAP32[$28>>2]|0;
 $$idx1$i$i = ((($gfc)) + 64|0);
 $$idx1$val$i$i = HEAP32[$$idx1$i$i>>2]|0;
 $30 = ($$idx$val$i$i*72000)|0;
 $31 = (($30) + 72000)|0;
 $32 = Math_imul($31, $bit_rate$0$i$i)|0;
 $33 = (($32|0) / ($$idx1$val$i$i|0))&-1;
 $34 = (($33) + ($29))|0;
 $35 = $34 << 3;
 $36 = (($35) + ($flushbits$0$i))|0;
 $37 = ($36|0)<(0);
 if ($37) {
  _lame_errorf($gfc,1072,$vararg_buffer);
  STACKTOP = sp;return;
 } else {
  _drain_into_ancillary($gfc,$36);
  $38 = ((($gfc)) + 52140|0);
  HEAP32[$38>>2] = 0;
  $39 = ((($gfc)) + 21312|0);
  HEAP32[$39>>2] = 0;
  STACKTOP = sp;return;
 }
}
function _add_dummy_byte($gfc,$val,$n) {
 $gfc = $gfc|0;
 $val = $val|0;
 $n = $n|0;
 var $$0$$i = 0, $$01$i = 0, $$in = 0, $$pre$i = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $i$01 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($n|0)==(0);
 if ($0) {
  return;
 }
 $1 = $val&255;
 $2 = ((($gfc)) + 300|0);
 $3 = ((($gfc)) + 296|0);
 $4 = ((($gfc)) + 284|0);
 $5 = ((($gfc)) + 292|0);
 $$in = $n;
 while(1) {
  $$01$i = 8;
  while(1) {
   $8 = HEAP32[$2>>2]|0;
   $9 = ($8|0)==(0);
   if ($9) {
    HEAP32[$2>>2] = 8;
    $10 = HEAP32[$3>>2]|0;
    $11 = (($10) + 1)|0;
    HEAP32[$3>>2] = $11;
    $12 = HEAP32[$4>>2]|0;
    $13 = (($12) + ($11)|0);
    HEAP8[$13>>0] = 0;
    $$pre$i = HEAP32[$2>>2]|0;
    $15 = $$pre$i;
   } else {
    $15 = $8;
   }
   $14 = ($$01$i|0)<($15|0);
   $$0$$i = $14 ? $$01$i : $15;
   $16 = (($$01$i) - ($$0$$i))|0;
   $17 = (($15) - ($$0$$i))|0;
   HEAP32[$2>>2] = $17;
   $18 = $1 >>> $16;
   $19 = $18 << $17;
   $20 = HEAP32[$3>>2]|0;
   $21 = HEAP32[$4>>2]|0;
   $22 = (($21) + ($20)|0);
   $23 = HEAP8[$22>>0]|0;
   $24 = $23&255;
   $25 = $19 | $24;
   $26 = $25&255;
   HEAP8[$22>>0] = $26;
   $27 = HEAP32[$5>>2]|0;
   $28 = (($27) + ($$0$$i))|0;
   HEAP32[$5>>2] = $28;
   $29 = ($16|0)>(0);
   if ($29) {
    $$01$i = $16;
   } else {
    $i$01 = 0;
    break;
   }
  }
  while(1) {
   $30 = (((($gfc)) + 39840|0) + (($i$01*48)|0)|0);
   $31 = HEAP32[$30>>2]|0;
   $32 = (($31) + 8)|0;
   HEAP32[$30>>2] = $32;
   $33 = (($i$01) + 1)|0;
   $exitcond = ($33|0)==(256);
   if ($exitcond) {
    break;
   } else {
    $i$01 = $33;
   }
  }
  $6 = (($$in) + -1)|0;
  $7 = ($6|0)==(0);
  if ($7) {
   break;
  } else {
   $$in = $6;
  }
 }
 return;
}
function _format_bitstream($gfc) {
 $gfc = $gfc|0;
 var $$$i = 0, $$$i$i = 0, $$$i26$i = 0, $$$i7 = 0, $$$i8$i = 0, $$$i9$i = 0, $$0$$i$i = 0, $$0$$i$us$i = 0, $$0$$i107$i = 0, $$0$$i11$i = 0, $$0$$i115$i = 0, $$0$$i123$i = 0, $$0$$i131$i = 0, $$0$$i139$i = 0, $$0$$i14$i = 0, $$0$$i147$i = 0, $$0$$i155$i = 0, $$0$$i163$i = 0, $$0$$i171$i = 0, $$0$$i179$i = 0;
 var $$0$$i189$i = 0, $$0$$i19$i = 0, $$0$$i19$i9 = 0, $$0$$i199$i = 0, $$0$$i209$i = 0, $$0$$i219$i = 0, $$0$$i229$i = 0, $$0$$i239$i = 0, $$0$$i24$i = 0, $$0$$i249$i = 0, $$0$$i259$i = 0, $$0$$i269$i = 0, $$0$$i27$i = 0, $$0$$i279$i = 0, $$0$$i289$i = 0, $$0$$i299$i = 0, $$0$$i3$i = 0, $$0$$i30$us$i = 0, $$0$$i309$i = 0, $$0$$i319$i = 0;
 var $$0$$i329$i = 0, $$0$$i339$i = 0, $$0$$i349$i = 0, $$0$$i35$i = 0, $$0$$i359$i = 0, $$0$$i369$i = 0, $$0$$i379$i = 0, $$0$$i389$i = 0, $$0$$i399$1$i = 0, $$0$$i399$2$i = 0, $$0$$i399$3$i = 0, $$0$$i399$i = 0, $$0$$i409$i = 0, $$0$$i419$i = 0, $$0$$i429$i = 0, $$0$$i43$i = 0, $$0$$i439$i = 0, $$0$$i449$i = 0, $$0$$i459$i = 0, $$0$$i469$i = 0;
 var $$0$$i479$i = 0, $$0$$i489$i = 0, $$0$$i499$i = 0, $$0$$i509$i = 0, $$0$$i51$i = 0, $$0$$i519$i = 0, $$0$$i529$i = 0, $$0$$i539$i = 0, $$0$$i549$i = 0, $$0$$i559$i = 0, $$0$$i59$i = 0, $$0$$i6$i = 0, $$0$$i67$i = 0, $$0$$i75$i = 0, $$0$$i83$i = 0, $$0$$i91$i = 0, $$0$$i99$i = 0, $$01$i$us$i = 0, $$01$i12$i = 0, $$01$i17$i = 0;
 var $$01$i22$i = 0, $$01$i28$us$i = 0, $$01$i4$i = 0, $$02$i$i = 0, $$02$i1$i = 0, $$02$i105$i = 0, $$02$i113$i = 0, $$02$i121$i = 0, $$02$i129$i = 0, $$02$i137$i = 0, $$02$i145$i = 0, $$02$i153$i = 0, $$02$i161$i = 0, $$02$i169$i = 0, $$02$i17$i = 0, $$02$i177$i = 0, $$02$i187$i = 0, $$02$i197$i = 0, $$02$i207$i = 0, $$02$i217$i = 0;
 var $$02$i227$i = 0, $$02$i237$i = 0, $$02$i247$i = 0, $$02$i25$i = 0, $$02$i257$i = 0, $$02$i267$i = 0, $$02$i277$i = 0, $$02$i287$i = 0, $$02$i297$i = 0, $$02$i307$i = 0, $$02$i317$i = 0, $$02$i327$i = 0, $$02$i33$i = 0, $$02$i337$i = 0, $$02$i347$i = 0, $$02$i357$i = 0, $$02$i367$i = 0, $$02$i377$i = 0, $$02$i387$i = 0, $$02$i397$1$i = 0;
 var $$02$i397$2$i = 0, $$02$i397$3$i = 0, $$02$i397$i = 0, $$02$i407$i = 0, $$02$i41$i = 0, $$02$i417$i = 0, $$02$i427$i = 0, $$02$i437$i = 0, $$02$i447$i = 0, $$02$i457$i = 0, $$02$i467$i = 0, $$02$i477$i = 0, $$02$i487$i = 0, $$02$i49$i = 0, $$02$i497$i = 0, $$02$i507$i = 0, $$02$i517$i = 0, $$02$i527$i = 0, $$02$i537$i = 0, $$02$i547$i = 0;
 var $$02$i557$i = 0, $$02$i57$i = 0, $$02$i65$i = 0, $$02$i73$i = 0, $$02$i81$i = 0, $$02$i89$i = 0, $$02$i9$i = 0, $$02$i97$i = 0, $$1$i = 0, $$1$i10 = 0, $$2$us$i = 0, $$idx$val$i = 0, $$idx$val$i$i = 0, $$idx$val$pre$i = 0, $$idx$val$pre$i$i = 0, $$idx1$i = 0, $$idx1$val$i = 0, $$idx1$val$i$i = 0, $$lcssa401 = 0, $$lcssa402 = 0;
 var $$lcssa404 = 0, $$lcssa405 = 0, $$lcssa406 = 0, $$lcssa407 = 0, $$lcssa408 = 0, $$lcssa409 = 0, $$lcssa410 = 0, $$lcssa411 = 0, $$lcssa412 = 0, $$lcssa413 = 0, $$lcssa414 = 0, $$lcssa415 = 0, $$lcssa416 = 0, $$lcssa417 = 0, $$lcssa418 = 0, $$lcssa419 = 0, $$lcssa420 = 0, $$lcssa421 = 0, $$lcssa422 = 0, $$lcssa423 = 0;
 var $$lcssa424 = 0, $$lcssa427 = 0, $$lcssa428 = 0, $$lcssa429 = 0, $$lcssa430 = 0, $$lcssa432 = 0, $$lcssa433 = 0, $$lcssa434 = 0, $$lcssa435 = 0, $$lcssa436 = 0, $$lcssa437 = 0, $$lcssa438 = 0, $$lcssa439 = 0, $$lcssa440 = 0, $$lcssa441 = 0, $$lcssa442 = 0, $$lcssa443 = 0, $$lcssa444 = 0, $$lcssa445 = 0, $$lcssa446 = 0;
 var $$lcssa447 = 0, $$lcssa448 = 0, $$lcssa449 = 0, $$lcssa450 = 0, $$lcssa451 = 0, $$lcssa452 = 0, $$lcssa453 = 0, $$lcssa454 = 0, $$lcssa455 = 0, $$lcssa456 = 0, $$lcssa457 = 0, $$lcssa458 = 0, $$lcssa459 = 0, $$lcssa460 = 0, $$lcssa461 = 0, $$lcssa462 = 0, $$lcssa463 = 0, $$lcssa464 = 0, $$lcssa465 = 0, $$lcssa466 = 0;
 var $$lcssa467 = 0, $$lcssa468 = 0, $$lcssa469 = 0, $$lcssa470 = 0, $$lcssa471 = 0, $$phi$trans$insert705$i = 0, $$phi$trans$insert708$i = 0, $$phi$trans$insert711$i = 0, $$phi$trans$insert714$i = 0, $$phi$trans$insert717$i = 0, $$phi$trans$insert720$i = 0, $$phi$trans$insert723$i = 0, $$phi$trans$insert726$i = 0, $$phi$trans$insert729$i = 0, $$phi$trans$insert732$i = 0, $$phi$trans$insert736$i = 0, $$pn$i = 0, $$pn100$i = 0, $$pre = 0, $$pre$i = 0;
 var $$pre$i$i = 0, $$pre$i$i$lcssa = 0, $$pre$i$us$i = 0, $$pre$i1 = 0, $$pre$i101$i = 0, $$pre$i101$i$lcssa = 0, $$pre$i109$i = 0, $$pre$i109$i$lcssa = 0, $$pre$i117$i = 0, $$pre$i117$i$lcssa = 0, $$pre$i125$i = 0, $$pre$i125$i$lcssa = 0, $$pre$i13$i = 0, $$pre$i13$i$lcssa = 0, $$pre$i13$i8 = 0, $$pre$i133$i = 0, $$pre$i133$i$lcssa = 0, $$pre$i141$i = 0, $$pre$i141$i$lcssa = 0, $$pre$i149$i = 0;
 var $$pre$i149$i$lcssa = 0, $$pre$i157$i = 0, $$pre$i157$i$lcssa = 0, $$pre$i165$i = 0, $$pre$i165$i$lcssa = 0, $$pre$i173$i = 0, $$pre$i173$i$lcssa = 0, $$pre$i18$i = 0, $$pre$i181$i = 0, $$pre$i181$i$lcssa = 0, $$pre$i191$i = 0, $$pre$i191$i$lcssa = 0, $$pre$i201$i = 0, $$pre$i201$i$lcssa = 0, $$pre$i21$i = 0, $$pre$i21$i$lcssa = 0, $$pre$i211$i = 0, $$pre$i211$i$lcssa = 0, $$pre$i221$i = 0, $$pre$i221$i$lcssa = 0;
 var $$pre$i23$i = 0, $$pre$i231$i = 0, $$pre$i231$i$lcssa = 0, $$pre$i241$i = 0, $$pre$i241$i$lcssa = 0, $$pre$i251$i = 0, $$pre$i251$i$lcssa = 0, $$pre$i261$i = 0, $$pre$i261$i$lcssa = 0, $$pre$i281$i = 0, $$pre$i281$i$lcssa = 0, $$pre$i29$i = 0, $$pre$i29$i$lcssa = 0, $$pre$i29$us$i = 0, $$pre$i291$i = 0, $$pre$i291$i$lcssa = 0, $$pre$i301$i = 0, $$pre$i301$i$lcssa = 0, $$pre$i311$i = 0, $$pre$i311$i$lcssa = 0;
 var $$pre$i321$i = 0, $$pre$i321$i$lcssa = 0, $$pre$i331$i = 0, $$pre$i331$i$lcssa = 0, $$pre$i341$i = 0, $$pre$i341$i$lcssa = 0, $$pre$i351$i = 0, $$pre$i351$i$lcssa = 0, $$pre$i361$i = 0, $$pre$i361$i$lcssa = 0, $$pre$i37$i = 0, $$pre$i37$i$lcssa = 0, $$pre$i371$i = 0, $$pre$i371$i$lcssa = 0, $$pre$i381$i = 0, $$pre$i381$i$lcssa = 0, $$pre$i391$i = 0, $$pre$i391$i$lcssa = 0, $$pre$i401$1$i = 0, $$pre$i401$1$i$lcssa = 0;
 var $$pre$i401$2$i = 0, $$pre$i401$2$i$lcssa = 0, $$pre$i401$3$i = 0, $$pre$i401$3$i$lcssa = 0, $$pre$i401$i = 0, $$pre$i401$i$lcssa = 0, $$pre$i411$i = 0, $$pre$i411$i$lcssa = 0, $$pre$i421$i = 0, $$pre$i421$i$lcssa = 0, $$pre$i431$i = 0, $$pre$i431$i$lcssa = 0, $$pre$i45$i = 0, $$pre$i45$i$lcssa = 0, $$pre$i451$i = 0, $$pre$i451$i$lcssa = 0, $$pre$i461$i = 0, $$pre$i461$i$lcssa = 0, $$pre$i471$i = 0, $$pre$i471$i$lcssa = 0;
 var $$pre$i481$i = 0, $$pre$i481$i$lcssa = 0, $$pre$i491$i = 0, $$pre$i491$i$lcssa = 0, $$pre$i5$i = 0, $$pre$i5$i$lcssa = 0, $$pre$i5$i4 = 0, $$pre$i501$i = 0, $$pre$i501$i$lcssa = 0, $$pre$i511$i = 0, $$pre$i511$i$lcssa = 0, $$pre$i521$i = 0, $$pre$i521$i$lcssa = 0, $$pre$i53$i = 0, $$pre$i53$i$lcssa = 0, $$pre$i531$i = 0, $$pre$i531$i$lcssa = 0, $$pre$i541$i = 0, $$pre$i541$i$lcssa = 0, $$pre$i551$i = 0;
 var $$pre$i551$i$lcssa = 0, $$pre$i561$i = 0, $$pre$i561$i$lcssa = 0, $$pre$i61$i = 0, $$pre$i61$i$lcssa = 0, $$pre$i77$i = 0, $$pre$i77$i$lcssa = 0, $$pre$i85$i = 0, $$pre$i85$i$lcssa = 0, $$pre$i93$i = 0, $$pre$i93$i$lcssa = 0, $$pre$phiZ2D = 0, $$pre167 = 0, $$pre704$i = 0, $$pre706$i = 0, $$pre707$i = 0, $$pre709$i = 0, $$pre710$i = 0, $$pre712$i = 0, $$pre713$i = 0;
 var $$pre715$i = 0, $$pre716$i = 0, $$pre718$i = 0, $$pre719$i = 0, $$pre721$i = 0, $$pre722$i = 0, $$pre724$i = 0, $$pre725$i = 0, $$pre727$i = 0, $$pre728$i = 0, $$pre730$i = 0, $$pre731$i = 0, $$pre733$i = 0, $$pre734$i = 0, $$pre735$i = 0, $$pre737$i = 0, $$pre96$pre$i = 0, $$pre97$i = 0, $$pre97$pre$i = 0, $0 = 0;
 var $1 = 0, $10 = 0, $100 = 0, $1000 = 0, $1001 = 0, $1002 = 0, $1003 = 0, $1004 = 0, $1005 = 0, $1006 = 0, $1007 = 0, $1008 = 0, $1009 = 0, $101 = 0, $1010 = 0, $1011 = 0, $1012 = 0, $1013 = 0, $1014 = 0, $1015 = 0;
 var $1016 = 0, $1017 = 0, $1018 = 0, $1019 = 0, $102 = 0, $1020 = 0, $1021 = 0, $1022 = 0, $1023 = 0, $1024 = 0, $1025 = 0, $1026 = 0, $1027 = 0, $1028 = 0, $1029 = 0, $103 = 0, $1030 = 0, $1031 = 0, $1032 = 0, $1033 = 0;
 var $1034 = 0, $1035 = 0, $1036 = 0, $1037 = 0, $1038 = 0, $1039 = 0, $104 = 0, $1040 = 0, $1041 = 0, $1042 = 0, $1043 = 0, $1044 = 0, $1045 = 0, $1046 = 0, $1047 = 0, $1048 = 0, $1049 = 0, $105 = 0, $1050 = 0, $1051 = 0;
 var $1052 = 0, $1053 = 0, $1054 = 0, $1055 = 0, $1056 = 0, $1057 = 0, $1058 = 0, $1059 = 0, $106 = 0, $1060 = 0, $1061 = 0, $1062 = 0, $1063 = 0, $1064 = 0, $1065 = 0, $1066 = 0, $1067 = 0, $1068 = 0, $1069 = 0, $107 = 0;
 var $1070 = 0, $1071 = 0, $1072 = 0, $1073 = 0, $1074 = 0, $1075 = 0, $1076 = 0, $1077 = 0, $1078 = 0, $1079 = 0, $108 = 0, $1080 = 0, $1081 = 0, $1082 = 0, $1083 = 0, $1084 = 0, $1085 = 0, $1086 = 0, $1087 = 0, $1088 = 0;
 var $1089 = 0, $109 = 0, $1090 = 0, $1091 = 0, $1092 = 0, $1093 = 0, $1094 = 0, $1095 = 0, $1096 = 0, $1097 = 0, $1098 = 0, $1099 = 0, $11 = 0, $110 = 0, $1100 = 0, $1101 = 0, $1102 = 0, $1103 = 0, $1104 = 0, $1105 = 0;
 var $1106 = 0, $1107 = 0, $1108 = 0, $1109 = 0, $111 = 0, $1110 = 0, $1111 = 0, $1112 = 0, $1113 = 0, $1114 = 0, $1115 = 0, $1116 = 0, $1117 = 0, $1118 = 0, $1119 = 0, $112 = 0, $1120 = 0, $1121 = 0, $1122 = 0, $1123 = 0;
 var $1124 = 0, $1125 = 0, $1126 = 0, $1127 = 0, $1128 = 0, $1129 = 0, $113 = 0, $1130 = 0, $1131 = 0, $1132 = 0, $1133 = 0, $1134 = 0, $1135 = 0, $1136 = 0, $1137 = 0, $1138 = 0, $1139 = 0, $114 = 0, $1140 = 0, $1141 = 0;
 var $1142 = 0, $1143 = 0, $1144 = 0, $1145 = 0, $1146 = 0, $1147 = 0, $1148 = 0, $1149 = 0, $115 = 0, $1150 = 0, $1151 = 0, $1152 = 0, $1153 = 0, $1154 = 0, $1155 = 0, $1156 = 0, $1157 = 0, $1158 = 0, $1159 = 0, $116 = 0;
 var $1160 = 0, $1161 = 0, $1162 = 0, $1163 = 0, $1164 = 0, $1165 = 0, $1166 = 0, $1167 = 0, $1168 = 0, $1169 = 0, $117 = 0, $1170 = 0, $1171 = 0, $1172 = 0, $1173 = 0, $1174 = 0, $1175 = 0, $1176 = 0, $1177 = 0, $1178 = 0;
 var $1179 = 0, $118 = 0, $1180 = 0, $1181 = 0, $1182 = 0, $1183 = 0, $1184 = 0, $1185 = 0, $1186 = 0, $1187 = 0, $1188 = 0, $1189 = 0, $119 = 0, $1190 = 0, $1191 = 0, $1192 = 0, $1193 = 0, $1194 = 0, $1195 = 0, $1196 = 0;
 var $1197 = 0, $1198 = 0, $1199 = 0, $12 = 0, $120 = 0, $1200 = 0, $1201 = 0, $1202 = 0, $1203 = 0, $1204 = 0, $1205 = 0, $1206 = 0, $1207 = 0, $1208 = 0, $1209 = 0, $121 = 0, $1210 = 0, $1211 = 0, $1212 = 0, $1213 = 0;
 var $1214 = 0, $1215 = 0, $1216 = 0, $1217 = 0, $1218 = 0, $1219 = 0, $122 = 0, $1220 = 0, $1221 = 0, $1222 = 0, $1223 = 0, $1224 = 0, $1225 = 0, $1226 = 0, $1227 = 0, $1228 = 0, $1229 = 0, $123 = 0, $1230 = 0, $1231 = 0;
 var $1232 = 0, $1233 = 0, $1234 = 0, $1235 = 0, $1236 = 0, $1237 = 0, $1238 = 0, $1239 = 0, $124 = 0, $1240 = 0, $1241 = 0, $1242 = 0, $1243 = 0, $1244 = 0, $1245 = 0, $1246 = 0, $1247 = 0, $1248 = 0, $1249 = 0, $125 = 0;
 var $1250 = 0, $1251 = 0, $1252 = 0, $1253 = 0, $1254 = 0, $1255 = 0, $1256 = 0, $1257 = 0, $1258 = 0, $1259 = 0, $126 = 0, $1260 = 0, $1261 = 0, $1262 = 0, $1263 = 0, $1264 = 0, $1265 = 0, $1266 = 0, $1267 = 0, $1268 = 0;
 var $1269 = 0, $127 = 0, $1270 = 0, $1271 = 0, $1272 = 0, $1273 = 0, $1274 = 0, $1275 = 0, $1276 = 0, $1277 = 0, $1278 = 0, $1279 = 0, $128 = 0, $1280 = 0, $1281 = 0, $1282 = 0, $1283 = 0, $1284 = 0, $1285 = 0, $1286 = 0;
 var $1287 = 0, $1288 = 0, $1289 = 0, $129 = 0, $1290 = 0, $1291 = 0, $1292 = 0, $1293 = 0, $1294 = 0, $1295 = 0, $1296 = 0, $1297 = 0, $1298 = 0, $1299 = 0, $13 = 0, $130 = 0, $1300 = 0, $1301 = 0, $1302 = 0, $1303 = 0;
 var $1304 = 0, $1305 = 0, $1306 = 0, $1307 = 0, $1308 = 0, $1309 = 0, $131 = 0, $1310 = 0, $1311 = 0, $1312 = 0, $1313 = 0, $1314 = 0, $1315 = 0, $1316 = 0, $1317 = 0, $1318 = 0, $1319 = 0, $132 = 0, $1320 = 0, $1321 = 0;
 var $1322 = 0, $1323 = 0, $1324 = 0, $1325 = 0, $1326 = 0, $1327 = 0, $1328 = 0, $1329 = 0, $133 = 0, $1330 = 0, $1331 = 0, $1332 = 0, $1333 = 0, $1334 = 0, $1335 = 0, $1336 = 0, $1337 = 0, $1338 = 0, $1339 = 0, $134 = 0;
 var $1340 = 0, $1341 = 0, $1342 = 0, $1343 = 0, $1344 = 0, $1345 = 0, $1346 = 0, $1347 = 0, $1348 = 0, $1349 = 0, $135 = 0, $1350 = 0, $1351 = 0, $1352 = 0, $1353 = 0, $1354 = 0, $1355 = 0, $1356 = 0, $1357 = 0, $1358 = 0;
 var $1359 = 0, $136 = 0, $1360 = 0, $1361 = 0, $1362 = 0, $1363 = 0, $1364 = 0, $1365 = 0, $1366 = 0, $1367 = 0, $1368 = 0, $1369 = 0, $137 = 0, $1370 = 0, $1371 = 0, $1372 = 0, $1373 = 0, $1374 = 0, $1375 = 0, $1376 = 0;
 var $1377 = 0, $1378 = 0, $1379 = 0, $138 = 0, $1380 = 0, $1381 = 0, $1382 = 0, $1383 = 0, $1384 = 0, $1385 = 0, $1386 = 0, $1387 = 0, $1388 = 0, $1389 = 0, $139 = 0, $1390 = 0, $1391 = 0, $1392 = 0, $1393 = 0, $1394 = 0;
 var $1395 = 0, $1396 = 0, $1397 = 0, $1398 = 0, $1399 = 0, $14 = 0, $140 = 0, $1400 = 0, $1401 = 0, $1402 = 0, $1403 = 0, $1404 = 0, $1405 = 0, $1406 = 0, $1407 = 0, $1408 = 0, $1409 = 0, $141 = 0, $1410 = 0, $1411 = 0;
 var $1412 = 0, $1413 = 0, $1414 = 0, $1415 = 0, $1416 = 0, $1417 = 0, $1418 = 0, $1419 = 0, $142 = 0, $1420 = 0, $1421 = 0, $1422 = 0, $1423 = 0, $1424 = 0, $1425 = 0, $1426 = 0, $1427 = 0, $1428 = 0, $1429 = 0, $143 = 0;
 var $1430 = 0, $1431 = 0, $1432 = 0, $1433 = 0, $1434 = 0, $1435 = 0, $1436 = 0, $1437 = 0, $1438 = 0, $1439 = 0, $144 = 0, $1440 = 0, $1441 = 0, $1442 = 0, $1443 = 0, $1444 = 0, $1445 = 0, $1446 = 0, $1447 = 0, $1448 = 0;
 var $1449 = 0, $145 = 0, $1450 = 0, $1451 = 0, $1452 = 0, $1453 = 0, $1454 = 0, $1455 = 0, $1456 = 0, $1457 = 0, $1458 = 0, $1459 = 0, $146 = 0, $1460 = 0, $1461 = 0, $1462 = 0, $1463 = 0, $1464 = 0, $1465 = 0, $1466 = 0;
 var $1467 = 0, $1468 = 0, $1469 = 0, $147 = 0, $1470 = 0, $1471 = 0, $1472 = 0, $1473 = 0, $1474 = 0, $1475 = 0, $1476 = 0, $1477 = 0, $1478 = 0, $1479 = 0, $148 = 0, $1480 = 0, $1481 = 0, $1482 = 0, $1483 = 0, $1484 = 0;
 var $1485 = 0, $1486 = 0, $1487 = 0, $1488 = 0, $1489 = 0, $149 = 0, $1490 = 0, $1491 = 0, $1492 = 0, $1493 = 0, $1494 = 0, $1495 = 0, $1496 = 0, $1497 = 0, $1498 = 0, $1499 = 0, $15 = 0, $150 = 0, $1500 = 0, $1501 = 0;
 var $1502 = 0, $1503 = 0, $1504 = 0, $1505 = 0, $1506 = 0, $1507 = 0, $1508 = 0, $1509 = 0, $151 = 0, $1510 = 0, $1511 = 0, $1512 = 0, $1513 = 0, $1514 = 0, $1515 = 0, $1516 = 0, $1517 = 0, $1518 = 0, $1519 = 0, $152 = 0;
 var $1520 = 0, $1521 = 0, $1522 = 0, $1523 = 0, $1524 = 0, $1525 = 0, $1526 = 0, $1527 = 0, $1528 = 0, $1529 = 0, $153 = 0, $1530 = 0, $1531 = 0, $1532 = 0, $1533 = 0, $1534 = 0, $1535 = 0, $1536 = 0, $1537 = 0, $1538 = 0;
 var $1539 = 0, $154 = 0, $1540 = 0, $1541 = 0, $1542 = 0, $1543 = 0, $1544 = 0, $1545 = 0, $1546 = 0, $1547 = 0, $1548 = 0, $1549 = 0, $155 = 0, $1550 = 0, $1551 = 0, $1552 = 0, $1553 = 0, $1554 = 0, $1555 = 0, $1556 = 0;
 var $1557 = 0, $1558 = 0, $1559 = 0, $156 = 0, $1560 = 0, $1561 = 0, $1562 = 0, $1563 = 0, $1564 = 0, $1565 = 0, $1566 = 0, $1567 = 0, $1568 = 0, $1569 = 0, $157 = 0, $1570 = 0, $1571 = 0, $1572 = 0, $1573 = 0, $1574 = 0;
 var $1575 = 0, $1576 = 0, $1577 = 0, $1578 = 0, $1579 = 0, $158 = 0, $1580 = 0, $1581 = 0, $1582 = 0, $1583 = 0, $1584 = 0, $1585 = 0, $1586 = 0, $1587 = 0, $1588 = 0, $1589 = 0, $159 = 0, $1590 = 0, $1591 = 0, $1592 = 0;
 var $1593 = 0, $1594 = 0, $1595 = 0, $1596 = 0, $1597 = 0, $1598 = 0, $1599 = 0, $16 = 0, $160 = 0, $1600 = 0, $1601 = 0, $1602 = 0, $1603 = 0, $1604 = 0, $1605 = 0, $1606 = 0, $1607 = 0, $1608 = 0, $1609 = 0, $161 = 0;
 var $1610 = 0, $1611 = 0, $1612 = 0, $1613 = 0, $1614 = 0, $1615 = 0, $1616 = 0, $1617 = 0, $1618 = 0, $1619 = 0, $162 = 0, $1620 = 0, $1621 = 0, $1622 = 0, $1623 = 0, $1624 = 0, $1625 = 0, $1626 = 0, $1627 = 0, $1628 = 0;
 var $1629 = 0, $163 = 0, $1630 = 0, $1631 = 0, $1632 = 0, $1633 = 0, $1634 = 0, $1635 = 0, $1636 = 0, $1637 = 0, $1638 = 0, $1639 = 0, $164 = 0, $1640 = 0, $1641 = 0, $1642 = 0, $1643 = 0, $1644 = 0, $1645 = 0, $1646 = 0;
 var $1647 = 0, $1648 = 0, $1649 = 0, $165 = 0, $1650 = 0, $1651 = 0, $1652 = 0, $1653 = 0, $1654 = 0, $1655 = 0, $1656 = 0, $1657 = 0, $1658 = 0, $1659 = 0, $166 = 0, $1660 = 0, $1661 = 0, $1662 = 0, $1663 = 0, $1664 = 0;
 var $1665 = 0, $1666 = 0, $1667 = 0, $1668 = 0, $1669 = 0, $167 = 0, $1670 = 0, $1671 = 0, $1672 = 0, $1673 = 0, $1674 = 0, $1675 = 0, $1676 = 0, $1677 = 0, $1678 = 0, $1679 = 0, $168 = 0, $1680 = 0, $1681 = 0, $1682 = 0;
 var $1683 = 0, $1684 = 0, $1685 = 0, $1686 = 0, $1687 = 0, $1688 = 0, $1689 = 0, $169 = 0, $1690 = 0, $1691 = 0, $1692 = 0, $1693 = 0, $1694 = 0, $1695 = 0, $1696 = 0, $1697 = 0, $1698 = 0, $1699 = 0, $17 = 0, $170 = 0;
 var $1700 = 0, $1701 = 0, $1702 = 0, $1703 = 0, $1704 = 0, $1705 = 0, $1706 = 0, $1707 = 0, $1708 = 0, $1709 = 0, $171 = 0, $1710 = 0, $1711 = 0, $1712 = 0, $1713 = 0, $1714 = 0, $1715 = 0, $1716 = 0, $1717 = 0, $1718 = 0;
 var $1719 = 0, $172 = 0, $1720 = 0, $1721 = 0, $1722 = 0, $1723 = 0, $1724 = 0, $1725 = 0, $1726 = 0, $1727 = 0, $1728 = 0, $1729 = 0, $173 = 0, $1730 = 0, $1731 = 0, $1732 = 0, $1733 = 0, $1734 = 0, $1735 = 0, $1736 = 0;
 var $1737 = 0, $1738 = 0, $1739 = 0, $174 = 0, $1740 = 0, $1741 = 0, $1742 = 0, $1743 = 0, $1744 = 0, $1745 = 0, $1746 = 0, $1747 = 0, $1748 = 0, $1749 = 0, $175 = 0, $1750 = 0, $1751 = 0, $1752 = 0, $1753 = 0, $1754 = 0;
 var $1755 = 0, $1756 = 0, $1757 = 0, $1758 = 0, $1759 = 0, $176 = 0, $1760 = 0, $1761 = 0, $1762 = 0, $1763 = 0, $1764 = 0, $1765 = 0, $1766 = 0, $1767 = 0, $1768 = 0, $1769 = 0, $177 = 0, $1770 = 0, $1771 = 0, $1772 = 0;
 var $1773 = 0, $1774 = 0, $1775 = 0, $1776 = 0, $1777 = 0, $1778 = 0, $1779 = 0, $178 = 0, $1780 = 0, $1781 = 0, $1782 = 0, $1783 = 0, $1784 = 0, $1785 = 0, $1786 = 0, $1787 = 0, $1788 = 0, $1789 = 0, $179 = 0, $1790 = 0;
 var $1791 = 0, $1792 = 0, $1793 = 0, $1794 = 0, $1795 = 0, $1796 = 0, $1797 = 0, $1798 = 0, $1799 = 0, $18 = 0, $180 = 0, $1800 = 0, $1801 = 0, $1802 = 0, $1803 = 0, $1804 = 0, $1805 = 0, $1806 = 0, $1807 = 0, $1808 = 0;
 var $1809 = 0, $181 = 0, $1810 = 0, $1811 = 0, $1812 = 0, $1813 = 0, $1814 = 0, $1815 = 0, $1816 = 0, $1817 = 0, $1818 = 0, $1819 = 0, $182 = 0, $1820 = 0, $1821 = 0, $1822 = 0, $1823 = 0, $1824 = 0, $1825 = 0, $183 = 0;
 var $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0;
 var $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0;
 var $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0;
 var $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0;
 var $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0;
 var $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0;
 var $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0, $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0;
 var $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0, $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0;
 var $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0, $332 = 0, $333 = 0, $334 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0;
 var $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0, $350 = 0, $351 = 0, $352 = 0, $353 = 0, $354 = 0, $355 = 0, $356 = 0, $357 = 0, $358 = 0, $359 = 0, $36 = 0, $360 = 0, $361 = 0, $362 = 0, $363 = 0;
 var $364 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0, $369 = 0, $37 = 0, $370 = 0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $379 = 0, $38 = 0, $380 = 0, $381 = 0;
 var $382 = 0, $383 = 0, $384 = 0, $385 = 0, $386 = 0, $387 = 0, $388 = 0, $389 = 0, $39 = 0, $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $396 = 0, $397 = 0, $398 = 0, $399 = 0, $4 = 0;
 var $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0, $404 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0, $409 = 0, $41 = 0, $410 = 0, $411 = 0, $412 = 0, $413 = 0, $414 = 0, $415 = 0, $416 = 0, $417 = 0;
 var $418 = 0, $419 = 0, $42 = 0, $420 = 0, $421 = 0, $422 = 0, $423 = 0, $424 = 0, $425 = 0, $426 = 0, $427 = 0, $428 = 0, $429 = 0, $43 = 0, $430 = 0, $431 = 0, $432 = 0, $433 = 0, $434 = 0, $435 = 0;
 var $436 = 0, $437 = 0, $438 = 0, $439 = 0, $44 = 0, $440 = 0, $441 = 0, $442 = 0, $443 = 0, $444 = 0, $445 = 0, $446 = 0, $447 = 0, $448 = 0, $449 = 0, $45 = 0, $450 = 0, $451 = 0, $452 = 0, $453 = 0;
 var $454 = 0, $455 = 0, $456 = 0, $457 = 0, $458 = 0, $459 = 0, $46 = 0, $460 = 0, $461 = 0, $462 = 0, $463 = 0, $464 = 0, $465 = 0, $466 = 0, $467 = 0, $468 = 0, $469 = 0, $47 = 0, $470 = 0, $471 = 0;
 var $472 = 0, $473 = 0, $474 = 0, $475 = 0, $476 = 0, $477 = 0, $478 = 0, $479 = 0, $48 = 0, $480 = 0, $481 = 0, $482 = 0, $483 = 0, $484 = 0, $485 = 0, $486 = 0, $487 = 0, $488 = 0, $489 = 0, $49 = 0;
 var $490 = 0, $491 = 0, $492 = 0, $493 = 0, $494 = 0, $495 = 0, $496 = 0, $497 = 0, $498 = 0, $499 = 0, $5 = 0, $50 = 0, $500 = 0, $501 = 0, $502 = 0, $503 = 0, $504 = 0, $505 = 0, $506 = 0, $507 = 0;
 var $508 = 0, $509 = 0, $51 = 0, $510 = 0, $511 = 0, $512 = 0, $513 = 0, $514 = 0, $515 = 0, $516 = 0, $517 = 0, $518 = 0, $519 = 0, $52 = 0, $520 = 0, $521 = 0, $522 = 0, $523 = 0, $524 = 0, $525 = 0;
 var $526 = 0, $527 = 0, $528 = 0, $529 = 0, $53 = 0, $530 = 0, $531 = 0, $532 = 0, $533 = 0, $534 = 0, $535 = 0, $536 = 0, $537 = 0, $538 = 0, $539 = 0, $54 = 0, $540 = 0, $541 = 0, $542 = 0, $543 = 0;
 var $544 = 0, $545 = 0, $546 = 0, $547 = 0, $548 = 0, $549 = 0, $55 = 0, $550 = 0, $551 = 0, $552 = 0, $553 = 0, $554 = 0, $555 = 0, $556 = 0, $557 = 0, $558 = 0, $559 = 0, $56 = 0, $560 = 0, $561 = 0;
 var $562 = 0, $563 = 0, $564 = 0, $565 = 0, $566 = 0, $567 = 0, $568 = 0, $569 = 0, $57 = 0, $570 = 0, $571 = 0, $572 = 0, $573 = 0, $574 = 0, $575 = 0, $576 = 0, $577 = 0, $578 = 0, $579 = 0, $58 = 0;
 var $580 = 0, $581 = 0, $582 = 0, $583 = 0, $584 = 0, $585 = 0, $586 = 0, $587 = 0, $588 = 0, $589 = 0, $59 = 0, $590 = 0, $591 = 0, $592 = 0, $593 = 0, $594 = 0, $595 = 0, $596 = 0, $597 = 0, $598 = 0;
 var $599 = 0, $6 = 0, $60 = 0, $600 = 0, $601 = 0, $602 = 0, $603 = 0, $604 = 0, $605 = 0, $606 = 0, $607 = 0, $608 = 0, $609 = 0, $61 = 0, $610 = 0, $611 = 0, $612 = 0, $613 = 0, $614 = 0, $615 = 0;
 var $616 = 0, $617 = 0, $618 = 0, $619 = 0, $62 = 0, $620 = 0, $621 = 0, $622 = 0, $623 = 0, $624 = 0, $625 = 0, $626 = 0, $627 = 0, $628 = 0, $629 = 0, $63 = 0, $630 = 0, $631 = 0, $632 = 0, $633 = 0;
 var $634 = 0, $635 = 0, $636 = 0, $637 = 0, $638 = 0, $639 = 0, $64 = 0, $640 = 0, $641 = 0, $642 = 0, $643 = 0, $644 = 0, $645 = 0, $646 = 0, $647 = 0, $648 = 0, $649 = 0, $65 = 0, $650 = 0, $651 = 0;
 var $652 = 0, $653 = 0, $654 = 0, $655 = 0, $656 = 0, $657 = 0, $658 = 0, $659 = 0, $66 = 0, $660 = 0, $661 = 0, $662 = 0, $663 = 0, $664 = 0, $665 = 0, $666 = 0, $667 = 0, $668 = 0, $669 = 0, $67 = 0;
 var $670 = 0, $671 = 0, $672 = 0, $673 = 0, $674 = 0, $675 = 0, $676 = 0, $677 = 0, $678 = 0, $679 = 0, $68 = 0, $680 = 0, $681 = 0, $682 = 0, $683 = 0, $684 = 0, $685 = 0, $686 = 0, $687 = 0, $688 = 0;
 var $689 = 0, $69 = 0, $690 = 0, $691 = 0, $692 = 0, $693 = 0, $694 = 0, $695 = 0, $696 = 0, $697 = 0, $698 = 0, $699 = 0, $7 = 0, $70 = 0, $700 = 0, $701 = 0, $702 = 0, $703 = 0, $704 = 0, $705 = 0;
 var $706 = 0, $707 = 0, $708 = 0, $709 = 0, $71 = 0, $710 = 0, $711 = 0, $712 = 0, $713 = 0, $714 = 0, $715 = 0, $716 = 0, $717 = 0, $718 = 0, $719 = 0, $72 = 0, $720 = 0, $721 = 0, $722 = 0, $723 = 0;
 var $724 = 0, $725 = 0, $726 = 0, $727 = 0, $728 = 0, $729 = 0, $73 = 0, $730 = 0, $731 = 0, $732 = 0, $733 = 0, $734 = 0, $735 = 0, $736 = 0, $737 = 0, $738 = 0, $739 = 0, $74 = 0, $740 = 0, $741 = 0;
 var $742 = 0, $743 = 0, $744 = 0, $745 = 0, $746 = 0, $747 = 0, $748 = 0, $749 = 0, $75 = 0, $750 = 0, $751 = 0, $752 = 0, $753 = 0, $754 = 0, $755 = 0, $756 = 0, $757 = 0, $758 = 0, $759 = 0, $76 = 0;
 var $760 = 0, $761 = 0, $762 = 0, $763 = 0, $764 = 0, $765 = 0, $766 = 0, $767 = 0, $768 = 0, $769 = 0, $77 = 0, $770 = 0, $771 = 0, $772 = 0, $773 = 0, $774 = 0, $775 = 0, $776 = 0, $777 = 0, $778 = 0;
 var $779 = 0, $78 = 0, $780 = 0, $781 = 0, $782 = 0, $783 = 0, $784 = 0, $785 = 0, $786 = 0, $787 = 0, $788 = 0, $789 = 0, $79 = 0, $790 = 0, $791 = 0, $792 = 0, $793 = 0, $794 = 0, $795 = 0, $796 = 0;
 var $797 = 0, $798 = 0, $799 = 0, $8 = 0, $80 = 0, $800 = 0, $801 = 0, $802 = 0, $803 = 0, $804 = 0, $805 = 0, $806 = 0, $807 = 0, $808 = 0, $809 = 0, $81 = 0, $810 = 0, $811 = 0, $812 = 0, $813 = 0;
 var $814 = 0, $815 = 0, $816 = 0, $817 = 0, $818 = 0, $819 = 0, $82 = 0, $820 = 0, $821 = 0, $822 = 0, $823 = 0, $824 = 0, $825 = 0, $826 = 0, $827 = 0, $828 = 0, $829 = 0, $83 = 0, $830 = 0, $831 = 0;
 var $832 = 0, $833 = 0, $834 = 0, $835 = 0, $836 = 0, $837 = 0, $838 = 0, $839 = 0, $84 = 0, $840 = 0, $841 = 0, $842 = 0, $843 = 0, $844 = 0, $845 = 0, $846 = 0, $847 = 0, $848 = 0, $849 = 0, $85 = 0;
 var $850 = 0, $851 = 0, $852 = 0, $853 = 0, $854 = 0, $855 = 0, $856 = 0, $857 = 0, $858 = 0, $859 = 0, $86 = 0, $860 = 0, $861 = 0, $862 = 0, $863 = 0, $864 = 0, $865 = 0, $866 = 0, $867 = 0, $868 = 0;
 var $869 = 0, $87 = 0, $870 = 0, $871 = 0, $872 = 0, $873 = 0, $874 = 0, $875 = 0, $876 = 0, $877 = 0, $878 = 0, $879 = 0, $88 = 0, $880 = 0, $881 = 0, $882 = 0, $883 = 0, $884 = 0, $885 = 0, $886 = 0;
 var $887 = 0, $888 = 0, $889 = 0, $89 = 0, $890 = 0, $891 = 0, $892 = 0, $893 = 0, $894 = 0, $895 = 0, $896 = 0, $897 = 0, $898 = 0, $899 = 0, $9 = 0, $90 = 0, $900 = 0, $901 = 0, $902 = 0, $903 = 0;
 var $904 = 0, $905 = 0, $906 = 0, $907 = 0, $908 = 0, $909 = 0, $91 = 0, $910 = 0, $911 = 0, $912 = 0, $913 = 0, $914 = 0, $915 = 0, $916 = 0, $917 = 0, $918 = 0, $919 = 0, $92 = 0, $920 = 0, $921 = 0;
 var $922 = 0, $923 = 0, $924 = 0, $925 = 0, $926 = 0, $927 = 0, $928 = 0, $929 = 0, $93 = 0, $930 = 0, $931 = 0, $932 = 0, $933 = 0, $934 = 0, $935 = 0, $936 = 0, $937 = 0, $938 = 0, $939 = 0, $94 = 0;
 var $940 = 0, $941 = 0, $942 = 0, $943 = 0, $944 = 0, $945 = 0, $946 = 0, $947 = 0, $948 = 0, $949 = 0, $95 = 0, $950 = 0, $951 = 0, $952 = 0, $953 = 0, $954 = 0, $955 = 0, $956 = 0, $957 = 0, $958 = 0;
 var $959 = 0, $96 = 0, $960 = 0, $961 = 0, $962 = 0, $963 = 0, $964 = 0, $965 = 0, $966 = 0, $967 = 0, $968 = 0, $969 = 0, $97 = 0, $970 = 0, $971 = 0, $972 = 0, $973 = 0, $974 = 0, $975 = 0, $976 = 0;
 var $977 = 0, $978 = 0, $979 = 0, $98 = 0, $980 = 0, $981 = 0, $982 = 0, $983 = 0, $984 = 0, $985 = 0, $986 = 0, $987 = 0, $988 = 0, $989 = 0, $99 = 0, $990 = 0, $991 = 0, $992 = 0, $993 = 0, $994 = 0;
 var $995 = 0, $996 = 0, $997 = 0, $998 = 0, $999 = 0, $bit_rate$0$i = 0, $bit_rate$0$i$i = 0, $bit_rate$0$in$i = 0, $bit_rate$0$in$i$i = 0, $ch$047$i = 0, $ch$0637$i = 0, $ch$1632$i = 0, $ch$179$i = 0, $ch$2638$i = 0, $data_bits$0$lcssa$i = 0, $data_bits$039$$i = 0, $data_bits$039$i = 0, $data_bits$039$us$i = 0, $data_bits$1$us$i = 0, $data_bits$2$lcssa$i = 0;
 var $data_bits$242$i = 0, $data_bits$3$i = 0, $data_bits$4$i = 0, $data_bits$5$i = 0, $exitcond = 0, $exitcond$i = 0, $exitcond$i6 = 0, $exitcond166 = 0, $exitcond93$i = 0, $exitcond94$i = 0, $exitcond95$i = 0, $flushbits$0$i = 0, $gr$054$i = 0, $gr$0634$i = 0, $i$067$i = 0, $i$091 = 0, $i$156$us$i = 0, $ptr$01$i$i = 0, $ptr$01$i10$i = 0, $ptr$01$i106$i = 0;
 var $ptr$01$i114$i = 0, $ptr$01$i122$i = 0, $ptr$01$i130$i = 0, $ptr$01$i138$i = 0, $ptr$01$i146$i = 0, $ptr$01$i154$i = 0, $ptr$01$i162$i = 0, $ptr$01$i170$i = 0, $ptr$01$i178$i = 0, $ptr$01$i18$i = 0, $ptr$01$i188$i = 0, $ptr$01$i198$i = 0, $ptr$01$i2$i = 0, $ptr$01$i208$i = 0, $ptr$01$i218$i = 0, $ptr$01$i228$i = 0, $ptr$01$i238$i = 0, $ptr$01$i248$i = 0, $ptr$01$i258$i = 0, $ptr$01$i26$i = 0;
 var $ptr$01$i268$i = 0, $ptr$01$i278$i = 0, $ptr$01$i288$i = 0, $ptr$01$i298$i = 0, $ptr$01$i308$i = 0, $ptr$01$i318$i = 0, $ptr$01$i328$i = 0, $ptr$01$i338$i = 0, $ptr$01$i34$i = 0, $ptr$01$i348$i = 0, $ptr$01$i358$i = 0, $ptr$01$i368$i = 0, $ptr$01$i378$i = 0, $ptr$01$i388$i = 0, $ptr$01$i398$1$i = 0, $ptr$01$i398$2$i = 0, $ptr$01$i398$3$i = 0, $ptr$01$i398$i = 0, $ptr$01$i408$i = 0, $ptr$01$i418$i = 0;
 var $ptr$01$i42$i = 0, $ptr$01$i428$i = 0, $ptr$01$i438$i = 0, $ptr$01$i448$i = 0, $ptr$01$i458$i = 0, $ptr$01$i468$i = 0, $ptr$01$i478$i = 0, $ptr$01$i488$i = 0, $ptr$01$i498$i = 0, $ptr$01$i50$i = 0, $ptr$01$i508$i = 0, $ptr$01$i518$i = 0, $ptr$01$i528$i = 0, $ptr$01$i538$i = 0, $ptr$01$i548$i = 0, $ptr$01$i558$i = 0, $ptr$01$i58$i = 0, $ptr$01$i66$i = 0, $ptr$01$i74$i = 0, $ptr$01$i82$i = 0;
 var $ptr$01$i90$i = 0, $ptr$01$i98$i = 0, $region2Start$0$i$i = 0, $region2Start$0$i10$i = 0, $scale_bits$076$i = 0, $scale_bits$1$lcssa$i = 0, $scale_bits$1$lcssa$i$lcssa = 0, $scale_bits$265$i = 0, $scale_bits$3$lcssa$i = 0, $scale_bits$3$lcssa$i$lcssa = 0, $scale_bits$4$i = 0, $sfb$0$lcssa$i = 0, $sfb$040$i = 0, $sfb$040$us$i = 0, $sfb$143$i = 0, $sfb$277$i = 0, $sfb$3$lcssa$i = 0, $sfb$369$i = 0, $sfb$466$i = 0, $sfb$5$lcssa$i = 0;
 var $sfb$558$us$i = 0, $sfb_partition$075$i = 0, $sfb_partition$164$i = 0, $smax$i = 0, $split62$i = 0, $split63$i = 0, $tot_bits$053$i = 0, $tot_bits$1$lcssa$i = 0, $tot_bits$146$i = 0, $tot_bits$278$i = 0, $tot_bits$3$i = 0, $vararg_buffer = 0, $vararg_buffer1 = 0, $vararg_buffer15 = 0, $vararg_buffer17 = 0, $vararg_buffer19 = 0, $vararg_buffer21 = 0, $vararg_buffer3 = 0, $vararg_buffer5 = 0, $vararg_ptr10 = 0;
 var $vararg_ptr11 = 0, $vararg_ptr12 = 0, $vararg_ptr13 = 0, $vararg_ptr14 = 0, $vararg_ptr7 = 0, $vararg_ptr8 = 0, $vararg_ptr9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 96|0;
 $vararg_buffer21 = sp + 88|0;
 $vararg_buffer19 = sp + 80|0;
 $vararg_buffer17 = sp + 72|0;
 $vararg_buffer15 = sp + 64|0;
 $vararg_buffer5 = sp + 24|0;
 $vararg_buffer3 = sp + 16|0;
 $vararg_buffer1 = sp + 8|0;
 $vararg_buffer = sp;
 $0 = ((($gfc)) + 16|0);
 $1 = ((($gfc)) + 84744|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0);
 if ($3) {
  $6 = ((($gfc)) + 120|0);
  $$idx$val$pre$i = HEAP32[$0>>2]|0;
  $$idx$val$i = $$idx$val$pre$i;$bit_rate$0$in$i = $6;
 } else {
  $4 = HEAP32[$0>>2]|0;
  $5 = ((83944 + ($4<<6)|0) + ($2<<2)|0);
  $$idx$val$i = $4;$bit_rate$0$in$i = $5;
 }
 $bit_rate$0$i = HEAP32[$bit_rate$0$in$i>>2]|0;
 $7 = ((($gfc)) + 84752|0);
 $8 = HEAP32[$7>>2]|0;
 $$idx1$i = ((($gfc)) + 64|0);
 $$idx1$val$i = HEAP32[$$idx1$i>>2]|0;
 $9 = ($$idx$val$i*72000)|0;
 $10 = (($9) + 72000)|0;
 $11 = Math_imul($10, $bit_rate$0$i)|0;
 $12 = (($11|0) / ($$idx1$val$i|0))&-1;
 $13 = (($12) + ($8))|0;
 $14 = $13 << 3;
 $15 = ((($gfc)) + 21320|0);
 $16 = HEAP32[$15>>2]|0;
 _drain_into_ancillary($gfc,$16);
 $17 = ((($gfc)) + 52128|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = (((((($gfc)) + 39840|0) + (($18*48)|0)|0)) + 4|0);
 HEAP32[$19>>2] = 0;
 $20 = (((((($gfc)) + 39840|0) + (($18*48)|0)|0)) + 8|0);
 $21 = ((($gfc)) + 24|0);
 $22 = HEAP32[$21>>2]|0;
 _memset(($20|0),0,($22|0))|0;
 $23 = HEAP32[$$idx1$i>>2]|0;
 $24 = ($23|0)<(16000);
 $25 = HEAP32[$17>>2]|0;
 $26 = (((((($gfc)) + 39840|0) + (($25*48)|0)|0)) + 4|0);
 $27 = HEAP32[$26>>2]|0;
 if ($24) {
  $$02$i$i = 12;$37 = $25;$ptr$01$i$i = $27;
  while(1) {
   $28 = $ptr$01$i$i & 7;
   $29 = (8 - ($28))|0;
   $30 = ($$02$i$i|0)<($29|0);
   $$0$$i$i = $30 ? $$02$i$i : $29;
   $31 = (($$02$i$i) - ($$0$$i$i))|0;
   $32 = 4094 >>> $31;
   $33 = (($29) - ($$0$$i$i))|0;
   $34 = $32 << $33;
   $35 = $ptr$01$i$i >> 3;
   $36 = ((((((($gfc)) + 39840|0) + (($37*48)|0)|0)) + 8|0) + ($35)|0);
   $38 = HEAP8[$36>>0]|0;
   $39 = $38&255;
   $40 = $34 | $39;
   $41 = $40&255;
   HEAP8[$36>>0] = $41;
   $42 = (($$0$$i$i) + ($ptr$01$i$i))|0;
   $43 = ($31|0)>(0);
   $$pre$i$i = HEAP32[$17>>2]|0;
   if ($43) {
    $$02$i$i = $31;$37 = $$pre$i$i;$ptr$01$i$i = $42;
   } else {
    $$lcssa470 = $42;$$pre$i$i$lcssa = $$pre$i$i;
    break;
   }
  }
  $44 = (((((($gfc)) + 39840|0) + (($$pre$i$i$lcssa*48)|0)|0)) + 4|0);
  HEAP32[$44>>2] = $$lcssa470;
  $1787 = $$lcssa470;$1788 = $$pre$i$i$lcssa;
 } else {
  $$02$i1$i = 12;$54 = $25;$ptr$01$i2$i = $27;
  while(1) {
   $45 = $ptr$01$i2$i & 7;
   $46 = (8 - ($45))|0;
   $47 = ($$02$i1$i|0)<($46|0);
   $$0$$i3$i = $47 ? $$02$i1$i : $46;
   $48 = (($$02$i1$i) - ($$0$$i3$i))|0;
   $49 = 4095 >>> $48;
   $50 = (($46) - ($$0$$i3$i))|0;
   $51 = $49 << $50;
   $52 = $ptr$01$i2$i >> 3;
   $53 = ((((((($gfc)) + 39840|0) + (($54*48)|0)|0)) + 8|0) + ($52)|0);
   $55 = HEAP8[$53>>0]|0;
   $56 = $55&255;
   $57 = $51 | $56;
   $58 = $57&255;
   HEAP8[$53>>0] = $58;
   $59 = (($$0$$i3$i) + ($ptr$01$i2$i))|0;
   $60 = ($48|0)>(0);
   $$pre$i5$i = HEAP32[$17>>2]|0;
   if ($60) {
    $$02$i1$i = $48;$54 = $$pre$i5$i;$ptr$01$i2$i = $59;
   } else {
    $$lcssa471 = $59;$$pre$i5$i$lcssa = $$pre$i5$i;
    break;
   }
  }
  $61 = (((((($gfc)) + 39840|0) + (($$pre$i5$i$lcssa*48)|0)|0)) + 4|0);
  HEAP32[$61>>2] = $$lcssa471;
  $1787 = $$lcssa471;$1788 = $$pre$i5$i$lcssa;
 }
 $62 = ((($gfc)) + 16|0);
 $63 = HEAP32[$62>>2]|0;
 $$02$i557$i = 1;$73 = $1788;$ptr$01$i558$i = $1787;
 while(1) {
  $64 = $ptr$01$i558$i & 7;
  $65 = (8 - ($64))|0;
  $66 = ($$02$i557$i|0)<($65|0);
  $$0$$i559$i = $66 ? $$02$i557$i : $65;
  $67 = (($$02$i557$i) - ($$0$$i559$i))|0;
  $68 = $63 >> $67;
  $69 = (($65) - ($$0$$i559$i))|0;
  $70 = $68 << $69;
  $71 = $ptr$01$i558$i >> 3;
  $72 = ((((((($gfc)) + 39840|0) + (($73*48)|0)|0)) + 8|0) + ($71)|0);
  $74 = HEAP8[$72>>0]|0;
  $75 = $74&255;
  $76 = $70 | $75;
  $77 = $76&255;
  HEAP8[$72>>0] = $77;
  $78 = (($$0$$i559$i) + ($ptr$01$i558$i))|0;
  $79 = ($67|0)>(0);
  $$pre$i561$i = HEAP32[$17>>2]|0;
  if ($79) {
   $$02$i557$i = $67;$73 = $$pre$i561$i;$ptr$01$i558$i = $78;
  } else {
   $$lcssa469 = $78;$$pre$i561$i$lcssa = $$pre$i561$i;
   break;
  }
 }
 $80 = (((((($gfc)) + 39840|0) + (($$pre$i561$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$80>>2] = $$lcssa469;
 $$02$i547$i = 2;$90 = $$pre$i561$i$lcssa;$ptr$01$i548$i = $$lcssa469;
 while(1) {
  $81 = $ptr$01$i548$i & 7;
  $82 = (8 - ($81))|0;
  $83 = ($$02$i547$i|0)<($82|0);
  $$0$$i549$i = $83 ? $$02$i547$i : $82;
  $84 = (($$02$i547$i) - ($$0$$i549$i))|0;
  $85 = 1 >>> $84;
  $86 = (($82) - ($$0$$i549$i))|0;
  $87 = $85 << $86;
  $88 = $ptr$01$i548$i >> 3;
  $89 = ((((((($gfc)) + 39840|0) + (($90*48)|0)|0)) + 8|0) + ($88)|0);
  $91 = HEAP8[$89>>0]|0;
  $92 = $91&255;
  $93 = $87 | $92;
  $94 = $93&255;
  HEAP8[$89>>0] = $94;
  $95 = (($$0$$i549$i) + ($ptr$01$i548$i))|0;
  $96 = ($84|0)>(0);
  $$pre$i551$i = HEAP32[$17>>2]|0;
  if ($96) {
   $$02$i547$i = $84;$90 = $$pre$i551$i;$ptr$01$i548$i = $95;
  } else {
   $$lcssa468 = $95;$$pre$i551$i$lcssa = $$pre$i551$i;
   break;
  }
 }
 $97 = (((((($gfc)) + 39840|0) + (($$pre$i551$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$97>>2] = $$lcssa468;
 $98 = ((($gfc)) + 160|0);
 $99 = HEAP32[$98>>2]|0;
 $100 = ($99|0)==(0);
 $101 = $100&1;
 $$02$i537$i = 1;$111 = $$pre$i551$i$lcssa;$ptr$01$i538$i = $$lcssa468;
 while(1) {
  $102 = $ptr$01$i538$i & 7;
  $103 = (8 - ($102))|0;
  $104 = ($$02$i537$i|0)<($103|0);
  $$0$$i539$i = $104 ? $$02$i537$i : $103;
  $105 = (($$02$i537$i) - ($$0$$i539$i))|0;
  $106 = $101 >>> $105;
  $107 = (($103) - ($$0$$i539$i))|0;
  $108 = $106 << $107;
  $109 = $ptr$01$i538$i >> 3;
  $110 = ((((((($gfc)) + 39840|0) + (($111*48)|0)|0)) + 8|0) + ($109)|0);
  $112 = HEAP8[$110>>0]|0;
  $113 = $112&255;
  $114 = $108 | $113;
  $115 = $114&255;
  HEAP8[$110>>0] = $115;
  $116 = (($$0$$i539$i) + ($ptr$01$i538$i))|0;
  $117 = ($105|0)>(0);
  $$pre$i541$i = HEAP32[$17>>2]|0;
  if ($117) {
   $$02$i537$i = $105;$111 = $$pre$i541$i;$ptr$01$i538$i = $116;
  } else {
   $$lcssa467 = $116;$$pre$i541$i$lcssa = $$pre$i541$i;
   break;
  }
 }
 $118 = (((((($gfc)) + 39840|0) + (($$pre$i541$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$118>>2] = $$lcssa467;
 $119 = HEAP32[$1>>2]|0;
 $$02$i527$i = 4;$129 = $$pre$i541$i$lcssa;$ptr$01$i528$i = $$lcssa467;
 while(1) {
  $120 = $ptr$01$i528$i & 7;
  $121 = (8 - ($120))|0;
  $122 = ($$02$i527$i|0)<($121|0);
  $$0$$i529$i = $122 ? $$02$i527$i : $121;
  $123 = (($$02$i527$i) - ($$0$$i529$i))|0;
  $124 = $119 >> $123;
  $125 = (($121) - ($$0$$i529$i))|0;
  $126 = $124 << $125;
  $127 = $ptr$01$i528$i >> 3;
  $128 = ((((((($gfc)) + 39840|0) + (($129*48)|0)|0)) + 8|0) + ($127)|0);
  $130 = HEAP8[$128>>0]|0;
  $131 = $130&255;
  $132 = $126 | $131;
  $133 = $132&255;
  HEAP8[$128>>0] = $133;
  $134 = (($$0$$i529$i) + ($ptr$01$i528$i))|0;
  $135 = ($123|0)>(0);
  $$pre$i531$i = HEAP32[$17>>2]|0;
  if ($135) {
   $$02$i527$i = $123;$129 = $$pre$i531$i;$ptr$01$i528$i = $134;
  } else {
   $$lcssa466 = $134;$$pre$i531$i$lcssa = $$pre$i531$i;
   break;
  }
 }
 $136 = (((((($gfc)) + 39840|0) + (($$pre$i531$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$136>>2] = $$lcssa466;
 $137 = ((($gfc)) + 20|0);
 $138 = HEAP32[$137>>2]|0;
 $$02$i517$i = 2;$148 = $$pre$i531$i$lcssa;$ptr$01$i518$i = $$lcssa466;
 while(1) {
  $139 = $ptr$01$i518$i & 7;
  $140 = (8 - ($139))|0;
  $141 = ($$02$i517$i|0)<($140|0);
  $$0$$i519$i = $141 ? $$02$i517$i : $140;
  $142 = (($$02$i517$i) - ($$0$$i519$i))|0;
  $143 = $138 >> $142;
  $144 = (($140) - ($$0$$i519$i))|0;
  $145 = $143 << $144;
  $146 = $ptr$01$i518$i >> 3;
  $147 = ((((((($gfc)) + 39840|0) + (($148*48)|0)|0)) + 8|0) + ($146)|0);
  $149 = HEAP8[$147>>0]|0;
  $150 = $149&255;
  $151 = $145 | $150;
  $152 = $151&255;
  HEAP8[$147>>0] = $152;
  $153 = (($$0$$i519$i) + ($ptr$01$i518$i))|0;
  $154 = ($142|0)>(0);
  $$pre$i521$i = HEAP32[$17>>2]|0;
  if ($154) {
   $$02$i517$i = $142;$148 = $$pre$i521$i;$ptr$01$i518$i = $153;
  } else {
   $$lcssa465 = $153;$$pre$i521$i$lcssa = $$pre$i521$i;
   break;
  }
 }
 $155 = (((((($gfc)) + 39840|0) + (($$pre$i521$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$155>>2] = $$lcssa465;
 $156 = HEAP32[$7>>2]|0;
 $$02$i507$i = 1;$166 = $$pre$i521$i$lcssa;$ptr$01$i508$i = $$lcssa465;
 while(1) {
  $157 = $ptr$01$i508$i & 7;
  $158 = (8 - ($157))|0;
  $159 = ($$02$i507$i|0)<($158|0);
  $$0$$i509$i = $159 ? $$02$i507$i : $158;
  $160 = (($$02$i507$i) - ($$0$$i509$i))|0;
  $161 = $156 >> $160;
  $162 = (($158) - ($$0$$i509$i))|0;
  $163 = $161 << $162;
  $164 = $ptr$01$i508$i >> 3;
  $165 = ((((((($gfc)) + 39840|0) + (($166*48)|0)|0)) + 8|0) + ($164)|0);
  $167 = HEAP8[$165>>0]|0;
  $168 = $167&255;
  $169 = $163 | $168;
  $170 = $169&255;
  HEAP8[$165>>0] = $170;
  $171 = (($$0$$i509$i) + ($ptr$01$i508$i))|0;
  $172 = ($160|0)>(0);
  $$pre$i511$i = HEAP32[$17>>2]|0;
  if ($172) {
   $$02$i507$i = $160;$166 = $$pre$i511$i;$ptr$01$i508$i = $171;
  } else {
   $$lcssa464 = $171;$$pre$i511$i$lcssa = $$pre$i511$i;
   break;
  }
 }
 $173 = (((((($gfc)) + 39840|0) + (($$pre$i511$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$173>>2] = $$lcssa464;
 $174 = ((($gfc)) + 172|0);
 $175 = HEAP32[$174>>2]|0;
 $$02$i497$i = 1;$185 = $$pre$i511$i$lcssa;$ptr$01$i498$i = $$lcssa464;
 while(1) {
  $176 = $ptr$01$i498$i & 7;
  $177 = (8 - ($176))|0;
  $178 = ($$02$i497$i|0)<($177|0);
  $$0$$i499$i = $178 ? $$02$i497$i : $177;
  $179 = (($$02$i497$i) - ($$0$$i499$i))|0;
  $180 = $175 >> $179;
  $181 = (($177) - ($$0$$i499$i))|0;
  $182 = $180 << $181;
  $183 = $ptr$01$i498$i >> 3;
  $184 = ((((((($gfc)) + 39840|0) + (($185*48)|0)|0)) + 8|0) + ($183)|0);
  $186 = HEAP8[$184>>0]|0;
  $187 = $186&255;
  $188 = $182 | $187;
  $189 = $188&255;
  HEAP8[$184>>0] = $189;
  $190 = (($$0$$i499$i) + ($ptr$01$i498$i))|0;
  $191 = ($179|0)>(0);
  $$pre$i501$i = HEAP32[$17>>2]|0;
  if ($191) {
   $$02$i497$i = $179;$185 = $$pre$i501$i;$ptr$01$i498$i = $190;
  } else {
   $$lcssa463 = $190;$$pre$i501$i$lcssa = $$pre$i501$i;
   break;
  }
 }
 $192 = (((((($gfc)) + 39840|0) + (($$pre$i501$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$192>>2] = $$lcssa463;
 $193 = ((($gfc)) + 180|0);
 $194 = HEAP32[$193>>2]|0;
 $$02$i487$i = 2;$204 = $$pre$i501$i$lcssa;$ptr$01$i488$i = $$lcssa463;
 while(1) {
  $195 = $ptr$01$i488$i & 7;
  $196 = (8 - ($195))|0;
  $197 = ($$02$i487$i|0)<($196|0);
  $$0$$i489$i = $197 ? $$02$i487$i : $196;
  $198 = (($$02$i487$i) - ($$0$$i489$i))|0;
  $199 = $194 >> $198;
  $200 = (($196) - ($$0$$i489$i))|0;
  $201 = $199 << $200;
  $202 = $ptr$01$i488$i >> 3;
  $203 = ((((((($gfc)) + 39840|0) + (($204*48)|0)|0)) + 8|0) + ($202)|0);
  $205 = HEAP8[$203>>0]|0;
  $206 = $205&255;
  $207 = $201 | $206;
  $208 = $207&255;
  HEAP8[$203>>0] = $208;
  $209 = (($$0$$i489$i) + ($ptr$01$i488$i))|0;
  $210 = ($198|0)>(0);
  $$pre$i491$i = HEAP32[$17>>2]|0;
  if ($210) {
   $$02$i487$i = $198;$204 = $$pre$i491$i;$ptr$01$i488$i = $209;
  } else {
   $$lcssa462 = $209;$$pre$i491$i$lcssa = $$pre$i491$i;
   break;
  }
 }
 $211 = (((((($gfc)) + 39840|0) + (($$pre$i491$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$211>>2] = $$lcssa462;
 $212 = ((($gfc)) + 84756|0);
 $213 = HEAP32[$212>>2]|0;
 $$02$i477$i = 2;$223 = $$pre$i491$i$lcssa;$ptr$01$i478$i = $$lcssa462;
 while(1) {
  $214 = $ptr$01$i478$i & 7;
  $215 = (8 - ($214))|0;
  $216 = ($$02$i477$i|0)<($215|0);
  $$0$$i479$i = $216 ? $$02$i477$i : $215;
  $217 = (($$02$i477$i) - ($$0$$i479$i))|0;
  $218 = $213 >> $217;
  $219 = (($215) - ($$0$$i479$i))|0;
  $220 = $218 << $219;
  $221 = $ptr$01$i478$i >> 3;
  $222 = ((((((($gfc)) + 39840|0) + (($223*48)|0)|0)) + 8|0) + ($221)|0);
  $224 = HEAP8[$222>>0]|0;
  $225 = $224&255;
  $226 = $220 | $225;
  $227 = $226&255;
  HEAP8[$222>>0] = $227;
  $228 = (($$0$$i479$i) + ($ptr$01$i478$i))|0;
  $229 = ($217|0)>(0);
  $$pre$i481$i = HEAP32[$17>>2]|0;
  if ($229) {
   $$02$i477$i = $217;$223 = $$pre$i481$i;$ptr$01$i478$i = $228;
  } else {
   $$lcssa461 = $228;$$pre$i481$i$lcssa = $$pre$i481$i;
   break;
  }
 }
 $230 = (((((($gfc)) + 39840|0) + (($$pre$i481$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$230>>2] = $$lcssa461;
 $231 = ((($gfc)) + 164|0);
 $232 = HEAP32[$231>>2]|0;
 $$02$i467$i = 1;$242 = $$pre$i481$i$lcssa;$ptr$01$i468$i = $$lcssa461;
 while(1) {
  $233 = $ptr$01$i468$i & 7;
  $234 = (8 - ($233))|0;
  $235 = ($$02$i467$i|0)<($234|0);
  $$0$$i469$i = $235 ? $$02$i467$i : $234;
  $236 = (($$02$i467$i) - ($$0$$i469$i))|0;
  $237 = $232 >> $236;
  $238 = (($234) - ($$0$$i469$i))|0;
  $239 = $237 << $238;
  $240 = $ptr$01$i468$i >> 3;
  $241 = ((((((($gfc)) + 39840|0) + (($242*48)|0)|0)) + 8|0) + ($240)|0);
  $243 = HEAP8[$241>>0]|0;
  $244 = $243&255;
  $245 = $239 | $244;
  $246 = $245&255;
  HEAP8[$241>>0] = $246;
  $247 = (($$0$$i469$i) + ($ptr$01$i468$i))|0;
  $248 = ($236|0)>(0);
  $$pre$i471$i = HEAP32[$17>>2]|0;
  if ($248) {
   $$02$i467$i = $236;$242 = $$pre$i471$i;$ptr$01$i468$i = $247;
  } else {
   $$lcssa460 = $247;$$pre$i471$i$lcssa = $$pre$i471$i;
   break;
  }
 }
 $249 = (((((($gfc)) + 39840|0) + (($$pre$i471$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$249>>2] = $$lcssa460;
 $250 = ((($gfc)) + 168|0);
 $251 = HEAP32[$250>>2]|0;
 $$02$i457$i = 1;$261 = $$pre$i471$i$lcssa;$ptr$01$i458$i = $$lcssa460;
 while(1) {
  $252 = $ptr$01$i458$i & 7;
  $253 = (8 - ($252))|0;
  $254 = ($$02$i457$i|0)<($253|0);
  $$0$$i459$i = $254 ? $$02$i457$i : $253;
  $255 = (($$02$i457$i) - ($$0$$i459$i))|0;
  $256 = $251 >> $255;
  $257 = (($253) - ($$0$$i459$i))|0;
  $258 = $256 << $257;
  $259 = $ptr$01$i458$i >> 3;
  $260 = ((((((($gfc)) + 39840|0) + (($261*48)|0)|0)) + 8|0) + ($259)|0);
  $262 = HEAP8[$260>>0]|0;
  $263 = $262&255;
  $264 = $258 | $263;
  $265 = $264&255;
  HEAP8[$260>>0] = $265;
  $266 = (($$0$$i459$i) + ($ptr$01$i458$i))|0;
  $267 = ($255|0)>(0);
  $$pre$i461$i = HEAP32[$17>>2]|0;
  if ($267) {
   $$02$i457$i = $255;$261 = $$pre$i461$i;$ptr$01$i458$i = $266;
  } else {
   $$lcssa459 = $266;$$pre$i461$i$lcssa = $$pre$i461$i;
   break;
  }
 }
 $268 = (((((($gfc)) + 39840|0) + (($$pre$i461$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$268>>2] = $$lcssa459;
 $269 = ((($gfc)) + 176|0);
 $270 = HEAP32[$269>>2]|0;
 $$02$i447$i = 2;$280 = $$pre$i461$i$lcssa;$ptr$01$i448$i = $$lcssa459;
 while(1) {
  $271 = $ptr$01$i448$i & 7;
  $272 = (8 - ($271))|0;
  $273 = ($$02$i447$i|0)<($272|0);
  $$0$$i449$i = $273 ? $$02$i447$i : $272;
  $274 = (($$02$i447$i) - ($$0$$i449$i))|0;
  $275 = $270 >> $274;
  $276 = (($272) - ($$0$$i449$i))|0;
  $277 = $275 << $276;
  $278 = $ptr$01$i448$i >> 3;
  $279 = ((((((($gfc)) + 39840|0) + (($280*48)|0)|0)) + 8|0) + ($278)|0);
  $281 = HEAP8[$279>>0]|0;
  $282 = $281&255;
  $283 = $277 | $282;
  $284 = $283&255;
  HEAP8[$279>>0] = $284;
  $285 = (($$0$$i449$i) + ($ptr$01$i448$i))|0;
  $286 = ($274|0)>(0);
  $$pre$i451$i = HEAP32[$17>>2]|0;
  if ($286) {
   $$02$i447$i = $274;$280 = $$pre$i451$i;$ptr$01$i448$i = $285;
  } else {
   $$lcssa458 = $285;$$pre$i451$i$lcssa = $$pre$i451$i;
   break;
  }
 }
 $287 = (((((($gfc)) + 39840|0) + (($$pre$i451$i$lcssa*48)|0)|0)) + 4|0);
 HEAP32[$287>>2] = $$lcssa458;
 $288 = HEAP32[$98>>2]|0;
 $289 = ($288|0)==(0);
 if ($289) {
  $1789 = $$lcssa458;
 } else {
  $$02$i437$i = 16;$ptr$01$i438$i = $$lcssa458;
  while(1) {
   $290 = $ptr$01$i438$i & 7;
   $291 = (8 - ($290))|0;
   $292 = ($$02$i437$i|0)<($291|0);
   $$0$$i439$i = $292 ? $$02$i437$i : $291;
   $293 = (($$02$i437$i) - ($$0$$i439$i))|0;
   $294 = (($$0$$i439$i) + ($ptr$01$i438$i))|0;
   $295 = ($293|0)>(0);
   if ($295) {
    $$02$i437$i = $293;$ptr$01$i438$i = $294;
   } else {
    $$lcssa457 = $294;
    break;
   }
  }
  HEAP32[$287>>2] = $$lcssa457;
  $1789 = $$lcssa457;
 }
 $296 = HEAP32[$62>>2]|0;
 $297 = ($296|0)==(1);
 $298 = ((($gfc)) + 21312|0);
 $299 = HEAP32[$298>>2]|0;
 do {
  if ($297) {
   $$02$i427$i = 9;$309 = $$pre$i451$i$lcssa;$ptr$01$i428$i = $1789;
   while(1) {
    $300 = $ptr$01$i428$i & 7;
    $301 = (8 - ($300))|0;
    $302 = ($$02$i427$i|0)<($301|0);
    $$0$$i429$i = $302 ? $$02$i427$i : $301;
    $303 = (($$02$i427$i) - ($$0$$i429$i))|0;
    $304 = $299 >> $303;
    $305 = (($301) - ($$0$$i429$i))|0;
    $306 = $304 << $305;
    $307 = $ptr$01$i428$i >> 3;
    $308 = ((((((($gfc)) + 39840|0) + (($309*48)|0)|0)) + 8|0) + ($307)|0);
    $310 = HEAP8[$308>>0]|0;
    $311 = $310&255;
    $312 = $306 | $311;
    $313 = $312&255;
    HEAP8[$308>>0] = $313;
    $314 = (($$0$$i429$i) + ($ptr$01$i428$i))|0;
    $315 = ($303|0)>(0);
    $$pre$i431$i = HEAP32[$17>>2]|0;
    if ($315) {
     $$02$i427$i = $303;$309 = $$pre$i431$i;$ptr$01$i428$i = $314;
    } else {
     $$lcssa434 = $314;$$pre$i431$i$lcssa = $$pre$i431$i;
     break;
    }
   }
   $316 = (((((($gfc)) + 39840|0) + (($$pre$i431$i$lcssa*48)|0)|0)) + 4|0);
   HEAP32[$316>>2] = $$lcssa434;
   $317 = ((($gfc)) + 72|0);
   $318 = HEAP32[$317>>2]|0;
   $319 = ($318|0)==(2);
   $320 = ((($gfc)) + 21316|0);
   $321 = HEAP32[$320>>2]|0;
   if ($319) {
    $$02$i417$i = 3;$331 = $$pre$i431$i$lcssa;$ptr$01$i418$i = $$lcssa434;
    while(1) {
     $322 = $ptr$01$i418$i & 7;
     $323 = (8 - ($322))|0;
     $324 = ($$02$i417$i|0)<($323|0);
     $$0$$i419$i = $324 ? $$02$i417$i : $323;
     $325 = (($$02$i417$i) - ($$0$$i419$i))|0;
     $326 = $321 >> $325;
     $327 = (($323) - ($$0$$i419$i))|0;
     $328 = $326 << $327;
     $329 = $ptr$01$i418$i >> 3;
     $330 = ((((((($gfc)) + 39840|0) + (($331*48)|0)|0)) + 8|0) + ($329)|0);
     $332 = HEAP8[$330>>0]|0;
     $333 = $332&255;
     $334 = $328 | $333;
     $335 = $334&255;
     HEAP8[$330>>0] = $335;
     $336 = (($$0$$i419$i) + ($ptr$01$i418$i))|0;
     $337 = ($325|0)>(0);
     $$pre$i421$i = HEAP32[$17>>2]|0;
     if ($337) {
      $$02$i417$i = $325;$331 = $$pre$i421$i;$ptr$01$i418$i = $336;
     } else {
      $$lcssa432 = $336;$$pre$i421$i$lcssa = $$pre$i421$i;
      break;
     }
    }
    $338 = (((((($gfc)) + 39840|0) + (($$pre$i421$i$lcssa*48)|0)|0)) + 4|0);
    HEAP32[$338>>2] = $$lcssa432;
    $$pre735$i = $$lcssa432;$1790 = $$pre$i421$i$lcssa;
   } else {
    $$02$i407$i = 5;$348 = $$pre$i431$i$lcssa;$ptr$01$i408$i = $$lcssa434;
    while(1) {
     $339 = $ptr$01$i408$i & 7;
     $340 = (8 - ($339))|0;
     $341 = ($$02$i407$i|0)<($340|0);
     $$0$$i409$i = $341 ? $$02$i407$i : $340;
     $342 = (($$02$i407$i) - ($$0$$i409$i))|0;
     $343 = $321 >> $342;
     $344 = (($340) - ($$0$$i409$i))|0;
     $345 = $343 << $344;
     $346 = $ptr$01$i408$i >> 3;
     $347 = ((((((($gfc)) + 39840|0) + (($348*48)|0)|0)) + 8|0) + ($346)|0);
     $349 = HEAP8[$347>>0]|0;
     $350 = $349&255;
     $351 = $345 | $350;
     $352 = $351&255;
     HEAP8[$347>>0] = $352;
     $353 = (($$0$$i409$i) + ($ptr$01$i408$i))|0;
     $354 = ($342|0)>(0);
     $$pre$i411$i = HEAP32[$17>>2]|0;
     if ($354) {
      $$02$i407$i = $342;$348 = $$pre$i411$i;$ptr$01$i408$i = $353;
     } else {
      $$lcssa433 = $353;$$pre$i411$i$lcssa = $$pre$i411$i;
      break;
     }
    }
    $355 = (((((($gfc)) + 39840|0) + (($$pre$i411$i$lcssa*48)|0)|0)) + 4|0);
    HEAP32[$355>>2] = $$lcssa433;
    $$pre735$i = $$lcssa433;$1790 = $$pre$i411$i$lcssa;
   }
   $356 = HEAP32[$317>>2]|0;
   $357 = ($356|0)>(0);
   if ($357) {
    $1791 = $$pre735$i;$1792 = $1790;$ch$0637$i = 0;
    while(1) {
     $358 = (((($gfc)) + 21328|0) + ($ch$0637$i<<4)|0);
     $359 = HEAP32[$358>>2]|0;
     $$02$i397$i = 1;$369 = $1792;$ptr$01$i398$i = $1791;
     while(1) {
      $360 = $ptr$01$i398$i & 7;
      $361 = (8 - ($360))|0;
      $362 = ($$02$i397$i|0)<($361|0);
      $$0$$i399$i = $362 ? $$02$i397$i : $361;
      $363 = (($$02$i397$i) - ($$0$$i399$i))|0;
      $364 = $359 >> $363;
      $365 = (($361) - ($$0$$i399$i))|0;
      $366 = $364 << $365;
      $367 = $ptr$01$i398$i >> 3;
      $368 = ((((((($gfc)) + 39840|0) + (($369*48)|0)|0)) + 8|0) + ($367)|0);
      $370 = HEAP8[$368>>0]|0;
      $371 = $370&255;
      $372 = $366 | $371;
      $373 = $372&255;
      HEAP8[$368>>0] = $373;
      $374 = (($$0$$i399$i) + ($ptr$01$i398$i))|0;
      $375 = ($363|0)>(0);
      $$pre$i401$i = HEAP32[$17>>2]|0;
      if ($375) {
       $$02$i397$i = $363;$369 = $$pre$i401$i;$ptr$01$i398$i = $374;
      } else {
       $$lcssa427 = $374;$$pre$i401$i$lcssa = $$pre$i401$i;
       break;
      }
     }
     $376 = (((((($gfc)) + 39840|0) + (($$pre$i401$i$lcssa*48)|0)|0)) + 4|0);
     HEAP32[$376>>2] = $$lcssa427;
     $377 = (((((($gfc)) + 21328|0) + ($ch$0637$i<<4)|0)) + 4|0);
     $378 = HEAP32[$377>>2]|0;
     $$02$i397$1$i = 1;$1234 = $$pre$i401$i$lcssa;$ptr$01$i398$1$i = $$lcssa427;
     while(1) {
      $1225 = $ptr$01$i398$1$i & 7;
      $1226 = (8 - ($1225))|0;
      $1227 = ($$02$i397$1$i|0)<($1226|0);
      $$0$$i399$1$i = $1227 ? $$02$i397$1$i : $1226;
      $1228 = (($$02$i397$1$i) - ($$0$$i399$1$i))|0;
      $1229 = $378 >> $1228;
      $1230 = (($1226) - ($$0$$i399$1$i))|0;
      $1231 = $1229 << $1230;
      $1232 = $ptr$01$i398$1$i >> 3;
      $1233 = ((((((($gfc)) + 39840|0) + (($1234*48)|0)|0)) + 8|0) + ($1232)|0);
      $1235 = HEAP8[$1233>>0]|0;
      $1236 = $1235&255;
      $1237 = $1231 | $1236;
      $1238 = $1237&255;
      HEAP8[$1233>>0] = $1238;
      $1239 = (($$0$$i399$1$i) + ($ptr$01$i398$1$i))|0;
      $1240 = ($1228|0)>(0);
      $$pre$i401$1$i = HEAP32[$17>>2]|0;
      if ($1240) {
       $$02$i397$1$i = $1228;$1234 = $$pre$i401$1$i;$ptr$01$i398$1$i = $1239;
      } else {
       $$lcssa428 = $1239;$$pre$i401$1$i$lcssa = $$pre$i401$1$i;
       break;
      }
     }
     $1241 = (((((($gfc)) + 39840|0) + (($$pre$i401$1$i$lcssa*48)|0)|0)) + 4|0);
     HEAP32[$1241>>2] = $$lcssa428;
     $1242 = (((((($gfc)) + 21328|0) + ($ch$0637$i<<4)|0)) + 8|0);
     $1243 = HEAP32[$1242>>2]|0;
     $$02$i397$2$i = 1;$1253 = $$pre$i401$1$i$lcssa;$ptr$01$i398$2$i = $$lcssa428;
     while(1) {
      $1244 = $ptr$01$i398$2$i & 7;
      $1245 = (8 - ($1244))|0;
      $1246 = ($$02$i397$2$i|0)<($1245|0);
      $$0$$i399$2$i = $1246 ? $$02$i397$2$i : $1245;
      $1247 = (($$02$i397$2$i) - ($$0$$i399$2$i))|0;
      $1248 = $1243 >> $1247;
      $1249 = (($1245) - ($$0$$i399$2$i))|0;
      $1250 = $1248 << $1249;
      $1251 = $ptr$01$i398$2$i >> 3;
      $1252 = ((((((($gfc)) + 39840|0) + (($1253*48)|0)|0)) + 8|0) + ($1251)|0);
      $1254 = HEAP8[$1252>>0]|0;
      $1255 = $1254&255;
      $1256 = $1250 | $1255;
      $1257 = $1256&255;
      HEAP8[$1252>>0] = $1257;
      $1258 = (($$0$$i399$2$i) + ($ptr$01$i398$2$i))|0;
      $1259 = ($1247|0)>(0);
      $$pre$i401$2$i = HEAP32[$17>>2]|0;
      if ($1259) {
       $$02$i397$2$i = $1247;$1253 = $$pre$i401$2$i;$ptr$01$i398$2$i = $1258;
      } else {
       $$lcssa429 = $1258;$$pre$i401$2$i$lcssa = $$pre$i401$2$i;
       break;
      }
     }
     $1260 = (((((($gfc)) + 39840|0) + (($$pre$i401$2$i$lcssa*48)|0)|0)) + 4|0);
     HEAP32[$1260>>2] = $$lcssa429;
     $1261 = (((((($gfc)) + 21328|0) + ($ch$0637$i<<4)|0)) + 12|0);
     $1262 = HEAP32[$1261>>2]|0;
     $$02$i397$3$i = 1;$1272 = $$pre$i401$2$i$lcssa;$ptr$01$i398$3$i = $$lcssa429;
     while(1) {
      $1263 = $ptr$01$i398$3$i & 7;
      $1264 = (8 - ($1263))|0;
      $1265 = ($$02$i397$3$i|0)<($1264|0);
      $$0$$i399$3$i = $1265 ? $$02$i397$3$i : $1264;
      $1266 = (($$02$i397$3$i) - ($$0$$i399$3$i))|0;
      $1267 = $1262 >> $1266;
      $1268 = (($1264) - ($$0$$i399$3$i))|0;
      $1269 = $1267 << $1268;
      $1270 = $ptr$01$i398$3$i >> 3;
      $1271 = ((((((($gfc)) + 39840|0) + (($1272*48)|0)|0)) + 8|0) + ($1270)|0);
      $1273 = HEAP8[$1271>>0]|0;
      $1274 = $1273&255;
      $1275 = $1269 | $1274;
      $1276 = $1275&255;
      HEAP8[$1271>>0] = $1276;
      $1277 = (($$0$$i399$3$i) + ($ptr$01$i398$3$i))|0;
      $1278 = ($1266|0)>(0);
      $$pre$i401$3$i = HEAP32[$17>>2]|0;
      if ($1278) {
       $$02$i397$3$i = $1266;$1272 = $$pre$i401$3$i;$ptr$01$i398$3$i = $1277;
      } else {
       $$lcssa430 = $1277;$$pre$i401$3$i$lcssa = $$pre$i401$3$i;
       break;
      }
     }
     $1279 = (((((($gfc)) + 39840|0) + (($$pre$i401$3$i$lcssa*48)|0)|0)) + 4|0);
     HEAP32[$1279>>2] = $$lcssa430;
     $1280 = (($ch$0637$i) + 1)|0;
     $1281 = HEAP32[$317>>2]|0;
     $1282 = ($1280|0)<($1281|0);
     if ($1282) {
      $1791 = $$lcssa430;$1792 = $$pre$i401$3$i$lcssa;$ch$0637$i = $1280;
     } else {
      $379 = $1281;$381 = $$pre$i401$3$i$lcssa;$gr$0634$i = 0;
      break;
     }
    }
   } else {
    $379 = $356;$381 = $1790;$gr$0634$i = 0;
   }
   while(1) {
    $380 = ($379|0)>(0);
    if ($380) {
     $$phi$trans$insert736$i = (((((($gfc)) + 39840|0) + (($381*48)|0)|0)) + 4|0);
     $$pre737$i = HEAP32[$$phi$trans$insert736$i>>2]|0;
     $1795 = $$pre737$i;$1796 = $381;$ch$1632$i = 0;
     while(1) {
      $382 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4768|0);
      $383 = HEAP32[$382>>2]|0;
      $384 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4844|0);
      $385 = HEAP32[$384>>2]|0;
      $386 = (($385) + ($383))|0;
      $$02$i387$i = 12;$396 = $1796;$ptr$01$i388$i = $1795;
      while(1) {
       $387 = $ptr$01$i388$i & 7;
       $388 = (8 - ($387))|0;
       $389 = ($$02$i387$i|0)<($388|0);
       $$0$$i389$i = $389 ? $$02$i387$i : $388;
       $390 = (($$02$i387$i) - ($$0$$i389$i))|0;
       $391 = $386 >> $390;
       $392 = (($388) - ($$0$$i389$i))|0;
       $393 = $391 << $392;
       $394 = $ptr$01$i388$i >> 3;
       $395 = ((((((($gfc)) + 39840|0) + (($396*48)|0)|0)) + 8|0) + ($394)|0);
       $397 = HEAP8[$395>>0]|0;
       $398 = $397&255;
       $399 = $393 | $398;
       $400 = $399&255;
       HEAP8[$395>>0] = $400;
       $401 = (($$0$$i389$i) + ($ptr$01$i388$i))|0;
       $402 = ($390|0)>(0);
       $$pre$i391$i = HEAP32[$17>>2]|0;
       if ($402) {
        $$02$i387$i = $390;$396 = $$pre$i391$i;$ptr$01$i388$i = $401;
       } else {
        $$lcssa404 = $401;$$pre$i391$i$lcssa = $$pre$i391$i;
        break;
       }
      }
      $403 = (((((($gfc)) + 39840|0) + (($$pre$i391$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$403>>2] = $$lcssa404;
      $404 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4772|0);
      $405 = HEAP32[$404>>2]|0;
      $406 = (($405|0) / 2)&-1;
      $$02$i377$i = 9;$416 = $$pre$i391$i$lcssa;$ptr$01$i378$i = $$lcssa404;
      while(1) {
       $407 = $ptr$01$i378$i & 7;
       $408 = (8 - ($407))|0;
       $409 = ($$02$i377$i|0)<($408|0);
       $$0$$i379$i = $409 ? $$02$i377$i : $408;
       $410 = (($$02$i377$i) - ($$0$$i379$i))|0;
       $411 = $406 >> $410;
       $412 = (($408) - ($$0$$i379$i))|0;
       $413 = $411 << $412;
       $414 = $ptr$01$i378$i >> 3;
       $415 = ((((((($gfc)) + 39840|0) + (($416*48)|0)|0)) + 8|0) + ($414)|0);
       $417 = HEAP8[$415>>0]|0;
       $418 = $417&255;
       $419 = $413 | $418;
       $420 = $419&255;
       HEAP8[$415>>0] = $420;
       $421 = (($$0$$i379$i) + ($ptr$01$i378$i))|0;
       $422 = ($410|0)>(0);
       $$pre$i381$i = HEAP32[$17>>2]|0;
       if ($422) {
        $$02$i377$i = $410;$416 = $$pre$i381$i;$ptr$01$i378$i = $421;
       } else {
        $$lcssa405 = $421;$$pre$i381$i$lcssa = $$pre$i381$i;
        break;
       }
      }
      $423 = (((((($gfc)) + 39840|0) + (($$pre$i381$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$423>>2] = $$lcssa405;
      $424 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4780|0);
      $425 = HEAP32[$424>>2]|0;
      $$02$i367$i = 8;$435 = $$pre$i381$i$lcssa;$ptr$01$i368$i = $$lcssa405;
      while(1) {
       $426 = $ptr$01$i368$i & 7;
       $427 = (8 - ($426))|0;
       $428 = ($$02$i367$i|0)<($427|0);
       $$0$$i369$i = $428 ? $$02$i367$i : $427;
       $429 = (($$02$i367$i) - ($$0$$i369$i))|0;
       $430 = $425 >> $429;
       $431 = (($427) - ($$0$$i369$i))|0;
       $432 = $430 << $431;
       $433 = $ptr$01$i368$i >> 3;
       $434 = ((((((($gfc)) + 39840|0) + (($435*48)|0)|0)) + 8|0) + ($433)|0);
       $436 = HEAP8[$434>>0]|0;
       $437 = $436&255;
       $438 = $432 | $437;
       $439 = $438&255;
       HEAP8[$434>>0] = $439;
       $440 = (($$0$$i369$i) + ($ptr$01$i368$i))|0;
       $441 = ($429|0)>(0);
       $$pre$i371$i = HEAP32[$17>>2]|0;
       if ($441) {
        $$02$i367$i = $429;$435 = $$pre$i371$i;$ptr$01$i368$i = $440;
       } else {
        $$lcssa406 = $440;$$pre$i371$i$lcssa = $$pre$i371$i;
        break;
       }
      }
      $442 = (((((($gfc)) + 39840|0) + (($$pre$i371$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$442>>2] = $$lcssa406;
      $443 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4784|0);
      $444 = HEAP32[$443>>2]|0;
      $$02$i357$i = 4;$454 = $$pre$i371$i$lcssa;$ptr$01$i358$i = $$lcssa406;
      while(1) {
       $445 = $ptr$01$i358$i & 7;
       $446 = (8 - ($445))|0;
       $447 = ($$02$i357$i|0)<($446|0);
       $$0$$i359$i = $447 ? $$02$i357$i : $446;
       $448 = (($$02$i357$i) - ($$0$$i359$i))|0;
       $449 = $444 >> $448;
       $450 = (($446) - ($$0$$i359$i))|0;
       $451 = $449 << $450;
       $452 = $ptr$01$i358$i >> 3;
       $453 = ((((((($gfc)) + 39840|0) + (($454*48)|0)|0)) + 8|0) + ($452)|0);
       $455 = HEAP8[$453>>0]|0;
       $456 = $455&255;
       $457 = $451 | $456;
       $458 = $457&255;
       HEAP8[$453>>0] = $458;
       $459 = (($$0$$i359$i) + ($ptr$01$i358$i))|0;
       $460 = ($448|0)>(0);
       $$pre$i361$i = HEAP32[$17>>2]|0;
       if ($460) {
        $$02$i357$i = $448;$454 = $$pre$i361$i;$ptr$01$i358$i = $459;
       } else {
        $$lcssa407 = $459;$$pre$i361$i$lcssa = $$pre$i361$i;
        break;
       }
      }
      $461 = (((((($gfc)) + 39840|0) + (($$pre$i361$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$461>>2] = $$lcssa407;
      $462 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4788|0);
      $463 = HEAP32[$462>>2]|0;
      $464 = ($463|0)==(0);
      if ($464) {
       $$02$i267$i = 1;$ptr$01$i268$i = $$lcssa407;
       while(1) {
        $618 = $ptr$01$i268$i & 7;
        $619 = (8 - ($618))|0;
        $620 = ($$02$i267$i|0)<($619|0);
        $$0$$i269$i = $620 ? $$02$i267$i : $619;
        $621 = (($$02$i267$i) - ($$0$$i269$i))|0;
        $622 = (($$0$$i269$i) + ($ptr$01$i268$i))|0;
        $623 = ($621|0)>(0);
        if ($623) {
         $$02$i267$i = $621;$ptr$01$i268$i = $622;
        } else {
         $$lcssa416 = $622;
         break;
        }
       }
       HEAP32[$461>>2] = $$lcssa416;
       $624 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4796|0);
       $625 = HEAP32[$624>>2]|0;
       $626 = ($625|0)==(14);
       if ($626) {
        HEAP32[$624>>2] = 16;
        $$pre725$i = HEAP32[$17>>2]|0;
        $$phi$trans$insert726$i = (((((($gfc)) + 39840|0) + (($$pre725$i*48)|0)|0)) + 4|0);
        $$pre727$i = HEAP32[$$phi$trans$insert726$i>>2]|0;
        $1803 = $$pre727$i;$1804 = $$pre725$i;$632 = 16;
       } else {
        $1803 = $$lcssa416;$1804 = $$pre$i361$i$lcssa;$632 = $625;
       }
       $$02$i257$i = 5;$637 = $1804;$ptr$01$i258$i = $1803;
       while(1) {
        $627 = $ptr$01$i258$i & 7;
        $628 = (8 - ($627))|0;
        $629 = ($$02$i257$i|0)<($628|0);
        $$0$$i259$i = $629 ? $$02$i257$i : $628;
        $630 = (($$02$i257$i) - ($$0$$i259$i))|0;
        $631 = $632 >> $630;
        $633 = (($628) - ($$0$$i259$i))|0;
        $634 = $631 << $633;
        $635 = $ptr$01$i258$i >> 3;
        $636 = ((((((($gfc)) + 39840|0) + (($637*48)|0)|0)) + 8|0) + ($635)|0);
        $638 = HEAP8[$636>>0]|0;
        $639 = $638&255;
        $640 = $634 | $639;
        $641 = $640&255;
        HEAP8[$636>>0] = $641;
        $642 = (($$0$$i259$i) + ($ptr$01$i258$i))|0;
        $643 = ($630|0)>(0);
        $$pre$i261$i = HEAP32[$17>>2]|0;
        if ($643) {
         $$02$i257$i = $630;$637 = $$pre$i261$i;$ptr$01$i258$i = $642;
        } else {
         $$lcssa417 = $642;$$pre$i261$i$lcssa = $$pre$i261$i;
         break;
        }
       }
       $644 = (((((($gfc)) + 39840|0) + (($$pre$i261$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$644>>2] = $$lcssa417;
       $645 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4800|0);
       $646 = HEAP32[$645>>2]|0;
       $647 = ($646|0)==(14);
       if ($647) {
        HEAP32[$645>>2] = 16;
        $$pre728$i = HEAP32[$17>>2]|0;
        $$phi$trans$insert729$i = (((((($gfc)) + 39840|0) + (($$pre728$i*48)|0)|0)) + 4|0);
        $$pre730$i = HEAP32[$$phi$trans$insert729$i>>2]|0;
        $1805 = $$pre730$i;$1806 = $$pre728$i;$653 = 16;
       } else {
        $1805 = $$lcssa417;$1806 = $$pre$i261$i$lcssa;$653 = $646;
       }
       $$02$i247$i = 5;$658 = $1806;$ptr$01$i248$i = $1805;
       while(1) {
        $648 = $ptr$01$i248$i & 7;
        $649 = (8 - ($648))|0;
        $650 = ($$02$i247$i|0)<($649|0);
        $$0$$i249$i = $650 ? $$02$i247$i : $649;
        $651 = (($$02$i247$i) - ($$0$$i249$i))|0;
        $652 = $653 >> $651;
        $654 = (($649) - ($$0$$i249$i))|0;
        $655 = $652 << $654;
        $656 = $ptr$01$i248$i >> 3;
        $657 = ((((((($gfc)) + 39840|0) + (($658*48)|0)|0)) + 8|0) + ($656)|0);
        $659 = HEAP8[$657>>0]|0;
        $660 = $659&255;
        $661 = $655 | $660;
        $662 = $661&255;
        HEAP8[$657>>0] = $662;
        $663 = (($$0$$i249$i) + ($ptr$01$i248$i))|0;
        $664 = ($651|0)>(0);
        $$pre$i251$i = HEAP32[$17>>2]|0;
        if ($664) {
         $$02$i247$i = $651;$658 = $$pre$i251$i;$ptr$01$i248$i = $663;
        } else {
         $$lcssa418 = $663;$$pre$i251$i$lcssa = $$pre$i251$i;
         break;
        }
       }
       $665 = (((((($gfc)) + 39840|0) + (($$pre$i251$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$665>>2] = $$lcssa418;
       $666 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4804|0);
       $667 = HEAP32[$666>>2]|0;
       $668 = ($667|0)==(14);
       if ($668) {
        HEAP32[$666>>2] = 16;
        $$pre731$i = HEAP32[$17>>2]|0;
        $$phi$trans$insert732$i = (((((($gfc)) + 39840|0) + (($$pre731$i*48)|0)|0)) + 4|0);
        $$pre733$i = HEAP32[$$phi$trans$insert732$i>>2]|0;
        $1807 = $$pre733$i;$1808 = $$pre731$i;$674 = 16;
       } else {
        $1807 = $$lcssa418;$1808 = $$pre$i251$i$lcssa;$674 = $667;
       }
       $$02$i237$i = 5;$679 = $1808;$ptr$01$i238$i = $1807;
       while(1) {
        $669 = $ptr$01$i238$i & 7;
        $670 = (8 - ($669))|0;
        $671 = ($$02$i237$i|0)<($670|0);
        $$0$$i239$i = $671 ? $$02$i237$i : $670;
        $672 = (($$02$i237$i) - ($$0$$i239$i))|0;
        $673 = $674 >> $672;
        $675 = (($670) - ($$0$$i239$i))|0;
        $676 = $673 << $675;
        $677 = $ptr$01$i238$i >> 3;
        $678 = ((((((($gfc)) + 39840|0) + (($679*48)|0)|0)) + 8|0) + ($677)|0);
        $680 = HEAP8[$678>>0]|0;
        $681 = $680&255;
        $682 = $676 | $681;
        $683 = $682&255;
        HEAP8[$678>>0] = $683;
        $684 = (($$0$$i239$i) + ($ptr$01$i238$i))|0;
        $685 = ($672|0)>(0);
        $$pre$i241$i = HEAP32[$17>>2]|0;
        if ($685) {
         $$02$i237$i = $672;$679 = $$pre$i241$i;$ptr$01$i238$i = $684;
        } else {
         $$lcssa419 = $684;$$pre$i241$i$lcssa = $$pre$i241$i;
         break;
        }
       }
       $686 = (((((($gfc)) + 39840|0) + (($$pre$i241$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$686>>2] = $$lcssa419;
       $687 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4824|0);
       $688 = HEAP32[$687>>2]|0;
       $$02$i227$i = 4;$698 = $$pre$i241$i$lcssa;$ptr$01$i228$i = $$lcssa419;
       while(1) {
        $689 = $ptr$01$i228$i & 7;
        $690 = (8 - ($689))|0;
        $691 = ($$02$i227$i|0)<($690|0);
        $$0$$i229$i = $691 ? $$02$i227$i : $690;
        $692 = (($$02$i227$i) - ($$0$$i229$i))|0;
        $693 = $688 >> $692;
        $694 = (($690) - ($$0$$i229$i))|0;
        $695 = $693 << $694;
        $696 = $ptr$01$i228$i >> 3;
        $697 = ((((((($gfc)) + 39840|0) + (($698*48)|0)|0)) + 8|0) + ($696)|0);
        $699 = HEAP8[$697>>0]|0;
        $700 = $699&255;
        $701 = $695 | $700;
        $702 = $701&255;
        HEAP8[$697>>0] = $702;
        $703 = (($$0$$i229$i) + ($ptr$01$i228$i))|0;
        $704 = ($692|0)>(0);
        $$pre$i231$i = HEAP32[$17>>2]|0;
        if ($704) {
         $$02$i227$i = $692;$698 = $$pre$i231$i;$ptr$01$i228$i = $703;
        } else {
         $$lcssa420 = $703;$$pre$i231$i$lcssa = $$pre$i231$i;
         break;
        }
       }
       $705 = (((((($gfc)) + 39840|0) + (($$pre$i231$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$705>>2] = $$lcssa420;
       $706 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4828|0);
       $707 = HEAP32[$706>>2]|0;
       $$02$i217$i = 3;$717 = $$pre$i231$i$lcssa;$ptr$01$i218$i = $$lcssa420;
       while(1) {
        $708 = $ptr$01$i218$i & 7;
        $709 = (8 - ($708))|0;
        $710 = ($$02$i217$i|0)<($709|0);
        $$0$$i219$i = $710 ? $$02$i217$i : $709;
        $711 = (($$02$i217$i) - ($$0$$i219$i))|0;
        $712 = $707 >> $711;
        $713 = (($709) - ($$0$$i219$i))|0;
        $714 = $712 << $713;
        $715 = $ptr$01$i218$i >> 3;
        $716 = ((((((($gfc)) + 39840|0) + (($717*48)|0)|0)) + 8|0) + ($715)|0);
        $718 = HEAP8[$716>>0]|0;
        $719 = $718&255;
        $720 = $714 | $719;
        $721 = $720&255;
        HEAP8[$716>>0] = $721;
        $722 = (($$0$$i219$i) + ($ptr$01$i218$i))|0;
        $723 = ($711|0)>(0);
        $$pre$i221$i = HEAP32[$17>>2]|0;
        if ($723) {
         $$02$i217$i = $711;$717 = $$pre$i221$i;$ptr$01$i218$i = $722;
        } else {
         $$lcssa421 = $722;$$pre$i221$i$lcssa = $$pre$i221$i;
         break;
        }
       }
       $724 = (((((($gfc)) + 39840|0) + (($$pre$i221$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$724>>2] = $$lcssa421;
       $1801 = $$lcssa421;$1802 = $$pre$i221$i$lcssa;
      } else {
       $$02$i347$i = 1;$474 = $$pre$i361$i$lcssa;$ptr$01$i348$i = $$lcssa407;
       while(1) {
        $465 = $ptr$01$i348$i & 7;
        $466 = (8 - ($465))|0;
        $467 = ($$02$i347$i|0)<($466|0);
        $$0$$i349$i = $467 ? $$02$i347$i : $466;
        $468 = (($$02$i347$i) - ($$0$$i349$i))|0;
        $469 = 1 >>> $468;
        $470 = (($466) - ($$0$$i349$i))|0;
        $471 = $469 << $470;
        $472 = $ptr$01$i348$i >> 3;
        $473 = ((((((($gfc)) + 39840|0) + (($474*48)|0)|0)) + 8|0) + ($472)|0);
        $475 = HEAP8[$473>>0]|0;
        $476 = $475&255;
        $477 = $471 | $476;
        $478 = $477&255;
        HEAP8[$473>>0] = $478;
        $479 = (($$0$$i349$i) + ($ptr$01$i348$i))|0;
        $480 = ($468|0)>(0);
        $$pre$i351$i = HEAP32[$17>>2]|0;
        if ($480) {
         $$02$i347$i = $468;$474 = $$pre$i351$i;$ptr$01$i348$i = $479;
        } else {
         $$lcssa408 = $479;$$pre$i351$i$lcssa = $$pre$i351$i;
         break;
        }
       }
       $481 = (((((($gfc)) + 39840|0) + (($$pre$i351$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$481>>2] = $$lcssa408;
       $482 = HEAP32[$462>>2]|0;
       $$02$i337$i = 2;$492 = $$pre$i351$i$lcssa;$ptr$01$i338$i = $$lcssa408;
       while(1) {
        $483 = $ptr$01$i338$i & 7;
        $484 = (8 - ($483))|0;
        $485 = ($$02$i337$i|0)<($484|0);
        $$0$$i339$i = $485 ? $$02$i337$i : $484;
        $486 = (($$02$i337$i) - ($$0$$i339$i))|0;
        $487 = $482 >> $486;
        $488 = (($484) - ($$0$$i339$i))|0;
        $489 = $487 << $488;
        $490 = $ptr$01$i338$i >> 3;
        $491 = ((((((($gfc)) + 39840|0) + (($492*48)|0)|0)) + 8|0) + ($490)|0);
        $493 = HEAP8[$491>>0]|0;
        $494 = $493&255;
        $495 = $489 | $494;
        $496 = $495&255;
        HEAP8[$491>>0] = $496;
        $497 = (($$0$$i339$i) + ($ptr$01$i338$i))|0;
        $498 = ($486|0)>(0);
        $$pre$i341$i = HEAP32[$17>>2]|0;
        if ($498) {
         $$02$i337$i = $486;$492 = $$pre$i341$i;$ptr$01$i338$i = $497;
        } else {
         $$lcssa409 = $497;$$pre$i341$i$lcssa = $$pre$i341$i;
         break;
        }
       }
       $499 = (((((($gfc)) + 39840|0) + (($$pre$i341$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$499>>2] = $$lcssa409;
       $500 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4792|0);
       $501 = HEAP32[$500>>2]|0;
       $$02$i327$i = 1;$511 = $$pre$i341$i$lcssa;$ptr$01$i328$i = $$lcssa409;
       while(1) {
        $502 = $ptr$01$i328$i & 7;
        $503 = (8 - ($502))|0;
        $504 = ($$02$i327$i|0)<($503|0);
        $$0$$i329$i = $504 ? $$02$i327$i : $503;
        $505 = (($$02$i327$i) - ($$0$$i329$i))|0;
        $506 = $501 >> $505;
        $507 = (($503) - ($$0$$i329$i))|0;
        $508 = $506 << $507;
        $509 = $ptr$01$i328$i >> 3;
        $510 = ((((((($gfc)) + 39840|0) + (($511*48)|0)|0)) + 8|0) + ($509)|0);
        $512 = HEAP8[$510>>0]|0;
        $513 = $512&255;
        $514 = $508 | $513;
        $515 = $514&255;
        HEAP8[$510>>0] = $515;
        $516 = (($$0$$i329$i) + ($ptr$01$i328$i))|0;
        $517 = ($505|0)>(0);
        $$pre$i331$i = HEAP32[$17>>2]|0;
        if ($517) {
         $$02$i327$i = $505;$511 = $$pre$i331$i;$ptr$01$i328$i = $516;
        } else {
         $$lcssa410 = $516;$$pre$i331$i$lcssa = $$pre$i331$i;
         break;
        }
       }
       $518 = (((((($gfc)) + 39840|0) + (($$pre$i331$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$518>>2] = $$lcssa410;
       $519 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4796|0);
       $520 = HEAP32[$519>>2]|0;
       $521 = ($520|0)==(14);
       if ($521) {
        HEAP32[$519>>2] = 16;
        $$pre719$i = HEAP32[$17>>2]|0;
        $$phi$trans$insert720$i = (((((($gfc)) + 39840|0) + (($$pre719$i*48)|0)|0)) + 4|0);
        $$pre721$i = HEAP32[$$phi$trans$insert720$i>>2]|0;
        $1797 = $$pre721$i;$1798 = $$pre719$i;$527 = 16;
       } else {
        $1797 = $$lcssa410;$1798 = $$pre$i331$i$lcssa;$527 = $520;
       }
       $$02$i317$i = 5;$532 = $1798;$ptr$01$i318$i = $1797;
       while(1) {
        $522 = $ptr$01$i318$i & 7;
        $523 = (8 - ($522))|0;
        $524 = ($$02$i317$i|0)<($523|0);
        $$0$$i319$i = $524 ? $$02$i317$i : $523;
        $525 = (($$02$i317$i) - ($$0$$i319$i))|0;
        $526 = $527 >> $525;
        $528 = (($523) - ($$0$$i319$i))|0;
        $529 = $526 << $528;
        $530 = $ptr$01$i318$i >> 3;
        $531 = ((((((($gfc)) + 39840|0) + (($532*48)|0)|0)) + 8|0) + ($530)|0);
        $533 = HEAP8[$531>>0]|0;
        $534 = $533&255;
        $535 = $529 | $534;
        $536 = $535&255;
        HEAP8[$531>>0] = $536;
        $537 = (($$0$$i319$i) + ($ptr$01$i318$i))|0;
        $538 = ($525|0)>(0);
        $$pre$i321$i = HEAP32[$17>>2]|0;
        if ($538) {
         $$02$i317$i = $525;$532 = $$pre$i321$i;$ptr$01$i318$i = $537;
        } else {
         $$lcssa411 = $537;$$pre$i321$i$lcssa = $$pre$i321$i;
         break;
        }
       }
       $539 = (((((($gfc)) + 39840|0) + (($$pre$i321$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$539>>2] = $$lcssa411;
       $540 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4800|0);
       $541 = HEAP32[$540>>2]|0;
       $542 = ($541|0)==(14);
       if ($542) {
        HEAP32[$540>>2] = 16;
        $$pre722$i = HEAP32[$17>>2]|0;
        $$phi$trans$insert723$i = (((((($gfc)) + 39840|0) + (($$pre722$i*48)|0)|0)) + 4|0);
        $$pre724$i = HEAP32[$$phi$trans$insert723$i>>2]|0;
        $1799 = $$pre724$i;$1800 = $$pre722$i;$548 = 16;
       } else {
        $1799 = $$lcssa411;$1800 = $$pre$i321$i$lcssa;$548 = $541;
       }
       $$02$i307$i = 5;$553 = $1800;$ptr$01$i308$i = $1799;
       while(1) {
        $543 = $ptr$01$i308$i & 7;
        $544 = (8 - ($543))|0;
        $545 = ($$02$i307$i|0)<($544|0);
        $$0$$i309$i = $545 ? $$02$i307$i : $544;
        $546 = (($$02$i307$i) - ($$0$$i309$i))|0;
        $547 = $548 >> $546;
        $549 = (($544) - ($$0$$i309$i))|0;
        $550 = $547 << $549;
        $551 = $ptr$01$i308$i >> 3;
        $552 = ((((((($gfc)) + 39840|0) + (($553*48)|0)|0)) + 8|0) + ($551)|0);
        $554 = HEAP8[$552>>0]|0;
        $555 = $554&255;
        $556 = $550 | $555;
        $557 = $556&255;
        HEAP8[$552>>0] = $557;
        $558 = (($$0$$i309$i) + ($ptr$01$i308$i))|0;
        $559 = ($546|0)>(0);
        $$pre$i311$i = HEAP32[$17>>2]|0;
        if ($559) {
         $$02$i307$i = $546;$553 = $$pre$i311$i;$ptr$01$i308$i = $558;
        } else {
         $$lcssa412 = $558;$$pre$i311$i$lcssa = $$pre$i311$i;
         break;
        }
       }
       $560 = (((((($gfc)) + 39840|0) + (($$pre$i311$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$560>>2] = $$lcssa412;
       $561 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4808|0);
       $562 = HEAP32[$561>>2]|0;
       $$02$i297$i = 3;$572 = $$pre$i311$i$lcssa;$ptr$01$i298$i = $$lcssa412;
       while(1) {
        $563 = $ptr$01$i298$i & 7;
        $564 = (8 - ($563))|0;
        $565 = ($$02$i297$i|0)<($564|0);
        $$0$$i299$i = $565 ? $$02$i297$i : $564;
        $566 = (($$02$i297$i) - ($$0$$i299$i))|0;
        $567 = $562 >> $566;
        $568 = (($564) - ($$0$$i299$i))|0;
        $569 = $567 << $568;
        $570 = $ptr$01$i298$i >> 3;
        $571 = ((((((($gfc)) + 39840|0) + (($572*48)|0)|0)) + 8|0) + ($570)|0);
        $573 = HEAP8[$571>>0]|0;
        $574 = $573&255;
        $575 = $569 | $574;
        $576 = $575&255;
        HEAP8[$571>>0] = $576;
        $577 = (($$0$$i299$i) + ($ptr$01$i298$i))|0;
        $578 = ($566|0)>(0);
        $$pre$i301$i = HEAP32[$17>>2]|0;
        if ($578) {
         $$02$i297$i = $566;$572 = $$pre$i301$i;$ptr$01$i298$i = $577;
        } else {
         $$lcssa413 = $577;$$pre$i301$i$lcssa = $$pre$i301$i;
         break;
        }
       }
       $579 = (((((($gfc)) + 39840|0) + (($$pre$i301$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$579>>2] = $$lcssa413;
       $580 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4812|0);
       $581 = HEAP32[$580>>2]|0;
       $$02$i287$i = 3;$591 = $$pre$i301$i$lcssa;$ptr$01$i288$i = $$lcssa413;
       while(1) {
        $582 = $ptr$01$i288$i & 7;
        $583 = (8 - ($582))|0;
        $584 = ($$02$i287$i|0)<($583|0);
        $$0$$i289$i = $584 ? $$02$i287$i : $583;
        $585 = (($$02$i287$i) - ($$0$$i289$i))|0;
        $586 = $581 >> $585;
        $587 = (($583) - ($$0$$i289$i))|0;
        $588 = $586 << $587;
        $589 = $ptr$01$i288$i >> 3;
        $590 = ((((((($gfc)) + 39840|0) + (($591*48)|0)|0)) + 8|0) + ($589)|0);
        $592 = HEAP8[$590>>0]|0;
        $593 = $592&255;
        $594 = $588 | $593;
        $595 = $594&255;
        HEAP8[$590>>0] = $595;
        $596 = (($$0$$i289$i) + ($ptr$01$i288$i))|0;
        $597 = ($585|0)>(0);
        $$pre$i291$i = HEAP32[$17>>2]|0;
        if ($597) {
         $$02$i287$i = $585;$591 = $$pre$i291$i;$ptr$01$i288$i = $596;
        } else {
         $$lcssa414 = $596;$$pre$i291$i$lcssa = $$pre$i291$i;
         break;
        }
       }
       $598 = (((((($gfc)) + 39840|0) + (($$pre$i291$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$598>>2] = $$lcssa414;
       $599 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4816|0);
       $600 = HEAP32[$599>>2]|0;
       $$02$i277$i = 3;$610 = $$pre$i291$i$lcssa;$ptr$01$i278$i = $$lcssa414;
       while(1) {
        $601 = $ptr$01$i278$i & 7;
        $602 = (8 - ($601))|0;
        $603 = ($$02$i277$i|0)<($602|0);
        $$0$$i279$i = $603 ? $$02$i277$i : $602;
        $604 = (($$02$i277$i) - ($$0$$i279$i))|0;
        $605 = $600 >> $604;
        $606 = (($602) - ($$0$$i279$i))|0;
        $607 = $605 << $606;
        $608 = $ptr$01$i278$i >> 3;
        $609 = ((((((($gfc)) + 39840|0) + (($610*48)|0)|0)) + 8|0) + ($608)|0);
        $611 = HEAP8[$609>>0]|0;
        $612 = $611&255;
        $613 = $607 | $612;
        $614 = $613&255;
        HEAP8[$609>>0] = $614;
        $615 = (($$0$$i279$i) + ($ptr$01$i278$i))|0;
        $616 = ($604|0)>(0);
        $$pre$i281$i = HEAP32[$17>>2]|0;
        if ($616) {
         $$02$i277$i = $604;$610 = $$pre$i281$i;$ptr$01$i278$i = $615;
        } else {
         $$lcssa415 = $615;$$pre$i281$i$lcssa = $$pre$i281$i;
         break;
        }
       }
       $617 = (((((($gfc)) + 39840|0) + (($$pre$i281$i$lcssa*48)|0)|0)) + 4|0);
       HEAP32[$617>>2] = $$lcssa415;
       $1801 = $$lcssa415;$1802 = $$pre$i281$i$lcssa;
      }
      $725 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4832|0);
      $726 = HEAP32[$725>>2]|0;
      $$02$i207$i = 1;$736 = $1802;$ptr$01$i208$i = $1801;
      while(1) {
       $727 = $ptr$01$i208$i & 7;
       $728 = (8 - ($727))|0;
       $729 = ($$02$i207$i|0)<($728|0);
       $$0$$i209$i = $729 ? $$02$i207$i : $728;
       $730 = (($$02$i207$i) - ($$0$$i209$i))|0;
       $731 = $726 >> $730;
       $732 = (($728) - ($$0$$i209$i))|0;
       $733 = $731 << $732;
       $734 = $ptr$01$i208$i >> 3;
       $735 = ((((((($gfc)) + 39840|0) + (($736*48)|0)|0)) + 8|0) + ($734)|0);
       $737 = HEAP8[$735>>0]|0;
       $738 = $737&255;
       $739 = $733 | $738;
       $740 = $739&255;
       HEAP8[$735>>0] = $740;
       $741 = (($$0$$i209$i) + ($ptr$01$i208$i))|0;
       $742 = ($730|0)>(0);
       $$pre$i211$i = HEAP32[$17>>2]|0;
       if ($742) {
        $$02$i207$i = $730;$736 = $$pre$i211$i;$ptr$01$i208$i = $741;
       } else {
        $$lcssa422 = $741;$$pre$i211$i$lcssa = $$pre$i211$i;
        break;
       }
      }
      $743 = (((((($gfc)) + 39840|0) + (($$pre$i211$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$743>>2] = $$lcssa422;
      $744 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4836|0);
      $745 = HEAP32[$744>>2]|0;
      $$02$i197$i = 1;$755 = $$pre$i211$i$lcssa;$ptr$01$i198$i = $$lcssa422;
      while(1) {
       $746 = $ptr$01$i198$i & 7;
       $747 = (8 - ($746))|0;
       $748 = ($$02$i197$i|0)<($747|0);
       $$0$$i199$i = $748 ? $$02$i197$i : $747;
       $749 = (($$02$i197$i) - ($$0$$i199$i))|0;
       $750 = $745 >> $749;
       $751 = (($747) - ($$0$$i199$i))|0;
       $752 = $750 << $751;
       $753 = $ptr$01$i198$i >> 3;
       $754 = ((((((($gfc)) + 39840|0) + (($755*48)|0)|0)) + 8|0) + ($753)|0);
       $756 = HEAP8[$754>>0]|0;
       $757 = $756&255;
       $758 = $752 | $757;
       $759 = $758&255;
       HEAP8[$754>>0] = $759;
       $760 = (($$0$$i199$i) + ($ptr$01$i198$i))|0;
       $761 = ($749|0)>(0);
       $$pre$i201$i = HEAP32[$17>>2]|0;
       if ($761) {
        $$02$i197$i = $749;$755 = $$pre$i201$i;$ptr$01$i198$i = $760;
       } else {
        $$lcssa423 = $760;$$pre$i201$i$lcssa = $$pre$i201$i;
        break;
       }
      }
      $762 = (((((($gfc)) + 39840|0) + (($$pre$i201$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$762>>2] = $$lcssa423;
      $763 = ((((((($gfc)) + 304|0) + (($gr$0634$i*10504)|0)|0) + (($ch$1632$i*5252)|0)|0)) + 4840|0);
      $764 = HEAP32[$763>>2]|0;
      $$02$i187$i = 1;$774 = $$pre$i201$i$lcssa;$ptr$01$i188$i = $$lcssa423;
      while(1) {
       $765 = $ptr$01$i188$i & 7;
       $766 = (8 - ($765))|0;
       $767 = ($$02$i187$i|0)<($766|0);
       $$0$$i189$i = $767 ? $$02$i187$i : $766;
       $768 = (($$02$i187$i) - ($$0$$i189$i))|0;
       $769 = $764 >> $768;
       $770 = (($766) - ($$0$$i189$i))|0;
       $771 = $769 << $770;
       $772 = $ptr$01$i188$i >> 3;
       $773 = ((((((($gfc)) + 39840|0) + (($774*48)|0)|0)) + 8|0) + ($772)|0);
       $775 = HEAP8[$773>>0]|0;
       $776 = $775&255;
       $777 = $771 | $776;
       $778 = $777&255;
       HEAP8[$773>>0] = $778;
       $779 = (($$0$$i189$i) + ($ptr$01$i188$i))|0;
       $780 = ($768|0)>(0);
       $$pre$i191$i = HEAP32[$17>>2]|0;
       if ($780) {
        $$02$i187$i = $768;$774 = $$pre$i191$i;$ptr$01$i188$i = $779;
       } else {
        $$lcssa424 = $779;$$pre$i191$i$lcssa = $$pre$i191$i;
        break;
       }
      }
      $781 = (((((($gfc)) + 39840|0) + (($$pre$i191$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$781>>2] = $$lcssa424;
      $782 = (($ch$1632$i) + 1)|0;
      $783 = HEAP32[$317>>2]|0;
      $784 = ($782|0)<($783|0);
      if ($784) {
       $1795 = $$lcssa424;$1796 = $$pre$i191$i$lcssa;$ch$1632$i = $782;
      } else {
       $1793 = $$pre$i191$i$lcssa;$1794 = $783;
       break;
      }
     }
    } else {
     $1793 = $381;$1794 = $379;
    }
    $785 = (($gr$0634$i) + 1)|0;
    $exitcond$i = ($785|0)==(2);
    if ($exitcond$i) {
     $1213 = $1793;
     break;
    } else {
     $379 = $1794;$381 = $1793;$gr$0634$i = $785;
    }
   }
  } else {
   $$02$i177$i = 8;$795 = $$pre$i451$i$lcssa;$ptr$01$i178$i = $1789;
   while(1) {
    $786 = $ptr$01$i178$i & 7;
    $787 = (8 - ($786))|0;
    $788 = ($$02$i177$i|0)<($787|0);
    $$0$$i179$i = $788 ? $$02$i177$i : $787;
    $789 = (($$02$i177$i) - ($$0$$i179$i))|0;
    $790 = $299 >> $789;
    $791 = (($787) - ($$0$$i179$i))|0;
    $792 = $790 << $791;
    $793 = $ptr$01$i178$i >> 3;
    $794 = ((((((($gfc)) + 39840|0) + (($795*48)|0)|0)) + 8|0) + ($793)|0);
    $796 = HEAP8[$794>>0]|0;
    $797 = $796&255;
    $798 = $792 | $797;
    $799 = $798&255;
    HEAP8[$794>>0] = $799;
    $800 = (($$0$$i179$i) + ($ptr$01$i178$i))|0;
    $801 = ($789|0)>(0);
    $$pre$i181$i = HEAP32[$17>>2]|0;
    if ($801) {
     $$02$i177$i = $789;$795 = $$pre$i181$i;$ptr$01$i178$i = $800;
    } else {
     $$lcssa456 = $800;$$pre$i181$i$lcssa = $$pre$i181$i;
     break;
    }
   }
   $802 = (((((($gfc)) + 39840|0) + (($$pre$i181$i$lcssa*48)|0)|0)) + 4|0);
   HEAP32[$802>>2] = $$lcssa456;
   $803 = ((($gfc)) + 21316|0);
   $804 = HEAP32[$803>>2]|0;
   $805 = ((($gfc)) + 72|0);
   $806 = HEAP32[$805>>2]|0;
   $807 = ($806|0)>(0);
   if ($807) {
    $$02$i169$i = $806;$817 = $$pre$i181$i$lcssa;$ptr$01$i170$i = $$lcssa456;
   } else {
    HEAP32[$802>>2] = $$lcssa456;
    $1213 = $$pre$i181$i$lcssa;
    break;
   }
   while(1) {
    $808 = $ptr$01$i170$i & 7;
    $809 = (8 - ($808))|0;
    $810 = ($$02$i169$i|0)<($809|0);
    $$0$$i171$i = $810 ? $$02$i169$i : $809;
    $811 = (($$02$i169$i) - ($$0$$i171$i))|0;
    $812 = $804 >> $811;
    $813 = (($809) - ($$0$$i171$i))|0;
    $814 = $812 << $813;
    $815 = $ptr$01$i170$i >> 3;
    $816 = ((((((($gfc)) + 39840|0) + (($817*48)|0)|0)) + 8|0) + ($815)|0);
    $818 = HEAP8[$816>>0]|0;
    $819 = $818&255;
    $820 = $814 | $819;
    $821 = $820&255;
    HEAP8[$816>>0] = $821;
    $822 = (($$0$$i171$i) + ($ptr$01$i170$i))|0;
    $823 = ($811|0)>(0);
    $$pre$i173$i = HEAP32[$17>>2]|0;
    if ($823) {
     $$02$i169$i = $811;$817 = $$pre$i173$i;$ptr$01$i170$i = $822;
    } else {
     $$lcssa455 = $822;$$pre$i173$i$lcssa = $$pre$i173$i;
     break;
    }
   }
   $$pre$i = HEAP32[$805>>2]|0;
   $824 = (((((($gfc)) + 39840|0) + (($$pre$i173$i$lcssa*48)|0)|0)) + 4|0);
   HEAP32[$824>>2] = $$lcssa455;
   $825 = ($$pre$i|0)>(0);
   if ($825) {
    $1809 = $$lcssa455;$1810 = $$pre$i173$i$lcssa;$ch$2638$i = 0;
    while(1) {
     $826 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4768|0);
     $827 = HEAP32[$826>>2]|0;
     $828 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4844|0);
     $829 = HEAP32[$828>>2]|0;
     $830 = (($829) + ($827))|0;
     $$02$i161$i = 12;$840 = $1810;$ptr$01$i162$i = $1809;
     while(1) {
      $831 = $ptr$01$i162$i & 7;
      $832 = (8 - ($831))|0;
      $833 = ($$02$i161$i|0)<($832|0);
      $$0$$i163$i = $833 ? $$02$i161$i : $832;
      $834 = (($$02$i161$i) - ($$0$$i163$i))|0;
      $835 = $830 >> $834;
      $836 = (($832) - ($$0$$i163$i))|0;
      $837 = $835 << $836;
      $838 = $ptr$01$i162$i >> 3;
      $839 = ((((((($gfc)) + 39840|0) + (($840*48)|0)|0)) + 8|0) + ($838)|0);
      $841 = HEAP8[$839>>0]|0;
      $842 = $841&255;
      $843 = $837 | $842;
      $844 = $843&255;
      HEAP8[$839>>0] = $844;
      $845 = (($$0$$i163$i) + ($ptr$01$i162$i))|0;
      $846 = ($834|0)>(0);
      $$pre$i165$i = HEAP32[$17>>2]|0;
      if ($846) {
       $$02$i161$i = $834;$840 = $$pre$i165$i;$ptr$01$i162$i = $845;
      } else {
       $$lcssa435 = $845;$$pre$i165$i$lcssa = $$pre$i165$i;
       break;
      }
     }
     $847 = (((((($gfc)) + 39840|0) + (($$pre$i165$i$lcssa*48)|0)|0)) + 4|0);
     HEAP32[$847>>2] = $$lcssa435;
     $848 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4772|0);
     $849 = HEAP32[$848>>2]|0;
     $850 = (($849|0) / 2)&-1;
     $$02$i153$i = 9;$860 = $$pre$i165$i$lcssa;$ptr$01$i154$i = $$lcssa435;
     while(1) {
      $851 = $ptr$01$i154$i & 7;
      $852 = (8 - ($851))|0;
      $853 = ($$02$i153$i|0)<($852|0);
      $$0$$i155$i = $853 ? $$02$i153$i : $852;
      $854 = (($$02$i153$i) - ($$0$$i155$i))|0;
      $855 = $850 >> $854;
      $856 = (($852) - ($$0$$i155$i))|0;
      $857 = $855 << $856;
      $858 = $ptr$01$i154$i >> 3;
      $859 = ((((((($gfc)) + 39840|0) + (($860*48)|0)|0)) + 8|0) + ($858)|0);
      $861 = HEAP8[$859>>0]|0;
      $862 = $861&255;
      $863 = $857 | $862;
      $864 = $863&255;
      HEAP8[$859>>0] = $864;
      $865 = (($$0$$i155$i) + ($ptr$01$i154$i))|0;
      $866 = ($854|0)>(0);
      $$pre$i157$i = HEAP32[$17>>2]|0;
      if ($866) {
       $$02$i153$i = $854;$860 = $$pre$i157$i;$ptr$01$i154$i = $865;
      } else {
       $$lcssa436 = $865;$$pre$i157$i$lcssa = $$pre$i157$i;
       break;
      }
     }
     $867 = (((((($gfc)) + 39840|0) + (($$pre$i157$i$lcssa*48)|0)|0)) + 4|0);
     HEAP32[$867>>2] = $$lcssa436;
     $868 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4780|0);
     $869 = HEAP32[$868>>2]|0;
     $$02$i145$i = 8;$879 = $$pre$i157$i$lcssa;$ptr$01$i146$i = $$lcssa436;
     while(1) {
      $870 = $ptr$01$i146$i & 7;
      $871 = (8 - ($870))|0;
      $872 = ($$02$i145$i|0)<($871|0);
      $$0$$i147$i = $872 ? $$02$i145$i : $871;
      $873 = (($$02$i145$i) - ($$0$$i147$i))|0;
      $874 = $869 >> $873;
      $875 = (($871) - ($$0$$i147$i))|0;
      $876 = $874 << $875;
      $877 = $ptr$01$i146$i >> 3;
      $878 = ((((((($gfc)) + 39840|0) + (($879*48)|0)|0)) + 8|0) + ($877)|0);
      $880 = HEAP8[$878>>0]|0;
      $881 = $880&255;
      $882 = $876 | $881;
      $883 = $882&255;
      HEAP8[$878>>0] = $883;
      $884 = (($$0$$i147$i) + ($ptr$01$i146$i))|0;
      $885 = ($873|0)>(0);
      $$pre$i149$i = HEAP32[$17>>2]|0;
      if ($885) {
       $$02$i145$i = $873;$879 = $$pre$i149$i;$ptr$01$i146$i = $884;
      } else {
       $$lcssa437 = $884;$$pre$i149$i$lcssa = $$pre$i149$i;
       break;
      }
     }
     $886 = (((((($gfc)) + 39840|0) + (($$pre$i149$i$lcssa*48)|0)|0)) + 4|0);
     HEAP32[$886>>2] = $$lcssa437;
     $887 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4784|0);
     $888 = HEAP32[$887>>2]|0;
     $$02$i137$i = 9;$898 = $$pre$i149$i$lcssa;$ptr$01$i138$i = $$lcssa437;
     while(1) {
      $889 = $ptr$01$i138$i & 7;
      $890 = (8 - ($889))|0;
      $891 = ($$02$i137$i|0)<($890|0);
      $$0$$i139$i = $891 ? $$02$i137$i : $890;
      $892 = (($$02$i137$i) - ($$0$$i139$i))|0;
      $893 = $888 >> $892;
      $894 = (($890) - ($$0$$i139$i))|0;
      $895 = $893 << $894;
      $896 = $ptr$01$i138$i >> 3;
      $897 = ((((((($gfc)) + 39840|0) + (($898*48)|0)|0)) + 8|0) + ($896)|0);
      $899 = HEAP8[$897>>0]|0;
      $900 = $899&255;
      $901 = $895 | $900;
      $902 = $901&255;
      HEAP8[$897>>0] = $902;
      $903 = (($$0$$i139$i) + ($ptr$01$i138$i))|0;
      $904 = ($892|0)>(0);
      $$pre$i141$i = HEAP32[$17>>2]|0;
      if ($904) {
       $$02$i137$i = $892;$898 = $$pre$i141$i;$ptr$01$i138$i = $903;
      } else {
       $$lcssa438 = $903;$$pre$i141$i$lcssa = $$pre$i141$i;
       break;
      }
     }
     $905 = (((((($gfc)) + 39840|0) + (($$pre$i141$i$lcssa*48)|0)|0)) + 4|0);
     HEAP32[$905>>2] = $$lcssa438;
     $906 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4788|0);
     $907 = HEAP32[$906>>2]|0;
     $908 = ($907|0)==(0);
     if ($908) {
      $$02$i65$i = 1;$ptr$01$i66$i = $$lcssa438;
      while(1) {
       $1062 = $ptr$01$i66$i & 7;
       $1063 = (8 - ($1062))|0;
       $1064 = ($$02$i65$i|0)<($1063|0);
       $$0$$i67$i = $1064 ? $$02$i65$i : $1063;
       $1065 = (($$02$i65$i) - ($$0$$i67$i))|0;
       $1066 = (($$0$$i67$i) + ($ptr$01$i66$i))|0;
       $1067 = ($1065|0)>(0);
       if ($1067) {
        $$02$i65$i = $1065;$ptr$01$i66$i = $1066;
       } else {
        $$lcssa447 = $1066;
        break;
       }
      }
      HEAP32[$905>>2] = $$lcssa447;
      $1068 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4796|0);
      $1069 = HEAP32[$1068>>2]|0;
      $1070 = ($1069|0)==(14);
      if ($1070) {
       HEAP32[$1068>>2] = 16;
       $$pre710$i = HEAP32[$17>>2]|0;
       $$phi$trans$insert711$i = (((((($gfc)) + 39840|0) + (($$pre710$i*48)|0)|0)) + 4|0);
       $$pre712$i = HEAP32[$$phi$trans$insert711$i>>2]|0;
       $1076 = 16;$1817 = $$pre712$i;$1818 = $$pre710$i;
      } else {
       $1076 = $1069;$1817 = $$lcssa447;$1818 = $$pre$i141$i$lcssa;
      }
      $$02$i57$i = 5;$1081 = $1818;$ptr$01$i58$i = $1817;
      while(1) {
       $1071 = $ptr$01$i58$i & 7;
       $1072 = (8 - ($1071))|0;
       $1073 = ($$02$i57$i|0)<($1072|0);
       $$0$$i59$i = $1073 ? $$02$i57$i : $1072;
       $1074 = (($$02$i57$i) - ($$0$$i59$i))|0;
       $1075 = $1076 >> $1074;
       $1077 = (($1072) - ($$0$$i59$i))|0;
       $1078 = $1075 << $1077;
       $1079 = $ptr$01$i58$i >> 3;
       $1080 = ((((((($gfc)) + 39840|0) + (($1081*48)|0)|0)) + 8|0) + ($1079)|0);
       $1082 = HEAP8[$1080>>0]|0;
       $1083 = $1082&255;
       $1084 = $1078 | $1083;
       $1085 = $1084&255;
       HEAP8[$1080>>0] = $1085;
       $1086 = (($$0$$i59$i) + ($ptr$01$i58$i))|0;
       $1087 = ($1074|0)>(0);
       $$pre$i61$i = HEAP32[$17>>2]|0;
       if ($1087) {
        $$02$i57$i = $1074;$1081 = $$pre$i61$i;$ptr$01$i58$i = $1086;
       } else {
        $$lcssa448 = $1086;$$pre$i61$i$lcssa = $$pre$i61$i;
        break;
       }
      }
      $1088 = (((((($gfc)) + 39840|0) + (($$pre$i61$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$1088>>2] = $$lcssa448;
      $1089 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4800|0);
      $1090 = HEAP32[$1089>>2]|0;
      $1091 = ($1090|0)==(14);
      if ($1091) {
       HEAP32[$1089>>2] = 16;
       $$pre713$i = HEAP32[$17>>2]|0;
       $$phi$trans$insert714$i = (((((($gfc)) + 39840|0) + (($$pre713$i*48)|0)|0)) + 4|0);
       $$pre715$i = HEAP32[$$phi$trans$insert714$i>>2]|0;
       $1097 = 16;$1819 = $$pre715$i;$1820 = $$pre713$i;
      } else {
       $1097 = $1090;$1819 = $$lcssa448;$1820 = $$pre$i61$i$lcssa;
      }
      $$02$i49$i = 5;$1102 = $1820;$ptr$01$i50$i = $1819;
      while(1) {
       $1092 = $ptr$01$i50$i & 7;
       $1093 = (8 - ($1092))|0;
       $1094 = ($$02$i49$i|0)<($1093|0);
       $$0$$i51$i = $1094 ? $$02$i49$i : $1093;
       $1095 = (($$02$i49$i) - ($$0$$i51$i))|0;
       $1096 = $1097 >> $1095;
       $1098 = (($1093) - ($$0$$i51$i))|0;
       $1099 = $1096 << $1098;
       $1100 = $ptr$01$i50$i >> 3;
       $1101 = ((((((($gfc)) + 39840|0) + (($1102*48)|0)|0)) + 8|0) + ($1100)|0);
       $1103 = HEAP8[$1101>>0]|0;
       $1104 = $1103&255;
       $1105 = $1099 | $1104;
       $1106 = $1105&255;
       HEAP8[$1101>>0] = $1106;
       $1107 = (($$0$$i51$i) + ($ptr$01$i50$i))|0;
       $1108 = ($1095|0)>(0);
       $$pre$i53$i = HEAP32[$17>>2]|0;
       if ($1108) {
        $$02$i49$i = $1095;$1102 = $$pre$i53$i;$ptr$01$i50$i = $1107;
       } else {
        $$lcssa449 = $1107;$$pre$i53$i$lcssa = $$pre$i53$i;
        break;
       }
      }
      $1109 = (((((($gfc)) + 39840|0) + (($$pre$i53$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$1109>>2] = $$lcssa449;
      $1110 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4804|0);
      $1111 = HEAP32[$1110>>2]|0;
      $1112 = ($1111|0)==(14);
      if ($1112) {
       HEAP32[$1110>>2] = 16;
       $$pre716$i = HEAP32[$17>>2]|0;
       $$phi$trans$insert717$i = (((((($gfc)) + 39840|0) + (($$pre716$i*48)|0)|0)) + 4|0);
       $$pre718$i = HEAP32[$$phi$trans$insert717$i>>2]|0;
       $1118 = 16;$1821 = $$pre718$i;$1822 = $$pre716$i;
      } else {
       $1118 = $1111;$1821 = $$lcssa449;$1822 = $$pre$i53$i$lcssa;
      }
      $$02$i41$i = 5;$1123 = $1822;$ptr$01$i42$i = $1821;
      while(1) {
       $1113 = $ptr$01$i42$i & 7;
       $1114 = (8 - ($1113))|0;
       $1115 = ($$02$i41$i|0)<($1114|0);
       $$0$$i43$i = $1115 ? $$02$i41$i : $1114;
       $1116 = (($$02$i41$i) - ($$0$$i43$i))|0;
       $1117 = $1118 >> $1116;
       $1119 = (($1114) - ($$0$$i43$i))|0;
       $1120 = $1117 << $1119;
       $1121 = $ptr$01$i42$i >> 3;
       $1122 = ((((((($gfc)) + 39840|0) + (($1123*48)|0)|0)) + 8|0) + ($1121)|0);
       $1124 = HEAP8[$1122>>0]|0;
       $1125 = $1124&255;
       $1126 = $1120 | $1125;
       $1127 = $1126&255;
       HEAP8[$1122>>0] = $1127;
       $1128 = (($$0$$i43$i) + ($ptr$01$i42$i))|0;
       $1129 = ($1116|0)>(0);
       $$pre$i45$i = HEAP32[$17>>2]|0;
       if ($1129) {
        $$02$i41$i = $1116;$1123 = $$pre$i45$i;$ptr$01$i42$i = $1128;
       } else {
        $$lcssa450 = $1128;$$pre$i45$i$lcssa = $$pre$i45$i;
        break;
       }
      }
      $1130 = (((((($gfc)) + 39840|0) + (($$pre$i45$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$1130>>2] = $$lcssa450;
      $1131 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4824|0);
      $1132 = HEAP32[$1131>>2]|0;
      $$02$i33$i = 4;$1142 = $$pre$i45$i$lcssa;$ptr$01$i34$i = $$lcssa450;
      while(1) {
       $1133 = $ptr$01$i34$i & 7;
       $1134 = (8 - ($1133))|0;
       $1135 = ($$02$i33$i|0)<($1134|0);
       $$0$$i35$i = $1135 ? $$02$i33$i : $1134;
       $1136 = (($$02$i33$i) - ($$0$$i35$i))|0;
       $1137 = $1132 >> $1136;
       $1138 = (($1134) - ($$0$$i35$i))|0;
       $1139 = $1137 << $1138;
       $1140 = $ptr$01$i34$i >> 3;
       $1141 = ((((((($gfc)) + 39840|0) + (($1142*48)|0)|0)) + 8|0) + ($1140)|0);
       $1143 = HEAP8[$1141>>0]|0;
       $1144 = $1143&255;
       $1145 = $1139 | $1144;
       $1146 = $1145&255;
       HEAP8[$1141>>0] = $1146;
       $1147 = (($$0$$i35$i) + ($ptr$01$i34$i))|0;
       $1148 = ($1136|0)>(0);
       $$pre$i37$i = HEAP32[$17>>2]|0;
       if ($1148) {
        $$02$i33$i = $1136;$1142 = $$pre$i37$i;$ptr$01$i34$i = $1147;
       } else {
        $$lcssa451 = $1147;$$pre$i37$i$lcssa = $$pre$i37$i;
        break;
       }
      }
      $1149 = (((((($gfc)) + 39840|0) + (($$pre$i37$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$1149>>2] = $$lcssa451;
      $1150 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4828|0);
      $1151 = HEAP32[$1150>>2]|0;
      $$02$i25$i = 3;$1161 = $$pre$i37$i$lcssa;$ptr$01$i26$i = $$lcssa451;
      while(1) {
       $1152 = $ptr$01$i26$i & 7;
       $1153 = (8 - ($1152))|0;
       $1154 = ($$02$i25$i|0)<($1153|0);
       $$0$$i27$i = $1154 ? $$02$i25$i : $1153;
       $1155 = (($$02$i25$i) - ($$0$$i27$i))|0;
       $1156 = $1151 >> $1155;
       $1157 = (($1153) - ($$0$$i27$i))|0;
       $1158 = $1156 << $1157;
       $1159 = $ptr$01$i26$i >> 3;
       $1160 = ((((((($gfc)) + 39840|0) + (($1161*48)|0)|0)) + 8|0) + ($1159)|0);
       $1162 = HEAP8[$1160>>0]|0;
       $1163 = $1162&255;
       $1164 = $1158 | $1163;
       $1165 = $1164&255;
       HEAP8[$1160>>0] = $1165;
       $1166 = (($$0$$i27$i) + ($ptr$01$i26$i))|0;
       $1167 = ($1155|0)>(0);
       $$pre$i29$i = HEAP32[$17>>2]|0;
       if ($1167) {
        $$02$i25$i = $1155;$1161 = $$pre$i29$i;$ptr$01$i26$i = $1166;
       } else {
        $$lcssa452 = $1166;$$pre$i29$i$lcssa = $$pre$i29$i;
        break;
       }
      }
      $1168 = (((((($gfc)) + 39840|0) + (($$pre$i29$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$1168>>2] = $$lcssa452;
      $1815 = $$lcssa452;$1816 = $$pre$i29$i$lcssa;
     } else {
      $$02$i129$i = 1;$918 = $$pre$i141$i$lcssa;$ptr$01$i130$i = $$lcssa438;
      while(1) {
       $909 = $ptr$01$i130$i & 7;
       $910 = (8 - ($909))|0;
       $911 = ($$02$i129$i|0)<($910|0);
       $$0$$i131$i = $911 ? $$02$i129$i : $910;
       $912 = (($$02$i129$i) - ($$0$$i131$i))|0;
       $913 = 1 >>> $912;
       $914 = (($910) - ($$0$$i131$i))|0;
       $915 = $913 << $914;
       $916 = $ptr$01$i130$i >> 3;
       $917 = ((((((($gfc)) + 39840|0) + (($918*48)|0)|0)) + 8|0) + ($916)|0);
       $919 = HEAP8[$917>>0]|0;
       $920 = $919&255;
       $921 = $915 | $920;
       $922 = $921&255;
       HEAP8[$917>>0] = $922;
       $923 = (($$0$$i131$i) + ($ptr$01$i130$i))|0;
       $924 = ($912|0)>(0);
       $$pre$i133$i = HEAP32[$17>>2]|0;
       if ($924) {
        $$02$i129$i = $912;$918 = $$pre$i133$i;$ptr$01$i130$i = $923;
       } else {
        $$lcssa439 = $923;$$pre$i133$i$lcssa = $$pre$i133$i;
        break;
       }
      }
      $925 = (((((($gfc)) + 39840|0) + (($$pre$i133$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$925>>2] = $$lcssa439;
      $926 = HEAP32[$906>>2]|0;
      $$02$i121$i = 2;$936 = $$pre$i133$i$lcssa;$ptr$01$i122$i = $$lcssa439;
      while(1) {
       $927 = $ptr$01$i122$i & 7;
       $928 = (8 - ($927))|0;
       $929 = ($$02$i121$i|0)<($928|0);
       $$0$$i123$i = $929 ? $$02$i121$i : $928;
       $930 = (($$02$i121$i) - ($$0$$i123$i))|0;
       $931 = $926 >> $930;
       $932 = (($928) - ($$0$$i123$i))|0;
       $933 = $931 << $932;
       $934 = $ptr$01$i122$i >> 3;
       $935 = ((((((($gfc)) + 39840|0) + (($936*48)|0)|0)) + 8|0) + ($934)|0);
       $937 = HEAP8[$935>>0]|0;
       $938 = $937&255;
       $939 = $933 | $938;
       $940 = $939&255;
       HEAP8[$935>>0] = $940;
       $941 = (($$0$$i123$i) + ($ptr$01$i122$i))|0;
       $942 = ($930|0)>(0);
       $$pre$i125$i = HEAP32[$17>>2]|0;
       if ($942) {
        $$02$i121$i = $930;$936 = $$pre$i125$i;$ptr$01$i122$i = $941;
       } else {
        $$lcssa440 = $941;$$pre$i125$i$lcssa = $$pre$i125$i;
        break;
       }
      }
      $943 = (((((($gfc)) + 39840|0) + (($$pre$i125$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$943>>2] = $$lcssa440;
      $944 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4792|0);
      $945 = HEAP32[$944>>2]|0;
      $$02$i113$i = 1;$955 = $$pre$i125$i$lcssa;$ptr$01$i114$i = $$lcssa440;
      while(1) {
       $946 = $ptr$01$i114$i & 7;
       $947 = (8 - ($946))|0;
       $948 = ($$02$i113$i|0)<($947|0);
       $$0$$i115$i = $948 ? $$02$i113$i : $947;
       $949 = (($$02$i113$i) - ($$0$$i115$i))|0;
       $950 = $945 >> $949;
       $951 = (($947) - ($$0$$i115$i))|0;
       $952 = $950 << $951;
       $953 = $ptr$01$i114$i >> 3;
       $954 = ((((((($gfc)) + 39840|0) + (($955*48)|0)|0)) + 8|0) + ($953)|0);
       $956 = HEAP8[$954>>0]|0;
       $957 = $956&255;
       $958 = $952 | $957;
       $959 = $958&255;
       HEAP8[$954>>0] = $959;
       $960 = (($$0$$i115$i) + ($ptr$01$i114$i))|0;
       $961 = ($949|0)>(0);
       $$pre$i117$i = HEAP32[$17>>2]|0;
       if ($961) {
        $$02$i113$i = $949;$955 = $$pre$i117$i;$ptr$01$i114$i = $960;
       } else {
        $$lcssa441 = $960;$$pre$i117$i$lcssa = $$pre$i117$i;
        break;
       }
      }
      $962 = (((((($gfc)) + 39840|0) + (($$pre$i117$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$962>>2] = $$lcssa441;
      $963 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4796|0);
      $964 = HEAP32[$963>>2]|0;
      $965 = ($964|0)==(14);
      if ($965) {
       HEAP32[$963>>2] = 16;
       $$pre704$i = HEAP32[$17>>2]|0;
       $$phi$trans$insert705$i = (((((($gfc)) + 39840|0) + (($$pre704$i*48)|0)|0)) + 4|0);
       $$pre706$i = HEAP32[$$phi$trans$insert705$i>>2]|0;
       $1811 = $$pre706$i;$1812 = $$pre704$i;$971 = 16;
      } else {
       $1811 = $$lcssa441;$1812 = $$pre$i117$i$lcssa;$971 = $964;
      }
      $$02$i105$i = 5;$976 = $1812;$ptr$01$i106$i = $1811;
      while(1) {
       $966 = $ptr$01$i106$i & 7;
       $967 = (8 - ($966))|0;
       $968 = ($$02$i105$i|0)<($967|0);
       $$0$$i107$i = $968 ? $$02$i105$i : $967;
       $969 = (($$02$i105$i) - ($$0$$i107$i))|0;
       $970 = $971 >> $969;
       $972 = (($967) - ($$0$$i107$i))|0;
       $973 = $970 << $972;
       $974 = $ptr$01$i106$i >> 3;
       $975 = ((((((($gfc)) + 39840|0) + (($976*48)|0)|0)) + 8|0) + ($974)|0);
       $977 = HEAP8[$975>>0]|0;
       $978 = $977&255;
       $979 = $973 | $978;
       $980 = $979&255;
       HEAP8[$975>>0] = $980;
       $981 = (($$0$$i107$i) + ($ptr$01$i106$i))|0;
       $982 = ($969|0)>(0);
       $$pre$i109$i = HEAP32[$17>>2]|0;
       if ($982) {
        $$02$i105$i = $969;$976 = $$pre$i109$i;$ptr$01$i106$i = $981;
       } else {
        $$lcssa442 = $981;$$pre$i109$i$lcssa = $$pre$i109$i;
        break;
       }
      }
      $983 = (((((($gfc)) + 39840|0) + (($$pre$i109$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$983>>2] = $$lcssa442;
      $984 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4800|0);
      $985 = HEAP32[$984>>2]|0;
      $986 = ($985|0)==(14);
      if ($986) {
       HEAP32[$984>>2] = 16;
       $$pre707$i = HEAP32[$17>>2]|0;
       $$phi$trans$insert708$i = (((((($gfc)) + 39840|0) + (($$pre707$i*48)|0)|0)) + 4|0);
       $$pre709$i = HEAP32[$$phi$trans$insert708$i>>2]|0;
       $1813 = $$pre709$i;$1814 = $$pre707$i;$992 = 16;
      } else {
       $1813 = $$lcssa442;$1814 = $$pre$i109$i$lcssa;$992 = $985;
      }
      $$02$i97$i = 5;$997 = $1814;$ptr$01$i98$i = $1813;
      while(1) {
       $987 = $ptr$01$i98$i & 7;
       $988 = (8 - ($987))|0;
       $989 = ($$02$i97$i|0)<($988|0);
       $$0$$i99$i = $989 ? $$02$i97$i : $988;
       $990 = (($$02$i97$i) - ($$0$$i99$i))|0;
       $991 = $992 >> $990;
       $993 = (($988) - ($$0$$i99$i))|0;
       $994 = $991 << $993;
       $995 = $ptr$01$i98$i >> 3;
       $996 = ((((((($gfc)) + 39840|0) + (($997*48)|0)|0)) + 8|0) + ($995)|0);
       $998 = HEAP8[$996>>0]|0;
       $999 = $998&255;
       $1000 = $994 | $999;
       $1001 = $1000&255;
       HEAP8[$996>>0] = $1001;
       $1002 = (($$0$$i99$i) + ($ptr$01$i98$i))|0;
       $1003 = ($990|0)>(0);
       $$pre$i101$i = HEAP32[$17>>2]|0;
       if ($1003) {
        $$02$i97$i = $990;$997 = $$pre$i101$i;$ptr$01$i98$i = $1002;
       } else {
        $$lcssa443 = $1002;$$pre$i101$i$lcssa = $$pre$i101$i;
        break;
       }
      }
      $1004 = (((((($gfc)) + 39840|0) + (($$pre$i101$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$1004>>2] = $$lcssa443;
      $1005 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4808|0);
      $1006 = HEAP32[$1005>>2]|0;
      $$02$i89$i = 3;$1016 = $$pre$i101$i$lcssa;$ptr$01$i90$i = $$lcssa443;
      while(1) {
       $1007 = $ptr$01$i90$i & 7;
       $1008 = (8 - ($1007))|0;
       $1009 = ($$02$i89$i|0)<($1008|0);
       $$0$$i91$i = $1009 ? $$02$i89$i : $1008;
       $1010 = (($$02$i89$i) - ($$0$$i91$i))|0;
       $1011 = $1006 >> $1010;
       $1012 = (($1008) - ($$0$$i91$i))|0;
       $1013 = $1011 << $1012;
       $1014 = $ptr$01$i90$i >> 3;
       $1015 = ((((((($gfc)) + 39840|0) + (($1016*48)|0)|0)) + 8|0) + ($1014)|0);
       $1017 = HEAP8[$1015>>0]|0;
       $1018 = $1017&255;
       $1019 = $1013 | $1018;
       $1020 = $1019&255;
       HEAP8[$1015>>0] = $1020;
       $1021 = (($$0$$i91$i) + ($ptr$01$i90$i))|0;
       $1022 = ($1010|0)>(0);
       $$pre$i93$i = HEAP32[$17>>2]|0;
       if ($1022) {
        $$02$i89$i = $1010;$1016 = $$pre$i93$i;$ptr$01$i90$i = $1021;
       } else {
        $$lcssa444 = $1021;$$pre$i93$i$lcssa = $$pre$i93$i;
        break;
       }
      }
      $1023 = (((((($gfc)) + 39840|0) + (($$pre$i93$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$1023>>2] = $$lcssa444;
      $1024 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4812|0);
      $1025 = HEAP32[$1024>>2]|0;
      $$02$i81$i = 3;$1035 = $$pre$i93$i$lcssa;$ptr$01$i82$i = $$lcssa444;
      while(1) {
       $1026 = $ptr$01$i82$i & 7;
       $1027 = (8 - ($1026))|0;
       $1028 = ($$02$i81$i|0)<($1027|0);
       $$0$$i83$i = $1028 ? $$02$i81$i : $1027;
       $1029 = (($$02$i81$i) - ($$0$$i83$i))|0;
       $1030 = $1025 >> $1029;
       $1031 = (($1027) - ($$0$$i83$i))|0;
       $1032 = $1030 << $1031;
       $1033 = $ptr$01$i82$i >> 3;
       $1034 = ((((((($gfc)) + 39840|0) + (($1035*48)|0)|0)) + 8|0) + ($1033)|0);
       $1036 = HEAP8[$1034>>0]|0;
       $1037 = $1036&255;
       $1038 = $1032 | $1037;
       $1039 = $1038&255;
       HEAP8[$1034>>0] = $1039;
       $1040 = (($$0$$i83$i) + ($ptr$01$i82$i))|0;
       $1041 = ($1029|0)>(0);
       $$pre$i85$i = HEAP32[$17>>2]|0;
       if ($1041) {
        $$02$i81$i = $1029;$1035 = $$pre$i85$i;$ptr$01$i82$i = $1040;
       } else {
        $$lcssa445 = $1040;$$pre$i85$i$lcssa = $$pre$i85$i;
        break;
       }
      }
      $1042 = (((((($gfc)) + 39840|0) + (($$pre$i85$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$1042>>2] = $$lcssa445;
      $1043 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4816|0);
      $1044 = HEAP32[$1043>>2]|0;
      $$02$i73$i = 3;$1054 = $$pre$i85$i$lcssa;$ptr$01$i74$i = $$lcssa445;
      while(1) {
       $1045 = $ptr$01$i74$i & 7;
       $1046 = (8 - ($1045))|0;
       $1047 = ($$02$i73$i|0)<($1046|0);
       $$0$$i75$i = $1047 ? $$02$i73$i : $1046;
       $1048 = (($$02$i73$i) - ($$0$$i75$i))|0;
       $1049 = $1044 >> $1048;
       $1050 = (($1046) - ($$0$$i75$i))|0;
       $1051 = $1049 << $1050;
       $1052 = $ptr$01$i74$i >> 3;
       $1053 = ((((((($gfc)) + 39840|0) + (($1054*48)|0)|0)) + 8|0) + ($1052)|0);
       $1055 = HEAP8[$1053>>0]|0;
       $1056 = $1055&255;
       $1057 = $1051 | $1056;
       $1058 = $1057&255;
       HEAP8[$1053>>0] = $1058;
       $1059 = (($$0$$i75$i) + ($ptr$01$i74$i))|0;
       $1060 = ($1048|0)>(0);
       $$pre$i77$i = HEAP32[$17>>2]|0;
       if ($1060) {
        $$02$i73$i = $1048;$1054 = $$pre$i77$i;$ptr$01$i74$i = $1059;
       } else {
        $$lcssa446 = $1059;$$pre$i77$i$lcssa = $$pre$i77$i;
        break;
       }
      }
      $1061 = (((((($gfc)) + 39840|0) + (($$pre$i77$i$lcssa*48)|0)|0)) + 4|0);
      HEAP32[$1061>>2] = $$lcssa446;
      $1815 = $$lcssa446;$1816 = $$pre$i77$i$lcssa;
     }
     $1169 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4836|0);
     $1170 = HEAP32[$1169>>2]|0;
     $$02$i17$i = 1;$1180 = $1816;$ptr$01$i18$i = $1815;
     while(1) {
      $1171 = $ptr$01$i18$i & 7;
      $1172 = (8 - ($1171))|0;
      $1173 = ($$02$i17$i|0)<($1172|0);
      $$0$$i19$i = $1173 ? $$02$i17$i : $1172;
      $1174 = (($$02$i17$i) - ($$0$$i19$i))|0;
      $1175 = $1170 >> $1174;
      $1176 = (($1172) - ($$0$$i19$i))|0;
      $1177 = $1175 << $1176;
      $1178 = $ptr$01$i18$i >> 3;
      $1179 = ((((((($gfc)) + 39840|0) + (($1180*48)|0)|0)) + 8|0) + ($1178)|0);
      $1181 = HEAP8[$1179>>0]|0;
      $1182 = $1181&255;
      $1183 = $1177 | $1182;
      $1184 = $1183&255;
      HEAP8[$1179>>0] = $1184;
      $1185 = (($$0$$i19$i) + ($ptr$01$i18$i))|0;
      $1186 = ($1174|0)>(0);
      $$pre$i21$i = HEAP32[$17>>2]|0;
      if ($1186) {
       $$02$i17$i = $1174;$1180 = $$pre$i21$i;$ptr$01$i18$i = $1185;
      } else {
       $$lcssa453 = $1185;$$pre$i21$i$lcssa = $$pre$i21$i;
       break;
      }
     }
     $1187 = (((((($gfc)) + 39840|0) + (($$pre$i21$i$lcssa*48)|0)|0)) + 4|0);
     HEAP32[$1187>>2] = $$lcssa453;
     $1188 = (((((($gfc)) + 304|0) + (($ch$2638$i*5252)|0)|0)) + 4840|0);
     $1189 = HEAP32[$1188>>2]|0;
     $$02$i9$i = 1;$1199 = $$pre$i21$i$lcssa;$ptr$01$i10$i = $$lcssa453;
     while(1) {
      $1190 = $ptr$01$i10$i & 7;
      $1191 = (8 - ($1190))|0;
      $1192 = ($$02$i9$i|0)<($1191|0);
      $$0$$i11$i = $1192 ? $$02$i9$i : $1191;
      $1193 = (($$02$i9$i) - ($$0$$i11$i))|0;
      $1194 = $1189 >> $1193;
      $1195 = (($1191) - ($$0$$i11$i))|0;
      $1196 = $1194 << $1195;
      $1197 = $ptr$01$i10$i >> 3;
      $1198 = ((((((($gfc)) + 39840|0) + (($1199*48)|0)|0)) + 8|0) + ($1197)|0);
      $1200 = HEAP8[$1198>>0]|0;
      $1201 = $1200&255;
      $1202 = $1196 | $1201;
      $1203 = $1202&255;
      HEAP8[$1198>>0] = $1203;
      $1204 = (($$0$$i11$i) + ($ptr$01$i10$i))|0;
      $1205 = ($1193|0)>(0);
      $$pre$i13$i = HEAP32[$17>>2]|0;
      if ($1205) {
       $$02$i9$i = $1193;$1199 = $$pre$i13$i;$ptr$01$i10$i = $1204;
      } else {
       $$lcssa454 = $1204;$$pre$i13$i$lcssa = $$pre$i13$i;
       break;
      }
     }
     $1206 = (((((($gfc)) + 39840|0) + (($$pre$i13$i$lcssa*48)|0)|0)) + 4|0);
     HEAP32[$1206>>2] = $$lcssa454;
     $1207 = (($ch$2638$i) + 1)|0;
     $1208 = HEAP32[$805>>2]|0;
     $1209 = ($1207|0)<($1208|0);
     if ($1209) {
      $1809 = $$lcssa454;$1810 = $$pre$i13$i$lcssa;$ch$2638$i = $1207;
     } else {
      $1213 = $$pre$i13$i$lcssa;
      break;
     }
    }
   } else {
    $1213 = $$pre$i173$i$lcssa;
   }
  }
 } while(0);
 $1210 = HEAP32[$98>>2]|0;
 $1211 = ($1210|0)==(0);
 if ($1211) {
  $1215 = $1213;
 } else {
  $1212 = (((((($gfc)) + 39840|0) + (($1213*48)|0)|0)) + 8|0);
  _CRC_writeheader($gfc,$1212);
  $$pre734$i = HEAP32[$17>>2]|0;
  $1215 = $$pre734$i;
 }
 $1214 = (($1215) + 1)|0;
 $1216 = $1214 & 255;
 HEAP32[$17>>2] = $1216;
 $1217 = (((($gfc)) + 39840|0) + (($1215*48)|0)|0);
 $1218 = HEAP32[$1217>>2]|0;
 $1219 = (($1218) + ($14))|0;
 $1220 = (((($gfc)) + 39840|0) + (($1216*48)|0)|0);
 HEAP32[$1220>>2] = $1219;
 $1221 = HEAP32[$17>>2]|0;
 $1222 = ((($gfc)) + 52132|0);
 $1223 = HEAP32[$1222>>2]|0;
 $1224 = ($1221|0)==($1223|0);
 if ($1224) {
  _lame_errorf($gfc,1112,$vararg_buffer);
 }
 $1283 = HEAP32[$21>>2]|0;
 $1284 = $1283 << 3;
 $1285 = HEAP32[$62>>2]|0;
 $1286 = ($1285|0)==(1);
 $1287 = ((($gfc)) + 72|0);
 do {
  if ($1286) {
   $1295 = ((($gfc)) + 300|0);
   $1296 = ((($gfc)) + 296|0);
   $1297 = ((($gfc)) + 292|0);
   $1298 = ((($gfc)) + 284|0);
   $1299 = ((($gfc)) + 21464|0);
   $$pre$i1 = HEAP32[$1287>>2]|0;
   $1300 = $$pre$i1;$gr$054$i = 0;$tot_bits$053$i = 0;
   while(1) {
    $1301 = ($1300|0)>(0);
    if ($1301) {
     $ch$047$i = 0;$tot_bits$146$i = $tot_bits$053$i;
     while(1) {
      $1302 = ((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0);
      $1303 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4784|0);
      $1304 = HEAP32[$1303>>2]|0;
      $1305 = (88648 + ($1304<<2)|0);
      $1306 = HEAP32[$1305>>2]|0;
      $1307 = (88712 + ($1304<<2)|0);
      $1308 = HEAP32[$1307>>2]|0;
      $1309 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4868|0);
      $1310 = HEAP32[$1309>>2]|0;
      $1311 = ($1310|0)>(0);
      L269: do {
       if ($1311) {
        $1312 = ($1306|0)>(0);
        if ($1312) {
         $1824 = $1310;$data_bits$039$us$i = 0;$sfb$040$us$i = 0;
        } else {
         $data_bits$039$i = 0;$sfb$040$i = 0;
         while(1) {
          $1365 = (((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4608|0) + ($sfb$040$i<<2)|0);
          $1366 = HEAP32[$1365>>2]|0;
          $1367 = ($1366|0)==(-1);
          $1368 = $1367 ? 0 : $1306;
          $data_bits$039$$i = (($1368) + ($data_bits$039$i))|0;
          $1369 = (($sfb$040$i) + 1)|0;
          $exitcond166 = ($1369|0)==($1310|0);
          if ($exitcond166) {
           $data_bits$0$lcssa$i = $data_bits$039$$i;$sfb$0$lcssa$i = $1310;
           break L269;
          } else {
           $data_bits$039$i = $data_bits$039$$i;$sfb$040$i = $1369;
          }
         }
        }
        while(1) {
         $1313 = (((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4608|0) + ($sfb$040$us$i<<2)|0);
         $1314 = HEAP32[$1313>>2]|0;
         $1315 = ($1314|0)==(-1);
         if ($1315) {
          $1360 = $1824;$data_bits$1$us$i = $data_bits$039$us$i;
         } else {
          $$01$i$us$i = $1306;
          while(1) {
           $1316 = HEAP32[$1295>>2]|0;
           $1317 = ($1316|0)==(0);
           if ($1317) {
            HEAP32[$1295>>2] = 8;
            $1318 = HEAP32[$1296>>2]|0;
            $1319 = (($1318) + 1)|0;
            HEAP32[$1296>>2] = $1319;
            $1320 = HEAP32[$1222>>2]|0;
            $1321 = (((($gfc)) + 39840|0) + (($1320*48)|0)|0);
            $1322 = HEAP32[$1321>>2]|0;
            $1323 = HEAP32[$1297>>2]|0;
            $1324 = ($1322|0)==($1323|0);
            if ($1324) {
             $1325 = HEAP32[$1298>>2]|0;
             $1326 = (($1325) + ($1319)|0);
             $1327 = (((((($gfc)) + 39840|0) + (($1320*48)|0)|0)) + 8|0);
             $1328 = HEAP32[$21>>2]|0;
             _memcpy(($1326|0),($1327|0),($1328|0))|0;
             $1329 = HEAP32[$21>>2]|0;
             $1330 = HEAP32[$1296>>2]|0;
             $1331 = (($1330) + ($1329))|0;
             HEAP32[$1296>>2] = $1331;
             $1332 = $1329 << 3;
             $1333 = HEAP32[$1297>>2]|0;
             $1334 = (($1333) + ($1332))|0;
             HEAP32[$1297>>2] = $1334;
             $1335 = HEAP32[$1222>>2]|0;
             $1336 = (($1335) + 1)|0;
             $1337 = $1336 & 255;
             HEAP32[$1222>>2] = $1337;
             $1340 = $1331;
            } else {
             $1340 = $1319;
            }
            $1338 = HEAP32[$1298>>2]|0;
            $1339 = (($1338) + ($1340)|0);
            HEAP8[$1339>>0] = 0;
            $$pre$i$us$i = HEAP32[$1295>>2]|0;
            $1342 = $$pre$i$us$i;
           } else {
            $1342 = $1316;
           }
           $1341 = ($$01$i$us$i|0)<($1342|0);
           $$0$$i$us$i = $1341 ? $$01$i$us$i : $1342;
           $1343 = (($$01$i$us$i) - ($$0$$i$us$i))|0;
           $1344 = (($1342) - ($$0$$i$us$i))|0;
           HEAP32[$1295>>2] = $1344;
           $1345 = $1314 >> $1343;
           $1346 = $1345 << $1344;
           $1347 = HEAP32[$1296>>2]|0;
           $1348 = HEAP32[$1298>>2]|0;
           $1349 = (($1348) + ($1347)|0);
           $1350 = HEAP8[$1349>>0]|0;
           $1351 = $1350&255;
           $1352 = $1346 | $1351;
           $1353 = $1352&255;
           HEAP8[$1349>>0] = $1353;
           $1354 = HEAP32[$1297>>2]|0;
           $1355 = (($1354) + ($$0$$i$us$i))|0;
           HEAP32[$1297>>2] = $1355;
           $1356 = ($1343|0)>(0);
           if ($1356) {
            $$01$i$us$i = $1343;
           } else {
            break;
           }
          }
          $$pre96$pre$i = HEAP32[$1309>>2]|0;
          $1357 = (($data_bits$039$us$i) + ($1306))|0;
          $1360 = $$pre96$pre$i;$data_bits$1$us$i = $1357;
         }
         $1358 = (($sfb$040$us$i) + 1)|0;
         $1359 = ($1358|0)<($1360|0);
         if ($1359) {
          $1824 = $1360;$data_bits$039$us$i = $data_bits$1$us$i;$sfb$040$us$i = $1358;
         } else {
          $data_bits$0$lcssa$i = $data_bits$1$us$i;$sfb$0$lcssa$i = $1358;
          break;
         }
        }
       } else {
        $data_bits$0$lcssa$i = 0;$sfb$0$lcssa$i = 0;
       }
      } while(0);
      $1361 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4860|0);
      $1362 = HEAP32[$1361>>2]|0;
      $1363 = ($sfb$0$lcssa$i|0)<($1362|0);
      if ($1363) {
       $1364 = ($1308|0)>(0);
       $1825 = $1362;$data_bits$242$i = $data_bits$0$lcssa$i;$sfb$143$i = $sfb$0$lcssa$i;
       while(1) {
        $1370 = (((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4608|0) + ($sfb$143$i<<2)|0);
        $1371 = HEAP32[$1370>>2]|0;
        $1372 = ($1371|0)==(-1);
        if ($1372) {
         $1417 = $1825;$data_bits$3$i = $data_bits$242$i;
        } else {
         if ($1364) {
          $$01$i4$i = $1308;
          while(1) {
           $1373 = HEAP32[$1295>>2]|0;
           $1374 = ($1373|0)==(0);
           if ($1374) {
            HEAP32[$1295>>2] = 8;
            $1375 = HEAP32[$1296>>2]|0;
            $1376 = (($1375) + 1)|0;
            HEAP32[$1296>>2] = $1376;
            $1377 = HEAP32[$1222>>2]|0;
            $1378 = (((($gfc)) + 39840|0) + (($1377*48)|0)|0);
            $1379 = HEAP32[$1378>>2]|0;
            $1380 = HEAP32[$1297>>2]|0;
            $1381 = ($1379|0)==($1380|0);
            if ($1381) {
             $1382 = HEAP32[$1298>>2]|0;
             $1383 = (($1382) + ($1376)|0);
             $1384 = (((((($gfc)) + 39840|0) + (($1377*48)|0)|0)) + 8|0);
             $1385 = HEAP32[$21>>2]|0;
             _memcpy(($1383|0),($1384|0),($1385|0))|0;
             $1386 = HEAP32[$21>>2]|0;
             $1387 = HEAP32[$1296>>2]|0;
             $1388 = (($1387) + ($1386))|0;
             HEAP32[$1296>>2] = $1388;
             $1389 = $1386 << 3;
             $1390 = HEAP32[$1297>>2]|0;
             $1391 = (($1390) + ($1389))|0;
             HEAP32[$1297>>2] = $1391;
             $1392 = HEAP32[$1222>>2]|0;
             $1393 = (($1392) + 1)|0;
             $1394 = $1393 & 255;
             HEAP32[$1222>>2] = $1394;
             $1397 = $1388;
            } else {
             $1397 = $1376;
            }
            $1395 = HEAP32[$1298>>2]|0;
            $1396 = (($1395) + ($1397)|0);
            HEAP8[$1396>>0] = 0;
            $$pre$i5$i4 = HEAP32[$1295>>2]|0;
            $1399 = $$pre$i5$i4;
           } else {
            $1399 = $1373;
           }
           $1398 = ($$01$i4$i|0)<($1399|0);
           $$0$$i6$i = $1398 ? $$01$i4$i : $1399;
           $1400 = (($$01$i4$i) - ($$0$$i6$i))|0;
           $1401 = (($1399) - ($$0$$i6$i))|0;
           HEAP32[$1295>>2] = $1401;
           $1402 = $1371 >> $1400;
           $1403 = $1402 << $1401;
           $1404 = HEAP32[$1296>>2]|0;
           $1405 = HEAP32[$1298>>2]|0;
           $1406 = (($1405) + ($1404)|0);
           $1407 = HEAP8[$1406>>0]|0;
           $1408 = $1407&255;
           $1409 = $1403 | $1408;
           $1410 = $1409&255;
           HEAP8[$1406>>0] = $1410;
           $1411 = HEAP32[$1297>>2]|0;
           $1412 = (($1411) + ($$0$$i6$i))|0;
           HEAP32[$1297>>2] = $1412;
           $1413 = ($1400|0)>(0);
           if ($1413) {
            $$01$i4$i = $1400;
           } else {
            break;
           }
          }
          $$pre97$pre$i = HEAP32[$1361>>2]|0;
          $$pre97$i = $$pre97$pre$i;
         } else {
          $$pre97$i = $1825;
         }
         $1414 = (($data_bits$242$i) + ($1308))|0;
         $1417 = $$pre97$i;$data_bits$3$i = $1414;
        }
        $1415 = (($sfb$143$i) + 1)|0;
        $1416 = ($1415|0)<($1417|0);
        if ($1416) {
         $1825 = $1417;$data_bits$242$i = $data_bits$3$i;$sfb$143$i = $1415;
        } else {
         $data_bits$2$lcssa$i = $data_bits$3$i;
         break;
        }
       }
      } else {
       $data_bits$2$lcssa$i = $data_bits$0$lcssa$i;
      }
      $1418 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4788|0);
      $1419 = HEAP32[$1418>>2]|0;
      $1420 = ($1419|0)==(2);
      if ($1420) {
       $1421 = HEAP32[$1299>>2]|0;
       $1422 = ($1421*3)|0;
       $1423 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4772|0);
       $1424 = HEAP32[$1423>>2]|0;
       $1425 = ($1422|0)>($1424|0);
       $$$i8$i = $1425 ? $1424 : $1422;
       $1426 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4796|0);
       $1427 = HEAP32[$1426>>2]|0;
       $1428 = (_Huffmancode($gfc,$1427,0,$$$i8$i,$1302)|0);
       $1429 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4800|0);
       $1430 = HEAP32[$1429>>2]|0;
       $1431 = HEAP32[$1423>>2]|0;
       $1432 = (_Huffmancode($gfc,$1430,$$$i8$i,$1431,$1302)|0);
       $1433 = (($1432) + ($1428))|0;
       $$pn$i = $1433;
      } else {
       $1434 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4772|0);
       $1435 = HEAP32[$1434>>2]|0;
       $1436 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4824|0);
       $1437 = HEAP32[$1436>>2]|0;
       $1438 = (($1437) + 1)|0;
       $1439 = (((($gfc)) + 21360|0) + ($1438<<2)|0);
       $1440 = HEAP32[$1439>>2]|0;
       $1441 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4828|0);
       $1442 = HEAP32[$1441>>2]|0;
       $1443 = (($1437) + 2)|0;
       $1444 = (($1443) + ($1442))|0;
       $1445 = (((($gfc)) + 21360|0) + ($1444<<2)|0);
       $1446 = HEAP32[$1445>>2]|0;
       $1447 = ($1440|0)>($1435|0);
       $$$i9$i = $1447 ? $1435 : $1440;
       $1448 = ($1446|0)>($1435|0);
       $region2Start$0$i10$i = $1448 ? $1435 : $1446;
       $1449 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4796|0);
       $1450 = HEAP32[$1449>>2]|0;
       $1451 = (_Huffmancode($gfc,$1450,0,$$$i9$i,$1302)|0);
       $1452 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4800|0);
       $1453 = HEAP32[$1452>>2]|0;
       $1454 = (_Huffmancode($gfc,$1453,$$$i9$i,$region2Start$0$i10$i,$1302)|0);
       $1455 = (($1454) + ($1451))|0;
       $1456 = ((((((($gfc)) + 304|0) + (($gr$054$i*10504)|0)|0) + (($ch$047$i*5252)|0)|0)) + 4804|0);
       $1457 = HEAP32[$1456>>2]|0;
       $1458 = (_Huffmancode($gfc,$1457,$region2Start$0$i10$i,$1435,$1302)|0);
       $1459 = (($1455) + ($1458))|0;
       $$pn$i = $1459;
      }
      $1460 = (_huffman_coder_count1($gfc,$1302)|0);
      $data_bits$4$i = (($data_bits$2$lcssa$i) + ($tot_bits$146$i))|0;
      $1461 = (($data_bits$4$i) + ($$pn$i))|0;
      $1462 = (($1461) + ($1460))|0;
      $1463 = (($ch$047$i) + 1)|0;
      $1464 = HEAP32[$1287>>2]|0;
      $1465 = ($1463|0)<($1464|0);
      if ($1465) {
       $ch$047$i = $1463;$tot_bits$146$i = $1462;
      } else {
       $1823 = $1464;$tot_bits$1$lcssa$i = $1462;
       break;
      }
     }
    } else {
     $1823 = $1300;$tot_bits$1$lcssa$i = $tot_bits$053$i;
    }
    $1466 = (($gr$054$i) + 1)|0;
    $exitcond$i6 = ($1466|0)==(2);
    if ($exitcond$i6) {
     $$pre$phiZ2D = $1297;$tot_bits$3$i = $tot_bits$1$lcssa$i;
     break;
    } else {
     $1300 = $1823;$gr$054$i = $1466;$tot_bits$053$i = $tot_bits$1$lcssa$i;
    }
   }
  } else {
   $1288 = HEAP32[$1287>>2]|0;
   $1289 = ($1288|0)>(0);
   if (!($1289)) {
    $$pre167 = ((($gfc)) + 292|0);
    $$pre$phiZ2D = $$pre167;$tot_bits$3$i = 0;
    break;
   }
   $1290 = ((($gfc)) + 300|0);
   $1291 = ((($gfc)) + 296|0);
   $1292 = ((($gfc)) + 292|0);
   $1293 = ((($gfc)) + 284|0);
   $1294 = ((($gfc)) + 21464|0);
   $ch$179$i = 0;$tot_bits$278$i = 0;
   while(1) {
    $1467 = (((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0);
    $1468 = (((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4788|0);
    $1469 = HEAP32[$1468>>2]|0;
    $1470 = ($1469|0)==(2);
    $1471 = (((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 5188|0);
    if ($1470) {
     $scale_bits$076$i = 0;$sfb$277$i = 0;$sfb_partition$075$i = 0;
     while(1) {
      $1472 = HEAP32[$1471>>2]|0;
      $1473 = (($1472) + ($sfb_partition$075$i<<2)|0);
      $1474 = HEAP32[$1473>>2]|0;
      $1475 = (($1474|0) / 3)&-1;
      $1476 = ((((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 5192|0) + ($sfb_partition$075$i<<2)|0);
      $1477 = HEAP32[$1476>>2]|0;
      $1478 = ($1474|0)>(2);
      if ($1478) {
       $1479 = ($1477|0)>(0);
       $1480 = ($1475|0)>(1);
       $smax$i = $1480 ? $1475 : 1;
       $i$067$i = 0;$sfb$369$i = $sfb$277$i;
       while(1) {
        $1481 = ($sfb$369$i*3)|0;
        $1482 = ((((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4608|0) + ($1481<<2)|0);
        $1483 = HEAP32[$1482>>2]|0;
        $1484 = ($1483|0)>(0);
        $$$i7 = $1484 ? $1483 : 0;
        if ($1479) {
         $$01$i12$i = $1477;
         while(1) {
          $1485 = HEAP32[$1290>>2]|0;
          $1486 = ($1485|0)==(0);
          if ($1486) {
           HEAP32[$1290>>2] = 8;
           $1487 = HEAP32[$1291>>2]|0;
           $1488 = (($1487) + 1)|0;
           HEAP32[$1291>>2] = $1488;
           $1489 = HEAP32[$1222>>2]|0;
           $1490 = (((($gfc)) + 39840|0) + (($1489*48)|0)|0);
           $1491 = HEAP32[$1490>>2]|0;
           $1492 = HEAP32[$1292>>2]|0;
           $1493 = ($1491|0)==($1492|0);
           if ($1493) {
            $1494 = HEAP32[$1293>>2]|0;
            $1495 = (($1494) + ($1488)|0);
            $1496 = (((((($gfc)) + 39840|0) + (($1489*48)|0)|0)) + 8|0);
            $1497 = HEAP32[$21>>2]|0;
            _memcpy(($1495|0),($1496|0),($1497|0))|0;
            $1498 = HEAP32[$21>>2]|0;
            $1499 = HEAP32[$1291>>2]|0;
            $1500 = (($1499) + ($1498))|0;
            HEAP32[$1291>>2] = $1500;
            $1501 = $1498 << 3;
            $1502 = HEAP32[$1292>>2]|0;
            $1503 = (($1502) + ($1501))|0;
            HEAP32[$1292>>2] = $1503;
            $1504 = HEAP32[$1222>>2]|0;
            $1505 = (($1504) + 1)|0;
            $1506 = $1505 & 255;
            HEAP32[$1222>>2] = $1506;
            $1509 = $1500;
           } else {
            $1509 = $1488;
           }
           $1507 = HEAP32[$1293>>2]|0;
           $1508 = (($1507) + ($1509)|0);
           HEAP8[$1508>>0] = 0;
           $$pre$i13$i8 = HEAP32[$1290>>2]|0;
           $1511 = $$pre$i13$i8;
          } else {
           $1511 = $1485;
          }
          $1510 = ($$01$i12$i|0)<($1511|0);
          $$0$$i14$i = $1510 ? $$01$i12$i : $1511;
          $1512 = (($$01$i12$i) - ($$0$$i14$i))|0;
          $1513 = (($1511) - ($$0$$i14$i))|0;
          HEAP32[$1290>>2] = $1513;
          $1514 = $$$i7 >> $1512;
          $1515 = $1514 << $1513;
          $1516 = HEAP32[$1291>>2]|0;
          $1517 = HEAP32[$1293>>2]|0;
          $1518 = (($1517) + ($1516)|0);
          $1519 = HEAP8[$1518>>0]|0;
          $1520 = $1519&255;
          $1521 = $1515 | $1520;
          $1522 = $1521&255;
          HEAP8[$1518>>0] = $1522;
          $1523 = HEAP32[$1292>>2]|0;
          $1524 = (($1523) + ($$0$$i14$i))|0;
          HEAP32[$1292>>2] = $1524;
          $1525 = ($1512|0)>(0);
          if ($1525) {
           $$01$i12$i = $1512;
          } else {
           $$lcssa401 = $1524;
           break;
          }
         }
         $1526 = (($1481) + 1)|0;
         $1527 = ((((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4608|0) + ($1526<<2)|0);
         $1528 = HEAP32[$1527>>2]|0;
         $1529 = ($1528|0)>(0);
         $1530 = $1529 ? $1528 : 0;
         $$01$i17$i = $1477;$1539 = $$lcssa401;
         while(1) {
          $1531 = HEAP32[$1290>>2]|0;
          $1532 = ($1531|0)==(0);
          if ($1532) {
           HEAP32[$1290>>2] = 8;
           $1533 = HEAP32[$1291>>2]|0;
           $1534 = (($1533) + 1)|0;
           HEAP32[$1291>>2] = $1534;
           $1535 = HEAP32[$1222>>2]|0;
           $1536 = (((($gfc)) + 39840|0) + (($1535*48)|0)|0);
           $1537 = HEAP32[$1536>>2]|0;
           $1538 = ($1537|0)==($1539|0);
           if ($1538) {
            $1540 = HEAP32[$1293>>2]|0;
            $1541 = (($1540) + ($1534)|0);
            $1542 = (((((($gfc)) + 39840|0) + (($1535*48)|0)|0)) + 8|0);
            $1543 = HEAP32[$21>>2]|0;
            _memcpy(($1541|0),($1542|0),($1543|0))|0;
            $1544 = HEAP32[$21>>2]|0;
            $1545 = HEAP32[$1291>>2]|0;
            $1546 = (($1545) + ($1544))|0;
            HEAP32[$1291>>2] = $1546;
            $1547 = $1544 << 3;
            $1548 = HEAP32[$1292>>2]|0;
            $1549 = (($1548) + ($1547))|0;
            HEAP32[$1292>>2] = $1549;
            $1550 = HEAP32[$1222>>2]|0;
            $1551 = (($1550) + 1)|0;
            $1552 = $1551 & 255;
            HEAP32[$1222>>2] = $1552;
            $1555 = $1546;
           } else {
            $1555 = $1534;
           }
           $1553 = HEAP32[$1293>>2]|0;
           $1554 = (($1553) + ($1555)|0);
           HEAP8[$1554>>0] = 0;
           $$pre$i18$i = HEAP32[$1290>>2]|0;
           $1557 = $$pre$i18$i;
          } else {
           $1557 = $1531;
          }
          $1556 = ($$01$i17$i|0)<($1557|0);
          $$0$$i19$i9 = $1556 ? $$01$i17$i : $1557;
          $1558 = (($$01$i17$i) - ($$0$$i19$i9))|0;
          $1559 = (($1557) - ($$0$$i19$i9))|0;
          HEAP32[$1290>>2] = $1559;
          $1560 = $1530 >> $1558;
          $1561 = $1560 << $1559;
          $1562 = HEAP32[$1291>>2]|0;
          $1563 = HEAP32[$1293>>2]|0;
          $1564 = (($1563) + ($1562)|0);
          $1565 = HEAP8[$1564>>0]|0;
          $1566 = $1565&255;
          $1567 = $1561 | $1566;
          $1568 = $1567&255;
          HEAP8[$1564>>0] = $1568;
          $1569 = HEAP32[$1292>>2]|0;
          $1570 = (($1569) + ($$0$$i19$i9))|0;
          HEAP32[$1292>>2] = $1570;
          $1571 = ($1558|0)>(0);
          if ($1571) {
           $$01$i17$i = $1558;$1539 = $1570;
          } else {
           $$lcssa402 = $1570;
           break;
          }
         }
         $1572 = (($1481) + 2)|0;
         $1573 = ((((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4608|0) + ($1572<<2)|0);
         $1574 = HEAP32[$1573>>2]|0;
         $1575 = ($1574|0)>(0);
         $$1$i10 = $1575 ? $1574 : 0;
         $$01$i22$i = $1477;$1584 = $$lcssa402;
         while(1) {
          $1576 = HEAP32[$1290>>2]|0;
          $1577 = ($1576|0)==(0);
          if ($1577) {
           HEAP32[$1290>>2] = 8;
           $1578 = HEAP32[$1291>>2]|0;
           $1579 = (($1578) + 1)|0;
           HEAP32[$1291>>2] = $1579;
           $1580 = HEAP32[$1222>>2]|0;
           $1581 = (((($gfc)) + 39840|0) + (($1580*48)|0)|0);
           $1582 = HEAP32[$1581>>2]|0;
           $1583 = ($1582|0)==($1584|0);
           if ($1583) {
            $1585 = HEAP32[$1293>>2]|0;
            $1586 = (($1585) + ($1579)|0);
            $1587 = (((((($gfc)) + 39840|0) + (($1580*48)|0)|0)) + 8|0);
            $1588 = HEAP32[$21>>2]|0;
            _memcpy(($1586|0),($1587|0),($1588|0))|0;
            $1589 = HEAP32[$21>>2]|0;
            $1590 = HEAP32[$1291>>2]|0;
            $1591 = (($1590) + ($1589))|0;
            HEAP32[$1291>>2] = $1591;
            $1592 = $1589 << 3;
            $1593 = HEAP32[$1292>>2]|0;
            $1594 = (($1593) + ($1592))|0;
            HEAP32[$1292>>2] = $1594;
            $1595 = HEAP32[$1222>>2]|0;
            $1596 = (($1595) + 1)|0;
            $1597 = $1596 & 255;
            HEAP32[$1222>>2] = $1597;
            $1600 = $1591;
           } else {
            $1600 = $1579;
           }
           $1598 = HEAP32[$1293>>2]|0;
           $1599 = (($1598) + ($1600)|0);
           HEAP8[$1599>>0] = 0;
           $$pre$i23$i = HEAP32[$1290>>2]|0;
           $1602 = $$pre$i23$i;
          } else {
           $1602 = $1576;
          }
          $1601 = ($$01$i22$i|0)<($1602|0);
          $$0$$i24$i = $1601 ? $$01$i22$i : $1602;
          $1603 = (($$01$i22$i) - ($$0$$i24$i))|0;
          $1604 = (($1602) - ($$0$$i24$i))|0;
          HEAP32[$1290>>2] = $1604;
          $1605 = $$1$i10 >> $1603;
          $1606 = $1605 << $1604;
          $1607 = HEAP32[$1291>>2]|0;
          $1608 = HEAP32[$1293>>2]|0;
          $1609 = (($1608) + ($1607)|0);
          $1610 = HEAP8[$1609>>0]|0;
          $1611 = $1610&255;
          $1612 = $1606 | $1611;
          $1613 = $1612&255;
          HEAP8[$1609>>0] = $1613;
          $1614 = HEAP32[$1292>>2]|0;
          $1615 = (($1614) + ($$0$$i24$i))|0;
          HEAP32[$1292>>2] = $1615;
          $1616 = ($1603|0)>(0);
          if ($1616) {
           $$01$i22$i = $1603;$1584 = $1615;
          } else {
           break;
          }
         }
        }
        $1617 = (($i$067$i) + 1)|0;
        $1618 = (($sfb$369$i) + 1)|0;
        $1619 = ($1617|0)<($1475|0);
        if ($1619) {
         $i$067$i = $1617;$sfb$369$i = $1618;
        } else {
         break;
        }
       }
       $1620 = ($1477*3)|0;
       $1621 = Math_imul($1620, $smax$i)|0;
       $1622 = (($smax$i) + ($sfb$277$i))|0;
       $1623 = (($1621) + ($scale_bits$076$i))|0;
       $scale_bits$1$lcssa$i = $1623;$sfb$3$lcssa$i = $1622;
      } else {
       $scale_bits$1$lcssa$i = $scale_bits$076$i;$sfb$3$lcssa$i = $sfb$277$i;
      }
      $1624 = (($sfb_partition$075$i) + 1)|0;
      $exitcond95$i = ($1624|0)==(4);
      if ($exitcond95$i) {
       $scale_bits$1$lcssa$i$lcssa = $scale_bits$1$lcssa$i;
       break;
      } else {
       $scale_bits$076$i = $scale_bits$1$lcssa$i;$sfb$277$i = $sfb$3$lcssa$i;$sfb_partition$075$i = $1624;
      }
     }
     $1625 = HEAP32[$1294>>2]|0;
     $1626 = ($1625*3)|0;
     $1627 = (((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4772|0);
     $1628 = HEAP32[$1627>>2]|0;
     $1629 = ($1626|0)>($1628|0);
     $$$i26$i = $1629 ? $1628 : $1626;
     $1630 = (((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4796|0);
     $1631 = HEAP32[$1630>>2]|0;
     $1632 = (_Huffmancode($gfc,$1631,0,$$$i26$i,$1467)|0);
     $1633 = (((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4800|0);
     $1634 = HEAP32[$1633>>2]|0;
     $1635 = HEAP32[$1627>>2]|0;
     $1636 = (_Huffmancode($gfc,$1634,$$$i26$i,$1635,$1467)|0);
     $1637 = (($1636) + ($1632))|0;
     $data_bits$5$i = $1637;$scale_bits$4$i = $scale_bits$1$lcssa$i$lcssa;
    } else {
     $scale_bits$265$i = 0;$sfb$466$i = 0;$sfb_partition$164$i = 0;
     while(1) {
      $1638 = HEAP32[$1471>>2]|0;
      $1639 = (($1638) + ($sfb_partition$164$i<<2)|0);
      $1640 = HEAP32[$1639>>2]|0;
      $1641 = ((((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 5192|0) + ($sfb_partition$164$i<<2)|0);
      $1642 = HEAP32[$1641>>2]|0;
      $1643 = ($1640|0)>(0);
      if ($1643) {
       $1644 = ($1642|0)>(0);
       if ($1644) {
        $i$156$us$i = 0;$sfb$558$us$i = $sfb$466$i;
        while(1) {
         $1645 = ((((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4608|0) + ($sfb$558$us$i<<2)|0);
         $1646 = HEAP32[$1645>>2]|0;
         $1647 = ($1646|0)>(0);
         $$2$us$i = $1647 ? $1646 : 0;
         $$01$i28$us$i = $1642;
         while(1) {
          $1648 = HEAP32[$1290>>2]|0;
          $1649 = ($1648|0)==(0);
          if ($1649) {
           HEAP32[$1290>>2] = 8;
           $1650 = HEAP32[$1291>>2]|0;
           $1651 = (($1650) + 1)|0;
           HEAP32[$1291>>2] = $1651;
           $1652 = HEAP32[$1222>>2]|0;
           $1653 = (((($gfc)) + 39840|0) + (($1652*48)|0)|0);
           $1654 = HEAP32[$1653>>2]|0;
           $1655 = HEAP32[$1292>>2]|0;
           $1656 = ($1654|0)==($1655|0);
           if ($1656) {
            $1657 = HEAP32[$1293>>2]|0;
            $1658 = (($1657) + ($1651)|0);
            $1659 = (((((($gfc)) + 39840|0) + (($1652*48)|0)|0)) + 8|0);
            $1660 = HEAP32[$21>>2]|0;
            _memcpy(($1658|0),($1659|0),($1660|0))|0;
            $1661 = HEAP32[$21>>2]|0;
            $1662 = HEAP32[$1291>>2]|0;
            $1663 = (($1662) + ($1661))|0;
            HEAP32[$1291>>2] = $1663;
            $1664 = $1661 << 3;
            $1665 = HEAP32[$1292>>2]|0;
            $1666 = (($1665) + ($1664))|0;
            HEAP32[$1292>>2] = $1666;
            $1667 = HEAP32[$1222>>2]|0;
            $1668 = (($1667) + 1)|0;
            $1669 = $1668 & 255;
            HEAP32[$1222>>2] = $1669;
            $1672 = $1663;
           } else {
            $1672 = $1651;
           }
           $1670 = HEAP32[$1293>>2]|0;
           $1671 = (($1670) + ($1672)|0);
           HEAP8[$1671>>0] = 0;
           $$pre$i29$us$i = HEAP32[$1290>>2]|0;
           $1674 = $$pre$i29$us$i;
          } else {
           $1674 = $1648;
          }
          $1673 = ($$01$i28$us$i|0)<($1674|0);
          $$0$$i30$us$i = $1673 ? $$01$i28$us$i : $1674;
          $1675 = (($$01$i28$us$i) - ($$0$$i30$us$i))|0;
          $1676 = (($1674) - ($$0$$i30$us$i))|0;
          HEAP32[$1290>>2] = $1676;
          $1677 = $$2$us$i >> $1675;
          $1678 = $1677 << $1676;
          $1679 = HEAP32[$1291>>2]|0;
          $1680 = HEAP32[$1293>>2]|0;
          $1681 = (($1680) + ($1679)|0);
          $1682 = HEAP8[$1681>>0]|0;
          $1683 = $1682&255;
          $1684 = $1678 | $1683;
          $1685 = $1684&255;
          HEAP8[$1681>>0] = $1685;
          $1686 = HEAP32[$1292>>2]|0;
          $1687 = (($1686) + ($$0$$i30$us$i))|0;
          HEAP32[$1292>>2] = $1687;
          $1688 = ($1675|0)>(0);
          if ($1688) {
           $$01$i28$us$i = $1675;
          } else {
           break;
          }
         }
         $1689 = (($i$156$us$i) + 1)|0;
         $1690 = (($sfb$558$us$i) + 1)|0;
         $exitcond93$i = ($1689|0)==($1640|0);
         if ($exitcond93$i) {
          break;
         } else {
          $i$156$us$i = $1689;$sfb$558$us$i = $1690;
         }
        }
       }
       $$pn100$i = Math_imul($1642, $1640)|0;
       $split63$i = (($$pn100$i) + ($scale_bits$265$i))|0;
       $split62$i = (($1640) + ($sfb$466$i))|0;
       $scale_bits$3$lcssa$i = $split63$i;$sfb$5$lcssa$i = $split62$i;
      } else {
       $scale_bits$3$lcssa$i = $scale_bits$265$i;$sfb$5$lcssa$i = $sfb$466$i;
      }
      $1691 = (($sfb_partition$164$i) + 1)|0;
      $exitcond94$i = ($1691|0)==(4);
      if ($exitcond94$i) {
       $scale_bits$3$lcssa$i$lcssa = $scale_bits$3$lcssa$i;
       break;
      } else {
       $scale_bits$265$i = $scale_bits$3$lcssa$i;$sfb$466$i = $sfb$5$lcssa$i;$sfb_partition$164$i = $1691;
      }
     }
     $1692 = (((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4772|0);
     $1693 = HEAP32[$1692>>2]|0;
     $1694 = (((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4824|0);
     $1695 = HEAP32[$1694>>2]|0;
     $1696 = (($1695) + 1)|0;
     $1697 = (((($gfc)) + 21360|0) + ($1696<<2)|0);
     $1698 = HEAP32[$1697>>2]|0;
     $1699 = (((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4828|0);
     $1700 = HEAP32[$1699>>2]|0;
     $1701 = (($1695) + 2)|0;
     $1702 = (($1701) + ($1700))|0;
     $1703 = (((($gfc)) + 21360|0) + ($1702<<2)|0);
     $1704 = HEAP32[$1703>>2]|0;
     $1705 = ($1698|0)>($1693|0);
     $$$i$i = $1705 ? $1693 : $1698;
     $1706 = ($1704|0)>($1693|0);
     $region2Start$0$i$i = $1706 ? $1693 : $1704;
     $1707 = (((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4796|0);
     $1708 = HEAP32[$1707>>2]|0;
     $1709 = (_Huffmancode($gfc,$1708,0,$$$i$i,$1467)|0);
     $1710 = (((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4800|0);
     $1711 = HEAP32[$1710>>2]|0;
     $1712 = (_Huffmancode($gfc,$1711,$$$i$i,$region2Start$0$i$i,$1467)|0);
     $1713 = (($1712) + ($1709))|0;
     $1714 = (((((($gfc)) + 304|0) + (($ch$179$i*5252)|0)|0)) + 4804|0);
     $1715 = HEAP32[$1714>>2]|0;
     $1716 = (_Huffmancode($gfc,$1715,$region2Start$0$i$i,$1693,$1467)|0);
     $1717 = (($1713) + ($1716))|0;
     $data_bits$5$i = $1717;$scale_bits$4$i = $scale_bits$3$lcssa$i$lcssa;
    }
    $1718 = (_huffman_coder_count1($gfc,$1467)|0);
    $1719 = (($scale_bits$4$i) + ($tot_bits$278$i))|0;
    $1720 = (($1719) + ($data_bits$5$i))|0;
    $1721 = (($1720) + ($1718))|0;
    $1722 = (($ch$179$i) + 1)|0;
    $1723 = HEAP32[$1287>>2]|0;
    $1724 = ($1722|0)<($1723|0);
    if ($1724) {
     $ch$179$i = $1722;$tot_bits$278$i = $1721;
    } else {
     $$pre$phiZ2D = $1292;$tot_bits$3$i = $1721;
     break;
    }
   }
  }
 } while(0);
 $1725 = (($tot_bits$3$i) + ($1284))|0;
 $1726 = ((($gfc)) + 21324|0);
 $1727 = HEAP32[$1726>>2]|0;
 _drain_into_ancillary($gfc,$1727);
 $1728 = HEAP32[$1726>>2]|0;
 $1729 = (($1725) + ($1728))|0;
 $1730 = (($14) - ($1729))|0;
 $1731 = (($1730|0) / 8)&-1;
 $1732 = HEAP32[$298>>2]|0;
 $1733 = (($1732) + ($1731))|0;
 HEAP32[$298>>2] = $1733;
 $1734 = HEAP32[$1222>>2]|0;
 $1735 = HEAP32[$17>>2]|0;
 $1736 = (($1735) + -1)|0;
 $1737 = ($1735|0)==(0);
 $$$i = $1737 ? 255 : $1736;
 $1738 = (((($gfc)) + 39840|0) + (($$$i*48)|0)|0);
 $1739 = HEAP32[$1738>>2]|0;
 $1740 = HEAP32[$$pre$phiZ2D>>2]|0;
 $1741 = (($1739) - ($1740))|0;
 $1742 = ($1741|0)>(-1);
 if ($1742) {
  $1743 = (1 - ($1734))|0;
  $1744 = (($$$i) + ($1743))|0;
  $1745 = ($$$i|0)<($1734|0);
  $1746 = (($1744) + 256)|0;
  $$1$i = $1745 ? $1746 : $1744;
  $1747 = $$1$i << 3;
  $1748 = HEAP32[$21>>2]|0;
  $1749 = Math_imul($1747, $1748)|0;
  $1750 = (($1741) - ($1749))|0;
  $flushbits$0$i = $1750;
 } else {
  $flushbits$0$i = $1741;
 }
 $1751 = HEAP32[$1>>2]|0;
 $1752 = ($1751|0)==(0);
 if ($1752) {
  $1755 = ((($gfc)) + 120|0);
  $$idx$val$pre$i$i = HEAP32[$0>>2]|0;
  $$idx$val$i$i = $$idx$val$pre$i$i;$bit_rate$0$in$i$i = $1755;
 } else {
  $1753 = HEAP32[$0>>2]|0;
  $1754 = ((83944 + ($1753<<6)|0) + ($1751<<2)|0);
  $$idx$val$i$i = $1753;$bit_rate$0$in$i$i = $1754;
 }
 $bit_rate$0$i$i = HEAP32[$bit_rate$0$in$i$i>>2]|0;
 $1756 = HEAP32[$7>>2]|0;
 $$idx1$val$i$i = HEAP32[$$idx1$i>>2]|0;
 $1757 = ($$idx$val$i$i*72000)|0;
 $1758 = (($1757) + 72000)|0;
 $1759 = Math_imul($1758, $bit_rate$0$i$i)|0;
 $1760 = (($1759|0) / ($$idx1$val$i$i|0))&-1;
 $1761 = (($1760) + ($1756))|0;
 $1762 = $1761 << 3;
 $1763 = (($1762) + ($flushbits$0$i))|0;
 $1764 = ($1763|0)<(0);
 if ($1764) {
  _lame_errorf($gfc,1072,$vararg_buffer1);
 }
 $1765 = ((($gfc)) + 52140|0);
 $1766 = HEAP32[$1765>>2]|0;
 $1767 = ($1763|0)==($1766|0);
 if ($1767) {
  $1771 = $1763;
 } else {
  _lame_errorf($gfc,1168,$vararg_buffer3);
  $$pre = HEAP32[$1765>>2]|0;
  $1771 = $$pre;
 }
 $1768 = HEAP32[$298>>2]|0;
 $1769 = $1768 << 3;
 $1770 = ($1769|0)==($1771|0);
 if (!($1770)) {
  $1772 = HEAP32[$1726>>2]|0;
  $1773 = HEAP32[$15>>2]|0;
  $1774 = HEAP32[$21>>2]|0;
  $1775 = $1774 << 3;
  $1776 = (($1729) - ($1772))|0;
  $1777 = (($1776) - ($1775))|0;
  $1778 = (($1729|0) % 8)&-1;
  HEAP32[$vararg_buffer5>>2] = $1769;
  $vararg_ptr7 = ((($vararg_buffer5)) + 4|0);
  HEAP32[$vararg_ptr7>>2] = $1771;
  $vararg_ptr8 = ((($vararg_buffer5)) + 8|0);
  HEAP32[$vararg_ptr8>>2] = $1772;
  $vararg_ptr9 = ((($vararg_buffer5)) + 12|0);
  HEAP32[$vararg_ptr9>>2] = $1773;
  $vararg_ptr10 = ((($vararg_buffer5)) + 16|0);
  HEAP32[$vararg_ptr10>>2] = $1775;
  $vararg_ptr11 = ((($vararg_buffer5)) + 20|0);
  HEAP32[$vararg_ptr11>>2] = $1777;
  $vararg_ptr12 = ((($vararg_buffer5)) + 24|0);
  HEAP32[$vararg_ptr12>>2] = $1729;
  $vararg_ptr13 = ((($vararg_buffer5)) + 28|0);
  HEAP32[$vararg_ptr13>>2] = $1778;
  $vararg_ptr14 = ((($vararg_buffer5)) + 32|0);
  HEAP32[$vararg_ptr14>>2] = $14;
  _lame_errorf($gfc,1224,$vararg_buffer5);
  _lame_errorf($gfc,1504,$vararg_buffer15);
  _lame_errorf($gfc,1560,$vararg_buffer17);
  _lame_errorf($gfc,1640,$vararg_buffer19);
  _lame_errorf($gfc,1680,$vararg_buffer21);
  $1779 = HEAP32[$298>>2]|0;
  $1780 = $1779 << 3;
  HEAP32[$1765>>2] = $1780;
 }
 $1781 = HEAP32[$$pre$phiZ2D>>2]|0;
 $1782 = ($1781|0)>(1000000000);
 if ($1782) {
  $i$091 = 0;
 } else {
  STACKTOP = sp;return 0;
 }
 while(1) {
  $1783 = (((($gfc)) + 39840|0) + (($i$091*48)|0)|0);
  $1784 = HEAP32[$1783>>2]|0;
  $1785 = (($1784) - ($1781))|0;
  HEAP32[$1783>>2] = $1785;
  $1786 = (($i$091) + 1)|0;
  $exitcond = ($1786|0)==(256);
  if ($exitcond) {
   break;
  } else {
   $i$091 = $1786;
  }
 }
 HEAP32[$$pre$phiZ2D>>2] = 0;
 STACKTOP = sp;return 0;
}
function _copy_buffer($gfc,$buffer,$size,$mp3data) {
 $gfc = $gfc|0;
 $buffer = $buffer|0;
 $size = $size|0;
 $mp3data = $mp3data|0;
 var $$$i = 0, $$0 = 0, $$pre$i = 0.0, $$pre8$i = 0.0, $$pre8$i$lcssa = 0.0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0;
 var $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0.0, $32 = 0, $33 = 0.0, $34 = 0.0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0;
 var $40 = 0.0, $41 = 0, $42 = 0.0, $43 = 0.0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0.0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond$i = 0;
 var $exitcond7$i = 0, $i$03$i = 0, $i$14$i = 0, $mp3_in$06$i = 0, $or$cond$i = 0, $pcm_buf$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 9216|0;
 $pcm_buf$i = sp;
 $0 = ((($gfc)) + 296|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = (($1) + 1)|0;
 $3 = ($1|0)<(0);
 if ($3) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $4 = ($size|0)==(0);
 $5 = ($1|0)<($size|0);
 $or$cond$i = $4 | $5;
 if (!($or$cond$i)) {
  $$0 = -1;
  STACKTOP = sp;return ($$0|0);
 }
 $6 = ((($gfc)) + 284|0);
 $7 = HEAP32[$6>>2]|0;
 _memcpy(($buffer|0),($7|0),($2|0))|0;
 HEAP32[$0>>2] = -1;
 $8 = ((($gfc)) + 300|0);
 HEAP32[$8>>2] = 0;
 $9 = ($mp3data|0)==(0);
 if ($9) {
  $$0 = $2;
  STACKTOP = sp;return ($$0|0);
 }
 $10 = ((($gfc)) + 85752|0);
 _UpdateMusicCRC($10,$buffer,$2);
 $11 = ((($gfc)) + 85788|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = (($12) + ($2))|0;
 HEAP32[$11>>2] = $13;
 $14 = ((($gfc)) + 136|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = ($15|0)==(0);
 if ($16) {
  $$0 = $2;
  STACKTOP = sp;return ($$0|0);
 }
 $17 = ((($gfc)) + 85808|0);
 $18 = ((($pcm_buf$i)) + 4608|0);
 $19 = ((($gfc)) + 132|0);
 $20 = ((($gfc)) + 128|0);
 $21 = ((($gfc)) + 85676|0);
 $22 = ((($gfc)) + 72|0);
 $23 = ((($gfc)) + 85684|0);
 $mp3_in$06$i = $2;
 while(1) {
  $24 = HEAP32[$17>>2]|0;
  $25 = (_hip_decode1_unclipped(($24|0),($buffer|0),($mp3_in$06$i|0),($pcm_buf$i|0),($18|0))|0);
  $26 = ($25|0)==(-1);
  $$$i = $26 ? 0 : $25;
  $27 = ($$$i|0)>(0);
  if ($27) {
   $28 = HEAP32[$19>>2]|0;
   $29 = ($28|0)==(0);
   if (!($29)) {
    $$pre$i = +HEAPF32[$23>>2];
    $33 = $$pre$i;$i$03$i = 0;
    while(1) {
     $30 = (($pcm_buf$i) + ($i$03$i<<2)|0);
     $31 = +HEAPF32[$30>>2];
     $32 = $31 > $33;
     if ($32) {
      HEAPF32[$23>>2] = $31;
      $$pre8$i = $31;
     } else {
      $34 = -$31;
      $35 = $33 < $34;
      if ($35) {
       HEAPF32[$23>>2] = $34;
       $$pre8$i = $34;
      } else {
       $$pre8$i = $33;
      }
     }
     $36 = (($i$03$i) + 1)|0;
     $exitcond$i = ($36|0)==($$$i|0);
     if ($exitcond$i) {
      $$pre8$i$lcssa = $$pre8$i;
      break;
     } else {
      $33 = $$pre8$i;$i$03$i = $36;
     }
    }
    $37 = HEAP32[$22>>2]|0;
    $38 = ($37|0)>(1);
    if ($38) {
     $42 = $$pre8$i$lcssa;$i$14$i = 0;
     while(1) {
      $39 = (((($pcm_buf$i)) + 4608|0) + ($i$14$i<<2)|0);
      $40 = +HEAPF32[$39>>2];
      $41 = $40 > $42;
      if ($41) {
       HEAPF32[$23>>2] = $40;
       $53 = $40;
      } else {
       $43 = -$40;
       $44 = $42 < $43;
       if ($44) {
        HEAPF32[$23>>2] = $43;
        $53 = $43;
       } else {
        $53 = $42;
       }
      }
      $45 = (($i$14$i) + 1)|0;
      $exitcond7$i = ($45|0)==($$$i|0);
      if ($exitcond7$i) {
       break;
      } else {
       $42 = $53;$i$14$i = $45;
      }
     }
    }
   }
   $46 = HEAP32[$20>>2]|0;
   $47 = ($46|0)==(0);
   if (!($47)) {
    $48 = HEAP32[$21>>2]|0;
    $49 = HEAP32[$22>>2]|0;
    $50 = (_AnalyzeSamples(($48|0),($pcm_buf$i|0),($18|0),($$$i|0),($49|0))|0);
    $51 = ($50|0)==(0);
    if ($51) {
     label = 24;
     break;
    }
   }
  }
  $52 = ($$$i|0)==(0);
  if ($52) {
   label = 23;
   break;
  } else {
   $mp3_in$06$i = 0;
  }
 }
 if ((label|0) == 23) {
  $$0 = $2;
  STACKTOP = sp;return ($$0|0);
 }
 else if ((label|0) == 24) {
  $$0 = -6;
  STACKTOP = sp;return ($$0|0);
 }
 return (0)|0;
}
function _init_bit_stream_w($gfc) {
 $gfc = $gfc|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($gfc)) + 52132|0);
 HEAP32[$0>>2] = 0;
 $1 = ((($gfc)) + 52128|0);
 HEAP32[$1>>2] = 0;
 $2 = ((($gfc)) + 39840|0);
 HEAP32[$2>>2] = 0;
 $3 = (_malloc(147456)|0);
 $4 = ((($gfc)) + 284|0);
 HEAP32[$4>>2] = $3;
 $5 = ((($gfc)) + 288|0);
 HEAP32[$5>>2] = 147456;
 $6 = ((($gfc)) + 296|0);
 HEAP32[$6>>2] = -1;
 $7 = ((($gfc)) + 300|0);
 HEAP32[$7>>2] = 0;
 $8 = ((($gfc)) + 292|0);
 HEAP32[$8>>2] = 0;
 return;
}
function _drain_into_ancillary($gfc,$remainingBits) {
 $gfc = $gfc|0;
 $remainingBits = $remainingBits|0;
 var $$0$$i = 0, $$0$$i11 = 0, $$0$$i15 = 0, $$0$$i19 = 0, $$0$$i3 = 0, $$0$$i7 = 0, $$01$i = 0, $$01$i1 = 0, $$01$i13 = 0, $$01$i17 = 0, $$01$i5 = 0, $$01$i9 = 0, $$428 = 0, $$5$ph = 0, $$5$ph30 = 0, $$526 = 0, $$lcssa42 = 0, $$lcssa43 = 0, $$lcssa44 = 0, $$pre = 0;
 var $$pre$i = 0, $$pre$i10 = 0, $$pre$i14 = 0, $$pre$i18 = 0, $$pre$i2 = 0, $$pre$i6 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0;
 var $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0;
 var $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0;
 var $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0;
 var $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0;
 var $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0;
 var $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0;
 var $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0;
 var $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0;
 var $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0;
 var $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $3 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $i$027 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($remainingBits|0)>(7);
 if ($0) {
  $10 = ((($gfc)) + 300|0);
  $11 = ((($gfc)) + 296|0);
  $12 = ((($gfc)) + 52132|0);
  $13 = ((($gfc)) + 292|0);
  $14 = ((($gfc)) + 284|0);
  $15 = ((($gfc)) + 24|0);
  $$01$i = 8;
  while(1) {
   $16 = HEAP32[$10>>2]|0;
   $17 = ($16|0)==(0);
   if ($17) {
    HEAP32[$10>>2] = 8;
    $18 = HEAP32[$11>>2]|0;
    $19 = (($18) + 1)|0;
    HEAP32[$11>>2] = $19;
    $20 = HEAP32[$12>>2]|0;
    $21 = (((($gfc)) + 39840|0) + (($20*48)|0)|0);
    $22 = HEAP32[$21>>2]|0;
    $23 = HEAP32[$13>>2]|0;
    $24 = ($22|0)==($23|0);
    if ($24) {
     $25 = HEAP32[$14>>2]|0;
     $26 = (($25) + ($19)|0);
     $27 = (((((($gfc)) + 39840|0) + (($20*48)|0)|0)) + 8|0);
     $28 = HEAP32[$15>>2]|0;
     _memcpy(($26|0),($27|0),($28|0))|0;
     $29 = HEAP32[$15>>2]|0;
     $30 = HEAP32[$11>>2]|0;
     $31 = (($30) + ($29))|0;
     HEAP32[$11>>2] = $31;
     $32 = $29 << 3;
     $33 = HEAP32[$13>>2]|0;
     $34 = (($33) + ($32))|0;
     HEAP32[$13>>2] = $34;
     $35 = HEAP32[$12>>2]|0;
     $36 = (($35) + 1)|0;
     $37 = $36 & 255;
     HEAP32[$12>>2] = $37;
     $40 = $31;
    } else {
     $40 = $19;
    }
    $38 = HEAP32[$14>>2]|0;
    $39 = (($38) + ($40)|0);
    HEAP8[$39>>0] = 0;
    $$pre$i = HEAP32[$10>>2]|0;
    $42 = $$pre$i;
   } else {
    $42 = $16;
   }
   $41 = ($$01$i|0)<($42|0);
   $$0$$i = $41 ? $$01$i : $42;
   $43 = (($$01$i) - ($$0$$i))|0;
   $44 = (($42) - ($$0$$i))|0;
   HEAP32[$10>>2] = $44;
   $45 = 76 >>> $43;
   $46 = $45 << $44;
   $47 = HEAP32[$11>>2]|0;
   $48 = HEAP32[$14>>2]|0;
   $49 = (($48) + ($47)|0);
   $50 = HEAP8[$49>>0]|0;
   $51 = $50&255;
   $52 = $46 | $51;
   $53 = $52&255;
   HEAP8[$49>>0] = $53;
   $54 = HEAP32[$13>>2]|0;
   $55 = (($54) + ($$0$$i))|0;
   HEAP32[$13>>2] = $55;
   $56 = ($43|0)>(0);
   if ($56) {
    $$01$i = $43;
   } else {
    $$lcssa44 = $55;
    break;
   }
  }
  $57 = (($remainingBits) + -8)|0;
  $58 = ($57|0)>(7);
  if ($58) {
   $$01$i17 = 8;$67 = $$lcssa44;
   while(1) {
    $59 = HEAP32[$10>>2]|0;
    $60 = ($59|0)==(0);
    if ($60) {
     HEAP32[$10>>2] = 8;
     $61 = HEAP32[$11>>2]|0;
     $62 = (($61) + 1)|0;
     HEAP32[$11>>2] = $62;
     $63 = HEAP32[$12>>2]|0;
     $64 = (((($gfc)) + 39840|0) + (($63*48)|0)|0);
     $65 = HEAP32[$64>>2]|0;
     $66 = ($65|0)==($67|0);
     if ($66) {
      $68 = HEAP32[$14>>2]|0;
      $69 = (($68) + ($62)|0);
      $70 = (((((($gfc)) + 39840|0) + (($63*48)|0)|0)) + 8|0);
      $71 = HEAP32[$15>>2]|0;
      _memcpy(($69|0),($70|0),($71|0))|0;
      $72 = HEAP32[$15>>2]|0;
      $73 = HEAP32[$11>>2]|0;
      $74 = (($73) + ($72))|0;
      HEAP32[$11>>2] = $74;
      $75 = $72 << 3;
      $76 = HEAP32[$13>>2]|0;
      $77 = (($76) + ($75))|0;
      HEAP32[$13>>2] = $77;
      $78 = HEAP32[$12>>2]|0;
      $79 = (($78) + 1)|0;
      $80 = $79 & 255;
      HEAP32[$12>>2] = $80;
      $83 = $74;
     } else {
      $83 = $62;
     }
     $81 = HEAP32[$14>>2]|0;
     $82 = (($81) + ($83)|0);
     HEAP8[$82>>0] = 0;
     $$pre$i18 = HEAP32[$10>>2]|0;
     $85 = $$pre$i18;
    } else {
     $85 = $59;
    }
    $84 = ($$01$i17|0)<($85|0);
    $$0$$i19 = $84 ? $$01$i17 : $85;
    $86 = (($$01$i17) - ($$0$$i19))|0;
    $87 = (($85) - ($$0$$i19))|0;
    HEAP32[$10>>2] = $87;
    $88 = 65 >>> $86;
    $89 = $88 << $87;
    $90 = HEAP32[$11>>2]|0;
    $91 = HEAP32[$14>>2]|0;
    $92 = (($91) + ($90)|0);
    $93 = HEAP8[$92>>0]|0;
    $94 = $93&255;
    $95 = $89 | $94;
    $96 = $95&255;
    HEAP8[$92>>0] = $96;
    $97 = HEAP32[$13>>2]|0;
    $98 = (($97) + ($$0$$i19))|0;
    HEAP32[$13>>2] = $98;
    $99 = ($86|0)>(0);
    if ($99) {
     $$01$i17 = $86;$67 = $98;
    } else {
     $$lcssa43 = $98;
     break;
    }
   }
   $100 = (($remainingBits) + -16)|0;
   $101 = ($100|0)>(7);
   if ($101) {
    $$01$i13 = 8;$110 = $$lcssa43;
    while(1) {
     $102 = HEAP32[$10>>2]|0;
     $103 = ($102|0)==(0);
     if ($103) {
      HEAP32[$10>>2] = 8;
      $104 = HEAP32[$11>>2]|0;
      $105 = (($104) + 1)|0;
      HEAP32[$11>>2] = $105;
      $106 = HEAP32[$12>>2]|0;
      $107 = (((($gfc)) + 39840|0) + (($106*48)|0)|0);
      $108 = HEAP32[$107>>2]|0;
      $109 = ($108|0)==($110|0);
      if ($109) {
       $111 = HEAP32[$14>>2]|0;
       $112 = (($111) + ($105)|0);
       $113 = (((((($gfc)) + 39840|0) + (($106*48)|0)|0)) + 8|0);
       $114 = HEAP32[$15>>2]|0;
       _memcpy(($112|0),($113|0),($114|0))|0;
       $115 = HEAP32[$15>>2]|0;
       $116 = HEAP32[$11>>2]|0;
       $117 = (($116) + ($115))|0;
       HEAP32[$11>>2] = $117;
       $118 = $115 << 3;
       $119 = HEAP32[$13>>2]|0;
       $120 = (($119) + ($118))|0;
       HEAP32[$13>>2] = $120;
       $121 = HEAP32[$12>>2]|0;
       $122 = (($121) + 1)|0;
       $123 = $122 & 255;
       HEAP32[$12>>2] = $123;
       $126 = $117;
      } else {
       $126 = $105;
      }
      $124 = HEAP32[$14>>2]|0;
      $125 = (($124) + ($126)|0);
      HEAP8[$125>>0] = 0;
      $$pre$i14 = HEAP32[$10>>2]|0;
      $128 = $$pre$i14;
     } else {
      $128 = $102;
     }
     $127 = ($$01$i13|0)<($128|0);
     $$0$$i15 = $127 ? $$01$i13 : $128;
     $129 = (($$01$i13) - ($$0$$i15))|0;
     $130 = (($128) - ($$0$$i15))|0;
     HEAP32[$10>>2] = $130;
     $131 = 77 >>> $129;
     $132 = $131 << $130;
     $133 = HEAP32[$11>>2]|0;
     $134 = HEAP32[$14>>2]|0;
     $135 = (($134) + ($133)|0);
     $136 = HEAP8[$135>>0]|0;
     $137 = $136&255;
     $138 = $132 | $137;
     $139 = $138&255;
     HEAP8[$135>>0] = $139;
     $140 = HEAP32[$13>>2]|0;
     $141 = (($140) + ($$0$$i15))|0;
     HEAP32[$13>>2] = $141;
     $142 = ($129|0)>(0);
     if ($142) {
      $$01$i13 = $129;$110 = $141;
     } else {
      $$lcssa42 = $141;
      break;
     }
    }
    $143 = (($remainingBits) + -24)|0;
    $144 = ($143|0)>(7);
    if ($144) {
     $$01$i9 = 8;$153 = $$lcssa42;
     while(1) {
      $145 = HEAP32[$10>>2]|0;
      $146 = ($145|0)==(0);
      if ($146) {
       HEAP32[$10>>2] = 8;
       $147 = HEAP32[$11>>2]|0;
       $148 = (($147) + 1)|0;
       HEAP32[$11>>2] = $148;
       $149 = HEAP32[$12>>2]|0;
       $150 = (((($gfc)) + 39840|0) + (($149*48)|0)|0);
       $151 = HEAP32[$150>>2]|0;
       $152 = ($151|0)==($153|0);
       if ($152) {
        $154 = HEAP32[$14>>2]|0;
        $155 = (($154) + ($148)|0);
        $156 = (((((($gfc)) + 39840|0) + (($149*48)|0)|0)) + 8|0);
        $157 = HEAP32[$15>>2]|0;
        _memcpy(($155|0),($156|0),($157|0))|0;
        $158 = HEAP32[$15>>2]|0;
        $159 = HEAP32[$11>>2]|0;
        $160 = (($159) + ($158))|0;
        HEAP32[$11>>2] = $160;
        $161 = $158 << 3;
        $162 = HEAP32[$13>>2]|0;
        $163 = (($162) + ($161))|0;
        HEAP32[$13>>2] = $163;
        $164 = HEAP32[$12>>2]|0;
        $165 = (($164) + 1)|0;
        $166 = $165 & 255;
        HEAP32[$12>>2] = $166;
        $169 = $160;
       } else {
        $169 = $148;
       }
       $167 = HEAP32[$14>>2]|0;
       $168 = (($167) + ($169)|0);
       HEAP8[$168>>0] = 0;
       $$pre$i10 = HEAP32[$10>>2]|0;
       $171 = $$pre$i10;
      } else {
       $171 = $145;
      }
      $170 = ($$01$i9|0)<($171|0);
      $$0$$i11 = $170 ? $$01$i9 : $171;
      $172 = (($$01$i9) - ($$0$$i11))|0;
      $173 = (($171) - ($$0$$i11))|0;
      HEAP32[$10>>2] = $173;
      $174 = 69 >>> $172;
      $175 = $174 << $173;
      $176 = HEAP32[$11>>2]|0;
      $177 = HEAP32[$14>>2]|0;
      $178 = (($177) + ($176)|0);
      $179 = HEAP8[$178>>0]|0;
      $180 = $179&255;
      $181 = $175 | $180;
      $182 = $181&255;
      HEAP8[$178>>0] = $182;
      $183 = HEAP32[$13>>2]|0;
      $184 = (($183) + ($$0$$i11))|0;
      HEAP32[$13>>2] = $184;
      $185 = ($172|0)>(0);
      if ($185) {
       $$01$i9 = $172;$153 = $184;
      } else {
       break;
      }
     }
     $186 = (($remainingBits) + -32)|0;
     $187 = ($186|0)>(31);
     if ($187) {
      $188 = (_get_lame_short_version()|0);
      $189 = (_strlen(($188|0))|0);
      $190 = ($189|0)>(0);
      if ($190) {
       $$428 = $186;$i$027 = 0;
       while(1) {
        $191 = (($188) + ($i$027)|0);
        $192 = HEAP8[$191>>0]|0;
        $193 = $192 << 24 >> 24;
        $$01$i5 = 8;
        while(1) {
         $194 = HEAP32[$10>>2]|0;
         $195 = ($194|0)==(0);
         if ($195) {
          HEAP32[$10>>2] = 8;
          $196 = HEAP32[$11>>2]|0;
          $197 = (($196) + 1)|0;
          HEAP32[$11>>2] = $197;
          $198 = HEAP32[$12>>2]|0;
          $199 = (((($gfc)) + 39840|0) + (($198*48)|0)|0);
          $200 = HEAP32[$199>>2]|0;
          $201 = HEAP32[$13>>2]|0;
          $202 = ($200|0)==($201|0);
          if ($202) {
           $203 = HEAP32[$14>>2]|0;
           $204 = (($203) + ($197)|0);
           $205 = (((((($gfc)) + 39840|0) + (($198*48)|0)|0)) + 8|0);
           $206 = HEAP32[$15>>2]|0;
           _memcpy(($204|0),($205|0),($206|0))|0;
           $207 = HEAP32[$15>>2]|0;
           $208 = HEAP32[$11>>2]|0;
           $209 = (($208) + ($207))|0;
           HEAP32[$11>>2] = $209;
           $210 = $207 << 3;
           $211 = HEAP32[$13>>2]|0;
           $212 = (($211) + ($210))|0;
           HEAP32[$13>>2] = $212;
           $213 = HEAP32[$12>>2]|0;
           $214 = (($213) + 1)|0;
           $215 = $214 & 255;
           HEAP32[$12>>2] = $215;
           $218 = $209;
          } else {
           $218 = $197;
          }
          $216 = HEAP32[$14>>2]|0;
          $217 = (($216) + ($218)|0);
          HEAP8[$217>>0] = 0;
          $$pre$i6 = HEAP32[$10>>2]|0;
          $220 = $$pre$i6;
         } else {
          $220 = $194;
         }
         $219 = ($$01$i5|0)<($220|0);
         $$0$$i7 = $219 ? $$01$i5 : $220;
         $221 = (($$01$i5) - ($$0$$i7))|0;
         $222 = (($220) - ($$0$$i7))|0;
         HEAP32[$10>>2] = $222;
         $223 = $193 >> $221;
         $224 = $223 << $222;
         $225 = HEAP32[$11>>2]|0;
         $226 = HEAP32[$14>>2]|0;
         $227 = (($226) + ($225)|0);
         $228 = HEAP8[$227>>0]|0;
         $229 = $228&255;
         $230 = $224 | $229;
         $231 = $230&255;
         HEAP8[$227>>0] = $231;
         $232 = HEAP32[$13>>2]|0;
         $233 = (($232) + ($$0$$i7))|0;
         HEAP32[$13>>2] = $233;
         $234 = ($221|0)>(0);
         if ($234) {
          $$01$i5 = $221;
         } else {
          break;
         }
        }
        $235 = (($$428) + -8)|0;
        $236 = (($i$027) + 1)|0;
        $237 = (_strlen(($188|0))|0);
        $238 = ($236|0)<($237|0);
        $239 = ($235|0)>(7);
        $240 = $239 & $238;
        if ($240) {
         $$428 = $235;$i$027 = $236;
        } else {
         $$5$ph = $235;
         label = 2;
         break;
        }
       }
      } else {
       $$5$ph30 = $186;
      }
     } else {
      $$5$ph = $186;
      label = 2;
     }
    } else {
     $$5$ph = $143;
     label = 2;
    }
   } else {
    $$5$ph = $100;
    label = 2;
   }
  } else {
   $$5$ph = $57;
   label = 2;
  }
 } else {
  $$5$ph = $remainingBits;
  label = 2;
 }
 if ((label|0) == 2) {
  $1 = ($$5$ph|0)>(0);
  if ($1) {
   $$5$ph30 = $$5$ph;
  } else {
   return;
  }
 }
 $2 = ((($gfc)) + 52136|0);
 $3 = ((($gfc)) + 300|0);
 $4 = ((($gfc)) + 296|0);
 $5 = ((($gfc)) + 52132|0);
 $6 = ((($gfc)) + 292|0);
 $7 = ((($gfc)) + 284|0);
 $8 = ((($gfc)) + 24|0);
 $9 = ((($gfc)) + 144|0);
 $$pre = HEAP32[$2>>2]|0;
 $$526 = $$5$ph30;$271 = $$pre;
 while(1) {
  $$01$i1 = 1;
  while(1) {
   $241 = HEAP32[$3>>2]|0;
   $242 = ($241|0)==(0);
   if ($242) {
    HEAP32[$3>>2] = 8;
    $243 = HEAP32[$4>>2]|0;
    $244 = (($243) + 1)|0;
    HEAP32[$4>>2] = $244;
    $245 = HEAP32[$5>>2]|0;
    $246 = (((($gfc)) + 39840|0) + (($245*48)|0)|0);
    $247 = HEAP32[$246>>2]|0;
    $248 = HEAP32[$6>>2]|0;
    $249 = ($247|0)==($248|0);
    if ($249) {
     $250 = HEAP32[$7>>2]|0;
     $251 = (($250) + ($244)|0);
     $252 = (((((($gfc)) + 39840|0) + (($245*48)|0)|0)) + 8|0);
     $253 = HEAP32[$8>>2]|0;
     _memcpy(($251|0),($252|0),($253|0))|0;
     $254 = HEAP32[$8>>2]|0;
     $255 = HEAP32[$4>>2]|0;
     $256 = (($255) + ($254))|0;
     HEAP32[$4>>2] = $256;
     $257 = $254 << 3;
     $258 = HEAP32[$6>>2]|0;
     $259 = (($258) + ($257))|0;
     HEAP32[$6>>2] = $259;
     $260 = HEAP32[$5>>2]|0;
     $261 = (($260) + 1)|0;
     $262 = $261 & 255;
     HEAP32[$5>>2] = $262;
     $265 = $256;
    } else {
     $265 = $244;
    }
    $263 = HEAP32[$7>>2]|0;
    $264 = (($263) + ($265)|0);
    HEAP8[$264>>0] = 0;
    $$pre$i2 = HEAP32[$3>>2]|0;
    $267 = $$pre$i2;
   } else {
    $267 = $241;
   }
   $266 = ($$01$i1|0)<($267|0);
   $$0$$i3 = $266 ? $$01$i1 : $267;
   $268 = (($$01$i1) - ($$0$$i3))|0;
   $269 = (($267) - ($$0$$i3))|0;
   HEAP32[$3>>2] = $269;
   $270 = $271 >> $268;
   $272 = $270 << $269;
   $273 = HEAP32[$4>>2]|0;
   $274 = HEAP32[$7>>2]|0;
   $275 = (($274) + ($273)|0);
   $276 = HEAP8[$275>>0]|0;
   $277 = $276&255;
   $278 = $272 | $277;
   $279 = $278&255;
   HEAP8[$275>>0] = $279;
   $280 = HEAP32[$6>>2]|0;
   $281 = (($280) + ($$0$$i3))|0;
   HEAP32[$6>>2] = $281;
   $282 = ($268|0)>(0);
   if ($282) {
    $$01$i1 = $268;
   } else {
    break;
   }
  }
  $283 = HEAP32[$9>>2]|0;
  $284 = ($283|0)==(0);
  $285 = $284&1;
  $286 = HEAP32[$2>>2]|0;
  $287 = $285 ^ $286;
  HEAP32[$2>>2] = $287;
  $288 = (($$526) + -1)|0;
  $289 = ($$526|0)>(1);
  if ($289) {
   $$526 = $288;$271 = $287;
  } else {
   break;
  }
 }
 return;
}
function _Huffmancode($gfc,$tableindex,$start,$end,$gi) {
 $gfc = $gfc|0;
 $tableindex = $tableindex|0;
 $start = $start|0;
 $end = $end|0;
 $gi = $gi|0;
 var $$0 = 0, $$0$$i = 0, $$0$$i4 = 0, $$01$i = 0, $$01$i2 = 0, $$pre$i = 0, $$pre$i3 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0;
 var $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0;
 var $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0;
 var $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0.0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0;
 var $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0.0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0;
 var $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0;
 var $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0;
 var $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $bits$015 = 0, $cbits$0 = 0, $cbits$1 = 0, $ext$0 = 0, $ext$1 = 0, $ext$2 = 0, $ext$4 = 0;
 var $ext$410 = 0, $ext$5 = 0, $ext$6 = 0, $i$016 = 0, $or$cond = 0, $x1$0 = 0, $x1$1 = 0, $x1$111 = 0, $x1$112 = 0, $x2$113 = 0, $x2$114 = 0, $xbits$0 = 0, $xbits$2 = 0, $xbits$26 = 0, $xbits$27 = 0, $xlen$0 = 0, $xlen$08 = 0, $xlen$09 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (82272 + ($tableindex<<4)|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($tableindex|0)!=(0);
 $3 = ($start|0)<($end|0);
 $or$cond = $2 & $3;
 if (!($or$cond)) {
  $$0 = 0;
  return ($$0|0);
 }
 $4 = ($tableindex>>>0)>(15);
 $5 = $1&65535;
 $6 = (((82272 + ($tableindex<<4)|0)) + 12|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = (((82272 + ($tableindex<<4)|0)) + 8|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($gfc)) + 300|0);
 $11 = ((($gfc)) + 296|0);
 $12 = ((($gfc)) + 52132|0);
 $13 = ((($gfc)) + 292|0);
 $14 = ((($gfc)) + 284|0);
 $15 = ((($gfc)) + 24|0);
 $bits$015 = 0;$i$016 = $start;
 while(1) {
  $16 = (((($gi)) + 2304|0) + ($i$016<<2)|0);
  $17 = HEAP32[$16>>2]|0;
  $18 = (($i$016) + 1)|0;
  $19 = (((($gi)) + 2304|0) + ($18<<2)|0);
  $20 = HEAP32[$19>>2]|0;
  $21 = ($17|0)==(0);
  if ($21) {
   $cbits$0 = 0;$ext$1 = 0;
  } else {
   $22 = (($gi) + ($i$016<<2)|0);
   $23 = +HEAPF32[$22>>2];
   $24 = $23 < 0.0;
   $ext$0 = $24&1;
   $cbits$0 = -1;$ext$1 = $ext$0;
  }
  if ($4) {
   $25 = ($17>>>0)>(14);
   if ($25) {
    $26 = $17 << 1;
    $27 = (($26) + 131042)|0;
    $28 = $27 & 131070;
    $29 = $ext$1 | $28;
    $ext$2 = $29;$x1$0 = 15;$xbits$0 = $5;
   } else {
    $ext$2 = $ext$1;$x1$0 = $17;$xbits$0 = 0;
   }
   $30 = ($20>>>0)>(14);
   if ($30) {
    $31 = (($20) + 65521)|0;
    $32 = $ext$2 << $1;
    $33 = $31 & 65535;
    $34 = $32 | $33;
    $35 = $xbits$0&65535;
    $36 = (($35) + ($1))|0;
    $37 = $36&65535;
    $ext$410 = $34;$x1$111 = $x1$0;$x2$113 = 15;$xbits$26 = $37;$xlen$08 = 16;
    label = 11;
   } else {
    $ext$4 = $ext$2;$x1$1 = $x1$0;$xbits$2 = $xbits$0;$xlen$0 = 16;
    label = 10;
   }
  } else {
   $ext$4 = $ext$1;$x1$1 = $17;$xbits$2 = 0;$xlen$0 = $1;
   label = 10;
  }
  if ((label|0) == 10) {
   label = 0;
   $38 = ($20|0)==(0);
   if ($38) {
    $cbits$1 = $cbits$0;$ext$6 = $ext$4;$x1$112 = $x1$1;$x2$114 = 0;$xbits$27 = $xbits$2;$xlen$09 = $xlen$0;
   } else {
    $ext$410 = $ext$4;$x1$111 = $x1$1;$x2$113 = $20;$xbits$26 = $xbits$2;$xlen$08 = $xlen$0;
    label = 11;
   }
  }
  if ((label|0) == 11) {
   label = 0;
   $39 = $ext$410 << 1;
   $40 = (($gi) + ($18<<2)|0);
   $41 = +HEAPF32[$40>>2];
   $42 = $41 < 0.0;
   $43 = $42&1;
   $ext$5 = $43 | $39;
   $44 = (($cbits$0) + -1)<<16>>16;
   $cbits$1 = $44;$ext$6 = $ext$5;$x1$112 = $x1$111;$x2$114 = $x2$113;$xbits$27 = $xbits$26;$xlen$09 = $xlen$08;
  }
  $45 = Math_imul($xlen$09, $x1$112)|0;
  $46 = (($45) + ($x2$114))|0;
  $47 = $cbits$1 << 16 >> 16;
  $48 = $xbits$27&65535;
  $49 = (($48) - ($47))|0;
  $50 = (($7) + ($46)|0);
  $51 = HEAP8[$50>>0]|0;
  $52 = $51&255;
  $53 = (($52) + ($47))|0;
  $54 = (($9) + ($46<<1)|0);
  $55 = HEAP16[$54>>1]|0;
  $56 = $55&65535;
  $57 = ($53|0)>(0);
  if ($57) {
   $$01$i = $53;
   while(1) {
    $58 = HEAP32[$10>>2]|0;
    $59 = ($58|0)==(0);
    if ($59) {
     HEAP32[$10>>2] = 8;
     $60 = HEAP32[$11>>2]|0;
     $61 = (($60) + 1)|0;
     HEAP32[$11>>2] = $61;
     $62 = HEAP32[$12>>2]|0;
     $63 = (((($gfc)) + 39840|0) + (($62*48)|0)|0);
     $64 = HEAP32[$63>>2]|0;
     $65 = HEAP32[$13>>2]|0;
     $66 = ($64|0)==($65|0);
     if ($66) {
      $67 = HEAP32[$14>>2]|0;
      $68 = (($67) + ($61)|0);
      $69 = (((((($gfc)) + 39840|0) + (($62*48)|0)|0)) + 8|0);
      $70 = HEAP32[$15>>2]|0;
      _memcpy(($68|0),($69|0),($70|0))|0;
      $71 = HEAP32[$15>>2]|0;
      $72 = HEAP32[$11>>2]|0;
      $73 = (($72) + ($71))|0;
      HEAP32[$11>>2] = $73;
      $74 = $71 << 3;
      $75 = HEAP32[$13>>2]|0;
      $76 = (($75) + ($74))|0;
      HEAP32[$13>>2] = $76;
      $77 = HEAP32[$12>>2]|0;
      $78 = (($77) + 1)|0;
      $79 = $78 & 255;
      HEAP32[$12>>2] = $79;
      $82 = $73;
     } else {
      $82 = $61;
     }
     $80 = HEAP32[$14>>2]|0;
     $81 = (($80) + ($82)|0);
     HEAP8[$81>>0] = 0;
     $$pre$i = HEAP32[$10>>2]|0;
     $84 = $$pre$i;
    } else {
     $84 = $58;
    }
    $83 = ($$01$i|0)<($84|0);
    $$0$$i = $83 ? $$01$i : $84;
    $85 = (($$01$i) - ($$0$$i))|0;
    $86 = (($84) - ($$0$$i))|0;
    HEAP32[$10>>2] = $86;
    $87 = $56 >>> $85;
    $88 = $87 << $86;
    $89 = HEAP32[$11>>2]|0;
    $90 = HEAP32[$14>>2]|0;
    $91 = (($90) + ($89)|0);
    $92 = HEAP8[$91>>0]|0;
    $93 = $92&255;
    $94 = $88 | $93;
    $95 = $94&255;
    HEAP8[$91>>0] = $95;
    $96 = HEAP32[$13>>2]|0;
    $97 = (($96) + ($$0$$i))|0;
    HEAP32[$13>>2] = $97;
    $98 = ($85|0)>(0);
    if ($98) {
     $$01$i = $85;
    } else {
     break;
    }
   }
  }
  $99 = $49 & 65535;
  $100 = ($99|0)==(0);
  if (!($100)) {
   $$01$i2 = $99;
   while(1) {
    $101 = HEAP32[$10>>2]|0;
    $102 = ($101|0)==(0);
    if ($102) {
     HEAP32[$10>>2] = 8;
     $103 = HEAP32[$11>>2]|0;
     $104 = (($103) + 1)|0;
     HEAP32[$11>>2] = $104;
     $105 = HEAP32[$12>>2]|0;
     $106 = (((($gfc)) + 39840|0) + (($105*48)|0)|0);
     $107 = HEAP32[$106>>2]|0;
     $108 = HEAP32[$13>>2]|0;
     $109 = ($107|0)==($108|0);
     if ($109) {
      $110 = HEAP32[$14>>2]|0;
      $111 = (($110) + ($104)|0);
      $112 = (((((($gfc)) + 39840|0) + (($105*48)|0)|0)) + 8|0);
      $113 = HEAP32[$15>>2]|0;
      _memcpy(($111|0),($112|0),($113|0))|0;
      $114 = HEAP32[$15>>2]|0;
      $115 = HEAP32[$11>>2]|0;
      $116 = (($115) + ($114))|0;
      HEAP32[$11>>2] = $116;
      $117 = $114 << 3;
      $118 = HEAP32[$13>>2]|0;
      $119 = (($118) + ($117))|0;
      HEAP32[$13>>2] = $119;
      $120 = HEAP32[$12>>2]|0;
      $121 = (($120) + 1)|0;
      $122 = $121 & 255;
      HEAP32[$12>>2] = $122;
      $125 = $116;
     } else {
      $125 = $104;
     }
     $123 = HEAP32[$14>>2]|0;
     $124 = (($123) + ($125)|0);
     HEAP8[$124>>0] = 0;
     $$pre$i3 = HEAP32[$10>>2]|0;
     $127 = $$pre$i3;
    } else {
     $127 = $101;
    }
    $126 = ($$01$i2|0)<($127|0);
    $$0$$i4 = $126 ? $$01$i2 : $127;
    $128 = (($$01$i2) - ($$0$$i4))|0;
    $129 = (($127) - ($$0$$i4))|0;
    HEAP32[$10>>2] = $129;
    $130 = $ext$6 >> $128;
    $131 = $130 << $129;
    $132 = HEAP32[$11>>2]|0;
    $133 = HEAP32[$14>>2]|0;
    $134 = (($133) + ($132)|0);
    $135 = HEAP8[$134>>0]|0;
    $136 = $135&255;
    $137 = $131 | $136;
    $138 = $137&255;
    HEAP8[$134>>0] = $138;
    $139 = HEAP32[$13>>2]|0;
    $140 = (($139) + ($$0$$i4))|0;
    HEAP32[$13>>2] = $140;
    $141 = ($128|0)>(0);
    if ($141) {
     $$01$i2 = $128;
    } else {
     break;
    }
   }
  }
  $142 = (($99) + ($bits$015))|0;
  $143 = (($142) + ($53))|0;
  $144 = (($i$016) + 2)|0;
  $145 = ($144|0)<($end|0);
  if ($145) {
   $bits$015 = $143;$i$016 = $144;
  } else {
   $$0 = $143;
   break;
  }
 }
 return ($$0|0);
}
function _huffman_coder_count1($gfc,$gi) {
 $gfc = $gfc|0;
 $gi = $gi|0;
 var $$0$$i = 0, $$01$i = 0, $$pre = 0, $$pre$i = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0;
 var $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0.0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0.0;
 var $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0.0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0.0;
 var $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0;
 var $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0;
 var $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $bits$0$lcssa = 0, $bits$02 = 0, $huffbits$0 = 0, $huffbits$1 = 0, $huffbits$2 = 0, $huffbits$3 = 0, $i$01 = 0;
 var $ix$03 = 0, $p$0 = 0, $p$1 = 0, $p$2 = 0, $p$3 = 0, $xr$04 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($gi)) + 4840|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = (($1) + 32)|0;
 $3 = ((($gi)) + 4772|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ((($gi)) + 4776|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = (($6) - ($4))|0;
 $8 = ($7|0)>(3);
 if (!($8)) {
  $bits$0$lcssa = 0;
  return ($bits$0$lcssa|0);
 }
 $9 = (($7|0) / 4)&-1;
 $10 = (($gi) + ($4<<2)|0);
 $11 = (((($gi)) + 2304|0) + ($4<<2)|0);
 $12 = (((82272 + ($2<<4)|0)) + 8|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = (((82272 + ($2<<4)|0)) + 12|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = ((($gfc)) + 300|0);
 $17 = ((($gfc)) + 296|0);
 $18 = ((($gfc)) + 52132|0);
 $19 = ((($gfc)) + 292|0);
 $20 = ((($gfc)) + 284|0);
 $21 = ((($gfc)) + 24|0);
 $bits$02 = 0;$i$01 = $9;$ix$03 = $11;$xr$04 = $10;
 while(1) {
  $22 = HEAP32[$ix$03>>2]|0;
  $23 = ($22|0)==(0);
  if ($23) {
   $huffbits$0 = 0;$p$0 = 0;
  } else {
   $24 = +HEAPF32[$xr$04>>2];
   $25 = $24 < 0.0;
   if ($25) {
    $huffbits$0 = 1;$p$0 = 8;
   } else {
    $huffbits$0 = 0;$p$0 = 8;
   }
  }
  $26 = ((($ix$03)) + 4|0);
  $27 = HEAP32[$26>>2]|0;
  $28 = ($27|0)==(0);
  if ($28) {
   $huffbits$1 = $huffbits$0;$p$1 = $p$0;
  } else {
   $29 = $p$0 | 4;
   $30 = $huffbits$0 << 1;
   $31 = ((($xr$04)) + 4|0);
   $32 = +HEAPF32[$31>>2];
   $33 = $32 < 0.0;
   if ($33) {
    $34 = $30 | 1;
    $huffbits$1 = $34;$p$1 = $29;
   } else {
    $huffbits$1 = $30;$p$1 = $29;
   }
  }
  $35 = ((($ix$03)) + 8|0);
  $36 = HEAP32[$35>>2]|0;
  $37 = ($36|0)==(0);
  if ($37) {
   $huffbits$2 = $huffbits$1;$p$2 = $p$1;
  } else {
   $38 = (($p$1) + 2)|0;
   $39 = $huffbits$1 << 1;
   $40 = ((($xr$04)) + 8|0);
   $41 = +HEAPF32[$40>>2];
   $42 = $41 < 0.0;
   if ($42) {
    $43 = $39 | 1;
    $huffbits$2 = $43;$p$2 = $38;
   } else {
    $huffbits$2 = $39;$p$2 = $38;
   }
  }
  $44 = ((($ix$03)) + 12|0);
  $45 = HEAP32[$44>>2]|0;
  $46 = ($45|0)==(0);
  if ($46) {
   $huffbits$3 = $huffbits$2;$p$3 = $p$2;
  } else {
   $47 = (($p$2) + 1)|0;
   $48 = $huffbits$2 << 1;
   $49 = ((($xr$04)) + 12|0);
   $50 = +HEAPF32[$49>>2];
   $51 = $50 < 0.0;
   if ($51) {
    $52 = $48 | 1;
    $huffbits$3 = $52;$p$3 = $47;
   } else {
    $huffbits$3 = $48;$p$3 = $47;
   }
  }
  $53 = ((($ix$03)) + 16|0);
  $54 = ((($xr$04)) + 16|0);
  $55 = (($13) + ($p$3<<1)|0);
  $56 = HEAP16[$55>>1]|0;
  $57 = $56&65535;
  $58 = (($57) + ($huffbits$3))|0;
  $59 = (($15) + ($p$3)|0);
  $60 = HEAP8[$59>>0]|0;
  $61 = ($60<<24>>24)==(0);
  if ($61) {
   $105 = 0;
  } else {
   $62 = $60&255;
   $$01$i = $62;
   while(1) {
    $63 = HEAP32[$16>>2]|0;
    $64 = ($63|0)==(0);
    if ($64) {
     HEAP32[$16>>2] = 8;
     $65 = HEAP32[$17>>2]|0;
     $66 = (($65) + 1)|0;
     HEAP32[$17>>2] = $66;
     $67 = HEAP32[$18>>2]|0;
     $68 = (((($gfc)) + 39840|0) + (($67*48)|0)|0);
     $69 = HEAP32[$68>>2]|0;
     $70 = HEAP32[$19>>2]|0;
     $71 = ($69|0)==($70|0);
     if ($71) {
      $72 = HEAP32[$20>>2]|0;
      $73 = (($72) + ($66)|0);
      $74 = (((((($gfc)) + 39840|0) + (($67*48)|0)|0)) + 8|0);
      $75 = HEAP32[$21>>2]|0;
      _memcpy(($73|0),($74|0),($75|0))|0;
      $76 = HEAP32[$21>>2]|0;
      $77 = HEAP32[$17>>2]|0;
      $78 = (($77) + ($76))|0;
      HEAP32[$17>>2] = $78;
      $79 = $76 << 3;
      $80 = HEAP32[$19>>2]|0;
      $81 = (($80) + ($79))|0;
      HEAP32[$19>>2] = $81;
      $82 = HEAP32[$18>>2]|0;
      $83 = (($82) + 1)|0;
      $84 = $83 & 255;
      HEAP32[$18>>2] = $84;
      $87 = $78;
     } else {
      $87 = $66;
     }
     $85 = HEAP32[$20>>2]|0;
     $86 = (($85) + ($87)|0);
     HEAP8[$86>>0] = 0;
     $$pre$i = HEAP32[$16>>2]|0;
     $89 = $$pre$i;
    } else {
     $89 = $63;
    }
    $88 = ($$01$i|0)<($89|0);
    $$0$$i = $88 ? $$01$i : $89;
    $90 = (($$01$i) - ($$0$$i))|0;
    $91 = (($89) - ($$0$$i))|0;
    HEAP32[$16>>2] = $91;
    $92 = $58 >> $90;
    $93 = $92 << $91;
    $94 = HEAP32[$17>>2]|0;
    $95 = HEAP32[$20>>2]|0;
    $96 = (($95) + ($94)|0);
    $97 = HEAP8[$96>>0]|0;
    $98 = $97&255;
    $99 = $93 | $98;
    $100 = $99&255;
    HEAP8[$96>>0] = $100;
    $101 = HEAP32[$19>>2]|0;
    $102 = (($101) + ($$0$$i))|0;
    HEAP32[$19>>2] = $102;
    $103 = ($90|0)>(0);
    if ($103) {
     $$01$i = $90;
    } else {
     break;
    }
   }
   $$pre = HEAP8[$59>>0]|0;
   $105 = $$pre;
  }
  $104 = $105&255;
  $106 = (($104) + ($bits$02))|0;
  $107 = (($i$01) + -1)|0;
  $108 = ($i$01|0)>(1);
  if ($108) {
   $bits$02 = $106;$i$01 = $107;$ix$03 = $53;$xr$04 = $54;
  } else {
   $bits$0$lcssa = $106;
   break;
  }
 }
 return ($bits$0$lcssa|0);
}
function _lame_encode_mp3_frame($gfc,$inbuf_l,$inbuf_r,$mp3buf,$mp3buf_size) {
 $gfc = $gfc|0;
 $inbuf_l = $inbuf_l|0;
 $inbuf_r = $inbuf_r|0;
 $mp3buf = $mp3buf|0;
 $mp3buf_size = $mp3buf_size|0;
 var $$$i = 0, $$0 = 0, $$lcssa = 0, $$lcssa116 = 0.0, $$lcssa117 = 0, $$lcssa118 = 0.0, $$lcssa118$lcssa = 0.0, $$lcssa119 = 0.0, $$lcssa119$lcssa = 0.0, $$lcssa121 = 0, $$pn$i = 0.0, $$pn1$i = 0.0, $$pre = 0, $$pre$i = 0, $$pre$i2 = 0, $$pre$i4 = 0, $$pre$phi$iZ2D = 0, $$pre10$i = 0, $$pre6$i = 0, $$pre92 = 0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0.0, $102 = 0, $103 = 0.0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0.0, $109 = 0, $11 = 0, $110 = 0.0, $111 = 0, $112 = 0, $113 = 0, $114 = 0.0, $115 = 0;
 var $116 = 0.0, $117 = 0.0, $118 = 0.0, $119 = 0, $12 = 0, $120 = 0, $121 = 0.0, $122 = 0, $123 = 0, $124 = 0.0, $125 = 0, $126 = 0.0, $127 = 0.0, $128 = 0.0, $129 = 0.0, $13 = 0, $130 = 0, $131 = 0.0, $132 = 0, $133 = 0.0;
 var $134 = 0.0, $135 = 0.0, $136 = 0.0, $137 = 0.0, $138 = 0.0, $139 = 0, $14 = 0, $140 = 0, $141 = 0.0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0.0, $162 = 0.0, $163 = 0, $164 = 0.0, $165 = 0.0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0.0, $195 = 0.0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0.0, $204 = 0.0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0.0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0.0, $265 = 0.0, $266 = 0.0, $267 = 0.0, $268 = 0.0, $269 = 0.0, $27 = 0, $270 = 0.0, $271 = 0.0, $272 = 0.0, $273 = 0.0, $274 = 0.0, $275 = 0.0, $276 = 0.0, $277 = 0.0, $278 = 0.0;
 var $279 = 0.0, $28 = 0, $280 = 0.0, $281 = 0.0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0.0, $289 = 0.0, $29 = 0, $290 = 0, $291 = 0, $292 = 0.0, $293 = 0.0, $294 = 0.0, $295 = 0.0, $296 = 0.0;
 var $297 = 0.0, $298 = 0.0, $299 = 0.0, $3 = 0, $30 = 0, $300 = 0.0, $301 = 0.0, $302 = 0.0, $303 = 0.0, $304 = 0.0, $305 = 0.0, $306 = 0.0, $307 = 0.0, $308 = 0.0, $309 = 0.0, $31 = 0, $310 = 0.0, $311 = 0.0, $312 = 0.0, $313 = 0.0;
 var $314 = 0.0, $315 = 0.0, $316 = 0.0, $317 = 0.0, $318 = 0.0, $319 = 0, $32 = 0, $320 = 0, $321 = 0.0, $322 = 0.0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0.0, $328 = 0.0, $329 = 0, $33 = 0, $330 = 0, $331 = 0;
 var $332 = 0, $333 = 0, $334 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0;
 var $350 = 0, $351 = 0.0, $352 = 0, $353 = 0, $354 = 0, $355 = 0, $356 = 0.0, $357 = 0.0, $358 = 0, $359 = 0, $36 = 0, $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0;
 var $369 = 0, $37 = 0, $370 = 0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $379 = 0, $38 = 0, $380 = 0, $381 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0, $386 = 0;
 var $387 = 0, $388 = 0, $389 = 0, $39 = 0, $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $396 = 0, $397 = 0, $398 = 0, $399 = 0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0;
 var $404 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0, $409 = 0, $41 = 0, $410 = 0, $411 = 0, $412 = 0, $413 = 0, $414 = 0, $415 = 0, $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0;
 var $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0.0, $78 = 0, $79 = 0.0, $8 = 0;
 var $80 = 0.0, $81 = 0, $82 = 0, $83 = 0.0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0;
 var $99 = 0, $blocktype = 0, $bufp = 0, $ch$02$i = 0, $ch$02$i8 = 0, $ch$069 = 0, $ch$173 = 0, $ch$254$us = 0, $ch$349 = 0, $ch$439$us = 0, $ch$533$us = 0, $ch$632 = 0, $exitcond = 0, $exitcond86 = 0, $exitcond91 = 0, $f$0$lcssa = 0.0, $f$045$us = 0.0, $f$140$us = 0.0, $gr$03$i = 0, $gr$03$i6 = 0;
 var $gr$076 = 0, $gr$161$us = 0, $gr$252 = 0, $gr$343$us = 0, $gr$435$us = 0, $gr2_max$0$i = 0.0, $i$06$i = 0, $inbuf = 0, $j$030 = 0, $j$07$i = 0, $j$1$i = 0, $j$131 = 0, $masking_LR = 0, $masking_MS = 0, $masking_MS$sink = 0, $max_pow$0$i = 0.0, $max_pow$1$i = 0.0, $ms_ener_ratio = 0, $or$cond = 0, $or$cond101 = 0;
 var $pe = 0, $pe_MS = 0, $primebuff0$i = 0, $primebuff1$i = 0, $sum_pe_LR$064$us = 0.0, $sum_pe_LR$156$us = 0.0, $sum_pe_MS$063$us = 0.0, $sum_pe_MS$155$us = 0.0, $tot_ener = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 20112|0;
 $primebuff0$i = sp + 12056|0;
 $primebuff1$i = sp + 4000|0;
 $masking_LR = sp + 2048|0;
 $masking_MS = sp + 96|0;
 $inbuf = sp + 88|0;
 $tot_ener = sp + 56|0;
 $ms_ener_ratio = sp + 8|0;
 $pe = sp + 40|0;
 $pe_MS = sp + 24|0;
 $bufp = sp;
 $blocktype = sp + 16|0;
 $0 = $ms_ener_ratio;
 $1 = $0;
 HEAP32[$1>>2] = 1056964608;
 $2 = (($0) + 4)|0;
 $3 = $2;
 HEAP32[$3>>2] = 1056964608;
 ;HEAP32[$pe>>2]=0|0;HEAP32[$pe+4>>2]=0|0;HEAP32[$pe+8>>2]=0|0;HEAP32[$pe+12>>2]=0|0;
 ;HEAP32[$pe_MS>>2]=0|0;HEAP32[$pe_MS+4>>2]=0|0;HEAP32[$pe_MS+8>>2]=0|0;HEAP32[$pe_MS+12>>2]=0|0;
 HEAP32[$inbuf>>2] = $inbuf_l;
 $4 = ((($inbuf)) + 4|0);
 HEAP32[$4>>2] = $inbuf_r;
 $5 = ((($gfc)) + 4|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = ($6|0)==(0);
 if ($7) {
  $8 = ((($gfc)) + 76|0);
  $9 = HEAP32[$8>>2]|0;
  $10 = ($9*576)|0;
  HEAP32[$5>>2] = 1;
  _memset(($primebuff0$i|0),0,8056)|0;
  _memset(($primebuff1$i|0),0,8056)|0;
  $11 = (($10) + 862)|0;
  $12 = ($11|0)>(0);
  if ($12) {
   $13 = ((($gfc)) + 72|0);
   $i$06$i = 0;$j$07$i = 0;
   while(1) {
    $16 = ($i$06$i|0)<($10|0);
    if ($16) {
     $17 = (($primebuff0$i) + ($i$06$i<<2)|0);
     HEAPF32[$17>>2] = 0.0;
     $18 = HEAP32[$13>>2]|0;
     $19 = ($18|0)==(2);
     if ($19) {
      $20 = (($primebuff1$i) + ($i$06$i<<2)|0);
      HEAPF32[$20>>2] = 0.0;
      $j$1$i = $j$07$i;
     } else {
      $j$1$i = $j$07$i;
     }
    } else {
     $21 = (($inbuf_l) + ($j$07$i<<2)|0);
     $22 = HEAP32[$21>>2]|0;
     $23 = (($primebuff0$i) + ($i$06$i<<2)|0);
     HEAP32[$23>>2] = $22;
     $24 = HEAP32[$13>>2]|0;
     $25 = ($24|0)==(2);
     if ($25) {
      $26 = (($inbuf_r) + ($j$07$i<<2)|0);
      $27 = HEAP32[$26>>2]|0;
      $28 = (($primebuff1$i) + ($i$06$i<<2)|0);
      HEAP32[$28>>2] = $27;
     }
     $29 = (($j$07$i) + 1)|0;
     $j$1$i = $29;
    }
    $30 = (($i$06$i) + 1)|0;
    $exitcond91 = ($30|0)==($11|0);
    if ($exitcond91) {
     break;
    } else {
     $i$06$i = $30;$j$07$i = $j$1$i;
    }
   }
  }
  $14 = ($9|0)>(0);
  if ($14) {
   $15 = ((($gfc)) + 72|0);
   $$pre$i = HEAP32[$15>>2]|0;
   $31 = $$pre$i;$415 = $9;$gr$03$i = 0;
   while(1) {
    $32 = ($31|0)>(0);
    if ($32) {
     $ch$02$i = 0;
     while(1) {
      $33 = ((((((($gfc)) + 304|0) + (($gr$03$i*10504)|0)|0) + (($ch$02$i*5252)|0)|0)) + 4788|0);
      HEAP32[$33>>2] = 2;
      $34 = (($ch$02$i) + 1)|0;
      $35 = HEAP32[$15>>2]|0;
      $36 = ($34|0)<($35|0);
      if ($36) {
       $ch$02$i = $34;
      } else {
       $$lcssa121 = $35;
       break;
      }
     }
     $$pre10$i = HEAP32[$8>>2]|0;
     $39 = $$pre10$i;$416 = $$lcssa121;
    } else {
     $39 = $415;$416 = $31;
    }
    $37 = (($gr$03$i) + 1)|0;
    $38 = ($37|0)<($39|0);
    if ($38) {
     $31 = $416;$415 = $39;$gr$03$i = $37;
    } else {
     break;
    }
   }
  }
  _mdct_sub48($gfc,$primebuff0$i,$primebuff1$i);
 }
 $40 = ((($gfc)) + 84752|0);
 HEAP32[$40>>2] = 0;
 $41 = ((($gfc)) + 39832|0);
 $42 = HEAP32[$41>>2]|0;
 $43 = ((($gfc)) + 39836|0);
 $44 = HEAP32[$43>>2]|0;
 $45 = (($44) - ($42))|0;
 HEAP32[$43>>2] = $45;
 $46 = ($45|0)<(0);
 if ($46) {
  $47 = ((($gfc)) + 64|0);
  $48 = HEAP32[$47>>2]|0;
  $49 = (($48) + ($45))|0;
  HEAP32[$43>>2] = $49;
  HEAP32[$40>>2] = 1;
 }
 $50 = $bufp;
 $51 = $50;
 HEAP32[$51>>2] = 0;
 $52 = (($50) + 4)|0;
 $53 = $52;
 HEAP32[$53>>2] = 0;
 $54 = ((($gfc)) + 76|0);
 $55 = HEAP32[$54>>2]|0;
 $56 = ($55|0)>(0);
 L30: do {
  if ($56) {
   $57 = ((($gfc)) + 72|0);
   $58 = ((($gfc)) + 180|0);
   $gr$076 = 0;
   while(1) {
    $59 = HEAP32[$57>>2]|0;
    $60 = ($59|0)>(0);
    if ($60) {
     $61 = ($gr$076*576)|0;
     $62 = (($61) + 304)|0;
     $ch$069 = 0;
     while(1) {
      $63 = (($inbuf) + ($ch$069<<2)|0);
      $64 = HEAP32[$63>>2]|0;
      $65 = (($64) + ($62<<2)|0);
      $66 = (($bufp) + ($ch$069<<2)|0);
      HEAP32[$66>>2] = $65;
      $67 = (($ch$069) + 1)|0;
      $68 = ($67|0)<($59|0);
      if ($68) {
       $ch$069 = $67;
      } else {
       break;
      }
     }
    }
    $69 = (($pe) + ($gr$076<<3)|0);
    $70 = (($pe_MS) + ($gr$076<<3)|0);
    $71 = (($tot_ener) + ($gr$076<<4)|0);
    $72 = (_L3psycho_anal_vbr($gfc,$bufp,$gr$076,$masking_LR,$masking_MS,$69,$70,$71,$blocktype)|0);
    $73 = ($72|0)==(0);
    if (!($73)) {
     $$0 = -4;
     break;
    }
    $74 = HEAP32[$58>>2]|0;
    $75 = ($74|0)==(1);
    if ($75) {
     $76 = (((($tot_ener) + ($gr$076<<4)|0)) + 8|0);
     $77 = +HEAPF32[$76>>2];
     $78 = (((($tot_ener) + ($gr$076<<4)|0)) + 12|0);
     $79 = +HEAPF32[$78>>2];
     $80 = $79 + $77;
     $81 = (($ms_ener_ratio) + ($gr$076<<2)|0);
     HEAPF32[$81>>2] = $80;
     $82 = $80 > 0.0;
     if ($82) {
      $83 = $79 / $80;
      HEAPF32[$81>>2] = $83;
     }
    }
    $84 = HEAP32[$57>>2]|0;
    $85 = ($84|0)>(0);
    if ($85) {
     $ch$173 = 0;
     while(1) {
      $86 = (($blocktype) + ($ch$173<<2)|0);
      $87 = HEAP32[$86>>2]|0;
      $88 = ((((((($gfc)) + 304|0) + (($gr$076*10504)|0)|0) + (($ch$173*5252)|0)|0)) + 4788|0);
      HEAP32[$88>>2] = $87;
      $89 = ((((((($gfc)) + 304|0) + (($gr$076*10504)|0)|0) + (($ch$173*5252)|0)|0)) + 4792|0);
      HEAP32[$89>>2] = 0;
      $90 = (($ch$173) + 1)|0;
      $91 = ($90|0)<($84|0);
      if ($91) {
       $ch$173 = $90;
      } else {
       break;
      }
     }
    }
    $92 = (($gr$076) + 1)|0;
    $93 = HEAP32[$54>>2]|0;
    $94 = ($92|0)<($93|0);
    if ($94) {
     $gr$076 = $92;
    } else {
     $111 = $93;
     break L30;
    }
   }
   STACKTOP = sp;return ($$0|0);
  } else {
   $111 = $55;
  }
 } while(0);
 $95 = ((($gfc)) + 85796|0);
 $96 = HEAP32[$95>>2]|0;
 $97 = HEAP32[$96>>2]|0;
 $98 = ($97|0)==(0);
 do {
  if ($98) {
   $99 = ((($96)) + 8|0);
   HEAPF32[$99>>2] = 1.0;
  } else {
   $100 = ((($gfc)) + 27804|0);
   $101 = +HEAPF32[$100>>2];
   $102 = ((($gfc)) + 27812|0);
   $103 = +HEAPF32[$102>>2];
   $104 = ((($gfc)) + 72|0);
   $105 = HEAP32[$104>>2]|0;
   $106 = ($105|0)==(2);
   if ($106) {
    $107 = ((($gfc)) + 27808|0);
    $108 = +HEAPF32[$107>>2];
    $109 = ((($gfc)) + 27816|0);
    $110 = +HEAPF32[$109>>2];
    $$pn$i = $108;$$pn1$i = $110;
   } else {
    $$pn$i = $101;$$pn1$i = $103;
   }
   $gr2_max$0$i = $103 + $$pn1$i;
   $max_pow$0$i = $101 + $$pn$i;
   $112 = ($111|0)==(2);
   $113 = $max_pow$0$i > $gr2_max$0$i;
   $114 = $113 ? $max_pow$0$i : $gr2_max$0$i;
   $max_pow$1$i = $112 ? $114 : $max_pow$0$i;
   $115 = ((($96)) + 4|0);
   $116 = +HEAPF32[$115>>2];
   $117 = $116 * 0.5;
   $118 = $117 * $max_pow$1$i;
   $119 = $118 > 0.03125;
   if ($119) {
    $120 = ((($96)) + 8|0);
    $121 = +HEAPF32[$120>>2];
    $122 = !($121 >= 1.0);
    if ($122) {
     $123 = ((($96)) + 12|0);
     $124 = +HEAPF32[$123>>2];
     $125 = $121 < $124;
     if ($125) {
      HEAPF32[$120>>2] = $124;
      $$pre$phi$iZ2D = $123;
     } else {
      $$pre$phi$iZ2D = $123;
     }
    } else {
     HEAPF32[$120>>2] = 1.0;
     $$pre$i2 = ((($96)) + 12|0);
     $$pre$phi$iZ2D = $$pre$i2;
    }
    HEAPF32[$$pre$phi$iZ2D>>2] = 1.0;
    break;
   }
   $126 = $118;
   $127 = $126 * 31.98;
   $128 = $127 + 6.2500000000000001E-4;
   $129 = $128;
   $130 = ((($96)) + 8|0);
   $131 = +HEAPF32[$130>>2];
   $132 = !($131 >= $129);
   do {
    if ($132) {
     $140 = ((($96)) + 12|0);
     $141 = +HEAPF32[$140>>2];
     $142 = !($141 >= $129);
     if (!($142)) {
      HEAPF32[$130>>2] = $129;
      break;
     }
     $143 = $131 < $141;
     if ($143) {
      HEAPF32[$130>>2] = $141;
     }
    } else {
     $133 = $129;
     $134 = $133 * 0.074999999999999997;
     $135 = $134 + 0.92500000000000004;
     $136 = $131;
     $137 = $136 * $135;
     $138 = $137;
     HEAPF32[$130>>2] = $138;
     $139 = $138 < $129;
     if ($139) {
      HEAPF32[$130>>2] = $129;
     }
    }
   } while(0);
   $144 = ((($96)) + 12|0);
   HEAPF32[$144>>2] = $129;
  }
 } while(0);
 $145 = HEAP32[$inbuf>>2]|0;
 _mdct_sub48($gfc,$145,$inbuf_r);
 $146 = ((($gfc)) + 84756|0);
 HEAP32[$146>>2] = 0;
 $147 = ((($gfc)) + 80|0);
 $148 = HEAP32[$147>>2]|0;
 $149 = ($148|0)==(0);
 do {
  if ($149) {
   $150 = ((($gfc)) + 180|0);
   $151 = HEAP32[$150>>2]|0;
   $152 = ($151|0)==(1);
   if ($152) {
    $153 = HEAP32[$54>>2]|0;
    $154 = ($153|0)>(0);
    if ($154) {
     $155 = ((($gfc)) + 72|0);
     $156 = HEAP32[$155>>2]|0;
     $157 = ($156|0)>(0);
     if ($157) {
      $gr$161$us = 0;$sum_pe_LR$064$us = 0.0;$sum_pe_MS$063$us = 0.0;
      while(1) {
       $ch$254$us = 0;$sum_pe_LR$156$us = $sum_pe_LR$064$us;$sum_pe_MS$155$us = $sum_pe_MS$063$us;
       while(1) {
        $160 = ((($pe_MS) + ($gr$161$us<<3)|0) + ($ch$254$us<<2)|0);
        $161 = +HEAPF32[$160>>2];
        $162 = $161 + $sum_pe_MS$155$us;
        $163 = ((($pe) + ($gr$161$us<<3)|0) + ($ch$254$us<<2)|0);
        $164 = +HEAPF32[$163>>2];
        $165 = $164 + $sum_pe_LR$156$us;
        $166 = (($ch$254$us) + 1)|0;
        $167 = ($166|0)<($156|0);
        if ($167) {
         $ch$254$us = $166;$sum_pe_LR$156$us = $165;$sum_pe_MS$155$us = $162;
        } else {
         $$lcssa118 = $162;$$lcssa119 = $165;
         break;
        }
       }
       $158 = (($gr$161$us) + 1)|0;
       $159 = ($158|0)<($153|0);
       if ($159) {
        $gr$161$us = $158;$sum_pe_LR$064$us = $$lcssa119;$sum_pe_MS$063$us = $$lcssa118;
       } else {
        $$lcssa118$lcssa = $$lcssa118;$$lcssa119$lcssa = $$lcssa119;
        break;
       }
      }
      $168 = !($$lcssa118$lcssa <= $$lcssa119$lcssa);
      if ($168) {
       $180 = 0;
       break;
      }
     }
    }
    $169 = (($153) + -1)|0;
    $170 = ((($gfc)) + 5092|0);
    $171 = HEAP32[$170>>2]|0;
    $172 = ((($gfc)) + 10344|0);
    $173 = HEAP32[$172>>2]|0;
    $174 = ($171|0)==($173|0);
    if ($174) {
     $175 = (((((($gfc)) + 304|0) + (($169*10504)|0)|0)) + 4788|0);
     $176 = HEAP32[$175>>2]|0;
     $177 = (((((($gfc)) + 304|0) + (($169*10504)|0)|0)) + 10040|0);
     $178 = HEAP32[$177>>2]|0;
     $179 = ($176|0)==($178|0);
     if ($179) {
      HEAP32[$146>>2] = 2;
      $180 = 1;
     } else {
      $180 = 0;
     }
    } else {
     $180 = 0;
    }
   } else {
    $180 = 0;
   }
  } else {
   HEAP32[$146>>2] = 2;
   $180 = 1;
  }
 } while(0);
 $masking_MS$sink = $180 ? $masking_MS : $masking_LR;
 $181 = $180 ? $pe_MS : $pe;
 $182 = ((($gfc)) + 140|0);
 $183 = HEAP32[$182>>2]|0;
 $184 = ($183|0)==(0);
 if (!($184)) {
  $185 = ((($gfc)) + 85804|0);
  $186 = HEAP32[$185>>2]|0;
  $187 = ($186|0)==(0|0);
  if (!($187)) {
   $188 = HEAP32[$54>>2]|0;
   $189 = ($188|0)>(0);
   if ($189) {
    $190 = ((($gfc)) + 72|0);
    $$pre = HEAP32[$190>>2]|0;
    $191 = $$pre;$417 = $188;$gr$252 = 0;
    while(1) {
     $192 = ($191|0)>(0);
     if ($192) {
      $193 = (($ms_ener_ratio) + ($gr$252<<2)|0);
      $194 = +HEAPF32[$193>>2];
      $195 = $194;
      $ch$349 = 0;
      while(1) {
       $196 = HEAP32[$185>>2]|0;
       $197 = (((($196)) + 90904|0) + ($gr$252<<3)|0);
       HEAPF64[$197>>3] = 0.0;
       $198 = (((($196)) + 90920|0) + ($gr$252<<3)|0);
       HEAPF64[$198>>3] = $195;
       $199 = ((((((($gfc)) + 304|0) + (($gr$252*10504)|0)|0) + (($ch$349*5252)|0)|0)) + 4788|0);
       $200 = HEAP32[$199>>2]|0;
       $201 = ((((($196)) + 203288|0) + ($gr$252<<3)|0) + ($ch$349<<2)|0);
       HEAP32[$201>>2] = $200;
       $202 = ((($181) + ($gr$252<<3)|0) + ($ch$349<<2)|0);
       $203 = +HEAPF32[$202>>2];
       $204 = $203;
       $205 = ((((($196)) + 189240|0) + ($gr$252<<5)|0) + ($ch$349<<3)|0);
       HEAPF64[$205>>3] = $204;
       $206 = ((((($196)) + 54040|0) + (($gr$252*9216)|0)|0) + (($ch$349*4608)|0)|0);
       $207 = ((((($gfc)) + 304|0) + (($gr$252*10504)|0)|0) + (($ch$349*5252)|0)|0);
       _memcpy(($206|0),($207|0),2304)|0;
       $208 = HEAP32[$146>>2]|0;
       $209 = ($208|0)==(2);
       if ($209) {
        $210 = (($ch$349) + 2)|0;
        $211 = HEAP32[$185>>2]|0;
        $212 = ((((($211)) + 197144|0) + ($gr$252<<5)|0) + ($210<<3)|0);
        $213 = +HEAPF64[$212>>3];
        $214 = ((((($211)) + 197144|0) + ($gr$252<<5)|0) + ($ch$349<<3)|0);
        HEAPF64[$214>>3] = $213;
        $215 = ((((($211)) + 123704|0) + ($gr$252<<15)|0) + ($ch$349<<13)|0);
        $216 = ((((($211)) + 123704|0) + ($gr$252<<15)|0) + ($210<<13)|0);
        _memcpy(($215|0),($216|0),8192)|0;
       }
       $217 = (($ch$349) + 1)|0;
       $218 = HEAP32[$190>>2]|0;
       $219 = ($217|0)<($218|0);
       if ($219) {
        $ch$349 = $217;
       } else {
        $$lcssa117 = $218;
        break;
       }
      }
      $$pre92 = HEAP32[$54>>2]|0;
      $222 = $$pre92;$418 = $$lcssa117;
     } else {
      $222 = $417;$418 = $191;
     }
     $220 = (($gr$252) + 1)|0;
     $221 = ($220|0)<($222|0);
     if ($221) {
      $191 = $418;$417 = $222;$gr$252 = $220;
     } else {
      break;
     }
    }
   }
  }
 }
 $223 = ((($gfc)) + 104|0);
 $224 = HEAP32[$223>>2]|0;
 if ((($224|0) == 3) | (($224|0) == 0)) {
  $225 = ((($gfc)) + 39760|0);
  $226 = HEAP32[$225>>2]|0;
  $227 = ((($gfc)) + 39756|0);
  HEAP32[$227>>2] = $226;
  $228 = ((($gfc)) + 39764|0);
  $229 = HEAP32[$228>>2]|0;
  HEAP32[$225>>2] = $229;
  $230 = ((($gfc)) + 39768|0);
  $231 = HEAP32[$230>>2]|0;
  HEAP32[$228>>2] = $231;
  $232 = ((($gfc)) + 39772|0);
  $233 = HEAP32[$232>>2]|0;
  HEAP32[$230>>2] = $233;
  $234 = ((($gfc)) + 39776|0);
  $235 = HEAP32[$234>>2]|0;
  HEAP32[$232>>2] = $235;
  $236 = ((($gfc)) + 39780|0);
  $237 = HEAP32[$236>>2]|0;
  HEAP32[$234>>2] = $237;
  $238 = ((($gfc)) + 39784|0);
  $239 = HEAP32[$238>>2]|0;
  HEAP32[$236>>2] = $239;
  $240 = ((($gfc)) + 39788|0);
  $241 = HEAP32[$240>>2]|0;
  HEAP32[$238>>2] = $241;
  $242 = ((($gfc)) + 39792|0);
  $243 = HEAP32[$242>>2]|0;
  HEAP32[$240>>2] = $243;
  $244 = ((($gfc)) + 39796|0);
  $245 = HEAP32[$244>>2]|0;
  HEAP32[$242>>2] = $245;
  $246 = ((($gfc)) + 39800|0);
  $247 = HEAP32[$246>>2]|0;
  HEAP32[$244>>2] = $247;
  $248 = ((($gfc)) + 39804|0);
  $249 = HEAP32[$248>>2]|0;
  HEAP32[$246>>2] = $249;
  $250 = ((($gfc)) + 39808|0);
  $251 = HEAP32[$250>>2]|0;
  HEAP32[$248>>2] = $251;
  $252 = ((($gfc)) + 39812|0);
  $253 = HEAP32[$252>>2]|0;
  HEAP32[$250>>2] = $253;
  $254 = ((($gfc)) + 39816|0);
  $255 = HEAP32[$254>>2]|0;
  HEAP32[$252>>2] = $255;
  $256 = ((($gfc)) + 39820|0);
  $257 = HEAP32[$256>>2]|0;
  HEAP32[$254>>2] = $257;
  $258 = ((($gfc)) + 39824|0);
  $259 = HEAP32[$258>>2]|0;
  HEAP32[$256>>2] = $259;
  $260 = ((($gfc)) + 39828|0);
  $261 = HEAP32[$260>>2]|0;
  HEAP32[$258>>2] = $261;
  $262 = HEAP32[$54>>2]|0;
  $263 = ($262|0)>(0);
  $264 = (HEAP32[tempDoublePtr>>2]=$245,+HEAPF32[tempDoublePtr>>2]);
  $265 = (HEAP32[tempDoublePtr>>2]=$226,+HEAPF32[tempDoublePtr>>2]);
  $266 = (HEAP32[tempDoublePtr>>2]=$229,+HEAPF32[tempDoublePtr>>2]);
  $267 = (HEAP32[tempDoublePtr>>2]=$261,+HEAPF32[tempDoublePtr>>2]);
  $268 = (HEAP32[tempDoublePtr>>2]=$231,+HEAPF32[tempDoublePtr>>2]);
  $269 = (HEAP32[tempDoublePtr>>2]=$259,+HEAPF32[tempDoublePtr>>2]);
  $270 = (HEAP32[tempDoublePtr>>2]=$233,+HEAPF32[tempDoublePtr>>2]);
  $271 = (HEAP32[tempDoublePtr>>2]=$257,+HEAPF32[tempDoublePtr>>2]);
  $272 = (HEAP32[tempDoublePtr>>2]=$235,+HEAPF32[tempDoublePtr>>2]);
  $273 = (HEAP32[tempDoublePtr>>2]=$255,+HEAPF32[tempDoublePtr>>2]);
  $274 = (HEAP32[tempDoublePtr>>2]=$237,+HEAPF32[tempDoublePtr>>2]);
  $275 = (HEAP32[tempDoublePtr>>2]=$253,+HEAPF32[tempDoublePtr>>2]);
  $276 = (HEAP32[tempDoublePtr>>2]=$239,+HEAPF32[tempDoublePtr>>2]);
  $277 = (HEAP32[tempDoublePtr>>2]=$251,+HEAPF32[tempDoublePtr>>2]);
  $278 = (HEAP32[tempDoublePtr>>2]=$241,+HEAPF32[tempDoublePtr>>2]);
  $279 = (HEAP32[tempDoublePtr>>2]=$249,+HEAPF32[tempDoublePtr>>2]);
  $280 = (HEAP32[tempDoublePtr>>2]=$243,+HEAPF32[tempDoublePtr>>2]);
  $281 = (HEAP32[tempDoublePtr>>2]=$247,+HEAPF32[tempDoublePtr>>2]);
  $282 = ((($gfc)) + 72|0);
  $283 = HEAP32[$282>>2]|0;
  $284 = ($283|0)>(0);
  $or$cond = $263 & $284;
  if ($or$cond) {
   $f$045$us = 0.0;$gr$343$us = 0;
   while(1) {
    $ch$439$us = 0;$f$140$us = $f$045$us;
    while(1) {
     $287 = ((($181) + ($gr$343$us<<3)|0) + ($ch$439$us<<2)|0);
     $288 = +HEAPF32[$287>>2];
     $289 = $288 + $f$140$us;
     $290 = (($ch$439$us) + 1)|0;
     $291 = ($290|0)<($283|0);
     if ($291) {
      $ch$439$us = $290;$f$140$us = $289;
     } else {
      $$lcssa116 = $289;
      break;
     }
    }
    $285 = (($gr$343$us) + 1)|0;
    $286 = ($285|0)<($262|0);
    if ($286) {
     $f$045$us = $$lcssa116;$gr$343$us = $285;
    } else {
     $f$0$lcssa = $$lcssa116;
     break;
    }
   }
  } else {
   $f$0$lcssa = 0.0;
  }
  HEAPF32[$260>>2] = $f$0$lcssa;
  $292 = $f$0$lcssa + $265;
  $293 = $292 * -0.10394349694252014;
  $294 = $293 + $264;
  $295 = $267 + $266;
  $296 = $295 * -0.18920649588108063;
  $297 = $296 + $294;
  $298 = $269 + $268;
  $299 = $298 * -0.21623599529266357;
  $300 = $299 + $297;
  $301 = $271 + $270;
  $302 = $301 * -0.15591500699520111;
  $303 = $302 + $300;
  $304 = $273 + $272;
  $305 = $304 * 3.8980449615198001E-17;
  $306 = $305 + $303;
  $307 = $275 + $274;
  $308 = $307 * 0.23387250304222107;
  $309 = $308 + $306;
  $310 = $277 + $276;
  $311 = $310 * 0.50454998016357422;
  $312 = $311 + $309;
  $313 = $279 + $278;
  $314 = $313 * 0.75682497024536133;
  $315 = $314 + $312;
  $316 = $281 + $280;
  $317 = $316 * 0.93549001216888427;
  $318 = $317 + $315;
  $319 = ($262*3350)|0;
  $320 = Math_imul($319, $283)|0;
  $321 = (+($320|0));
  $322 = $321 / $318;
  $323 = ($283|0)>(0);
  $or$cond101 = $263 & $323;
  if ($or$cond101) {
   $gr$435$us = 0;
   while(1) {
    $ch$533$us = 0;
    while(1) {
     $326 = ((($181) + ($gr$435$us<<3)|0) + ($ch$533$us<<2)|0);
     $327 = +HEAPF32[$326>>2];
     $328 = $327 * $322;
     HEAPF32[$326>>2] = $328;
     $329 = (($ch$533$us) + 1)|0;
     $330 = ($329|0)<($283|0);
     if ($330) {
      $ch$533$us = $329;
     } else {
      break;
     }
    }
    $324 = (($gr$435$us) + 1)|0;
    $325 = ($324|0)<($262|0);
    if ($325) {
     $gr$435$us = $324;
    } else {
     break;
    }
   }
  }
 }
 $331 = ((($gfc)) + 85812|0);
 $332 = HEAP32[$331>>2]|0;
 FUNCTION_TABLE_viiii[$332 & 7]($gfc,$181,$ms_ener_ratio,$masking_MS$sink);
 (_format_bitstream($gfc)|0);
 $333 = (_copy_buffer($gfc,$mp3buf,$mp3buf_size,1)|0);
 $334 = ((($gfc)) + 156|0);
 $335 = HEAP32[$334>>2]|0;
 $336 = ($335|0)==(0);
 if (!($336)) {
  _AddVbrFrame($gfc);
 }
 $337 = HEAP32[$182>>2]|0;
 $338 = ($337|0)==(0);
 if (!($338)) {
  $339 = ((($gfc)) + 85804|0);
  $340 = HEAP32[$339>>2]|0;
  $341 = ($340|0)==(0|0);
  if (!($341)) {
   $342 = HEAP32[$54>>2]|0;
   $343 = ($342*576)|0;
   $344 = ((($gfc)) + 72|0);
   $345 = HEAP32[$344>>2]|0;
   $346 = ($345|0)>(0);
   if ($346) {
    $ch$632 = 0;
    while(1) {
     $j$030 = 0;
     while(1) {
      $349 = (($j$030) + ($343))|0;
      $350 = ((((($340)) + 24|0) + (($ch$632*12800)|0)|0) + ($349<<3)|0);
      $351 = +HEAPF64[$350>>3];
      $352 = ((((($340)) + 24|0) + (($ch$632*12800)|0)|0) + ($j$030<<3)|0);
      HEAPF64[$352>>3] = $351;
      $353 = (($j$030) + 1)|0;
      $exitcond = ($353|0)==(272);
      if ($exitcond) {
       break;
      } else {
       $j$030 = $353;
      }
     }
     $347 = (($inbuf) + ($ch$632<<2)|0);
     $348 = HEAP32[$347>>2]|0;
     $j$131 = 272;
     while(1) {
      $354 = (($j$131) + -272)|0;
      $355 = (($348) + ($354<<2)|0);
      $356 = +HEAPF32[$355>>2];
      $357 = $356;
      $358 = ((((($340)) + 24|0) + (($ch$632*12800)|0)|0) + ($j$131<<3)|0);
      HEAPF64[$358>>3] = $357;
      $359 = (($j$131) + 1)|0;
      $exitcond86 = ($359|0)==(1600);
      if ($exitcond86) {
       break;
      } else {
       $j$131 = $359;
      }
     }
     $360 = (($ch$632) + 1)|0;
     $361 = ($360|0)<($345|0);
     if ($361) {
      $ch$632 = $360;
     } else {
      break;
     }
    }
   }
   $362 = ((($gfc)) + 84908|0);
   HEAPF32[$362>>2] = 1.0;
   _set_frame_pinfo($gfc,$masking_MS$sink);
  }
 }
 $363 = ((($gfc)) + 84748|0);
 $364 = HEAP32[$363>>2]|0;
 $365 = (($364) + 1)|0;
 HEAP32[$363>>2] = $365;
 $366 = ((($gfc)) + 84744|0);
 $367 = HEAP32[$366>>2]|0;
 $368 = (((((($gfc)) + 84040|0) + (($367*20)|0)|0)) + 16|0);
 $369 = HEAP32[$368>>2]|0;
 $370 = (($369) + 1)|0;
 HEAP32[$368>>2] = $370;
 $371 = ((($gfc)) + 84356|0);
 $372 = HEAP32[$371>>2]|0;
 $373 = (($372) + 1)|0;
 HEAP32[$371>>2] = $373;
 $374 = ((($gfc)) + 72|0);
 $375 = HEAP32[$374>>2]|0;
 $376 = ($375|0)==(2);
 if ($376) {
  $377 = HEAP32[$146>>2]|0;
  $378 = HEAP32[$366>>2]|0;
  $379 = ((((($gfc)) + 84040|0) + (($378*20)|0)|0) + ($377<<2)|0);
  $380 = HEAP32[$379>>2]|0;
  $381 = (($380) + 1)|0;
  HEAP32[$379>>2] = $381;
  $382 = HEAP32[$146>>2]|0;
  $383 = (((($gfc)) + 84340|0) + ($382<<2)|0);
  $384 = HEAP32[$383>>2]|0;
  $385 = (($384) + 1)|0;
  HEAP32[$383>>2] = $385;
 }
 $386 = HEAP32[$54>>2]|0;
 $387 = ($386|0)>(0);
 if (!($387)) {
  $$0 = $333;
  STACKTOP = sp;return ($$0|0);
 }
 $388 = ((($gfc)) + 84740|0);
 $$pre$i4 = HEAP32[$374>>2]|0;
 $389 = $$pre$i4;$419 = $386;$gr$03$i6 = 0;
 while(1) {
  $390 = ($389|0)>(0);
  if ($390) {
   $ch$02$i8 = 0;
   while(1) {
    $391 = ((((((($gfc)) + 304|0) + (($gr$03$i6*10504)|0)|0) + (($ch$02$i8*5252)|0)|0)) + 4788|0);
    $392 = HEAP32[$391>>2]|0;
    $393 = ((((((($gfc)) + 304|0) + (($gr$03$i6*10504)|0)|0) + (($ch$02$i8*5252)|0)|0)) + 4792|0);
    $394 = HEAP32[$393>>2]|0;
    $395 = ($394|0)==(0);
    $$$i = $395 ? $392 : 4;
    $396 = HEAP32[$366>>2]|0;
    $397 = ((((($gfc)) + 84360|0) + (($396*24)|0)|0) + ($$$i<<2)|0);
    $398 = HEAP32[$397>>2]|0;
    $399 = (($398) + 1)|0;
    HEAP32[$397>>2] = $399;
    $400 = HEAP32[$366>>2]|0;
    $401 = (((((($gfc)) + 84360|0) + (($400*24)|0)|0)) + 20|0);
    $402 = HEAP32[$401>>2]|0;
    $403 = (($402) + 1)|0;
    HEAP32[$401>>2] = $403;
    $404 = (((($gfc)) + 84720|0) + ($$$i<<2)|0);
    $405 = HEAP32[$404>>2]|0;
    $406 = (($405) + 1)|0;
    HEAP32[$404>>2] = $406;
    $407 = HEAP32[$388>>2]|0;
    $408 = (($407) + 1)|0;
    HEAP32[$388>>2] = $408;
    $409 = (($ch$02$i8) + 1)|0;
    $410 = HEAP32[$374>>2]|0;
    $411 = ($409|0)<($410|0);
    if ($411) {
     $ch$02$i8 = $409;
    } else {
     $$lcssa = $410;
     break;
    }
   }
   $$pre6$i = HEAP32[$54>>2]|0;
   $414 = $$pre6$i;$420 = $$lcssa;
  } else {
   $414 = $419;$420 = $389;
  }
  $412 = (($gr$03$i6) + 1)|0;
  $413 = ($412|0)<($414|0);
  if ($413) {
   $389 = $420;$419 = $414;$gr$03$i6 = $412;
  } else {
   $$0 = $333;
   break;
  }
 }
 STACKTOP = sp;return ($$0|0);
}
function _fft_short($gfc,$x_real,$chn,$buffer) {
 $gfc = $gfc|0;
 $x_real = $x_real|0;
 $chn = $chn|0;
 $buffer = $buffer|0;
 var $$pre = 0, $0 = 0, $1 = 0, $10 = 0.0, $11 = 0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0.0, $18 = 0, $19 = 0, $2 = 0, $20 = 0.0, $21 = 0.0, $22 = 0.0, $23 = 0.0, $24 = 0, $25 = 0;
 var $26 = 0.0, $27 = 0, $28 = 0, $29 = 0.0, $3 = 0, $30 = 0.0, $31 = 0, $32 = 0, $33 = 0.0, $34 = 0, $35 = 0, $36 = 0.0, $37 = 0.0, $38 = 0.0, $39 = 0.0, $4 = 0, $40 = 0, $41 = 0.0, $42 = 0.0, $43 = 0;
 var $44 = 0.0, $45 = 0, $46 = 0.0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0.0, $51 = 0, $52 = 0, $53 = 0.0, $54 = 0.0, $55 = 0, $56 = 0, $57 = 0.0, $58 = 0, $59 = 0, $6 = 0, $60 = 0.0, $61 = 0.0;
 var $62 = 0.0, $63 = 0.0, $64 = 0, $65 = 0, $66 = 0.0, $67 = 0, $68 = 0, $69 = 0.0, $7 = 0, $70 = 0.0, $71 = 0, $72 = 0, $73 = 0.0, $74 = 0, $75 = 0, $76 = 0.0, $77 = 0.0, $78 = 0.0, $79 = 0.0, $8 = 0;
 var $80 = 0.0, $81 = 0, $82 = 0.0, $83 = 0, $84 = 0.0, $85 = 0, $86 = 0.0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $b$01 = 0, $exitcond = 0, $indvars$iv = 0, $j$0 = 0, $scevgep = 0, $sext = 0, $x$0 = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 $0 = (($buffer) + ($chn<<2)|0);
 $1 = ((($gfc)) + 85820|0);
 $b$01 = 0;$indvars$iv = $x_real;
 while(1) {
  $2 = (((($x_real) + ($b$01<<10)|0)) + 512|0);
  $3 = (($b$01) + 1)|0;
  $sext = Math_imul($3, 12582912)|0;
  $4 = $sext >> 16;
  $$pre = HEAP32[$0>>2]|0;
  $j$0 = 31;$x$0 = $2;
  while(1) {
   $5 = $j$0 << 2;
   $6 = (1720 + ($5)|0);
   $7 = HEAP8[$6>>0]|0;
   $8 = $7&255;
   $9 = (1848 + ($8<<2)|0);
   $10 = +HEAPF32[$9>>2];
   $11 = (($8) + ($4))|0;
   $12 = (($$pre) + ($11<<2)|0);
   $13 = +HEAPF32[$12>>2];
   $14 = $13 * $10;
   $15 = (127 - ($8))|0;
   $16 = (1848 + ($15<<2)|0);
   $17 = +HEAPF32[$16>>2];
   $18 = (($11) + 128)|0;
   $19 = (($$pre) + ($18<<2)|0);
   $20 = +HEAPF32[$19>>2];
   $21 = $20 * $17;
   $22 = $14 - $21;
   $23 = $21 + $14;
   $24 = (($8) + 64)|0;
   $25 = (1848 + ($24<<2)|0);
   $26 = +HEAPF32[$25>>2];
   $27 = (($11) + 64)|0;
   $28 = (($$pre) + ($27<<2)|0);
   $29 = +HEAPF32[$28>>2];
   $30 = $29 * $26;
   $31 = (63 - ($8))|0;
   $32 = (1848 + ($31<<2)|0);
   $33 = +HEAPF32[$32>>2];
   $34 = (($11) + 192)|0;
   $35 = (($$pre) + ($34<<2)|0);
   $36 = +HEAPF32[$35>>2];
   $37 = $36 * $33;
   $38 = $30 - $37;
   $39 = $37 + $30;
   $40 = ((($x$0)) + -16|0);
   $41 = $39 + $23;
   HEAPF32[$40>>2] = $41;
   $42 = $23 - $39;
   $43 = ((($x$0)) + -8|0);
   HEAPF32[$43>>2] = $42;
   $44 = $38 + $22;
   $45 = ((($x$0)) + -12|0);
   HEAPF32[$45>>2] = $44;
   $46 = $22 - $38;
   $47 = ((($x$0)) + -4|0);
   HEAPF32[$47>>2] = $46;
   $48 = (($8) + 1)|0;
   $49 = (1848 + ($48<<2)|0);
   $50 = +HEAPF32[$49>>2];
   $51 = (($11) + 1)|0;
   $52 = (($$pre) + ($51<<2)|0);
   $53 = +HEAPF32[$52>>2];
   $54 = $53 * $50;
   $55 = (126 - ($8))|0;
   $56 = (1848 + ($55<<2)|0);
   $57 = +HEAPF32[$56>>2];
   $58 = (($11) + 129)|0;
   $59 = (($$pre) + ($58<<2)|0);
   $60 = +HEAPF32[$59>>2];
   $61 = $60 * $57;
   $62 = $54 - $61;
   $63 = $61 + $54;
   $64 = (($8) + 65)|0;
   $65 = (1848 + ($64<<2)|0);
   $66 = +HEAPF32[$65>>2];
   $67 = (($11) + 65)|0;
   $68 = (($$pre) + ($67<<2)|0);
   $69 = +HEAPF32[$68>>2];
   $70 = $69 * $66;
   $71 = (62 - ($8))|0;
   $72 = (1848 + ($71<<2)|0);
   $73 = +HEAPF32[$72>>2];
   $74 = (($11) + 193)|0;
   $75 = (($$pre) + ($74<<2)|0);
   $76 = +HEAPF32[$75>>2];
   $77 = $76 * $73;
   $78 = $70 - $77;
   $79 = $77 + $70;
   $80 = $79 + $63;
   $81 = ((($x$0)) + 496|0);
   HEAPF32[$81>>2] = $80;
   $82 = $63 - $79;
   $83 = ((($x$0)) + 504|0);
   HEAPF32[$83>>2] = $82;
   $84 = $78 + $62;
   $85 = ((($x$0)) + 500|0);
   HEAPF32[$85>>2] = $84;
   $86 = $62 - $78;
   $87 = ((($x$0)) + 508|0);
   HEAPF32[$87>>2] = $86;
   $88 = (($j$0) + -1)|0;
   $89 = ($j$0|0)>(0);
   if ($89) {
    $j$0 = $88;$x$0 = $40;
   } else {
    break;
   }
  }
  $90 = HEAP32[$1>>2]|0;
  FUNCTION_TABLE_vii[$90 & 3]($indvars$iv,128);
  $scevgep = ((($indvars$iv)) + 1024|0);
  $exitcond = ($3|0)==(3);
  if ($exitcond) {
   break;
  } else {
   $b$01 = $3;$indvars$iv = $scevgep;
  }
 }
 return;
}
function _fft_long($gfc,$x,$chn,$buffer) {
 $gfc = $gfc|0;
 $x = $x|0;
 $chn = $chn|0;
 $buffer = $buffer|0;
 var $$0 = 0, $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0.0, $13 = 0, $14 = 0.0, $15 = 0.0, $16 = 0.0, $17 = 0.0, $18 = 0, $19 = 0, $2 = 0, $20 = 0.0, $21 = 0, $22 = 0.0, $23 = 0.0, $24 = 0;
 var $25 = 0, $26 = 0.0, $27 = 0, $28 = 0.0, $29 = 0.0, $3 = 0, $30 = 0.0, $31 = 0.0, $32 = 0, $33 = 0.0, $34 = 0.0, $35 = 0, $36 = 0.0, $37 = 0, $38 = 0.0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0.0;
 var $43 = 0, $44 = 0.0, $45 = 0.0, $46 = 0, $47 = 0, $48 = 0.0, $49 = 0, $5 = 0, $50 = 0.0, $51 = 0.0, $52 = 0.0, $53 = 0.0, $54 = 0, $55 = 0, $56 = 0.0, $57 = 0, $58 = 0.0, $59 = 0.0, $6 = 0.0, $60 = 0;
 var $61 = 0, $62 = 0.0, $63 = 0, $64 = 0.0, $65 = 0.0, $66 = 0.0, $67 = 0.0, $68 = 0.0, $69 = 0, $7 = 0, $70 = 0.0, $71 = 0, $72 = 0.0, $73 = 0, $74 = 0.0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0.0, $9 = 0.0, $jj$0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($x)) + 2048|0);
 $1 = (($buffer) + ($chn<<2)|0);
 $$pre = HEAP32[$1>>2]|0;
 $$0 = $0;$jj$0 = 127;
 while(1) {
  $2 = (1720 + ($jj$0)|0);
  $3 = HEAP8[$2>>0]|0;
  $4 = $3&255;
  $5 = (2360 + ($4<<2)|0);
  $6 = +HEAPF32[$5>>2];
  $7 = (($$pre) + ($4<<2)|0);
  $8 = +HEAPF32[$7>>2];
  $9 = $8 * $6;
  $10 = $4 | 512;
  $11 = (2360 + ($10<<2)|0);
  $12 = +HEAPF32[$11>>2];
  $13 = (($$pre) + ($10<<2)|0);
  $14 = +HEAPF32[$13>>2];
  $15 = $14 * $12;
  $16 = $9 - $15;
  $17 = $15 + $9;
  $18 = $4 | 256;
  $19 = (2360 + ($18<<2)|0);
  $20 = +HEAPF32[$19>>2];
  $21 = (($$pre) + ($18<<2)|0);
  $22 = +HEAPF32[$21>>2];
  $23 = $22 * $20;
  $24 = $4 | 768;
  $25 = (2360 + ($24<<2)|0);
  $26 = +HEAPF32[$25>>2];
  $27 = (($$pre) + ($24<<2)|0);
  $28 = +HEAPF32[$27>>2];
  $29 = $28 * $26;
  $30 = $23 - $29;
  $31 = $29 + $23;
  $32 = ((($$0)) + -16|0);
  $33 = $31 + $17;
  HEAPF32[$32>>2] = $33;
  $34 = $17 - $31;
  $35 = ((($$0)) + -8|0);
  HEAPF32[$35>>2] = $34;
  $36 = $30 + $16;
  $37 = ((($$0)) + -12|0);
  HEAPF32[$37>>2] = $36;
  $38 = $16 - $30;
  $39 = ((($$0)) + -4|0);
  HEAPF32[$39>>2] = $38;
  $40 = (($4) + 1)|0;
  $41 = (2360 + ($40<<2)|0);
  $42 = +HEAPF32[$41>>2];
  $43 = (($$pre) + ($40<<2)|0);
  $44 = +HEAPF32[$43>>2];
  $45 = $44 * $42;
  $46 = (($4) + 513)|0;
  $47 = (2360 + ($46<<2)|0);
  $48 = +HEAPF32[$47>>2];
  $49 = (($$pre) + ($46<<2)|0);
  $50 = +HEAPF32[$49>>2];
  $51 = $50 * $48;
  $52 = $45 - $51;
  $53 = $51 + $45;
  $54 = (($4) + 257)|0;
  $55 = (2360 + ($54<<2)|0);
  $56 = +HEAPF32[$55>>2];
  $57 = (($$pre) + ($54<<2)|0);
  $58 = +HEAPF32[$57>>2];
  $59 = $58 * $56;
  $60 = (($4) + 769)|0;
  $61 = (2360 + ($60<<2)|0);
  $62 = +HEAPF32[$61>>2];
  $63 = (($$pre) + ($60<<2)|0);
  $64 = +HEAPF32[$63>>2];
  $65 = $64 * $62;
  $66 = $59 - $65;
  $67 = $65 + $59;
  $68 = $67 + $53;
  $69 = ((($$0)) + 2032|0);
  HEAPF32[$69>>2] = $68;
  $70 = $53 - $67;
  $71 = ((($$0)) + 2040|0);
  HEAPF32[$71>>2] = $70;
  $72 = $66 + $52;
  $73 = ((($$0)) + 2036|0);
  HEAPF32[$73>>2] = $72;
  $74 = $52 - $66;
  $75 = ((($$0)) + 2044|0);
  HEAPF32[$75>>2] = $74;
  $76 = (($jj$0) + -1)|0;
  $77 = ($jj$0|0)>(0);
  if ($77) {
   $$0 = $32;$jj$0 = $76;
  } else {
   break;
  }
 }
 $78 = ((($gfc)) + 85820|0);
 $79 = HEAP32[$78>>2]|0;
 FUNCTION_TABLE_vii[$79 & 3]($x,512);
 return;
}
function _init_fft($gfc) {
 $gfc = $gfc|0;
 var $0 = 0.0, $1 = 0.0, $10 = 0.0, $11 = 0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0.0, $16 = 0.0, $17 = 0.0, $18 = 0.0, $19 = 0.0, $2 = 0.0, $20 = 0, $21 = 0, $22 = 0, $3 = 0.0, $4 = 0.0, $5 = 0.0, $6 = 0.0;
 var $7 = 0.0, $8 = 0.0, $9 = 0.0, $exitcond = 0, $exitcond3 = 0, $i$02 = 0, $i$11 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $i$02 = 0;
 while(1) {
  $0 = (+($i$02|0));
  $1 = $0 + 0.5;
  $2 = $1 * 0.0061359231515425647;
  $3 = (+Math_cos((+$2)));
  $4 = $3 * 0.5;
  $5 = 0.41999999999999998 - $4;
  $6 = $1 * 0.012271846303085129;
  $7 = (+Math_cos((+$6)));
  $8 = $7 * 0.080000000000000002;
  $9 = $5 + $8;
  $10 = $9;
  $11 = (2360 + ($i$02<<2)|0);
  HEAPF32[$11>>2] = $10;
  $12 = (($i$02) + 1)|0;
  $exitcond3 = ($12|0)==(1024);
  if ($exitcond3) {
   $i$11 = 0;
   break;
  } else {
   $i$02 = $12;
  }
 }
 while(1) {
  $13 = (+($i$11|0));
  $14 = $13 + 0.5;
  $15 = $14 * 0.024543692606170259;
  $16 = (+Math_cos((+$15)));
  $17 = 1.0 - $16;
  $18 = $17 * 0.5;
  $19 = $18;
  $20 = (1848 + ($i$11<<2)|0);
  HEAPF32[$20>>2] = $19;
  $21 = (($i$11) + 1)|0;
  $exitcond = ($21|0)==(128);
  if ($exitcond) {
   break;
  } else {
   $i$11 = $21;
  }
 }
 $22 = ((($gfc)) + 85820|0);
 HEAP32[$22>>2] = 1;
 return;
}
function _fht($fz,$n) {
 $fz = $fz|0;
 $n = $n|0;
 var $$sum = 0, $0 = 0, $1 = 0, $10 = 0.0, $100 = 0.0, $101 = 0.0, $102 = 0.0, $103 = 0.0, $104 = 0.0, $105 = 0.0, $106 = 0.0, $107 = 0.0, $108 = 0, $109 = 0, $11 = 0.0, $110 = 0, $111 = 0.0, $112 = 0.0, $113 = 0.0, $114 = 0.0;
 var $115 = 0.0, $116 = 0.0, $117 = 0.0, $118 = 0.0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $13 = 0.0, $14 = 0, $15 = 0.0, $16 = 0.0, $17 = 0.0, $18 = 0.0, $19 = 0.0, $2 = 0, $20 = 0.0, $21 = 0.0, $22 = 0.0;
 var $23 = 0, $24 = 0.0, $25 = 0.0, $26 = 0.0, $27 = 0, $28 = 0.0, $29 = 0.0, $3 = 0, $30 = 0.0, $31 = 0.0, $32 = 0, $33 = 0.0, $34 = 0.0, $35 = 0.0, $36 = 0.0, $37 = 0.0, $38 = 0.0, $39 = 0.0, $4 = 0, $40 = 0.0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0.0, $47 = 0.0, $48 = 0.0, $49 = 0.0, $5 = 0, $50 = 0.0, $51 = 0.0, $52 = 0, $53 = 0, $54 = 0, $55 = 0.0, $56 = 0.0, $57 = 0, $58 = 0.0, $59 = 0.0;
 var $6 = 0, $60 = 0.0, $61 = 0.0, $62 = 0.0, $63 = 0.0, $64 = 0.0, $65 = 0.0, $66 = 0.0, $67 = 0.0, $68 = 0.0, $69 = 0.0, $7 = 0.0, $70 = 0, $71 = 0.0, $72 = 0.0, $73 = 0, $74 = 0.0, $75 = 0.0, $76 = 0.0, $77 = 0.0;
 var $78 = 0.0, $79 = 0.0, $8 = 0, $80 = 0, $81 = 0.0, $82 = 0.0, $83 = 0.0, $84 = 0, $85 = 0.0, $86 = 0.0, $87 = 0.0, $88 = 0.0, $89 = 0.0, $9 = 0.0, $90 = 0.0, $91 = 0.0, $92 = 0.0, $93 = 0.0, $94 = 0.0, $95 = 0.0;
 var $96 = 0.0, $97 = 0.0, $98 = 0.0, $99 = 0.0, $c1$02 = 0.0, $fi$0 = 0, $fi$1 = 0, $gi$0 = 0, $gi$1 = 0, $i$01 = 0, $k4$0 = 0, $s1$03 = 0.0, $tri$0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = $n << 1;
 $1 = (($fz) + ($0<<2)|0);
 $k4$0 = 4;$tri$0 = 6456;
 while(1) {
  $2 = $k4$0 >> 1;
  $3 = $k4$0 << 1;
  $4 = ($k4$0*3)|0;
  $5 = $k4$0 << 2;
  $6 = (($fz) + ($2<<2)|0);
  $fi$0 = $fz;$gi$0 = $6;
  while(1) {
   $7 = +HEAPF32[$fi$0>>2];
   $8 = (($fi$0) + ($k4$0<<2)|0);
   $9 = +HEAPF32[$8>>2];
   $10 = $7 - $9;
   $11 = $9 + $7;
   $12 = (($fi$0) + ($3<<2)|0);
   $13 = +HEAPF32[$12>>2];
   $14 = (($fi$0) + ($4<<2)|0);
   $15 = +HEAPF32[$14>>2];
   $16 = $13 - $15;
   $17 = $15 + $13;
   $18 = $11 - $17;
   HEAPF32[$12>>2] = $18;
   $19 = $17 + $11;
   HEAPF32[$fi$0>>2] = $19;
   $20 = $10 - $16;
   HEAPF32[$14>>2] = $20;
   $21 = $16 + $10;
   HEAPF32[$8>>2] = $21;
   $22 = +HEAPF32[$gi$0>>2];
   $23 = (($gi$0) + ($k4$0<<2)|0);
   $24 = +HEAPF32[$23>>2];
   $25 = $22 - $24;
   $26 = $24 + $22;
   $27 = (($gi$0) + ($4<<2)|0);
   $28 = +HEAPF32[$27>>2];
   $29 = $28;
   $30 = $29 * 1.4142135623730951;
   $31 = $30;
   $32 = (($gi$0) + ($3<<2)|0);
   $33 = +HEAPF32[$32>>2];
   $34 = $33;
   $35 = $34 * 1.4142135623730951;
   $36 = $35;
   $37 = $26 - $36;
   HEAPF32[$32>>2] = $37;
   $38 = $36 + $26;
   HEAPF32[$gi$0>>2] = $38;
   $39 = $25 - $31;
   HEAPF32[$27>>2] = $39;
   $40 = $31 + $25;
   HEAPF32[$23>>2] = $40;
   $41 = (($gi$0) + ($5<<2)|0);
   $42 = (($fi$0) + ($5<<2)|0);
   $43 = ($42>>>0)<($1>>>0);
   if ($43) {
    $fi$0 = $42;$gi$0 = $41;
   } else {
    break;
   }
  }
  $44 = ((($tri$0)) + 4|0);
  $45 = ($k4$0|0)>(2);
  if ($45) {
   $46 = +HEAPF32[$44>>2];
   $47 = +HEAPF32[$tri$0>>2];
   $c1$02 = $47;$i$01 = 1;$s1$03 = $46;
   while(1) {
    $48 = $s1$03 * 2.0;
    $49 = $48 * $s1$03;
    $50 = 1.0 - $49;
    $51 = $48 * $c1$02;
    $52 = (($fz) + ($i$01<<2)|0);
    $$sum = (($k4$0) - ($i$01))|0;
    $53 = (($fz) + ($$sum<<2)|0);
    $fi$1 = $52;$gi$1 = $53;
    while(1) {
     $54 = (($fi$1) + ($k4$0<<2)|0);
     $55 = +HEAPF32[$54>>2];
     $56 = $55 * $51;
     $57 = (($gi$1) + ($k4$0<<2)|0);
     $58 = +HEAPF32[$57>>2];
     $59 = $58 * $50;
     $60 = $56 - $59;
     $61 = $55 * $50;
     $62 = $58 * $51;
     $63 = $62 + $61;
     $64 = +HEAPF32[$fi$1>>2];
     $65 = $64 - $63;
     $66 = $63 + $64;
     $67 = +HEAPF32[$gi$1>>2];
     $68 = $67 - $60;
     $69 = $67 + $60;
     $70 = (($fi$1) + ($4<<2)|0);
     $71 = +HEAPF32[$70>>2];
     $72 = $71 * $51;
     $73 = (($gi$1) + ($4<<2)|0);
     $74 = +HEAPF32[$73>>2];
     $75 = $74 * $50;
     $76 = $72 - $75;
     $77 = $71 * $50;
     $78 = $74 * $51;
     $79 = $78 + $77;
     $80 = (($fi$1) + ($3<<2)|0);
     $81 = +HEAPF32[$80>>2];
     $82 = $81 - $79;
     $83 = $79 + $81;
     $84 = (($gi$1) + ($3<<2)|0);
     $85 = +HEAPF32[$84>>2];
     $86 = $85 - $76;
     $87 = $85 + $76;
     $88 = $83 * $s1$03;
     $89 = $86 * $c1$02;
     $90 = $88 - $89;
     $91 = $83 * $c1$02;
     $92 = $86 * $s1$03;
     $93 = $91 + $92;
     $94 = $66 - $93;
     HEAPF32[$80>>2] = $94;
     $95 = $93 + $66;
     HEAPF32[$fi$1>>2] = $95;
     $96 = $68 - $90;
     HEAPF32[$73>>2] = $96;
     $97 = $90 + $68;
     HEAPF32[$57>>2] = $97;
     $98 = $87 * $c1$02;
     $99 = $82 * $s1$03;
     $100 = $98 - $99;
     $101 = $87 * $s1$03;
     $102 = $82 * $c1$02;
     $103 = $101 + $102;
     $104 = $69 - $103;
     HEAPF32[$84>>2] = $104;
     $105 = $103 + $69;
     HEAPF32[$gi$1>>2] = $105;
     $106 = $65 - $100;
     HEAPF32[$70>>2] = $106;
     $107 = $100 + $65;
     HEAPF32[$54>>2] = $107;
     $108 = (($gi$1) + ($5<<2)|0);
     $109 = (($fi$1) + ($5<<2)|0);
     $110 = ($109>>>0)<($1>>>0);
     if ($110) {
      $fi$1 = $109;$gi$1 = $108;
     } else {
      break;
     }
    }
    $111 = +HEAPF32[$tri$0>>2];
    $112 = $111 * $c1$02;
    $113 = +HEAPF32[$44>>2];
    $114 = $113 * $s1$03;
    $115 = $112 - $114;
    $116 = $113 * $c1$02;
    $117 = $111 * $s1$03;
    $118 = $116 + $117;
    $119 = (($i$01) + 1)|0;
    $120 = ($119|0)<($2|0);
    if ($120) {
     $c1$02 = $115;$i$01 = $119;$s1$03 = $118;
    } else {
     break;
    }
   }
  }
  $121 = ((($tri$0)) + 8|0);
  $122 = ($5|0)<($0|0);
  if ($122) {
   $k4$0 = $5;$tri$0 = $121;
  } else {
   break;
  }
 }
 return;
}
function _lame_get_id3v2_tag($gfp,$buffer,$size) {
 $gfp = $gfp|0;
 $buffer = $buffer|0;
 $size = $size|0;
 var $$$i = 0, $$$i$i = 0, $$$i$i29 = 0, $$0 = 0, $$0$be$i$i = 0, $$0$i = 0, $$0$i$off0$i$i = 0, $$0$i$off0$i$i18 = 0, $$0$i$off0$i$i66 = 0, $$0$i$off0$i22$i = 0, $$0$i$off0$i30$i = 0, $$0$i$off0$i35$i = 0, $$0$i$off0$i8$i = 0, $$0$i$off0$i8$i47 = 0, $$0$i$off0$i836$i = 0, $$0$i$off0$i841$i = 0, $$0$i$off0$v$i$i = 0, $$0$i$off0$v$i$i17 = 0, $$0$i$off0$v$i$i65 = 0, $$0$i$off0$v$i21$i = 0;
 var $$0$i$off0$v$i29$i = 0, $$0$i$off0$v$i34$i = 0, $$0$i$off0$v$i7$i = 0, $$0$i$off0$v$i7$i46 = 0, $$0$i$off0$v$i735$i = 0, $$0$i$off0$v$i740$i = 0, $$0$i$off8$i$i = 0, $$0$i$off8$i$i20 = 0, $$0$i$off8$i$i68 = 0, $$0$i$off8$i10$i = 0, $$0$i$off8$i10$i49 = 0, $$0$i$off8$i1038$i = 0, $$0$i$off8$i1043$i = 0, $$0$i$off8$i24$i = 0, $$0$i$off8$i32$i = 0, $$0$i$off8$i37$i = 0, $$0$i$off8$v$i$i = 0, $$0$i$off8$v$i$i19 = 0, $$0$i$off8$v$i$i67 = 0, $$0$i$off8$v$i9$i = 0;
 var $$0$i$off8$v$i9$i48 = 0, $$0$i23 = 0, $$0$i3$i$i = 0, $$0$i3$off$i$i = 0, $$0$i53 = 0, $$0$sum$i = 0, $$0$sum30$i = 0, $$0$sum45$i = 0, $$01$ph8$i$i = 0, $$010$i25$i = 0, $$010$i33$i = 0, $$010$i339$i = 0, $$010$i344$i = 0, $$010$i38$i = 0, $$014$i$i = 0, $$014$i$i25 = 0, $$014$i$i56 = 0, $$014$i19$i = 0, $$014$i19$i36 = 0, $$014$i7$i = 0;
 var $$015$i$i = 0, $$02$lcssa$i12$i = 0, $$02$lcssa$i24$i = 0, $$02$ph7$i$i = 0, $$023$i$i = 0, $$023$i$i26 = 0, $$023$i$i57 = 0, $$023$i20$i = 0, $$023$i20$i37 = 0, $$023$i8$i = 0, $$048$i = 0, $$05$i$i = 0, $$05$i$i24 = 0, $$05$i$i55 = 0, $$05$i18$i = 0, $$05$i18$i35 = 0, $$05$i6$i = 0, $$0511$i = 0, $$06$i$i = 0, $$06$lcssa$i = 0;
 var $$0610$i = 0, $$09$i = 0, $$1$i16$i = 0, $$1$i5$i = 0, $$17$i = 0, $$idx$val = 0, $$idx9 = 0, $$idx9$val = 0, $$in$i$i = 0, $$lobit = 0, $$lobit85 = 0, $$pn = 0, $$pn$i = 0, $$pn$i14 = 0, $$pn$i62 = 0, $$pn40$i = 0, $$pn46$i = 0, $$pre$i$i = 0, $$pre$i$i15 = 0, $$pre$i$i63 = 0;
 var $$pre$i12$i = 0, $$pre$i12$i44 = 0, $$sink$i = 0, $$sum$i = 0, $$sum$i12 = 0, $$sum$i39 = 0, $$sum15$i = 0, $$sum26$i = 0, $$sum26$pn$i = 0, $$sum27$i = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0;
 var $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0;
 var $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0;
 var $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0;
 var $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0;
 var $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0;
 var $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0;
 var $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0;
 var $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0;
 var $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0;
 var $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0;
 var $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0, $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0;
 var $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0, $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0;
 var $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0, $332 = 0, $333 = 0, $334 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0;
 var $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0, $350 = 0, $351 = 0, $352 = 0, $353 = 0, $354 = 0, $355 = 0, $356 = 0, $357 = 0, $358 = 0, $359 = 0;
 var $36 = 0.0, $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0, $369 = 0, $37 = 0.0, $370 = 0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0;
 var $378 = 0, $379 = 0, $38 = 0, $380 = 0, $381 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0, $386 = 0, $387 = 0, $388 = 0, $389 = 0, $39 = 0, $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0;
 var $396 = 0, $397 = 0, $398 = 0, $399 = 0, $4 = 0, $40 = 0.0, $400 = 0, $401 = 0, $402 = 0, $403 = 0, $404 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0, $409 = 0, $41 = 0.0, $410 = 0, $411 = 0, $412 = 0;
 var $413 = 0, $414 = 0, $415 = 0, $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $421 = 0, $422 = 0, $423 = 0, $424 = 0, $425 = 0, $426 = 0, $427 = 0, $428 = 0, $429 = 0, $43 = 0, $430 = 0;
 var $431 = 0, $432 = 0, $433 = 0, $434 = 0, $435 = 0, $436 = 0, $437 = 0, $438 = 0, $439 = 0, $44 = 0, $440 = 0, $441 = 0, $442 = 0, $443 = 0, $444 = 0, $445 = 0, $446 = 0, $447 = 0, $448 = 0, $449 = 0;
 var $45 = 0, $450 = 0, $451 = 0, $452 = 0, $453 = 0, $454 = 0, $455 = 0, $456 = 0, $457 = 0, $458 = 0, $459 = 0, $46 = 0, $460 = 0, $461 = 0, $462 = 0, $463 = 0, $464 = 0, $465 = 0, $466 = 0, $467 = 0;
 var $468 = 0, $469 = 0, $47 = 0, $470 = 0, $471 = 0, $472 = 0, $473 = 0, $474 = 0, $475 = 0, $476 = 0, $477 = 0, $478 = 0, $479 = 0, $48 = 0, $480 = 0, $481 = 0, $482 = 0, $483 = 0, $484 = 0, $485 = 0;
 var $486 = 0, $487 = 0, $488 = 0, $489 = 0, $49 = 0, $490 = 0, $491 = 0, $492 = 0, $493 = 0, $494 = 0, $495 = 0, $496 = 0, $497 = 0, $498 = 0, $499 = 0, $5 = 0, $50 = 0, $500 = 0, $501 = 0, $502 = 0;
 var $503 = 0, $504 = 0, $505 = 0, $506 = 0, $507 = 0, $508 = 0, $509 = 0, $51 = 0, $510 = 0, $511 = 0, $512 = 0, $513 = 0, $514 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0;
 var $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0;
 var $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0;
 var $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $albumart_mime$0$ph = 0, $albumart_mime$1 = 0, $buffer$i = 0, $cond$i = 0, $cond$i$i = 0, $cond$i$i10 = 0, $cond$i$i32 = 0, $cond$i73 = 0, $cond$i75 = 0, $cond1$i = 0, $cond1$i$i = 0, $cond1$i$i34 = 0, $cond1$i77 = 0, $extract5$i$i = 0, $extract5$i$i16 = 0;
 var $extract5$i$i64 = 0, $extract5$i20$i = 0, $extract5$i28$i = 0, $extract5$i33$i = 0, $extract5$i6$i = 0, $extract5$i6$i45 = 0, $extract5$i634$i = 0, $extract5$i639$i = 0, $n$0$i = 0, $n$0$i$i = 0, $n$0$i$i33 = 0, $n$0$i76 = 0, $n$1$i = 0, $n$1$i$i = 0, $n$1$i$i11 = 0, $n$2$i$i = 0, $node$096 = 0, $node2$093 = 0, $notlhs = 0, $notrhs = 0;
 var $or$cond = 0, $or$cond3 = 0, $or$cond3$i = 0, $or$cond5 = 0, $or$cond7$not = 0, $or$cond82 = 0, $p$091 = 0, $p$1 = 0, $p$2 = 0, $p$3 = 0, $phitmp$i = 0, $phitmp$i41 = 0, $phitmp18$i = 0, $phitmp19$i = 0, $phitmp31$i = 0, $phitmp32$i = 0, $playlength_ms$0$i = 0, $scevgep$i = 0, $scevgep$i$i = 0, $scevgep$i$i30 = 0;
 var $scevgep$i$i70 = 0, $scevgep$i1$i = 0, $scevgep$i1$i59 = 0, $scevgep$i10$i = 0, $scevgep$i14$i = 0, $scevgep$i14$i51 = 0, $scevgep$i14$sum$i = 0, $scevgep$i14$sum27$i = 0, $scevgep$i2$i = 0, $scevgep$i22$i = 0, $scevgep$i22$i40 = 0, $scevgep$i22$sum$i = 0, $scevgep$i4$i = 0, $tag_size$0 = 0, $tag_size$195 = 0, $tag_size$2 = 0, $tag_size$3 = 0, $tag_size$4 = 0, $vararg_buffer = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 1040|0;
 $vararg_buffer = sp;
 $buffer$i = sp + 8|0;
 $0 = ($gfp|0)==(0|0);
 if ($0) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $1 = ((($gfp)) + 288|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if ($3) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $$idx9 = ((($2)) + 85696|0);
 $$idx9$val = HEAP32[$$idx9>>2]|0;
 $$lobit = $$idx9$val & 4;
 $4 = ($$lobit|0)==(0);
 if (!($4)) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $5 = $$idx9$val & 10;
 $6 = ((($2)) + 85704|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)==(0|0);
 if ($8) {
  $22 = 0;
 } else {
  $9 = (_strlen(($7|0))|0);
  $22 = $9;
 }
 $10 = ((($2)) + 85708|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ($11|0)==(0|0);
 if ($12) {
  $24 = 0;
 } else {
  $13 = (_strlen(($11|0))|0);
  $24 = $13;
 }
 $14 = ((($2)) + 85712|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = ($15|0)==(0|0);
 if ($16) {
  $26 = 0;
 } else {
  $17 = (_strlen(($15|0))|0);
  $26 = $17;
 }
 $18 = ((($2)) + 85716|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = ($19|0)==(0|0);
 if ($20) {
  $28 = 0;
 } else {
  $21 = (_strlen(($19|0))|0);
  $28 = $21;
 }
 $23 = ($22>>>0)>(30);
 $25 = ($24>>>0)>(30);
 $or$cond = $23 | $25;
 $27 = ($26>>>0)>(30);
 $or$cond3 = $or$cond | $27;
 $29 = ($28>>>0)>(30);
 $or$cond5 = $or$cond3 | $29;
 if (!($or$cond5)) {
  $30 = ((($2)) + 85720|0);
  $31 = HEAP32[$30>>2]|0;
  $notlhs = ($31|0)==(0);
  $notrhs = ($28>>>0)<(29);
  $or$cond7$not = $notrhs | $notlhs;
  $32 = ($5|0)==(0);
  $or$cond82 = $32 & $or$cond7$not;
  if ($or$cond82) {
   $$0 = 0;
   STACKTOP = sp;return ($$0|0);
  }
 }
 $33 = ((($gfp)) + 4|0);
 $34 = HEAP32[$33>>2]|0;
 $35 = ($34|0)==(-1);
 if (!($35)) {
  $36 = (+($34>>>0));
  $37 = $36 * 1000.0;
  $38 = ((($2)) + 60|0);
  $39 = HEAP32[$38>>2]|0;
  $40 = (+($39|0));
  $41 = $37 / $40;
  $42 = $41 > 4294967295.0;
  if ($42) {
   $playlength_ms$0$i = -1;
  } else {
   $43 = $41 < 0.0;
   if ($43) {
    $playlength_ms$0$i = 0;
   } else {
    $44 = (~~(($41))>>>0);
    $playlength_ms$0$i = $44;
   }
  }
  HEAP32[$vararg_buffer>>2] = $playlength_ms$0$i;
  (_sprintf($buffer$i,6496,$vararg_buffer)|0);
  $45 = HEAP32[$1>>2]|0;
  $46 = ($45|0)==(0|0);
  if (!($46)) {
   $47 = ((($45)) + 85696|0);
   $48 = HEAP32[$47>>2]|0;
   (_id3v2_add_latin1($gfp,1414284622,6488,0,$buffer$i)|0);
   HEAP32[$47>>2] = $48;
  }
 }
 $49 = ((($2)) + 85728|0);
 $50 = HEAP32[$49>>2]|0;
 $51 = ($50|0)==(0|0);
 do {
  if ($51) {
   $albumart_mime$1 = 0;$tag_size$0 = 10;
  } else {
   $52 = ((($2)) + 85732|0);
   $53 = HEAP32[$52>>2]|0;
   $54 = ($53|0)==(0);
   if ($54) {
    $albumart_mime$1 = 0;$tag_size$0 = 10;
   } else {
    $55 = ((($2)) + 85740|0);
    $56 = HEAP32[$55>>2]|0;
    if ((($56|0) == 2)) {
     $albumart_mime$0$ph = 6504;
    } else if ((($56|0) == 3)) {
     $albumart_mime$0$ph = 6520;
    } else if ((($56|0) == 1)) {
     $albumart_mime$0$ph = 6536;
    } else {
     $albumart_mime$1 = 0;$tag_size$0 = 10;
     break;
    }
    $57 = (_strlen(($albumart_mime$0$ph|0))|0);
    $58 = (($57) + 24)|0;
    $59 = (($58) + ($53))|0;
    $albumart_mime$1 = $albumart_mime$0$ph;$tag_size$0 = $59;
   }
  }
 } while(0);
 $60 = ((($2)) + 85744|0);
 $61 = HEAP32[$60>>2]|0;
 $62 = ($61|0)==(0|0);
 if ($62) {
  $tag_size$3 = $tag_size$0;
 } else {
  $node$096 = $61;$tag_size$195 = $tag_size$0;
  while(1) {
   $63 = ((($node$096)) + 4|0);
   $64 = HEAP32[$63>>2]|0;
   do {
    if ((($64|0) == 1431520594) | (($64|0) == 1129270605)) {
     $65 = ((($node$096)) + 20|0);
     $66 = HEAP32[$65>>2]|0;
     $cond$i75 = ($66|0)==(1);
     $67 = ((($node$096)) + 16|0);
     $68 = HEAP32[$67>>2]|0;
     $69 = $68 << 1;
     $70 = (($69) + 16)|0;
     $71 = (($68) + 15)|0;
     $n$0$i76 = $cond$i75 ? $70 : $71;
     $72 = ((($node$096)) + 32|0);
     $73 = HEAP32[$72>>2]|0;
     $cond1$i77 = ($73|0)==(1);
     $74 = ((($node$096)) + 28|0);
     $75 = HEAP32[$74>>2]|0;
     if ($cond1$i77) {
      $77 = $75 << 1;
      $78 = (($n$0$i76) + ($77))|0;
      $$pn = $78;
      break;
     } else {
      $76 = (($n$0$i76) + ($75))|0;
      $$pn = $76;
      break;
     }
    } else {
     $79 = $64 & -16777216;
     if (!((($79|0) == 0) | (($79|0) == 1459617792))) {
      $96 = ((($node$096)) + 32|0);
      $97 = HEAP32[$96>>2]|0;
      $cond$i = ($97|0)==(1);
      $98 = ((($node$096)) + 16|0);
      $99 = HEAP32[$98>>2]|0;
      $100 = ($99|0)!=(0);
      $101 = ((($node$096)) + 28|0);
      $102 = HEAP32[$101>>2]|0;
      if ($cond$i) {
       $105 = $99 << 1;
       $106 = (($105) + 13)|0;
       $n$1$i = $100 ? $106 : 11;
       $107 = $102 << 1;
       $108 = (($n$1$i) + ($107))|0;
       $$pn = $108;
       break;
      } else {
       $103 = (($99) + 12)|0;
       $$$i = $100 ? $103 : 11;
       $104 = (($$$i) + ($102))|0;
       $$pn = $104;
       break;
      }
     }
     $80 = ((($node$096)) + 16|0);
     $81 = HEAP32[$80>>2]|0;
     $82 = ($81|0)==(0);
     do {
      if ($82) {
       $n$0$i = 10;
      } else {
       $83 = ((($node$096)) + 20|0);
       $84 = HEAP32[$83>>2]|0;
       $cond$i73 = ($84|0)==(1);
       if ($cond$i73) {
        $86 = $81 << 1;
        $87 = (($86) + 13)|0;
        $n$0$i = $87;
        break;
       } else {
        $85 = (($81) + 12)|0;
        $n$0$i = $85;
        break;
       }
      }
     } while(0);
     $88 = ((($node$096)) + 28|0);
     $89 = HEAP32[$88>>2]|0;
     $90 = ($89|0)==(0);
     if ($90) {
      $$pn = $n$0$i;
     } else {
      $91 = ((($node$096)) + 32|0);
      $92 = HEAP32[$91>>2]|0;
      $cond1$i = ($92|0)==(1);
      if ($cond1$i) {
       $94 = (($n$0$i) + -1)|0;
       $95 = (($94) + ($89))|0;
       $$pn = $95;
       break;
      } else {
       $93 = (($89) + ($n$0$i))|0;
       $$pn = $93;
       break;
      }
     }
    }
   } while(0);
   $tag_size$2 = (($$pn) + ($tag_size$195))|0;
   $109 = HEAP32[$node$096>>2]|0;
   $110 = ($109|0)==(0|0);
   if ($110) {
    $tag_size$3 = $tag_size$2;
    break;
   } else {
    $node$096 = $109;$tag_size$195 = $tag_size$2;
   }
  }
 }
 $$idx$val = HEAP32[$$idx9>>2]|0;
 $$lobit85 = $$idx$val & 32;
 $111 = ($$lobit85|0)==(0);
 if ($111) {
  $tag_size$4 = $tag_size$3;
 } else {
  $112 = ((($2)) + 85736|0);
  $113 = HEAP32[$112>>2]|0;
  $114 = (($113) + ($tag_size$3))|0;
  $tag_size$4 = $114;
 }
 $115 = ($tag_size$4>>>0)>($size>>>0);
 if ($115) {
  $$0 = $tag_size$4;
  STACKTOP = sp;return ($$0|0);
 }
 $116 = ($buffer|0)==(0|0);
 if ($116) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $117 = ((($buffer)) + 1|0);
 HEAP8[$buffer>>0] = 73;
 $118 = ((($buffer)) + 2|0);
 HEAP8[$117>>0] = 68;
 $119 = ((($buffer)) + 3|0);
 HEAP8[$118>>0] = 51;
 $120 = ((($buffer)) + 4|0);
 HEAP8[$119>>0] = 3;
 $121 = ((($buffer)) + 5|0);
 HEAP8[$120>>0] = 0;
 $122 = ((($buffer)) + 6|0);
 HEAP8[$121>>0] = 0;
 $123 = (($tag_size$4) + -10)|0;
 $124 = $123 >>> 21;
 $125 = $124 & 127;
 $126 = $125&255;
 $127 = ((($buffer)) + 7|0);
 HEAP8[$122>>0] = $126;
 $128 = $123 >>> 14;
 $129 = $128 & 127;
 $130 = $129&255;
 $131 = ((($buffer)) + 8|0);
 HEAP8[$127>>0] = $130;
 $132 = $123 >>> 7;
 $133 = $132 & 127;
 $134 = $133&255;
 $135 = ((($buffer)) + 9|0);
 HEAP8[$131>>0] = $134;
 $136 = $123 & 127;
 $137 = $136&255;
 $138 = ((($buffer)) + 10|0);
 HEAP8[$135>>0] = $137;
 $139 = HEAP32[$60>>2]|0;
 $140 = ($139|0)==(0|0);
 if ($140) {
  $p$2 = $138;
 } else {
  $node2$093 = $139;$p$091 = $138;
  while(1) {
   $141 = ((($node2$093)) + 4|0);
   $142 = HEAP32[$141>>2]|0;
   do {
    if ((($142|0) == 1431520594) | (($142|0) == 1129270605)) {
     $143 = ((($node2$093)) + 20|0);
     $144 = HEAP32[$143>>2]|0;
     $cond$i$i32 = ($144|0)==(1);
     $145 = ((($node2$093)) + 16|0);
     $146 = HEAP32[$145>>2]|0;
     $147 = $146 << 1;
     $148 = (($147) + 16)|0;
     $149 = (($146) + 15)|0;
     $n$0$i$i33 = $cond$i$i32 ? $148 : $149;
     $150 = ((($node2$093)) + 32|0);
     $151 = HEAP32[$150>>2]|0;
     $cond1$i$i34 = ($151|0)==(1);
     $152 = ((($node2$093)) + 28|0);
     $153 = HEAP32[$152>>2]|0;
     $154 = $cond1$i$i34&1;
     $$sink$i = $153 << $154;
     $155 = (($$sink$i) + ($n$0$i$i33))|0;
     $156 = ($155>>>0)>(10);
     if ($156) {
      $157 = $142&255;
      $158 = ((($p$091)) + 3|0);
      HEAP8[$158>>0] = $157;
      $159 = $142 >>> 8;
      $160 = $159&255;
      $161 = ((($p$091)) + 2|0);
      HEAP8[$161>>0] = $160;
      $162 = $142 >>> 16;
      $163 = $162&255;
      $164 = ((($p$091)) + 1|0);
      HEAP8[$164>>0] = $163;
      $165 = $142 >>> 24;
      $166 = $165&255;
      HEAP8[$p$091>>0] = $166;
      $167 = ((($p$091)) + 4|0);
      $168 = (($155) + -10)|0;
      $169 = $168&255;
      $170 = ((($p$091)) + 7|0);
      HEAP8[$170>>0] = $169;
      $171 = $168 >>> 8;
      $172 = $171&255;
      $173 = ((($p$091)) + 6|0);
      HEAP8[$173>>0] = $172;
      $174 = $168 >>> 16;
      $175 = $174&255;
      $176 = ((($p$091)) + 5|0);
      HEAP8[$176>>0] = $175;
      $177 = $168 >>> 24;
      $178 = $177&255;
      HEAP8[$167>>0] = $178;
      $179 = ((($p$091)) + 8|0);
      $180 = ((($p$091)) + 9|0);
      HEAP8[$179>>0] = 0;
      $181 = ((($p$091)) + 10|0);
      HEAP8[$180>>0] = 0;
      $182 = ((($node2$093)) + 24|0);
      $183 = HEAP32[$150>>2]|0;
      $184 = ($183|0)==(1);
      $185 = $184&1;
      $186 = ((($p$091)) + 11|0);
      HEAP8[$181>>0] = $185;
      $187 = ((($node2$093)) + 8|0);
      $188 = HEAP8[$187>>0]|0;
      $189 = ((($p$091)) + 12|0);
      HEAP8[$186>>0] = $188;
      $190 = ((($node2$093)) + 9|0);
      $191 = HEAP8[$190>>0]|0;
      $192 = ((($p$091)) + 13|0);
      HEAP8[$189>>0] = $191;
      $193 = ((($node2$093)) + 10|0);
      $194 = HEAP8[$193>>0]|0;
      $195 = ((($p$091)) + 14|0);
      HEAP8[$192>>0] = $194;
      $196 = ((($node2$093)) + 12|0);
      $197 = HEAP32[$143>>2]|0;
      $198 = ($197|0)==(1);
      if ($198) {
       $207 = HEAP32[$196>>2]|0;
       $208 = HEAP32[$145>>2]|0;
       $209 = ($208|0)==(0);
       if ($209) {
        $$1$i16$i = $195;$224 = 15;$514 = 16;
       } else {
        $210 = HEAP16[$207>>1]|0;
        $211 = ($210<<16>>16)==(-2);
        $212 = $208 << 1;
        $213 = (($208) + -1)|0;
        $extract5$i639$i = ($210&65535) >>> 8;
        $$0$i$off0$v$i740$i = $211 ? $extract5$i639$i : $210;
        $$0$i$off0$i841$i = $$0$i$off0$v$i740$i&255;
        $214 = $extract5$i639$i&255;
        $$0$i$off8$i1043$i = $211 ? -2 : $214;
        $215 = ((($p$091)) + 15|0);
        HEAP8[$195>>0] = $$0$i$off0$i841$i;
        HEAP8[$215>>0] = $$0$i$off8$i1043$i;
        $216 = ($213|0)==(0);
        if (!($216)) {
         $$010$i344$i = $195;$$pn46$i = $207;$220 = $213;
         while(1) {
          $217 = ((($$pn46$i)) + 2|0);
          $218 = ((($$010$i344$i)) + 2|0);
          $$pre$i12$i44 = HEAP16[$217>>1]|0;
          $219 = (($220) + -1)|0;
          $extract5$i6$i45 = ($$pre$i12$i44&65535) >>> 8;
          $$0$i$off0$v$i7$i46 = $211 ? $extract5$i6$i45 : $$pre$i12$i44;
          $$0$i$off0$i8$i47 = $$0$i$off0$v$i7$i46&255;
          $$0$i$off8$v$i9$i48 = $211 ? $$pre$i12$i44 : $extract5$i6$i45;
          $$0$i$off8$i10$i49 = $$0$i$off8$v$i9$i48&255;
          $221 = ((($$010$i344$i)) + 3|0);
          HEAP8[$218>>0] = $$0$i$off0$i8$i47;
          HEAP8[$221>>0] = $$0$i$off8$i10$i49;
          $222 = ($219|0)==(0);
          if ($222) {
           break;
          } else {
           $$010$i344$i = $218;$$pn46$i = $217;$220 = $219;
          }
         }
        }
        $$sum27$i = (($212) + 14)|0;
        $scevgep$i14$i51 = (($p$091) + ($$sum27$i)|0);
        $phitmp31$i = (($212) + 15)|0;
        $phitmp32$i = (($212) + 16)|0;
        $$1$i16$i = $scevgep$i14$i51;$224 = $phitmp31$i;$514 = $phitmp32$i;
       }
       $223 = (($p$091) + ($224)|0);
       HEAP8[$$1$i16$i>>0] = 0;
       HEAP8[$223>>0] = 0;
       $$sum26$pn$i = $514;
      } else {
       $199 = HEAP32[$145>>2]|0;
       $200 = ($199|0)==(0);
       if ($200) {
        $$02$lcssa$i24$i = $195;$513 = 15;
       } else {
        $201 = HEAP32[$196>>2]|0;
        $$014$i19$i36 = $201;$$023$i20$i37 = $195;$$05$i18$i35 = $199;
        while(1) {
         $202 = (($$05$i18$i35) + -1)|0;
         $203 = ((($$014$i19$i36)) + 1|0);
         $204 = HEAP8[$$014$i19$i36>>0]|0;
         $205 = ((($$023$i20$i37)) + 1|0);
         HEAP8[$$023$i20$i37>>0] = $204;
         $206 = ($202|0)==(0);
         if ($206) {
          break;
         } else {
          $$014$i19$i36 = $203;$$023$i20$i37 = $205;$$05$i18$i35 = $202;
         }
        }
        $$sum$i39 = (($199) + 14)|0;
        $scevgep$i22$i40 = (($p$091) + ($$sum$i39)|0);
        $phitmp$i41 = (($199) + 15)|0;
        $$02$lcssa$i24$i = $scevgep$i22$i40;$513 = $phitmp$i41;
       }
       HEAP8[$$02$lcssa$i24$i>>0] = 0;
       $$sum26$pn$i = $513;
      }
      $$0$i53 = (($p$091) + ($$sum26$pn$i)|0);
      $225 = HEAP32[$150>>2]|0;
      $226 = ($225|0)==(1);
      if ($226) {
       $235 = HEAP32[$182>>2]|0;
       $236 = HEAP32[$152>>2]|0;
       $237 = ($236|0)==(0);
       if ($237) {
        $p$1 = $$0$i53;
        break;
       }
       $238 = HEAP16[$235>>1]|0;
       $239 = ($238<<16>>16)==(-2);
       $240 = $236 << 1;
       $241 = (($236) + -1)|0;
       $extract5$i33$i = ($238&65535) >>> 8;
       $$0$i$off0$v$i34$i = $239 ? $extract5$i33$i : $238;
       $$0$i$off0$i35$i = $$0$i$off0$v$i34$i&255;
       $242 = $extract5$i33$i&255;
       $$0$i$off8$i37$i = $239 ? -2 : $242;
       $$0$sum45$i = (($$sum26$pn$i) + 1)|0;
       $243 = (($p$091) + ($$0$sum45$i)|0);
       HEAP8[$$0$i53>>0] = $$0$i$off0$i35$i;
       HEAP8[$243>>0] = $$0$i$off8$i37$i;
       $244 = ($241|0)==(0);
       if (!($244)) {
        $$010$i38$i = $$0$i53;$$pn$i62 = $235;$248 = $241;
        while(1) {
         $245 = ((($$pn$i62)) + 2|0);
         $246 = ((($$010$i38$i)) + 2|0);
         $$pre$i$i63 = HEAP16[$245>>1]|0;
         $247 = (($248) + -1)|0;
         $extract5$i$i64 = ($$pre$i$i63&65535) >>> 8;
         $$0$i$off0$v$i$i65 = $239 ? $extract5$i$i64 : $$pre$i$i63;
         $$0$i$off0$i$i66 = $$0$i$off0$v$i$i65&255;
         $$0$i$off8$v$i$i67 = $239 ? $$pre$i$i63 : $extract5$i$i64;
         $$0$i$off8$i$i68 = $$0$i$off8$v$i$i67&255;
         $249 = ((($$010$i38$i)) + 3|0);
         HEAP8[$246>>0] = $$0$i$off0$i$i66;
         HEAP8[$249>>0] = $$0$i$off8$i$i68;
         $250 = ($247|0)==(0);
         if ($250) {
          break;
         } else {
          $$010$i38$i = $246;$$pn$i62 = $245;$248 = $247;
         }
        }
       }
       $$0$sum30$i = (($240) + ($$sum26$pn$i))|0;
       $scevgep$i$i70 = (($p$091) + ($$0$sum30$i)|0);
       $p$1 = $scevgep$i$i70;
       break;
      } else {
       $227 = HEAP32[$152>>2]|0;
       $228 = ($227|0)==(0);
       if ($228) {
        $p$1 = $$0$i53;
        break;
       }
       $229 = HEAP32[$182>>2]|0;
       $$014$i$i56 = $229;$$023$i$i57 = $$0$i53;$$05$i$i55 = $227;
       while(1) {
        $230 = (($$05$i$i55) + -1)|0;
        $231 = ((($$014$i$i56)) + 1|0);
        $232 = HEAP8[$$014$i$i56>>0]|0;
        $233 = ((($$023$i$i57)) + 1|0);
        HEAP8[$$023$i$i57>>0] = $232;
        $234 = ($230|0)==(0);
        if ($234) {
         break;
        } else {
         $$014$i$i56 = $231;$$023$i$i57 = $233;$$05$i$i55 = $230;
        }
       }
       $$0$sum$i = (($227) + ($$sum26$pn$i))|0;
       $scevgep$i1$i59 = (($p$091) + ($$0$sum$i)|0);
       $p$1 = $scevgep$i1$i59;
       break;
      }
     } else {
      $p$1 = $p$091;
     }
    } else {
     $251 = $142 & -16777216;
     if (!((($251|0) == 0) | (($251|0) == 1459617792))) {
      $365 = ((($node2$093)) + 32|0);
      $366 = HEAP32[$365>>2]|0;
      $cond$i$i = ($366|0)==(1);
      $367 = ((($node2$093)) + 16|0);
      $368 = HEAP32[$367>>2]|0;
      $369 = ($368|0)!=(0);
      $370 = ((($node2$093)) + 28|0);
      $371 = HEAP32[$370>>2]|0;
      if ($cond$i$i) {
       $374 = $368 << 1;
       $375 = (($374) + 13)|0;
       $n$1$i$i = $369 ? $375 : 11;
       $376 = $371 << 1;
       $377 = (($n$1$i$i) + ($376))|0;
       $n$2$i$i = $377;
      } else {
       $372 = (($368) + 12)|0;
       $$$i$i = $369 ? $372 : 11;
       $373 = (($$$i$i) + ($371))|0;
       $n$2$i$i = $373;
      }
      $378 = ($n$2$i$i>>>0)>(10);
      if (!($378)) {
       $p$1 = $p$091;
       break;
      }
      $379 = $142&255;
      $380 = ((($p$091)) + 3|0);
      HEAP8[$380>>0] = $379;
      $381 = $142 >>> 8;
      $382 = $381&255;
      $383 = ((($p$091)) + 2|0);
      HEAP8[$383>>0] = $382;
      $384 = $142 >>> 16;
      $385 = $384&255;
      $386 = ((($p$091)) + 1|0);
      HEAP8[$386>>0] = $385;
      $387 = $142 >>> 24;
      $388 = $387&255;
      HEAP8[$p$091>>0] = $388;
      $389 = ((($p$091)) + 4|0);
      $390 = (($n$2$i$i) + -10)|0;
      $391 = $390&255;
      $392 = ((($p$091)) + 7|0);
      HEAP8[$392>>0] = $391;
      $393 = $390 >>> 8;
      $394 = $393&255;
      $395 = ((($p$091)) + 6|0);
      HEAP8[$395>>0] = $394;
      $396 = $390 >>> 16;
      $397 = $396&255;
      $398 = ((($p$091)) + 5|0);
      HEAP8[$398>>0] = $397;
      $399 = $390 >>> 24;
      $400 = $399&255;
      HEAP8[$389>>0] = $400;
      $401 = ((($p$091)) + 8|0);
      $402 = ((($p$091)) + 9|0);
      HEAP8[$401>>0] = 0;
      $403 = ((($p$091)) + 10|0);
      HEAP8[$402>>0] = 0;
      $404 = ((($node2$093)) + 24|0);
      $405 = HEAP32[$365>>2]|0;
      $406 = ($405|0)==(1);
      $407 = $406&1;
      $408 = ((($p$091)) + 11|0);
      HEAP8[$403>>0] = $407;
      $409 = HEAP32[$367>>2]|0;
      $410 = ($409|0)==(0);
      do {
       if ($410) {
        $$0$i = $408;
       } else {
        $411 = ((($node2$093)) + 20|0);
        $412 = HEAP32[$411>>2]|0;
        $413 = ($412|0)==(1);
        $414 = ((($node2$093)) + 12|0);
        if ($413) {
         $422 = HEAP32[$414>>2]|0;
         $423 = HEAP16[$422>>1]|0;
         $424 = ($423<<16>>16)==(-2);
         $425 = $409 << 1;
         $426 = (($409) + -1)|0;
         $extract5$i634$i = ($423&65535) >>> 8;
         $$0$i$off0$v$i735$i = $424 ? $extract5$i634$i : $423;
         $$0$i$off0$i836$i = $$0$i$off0$v$i735$i&255;
         $427 = $extract5$i634$i&255;
         $$0$i$off8$i1038$i = $424 ? -2 : $427;
         $428 = ((($p$091)) + 12|0);
         HEAP8[$408>>0] = $$0$i$off0$i836$i;
         HEAP8[$428>>0] = $$0$i$off8$i1038$i;
         $429 = ($426|0)==(0);
         if (!($429)) {
          $$010$i339$i = $408;$$pn40$i = $422;$433 = $426;
          while(1) {
           $430 = ((($$pn40$i)) + 2|0);
           $431 = ((($$010$i339$i)) + 2|0);
           $$pre$i12$i = HEAP16[$430>>1]|0;
           $432 = (($433) + -1)|0;
           $extract5$i6$i = ($$pre$i12$i&65535) >>> 8;
           $$0$i$off0$v$i7$i = $424 ? $extract5$i6$i : $$pre$i12$i;
           $$0$i$off0$i8$i = $$0$i$off0$v$i7$i&255;
           $$0$i$off8$v$i9$i = $424 ? $$pre$i12$i : $extract5$i6$i;
           $$0$i$off8$i10$i = $$0$i$off8$v$i9$i&255;
           $434 = ((($$010$i339$i)) + 3|0);
           HEAP8[$431>>0] = $$0$i$off0$i8$i;
           HEAP8[$434>>0] = $$0$i$off8$i10$i;
           $435 = ($432|0)==(0);
           if ($435) {
            break;
           } else {
            $$010$i339$i = $431;$$pn40$i = $430;$433 = $432;
           }
          }
         }
         $$sum26$i = (($425) + 11)|0;
         $scevgep$i14$i = (($p$091) + ($$sum26$i)|0);
         $scevgep$i14$sum$i = (($425) + 12)|0;
         $436 = (($p$091) + ($scevgep$i14$sum$i)|0);
         HEAP8[$scevgep$i14$i>>0] = 0;
         $scevgep$i14$sum27$i = (($425) + 13)|0;
         $437 = (($p$091) + ($scevgep$i14$sum27$i)|0);
         HEAP8[$436>>0] = 0;
         $$0$i = $437;
         break;
        } else {
         $415 = HEAP32[$414>>2]|0;
         $$014$i19$i = $415;$$023$i20$i = $408;$$05$i18$i = $409;
         while(1) {
          $416 = (($$05$i18$i) + -1)|0;
          $417 = ((($$014$i19$i)) + 1|0);
          $418 = HEAP8[$$014$i19$i>>0]|0;
          $419 = ((($$023$i20$i)) + 1|0);
          HEAP8[$$023$i20$i>>0] = $418;
          $420 = ($416|0)==(0);
          if ($420) {
           break;
          } else {
           $$014$i19$i = $417;$$023$i20$i = $419;$$05$i18$i = $416;
          }
         }
         $$sum$i = (($409) + 11)|0;
         $scevgep$i22$i = (($p$091) + ($$sum$i)|0);
         $scevgep$i22$sum$i = (($409) + 12)|0;
         $421 = (($p$091) + ($scevgep$i22$sum$i)|0);
         HEAP8[$scevgep$i22$i>>0] = 0;
         $$0$i = $421;
         break;
        }
       }
      } while(0);
      $438 = HEAP32[$365>>2]|0;
      $439 = ($438|0)==(1);
      if ($439) {
       $448 = HEAP32[$404>>2]|0;
       $449 = HEAP32[$370>>2]|0;
       $450 = ($449|0)==(0);
       if ($450) {
        $p$1 = $$0$i;
        break;
       }
       $451 = HEAP16[$448>>1]|0;
       $452 = ($451<<16>>16)==(-2);
       $453 = $449 << 1;
       $454 = (($449) + -1)|0;
       $extract5$i28$i = ($451&65535) >>> 8;
       $$0$i$off0$v$i29$i = $452 ? $extract5$i28$i : $451;
       $$0$i$off0$i30$i = $$0$i$off0$v$i29$i&255;
       $455 = $extract5$i28$i&255;
       $$0$i$off8$i32$i = $452 ? -2 : $455;
       $456 = ((($$0$i)) + 1|0);
       HEAP8[$$0$i>>0] = $$0$i$off0$i30$i;
       HEAP8[$456>>0] = $$0$i$off8$i32$i;
       $457 = ($454|0)==(0);
       if (!($457)) {
        $$010$i33$i = $$0$i;$$pn$i = $448;$461 = $454;
        while(1) {
         $458 = ((($$pn$i)) + 2|0);
         $459 = ((($$010$i33$i)) + 2|0);
         $$pre$i$i = HEAP16[$458>>1]|0;
         $460 = (($461) + -1)|0;
         $extract5$i$i = ($$pre$i$i&65535) >>> 8;
         $$0$i$off0$v$i$i = $452 ? $extract5$i$i : $$pre$i$i;
         $$0$i$off0$i$i = $$0$i$off0$v$i$i&255;
         $$0$i$off8$v$i$i = $452 ? $$pre$i$i : $extract5$i$i;
         $$0$i$off8$i$i = $$0$i$off8$v$i$i&255;
         $462 = ((($$010$i33$i)) + 3|0);
         HEAP8[$459>>0] = $$0$i$off0$i$i;
         HEAP8[$462>>0] = $$0$i$off8$i$i;
         $463 = ($460|0)==(0);
         if ($463) {
          break;
         } else {
          $$010$i33$i = $459;$$pn$i = $458;$461 = $460;
         }
        }
       }
       $scevgep$i$i = (($$0$i) + ($453)|0);
       $p$1 = $scevgep$i$i;
       break;
      } else {
       $440 = HEAP32[$370>>2]|0;
       $441 = ($440|0)==(0);
       if ($441) {
        $p$1 = $$0$i;
        break;
       }
       $442 = HEAP32[$404>>2]|0;
       $$014$i$i = $442;$$023$i$i = $$0$i;$$05$i$i = $440;
       while(1) {
        $443 = (($$05$i$i) + -1)|0;
        $444 = ((($$014$i$i)) + 1|0);
        $445 = HEAP8[$$014$i$i>>0]|0;
        $446 = ((($$023$i$i)) + 1|0);
        HEAP8[$$023$i$i>>0] = $445;
        $447 = ($443|0)==(0);
        if ($447) {
         break;
        } else {
         $$014$i$i = $444;$$023$i$i = $446;$$05$i$i = $443;
        }
       }
       $scevgep$i1$i = (($$0$i) + ($440)|0);
       $p$1 = $scevgep$i1$i;
       break;
      }
     }
     $252 = ((($node2$093)) + 16|0);
     $253 = HEAP32[$252>>2]|0;
     $254 = ($253|0)==(0);
     do {
      if ($254) {
       $n$0$i$i = 10;
      } else {
       $255 = ((($node2$093)) + 20|0);
       $256 = HEAP32[$255>>2]|0;
       $cond$i$i10 = ($256|0)==(1);
       if ($cond$i$i10) {
        $258 = $253 << 1;
        $259 = (($258) + 13)|0;
        $n$0$i$i = $259;
        break;
       } else {
        $257 = (($253) + 12)|0;
        $n$0$i$i = $257;
        break;
       }
      }
     } while(0);
     $260 = ((($node2$093)) + 28|0);
     $261 = HEAP32[$260>>2]|0;
     $262 = ($261|0)==(0);
     do {
      if ($262) {
       $n$1$i$i11 = $n$0$i$i;
      } else {
       $263 = ((($node2$093)) + 32|0);
       $264 = HEAP32[$263>>2]|0;
       $cond1$i$i = ($264|0)==(1);
       if ($cond1$i$i) {
        $266 = (($n$0$i$i) + -1)|0;
        $267 = (($266) + ($261))|0;
        $n$1$i$i11 = $267;
        break;
       } else {
        $265 = (($261) + ($n$0$i$i))|0;
        $n$1$i$i11 = $265;
        break;
       }
      }
     } while(0);
     $268 = ($n$1$i$i11>>>0)>(10);
     if (!($268)) {
      $p$1 = $p$091;
      break;
     }
     $269 = $142&255;
     $270 = ((($p$091)) + 3|0);
     HEAP8[$270>>0] = $269;
     $271 = $142 >>> 8;
     $272 = $271&255;
     $273 = ((($p$091)) + 2|0);
     HEAP8[$273>>0] = $272;
     $274 = $142 >>> 16;
     $275 = $274&255;
     $276 = ((($p$091)) + 1|0);
     HEAP8[$276>>0] = $275;
     $277 = $142 >>> 24;
     $278 = $277&255;
     HEAP8[$p$091>>0] = $278;
     $279 = ((($p$091)) + 4|0);
     $280 = (($n$1$i$i11) + -10)|0;
     $281 = $280&255;
     $282 = ((($p$091)) + 7|0);
     HEAP8[$282>>0] = $281;
     $283 = $280 >>> 8;
     $284 = $283&255;
     $285 = ((($p$091)) + 6|0);
     HEAP8[$285>>0] = $284;
     $286 = $280 >>> 16;
     $287 = $286&255;
     $288 = ((($p$091)) + 5|0);
     HEAP8[$288>>0] = $287;
     $289 = $280 >>> 24;
     $290 = $289&255;
     HEAP8[$279>>0] = $290;
     $291 = ((($p$091)) + 8|0);
     $292 = ((($p$091)) + 9|0);
     HEAP8[$291>>0] = 0;
     $293 = ((($p$091)) + 10|0);
     HEAP8[$292>>0] = 0;
     $294 = HEAP32[$252>>2]|0;
     $295 = ($294|0)==(0);
     do {
      if ($295) {
       $$0$i23 = $293;
      } else {
       $296 = ((($node2$093)) + 20|0);
       $297 = HEAP32[$296>>2]|0;
       $298 = ($297|0)==(1);
       $299 = $298&1;
       $300 = ((($p$091)) + 11|0);
       HEAP8[$293>>0] = $299;
       $301 = HEAP32[$296>>2]|0;
       $302 = ($301|0)==(1);
       $303 = ((($node2$093)) + 12|0);
       if ($302) {
        $314 = HEAP32[$303>>2]|0;
        $315 = HEAP32[$252>>2]|0;
        $316 = ($315|0)==(0);
        if ($316) {
         $$1$i5$i = $300;$331 = 12;$333 = 13;
        } else {
         $317 = HEAP16[$314>>1]|0;
         $318 = ($317<<16>>16)==(-2);
         $319 = $315 << 1;
         $320 = (($315) + -1)|0;
         $extract5$i20$i = ($317&65535) >>> 8;
         $$0$i$off0$v$i21$i = $318 ? $extract5$i20$i : $317;
         $$0$i$off0$i22$i = $$0$i$off0$v$i21$i&255;
         $321 = $extract5$i20$i&255;
         $$0$i$off8$i24$i = $318 ? -2 : $321;
         $322 = ((($p$091)) + 12|0);
         HEAP8[$300>>0] = $$0$i$off0$i22$i;
         HEAP8[$322>>0] = $$0$i$off8$i24$i;
         $323 = ($320|0)==(0);
         if (!($323)) {
          $$010$i25$i = $300;$$pn$i14 = $314;$327 = $320;
          while(1) {
           $324 = ((($$pn$i14)) + 2|0);
           $325 = ((($$010$i25$i)) + 2|0);
           $$pre$i$i15 = HEAP16[$324>>1]|0;
           $326 = (($327) + -1)|0;
           $extract5$i$i16 = ($$pre$i$i15&65535) >>> 8;
           $$0$i$off0$v$i$i17 = $318 ? $extract5$i$i16 : $$pre$i$i15;
           $$0$i$off0$i$i18 = $$0$i$off0$v$i$i17&255;
           $$0$i$off8$v$i$i19 = $318 ? $$pre$i$i15 : $extract5$i$i16;
           $$0$i$off8$i$i20 = $$0$i$off8$v$i$i19&255;
           $328 = ((($$010$i25$i)) + 3|0);
           HEAP8[$325>>0] = $$0$i$off0$i$i18;
           HEAP8[$328>>0] = $$0$i$off8$i$i20;
           $329 = ($326|0)==(0);
           if ($329) {
            break;
           } else {
            $$010$i25$i = $325;$$pn$i14 = $324;$327 = $326;
           }
          }
         }
         $$sum15$i = (($319) + 11)|0;
         $scevgep$i4$i = (($p$091) + ($$sum15$i)|0);
         $phitmp18$i = (($319) + 12)|0;
         $phitmp19$i = (($319) + 13)|0;
         $$1$i5$i = $scevgep$i4$i;$331 = $phitmp18$i;$333 = $phitmp19$i;
        }
        $330 = (($p$091) + ($331)|0);
        HEAP8[$$1$i5$i>>0] = 0;
        $332 = (($p$091) + ($333)|0);
        HEAP8[$330>>0] = 0;
        $$0$i23 = $332;
        break;
       } else {
        $304 = HEAP32[$252>>2]|0;
        $305 = ($304|0)==(0);
        if ($305) {
         $$02$lcssa$i12$i = $300;$313 = 12;
        } else {
         $306 = HEAP32[$303>>2]|0;
         $$014$i7$i = $306;$$023$i8$i = $300;$$05$i6$i = $304;
         while(1) {
          $307 = (($$05$i6$i) + -1)|0;
          $308 = ((($$014$i7$i)) + 1|0);
          $309 = HEAP8[$$014$i7$i>>0]|0;
          $310 = ((($$023$i8$i)) + 1|0);
          HEAP8[$$023$i8$i>>0] = $309;
          $311 = ($307|0)==(0);
          if ($311) {
           break;
          } else {
           $$014$i7$i = $308;$$023$i8$i = $310;$$05$i6$i = $307;
          }
         }
         $$sum$i12 = (($304) + 11)|0;
         $scevgep$i10$i = (($p$091) + ($$sum$i12)|0);
         $phitmp$i = (($304) + 12)|0;
         $$02$lcssa$i12$i = $scevgep$i10$i;$313 = $phitmp$i;
        }
        $312 = (($p$091) + ($313)|0);
        HEAP8[$$02$lcssa$i12$i>>0] = 0;
        $$0$i23 = $312;
        break;
       }
      }
     } while(0);
     $334 = ((($node2$093)) + 24|0);
     $335 = ((($node2$093)) + 32|0);
     $336 = HEAP32[$335>>2]|0;
     $337 = ($336|0)==(1);
     if (!($337)) {
      $338 = HEAP32[$260>>2]|0;
      $339 = ($338|0)==(0);
      if ($339) {
       $p$1 = $$0$i23;
       break;
      }
      $340 = HEAP32[$334>>2]|0;
      $$014$i$i25 = $340;$$023$i$i26 = $$0$i23;$$05$i$i24 = $338;
      while(1) {
       $341 = (($$05$i$i24) + -1)|0;
       $342 = ((($$014$i$i25)) + 1|0);
       $343 = HEAP8[$$014$i$i25>>0]|0;
       $344 = ((($$023$i$i26)) + 1|0);
       HEAP8[$$023$i$i26>>0] = $343;
       $345 = ($341|0)==(0);
       if ($345) {
        break;
       } else {
        $$014$i$i25 = $342;$$023$i$i26 = $344;$$05$i$i24 = $341;
       }
      }
      $scevgep$i2$i = (($$0$i23) + ($338)|0);
      $p$1 = $scevgep$i2$i;
      break;
     }
     $346 = HEAP32[$334>>2]|0;
     $347 = HEAP32[$260>>2]|0;
     $348 = ($347|0)==(0);
     if ($348) {
      $p$1 = $$0$i23;
      break;
     }
     $349 = HEAP16[$346>>1]|0;
     if ((($349<<16>>16) == -257) | (($349<<16>>16) == -2)) {
      $350 = ((($346)) + 2|0);
      $351 = (($347) + -1)|0;
      $352 = ($351|0)==(0);
      if ($352) {
       $p$1 = $$0$i23;
       break;
      } else {
       $$01$ph8$i$i = $350;$$02$ph7$i$i = $351;
      }
     } else {
      $$01$ph8$i$i = $346;$$02$ph7$i$i = $347;
     }
     $353 = ($349<<16>>16)==(-2);
     $$015$i$i = $$01$ph8$i$i;$$06$i$i = $$0$i23;$$in$i$i = $$02$ph7$i$i;
     while(1) {
      $354 = (($$in$i$i) + -1)|0;
      $355 = ((($$015$i$i)) + 2|0);
      $356 = HEAP16[$$015$i$i>>1]|0;
      if ($353) {
       $357 = $356&65535;
       $358 = $357 << 8;
       $359 = $357 >>> 8;
       $360 = $358 | $359;
       $361 = $360&65535;
       $$0$i3$i$i = $361;
      } else {
       $$0$i3$i$i = $356;
      }
      $$0$i3$off$i$i = (($$0$i3$i$i) + -32)<<16>>16;
      $362 = ($$0$i3$off$i$i&65535)>(223);
      $363 = $$0$i3$i$i&255;
      $$$i$i29 = $362 ? 32 : $363;
      $$0$be$i$i = ((($$06$i$i)) + 1|0);
      HEAP8[$$06$i$i>>0] = $$$i$i29;
      $364 = ($354|0)==(0);
      if ($364) {
       break;
      } else {
       $$015$i$i = $355;$$06$i$i = $$0$be$i$i;$$in$i$i = $354;
      }
     }
     $scevgep$i$i30 = (($$0$i23) + ($$02$ph7$i$i)|0);
     $p$1 = $scevgep$i$i30;
    }
   } while(0);
   $464 = HEAP32[$node2$093>>2]|0;
   $465 = ($464|0)==(0|0);
   if ($465) {
    $p$2 = $p$1;
    break;
   } else {
    $node2$093 = $464;$p$091 = $p$1;
   }
  }
 }
 $466 = ($albumart_mime$1|0)==(0|0);
 if ($466) {
  $p$3 = $p$2;
 } else {
  $467 = HEAP32[$49>>2]|0;
  $468 = ((($2)) + 85732|0);
  $469 = HEAP32[$468>>2]|0;
  $470 = ($467|0)!=(0|0);
  $471 = ($469|0)!=(0);
  $or$cond3$i = $470 & $471;
  if ($or$cond3$i) {
   $472 = ((($p$2)) + 3|0);
   HEAP8[$472>>0] = 67;
   $473 = ((($p$2)) + 2|0);
   HEAP8[$473>>0] = 73;
   $474 = ((($p$2)) + 1|0);
   HEAP8[$474>>0] = 80;
   HEAP8[$p$2>>0] = 65;
   $475 = ((($p$2)) + 4|0);
   $476 = (_strlen(($albumart_mime$1|0))|0);
   $477 = (($469) + 4)|0;
   $478 = (($477) + ($476))|0;
   $479 = $478&255;
   $480 = ((($p$2)) + 7|0);
   HEAP8[$480>>0] = $479;
   $481 = $478 >>> 8;
   $482 = $481&255;
   $483 = ((($p$2)) + 6|0);
   HEAP8[$483>>0] = $482;
   $484 = $478 >>> 16;
   $485 = $484&255;
   $486 = ((($p$2)) + 5|0);
   HEAP8[$486>>0] = $485;
   $487 = $478 >>> 24;
   $488 = $487&255;
   HEAP8[$475>>0] = $488;
   $489 = ((($p$2)) + 8|0);
   $490 = ((($p$2)) + 9|0);
   HEAP8[$489>>0] = 0;
   $491 = ((($p$2)) + 10|0);
   HEAP8[$490>>0] = 0;
   $492 = ((($p$2)) + 11|0);
   HEAP8[$491>>0] = 0;
   $493 = HEAP8[$albumart_mime$1>>0]|0;
   $494 = ($493<<24>>24)==(0);
   if ($494) {
    $$06$lcssa$i = $492;
   } else {
    $$0511$i = $albumart_mime$1;$$0610$i = $492;$497 = $493;
    while(1) {
     $495 = ((($$0511$i)) + 1|0);
     $496 = ((($$0610$i)) + 1|0);
     HEAP8[$$0610$i>>0] = $497;
     $498 = HEAP8[$495>>0]|0;
     $499 = ($498<<24>>24)==(0);
     if ($499) {
      $$06$lcssa$i = $496;
      break;
     } else {
      $$0511$i = $495;$$0610$i = $496;$497 = $498;
     }
    }
   }
   $500 = ((($$06$lcssa$i)) + 1|0);
   HEAP8[$$06$lcssa$i>>0] = 0;
   $501 = ((($$06$lcssa$i)) + 2|0);
   HEAP8[$500>>0] = 0;
   HEAP8[$501>>0] = 0;
   $502 = ((($$06$lcssa$i)) + 3|0);
   $$048$i = $467;$$09$i = $469;$$17$i = $502;
   while(1) {
    $503 = (($$09$i) + -1)|0;
    $504 = ((($$048$i)) + 1|0);
    $505 = HEAP8[$$048$i>>0]|0;
    $506 = ((($$17$i)) + 1|0);
    HEAP8[$$17$i>>0] = $505;
    $507 = ($503|0)==(0);
    if ($507) {
     break;
    } else {
     $$048$i = $504;$$09$i = $503;$$17$i = $506;
    }
   }
   $508 = (($469) + 3)|0;
   $scevgep$i = (($$06$lcssa$i) + ($508)|0);
   $p$3 = $scevgep$i;
  } else {
   $p$3 = $p$2;
  }
 }
 $509 = $p$3;
 $510 = $buffer;
 $511 = (($tag_size$4) + ($510))|0;
 $512 = (($511) - ($509))|0;
 _memset(($p$3|0),0,($512|0))|0;
 $$0 = $tag_size$4;
 STACKTOP = sp;return ($$0|0);
}
function _id3tag_write_v2($gfp) {
 $gfp = $gfp|0;
 var $$0 = 0, $$idx1 = 0, $$idx1$val = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $i$03 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($gfp)) + 288|0);
 $1 = HEAP32[$0>>2]|0;
 $$idx1 = ((($1)) + 85696|0);
 $$idx1$val = HEAP32[$$idx1>>2]|0;
 $2 = $$idx1$val & 5;
 $3 = ($2|0)==(1);
 if (!($3)) {
  $$0 = 0;
  return ($$0|0);
 }
 $4 = (_lame_get_id3v2_tag($gfp,0,0)|0);
 $5 = (_calloc($4,1)|0);
 $6 = ($5|0)==(0|0);
 if ($6) {
  $$0 = -1;
  return ($$0|0);
 }
 $7 = (_lame_get_id3v2_tag($gfp,$5,$4)|0);
 $8 = ($7>>>0)>($4>>>0);
 if ($8) {
  _free($5);
  $$0 = -1;
  return ($$0|0);
 }
 $9 = ($7|0)==(0);
 if (!($9)) {
  $i$03 = 0;
  while(1) {
   $10 = (($5) + ($i$03)|0);
   $11 = HEAP8[$10>>0]|0;
   _add_dummy_byte($1,$11,1);
   $12 = (($i$03) + 1)|0;
   $exitcond = ($12|0)==($7|0);
   if ($exitcond) {
    break;
   } else {
    $i$03 = $12;
   }
  }
 }
 _free($5);
 $$0 = $7;
 return ($$0|0);
}
function _lame_get_id3v1_tag($gfp,$buffer,$size) {
 $gfp = $gfp|0;
 $buffer = $buffer|0;
 $size = $size|0;
 var $$0 = 0, $$0$lcssa$i = 0, $$0$lcssa$i10 = 0, $$0$lcssa$i19 = 0, $$0$lcssa$i28 = 0, $$0$lcssa$i37 = 0, $$0$ph8$i = 0, $$0$ph8$i13 = 0, $$0$ph8$i22 = 0, $$0$ph8$i31 = 0, $$0$ph8$i4 = 0, $$02$ph7$i = 0, $$02$ph7$i14 = 0, $$02$ph7$i23 = 0, $$02$ph7$i32 = 0, $$02$ph7$i5 = 0, $$05$i = 0, $$05$i$lcssa = 0, $$05$i17 = 0, $$05$i17$lcssa = 0;
 var $$05$i212 = 0, $$05$i26 = 0, $$05$i26$lcssa = 0, $$05$i35 = 0, $$05$i35$lcssa = 0, $$05$i8 = 0, $$05$i8$lcssa = 0, $$idx2 = 0, $$idx2$val = 0, $$in$i = 0, $$in$i12 = 0, $$in$i21 = 0, $$in$i3 = 0, $$in$i30 = 0, $$in10$i = 0, $$in10$i16 = 0, $$in10$i25 = 0, $$in10$i34 = 0, $$in10$i7 = 0, $$lcssa = 0;
 var $$lcssa214 = 0, $$lcssa218 = 0, $$lcssa220 = 0, $$lcssa224 = 0, $$lcssa226 = 0, $$lcssa230 = 0, $$lcssa232 = 0, $$lcssa236 = 0, $$lcssa238 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0;
 var $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0;
 var $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0;
 var $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0;
 var $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $9 = 0, $or$cond = 0, $p$0 = 0, $vararg_buffer = 0, $year = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $vararg_buffer = sp;
 $year = sp + 4|0;
 $0 = ($gfp|0)==(0|0);
 if ($0) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $1 = ($size>>>0)<(128);
 if ($1) {
  $$0 = 128;
  STACKTOP = sp;return ($$0|0);
 }
 $2 = ((($gfp)) + 288|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)==(0|0);
 $5 = ($buffer|0)==(0|0);
 $or$cond = $5 | $4;
 if ($or$cond) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $$idx2 = ((($3)) + 85696|0);
 $$idx2$val = HEAP32[$$idx2>>2]|0;
 $6 = $$idx2$val & 9;
 $7 = ($6|0)==(1);
 if (!($7)) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $8 = $$idx2$val << 1;
 $9 = $8 & 32;
 $10 = ((($buffer)) + 1|0);
 HEAP8[$buffer>>0] = 84;
 $11 = ((($buffer)) + 2|0);
 HEAP8[$10>>0] = 65;
 $12 = ((($buffer)) + 3|0);
 HEAP8[$11>>0] = 71;
 $13 = ((($3)) + 85704|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = $9&255;
 $$0$ph8$i31 = $12;$$02$ph7$i32 = $14;$$in$i30 = 30;
 L13: while(1) {
  $16 = ($$02$ph7$i32|0)==(0|0);
  $$05$i35 = $$0$ph8$i31;$$in10$i34 = $$in$i30;
  while(1) {
   $17 = (($$in10$i34) + -1)|0;
   if (!($16)) {
    $18 = HEAP8[$$02$ph7$i32>>0]|0;
    $19 = ($18<<24>>24)==(0);
    if (!($19)) {
     $$05$i35$lcssa = $$05$i35;$$lcssa236 = $17;$$lcssa238 = $18;
     break;
    }
   }
   $23 = ((($$05$i35)) + 1|0);
   HEAP8[$$05$i35>>0] = $15;
   $24 = ($17|0)==(0);
   if ($24) {
    $$0$lcssa$i37 = $23;
    break L13;
   } else {
    $$05$i35 = $23;$$in10$i34 = $17;
   }
  }
  $20 = ((($$02$ph7$i32)) + 1|0);
  $21 = ((($$05$i35$lcssa)) + 1|0);
  HEAP8[$$05$i35$lcssa>>0] = $$lcssa238;
  $22 = ($$lcssa236|0)==(0);
  if ($22) {
   $$0$lcssa$i37 = $21;
   break;
  } else {
   $$0$ph8$i31 = $21;$$02$ph7$i32 = $20;$$in$i30 = $$lcssa236;
  }
 }
 $25 = ((($3)) + 85708|0);
 $26 = HEAP32[$25>>2]|0;
 $$0$ph8$i22 = $$0$lcssa$i37;$$02$ph7$i23 = $26;$$in$i21 = 30;
 L22: while(1) {
  $27 = ($$02$ph7$i23|0)==(0|0);
  $$05$i26 = $$0$ph8$i22;$$in10$i25 = $$in$i21;
  while(1) {
   $28 = (($$in10$i25) + -1)|0;
   if (!($27)) {
    $29 = HEAP8[$$02$ph7$i23>>0]|0;
    $30 = ($29<<24>>24)==(0);
    if (!($30)) {
     $$05$i26$lcssa = $$05$i26;$$lcssa230 = $28;$$lcssa232 = $29;
     break;
    }
   }
   $34 = ((($$05$i26)) + 1|0);
   HEAP8[$$05$i26>>0] = $15;
   $35 = ($28|0)==(0);
   if ($35) {
    $$0$lcssa$i28 = $34;
    break L22;
   } else {
    $$05$i26 = $34;$$in10$i25 = $28;
   }
  }
  $31 = ((($$02$ph7$i23)) + 1|0);
  $32 = ((($$05$i26$lcssa)) + 1|0);
  HEAP8[$$05$i26$lcssa>>0] = $$lcssa232;
  $33 = ($$lcssa230|0)==(0);
  if ($33) {
   $$0$lcssa$i28 = $32;
   break;
  } else {
   $$0$ph8$i22 = $32;$$02$ph7$i23 = $31;$$in$i21 = $$lcssa230;
  }
 }
 $36 = ((($3)) + 85712|0);
 $37 = HEAP32[$36>>2]|0;
 $$0$ph8$i13 = $$0$lcssa$i28;$$02$ph7$i14 = $37;$$in$i12 = 30;
 L31: while(1) {
  $38 = ($$02$ph7$i14|0)==(0|0);
  $$05$i17 = $$0$ph8$i13;$$in10$i16 = $$in$i12;
  while(1) {
   $39 = (($$in10$i16) + -1)|0;
   if (!($38)) {
    $40 = HEAP8[$$02$ph7$i14>>0]|0;
    $41 = ($40<<24>>24)==(0);
    if (!($41)) {
     $$05$i17$lcssa = $$05$i17;$$lcssa224 = $39;$$lcssa226 = $40;
     break;
    }
   }
   $45 = ((($$05$i17)) + 1|0);
   HEAP8[$$05$i17>>0] = $15;
   $46 = ($39|0)==(0);
   if ($46) {
    $$0$lcssa$i19 = $45;
    break L31;
   } else {
    $$05$i17 = $45;$$in10$i16 = $39;
   }
  }
  $42 = ((($$02$ph7$i14)) + 1|0);
  $43 = ((($$05$i17$lcssa)) + 1|0);
  HEAP8[$$05$i17$lcssa>>0] = $$lcssa226;
  $44 = ($$lcssa224|0)==(0);
  if ($44) {
   $$0$lcssa$i19 = $43;
   break;
  } else {
   $$0$ph8$i13 = $43;$$02$ph7$i14 = $42;$$in$i12 = $$lcssa224;
  }
 }
 $47 = ((($3)) + 85700|0);
 $48 = HEAP32[$47>>2]|0;
 HEAP32[$vararg_buffer>>2] = $48;
 (_sprintf($year,6552,$vararg_buffer)|0);
 $49 = HEAP32[$47>>2]|0;
 $50 = ($49|0)!=(0);
 $51 = $50 ? $year : 0;
 $$0$ph8$i4 = $$0$lcssa$i19;$$02$ph7$i5 = $51;$$in$i3 = 4;
 L40: while(1) {
  $52 = ($$02$ph7$i5|0)==(0|0);
  $$05$i8 = $$0$ph8$i4;$$in10$i7 = $$in$i3;
  while(1) {
   $53 = (($$in10$i7) + -1)|0;
   if (!($52)) {
    $54 = HEAP8[$$02$ph7$i5>>0]|0;
    $55 = ($54<<24>>24)==(0);
    if (!($55)) {
     $$05$i8$lcssa = $$05$i8;$$lcssa218 = $53;$$lcssa220 = $54;
     break;
    }
   }
   $59 = ((($$05$i8)) + 1|0);
   HEAP8[$$05$i8>>0] = $15;
   $60 = ($53|0)==(0);
   if ($60) {
    $$0$lcssa$i10 = $59;
    break L40;
   } else {
    $$05$i8 = $59;$$in10$i7 = $53;
   }
  }
  $56 = ((($$02$ph7$i5)) + 1|0);
  $57 = ((($$05$i8$lcssa)) + 1|0);
  HEAP8[$$05$i8$lcssa>>0] = $$lcssa220;
  $58 = ($$lcssa218|0)==(0);
  if ($58) {
   $$0$lcssa$i10 = $57;
   break;
  } else {
   $$0$ph8$i4 = $57;$$02$ph7$i5 = $56;$$in$i3 = $$lcssa218;
  }
 }
 $61 = ((($3)) + 85716|0);
 $62 = HEAP32[$61>>2]|0;
 $63 = ((($3)) + 85720|0);
 $64 = HEAP32[$63>>2]|0;
 $65 = ($64|0)!=(0);
 $66 = $65 ? 28 : 30;
 $$0$ph8$i = $$0$lcssa$i10;$$02$ph7$i = $62;$$in$i = $66;
 L49: while(1) {
  $67 = ($$02$ph7$i|0)==(0|0);
  $$05$i = $$0$ph8$i;$$in10$i = $$in$i;
  while(1) {
   $68 = (($$in10$i) + -1)|0;
   if (!($67)) {
    $69 = HEAP8[$$02$ph7$i>>0]|0;
    $70 = ($69<<24>>24)==(0);
    if (!($70)) {
     $$05$i$lcssa = $$05$i;$$lcssa = $68;$$lcssa214 = $69;
     break;
    }
   }
   $74 = ((($$05$i)) + 1|0);
   HEAP8[$$05$i>>0] = $15;
   $75 = ($68|0)==(0);
   if ($75) {
    $$0$lcssa$i = $74;$$05$i212 = $$05$i;
    break L49;
   } else {
    $$05$i = $74;$$in10$i = $68;
   }
  }
  $71 = ((($$02$ph7$i)) + 1|0);
  $72 = ((($$05$i$lcssa)) + 1|0);
  HEAP8[$$05$i$lcssa>>0] = $$lcssa214;
  $73 = ($$lcssa|0)==(0);
  if ($73) {
   $$0$lcssa$i = $72;$$05$i212 = $$05$i$lcssa;
   break;
  } else {
   $$0$ph8$i = $72;$$02$ph7$i = $71;$$in$i = $$lcssa;
  }
 }
 $76 = HEAP32[$63>>2]|0;
 $77 = ($76|0)==(0);
 if ($77) {
  $p$0 = $$0$lcssa$i;
 } else {
  $78 = ((($$05$i212)) + 2|0);
  HEAP8[$$0$lcssa$i>>0] = 0;
  $79 = HEAP32[$63>>2]|0;
  $80 = $79&255;
  $81 = ((($$05$i212)) + 3|0);
  HEAP8[$78>>0] = $80;
  $p$0 = $81;
 }
 $82 = ((($3)) + 85724|0);
 $83 = HEAP32[$82>>2]|0;
 $84 = $83&255;
 HEAP8[$p$0>>0] = $84;
 $$0 = 128;
 STACKTOP = sp;return ($$0|0);
}
function _id3tag_write_v1($gfp) {
 $gfp = $gfp|0;
 var $$0 = 0, $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $exitcond = 0, $i$01 = 0, $tag = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0;
 $tag = sp;
 $0 = ((($gfp)) + 288|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = (_lame_get_id3v1_tag($gfp,$tag,128)|0);
 $3 = (($2) + -1)|0;
 $4 = ($3>>>0)>(127);
 if ($4) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 } else {
  $i$01 = 0;
 }
 while(1) {
  $5 = (($tag) + ($i$01)|0);
  $6 = HEAP8[$5>>0]|0;
  _add_dummy_byte($1,$6,1);
  $7 = (($i$01) + 1)|0;
  $exitcond = ($7|0)==($2|0);
  if ($exitcond) {
   $$0 = $2;
   break;
  } else {
   $i$01 = $7;
  }
 }
 STACKTOP = sp;return ($$0|0);
}
function _id3v2_add_latin1($gfp,$frame_id,$lang,$desc,$text) {
 $gfp = $gfp|0;
 $frame_id = $frame_id|0;
 $lang = $lang|0;
 $desc = $desc|0;
 $text = $text|0;
 var $$0 = 0, $$0$i = 0, $$0$i2 = 0, $$0$i9 = 0, $$in$i = 0, $$lcssa = 0, $$lcssa84 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0;
 var $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0;
 var $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0;
 var $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0;
 var $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0;
 var $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $i$0$lcssa$ph$i = 0, $i$01$i = 0, $n$0$i = 0, $n$0$i$lcssa = 0, $n$0$i7 = 0, $n$0$i7$lcssa = 0, $node$0 = 0, $node$0$i = 0, $node$0$i14 = 0, $node$0$i14$us = 0, $node$0$us = 0;
 var $node$01$i = 0, $node$01$i11 = 0, $node$01$i11$us = 0, $node$02$i = 0, $node$02$i12 = 0, $node$02$i12$us = 0, $node$1 = 0, $node$2 = 0, $scevgep$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($gfp|0)==(0|0);
 if ($0) {
  $$0 = -255;
  return ($$0|0);
 }
 $1 = ((($gfp)) + 288|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if ($3) {
  $$0 = -255;
  return ($$0|0);
 }
 $4 = ((($2)) + 85744|0);
 $node$01$i = HEAP32[$4>>2]|0;
 $5 = ($node$01$i|0)==(0|0);
 L7: do {
  if ($5) {
   $$0$i = 0;
  } else {
   $node$02$i = $node$01$i;
   while(1) {
    $6 = ((($node$02$i)) + 4|0);
    $7 = HEAP32[$6>>2]|0;
    $8 = ($7|0)==($frame_id|0);
    if ($8) {
     $$0$i = $node$02$i;
     break L7;
    }
    $node$0$i = HEAP32[$node$02$i>>2]|0;
    $9 = ($node$0$i|0)==(0|0);
    if ($9) {
     $$0$i = 0;
     break;
    } else {
     $node$02$i = $node$0$i;
    }
   }
  }
 } while(0);
 L12: do {
  if ((($frame_id|0) == 1347570006) | (($frame_id|0) == 1196575044) | (($frame_id|0) == 1162756946) | (($frame_id|0) == 1279872587) | (($frame_id|0) == 1095061059) | (($frame_id|0) == 1346588244) | (($frame_id|0) == 1195724610) | (($frame_id|0) == 1095780675) | (($frame_id|0) == 1398361172) | (($frame_id|0) == 1129270605) | (($frame_id|0) == 1465407576) | (($frame_id|0) == 1415075928)) {
   $10 = ($$0$i|0)==(0|0);
   if ($10) {
    label = 25;
   } else {
    $11 = ($desc|0)==(0|0);
    if ($11) {
     $node$0$us = $$0$i;
     L16: while(1) {
      $12 = ((($node$0$us)) + 8|0);
      $13 = (_isSameLang($12,$lang)|0);
      $14 = ($13|0)==(0);
      if (!($14)) {
       $15 = ((($node$0$us)) + 16|0);
       $16 = HEAP32[$15>>2]|0;
       $17 = ($16|0)==(0);
       if ($17) {
        $node$2 = $node$0$us;
        break L12;
       }
      }
      $node$01$i11$us = HEAP32[$node$0$us>>2]|0;
      $18 = ($node$01$i11$us|0)==(0|0);
      if ($18) {
       label = 25;
       break L12;
      } else {
       $node$02$i12$us = $node$01$i11$us;
      }
      while(1) {
       $19 = ((($node$02$i12$us)) + 4|0);
       $20 = HEAP32[$19>>2]|0;
       $21 = ($20|0)==($frame_id|0);
       if ($21) {
        $node$0$us = $node$02$i12$us;
        continue L16;
       }
       $node$0$i14$us = HEAP32[$node$02$i12$us>>2]|0;
       $22 = ($node$0$i14$us|0)==(0|0);
       if ($22) {
        label = 25;
        break L12;
       } else {
        $node$02$i12$us = $node$0$i14$us;
       }
      }
     }
    } else {
     $node$0 = $$0$i;
    }
    L24: while(1) {
     $23 = ((($node$0)) + 8|0);
     $24 = (_isSameLang($23,$lang)|0);
     $25 = ($24|0)==(0);
     L26: do {
      if (!($25)) {
       $26 = ((($node$0)) + 20|0);
       $27 = HEAP32[$26>>2]|0;
       $28 = ($27|0)==(1);
       $29 = ((($node$0)) + 16|0);
       $30 = HEAP32[$29>>2]|0;
       $31 = ($30|0)==(0);
       if ($28) {
        if ($31) {
         $node$2 = $node$0;
         break L12;
        } else {
         break;
        }
       }
       if ($31) {
        $node$2 = $node$0;
        break L12;
       }
       $32 = ((($node$0)) + 12|0);
       $33 = HEAP32[$32>>2]|0;
       $i$01$i = 0;
       while(1) {
        $36 = (($33) + ($i$01$i)|0);
        $37 = HEAP8[$36>>0]|0;
        $38 = (($desc) + ($i$01$i)|0);
        $39 = HEAP8[$38>>0]|0;
        $40 = ($37<<24>>24)==($39<<24>>24);
        $34 = (($i$01$i) + 1)|0;
        if (!($40)) {
         break L26;
        }
        $35 = ($34>>>0)<($30>>>0);
        if ($35) {
         $i$01$i = $34;
        } else {
         $node$1 = $node$0;
         label = 24;
         break L12;
        }
       }
      }
     } while(0);
     $41 = ($node$0|0)==(0|0);
     $$in$i = $41 ? $4 : $node$0;
     $node$01$i11 = HEAP32[$$in$i>>2]|0;
     $42 = ($node$01$i11|0)==(0|0);
     if ($42) {
      label = 25;
      break L12;
     } else {
      $node$02$i12 = $node$01$i11;
     }
     while(1) {
      $43 = ((($node$02$i12)) + 4|0);
      $44 = HEAP32[$43>>2]|0;
      $45 = ($44|0)==($frame_id|0);
      if ($45) {
       $node$0 = $node$02$i12;
       continue L24;
      }
      $node$0$i14 = HEAP32[$node$02$i12>>2]|0;
      $46 = ($node$0$i14|0)==(0|0);
      if ($46) {
       label = 25;
       break L12;
      } else {
       $node$02$i12 = $node$0$i14;
      }
     }
    }
   }
  } else {
   $node$1 = $$0$i;
   label = 24;
  }
 } while(0);
 if ((label|0) == 24) {
  $47 = ($node$1|0)==(0|0);
  if ($47) {
   label = 25;
  } else {
   $node$2 = $node$1;
  }
 }
 if ((label|0) == 25) {
  $48 = (_calloc(1,36)|0);
  $49 = ($48|0)==(0|0);
  if ($49) {
   $$0 = -254;
   return ($$0|0);
  }
  $50 = ((($2)) + 85748|0);
  $51 = HEAP32[$50>>2]|0;
  $52 = ($51|0)==(0|0);
  if ($52) {
   label = 28;
  } else {
   $53 = HEAP32[$4>>2]|0;
   $54 = ($53|0)==(0|0);
   if ($54) {
    label = 28;
   } else {
    HEAP32[$51>>2] = $48;
   }
  }
  if ((label|0) == 28) {
   HEAP32[$4>>2] = $48;
  }
  HEAP32[$50>>2] = $48;
  $node$2 = $48;
 }
 $55 = ((($node$2)) + 4|0);
 HEAP32[$55>>2] = $frame_id;
 $56 = ((($node$2)) + 8|0);
 $57 = ($lang|0)==(0|0);
 do {
  if ($57) {
   label = 33;
  } else {
   $58 = HEAP8[$lang>>0]|0;
   $59 = ($58<<24>>24)==(0);
   if ($59) {
    label = 33;
   } else {
    HEAP8[$56>>0] = $58;
    $66 = HEAP8[$lang>>0]|0;
    $67 = ($66<<24>>24)==(0);
    if ($67) {
     $i$0$lcssa$ph$i = 1;
    } else {
     $68 = ((($lang)) + 1|0);
     $69 = HEAP8[$68>>0]|0;
     $70 = ((($node$2)) + 9|0);
     HEAP8[$70>>0] = $69;
     $71 = HEAP8[$lang>>0]|0;
     $72 = ($71<<24>>24)==(0);
     if ($72) {
      $i$0$lcssa$ph$i = 2;
     } else {
      $62 = ((($lang)) + 2|0);
      $63 = HEAP8[$62>>0]|0;
      $64 = ((($node$2)) + 10|0);
      HEAP8[$64>>0] = $63;
      break;
     }
    }
    $scevgep$i = (((($node$2)) + 8|0) + ($i$0$lcssa$ph$i)|0);
    $65 = $i$0$lcssa$ph$i ^ 3;
    _memset(($scevgep$i|0),32,($65|0))|0;
   }
  }
 } while(0);
 if ((label|0) == 33) {
  HEAP8[$56>>0] = 88;
  $60 = ((($node$2)) + 9|0);
  HEAP8[$60>>0] = 88;
  $61 = ((($node$2)) + 10|0);
  HEAP8[$61>>0] = 88;
 }
 $73 = ((($node$2)) + 12|0);
 $74 = HEAP32[$73>>2]|0;
 _free($74);
 HEAP32[$73>>2] = 0;
 $75 = ($desc|0)==(0|0);
 if ($75) {
  $$0$i9 = 0;
 } else {
  $n$0$i7 = 0;
  while(1) {
   $76 = (($desc) + ($n$0$i7)|0);
   $77 = HEAP8[$76>>0]|0;
   $78 = ($77<<24>>24)==(0);
   $79 = (($n$0$i7) + 1)|0;
   if ($78) {
    $$lcssa84 = $79;$n$0$i7$lcssa = $n$0$i7;
    break;
   } else {
    $n$0$i7 = $79;
   }
  }
  $80 = ($n$0$i7$lcssa|0)==(0);
  if ($80) {
   $$0$i9 = 0;
  } else {
   $81 = (_calloc($$lcssa84,1)|0);
   HEAP32[$73>>2] = $81;
   $82 = ($81|0)==(0|0);
   if ($82) {
    $$0$i9 = 0;
   } else {
    _memcpy(($81|0),($desc|0),($n$0$i7$lcssa|0))|0;
    $83 = (($81) + ($n$0$i7$lcssa)|0);
    HEAP8[$83>>0] = 0;
    $$0$i9 = $n$0$i7$lcssa;
   }
  }
 }
 $84 = ((($node$2)) + 16|0);
 HEAP32[$84>>2] = $$0$i9;
 $85 = ((($node$2)) + 20|0);
 HEAP32[$85>>2] = 0;
 $86 = ((($node$2)) + 24|0);
 $87 = HEAP32[$86>>2]|0;
 _free($87);
 HEAP32[$86>>2] = 0;
 $88 = ($text|0)==(0|0);
 if ($88) {
  $$0$i2 = 0;
 } else {
  $n$0$i = 0;
  while(1) {
   $89 = (($text) + ($n$0$i)|0);
   $90 = HEAP8[$89>>0]|0;
   $91 = ($90<<24>>24)==(0);
   $92 = (($n$0$i) + 1)|0;
   if ($91) {
    $$lcssa = $92;$n$0$i$lcssa = $n$0$i;
    break;
   } else {
    $n$0$i = $92;
   }
  }
  $93 = ($n$0$i$lcssa|0)==(0);
  if ($93) {
   $$0$i2 = 0;
  } else {
   $94 = (_calloc($$lcssa,1)|0);
   HEAP32[$86>>2] = $94;
   $95 = ($94|0)==(0|0);
   if ($95) {
    $$0$i2 = 0;
   } else {
    _memcpy(($94|0),($text|0),($n$0$i$lcssa|0))|0;
    $96 = (($94) + ($n$0$i$lcssa)|0);
    HEAP8[$96>>0] = 0;
    $$0$i2 = $n$0$i$lcssa;
   }
  }
 }
 $97 = ((($node$2)) + 28|0);
 HEAP32[$97>>2] = $$0$i2;
 $98 = ((($node$2)) + 32|0);
 HEAP32[$98>>2] = 0;
 $99 = ((($2)) + 85696|0);
 $100 = HEAP32[$99>>2]|0;
 $101 = $100 | 3;
 HEAP32[$99>>2] = $101;
 $$0 = 0;
 return ($$0|0);
}
function _isSameLang($l1,$l2) {
 $l1 = $l1|0;
 $l2 = $l2|0;
 var $$ = 0, $$$1 = 0, $$$2 = 0, $$5 = 0, $$mask = 0, $$mask$1 = 0, $$mask$2 = 0, $$unshifted = 0, $$unshifted$1 = 0, $$unshifted$2 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0;
 var $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0;
 var $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $b$0 = 0, $b$0$1 = 0, $b$0$2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($l2|0)==(0|0);
 if ($0) {
  $11 = 88;$23 = 88;$35 = 88;
 } else {
  $1 = HEAP8[$l2>>0]|0;
  $2 = ($1<<24>>24)==(0);
  if ($2) {
   $11 = 88;$23 = 88;$35 = 88;
  } else {
   $3 = ((($l2)) + 1|0);
   $4 = HEAP8[$3>>0]|0;
   $5 = ((($l2)) + 2|0);
   $6 = HEAP8[$5>>0]|0;
   $11 = $1;$23 = $4;$35 = $6;
  }
 }
 $7 = HEAP8[$l1>>0]|0;
 $8 = $7 << 24 >> 24;
 $9 = (_tolower($8)|0);
 $10 = $11 << 24 >> 24;
 $12 = (_tolower($10)|0);
 $13 = $9&255;
 $14 = ($13<<24>>24)<(32);
 $$ = $14 ? 32 : $9;
 $15 = $12&255;
 $16 = ($15<<24>>24)<(32);
 $b$0 = $16 ? 32 : $12;
 $$unshifted = $b$0 ^ $$;
 $$mask = $$unshifted & 255;
 $17 = ($$mask|0)==(0);
 if (!($17)) {
  return 0;
 }
 $18 = ((($l1)) + 1|0);
 $19 = HEAP8[$18>>0]|0;
 $20 = $19 << 24 >> 24;
 $21 = (_tolower($20)|0);
 $22 = $23 << 24 >> 24;
 $24 = (_tolower($22)|0);
 $25 = $21&255;
 $26 = ($25<<24>>24)<(32);
 $$$1 = $26 ? 32 : $21;
 $27 = $24&255;
 $28 = ($27<<24>>24)<(32);
 $b$0$1 = $28 ? 32 : $24;
 $$unshifted$1 = $b$0$1 ^ $$$1;
 $$mask$1 = $$unshifted$1 & 255;
 $29 = ($$mask$1|0)==(0);
 if ($29) {
  $30 = ((($l1)) + 2|0);
  $31 = HEAP8[$30>>0]|0;
  $32 = $31 << 24 >> 24;
  $33 = (_tolower($32)|0);
  $34 = $35 << 24 >> 24;
  $36 = (_tolower($34)|0);
  $37 = $33&255;
  $38 = ($37<<24>>24)<(32);
  $$$2 = $38 ? 32 : $33;
  $39 = $36&255;
  $40 = ($39<<24>>24)<(32);
  $b$0$2 = $40 ? 32 : $36;
  $$unshifted$2 = $b$0$2 ^ $$$2;
  $$mask$2 = $$unshifted$2 & 255;
  $41 = ($$mask$2|0)==(0);
  $$5 = $41&1;
  return ($$5|0);
 } else {
  return 0;
 }
 return (0)|0;
}
function _is_lame_global_flags_valid($gfp) {
 $gfp = $gfp|0;
 var $$ = 0, $$0 = 0, $0 = 0, $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($gfp|0)==(0|0);
 if ($0) {
  $$0 = 0;
  return ($$0|0);
 }
 $1 = HEAP32[$gfp>>2]|0;
 $2 = ($1|0)==(-487877);
 $$ = $2&1;
 $$0 = $$;
 return ($$0|0);
}
function _lame_init_params($gfp) {
 $gfp = $gfp|0;
 var $$ = 0, $$$i = 0, $$0 = 0, $$0$i13 = 0, $$1$i = 0, $$10 = 0, $$11 = 0, $$12 = 0, $$30 = 0, $$5 = 0, $$6 = 0, $$9 = 0, $$lcssa = 0, $$lcssa113 = 0.0, $$lcssa114 = 0.0, $$phi$trans$insert56 = 0, $$phi$trans$insert64 = 0, $$phi$trans$insert77 = 0, $$pr$i = 0.0, $$pre = 0;
 var $$pre$i = 0.0, $$pre57 = 0, $$pre58 = 0, $$pre59 = 0.0, $$pre60 = 0, $$pre63 = 0, $$pre65 = 0, $$pre67 = 0, $$pre69 = 0, $$pre69$1 = 0, $$pre69$10 = 0, $$pre69$11 = 0, $$pre69$12 = 0, $$pre69$13 = 0, $$pre69$14 = 0, $$pre69$15 = 0, $$pre69$16 = 0, $$pre69$17 = 0, $$pre69$2 = 0, $$pre69$3 = 0;
 var $$pre69$4 = 0, $$pre69$5 = 0, $$pre69$6 = 0, $$pre69$7 = 0, $$pre69$8 = 0, $$pre69$9 = 0, $$pre70 = 0, $$pre70$1 = 0, $$pre70$10 = 0, $$pre70$11 = 0, $$pre70$12 = 0, $$pre70$13 = 0, $$pre70$14 = 0, $$pre70$15 = 0, $$pre70$16 = 0, $$pre70$17 = 0, $$pre70$2 = 0, $$pre70$3 = 0, $$pre70$4 = 0, $$pre70$5 = 0;
 var $$pre70$6 = 0, $$pre70$7 = 0, $$pre70$8 = 0, $$pre70$9 = 0, $$pre72 = 0, $$pre74 = 0, $$pre75 = 0, $$pre78 = 0, $$sink = 0.0, $$sink54 = 0, $$sink55 = 0, $$storemerge = 0, $$storemerge91 = 0, $$suggested_samplefreq$0$i = 0, $$suggested_samplefreq$2$i = 0, $$suggested_samplefreq$4$i = 0, $$suggested_samplefreq$6$i = 0, $0 = 0, $1 = 0, $10 = 0;
 var $100 = 0, $1000 = 0, $1001 = 0, $1002 = 0, $1003 = 0, $1004 = 0, $1005 = 0, $1006 = 0, $1007 = 0, $1008 = 0, $1009 = 0, $101 = 0, $1010 = 0, $1011 = 0, $1012 = 0, $1013 = 0, $1014 = 0, $1015 = 0, $1016 = 0, $1017 = 0;
 var $1018 = 0, $1019 = 0, $102 = 0, $1020 = 0, $1021 = 0, $1022 = 0, $1023 = 0, $1024 = 0, $1025 = 0, $1026 = 0, $1027 = 0, $1028 = 0, $1029 = 0, $103 = 0, $1030 = 0, $1031 = 0, $1032 = 0, $1033 = 0, $1034 = 0, $1035 = 0;
 var $1036 = 0, $1037 = 0, $1038 = 0, $1039 = 0, $104 = 0, $1040 = 0, $1041 = 0, $1042 = 0, $1043 = 0, $1044 = 0, $1045 = 0, $1046 = 0, $1047 = 0, $1048 = 0, $1049 = 0, $105 = 0, $1050 = 0, $1051 = 0, $1052 = 0, $1053 = 0;
 var $1054 = 0, $1055 = 0, $1056 = 0, $1057 = 0, $1058 = 0, $1059 = 0, $106 = 0, $1060 = 0, $1061 = 0.0, $1062 = 0.0, $1063 = 0.0, $1064 = 0.0, $1065 = 0.0, $1066 = 0, $1067 = 0, $1068 = 0, $1069 = 0, $107 = 0, $1070 = 0, $1071 = 0;
 var $1072 = 0, $1073 = 0, $1074 = 0, $1075 = 0, $1076 = 0.0, $1077 = 0, $1078 = 0, $1079 = 0, $108 = 0, $1080 = 0, $1081 = 0, $1082 = 0, $1083 = 0.0, $1084 = 0, $1085 = 0, $1086 = 0, $1087 = 0.0, $1088 = 0, $1089 = 0, $109 = 0;
 var $1090 = 0, $1091 = 0, $1092 = 0, $1093 = 0, $1094 = 0, $1095 = 0, $1096 = 0, $1097 = 0, $1098 = 0, $1099 = 0.0, $11 = 0, $110 = 0, $1100 = 0.0, $1101 = 0, $1102 = 0.0, $1103 = 0.0, $1104 = 0, $1105 = 0, $1106 = 0, $1107 = 0;
 var $1108 = 0, $1109 = 0, $111 = 0, $1110 = 0, $1111 = 0, $1112 = 0, $1113 = 0, $1114 = 0, $1115 = 0, $1116 = 0, $1117 = 0, $1118 = 0, $1119 = 0, $112 = 0, $1120 = 0, $1121 = 0, $1122 = 0, $1123 = 0, $1124 = 0, $1125 = 0;
 var $1126 = 0, $1127 = 0, $1128 = 0, $1129 = 0, $113 = 0, $1130 = 0, $1131 = 0, $1132 = 0.0, $1133 = 0, $1134 = 0, $1135 = 0.0, $1136 = 0.0, $1137 = 0, $1138 = 0, $1139 = 0.0, $114 = 0, $1140 = 0, $1141 = 0, $1142 = 0.0, $1143 = 0.0;
 var $1144 = 0, $1145 = 0, $1146 = 0.0, $1147 = 0, $1148 = 0, $1149 = 0.0, $115 = 0, $1150 = 0.0, $1151 = 0, $1152 = 0, $1153 = 0.0, $1154 = 0, $1155 = 0, $1156 = 0.0, $1157 = 0.0, $1158 = 0.0, $1159 = 0, $116 = 0, $1160 = 0.0, $1161 = 0;
 var $1162 = 0.0, $1163 = 0.0, $1164 = 0, $1165 = 0.0, $1166 = 0.0, $1167 = 0, $1168 = 0, $1169 = 0, $117 = 0, $1170 = 0, $1171 = 0.0, $1172 = 0.0, $1173 = 0, $1174 = 0, $1175 = 0, $1176 = 0, $1177 = 0, $1178 = 0, $1179 = 0, $118 = 0;
 var $1180 = 0, $1181 = 0, $1182 = 0, $1183 = 0, $1184 = 0, $1185 = 0, $1186 = 0, $1187 = 0, $1188 = 0, $1189 = 0, $119 = 0, $1190 = 0, $1191 = 0, $1192 = 0, $1193 = 0, $1194 = 0, $1195 = 0, $1196 = 0, $1197 = 0, $1198 = 0;
 var $1199 = 0, $12 = 0, $120 = 0, $1200 = 0, $1201 = 0, $1202 = 0, $1203 = 0, $1204 = 0, $1205 = 0, $1206 = 0, $1207 = 0, $1208 = 0, $1209 = 0, $121 = 0, $1210 = 0, $122 = 0, $123 = 0, $124 = 0.0, $125 = 0.0, $126 = 0;
 var $127 = 0.0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0.0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0.0, $139 = 0.0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0;
 var $145 = 0, $146 = 0, $147 = 0.0, $148 = 0.0, $149 = 0.0, $15 = 0, $150 = 0.0, $151 = 0.0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0;
 var $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0;
 var $181 = 0, $182 = 0.0, $183 = 0, $184 = 0.0, $185 = 0.0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0.0, $193 = 0, $194 = 0.0, $195 = 0.0, $196 = 0, $197 = 0.0, $198 = 0.0, $199 = 0.0;
 var $2 = 0, $20 = 0, $200 = 0, $201 = 0.0, $202 = 0.0, $203 = 0.0, $204 = 0, $205 = 0, $206 = 0.0, $207 = 0, $208 = 0, $209 = 0.0, $21 = 0, $210 = 0, $211 = 0.0, $212 = 0, $213 = 0.0, $214 = 0, $215 = 0.0, $216 = 0.0;
 var $217 = 0.0, $218 = 0.0, $219 = 0.0, $22 = 0, $220 = 0.0, $221 = 0.0, $222 = 0, $223 = 0.0, $224 = 0.0, $225 = 0.0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0;
 var $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0.0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0.0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0;
 var $253 = 0, $254 = 0.0, $255 = 0, $256 = 0, $257 = 0, $258 = 0.0, $259 = 0, $26 = 0, $260 = 0.0, $261 = 0.0, $262 = 0.0, $263 = 0.0, $264 = 0.0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0.0;
 var $271 = 0, $272 = 0, $273 = 0, $274 = 0.0, $275 = 0, $276 = 0.0, $277 = 0.0, $278 = 0.0, $279 = 0.0, $28 = 0, $280 = 0.0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0.0, $287 = 0, $288 = 0, $289 = 0;
 var $29 = 0, $290 = 0.0, $291 = 0, $292 = 0.0, $293 = 0.0, $294 = 0.0, $295 = 0.0, $296 = 0.0, $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0.0, $301 = 0.0, $302 = 0, $303 = 0.0, $304 = 0, $305 = 0, $306 = 0;
 var $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0, $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0;
 var $325 = 0, $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0, $332 = 0, $333 = 0, $334 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0;
 var $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0, $350 = 0, $351 = 0, $352 = 0, $353 = 0.0, $354 = 0, $355 = 0, $356 = 0.0, $357 = 0.0, $358 = 0.0, $359 = 0.0, $36 = 0, $360 = 0;
 var $361 = 0, $362 = 0, $363 = 0, $364 = 0.0, $365 = 0, $366 = 0, $367 = 0.0, $368 = 0.0, $369 = 0.0, $37 = 0, $370 = 0.0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $379 = 0;
 var $38 = 0, $380 = 0, $381 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0, $386 = 0, $387 = 0, $388 = 0, $389 = 0, $39 = 0, $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $396 = 0, $397 = 0;
 var $398 = 0, $399 = 0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0, $404 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0, $409 = 0, $41 = 0, $410 = 0, $411 = 0, $412 = 0, $413 = 0, $414 = 0;
 var $415 = 0, $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $421 = 0, $422 = 0, $423 = 0, $424 = 0, $425 = 0, $426 = 0, $427 = 0, $428 = 0.0, $429 = 0, $43 = 0, $430 = 0, $431 = 0.0, $432 = 0.0;
 var $433 = 0.0, $434 = 0.0, $435 = 0, $436 = 0, $437 = 0, $438 = 0, $439 = 0.0, $44 = 0, $440 = 0, $441 = 0, $442 = 0.0, $443 = 0.0, $444 = 0.0, $445 = 0.0, $446 = 0, $447 = 0, $448 = 0, $449 = 0, $45 = 0, $450 = 0;
 var $451 = 0, $452 = 0.0, $453 = 0.0, $454 = 0.0, $455 = 0, $456 = 0, $457 = 0, $458 = 0, $459 = 0, $46 = 0, $460 = 0.0, $461 = 0.0, $462 = 0.0, $463 = 0, $464 = 0.0, $465 = 0.0, $466 = 0.0, $467 = 0, $468 = 0, $469 = 0;
 var $47 = 0, $470 = 0, $471 = 0, $472 = 0, $473 = 0, $474 = 0.0, $475 = 0.0, $476 = 0.0, $477 = 0, $478 = 0, $479 = 0, $48 = 0, $480 = 0, $481 = 0.0, $482 = 0.0, $483 = 0.0, $484 = 0, $485 = 0.0, $486 = 0.0, $487 = 0.0;
 var $488 = 0.0, $489 = 0, $49 = 0, $490 = 0.0, $491 = 0.0, $492 = 0.0, $493 = 0, $494 = 0, $495 = 0, $496 = 0, $497 = 0, $498 = 0, $499 = 0, $5 = 0, $50 = 0, $500 = 0, $501 = 0, $502 = 0.0, $503 = 0.0, $504 = 0.0;
 var $505 = 0, $506 = 0, $507 = 0.0, $508 = 0.0, $509 = 0, $51 = 0, $510 = 0, $511 = 0, $512 = 0.0, $513 = 0.0, $514 = 0.0, $515 = 0.0, $516 = 0.0, $517 = 0, $518 = 0, $519 = 0, $52 = 0, $520 = 0, $521 = 0, $522 = 0;
 var $523 = 0, $524 = 0, $525 = 0.0, $526 = 0.0, $527 = 0.0, $528 = 0, $529 = 0.0, $53 = 0, $530 = 0.0, $531 = 0.0, $532 = 0.0, $533 = 0.0, $534 = 0.0, $535 = 0.0, $536 = 0.0, $537 = 0.0, $538 = 0.0, $539 = 0, $54 = 0, $540 = 0.0;
 var $541 = 0.0, $542 = 0.0, $543 = 0.0, $544 = 0.0, $545 = 0.0, $546 = 0.0, $547 = 0.0, $548 = 0.0, $549 = 0, $55 = 0, $550 = 0, $551 = 0.0, $552 = 0.0, $553 = 0.0, $554 = 0.0, $555 = 0.0, $556 = 0, $557 = 0.0, $558 = 0.0, $559 = 0.0;
 var $56 = 0, $560 = 0.0, $561 = 0.0, $562 = 0.0, $563 = 0.0, $564 = 0.0, $565 = 0, $566 = 0, $567 = 0.0, $568 = 0.0, $569 = 0.0, $57 = 0, $570 = 0.0, $571 = 0, $572 = 0, $573 = 0, $574 = 0, $575 = 0, $576 = 0, $577 = 0;
 var $578 = 0, $579 = 0, $58 = 0, $580 = 0, $581 = 0, $582 = 0, $583 = 0, $584 = 0, $585 = 0, $586 = 0, $587 = 0, $588 = 0, $589 = 0, $59 = 0, $590 = 0, $591 = 0, $592 = 0, $593 = 0, $594 = 0, $595 = 0;
 var $596 = 0, $597 = 0, $598 = 0, $599 = 0, $6 = 0, $60 = 0, $600 = 0, $601 = 0, $602 = 0, $603 = 0, $604 = 0, $605 = 0, $606 = 0, $607 = 0, $608 = 0, $609 = 0, $61 = 0, $610 = 0, $611 = 0, $612 = 0;
 var $613 = 0, $614 = 0, $615 = 0, $616 = 0, $617 = 0, $618 = 0, $619 = 0, $62 = 0, $620 = 0, $621 = 0, $622 = 0, $623 = 0, $624 = 0, $625 = 0, $626 = 0, $627 = 0, $628 = 0, $629 = 0, $63 = 0, $630 = 0;
 var $631 = 0, $632 = 0, $633 = 0, $634 = 0, $635 = 0, $636 = 0, $637 = 0, $638 = 0, $639 = 0, $64 = 0, $640 = 0, $641 = 0, $642 = 0, $643 = 0, $644 = 0, $645 = 0, $646 = 0, $647 = 0, $648 = 0, $649 = 0;
 var $65 = 0, $650 = 0, $651 = 0, $652 = 0, $653 = 0, $654 = 0, $655 = 0, $656 = 0, $657 = 0, $658 = 0, $659 = 0, $66 = 0, $660 = 0, $661 = 0, $662 = 0, $663 = 0, $664 = 0, $665 = 0, $666 = 0, $667 = 0;
 var $668 = 0, $669 = 0, $67 = 0, $670 = 0, $671 = 0, $672 = 0, $673 = 0, $674 = 0, $675 = 0, $676 = 0, $677 = 0, $678 = 0, $679 = 0, $68 = 0, $680 = 0, $681 = 0, $682 = 0, $683 = 0, $684 = 0, $685 = 0;
 var $686 = 0, $687 = 0, $688 = 0, $689 = 0, $69 = 0, $690 = 0, $691 = 0, $692 = 0, $693 = 0, $694 = 0, $695 = 0, $696 = 0, $697 = 0, $698 = 0, $699 = 0, $7 = 0, $70 = 0, $700 = 0, $701 = 0, $702 = 0;
 var $703 = 0, $704 = 0, $705 = 0, $706 = 0, $707 = 0, $708 = 0, $709 = 0, $71 = 0, $710 = 0, $711 = 0, $712 = 0, $713 = 0, $714 = 0, $715 = 0, $716 = 0, $717 = 0, $718 = 0, $719 = 0, $72 = 0, $720 = 0;
 var $721 = 0, $722 = 0, $723 = 0, $724 = 0, $725 = 0, $726 = 0, $727 = 0, $728 = 0, $729 = 0, $73 = 0, $730 = 0, $731 = 0, $732 = 0, $733 = 0, $734 = 0, $735 = 0, $736 = 0, $737 = 0, $738 = 0, $739 = 0;
 var $74 = 0, $740 = 0, $741 = 0, $742 = 0, $743 = 0, $744 = 0, $745 = 0, $746 = 0, $747 = 0, $748 = 0, $749 = 0, $75 = 0, $750 = 0, $751 = 0, $752 = 0, $753 = 0, $754 = 0, $755 = 0, $756 = 0, $757 = 0;
 var $758 = 0, $759 = 0, $76 = 0, $760 = 0, $761 = 0, $762 = 0.0, $763 = 0, $764 = 0, $765 = 0, $766 = 0.0, $767 = 0, $768 = 0, $769 = 0, $77 = 0, $770 = 0.0, $771 = 0, $772 = 0, $773 = 0, $774 = 0.0, $775 = 0;
 var $776 = 0, $777 = 0, $778 = 0.0, $779 = 0, $78 = 0, $780 = 0, $781 = 0, $782 = 0.0, $783 = 0, $784 = 0, $785 = 0, $786 = 0.0, $787 = 0, $788 = 0, $789 = 0, $79 = 0, $790 = 0.0, $791 = 0, $792 = 0, $793 = 0;
 var $794 = 0.0, $795 = 0, $796 = 0, $797 = 0, $798 = 0.0, $799 = 0, $8 = 0, $80 = 0, $800 = 0, $801 = 0, $802 = 0.0, $803 = 0, $804 = 0, $805 = 0, $806 = 0.0, $807 = 0, $808 = 0, $809 = 0, $81 = 0, $810 = 0.0;
 var $811 = 0, $812 = 0, $813 = 0, $814 = 0.0, $815 = 0, $816 = 0, $817 = 0, $818 = 0.0, $819 = 0, $82 = 0, $820 = 0, $821 = 0, $822 = 0.0, $823 = 0, $824 = 0, $825 = 0, $826 = 0.0, $827 = 0, $828 = 0, $829 = 0;
 var $83 = 0, $830 = 0.0, $831 = 0, $832 = 0, $833 = 0, $834 = 0.0, $835 = 0, $836 = 0, $837 = 0, $838 = 0, $839 = 0, $84 = 0, $840 = 0, $841 = 0, $842 = 0, $843 = 0, $844 = 0, $845 = 0, $846 = 0, $847 = 0;
 var $848 = 0, $849 = 0, $85 = 0, $850 = 0, $851 = 0, $852 = 0, $853 = 0, $854 = 0, $855 = 0, $856 = 0, $857 = 0, $858 = 0, $859 = 0, $86 = 0, $860 = 0, $861 = 0, $862 = 0, $863 = 0, $864 = 0, $865 = 0;
 var $866 = 0, $867 = 0, $868 = 0, $869 = 0, $87 = 0, $870 = 0, $871 = 0, $872 = 0, $873 = 0, $874 = 0, $875 = 0, $876 = 0, $877 = 0, $878 = 0, $879 = 0, $88 = 0, $880 = 0, $881 = 0, $882 = 0, $883 = 0;
 var $884 = 0, $885 = 0, $886 = 0, $887 = 0, $888 = 0, $889 = 0, $89 = 0, $890 = 0, $891 = 0, $892 = 0, $893 = 0, $894 = 0, $895 = 0, $896 = 0, $897 = 0, $898 = 0.0, $899 = 0.0, $9 = 0, $90 = 0, $900 = 0;
 var $901 = 0.0, $902 = 0.0, $903 = 0.0, $904 = 0, $905 = 0, $906 = 0, $907 = 0, $908 = 0, $909 = 0, $91 = 0, $910 = 0, $911 = 0, $912 = 0, $913 = 0, $914 = 0, $915 = 0, $916 = 0, $917 = 0, $918 = 0, $919 = 0;
 var $92 = 0, $920 = 0, $921 = 0, $922 = 0, $923 = 0, $924 = 0, $925 = 0, $926 = 0, $927 = 0, $928 = 0, $929 = 0, $93 = 0, $930 = 0, $931 = 0, $932 = 0, $933 = 0, $934 = 0, $935 = 0, $936 = 0, $937 = 0;
 var $938 = 0, $939 = 0, $94 = 0, $940 = 0, $941 = 0, $942 = 0, $943 = 0, $944 = 0, $945 = 0, $946 = 0, $947 = 0, $948 = 0, $949 = 0, $95 = 0, $950 = 0, $951 = 0, $952 = 0, $953 = 0, $954 = 0, $955 = 0;
 var $956 = 0, $957 = 0, $958 = 0, $959 = 0, $96 = 0, $960 = 0, $961 = 0, $962 = 0, $963 = 0, $964 = 0, $965 = 0, $966 = 0, $967 = 0, $968 = 0, $969 = 0, $97 = 0, $970 = 0, $971 = 0, $972 = 0, $973 = 0;
 var $974 = 0, $975 = 0, $976 = 0, $977 = 0, $978 = 0, $979 = 0, $98 = 0, $980 = 0, $981 = 0, $982 = 0, $983 = 0, $984 = 0, $985 = 0, $986 = 0, $987 = 0, $988 = 0, $989 = 0, $99 = 0, $990 = 0, $991 = 0;
 var $992 = 0, $993 = 0, $994 = 0, $995 = 0, $996 = 0, $997 = 0, $998 = 0, $999 = 0, $band$011$i = 0, $band$18$i = 0, $band$27$i = 0, $exitcond$i = 0, $exitcond14$i = 0, $exitcond15$i = 0, $fabsf = 0.0, $fc1$0$i = 0.0, $fc2$0$i = 0.0, $highpass_band$010$i = 0, $highpass_band$1$i = 0, $highpass_band$1$i$lcssa = 0;
 var $i$040 = 0, $i$040$lcssa = 0, $lowpass_band$0$minband$0$i = 0, $lowpass_band$013$i = 0, $lowpass_band$1$i = 0, $lowpass_band$1$i$lcssa = 0, $m10$sroa$0$0 = 0.0, $m10$sroa$22$0 = 0.0, $m10$sroa$8$0 = 0.0, $maxband$09$i = 0, $maxband$1$i = 0, $maxband$1$i$lcssa = 0, $minband$012$i = 0, $minband$1$i = 0, $minband$1$i$lcssa = 0, $or$cond = 0, $or$cond$i = 0, $or$cond17$i = 0, $or$cond4$i = 0, $storemerge$i = 0.0;
 var $storemerge$in$i = 0.0, $storemerge$in$in$i = 0.0, $storemerge$in$in$in$i = 0.0, $storemerge1 = 0.0, $storemerge2 = 0.0, $storemerge3 = 0.0, $storemerge4 = 0.0, $suggested_samplefreq$0$i = 0, $suggested_samplefreq$2$i = 0, $suggested_samplefreq$4$i = 0, $suggested_samplefreq$6$i = 0, $suggested_samplefreq$8$i = 0, $switch = 0, $vararg_buffer = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $vararg_buffer = sp;
 $0 = ((($gfp)) + 288|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 16|0);
 HEAP32[$1>>2] = 0;
 $3 = ((($gfp)) + 180|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ((($1)) + 124|0);
 HEAP32[$5>>2] = $4;
 $6 = ((($gfp)) + 32|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($1)) + 140|0);
 HEAP32[$8>>2] = $7;
 $9 = ($7|0)==(0);
 if (!($9)) {
  $10 = ((($gfp)) + 36|0);
  HEAP32[$10>>2] = 0;
 }
 $11 = ((($1)) + 85804|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = ($12|0)==(0|0);
 if (!($13)) {
  $14 = ((($gfp)) + 36|0);
  HEAP32[$14>>2] = 0;
 }
 $15 = ((($gfp)) + 272|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ((($1)) + 85828|0);
 HEAP32[$17>>2] = $16;
 $18 = ((($gfp)) + 276|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = ((($1)) + 85832|0);
 HEAP32[$20>>2] = $19;
 $21 = ((($gfp)) + 280|0);
 $22 = HEAP32[$21>>2]|0;
 $23 = ((($1)) + 85836|0);
 HEAP32[$23>>2] = $22;
 $24 = ((($gfp)) + 296|0);
 $25 = HEAP32[$24>>2]|0;
 $26 = ($25|0)==(0);
 if ($26) {
  $34 = ((($1)) + 85756|0);
  $35 = HEAP32[$34>>2]|0;
  $36 = $35 & -3;
  HEAP32[$34>>2] = $36;
  $48 = $36;
 } else {
  $27 = (_has_3DNow()|0);
  $28 = ((($1)) + 85756|0);
  $29 = HEAP32[$28>>2]|0;
  $30 = $27 << 1;
  $31 = $30 & 2;
  $32 = $29 & -3;
  $33 = $32 | $31;
  HEAP32[$28>>2] = $33;
  $48 = $33;
 }
 $37 = ((($gfp)) + 292|0);
 $38 = HEAP32[$37>>2]|0;
 $39 = ($38|0)==(0);
 if ($39) {
  $46 = ((($1)) + 85756|0);
  $47 = $48 & -2;
  HEAP32[$46>>2] = $47;
  $67 = $47;
 } else {
  $40 = (_has_MMX()|0);
  $41 = ((($1)) + 85756|0);
  $42 = HEAP32[$41>>2]|0;
  $43 = $40 & 1;
  $44 = $42 & -2;
  $45 = $44 | $43;
  HEAP32[$41>>2] = $45;
  $67 = $45;
 }
 $49 = ((($gfp)) + 300|0);
 $50 = HEAP32[$49>>2]|0;
 $51 = ($50|0)==(0);
 if ($51) {
  $65 = ((($1)) + 85756|0);
  $66 = $67 & -13;
  HEAP32[$65>>2] = $66;
 } else {
  $52 = (_has_SSE()|0);
  $53 = ((($1)) + 85756|0);
  $54 = HEAP32[$53>>2]|0;
  $55 = $52 << 2;
  $56 = $55 & 4;
  $57 = $54 & -5;
  $58 = $57 | $56;
  HEAP32[$53>>2] = $58;
  $59 = (_has_SSE2()|0);
  $60 = HEAP32[$53>>2]|0;
  $61 = $59 << 3;
  $62 = $61 & 8;
  $63 = $60 & -9;
  $64 = $63 | $62;
  HEAP32[$53>>2] = $64;
 }
 $68 = ((($1)) + 85796|0);
 $69 = HEAP32[$68>>2]|0;
 $70 = ($69|0)==(0|0);
 if ($70) {
  $71 = (_calloc(1,2772)|0);
  HEAP32[$68>>2] = $71;
  $72 = ($71|0)==(0|0);
  if ($72) {
   $$0 = -2;
   STACKTOP = sp;return ($$0|0);
  }
 }
 $73 = ((($1)) + 85676|0);
 $74 = HEAP32[$73>>2]|0;
 $75 = ($74|0)==(0|0);
 if ($75) {
  $76 = (_calloc(1,134792)|0);
  HEAP32[$73>>2] = $76;
  $77 = ($76|0)==(0|0);
  if ($77) {
   _freegfc($1);
   HEAP32[$0>>2] = 0;
   $$0 = -2;
   STACKTOP = sp;return ($$0|0);
  }
 }
 $78 = ((($gfp)) + 120|0);
 $79 = HEAP32[$78>>2]|0;
 $80 = ((($1)) + 160|0);
 HEAP32[$80>>2] = $79;
 $81 = ((($gfp)) + 104|0);
 $82 = HEAP32[$81>>2]|0;
 $83 = ((($1)) + 164|0);
 HEAP32[$83>>2] = $82;
 $84 = ((($gfp)) + 108|0);
 $85 = HEAP32[$84>>2]|0;
 $86 = ((($1)) + 168|0);
 HEAP32[$86>>2] = $85;
 $87 = ((($gfp)) + 112|0);
 $88 = HEAP32[$87>>2]|0;
 $89 = ((($1)) + 172|0);
 HEAP32[$89>>2] = $88;
 $90 = ((($gfp)) + 116|0);
 $91 = HEAP32[$90>>2]|0;
 $92 = ((($1)) + 176|0);
 HEAP32[$92>>2] = $91;
 $93 = ((($gfp)) + 8|0);
 $94 = HEAP32[$93>>2]|0;
 $95 = ((($1)) + 68|0);
 HEAP32[$95>>2] = $94;
 $96 = ($94|0)==(1);
 $97 = ((($gfp)) + 48|0);
 if ($96) {
  HEAP32[$97>>2] = 3;
  $98 = ((($1)) + 72|0);
  HEAP32[$98>>2] = 1;
  $1205 = $98;$1206 = 1;
  label = 23;
 } else {
  $$pre = HEAP32[$97>>2]|0;
  $99 = ($$pre|0)==(3);
  $100 = $99 ? 1 : 2;
  $101 = ((($1)) + 72|0);
  HEAP32[$101>>2] = $100;
  if ($99) {
   $1205 = $101;$1206 = $100;
   label = 23;
  } else {
   $$phi$trans$insert56 = ((($gfp)) + 52|0);
   $$pre57 = HEAP32[$$phi$trans$insert56>>2]|0;
   $104 = $$pre57;$1207 = $100;$142 = $101;
  }
 }
 if ((label|0) == 23) {
  $102 = ((($gfp)) + 52|0);
  HEAP32[$102>>2] = 0;
  $104 = 0;$1207 = $1206;$142 = $1205;
 }
 $103 = ((($1)) + 80|0);
 HEAP32[$103>>2] = $104;
 $105 = ((($gfp)) + 156|0);
 $106 = HEAP32[$105>>2]|0;
 if ((($106|0) == 4) | (($106|0) == 1)) {
  label = 29;
 } else if ((($106|0) == 0)) {
  $107 = ((($gfp)) + 168|0);
  $108 = HEAP32[$107>>2]|0;
  $109 = ($108|0)==(128);
  if (!($109)) {
   $110 = ((($gfp)) + 96|0);
   $111 = HEAP32[$110>>2]|0;
   $112 = ($111|0)==(0);
   if ($112) {
    HEAP32[$110>>2] = $108;
   }
  }
  $117 = ((($gfp)) + 56|0);
  $118 = HEAP32[$117>>2]|0;
  $119 = ((($1)) + 152|0);
  HEAP32[$119>>2] = $118;
  $120 = ((($gfp)) + 96|0);
  $121 = HEAP32[$120>>2]|0;
  $122 = ($121|0)==(0);
  do {
   if ($122) {
    $123 = ((($gfp)) + 100|0);
    $124 = +HEAPF32[$123>>2];
    $fabsf = (+Math_abs((+$124)));
    $125 = $fabsf;
    $126 = ($124 != $124) | (0.0 != 0.0) |($124 == 0.0);
    if ($126) {
     $129 = $124 == 0.0;
     if (!($129)) {
      break;
     }
    } else {
     $127 = $125 * 9.9999999747524271E-7;
     $128 = !($125 <= $127);
     if ($128) {
      break;
     }
    }
    HEAPF32[$123>>2] = 11.024999618530273;
   }
  } while(0);
  $130 = ((($gfp)) + 100|0);
  $131 = +HEAPF32[$130>>2];
  $132 = $131 > 0.0;
  if ($132) {
   $133 = ((($gfp)) + 16|0);
   $134 = HEAP32[$133>>2]|0;
   $135 = ($134|0)==(0);
   if ($135) {
    $136 = ((($gfp)) + 12|0);
    $137 = HEAP32[$136>>2]|0;
    $138 = (+($137|0));
    $139 = $138 * 0.96999999999999997;
    $140 = (~~(($139)));
    $141 = (_map2MP3Frequency($140)|0);
    HEAP32[$133>>2] = $141;
    $$pre58 = HEAP32[$142>>2]|0;
    $$pre59 = +HEAPF32[$130>>2];
    $144 = $141;$146 = $$pre58;$149 = $$pre59;
   } else {
    $144 = $134;$146 = $1207;$149 = $131;
   }
   $143 = $144 << 4;
   $145 = Math_imul($143, $146)|0;
   $147 = (+($145|0));
   $148 = $149;
   $150 = $148 * 1000.0;
   $151 = $147 / $150;
   $152 = (~~(($151)));
   HEAP32[$120>>2] = $152;
   $153 = (_SmpFrqIndex($144,$2)|0);
   $154 = ((($1)) + 20|0);
   HEAP32[$154>>2] = $153;
   $155 = HEAP32[$119>>2]|0;
   $156 = ($155|0)==(0);
   if ($156) {
    $157 = HEAP32[$120>>2]|0;
    $158 = HEAP32[$2>>2]|0;
    $159 = HEAP32[$133>>2]|0;
    $160 = (_FindNearestBitrate($157,$158,$159)|0);
    HEAP32[$120>>2] = $160;
    $580 = $119;
   } else {
    $580 = $119;
   }
  } else {
   $580 = $119;
  }
 } else {
  $113 = ((($gfp)) + 56|0);
  HEAP32[$113>>2] = 0;
  label = 29;
 }
 if ((label|0) == 29) {
  $114 = ((($gfp)) + 56|0);
  $115 = HEAP32[$114>>2]|0;
  $116 = ((($1)) + 152|0);
  HEAP32[$116>>2] = $115;
  $580 = $116;
 }
 $161 = ((($gfp)) + 16|0);
 $162 = HEAP32[$161>>2]|0;
 $163 = ($162|0)==(0);
 L57: do {
  if ($163) {
   $179 = HEAP32[$105>>2]|0;
   if ((($179|0) == 4) | (($179|0) == 1)) {
    $180 = ((($gfp)) + 164|0);
    $181 = HEAP32[$180>>2]|0;
    $182 = (+($181|0));
    $183 = ((($gfp)) + 160|0);
    $184 = +HEAPF32[$183>>2];
    $185 = $182 + $184;
    $186 = ((($gfp)) + 12|0);
    $187 = HEAP32[$186>>2]|0;
    $i$040 = 2;
    while(1) {
     $188 = (6560 + (($i$040*24)|0)|0);
     $189 = HEAP32[$188>>2]|0;
     $190 = ($187|0)==($189|0);
     if ($190) {
      $191 = (((6560 + (($i$040*24)|0)|0)) + 4|0);
      $192 = +HEAPF32[$191>>2];
      $193 = $185 < $192;
      if ($193) {
       $194 = $185 / $192;
       $195 = $194;
       $196 = (((6560 + (($i$040*24)|0)|0)) + 12|0);
       $197 = +HEAPF32[$196>>2];
       $198 = $197;
       $199 = $198 * $195;
       $200 = (~~(($199)));
       HEAP32[$180>>2] = $200;
       $201 = (+($200|0));
       $202 = $199 - $201;
       $203 = $202;
       HEAPF32[$183>>2] = $203;
      }
     }
     $204 = ($187|0)<($189|0);
     if (!($204)) {
      $205 = (((6560 + (($i$040*24)|0)|0)) + 4|0);
      $206 = +HEAPF32[$205>>2];
      $207 = !($206 <= $185);
      if (!($207)) {
       $208 = (((6560 + (($i$040*24)|0)|0)) + 8|0);
       $209 = +HEAPF32[$208>>2];
       $210 = $185 < $209;
       if ($210) {
        $$lcssa = $189;$$lcssa113 = $206;$$lcssa114 = $209;$i$040$lcssa = $i$040;
        break;
       }
      }
     }
     $229 = (($i$040) + 1)|0;
     $230 = ($229|0)<(9);
     if ($230) {
      $i$040 = $229;
     } else {
      $1208 = $162;
      break L57;
     }
    }
    $211 = $$lcssa114 - $$lcssa113;
    $212 = (((6560 + (($i$040$lcssa*24)|0)|0)) + 16|0);
    $213 = +HEAPF32[$212>>2];
    $214 = (((6560 + (($i$040$lcssa*24)|0)|0)) + 12|0);
    $215 = +HEAPF32[$214>>2];
    $216 = $213 - $215;
    $217 = $185 - $$lcssa113;
    $218 = $216 * $217;
    $219 = $218 / $211;
    $220 = $219 + $215;
    $221 = $220;
    $222 = (~~(($220)));
    HEAP32[$180>>2] = $222;
    $223 = (+($222|0));
    $224 = $221 - $223;
    $225 = $224;
    HEAPF32[$183>>2] = $225;
    HEAP32[$161>>2] = $$lcssa;
    $226 = ((($gfp)) + 184|0);
    $227 = HEAP32[$226>>2]|0;
    $228 = ($227|0)==(0);
    if ($228) {
     HEAP32[$226>>2] = -1;
     $1208 = $$lcssa;
    } else {
     $1208 = $$lcssa;
    }
   } else {
    $1208 = 0;
   }
  } else {
   $164 = ($162|0)<(16000);
   if ($164) {
    $165 = ((($gfp)) + 168|0);
    $166 = HEAP32[$165>>2]|0;
    $167 = ($166|0)>(8);
    $$ = $167 ? $166 : 8;
    $168 = ($$|0)<(64);
    $169 = $168 ? $$ : 64;
    HEAP32[$165>>2] = $169;
    $1208 = $162;
    break;
   }
   $170 = ($162|0)<(32000);
   $171 = ((($gfp)) + 168|0);
   $172 = HEAP32[$171>>2]|0;
   if ($170) {
    $173 = ($172|0)>(8);
    $$5 = $173 ? $172 : 8;
    $174 = ($$5|0)<(160);
    $175 = $174 ? $$5 : 160;
    HEAP32[$171>>2] = $175;
    $1208 = $162;
    break;
   } else {
    $176 = ($172|0)>(32);
    $$6 = $176 ? $172 : 32;
    $177 = ($$6|0)<(320);
    $178 = $177 ? $$6 : 320;
    HEAP32[$171>>2] = $178;
    $1208 = $162;
    break;
   }
  }
 } while(0);
 $231 = ((($gfp)) + 184|0);
 $232 = HEAP32[$231>>2]|0;
 $233 = ($232|0)==(0);
 if ($233) {
  $234 = HEAP32[$105>>2]|0;
  switch ($234|0) {
  case 0:  {
   $235 = ((($gfp)) + 96|0);
   $236 = HEAP32[$235>>2]|0;
   $237 = $236&65535;
   $238 = (_nearestBitrateFullIndex($237)|0);
   $239 = (((6776 + ($238<<3)|0)) + 4|0);
   $240 = HEAP32[$239>>2]|0;
   $241 = (+($240|0));
   $301 = $241;
   break;
  }
  case 3:  {
   $242 = ((($gfp)) + 168|0);
   $243 = HEAP32[$242>>2]|0;
   $244 = $243&65535;
   $245 = (_nearestBitrateFullIndex($244)|0);
   $246 = (((6776 + ($245<<3)|0)) + 4|0);
   $247 = HEAP32[$246>>2]|0;
   $248 = (+($247|0));
   $301 = $248;
   break;
  }
  case 2:  {
   $249 = ((($gfp)) + 164|0);
   $250 = HEAP32[$249>>2]|0;
   $251 = ($250>>>0)<(10);
   if ($251) {
    $252 = (6912 + ($250<<2)|0);
    $253 = HEAP32[$252>>2]|0;
    $254 = (+($253|0));
    $255 = (($250) + 1)|0;
    $256 = (6912 + ($255<<2)|0);
    $257 = HEAP32[$256>>2]|0;
    $258 = (+($257|0));
    $259 = ((($gfp)) + 160|0);
    $260 = +HEAPF32[$259>>2];
    $261 = $260;
    $262 = $258 - $254;
    $263 = $262 * $261;
    $264 = $263 + $254;
    $301 = $264;
   } else {
    $301 = 19500.0;
   }
   break;
  }
  case 1: case 4:  {
   $265 = ((($gfp)) + 164|0);
   $266 = HEAP32[$265>>2]|0;
   $267 = ($266>>>0)<(10);
   if ($267) {
    $268 = (6960 + ($266<<2)|0);
    $269 = HEAP32[$268>>2]|0;
    $270 = (+($269|0));
    $271 = (($266) + 1)|0;
    $272 = (6960 + ($271<<2)|0);
    $273 = HEAP32[$272>>2]|0;
    $274 = (+($273|0));
    $275 = ((($gfp)) + 160|0);
    $276 = +HEAPF32[$275>>2];
    $277 = $276;
    $278 = $274 - $270;
    $279 = $278 * $277;
    $280 = $279 + $270;
    $301 = $280;
   } else {
    $301 = 21500.0;
   }
   break;
  }
  default: {
   $281 = ((($gfp)) + 164|0);
   $282 = HEAP32[$281>>2]|0;
   $283 = ($282>>>0)<(10);
   if ($283) {
    $284 = (7008 + ($282<<2)|0);
    $285 = HEAP32[$284>>2]|0;
    $286 = (+($285|0));
    $287 = (($282) + 1)|0;
    $288 = (7008 + ($287<<2)|0);
    $289 = HEAP32[$288>>2]|0;
    $290 = (+($289|0));
    $291 = ((($gfp)) + 160|0);
    $292 = +HEAPF32[$291>>2];
    $293 = $292;
    $294 = $290 - $286;
    $295 = $294 * $293;
    $296 = $295 + $286;
    $301 = $296;
   } else {
    $301 = 19500.0;
   }
  }
  }
  $297 = HEAP32[$97>>2]|0;
  $298 = ($297|0)==(3);
  if ($298) {
   $299 = HEAP32[$105>>2]|0;
   if ((($299|0) == 3) | (($299|0) == 0)) {
    $300 = $301 * 1.5;
    $303 = $300;
   } else {
    $303 = $301;
   }
  } else {
   $303 = $301;
  }
  $302 = (~~(($303)));
  HEAP32[$231>>2] = $302;
  $$pre60 = HEAP32[$161>>2]|0;
  $304 = $$pre60;$307 = $302;
 } else {
  $304 = $1208;$307 = $232;
 }
 $305 = ($304|0)==(0);
 if ($305) {
  $306 = $307 << 1;
  $308 = ((($gfp)) + 12|0);
  $309 = HEAP32[$308>>2]|0;
  $310 = ($306|0)>($309|0);
  if ($310) {
   $311 = (($309|0) / 2)&-1;
   HEAP32[$231>>2] = $311;
   $321 = $311;
  } else {
   $321 = $307;
  }
  $312 = ($309|0)>(47999);
  do {
   if ($312) {
    $suggested_samplefreq$0$i = 48000;
   } else {
    $313 = ($309|0)>(44099);
    if ($313) {
     $suggested_samplefreq$0$i = 44100;
    } else {
     $314 = ($309|0)>(31999);
     if ($314) {
      $suggested_samplefreq$0$i = 32000;
     } else {
      $315 = ($309|0)>(23999);
      if ($315) {
       $suggested_samplefreq$0$i = 24000;
      } else {
       $316 = ($309|0)>(22049);
       if ($316) {
        $suggested_samplefreq$0$i = 22050;
       } else {
        $317 = ($309|0)>(15999);
        if ($317) {
         $suggested_samplefreq$0$i = 16000;
        } else {
         $318 = ($309|0)>(11999);
         if ($318) {
          $suggested_samplefreq$0$i = 12000;
          break;
         }
         $319 = ($309|0)>(11024);
         if ($319) {
          $suggested_samplefreq$0$i = 11025;
          break;
         }
         $320 = ($309|0)>(7999);
         $$$i = $320 ? 8000 : 44100;
         $suggested_samplefreq$0$i = $$$i;
        }
       }
      }
     }
    }
   }
  } while(0);
  $322 = ($321|0)==(-1);
  do {
   if ($322) {
    $$0$i13 = $suggested_samplefreq$0$i;
   } else {
    $323 = ($321|0)<(15961);
    $$suggested_samplefreq$0$i = $323 ? 44100 : $suggested_samplefreq$0$i;
    $324 = ($321|0)<(15251);
    $suggested_samplefreq$2$i = $324 ? 32000 : $$suggested_samplefreq$0$i;
    $325 = ($321|0)<(11221);
    $$suggested_samplefreq$2$i = $325 ? 24000 : $suggested_samplefreq$2$i;
    $326 = ($321|0)<(9971);
    $suggested_samplefreq$4$i = $326 ? 22050 : $$suggested_samplefreq$2$i;
    $327 = ($321|0)<(7231);
    $$suggested_samplefreq$4$i = $327 ? 16000 : $suggested_samplefreq$4$i;
    $328 = ($321|0)<(5421);
    $suggested_samplefreq$6$i = $328 ? 12000 : $$suggested_samplefreq$4$i;
    $329 = ($321|0)<(4511);
    $$suggested_samplefreq$6$i = $329 ? 11025 : $suggested_samplefreq$6$i;
    $330 = ($321|0)<(3971);
    $suggested_samplefreq$8$i = $330 ? 8000 : $$suggested_samplefreq$6$i;
    $331 = ($suggested_samplefreq$8$i|0)>($309|0);
    if ($331) {
     $332 = ($309|0)>(44100);
     if ($332) {
      $$0$i13 = 48000;
     } else {
      $333 = ($309|0)>(32000);
      if ($333) {
       $$0$i13 = 44100;
      } else {
       $334 = ($309|0)>(24000);
       if ($334) {
        $$0$i13 = 32000;
       } else {
        $335 = ($309|0)>(22050);
        if ($335) {
         $$0$i13 = 24000;
         break;
        }
        $336 = ($309|0)>(16000);
        if ($336) {
         $$0$i13 = 22050;
         break;
        }
        $337 = ($309|0)>(12000);
        if ($337) {
         $$0$i13 = 16000;
         break;
        }
        $338 = ($309|0)>(11025);
        if ($338) {
         $$0$i13 = 12000;
         break;
        }
        $339 = ($309|0)>(8000);
        $$1$i = $339 ? 11025 : 8000;
        $$0$i13 = $$1$i;
       }
      }
     }
    } else {
     $$0$i13 = $suggested_samplefreq$8$i;
    }
   }
  } while(0);
  HEAP32[$161>>2] = $$0$i13;
  $341 = $321;$344 = $$0$i13;
 } else {
  $341 = $307;$344 = $304;
 }
 $340 = HEAP32[$105>>2]|0;
 do {
  if ((($340|0) == 4) | (($340|0) == 1)) {
   $342 = ($341|0)>(24000);
   $$9 = $342 ? 24000 : $341;
   $343 = (($344|0) / 2)&-1;
   $345 = ($343|0)<($$9|0);
   $$storemerge91 = $345 ? $343 : $$9;
   HEAP32[$231>>2] = $$storemerge91;
   $346 = ($340|0)==(3);
   if ($346) {
    label = 98;
   }
  } else {
   $347 = ($341|0)>(20500);
   $$10 = $347 ? 20500 : $341;
   $348 = (($344|0) / 2)&-1;
   $349 = ($348|0)<($$10|0);
   $$storemerge = $349 ? $348 : $$10;
   HEAP32[$231>>2] = $$storemerge;
   if ((($340|0) == 3)) {
    label = 98;
    break;
   } else if (!((($340|0) == 0))) {
    break;
   }
   $350 = $344 << 4;
   $351 = HEAP32[$142>>2]|0;
   $352 = Math_imul($350, $351)|0;
   $353 = (+($352|0));
   $354 = ((($gfp)) + 96|0);
   $355 = HEAP32[$354>>2]|0;
   $356 = (+($355|0));
   $357 = $356 * 1000.0;
   $358 = $353 / $357;
   $359 = $358;
   $360 = ((($gfp)) + 100|0);
   HEAPF32[$360>>2] = $359;
  }
 } while(0);
 if ((label|0) == 98) {
  $361 = $344 << 4;
  $362 = HEAP32[$142>>2]|0;
  $363 = Math_imul($361, $362)|0;
  $364 = (+($363|0));
  $365 = ((($gfp)) + 168|0);
  $366 = HEAP32[$365>>2]|0;
  $367 = (+($366|0));
  $368 = $367 * 1000.0;
  $369 = $364 / $368;
  $370 = $369;
  $371 = ((($gfp)) + 100|0);
  HEAPF32[$371>>2] = $370;
 }
 $372 = ((($gfp)) + 36|0);
 $373 = HEAP32[$372>>2]|0;
 $374 = ($373|0)==(0);
 $375 = ((($gfp)) + 60|0);
 if ($374) {
  HEAP32[$375>>2] = 0;
  $376 = ((($gfp)) + 64|0);
  HEAP32[$376>>2] = 0;
  $377 = ((($1)) + 132|0);
  HEAP32[$377>>2] = 0;
  $378 = ((($1)) + 128|0);
  HEAP32[$378>>2] = 0;
  $379 = ((($1)) + 136|0);
  HEAP32[$379>>2] = 0;
 } else {
  $$pre63 = HEAP32[$375>>2]|0;
  $$phi$trans$insert64 = ((($gfp)) + 64|0);
  $$pre65 = HEAP32[$$phi$trans$insert64>>2]|0;
  $380 = ((($1)) + 128|0);
  HEAP32[$380>>2] = $$pre63;
  $381 = ((($1)) + 136|0);
  HEAP32[$381>>2] = $$pre65;
  $382 = ($$pre65|0)==(0);
  if ($382) {
   $1209 = 0;
  } else {
   $383 = ((($1)) + 132|0);
   HEAP32[$383>>2] = 1;
   $1209 = $$pre65;
  }
  $384 = ($$pre63|0)==(0);
  do {
   if ($384) {
    $388 = $1209;
   } else {
    $385 = HEAP32[$73>>2]|0;
    $386 = (_InitGainAnalysis(($385|0),($344|0))|0);
    $387 = ($386|0)==(0);
    if (!($387)) {
     $$pre67 = HEAP32[$381>>2]|0;
     $388 = $$pre67;
     break;
    }
    _freegfc($1);
    HEAP32[$0>>2] = 0;
    $$0 = -6;
    STACKTOP = sp;return ($$0|0);
   }
  } while(0);
  $389 = ($388|0)==(0);
  if (!($389)) {
   $390 = ((($gfp)) + 40|0);
   $391 = HEAP32[$390>>2]|0;
   $392 = ($391|0)==(0);
   if ($392) {
    $393 = ((($1)) + 85808|0);
    $394 = HEAP32[$393>>2]|0;
    $395 = ($394|0)==(0|0);
    if (!($395)) {
     (_hip_decode_exit(($394|0))|0);
    }
    $396 = (_hip_decode_init()|0);
    HEAP32[$393>>2] = $396;
    $397 = HEAP32[$21>>2]|0;
    _hip_set_errorf(($396|0),($397|0));
    $398 = HEAP32[$393>>2]|0;
    $399 = HEAP32[$18>>2]|0;
    _hip_set_debugf(($398|0),($399|0));
    $400 = HEAP32[$393>>2]|0;
    $401 = HEAP32[$15>>2]|0;
    _hip_set_msgf(($400|0),($401|0));
   }
  }
 }
 $402 = ((($gfp)) + 128|0);
 $403 = HEAP32[$402>>2]|0;
 $404 = ((($1)) + 144|0);
 HEAP32[$404>>2] = $403;
 $405 = HEAP32[$231>>2]|0;
 $406 = ((($1)) + 52|0);
 HEAP32[$406>>2] = $405;
 $407 = ((($gfp)) + 188|0);
 $408 = HEAP32[$407>>2]|0;
 $409 = ((($1)) + 56|0);
 HEAP32[$409>>2] = $408;
 $410 = ((($gfp)) + 12|0);
 $411 = HEAP32[$410>>2]|0;
 $412 = ((($1)) + 60|0);
 HEAP32[$412>>2] = $411;
 $413 = HEAP32[$161>>2]|0;
 $414 = ((($1)) + 64|0);
 HEAP32[$414>>2] = $413;
 $415 = ($413|0)<(24001);
 $416 = $415 ? 1 : 2;
 $417 = ((($1)) + 76|0);
 HEAP32[$417>>2] = $416;
 $418 = ((($1)) + 84760|0);
 HEAP32[$418>>2] = 576;
 $419 = HEAP32[$105>>2]|0;
 if ((($419|0) == 4) | (($419|0) == 2) | (($419|0) == 1)) {
  $420 = ((($gfp)) + 164|0);
  $421 = HEAP32[$420>>2]|0;
  $422 = (7056 + ($421<<2)|0);
  $423 = HEAP32[$422>>2]|0;
  $424 = ((($gfp)) + 100|0);
  HEAP32[$424>>2] = $423;
 } else if ((($419|0) == 3)) {
  $425 = $413 << 4;
  $426 = HEAP32[$142>>2]|0;
  $427 = Math_imul($425, $426)|0;
  $428 = (+($427|0));
  $429 = ((($gfp)) + 168|0);
  $430 = HEAP32[$429>>2]|0;
  $431 = (+($430|0));
  $432 = $431 * 1000.0;
  $433 = $428 / $432;
  $434 = $433;
  $435 = ((($gfp)) + 100|0);
  HEAPF32[$435>>2] = $434;
 } else {
  $436 = $413 << 4;
  $437 = HEAP32[$142>>2]|0;
  $438 = Math_imul($436, $437)|0;
  $439 = (+($438|0));
  $440 = ((($gfp)) + 96|0);
  $441 = HEAP32[$440>>2]|0;
  $442 = (+($441|0));
  $443 = $442 * 1000.0;
  $444 = $439 / $443;
  $445 = $444;
  $446 = ((($gfp)) + 100|0);
  HEAPF32[$446>>2] = $445;
 }
 $447 = HEAP32[$97>>2]|0;
 $448 = ($447|0)==(4);
 if ($448) {
  HEAP32[$97>>2] = 1;
  $450 = 1;
 } else {
  $450 = $447;
 }
 $449 = ((($1)) + 180|0);
 HEAP32[$449>>2] = $450;
 $451 = ($408|0)>(0);
 if ($451) {
  $452 = (+($408|0));
  $453 = $452 * 2.0;
  $454 = $453;
  $455 = ((($1)) + 256|0);
  HEAPF32[$455>>2] = $454;
  $456 = ((($gfp)) + 196|0);
  $457 = HEAP32[$456>>2]|0;
  $458 = ($457|0)>(-1);
  if ($458) {
   $459 = (($408) + ($457))|0;
   $460 = (+($459|0));
   $461 = $460 * 2.0;
   $462 = $461;
   $$sink = $462;
  } else {
   $$sink = $454;
  }
  $463 = ((($1)) + 260|0);
  $464 = (+($413|0));
  $465 = $454 / $464;
  HEAPF32[$455>>2] = $465;
  $466 = $$sink / $464;
  HEAPF32[$463>>2] = $466;
  $507 = $466;
 } else {
  $467 = ((($1)) + 256|0);
  HEAPF32[$467>>2] = 0.0;
  $468 = ((($1)) + 260|0);
  HEAPF32[$468>>2] = 0.0;
  $507 = 0.0;
 }
 $469 = ((($1)) + 248|0);
 HEAPF32[$469>>2] = 0.0;
 $470 = ((($1)) + 252|0);
 HEAPF32[$470>>2] = 0.0;
 $471 = ($405|0)>(0);
 $472 = (($413|0) / 2)&-1;
 $473 = ($405|0)<($472|0);
 $or$cond = $471 & $473;
 if ($or$cond) {
  $474 = (+($405|0));
  $475 = $474 * 2.0;
  $476 = $475;
  HEAPF32[$470>>2] = $476;
  $477 = ((($gfp)) + 192|0);
  $478 = HEAP32[$477>>2]|0;
  $479 = ($478|0)>(-1);
  if ($479) {
   $480 = (($405) - ($478))|0;
   $481 = (+($480|0));
   $482 = $481 * 2.0;
   $483 = $482;
   HEAPF32[$469>>2] = $483;
   $484 = $483 < 0.0;
   if ($484) {
    HEAPF32[$469>>2] = 0.0;
    $487 = 0.0;
   } else {
    $487 = $483;
   }
  } else {
   HEAPF32[$469>>2] = $476;
   $487 = $476;
  }
  $485 = (+($413|0));
  $486 = $487 / $485;
  HEAPF32[$469>>2] = $486;
  $488 = $476 / $485;
  HEAPF32[$470>>2] = $488;
  $489 = $486 > 0.0;
  if ($489) {
   $band$011$i = 0;$lowpass_band$013$i = 32;$minband$012$i = 999;
   while(1) {
    $490 = (+($band$011$i|0));
    $491 = $490 * 0.032258064516129031;
    $492 = $491;
    $493 = !($492 >= $488);
    $494 = ($lowpass_band$013$i|0)<($band$011$i|0);
    $495 = $494 | $493;
    $lowpass_band$1$i = $495 ? $lowpass_band$013$i : $band$011$i;
    $496 = $486 < $492;
    $497 = $492 < $488;
    $or$cond4$i = $497 & $496;
    $498 = ($minband$012$i|0)<($band$011$i|0);
    $499 = $498 ? $minband$012$i : $band$011$i;
    $minband$1$i = $or$cond4$i ? $499 : $minband$012$i;
    $500 = (($band$011$i) + 1)|0;
    $exitcond15$i = ($500|0)==(32);
    if ($exitcond15$i) {
     $lowpass_band$1$i$lcssa = $lowpass_band$1$i;$minband$1$i$lcssa = $minband$1$i;
     break;
    } else {
     $band$011$i = $500;$lowpass_band$013$i = $lowpass_band$1$i;$minband$012$i = $minband$1$i;
    }
   }
   $501 = ($minband$1$i$lcssa|0)==(999);
   $lowpass_band$0$minband$0$i = $501 ? $lowpass_band$1$i$lcssa : $minband$1$i$lcssa;
   $storemerge$in$in$in$i = (+($lowpass_band$0$minband$0$i|0));
   $storemerge$in$in$i = $storemerge$in$in$in$i + -0.75;
   $storemerge$in$i = $storemerge$in$in$i * 0.032258064516129031;
   $storemerge$i = $storemerge$in$i;
   HEAPF32[$469>>2] = $storemerge$i;
   $502 = (+($lowpass_band$1$i$lcssa|0));
   $503 = $502 * 0.032258064516129031;
   $504 = $503;
   HEAPF32[$470>>2] = $504;
  }
 }
 $505 = ((($1)) + 260|0);
 $506 = $507 > 0.0;
 $508 = $507;
 $509 = $508 < 0.021774193548387097;
 $or$cond$i = $506 & $509;
 $510 = ((($1)) + 256|0);
 if ($or$cond$i) {
  HEAPF32[$510>>2] = 0.0;
  HEAPF32[$505>>2] = 0.0;
  _lame_msgf($1,7096,$vararg_buffer);
  $$pr$i = +HEAPF32[$505>>2];
  $512 = $$pr$i;
 } else {
  $512 = $507;
 }
 $511 = $512 > 0.0;
 do {
  if ($511) {
   $513 = +HEAPF32[$510>>2];
   $band$18$i = 0;$highpass_band$010$i = -1;$maxband$09$i = -1;
   while(1) {
    $514 = (+($band$18$i|0));
    $515 = $514 * 0.032258064516129031;
    $516 = $515;
    $517 = !($516 <= $513);
    $518 = ($highpass_band$010$i|0)>($band$18$i|0);
    $519 = $518 | $517;
    $highpass_band$1$i = $519 ? $highpass_band$010$i : $band$18$i;
    $520 = $513 < $516;
    $521 = $516 < $512;
    $or$cond17$i = $520 & $521;
    $522 = ($maxband$09$i|0)>($band$18$i|0);
    $523 = $522 ? $maxband$09$i : $band$18$i;
    $maxband$1$i = $or$cond17$i ? $523 : $maxband$09$i;
    $524 = (($band$18$i) + 1)|0;
    $exitcond14$i = ($524|0)==(32);
    if ($exitcond14$i) {
     $highpass_band$1$i$lcssa = $highpass_band$1$i;$maxband$1$i$lcssa = $maxband$1$i;
     break;
    } else {
     $band$18$i = $524;$highpass_band$010$i = $highpass_band$1$i;$maxband$09$i = $maxband$1$i;
    }
   }
   $525 = (+($highpass_band$1$i$lcssa|0));
   $526 = $525 * 0.032258064516129031;
   $527 = $526;
   HEAPF32[$510>>2] = $527;
   $528 = ($maxband$1$i$lcssa|0)==(-1);
   if ($528) {
    $529 = $525 + 0.75;
    $530 = $529 * 0.032258064516129031;
    $531 = $530;
    HEAPF32[$505>>2] = $531;
    $540 = $531;$band$27$i = 0;
    break;
   } else {
    $532 = (+($maxband$1$i$lcssa|0));
    $533 = $532 + 0.75;
    $534 = $533 * 0.032258064516129031;
    $535 = $534;
    HEAPF32[$505>>2] = $535;
    $540 = $535;$band$27$i = 0;
    break;
   }
  } else {
   $540 = $512;$band$27$i = 0;
  }
 } while(0);
 while(1) {
  $536 = (+($band$27$i|0));
  $537 = $536 * 0.032258063554763794;
  $538 = +HEAPF32[$510>>2];
  $539 = $540 > $538;
  do {
   if ($539) {
    $541 = $540 - $537;
    $542 = $541;
    $543 = $540 - $538;
    $544 = $543;
    $545 = $544 + 9.9999999999999995E-21;
    $546 = $542 / $545;
    $547 = $546;
    $548 = $547;
    $549 = $547 > 1.0;
    if ($549) {
     $fc1$0$i = 0.0;
     break;
    }
    $550 = !($547 <= 0.0);
    if (!($550)) {
     $fc1$0$i = 1.0;
     break;
    }
    $551 = $548 * 1.5707963267948966;
    $552 = (+Math_cos((+$551)));
    $553 = $552;
    $fc1$0$i = $553;
   } else {
    $fc1$0$i = 1.0;
   }
  } while(0);
  $554 = +HEAPF32[$470>>2];
  $555 = +HEAPF32[$469>>2];
  $556 = $554 > $555;
  do {
   if ($556) {
    $557 = $537 - $555;
    $558 = $557;
    $559 = $554 - $555;
    $560 = $559;
    $561 = $560 + 9.9999999999999995E-21;
    $562 = $558 / $561;
    $563 = $562;
    $564 = $563;
    $565 = $563 > 1.0;
    if ($565) {
     $fc2$0$i = 0.0;
     break;
    }
    $566 = !($563 <= 0.0);
    if (!($566)) {
     $fc2$0$i = 1.0;
     break;
    }
    $567 = $564 * 1.5707963267948966;
    $568 = (+Math_cos((+$567)));
    $569 = $568;
    $fc2$0$i = $569;
   } else {
    $fc2$0$i = 1.0;
   }
  } while(0);
  $570 = $fc2$0$i * $fc1$0$i;
  $571 = (((($1)) + 37040|0) + ($band$27$i<<2)|0);
  HEAPF32[$571>>2] = $570;
  $572 = (($band$27$i) + 1)|0;
  $exitcond$i = ($572|0)==(32);
  if ($exitcond$i) {
   break;
  }
  $$pre$i = +HEAPF32[$505>>2];
  $540 = $$pre$i;$band$27$i = $572;
 }
 $573 = HEAP32[$414>>2]|0;
 $574 = (_SmpFrqIndex($573,$2)|0);
 $575 = ((($1)) + 20|0);
 HEAP32[$575>>2] = $574;
 $576 = ($574|0)<(0);
 if ($576) {
  _freegfc($1);
  HEAP32[$0>>2] = 0;
  $$0 = -1;
  STACKTOP = sp;return ($$0|0);
 }
 $577 = HEAP32[$105>>2]|0;
 $578 = ($577|0)==(0);
 do {
  if ($578) {
   $579 = HEAP32[$580>>2]|0;
   $581 = ($579|0)==(0);
   if (!($581)) {
    $582 = ((($1)) + 84744|0);
    HEAP32[$582>>2] = 0;
    break;
   }
   $583 = ((($gfp)) + 96|0);
   $584 = HEAP32[$583>>2]|0;
   $585 = HEAP32[$2>>2]|0;
   $586 = HEAP32[$414>>2]|0;
   $587 = (_FindNearestBitrate($584,$585,$586)|0);
   HEAP32[$583>>2] = $587;
   $588 = HEAP32[$2>>2]|0;
   $589 = HEAP32[$414>>2]|0;
   $590 = (_BitrateIndex($587,$588,$589)|0);
   $591 = ((($1)) + 84744|0);
   HEAP32[$591>>2] = $590;
   $592 = ($590|0)<(1);
   if (!($592)) {
    break;
   }
   _freegfc($1);
   HEAP32[$0>>2] = 0;
   $$0 = -1;
   STACKTOP = sp;return ($$0|0);
  } else {
   $593 = ((($1)) + 84744|0);
   HEAP32[$593>>2] = 1;
  }
 } while(0);
 _init_bit_stream_w($1);
 $594 = HEAP32[$575>>2]|0;
 $595 = HEAP32[$2>>2]|0;
 $596 = ($595*3)|0;
 $597 = (($596) + ($594))|0;
 $598 = HEAP32[$414>>2]|0;
 $599 = ($598|0)<(16000);
 $600 = $599 ? 6 : 0;
 $601 = (($597) + ($600))|0;
 $602 = (12200 + (($601*204)|0)|0);
 $603 = HEAP32[$602>>2]|0;
 $604 = ((($1)) + 21360|0);
 HEAP32[$604>>2] = $603;
 $605 = (((12200 + (($601*204)|0)|0)) + 4|0);
 $606 = HEAP32[$605>>2]|0;
 $607 = ((($1)) + 21364|0);
 HEAP32[$607>>2] = $606;
 $608 = (((12200 + (($601*204)|0)|0)) + 8|0);
 $609 = HEAP32[$608>>2]|0;
 $610 = ((($1)) + 21368|0);
 HEAP32[$610>>2] = $609;
 $611 = (((12200 + (($601*204)|0)|0)) + 12|0);
 $612 = HEAP32[$611>>2]|0;
 $613 = ((($1)) + 21372|0);
 HEAP32[$613>>2] = $612;
 $614 = (((12200 + (($601*204)|0)|0)) + 16|0);
 $615 = HEAP32[$614>>2]|0;
 $616 = ((($1)) + 21376|0);
 HEAP32[$616>>2] = $615;
 $617 = (((12200 + (($601*204)|0)|0)) + 20|0);
 $618 = HEAP32[$617>>2]|0;
 $619 = ((($1)) + 21380|0);
 HEAP32[$619>>2] = $618;
 $620 = (((12200 + (($601*204)|0)|0)) + 24|0);
 $621 = HEAP32[$620>>2]|0;
 $622 = ((($1)) + 21384|0);
 HEAP32[$622>>2] = $621;
 $623 = (((12200 + (($601*204)|0)|0)) + 28|0);
 $624 = HEAP32[$623>>2]|0;
 $625 = ((($1)) + 21388|0);
 HEAP32[$625>>2] = $624;
 $626 = (((12200 + (($601*204)|0)|0)) + 32|0);
 $627 = HEAP32[$626>>2]|0;
 $628 = ((($1)) + 21392|0);
 HEAP32[$628>>2] = $627;
 $629 = (((12200 + (($601*204)|0)|0)) + 36|0);
 $630 = HEAP32[$629>>2]|0;
 $631 = ((($1)) + 21396|0);
 HEAP32[$631>>2] = $630;
 $632 = (((12200 + (($601*204)|0)|0)) + 40|0);
 $633 = HEAP32[$632>>2]|0;
 $634 = ((($1)) + 21400|0);
 HEAP32[$634>>2] = $633;
 $635 = (((12200 + (($601*204)|0)|0)) + 44|0);
 $636 = HEAP32[$635>>2]|0;
 $637 = ((($1)) + 21404|0);
 HEAP32[$637>>2] = $636;
 $638 = (((12200 + (($601*204)|0)|0)) + 48|0);
 $639 = HEAP32[$638>>2]|0;
 $640 = ((($1)) + 21408|0);
 HEAP32[$640>>2] = $639;
 $641 = (((12200 + (($601*204)|0)|0)) + 52|0);
 $642 = HEAP32[$641>>2]|0;
 $643 = ((($1)) + 21412|0);
 HEAP32[$643>>2] = $642;
 $644 = (((12200 + (($601*204)|0)|0)) + 56|0);
 $645 = HEAP32[$644>>2]|0;
 $646 = ((($1)) + 21416|0);
 HEAP32[$646>>2] = $645;
 $647 = (((12200 + (($601*204)|0)|0)) + 60|0);
 $648 = HEAP32[$647>>2]|0;
 $649 = ((($1)) + 21420|0);
 HEAP32[$649>>2] = $648;
 $650 = (((12200 + (($601*204)|0)|0)) + 64|0);
 $651 = HEAP32[$650>>2]|0;
 $652 = ((($1)) + 21424|0);
 HEAP32[$652>>2] = $651;
 $653 = (((12200 + (($601*204)|0)|0)) + 68|0);
 $654 = HEAP32[$653>>2]|0;
 $655 = ((($1)) + 21428|0);
 HEAP32[$655>>2] = $654;
 $656 = (((12200 + (($601*204)|0)|0)) + 72|0);
 $657 = HEAP32[$656>>2]|0;
 $658 = ((($1)) + 21432|0);
 HEAP32[$658>>2] = $657;
 $659 = (((12200 + (($601*204)|0)|0)) + 76|0);
 $660 = HEAP32[$659>>2]|0;
 $661 = ((($1)) + 21436|0);
 HEAP32[$661>>2] = $660;
 $662 = (((12200 + (($601*204)|0)|0)) + 80|0);
 $663 = HEAP32[$662>>2]|0;
 $664 = ((($1)) + 21440|0);
 HEAP32[$664>>2] = $663;
 $665 = (((12200 + (($601*204)|0)|0)) + 84|0);
 $666 = HEAP32[$665>>2]|0;
 $667 = ((($1)) + 21444|0);
 HEAP32[$667>>2] = $666;
 $668 = (((12200 + (($601*204)|0)|0)) + 88|0);
 $669 = HEAP32[$668>>2]|0;
 $670 = ((($1)) + 21448|0);
 HEAP32[$670>>2] = $669;
 $671 = (($669) - ($666))|0;
 $672 = (($671|0) / 6)&-1;
 $673 = ((($1)) + 21508|0);
 HEAP32[$673>>2] = $666;
 $674 = (($672) + ($666))|0;
 $675 = ((($1)) + 21512|0);
 HEAP32[$675>>2] = $674;
 $676 = $672 << 1;
 $677 = (($676) + ($666))|0;
 $678 = ((($1)) + 21516|0);
 HEAP32[$678>>2] = $677;
 $679 = ($672*3)|0;
 $680 = (($679) + ($666))|0;
 $681 = ((($1)) + 21520|0);
 HEAP32[$681>>2] = $680;
 $682 = $672 << 2;
 $683 = (($682) + ($666))|0;
 $684 = ((($1)) + 21524|0);
 HEAP32[$684>>2] = $683;
 $685 = ($672*5)|0;
 $686 = (($685) + ($666))|0;
 $687 = ((($1)) + 21528|0);
 HEAP32[$687>>2] = $686;
 $688 = ((($1)) + 21532|0);
 HEAP32[$688>>2] = 576;
 $689 = (((12200 + (($601*204)|0)|0)) + 92|0);
 $690 = HEAP32[$689>>2]|0;
 $691 = ((($1)) + 21452|0);
 HEAP32[$691>>2] = $690;
 $692 = (((12200 + (($601*204)|0)|0)) + 96|0);
 $693 = HEAP32[$692>>2]|0;
 $694 = ((($1)) + 21456|0);
 HEAP32[$694>>2] = $693;
 $695 = (((12200 + (($601*204)|0)|0)) + 100|0);
 $696 = HEAP32[$695>>2]|0;
 $697 = ((($1)) + 21460|0);
 HEAP32[$697>>2] = $696;
 $698 = (((12200 + (($601*204)|0)|0)) + 104|0);
 $699 = HEAP32[$698>>2]|0;
 $700 = ((($1)) + 21464|0);
 HEAP32[$700>>2] = $699;
 $701 = (((12200 + (($601*204)|0)|0)) + 108|0);
 $702 = HEAP32[$701>>2]|0;
 $703 = ((($1)) + 21468|0);
 HEAP32[$703>>2] = $702;
 $704 = (((12200 + (($601*204)|0)|0)) + 112|0);
 $705 = HEAP32[$704>>2]|0;
 $706 = ((($1)) + 21472|0);
 HEAP32[$706>>2] = $705;
 $707 = (((12200 + (($601*204)|0)|0)) + 116|0);
 $708 = HEAP32[$707>>2]|0;
 $709 = ((($1)) + 21476|0);
 HEAP32[$709>>2] = $708;
 $710 = (((12200 + (($601*204)|0)|0)) + 120|0);
 $711 = HEAP32[$710>>2]|0;
 $712 = ((($1)) + 21480|0);
 HEAP32[$712>>2] = $711;
 $713 = (((12200 + (($601*204)|0)|0)) + 124|0);
 $714 = HEAP32[$713>>2]|0;
 $715 = ((($1)) + 21484|0);
 HEAP32[$715>>2] = $714;
 $716 = (((12200 + (($601*204)|0)|0)) + 128|0);
 $717 = HEAP32[$716>>2]|0;
 $718 = ((($1)) + 21488|0);
 HEAP32[$718>>2] = $717;
 $719 = (((12200 + (($601*204)|0)|0)) + 132|0);
 $720 = HEAP32[$719>>2]|0;
 $721 = ((($1)) + 21492|0);
 HEAP32[$721>>2] = $720;
 $722 = (((12200 + (($601*204)|0)|0)) + 136|0);
 $723 = HEAP32[$722>>2]|0;
 $724 = ((($1)) + 21496|0);
 HEAP32[$724>>2] = $723;
 $725 = (((12200 + (($601*204)|0)|0)) + 140|0);
 $726 = HEAP32[$725>>2]|0;
 $727 = ((($1)) + 21500|0);
 HEAP32[$727>>2] = $726;
 $728 = (((12200 + (($601*204)|0)|0)) + 144|0);
 $729 = HEAP32[$728>>2]|0;
 $730 = ((($1)) + 21504|0);
 HEAP32[$730>>2] = $729;
 $731 = (($729) - ($726))|0;
 $732 = (($731|0) / 6)&-1;
 $733 = ((($1)) + 21536|0);
 HEAP32[$733>>2] = $726;
 $734 = (($732) + ($726))|0;
 $735 = ((($1)) + 21540|0);
 HEAP32[$735>>2] = $734;
 $736 = $732 << 1;
 $737 = (($736) + ($726))|0;
 $738 = ((($1)) + 21544|0);
 HEAP32[$738>>2] = $737;
 $739 = ($732*3)|0;
 $740 = (($739) + ($726))|0;
 $741 = ((($1)) + 21548|0);
 HEAP32[$741>>2] = $740;
 $742 = $732 << 2;
 $743 = (($742) + ($726))|0;
 $744 = ((($1)) + 21552|0);
 HEAP32[$744>>2] = $743;
 $745 = ($732*5)|0;
 $746 = (($745) + ($726))|0;
 $747 = ((($1)) + 21556|0);
 HEAP32[$747>>2] = $746;
 $748 = ((($1)) + 21560|0);
 HEAP32[$748>>2] = 192;
 $749 = HEAP32[$417>>2]|0;
 $750 = ($749|0)==(2);
 $751 = HEAP32[$142>>2]|0;
 $752 = ($751|0)==(1);
 $753 = $752 ? 13 : 21;
 $754 = $752 ? 21 : 36;
 $755 = $750 ? $754 : $753;
 $756 = ((($1)) + 24|0);
 HEAP32[$756>>2] = $755;
 $757 = HEAP32[$80>>2]|0;
 $758 = ($757|0)==(0);
 if (!($758)) {
  $759 = $755 | 2;
  HEAP32[$756>>2] = $759;
 }
 HEAP32[$1>>2] = -487877;
 $760 = ($749*700)|0;
 $761 = Math_imul($760, $751)|0;
 $762 = (+($761|0));
 $763 = ((($1)) + 39756|0);
 HEAPF32[$763>>2] = $762;
 $$pre69 = HEAP32[$417>>2]|0;
 $$pre70 = HEAP32[$142>>2]|0;
 $764 = ($$pre69*700)|0;
 $765 = Math_imul($764, $$pre70)|0;
 $766 = (+($765|0));
 $767 = ((($1)) + 39760|0);
 HEAPF32[$767>>2] = $766;
 $$pre69$1 = HEAP32[$417>>2]|0;
 $$pre70$1 = HEAP32[$142>>2]|0;
 $768 = ($$pre69$1*700)|0;
 $769 = Math_imul($768, $$pre70$1)|0;
 $770 = (+($769|0));
 $771 = ((($1)) + 39764|0);
 HEAPF32[$771>>2] = $770;
 $$pre69$2 = HEAP32[$417>>2]|0;
 $$pre70$2 = HEAP32[$142>>2]|0;
 $772 = ($$pre69$2*700)|0;
 $773 = Math_imul($772, $$pre70$2)|0;
 $774 = (+($773|0));
 $775 = ((($1)) + 39768|0);
 HEAPF32[$775>>2] = $774;
 $$pre69$3 = HEAP32[$417>>2]|0;
 $$pre70$3 = HEAP32[$142>>2]|0;
 $776 = ($$pre69$3*700)|0;
 $777 = Math_imul($776, $$pre70$3)|0;
 $778 = (+($777|0));
 $779 = ((($1)) + 39772|0);
 HEAPF32[$779>>2] = $778;
 $$pre69$4 = HEAP32[$417>>2]|0;
 $$pre70$4 = HEAP32[$142>>2]|0;
 $780 = ($$pre69$4*700)|0;
 $781 = Math_imul($780, $$pre70$4)|0;
 $782 = (+($781|0));
 $783 = ((($1)) + 39776|0);
 HEAPF32[$783>>2] = $782;
 $$pre69$5 = HEAP32[$417>>2]|0;
 $$pre70$5 = HEAP32[$142>>2]|0;
 $784 = ($$pre69$5*700)|0;
 $785 = Math_imul($784, $$pre70$5)|0;
 $786 = (+($785|0));
 $787 = ((($1)) + 39780|0);
 HEAPF32[$787>>2] = $786;
 $$pre69$6 = HEAP32[$417>>2]|0;
 $$pre70$6 = HEAP32[$142>>2]|0;
 $788 = ($$pre69$6*700)|0;
 $789 = Math_imul($788, $$pre70$6)|0;
 $790 = (+($789|0));
 $791 = ((($1)) + 39784|0);
 HEAPF32[$791>>2] = $790;
 $$pre69$7 = HEAP32[$417>>2]|0;
 $$pre70$7 = HEAP32[$142>>2]|0;
 $792 = ($$pre69$7*700)|0;
 $793 = Math_imul($792, $$pre70$7)|0;
 $794 = (+($793|0));
 $795 = ((($1)) + 39788|0);
 HEAPF32[$795>>2] = $794;
 $$pre69$8 = HEAP32[$417>>2]|0;
 $$pre70$8 = HEAP32[$142>>2]|0;
 $796 = ($$pre69$8*700)|0;
 $797 = Math_imul($796, $$pre70$8)|0;
 $798 = (+($797|0));
 $799 = ((($1)) + 39792|0);
 HEAPF32[$799>>2] = $798;
 $$pre69$9 = HEAP32[$417>>2]|0;
 $$pre70$9 = HEAP32[$142>>2]|0;
 $800 = ($$pre69$9*700)|0;
 $801 = Math_imul($800, $$pre70$9)|0;
 $802 = (+($801|0));
 $803 = ((($1)) + 39796|0);
 HEAPF32[$803>>2] = $802;
 $$pre69$10 = HEAP32[$417>>2]|0;
 $$pre70$10 = HEAP32[$142>>2]|0;
 $804 = ($$pre69$10*700)|0;
 $805 = Math_imul($804, $$pre70$10)|0;
 $806 = (+($805|0));
 $807 = ((($1)) + 39800|0);
 HEAPF32[$807>>2] = $806;
 $$pre69$11 = HEAP32[$417>>2]|0;
 $$pre70$11 = HEAP32[$142>>2]|0;
 $808 = ($$pre69$11*700)|0;
 $809 = Math_imul($808, $$pre70$11)|0;
 $810 = (+($809|0));
 $811 = ((($1)) + 39804|0);
 HEAPF32[$811>>2] = $810;
 $$pre69$12 = HEAP32[$417>>2]|0;
 $$pre70$12 = HEAP32[$142>>2]|0;
 $812 = ($$pre69$12*700)|0;
 $813 = Math_imul($812, $$pre70$12)|0;
 $814 = (+($813|0));
 $815 = ((($1)) + 39808|0);
 HEAPF32[$815>>2] = $814;
 $$pre69$13 = HEAP32[$417>>2]|0;
 $$pre70$13 = HEAP32[$142>>2]|0;
 $816 = ($$pre69$13*700)|0;
 $817 = Math_imul($816, $$pre70$13)|0;
 $818 = (+($817|0));
 $819 = ((($1)) + 39812|0);
 HEAPF32[$819>>2] = $818;
 $$pre69$14 = HEAP32[$417>>2]|0;
 $$pre70$14 = HEAP32[$142>>2]|0;
 $820 = ($$pre69$14*700)|0;
 $821 = Math_imul($820, $$pre70$14)|0;
 $822 = (+($821|0));
 $823 = ((($1)) + 39816|0);
 HEAPF32[$823>>2] = $822;
 $$pre69$15 = HEAP32[$417>>2]|0;
 $$pre70$15 = HEAP32[$142>>2]|0;
 $824 = ($$pre69$15*700)|0;
 $825 = Math_imul($824, $$pre70$15)|0;
 $826 = (+($825|0));
 $827 = ((($1)) + 39820|0);
 HEAPF32[$827>>2] = $826;
 $$pre69$16 = HEAP32[$417>>2]|0;
 $$pre70$16 = HEAP32[$142>>2]|0;
 $828 = ($$pre69$16*700)|0;
 $829 = Math_imul($828, $$pre70$16)|0;
 $830 = (+($829|0));
 $831 = ((($1)) + 39824|0);
 HEAPF32[$831>>2] = $830;
 $$pre69$17 = HEAP32[$417>>2]|0;
 $$pre70$17 = HEAP32[$142>>2]|0;
 $832 = ($$pre69$17*700)|0;
 $833 = Math_imul($832, $$pre70$17)|0;
 $834 = (+($833|0));
 $835 = ((($1)) + 39828|0);
 HEAPF32[$835>>2] = $834;
 $836 = ((($gfp)) + 220|0);
 $837 = HEAP32[$836>>2]|0;
 $838 = ($837|0)==(-1);
 if ($838) {
  HEAP32[$836>>2] = 4;
 }
 $839 = HEAP32[$105>>2]|0;
 do {
  if ((($839|0) == 4) | (($839|0) == 1)) {
   $840 = ((($gfp)) + 124|0);
   $841 = HEAP32[$840>>2]|0;
   $842 = ($841|0)<(0);
   if ($842) {
    HEAP32[$840>>2] = 2;
   }
   $843 = ((($gfp)) + 244|0);
   $844 = HEAP32[$843>>2]|0;
   $845 = ($844|0)<(0);
   if ($845) {
    HEAP32[$843>>2] = 0;
   }
   $846 = ((($gfp)) + 164|0);
   $847 = HEAP32[$846>>2]|0;
   $848 = Math_imul($847, -10)|0;
   $849 = (($848) + 500)|0;
   (_apply_preset($gfp,$849,0)|0);
   $850 = ((($gfp)) + 44|0);
   $851 = HEAP32[$850>>2]|0;
   $852 = ($851|0)<(0);
   do {
    if ($852) {
     HEAP32[$850>>2] = 3;
     label = 169;
    } else {
     $853 = ($851|0)<(5);
     if ($853) {
      label = 169;
      break;
     }
     $854 = ($851|0)>(7);
     if (!($854)) {
      break;
     }
     HEAP32[$850>>2] = 7;
    }
   } while(0);
   if ((label|0) == 169) {
    HEAP32[$850>>2] = 0;
   }
   $855 = ((($gfp)) + 140|0);
   $856 = HEAP32[$855>>2]|0;
   $857 = ($856|0)==(0);
   if ($857) {
    $858 = HEAP32[$414>>2]|0;
    $859 = ($858|0)>(44000);
    $860 = $859&1;
    $$sink54 = $860;
   } else {
    $$sink54 = 0;
   }
   $861 = ((($1)) + 85092|0);
   HEAP32[$861>>2] = $$sink54;
   $862 = ((($1)) + 85812|0);
   HEAP32[$862>>2] = 1;
  } else if ((($839|0) == 2)) {
   $863 = ((($gfp)) + 164|0);
   $864 = HEAP32[$863>>2]|0;
   $865 = Math_imul($864, -10)|0;
   $866 = (($865) + 500)|0;
   (_apply_preset($gfp,$866,0)|0);
   $867 = ((($gfp)) + 140|0);
   $868 = HEAP32[$867>>2]|0;
   $869 = ($868|0)==(0);
   if ($869) {
    $870 = HEAP32[$414>>2]|0;
    $871 = ($870|0)>(44000);
    $872 = $871&1;
    $$sink55 = $872;
   } else {
    $$sink55 = 0;
   }
   $873 = ((($1)) + 85092|0);
   HEAP32[$873>>2] = $$sink55;
   $874 = ((($gfp)) + 44|0);
   $875 = HEAP32[$874>>2]|0;
   $876 = ($875|0)>(6);
   do {
    if ($876) {
     HEAP32[$874>>2] = 6;
    } else {
     $877 = ($875|0)<(0);
     if (!($877)) {
      break;
     }
     HEAP32[$874>>2] = 3;
    }
   } while(0);
   $878 = ((($1)) + 85812|0);
   HEAP32[$878>>2] = 2;
  } else {
   $879 = ((($1)) + 85092|0);
   HEAP32[$879>>2] = 0;
   $880 = ((($gfp)) + 44|0);
   $881 = HEAP32[$880>>2]|0;
   $882 = ($881|0)<(0);
   if ($882) {
    HEAP32[$880>>2] = 3;
   }
   $883 = ($839|0)==(0);
   if ($883) {
    $884 = ((($gfp)) + 96|0);
    $885 = HEAP32[$884>>2]|0;
    (_lame_set_VBR_mean_bitrate_kbps($gfp,$885)|0);
   }
   $886 = ((($gfp)) + 168|0);
   $887 = HEAP32[$886>>2]|0;
   (_apply_preset($gfp,$887,0)|0);
   HEAP32[$105>>2] = $839;
   $888 = ((($1)) + 85812|0);
   if ($883) {
    HEAP32[$888>>2] = 3;
    break;
   } else {
    HEAP32[$888>>2] = 4;
    break;
   }
  }
 } while(0);
 $889 = ((($gfp)) + 200|0);
 $890 = HEAP32[$889>>2]|0;
 $891 = ((($1)) + 84912|0);
 HEAP32[$891>>2] = $890;
 $892 = ((($gfp)) + 204|0);
 $893 = HEAP32[$892>>2]|0;
 $894 = ((($1)) + 84916|0);
 HEAP32[$894>>2] = $893;
 $895 = ((($gfp)) + 256|0);
 $896 = HEAP32[$895>>2]|0;
 $897 = ($896|0)==(0);
 if (!($897)) {
  $898 = (HEAP32[tempDoublePtr>>2]=$893,+HEAPF32[tempDoublePtr>>2]);
  $899 = (HEAP32[tempDoublePtr>>2]=$890,+HEAPF32[tempDoublePtr>>2]);
  $900 = ((($gfp)) + 260|0);
  $901 = +HEAPF32[$900>>2];
  $902 = $899 + $901;
  HEAPF32[$891>>2] = $902;
  $903 = $898 + $901;
  HEAPF32[$894>>2] = $903;
 }
 $904 = HEAP32[$105>>2]|0;
 $905 = ($904|0)==(0);
 if ($905) {
  $$phi$trans$insert77 = ((($gfp)) + 168|0);
  $$pre78 = HEAP32[$$phi$trans$insert77>>2]|0;
  $947 = 0;$964 = $$pre78;
 } else {
  $906 = ((($1)) + 112|0);
  HEAP32[$906>>2] = 1;
  $907 = ((($1)) + 116|0);
  $908 = HEAP32[$414>>2]|0;
  $909 = ($908|0)<(16000);
  $$11 = $909 ? 8 : 14;
  HEAP32[$907>>2] = $$11;
  $910 = ((($gfp)) + 172|0);
  $911 = HEAP32[$910>>2]|0;
  $912 = ($911|0)==(0);
  do {
   if ($912) {
    $1210 = 1;
   } else {
    $913 = HEAP32[$2>>2]|0;
    $914 = (_FindNearestBitrate($911,$913,$908)|0);
    HEAP32[$910>>2] = $914;
    $915 = HEAP32[$2>>2]|0;
    $916 = HEAP32[$414>>2]|0;
    $917 = (_BitrateIndex($914,$915,$916)|0);
    HEAP32[$906>>2] = $917;
    $918 = ($917|0)<(0);
    if ($918) {
     $$0 = -1;
    } else {
     $1210 = $917;
     break;
    }
    STACKTOP = sp;return ($$0|0);
   }
  } while(0);
  $919 = ((($gfp)) + 176|0);
  $920 = HEAP32[$919>>2]|0;
  $921 = ($920|0)==(0);
  do {
   if ($921) {
    $$pre74 = HEAP32[$907>>2]|0;
    $931 = $1210;$934 = $$pre74;
   } else {
    $922 = HEAP32[$2>>2]|0;
    $923 = HEAP32[$414>>2]|0;
    $924 = (_FindNearestBitrate($920,$922,$923)|0);
    HEAP32[$919>>2] = $924;
    $925 = HEAP32[$2>>2]|0;
    $926 = HEAP32[$414>>2]|0;
    $927 = (_BitrateIndex($924,$925,$926)|0);
    HEAP32[$907>>2] = $927;
    $928 = ($927|0)<(0);
    if ($928) {
     $$0 = -1;
     STACKTOP = sp;return ($$0|0);
    } else {
     $$pre72 = HEAP32[$906>>2]|0;
     $931 = $$pre72;$934 = $927;
     break;
    }
   }
  } while(0);
  $929 = HEAP32[$2>>2]|0;
  $930 = ((83944 + ($929<<6)|0) + ($931<<2)|0);
  $932 = HEAP32[$930>>2]|0;
  HEAP32[$910>>2] = $932;
  $933 = ((83944 + ($929<<6)|0) + ($934<<2)|0);
  $935 = HEAP32[$933>>2]|0;
  HEAP32[$919>>2] = $935;
  $936 = ((($gfp)) + 168|0);
  $937 = HEAP32[$936>>2]|0;
  $938 = ($935|0)<($937|0);
  $$12 = $938 ? $935 : $937;
  $939 = ($932|0)>($$12|0);
  $940 = $939 ? $932 : $$12;
  HEAP32[$936>>2] = $940;
  $$pre75 = HEAP32[$105>>2]|0;
  $947 = $$pre75;$964 = $940;
 }
 $941 = ((($gfp)) + 152|0);
 $942 = HEAP32[$941>>2]|0;
 $943 = ((($1)) + 100|0);
 HEAP32[$943>>2] = $942;
 $944 = HEAP32[$372>>2]|0;
 $945 = ((($1)) + 156|0);
 HEAP32[$945>>2] = $944;
 $946 = ((($1)) + 104|0);
 HEAP32[$946>>2] = $947;
 $948 = ((($gfp)) + 80|0);
 $949 = HEAP32[$948>>2]|0;
 $950 = ((($1)) + 85096|0);
 HEAP32[$950>>2] = $949;
 $951 = ((($gfp)) + 84|0);
 $952 = HEAP32[$951>>2]|0;
 $953 = ((($1)) + 28|0);
 HEAP32[$953>>2] = $952;
 $954 = ((($gfp)) + 88|0);
 $955 = HEAP32[$954>>2]|0;
 $956 = ((($1)) + 32|0);
 HEAP32[$956>>2] = $955;
 $957 = ((($gfp)) + 92|0);
 $958 = HEAP32[$957>>2]|0;
 $959 = ((($1)) + 36|0);
 HEAP32[$959>>2] = $958;
 $960 = ((($gfp)) + 96|0);
 $961 = HEAP32[$960>>2]|0;
 $962 = ((($1)) + 120|0);
 HEAP32[$962>>2] = $961;
 $963 = ((($1)) + 108|0);
 HEAP32[$963>>2] = $964;
 $965 = ((($gfp)) + 100|0);
 $966 = HEAP32[$965>>2]|0;
 $967 = ((($1)) + 244|0);
 HEAP32[$967>>2] = $966;
 $968 = HEAP32[$0>>2]|0;
 $969 = ((($gfp)) + 44|0);
 $970 = HEAP32[$969>>2]|0;
 switch ($970|0) {
 case 6:  {
  $977 = ((($968)) + 28|0);
  $978 = HEAP32[$977>>2]|0;
  $979 = ($978|0)==(0);
  if ($979) {
   HEAP32[$977>>2] = 1;
  }
  $980 = ((($968)) + 40|0);
  HEAP32[$980>>2] = 0;
  $981 = ((($968)) + 44|0);
  HEAP32[$981>>2] = 0;
  $982 = ((($968)) + 32|0);
  $983 = HEAP32[$982>>2]|0;
  $984 = ($983|0)==(-1);
  if ($984) {
   HEAP32[$982>>2] = 1;
  }
  $985 = ((($968)) + 36|0);
  HEAP32[$985>>2] = 0;
  $986 = ((($968)) + 48|0);
  HEAP32[$986>>2] = 0;
  break;
 }
 case 5:  {
  $987 = ((($968)) + 28|0);
  $988 = HEAP32[$987>>2]|0;
  $989 = ($988|0)==(0);
  if ($989) {
   HEAP32[$987>>2] = 1;
  }
  $990 = ((($968)) + 40|0);
  HEAP32[$990>>2] = 0;
  $991 = ((($968)) + 44|0);
  HEAP32[$991>>2] = 0;
  $992 = ((($968)) + 32|0);
  $993 = HEAP32[$992>>2]|0;
  $994 = ($993|0)==(-1);
  if ($994) {
   HEAP32[$992>>2] = 1;
  }
  $995 = ((($968)) + 36|0);
  HEAP32[$995>>2] = 0;
  $996 = ((($968)) + 48|0);
  HEAP32[$996>>2] = 0;
  break;
 }
 case 8:  {
  HEAP32[$969>>2] = 7;
  label = 203;
  break;
 }
 case 7:  {
  label = 203;
  break;
 }
 case 3:  {
  $1007 = ((($968)) + 28|0);
  $1008 = HEAP32[$1007>>2]|0;
  $1009 = ($1008|0)==(0);
  if ($1009) {
   HEAP32[$1007>>2] = 1;
  }
  $1010 = ((($968)) + 40|0);
  HEAP32[$1010>>2] = 1;
  $1011 = ((($968)) + 44|0);
  HEAP32[$1011>>2] = 1;
  $1012 = ((($968)) + 32|0);
  $1013 = HEAP32[$1012>>2]|0;
  $1014 = ($1013|0)==(-1);
  if ($1014) {
   HEAP32[$1012>>2] = 1;
  }
  $1015 = ((($968)) + 36|0);
  HEAP32[$1015>>2] = 1;
  $1016 = ((($968)) + 48|0);
  HEAP32[$1016>>2] = 0;
  break;
 }
 case 4:  {
  $997 = ((($968)) + 28|0);
  $998 = HEAP32[$997>>2]|0;
  $999 = ($998|0)==(0);
  if ($999) {
   HEAP32[$997>>2] = 1;
  }
  $1000 = ((($968)) + 40|0);
  HEAP32[$1000>>2] = 0;
  $1001 = ((($968)) + 44|0);
  HEAP32[$1001>>2] = 0;
  $1002 = ((($968)) + 32|0);
  $1003 = HEAP32[$1002>>2]|0;
  $1004 = ($1003|0)==(-1);
  if ($1004) {
   HEAP32[$1002>>2] = 1;
  }
  $1005 = ((($968)) + 36|0);
  HEAP32[$1005>>2] = 1;
  $1006 = ((($968)) + 48|0);
  HEAP32[$1006>>2] = 0;
  break;
 }
 case 1:  {
  $1030 = ((($968)) + 28|0);
  $1031 = HEAP32[$1030>>2]|0;
  $1032 = ($1031|0)==(0);
  if ($1032) {
   HEAP32[$1030>>2] = 1;
  }
  $1033 = ((($968)) + 85096|0);
  $1034 = HEAP32[$1033>>2]|0;
  $1035 = ($1034|0)==(0);
  if ($1035) {
   HEAP32[$1033>>2] = 2;
  }
  $1036 = ((($968)) + 40|0);
  HEAP32[$1036>>2] = 2;
  $1037 = ((($968)) + 44|0);
  HEAP32[$1037>>2] = 1;
  $1038 = ((($968)) + 32|0);
  $1039 = HEAP32[$1038>>2]|0;
  $1040 = ($1039|0)==(-1);
  if ($1040) {
   HEAP32[$1038>>2] = 1;
  }
  $1041 = ((($968)) + 36|0);
  HEAP32[$1041>>2] = 1;
  $1042 = ((($968)) + 48|0);
  HEAP32[$1042>>2] = 0;
  break;
 }
 case 2:  {
  $1017 = ((($968)) + 28|0);
  $1018 = HEAP32[$1017>>2]|0;
  $1019 = ($1018|0)==(0);
  if ($1019) {
   HEAP32[$1017>>2] = 1;
  }
  $1020 = ((($968)) + 85096|0);
  $1021 = HEAP32[$1020>>2]|0;
  $1022 = ($1021|0)==(0);
  if ($1022) {
   HEAP32[$1020>>2] = 2;
  }
  $1023 = ((($968)) + 40|0);
  HEAP32[$1023>>2] = 1;
  $1024 = ((($968)) + 44|0);
  HEAP32[$1024>>2] = 1;
  $1025 = ((($968)) + 32|0);
  $1026 = HEAP32[$1025>>2]|0;
  $1027 = ($1026|0)==(-1);
  if ($1027) {
   HEAP32[$1025>>2] = 1;
  }
  $1028 = ((($968)) + 36|0);
  HEAP32[$1028>>2] = 1;
  $1029 = ((($968)) + 48|0);
  HEAP32[$1029>>2] = 0;
  break;
 }
 case 0:  {
  $1043 = ((($968)) + 28|0);
  $1044 = HEAP32[$1043>>2]|0;
  $1045 = ($1044|0)==(0);
  if ($1045) {
   HEAP32[$1043>>2] = 1;
  }
  $1046 = ((($968)) + 85096|0);
  $1047 = HEAP32[$1046>>2]|0;
  $1048 = ($1047|0)==(0);
  if ($1048) {
   HEAP32[$1046>>2] = 2;
  }
  $1049 = ((($968)) + 40|0);
  HEAP32[$1049>>2] = 2;
  $1050 = ((($968)) + 44|0);
  HEAP32[$1050>>2] = 1;
  $1051 = ((($968)) + 32|0);
  $1052 = HEAP32[$1051>>2]|0;
  $1053 = ($1052|0)==(-1);
  if ($1053) {
   HEAP32[$1051>>2] = 1;
  }
  $1054 = ((($968)) + 36|0);
  HEAP32[$1054>>2] = 1;
  $1055 = ((($968)) + 48|0);
  HEAP32[$1055>>2] = 1;
  break;
 }
 default: {
  $971 = ((($968)) + 28|0);
  HEAP32[$971>>2] = 0;
  $972 = ((($968)) + 36|0);
  ;HEAP32[$972>>2]=0|0;HEAP32[$972+4>>2]=0|0;HEAP32[$972+8>>2]=0|0;HEAP32[$972+12>>2]=0|0;
 }
 }
 do {
  if ((label|0) == 203) {
   $973 = ((($968)) + 28|0);
   HEAP32[$973>>2] = 0;
   $974 = ((($968)) + 36|0);
   $975 = ((($968)) + 48|0);
   ;HEAP32[$974>>2]=0|0;HEAP32[$974+4>>2]=0|0;HEAP32[$974+8>>2]=0|0;HEAP32[$974+12>>2]=0|0;
   $976 = HEAP32[$105>>2]|0;
   if (!((($976|0) == 4) | (($976|0) == 1))) {
    break;
   }
   HEAP32[$975>>2] = -1;
  }
 } while(0);
 $1056 = ((($gfp)) + 232|0);
 $1057 = HEAP32[$1056>>2]|0;
 $1058 = ($1057|0)<(0);
 $1059 = HEAP32[$68>>2]|0;
 $$30 = $1058 ? 3 : $1057;
 HEAP32[$1059>>2] = $$30;
 $1060 = ((($gfp)) + 236|0);
 $1061 = +HEAPF32[$1060>>2];
 $1062 = $1061;
 $1063 = $1062 * -0.10000000000000001;
 $1064 = (+Math_pow(10.0,(+$1063)));
 $1065 = $1064;
 $1066 = ((($1059)) + 4|0);
 HEAPF32[$1066>>2] = $1065;
 $1067 = ((($gfp)) + 240|0);
 $1068 = HEAP32[$1067>>2]|0;
 if ((($1068|0) == -1)) {
  HEAP32[$1067>>2] = 0;
  label = 248;
 } else if ((($1068|0) == 0)) {
  label = 248;
 } else {
  $1071 = $1068;
 }
 do {
  if ((label|0) == 248) {
   $1069 = HEAP32[$449>>2]|0;
   $switch = ($1069>>>0)<(2);
   if (!($switch)) {
    $1071 = 0;
    break;
   }
   HEAP32[$1067>>2] = 1;
   $1071 = 1;
  }
 } while(0);
 $1070 = ((($1)) + 184|0);
 HEAP32[$1070>>2] = $1071;
 $1072 = (_lame_get_quant_comp($gfp)|0);
 $1073 = ($1072|0)<(0);
 if ($1073) {
  (_lame_set_quant_comp($gfp,1)|0);
 }
 $1074 = (_lame_get_quant_comp_short($gfp)|0);
 $1075 = ($1074|0)<(0);
 if ($1075) {
  (_lame_set_quant_comp_short($gfp,0)|0);
 }
 $1076 = (+_lame_get_msfix($gfp));
 $1077 = $1076 < 0.0;
 if ($1077) {
  _lame_set_msfix($gfp,0.0);
 }
 $1078 = (_lame_get_exp_nspsytune($gfp)|0);
 $1079 = $1078 | 1;
 (_lame_set_exp_nspsytune($gfp,$1079)|0);
 $1080 = HEAP32[$836>>2]|0;
 $1081 = ($1080|0)<(0);
 if ($1081) {
  HEAP32[$836>>2] = 4;
  $1108 = 4;
 } else {
  $1108 = $1080;
 }
 $1082 = ((($gfp)) + 224|0);
 $1083 = +HEAPF32[$1082>>2];
 $1084 = $1083 < 0.0;
 $1085 = (HEAPF32[tempDoublePtr>>2]=$1083,HEAP32[tempDoublePtr>>2]|0);
 if ($1084) {
  HEAPF32[$1082>>2] = 4.0;
  $1106 = 1082130432;
 } else {
  $1106 = $1085;
 }
 $1086 = ((($gfp)) + 248|0);
 $1087 = +HEAPF32[$1086>>2];
 $1088 = $1087 < 0.0;
 $1089 = (HEAPF32[tempDoublePtr>>2]=$1087,HEAP32[tempDoublePtr>>2]|0);
 if ($1088) {
  HEAPF32[$1086>>2] = 0.0;
  $1094 = 0;
 } else {
  $1094 = $1089;
 }
 $1090 = ((($gfp)) + 244|0);
 $1091 = HEAP32[$1090>>2]|0;
 $1092 = ($1091|0)<(0);
 if ($1092) {
  HEAP32[$1090>>2] = 1;
  $1125 = 1;
 } else {
  $1125 = $1091;
 }
 $1093 = ((($1)) + 188|0);
 HEAP32[$1093>>2] = $1094;
 $1095 = ((($gfp)) + 252|0);
 $1096 = HEAP32[$1095>>2]|0;
 $1097 = ((($1)) + 192|0);
 HEAP32[$1097>>2] = $1096;
 $1098 = ((($gfp)) + 228|0);
 $1099 = +HEAPF32[$1098>>2];
 $1100 = -$1099;
 $1101 = ((($1)) + 196|0);
 HEAPF32[$1101>>2] = $1100;
 $1102 = $1099 * -0.10000000149011612;
 $1103 = (+Math_pow(10.0,(+$1102)));
 $1104 = ((($1)) + 200|0);
 HEAPF32[$1104>>2] = $1103;
 $1105 = ((($1)) + 204|0);
 HEAP32[$1105>>2] = $1106;
 $1107 = ((($1)) + 208|0);
 HEAP32[$1107>>2] = $1108;
 $1109 = ((($gfp)) + 208|0);
 $1110 = HEAP32[$1109>>2]|0;
 $1111 = ((($1)) + 212|0);
 HEAP32[$1111>>2] = $1110;
 $1112 = ((($gfp)) + 212|0);
 $1113 = HEAP32[$1112>>2]|0;
 $1114 = ((($1)) + 216|0);
 HEAP32[$1114>>2] = $1113;
 $1115 = ((($gfp)) + 216|0);
 $1116 = HEAP32[$1115>>2]|0;
 $1117 = ((($1)) + 220|0);
 HEAP32[$1117>>2] = $1116;
 $1118 = ((($gfp)) + 132|0);
 $1119 = HEAP32[$1118>>2]|0;
 $1120 = ((($1)) + 84|0);
 HEAP32[$1120>>2] = $1119;
 $1121 = ((($gfp)) + 136|0);
 $1122 = HEAP32[$1121>>2]|0;
 $1123 = ((($1)) + 88|0);
 HEAP32[$1123>>2] = $1122;
 $1124 = ((($1)) + 92|0);
 HEAP32[$1124>>2] = $1125;
 $1126 = ((($gfp)) + 148|0);
 $1127 = HEAP32[$1126>>2]|0;
 $1128 = $1127 & 2;
 $1129 = ((($1)) + 96|0);
 HEAP32[$1129>>2] = $1128;
 $1130 = $1127 >>> 2;
 $1131 = $1130 & 63;
 $1132 = (+($1131|0));
 $1133 = ((($1)) + 232|0);
 $1134 = !($1132 >= 32.0);
 $1135 = $1132 + -64.0;
 $storemerge4 = $1134 ? $1132 : $1135;
 $1136 = $storemerge4 * 0.25;
 HEAPF32[$1133>>2] = $1136;
 $1137 = $1127 >>> 8;
 $1138 = $1137 & 63;
 $1139 = (+($1138|0));
 $1140 = ((($1)) + 228|0);
 $1141 = !($1139 >= 32.0);
 $1142 = $1139 + -64.0;
 $storemerge3 = $1141 ? $1139 : $1142;
 $1143 = $storemerge3 * 0.25;
 HEAPF32[$1140>>2] = $1143;
 $1144 = $1127 >>> 14;
 $1145 = $1144 & 63;
 $1146 = (+($1145|0));
 $1147 = ((($1)) + 236|0);
 $1148 = !($1146 >= 32.0);
 $1149 = $1146 + -64.0;
 $storemerge2 = $1148 ? $1146 : $1149;
 $1150 = $storemerge2 * 0.25;
 HEAPF32[$1147>>2] = $1150;
 $1151 = $1127 >>> 20;
 $1152 = $1151 & 63;
 $1153 = (+($1152|0));
 $1154 = ((($1)) + 240|0);
 $1155 = !($1153 >= 32.0);
 $1156 = $1153 + -64.0;
 $storemerge1 = $1155 ? $1153 : $1156;
 $1157 = $storemerge1 + $storemerge2;
 $1158 = $1157 * 0.25;
 HEAPF32[$1154>>2] = $1158;
 $1159 = ((($gfp)) + 20|0);
 $1160 = +HEAPF32[$1159>>2];
 $1161 = ((($gfp)) + 24|0);
 $1162 = +HEAPF32[$1161>>2];
 $1163 = $1162 * $1160;
 $1164 = ((($gfp)) + 28|0);
 $1165 = +HEAPF32[$1164>>2];
 $1166 = $1165 * $1160;
 $1167 = HEAP32[$95>>2]|0;
 $1168 = ($1167|0)==(2);
 do {
  if ($1168) {
   $1169 = HEAP32[$142>>2]|0;
   $1170 = ($1169|0)==(1);
   if (!($1170)) {
    $m10$sroa$0$0 = $1163;$m10$sroa$22$0 = $1166;$m10$sroa$8$0 = 0.0;
    break;
   }
   $1171 = $1163 * 0.5;
   $1172 = $1166 * 0.5;
   $m10$sroa$0$0 = $1171;$m10$sroa$22$0 = 0.0;$m10$sroa$8$0 = $1172;
  } else {
   $m10$sroa$0$0 = $1163;$m10$sroa$22$0 = $1166;$m10$sroa$8$0 = 0.0;
  }
 } while(0);
 $1173 = ((($1)) + 264|0);
 HEAPF32[$1173>>2] = $m10$sroa$0$0;
 $1174 = ((($1)) + 268|0);
 HEAPF32[$1174>>2] = $m10$sroa$8$0;
 $1175 = ((($1)) + 272|0);
 HEAPF32[$1175>>2] = 0.0;
 $1176 = ((($1)) + 276|0);
 HEAPF32[$1176>>2] = $m10$sroa$22$0;
 $1177 = ((($1)) + 39832|0);
 HEAP32[$1177>>2] = 0;
 $1178 = ((($1)) + 39836|0);
 HEAP32[$1178>>2] = 0;
 $1179 = HEAP32[$946>>2]|0;
 $1180 = ($1179|0)==(0);
 if ($1180) {
  $1181 = HEAP32[$2>>2]|0;
  $1182 = ($1181*72000)|0;
  $1183 = (($1182) + 72000)|0;
  $1184 = HEAP32[$962>>2]|0;
  $1185 = Math_imul($1183, $1184)|0;
  $1186 = HEAP32[$414>>2]|0;
  $1187 = (($1185|0) % ($1186|0))&-1;
  HEAP32[$1177>>2] = $1187;
  HEAP32[$1178>>2] = $1187;
 }
 $1188 = HEAP32[$gfp>>2]|0;
 $1189 = ($1188|0)==(-487877);
 do {
  if ($1189) {
   $1190 = HEAP32[$0>>2]|0;
   $1191 = ($1190|0)==(0|0);
   if ($1191) {
    break;
   }
   $1192 = ((($1190)) + 84040|0);
   $1193 = ((($1190)) + 84748|0);
   HEAP32[$1193>>2] = 0;
   $1194 = ((($gfp)) + 68|0);
   $1195 = HEAP32[$1194>>2]|0;
   $1196 = ($1195|0)==(0);
   if (!($1196)) {
    (_id3tag_write_v2($gfp)|0);
   }
   $1197 = ((($1190)) + 85684|0);
   HEAPF32[$1197>>2] = 0.0;
   $1198 = ((($1190)) + 156|0);
   _memset(($1192|0),0,704)|0;
   $1199 = HEAP32[$1198>>2]|0;
   $1200 = ($1199|0)==(0);
   if ($1200) {
    break;
   }
   (_InitVbrTag($gfp)|0);
  }
 } while(0);
 _iteration_init($1);
 (_psymodel_init($gfp)|0);
 $1201 = ((($gfp)) + 124|0);
 $1202 = HEAP32[$1201>>2]|0;
 $1203 = (_get_max_frame_buffer_size_by_constraint($2,$1202)|0);
 $1204 = ((($1)) + 148|0);
 HEAP32[$1204>>2] = $1203;
 $$0 = 0;
 STACKTOP = sp;return ($$0|0);
}
function _lame_encode_buffer_ieee_float($gfp,$pcm_l,$pcm_r,$nsamples,$mp3buf,$mp3buf_size) {
 $gfp = $gfp|0;
 $pcm_l = $pcm_l|0;
 $pcm_r = $pcm_r|0;
 $nsamples = $nsamples|0;
 $mp3buf = $mp3buf|0;
 $mp3buf_size = $mp3buf_size|0;
 var $0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (_lame_encode_buffer_template($gfp,$pcm_l,$pcm_r,$nsamples,$mp3buf,$mp3buf_size,3,1,32767.0)|0);
 return ($0|0);
}
function _lame_encode_flush($gfp,$mp3buffer,$mp3buffer_size) {
 $gfp = $gfp|0;
 $mp3buffer = $mp3buffer|0;
 $mp3buffer_size = $mp3buffer_size|0;
 var $$ = 0, $$$ = 0, $$0 = 0, $$04$lcssa16 = 0, $$0411 = 0, $$1 = 0, $$2 = 0, $$3 = 0, $$5 = 0, $$6 = 0, $$lcssa = 0, $$lcssa24 = 0, $$lcssa25 = 0, $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0;
 var $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0.0, $22 = 0, $23 = 0, $24 = 0.0, $25 = 0.0, $26 = 0.0, $27 = 0.0, $28 = 0.0, $29 = 0, $3 = 0, $30 = 0, $31 = 0;
 var $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0.0, $45 = 0.0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0;
 var $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0;
 var $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $8 = 0, $9 = 0, $buffer = 0, $frames_left$09 = 0, $mp3count$0$lcssa17 = 0, $mp3count$010 = 0, $resample_ratio$0 = 0.0, $samples_to_encode$0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 4608|0;
 $buffer = sp;
 $0 = ($gfp|0)==(0|0);
 if ($0) {
  $$0 = -3;
  STACKTOP = sp;return ($$0|0);
 }
 $1 = HEAP32[$gfp>>2]|0;
 $2 = ($1|0)==(-487877);
 if (!($2)) {
  $$0 = -3;
  STACKTOP = sp;return ($$0|0);
 }
 $3 = ((($gfp)) + 288|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)==(0|0);
 if ($5) {
  $$0 = -3;
  STACKTOP = sp;return ($$0|0);
 }
 $6 = HEAP32[$4>>2]|0;
 $7 = ($6|0)==(-487877);
 if (!($7)) {
  $$0 = -3;
  STACKTOP = sp;return ($$0|0);
 }
 $8 = ((($4)) + 84032|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ($9|0)<(1);
 if ($10) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $11 = ((($4)) + 16|0);
 $12 = ((($4)) + 76|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = ($13*576)|0;
 $15 = (($14) + 752)|0;
 $16 = (($9) + -1152)|0;
 _memset(($buffer|0),0,4608)|0;
 $17 = (_isResamplingNecessary($11)|0);
 $18 = ($17|0)==(0);
 if ($18) {
  $resample_ratio$0 = 1.0;$samples_to_encode$0 = $16;
 } else {
  $19 = ((($4)) + 60|0);
  $20 = HEAP32[$19>>2]|0;
  $21 = (+($20|0));
  $22 = ((($4)) + 64|0);
  $23 = HEAP32[$22>>2]|0;
  $24 = (+($23|0));
  $25 = $21 / $24;
  $26 = 16.0 / $25;
  $27 = (+($16|0));
  $28 = $26 + $27;
  $29 = (~~(($28)));
  $resample_ratio$0 = $25;$samples_to_encode$0 = $29;
 }
 $30 = (($samples_to_encode$0|0) % ($14|0))&-1;
 $31 = (($14) - ($30))|0;
 $32 = ($31|0)<(576);
 $33 = $32 ? $14 : 0;
 $$5 = (($33) + ($31))|0;
 $34 = ((($4)) + 84764|0);
 HEAP32[$34>>2] = $$5;
 $35 = (($$5) + ($samples_to_encode$0))|0;
 $36 = (($35|0) / ($14|0))&-1;
 $37 = ($36|0)>(0);
 if ($37) {
  $38 = ((($4)) + 84748|0);
  $39 = ((($4)) + 84036|0);
  $40 = ($mp3buffer_size|0)==(0);
  $41 = ((($buffer)) + 2304|0);
  $$pre = HEAP32[$38>>2]|0;
  $$0411 = $mp3buffer;$54 = $$pre;$frames_left$09 = $36;$mp3count$010 = 0;
  while(1) {
   $42 = HEAP32[$39>>2]|0;
   $43 = (($15) - ($42))|0;
   $44 = (+($43|0));
   $45 = $44 * $resample_ratio$0;
   $46 = (~~(($45)));
   $47 = ($46|0)>(1152);
   $$ = $47 ? 1152 : $46;
   $48 = ($$|0)<(1);
   $$$ = $48 ? 1 : $$;
   $49 = (($mp3buffer_size) - ($mp3count$010))|0;
   $$1 = $40 ? 0 : $49;
   $50 = (_lame_encode_buffer_template($gfp,$buffer,$41,$$$,$$0411,$$1,0,1,1.0)|0);
   $51 = (($$0411) + ($50)|0);
   $52 = (($50) + ($mp3count$010))|0;
   $53 = HEAP32[$38>>2]|0;
   $55 = ($54|0)!=($53|0);
   $56 = $55&1;
   $57 = (($frames_left$09) - ($56))|0;
   $58 = ($57|0)>(0);
   $59 = ($50|0)>(-1);
   $60 = $58 & $59;
   if ($60) {
    $$0411 = $51;$54 = $53;$frames_left$09 = $57;$mp3count$010 = $52;
   } else {
    $$lcssa = $50;$$lcssa24 = $51;$$lcssa25 = $52;
    break;
   }
  }
  HEAP32[$8>>2] = 0;
  $61 = ($$lcssa|0)<(0);
  if ($61) {
   $$0 = $$lcssa;
   STACKTOP = sp;return ($$0|0);
  } else {
   $$04$lcssa16 = $$lcssa24;$mp3count$0$lcssa17 = $$lcssa25;
  }
 } else {
  HEAP32[$8>>2] = 0;
  $$04$lcssa16 = $mp3buffer;$mp3count$0$lcssa17 = 0;
 }
 $62 = (($mp3buffer_size) - ($mp3count$0$lcssa17))|0;
 $63 = ($mp3buffer_size|0)==(0);
 $$2 = $63 ? 0 : $62;
 _flush_bitstream($4);
 $64 = (_copy_buffer($4,$$04$lcssa16,$$2,1)|0);
 _save_gain_values($4);
 $65 = ($64|0)<(0);
 if ($65) {
  $$0 = $64;
  STACKTOP = sp;return ($$0|0);
 }
 $66 = (($64) + ($mp3count$0$lcssa17))|0;
 $67 = ((($gfp)) + 68|0);
 $68 = HEAP32[$67>>2]|0;
 $69 = ($68|0)==(0);
 if ($69) {
  $$0 = $66;
  STACKTOP = sp;return ($$0|0);
 }
 $70 = (($mp3buffer_size) - ($66))|0;
 $$3 = $63 ? 0 : $70;
 $71 = (($$04$lcssa16) + ($64)|0);
 (_id3tag_write_v1($gfp)|0);
 $72 = (_copy_buffer($4,$71,$$3,0)|0);
 $73 = ($72|0)<(0);
 $74 = $73 ? 0 : $66;
 $$6 = (($74) + ($72))|0;
 $$0 = $$6;
 STACKTOP = sp;return ($$0|0);
}
function _lame_close($gfp) {
 $gfp = $gfp|0;
 var $$ = 0, $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $ret$02 = 0, $ret$1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($gfp|0)==(0|0);
 if ($0) {
  $ret$1 = 0;
  return ($ret$1|0);
 }
 $1 = HEAP32[$gfp>>2]|0;
 $2 = ($1|0)==(-487877);
 if (!($2)) {
  $ret$1 = 0;
  return ($ret$1|0);
 }
 $3 = ((($gfp)) + 288|0);
 $4 = HEAP32[$3>>2]|0;
 HEAP32[$gfp>>2] = 0;
 $5 = ($4|0)==(0|0);
 if ($5) {
  $ret$02 = -3;
 } else {
  $6 = HEAP32[$4>>2]|0;
  $7 = ($6|0)==(-487877);
  $$ = $7 ? 0 : -3;
  HEAP32[$4>>2] = 0;
  _freegfc($4);
  HEAP32[$3>>2] = 0;
  $ret$02 = $$;
 }
 $8 = ((($gfp)) + 284|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ($9|0)==(0);
 if ($10) {
  $ret$1 = $ret$02;
  return ($ret$1|0);
 }
 _free($gfp);
 $ret$1 = $ret$02;
 return ($ret$1|0);
}
function _lame_init() {
 var $$0 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0;
 var $62 = 0, $63 = 0, $64 = 0, $65 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 _init_log_table();
 $0 = (_calloc(1,304)|0);
 $1 = ($0|0)==(0|0);
 if ($1) {
  $$0 = 0;
  return ($$0|0);
 }
 _memset(($0|0),0,304)|0;
 HEAP32[$0>>2] = -487877;
 $2 = (_calloc(1,85840)|0);
 $3 = ((($0)) + 288|0);
 HEAP32[$3>>2] = $2;
 $4 = ($2|0)==(0|0);
 if ($4) {
  _free($0);
  $$0 = 0;
  return ($$0|0);
 } else {
  $5 = ((($0)) + 124|0);
  HEAP32[$5>>2] = 2;
  $6 = ((($0)) + 48|0);
  HEAP32[$6>>2] = 4;
  $7 = ((($0)) + 108|0);
  HEAP32[$7>>2] = 1;
  $8 = ((($0)) + 12|0);
  HEAP32[$8>>2] = 44100;
  $9 = ((($0)) + 8|0);
  HEAP32[$9>>2] = 2;
  $10 = ((($0)) + 4|0);
  HEAP32[$10>>2] = -1;
  $11 = ((($0)) + 36|0);
  HEAP32[$11>>2] = 1;
  $12 = ((($0)) + 44|0);
  HEAP32[$12>>2] = -1;
  $13 = ((($0)) + 240|0);
  HEAP32[$13>>2] = -1;
  $14 = ((($0)) + 88|0);
  HEAP32[$14>>2] = -1;
  $15 = ((($0)) + 184|0);
  HEAP32[$15>>2] = 0;
  $16 = ((($0)) + 188|0);
  HEAP32[$16>>2] = 0;
  $17 = ((($0)) + 192|0);
  HEAP32[$17>>2] = -1;
  $18 = ((($0)) + 196|0);
  HEAP32[$18>>2] = -1;
  $19 = ((($0)) + 156|0);
  HEAP32[$19>>2] = 0;
  $20 = ((($0)) + 164|0);
  HEAP32[$20>>2] = 4;
  $21 = ((($0)) + 224|0);
  HEAPF32[$21>>2] = -1.0;
  $22 = ((($0)) + 168|0);
  HEAP32[$22>>2] = 128;
  $23 = ((($0)) + 172|0);
  HEAP32[$23>>2] = 0;
  $24 = ((($0)) + 176|0);
  HEAP32[$24>>2] = 0;
  $25 = ((($0)) + 180|0);
  HEAP32[$25>>2] = 0;
  $26 = ((($2)) + 112|0);
  HEAP32[$26>>2] = 1;
  $27 = ((($2)) + 116|0);
  HEAP32[$27>>2] = 13;
  $28 = ((($0)) + 132|0);
  HEAP32[$28>>2] = -1;
  $29 = ((($0)) + 136|0);
  HEAP32[$29>>2] = -1;
  $30 = ((($0)) + 252|0);
  HEAPF32[$30>>2] = -1.0;
  $31 = ((($2)) + 84920|0);
  HEAP32[$31>>2] = 180;
  $32 = ((($2)) + 84924|0);
  HEAP32[$32>>2] = 180;
  $33 = ((($2)) + 84928|0);
  HEAP32[$33>>2] = 4;
  $34 = ((($2)) + 84932|0);
  HEAP32[$34>>2] = 4;
  $35 = ((($2)) + 84908|0);
  HEAPF32[$35>>2] = 1.0;
  $36 = ((($0)) + 264|0);
  HEAPF32[$36>>2] = -1.0;
  $37 = ((($0)) + 268|0);
  HEAPF32[$37>>2] = -1.0;
  $38 = ((($0)) + 20|0);
  HEAPF32[$38>>2] = 1.0;
  $39 = ((($0)) + 24|0);
  HEAPF32[$39>>2] = 1.0;
  $40 = ((($0)) + 28|0);
  HEAPF32[$40>>2] = 1.0;
  $41 = ((($0)) + 232|0);
  HEAP32[$41>>2] = -1;
  $42 = ((($0)) + 220|0);
  HEAP32[$42>>2] = -1;
  $43 = ((($0)) + 236|0);
  HEAPF32[$43>>2] = 0.0;
  $44 = ((($0)) + 244|0);
  HEAP32[$44>>2] = -1;
  $45 = ((($0)) + 248|0);
  HEAPF32[$45>>2] = -1.0;
  $46 = ((($2)) + 84032|0);
  HEAP32[$46>>2] = 1728;
  $47 = ((($2)) + 84764|0);
  HEAP32[$47>>2] = 0;
  $48 = ((($2)) + 84036|0);
  HEAP32[$48>>2] = 528;
  $49 = ((($0)) + 60|0);
  HEAP32[$49>>2] = 0;
  $50 = ((($0)) + 64|0);
  HEAP32[$50>>2] = 0;
  $51 = ((($2)) + 136|0);
  HEAP32[$51>>2] = 0;
  $52 = ((($2)) + 128|0);
  HEAP32[$52>>2] = 0;
  $53 = ((($2)) + 132|0);
  HEAP32[$53>>2] = 0;
  $54 = ((($2)) + 85680|0);
  $55 = ((($2)) + 85688|0);
  HEAP32[$55>>2] = 0;
  $56 = ((($2)) + 85692|0);
  HEAP32[$56>>2] = 0;
  HEAPF32[$54>>2] = -1.0;
  $57 = ((($0)) + 292|0);
  HEAP32[$57>>2] = 1;
  $58 = ((($0)) + 296|0);
  HEAP32[$58>>2] = 1;
  $59 = ((($0)) + 300|0);
  HEAP32[$59>>2] = 1;
  $60 = ((($0)) + 152|0);
  HEAP32[$60>>2] = 0;
  $61 = ((($0)) + 68|0);
  HEAP32[$61>>2] = 1;
  $62 = ((($0)) + 276|0);
  HEAP32[$62>>2] = 2;
  $63 = ((($0)) + 280|0);
  HEAP32[$63>>2] = 2;
  $64 = ((($0)) + 272|0);
  HEAP32[$64>>2] = 2;
  $65 = ((($0)) + 284|0);
  HEAP32[$65>>2] = 1;
  $$0 = $0;
  return ($$0|0);
 }
 return (0)|0;
}
function _lame_encode_buffer_template($gfp,$buffer_l,$buffer_r,$nsamples,$mp3buf,$mp3buf_size,$pcm_type,$aa,$norm) {
 $gfp = $gfp|0;
 $buffer_l = $buffer_l|0;
 $buffer_r = $buffer_r|0;
 $nsamples = $nsamples|0;
 $mp3buf = $mp3buf|0;
 $mp3buf_size = $mp3buf_size|0;
 $pcm_type = $pcm_type|0;
 $aa = $aa|0;
 $norm = +$norm;
 var $$0 = 0, $$0$i3 = 0, $$01$i = 0, $$01$i$us = 0, $$01$ph$i = 0, $$01$ph$i$us = 0, $$02$ph$i = 0, $$02$ph$i$us = 0, $$idx$val$i = 0, $$in_buffer$sroa$4$0$i = 0, $$in_buffer$sroa$4$0$i$lcssa = 0, $$in_buffer$sroa$4$0$i$us = 0, $$in_buffer$sroa$4$0$i$us$lcssa = 0, $$lcssa = 0, $$lcssa46 = 0, $$lcssa48 = 0, $$lcssa49 = 0, $$phi$trans$insert = 0, $$pr15$i = 0, $$pre = 0;
 var $$pre$phi$iZ2D = 0, $$pre$phiZ2D = 0, $$pre18 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0;
 var $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0;
 var $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0;
 var $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0;
 var $98 = 0, $99 = 0, $ch$011$us$i = 0, $ch$011$us$i$us = 0, $exitcond = 0, $exitcond15 = 0, $exitcond16 = 0, $exitcond17 = 0, $i$010$us$i = 0, $i$010$us$i$us = 0, $in_buffer$sroa$0$0$i = 0, $in_buffer$sroa$0$0$i$us = 0, $in_buffer$sroa$0$0$ph$i = 0, $in_buffer$sroa$0$0$ph$i$us = 0, $in_buffer$sroa$4$0$i = 0, $in_buffer$sroa$4$0$i$us = 0, $in_buffer$sroa$4$0$ph$i = 0, $in_buffer$sroa$4$0$ph$i$us = 0, $in_buffer_ptr$i = 0, $mfbuf$i = 0;
 var $mp3size$0$ph$i = 0, $mp3size$0$ph$i$us = 0, $n_in$i = 0, $n_out$i = 0, $or$cond = 0, $or$cond$i = 0, $or$cond$i$us = 0, $vararg_buffer = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $vararg_buffer = sp;
 $mfbuf$i = sp + 24|0;
 $in_buffer_ptr$i = sp + 16|0;
 $n_in$i = sp + 8|0;
 $n_out$i = sp + 4|0;
 $0 = ($gfp|0)==(0|0);
 if ($0) {
  $$0 = -3;
  STACKTOP = sp;return ($$0|0);
 }
 $1 = HEAP32[$gfp>>2]|0;
 $2 = ($1|0)==(-487877);
 if (!($2)) {
  $$0 = -3;
  STACKTOP = sp;return ($$0|0);
 }
 $3 = ((($gfp)) + 288|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)==(0|0);
 if ($5) {
  $$0 = -3;
  STACKTOP = sp;return ($$0|0);
 }
 $6 = HEAP32[$4>>2]|0;
 $7 = ($6|0)==(-487877);
 if (!($7)) {
  $$0 = -3;
  STACKTOP = sp;return ($$0|0);
 }
 $8 = ($nsamples|0)==(0);
 if ($8) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $9 = ((($4)) + 52152|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)==(0|0);
 do {
  if ($11) {
   label = 10;
  } else {
   $12 = ((($4)) + 52148|0);
   $13 = HEAP32[$12>>2]|0;
   $14 = ($13|0)<($nsamples|0);
   if ($14) {
    _free($10);
    label = 10;
    break;
   } else {
    $$phi$trans$insert = ((($4)) + 52156|0);
    $$pre = HEAP32[$$phi$trans$insert>>2]|0;
    $$pr15$i = $10;$$pre$phiZ2D = $$phi$trans$insert;$22 = $$pre;
    label = 13;
    break;
   }
  }
 } while(0);
 if ((label|0) == 10) {
  $15 = ((($4)) + 52156|0);
  $16 = HEAP32[$15>>2]|0;
  $17 = ($16|0)==(0|0);
  if (!($17)) {
   _free($16);
  }
  $18 = (_calloc($nsamples,4)|0);
  HEAP32[$9>>2] = $18;
  $19 = (_calloc($nsamples,4)|0);
  HEAP32[$15>>2] = $19;
  $20 = ((($4)) + 52148|0);
  HEAP32[$20>>2] = $nsamples;
  $21 = ($18|0)==(0|0);
  if ($21) {
   $$pre$phi$iZ2D = $15;$24 = $19;
  } else {
   $$pr15$i = $18;$$pre$phiZ2D = $15;$22 = $19;
   label = 13;
  }
 }
 do {
  if ((label|0) == 13) {
   $23 = ($22|0)==(0|0);
   if ($23) {
    _free($$pr15$i);
    $$pre18 = HEAP32[$$pre$phiZ2D>>2]|0;
    $$pre$phi$iZ2D = $$pre$phiZ2D;$24 = $$pre18;
    break;
   }
   $27 = ((($4)) + 68|0);
   $28 = HEAP32[$27>>2]|0;
   $29 = ($28|0)>(1);
   $30 = ($buffer_l|0)==(0|0);
   do {
    if ($29) {
     $31 = ($buffer_r|0)==(0|0);
     $or$cond = $30 | $31;
     if ($or$cond) {
      $$0 = 0;
      STACKTOP = sp;return ($$0|0);
     } else {
      _lame_copy_inbuffer($4,$buffer_l,$buffer_r,$nsamples,$pcm_type,$aa,$norm);
      break;
     }
    } else {
     if ($30) {
      $$0 = 0;
      STACKTOP = sp;return ($$0|0);
     } else {
      _lame_copy_inbuffer($4,$buffer_l,$buffer_l,$nsamples,$pcm_type,$aa,$norm);
      break;
     }
    }
   } while(0);
   $32 = ((($4)) + 76|0);
   $33 = HEAP32[$32>>2]|0;
   $34 = ($33*576)|0;
   $35 = HEAP32[$4>>2]|0;
   $36 = ($35|0)==(-487877);
   L41: do {
    if ($36) {
     $37 = (_copy_buffer($4,$mp3buf,$mp3buf_size,0)|0);
     $38 = ($37|0)<(0);
     if ($38) {
      $$0$i3 = $37;
     } else {
      $39 = (($mp3buf) + ($37)|0);
      $40 = HEAP32[$9>>2]|0;
      $41 = HEAP32[$$pre$phiZ2D>>2]|0;
      $$idx$val$i = HEAP32[$32>>2]|0;
      $42 = ($$idx$val$i*576)|0;
      $43 = (($42) + 752)|0;
      $44 = ((($4)) + 52160|0);
      HEAP32[$mfbuf$i>>2] = $44;
      $45 = ((($4)) + 68096|0);
      $46 = ((($mfbuf$i)) + 4|0);
      HEAP32[$46>>2] = $45;
      $47 = ((($in_buffer_ptr$i)) + 4|0);
      $48 = ((($4)) + 128|0);
      $49 = ((($4)) + 72|0);
      $50 = ((($4)) + 84036|0);
      $51 = ((($4)) + 84032|0);
      $52 = ((($4)) + 136|0);
      $53 = ((($4)) + 85676|0);
      $54 = ($mp3buf_size|0)==(0);
      $55 = Math_imul($33, -576)|0;
      if ($54) {
       $$01$ph$i$us = $nsamples;$$02$ph$i$us = $39;$in_buffer$sroa$0$0$ph$i$us = $40;$in_buffer$sroa$4$0$ph$i$us = $41;$mp3size$0$ph$i$us = $37;
       L65: while(1) {
        $$01$i$us = $$01$ph$i$us;$in_buffer$sroa$0$0$i$us = $in_buffer$sroa$0$0$ph$i$us;$in_buffer$sroa$4$0$i$us = $in_buffer$sroa$4$0$ph$i$us;
        while(1) {
         $56 = ($$01$i$us|0)>(0);
         if (!($56)) {
          $$0$i3 = $mp3size$0$ph$i$us;
          break L41;
         }
         HEAP32[$n_in$i>>2] = 0;
         HEAP32[$n_out$i>>2] = 0;
         HEAP32[$in_buffer_ptr$i>>2] = $in_buffer$sroa$0$0$i$us;
         HEAP32[$47>>2] = $in_buffer$sroa$4$0$i$us;
         _fill_buffer($4,$mfbuf$i,$in_buffer_ptr$i,$$01$i$us,$n_in$i,$n_out$i);
         $57 = HEAP32[$48>>2]|0;
         $58 = ($57|0)==(0);
         if (!($58)) {
          $59 = HEAP32[$52>>2]|0;
          $60 = ($59|0)==(0);
          if ($60) {
           $61 = HEAP32[$53>>2]|0;
           $62 = HEAP32[$50>>2]|0;
           $63 = HEAP32[$mfbuf$i>>2]|0;
           $64 = (($63) + ($62<<2)|0);
           $65 = HEAP32[$46>>2]|0;
           $66 = (($65) + ($62<<2)|0);
           $67 = HEAP32[$n_out$i>>2]|0;
           $68 = HEAP32[$49>>2]|0;
           $69 = (_AnalyzeSamples(($61|0),($64|0),($66|0),($67|0),($68|0))|0);
           $70 = ($69|0)==(0);
           if ($70) {
            $$0$i3 = -6;
            break L41;
           }
          }
         }
         $71 = HEAP32[$n_in$i>>2]|0;
         $72 = (($$01$i$us) - ($71))|0;
         $73 = (($in_buffer$sroa$0$0$i$us) + ($71<<2)|0);
         $74 = HEAP32[$49>>2]|0;
         $75 = ($74|0)==(2);
         $76 = (($in_buffer$sroa$4$0$i$us) + ($71<<2)|0);
         $$in_buffer$sroa$4$0$i$us = $75 ? $76 : $in_buffer$sroa$4$0$i$us;
         $77 = HEAP32[$n_out$i>>2]|0;
         $78 = HEAP32[$50>>2]|0;
         $79 = (($78) + ($77))|0;
         HEAP32[$50>>2] = $79;
         $80 = HEAP32[$51>>2]|0;
         $81 = ($80|0)<(1);
         if ($81) {
          HEAP32[$51>>2] = 1728;
          $83 = 1728;
         } else {
          $83 = $80;
         }
         $82 = (($83) + ($77))|0;
         HEAP32[$51>>2] = $82;
         $84 = ($79|0)<($43|0);
         if ($84) {
          $$01$i$us = $72;$in_buffer$sroa$0$0$i$us = $73;$in_buffer$sroa$4$0$i$us = $$in_buffer$sroa$4$0$i$us;
         } else {
          $$in_buffer$sroa$4$0$i$us$lcssa = $$in_buffer$sroa$4$0$i$us;$$lcssa = $72;$$lcssa46 = $73;
          break;
         }
        }
        $85 = HEAP32[$mfbuf$i>>2]|0;
        $86 = HEAP32[$46>>2]|0;
        $87 = (_lame_encode_mp3_frame($4,$85,$86,$$02$ph$i$us,0)|0);
        $88 = ($87|0)<(0);
        if ($88) {
         $$0$i3 = $87;
         break L41;
        }
        $89 = (($$02$ph$i$us) + ($87)|0);
        $90 = (($87) + ($mp3size$0$ph$i$us))|0;
        $91 = HEAP32[$50>>2]|0;
        $92 = (($91) - ($34))|0;
        HEAP32[$50>>2] = $92;
        $93 = HEAP32[$51>>2]|0;
        $94 = (($93) - ($34))|0;
        HEAP32[$51>>2] = $94;
        $95 = HEAP32[$49>>2]|0;
        $96 = ($95|0)>(0);
        $97 = ($92|0)>(0);
        $or$cond$i$us = $97 & $96;
        if (!($or$cond$i$us)) {
         $$01$ph$i$us = $$lcssa;$$02$ph$i$us = $89;$in_buffer$sroa$0$0$ph$i$us = $$lcssa46;$in_buffer$sroa$4$0$ph$i$us = $$in_buffer$sroa$4$0$i$us$lcssa;$mp3size$0$ph$i$us = $90;
         continue;
        }
        $105 = (($55) + ($91))|0;
        $ch$011$us$i$us = 0;
        while(1) {
         $98 = (($mfbuf$i) + ($ch$011$us$i$us<<2)|0);
         $99 = HEAP32[$98>>2]|0;
         $i$010$us$i$us = 0;
         while(1) {
          $100 = (($i$010$us$i$us) + ($34))|0;
          $101 = (($99) + ($100<<2)|0);
          $102 = HEAP32[$101>>2]|0;
          $103 = (($99) + ($i$010$us$i$us<<2)|0);
          HEAP32[$103>>2] = $102;
          $104 = (($i$010$us$i$us) + 1)|0;
          $exitcond16 = ($104|0)==($105|0);
          if ($exitcond16) {
           break;
          } else {
           $i$010$us$i$us = $104;
          }
         }
         $106 = (($ch$011$us$i$us) + 1)|0;
         $exitcond17 = ($106|0)==($95|0);
         if ($exitcond17) {
          $$01$ph$i$us = $$lcssa;$$02$ph$i$us = $89;$in_buffer$sroa$0$0$ph$i$us = $$lcssa46;$in_buffer$sroa$4$0$ph$i$us = $$in_buffer$sroa$4$0$i$us$lcssa;$mp3size$0$ph$i$us = $90;
          continue L65;
         } else {
          $ch$011$us$i$us = $106;
         }
        }
       }
      } else {
       $$01$ph$i = $nsamples;$$02$ph$i = $39;$in_buffer$sroa$0$0$ph$i = $40;$in_buffer$sroa$4$0$ph$i = $41;$mp3size$0$ph$i = $37;
       L45: while(1) {
        $$01$i = $$01$ph$i;$in_buffer$sroa$0$0$i = $in_buffer$sroa$0$0$ph$i;$in_buffer$sroa$4$0$i = $in_buffer$sroa$4$0$ph$i;
        while(1) {
         $107 = ($$01$i|0)>(0);
         if (!($107)) {
          $$0$i3 = $mp3size$0$ph$i;
          break L41;
         }
         HEAP32[$n_in$i>>2] = 0;
         HEAP32[$n_out$i>>2] = 0;
         HEAP32[$in_buffer_ptr$i>>2] = $in_buffer$sroa$0$0$i;
         HEAP32[$47>>2] = $in_buffer$sroa$4$0$i;
         _fill_buffer($4,$mfbuf$i,$in_buffer_ptr$i,$$01$i,$n_in$i,$n_out$i);
         $108 = HEAP32[$48>>2]|0;
         $109 = ($108|0)==(0);
         if (!($109)) {
          $110 = HEAP32[$52>>2]|0;
          $111 = ($110|0)==(0);
          if ($111) {
           $112 = HEAP32[$53>>2]|0;
           $113 = HEAP32[$50>>2]|0;
           $114 = HEAP32[$mfbuf$i>>2]|0;
           $115 = (($114) + ($113<<2)|0);
           $116 = HEAP32[$46>>2]|0;
           $117 = (($116) + ($113<<2)|0);
           $118 = HEAP32[$n_out$i>>2]|0;
           $119 = HEAP32[$49>>2]|0;
           $120 = (_AnalyzeSamples(($112|0),($115|0),($117|0),($118|0),($119|0))|0);
           $121 = ($120|0)==(0);
           if ($121) {
            $$0$i3 = -6;
            break L41;
           }
          }
         }
         $122 = HEAP32[$n_in$i>>2]|0;
         $123 = (($$01$i) - ($122))|0;
         $124 = (($in_buffer$sroa$0$0$i) + ($122<<2)|0);
         $125 = HEAP32[$49>>2]|0;
         $126 = ($125|0)==(2);
         $127 = (($in_buffer$sroa$4$0$i) + ($122<<2)|0);
         $$in_buffer$sroa$4$0$i = $126 ? $127 : $in_buffer$sroa$4$0$i;
         $128 = HEAP32[$n_out$i>>2]|0;
         $129 = HEAP32[$50>>2]|0;
         $130 = (($129) + ($128))|0;
         HEAP32[$50>>2] = $130;
         $131 = HEAP32[$51>>2]|0;
         $132 = ($131|0)<(1);
         if ($132) {
          HEAP32[$51>>2] = 1728;
          $134 = 1728;
         } else {
          $134 = $131;
         }
         $133 = (($134) + ($128))|0;
         HEAP32[$51>>2] = $133;
         $135 = ($130|0)<($43|0);
         if ($135) {
          $$01$i = $123;$in_buffer$sroa$0$0$i = $124;$in_buffer$sroa$4$0$i = $$in_buffer$sroa$4$0$i;
         } else {
          $$in_buffer$sroa$4$0$i$lcssa = $$in_buffer$sroa$4$0$i;$$lcssa48 = $123;$$lcssa49 = $124;
          break;
         }
        }
        $136 = (($mp3buf_size) - ($mp3size$0$ph$i))|0;
        $137 = HEAP32[$mfbuf$i>>2]|0;
        $138 = HEAP32[$46>>2]|0;
        $139 = (_lame_encode_mp3_frame($4,$137,$138,$$02$ph$i,$136)|0);
        $140 = ($139|0)<(0);
        if ($140) {
         $$0$i3 = $139;
         break L41;
        }
        $141 = (($$02$ph$i) + ($139)|0);
        $142 = (($139) + ($mp3size$0$ph$i))|0;
        $143 = HEAP32[$50>>2]|0;
        $144 = (($143) - ($34))|0;
        HEAP32[$50>>2] = $144;
        $145 = HEAP32[$51>>2]|0;
        $146 = (($145) - ($34))|0;
        HEAP32[$51>>2] = $146;
        $147 = HEAP32[$49>>2]|0;
        $148 = ($147|0)>(0);
        $149 = ($144|0)>(0);
        $or$cond$i = $149 & $148;
        if (!($or$cond$i)) {
         $$01$ph$i = $$lcssa48;$$02$ph$i = $141;$in_buffer$sroa$0$0$ph$i = $$lcssa49;$in_buffer$sroa$4$0$ph$i = $$in_buffer$sroa$4$0$i$lcssa;$mp3size$0$ph$i = $142;
         continue;
        }
        $150 = (($55) + ($143))|0;
        $ch$011$us$i = 0;
        while(1) {
         $158 = (($mfbuf$i) + ($ch$011$us$i<<2)|0);
         $154 = HEAP32[$158>>2]|0;
         $i$010$us$i = 0;
         while(1) {
          $152 = (($i$010$us$i) + ($34))|0;
          $153 = (($154) + ($152<<2)|0);
          $155 = HEAP32[$153>>2]|0;
          $156 = (($154) + ($i$010$us$i<<2)|0);
          HEAP32[$156>>2] = $155;
          $157 = (($i$010$us$i) + 1)|0;
          $exitcond = ($157|0)==($150|0);
          if ($exitcond) {
           break;
          } else {
           $i$010$us$i = $157;
          }
         }
         $151 = (($ch$011$us$i) + 1)|0;
         $exitcond15 = ($151|0)==($147|0);
         if ($exitcond15) {
          $$01$ph$i = $$lcssa48;$$02$ph$i = $141;$in_buffer$sroa$0$0$ph$i = $$lcssa49;$in_buffer$sroa$4$0$ph$i = $$in_buffer$sroa$4$0$i$lcssa;$mp3size$0$ph$i = $142;
          continue L45;
         } else {
          $ch$011$us$i = $151;
         }
        }
       }
      }
     }
    } else {
     $$0$i3 = -3;
    }
   } while(0);
   $$0 = $$0$i3;
   STACKTOP = sp;return ($$0|0);
  }
 } while(0);
 $25 = ($24|0)==(0|0);
 if (!($25)) {
  _free($24);
 }
 HEAP32[$9>>2] = 0;
 HEAP32[$$pre$phi$iZ2D>>2] = 0;
 $26 = ((($4)) + 52148|0);
 HEAP32[$26>>2] = 0;
 _lame_errorf($4,7168,$vararg_buffer);
 $$0 = -2;
 STACKTOP = sp;return ($$0|0);
}
function _save_gain_values($gfc) {
 $gfc = $gfc|0;
 var $0 = 0, $1 = 0, $10 = 0.0, $11 = 0.0, $12 = 0.0, $13 = 0, $14 = 0, $15 = 0.0, $16 = 0.0, $17 = 0.0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0.0, $26 = 0.0;
 var $27 = 0.0, $28 = 0.0, $29 = 0.0, $3 = 0, $30 = 0.0, $31 = 0, $32 = 0, $33 = 0, $34 = 0.0, $35 = 0.0, $36 = 0.0, $37 = 0.0, $4 = 0, $5 = 0, $6 = 0.0, $7 = 0.0, $8 = 0, $9 = 0.0, $fabsf = 0.0, $fabsf1 = 0.0;
 var $floorf = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($gfc)) + 85680|0);
 $1 = ((($gfc)) + 128|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0);
 do {
  if (!($3)) {
   $4 = ((($gfc)) + 85676|0);
   $5 = HEAP32[$4>>2]|0;
   $6 = (+_GetTitleGain(($5|0)));
   $7 = $6;
   $fabsf = (+Math_abs((+$6)));
   $8 = $fabsf > 24601.0;
   $9 = $6 + 24601.0;
   $fabsf1 = (+Math_abs((+$9)));
   $10 = $fabsf1;
   if ($8) {
    $11 = $fabsf;
    $12 = $11 * 9.9999999747524271E-7;
    $13 = !($10 <= $12);
    if ($13) {
     label = 5;
    } else {
     label = 6;
    }
   } else {
    $14 = !($10 <= 0.024600999937888446);
    if ($14) {
     label = 5;
    } else {
     label = 6;
    }
   }
   if ((label|0) == 5) {
    $15 = $7 * 10.0;
    $16 = $15 + 0.5;
    $17 = (+Math_floor((+$16)));
    $18 = (~~(($17)));
    $19 = ((($gfc)) + 85688|0);
    HEAP32[$19>>2] = $18;
    break;
   }
   else if ((label|0) == 6) {
    $20 = ((($gfc)) + 85688|0);
    HEAP32[$20>>2] = 0;
    break;
   }
  }
 } while(0);
 $21 = ((($gfc)) + 132|0);
 $22 = HEAP32[$21>>2]|0;
 $23 = ($22|0)==(0);
 if ($23) {
  return;
 }
 $24 = ((($gfc)) + 85684|0);
 $25 = +HEAPF32[$24>>2];
 $26 = $25;
 $27 = $26 * 3.0518509475997192E-5;
 $28 = (+_log10($27));
 $29 = $28 * 200.0;
 $30 = (+Math_ceil((+$29)));
 $31 = (~~(($30)));
 $32 = ((($gfc)) + 85692|0);
 HEAP32[$32>>2] = $31;
 $33 = ($31|0)>(0);
 if ($33) {
  $34 = 3276700.0 / $25;
  $floorf = (+Math_floor((+$34)));
  $35 = $floorf;
  $36 = $35 * 0.01;
  $37 = $36;
  HEAPF32[$0>>2] = $37;
  return;
 } else {
  HEAPF32[$0>>2] = -1.0;
  return;
 }
}
function _lame_copy_inbuffer($gfc,$l,$r,$nsamples,$pcm_type,$jump,$s) {
 $gfc = $gfc|0;
 $l = $l|0;
 $r = $r|0;
 $nsamples = $nsamples|0;
 $pcm_type = $pcm_type|0;
 $jump = $jump|0;
 $s = +$s;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0.0, $13 = 0, $14 = 0.0, $15 = 0.0, $16 = 0, $17 = 0, $18 = 0.0, $19 = 0, $2 = 0, $20 = 0.0, $21 = 0.0, $22 = 0.0, $23 = 0.0, $24 = 0.0, $25 = 0.0, $26 = 0.0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0.0, $35 = 0, $36 = 0.0, $37 = 0.0, $38 = 0.0, $39 = 0.0, $4 = 0, $40 = 0.0, $41 = 0.0, $42 = 0.0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0.0, $50 = 0.0, $51 = 0, $52 = 0.0, $53 = 0.0, $54 = 0.0, $55 = 0.0, $56 = 0.0, $57 = 0.0, $58 = 0.0, $59 = 0, $6 = 0.0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0.0, $66 = 0.0, $67 = 0.0, $68 = 0.0, $69 = 0.0, $7 = 0, $70 = 0.0, $71 = 0.0, $72 = 0.0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0.0, $8 = 0.0, $80 = 0.0;
 var $81 = 0.0, $82 = 0.0, $83 = 0.0, $84 = 0.0, $85 = 0.0, $86 = 0.0, $87 = 0.0, $88 = 0.0, $89 = 0, $9 = 0.0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $bl$07 = 0, $bl1$010 = 0, $bl15$016 = 0, $bl22$020 = 0, $bl8$014 = 0, $br$06 = 0;
 var $br16$017 = 0, $br2$09 = 0, $br23$021 = 0, $br9$013 = 0, $exitcond = 0, $exitcond24 = 0, $exitcond25 = 0, $exitcond26 = 0, $exitcond27 = 0, $i$05 = 0, $i10$012 = 0, $i17$018 = 0, $i24$022 = 0, $i3$08 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($gfc)) + 52152|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($gfc)) + 52156|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($gfc)) + 264|0);
 $5 = +HEAPF32[$4>>2];
 $6 = $5 * $s;
 $7 = ((($gfc)) + 268|0);
 $8 = +HEAPF32[$7>>2];
 $9 = $8 * $s;
 $10 = ((($gfc)) + 272|0);
 $11 = +HEAPF32[$10>>2];
 $12 = $11 * $s;
 $13 = ((($gfc)) + 276|0);
 $14 = +HEAPF32[$13>>2];
 $15 = $14 * $s;
 switch ($pcm_type|0) {
 case 4:  {
  $78 = ($nsamples|0)>(0);
  if (!($78)) {
   return;
  }
  $bl22$020 = $l;$br23$021 = $r;$i24$022 = 0;
  while(1) {
   $79 = +HEAPF64[$bl22$020>>3];
   $80 = $79;
   $81 = +HEAPF64[$br23$021>>3];
   $82 = $81;
   $83 = $80 * $6;
   $84 = $82 * $9;
   $85 = $84 + $83;
   $86 = $80 * $12;
   $87 = $82 * $15;
   $88 = $87 + $86;
   $89 = (($1) + ($i24$022<<2)|0);
   HEAPF32[$89>>2] = $85;
   $90 = (($3) + ($i24$022<<2)|0);
   HEAPF32[$90>>2] = $88;
   $91 = (($bl22$020) + ($jump<<3)|0);
   $92 = (($br23$021) + ($jump<<3)|0);
   $93 = (($i24$022) + 1)|0;
   $exitcond27 = ($93|0)==($nsamples|0);
   if ($exitcond27) {
    break;
   } else {
    $bl22$020 = $91;$br23$021 = $92;$i24$022 = $93;
   }
  }
  return;
  break;
 }
 case 0:  {
  $16 = ($nsamples|0)>(0);
  if (!($16)) {
   return;
  }
  $bl$07 = $l;$br$06 = $r;$i$05 = 0;
  while(1) {
   $17 = HEAP16[$bl$07>>1]|0;
   $18 = (+($17<<16>>16));
   $19 = HEAP16[$br$06>>1]|0;
   $20 = (+($19<<16>>16));
   $21 = $18 * $6;
   $22 = $20 * $9;
   $23 = $22 + $21;
   $24 = $18 * $12;
   $25 = $20 * $15;
   $26 = $25 + $24;
   $27 = (($1) + ($i$05<<2)|0);
   HEAPF32[$27>>2] = $23;
   $28 = (($3) + ($i$05<<2)|0);
   HEAPF32[$28>>2] = $26;
   $29 = (($bl$07) + ($jump<<1)|0);
   $30 = (($br$06) + ($jump<<1)|0);
   $31 = (($i$05) + 1)|0;
   $exitcond = ($31|0)==($nsamples|0);
   if ($exitcond) {
    break;
   } else {
    $bl$07 = $29;$br$06 = $30;$i$05 = $31;
   }
  }
  return;
  break;
 }
 case 3:  {
  $64 = ($nsamples|0)>(0);
  if (!($64)) {
   return;
  }
  $bl15$016 = $l;$br16$017 = $r;$i17$018 = 0;
  while(1) {
   $65 = +HEAPF32[$bl15$016>>2];
   $66 = +HEAPF32[$br16$017>>2];
   $67 = $65 * $6;
   $68 = $66 * $9;
   $69 = $68 + $67;
   $70 = $65 * $12;
   $71 = $66 * $15;
   $72 = $71 + $70;
   $73 = (($1) + ($i17$018<<2)|0);
   HEAPF32[$73>>2] = $69;
   $74 = (($3) + ($i17$018<<2)|0);
   HEAPF32[$74>>2] = $72;
   $75 = (($bl15$016) + ($jump<<2)|0);
   $76 = (($br16$017) + ($jump<<2)|0);
   $77 = (($i17$018) + 1)|0;
   $exitcond26 = ($77|0)==($nsamples|0);
   if ($exitcond26) {
    break;
   } else {
    $bl15$016 = $75;$br16$017 = $76;$i17$018 = $77;
   }
  }
  return;
  break;
 }
 case 2:  {
  $48 = ($nsamples|0)>(0);
  if (!($48)) {
   return;
  }
  $bl8$014 = $l;$br9$013 = $r;$i10$012 = 0;
  while(1) {
   $49 = HEAP32[$bl8$014>>2]|0;
   $50 = (+($49|0));
   $51 = HEAP32[$br9$013>>2]|0;
   $52 = (+($51|0));
   $53 = $50 * $6;
   $54 = $52 * $9;
   $55 = $54 + $53;
   $56 = $50 * $12;
   $57 = $52 * $15;
   $58 = $57 + $56;
   $59 = (($1) + ($i10$012<<2)|0);
   HEAPF32[$59>>2] = $55;
   $60 = (($3) + ($i10$012<<2)|0);
   HEAPF32[$60>>2] = $58;
   $61 = (($bl8$014) + ($jump<<2)|0);
   $62 = (($br9$013) + ($jump<<2)|0);
   $63 = (($i10$012) + 1)|0;
   $exitcond25 = ($63|0)==($nsamples|0);
   if ($exitcond25) {
    break;
   } else {
    $bl8$014 = $61;$br9$013 = $62;$i10$012 = $63;
   }
  }
  return;
  break;
 }
 case 1:  {
  $32 = ($nsamples|0)>(0);
  if (!($32)) {
   return;
  }
  $bl1$010 = $l;$br2$09 = $r;$i3$08 = 0;
  while(1) {
   $33 = HEAP32[$bl1$010>>2]|0;
   $34 = (+($33|0));
   $35 = HEAP32[$br2$09>>2]|0;
   $36 = (+($35|0));
   $37 = $34 * $6;
   $38 = $36 * $9;
   $39 = $38 + $37;
   $40 = $34 * $12;
   $41 = $36 * $15;
   $42 = $41 + $40;
   $43 = (($1) + ($i3$08<<2)|0);
   HEAPF32[$43>>2] = $39;
   $44 = (($3) + ($i3$08<<2)|0);
   HEAPF32[$44>>2] = $42;
   $45 = (($bl1$010) + ($jump<<2)|0);
   $46 = (($br2$09) + ($jump<<2)|0);
   $47 = (($i3$08) + 1)|0;
   $exitcond24 = ($47|0)==($nsamples|0);
   if ($exitcond24) {
    break;
   } else {
    $bl1$010 = $45;$br2$09 = $46;$i3$08 = $47;
   }
  }
  return;
  break;
 }
 default: {
  return;
 }
 }
}
function _mdct_sub48($gfc,$w0,$w1) {
 $gfc = $gfc|0;
 $w0 = $w0|0;
 $w1 = $w1|0;
 var $$ = 0, $$02$i = 0, $$lcssa = 0, $$neg11$i = 0.0, $$neg13$i = 0.0, $$neg3$i = 0.0, $$sum = 0, $$sum10 = 0, $$sum11 = 0, $$sum12 = 0, $$sum13 = 0, $$sum14 = 0, $$sum15 = 0, $$sum18$1 = 0, $$sum18$10 = 0, $$sum18$11 = 0, $$sum18$12 = 0, $$sum18$13 = 0, $$sum18$14 = 0, $$sum18$15 = 0;
 var $$sum18$16 = 0, $$sum18$17 = 0, $$sum18$2 = 0, $$sum18$3 = 0, $$sum18$4 = 0, $$sum18$5 = 0, $$sum18$6 = 0, $$sum18$7 = 0, $$sum18$8 = 0, $$sum18$9 = 0, $$sum4 = 0, $$sum5 = 0, $$sum6 = 0, $$sum9 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0.0, $102 = 0.0;
 var $103 = 0.0, $104 = 0, $105 = 0.0, $106 = 0.0, $107 = 0.0, $108 = 0, $109 = 0.0, $11 = 0, $110 = 0.0, $111 = 0.0, $112 = 0, $113 = 0.0, $114 = 0.0, $115 = 0.0, $116 = 0, $117 = 0.0, $118 = 0.0, $119 = 0.0, $12 = 0, $120 = 0;
 var $121 = 0.0, $122 = 0.0, $123 = 0.0, $124 = 0, $125 = 0.0, $126 = 0.0, $127 = 0.0, $128 = 0, $129 = 0.0, $13 = 0, $130 = 0.0, $131 = 0.0, $132 = 0, $133 = 0.0, $134 = 0.0, $135 = 0.0, $136 = 0, $137 = 0.0, $138 = 0.0, $139 = 0.0;
 var $14 = 0, $140 = 0, $141 = 0.0, $142 = 0.0, $143 = 0.0, $144 = 0, $145 = 0.0, $146 = 0.0, $147 = 0.0, $148 = 0, $149 = 0.0, $15 = 0, $150 = 0.0, $151 = 0.0, $152 = 0, $153 = 0.0, $154 = 0.0, $155 = 0.0, $156 = 0, $157 = 0.0;
 var $158 = 0.0, $159 = 0.0, $16 = 0, $160 = 0, $161 = 0.0, $162 = 0.0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0.0, $169 = 0, $17 = 0, $170 = 0, $171 = 0.0, $172 = 0.0, $173 = 0, $174 = 0, $175 = 0;
 var $176 = 0.0, $177 = 0.0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0.0, $185 = 0.0, $186 = 0, $187 = 0.0, $188 = 0.0, $189 = 0, $19 = 0, $190 = 0, $191 = 0.0, $192 = 0.0, $193 = 0.0;
 var $194 = 0.0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0.0, $201 = 0.0, $202 = 0, $203 = 0, $204 = 0.0, $205 = 0.0, $206 = 0, $207 = 0, $208 = 0.0, $209 = 0.0, $21 = 0, $210 = 0.0;
 var $211 = 0.0, $212 = 0, $213 = 0, $214 = 0, $215 = 0.0, $216 = 0.0, $217 = 0, $218 = 0.0, $219 = 0.0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0.0, $225 = 0.0, $226 = 0, $227 = 0.0, $228 = 0.0, $229 = 0.0;
 var $23 = 0, $230 = 0.0, $231 = 0, $232 = 0.0, $233 = 0.0, $234 = 0.0, $235 = 0.0, $236 = 0.0, $237 = 0.0, $238 = 0.0, $239 = 0.0, $24 = 0, $240 = 0.0, $241 = 0.0, $242 = 0, $243 = 0.0, $244 = 0.0, $245 = 0, $246 = 0.0, $247 = 0.0;
 var $248 = 0.0, $249 = 0.0, $25 = 0, $250 = 0.0, $251 = 0.0, $252 = 0.0, $253 = 0.0, $254 = 0.0, $255 = 0.0, $256 = 0.0, $257 = 0.0, $258 = 0.0, $259 = 0.0, $26 = 0, $260 = 0.0, $261 = 0.0, $262 = 0.0, $263 = 0.0, $264 = 0.0, $265 = 0.0;
 var $266 = 0.0, $267 = 0.0, $268 = 0.0, $269 = 0.0, $27 = 0, $270 = 0.0, $271 = 0.0, $272 = 0.0, $273 = 0.0, $274 = 0.0, $275 = 0.0, $276 = 0.0, $277 = 0.0, $278 = 0.0, $279 = 0.0, $28 = 0, $280 = 0.0, $281 = 0.0, $282 = 0.0, $283 = 0.0;
 var $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0.0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0.0, $293 = 0.0, $294 = 0, $295 = 0, $296 = 0.0, $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0.0;
 var $301 = 0.0, $302 = 0.0, $303 = 0, $304 = 0.0, $305 = 0, $306 = 0.0, $307 = 0.0, $308 = 0, $309 = 0, $31 = 0, $310 = 0.0, $311 = 0, $312 = 0.0, $313 = 0.0, $314 = 0.0, $315 = 0, $316 = 0.0, $317 = 0.0, $318 = 0.0, $319 = 0;
 var $32 = 0.0, $320 = 0.0, $321 = 0.0, $322 = 0, $323 = 0, $324 = 0.0, $325 = 0.0, $326 = 0.0, $327 = 0.0, $328 = 0.0, $329 = 0.0, $33 = 0.0, $330 = 0.0, $331 = 0.0, $332 = 0.0, $333 = 0.0, $334 = 0.0, $335 = 0.0, $336 = 0.0, $337 = 0.0;
 var $338 = 0.0, $339 = 0.0, $34 = 0, $340 = 0.0, $341 = 0.0, $342 = 0.0, $343 = 0.0, $344 = 0.0, $345 = 0.0, $346 = 0.0, $347 = 0.0, $348 = 0.0, $349 = 0, $35 = 0.0, $350 = 0.0, $351 = 0.0, $352 = 0.0, $353 = 0.0, $354 = 0.0, $355 = 0.0;
 var $356 = 0.0, $357 = 0.0, $358 = 0, $359 = 0.0, $36 = 0.0, $360 = 0, $361 = 0.0, $362 = 0.0, $363 = 0.0, $364 = 0.0, $365 = 0.0, $366 = 0.0, $367 = 0.0, $368 = 0.0, $369 = 0.0, $37 = 0, $370 = 0.0, $371 = 0.0, $372 = 0.0, $373 = 0.0;
 var $374 = 0.0, $375 = 0.0, $376 = 0.0, $377 = 0.0, $378 = 0.0, $379 = 0.0, $38 = 0.0, $380 = 0.0, $381 = 0, $382 = 0.0, $383 = 0, $384 = 0.0, $385 = 0.0, $386 = 0.0, $387 = 0.0, $388 = 0.0, $389 = 0.0, $39 = 0.0, $390 = 0.0, $391 = 0.0;
 var $392 = 0.0, $393 = 0.0, $394 = 0.0, $395 = 0.0, $396 = 0.0, $397 = 0, $398 = 0.0, $399 = 0, $4 = 0, $40 = 0, $400 = 0.0, $401 = 0.0, $402 = 0.0, $403 = 0.0, $404 = 0.0, $405 = 0.0, $406 = 0.0, $407 = 0.0, $408 = 0.0, $409 = 0.0;
 var $41 = 0.0, $410 = 0.0, $411 = 0.0, $412 = 0.0, $413 = 0, $414 = 0.0, $415 = 0, $416 = 0.0, $417 = 0.0, $418 = 0.0, $419 = 0.0, $42 = 0.0, $420 = 0.0, $421 = 0.0, $422 = 0.0, $423 = 0.0, $424 = 0.0, $425 = 0.0, $426 = 0.0, $427 = 0.0;
 var $428 = 0.0, $429 = 0.0, $43 = 0, $430 = 0.0, $431 = 0.0, $432 = 0.0, $433 = 0.0, $434 = 0.0, $435 = 0.0, $436 = 0.0, $437 = 0.0, $438 = 0.0, $439 = 0.0, $44 = 0.0, $440 = 0.0, $441 = 0.0, $442 = 0.0, $443 = 0.0, $444 = 0.0, $445 = 0.0;
 var $446 = 0.0, $447 = 0.0, $448 = 0.0, $449 = 0, $45 = 0.0, $450 = 0.0, $451 = 0, $452 = 0.0, $453 = 0.0, $454 = 0.0, $455 = 0.0, $456 = 0.0, $457 = 0.0, $458 = 0.0, $459 = 0.0, $46 = 0, $460 = 0.0, $461 = 0.0, $462 = 0.0, $463 = 0.0;
 var $464 = 0.0, $465 = 0.0, $466 = 0.0, $467 = 0.0, $468 = 0.0, $469 = 0.0, $47 = 0.0, $470 = 0.0, $471 = 0.0, $472 = 0, $473 = 0.0, $474 = 0, $475 = 0.0, $476 = 0.0, $477 = 0.0, $478 = 0.0, $479 = 0.0, $48 = 0.0, $480 = 0.0, $481 = 0.0;
 var $482 = 0.0, $483 = 0.0, $484 = 0.0, $485 = 0.0, $486 = 0.0, $487 = 0.0, $488 = 0, $489 = 0.0, $49 = 0, $490 = 0, $491 = 0.0, $492 = 0.0, $493 = 0.0, $494 = 0.0, $495 = 0.0, $496 = 0.0, $497 = 0.0, $498 = 0.0, $499 = 0.0, $5 = 0;
 var $50 = 0.0, $500 = 0.0, $501 = 0.0, $502 = 0.0, $503 = 0.0, $504 = 0, $505 = 0.0, $506 = 0, $507 = 0, $508 = 0, $509 = 0, $51 = 0.0, $510 = 0.0, $511 = 0, $512 = 0.0, $513 = 0.0, $514 = 0, $515 = 0, $516 = 0.0, $517 = 0;
 var $518 = 0.0, $519 = 0.0, $52 = 0, $520 = 0.0, $521 = 0.0, $522 = 0.0, $523 = 0.0, $524 = 0, $525 = 0, $526 = 0, $527 = 0, $528 = 0, $529 = 0, $53 = 0.0, $530 = 0, $531 = 0, $532 = 0, $533 = 0, $534 = 0, $535 = 0;
 var $536 = 0, $54 = 0.0, $55 = 0, $56 = 0.0, $57 = 0.0, $58 = 0, $59 = 0.0, $6 = 0, $60 = 0.0, $61 = 0, $62 = 0.0, $63 = 0.0, $64 = 0, $65 = 0.0, $66 = 0.0, $67 = 0, $68 = 0.0, $69 = 0.0, $7 = 0, $70 = 0;
 var $71 = 0.0, $72 = 0.0, $73 = 0, $74 = 0.0, $75 = 0.0, $76 = 0, $77 = 0.0, $78 = 0.0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0.0, $89 = 0.0;
 var $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0.0, $94 = 0.0, $95 = 0.0, $96 = 0, $97 = 0.0, $98 = 0.0, $99 = 0.0, $band$156 = 0, $ch$060 = 0, $exitcond = 0, $exitcond$i = 0, $exitcond69 = 0, $exitcond70 = 0, $exitcond71 = 0, $gr$058 = 0, $k$049 = 0;
 var $k$252 = 0, $k$351 = 0, $k$453 = 0, $l$01$i = 0, $mdct_enc$054 = 0, $or$cond = 0, $or$cond3 = 0, $samp$047 = 0, $scevgep = 0, $w0$pn59 = 0, $wk$0 = 0, $wk$157 = 0, $wk$248 = 0, $work = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0;
 $work = sp;
 $0 = ((($gfc)) + 72|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)>(0);
 if (!($2)) {
  STACKTOP = sp;return;
 }
 $3 = ((($gfc)) + 76|0);
 $4 = ((($work)) + 68|0);
 $5 = ((($work)) + 36|0);
 $6 = ((($work)) + 60|0);
 $7 = ((($work)) + 44|0);
 $8 = ((($work)) + 56|0);
 $9 = ((($work)) + 48|0);
 $10 = ((($work)) + 32|0);
 $11 = ((($work)) + 4|0);
 $12 = ((($work)) + 28|0);
 $13 = ((($work)) + 8|0);
 $14 = ((($work)) + 24|0);
 $15 = ((($work)) + 12|0);
 $16 = ((($work)) + 20|0);
 $17 = ((($work)) + 16|0);
 $18 = ((($work)) + 64|0);
 $19 = ((($work)) + 40|0);
 $20 = ((($work)) + 52|0);
 $ch$060 = 0;$w0$pn59 = $w0;
 while(1) {
  $21 = HEAP32[$3>>2]|0;
  $22 = ($21|0)>(0);
  if ($22) {
   $wk$0 = ((($w0$pn59)) + 1144|0);
   $gr$058 = 0;$wk$157 = $wk$0;
   while(1) {
    $23 = (1 - ($gr$058))|0;
    $24 = ((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0);
    $k$049 = 0;$samp$047 = $24;$wk$248 = $wk$157;
    while(1) {
     _window_subband($wk$248,$samp$047);
     $28 = ((($wk$248)) + 128|0);
     $29 = ((($samp$047)) + 128|0);
     _window_subband($28,$29);
     $30 = ((($samp$047)) + 256|0);
     $31 = ((($samp$047)) + 132|0);
     $32 = +HEAPF32[$31>>2];
     $33 = -$32;
     HEAPF32[$31>>2] = $33;
     $34 = ((($samp$047)) + 140|0);
     $35 = +HEAPF32[$34>>2];
     $36 = -$35;
     HEAPF32[$34>>2] = $36;
     $37 = ((($samp$047)) + 148|0);
     $38 = +HEAPF32[$37>>2];
     $39 = -$38;
     HEAPF32[$37>>2] = $39;
     $40 = ((($samp$047)) + 156|0);
     $41 = +HEAPF32[$40>>2];
     $42 = -$41;
     HEAPF32[$40>>2] = $42;
     $43 = ((($samp$047)) + 164|0);
     $44 = +HEAPF32[$43>>2];
     $45 = -$44;
     HEAPF32[$43>>2] = $45;
     $46 = ((($samp$047)) + 172|0);
     $47 = +HEAPF32[$46>>2];
     $48 = -$47;
     HEAPF32[$46>>2] = $48;
     $49 = ((($samp$047)) + 180|0);
     $50 = +HEAPF32[$49>>2];
     $51 = -$50;
     HEAPF32[$49>>2] = $51;
     $52 = ((($samp$047)) + 188|0);
     $53 = +HEAPF32[$52>>2];
     $54 = -$53;
     HEAPF32[$52>>2] = $54;
     $55 = ((($samp$047)) + 196|0);
     $56 = +HEAPF32[$55>>2];
     $57 = -$56;
     HEAPF32[$55>>2] = $57;
     $58 = ((($samp$047)) + 204|0);
     $59 = +HEAPF32[$58>>2];
     $60 = -$59;
     HEAPF32[$58>>2] = $60;
     $61 = ((($samp$047)) + 212|0);
     $62 = +HEAPF32[$61>>2];
     $63 = -$62;
     HEAPF32[$61>>2] = $63;
     $64 = ((($samp$047)) + 220|0);
     $65 = +HEAPF32[$64>>2];
     $66 = -$65;
     HEAPF32[$64>>2] = $66;
     $67 = ((($samp$047)) + 228|0);
     $68 = +HEAPF32[$67>>2];
     $69 = -$68;
     HEAPF32[$67>>2] = $69;
     $70 = ((($samp$047)) + 236|0);
     $71 = +HEAPF32[$70>>2];
     $72 = -$71;
     HEAPF32[$70>>2] = $72;
     $73 = ((($samp$047)) + 244|0);
     $74 = +HEAPF32[$73>>2];
     $75 = -$74;
     HEAPF32[$73>>2] = $75;
     $76 = ((($samp$047)) + 252|0);
     $77 = +HEAPF32[$76>>2];
     $78 = -$77;
     HEAPF32[$76>>2] = $78;
     $79 = ((($wk$248)) + 256|0);
     $80 = (($k$049) + 1)|0;
     $exitcond = ($80|0)==(9);
     if ($exitcond) {
      break;
     } else {
      $k$049 = $80;$samp$047 = $30;$wk$248 = $79;
     }
    }
    $25 = ((((($gfc)) + 304|0) + (($gr$058*10504)|0)|0) + (($ch$060*5252)|0)|0);
    $26 = ((((((($gfc)) + 304|0) + (($gr$058*10504)|0)|0) + (($ch$060*5252)|0)|0)) + 4788|0);
    $27 = ((((((($gfc)) + 304|0) + (($gr$058*10504)|0)|0) + (($ch$060*5252)|0)|0)) + 4792|0);
    $band$156 = 0;$mdct_enc$054 = $25;
    while(1) {
     $81 = HEAP32[$26>>2]|0;
     $82 = (7208 + ($band$156<<2)|0);
     $83 = HEAP32[$82>>2]|0;
     $84 = HEAP32[$27>>2]|0;
     $85 = ($84|0)!=(0);
     $86 = ($band$156|0)<(2);
     $or$cond = $86 & $85;
     $$ = $or$cond ? 0 : $81;
     $87 = (((($gfc)) + 37040|0) + ($band$156<<2)|0);
     $88 = +HEAPF32[$87>>2];
     $89 = $88;
     $90 = $89 < 9.9999999999999998E-13;
     do {
      if ($90) {
       dest=$mdct_enc$054; stop=dest+72|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
      } else {
       $91 = $88 < 1.0;
       if ($91) {
        $92 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($83<<2)|0);
        $93 = +HEAPF32[$92>>2];
        $94 = $93 * $88;
        HEAPF32[$92>>2] = $94;
        $95 = +HEAPF32[$87>>2];
        $$sum18$1 = (($83) + 32)|0;
        $96 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$1<<2)|0);
        $97 = +HEAPF32[$96>>2];
        $98 = $97 * $95;
        HEAPF32[$96>>2] = $98;
        $99 = +HEAPF32[$87>>2];
        $$sum18$2 = (($83) + 64)|0;
        $100 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$2<<2)|0);
        $101 = +HEAPF32[$100>>2];
        $102 = $101 * $99;
        HEAPF32[$100>>2] = $102;
        $103 = +HEAPF32[$87>>2];
        $$sum18$3 = (($83) + 96)|0;
        $104 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$3<<2)|0);
        $105 = +HEAPF32[$104>>2];
        $106 = $105 * $103;
        HEAPF32[$104>>2] = $106;
        $107 = +HEAPF32[$87>>2];
        $$sum18$4 = (($83) + 128)|0;
        $108 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$4<<2)|0);
        $109 = +HEAPF32[$108>>2];
        $110 = $109 * $107;
        HEAPF32[$108>>2] = $110;
        $111 = +HEAPF32[$87>>2];
        $$sum18$5 = (($83) + 160)|0;
        $112 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$5<<2)|0);
        $113 = +HEAPF32[$112>>2];
        $114 = $113 * $111;
        HEAPF32[$112>>2] = $114;
        $115 = +HEAPF32[$87>>2];
        $$sum18$6 = (($83) + 192)|0;
        $116 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$6<<2)|0);
        $117 = +HEAPF32[$116>>2];
        $118 = $117 * $115;
        HEAPF32[$116>>2] = $118;
        $119 = +HEAPF32[$87>>2];
        $$sum18$7 = (($83) + 224)|0;
        $120 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$7<<2)|0);
        $121 = +HEAPF32[$120>>2];
        $122 = $121 * $119;
        HEAPF32[$120>>2] = $122;
        $123 = +HEAPF32[$87>>2];
        $$sum18$8 = (($83) + 256)|0;
        $124 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$8<<2)|0);
        $125 = +HEAPF32[$124>>2];
        $126 = $125 * $123;
        HEAPF32[$124>>2] = $126;
        $127 = +HEAPF32[$87>>2];
        $$sum18$9 = (($83) + 288)|0;
        $128 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$9<<2)|0);
        $129 = +HEAPF32[$128>>2];
        $130 = $129 * $127;
        HEAPF32[$128>>2] = $130;
        $131 = +HEAPF32[$87>>2];
        $$sum18$10 = (($83) + 320)|0;
        $132 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$10<<2)|0);
        $133 = +HEAPF32[$132>>2];
        $134 = $133 * $131;
        HEAPF32[$132>>2] = $134;
        $135 = +HEAPF32[$87>>2];
        $$sum18$11 = (($83) + 352)|0;
        $136 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$11<<2)|0);
        $137 = +HEAPF32[$136>>2];
        $138 = $137 * $135;
        HEAPF32[$136>>2] = $138;
        $139 = +HEAPF32[$87>>2];
        $$sum18$12 = (($83) + 384)|0;
        $140 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$12<<2)|0);
        $141 = +HEAPF32[$140>>2];
        $142 = $141 * $139;
        HEAPF32[$140>>2] = $142;
        $143 = +HEAPF32[$87>>2];
        $$sum18$13 = (($83) + 416)|0;
        $144 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$13<<2)|0);
        $145 = +HEAPF32[$144>>2];
        $146 = $145 * $143;
        HEAPF32[$144>>2] = $146;
        $147 = +HEAPF32[$87>>2];
        $$sum18$14 = (($83) + 448)|0;
        $148 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$14<<2)|0);
        $149 = +HEAPF32[$148>>2];
        $150 = $149 * $147;
        HEAPF32[$148>>2] = $150;
        $151 = +HEAPF32[$87>>2];
        $$sum18$15 = (($83) + 480)|0;
        $152 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$15<<2)|0);
        $153 = +HEAPF32[$152>>2];
        $154 = $153 * $151;
        HEAPF32[$152>>2] = $154;
        $155 = +HEAPF32[$87>>2];
        $$sum18$16 = (($83) + 512)|0;
        $156 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$16<<2)|0);
        $157 = +HEAPF32[$156>>2];
        $158 = $157 * $155;
        HEAPF32[$156>>2] = $158;
        $159 = +HEAPF32[$87>>2];
        $$sum18$17 = (($83) + 544)|0;
        $160 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum18$17<<2)|0);
        $161 = +HEAPF32[$160>>2];
        $162 = $161 * $159;
        HEAPF32[$160>>2] = $162;
       }
       $163 = ($$|0)==(2);
       if ($163) {
        $164 = (($83) + 288)|0;
        $165 = (($83) + 480)|0;
        $k$252 = -3;
        while(1) {
         $166 = (($k$252) + 3)|0;
         $167 = (7624 + ($166<<2)|0);
         $168 = +HEAPF32[$167>>2];
         $169 = $k$252 << 5;
         $$sum10 = (($164) + ($169))|0;
         $170 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($gr$058*2304)|0)|0) + ($$sum10<<2)|0);
         $171 = +HEAPF32[$170>>2];
         $172 = $171 * $168;
         $173 = (8 - ($k$252))|0;
         $174 = $173 << 5;
         $$sum11 = (($174) + ($83))|0;
         $175 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($gr$058*2304)|0)|0) + ($$sum11<<2)|0);
         $176 = +HEAPF32[$175>>2];
         $177 = $172 - $176;
         $178 = ($k$252*3)|0;
         $179 = (($178) + 9)|0;
         $180 = (($mdct_enc$054) + ($179<<2)|0);
         HEAPF32[$180>>2] = $177;
         $181 = (14 - ($k$252))|0;
         $182 = $181 << 5;
         $$sum12 = (($182) + ($83))|0;
         $183 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($gr$058*2304)|0)|0) + ($$sum12<<2)|0);
         $184 = +HEAPF32[$183>>2];
         $185 = $184 * $168;
         $$sum13 = (($165) + ($169))|0;
         $186 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($gr$058*2304)|0)|0) + ($$sum13<<2)|0);
         $187 = +HEAPF32[$186>>2];
         $188 = $185 + $187;
         $189 = (($178) + 18)|0;
         $190 = (($mdct_enc$054) + ($189<<2)|0);
         HEAPF32[$190>>2] = $188;
         $191 = +HEAPF32[$186>>2];
         $192 = $191 * $168;
         $193 = +HEAPF32[$183>>2];
         $194 = $192 - $193;
         $195 = (($178) + 10)|0;
         $196 = (($mdct_enc$054) + ($195<<2)|0);
         HEAPF32[$196>>2] = $194;
         $197 = (2 - ($k$252))|0;
         $198 = $197 << 5;
         $$sum14 = (($198) + ($83))|0;
         $199 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum14<<2)|0);
         $200 = +HEAPF32[$199>>2];
         $201 = $200 * $168;
         $202 = $166 << 5;
         $$sum15 = (($202) + ($83))|0;
         $203 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum15<<2)|0);
         $204 = +HEAPF32[$203>>2];
         $205 = $201 + $204;
         $206 = (($178) + 19)|0;
         $207 = (($mdct_enc$054) + ($206<<2)|0);
         HEAPF32[$207>>2] = $205;
         $208 = +HEAPF32[$203>>2];
         $209 = $208 * $168;
         $210 = +HEAPF32[$199>>2];
         $211 = $209 - $210;
         $212 = (($178) + 11)|0;
         $213 = (($mdct_enc$054) + ($212<<2)|0);
         HEAPF32[$213>>2] = $211;
         $214 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum11<<2)|0);
         $215 = +HEAPF32[$214>>2];
         $216 = $215 * $168;
         $217 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum10<<2)|0);
         $218 = +HEAPF32[$217>>2];
         $219 = $216 + $218;
         $220 = (($178) + 20)|0;
         $221 = (($mdct_enc$054) + ($220<<2)|0);
         HEAPF32[$221>>2] = $219;
         $222 = (($k$252) + 1)|0;
         $exitcond70 = ($222|0)==(0);
         if ($exitcond70) {
          $$02$i = $mdct_enc$054;$l$01$i = 0;
          break;
         } else {
          $k$252 = $222;
         }
        }
        while(1) {
         $223 = ((($$02$i)) + 24|0);
         $224 = +HEAPF32[$223>>2];
         $225 = $224 * 0.13165250420570374;
         $226 = ((($$02$i)) + 60|0);
         $227 = +HEAPF32[$226>>2];
         $228 = $225 - $227;
         $229 = +HEAPF32[$$02$i>>2];
         $230 = $229 * 0.76732701063156128;
         $231 = ((($$02$i)) + 36|0);
         $232 = +HEAPF32[$231>>2];
         $233 = $230 - $232;
         $234 = $233 + $228;
         $235 = $228 - $233;
         $236 = $227 * 0.13165250420570374;
         $237 = $236 + $224;
         $238 = $232 * 0.76732701063156128;
         $239 = $238 + $229;
         $240 = $239 + $237;
         $241 = $239 - $237;
         $242 = ((($$02$i)) + 12|0);
         $243 = +HEAPF32[$242>>2];
         $244 = $243 * 0.41421356797218323;
         $245 = ((($$02$i)) + 48|0);
         $246 = +HEAPF32[$245>>2];
         $247 = $244 - $246;
         $248 = $247;
         $249 = $248 * 2.0699781119530891E-11;
         $250 = $249;
         $251 = $246 * 0.41421356797218323;
         $252 = $251 + $243;
         $253 = $252;
         $254 = $253 * 2.0699781119530891E-11;
         $255 = $254;
         $256 = $234;
         $257 = $256 * 1.9075251917372799E-11;
         $258 = $250;
         $259 = $258 + $257;
         $260 = $259;
         HEAPF32[$$02$i>>2] = $260;
         $261 = -$240;
         $262 = $261;
         $263 = $262 * 1.9075251917372799E-11;
         $264 = $255;
         $265 = $264 + $263;
         $266 = $265;
         HEAPF32[$226>>2] = $266;
         $267 = $235;
         $268 = $267 * 1.6519652744032674E-11;
         $269 = $268;
         $270 = $240;
         $271 = $270 * 9.5376259586864042E-12;
         $272 = $264 + $271;
         $273 = $272;
         $274 = $269 - $273;
         HEAPF32[$242>>2] = $274;
         $275 = $273 + $269;
         HEAPF32[$223>>2] = $275;
         $276 = $256 * 9.5376259586864042E-12;
         $277 = $276 - $258;
         $278 = $277;
         $279 = $241;
         $280 = $279 * 1.6519652744032674E-11;
         $281 = $280;
         $282 = $278 + $281;
         HEAPF32[$231>>2] = $282;
         $283 = $278 - $281;
         HEAPF32[$245>>2] = $283;
         $284 = ((($$02$i)) + 4|0);
         $285 = (($l$01$i) + 1)|0;
         $exitcond$i = ($285|0)==(3);
         if ($exitcond$i) {
          break;
         } else {
          $$02$i = $284;$l$01$i = $285;
         }
        }
       } else {
        $k$351 = -9;
        while(1) {
         $286 = (($k$351) + 27)|0;
         $287 = ((7336 + (($$*144)|0)|0) + ($286<<2)|0);
         $288 = +HEAPF32[$287>>2];
         $289 = (($k$351) + 9)|0;
         $290 = $289 << 5;
         $$sum5 = (($290) + ($83))|0;
         $291 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum5<<2)|0);
         $292 = +HEAPF32[$291>>2];
         $293 = $292 * $288;
         $294 = (($k$351) + 36)|0;
         $295 = ((7336 + (($$*144)|0)|0) + ($294<<2)|0);
         $296 = +HEAPF32[$295>>2];
         $297 = (8 - ($k$351))|0;
         $298 = $297 << 5;
         $$sum6 = (($298) + ($83))|0;
         $299 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($23*2304)|0)|0) + ($$sum6<<2)|0);
         $300 = +HEAPF32[$299>>2];
         $301 = $300 * $296;
         $302 = $301 + $293;
         $303 = ((7336 + (($$*144)|0)|0) + ($289<<2)|0);
         $304 = +HEAPF32[$303>>2];
         $305 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($gr$058*2304)|0)|0) + ($$sum5<<2)|0);
         $306 = +HEAPF32[$305>>2];
         $307 = $306 * $304;
         $308 = (($k$351) + 18)|0;
         $309 = ((7336 + (($$*144)|0)|0) + ($308<<2)|0);
         $310 = +HEAPF32[$309>>2];
         $311 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0) + (($gr$058*2304)|0)|0) + ($$sum6<<2)|0);
         $312 = +HEAPF32[$311>>2];
         $313 = $312 * $310;
         $314 = $307 - $313;
         $$sum9 = (($k$351) + 12)|0;
         $315 = (7624 + ($$sum9<<2)|0);
         $316 = +HEAPF32[$315>>2];
         $317 = $314 * $316;
         $318 = $302 - $317;
         $319 = (($work) + ($289<<2)|0);
         HEAPF32[$319>>2] = $318;
         $320 = $316 * $302;
         $321 = $320 + $314;
         $322 = (($work) + ($308<<2)|0);
         HEAPF32[$322>>2] = $321;
         $323 = (($k$351) + 1)|0;
         $exitcond69 = ($323|0)==(0);
         if ($exitcond69) {
          break;
         } else {
          $k$351 = $323;
         }
        }
        $324 = +HEAPF32[$4>>2];
        $325 = +HEAPF32[$5>>2];
        $326 = $324 - $325;
        $327 = +HEAPF32[$6>>2];
        $328 = +HEAPF32[$7>>2];
        $329 = $327 - $328;
        $330 = +HEAPF32[$8>>2];
        $331 = +HEAPF32[$9>>2];
        $332 = $330 - $331;
        $333 = +HEAPF32[$work>>2];
        $334 = +HEAPF32[$10>>2];
        $335 = $334 + $333;
        $336 = +HEAPF32[$11>>2];
        $337 = +HEAPF32[$12>>2];
        $338 = $337 + $336;
        $339 = +HEAPF32[$13>>2];
        $340 = +HEAPF32[$14>>2];
        $341 = $340 + $339;
        $342 = +HEAPF32[$15>>2];
        $343 = +HEAPF32[$16>>2];
        $344 = $343 + $342;
        $345 = $341 + $335;
        $346 = $345 - $344;
        $347 = +HEAPF32[$17>>2];
        $$neg3$i = $347 - $338;
        $348 = $$neg3$i + $346;
        $349 = ((($mdct_enc$054)) + 68|0);
        HEAPF32[$349>>2] = $348;
        $350 = $346 * 0.5;
        $351 = +HEAPF32[$17>>2];
        $352 = $338 - $351;
        $353 = $350 + $352;
        $354 = $326 - $329;
        $355 = $354 - $332;
        $356 = $355 * 0.86602538824081421;
        $357 = $353 + $356;
        $358 = ((($mdct_enc$054)) + 20|0);
        HEAPF32[$358>>2] = $357;
        $359 = $356 - $353;
        $360 = ((($mdct_enc$054)) + 24|0);
        HEAPF32[$360>>2] = $359;
        $361 = +HEAPF32[$18>>2];
        $362 = +HEAPF32[$19>>2];
        $363 = $361 - $362;
        $364 = $363 * 0.86602538824081421;
        $365 = $338 * 0.5;
        $366 = +HEAPF32[$17>>2];
        $367 = $366 + $365;
        $368 = $326 * 0.98480772972106933;
        $369 = $329 * 0.6427876353263855;
        $370 = $332 * 0.34202015399932861;
        $371 = $369 + $368;
        $372 = $371 + $370;
        $373 = $372 + $364;
        $374 = $335 * 0.1736481785774231;
        $375 = $341 * 0.76604443788528442;
        $376 = $344 * 0.93969261646270751;
        $377 = $375 + $374;
        $378 = $377 + $376;
        $379 = $378 + $367;
        $380 = $373 + $379;
        $381 = ((($mdct_enc$054)) + 4|0);
        HEAPF32[$381>>2] = $380;
        $382 = $373 - $379;
        $383 = ((($mdct_enc$054)) + 8|0);
        HEAPF32[$383>>2] = $382;
        $384 = $326 * 0.6427876353263855;
        $385 = $329 * 0.34202015399932861;
        $386 = $332 * 0.98480772972106933;
        $387 = $384 - $385;
        $388 = $387 + $386;
        $389 = $388 - $364;
        $390 = $335 * 0.76604443788528442;
        $391 = $341 * 0.93969261646270751;
        $392 = $344 * 0.1736481785774231;
        $393 = $390 - $391;
        $394 = $393 - $392;
        $395 = $394 + $367;
        $396 = $389 + $395;
        $397 = ((($mdct_enc$054)) + 36|0);
        HEAPF32[$397>>2] = $396;
        $398 = $389 - $395;
        $399 = ((($mdct_enc$054)) + 40|0);
        HEAPF32[$399>>2] = $398;
        $400 = $326 * 0.34202015399932861;
        $401 = $329 * 0.98480772972106933;
        $402 = $332 * 0.6427876353263855;
        $403 = $401 + $400;
        $404 = $403 - $402;
        $405 = $404 - $364;
        $406 = $335 * 0.93969261646270751;
        $407 = $341 * 0.1736481785774231;
        $408 = $344 * 0.76604443788528442;
        $409 = $406 - $407;
        $410 = $409 + $408;
        $411 = $410 - $367;
        $412 = $411 + $405;
        $413 = ((($mdct_enc$054)) + 52|0);
        HEAPF32[$413>>2] = $412;
        $414 = $405 - $411;
        $415 = ((($mdct_enc$054)) + 56|0);
        HEAPF32[$415>>2] = $414;
        $416 = +HEAPF32[$10>>2];
        $417 = +HEAPF32[$work>>2];
        $418 = $416 - $417;
        $419 = +HEAPF32[$14>>2];
        $420 = +HEAPF32[$13>>2];
        $421 = $419 - $420;
        $422 = +HEAPF32[$16>>2];
        $423 = +HEAPF32[$15>>2];
        $424 = $422 - $423;
        $425 = +HEAPF32[$4>>2];
        $426 = +HEAPF32[$5>>2];
        $427 = $426 + $425;
        $428 = +HEAPF32[$18>>2];
        $429 = +HEAPF32[$19>>2];
        $430 = $429 + $428;
        $431 = +HEAPF32[$6>>2];
        $432 = +HEAPF32[$7>>2];
        $433 = $432 + $431;
        $434 = +HEAPF32[$8>>2];
        $435 = +HEAPF32[$9>>2];
        $436 = $435 + $434;
        $437 = $433 + $427;
        $438 = $437 + $436;
        $439 = +HEAPF32[$20>>2];
        $440 = $439 + $430;
        $441 = $440 + $438;
        HEAPF32[$mdct_enc$054>>2] = $441;
        $442 = $438 * 0.5;
        $443 = +HEAPF32[$20>>2];
        $$neg11$i = -$430;
        $$neg13$i = $$neg11$i - $443;
        $444 = $$neg13$i + $442;
        $445 = $418 - $421;
        $446 = $445 + $424;
        $447 = $446 * 0.86602538824081421;
        $448 = $444 + $447;
        $449 = ((($mdct_enc$054)) + 44|0);
        HEAPF32[$449>>2] = $448;
        $450 = $444 - $447;
        $451 = ((($mdct_enc$054)) + 48|0);
        HEAPF32[$451>>2] = $450;
        $452 = +HEAPF32[$12>>2];
        $453 = +HEAPF32[$11>>2];
        $454 = $452 - $453;
        $455 = $454 * 0.86602538824081421;
        $456 = +HEAPF32[$20>>2];
        $457 = $430 * 0.5;
        $458 = $456 - $457;
        $459 = $427 * 0.93969261646270751;
        $460 = $433 * 0.1736481785774231;
        $461 = $436 * 0.76604443788528442;
        $462 = $459 - $460;
        $463 = $462 - $461;
        $464 = $463 - $458;
        $465 = $418 * 0.34202015399932861;
        $466 = $421 * 0.98480772972106933;
        $467 = $424 * 0.6427876353263855;
        $468 = $466 + $465;
        $469 = $468 + $467;
        $470 = $469 + $455;
        $471 = $464 + $470;
        $472 = ((($mdct_enc$054)) + 12|0);
        HEAPF32[$472>>2] = $471;
        $473 = $464 - $470;
        $474 = ((($mdct_enc$054)) + 16|0);
        HEAPF32[$474>>2] = $473;
        $475 = $427 * 0.76604443788528442;
        $476 = $433 * 0.93969261646270751;
        $477 = $436 * 0.1736481785774231;
        $478 = $475 - $476;
        $479 = $478 + $477;
        $480 = $479 + $458;
        $481 = $418 * 0.6427876353263855;
        $482 = $421 * 0.34202015399932861;
        $483 = $424 * 0.98480772972106933;
        $484 = $481 - $482;
        $485 = $484 - $483;
        $486 = $485 + $455;
        $487 = $480 + $486;
        $488 = ((($mdct_enc$054)) + 28|0);
        HEAPF32[$488>>2] = $487;
        $489 = $480 - $486;
        $490 = ((($mdct_enc$054)) + 32|0);
        HEAPF32[$490>>2] = $489;
        $491 = $427 * 0.1736481785774231;
        $492 = $433 * 0.76604443788528442;
        $493 = $436 * 0.93969261646270751;
        $494 = $492 + $491;
        $495 = $494 - $493;
        $496 = $495 + $458;
        $497 = $418 * 0.98480772972106933;
        $498 = $421 * 0.6427876353263855;
        $499 = $424 * 0.34202015399932861;
        $500 = $498 + $497;
        $501 = $500 - $499;
        $502 = $501 - $455;
        $503 = $496 + $502;
        $504 = ((($mdct_enc$054)) + 60|0);
        HEAPF32[$504>>2] = $503;
        $505 = $496 - $502;
        $506 = ((($mdct_enc$054)) + 64|0);
        HEAPF32[$506>>2] = $505;
        break;
       }
      }
     } while(0);
     $507 = ($$|0)!=(2);
     $508 = ($band$156|0)!=(0);
     $or$cond3 = $508 & $507;
     if ($or$cond3) {
      $k$453 = 7;
      while(1) {
       $509 = (($mdct_enc$054) + ($k$453<<2)|0);
       $510 = +HEAPF32[$509>>2];
       $$sum = (($k$453) + 20)|0;
       $511 = (7624 + ($$sum<<2)|0);
       $512 = +HEAPF32[$511>>2];
       $513 = $512 * $510;
       $514 = $k$453 ^ -1;
       $515 = (($mdct_enc$054) + ($514<<2)|0);
       $516 = +HEAPF32[$515>>2];
       $$sum4 = (($k$453) + 28)|0;
       $517 = (7624 + ($$sum4<<2)|0);
       $518 = +HEAPF32[$517>>2];
       $519 = $518 * $516;
       $520 = $519 + $513;
       $521 = $518 * $510;
       $522 = $516 * $512;
       $523 = $521 - $522;
       HEAPF32[$515>>2] = $520;
       HEAPF32[$509>>2] = $523;
       $524 = (($k$453) + -1)|0;
       $525 = ($k$453|0)>(0);
       if ($525) {
        $k$453 = $524;
       } else {
        break;
       }
      }
     }
     $526 = (($band$156) + 1)|0;
     $527 = ((($mdct_enc$054)) + 72|0);
     $exitcond71 = ($526|0)==(32);
     if ($exitcond71) {
      break;
     } else {
      $band$156 = $526;$mdct_enc$054 = $527;
     }
    }
    $scevgep = ((($wk$157)) + 2304|0);
    $528 = (($gr$058) + 1)|0;
    $529 = HEAP32[$3>>2]|0;
    $530 = ($528|0)<($529|0);
    if ($530) {
     $gr$058 = $528;$wk$157 = $scevgep;
    } else {
     $$lcssa = $529;
     break;
    }
   }
   $531 = ($$lcssa|0)==(1);
   if ($531) {
    $532 = (((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0);
    $533 = (((((($gfc)) + 27824|0) + (($ch$060*4608)|0)|0)) + 2304|0);
    _memcpy(($532|0),($533|0),2304)|0;
   }
  }
  $534 = (($ch$060) + 1)|0;
  $535 = HEAP32[$0>>2]|0;
  $536 = ($534|0)<($535|0);
  if ($536) {
   $ch$060 = $534;$w0$pn59 = $w1;
  } else {
   break;
  }
 }
 STACKTOP = sp;return;
}
function _window_subband($x1,$a) {
 $x1 = $x1|0;
 $a = $a|0;
 var $$015 = 0, $0 = 0, $1 = 0, $10 = 0.0, $100 = 0, $101 = 0.0, $102 = 0.0, $103 = 0.0, $104 = 0, $105 = 0.0, $106 = 0.0, $107 = 0.0, $108 = 0, $109 = 0.0, $11 = 0, $110 = 0, $111 = 0.0, $112 = 0.0, $113 = 0.0, $114 = 0;
 var $115 = 0.0, $116 = 0.0, $117 = 0.0, $118 = 0, $119 = 0.0, $12 = 0.0, $120 = 0.0, $121 = 0.0, $122 = 0.0, $123 = 0.0, $124 = 0.0, $125 = 0.0, $126 = 0, $127 = 0.0, $128 = 0, $129 = 0.0, $13 = 0.0, $130 = 0.0, $131 = 0.0, $132 = 0;
 var $133 = 0.0, $134 = 0.0, $135 = 0.0, $136 = 0, $137 = 0.0, $138 = 0, $139 = 0.0, $14 = 0.0, $140 = 0.0, $141 = 0.0, $142 = 0, $143 = 0.0, $144 = 0.0, $145 = 0.0, $146 = 0, $147 = 0.0, $148 = 0, $149 = 0.0, $15 = 0, $150 = 0.0;
 var $151 = 0.0, $152 = 0, $153 = 0.0, $154 = 0.0, $155 = 0.0, $156 = 0, $157 = 0.0, $158 = 0.0, $159 = 0.0, $16 = 0.0, $160 = 0.0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0.0, $166 = 0.0, $167 = 0, $168 = 0, $169 = 0;
 var $17 = 0.0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0.0, $175 = 0.0, $176 = 0, $177 = 0.0, $178 = 0.0, $179 = 0, $18 = 0.0, $180 = 0.0, $181 = 0, $182 = 0.0, $183 = 0.0, $184 = 0.0, $185 = 0.0, $186 = 0, $187 = 0.0;
 var $188 = 0.0, $189 = 0.0, $19 = 0, $190 = 0, $191 = 0.0, $192 = 0, $193 = 0.0, $194 = 0.0, $195 = 0.0, $196 = 0.0, $197 = 0, $198 = 0.0, $199 = 0.0, $2 = 0.0, $20 = 0.0, $200 = 0.0, $201 = 0, $202 = 0.0, $203 = 0, $204 = 0.0;
 var $205 = 0.0, $206 = 0.0, $207 = 0.0, $208 = 0, $209 = 0.0, $21 = 0, $210 = 0.0, $211 = 0.0, $212 = 0, $213 = 0.0, $214 = 0, $215 = 0.0, $216 = 0.0, $217 = 0.0, $218 = 0.0, $219 = 0, $22 = 0.0, $220 = 0.0, $221 = 0.0, $222 = 0.0;
 var $223 = 0, $224 = 0.0, $225 = 0, $226 = 0.0, $227 = 0.0, $228 = 0.0, $229 = 0.0, $23 = 0.0, $230 = 0, $231 = 0.0, $232 = 0.0, $233 = 0.0, $234 = 0, $235 = 0.0, $236 = 0, $237 = 0.0, $238 = 0.0, $239 = 0.0, $24 = 0.0, $240 = 0.0;
 var $241 = 0, $242 = 0.0, $243 = 0.0, $244 = 0.0, $245 = 0, $246 = 0.0, $247 = 0, $248 = 0.0, $249 = 0.0, $25 = 0, $250 = 0.0, $251 = 0.0, $252 = 0, $253 = 0.0, $254 = 0.0, $255 = 0.0, $256 = 0.0, $257 = 0, $258 = 0.0, $259 = 0;
 var $26 = 0.0, $260 = 0.0, $261 = 0.0, $262 = 0.0, $263 = 0, $264 = 0.0, $265 = 0, $266 = 0.0, $267 = 0.0, $268 = 0, $269 = 0.0, $27 = 0.0, $270 = 0.0, $271 = 0.0, $272 = 0.0, $273 = 0.0, $274 = 0, $275 = 0.0, $276 = 0, $277 = 0.0;
 var $278 = 0.0, $279 = 0.0, $28 = 0.0, $280 = 0.0, $281 = 0, $282 = 0.0, $283 = 0, $284 = 0.0, $285 = 0.0, $286 = 0.0, $287 = 0.0, $288 = 0, $289 = 0.0, $29 = 0, $290 = 0, $291 = 0.0, $292 = 0.0, $293 = 0.0, $294 = 0.0, $295 = 0;
 var $296 = 0.0, $297 = 0, $298 = 0.0, $299 = 0.0, $3 = 0, $30 = 0.0, $300 = 0.0, $301 = 0.0, $302 = 0, $303 = 0.0, $304 = 0, $305 = 0.0, $306 = 0.0, $307 = 0.0, $308 = 0.0, $309 = 0, $31 = 0, $310 = 0.0, $311 = 0, $312 = 0.0;
 var $313 = 0.0, $314 = 0.0, $315 = 0.0, $316 = 0.0, $317 = 0.0, $318 = 0, $319 = 0.0, $32 = 0.0, $320 = 0, $321 = 0.0, $322 = 0.0, $323 = 0.0, $324 = 0.0, $325 = 0.0, $326 = 0.0, $327 = 0.0, $328 = 0.0, $329 = 0.0, $33 = 0.0, $330 = 0.0;
 var $331 = 0.0, $332 = 0.0, $333 = 0.0, $334 = 0.0, $335 = 0.0, $336 = 0.0, $337 = 0.0, $338 = 0.0, $339 = 0.0, $34 = 0.0, $340 = 0, $341 = 0.0, $342 = 0, $343 = 0.0, $344 = 0.0, $345 = 0.0, $346 = 0.0, $347 = 0, $348 = 0.0, $349 = 0;
 var $35 = 0, $350 = 0.0, $351 = 0.0, $352 = 0.0, $353 = 0.0, $354 = 0, $355 = 0.0, $356 = 0, $357 = 0.0, $358 = 0.0, $359 = 0.0, $36 = 0.0, $360 = 0.0, $361 = 0, $362 = 0.0, $363 = 0, $364 = 0.0, $365 = 0.0, $366 = 0.0, $367 = 0.0;
 var $368 = 0, $369 = 0.0, $37 = 0.0, $370 = 0, $371 = 0.0, $372 = 0.0, $373 = 0.0, $374 = 0.0, $375 = 0, $376 = 0.0, $377 = 0, $378 = 0.0, $379 = 0.0, $38 = 0.0, $380 = 0.0, $381 = 0.0, $382 = 0.0, $383 = 0.0, $384 = 0.0, $385 = 0.0;
 var $386 = 0.0, $387 = 0.0, $388 = 0.0, $389 = 0.0, $39 = 0, $390 = 0.0, $391 = 0.0, $392 = 0.0, $393 = 0.0, $394 = 0.0, $395 = 0.0, $396 = 0.0, $397 = 0.0, $398 = 0.0, $399 = 0.0, $4 = 0.0, $40 = 0.0, $400 = 0.0, $401 = 0.0, $402 = 0.0;
 var $403 = 0.0, $404 = 0.0, $405 = 0.0, $406 = 0.0, $407 = 0.0, $408 = 0.0, $409 = 0.0, $41 = 0, $410 = 0.0, $411 = 0.0, $412 = 0.0, $413 = 0.0, $414 = 0.0, $415 = 0.0, $416 = 0.0, $417 = 0.0, $418 = 0.0, $419 = 0.0, $42 = 0.0, $420 = 0.0;
 var $421 = 0.0, $422 = 0.0, $423 = 0.0, $424 = 0.0, $425 = 0.0, $426 = 0.0, $427 = 0.0, $428 = 0.0, $429 = 0.0, $43 = 0.0, $430 = 0.0, $431 = 0.0, $432 = 0.0, $433 = 0.0, $434 = 0.0, $435 = 0.0, $436 = 0.0, $437 = 0.0, $438 = 0.0, $439 = 0.0;
 var $44 = 0.0, $440 = 0.0, $441 = 0.0, $442 = 0.0, $443 = 0.0, $444 = 0.0, $445 = 0.0, $446 = 0.0, $447 = 0.0, $448 = 0.0, $449 = 0.0, $45 = 0, $450 = 0.0, $451 = 0.0, $452 = 0.0, $453 = 0.0, $454 = 0.0, $455 = 0.0, $456 = 0.0, $457 = 0.0;
 var $458 = 0.0, $459 = 0.0, $46 = 0.0, $460 = 0.0, $461 = 0.0, $462 = 0.0, $463 = 0.0, $464 = 0.0, $465 = 0.0, $466 = 0.0, $467 = 0.0, $468 = 0.0, $469 = 0.0, $47 = 0.0, $470 = 0.0, $471 = 0.0, $472 = 0.0, $473 = 0.0, $474 = 0.0, $475 = 0.0;
 var $476 = 0.0, $477 = 0.0, $478 = 0.0, $479 = 0.0, $48 = 0.0, $480 = 0.0, $481 = 0.0, $482 = 0.0, $483 = 0.0, $484 = 0.0, $485 = 0.0, $486 = 0.0, $487 = 0.0, $488 = 0.0, $489 = 0.0, $49 = 0, $490 = 0.0, $491 = 0.0, $492 = 0.0, $493 = 0.0;
 var $494 = 0.0, $495 = 0.0, $496 = 0.0, $497 = 0.0, $498 = 0.0, $499 = 0.0, $5 = 0.0, $50 = 0.0, $500 = 0.0, $501 = 0.0, $502 = 0.0, $503 = 0.0, $504 = 0.0, $505 = 0.0, $506 = 0.0, $507 = 0.0, $508 = 0.0, $509 = 0.0, $51 = 0, $510 = 0.0;
 var $511 = 0.0, $512 = 0.0, $513 = 0.0, $514 = 0.0, $515 = 0.0, $516 = 0.0, $517 = 0.0, $518 = 0.0, $519 = 0.0, $52 = 0.0, $520 = 0.0, $521 = 0.0, $522 = 0.0, $523 = 0.0, $524 = 0.0, $525 = 0.0, $526 = 0.0, $527 = 0.0, $528 = 0.0, $529 = 0.0;
 var $53 = 0.0, $530 = 0.0, $531 = 0.0, $532 = 0.0, $533 = 0.0, $534 = 0.0, $535 = 0.0, $536 = 0.0, $537 = 0.0, $538 = 0.0, $539 = 0.0, $54 = 0.0, $540 = 0.0, $541 = 0.0, $542 = 0.0, $543 = 0.0, $544 = 0.0, $545 = 0.0, $546 = 0.0, $547 = 0.0;
 var $548 = 0.0, $549 = 0.0, $55 = 0, $550 = 0.0, $551 = 0.0, $552 = 0.0, $553 = 0.0, $554 = 0.0, $555 = 0.0, $556 = 0.0, $557 = 0.0, $558 = 0.0, $559 = 0.0, $56 = 0.0, $560 = 0.0, $561 = 0.0, $562 = 0.0, $563 = 0.0, $564 = 0.0, $565 = 0.0;
 var $566 = 0.0, $567 = 0.0, $568 = 0.0, $569 = 0.0, $57 = 0.0, $570 = 0.0, $571 = 0.0, $572 = 0.0, $573 = 0.0, $574 = 0.0, $575 = 0.0, $576 = 0.0, $577 = 0.0, $578 = 0.0, $579 = 0.0, $58 = 0.0, $580 = 0.0, $581 = 0.0, $582 = 0.0, $583 = 0.0;
 var $584 = 0.0, $585 = 0.0, $586 = 0.0, $587 = 0.0, $588 = 0.0, $589 = 0.0, $59 = 0, $590 = 0.0, $591 = 0.0, $592 = 0.0, $593 = 0.0, $594 = 0.0, $595 = 0.0, $596 = 0.0, $597 = 0.0, $598 = 0.0, $599 = 0.0, $6 = 0, $60 = 0.0, $600 = 0.0;
 var $601 = 0.0, $602 = 0.0, $603 = 0.0, $604 = 0.0, $605 = 0.0, $606 = 0.0, $607 = 0.0, $608 = 0.0, $609 = 0.0, $61 = 0, $610 = 0.0, $611 = 0.0, $62 = 0.0, $63 = 0.0, $64 = 0.0, $65 = 0, $66 = 0.0, $67 = 0.0, $68 = 0.0, $69 = 0;
 var $7 = 0.0, $70 = 0.0, $71 = 0, $72 = 0.0, $73 = 0.0, $74 = 0.0, $75 = 0, $76 = 0.0, $77 = 0.0, $78 = 0.0, $79 = 0, $8 = 0.0, $80 = 0.0, $81 = 0, $82 = 0.0, $83 = 0.0, $84 = 0.0, $85 = 0, $86 = 0.0, $87 = 0.0;
 var $88 = 0.0, $89 = 0, $9 = 0, $90 = 0.0, $91 = 0, $92 = 0.0, $93 = 0.0, $94 = 0.0, $95 = 0, $96 = 0.0, $97 = 0.0, $98 = 0.0, $99 = 0.0, $exitcond = 0, $i$014 = 0, $wp$013 = 0, $x2$012 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($x1)) + -248|0);
 $$015 = $x1;$i$014 = -15;$wp$013 = (7952);$x2$012 = $0;
 while(1) {
  $1 = ((($wp$013)) + -40|0);
  $2 = +HEAPF32[$1>>2];
  $3 = ((($x2$012)) + -896|0);
  $4 = +HEAPF32[$3>>2];
  $5 = $4 * $2;
  $6 = ((($$015)) + 896|0);
  $7 = +HEAPF32[$6>>2];
  $8 = $7 * $2;
  $9 = ((($wp$013)) + -36|0);
  $10 = +HEAPF32[$9>>2];
  $11 = ((($x2$012)) + -640|0);
  $12 = +HEAPF32[$11>>2];
  $13 = $12 * $10;
  $14 = $13 + $5;
  $15 = ((($$015)) + 640|0);
  $16 = +HEAPF32[$15>>2];
  $17 = $16 * $10;
  $18 = $17 + $8;
  $19 = ((($wp$013)) + -32|0);
  $20 = +HEAPF32[$19>>2];
  $21 = ((($x2$012)) + -384|0);
  $22 = +HEAPF32[$21>>2];
  $23 = $22 * $20;
  $24 = $14 + $23;
  $25 = ((($$015)) + 384|0);
  $26 = +HEAPF32[$25>>2];
  $27 = $26 * $20;
  $28 = $18 + $27;
  $29 = ((($wp$013)) + -28|0);
  $30 = +HEAPF32[$29>>2];
  $31 = ((($x2$012)) + -128|0);
  $32 = +HEAPF32[$31>>2];
  $33 = $32 * $30;
  $34 = $24 + $33;
  $35 = ((($$015)) + 128|0);
  $36 = +HEAPF32[$35>>2];
  $37 = $36 * $30;
  $38 = $28 + $37;
  $39 = ((($wp$013)) + -24|0);
  $40 = +HEAPF32[$39>>2];
  $41 = ((($x2$012)) + 128|0);
  $42 = +HEAPF32[$41>>2];
  $43 = $42 * $40;
  $44 = $34 + $43;
  $45 = ((($$015)) + -128|0);
  $46 = +HEAPF32[$45>>2];
  $47 = $46 * $40;
  $48 = $38 + $47;
  $49 = ((($wp$013)) + -20|0);
  $50 = +HEAPF32[$49>>2];
  $51 = ((($x2$012)) + 384|0);
  $52 = +HEAPF32[$51>>2];
  $53 = $52 * $50;
  $54 = $44 + $53;
  $55 = ((($$015)) + -384|0);
  $56 = +HEAPF32[$55>>2];
  $57 = $56 * $50;
  $58 = $48 + $57;
  $59 = ((($wp$013)) + -16|0);
  $60 = +HEAPF32[$59>>2];
  $61 = ((($x2$012)) + 640|0);
  $62 = +HEAPF32[$61>>2];
  $63 = $62 * $60;
  $64 = $54 + $63;
  $65 = ((($$015)) + -640|0);
  $66 = +HEAPF32[$65>>2];
  $67 = $66 * $60;
  $68 = $58 + $67;
  $69 = ((($wp$013)) + -12|0);
  $70 = +HEAPF32[$69>>2];
  $71 = ((($x2$012)) + 896|0);
  $72 = +HEAPF32[$71>>2];
  $73 = $72 * $70;
  $74 = $64 + $73;
  $75 = ((($$015)) + -896|0);
  $76 = +HEAPF32[$75>>2];
  $77 = $76 * $70;
  $78 = $68 + $77;
  $79 = ((($wp$013)) + -8|0);
  $80 = +HEAPF32[$79>>2];
  $81 = ((($$015)) + -1024|0);
  $82 = +HEAPF32[$81>>2];
  $83 = $82 * $80;
  $84 = $74 + $83;
  $85 = ((($x2$012)) + 1024|0);
  $86 = +HEAPF32[$85>>2];
  $87 = $86 * $80;
  $88 = $78 - $87;
  $89 = ((($wp$013)) + -4|0);
  $90 = +HEAPF32[$89>>2];
  $91 = ((($$015)) + -768|0);
  $92 = +HEAPF32[$91>>2];
  $93 = $92 * $90;
  $94 = $84 + $93;
  $95 = ((($x2$012)) + 768|0);
  $96 = +HEAPF32[$95>>2];
  $97 = $96 * $90;
  $98 = $88 - $97;
  $99 = +HEAPF32[$wp$013>>2];
  $100 = ((($$015)) + -512|0);
  $101 = +HEAPF32[$100>>2];
  $102 = $101 * $99;
  $103 = $94 + $102;
  $104 = ((($x2$012)) + 512|0);
  $105 = +HEAPF32[$104>>2];
  $106 = $105 * $99;
  $107 = $98 - $106;
  $108 = ((($wp$013)) + 4|0);
  $109 = +HEAPF32[$108>>2];
  $110 = ((($$015)) + -256|0);
  $111 = +HEAPF32[$110>>2];
  $112 = $111 * $109;
  $113 = $103 + $112;
  $114 = ((($x2$012)) + 256|0);
  $115 = +HEAPF32[$114>>2];
  $116 = $115 * $109;
  $117 = $107 - $116;
  $118 = ((($wp$013)) + 8|0);
  $119 = +HEAPF32[$118>>2];
  $120 = +HEAPF32[$$015>>2];
  $121 = $120 * $119;
  $122 = $113 + $121;
  $123 = +HEAPF32[$x2$012>>2];
  $124 = $123 * $119;
  $125 = $117 - $124;
  $126 = ((($wp$013)) + 12|0);
  $127 = +HEAPF32[$126>>2];
  $128 = ((($$015)) + 256|0);
  $129 = +HEAPF32[$128>>2];
  $130 = $129 * $127;
  $131 = $122 + $130;
  $132 = ((($x2$012)) + -256|0);
  $133 = +HEAPF32[$132>>2];
  $134 = $133 * $127;
  $135 = $125 - $134;
  $136 = ((($wp$013)) + 16|0);
  $137 = +HEAPF32[$136>>2];
  $138 = ((($$015)) + 512|0);
  $139 = +HEAPF32[$138>>2];
  $140 = $139 * $137;
  $141 = $131 + $140;
  $142 = ((($x2$012)) + -512|0);
  $143 = +HEAPF32[$142>>2];
  $144 = $143 * $137;
  $145 = $135 - $144;
  $146 = ((($wp$013)) + 20|0);
  $147 = +HEAPF32[$146>>2];
  $148 = ((($$015)) + 768|0);
  $149 = +HEAPF32[$148>>2];
  $150 = $149 * $147;
  $151 = $141 + $150;
  $152 = ((($x2$012)) + -768|0);
  $153 = +HEAPF32[$152>>2];
  $154 = $153 * $147;
  $155 = $145 - $154;
  $156 = ((($wp$013)) + 24|0);
  $157 = +HEAPF32[$156>>2];
  $158 = $151 * $157;
  $159 = $155 - $158;
  $160 = $155 + $158;
  $161 = $i$014 << 1;
  $162 = (($161) + 30)|0;
  $163 = (($a) + ($162<<2)|0);
  HEAPF32[$163>>2] = $160;
  $164 = ((($wp$013)) + 28|0);
  $165 = +HEAPF32[$164>>2];
  $166 = $159 * $165;
  $167 = (($161) + 31)|0;
  $168 = (($a) + ($167<<2)|0);
  HEAPF32[$168>>2] = $166;
  $169 = ((($wp$013)) + 72|0);
  $170 = ((($$015)) + -4|0);
  $171 = ((($x2$012)) + 4|0);
  $172 = (($i$014) + 1)|0;
  $exitcond = ($172|0)==(0);
  if ($exitcond) {
   break;
  } else {
   $$015 = $170;$i$014 = $172;$wp$013 = $169;$x2$012 = $171;
  }
 }
 $173 = ((($x1)) + -124|0);
 $174 = +HEAPF32[$173>>2];
 $175 = $174 * 10612.802734375;
 $176 = ((($x1)) + -188|0);
 $177 = +HEAPF32[$176>>2];
 $178 = $177 * 12804.7978515625;
 $179 = ((($x1)) + -252|0);
 $180 = +HEAPF32[$179>>2];
 $181 = ((($x1)) + 4|0);
 $182 = +HEAPF32[$181>>2];
 $183 = $180 - $182;
 $184 = $183 * 5302.158203125;
 $185 = $184 + $175;
 $186 = ((($x1)) + -444|0);
 $187 = +HEAPF32[$186>>2];
 $188 = $187 * 1945.5516357421875;
 $189 = $188 + $178;
 $190 = ((($x1)) + -380|0);
 $191 = +HEAPF32[$190>>2];
 $192 = ((($x1)) + 132|0);
 $193 = +HEAPF32[$192>>2];
 $194 = $193 + $191;
 $195 = $194 * 929.77630615234375;
 $196 = $185 + $195;
 $197 = ((($x1)) + -700|0);
 $198 = +HEAPF32[$197>>2];
 $199 = $198 * 313.42449951171875;
 $200 = $189 + $199;
 $201 = ((($x1)) + -508|0);
 $202 = +HEAPF32[$201>>2];
 $203 = ((($x1)) + 260|0);
 $204 = +HEAPF32[$203>>2];
 $205 = $202 - $204;
 $206 = $205 * 728.80108642578125;
 $207 = $196 + $206;
 $208 = ((($x1)) + -956|0);
 $209 = +HEAPF32[$208>>2];
 $210 = $209 * 20.801593780517578;
 $211 = $200 + $210;
 $212 = ((($x1)) + -636|0);
 $213 = +HEAPF32[$212>>2];
 $214 = ((($x1)) + 388|0);
 $215 = +HEAPF32[$214>>2];
 $216 = $215 + $213;
 $217 = $216 * 288.09765625;
 $218 = $207 + $217;
 $219 = ((($x1)) + 68|0);
 $220 = +HEAPF32[$219>>2];
 $221 = $220 * 1995.1556396484375;
 $222 = $211 - $221;
 $223 = ((($x1)) + -764|0);
 $224 = +HEAPF32[$223>>2];
 $225 = ((($x1)) + 516|0);
 $226 = +HEAPF32[$225>>2];
 $227 = $224 - $226;
 $228 = $227 * 64.917388916015625;
 $229 = $218 + $228;
 $230 = ((($x1)) + 324|0);
 $231 = +HEAPF32[$230>>2];
 $232 = $231 * 9.0008392333984375;
 $233 = $222 - $232;
 $234 = ((($x1)) + -892|0);
 $235 = +HEAPF32[$234>>2];
 $236 = ((($x1)) + 644|0);
 $237 = +HEAPF32[$236>>2];
 $238 = $237 + $235;
 $239 = $238 * 30.125003814697266;
 $240 = $229 + $239;
 $241 = ((($x1)) + 580|0);
 $242 = +HEAPF32[$241>>2];
 $243 = $242 * -29.202180862426758;
 $244 = $233 - $243;
 $245 = ((($x1)) + -1020|0);
 $246 = +HEAPF32[$245>>2];
 $247 = ((($x1)) + 772|0);
 $248 = +HEAPF32[$247>>2];
 $249 = $246 - $248;
 $250 = $249 * 4.1014566421508789;
 $251 = $240 + $250;
 $252 = ((($x1)) + 836|0);
 $253 = +HEAPF32[$252>>2];
 $254 = $244 - $253;
 $255 = $254 - $251;
 $256 = $254 + $251;
 $257 = ((($a)) + 56|0);
 $258 = +HEAPF32[$257>>2];
 $259 = ((($a)) + 60|0);
 $260 = +HEAPF32[$259>>2];
 $261 = $260 - $258;
 $262 = $256 + $258;
 $263 = ((($a)) + 124|0);
 $264 = $261 + $255;
 $265 = ((($a)) + 120|0);
 $266 = $255 - $261;
 $267 = $256 - $258;
 $268 = ((($a)) + 112|0);
 $269 = +HEAPF32[$268>>2];
 $270 = +HEAPF32[$a>>2];
 $271 = $269 - $270;
 $272 = $270 + $269;
 HEAPF32[$a>>2] = $272;
 $273 = $271 * 1.9615705013275146;
 HEAPF32[$268>>2] = $273;
 $274 = ((($a)) + 116|0);
 $275 = +HEAPF32[$274>>2];
 $276 = ((($a)) + 4|0);
 $277 = +HEAPF32[$276>>2];
 $278 = $275 - $277;
 $279 = $277 + $275;
 HEAPF32[$276>>2] = $279;
 $280 = $278 * 1.9615705013275146;
 HEAPF32[$274>>2] = $280;
 $281 = ((($a)) + 104|0);
 $282 = +HEAPF32[$281>>2];
 $283 = ((($a)) + 8|0);
 $284 = +HEAPF32[$283>>2];
 $285 = $282 - $284;
 $286 = $284 + $282;
 HEAPF32[$283>>2] = $286;
 $287 = $285 * 1.8477590084075928;
 HEAPF32[$281>>2] = $287;
 $288 = ((($a)) + 108|0);
 $289 = +HEAPF32[$288>>2];
 $290 = ((($a)) + 12|0);
 $291 = +HEAPF32[$290>>2];
 $292 = $289 - $291;
 $293 = $291 + $289;
 HEAPF32[$290>>2] = $293;
 $294 = $292 * 1.8477590084075928;
 HEAPF32[$288>>2] = $294;
 $295 = ((($a)) + 96|0);
 $296 = +HEAPF32[$295>>2];
 $297 = ((($a)) + 16|0);
 $298 = +HEAPF32[$297>>2];
 $299 = $296 - $298;
 $300 = $298 + $296;
 HEAPF32[$297>>2] = $300;
 $301 = $299 * 1.662939190864563;
 HEAPF32[$295>>2] = $301;
 $302 = ((($a)) + 100|0);
 $303 = +HEAPF32[$302>>2];
 $304 = ((($a)) + 20|0);
 $305 = +HEAPF32[$304>>2];
 $306 = $303 - $305;
 $307 = $305 + $303;
 HEAPF32[$304>>2] = $307;
 $308 = $306 * 1.662939190864563;
 HEAPF32[$302>>2] = $308;
 $309 = ((($a)) + 88|0);
 $310 = +HEAPF32[$309>>2];
 $311 = ((($a)) + 24|0);
 $312 = +HEAPF32[$311>>2];
 $313 = $310 - $312;
 $314 = $312 + $310;
 $315 = $313;
 $316 = $315 * 1.4142135623730951;
 $317 = $316;
 $318 = ((($a)) + 92|0);
 $319 = +HEAPF32[$318>>2];
 $320 = ((($a)) + 28|0);
 $321 = +HEAPF32[$320>>2];
 $322 = $319 - $321;
 $323 = $321 + $319;
 $324 = $322;
 $325 = $324 * 1.4142135623730951;
 $326 = $323;
 $327 = $325 - $326;
 $328 = $327;
 $329 = $323 - $314;
 $330 = $317 - $329;
 $331 = $328 - $330;
 $332 = $262 - $314;
 HEAPF32[$311>>2] = $332;
 $333 = $262 + $314;
 HEAPF32[$263>>2] = $333;
 $334 = $264 - $329;
 HEAPF32[$320>>2] = $334;
 $335 = $264 + $329;
 HEAPF32[$265>>2] = $335;
 $336 = $266 - $330;
 HEAPF32[$309>>2] = $336;
 $337 = $266 + $330;
 HEAPF32[$259>>2] = $337;
 $338 = $267 - $331;
 HEAPF32[$318>>2] = $338;
 $339 = $267 + $331;
 HEAPF32[$257>>2] = $339;
 $340 = ((($a)) + 80|0);
 $341 = +HEAPF32[$340>>2];
 $342 = ((($a)) + 32|0);
 $343 = +HEAPF32[$342>>2];
 $344 = $341 - $343;
 $345 = $343 + $341;
 $346 = $344 * 1.1111404895782471;
 $347 = ((($a)) + 84|0);
 $348 = +HEAPF32[$347>>2];
 $349 = ((($a)) + 36|0);
 $350 = +HEAPF32[$349>>2];
 $351 = $348 - $350;
 $352 = $350 + $348;
 $353 = $351 * 1.1111404895782471;
 $354 = ((($a)) + 72|0);
 $355 = +HEAPF32[$354>>2];
 $356 = ((($a)) + 40|0);
 $357 = +HEAPF32[$356>>2];
 $358 = $355 - $357;
 $359 = $357 + $355;
 $360 = $358 * 0.76536685228347778;
 $361 = ((($a)) + 76|0);
 $362 = +HEAPF32[$361>>2];
 $363 = ((($a)) + 44|0);
 $364 = +HEAPF32[$363>>2];
 $365 = $362 - $364;
 $366 = $364 + $362;
 $367 = $365 * 0.76536685228347778;
 $368 = ((($a)) + 64|0);
 $369 = +HEAPF32[$368>>2];
 $370 = ((($a)) + 48|0);
 $371 = +HEAPF32[$370>>2];
 $372 = $369 - $371;
 $373 = $371 + $369;
 $374 = $372 * 0.39018064737319946;
 $375 = ((($a)) + 68|0);
 $376 = +HEAPF32[$375>>2];
 $377 = ((($a)) + 52|0);
 $378 = +HEAPF32[$377>>2];
 $379 = $376 - $378;
 $380 = $378 + $376;
 $381 = $379 * 0.39018064737319946;
 $382 = +HEAPF32[$295>>2];
 $383 = $382 - $346;
 $384 = $382 + $346;
 HEAPF32[$340>>2] = $384;
 $385 = $383 * 0.76536685228347778;
 HEAPF32[$295>>2] = $385;
 $386 = +HEAPF32[$302>>2];
 $387 = $386 - $353;
 $388 = $386 + $353;
 HEAPF32[$347>>2] = $388;
 $389 = $387 * 0.76536685228347778;
 HEAPF32[$302>>2] = $389;
 $390 = +HEAPF32[$297>>2];
 $391 = $390 - $345;
 $392 = $345 + $390;
 HEAPF32[$297>>2] = $392;
 $393 = $391 * 0.76536685228347778;
 HEAPF32[$342>>2] = $393;
 $394 = +HEAPF32[$304>>2];
 $395 = $394 - $352;
 $396 = $352 + $394;
 HEAPF32[$304>>2] = $396;
 $397 = $395 * 0.76536685228347778;
 HEAPF32[$349>>2] = $397;
 $398 = +HEAPF32[$a>>2];
 $399 = $398 - $373;
 $400 = $373 + $398;
 HEAPF32[$a>>2] = $400;
 $401 = $399 * 1.8477590084075928;
 HEAPF32[$370>>2] = $401;
 $402 = +HEAPF32[$276>>2];
 $403 = $402 - $380;
 $404 = $380 + $402;
 HEAPF32[$276>>2] = $404;
 $405 = $403 * 1.8477590084075928;
 HEAPF32[$377>>2] = $405;
 $406 = +HEAPF32[$268>>2];
 $407 = $374 - $406;
 $408 = $406 + $374;
 HEAPF32[$368>>2] = $408;
 $409 = $407 * 1.8477590084075928;
 HEAPF32[$268>>2] = $409;
 $410 = +HEAPF32[$274>>2];
 $411 = $410 - $381;
 $412 = $410 + $381;
 HEAPF32[$375>>2] = $412;
 $413 = $411 * 1.8477590084075928;
 HEAPF32[$274>>2] = $413;
 $414 = +HEAPF32[$283>>2];
 $415 = $414 - $359;
 $416 = $415;
 $417 = $416 * 1.4142135623730951;
 $418 = $417;
 $419 = $359 + $414;
 $420 = +HEAPF32[$290>>2];
 $421 = $420 - $366;
 $422 = $421;
 $423 = $422 * 1.4142135623730951;
 $424 = $423;
 $425 = $366 + $420;
 $426 = +HEAPF32[$281>>2];
 $427 = $426 - $360;
 $428 = $427;
 $429 = $428 * 1.4142135623730951;
 $430 = $429;
 $431 = $426 + $360;
 $432 = $430 - $431;
 $433 = +HEAPF32[$288>>2];
 $434 = $433 - $367;
 $435 = $434;
 $436 = $435 * 1.4142135623730951;
 $437 = $436;
 $438 = $433 + $367;
 $439 = $437 - $438;
 $440 = $438 - $425;
 $441 = $425 - $419;
 $442 = +HEAPF32[$263>>2];
 $443 = $442 - $419;
 HEAPF32[$283>>2] = $443;
 $444 = $442 + $419;
 HEAPF32[$263>>2] = $444;
 $445 = $424 - $440;
 $446 = $431 - $441;
 $447 = +HEAPF32[$265>>2];
 $448 = $447 - $441;
 HEAPF32[$290>>2] = $448;
 $449 = $447 + $441;
 HEAPF32[$265>>2] = $449;
 $450 = $439 - $445;
 $451 = $440 - $446;
 $452 = +HEAPF32[$259>>2];
 $453 = $452 - $446;
 HEAPF32[$354>>2] = $453;
 $454 = $452 + $446;
 HEAPF32[$259>>2] = $454;
 $455 = $418 - $451;
 $456 = +HEAPF32[$257>>2];
 $457 = $456 - $451;
 HEAPF32[$361>>2] = $457;
 $458 = $456 + $451;
 HEAPF32[$257>>2] = $458;
 $459 = $445 - $455;
 $460 = +HEAPF32[$318>>2];
 $461 = $460 - $455;
 HEAPF32[$356>>2] = $461;
 $462 = $460 + $455;
 HEAPF32[$318>>2] = $462;
 $463 = $432 - $459;
 $464 = +HEAPF32[$309>>2];
 $465 = $464 - $459;
 HEAPF32[$363>>2] = $465;
 $466 = $464 + $459;
 HEAPF32[$309>>2] = $466;
 $467 = $450 - $463;
 $468 = +HEAPF32[$320>>2];
 $469 = $468 - $463;
 HEAPF32[$281>>2] = $469;
 $470 = $468 + $463;
 HEAPF32[$320>>2] = $470;
 $471 = +HEAPF32[$311>>2];
 $472 = $471 - $467;
 HEAPF32[$288>>2] = $472;
 $473 = $471 + $467;
 HEAPF32[$311>>2] = $473;
 $474 = +HEAPF32[$a>>2];
 $475 = +HEAPF32[$297>>2];
 $476 = $474 - $475;
 $477 = $476;
 $478 = $477 * 1.4142135623730951;
 $479 = $478;
 $480 = $475 + $474;
 HEAPF32[$a>>2] = $480;
 HEAPF32[$297>>2] = $479;
 $481 = +HEAPF32[$276>>2];
 $482 = +HEAPF32[$304>>2];
 $483 = $481 - $482;
 $484 = $483;
 $485 = $484 * 1.4142135623730951;
 $486 = $485;
 $487 = $482 + $481;
 $488 = +HEAPF32[$368>>2];
 $489 = +HEAPF32[$340>>2];
 $490 = $488 - $489;
 $491 = $490;
 $492 = $491 * 1.4142135623730951;
 $493 = $492;
 $494 = $489 + $488;
 $495 = +HEAPF32[$375>>2];
 $496 = +HEAPF32[$347>>2];
 $497 = $495 - $496;
 $498 = $497;
 $499 = $498 * 1.4142135623730951;
 $500 = $499;
 $501 = $496 + $495;
 $502 = +HEAPF32[$342>>2];
 $503 = +HEAPF32[$370>>2];
 $504 = $502 - $503;
 $505 = $504;
 $506 = $505 * -1.4142135623730951;
 $507 = $506;
 $508 = $503 + $502;
 $509 = $507 - $508;
 $510 = +HEAPF32[$349>>2];
 $511 = +HEAPF32[$377>>2];
 $512 = $510 - $511;
 $513 = $512;
 $514 = $513 * -1.4142135623730951;
 $515 = $514;
 $516 = $511 + $510;
 $517 = $515 - $516;
 $518 = +HEAPF32[$302>>2];
 $519 = +HEAPF32[$274>>2];
 $520 = $518 - $519;
 $521 = $520;
 $522 = $521 * -1.4142135623730951;
 $523 = $522;
 $524 = $519 + $518;
 $525 = $523 - $524;
 $526 = +HEAPF32[$295>>2];
 $527 = +HEAPF32[$268>>2];
 $528 = $527 + $526;
 $529 = $528;
 $530 = $529 * -1.4142135623730951;
 $531 = $530;
 $532 = $526 - $527;
 $533 = $531 - $532;
 $534 = $532 - $494;
 $535 = $493 - $534;
 $536 = $533 - $535;
 $537 = $524 - $501;
 $538 = $500 - $537;
 $539 = $525 - $538;
 $540 = $501 - $487;
 $541 = $516 - $540;
 $542 = $537 - $541;
 $543 = $486 - $542;
 $544 = $538 - $543;
 $545 = $517 - $544;
 $546 = $539 - $545;
 $547 = $487 - $480;
 $548 = $494 - $547;
 $549 = $540 - $548;
 $550 = $508 - $549;
 $551 = $541 - $550;
 $552 = $534 - $551;
 $553 = $542 - $552;
 $554 = +HEAPF32[$297>>2];
 $555 = $554 - $553;
 $556 = $543 - $555;
 $557 = $535 - $556;
 $558 = $544 - $557;
 $559 = $509 - $558;
 $560 = $545 - $559;
 $561 = $536 - $560;
 $562 = $546 - $561;
 $563 = +HEAPF32[$a>>2];
 $564 = +HEAPF32[$263>>2];
 $565 = $564 + $563;
 HEAPF32[$a>>2] = $565;
 $566 = $564 - $563;
 HEAPF32[$263>>2] = $566;
 $567 = +HEAPF32[$265>>2];
 $568 = $567 + $547;
 HEAPF32[$276>>2] = $568;
 $569 = $567 - $547;
 HEAPF32[$265>>2] = $569;
 $570 = +HEAPF32[$259>>2];
 $571 = $570 + $548;
 HEAPF32[$368>>2] = $571;
 $572 = $570 - $548;
 HEAPF32[$259>>2] = $572;
 $573 = +HEAPF32[$257>>2];
 $574 = $573 + $549;
 HEAPF32[$375>>2] = $574;
 $575 = $573 - $549;
 HEAPF32[$257>>2] = $575;
 $576 = +HEAPF32[$318>>2];
 $577 = $576 + $550;
 HEAPF32[$342>>2] = $577;
 $578 = $576 - $550;
 HEAPF32[$318>>2] = $578;
 $579 = +HEAPF32[$309>>2];
 $580 = $579 + $551;
 HEAPF32[$349>>2] = $580;
 $581 = $579 - $551;
 HEAPF32[$309>>2] = $581;
 $582 = +HEAPF32[$320>>2];
 $583 = $582 + $552;
 HEAPF32[$295>>2] = $583;
 $584 = $582 - $552;
 HEAPF32[$320>>2] = $584;
 $585 = +HEAPF32[$311>>2];
 $586 = $585 + $553;
 HEAPF32[$302>>2] = $586;
 $587 = $585 - $553;
 HEAPF32[$311>>2] = $587;
 $588 = +HEAPF32[$288>>2];
 $589 = $588 + $555;
 HEAPF32[$297>>2] = $589;
 $590 = $588 - $555;
 HEAPF32[$288>>2] = $590;
 $591 = +HEAPF32[$281>>2];
 $592 = $591 + $556;
 HEAPF32[$304>>2] = $592;
 $593 = $591 - $556;
 HEAPF32[$281>>2] = $593;
 $594 = +HEAPF32[$363>>2];
 $595 = $594 + $557;
 HEAPF32[$340>>2] = $595;
 $596 = $594 - $557;
 HEAPF32[$363>>2] = $596;
 $597 = +HEAPF32[$356>>2];
 $598 = $597 + $558;
 HEAPF32[$347>>2] = $598;
 $599 = $597 - $558;
 HEAPF32[$356>>2] = $599;
 $600 = +HEAPF32[$361>>2];
 $601 = $600 + $559;
 HEAPF32[$370>>2] = $601;
 $602 = $600 - $559;
 HEAPF32[$361>>2] = $602;
 $603 = +HEAPF32[$354>>2];
 $604 = $603 + $560;
 HEAPF32[$377>>2] = $604;
 $605 = $603 - $560;
 HEAPF32[$354>>2] = $605;
 $606 = +HEAPF32[$290>>2];
 $607 = $606 + $561;
 HEAPF32[$268>>2] = $607;
 $608 = $606 - $561;
 HEAPF32[$290>>2] = $608;
 $609 = +HEAPF32[$283>>2];
 $610 = $609 + $562;
 HEAPF32[$274>>2] = $610;
 $611 = $609 - $562;
 HEAPF32[$283>>2] = $611;
 return;
}
function _apply_preset($gfp,$preset,$enforce) {
 $gfp = $gfp|0;
 $preset = $preset|0;
 $enforce = $enforce|0;
 var $$0 = 0, $$02$off = 0, $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 L1: do {
  switch ($preset|0) {
  case 1004: case 1001:  {
   (_lame_set_VBR($gfp,4)|0);
   $2 = ((($gfp)) + 152|0);
   HEAP32[$2>>2] = 480;
   label = 15;
   break;
  }
  case 1007: case 1006:  {
   (_lame_set_VBR($gfp,4)|0);
   $1 = ((($gfp)) + 152|0);
   HEAP32[$1>>2] = 460;
   label = 13;
   break;
  }
  case 1005: case 1002:  {
   (_lame_set_VBR($gfp,4)|0);
   $3 = ((($gfp)) + 152|0);
   HEAP32[$3>>2] = 500;
   label = 17;
   break;
  }
  case 1003:  {
   $4 = ((($gfp)) + 152|0);
   HEAP32[$4>>2] = 320;
   (_apply_abr_preset($gfp,320,$enforce)|0);
   (_lame_set_VBR($gfp,0)|0);
   $$0 = 320;
   return ($$0|0);
   break;
  }
  case 1000:  {
   (_lame_set_VBR($gfp,4)|0);
   $0 = ((($gfp)) + 152|0);
   HEAP32[$0>>2] = 470;
   label = 14;
   break;
  }
  default: {
   $5 = ((($gfp)) + 152|0);
   HEAP32[$5>>2] = $preset;
   switch ($preset|0) {
   case 490:  {
    _apply_vbr_preset($gfp,1,$enforce);
    $$0 = 490;
    return ($$0|0);
    break;
   }
   case 470:  {
    label = 14;
    break L1;
    break;
   }
   case 410:  {
    _apply_vbr_preset($gfp,9,$enforce);
    $$0 = 410;
    return ($$0|0);
    break;
   }
   case 450:  {
    _apply_vbr_preset($gfp,5,$enforce);
    $$0 = 450;
    return ($$0|0);
    break;
   }
   case 420:  {
    _apply_vbr_preset($gfp,8,$enforce);
    $$0 = 420;
    return ($$0|0);
    break;
   }
   case 500:  {
    label = 17;
    break L1;
    break;
   }
   case 440:  {
    _apply_vbr_preset($gfp,6,$enforce);
    $$0 = 440;
    return ($$0|0);
    break;
   }
   case 480:  {
    label = 15;
    break L1;
    break;
   }
   case 460:  {
    label = 13;
    break L1;
    break;
   }
   case 430:  {
    _apply_vbr_preset($gfp,7,$enforce);
    $$0 = 430;
    return ($$0|0);
    break;
   }
   default: {
    $$02$off = (($preset) + -8)|0;
    $6 = ($$02$off>>>0)<(313);
    if ($6) {
     $7 = (_apply_abr_preset($gfp,$preset,$enforce)|0);
     $$0 = $7;
     return ($$0|0);
    } else {
     HEAP32[$5>>2] = 0;
     $$0 = $preset;
     return ($$0|0);
    }
   }
   }
  }
  }
 } while(0);
 if ((label|0) == 13) {
  _apply_vbr_preset($gfp,4,$enforce);
  $$0 = 460;
  return ($$0|0);
 }
 else if ((label|0) == 14) {
  _apply_vbr_preset($gfp,3,$enforce);
  $$0 = 470;
  return ($$0|0);
 }
 else if ((label|0) == 15) {
  _apply_vbr_preset($gfp,2,$enforce);
  $$0 = 480;
  return ($$0|0);
 }
 else if ((label|0) == 17) {
  _apply_vbr_preset($gfp,0,$enforce);
  $$0 = 500;
  return ($$0|0);
 }
 return (0)|0;
}
function _apply_abr_preset($gfp,$preset,$enforce) {
 $gfp = $gfp|0;
 $preset = $preset|0;
 $enforce = $enforce|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0.0, $22 = 0.0, $23 = 0, $24 = 0, $25 = 0.0, $26 = 0.0;
 var $27 = 0.0, $28 = 0.0, $29 = 0, $3 = 0, $30 = 0, $31 = 0.0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0.0, $38 = 0.0, $39 = 0, $4 = 0, $40 = 0.0, $41 = 0, $42 = 0.0, $43 = 0.0, $44 = 0.0;
 var $45 = 0, $46 = 0, $47 = 0.0, $48 = 0.0, $49 = 0, $5 = 0, $50 = 0.0, $51 = 0.0, $52 = 0.0, $53 = 0, $54 = 0, $55 = 0.0, $56 = 0.0, $57 = 0, $58 = 0, $59 = 0.0, $6 = 0, $60 = 0.0, $61 = 0.0, $62 = 0.0;
 var $63 = 0.0, $64 = 0, $65 = 0, $66 = 0.0, $67 = 0.0, $68 = 0.0, $69 = 0, $7 = 0, $70 = 0, $71 = 0.0, $72 = 0, $73 = 0.0, $74 = 0.0, $75 = 0.0, $76 = 0.0, $77 = 0, $78 = 0.0, $79 = 0, $8 = 0, $80 = 0.0;
 var $81 = 0, $82 = 0.0, $83 = 0.0, $84 = 0.0, $85 = 0, $86 = 0, $87 = 0.0, $88 = 0, $89 = 0, $9 = 0, $90 = 0.0, $91 = 0.0, $92 = 0.0, $93 = 0, $94 = 0, $95 = 0, $a$$i = 0, $a$$i1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = $preset&65535;
 $1 = (_nearestBitrateFullIndex($0)|0);
 (_lame_set_VBR($gfp,3)|0);
 (_lame_set_VBR_mean_bitrate_kbps($gfp,$preset)|0);
 $2 = (_lame_get_VBR_mean_bitrate_kbps($gfp)|0);
 $3 = ($2|0)<(320);
 $a$$i = $3 ? $2 : 320;
 (_lame_set_VBR_mean_bitrate_kbps($gfp,$a$$i)|0);
 $4 = (_lame_get_VBR_mean_bitrate_kbps($gfp)|0);
 $5 = ($4|0)>(8);
 $a$$i1 = $5 ? $4 : 8;
 (_lame_set_VBR_mean_bitrate_kbps($gfp,$a$$i1)|0);
 $6 = (_lame_get_VBR_mean_bitrate_kbps($gfp)|0);
 (_lame_set_brate($gfp,$6)|0);
 $7 = (($1) + -12)|0;
 $8 = ($7>>>0)<(5);
 if ($8) {
  $9 = (_lame_get_exp_nspsytune($gfp)|0);
  $10 = $9 | 2;
  (_lame_set_exp_nspsytune($gfp,$10)|0);
 }
 $11 = ($1>>>0)<(13);
 if ($11) {
  (_lame_set_sfscale($gfp,1)|0);
 }
 $12 = ($enforce|0)!=(0);
 if ($12) {
  $32 = (((10560 + (($1*52)|0)|0)) + 4|0);
  $33 = HEAP32[$32>>2]|0;
  (_lame_set_quant_comp($gfp,$33)|0);
  $34 = (((10560 + (($1*52)|0)|0)) + 8|0);
  $35 = HEAP32[$34>>2]|0;
  (_lame_set_quant_comp_short($gfp,$35)|0);
  $36 = (((10560 + (($1*52)|0)|0)) + 16|0);
  $37 = +HEAPF32[$36>>2];
  $38 = $37;
  _lame_set_msfix($gfp,$38);
  $39 = (((10560 + (($1*52)|0)|0)) + 20|0);
  $40 = +HEAPF32[$39>>2];
  (_lame_set_short_threshold_lrm($gfp,$40)|0);
  $41 = (((10560 + (($1*52)|0)|0)) + 24|0);
  $42 = +HEAPF32[$41>>2];
  (_lame_set_short_threshold_s($gfp,$42)|0);
 } else {
  $13 = (_lame_get_quant_comp($gfp)|0);
  $14 = ($13|0)==(-1);
  if ($14) {
   $15 = (((10560 + (($1*52)|0)|0)) + 4|0);
   $16 = HEAP32[$15>>2]|0;
   (_lame_set_quant_comp($gfp,$16)|0);
  }
  $17 = (_lame_get_quant_comp_short($gfp)|0);
  $18 = ($17|0)==(-1);
  if ($18) {
   $19 = (((10560 + (($1*52)|0)|0)) + 8|0);
   $20 = HEAP32[$19>>2]|0;
   (_lame_set_quant_comp_short($gfp,$20)|0);
  }
  $21 = (+_lame_get_msfix($gfp));
  $22 = $21 + 1.0;
  $23 = ($22 != $22) | (0.0 != 0.0) |($22 == 0.0);
  if ($23) {
   $24 = (((10560 + (($1*52)|0)|0)) + 16|0);
   $25 = +HEAPF32[$24>>2];
   $26 = $25;
   _lame_set_msfix($gfp,$26);
  }
  $27 = (+_lame_get_short_threshold_lrm($gfp));
  $28 = $27 + 1.0;
  $29 = ($28 != $28) | (0.0 != 0.0) |($28 == 0.0);
  if ($29) {
   $30 = (((10560 + (($1*52)|0)|0)) + 20|0);
   $31 = +HEAPF32[$30>>2];
   (_lame_set_short_threshold_lrm($gfp,$31)|0);
  }
  $43 = (+_lame_get_short_threshold_s($gfp));
  $44 = $43 + 1.0;
  $45 = ($44 != $44) | (0.0 != 0.0) |($44 == 0.0);
  if ($45) {
   $46 = (((10560 + (($1*52)|0)|0)) + 24|0);
   $47 = +HEAPF32[$46>>2];
   (_lame_set_short_threshold_s($gfp,$47)|0);
  }
 }
 $48 = (+_lame_get_scale($gfp));
 $49 = (((10560 + (($1*52)|0)|0)) + 28|0);
 $50 = +HEAPF32[$49>>2];
 $51 = $50 * $48;
 (_lame_set_scale($gfp,$51)|0);
 if ($12) {
  $72 = (((10560 + (($1*52)|0)|0)) + 32|0);
  $73 = +HEAPF32[$72>>2];
  (_lame_set_maskingadjust($gfp,$73)|0);
  $74 = $73;
  $75 = $74 * 1.1000000000000001;
  $76 = $75;
  (_lame_set_maskingadjust_short($gfp,$76)|0);
  $77 = (((10560 + (($1*52)|0)|0)) + 36|0);
  $78 = +HEAPF32[$77>>2];
  (_lame_set_ATHlower($gfp,$78)|0);
  $79 = (((10560 + (($1*52)|0)|0)) + 40|0);
  $80 = +HEAPF32[$79>>2];
  (_lame_set_ATHcurve($gfp,$80)|0);
  $81 = (((10560 + (($1*52)|0)|0)) + 44|0);
  $82 = +HEAPF32[$81>>2];
  (_lame_set_interChRatio($gfp,$82)|0);
  $88 = (10560 + (($1*52)|0)|0);
  $89 = HEAP32[$88>>2]|0;
  $90 = (+($89|0));
  $91 = $90 * 0.015625;
  $92 = $91;
  $93 = ((($gfp)) + 288|0);
  $94 = HEAP32[$93>>2]|0;
  $95 = ((($94)) + 280|0);
  HEAPF32[$95>>2] = $92;
  return ($preset|0);
 }
 $52 = (+_lame_get_maskingadjust($gfp));
 $53 = ($52 != $52) | (0.0 != 0.0) |($52 == 0.0);
 if ($53) {
  $54 = (((10560 + (($1*52)|0)|0)) + 32|0);
  $55 = +HEAPF32[$54>>2];
  (_lame_set_maskingadjust($gfp,$55)|0);
 }
 $56 = (+_lame_get_maskingadjust_short($gfp));
 $57 = ($56 != $56) | (0.0 != 0.0) |($56 == 0.0);
 if ($57) {
  $58 = (((10560 + (($1*52)|0)|0)) + 32|0);
  $59 = +HEAPF32[$58>>2];
  $60 = $59;
  $61 = $60 * 1.1000000000000001;
  $62 = $61;
  (_lame_set_maskingadjust_short($gfp,$62)|0);
 }
 $63 = (+_lame_get_ATHlower($gfp));
 $64 = ($63 != $63) | (0.0 != 0.0) |($63 == 0.0);
 if ($64) {
  $65 = (((10560 + (($1*52)|0)|0)) + 36|0);
  $66 = +HEAPF32[$65>>2];
  (_lame_set_ATHlower($gfp,$66)|0);
 }
 $67 = (+_lame_get_ATHcurve($gfp));
 $68 = $67 + 1.0;
 $69 = ($68 != $68) | (0.0 != 0.0) |($68 == 0.0);
 if ($69) {
  $70 = (((10560 + (($1*52)|0)|0)) + 40|0);
  $71 = +HEAPF32[$70>>2];
  (_lame_set_ATHcurve($gfp,$71)|0);
 }
 $83 = (+_lame_get_interChRatio($gfp));
 $84 = $83 + 1.0;
 $85 = ($84 != $84) | (0.0 != 0.0) |($84 == 0.0);
 if (!($85)) {
  $88 = (10560 + (($1*52)|0)|0);
  $89 = HEAP32[$88>>2]|0;
  $90 = (+($89|0));
  $91 = $90 * 0.015625;
  $92 = $91;
  $93 = ((($gfp)) + 288|0);
  $94 = HEAP32[$93>>2]|0;
  $95 = ((($94)) + 280|0);
  HEAPF32[$95>>2] = $92;
  return ($preset|0);
 }
 $86 = (((10560 + (($1*52)|0)|0)) + 44|0);
 $87 = +HEAPF32[$86>>2];
 (_lame_set_interChRatio($gfp,$87)|0);
 $88 = (10560 + (($1*52)|0)|0);
 $89 = HEAP32[$88>>2]|0;
 $90 = (+($89|0));
 $91 = $90 * 0.015625;
 $92 = $91;
 $93 = ((($gfp)) + 288|0);
 $94 = HEAP32[$93>>2]|0;
 $95 = ((($94)) + 280|0);
 HEAPF32[$95>>2] = $92;
 return ($preset|0);
}
function _apply_vbr_preset($gfp,$a,$enforce) {
 $gfp = $gfp|0;
 $a = $a|0;
 $enforce = $enforce|0;
 var $$0$i = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0.0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0.0, $108 = 0.0, $109 = 0, $11 = 0, $110 = 0.0, $111 = 0.0, $112 = 0, $113 = 0.0, $114 = 0;
 var $115 = 0.0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0.0, $120 = 0, $121 = 0.0, $122 = 0, $123 = 0.0, $124 = 0.0, $125 = 0, $126 = 0.0, $127 = 0, $128 = 0, $129 = 0.0, $13 = 0, $130 = 0.0, $131 = 0, $132 = 0;
 var $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0.0, $140 = 0, $141 = 0.0, $142 = 0.0, $143 = 0, $144 = 0.0, $145 = 0.0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0;
 var $16 = 0.0, $17 = 0, $18 = 0.0, $19 = 0, $2 = 0.0, $20 = 0.0, $21 = 0, $22 = 0.0, $23 = 0, $24 = 0.0, $25 = 0, $26 = 0.0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0.0, $33 = 0;
 var $34 = 0.0, $35 = 0, $36 = 0.0, $37 = 0, $38 = 0, $39 = 0.0, $4 = 0, $40 = 0, $41 = 0.0, $42 = 0, $43 = 0.0, $44 = 0, $45 = 0.0, $46 = 0, $47 = 0.0, $48 = 0, $49 = 0.0, $5 = 0, $50 = 0, $51 = 0.0;
 var $52 = 0, $53 = 0.0, $54 = 0, $55 = 0, $56 = 0, $57 = 0.0, $58 = 0, $59 = 0.0, $6 = 0, $60 = 0, $61 = 0.0, $62 = 0.0, $63 = 0.0, $64 = 0.0, $65 = 0.0, $66 = 0.0, $67 = 0.0, $68 = 0.0, $69 = 0.0, $7 = 0;
 var $70 = 0.0, $71 = 0.0, $72 = 0.0, $73 = 0.0, $74 = 0.0, $75 = 0.0, $76 = 0.0, $77 = 0.0, $78 = 0.0, $79 = 0.0, $8 = 0, $80 = 0.0, $81 = 0.0, $82 = 0.0, $83 = 0.0, $84 = 0.0, $85 = 0.0, $86 = 0.0, $87 = 0, $88 = 0.0;
 var $89 = 0.0, $9 = 0, $90 = 0.0, $91 = 0, $92 = 0.0, $93 = 0.0, $94 = 0.0, $95 = 0.0, $96 = 0.0, $97 = 0.0, $98 = 0.0, $99 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (_lame_get_VBR($gfp)|0);
 if ((($0|0) == 1) | (($0|0) == 4)) {
  $$0$i = 9808;
 } else {
  $$0$i = 9056;
 }
 $1 = ((($gfp)) + 160|0);
 $2 = +HEAPF32[$1>>2];
 $3 = (($$0$i) + (($a*68)|0)|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = (((($$0$i) + (($a*68)|0)|0)) + 4|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = (((($$0$i) + (($a*68)|0)|0)) + 8|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = (((($$0$i) + (($a*68)|0)|0)) + 12|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = (((($$0$i) + (($a*68)|0)|0)) + 16|0);
 $12 = +HEAPF32[$11>>2];
 $13 = (((($$0$i) + (($a*68)|0)|0)) + 20|0);
 $14 = +HEAPF32[$13>>2];
 $15 = (((($$0$i) + (($a*68)|0)|0)) + 24|0);
 $16 = +HEAPF32[$15>>2];
 $17 = (((($$0$i) + (($a*68)|0)|0)) + 28|0);
 $18 = +HEAPF32[$17>>2];
 $19 = (((($$0$i) + (($a*68)|0)|0)) + 32|0);
 $20 = +HEAPF32[$19>>2];
 $21 = (((($$0$i) + (($a*68)|0)|0)) + 36|0);
 $22 = +HEAPF32[$21>>2];
 $23 = (((($$0$i) + (($a*68)|0)|0)) + 40|0);
 $24 = +HEAPF32[$23>>2];
 $25 = (((($$0$i) + (($a*68)|0)|0)) + 44|0);
 $26 = +HEAPF32[$25>>2];
 $27 = (((($$0$i) + (($a*68)|0)|0)) + 48|0);
 $28 = HEAP32[$27>>2]|0;
 $29 = (((($$0$i) + (($a*68)|0)|0)) + 52|0);
 $30 = HEAP32[$29>>2]|0;
 $31 = (((($$0$i) + (($a*68)|0)|0)) + 56|0);
 $32 = +HEAPF32[$31>>2];
 $33 = (((($$0$i) + (($a*68)|0)|0)) + 60|0);
 $34 = +HEAPF32[$33>>2];
 $35 = (((($$0$i) + (($a*68)|0)|0)) + 64|0);
 $36 = +HEAPF32[$35>>2];
 $37 = (($a) + 1)|0;
 $38 = (((($$0$i) + (($37*68)|0)|0)) + 16|0);
 $39 = +HEAPF32[$38>>2];
 $40 = (((($$0$i) + (($37*68)|0)|0)) + 20|0);
 $41 = +HEAPF32[$40>>2];
 $42 = (((($$0$i) + (($37*68)|0)|0)) + 24|0);
 $43 = +HEAPF32[$42>>2];
 $44 = (((($$0$i) + (($37*68)|0)|0)) + 28|0);
 $45 = +HEAPF32[$44>>2];
 $46 = (((($$0$i) + (($37*68)|0)|0)) + 32|0);
 $47 = +HEAPF32[$46>>2];
 $48 = (((($$0$i) + (($37*68)|0)|0)) + 36|0);
 $49 = +HEAPF32[$48>>2];
 $50 = (((($$0$i) + (($37*68)|0)|0)) + 40|0);
 $51 = +HEAPF32[$50>>2];
 $52 = (((($$0$i) + (($37*68)|0)|0)) + 44|0);
 $53 = +HEAPF32[$52>>2];
 $54 = (((($$0$i) + (($37*68)|0)|0)) + 52|0);
 $55 = HEAP32[$54>>2]|0;
 $56 = (((($$0$i) + (($37*68)|0)|0)) + 56|0);
 $57 = +HEAPF32[$56>>2];
 $58 = (((($$0$i) + (($37*68)|0)|0)) + 60|0);
 $59 = +HEAPF32[$58>>2];
 $60 = (((($$0$i) + (($37*68)|0)|0)) + 64|0);
 $61 = +HEAPF32[$60>>2];
 $62 = $39 - $12;
 $63 = $62 * $2;
 $64 = $63 + $12;
 $65 = $41 - $14;
 $66 = $65 * $2;
 $67 = $66 + $14;
 $68 = $43 - $16;
 $69 = $68 * $2;
 $70 = $69 + $16;
 $71 = $45 - $18;
 $72 = $71 * $2;
 $73 = $72 + $18;
 $74 = $47 - $20;
 $75 = $74 * $2;
 $76 = $75 + $20;
 $77 = $49 - $22;
 $78 = $77 * $2;
 $79 = $78 + $22;
 $80 = $51 - $24;
 $81 = $80 * $2;
 $82 = $81 + $24;
 $83 = $53 - $26;
 $84 = $83 * $2;
 $85 = $84 + $26;
 $86 = (+($30|0));
 $87 = (($55) - ($30))|0;
 $88 = (+($87|0));
 $89 = $88 * $2;
 $90 = $89 + $86;
 $91 = (~~(($90)));
 $92 = $57 - $32;
 $93 = $92 * $2;
 $94 = $93 + $32;
 $95 = $59 - $34;
 $96 = $95 * $2;
 $97 = $96 + $34;
 $98 = $61 - $36;
 $99 = $98 * $2;
 $100 = $99 + $36;
 (_lame_set_VBR_q($gfp,$4)|0);
 $101 = ($enforce|0)!=(0);
 if ($101) {
  (_lame_set_quant_comp($gfp,$6)|0);
  (_lame_set_quant_comp_short($gfp,$8)|0);
 } else {
  $102 = (_lame_get_quant_comp($gfp)|0);
  $103 = ($102|0)==(-1);
  if ($103) {
   (_lame_set_quant_comp($gfp,$6)|0);
  }
  $104 = (_lame_get_quant_comp_short($gfp)|0);
  $105 = ($104|0)==(-1);
  if ($105) {
   (_lame_set_quant_comp_short($gfp,$8)|0);
  }
 }
 $106 = ($10|0)==(0);
 if (!($106)) {
  (_lame_set_experimentalY($gfp,$10)|0);
 }
 if ($101) {
  (_lame_set_short_threshold_lrm($gfp,$64)|0);
  (_lame_set_short_threshold_s($gfp,$67)|0);
  (_lame_set_maskingadjust($gfp,$70)|0);
  (_lame_set_maskingadjust_short($gfp,$73)|0);
 } else {
  $107 = (+_lame_get_short_threshold_lrm($gfp));
  $108 = $107 + 1.0;
  $109 = ($108 != $108) | (0.0 != 0.0) |($108 == 0.0);
  if ($109) {
   (_lame_set_short_threshold_lrm($gfp,$64)|0);
  }
  $110 = (+_lame_get_short_threshold_s($gfp));
  $111 = $110 + 1.0;
  $112 = ($111 != $111) | (0.0 != 0.0) |($111 == 0.0);
  if ($112) {
   (_lame_set_short_threshold_s($gfp,$67)|0);
  }
  $113 = (+_lame_get_maskingadjust($gfp));
  $114 = ($113 != $113) | (0.0 != 0.0) |($113 == 0.0);
  if ($114) {
   (_lame_set_maskingadjust($gfp,$70)|0);
  }
  $115 = (+_lame_get_maskingadjust_short($gfp));
  $116 = ($115 != $115) | (0.0 != 0.0) |($115 == 0.0);
  if ($116) {
   (_lame_set_maskingadjust_short($gfp,$73)|0);
  }
 }
 $117 = (_lame_get_VBR($gfp)|0);
 $118 = ($117|0)==(1);
 if ($118) {
  label = 23;
 } else {
  $119 = (_lame_get_VBR($gfp)|0);
  $120 = ($119|0)==(4);
  if ($120) {
   label = 23;
  }
 }
 if ((label|0) == 23) {
  (_lame_set_ATHtype($gfp,5)|0);
 }
 if ($101) {
  (_lame_set_ATHlower($gfp,$76)|0);
  (_lame_set_ATHcurve($gfp,$79)|0);
  (_lame_set_athaa_sensitivity($gfp,$82)|0);
 } else {
  $121 = (+_lame_get_ATHlower($gfp));
  $122 = ($121 != $121) | (0.0 != 0.0) |($121 == 0.0);
  if ($122) {
   (_lame_set_ATHlower($gfp,$76)|0);
  }
  $123 = (+_lame_get_ATHcurve($gfp));
  $124 = $123 + 1.0;
  $125 = ($124 != $124) | (0.0 != 0.0) |($124 == 0.0);
  if ($125) {
   (_lame_set_ATHcurve($gfp,$79)|0);
  }
  $126 = (+_lame_get_athaa_sensitivity($gfp));
  $127 = ($126 != $126) | (0.0 != 0.0) |($126 == 0.0);
  if ($127) {
   (_lame_set_athaa_sensitivity($gfp,$82)|0);
  }
 }
 $128 = $85 > 0.0;
 do {
  if ($128) {
   if ($101) {
    (_lame_set_interChRatio($gfp,$85)|0);
    break;
   }
   $129 = (+_lame_get_interChRatio($gfp));
   $130 = $129 + 1.0;
   $131 = ($130 != $130) | (0.0 != 0.0) |($130 == 0.0);
   if ($131) {
    (_lame_set_interChRatio($gfp,$85)|0);
   }
  }
 } while(0);
 $132 = ($28|0)>(0);
 if ($132) {
  $133 = (_lame_get_exp_nspsytune($gfp)|0);
  $134 = $133 | 2;
  (_lame_set_exp_nspsytune($gfp,$134)|0);
 }
 $135 = ($91|0)>(0);
 if ($135) {
  $136 = (_lame_get_exp_nspsytune($gfp)|0);
  $137 = $136 & 66060288;
  $138 = ($137|0)==(0);
  if ($138) {
   $139 = $91 << 20;
   $140 = $136 | $139;
   (_lame_set_exp_nspsytune($gfp,$140)|0);
  }
 }
 if ($101) {
  $145 = $94;
  _lame_set_msfix($gfp,$145);
  $147 = ((($gfp)) + 288|0);
  $148 = HEAP32[$147>>2]|0;
  $149 = ((($148)) + 280|0);
  HEAPF32[$149>>2] = $97;
  $150 = ((($148)) + 224|0);
  HEAPF32[$150>>2] = $100;
  return;
 }
 $141 = (+_lame_get_msfix($gfp));
 $142 = $141 + 1.0;
 $143 = ($142 != $142) | (0.0 != 0.0) |($142 == 0.0);
 if ($143) {
  $144 = $94;
  _lame_set_msfix($gfp,$144);
 }
 $146 = ((($gfp)) + 164|0);
 HEAP32[$146>>2] = $a;
 HEAPF32[$1>>2] = $2;
 $147 = ((($gfp)) + 288|0);
 $148 = HEAP32[$147>>2]|0;
 $149 = ((($148)) + 280|0);
 HEAPF32[$149>>2] = $97;
 $150 = ((($148)) + 224|0);
 HEAPF32[$150>>2] = $100;
 return;
}
function _L3psycho_anal_vbr($gfc,$buffer,$gr_out,$masking_ratio,$masking_MS_ratio,$percep_entropy,$percep_MS_entropy,$energy,$blocktype_d) {
 $gfc = $gfc|0;
 $buffer = $buffer|0;
 $gr_out = $gr_out|0;
 $masking_ratio = $masking_ratio|0;
 $masking_MS_ratio = $masking_MS_ratio|0;
 $percep_entropy = $percep_entropy|0;
 $percep_MS_entropy = $percep_MS_entropy|0;
 $energy = $energy|0;
 $blocktype_d = $blocktype_d|0;
 var $$$i = 0.0, $$$i67 = 0, $$01$i$i = 0.0, $$01$i$i46 = 0.0, $$02$i$i = 0.0, $$02$i$i47 = 0.0, $$1$i$i = 0.0, $$1$i$i54 = 0.0, $$lcssa = 0.0, $$lcssa$i$i = 0, $$lcssa$i$i39 = 0, $$lcssa1$i$i = 0.0, $$lcssa1$i$i38 = 0.0, $$lcssa226 = 0.0, $$lcssa227 = 0, $$lcssa228 = 0, $$lcssa229 = 0.0, $$lcssa230 = 0.0, $$lcssa231 = 0.0, $$lcssa232 = 0.0;
 var $$lcssa233 = 0, $$lcssa234 = 0, $$not = 0, $$not203 = 0, $$phi$trans$insert$i = 0, $$pre$i = 0, $$pre$i12 = 0.0, $$pre$i27 = 0.0, $$pre$phi$iZ2D = 0, $$pre$phi36$iZ2D = 0, $$pre34$i = 0.0, $$pre35$i = 0, $$pre37$i = 0, $$pre48$i = 0.0, $$pre49$i = 0, $$pre52$i = 0, $$pre61$i = 0, $$pre63$i = 0, $$pre8$i = 0, $$sink$i$i = 0;
 var $$sink$i$i36 = 0, $$sink7$i$i = 0, $$sink7$i$i43 = 0, $$sum = 0, $$sum$i = 0, $$sum$us$i = 0, $$sum1$1$i = 0, $$sum1$2$i = 0, $$sum1$3$i = 0, $$sum1$4$i = 0, $$sum1$i = 0, $$sum1$us$1$i = 0, $$sum1$us$2$i = 0, $$sum1$us$3$i = 0, $$sum1$us$4$i = 0, $$sum1$us$i = 0, $$sum2$1$i = 0, $$sum2$2$i = 0, $$sum2$3$i = 0, $$sum2$4$i = 0;
 var $$sum2$i = 0, $$sum2$us$1$i = 0, $$sum2$us$2$i = 0, $$sum2$us$3$i = 0, $$sum2$us$4$i = 0, $$sum2$us$i = 0, $$sum3$1$i = 0, $$sum3$2$i = 0, $$sum3$3$i = 0, $$sum3$4$i = 0, $$sum3$i = 0, $$sum3$us$1$i = 0, $$sum3$us$2$i = 0, $$sum3$us$3$i = 0, $$sum3$us$4$i = 0, $$sum3$us$i = 0, $$sum4$1$i = 0, $$sum4$2$i = 0, $$sum4$3$i = 0, $$sum4$4$i = 0;
 var $$sum4$i = 0, $$sum4$us$1$i = 0, $$sum4$us$2$i = 0, $$sum4$us$3$i = 0, $$sum4$us$4$i = 0, $$sum4$us$i = 0, $$sum73 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $1000 = 0, $1001 = 0, $1002 = 0.0, $1003 = 0.0, $1004 = 0, $1005 = 0, $1006 = 0.0, $1007 = 0, $1008 = 0.0;
 var $1009 = 0.0, $101 = 0.0, $1010 = 0.0, $1011 = 0.0, $1012 = 0, $1013 = 0.0, $1014 = 0, $1015 = 0.0, $1016 = 0.0, $1017 = 0.0, $1018 = 0, $1019 = 0.0, $102 = 0.0, $1020 = 0, $1021 = 0, $1022 = 0, $1023 = 0, $1024 = 0, $1025 = 0, $1026 = 0;
 var $1027 = 0, $1028 = 0, $1029 = 0.0, $103 = 0.0, $1030 = 0.0, $1031 = 0.0, $1032 = 0, $1033 = 0, $1034 = 0, $1035 = 0, $1036 = 0, $1037 = 0.0, $1038 = 0, $1039 = 0.0, $104 = 0.0, $1040 = 0.0, $1041 = 0.0, $1042 = 0, $1043 = 0, $1044 = 0.0;
 var $1045 = 0.0, $1046 = 0, $1047 = 0.0, $1048 = 0, $1049 = 0.0, $105 = 0.0, $1050 = 0, $1051 = 0.0, $1052 = 0.0, $1053 = 0, $1054 = 0, $1055 = 0, $1056 = 0, $1057 = 0, $1058 = 0, $1059 = 0, $106 = 0.0, $1060 = 0.0, $1061 = 0, $1062 = 0;
 var $1063 = 0, $1064 = 0, $1065 = 0, $1066 = 0, $1067 = 0, $1068 = 0, $1069 = 0, $107 = 0.0, $1070 = 0, $1071 = 0, $1072 = 0, $1073 = 0, $1074 = 0, $1075 = 0, $1076 = 0, $1077 = 0, $1078 = 0, $1079 = 0, $108 = 0.0, $1080 = 0;
 var $1081 = 0, $1082 = 0, $1083 = 0, $1084 = 0, $1085 = 0, $1086 = 0, $1087 = 0, $1088 = 0, $1089 = 0, $109 = 0.0, $1090 = 0, $1091 = 0, $1092 = 0, $1093 = 0, $1094 = 0, $1095 = 0, $1096 = 0, $1097 = 0, $1098 = 0, $1099 = 0;
 var $11 = 0.0, $110 = 0.0, $1100 = 0, $1101 = 0, $1102 = 0, $1103 = 0, $1104 = 0, $1105 = 0, $1106 = 0, $1107 = 0, $1108 = 0, $1109 = 0, $111 = 0.0, $1110 = 0, $1111 = 0, $1112 = 0, $1113 = 0, $1114 = 0, $1115 = 0, $1116 = 0;
 var $1117 = 0, $1118 = 0, $1119 = 0, $112 = 0.0, $1120 = 0, $1121 = 0, $1122 = 0, $1123 = 0, $1124 = 0, $1125 = 0, $1126 = 0, $1127 = 0, $1128 = 0, $1129 = 0.0, $113 = 0.0, $1130 = 0.0, $1131 = 0.0, $1132 = 0.0, $1133 = 0, $1134 = 0;
 var $1135 = 0, $1136 = 0, $1137 = 0, $1138 = 0, $1139 = 0, $114 = 0, $1140 = 0, $1141 = 0, $1142 = 0, $1143 = 0, $1144 = 0.0, $1145 = 0.0, $1146 = 0.0, $1147 = 0, $1148 = 0.0, $1149 = 0, $115 = 0, $1150 = 0, $1151 = 0.0, $1152 = 0.0;
 var $1153 = 0.0, $1154 = 0, $1155 = 0, $1156 = 0, $1157 = 0, $1158 = 0, $1159 = 0, $116 = 0, $1160 = 0.0, $1161 = 0.0, $1162 = 0.0, $1163 = 0, $1164 = 0.0, $1165 = 0.0, $1166 = 0.0, $1167 = 0, $1168 = 0.0, $1169 = 0, $117 = 0, $1170 = 0.0;
 var $1171 = 0.0, $1172 = 0, $1173 = 0, $1174 = 0, $1175 = 0, $1176 = 0, $1177 = 0, $1178 = 0, $1179 = 0, $118 = 0, $1180 = 0, $1181 = 0, $1182 = 0, $1183 = 0, $1184 = 0, $1185 = 0, $1186 = 0, $1187 = 0, $1188 = 0, $1189 = 0;
 var $119 = 0, $1190 = 0, $1191 = 0, $1192 = 0, $1193 = 0, $1194 = 0, $1195 = 0, $1196 = 0, $1197 = 0, $1198 = 0, $1199 = 0, $12 = 0, $120 = 0, $1200 = 0, $1201 = 0, $1202 = 0, $1203 = 0, $1204 = 0, $1205 = 0.0, $1206 = 0;
 var $1207 = 0, $1208 = 0.0, $1209 = 0, $121 = 0, $1210 = 0.0, $1211 = 0, $1212 = 0.0, $1213 = 0, $1214 = 0.0, $1215 = 0, $1216 = 0.0, $1217 = 0.0, $1218 = 0.0, $1219 = 0.0, $122 = 0, $1220 = 0.0, $1221 = 0.0, $1222 = 0.0, $1223 = 0.0, $1224 = 0.0;
 var $1225 = 0.0, $1226 = 0.0, $1227 = 0.0, $1228 = 0.0, $1229 = 0.0, $123 = 0, $1230 = 0, $1231 = 0.0, $1232 = 0, $1233 = 0.0, $1234 = 0, $1235 = 0.0, $1236 = 0, $1237 = 0.0, $1238 = 0, $1239 = 0.0, $124 = 0, $1240 = 0.0, $1241 = 0.0, $1242 = 0.0;
 var $1243 = 0.0, $1244 = 0.0, $1245 = 0.0, $1246 = 0.0, $1247 = 0.0, $1248 = 0.0, $1249 = 0.0, $125 = 0, $1250 = 0.0, $1251 = 0.0, $1252 = 0.0, $1253 = 0, $1254 = 0.0, $1255 = 0, $1256 = 0.0, $1257 = 0, $1258 = 0.0, $1259 = 0, $126 = 0, $1260 = 0.0;
 var $1261 = 0, $1262 = 0.0, $1263 = 0.0, $1264 = 0.0, $1265 = 0.0, $1266 = 0.0, $1267 = 0.0, $1268 = 0.0, $1269 = 0.0, $127 = 0, $1270 = 0.0, $1271 = 0.0, $1272 = 0.0, $1273 = 0.0, $1274 = 0.0, $1275 = 0.0, $1276 = 0, $1277 = 0, $1278 = 0, $1279 = 0.0;
 var $128 = 0, $1280 = 0, $1281 = 0.0, $1282 = 0, $1283 = 0.0, $1284 = 0, $1285 = 0.0, $1286 = 0, $1287 = 0, $1288 = 0.0, $1289 = 0.0, $129 = 0, $1290 = 0.0, $1291 = 0.0, $1292 = 0.0, $1293 = 0.0, $1294 = 0.0, $1295 = 0.0, $1296 = 0.0, $1297 = 0.0;
 var $1298 = 0.0, $1299 = 0.0, $13 = 0, $130 = 0, $1300 = 0.0, $1301 = 0.0, $1302 = 0, $1303 = 0, $1304 = 0.0, $1305 = 0.0, $1306 = 0, $1307 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0;
 var $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0.0, $149 = 0, $15 = 0.0, $150 = 0.0, $151 = 0, $152 = 0.0, $153 = 0.0, $154 = 0.0, $155 = 0, $156 = 0.0;
 var $157 = 0, $158 = 0.0, $159 = 0.0, $16 = 0.0, $160 = 0.0, $161 = 0, $162 = 0.0, $163 = 0, $164 = 0.0, $165 = 0.0, $166 = 0.0, $167 = 0, $168 = 0.0, $169 = 0, $17 = 0, $170 = 0.0, $171 = 0.0, $172 = 0.0, $173 = 0, $174 = 0.0;
 var $175 = 0, $176 = 0.0, $177 = 0.0, $178 = 0.0, $179 = 0, $18 = 0, $180 = 0.0, $181 = 0, $182 = 0.0, $183 = 0.0, $184 = 0.0, $185 = 0, $186 = 0.0, $187 = 0, $188 = 0.0, $189 = 0.0, $19 = 0, $190 = 0.0, $191 = 0, $192 = 0.0;
 var $193 = 0, $194 = 0.0, $195 = 0.0, $196 = 0.0, $197 = 0, $198 = 0.0, $199 = 0, $2 = 0, $20 = 0, $200 = 0.0, $201 = 0.0, $202 = 0.0, $203 = 0, $204 = 0.0, $205 = 0, $206 = 0.0, $207 = 0.0, $208 = 0.0, $209 = 0.0, $21 = 0;
 var $210 = 0.0, $211 = 0.0, $212 = 0.0, $213 = 0.0, $214 = 0.0, $215 = 0.0, $216 = 0.0, $217 = 0.0, $218 = 0.0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0;
 var $229 = 0, $23 = 0, $230 = 0.0, $231 = 0, $232 = 0.0, $233 = 0.0, $234 = 0, $235 = 0.0, $236 = 0, $237 = 0.0, $238 = 0.0, $239 = 0.0, $24 = 0, $240 = 0, $241 = 0.0, $242 = 0.0, $243 = 0.0, $244 = 0, $245 = 0.0, $246 = 0;
 var $247 = 0.0, $248 = 0.0, $249 = 0.0, $25 = 0, $250 = 0, $251 = 0.0, $252 = 0.0, $253 = 0.0, $254 = 0.0, $255 = 0.0, $256 = 0.0, $257 = 0, $258 = 0, $259 = 0.0, $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0;
 var $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0.0, $27 = 0, $270 = 0.0, $271 = 0, $272 = 0, $273 = 0.0, $274 = 0, $275 = 0.0, $276 = 0.0, $277 = 0, $278 = 0.0, $279 = 0, $28 = 0, $280 = 0.0, $281 = 0, $282 = 0;
 var $283 = 0.0, $284 = 0.0, $285 = 0.0, $286 = 0.0, $287 = 0.0, $288 = 0.0, $289 = 0, $29 = 0, $290 = 0.0, $291 = 0.0, $292 = 0, $293 = 0.0, $294 = 0, $295 = 0.0, $296 = 0, $297 = 0.0, $298 = 0, $299 = 0.0, $3 = 0, $30 = 0;
 var $300 = 0, $301 = 0.0, $302 = 0, $303 = 0.0, $304 = 0, $305 = 0.0, $306 = 0, $307 = 0.0, $308 = 0, $309 = 0.0, $31 = 0, $310 = 0, $311 = 0.0, $312 = 0, $313 = 0, $314 = 0.0, $315 = 0, $316 = 0.0, $317 = 0, $318 = 0;
 var $319 = 0.0, $32 = 0, $320 = 0, $321 = 0.0, $322 = 0.0, $323 = 0, $324 = 0.0, $325 = 0, $326 = 0.0, $327 = 0, $328 = 0.0, $329 = 0, $33 = 0, $330 = 0, $331 = 0, $332 = 0, $333 = 0, $334 = 0, $335 = 0.0, $336 = 0;
 var $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0.0, $345 = 0, $346 = 0.0, $347 = 0, $348 = 0.0, $349 = 0, $35 = 0, $350 = 0, $351 = 0, $352 = 0, $353 = 0, $354 = 0;
 var $355 = 0, $356 = 0, $357 = 0, $358 = 0, $359 = 0, $36 = 0, $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0, $369 = 0, $37 = 0, $370 = 0, $371 = 0, $372 = 0;
 var $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $379 = 0.0, $38 = 0, $380 = 0, $381 = 0, $382 = 0.0, $383 = 0.0, $384 = 0.0, $385 = 0.0, $386 = 0.0, $387 = 0.0, $388 = 0, $389 = 0.0, $39 = 0, $390 = 0;
 var $391 = 0, $392 = 0.0, $393 = 0, $394 = 0.0, $395 = 0, $396 = 0.0, $397 = 0, $398 = 0, $399 = 0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0, $404 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0;
 var $409 = 0, $41 = 0, $410 = 0, $411 = 0, $412 = 0, $413 = 0, $414 = 0, $415 = 0, $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $421 = 0, $422 = 0, $423 = 0, $424 = 0, $425 = 0, $426 = 0;
 var $427 = 0, $428 = 0, $429 = 0, $43 = 0.0, $430 = 0, $431 = 0.0, $432 = 0, $433 = 0.0, $434 = 0.0, $435 = 0.0, $436 = 0.0, $437 = 0.0, $438 = 0, $439 = 0, $44 = 0, $440 = 0.0, $441 = 0.0, $442 = 0, $443 = 0, $444 = 0.0;
 var $445 = 0, $446 = 0, $447 = 0.0, $448 = 0.0, $449 = 0.0, $45 = 0.0, $450 = 0.0, $451 = 0.0, $452 = 0, $453 = 0, $454 = 0, $455 = 0, $456 = 0.0, $457 = 0.0, $458 = 0, $459 = 0, $46 = 0, $460 = 0, $461 = 0, $462 = 0;
 var $463 = 0.0, $464 = 0, $465 = 0, $466 = 0.0, $467 = 0.0, $468 = 0, $469 = 0, $47 = 0.0, $470 = 0, $471 = 0, $472 = 0, $473 = 0, $474 = 0.0, $475 = 0, $476 = 0.0, $477 = 0.0, $478 = 0.0, $479 = 0, $48 = 0.0, $480 = 0.0;
 var $481 = 0.0, $482 = 0.0, $483 = 0, $484 = 0, $485 = 0, $486 = 0, $487 = 0, $488 = 0, $489 = 0, $49 = 0.0, $490 = 0, $491 = 0.0, $492 = 0.0, $493 = 0, $494 = 0, $495 = 0, $496 = 0, $497 = 0, $498 = 0, $499 = 0;
 var $5 = 0, $50 = 0, $500 = 0, $501 = 0.0, $502 = 0.0, $503 = 0, $504 = 0, $505 = 0.0, $506 = 0.0, $507 = 0.0, $508 = 0, $509 = 0.0, $51 = 0.0, $510 = 0.0, $511 = 0, $512 = 0.0, $513 = 0.0, $514 = 0.0, $515 = 0, $516 = 0;
 var $517 = 0, $518 = 0, $519 = 0, $52 = 0, $520 = 0, $521 = 0.0, $522 = 0.0, $523 = 0.0, $524 = 0, $525 = 0, $526 = 0, $527 = 0, $528 = 0, $529 = 0, $53 = 0.0, $530 = 0.0, $531 = 0.0, $532 = 0, $533 = 0, $534 = 0;
 var $535 = 0.0, $536 = 0.0, $537 = 0.0, $538 = 0, $539 = 0, $54 = 0.0, $540 = 0, $540$phi = 0, $541 = 0.0, $542 = 0, $543 = 0.0, $544 = 0, $545 = 0, $546 = 0.0, $547 = 0, $548 = 0.0, $549 = 0.0, $55 = 0.0, $550 = 0.0, $551 = 0;
 var $552 = 0, $553 = 0, $554 = 0, $555 = 0, $556 = 0, $557 = 0, $558 = 0, $559 = 0, $56 = 0, $560 = 0.0, $561 = 0.0, $562 = 0.0, $563 = 0, $564 = 0, $565 = 0, $566 = 0, $567 = 0, $568 = 0.0, $569 = 0.0, $57 = 0.0;
 var $570 = 0, $571 = 0, $572 = 0, $573 = 0.0, $574 = 0, $575 = 0.0, $576 = 0, $577 = 0.0, $578 = 0.0, $579 = 0.0, $58 = 0, $580 = 0, $581 = 0, $582 = 0, $583 = 0, $584 = 0, $585 = 0, $586 = 0.0, $587 = 0.0, $588 = 0.0;
 var $589 = 0, $59 = 0.0, $590 = 0, $591 = 0, $592 = 0, $593 = 0, $594 = 0, $595 = 0, $596 = 0, $597 = 0, $598 = 0, $599 = 0, $6 = 0, $60 = 0.0, $600 = 0.0, $601 = 0.0, $602 = 0.0, $603 = 0, $604 = 0, $605 = 0;
 var $606 = 0, $607 = 0, $608 = 0, $609 = 0, $61 = 0.0, $610 = 0, $611 = 0, $612 = 0, $613 = 0, $614 = 0, $615 = 0, $616 = 0, $617 = 0.0, $618 = 0, $619 = 0.0, $62 = 0, $620 = 0.0, $621 = 0, $622 = 0.0, $623 = 0.0;
 var $624 = 0, $625 = 0, $626 = 0, $627 = 0, $628 = 0, $629 = 0, $63 = 0.0, $630 = 0, $631 = 0.0, $632 = 0, $633 = 0.0, $634 = 0.0, $635 = 0, $636 = 0.0, $637 = 0.0, $638 = 0, $639 = 0, $64 = 0, $640 = 0, $641 = 0;
 var $642 = 0, $643 = 0, $644 = 0.0, $645 = 0.0, $646 = 0, $647 = 0, $648 = 0.0, $649 = 0, $65 = 0.0, $650 = 0.0, $651 = 0.0, $652 = 0.0, $653 = 0.0, $654 = 0, $655 = 0.0, $656 = 0, $657 = 0.0, $658 = 0.0, $659 = 0.0, $66 = 0.0;
 var $660 = 0, $661 = 0.0, $662 = 0, $663 = 0, $664 = 0, $665 = 0, $666 = 0, $667 = 0, $668 = 0, $669 = 0, $67 = 0.0, $670 = 0, $671 = 0.0, $672 = 0.0, $673 = 0.0, $674 = 0, $675 = 0, $676 = 0, $677 = 0.0, $678 = 0.0;
 var $679 = 0, $68 = 0, $680 = 0, $681 = 0.0, $682 = 0, $683 = 0.0, $684 = 0, $685 = 0.0, $686 = 0.0, $687 = 0.0, $688 = 0, $689 = 0.0, $69 = 0.0, $690 = 0, $691 = 0, $692 = 0.0, $693 = 0.0, $694 = 0, $695 = 0.0, $696 = 0.0;
 var $697 = 0, $698 = 0, $699 = 0, $7 = 0, $70 = 0, $700 = 0, $701 = 0.0, $702 = 0, $703 = 0.0, $704 = 0, $705 = 0, $706 = 0, $707 = 0, $708 = 0.0, $709 = 0, $71 = 0.0, $710 = 0.0, $711 = 0.0, $712 = 0.0, $713 = 0;
 var $714 = 0.0, $715 = 0, $716 = 0.0, $717 = 0.0, $718 = 0, $719 = 0.0, $72 = 0.0, $720 = 0, $721 = 0.0, $722 = 0, $723 = 0.0, $724 = 0.0, $725 = 0, $726 = 0, $727 = 0, $728 = 0, $729 = 0, $73 = 0.0, $730 = 0, $731 = 0;
 var $732 = 0, $733 = 0, $734 = 0, $735 = 0, $736 = 0, $737 = 0, $738 = 0, $739 = 0, $74 = 0, $740 = 0.0, $741 = 0, $742 = 0, $743 = 0.0, $744 = 0, $745 = 0, $746 = 0, $747 = 0, $748 = 0, $749 = 0, $75 = 0.0;
 var $750 = 0, $751 = 0, $752 = 0, $753 = 0, $754 = 0.0, $755 = 0.0, $756 = 0, $757 = 0, $758 = 0, $759 = 0, $76 = 0, $760 = 0, $761 = 0, $762 = 0, $763 = 0, $764 = 0, $765 = 0, $766 = 0, $767 = 0, $768 = 0;
 var $769 = 0, $77 = 0.0, $770 = 0, $771 = 0, $772 = 0, $773 = 0, $774 = 0, $775 = 0, $776 = 0, $777 = 0, $778 = 0, $779 = 0, $78 = 0.0, $780 = 0, $781 = 0, $782 = 0, $783 = 0, $784 = 0, $785 = 0, $786 = 0;
 var $787 = 0, $788 = 0, $789 = 0, $79 = 0.0, $790 = 0, $791 = 0, $792 = 0, $793 = 0, $794 = 0, $795 = 0, $796 = 0, $797 = 0, $798 = 0, $799 = 0, $8 = 0.0, $80 = 0, $800 = 0, $801 = 0, $802 = 0, $803 = 0;
 var $804 = 0, $805 = 0, $806 = 0, $807 = 0, $808 = 0, $809 = 0, $81 = 0.0, $810 = 0, $811 = 0, $812 = 0, $813 = 0, $814 = 0, $815 = 0, $816 = 0, $817 = 0, $818 = 0, $819 = 0.0, $82 = 0, $820 = 0, $821 = 0.0;
 var $822 = 0.0, $823 = 0.0, $824 = 0.0, $825 = 0.0, $826 = 0, $827 = 0, $828 = 0, $829 = 0.0, $83 = 0.0, $830 = 0.0, $831 = 0, $832 = 0, $833 = 0.0, $834 = 0, $835 = 0, $836 = 0.0, $837 = 0.0, $838 = 0.0, $839 = 0.0, $84 = 0.0;
 var $840 = 0.0, $841 = 0, $842 = 0, $843 = 0, $844 = 0, $845 = 0, $846 = 0, $847 = 0, $848 = 0, $849 = 0, $85 = 0.0, $850 = 0, $851 = 0, $852 = 0.0, $853 = 0.0, $854 = 0, $855 = 0, $856 = 0, $857 = 0, $858 = 0;
 var $859 = 0, $86 = 0, $860 = 0, $861 = 0.0, $862 = 0.0, $863 = 0, $864 = 0, $865 = 0.0, $866 = 0.0, $867 = 0.0, $868 = 0, $869 = 0.0, $87 = 0.0, $870 = 0.0, $871 = 0, $872 = 0.0, $873 = 0.0, $874 = 0.0, $875 = 0, $876 = 0;
 var $877 = 0, $878 = 0, $879 = 0, $88 = 0, $880 = 0, $881 = 0.0, $882 = 0.0, $883 = 0.0, $884 = 0, $885 = 0, $886 = 0, $887 = 0, $888 = 0, $889 = 0, $89 = 0.0, $890 = 0.0, $891 = 0, $892 = 0, $893 = 0, $894 = 0.0;
 var $895 = 0.0, $896 = 0.0, $897 = 0, $898 = 0, $899 = 0, $899$phi = 0, $9 = 0, $90 = 0.0, $900 = 0.0, $901 = 0, $902 = 0.0, $903 = 0, $904 = 0, $905 = 0.0, $906 = 0, $907 = 0.0, $908 = 0.0, $909 = 0.0, $91 = 0.0, $910 = 0;
 var $911 = 0, $912 = 0, $913 = 0, $914 = 0, $915 = 0, $916 = 0, $917 = 0, $918 = 0, $919 = 0.0, $92 = 0, $920 = 0.0, $921 = 0.0, $922 = 0, $923 = 0, $924 = 0, $925 = 0, $926 = 0, $927 = 0.0, $928 = 0.0, $929 = 0;
 var $93 = 0.0, $930 = 0, $931 = 0, $932 = 0.0, $933 = 0, $934 = 0.0, $935 = 0, $936 = 0.0, $937 = 0.0, $938 = 0.0, $939 = 0, $94 = 0, $940 = 0, $941 = 0, $942 = 0, $943 = 0, $944 = 0, $945 = 0.0, $946 = 0.0, $947 = 0.0;
 var $948 = 0, $949 = 0, $95 = 0.0, $950 = 0, $951 = 0, $952 = 0, $953 = 0, $954 = 0, $955 = 0, $956 = 0, $957 = 0, $958 = 0, $959 = 0, $96 = 0.0, $960 = 0, $961 = 0, $962 = 0, $963 = 0, $964 = 0, $965 = 0;
 var $966 = 0, $967 = 0.0, $968 = 0.0, $969 = 0.0, $97 = 0.0, $970 = 0, $971 = 0, $972 = 0, $973 = 0, $974 = 0, $975 = 0.0, $976 = 0, $977 = 0.0, $978 = 0.0, $979 = 0, $98 = 0, $980 = 0.0, $981 = 0.0, $982 = 0, $983 = 0;
 var $984 = 0, $985 = 0, $986 = 0, $987 = 0, $988 = 0, $989 = 0.0, $99 = 0.0, $990 = 0, $991 = 0.0, $992 = 0.0, $993 = 0, $994 = 0.0, $995 = 0.0, $996 = 0, $997 = 0, $998 = 0, $999 = 0, $avg$i = 0, $b$0$lcssa$i$i = 0, $b$0$lcssa$i$i40 = 0;
 var $b$01$i = 0, $b$019$i = 0, $b$02$i$i = 0, $b$02$i$i32 = 0, $b$030$i = 0, $b$08$i$i = 0, $b$116$i = 0, $b$16$i$ph = 0, $b$23$i$ph = 0, $blocktype$0$i = 0, $brmerge = 0, $chn$01$i$us = 0, $chn$01$i65 = 0, $chn$01$us$i = 0, $chn$0136 = 0, $chn$031$i = 0, $chn$031$us$i = 0, $chn$1133 = 0, $chn$125$i = 0, $chn$2120 = 0;
 var $chn$3127 = 0, $chn$4119 = 0, $chn$5114 = 0, $chn$6112 = 0, $dd$0$lcssa$i = 0, $dd$0$lcssa$i58 = 0, $dd$010$i = 0, $dd$06$i = 0, $dd_n$0$lcssa$i = 0, $dd_n$0$lcssa$i57 = 0, $eb = 0, $ebb$0$lcssa$i = 0.0, $ebb$0$lcssa$i$i = 0.0, $ebb$02$i$i = 0.0, $ebb$021$i = 0.0, $ecb$0$be$i = 0.0, $ecb$0$be$i$lcssa = 0.0, $ecb$0$be$i48 = 0.0, $ecb$0$be$i48$lcssa = 0.0, $ecb$0$lcssa$i = 0.0;
 var $ecb$0$lcssa$i56 = 0.0, $ecb$08$i = 0.0, $ecb$09$i = 0.0, $ecb_limit1$0$i = 0.0, $ecb_limit_1$0$i = 0.0, $ecb_limit_2$0$i = 0.0, $en_short$i = 0, $exitcond = 0, $exitcond$i = 0, $exitcond$i$i = 0, $exitcond$i11 = 0, $exitcond$i17 = 0, $exitcond$i18 = 0, $exitcond$i68 = 0, $exitcond$i7 = 0, $exitcond$i8 = 0, $exitcond150 = 0, $exitcond151 = 0, $exitcond155 = 0, $exitcond156 = 0;
 var $exitcond159 = 0, $exitcond160 = 0, $exitcond167 = 0, $exitcond168 = 0, $exitcond169 = 0, $exitcond170 = 0, $exitcond173 = 0, $exitcond180 = 0, $exitcond31$i = 0, $exitcond32$i = 0, $exitcond33$i = 0, $exitcond41$i = 0, $exitcond44$i = 0, $exitcond45$i = 0, $exitcond46$i = 0, $exitcond46$i25 = 0, $exitcond48$i = 0, $exitcond49$i = 0, $exitcond50$i = 0, $exitcond51$i = 0;
 var $exitcond9$i = 0, $fabsf$i = 0.0, $factor$0$1$i = 0.0, $factor$0$2$i = 0.0, $factor$0$i = 0.0, $fftenergy = 0, $fftenergy_s = 0, $i$01$i$i = 0, $i$023$i = 0, $i$030$i = 0, $i$030$us$i = 0, $i$04$i$i = 0, $i$114$i = 0, $i$319$i = 0, $i$623$i = 0, $ispos$i$i = 0, $ispos$i$i52 = 0, $j$03$i = 0, $j$031$i = 0, $j$07$i$i = 0;
 var $j$08$i = 0, $j$1$lcssa$i = 0, $j$1$lcssa$i$i = 0, $j$11$i$i = 0, $j$12$i = 0, $j$122$i = 0, $j$17$i = 0, $j$217$i = 0, $j$25$i = 0, $j$3$i = 0, $j$3$lcssa$i = 0, $j$34$i = 0, $j$34$i45 = 0, $j$39$i = 0, $k$020$i = 0, $k$1$i = 0, $k$1$lcssa$i = 0, $k$112$i = 0, $k$17$i = 0, $kk$010$i = 0;
 var $kk$010$in$i = 0, $kk$013$i = 0, $kk$013$in$i = 0, $last_thm = 0, $loudness_power$02$i$i = 0.0, $m$0$i$i = 0.0, $m$0$i$i29 = 0.0, $m$0$lcssa$i = 0.0, $m$0$lcssa$i$i = 0.0, $m$020$i = 0.0, $m$03$i$i = 0.0, $m$1$i = 0.0, $m$1$i$i = 0.0, $m$1$i$i$lcssa = 0.0, $m$1$i$i34 = 0.0, $m$1$i$lcssa = 0.0, $m$1$i2$i = 0.0, $m$2$i$i = 0.0, $m$2$i$i35 = 0.0, $m$3$i$i = 0.0;
 var $m$3$i$i42 = 0.0, $mask_idx_s$i = 0, $mr$0 = 0, $neg$i$i = 0, $neg$i$i53 = 0, $new_thmm = 0, $ns_attacks = 0, $ns_uselongblock$0$i = 0, $or$cond = 0, $or$cond$1$i = 0, $or$cond$2$i = 0, $or$cond$i = 0, $or$cond$i20 = 0, $or$cond3 = 0, $or$cond7$1$i = 0, $or$cond7$2$i = 0, $or$cond7$i = 0, $or$cond75 = 0, $p$017$i = 0.0, $p$1$i = 0.0;
 var $p$1$i$lcssa = 0.0, $p$2$i = 0.0, $pe_l$02$i = 0.0, $pe_l$1$i = 0.0, $pe_l$1$i$lcssa = 0.0, $pe_s$04$i = 0.0, $pe_s$2$1$i = 0.0, $pe_s$2$2$i = 0.0, $pe_s$2$2$i$lcssa = 0.0, $pe_s$2$i = 0.0, $pf$018$i = 0, $pf$116$i = 0, $ppe$0 = 0, $prev_thm$0 = 0.0, $prev_thm$0$in = 0, $prev_thm$1 = 0.0, $ratio$0$i$i = 0.0, $ratio$0$i$i51 = 0.0, $sb$01$i = 0, $sb$0118 = 0;
 var $sb$02$i = 0, $sb$03$i = 0, $sblock$0130 = 0, $sblock$1116 = 0, $scevgep = 0, $scevgep162 = 0, $scevgep165 = 0, $scevgep175 = 0, $scevgep178 = 0, $smax$i = 0, $smax$i$i = 0, $smax$i31 = 0, $storemerge$i$i = 0, $storemerge$i$i30 = 0, $sub_short_factor = 0, $t1$0 = 0.0, $t2$0 = 0.0, $thm$i = 0, $thr = 0, $totalenergy$06$i = 0.0;
 var $type$0 = 0, $type$1 = 0, $uselongblock = 0, $wsamp_L = 0, $wsamp_S = 0, $x$1$1$i = 0.0, $x$1$10$i = 0.0, $x$1$2$i = 0.0, $x$1$3$i = 0.0, $x$1$4$i = 0.0, $x$1$5$i = 0.0, $x$1$6$i = 0.0, $x$1$7$i = 0.0, $x$1$8$i = 0.0, $x$1$9$i = 0.0, $x$1$i = 0.0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 26240|0;
 $mask_idx_s$i = sp + 21624|0;
 $thm$i = sp + 21368|0;
 $avg$i = sp + 21112|0;
 $en_short$i = sp + 21096|0;
 $last_thm = sp + 20120|0;
 $fftenergy = sp + 18068|0;
 $fftenergy_s = sp + 16520|0;
 $wsamp_L = sp + 8328|0;
 $wsamp_S = sp + 2184|0;
 $eb = sp + 1160|0;
 $thr = sp + 136|0;
 $sub_short_factor = sp + 88|0;
 $ns_attacks = sp + 24|0;
 $uselongblock = sp + 16|0;
 $new_thmm = sp;
 $0 = ((($gfc)) + 85800|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($gfc)) + 140|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)==(0);
 if ($4) {
  $1192 = 0;
 } else {
  $5 = ((($gfc)) + 85804|0);
  $6 = HEAP32[$5>>2]|0;
  $1192 = $6;
 }
 $7 = ((($gfc)) + 192|0);
 $8 = +HEAPF32[$7>>2];
 $9 = $8 > 0.0;
 if ($9) {
  $10 = ((($gfc)) + 200|0);
  $11 = +HEAPF32[$10>>2];
  $12 = ((($gfc)) + 85796|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = ((($13)) + 8|0);
  $15 = +HEAPF32[$14>>2];
  $16 = $15 * $11;
  $743 = $16;
 } else {
  $743 = 1.0;
 }
 dest=$ns_attacks; stop=dest+64|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 $17 = ((($gfc)) + 180|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($18|0)==(1);
 if ($19) {
  $417 = 4;
 } else {
  $20 = ((($gfc)) + 72|0);
  $21 = HEAP32[$20>>2]|0;
  $417 = $21;
 }
 $22 = ((($gfc)) + 25660|0);
 _memcpy(($last_thm|0),($22|0),976)|0;
 if ($4) {
  $117 = 0;
 } else {
  $23 = ((($gfc)) + 85804|0);
  $24 = HEAP32[$23>>2]|0;
  $117 = $24;
 }
 $25 = ((($gfc)) + 72|0);
 $26 = HEAP32[$25>>2]|0;
 $27 = $19 ? 4 : $26;
 _memset(($mask_idx_s$i|0),0,4608)|0;
 $28 = ($26|0)>(0);
 if ($28) {
  $29 = ($27|0)>(2);
  if ($29) {
   $chn$031$us$i = 0;
   while(1) {
    $30 = (($buffer) + ($chn$031$us$i<<2)|0);
    $31 = HEAP32[$30>>2]|0;
    $i$030$us$i = 0;
    while(1) {
     $$sum$us$i = (($i$030$us$i) + 407)|0;
     $42 = (($31) + ($$sum$us$i<<2)|0);
     $43 = +HEAPF32[$42>>2];
     $$sum1$us$i = (($i$030$us$i) + 397)|0;
     $44 = (($31) + ($$sum1$us$i<<2)|0);
     $45 = +HEAPF32[$44>>2];
     $$sum2$us$i = (($i$030$us$i) + 418)|0;
     $46 = (($31) + ($$sum2$us$i<<2)|0);
     $47 = +HEAPF32[$46>>2];
     $48 = $47 + $45;
     $49 = $48 * 1.7303260184043527E-17;
     $$sum3$us$i = (($i$030$us$i) + 398)|0;
     $50 = (($31) + ($$sum3$us$i<<2)|0);
     $51 = +HEAPF32[$50>>2];
     $$sum4$us$i = (($i$030$us$i) + 417)|0;
     $52 = (($31) + ($$sum4$us$i<<2)|0);
     $53 = +HEAPF32[$52>>2];
     $54 = $53 + $51;
     $55 = $54 * 0.017031719908118248;
     $$sum1$us$1$i = (($i$030$us$i) + 399)|0;
     $56 = (($31) + ($$sum1$us$1$i<<2)|0);
     $57 = +HEAPF32[$56>>2];
     $$sum2$us$1$i = (($i$030$us$i) + 416)|0;
     $58 = (($31) + ($$sum2$us$1$i<<2)|0);
     $59 = +HEAPF32[$58>>2];
     $60 = $59 + $57;
     $61 = $60 * 1.3495279640235235E-17;
     $$sum3$us$1$i = (($i$030$us$i) + 400)|0;
     $62 = (($31) + ($$sum3$us$1$i<<2)|0);
     $63 = +HEAPF32[$62>>2];
     $$sum4$us$1$i = (($i$030$us$i) + 415)|0;
     $64 = (($31) + ($$sum4$us$1$i<<2)|0);
     $65 = +HEAPF32[$64>>2];
     $66 = $65 + $63;
     $67 = $66 * 0.041807200759649277;
     $$sum1$us$2$i = (($i$030$us$i) + 401)|0;
     $68 = (($31) + ($$sum1$us$2$i<<2)|0);
     $69 = +HEAPF32[$68>>2];
     $$sum2$us$2$i = (($i$030$us$i) + 414)|0;
     $70 = (($31) + ($$sum2$us$2$i<<2)|0);
     $71 = +HEAPF32[$70>>2];
     $72 = $71 + $69;
     $73 = $72 * 6.7327796858492251E-17;
     $$sum3$us$2$i = (($i$030$us$i) + 402)|0;
     $74 = (($31) + ($$sum3$us$2$i<<2)|0);
     $75 = +HEAPF32[$74>>2];
     $$sum4$us$2$i = (($i$030$us$i) + 413)|0;
     $76 = (($31) + ($$sum4$us$2$i<<2)|0);
     $77 = +HEAPF32[$76>>2];
     $78 = $77 + $75;
     $79 = $78 * 0.087632402777671814;
     $$sum1$us$3$i = (($i$030$us$i) + 403)|0;
     $80 = (($31) + ($$sum1$us$3$i<<2)|0);
     $81 = +HEAPF32[$80>>2];
     $$sum2$us$3$i = (($i$030$us$i) + 412)|0;
     $82 = (($31) + ($$sum2$us$3$i<<2)|0);
     $83 = +HEAPF32[$82>>2];
     $84 = $83 + $81;
     $85 = $84 * 3.0835000291318875E-17;
     $$sum3$us$3$i = (($i$030$us$i) + 404)|0;
     $86 = (($31) + ($$sum3$us$3$i<<2)|0);
     $87 = +HEAPF32[$86>>2];
     $$sum4$us$3$i = (($i$030$us$i) + 411)|0;
     $88 = (($31) + ($$sum4$us$3$i<<2)|0);
     $89 = +HEAPF32[$88>>2];
     $90 = $89 + $87;
     $91 = $90 * 0.1863476037979126;
     $$sum1$us$4$i = (($i$030$us$i) + 405)|0;
     $92 = (($31) + ($$sum1$us$4$i<<2)|0);
     $93 = +HEAPF32[$92>>2];
     $$sum2$us$4$i = (($i$030$us$i) + 410)|0;
     $94 = (($31) + ($$sum2$us$4$i<<2)|0);
     $95 = +HEAPF32[$94>>2];
     $96 = $95 + $93;
     $97 = $96 * 1.1044240253100168E-16;
     $$sum3$us$4$i = (($i$030$us$i) + 406)|0;
     $98 = (($31) + ($$sum3$us$4$i<<2)|0);
     $99 = +HEAPF32[$98>>2];
     $$sum4$us$4$i = (($i$030$us$i) + 409)|0;
     $100 = (($31) + ($$sum4$us$4$i<<2)|0);
     $101 = +HEAPF32[$100>>2];
     $102 = $101 + $99;
     $103 = $102 * 0.62763798236846924;
     $104 = $43 - $49;
     $105 = $104 - $55;
     $106 = $105 - $61;
     $107 = $106 + $67;
     $108 = $107 - $73;
     $109 = $108 - $79;
     $110 = $109 - $85;
     $111 = $110 + $91;
     $112 = $111 - $97;
     $113 = $112 - $103;
     $114 = ((($mask_idx_s$i) + (($chn$031$us$i*2304)|0)|0) + ($i$030$us$i<<2)|0);
     HEAPF32[$114>>2] = $113;
     $115 = (($i$030$us$i) + 1)|0;
     $exitcond50$i = ($115|0)==(576);
     if ($exitcond50$i) {
      break;
     } else {
      $i$030$us$i = $115;
     }
    }
    $32 = ((((($masking_ratio) + (($gr_out*976)|0)|0) + (($chn$031$us$i*488)|0)|0)) + 244|0);
    $33 = (((($gfc)) + 26636|0) + (($chn$031$us$i*244)|0)|0);
    _memcpy(($32|0),($33|0),244)|0;
    $34 = ((($masking_ratio) + (($gr_out*976)|0)|0) + (($chn$031$us$i*488)|0)|0);
    $35 = (((($gfc)) + 25660|0) + (($chn$031$us$i*244)|0)|0);
    _memcpy(($34|0),($35|0),244)|0;
    $36 = ((((($masking_MS_ratio) + (($gr_out*976)|0)|0) + (($chn$031$us$i*488)|0)|0)) + 244|0);
    $37 = (($chn$031$us$i) + 2)|0;
    $38 = (((($gfc)) + 26636|0) + (($37*244)|0)|0);
    _memcpy(($36|0),($38|0),244)|0;
    $39 = ((($masking_MS_ratio) + (($gr_out*976)|0)|0) + (($chn$031$us$i*488)|0)|0);
    $40 = (((($gfc)) + 25660|0) + (($37*244)|0)|0);
    _memcpy(($39|0),($40|0),244)|0;
    $41 = (($chn$031$us$i) + 1)|0;
    $exitcond51$i = ($41|0)==($26|0);
    if ($exitcond51$i) {
     break;
    } else {
     $chn$031$us$i = $41;
    }
   }
  } else {
   $chn$031$i = 0;
   while(1) {
    $145 = (($buffer) + ($chn$031$i<<2)|0);
    $146 = HEAP32[$145>>2]|0;
    $i$030$i = 0;
    while(1) {
     $$sum$i = (($i$030$i) + 407)|0;
     $147 = (($146) + ($$sum$i<<2)|0);
     $148 = +HEAPF32[$147>>2];
     $$sum1$i = (($i$030$i) + 397)|0;
     $149 = (($146) + ($$sum1$i<<2)|0);
     $150 = +HEAPF32[$149>>2];
     $$sum2$i = (($i$030$i) + 418)|0;
     $151 = (($146) + ($$sum2$i<<2)|0);
     $152 = +HEAPF32[$151>>2];
     $153 = $152 + $150;
     $154 = $153 * 1.7303260184043527E-17;
     $$sum3$i = (($i$030$i) + 398)|0;
     $155 = (($146) + ($$sum3$i<<2)|0);
     $156 = +HEAPF32[$155>>2];
     $$sum4$i = (($i$030$i) + 417)|0;
     $157 = (($146) + ($$sum4$i<<2)|0);
     $158 = +HEAPF32[$157>>2];
     $159 = $158 + $156;
     $160 = $159 * 0.017031719908118248;
     $$sum1$1$i = (($i$030$i) + 399)|0;
     $161 = (($146) + ($$sum1$1$i<<2)|0);
     $162 = +HEAPF32[$161>>2];
     $$sum2$1$i = (($i$030$i) + 416)|0;
     $163 = (($146) + ($$sum2$1$i<<2)|0);
     $164 = +HEAPF32[$163>>2];
     $165 = $164 + $162;
     $166 = $165 * 1.3495279640235235E-17;
     $$sum3$1$i = (($i$030$i) + 400)|0;
     $167 = (($146) + ($$sum3$1$i<<2)|0);
     $168 = +HEAPF32[$167>>2];
     $$sum4$1$i = (($i$030$i) + 415)|0;
     $169 = (($146) + ($$sum4$1$i<<2)|0);
     $170 = +HEAPF32[$169>>2];
     $171 = $170 + $168;
     $172 = $171 * 0.041807200759649277;
     $$sum1$2$i = (($i$030$i) + 401)|0;
     $173 = (($146) + ($$sum1$2$i<<2)|0);
     $174 = +HEAPF32[$173>>2];
     $$sum2$2$i = (($i$030$i) + 414)|0;
     $175 = (($146) + ($$sum2$2$i<<2)|0);
     $176 = +HEAPF32[$175>>2];
     $177 = $176 + $174;
     $178 = $177 * 6.7327796858492251E-17;
     $$sum3$2$i = (($i$030$i) + 402)|0;
     $179 = (($146) + ($$sum3$2$i<<2)|0);
     $180 = +HEAPF32[$179>>2];
     $$sum4$2$i = (($i$030$i) + 413)|0;
     $181 = (($146) + ($$sum4$2$i<<2)|0);
     $182 = +HEAPF32[$181>>2];
     $183 = $182 + $180;
     $184 = $183 * 0.087632402777671814;
     $$sum1$3$i = (($i$030$i) + 403)|0;
     $185 = (($146) + ($$sum1$3$i<<2)|0);
     $186 = +HEAPF32[$185>>2];
     $$sum2$3$i = (($i$030$i) + 412)|0;
     $187 = (($146) + ($$sum2$3$i<<2)|0);
     $188 = +HEAPF32[$187>>2];
     $189 = $188 + $186;
     $190 = $189 * 3.0835000291318875E-17;
     $$sum3$3$i = (($i$030$i) + 404)|0;
     $191 = (($146) + ($$sum3$3$i<<2)|0);
     $192 = +HEAPF32[$191>>2];
     $$sum4$3$i = (($i$030$i) + 411)|0;
     $193 = (($146) + ($$sum4$3$i<<2)|0);
     $194 = +HEAPF32[$193>>2];
     $195 = $194 + $192;
     $196 = $195 * 0.1863476037979126;
     $$sum1$4$i = (($i$030$i) + 405)|0;
     $197 = (($146) + ($$sum1$4$i<<2)|0);
     $198 = +HEAPF32[$197>>2];
     $$sum2$4$i = (($i$030$i) + 410)|0;
     $199 = (($146) + ($$sum2$4$i<<2)|0);
     $200 = +HEAPF32[$199>>2];
     $201 = $200 + $198;
     $202 = $201 * 1.1044240253100168E-16;
     $$sum3$4$i = (($i$030$i) + 406)|0;
     $203 = (($146) + ($$sum3$4$i<<2)|0);
     $204 = +HEAPF32[$203>>2];
     $$sum4$4$i = (($i$030$i) + 409)|0;
     $205 = (($146) + ($$sum4$4$i<<2)|0);
     $206 = +HEAPF32[$205>>2];
     $207 = $206 + $204;
     $208 = $207 * 0.62763798236846924;
     $209 = $148 - $154;
     $210 = $209 - $160;
     $211 = $210 - $166;
     $212 = $211 + $172;
     $213 = $212 - $178;
     $214 = $213 - $184;
     $215 = $214 - $190;
     $216 = $215 + $196;
     $217 = $216 - $202;
     $218 = $217 - $208;
     $219 = ((($mask_idx_s$i) + (($chn$031$i*2304)|0)|0) + ($i$030$i<<2)|0);
     HEAPF32[$219>>2] = $218;
     $220 = (($i$030$i) + 1)|0;
     $exitcond48$i = ($220|0)==(576);
     if ($exitcond48$i) {
      break;
     } else {
      $i$030$i = $220;
     }
    }
    $221 = ((((($masking_ratio) + (($gr_out*976)|0)|0) + (($chn$031$i*488)|0)|0)) + 244|0);
    $222 = (((($gfc)) + 26636|0) + (($chn$031$i*244)|0)|0);
    _memcpy(($221|0),($222|0),244)|0;
    $223 = ((($masking_ratio) + (($gr_out*976)|0)|0) + (($chn$031$i*488)|0)|0);
    $224 = (((($gfc)) + 25660|0) + (($chn$031$i*244)|0)|0);
    _memcpy(($223|0),($224|0),244)|0;
    $225 = (($chn$031$i) + 1)|0;
    $exitcond49$i = ($225|0)==($26|0);
    if ($exitcond49$i) {
     break;
    } else {
     $chn$031$i = $225;
    }
   }
  }
 }
 $116 = ($27|0)>(0);
 if ($116) {
  $118 = ($117|0)==(0|0);
  $119 = ((($uselongblock)) + 4|0);
  $120 = ((($avg$i)) + 4|0);
  $121 = ((($thm$i)) + 4|0);
  $122 = ((($avg$i)) + 8|0);
  $123 = ((($thm$i)) + 8|0);
  $124 = ((($avg$i)) + 12|0);
  $125 = ((($avg$i)) + 16|0);
  $126 = ((($avg$i)) + 20|0);
  $127 = ((($avg$i)) + 24|0);
  $128 = ((($avg$i)) + 28|0);
  $129 = ((($avg$i)) + 32|0);
  $130 = ((($avg$i)) + 36|0);
  $131 = ((($avg$i)) + 40|0);
  $132 = ((($avg$i)) + 44|0);
  $133 = ((($en_short$i)) + 4|0);
  $134 = ((($en_short$i)) + 8|0);
  $135 = ((($en_short$i)) + 12|0);
  $136 = ((($thm$i)) + 12|0);
  $137 = ((($thm$i)) + 16|0);
  $138 = ((($thm$i)) + 20|0);
  $139 = ((($thm$i)) + 24|0);
  $140 = ((($thm$i)) + 28|0);
  $141 = ((($thm$i)) + 32|0);
  $142 = ((($thm$i)) + 36|0);
  $143 = ((($thm$i)) + 40|0);
  $144 = ((($thm$i)) + 44|0);
  $chn$125$i = 0;
  while(1) {
   ;HEAP32[$en_short$i>>2]=0|0;HEAP32[$en_short$i+4>>2]=0|0;HEAP32[$en_short$i+8>>2]=0|0;HEAP32[$en_short$i+12>>2]=0|0;
   $226 = $chn$125$i & 1;
   $227 = (($mask_idx_s$i) + (($226*2304)|0)|0);
   $228 = ($chn$125$i|0)==(2);
   if ($228) {
    $i$114$i = 0;
    while(1) {
     $244 = (($mask_idx_s$i) + ($i$114$i<<2)|0);
     $245 = +HEAPF32[$244>>2];
     $246 = (((($mask_idx_s$i)) + 2304|0) + ($i$114$i<<2)|0);
     $247 = +HEAPF32[$246>>2];
     $248 = $247 + $245;
     HEAPF32[$244>>2] = $248;
     $249 = $245 - $247;
     HEAPF32[$246>>2] = $249;
     $250 = (($i$114$i) + 1)|0;
     $exitcond$i = ($250|0)==(576);
     if ($exitcond$i) {
      break;
     } else {
      $i$114$i = $250;
     }
    }
   }
   $229 = (((((($gfc)) + 27636|0) + (($chn$125$i*36)|0)|0)) + 24|0);
   $230 = +HEAPF32[$229>>2];
   HEAPF32[$avg$i>>2] = $230;
   $231 = (((((($gfc)) + 27636|0) + (($chn$125$i*36)|0)|0)) + 16|0);
   $232 = +HEAPF32[$231>>2];
   $233 = $230 / $232;
   HEAPF32[$thm$i>>2] = $233;
   $234 = (((((($gfc)) + 27636|0) + (($chn$125$i*36)|0)|0)) + 28|0);
   $235 = +HEAPF32[$234>>2];
   HEAPF32[$120>>2] = $235;
   $236 = (((((($gfc)) + 27636|0) + (($chn$125$i*36)|0)|0)) + 20|0);
   $237 = +HEAPF32[$236>>2];
   $238 = $235 / $237;
   HEAPF32[$121>>2] = $238;
   $239 = $235 + $230;
   $240 = (((((($gfc)) + 27636|0) + (($chn$125$i*36)|0)|0)) + 32|0);
   $241 = +HEAPF32[$240>>2];
   HEAPF32[$122>>2] = $241;
   $242 = $241 / $230;
   HEAPF32[$123>>2] = $242;
   $243 = $239 + $241;
   HEAPF32[$en_short$i>>2] = $243;
   $i$319$i = 0;$pf$018$i = $227;
   while(1) {
    $258 = ((($pf$018$i)) + 256|0);
    $p$017$i = 1.0;$pf$116$i = $pf$018$i;
    while(1) {
     $259 = +HEAPF32[$pf$116$i>>2];
     $fabsf$i = (+Math_abs((+$259)));
     $260 = $p$017$i < $fabsf$i;
     $p$1$i = $260 ? $fabsf$i : $p$017$i;
     $261 = ((($pf$116$i)) + 4|0);
     $262 = ($261>>>0)<($258>>>0);
     if ($262) {
      $p$017$i = $p$1$i;$pf$116$i = $261;
     } else {
      $p$1$i$lcssa = $p$1$i;
      break;
     }
    }
    $263 = (($i$319$i) + 3)|0;
    $264 = (($avg$i) + ($263<<2)|0);
    HEAPF32[$264>>2] = $p$1$i$lcssa;
    $265 = ((((($gfc)) + 27636|0) + (($chn$125$i*36)|0)|0) + ($i$319$i<<2)|0);
    HEAPF32[$265>>2] = $p$1$i$lcssa;
    $266 = (($i$319$i|0) / 3)&-1;
    $267 = (($266) + 1)|0;
    $268 = (($en_short$i) + ($267<<2)|0);
    $269 = +HEAPF32[$268>>2];
    $270 = $269 + $p$1$i$lcssa;
    HEAPF32[$268>>2] = $270;
    $271 = (($i$319$i) + 1)|0;
    $272 = (($avg$i) + ($271<<2)|0);
    $273 = +HEAPF32[$272>>2];
    $274 = $p$1$i$lcssa > $273;
    if ($274) {
     $275 = $p$1$i$lcssa / $273;
     $p$2$i = $275;
    } else {
     $276 = $p$1$i$lcssa * 10.0;
     $277 = $273 > $276;
     if ($277) {
      $278 = $273 / $276;
      $p$2$i = $278;
     } else {
      $p$2$i = 0.0;
     }
    }
    $279 = (($thm$i) + ($263<<2)|0);
    HEAPF32[$279>>2] = $p$2$i;
    $exitcond41$i = ($271|0)==(9);
    if ($exitcond41$i) {
     break;
    } else {
     $i$319$i = $271;$pf$018$i = $258;
    }
   }
   $251 = +HEAPF32[$124>>2];
   $252 = +HEAPF32[$125>>2];
   $253 = $252 + $251;
   $254 = +HEAPF32[$126>>2];
   $255 = $253 + $254;
   $256 = $254 * 6.0;
   $257 = $256 < $255;
   if ($257) {
    $280 = $252 * 6.0;
    $281 = $280 < $255;
    if ($281) {
     $factor$0$i = 0.25;
    } else {
     $factor$0$i = 0.5;
    }
   } else {
    $factor$0$i = 1.0;
   }
   $282 = (($sub_short_factor) + (($chn$125$i*12)|0)|0);
   HEAPF32[$282>>2] = $factor$0$i;
   $283 = +HEAPF32[$127>>2];
   $284 = +HEAPF32[$128>>2];
   $285 = $284 + $283;
   $286 = +HEAPF32[$129>>2];
   $287 = $285 + $286;
   $288 = $286 * 6.0;
   $289 = $288 < $287;
   if ($289) {
    $379 = $284 * 6.0;
    $380 = $379 < $287;
    if ($380) {
     $factor$0$1$i = 0.25;
    } else {
     $factor$0$1$i = 0.5;
    }
   } else {
    $factor$0$1$i = 1.0;
   }
   $381 = (((($sub_short_factor) + (($chn$125$i*12)|0)|0)) + 4|0);
   HEAPF32[$381>>2] = $factor$0$1$i;
   $382 = +HEAPF32[$130>>2];
   $383 = +HEAPF32[$131>>2];
   $384 = $383 + $382;
   $385 = +HEAPF32[$132>>2];
   $386 = $384 + $385;
   $387 = $385 * 6.0;
   $388 = $387 < $386;
   if ($388) {
    $389 = $383 * 6.0;
    $390 = $389 < $386;
    if ($390) {
     $factor$0$2$i = 0.25;
    } else {
     $factor$0$2$i = 0.5;
    }
   } else {
    $factor$0$2$i = 1.0;
   }
   $391 = (((($sub_short_factor) + (($chn$125$i*12)|0)|0)) + 8|0);
   HEAPF32[$391>>2] = $factor$0$2$i;
   if (!($118)) {
    $290 = +HEAPF32[$thm$i>>2];
    $291 = +HEAPF32[$121>>2];
    $292 = $290 < $291;
    $x$1$i = $292 ? $291 : $290;
    $293 = +HEAPF32[$123>>2];
    $294 = $x$1$i < $293;
    $x$1$1$i = $294 ? $293 : $x$1$i;
    $295 = +HEAPF32[$136>>2];
    $296 = $x$1$1$i < $295;
    $x$1$2$i = $296 ? $295 : $x$1$1$i;
    $297 = +HEAPF32[$137>>2];
    $298 = $x$1$2$i < $297;
    $x$1$3$i = $298 ? $297 : $x$1$2$i;
    $299 = +HEAPF32[$138>>2];
    $300 = $x$1$3$i < $299;
    $x$1$4$i = $300 ? $299 : $x$1$3$i;
    $301 = +HEAPF32[$139>>2];
    $302 = $x$1$4$i < $301;
    $x$1$5$i = $302 ? $301 : $x$1$4$i;
    $303 = +HEAPF32[$140>>2];
    $304 = $x$1$5$i < $303;
    $x$1$6$i = $304 ? $303 : $x$1$5$i;
    $305 = +HEAPF32[$141>>2];
    $306 = $x$1$6$i < $305;
    $x$1$7$i = $306 ? $305 : $x$1$6$i;
    $307 = +HEAPF32[$142>>2];
    $308 = $x$1$7$i < $307;
    $x$1$8$i = $308 ? $307 : $x$1$7$i;
    $309 = +HEAPF32[$143>>2];
    $310 = $x$1$8$i < $309;
    $x$1$9$i = $310 ? $309 : $x$1$8$i;
    $311 = +HEAPF32[$144>>2];
    $312 = $x$1$9$i < $311;
    $x$1$10$i = $312 ? $311 : $x$1$9$i;
    $313 = (((($117)) + 197112|0) + ($chn$125$i<<3)|0);
    $314 = +HEAPF64[$313>>3];
    $315 = ((((($117)) + 197144|0) + ($gr_out<<5)|0) + ($chn$125$i<<3)|0);
    HEAPF64[$315>>3] = $314;
    $316 = $x$1$10$i;
    HEAPF64[$313>>3] = $316;
   }
   $317 = HEAP32[$0>>2]|0;
   $318 = (((($317)) + 6480|0) + ($chn$125$i<<2)|0);
   $319 = +HEAPF32[$318>>2];
   $i$623$i = 0;
   while(1) {
    $330 = (($i$623$i|0) / 3)&-1;
    $331 = ((($ns_attacks) + ($chn$125$i<<4)|0) + ($330<<2)|0);
    $332 = HEAP32[$331>>2]|0;
    $333 = ($332|0)==(0);
    if ($333) {
     $334 = (($thm$i) + ($i$623$i<<2)|0);
     $335 = +HEAPF32[$334>>2];
     $336 = $335 > $319;
     if ($336) {
      $337 = (($i$623$i|0) % 3)&-1;
      $338 = (($337) + 1)|0;
      HEAP32[$331>>2] = $338;
     }
    }
    $339 = (($i$623$i) + 1)|0;
    $exitcond44$i = ($339|0)==(12);
    if ($exitcond44$i) {
     break;
    } else {
     $i$623$i = $339;
    }
   }
   $320 = (($ns_attacks) + ($chn$125$i<<4)|0);
   $321 = +HEAPF32[$en_short$i>>2];
   $322 = +HEAPF32[$133>>2];
   $323 = $321 > $322;
   $324 = $323 ? $321 : $322;
   $325 = $324 < 4.0E+4;
   $326 = $322 * 1.7000000476837158;
   $327 = $321 < $326;
   $or$cond$i = $327 & $325;
   $328 = $321 * 1.7000000476837158;
   $329 = $322 < $328;
   $or$cond7$i = $329 & $or$cond$i;
   if ($or$cond7$i) {
    $340 = HEAP32[$320>>2]|0;
    $341 = (((($ns_attacks) + ($chn$125$i<<4)|0)) + 4|0);
    $342 = HEAP32[$341>>2]|0;
    $343 = ($340|0)>($342|0);
    if (!($343)) {
     HEAP32[$320>>2] = 0;
    }
    HEAP32[$341>>2] = 0;
   }
   $344 = +HEAPF32[$134>>2];
   $345 = $322 > $344;
   $346 = $345 ? $322 : $344;
   $347 = $346 < 4.0E+4;
   $348 = $344 * 1.7000000476837158;
   $349 = $322 < $348;
   $or$cond$1$i = $349 & $347;
   $350 = $344 < $326;
   $or$cond7$1$i = $350 & $or$cond$1$i;
   if ($or$cond7$1$i) {
    $$pre61$i = (((($ns_attacks) + ($chn$125$i<<4)|0)) + 8|0);
    HEAP32[$$pre61$i>>2] = 0;
   }
   $392 = +HEAPF32[$135>>2];
   $393 = $344 > $392;
   $394 = $393 ? $344 : $392;
   $395 = $394 < 4.0E+4;
   $396 = $392 * 1.7000000476837158;
   $397 = $344 < $396;
   $or$cond$2$i = $397 & $395;
   $398 = $392 < $348;
   $or$cond7$2$i = $398 & $or$cond$2$i;
   if ($or$cond7$2$i) {
    $$pre63$i = (((($ns_attacks) + ($chn$125$i<<4)|0)) + 12|0);
    HEAP32[$$pre63$i>>2] = 0;
   }
   $399 = HEAP32[$320>>2]|0;
   $400 = (((($gfc)) + 27780|0) + ($chn$125$i<<2)|0);
   $351 = HEAP32[$400>>2]|0;
   $401 = ($399|0)>($351|0);
   if ($401) {
    $354 = $399;
   } else {
    HEAP32[$320>>2] = 0;
    $354 = 0;
   }
   $352 = ($351|0)==(3);
   $$phi$trans$insert$i = (((($ns_attacks) + ($chn$125$i<<4)|0)) + 4|0);
   $$pre$i = HEAP32[$$phi$trans$insert$i>>2]|0;
   if ($352) {
    label = 47;
   } else {
    $353 = (($$pre$i) + ($354))|0;
    $355 = (((($ns_attacks) + ($chn$125$i<<4)|0)) + 8|0);
    $356 = HEAP32[$355>>2]|0;
    $357 = (($353) + ($356))|0;
    $358 = (((($ns_attacks) + ($chn$125$i<<4)|0)) + 12|0);
    $359 = HEAP32[$358>>2]|0;
    $360 = (0 - ($359))|0;
    $361 = ($357|0)==($360|0);
    if ($361) {
     $ns_uselongblock$0$i = 1;
    } else {
     label = 47;
    }
   }
   do {
    if ((label|0) == 47) {
     label = 0;
     $362 = ($$pre$i|0)==(0);
     do {
      if ($362) {
       $367 = 0;
      } else {
       $363 = ($354|0)==(0);
       if ($363) {
        $367 = $$pre$i;
        break;
       }
       HEAP32[$$phi$trans$insert$i>>2] = 0;
       $367 = 0;
      }
     } while(0);
     $364 = (((($ns_attacks) + ($chn$125$i<<4)|0)) + 8|0);
     $365 = HEAP32[$364>>2]|0;
     $366 = ($365|0)==(0);
     if ($366) {
      $ns_uselongblock$0$i = 0;
      break;
     }
     $368 = ($367|0)==(0);
     if (!($368)) {
      HEAP32[$364>>2] = 0;
      $ns_uselongblock$0$i = 0;
      break;
     }
     $369 = (((($ns_attacks) + ($chn$125$i<<4)|0)) + 12|0);
     $370 = HEAP32[$369>>2]|0;
     $371 = ($370|0)==(0);
     if ($371) {
      $ns_uselongblock$0$i = 0;
      break;
     }
     HEAP32[$369>>2] = 0;
     $ns_uselongblock$0$i = 0;
    }
   } while(0);
   $372 = ($chn$125$i|0)<(2);
   do {
    if ($372) {
     $373 = (($uselongblock) + ($chn$125$i<<2)|0);
     HEAP32[$373>>2] = $ns_uselongblock$0$i;
    } else {
     $374 = ($ns_uselongblock$0$i|0)==(0);
     if (!($374)) {
      break;
     }
     HEAP32[$119>>2] = 0;
     HEAP32[$uselongblock>>2] = 0;
    }
   } while(0);
   $375 = (((($gfc)) + 27620|0) + ($chn$125$i<<2)|0);
   $376 = HEAP32[$375>>2]|0;
   $377 = (($energy) + ($chn$125$i<<2)|0);
   HEAP32[$377>>2] = $376;
   $378 = (($chn$125$i) + 1)|0;
   $exitcond46$i = ($378|0)==($27|0);
   if ($exitcond46$i) {
    break;
   } else {
    $chn$125$i = $378;
   }
  }
 }
 $402 = ((($gfc)) + 184|0);
 $403 = HEAP32[$402>>2]|0;
 $404 = ($403|0)==(1);
 if ($404) {
  $405 = HEAP32[$uselongblock>>2]|0;
  $406 = ($405|0)==(0);
  $$pre8$i = ((($uselongblock)) + 4|0);
  $407 = HEAP32[$$pre8$i>>2]|0;
  $408 = ($407|0)==(0);
  $or$cond75 = $406 | $408;
  if ($or$cond75) {
   HEAP32[$$pre8$i>>2] = 0;
   HEAP32[$uselongblock>>2] = 0;
  }
 }
 $409 = HEAP32[$25>>2]|0;
 $410 = ($409|0)>(0);
 do {
  if ($410) {
   if ((($403|0) == 3)) {
    $chn$01$i$us = 0;
    while(1) {
     $411 = (($uselongblock) + ($chn$01$i$us<<2)|0);
     HEAP32[$411>>2] = 0;
     $412 = (($chn$01$i$us) + 1)|0;
     $413 = ($412|0)<($409|0);
     if ($413) {
      $chn$01$i$us = $412;
     } else {
      break;
     }
    }
   } else if ((($403|0) == 2)) {
    $chn$01$us$i = 0;
    while(1) {
     $414 = (($uselongblock) + ($chn$01$us$i<<2)|0);
     HEAP32[$414>>2] = 1;
     $415 = (($chn$01$us$i) + 1)|0;
     $416 = ($415|0)<($409|0);
     if ($416) {
      $chn$01$us$i = $415;
     } else {
      break;
     }
    }
   } else {
    break;
   }
  }
 } while(0);
 $418 = ($417|0)>(0);
 if ($418) {
  $419 = ((($gfc)) + 85796|0);
  $420 = ((($thm$i)) + 4|0);
  $421 = ((($gfc)) + 84908|0);
  $$pre37$i = ((($avg$i)) + 4|0);
  $422 = ((($gfc)) + 85804|0);
  $chn$0136 = 0;
  while(1) {
   $423 = $chn$0136 & 1;
   $424 = (($wsamp_L) + ($423<<12)|0);
   $425 = HEAP32[$2>>2]|0;
   $426 = ($425|0)==(0);
   if ($426) {
    $460 = 0;
   } else {
    $427 = HEAP32[$422>>2]|0;
    $460 = $427;
   }
   $428 = ($chn$0136|0)<(2);
   if ($428) {
    _fft_long($gfc,$424,$chn$0136,$buffer);
   } else {
    $429 = ($chn$0136|0)==(2);
    if ($429) {
     $$sum73 = (($423) + 1)|0;
     $j$08$i = 1023;
     while(1) {
      $430 = ((($wsamp_L) + ($423<<12)|0) + ($j$08$i<<2)|0);
      $431 = +HEAPF32[$430>>2];
      $432 = ((($wsamp_L) + ($$sum73<<12)|0) + ($j$08$i<<2)|0);
      $433 = +HEAPF32[$432>>2];
      $434 = $433 + $431;
      $435 = $434 * 0.70710676908493042;
      HEAPF32[$430>>2] = $435;
      $436 = $431 - $433;
      $437 = $436 * 0.70710676908493042;
      HEAPF32[$432>>2] = $437;
      $438 = (($j$08$i) + -1)|0;
      $439 = ($j$08$i|0)>(0);
      if ($439) {
       $j$08$i = $438;
      } else {
       break;
      }
     }
    }
   }
   $440 = +HEAPF32[$424>>2];
   $441 = $440 * $440;
   HEAPF32[$fftenergy>>2] = $441;
   $j$17$i = 511;
   while(1) {
    $442 = (512 - ($j$17$i))|0;
    $443 = ((($wsamp_L) + ($423<<12)|0) + ($442<<2)|0);
    $444 = +HEAPF32[$443>>2];
    $445 = (($j$17$i) + 512)|0;
    $446 = ((($wsamp_L) + ($423<<12)|0) + ($445<<2)|0);
    $447 = +HEAPF32[$446>>2];
    $448 = $444 * $444;
    $449 = $447 * $447;
    $450 = $449 + $448;
    $451 = $450 * 0.5;
    $452 = (($fftenergy) + ($442<<2)|0);
    HEAPF32[$452>>2] = $451;
    $453 = (($j$17$i) + -1)|0;
    $454 = ($j$17$i|0)>(0);
    if ($454) {
     $j$17$i = $453;
    } else {
     $j$25$i = 11;$totalenergy$06$i = 0.0;
     break;
    }
   }
   while(1) {
    $455 = (($fftenergy) + ($j$25$i<<2)|0);
    $456 = +HEAPF32[$455>>2];
    $457 = $456 + $totalenergy$06$i;
    $458 = (($j$25$i) + 1)|0;
    $exitcond9$i = ($458|0)==(513);
    if ($exitcond9$i) {
     $$lcssa229 = $457;
     break;
    } else {
     $j$25$i = $458;$totalenergy$06$i = $457;
    }
   }
   $459 = (((($gfc)) + 27620|0) + ($chn$0136<<2)|0);
   HEAPF32[$459>>2] = $$lcssa229;
   $461 = ($460|0)==(0|0);
   if (!($461)) {
    $j$34$i = 0;
    while(1) {
     $462 = ((((($460)) + 90936|0) + ($chn$0136<<13)|0) + ($j$34$i<<3)|0);
     $463 = +HEAPF64[$462>>3];
     $464 = (((((($460)) + 123704|0) + ($gr_out<<15)|0) + ($chn$0136<<13)|0) + ($j$34$i<<3)|0);
     HEAPF64[$464>>3] = $463;
     $465 = (($fftenergy) + ($j$34$i<<2)|0);
     $466 = +HEAPF32[$465>>2];
     $467 = $466;
     HEAPF64[$462>>3] = $467;
     $468 = (($j$34$i) + 1)|0;
     $exitcond$i8 = ($468|0)==(513);
     if ($exitcond$i8) {
      break;
     } else {
      $j$34$i = $468;
     }
    }
   }
   if ($428) {
    $469 = (((($gfc)) + 27612|0) + ($chn$0136<<2)|0);
    $470 = HEAP32[$469>>2]|0;
    $471 = ((((($gfc)) + 27804|0) + ($gr_out<<3)|0) + ($chn$0136<<2)|0);
    HEAP32[$471>>2] = $470;
    $472 = HEAP32[$419>>2]|0;
    $i$01$i$i = 0;$loudness_power$02$i$i = 0.0;
    while(1) {
     $473 = (($fftenergy) + ($i$01$i$i<<2)|0);
     $474 = +HEAPF32[$473>>2];
     $475 = (((($472)) + 724|0) + ($i$01$i$i<<2)|0);
     $476 = +HEAPF32[$475>>2];
     $477 = $476 * $474;
     $478 = $477 + $loudness_power$02$i$i;
     $479 = (($i$01$i$i) + 1)|0;
     $exitcond$i$i = ($479|0)==(512);
     if ($exitcond$i$i) {
      $$lcssa230 = $478;
      break;
     } else {
      $i$01$i$i = $479;$loudness_power$02$i$i = $478;
     }
    }
    $480 = $$lcssa230;
    $481 = $480 * 8.9748713435966334E-12;
    $482 = $481;
    HEAPF32[$469>>2] = $482;
   }
   $483 = HEAP32[$0>>2]|0;
   $484 = ((($483)) + 2148|0);
   $485 = HEAP32[$484>>2]|0;
   $486 = ($485|0)>(0);
   if ($486) {
    $b$08$i$i = 0;$j$07$i$i = 0;
    while(1) {
     $487 = (((($483)) + 1716|0) + ($b$08$i$i<<2)|0);
     $488 = HEAP32[$487>>2]|0;
     $489 = ($488|0)>(0);
     if ($489) {
      $ebb$02$i$i = 0.0;$i$04$i$i = 0;$j$11$i$i = $j$07$i$i;$m$03$i$i = 0.0;
      while(1) {
       $490 = (($fftenergy) + ($j$11$i$i<<2)|0);
       $491 = +HEAPF32[$490>>2];
       $492 = $491 + $ebb$02$i$i;
       $493 = $m$03$i$i < $491;
       $m$1$i$i = $493 ? $491 : $m$03$i$i;
       $494 = (($i$04$i$i) + 1)|0;
       $495 = (($j$11$i$i) + 1)|0;
       $exitcond32$i = ($494|0)==($488|0);
       if ($exitcond32$i) {
        $$lcssa231 = $492;$m$1$i$i$lcssa = $m$1$i$i;
        break;
       } else {
        $ebb$02$i$i = $492;$i$04$i$i = $494;$j$11$i$i = $495;$m$03$i$i = $m$1$i$i;
       }
      }
      $496 = ($488|0)>(1);
      $smax$i$i = $496 ? $488 : 1;
      $497 = (($smax$i$i) + ($j$07$i$i))|0;
      $ebb$0$lcssa$i$i = $$lcssa231;$j$1$lcssa$i$i = $497;$m$0$lcssa$i$i = $m$1$i$i$lcssa;
     } else {
      $ebb$0$lcssa$i$i = 0.0;$j$1$lcssa$i$i = $j$07$i$i;$m$0$lcssa$i$i = 0.0;
     }
     $498 = ((($eb) + ($chn$0136<<8)|0) + ($b$08$i$i<<2)|0);
     HEAPF32[$498>>2] = $ebb$0$lcssa$i$i;
     $499 = (($thm$i) + ($b$08$i$i<<2)|0);
     HEAPF32[$499>>2] = $m$0$lcssa$i$i;
     $500 = (((($483)) + 512|0) + ($b$08$i$i<<2)|0);
     $501 = +HEAPF32[$500>>2];
     $502 = $501 * $ebb$0$lcssa$i$i;
     $503 = (($avg$i) + ($b$08$i$i<<2)|0);
     HEAPF32[$503>>2] = $502;
     $504 = (($b$08$i$i) + 1)|0;
     $exitcond33$i = ($504|0)==($485|0);
     if ($exitcond33$i) {
      break;
     } else {
      $b$08$i$i = $504;$j$07$i$i = $j$1$lcssa$i$i;
     }
    }
    $$pre$i12 = +HEAPF32[$avg$i>>2];
    $$pre34$i = +HEAPF32[$$pre37$i>>2];
    $506 = $$pre34$i;$507 = $$pre$i12;
   } else {
    $506 = 0.0;$507 = 0.0;
   }
   $505 = $507 + $506;
   $508 = $505 > 0.0;
   if ($508) {
    $509 = +HEAPF32[$thm$i>>2];
    $510 = +HEAPF32[$420>>2];
    $511 = $509 < $510;
    $m$0$i$i = $511 ? $510 : $509;
    $512 = $m$0$i$i * 2.0;
    $513 = $512 - $505;
    $514 = $513 * 20.0;
    $515 = ((($483)) + 1716|0);
    $516 = HEAP32[$515>>2]|0;
    $517 = ((($483)) + 1720|0);
    $518 = HEAP32[$517>>2]|0;
    $519 = (($516) + -1)|0;
    $520 = (($519) + ($518))|0;
    $521 = (+($520|0));
    $522 = $521 * $505;
    $523 = $514 / $522;
    $524 = (~~(($523)));
    $525 = ($524|0)>(8);
    $526 = $524&255;
    $527 = $525 ? 8 : $526;
    $storemerge$i$i = $527;
   } else {
    $storemerge$i$i = 0;
   }
   HEAP8[$mask_idx_s$i>>0] = $storemerge$i$i;
   $528 = (($485) + -1)|0;
   $529 = ($528|0)>(1);
   $530 = +HEAPF32[$$pre37$i>>2];
   $531 = $530 + $507;
   if ($529) {
    $532 = ($528|0)>(2);
    $537 = $531;$540 = 0;$569 = $530;$b$02$i$i = 1;
    while(1) {
     $533 = (($b$02$i$i) + 1)|0;
     $534 = (($avg$i) + ($533<<2)|0);
     $535 = +HEAPF32[$534>>2];
     $536 = $535 + $537;
     $538 = $536 > 0.0;
     if ($538) {
      $539 = (($thm$i) + ($540<<2)|0);
      $541 = +HEAPF32[$539>>2];
      $542 = (($thm$i) + ($b$02$i$i<<2)|0);
      $543 = +HEAPF32[$542>>2];
      $544 = $541 < $543;
      $m$1$i2$i = $544 ? $543 : $541;
      $545 = (($thm$i) + ($533<<2)|0);
      $546 = +HEAPF32[$545>>2];
      $547 = $m$1$i2$i < $546;
      $m$2$i$i = $547 ? $546 : $m$1$i2$i;
      $548 = $m$2$i$i * 3.0;
      $549 = $548 - $536;
      $550 = $549 * 20.0;
      $551 = (((($483)) + 1716|0) + ($540<<2)|0);
      $552 = HEAP32[$551>>2]|0;
      $553 = (((($483)) + 1716|0) + ($b$02$i$i<<2)|0);
      $554 = HEAP32[$553>>2]|0;
      $555 = (((($483)) + 1716|0) + ($533<<2)|0);
      $556 = HEAP32[$555>>2]|0;
      $557 = (($552) + -1)|0;
      $558 = (($557) + ($554))|0;
      $559 = (($558) + ($556))|0;
      $560 = (+($559|0));
      $561 = $560 * $536;
      $562 = $550 / $561;
      $563 = (~~(($562)));
      $564 = ($563|0)>(8);
      $565 = $563&255;
      $566 = $564 ? 8 : $565;
      $$sink$i$i = $566;
     } else {
      $$sink$i$i = 0;
     }
     $567 = (($mask_idx_s$i) + ($b$02$i$i)|0);
     HEAP8[$567>>0] = $$sink$i$i;
     $568 = $535 + $569;
     $exitcond173 = ($533|0)==($528|0);
     if ($exitcond173) {
      $$lcssa232 = $568;
      break;
     } else {
      $540$phi = $b$02$i$i;$537 = $568;$569 = $535;$b$02$i$i = $533;$540 = $540$phi;
     }
    }
    $smax$i = $532 ? $528 : 2;
    $570 = (($smax$i) + -1)|0;
    $$lcssa$i$i = $570;$$lcssa1$i$i = $$lcssa232;$b$0$lcssa$i$i = $smax$i;
   } else {
    $$lcssa$i$i = 0;$$lcssa1$i$i = $531;$b$0$lcssa$i$i = 1;
   }
   $571 = $$lcssa1$i$i > 0.0;
   if ($571) {
    $572 = (($thm$i) + ($$lcssa$i$i<<2)|0);
    $573 = +HEAPF32[$572>>2];
    $574 = (($thm$i) + ($b$0$lcssa$i$i<<2)|0);
    $575 = +HEAPF32[$574>>2];
    $576 = $573 < $575;
    $m$3$i$i = $576 ? $575 : $573;
    $577 = $m$3$i$i * 2.0;
    $578 = $577 - $$lcssa1$i$i;
    $579 = $578 * 20.0;
    $580 = (((($483)) + 1716|0) + ($$lcssa$i$i<<2)|0);
    $581 = HEAP32[$580>>2]|0;
    $582 = (((($483)) + 1716|0) + ($b$0$lcssa$i$i<<2)|0);
    $583 = HEAP32[$582>>2]|0;
    $584 = (($581) + -1)|0;
    $585 = (($584) + ($583))|0;
    $586 = (+($585|0));
    $587 = $586 * $$lcssa1$i$i;
    $588 = $579 / $587;
    $589 = (~~(($588)));
    $590 = ($589|0)>(8);
    $591 = $589&255;
    $592 = $590 ? 8 : $591;
    $$sink7$i$i = $592;
   } else {
    $$sink7$i$i = 0;
   }
   $593 = (($mask_idx_s$i) + ($b$0$lcssa$i$i)|0);
   HEAP8[$593>>0] = $$sink7$i$i;
   if ($486) {
    $594 = ((($483)) + 2156|0);
    $595 = (((($gfc)) + 27796|0) + ($423<<2)|0);
    $b$019$i = 0;$k$020$i = 0;
    while(1) {
     $599 = (($483) + ($b$019$i<<2)|0);
     $600 = +HEAPF32[$599>>2];
     $601 = +HEAPF32[$421>>2];
     $602 = $601 * $600;
     $603 = (((($483)) + 1204|0) + ($b$019$i<<3)|0);
     $604 = HEAP32[$603>>2]|0;
     $605 = (((((($483)) + 1204|0) + ($b$019$i<<3)|0)) + 4|0);
     $606 = HEAP32[$605>>2]|0;
     $607 = (($mask_idx_s$i) + ($b$019$i)|0);
     $608 = HEAP8[$607>>0]|0;
     $609 = $608&255;
     $610 = (11448 + ($609<<2)|0);
     $611 = HEAP32[$610>>2]|0;
     $612 = (($mask_idx_s$i) + ($604)|0);
     $613 = HEAP8[$612>>0]|0;
     $614 = $613&255;
     $615 = HEAP32[$594>>2]|0;
     $616 = (($615) + ($k$020$i<<2)|0);
     $617 = +HEAPF32[$616>>2];
     $618 = ((($eb) + ($chn$0136<<8)|0) + ($604<<2)|0);
     $619 = +HEAPF32[$618>>2];
     $620 = $619 * $617;
     $621 = (11488 + ($614<<2)|0);
     $622 = +HEAPF32[$621>>2];
     $623 = $620 * $622;
     $k$17$i = (($k$020$i) + 1)|0;
     $624 = ($604|0)<($606|0);
     if ($624) {
      $630 = $615;$dd$010$i = $614;$ecb$09$i = $623;$k$112$i = $k$17$i;$kk$013$in$i = $604;
      while(1) {
       $kk$013$i = (($kk$013$in$i) + 1)|0;
       $625 = (($mask_idx_s$i) + ($kk$013$i)|0);
       $626 = HEAP8[$625>>0]|0;
       $627 = $626&255;
       $628 = (($627) + ($dd$010$i))|0;
       $629 = (($630) + ($k$112$i<<2)|0);
       $631 = +HEAPF32[$629>>2];
       $632 = ((($eb) + ($chn$0136<<8)|0) + ($kk$013$i<<2)|0);
       $633 = +HEAPF32[$632>>2];
       $634 = $633 * $631;
       $635 = (11488 + ($627<<2)|0);
       $636 = +HEAPF32[$635>>2];
       $637 = $634 * $636;
       $638 = (($kk$013$i) - ($b$019$i))|0;
       $639 = $ecb$09$i < 0.0;
       $$01$i$i = $639 ? 0.0 : $ecb$09$i;
       $640 = $637 < 0.0;
       $$02$i$i = $640 ? 0.0 : $637;
       $641 = !($$01$i$i <= 0.0);
       do {
        if ($641) {
         $642 = !($$02$i$i <= 0.0);
         if (!($642)) {
          $ecb$0$be$i = $$01$i$i;
          break;
         }
         $643 = $$02$i$i > $$01$i$i;
         $644 = $$02$i$i / $$01$i$i;
         $645 = $$01$i$i / $$02$i$i;
         $ratio$0$i$i = $643 ? $644 : $645;
         $ispos$i$i = ($638|0)>(-1);
         $neg$i$i = (0 - ($638))|0;
         $646 = $ispos$i$i ? $638 : $neg$i$i;
         $647 = ($646|0)>($611|0);
         if ($647) {
          $659 = +HEAPF32[11576>>2];
          $660 = $ratio$0$i$i < $659;
          if ($660) {
           $661 = $$02$i$i + $$01$i$i;
           $ecb$0$be$i = $661;
           break;
          } else {
           $$1$i$i = $643 ? $$02$i$i : $$01$i$i;
           $ecb$0$be$i = $$1$i$i;
           break;
          }
         } else {
          $648 = +HEAPF32[11528>>2];
          $649 = !($ratio$0$i$i >= $648);
          if ($649) {
           $651 = (+_fast_log2($ratio$0$i$i));
           $652 = $651;
           $653 = $652 * 4.8164799306236983;
           $654 = (~~(($653)));
           $655 = $$02$i$i + $$01$i$i;
           $656 = (11536 + ($654<<2)|0);
           $657 = +HEAPF32[$656>>2];
           $658 = $657 * $655;
           $ecb$0$be$i = $658;
           break;
          } else {
           $650 = $$02$i$i + $$01$i$i;
           $ecb$0$be$i = $650;
           break;
          }
         }
        } else {
         $ecb$0$be$i = $$02$i$i;
        }
       } while(0);
       $exitcond31$i = ($kk$013$i|0)==($606|0);
       if ($exitcond31$i) {
        $$lcssa233 = $628;$ecb$0$be$i$lcssa = $ecb$0$be$i;
        break;
       }
       $k$1$i = (($k$112$i) + 1)|0;
       $$pre35$i = HEAP32[$594>>2]|0;
       $630 = $$pre35$i;$dd$010$i = $628;$ecb$09$i = $ecb$0$be$i;$k$112$i = $k$1$i;$kk$013$in$i = $kk$013$i;
      }
      $662 = (($k$17$i) - ($604))|0;
      $663 = (($662) + ($606))|0;
      $664 = (1 - ($604))|0;
      $665 = (($664) + ($606))|0;
      $dd$0$lcssa$i = $$lcssa233;$dd_n$0$lcssa$i = $665;$ecb$0$lcssa$i = $ecb$0$be$i$lcssa;$k$1$lcssa$i = $663;
     } else {
      $dd$0$lcssa$i = $614;$dd_n$0$lcssa$i = 1;$ecb$0$lcssa$i = $623;$k$1$lcssa$i = $k$17$i;
     }
     $666 = $dd$0$lcssa$i << 1;
     $667 = $666 | 1;
     $668 = $dd_n$0$lcssa$i << 1;
     $669 = (($667|0) / ($668|0))&-1;
     $670 = (11488 + ($669<<2)|0);
     $671 = +HEAPF32[$670>>2];
     $672 = $671 * 0.5;
     $673 = $672 * $ecb$0$lcssa$i;
     $674 = HEAP32[$595>>2]|0;
     $675 = ($674|0)==(2);
     do {
      if ($675) {
       $676 = ((((($gfc)) + 21564|0) + ($chn$0136<<8)|0) + ($b$019$i<<2)|0);
       $677 = +HEAPF32[$676>>2];
       $678 = $677 * 2.0;
       $679 = $678 > 0.0;
       if ($679) {
        $680 = $673 < $678;
        $681 = $680 ? $673 : $678;
        $682 = ((($thr) + ($chn$0136<<8)|0) + ($b$019$i<<2)|0);
        HEAPF32[$682>>2] = $681;
        $$pre$phi$iZ2D = $676;$$pre$phi36$iZ2D = $682;$714 = $681;
        break;
       } else {
        $683 = $673;
        $684 = ((($eb) + ($chn$0136<<8)|0) + ($b$019$i<<2)|0);
        $685 = +HEAPF32[$684>>2];
        $686 = $685;
        $687 = $686 * 0.29999999999999999;
        $688 = $683 < $687;
        $$$i = $688 ? $683 : $687;
        $689 = $$$i;
        $690 = ((($thr) + ($chn$0136<<8)|0) + ($b$019$i<<2)|0);
        HEAPF32[$690>>2] = $689;
        $$pre$phi$iZ2D = $676;$$pre$phi36$iZ2D = $690;$714 = $689;
        break;
       }
      } else {
       $691 = ((((($gfc)) + 22588|0) + ($chn$0136<<8)|0) + ($b$019$i<<2)|0);
       $692 = +HEAPF32[$691>>2];
       $693 = $692 * 16.0;
       $694 = ((((($gfc)) + 21564|0) + ($chn$0136<<8)|0) + ($b$019$i<<2)|0);
       $695 = +HEAPF32[$694>>2];
       $696 = $695 * 2.0;
       $697 = !($693 <= 0.0);
       $ecb_limit_2$0$i = $697 ? $693 : $673;
       $698 = !($696 <= 0.0);
       $ecb_limit_1$0$i = $698 ? $696 : $673;
       $699 = ($674|0)==(0);
       $700 = $ecb_limit_1$0$i < $ecb_limit_2$0$i;
       $701 = $700 ? $ecb_limit_1$0$i : $ecb_limit_2$0$i;
       $ecb_limit1$0$i = $699 ? $701 : $ecb_limit_1$0$i;
       $702 = $673 < $ecb_limit1$0$i;
       $703 = $702 ? $673 : $ecb_limit1$0$i;
       $704 = ((($thr) + ($chn$0136<<8)|0) + ($b$019$i<<2)|0);
       HEAPF32[$704>>2] = $703;
       $$pre$phi$iZ2D = $694;$$pre$phi36$iZ2D = $704;$714 = $703;
      }
     } while(0);
     $705 = HEAP32[$$pre$phi$iZ2D>>2]|0;
     $706 = ((((($gfc)) + 22588|0) + ($chn$0136<<8)|0) + ($b$019$i<<2)|0);
     HEAP32[$706>>2] = $705;
     HEAPF32[$$pre$phi$iZ2D>>2] = $673;
     $707 = (($thm$i) + ($b$019$i<<2)|0);
     $708 = +HEAPF32[$707>>2];
     $709 = (((($483)) + 256|0) + ($b$019$i<<2)|0);
     $710 = +HEAPF32[$709>>2];
     $711 = $708 * $672;
     $712 = $711 * $710;
     $713 = $714 > $712;
     if ($713) {
      HEAPF32[$$pre$phi36$iZ2D>>2] = $712;
      $717 = $712;
     } else {
      $717 = $714;
     }
     $715 = $602 > 1.0;
     if ($715) {
      $716 = $717 * $602;
      HEAPF32[$$pre$phi36$iZ2D>>2] = $716;
      $721 = $716;
     } else {
      $721 = $717;
     }
     $718 = ((($eb) + ($chn$0136<<8)|0) + ($b$019$i<<2)|0);
     $719 = +HEAPF32[$718>>2];
     $720 = $721 > $719;
     if ($720) {
      HEAPF32[$$pre$phi36$iZ2D>>2] = $719;
      $724 = $719;
     } else {
      $724 = $721;
     }
     $722 = $602 < 1.0;
     if ($722) {
      $723 = $724 * $602;
      HEAPF32[$$pre$phi36$iZ2D>>2] = $723;
     }
     $725 = (($b$019$i) + 1)|0;
     $726 = HEAP32[$484>>2]|0;
     $727 = ($725|0)<($726|0);
     if ($727) {
      $b$019$i = $725;$k$020$i = $k$1$lcssa$i;
     } else {
      $$lcssa234 = $725;
      break;
     }
    }
    $596 = ($$lcssa234|0)<(64);
    if ($596) {
     $b$16$i$ph = $$lcssa234;
     label = 114;
    }
   } else {
    $b$16$i$ph = 0;
    label = 114;
   }
   if ((label|0) == 114) {
    label = 0;
    $scevgep175 = ((($eb) + ($chn$0136<<8)|0) + ($b$16$i$ph<<2)|0);
    $597 = $b$16$i$ph << 2;
    $598 = (256 - ($597))|0;
    _memset(($scevgep175|0),0,($598|0))|0;
    $scevgep178 = ((($thr) + ($chn$0136<<8)|0) + ($b$16$i$ph<<2)|0);
    _memset(($scevgep178|0),0,($598|0))|0;
   }
   $728 = (($chn$0136) + 1)|0;
   $exitcond180 = ($728|0)==($417|0);
   if ($exitcond180) {
    break;
   } else {
    $chn$0136 = $728;
   }
  }
 }
 $729 = HEAP32[$17>>2]|0;
 $730 = ($729|0)==(1);
 if ($730) {
  $731 = HEAP32[$uselongblock>>2]|0;
  $732 = ((($uselongblock)) + 4|0);
  $733 = HEAP32[$732>>2]|0;
  $734 = (($733) + ($731))|0;
  $735 = ($734|0)==(2);
  if ($735) {
   $736 = ((($1)) + 768|0);
   $737 = ((($gfc)) + 85796|0);
   $738 = HEAP32[$737>>2]|0;
   $739 = ((($738)) + 212|0);
   $740 = +HEAPF32[$7>>2];
   $741 = ((($1)) + 2148|0);
   $742 = HEAP32[$741>>2]|0;
   _vbrpsy_compute_MS_thresholds($eb,$thr,$736,$739,$743,$740,$742);
  }
 }
 if ($418) {
  $chn$1133 = 0;
  while(1) {
   $744 = (($eb) + ($chn$1133<<8)|0);
   $745 = (($thr) + ($chn$1133<<8)|0);
   $746 = HEAP32[$0>>2]|0;
   $747 = (((($gfc)) + 26636|0) + (($chn$1133*244)|0)|0);
   $748 = (((($gfc)) + 25660|0) + (($chn$1133*244)|0)|0);
   _convert_partition2scalefac($746,$744,$745,$747,$748);
   $749 = HEAP32[$0>>2]|0;
   $750 = ((($749)) + 4320|0);
   _convert_partition2scalefac($750,$744,$745,$mask_idx_s$i,$thm$i);
   $sb$02$i = 0;
   while(1) {
    $751 = (($mask_idx_s$i) + ($sb$02$i<<2)|0);
    $752 = HEAP32[$751>>2]|0;
    $753 = (($thm$i) + ($sb$02$i<<2)|0);
    $754 = +HEAPF32[$753>>2];
    $755 = $754 * 0.015625;
    $756 = ((((((($gfc)) + 26636|0) + (($chn$1133*244)|0)|0)) + 88|0) + (($sb$02$i*12)|0)|0);
    HEAP32[$756>>2] = $752;
    $757 = ((((((($gfc)) + 25660|0) + (($chn$1133*244)|0)|0)) + 88|0) + (($sb$02$i*12)|0)|0);
    HEAPF32[$757>>2] = $755;
    $758 = ((((((((($gfc)) + 26636|0) + (($chn$1133*244)|0)|0)) + 88|0) + (($sb$02$i*12)|0)|0)) + 4|0);
    HEAP32[$758>>2] = $752;
    $759 = ((((((((($gfc)) + 25660|0) + (($chn$1133*244)|0)|0)) + 88|0) + (($sb$02$i*12)|0)|0)) + 4|0);
    HEAPF32[$759>>2] = $755;
    $760 = ((((((((($gfc)) + 26636|0) + (($chn$1133*244)|0)|0)) + 88|0) + (($sb$02$i*12)|0)|0)) + 8|0);
    HEAP32[$760>>2] = $752;
    $761 = ((((((((($gfc)) + 25660|0) + (($chn$1133*244)|0)|0)) + 88|0) + (($sb$02$i*12)|0)|0)) + 8|0);
    HEAPF32[$761>>2] = $755;
    $762 = (($sb$02$i) + 1)|0;
    $exitcond$i17 = ($762|0)==(13);
    if ($exitcond$i17) {
     break;
    } else {
     $sb$02$i = $762;
    }
   }
   $763 = (($chn$1133) + 1)|0;
   $exitcond170 = ($763|0)==($417|0);
   if ($exitcond170) {
    break;
   } else {
    $chn$1133 = $763;
   }
  }
 }
 $764 = HEAP32[$0>>2]|0;
 $765 = ((($764)) + 6500|0);
 $766 = HEAP32[$765>>2]|0;
 $767 = HEAP32[$uselongblock>>2]|0;
 $768 = ((($uselongblock)) + 4|0);
 $769 = HEAP32[$768>>2]|0;
 $770 = (0 - ($769))|0;
 $771 = ((($1)) + 2928|0);
 $772 = ((($gfc)) + 85796|0);
 $773 = ((($1)) + 4308|0);
 $774 = ($766|0)!=(0);
 $775 = ((($mask_idx_s$i)) + 4|0);
 $776 = ((($thm$i)) + 4|0);
 $777 = ((($mask_idx_s$i)) + 8|0);
 $778 = ((($thm$i)) + 8|0);
 $779 = ((($mask_idx_s$i)) + 12|0);
 $780 = ((($thm$i)) + 12|0);
 $781 = ((($mask_idx_s$i)) + 16|0);
 $782 = ((($thm$i)) + 16|0);
 $783 = ((($mask_idx_s$i)) + 20|0);
 $784 = ((($thm$i)) + 20|0);
 $785 = ((($mask_idx_s$i)) + 24|0);
 $786 = ((($thm$i)) + 24|0);
 $787 = ((($mask_idx_s$i)) + 28|0);
 $788 = ((($thm$i)) + 28|0);
 $789 = ((($mask_idx_s$i)) + 32|0);
 $790 = ((($thm$i)) + 32|0);
 $791 = ((($mask_idx_s$i)) + 36|0);
 $792 = ((($thm$i)) + 36|0);
 $793 = ((($mask_idx_s$i)) + 40|0);
 $794 = ((($thm$i)) + 40|0);
 $795 = ((($mask_idx_s$i)) + 44|0);
 $796 = ((($thm$i)) + 44|0);
 $797 = ((($mask_idx_s$i)) + 48|0);
 $798 = ((($thm$i)) + 48|0);
 $799 = ((($thm$i)) + 4|0);
 $800 = ((($gfc)) + 84908|0);
 $$pre52$i = ((($avg$i)) + 4|0);
 $$not203 = ($767|0)!=($770|0);
 $sblock$0130 = 0;
 while(1) {
  if ($418) {
   $801 = ($sblock$0130|0)==(0);
   $802 = (($fftenergy_s) + (($sblock$0130*516)|0)|0);
   $chn$2120 = 0;
   while(1) {
    $803 = $chn$2120 & 1;
    $804 = (($uselongblock) + ($803<<2)|0);
    $805 = HEAP32[$804>>2]|0;
    $806 = ($805|0)==(0);
    $or$cond = $774 | $806;
    if ($or$cond) {
     $815 = ($chn$2120|0)<(2);
     $or$cond$i20 = $801 & $815;
     if ($or$cond$i20) {
      $816 = (($wsamp_S) + (($803*3072)|0)|0);
      _fft_short($gfc,$816,$chn$2120,$buffer);
     }
     $817 = ($chn$2120|0)==(2);
     if ($817) {
      $$sum = (($803) + 1)|0;
      $j$03$i = 255;
      while(1) {
       $818 = (((($wsamp_S) + (($803*3072)|0)|0) + ($sblock$0130<<10)|0) + ($j$03$i<<2)|0);
       $819 = +HEAPF32[$818>>2];
       $820 = (((($wsamp_S) + (($$sum*3072)|0)|0) + ($sblock$0130<<10)|0) + ($j$03$i<<2)|0);
       $821 = +HEAPF32[$820>>2];
       $822 = $821 + $819;
       $823 = $822 * 0.70710676908493042;
       HEAPF32[$818>>2] = $823;
       $824 = $819 - $821;
       $825 = $824 * 0.70710676908493042;
       HEAPF32[$820>>2] = $825;
       $826 = (($j$03$i) + -1)|0;
       $827 = ($j$03$i|0)>(0);
       if ($827) {
        $j$03$i = $826;
       } else {
        break;
       }
      }
     }
     $828 = ((($wsamp_S) + (($803*3072)|0)|0) + ($sblock$0130<<10)|0);
     $829 = +HEAPF32[$828>>2];
     $830 = $829 * $829;
     HEAPF32[$802>>2] = $830;
     $j$12$i = 127;
     while(1) {
      $831 = (128 - ($j$12$i))|0;
      $832 = (((($wsamp_S) + (($803*3072)|0)|0) + ($sblock$0130<<10)|0) + ($831<<2)|0);
      $833 = +HEAPF32[$832>>2];
      $834 = (($j$12$i) + 128)|0;
      $835 = (((($wsamp_S) + (($803*3072)|0)|0) + ($sblock$0130<<10)|0) + ($834<<2)|0);
      $836 = +HEAPF32[$835>>2];
      $837 = $833 * $833;
      $838 = $836 * $836;
      $839 = $838 + $837;
      $840 = $839 * 0.5;
      $841 = ((($fftenergy_s) + (($sblock$0130*516)|0)|0) + ($831<<2)|0);
      HEAPF32[$841>>2] = $840;
      $842 = (($j$12$i) + -1)|0;
      $843 = ($j$12$i|0)>(0);
      if ($843) {
       $j$12$i = $842;
      } else {
       break;
      }
     }
     $844 = HEAP32[$0>>2]|0;
     _memset(($thm$i|0),0,256)|0;
     _memset(($avg$i|0),0,256)|0;
     $845 = ((($844)) + 4308|0);
     $846 = HEAP32[$845>>2]|0;
     $847 = ($846|0)>(0);
     if ($847) {
      $b$030$i = 0;$j$031$i = 0;
      while(1) {
       $848 = (((($844)) + 3876|0) + ($b$030$i<<2)|0);
       $849 = HEAP32[$848>>2]|0;
       $850 = ($849|0)>(0);
       if ($850) {
        $ebb$021$i = 0.0;$i$023$i = 0;$j$122$i = $j$031$i;$m$020$i = 0.0;
        while(1) {
         $851 = ((($fftenergy_s) + (($sblock$0130*516)|0)|0) + ($j$122$i<<2)|0);
         $852 = +HEAPF32[$851>>2];
         $853 = $852 + $ebb$021$i;
         $854 = $m$020$i < $852;
         $m$1$i = $854 ? $852 : $m$020$i;
         $855 = (($i$023$i) + 1)|0;
         $856 = (($j$122$i) + 1)|0;
         $exitcond46$i25 = ($855|0)==($849|0);
         if ($exitcond46$i25) {
          $$lcssa = $853;$m$1$i$lcssa = $m$1$i;
          break;
         } else {
          $ebb$021$i = $853;$i$023$i = $855;$j$122$i = $856;$m$020$i = $m$1$i;
         }
        }
        $857 = (($849) + ($j$031$i))|0;
        $ebb$0$lcssa$i = $$lcssa;$j$1$lcssa$i = $857;$m$0$lcssa$i = $m$1$i$lcssa;
       } else {
        $ebb$0$lcssa$i = 0.0;$j$1$lcssa$i = $j$031$i;$m$0$lcssa$i = 0.0;
       }
       $858 = ((($eb) + ($chn$2120<<8)|0) + ($b$030$i<<2)|0);
       HEAPF32[$858>>2] = $ebb$0$lcssa$i;
       $859 = (($thm$i) + ($b$030$i<<2)|0);
       HEAPF32[$859>>2] = $m$0$lcssa$i;
       $860 = (((($844)) + 2672|0) + ($b$030$i<<2)|0);
       $861 = +HEAPF32[$860>>2];
       $862 = $861 * $ebb$0$lcssa$i;
       $863 = (($avg$i) + ($b$030$i<<2)|0);
       HEAPF32[$863>>2] = $862;
       $864 = (($b$030$i) + 1)|0;
       $exitcond159 = ($864|0)==($846|0);
       if ($exitcond159) {
        break;
       } else {
        $b$030$i = $864;$j$031$i = $j$1$lcssa$i;
       }
      }
      $$pre$i27 = +HEAPF32[$avg$i>>2];
      $$pre48$i = +HEAPF32[$$pre52$i>>2];
      $866 = $$pre48$i;$867 = $$pre$i27;
     } else {
      $866 = 0.0;$867 = 0.0;
     }
     $865 = $867 + $866;
     $868 = $865 > 0.0;
     if ($868) {
      $869 = +HEAPF32[$thm$i>>2];
      $870 = +HEAPF32[$799>>2];
      $871 = $869 < $870;
      $m$0$i$i29 = $871 ? $870 : $869;
      $872 = $m$0$i$i29 * 2.0;
      $873 = $872 - $865;
      $874 = $873 * 20.0;
      $875 = ((($844)) + 3876|0);
      $876 = HEAP32[$875>>2]|0;
      $877 = ((($844)) + 3880|0);
      $878 = HEAP32[$877>>2]|0;
      $879 = (($876) + -1)|0;
      $880 = (($879) + ($878))|0;
      $881 = (+($880|0));
      $882 = $881 * $865;
      $883 = $874 / $882;
      $884 = (~~(($883)));
      $885 = ($884|0)>(8);
      $886 = $884&255;
      $887 = $885 ? 8 : $886;
      $storemerge$i$i30 = $887;
     } else {
      $storemerge$i$i30 = 0;
     }
     HEAP8[$mask_idx_s$i>>0] = $storemerge$i$i30;
     $888 = (($846) + -1)|0;
     $889 = ($888|0)>(1);
     $890 = $866 + $867;
     if ($889) {
      $891 = ($888|0)>(2);
      $896 = $890;$899 = 0;$928 = $866;$b$02$i$i32 = 1;
      while(1) {
       $892 = (($b$02$i$i32) + 1)|0;
       $893 = (($avg$i) + ($892<<2)|0);
       $894 = +HEAPF32[$893>>2];
       $895 = $894 + $896;
       $897 = $895 > 0.0;
       if ($897) {
        $898 = (($thm$i) + ($899<<2)|0);
        $900 = +HEAPF32[$898>>2];
        $901 = (($thm$i) + ($b$02$i$i32<<2)|0);
        $902 = +HEAPF32[$901>>2];
        $903 = $900 < $902;
        $m$1$i$i34 = $903 ? $902 : $900;
        $904 = (($thm$i) + ($892<<2)|0);
        $905 = +HEAPF32[$904>>2];
        $906 = $m$1$i$i34 < $905;
        $m$2$i$i35 = $906 ? $905 : $m$1$i$i34;
        $907 = $m$2$i$i35 * 3.0;
        $908 = $907 - $895;
        $909 = $908 * 20.0;
        $910 = (((($844)) + 3876|0) + ($899<<2)|0);
        $911 = HEAP32[$910>>2]|0;
        $912 = (((($844)) + 3876|0) + ($b$02$i$i32<<2)|0);
        $913 = HEAP32[$912>>2]|0;
        $914 = (((($844)) + 3876|0) + ($892<<2)|0);
        $915 = HEAP32[$914>>2]|0;
        $916 = (($911) + -1)|0;
        $917 = (($916) + ($913))|0;
        $918 = (($917) + ($915))|0;
        $919 = (+($918|0));
        $920 = $919 * $895;
        $921 = $909 / $920;
        $922 = (~~(($921)));
        $923 = ($922|0)>(8);
        $924 = $922&255;
        $925 = $923 ? 8 : $924;
        $$sink$i$i36 = $925;
       } else {
        $$sink$i$i36 = 0;
       }
       $926 = (($mask_idx_s$i) + ($b$02$i$i32)|0);
       HEAP8[$926>>0] = $$sink$i$i36;
       $927 = $894 + $928;
       $exitcond160 = ($892|0)==($888|0);
       if ($exitcond160) {
        $$lcssa226 = $927;
        break;
       } else {
        $899$phi = $b$02$i$i32;$896 = $927;$928 = $894;$b$02$i$i32 = $892;$899 = $899$phi;
       }
      }
      $smax$i31 = $891 ? $888 : 2;
      $929 = (($smax$i31) + -1)|0;
      $$lcssa$i$i39 = $929;$$lcssa1$i$i38 = $$lcssa226;$b$0$lcssa$i$i40 = $smax$i31;
     } else {
      $$lcssa$i$i39 = 0;$$lcssa1$i$i38 = $890;$b$0$lcssa$i$i40 = 1;
     }
     $930 = $$lcssa1$i$i38 > 0.0;
     if ($930) {
      $931 = (($thm$i) + ($$lcssa$i$i39<<2)|0);
      $932 = +HEAPF32[$931>>2];
      $933 = (($thm$i) + ($b$0$lcssa$i$i40<<2)|0);
      $934 = +HEAPF32[$933>>2];
      $935 = $932 < $934;
      $m$3$i$i42 = $935 ? $934 : $932;
      $936 = $m$3$i$i42 * 2.0;
      $937 = $936 - $$lcssa1$i$i38;
      $938 = $937 * 20.0;
      $939 = (((($844)) + 3876|0) + ($$lcssa$i$i39<<2)|0);
      $940 = HEAP32[$939>>2]|0;
      $941 = (((($844)) + 3876|0) + ($b$0$lcssa$i$i40<<2)|0);
      $942 = HEAP32[$941>>2]|0;
      $943 = (($940) + -1)|0;
      $944 = (($943) + ($942))|0;
      $945 = (+($944|0));
      $946 = $945 * $$lcssa1$i$i38;
      $947 = $938 / $946;
      $948 = (~~(($947)));
      $949 = ($948|0)>(8);
      $950 = $948&255;
      $951 = $949 ? 8 : $950;
      $$sink7$i$i43 = $951;
     } else {
      $$sink7$i$i43 = 0;
     }
     $952 = (($mask_idx_s$i) + ($b$0$lcssa$i$i40)|0);
     HEAP8[$952>>0] = $$sink7$i$i43;
     if ($847) {
      $953 = ((($844)) + 4316|0);
      $b$116$i = 0;$j$217$i = 0;
      while(1) {
       $957 = (((($844)) + 3364|0) + ($b$116$i<<3)|0);
       $958 = HEAP32[$957>>2]|0;
       $959 = (((((($844)) + 3364|0) + ($b$116$i<<3)|0)) + 4|0);
       $960 = HEAP32[$959>>2]|0;
       $961 = (($mask_idx_s$i) + ($b$116$i)|0);
       $962 = HEAP8[$961>>0]|0;
       $963 = $962&255;
       $964 = (11448 + ($963<<2)|0);
       $965 = HEAP32[$964>>2]|0;
       $966 = (((($844)) + 2160|0) + ($b$116$i<<2)|0);
       $967 = +HEAPF32[$966>>2];
       $968 = +HEAPF32[$800>>2];
       $969 = $968 * $967;
       $970 = (($mask_idx_s$i) + ($958)|0);
       $971 = HEAP8[$970>>0]|0;
       $972 = $971&255;
       $973 = HEAP32[$953>>2]|0;
       $974 = (($973) + ($j$217$i<<2)|0);
       $975 = +HEAPF32[$974>>2];
       $976 = ((($eb) + ($chn$2120<<8)|0) + ($958<<2)|0);
       $977 = +HEAPF32[$976>>2];
       $978 = $977 * $975;
       $979 = (11488 + ($972<<2)|0);
       $980 = +HEAPF32[$979>>2];
       $981 = $978 * $980;
       $j$34$i45 = (($j$217$i) + 1)|0;
       $982 = ($958|0)<($960|0);
       if ($982) {
        $988 = $973;$dd$06$i = $972;$ecb$08$i = $981;$j$39$i = $j$34$i45;$kk$010$in$i = $958;
        while(1) {
         $kk$010$i = (($kk$010$in$i) + 1)|0;
         $983 = (($mask_idx_s$i) + ($kk$010$i)|0);
         $984 = HEAP8[$983>>0]|0;
         $985 = $984&255;
         $986 = (($985) + ($dd$06$i))|0;
         $987 = (($988) + ($j$39$i<<2)|0);
         $989 = +HEAPF32[$987>>2];
         $990 = ((($eb) + ($chn$2120<<8)|0) + ($kk$010$i<<2)|0);
         $991 = +HEAPF32[$990>>2];
         $992 = $991 * $989;
         $993 = (11488 + ($985<<2)|0);
         $994 = +HEAPF32[$993>>2];
         $995 = $992 * $994;
         $996 = (($kk$010$i) - ($b$116$i))|0;
         $997 = $ecb$08$i < 0.0;
         $$01$i$i46 = $997 ? 0.0 : $ecb$08$i;
         $998 = $995 < 0.0;
         $$02$i$i47 = $998 ? 0.0 : $995;
         $999 = !($$01$i$i46 <= 0.0);
         do {
          if ($999) {
           $1000 = !($$02$i$i47 <= 0.0);
           if (!($1000)) {
            $ecb$0$be$i48 = $$01$i$i46;
            break;
           }
           $1001 = $$02$i$i47 > $$01$i$i46;
           $1002 = $$02$i$i47 / $$01$i$i46;
           $1003 = $$01$i$i46 / $$02$i$i47;
           $ratio$0$i$i51 = $1001 ? $1002 : $1003;
           $ispos$i$i52 = ($996|0)>(-1);
           $neg$i$i53 = (0 - ($996))|0;
           $1004 = $ispos$i$i52 ? $996 : $neg$i$i53;
           $1005 = ($1004|0)>($965|0);
           if ($1005) {
            $1017 = +HEAPF32[11576>>2];
            $1018 = $ratio$0$i$i51 < $1017;
            if ($1018) {
             $1019 = $$02$i$i47 + $$01$i$i46;
             $ecb$0$be$i48 = $1019;
             break;
            } else {
             $$1$i$i54 = $1001 ? $$02$i$i47 : $$01$i$i46;
             $ecb$0$be$i48 = $$1$i$i54;
             break;
            }
           } else {
            $1006 = +HEAPF32[11528>>2];
            $1007 = !($ratio$0$i$i51 >= $1006);
            if ($1007) {
             $1009 = (+_fast_log2($ratio$0$i$i51));
             $1010 = $1009;
             $1011 = $1010 * 4.8164799306236983;
             $1012 = (~~(($1011)));
             $1013 = $$02$i$i47 + $$01$i$i46;
             $1014 = (11536 + ($1012<<2)|0);
             $1015 = +HEAPF32[$1014>>2];
             $1016 = $1015 * $1013;
             $ecb$0$be$i48 = $1016;
             break;
            } else {
             $1008 = $$02$i$i47 + $$01$i$i46;
             $ecb$0$be$i48 = $1008;
             break;
            }
           }
          } else {
           $ecb$0$be$i48 = $$02$i$i47;
          }
         } while(0);
         $exitcond45$i = ($kk$010$i|0)==($960|0);
         if ($exitcond45$i) {
          $$lcssa227 = $986;$ecb$0$be$i48$lcssa = $ecb$0$be$i48;
          break;
         }
         $j$3$i = (($j$39$i) + 1)|0;
         $$pre49$i = HEAP32[$953>>2]|0;
         $988 = $$pre49$i;$dd$06$i = $986;$ecb$08$i = $ecb$0$be$i48;$j$39$i = $j$3$i;$kk$010$in$i = $kk$010$i;
        }
        $1020 = (($j$34$i45) - ($958))|0;
        $1021 = (($1020) + ($960))|0;
        $1022 = (1 - ($958))|0;
        $1023 = (($1022) + ($960))|0;
        $dd$0$lcssa$i58 = $$lcssa227;$dd_n$0$lcssa$i57 = $1023;$ecb$0$lcssa$i56 = $ecb$0$be$i48$lcssa;$j$3$lcssa$i = $1021;
       } else {
        $dd$0$lcssa$i58 = $972;$dd_n$0$lcssa$i57 = 1;$ecb$0$lcssa$i56 = $981;$j$3$lcssa$i = $j$34$i45;
       }
       $1024 = $dd$0$lcssa$i58 << 1;
       $1025 = $1024 | 1;
       $1026 = $dd_n$0$lcssa$i57 << 1;
       $1027 = (($1025|0) / ($1026|0))&-1;
       $1028 = (11488 + ($1027<<2)|0);
       $1029 = +HEAPF32[$1028>>2];
       $1030 = $1029 * 0.5;
       $1031 = $1030 * $ecb$0$lcssa$i56;
       $1032 = ((($thr) + ($chn$2120<<8)|0) + ($b$116$i<<2)|0);
       HEAPF32[$1032>>2] = $1031;
       $1033 = ((((($gfc)) + 23612|0) + ($chn$2120<<8)|0) + ($b$116$i<<2)|0);
       $1034 = HEAP32[$1033>>2]|0;
       $1035 = ((((($gfc)) + 24636|0) + ($chn$2120<<8)|0) + ($b$116$i<<2)|0);
       HEAP32[$1035>>2] = $1034;
       HEAPF32[$1033>>2] = $1031;
       $1036 = (($thm$i) + ($b$116$i<<2)|0);
       $1037 = +HEAPF32[$1036>>2];
       $1038 = (((($844)) + 2416|0) + ($b$116$i<<2)|0);
       $1039 = +HEAPF32[$1038>>2];
       $1040 = $1037 * $1030;
       $1041 = $1040 * $1039;
       $1042 = $1031 > $1041;
       if ($1042) {
        HEAPF32[$1032>>2] = $1041;
        $1045 = $1041;
       } else {
        $1045 = $1031;
       }
       $1043 = $969 > 1.0;
       if ($1043) {
        $1044 = $1045 * $969;
        HEAPF32[$1032>>2] = $1044;
        $1049 = $1044;
       } else {
        $1049 = $1045;
       }
       $1046 = ((($eb) + ($chn$2120<<8)|0) + ($b$116$i<<2)|0);
       $1047 = +HEAPF32[$1046>>2];
       $1048 = $1049 > $1047;
       if ($1048) {
        HEAPF32[$1032>>2] = $1047;
        $1052 = $1047;
       } else {
        $1052 = $1049;
       }
       $1050 = $969 < 1.0;
       if ($1050) {
        $1051 = $1052 * $969;
        HEAPF32[$1032>>2] = $1051;
       }
       $1053 = (($b$116$i) + 1)|0;
       $1054 = HEAP32[$845>>2]|0;
       $1055 = ($1053|0)<($1054|0);
       if ($1055) {
        $b$116$i = $1053;$j$217$i = $j$3$lcssa$i;
       } else {
        $$lcssa228 = $1053;
        break;
       }
      }
      $954 = ($$lcssa228|0)<(64);
      if ($954) {
       $b$23$i$ph = $$lcssa228;
       label = 185;
      }
     } else {
      $b$23$i$ph = 0;
      label = 185;
     }
     if ((label|0) == 185) {
      label = 0;
      $scevgep162 = ((($eb) + ($chn$2120<<8)|0) + ($b$23$i$ph<<2)|0);
      $955 = $b$23$i$ph << 2;
      $956 = (256 - ($955))|0;
      _memset(($scevgep162|0),0,($956|0))|0;
      $scevgep165 = ((($thr) + ($chn$2120<<8)|0) + ($b$23$i$ph<<2)|0);
      _memset(($scevgep165|0),0,($956|0))|0;
     }
    } else {
     if ($801) {
      $807 = HEAP32[$0>>2]|0;
      $808 = ((($807)) + 4308|0);
      $809 = HEAP32[$808>>2]|0;
      $810 = ($809|0)>(0);
      if ($810) {
       $b$01$i = 0;
       while(1) {
        $811 = ((((($gfc)) + 23612|0) + ($chn$2120<<8)|0) + ($b$01$i<<2)|0);
        $812 = HEAP32[$811>>2]|0;
        $813 = ((((($gfc)) + 24636|0) + ($chn$2120<<8)|0) + ($b$01$i<<2)|0);
        HEAP32[$813>>2] = $812;
        $814 = (($b$01$i) + 1)|0;
        $exitcond$i18 = ($814|0)==($809|0);
        if ($exitcond$i18) {
         break;
        } else {
         $b$01$i = $814;
        }
       }
      }
     }
    }
    $1056 = (($chn$2120) + 1)|0;
    $exitcond167 = ($1056|0)==($417|0);
    if ($exitcond167) {
     break;
    } else {
     $chn$2120 = $1056;
    }
   }
  }
  $1057 = HEAP32[$17>>2]|0;
  $$not = ($1057|0)!=(1);
  $brmerge = $$not | $$not203;
  if (!($brmerge)) {
   $1058 = HEAP32[$772>>2]|0;
   $1059 = ((($1058)) + 468|0);
   $1060 = +HEAPF32[$7>>2];
   $1061 = HEAP32[$773>>2]|0;
   _vbrpsy_compute_MS_thresholds($eb,$thr,$771,$1059,$743,$1060,$1061);
  }
  if ($418) {
   $chn$3127 = 0;
   while(1) {
    $1062 = $chn$3127 & 1;
    $1063 = (($uselongblock) + ($1062<<2)|0);
    $1064 = HEAP32[$1063>>2]|0;
    $1065 = ($1064|0)==(0);
    $or$cond3 = $774 | $1065;
    if ($or$cond3) {
     $1066 = (($eb) + ($chn$3127<<8)|0);
     $1067 = (($thr) + ($chn$3127<<8)|0);
     $1068 = HEAP32[$0>>2]|0;
     $1069 = ((($1068)) + 2160|0);
     _convert_partition2scalefac($1069,$1066,$1067,$mask_idx_s$i,$thm$i);
     $1070 = HEAP32[$mask_idx_s$i>>2]|0;
     $1071 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 88|0) + ($sblock$0130<<2)|0);
     HEAP32[$1071>>2] = $1070;
     $1072 = HEAP32[$thm$i>>2]|0;
     $1073 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 88|0) + ($sblock$0130<<2)|0);
     HEAP32[$1073>>2] = $1072;
     $1074 = HEAP32[$775>>2]|0;
     $1075 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 100|0) + ($sblock$0130<<2)|0);
     HEAP32[$1075>>2] = $1074;
     $1076 = HEAP32[$776>>2]|0;
     $1077 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 100|0) + ($sblock$0130<<2)|0);
     HEAP32[$1077>>2] = $1076;
     $1078 = HEAP32[$777>>2]|0;
     $1079 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 112|0) + ($sblock$0130<<2)|0);
     HEAP32[$1079>>2] = $1078;
     $1080 = HEAP32[$778>>2]|0;
     $1081 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 112|0) + ($sblock$0130<<2)|0);
     HEAP32[$1081>>2] = $1080;
     $1082 = HEAP32[$779>>2]|0;
     $1083 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 124|0) + ($sblock$0130<<2)|0);
     HEAP32[$1083>>2] = $1082;
     $1084 = HEAP32[$780>>2]|0;
     $1085 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 124|0) + ($sblock$0130<<2)|0);
     HEAP32[$1085>>2] = $1084;
     $1086 = HEAP32[$781>>2]|0;
     $1087 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 136|0) + ($sblock$0130<<2)|0);
     HEAP32[$1087>>2] = $1086;
     $1088 = HEAP32[$782>>2]|0;
     $1089 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 136|0) + ($sblock$0130<<2)|0);
     HEAP32[$1089>>2] = $1088;
     $1090 = HEAP32[$783>>2]|0;
     $1091 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 148|0) + ($sblock$0130<<2)|0);
     HEAP32[$1091>>2] = $1090;
     $1092 = HEAP32[$784>>2]|0;
     $1093 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 148|0) + ($sblock$0130<<2)|0);
     HEAP32[$1093>>2] = $1092;
     $1094 = HEAP32[$785>>2]|0;
     $1095 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 160|0) + ($sblock$0130<<2)|0);
     HEAP32[$1095>>2] = $1094;
     $1096 = HEAP32[$786>>2]|0;
     $1097 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 160|0) + ($sblock$0130<<2)|0);
     HEAP32[$1097>>2] = $1096;
     $1098 = HEAP32[$787>>2]|0;
     $1099 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 172|0) + ($sblock$0130<<2)|0);
     HEAP32[$1099>>2] = $1098;
     $1100 = HEAP32[$788>>2]|0;
     $1101 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 172|0) + ($sblock$0130<<2)|0);
     HEAP32[$1101>>2] = $1100;
     $1102 = HEAP32[$789>>2]|0;
     $1103 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 184|0) + ($sblock$0130<<2)|0);
     HEAP32[$1103>>2] = $1102;
     $1104 = HEAP32[$790>>2]|0;
     $1105 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 184|0) + ($sblock$0130<<2)|0);
     HEAP32[$1105>>2] = $1104;
     $1106 = HEAP32[$791>>2]|0;
     $1107 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 196|0) + ($sblock$0130<<2)|0);
     HEAP32[$1107>>2] = $1106;
     $1108 = HEAP32[$792>>2]|0;
     $1109 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 196|0) + ($sblock$0130<<2)|0);
     HEAP32[$1109>>2] = $1108;
     $1110 = HEAP32[$793>>2]|0;
     $1111 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 208|0) + ($sblock$0130<<2)|0);
     HEAP32[$1111>>2] = $1110;
     $1112 = HEAP32[$794>>2]|0;
     $1113 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 208|0) + ($sblock$0130<<2)|0);
     HEAP32[$1113>>2] = $1112;
     $1114 = HEAP32[$795>>2]|0;
     $1115 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 220|0) + ($sblock$0130<<2)|0);
     HEAP32[$1115>>2] = $1114;
     $1116 = HEAP32[$796>>2]|0;
     $1117 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 220|0) + ($sblock$0130<<2)|0);
     HEAP32[$1117>>2] = $1116;
     $1118 = HEAP32[$797>>2]|0;
     $1119 = ((((((($gfc)) + 26636|0) + (($chn$3127*244)|0)|0)) + 232|0) + ($sblock$0130<<2)|0);
     HEAP32[$1119>>2] = $1118;
     $1120 = HEAP32[$798>>2]|0;
     $1121 = ((((((($gfc)) + 25660|0) + (($chn$3127*244)|0)|0)) + 232|0) + ($sblock$0130<<2)|0);
     HEAP32[$1121>>2] = $1120;
    }
    $1122 = (($chn$3127) + 1)|0;
    $exitcond168 = ($1122|0)==($417|0);
    if ($exitcond168) {
     break;
    } else {
     $chn$3127 = $1122;
    }
   }
  }
  $1123 = (($sblock$0130) + 1)|0;
  $exitcond169 = ($1123|0)==(3);
  if ($exitcond169) {
   break;
  } else {
   $sblock$0130 = $1123;
  }
 }
 if ($418) {
  $chn$4119 = 0;
  while(1) {
   $1124 = (((($gfc)) + 27780|0) + ($chn$4119<<2)|0);
   $sb$0118 = 0;
   while(1) {
    $scevgep = ((((((($gfc)) + 25660|0) + (($chn$4119*244)|0)|0)) + 88|0) + (($sb$0118*12)|0)|0);
    $1125 = ((((((($last_thm) + (($chn$4119*244)|0)|0)) + 88|0) + (($sb$0118*12)|0)|0)) + 8|0);
    $1126 = ((((((($last_thm) + (($chn$4119*244)|0)|0)) + 88|0) + (($sb$0118*12)|0)|0)) + 4|0);
    $sblock$1116 = 0;
    while(1) {
     $1128 = (((((((($gfc)) + 25660|0) + (($chn$4119*244)|0)|0)) + 88|0) + (($sb$0118*12)|0)|0) + ($sblock$1116<<2)|0);
     $1129 = +HEAPF32[$1128>>2];
     $1130 = $1129;
     $1131 = $1130 * 0.80000000000000004;
     $1132 = $1131;
     $1133 = ($sblock$1116|0)>(0);
     $1134 = (($sblock$1116) + -1)|0;
     $1135 = (($new_thmm) + ($1134<<2)|0);
     $prev_thm$0$in = $1133 ? $1135 : $1125;
     $prev_thm$0 = +HEAPF32[$prev_thm$0$in>>2];
     $1136 = ((($ns_attacks) + ($chn$4119<<4)|0) + ($sblock$1116<<2)|0);
     $1137 = HEAP32[$1136>>2]|0;
     $1138 = ($1137|0)>(1);
     if ($1138) {
      label = 223;
     } else {
      $1139 = (($sblock$1116) + 1)|0;
      $1140 = ((($ns_attacks) + ($chn$4119<<4)|0) + ($1139<<2)|0);
      $1141 = HEAP32[$1140>>2]|0;
      $1142 = ($1141|0)==(1);
      if ($1142) {
       label = 223;
      } else {
       $t1$0 = $1132;
      }
     }
     if ((label|0) == 223) {
      label = 0;
      $1143 = $1132 > 0.0;
      if ($1143) {
       $1144 = $prev_thm$0 / $1132;
       $1145 = (+Math_pow((+$1144),0.36000001430511475));
       $1146 = $1145 * $1132;
       $t1$0 = $1146;
      } else {
       $t1$0 = 0.0;
      }
     }
     $1147 = $t1$0 < $1132;
     $1148 = $1147 ? $t1$0 : $1132;
     $1149 = ($1137|0)==(1);
     L341: do {
      if ($1149) {
       $1150 = $1148 > 0.0;
       if ($1150) {
        $1151 = $prev_thm$0 / $1148;
        $1152 = (+Math_pow((+$1151),0.18000000715255737));
        $1153 = $1152 * $1148;
        $t2$0 = $1153;
       } else {
        $t2$0 = 0.0;
       }
      } else {
       $1154 = ($sblock$1116|0)==(0);
       if ($1154) {
        $1155 = HEAP32[$1124>>2]|0;
        $1156 = ($1155|0)==(3);
        if ($1156) {
         label = 233;
        } else {
         label = 230;
        }
       } else {
        label = 230;
       }
       do {
        if ((label|0) == 230) {
         label = 0;
         if (!($1133)) {
          $t2$0 = $1132;
          break L341;
         }
         $1157 = ((($ns_attacks) + ($chn$4119<<4)|0) + ($1134<<2)|0);
         $1158 = HEAP32[$1157>>2]|0;
         $1159 = ($1158|0)==(3);
         if (!($1159)) {
          $t2$0 = $1132;
          break L341;
         }
         if ((($sblock$1116|0) == 0)) {
          label = 233;
          break;
         } else if ((($sblock$1116|0) == 1)) {
          $1161 = +HEAPF32[$1125>>2];
          $prev_thm$1 = $1161;
          break;
         } else if ((($sblock$1116|0) == 2)) {
          $1162 = +HEAPF32[$new_thmm>>2];
          $prev_thm$1 = $1162;
          break;
         } else {
          $prev_thm$1 = $prev_thm$0;
          break;
         }
        }
       } while(0);
       if ((label|0) == 233) {
        label = 0;
        $1160 = +HEAPF32[$1126>>2];
        $prev_thm$1 = $1160;
       }
       $1163 = $1148 > 0.0;
       if (!($1163)) {
        $t2$0 = 0.0;
        break;
       }
       $1164 = $prev_thm$1 / $1148;
       $1165 = (+Math_pow((+$1164),0.18000000715255737));
       $1166 = $1165 * $1148;
       $t2$0 = $1166;
      }
     } while(0);
     $1167 = $t2$0 < $1148;
     $1168 = $1167 ? $t2$0 : $1148;
     $1169 = ((($sub_short_factor) + (($chn$4119*12)|0)|0) + ($sblock$1116<<2)|0);
     $1170 = +HEAPF32[$1169>>2];
     $1171 = $1168 * $1170;
     $1172 = (($new_thmm) + ($sblock$1116<<2)|0);
     HEAPF32[$1172>>2] = $1171;
     $1173 = (($sblock$1116) + 1)|0;
     $exitcond151 = ($1173|0)==(3);
     if ($exitcond151) {
      break;
     } else {
      $sblock$1116 = $1173;
     }
    }
    ;HEAP32[$scevgep>>2]=HEAP32[$new_thmm>>2]|0;HEAP32[$scevgep+4>>2]=HEAP32[$new_thmm+4>>2]|0;HEAP32[$scevgep+8>>2]=HEAP32[$new_thmm+8>>2]|0;
    $1127 = (($sb$0118) + 1)|0;
    $exitcond155 = ($1127|0)==(13);
    if ($exitcond155) {
     break;
    } else {
     $sb$0118 = $1127;
    }
   }
   $1174 = (($chn$4119) + 1)|0;
   $exitcond156 = ($1174|0)==($417|0);
   if ($exitcond156) {
    break;
   } else {
    $chn$4119 = $1174;
   }
  }
  if ($418) {
   $chn$5114 = 0;
   while(1) {
    $1175 = (((($ns_attacks) + ($chn$5114<<4)|0)) + 8|0);
    $1176 = HEAP32[$1175>>2]|0;
    $1177 = (((($gfc)) + 27780|0) + ($chn$5114<<2)|0);
    HEAP32[$1177>>2] = $1176;
    $1178 = (($chn$5114) + 1)|0;
    $exitcond150 = ($1178|0)==($417|0);
    if ($exitcond150) {
     break;
    } else {
     $chn$5114 = $1178;
    }
   }
  }
 }
 $1179 = HEAP32[$25>>2]|0;
 $1180 = ($1179|0)>(0);
 if ($1180) {
  $chn$01$i65 = 0;
  while(1) {
   $1181 = (($uselongblock) + ($chn$01$i65<<2)|0);
   $1182 = HEAP32[$1181>>2]|0;
   $1183 = ($1182|0)==(0);
   $1184 = (((($gfc)) + 27796|0) + ($chn$01$i65<<2)|0);
   $1185 = HEAP32[$1184>>2]|0;
   do {
    if ($1183) {
     if ((($1185|0) == 0)) {
      HEAP32[$1184>>2] = 1;
      $1188 = 1;$blocktype$0$i = 2;
      break;
     } else if ((($1185|0) == 3)) {
      HEAP32[$1184>>2] = 2;
      $1188 = 2;$blocktype$0$i = 2;
      break;
     } else {
      $1188 = $1185;$blocktype$0$i = 2;
      break;
     }
    } else {
     $1186 = ($1185|0)==(2);
     $$$i67 = $1186 ? 3 : 0;
     $1188 = $1185;$blocktype$0$i = $$$i67;
    }
   } while(0);
   $1187 = (($blocktype_d) + ($chn$01$i65<<2)|0);
   HEAP32[$1187>>2] = $1188;
   HEAP32[$1184>>2] = $blocktype$0$i;
   $1189 = (($chn$01$i65) + 1)|0;
   $exitcond$i68 = ($1189|0)==($1179|0);
   if ($exitcond$i68) {
    break;
   } else {
    $chn$01$i65 = $1189;
   }
  }
 }
 if (!($418)) {
  STACKTOP = sp;return 0;
 }
 $1190 = ((($percep_MS_entropy)) + -8|0);
 $1191 = ((($blocktype_d)) + 4|0);
 $1193 = ($1192|0)==(0|0);
 $chn$6112 = 0;
 while(1) {
  $1194 = ($chn$6112|0)>(1);
  if ($1194) {
   $1195 = HEAP32[$blocktype_d>>2]|0;
   $1196 = ($1195|0)==(2);
   if ($1196) {
    label = 253;
   } else {
    $1197 = HEAP32[$1191>>2]|0;
    $1198 = ($1197|0)==(2);
    if ($1198) {
     label = 253;
    } else {
     $type$0 = 0;
    }
   }
   if ((label|0) == 253) {
    label = 0;
    $type$0 = 2;
   }
   $1199 = (($chn$6112) + -2)|0;
   $1200 = ((($masking_MS_ratio) + (($gr_out*976)|0)|0) + (($1199*488)|0)|0);
   $mr$0 = $1200;$ppe$0 = $1190;$type$1 = $type$0;
  } else {
   $1201 = (($blocktype_d) + ($chn$6112<<2)|0);
   $1202 = HEAP32[$1201>>2]|0;
   $1203 = ((($masking_ratio) + (($gr_out*976)|0)|0) + (($chn$6112*488)|0)|0);
   $mr$0 = $1203;$ppe$0 = $percep_entropy;$type$1 = $1202;
  }
  $1204 = ($type$1|0)==(2);
  $1205 = +HEAPF32[$800>>2];
  if ($1204) {
   $pe_s$04$i = 309.07000732421875;$sb$03$i = 0;
   while(1) {
    $1206 = (11584 + ($sb$03$i<<2)|0);
    $1207 = (((($mr$0)) + 88|0) + (($sb$03$i*12)|0)|0);
    $1208 = +HEAPF32[$1207>>2];
    $1209 = $1208 > 0.0;
    do {
     if ($1209) {
      $1210 = $1208 * $1205;
      $1211 = (((($mr$0)) + 332|0) + (($sb$03$i*12)|0)|0);
      $1212 = +HEAPF32[$1211>>2];
      $1213 = $1212 > $1210;
      if (!($1213)) {
       $pe_s$2$i = $pe_s$04$i;
       break;
      }
      $1214 = $1210 * 1.0E+10;
      $1215 = $1212 > $1214;
      $1216 = +HEAPF32[$1206>>2];
      $1217 = $1216;
      if ($1215) {
       $1218 = $1217 * 23.025850929940461;
       $1219 = $pe_s$04$i;
       $1220 = $1218 + $1219;
       $1221 = $1220;
       $pe_s$2$i = $1221;
       break;
      } else {
       $1222 = $1212 / $1210;
       $1223 = (+_fast_log2($1222));
       $1224 = $1223;
       $1225 = $1217 * 0.30102999566398114;
       $1226 = $1225 * $1224;
       $1227 = $pe_s$04$i;
       $1228 = $1226 + $1227;
       $1229 = $1228;
       $pe_s$2$i = $1229;
       break;
      }
     } else {
      $pe_s$2$i = $pe_s$04$i;
     }
    } while(0);
    $1230 = (((((($mr$0)) + 88|0) + (($sb$03$i*12)|0)|0)) + 4|0);
    $1231 = +HEAPF32[$1230>>2];
    $1232 = $1231 > 0.0;
    do {
     if ($1232) {
      $1233 = $1231 * $1205;
      $1234 = (((((($mr$0)) + 332|0) + (($sb$03$i*12)|0)|0)) + 4|0);
      $1235 = +HEAPF32[$1234>>2];
      $1236 = $1235 > $1233;
      if (!($1236)) {
       $pe_s$2$1$i = $pe_s$2$i;
       break;
      }
      $1237 = $1233 * 1.0E+10;
      $1238 = $1235 > $1237;
      $1239 = +HEAPF32[$1206>>2];
      $1240 = $1239;
      if ($1238) {
       $1249 = $1240 * 23.025850929940461;
       $1250 = $pe_s$2$i;
       $1251 = $1249 + $1250;
       $1252 = $1251;
       $pe_s$2$1$i = $1252;
       break;
      } else {
       $1241 = $1235 / $1233;
       $1242 = (+_fast_log2($1241));
       $1243 = $1242;
       $1244 = $1240 * 0.30102999566398114;
       $1245 = $1244 * $1243;
       $1246 = $pe_s$2$i;
       $1247 = $1245 + $1246;
       $1248 = $1247;
       $pe_s$2$1$i = $1248;
       break;
      }
     } else {
      $pe_s$2$1$i = $pe_s$2$i;
     }
    } while(0);
    $1253 = (((((($mr$0)) + 88|0) + (($sb$03$i*12)|0)|0)) + 8|0);
    $1254 = +HEAPF32[$1253>>2];
    $1255 = $1254 > 0.0;
    do {
     if ($1255) {
      $1256 = $1254 * $1205;
      $1257 = (((((($mr$0)) + 332|0) + (($sb$03$i*12)|0)|0)) + 8|0);
      $1258 = +HEAPF32[$1257>>2];
      $1259 = $1258 > $1256;
      if (!($1259)) {
       $pe_s$2$2$i = $pe_s$2$1$i;
       break;
      }
      $1260 = $1256 * 1.0E+10;
      $1261 = $1258 > $1260;
      $1262 = +HEAPF32[$1206>>2];
      $1263 = $1262;
      if ($1261) {
       $1272 = $1263 * 23.025850929940461;
       $1273 = $pe_s$2$1$i;
       $1274 = $1272 + $1273;
       $1275 = $1274;
       $pe_s$2$2$i = $1275;
       break;
      } else {
       $1264 = $1258 / $1256;
       $1265 = (+_fast_log2($1264));
       $1266 = $1265;
       $1267 = $1263 * 0.30102999566398114;
       $1268 = $1267 * $1266;
       $1269 = $pe_s$2$1$i;
       $1270 = $1268 + $1269;
       $1271 = $1270;
       $pe_s$2$2$i = $1271;
       break;
      }
     } else {
      $pe_s$2$2$i = $pe_s$2$1$i;
     }
    } while(0);
    $1276 = (($sb$03$i) + 1)|0;
    $exitcond$i11 = ($1276|0)==(12);
    if ($exitcond$i11) {
     $pe_s$2$2$i$lcssa = $pe_s$2$2$i;
     break;
    } else {
     $pe_s$04$i = $pe_s$2$2$i;$sb$03$i = $1276;
    }
   }
   $1277 = (($ppe$0) + ($chn$6112<<2)|0);
   HEAPF32[$1277>>2] = $pe_s$2$2$i$lcssa;
   $1305 = $pe_s$2$2$i$lcssa;
  } else {
   $pe_l$02$i = 281.0574951171875;$sb$01$i = 0;
   while(1) {
    $1278 = (($mr$0) + ($sb$01$i<<2)|0);
    $1279 = +HEAPF32[$1278>>2];
    $1280 = $1279 > 0.0;
    do {
     if ($1280) {
      $1281 = $1279 * $1205;
      $1282 = (((($mr$0)) + 244|0) + ($sb$01$i<<2)|0);
      $1283 = +HEAPF32[$1282>>2];
      $1284 = $1283 > $1281;
      if (!($1284)) {
       $pe_l$1$i = $pe_l$02$i;
       break;
      }
      $1285 = $1281 * 1.0E+10;
      $1286 = $1283 > $1285;
      $1287 = (11632 + ($sb$01$i<<2)|0);
      $1288 = +HEAPF32[$1287>>2];
      $1289 = $1288;
      if ($1286) {
       $1290 = $1289 * 23.025850929940461;
       $1291 = $pe_l$02$i;
       $1292 = $1290 + $1291;
       $1293 = $1292;
       $pe_l$1$i = $1293;
       break;
      } else {
       $1294 = $1283 / $1281;
       $1295 = (+_fast_log2($1294));
       $1296 = $1295;
       $1297 = $1289 * 0.30102999566398114;
       $1298 = $1297 * $1296;
       $1299 = $pe_l$02$i;
       $1300 = $1298 + $1299;
       $1301 = $1300;
       $pe_l$1$i = $1301;
       break;
      }
     } else {
      $pe_l$1$i = $pe_l$02$i;
     }
    } while(0);
    $1302 = (($sb$01$i) + 1)|0;
    $exitcond$i7 = ($1302|0)==(21);
    if ($exitcond$i7) {
     $pe_l$1$i$lcssa = $pe_l$1$i;
     break;
    } else {
     $pe_l$02$i = $pe_l$1$i;$sb$01$i = $1302;
    }
   }
   $1303 = (($ppe$0) + ($chn$6112<<2)|0);
   HEAPF32[$1303>>2] = $pe_l$1$i$lcssa;
   $1305 = $pe_l$1$i$lcssa;
  }
  if (!($1193)) {
   $1304 = $1305;
   $1306 = ((((($1192)) + 189240|0) + ($gr_out<<5)|0) + ($chn$6112<<3)|0);
   HEAPF64[$1306>>3] = $1304;
  }
  $1307 = (($chn$6112) + 1)|0;
  $exitcond = ($1307|0)==($417|0);
  if ($exitcond) {
   break;
  } else {
   $chn$6112 = $1307;
  }
 }
 STACKTOP = sp;return 0;
}
function _psymodel_init($gfp) {
 $gfp = $gfp|0;
 var $$ = 0.0, $$0 = 0, $$lcssa = 0, $$lcssa133 = 0.0, $$lcssa20 = 0, $$pre = 0, $$pre109 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0;
 var $11 = 0, $110 = 0.0, $111 = 0, $112 = 0.0, $113 = 0, $114 = 0, $115 = 0.0, $116 = 0.0, $117 = 0.0, $118 = 0, $119 = 0, $12 = 0, $120 = 0.0, $121 = 0.0, $122 = 0.0, $123 = 0.0, $124 = 0.0, $125 = 0, $126 = 0.0, $127 = 0.0;
 var $128 = 0.0, $129 = 0.0, $13 = 0, $130 = 0.0, $131 = 0.0, $132 = 0.0, $133 = 0.0, $134 = 0.0, $135 = 0.0, $136 = 0.0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0;
 var $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0.0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0.0, $158 = 0.0, $159 = 0.0, $16 = 0, $160 = 0.0, $161 = 0.0, $162 = 0.0, $163 = 0.0;
 var $164 = 0.0, $165 = 0.0, $166 = 0.0, $167 = 0.0, $168 = 0.0, $169 = 0, $17 = 0, $170 = 0.0, $171 = 0.0, $172 = 0.0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0.0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0.0;
 var $182 = 0.0, $183 = 0.0, $184 = 0.0, $185 = 0.0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0.0, $191 = 0.0, $192 = 0.0, $193 = 0, $194 = 0.0, $195 = 0.0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0;
 var $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0.0, $205 = 0, $206 = 0.0, $207 = 0, $208 = 0, $209 = 0.0, $21 = 0, $210 = 0.0, $211 = 0.0, $212 = 0, $213 = 0, $214 = 0.0, $215 = 0.0, $216 = 0.0, $217 = 0.0;
 var $218 = 0.0, $219 = 0, $22 = 0, $220 = 0.0, $221 = 0.0, $222 = 0.0, $223 = 0.0, $224 = 0.0, $225 = 0.0, $226 = 0.0, $227 = 0.0, $228 = 0.0, $229 = 0.0, $23 = 0, $230 = 0.0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0;
 var $236 = 0.0, $237 = 0, $238 = 0, $239 = 0.0, $24 = 0, $240 = 0, $241 = 0.0, $242 = 0.0, $243 = 0.0, $244 = 0.0, $245 = 0.0, $246 = 0.0, $247 = 0.0, $248 = 0.0, $249 = 0.0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0;
 var $254 = 0.0, $255 = 0.0, $256 = 0.0, $257 = 0.0, $258 = 0.0, $259 = 0.0, $26 = 0, $260 = 0.0, $261 = 0.0, $262 = 0.0, $263 = 0.0, $264 = 0.0, $265 = 0.0, $266 = 0, $267 = 0.0, $268 = 0.0, $269 = 0.0, $27 = 0, $270 = 0, $271 = 0;
 var $272 = 0, $273 = 0, $274 = 0.0, $275 = 0, $276 = 0, $277 = 0.0, $278 = 0.0, $279 = 0.0, $28 = 0, $280 = 0.0, $281 = 0, $282 = 0.0, $283 = 0.0, $284 = 0.0, $285 = 0.0, $286 = 0.0, $287 = 0, $288 = 0.0, $289 = 0.0, $29 = 0;
 var $290 = 0.0, $291 = 0.0, $292 = 0.0, $293 = 0, $294 = 0, $295 = 0, $296 = 0, $297 = 0.0, $298 = 0.0, $299 = 0.0, $3 = 0, $30 = 0, $300 = 0, $301 = 0.0, $302 = 0.0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0;
 var $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0.0, $312 = 0.0, $313 = 0.0, $314 = 0.0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0.0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0;
 var $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0, $332 = 0.0, $333 = 0.0, $334 = 0.0, $335 = 0.0, $336 = 0.0, $337 = 0.0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0;
 var $344 = 0, $345 = 0, $346 = 0, $347 = 0.0, $348 = 0.0, $349 = 0.0, $35 = 0, $350 = 0.0, $351 = 0.0, $352 = 0.0, $353 = 0.0, $354 = 0.0, $355 = 0.0, $356 = 0, $357 = 0, $358 = 0.0, $359 = 0, $36 = 0, $360 = 0.0, $361 = 0;
 var $362 = 0, $363 = 0, $364 = 0.0, $365 = 0, $366 = 0.0, $367 = 0, $368 = 0, $369 = 0, $37 = 0, $370 = 0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0.0, $379 = 0.0, $38 = 0;
 var $380 = 0, $381 = 0, $382 = 0, $383 = 0.0, $384 = 0, $385 = 0.0, $386 = 0, $387 = 0, $388 = 0.0, $389 = 0.0, $39 = 0, $390 = 0.0, $391 = 0.0, $392 = 0, $393 = 0.0, $394 = 0, $395 = 0, $396 = 0.0, $397 = 0.0, $398 = 0.0;
 var $399 = 0.0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0, $404 = 0, $405 = 0, $406 = 0.0, $407 = 0, $408 = 0, $409 = 0, $41 = 0, $410 = 0, $411 = 0.0, $412 = 0.0, $413 = 0.0, $414 = 0.0, $415 = 0;
 var $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0.0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0;
 var $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0.0, $70 = 0, $71 = 0, $72 = 0, $73 = 0;
 var $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0.0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0;
 var $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $b$051 = 0, $b$3$lcssa110 = 0, $b$329 = 0, $b$427 = 0, $b$5$lcssa111 = 0, $b$525 = 0, $b$624 = 0, $bval = 0, $bval_width = 0, $eql_balance$049 = 0.0, $exitcond = 0, $exitcond$i = 0;
 var $exitcond$i4 = 0, $exitcond101 = 0, $exitcond102 = 0, $exitcond106 = 0, $exitcond108 = 0, $exitcond97 = 0, $freq5$048 = 0.0, $i$089 = 0, $i$180 = 0, $i$278 = 0, $i$365 = 0, $i$450 = 0, $j$01$i = 0, $j$01$i3 = 0, $j$084 = 0, $j$187 = 0, $j$377 = 0, $j$4$lcssa = 0, $j$471 = 0, $j$564 = 0;
 var $j$6$lcssa = 0, $j$657 = 0, $k$02$i = 0, $k$02$i2 = 0, $k$069 = 0, $k$155 = 0, $msfix$0 = 0.0, $norm = 0, $phitmp = 0.0, $sk_s$0 = 0.0, $snr2$0 = 0.0, $x$0$lcssa = 0.0, $x$070 = 0.0, $x$1 = 0.0, $x$2 = 0.0, $x$3 = 0.0, $x$3$op = 0.0, $x$3$op$op = 0.0, $x1$0$lcssa = 0.0, $x1$056 = 0.0;
 var $x1$1 = 0.0, $x1$2 = 0.0, $x1$3 = 0.0, $x1$4 = 0.0, $x1$5 = 0.0, $x1$5$op = 0.0, $x1$5$op$op = 0.0, $x6$0 = 0.0, $y$0 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 768|0;
 $bval = sp + 512|0;
 $bval_width = sp + 256|0;
 $norm = sp;
 $0 = ((($gfp)) + 288|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 16|0);
 $3 = ((($1)) + 64|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = (+($4|0));
 $6 = ((($1)) + 280|0);
 $7 = +HEAPF32[$6>>2];
 $8 = -$7;
 $9 = ((($1)) + 85800|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)==(0|0);
 if (!($11)) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 _memset(($norm|0),0,256)|0;
 $12 = (_calloc(1,6504)|0);
 HEAP32[$9>>2] = $12;
 $13 = ((($gfp)) + 144|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = ((($12)) + 6500|0);
 HEAP32[$15>>2] = $14;
 $16 = ((($1)) + 27800|0);
 HEAP32[$16>>2] = 0;
 $17 = ((($1)) + 27796|0);
 HEAP32[$17>>2] = 0;
 $i$089 = 0;
 while(1) {
  $j$084 = 0;
  while(1) {
   $63 = ((((($1)) + 21564|0) + ($i$089<<8)|0) + ($j$084<<2)|0);
   HEAPF32[$63>>2] = 1.0000000200408773E+20;
   $64 = ((((($1)) + 22588|0) + ($i$089<<8)|0) + ($j$084<<2)|0);
   HEAPF32[$64>>2] = 1.0000000200408773E+20;
   $65 = ((((($1)) + 24636|0) + ($i$089<<8)|0) + ($j$084<<2)|0);
   HEAPF32[$65>>2] = 1.0;
   $66 = ((((($1)) + 23612|0) + ($i$089<<8)|0) + ($j$084<<2)|0);
   HEAPF32[$66>>2] = 1.0;
   $67 = (($j$084) + 1)|0;
   $exitcond102 = ($67|0)==(64);
   if ($exitcond102) {
    break;
   } else {
    $j$084 = $67;
   }
  }
  $18 = (((($1)) + 26636|0) + (($i$089*244)|0)|0);
  HEAPF32[$18>>2] = 1.0000000200408773E+20;
  $19 = (((($1)) + 25660|0) + (($i$089*244)|0)|0);
  HEAPF32[$19>>2] = 1.0000000200408773E+20;
  $20 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 4|0);
  HEAPF32[$20>>2] = 1.0000000200408773E+20;
  $21 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 4|0);
  HEAPF32[$21>>2] = 1.0000000200408773E+20;
  $22 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 8|0);
  HEAPF32[$22>>2] = 1.0000000200408773E+20;
  $23 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 8|0);
  HEAPF32[$23>>2] = 1.0000000200408773E+20;
  $24 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 12|0);
  HEAPF32[$24>>2] = 1.0000000200408773E+20;
  $25 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 12|0);
  HEAPF32[$25>>2] = 1.0000000200408773E+20;
  $26 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 16|0);
  HEAPF32[$26>>2] = 1.0000000200408773E+20;
  $27 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 16|0);
  HEAPF32[$27>>2] = 1.0000000200408773E+20;
  $28 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 20|0);
  HEAPF32[$28>>2] = 1.0000000200408773E+20;
  $29 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 20|0);
  HEAPF32[$29>>2] = 1.0000000200408773E+20;
  $30 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 24|0);
  HEAPF32[$30>>2] = 1.0000000200408773E+20;
  $31 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 24|0);
  HEAPF32[$31>>2] = 1.0000000200408773E+20;
  $32 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 28|0);
  HEAPF32[$32>>2] = 1.0000000200408773E+20;
  $33 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 28|0);
  HEAPF32[$33>>2] = 1.0000000200408773E+20;
  $34 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 32|0);
  HEAPF32[$34>>2] = 1.0000000200408773E+20;
  $35 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 32|0);
  HEAPF32[$35>>2] = 1.0000000200408773E+20;
  $36 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 36|0);
  HEAPF32[$36>>2] = 1.0000000200408773E+20;
  $37 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 36|0);
  HEAPF32[$37>>2] = 1.0000000200408773E+20;
  $38 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 40|0);
  HEAPF32[$38>>2] = 1.0000000200408773E+20;
  $39 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 40|0);
  HEAPF32[$39>>2] = 1.0000000200408773E+20;
  $40 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 44|0);
  HEAPF32[$40>>2] = 1.0000000200408773E+20;
  $41 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 44|0);
  HEAPF32[$41>>2] = 1.0000000200408773E+20;
  $42 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 48|0);
  HEAPF32[$42>>2] = 1.0000000200408773E+20;
  $43 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 48|0);
  HEAPF32[$43>>2] = 1.0000000200408773E+20;
  $44 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 52|0);
  HEAPF32[$44>>2] = 1.0000000200408773E+20;
  $45 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 52|0);
  HEAPF32[$45>>2] = 1.0000000200408773E+20;
  $46 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 56|0);
  HEAPF32[$46>>2] = 1.0000000200408773E+20;
  $47 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 56|0);
  HEAPF32[$47>>2] = 1.0000000200408773E+20;
  $48 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 60|0);
  HEAPF32[$48>>2] = 1.0000000200408773E+20;
  $49 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 60|0);
  HEAPF32[$49>>2] = 1.0000000200408773E+20;
  $50 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 64|0);
  HEAPF32[$50>>2] = 1.0000000200408773E+20;
  $51 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 64|0);
  HEAPF32[$51>>2] = 1.0000000200408773E+20;
  $52 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 68|0);
  HEAPF32[$52>>2] = 1.0000000200408773E+20;
  $53 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 68|0);
  HEAPF32[$53>>2] = 1.0000000200408773E+20;
  $54 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 72|0);
  HEAPF32[$54>>2] = 1.0000000200408773E+20;
  $55 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 72|0);
  HEAPF32[$55>>2] = 1.0000000200408773E+20;
  $56 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 76|0);
  HEAPF32[$56>>2] = 1.0000000200408773E+20;
  $57 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 76|0);
  HEAPF32[$57>>2] = 1.0000000200408773E+20;
  $58 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 80|0);
  HEAPF32[$58>>2] = 1.0000000200408773E+20;
  $59 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 80|0);
  HEAPF32[$59>>2] = 1.0000000200408773E+20;
  $60 = (((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 84|0);
  HEAPF32[$60>>2] = 1.0000000200408773E+20;
  $61 = (((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 84|0);
  HEAPF32[$61>>2] = 1.0000000200408773E+20;
  $62 = (((($1)) + 27780|0) + ($i$089<<2)|0);
  $j$187 = 0;
  while(1) {
   $78 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 88|0) + ($j$187<<2)|0);
   HEAPF32[$78>>2] = 1.0000000200408773E+20;
   $79 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 88|0) + ($j$187<<2)|0);
   HEAPF32[$79>>2] = 1.0000000200408773E+20;
   $80 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 100|0) + ($j$187<<2)|0);
   HEAPF32[$80>>2] = 1.0000000200408773E+20;
   $81 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 100|0) + ($j$187<<2)|0);
   HEAPF32[$81>>2] = 1.0000000200408773E+20;
   $82 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 112|0) + ($j$187<<2)|0);
   HEAPF32[$82>>2] = 1.0000000200408773E+20;
   $83 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 112|0) + ($j$187<<2)|0);
   HEAPF32[$83>>2] = 1.0000000200408773E+20;
   $84 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 124|0) + ($j$187<<2)|0);
   HEAPF32[$84>>2] = 1.0000000200408773E+20;
   $85 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 124|0) + ($j$187<<2)|0);
   HEAPF32[$85>>2] = 1.0000000200408773E+20;
   $86 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 136|0) + ($j$187<<2)|0);
   HEAPF32[$86>>2] = 1.0000000200408773E+20;
   $87 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 136|0) + ($j$187<<2)|0);
   HEAPF32[$87>>2] = 1.0000000200408773E+20;
   $88 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 148|0) + ($j$187<<2)|0);
   HEAPF32[$88>>2] = 1.0000000200408773E+20;
   $89 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 148|0) + ($j$187<<2)|0);
   HEAPF32[$89>>2] = 1.0000000200408773E+20;
   $90 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 160|0) + ($j$187<<2)|0);
   HEAPF32[$90>>2] = 1.0000000200408773E+20;
   $91 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 160|0) + ($j$187<<2)|0);
   HEAPF32[$91>>2] = 1.0000000200408773E+20;
   $92 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 172|0) + ($j$187<<2)|0);
   HEAPF32[$92>>2] = 1.0000000200408773E+20;
   $93 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 172|0) + ($j$187<<2)|0);
   HEAPF32[$93>>2] = 1.0000000200408773E+20;
   $94 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 184|0) + ($j$187<<2)|0);
   HEAPF32[$94>>2] = 1.0000000200408773E+20;
   $95 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 184|0) + ($j$187<<2)|0);
   HEAPF32[$95>>2] = 1.0000000200408773E+20;
   $96 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 196|0) + ($j$187<<2)|0);
   HEAPF32[$96>>2] = 1.0000000200408773E+20;
   $97 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 196|0) + ($j$187<<2)|0);
   HEAPF32[$97>>2] = 1.0000000200408773E+20;
   $98 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 208|0) + ($j$187<<2)|0);
   HEAPF32[$98>>2] = 1.0000000200408773E+20;
   $99 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 208|0) + ($j$187<<2)|0);
   HEAPF32[$99>>2] = 1.0000000200408773E+20;
   $100 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 220|0) + ($j$187<<2)|0);
   HEAPF32[$100>>2] = 1.0000000200408773E+20;
   $101 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 220|0) + ($j$187<<2)|0);
   HEAPF32[$101>>2] = 1.0000000200408773E+20;
   $102 = ((((((($1)) + 26636|0) + (($i$089*244)|0)|0)) + 232|0) + ($j$187<<2)|0);
   HEAPF32[$102>>2] = 1.0000000200408773E+20;
   $103 = ((((((($1)) + 25660|0) + (($i$089*244)|0)|0)) + 232|0) + ($j$187<<2)|0);
   HEAPF32[$103>>2] = 1.0000000200408773E+20;
   HEAP32[$62>>2] = 0;
   $104 = (($j$187) + 1)|0;
   $exitcond106 = ($104|0)==(3);
   if ($exitcond106) {
    break;
   } else {
    $j$187 = $104;
   }
  }
  $68 = (((($1)) + 27636|0) + (($i$089*36)|0)|0);
  HEAPF32[$68>>2] = 10.0;
  $69 = (((((($1)) + 27636|0) + (($i$089*36)|0)|0)) + 4|0);
  HEAPF32[$69>>2] = 10.0;
  $70 = (((((($1)) + 27636|0) + (($i$089*36)|0)|0)) + 8|0);
  HEAPF32[$70>>2] = 10.0;
  $71 = (((((($1)) + 27636|0) + (($i$089*36)|0)|0)) + 12|0);
  HEAPF32[$71>>2] = 10.0;
  $72 = (((((($1)) + 27636|0) + (($i$089*36)|0)|0)) + 16|0);
  HEAPF32[$72>>2] = 10.0;
  $73 = (((((($1)) + 27636|0) + (($i$089*36)|0)|0)) + 20|0);
  HEAPF32[$73>>2] = 10.0;
  $74 = (((((($1)) + 27636|0) + (($i$089*36)|0)|0)) + 24|0);
  HEAPF32[$74>>2] = 10.0;
  $75 = (((((($1)) + 27636|0) + (($i$089*36)|0)|0)) + 28|0);
  HEAPF32[$75>>2] = 10.0;
  $76 = (((((($1)) + 27636|0) + (($i$089*36)|0)|0)) + 32|0);
  HEAPF32[$76>>2] = 10.0;
  $77 = (($i$089) + 1)|0;
  $exitcond108 = ($77|0)==(4);
  if ($exitcond108) {
   break;
  } else {
   $i$089 = $77;
  }
 }
 $105 = ((($1)) + 27616|0);
 HEAPF32[$105>>2] = 0.0;
 $106 = ((($1)) + 27612|0);
 HEAPF32[$106>>2] = 0.0;
 $107 = ((($1)) + 21360|0);
 _init_numline($12,$5,1024,576,22,$107);
 $108 = ((($12)) + 2148|0);
 $109 = HEAP32[$108>>2]|0;
 $110 = $5 * 9.765625E-4;
 $111 = ($109|0)>(0);
 if ($111) {
  $112 = $110;
  $j$01$i = 0;$k$02$i = 0;
  while(1) {
   $113 = (((($12)) + 1716|0) + ($k$02$i<<2)|0);
   $114 = HEAP32[$113>>2]|0;
   $115 = (+($j$01$i|0));
   $116 = $115 * $110;
   $117 = (+_freq2bark($116));
   $118 = (($114) + ($j$01$i))|0;
   $119 = (($118) + -1)|0;
   $120 = (+($119|0));
   $121 = $120 * $110;
   $122 = (+_freq2bark($121));
   $123 = $122 + $117;
   $124 = $123 * 0.5;
   $125 = (($bval) + ($k$02$i<<2)|0);
   HEAPF32[$125>>2] = $124;
   $126 = (+($j$01$i|0));
   $127 = $126 + -0.5;
   $128 = $127 * $112;
   $129 = $128;
   $130 = (+_freq2bark($129));
   $131 = (+($118|0));
   $132 = $131 + -0.5;
   $133 = $132 * $112;
   $134 = $133;
   $135 = (+_freq2bark($134));
   $136 = $135 - $130;
   $137 = (($bval_width) + ($k$02$i<<2)|0);
   HEAPF32[$137>>2] = $136;
   $138 = (($k$02$i) + 1)|0;
   $exitcond$i = ($138|0)==($109|0);
   if ($exitcond$i) {
    break;
   } else {
    $j$01$i = $118;$k$02$i = $138;
   }
  }
  $$pre = HEAP32[$108>>2]|0;
  $139 = ($$pre|0)>(0);
  if ($139) {
   $i$180 = 0;
   while(1) {
    $140 = (($norm) + ($i$180<<2)|0);
    HEAPF32[$140>>2] = 1.0;
    $141 = (($i$180) + 1)|0;
    $142 = ($141|0)<($$pre|0);
    if ($142) {
     $i$180 = $141;
    } else {
     $145 = $$pre;
     break;
    }
   }
  } else {
   $145 = $$pre;
  }
 } else {
  $145 = $109;
 }
 $143 = ((($12)) + 2156|0);
 $144 = ((($12)) + 1204|0);
 $146 = (_init_s3_values($143,$144,$145,$bval,$bval_width,$norm)|0);
 $147 = ($146|0)==(0);
 if (!($147)) {
  $$0 = $146;
  STACKTOP = sp;return ($$0|0);
 }
 $148 = HEAP32[$108>>2]|0;
 $149 = ($148|0)>(0);
 if ($149) {
  $150 = ((($12)) + 1716|0);
  $151 = ((($1)) + 85796|0);
  $152 = $8;
  $153 = ((($12)) + 256|0);
  $i$278 = 0;$j$377 = 0;
  while(1) {
   $154 = (($150) + ($i$278<<2)|0);
   $155 = HEAP32[$154>>2]|0;
   $156 = ($155|0)>(0);
   if ($156) {
    $j$471 = $j$377;$k$069 = 0;$x$070 = 9.9999999999999995E+36;
    while(1) {
     $157 = (+($j$471|0));
     $158 = $157 * $5;
     $159 = $158;
     $160 = $159 * 9.7656250000000002E-7;
     $161 = $160;
     $162 = $161 * 1000.0;
     $163 = (+_ATHformula($2,$162));
     $164 = $163 + -20.0;
     $165 = $164;
     $166 = $165 * 0.10000000000000001;
     $167 = (+Math_pow(10.0,(+$166)));
     $168 = $167;
     $169 = HEAP32[$154>>2]|0;
     $170 = (+($169|0));
     $171 = $170 * $168;
     $172 = $171;
     $173 = $x$070 > $172;
     $x$1 = $173 ? $172 : $x$070;
     $174 = (($k$069) + 1)|0;
     $175 = (($j$471) + 1)|0;
     $176 = ($174|0)<($169|0);
     if ($176) {
      $j$471 = $175;$k$069 = $174;$x$070 = $x$1;
     } else {
      $193 = $169;$j$4$lcssa = $175;$x$0$lcssa = $x$1;
      break;
     }
    }
   } else {
    $193 = $155;$j$4$lcssa = $j$377;$x$0$lcssa = 9.9999999999999995E+36;
   }
   $177 = $x$0$lcssa;
   $178 = HEAP32[$151>>2]|0;
   $179 = (((($178)) + 212|0) + ($i$278<<2)|0);
   HEAPF32[$179>>2] = $177;
   $180 = (($bval) + ($i$278<<2)|0);
   $181 = +HEAPF32[$180>>2];
   $182 = $181 * 0.10000000149011612;
   $183 = $182;
   $184 = $183 + -1.0;
   $185 = $184 * 20.0;
   $186 = $185 > 6.0;
   $x$2 = $186 ? 30.0 : $185;
   $187 = $x$2 < $152;
   $x$3 = $187 ? $152 : $x$2;
   $188 = HEAP32[$3>>2]|0;
   $189 = ($188|0)<(44000);
   $x$3$op = $x$3 + -8.0;
   $x$3$op$op = $x$3$op * 0.10000000000000001;
   $190 = $189 ? 2.2000000000000002 : $x$3$op$op;
   $191 = (+Math_pow(10.0,(+$190)));
   $192 = (+($193|0));
   $194 = $192 * $191;
   $195 = $194;
   $196 = (($153) + ($i$278<<2)|0);
   HEAPF32[$196>>2] = $195;
   $197 = (($i$278) + 1)|0;
   $198 = HEAP32[$108>>2]|0;
   $199 = ($197|0)<($198|0);
   if ($199) {
    $i$278 = $197;$j$377 = $j$4$lcssa;
   } else {
    break;
   }
  }
 }
 $200 = ((($12)) + 2160|0);
 $201 = ((($1)) + 21452|0);
 _init_numline($200,$5,256,192,13,$201);
 $202 = ((($12)) + 4308|0);
 $203 = HEAP32[$202>>2]|0;
 $204 = $5 * 0.00390625;
 $205 = ($203|0)>(0);
 if ($205) {
  $206 = $204;
  $j$01$i3 = 0;$k$02$i2 = 0;
  while(1) {
   $207 = (((($200)) + 1716|0) + ($k$02$i2<<2)|0);
   $208 = HEAP32[$207>>2]|0;
   $209 = (+($j$01$i3|0));
   $210 = $209 * $204;
   $211 = (+_freq2bark($210));
   $212 = (($208) + ($j$01$i3))|0;
   $213 = (($212) + -1)|0;
   $214 = (+($213|0));
   $215 = $214 * $204;
   $216 = (+_freq2bark($215));
   $217 = $216 + $211;
   $218 = $217 * 0.5;
   $219 = (($bval) + ($k$02$i2<<2)|0);
   HEAPF32[$219>>2] = $218;
   $220 = (+($j$01$i3|0));
   $221 = $220 + -0.5;
   $222 = $221 * $206;
   $223 = $222;
   $224 = (+_freq2bark($223));
   $225 = (+($212|0));
   $226 = $225 + -0.5;
   $227 = $226 * $206;
   $228 = $227;
   $229 = (+_freq2bark($228));
   $230 = $229 - $224;
   $231 = (($bval_width) + ($k$02$i2<<2)|0);
   HEAPF32[$231>>2] = $230;
   $232 = (($k$02$i2) + 1)|0;
   $exitcond$i4 = ($232|0)==($203|0);
   if ($exitcond$i4) {
    break;
   } else {
    $j$01$i3 = $212;$k$02$i2 = $232;
   }
  }
  $$pre109 = HEAP32[$202>>2]|0;
  $233 = ($$pre109|0)>(0);
  if ($233) {
   $234 = ((($12)) + 3876|0);
   $235 = ((($1)) + 85796|0);
   $236 = $8;
   $237 = ((($12)) + 2416|0);
   $i$365 = 0;$j$564 = 0;
   while(1) {
    $238 = (($bval) + ($i$365<<2)|0);
    $239 = +HEAPF32[$238>>2];
    $240 = !($239 >= 13.0);
    if ($240) {
     $snr2$0 = -8.25;
    } else {
     $241 = $239 + -13.0;
     $242 = $241 * 0.40909090638160706;
     $243 = 24.0 - $239;
     $244 = $243 * -0.75;
     $245 = $244 - $242;
     $246 = $245;
     $snr2$0 = $246;
    }
    $247 = $snr2$0 * 0.10000000000000001;
    $248 = (+Math_pow(10.0,(+$247)));
    $249 = $248;
    $250 = (($norm) + ($i$365<<2)|0);
    HEAPF32[$250>>2] = $249;
    $251 = (($234) + ($i$365<<2)|0);
    $252 = HEAP32[$251>>2]|0;
    $253 = ($252|0)>(0);
    if ($253) {
     $j$657 = $j$564;$k$155 = 0;$x1$056 = 9.9999999999999995E+36;
     while(1) {
      $254 = (+($j$657|0));
      $255 = $254 * $5;
      $256 = $255;
      $257 = $256 * 3.9062500000000001E-6;
      $258 = $257;
      $259 = $258 * 1000.0;
      $260 = (+_ATHformula($2,$259));
      $261 = $260 + -20.0;
      $262 = $261;
      $263 = $262 * 0.10000000000000001;
      $264 = (+Math_pow(10.0,(+$263)));
      $265 = $264;
      $266 = HEAP32[$251>>2]|0;
      $267 = (+($266|0));
      $268 = $267 * $265;
      $269 = $268;
      $270 = $x1$056 > $269;
      $x1$1 = $270 ? $269 : $x1$056;
      $271 = (($k$155) + 1)|0;
      $272 = (($j$657) + 1)|0;
      $273 = ($271|0)<($266|0);
      if ($273) {
       $j$657 = $272;$k$155 = $271;$x1$056 = $x1$1;
      } else {
       $300 = $266;$j$6$lcssa = $272;$x1$0$lcssa = $x1$1;
       break;
      }
     }
    } else {
     $300 = $252;$j$6$lcssa = $j$564;$x1$0$lcssa = 9.9999999999999995E+36;
    }
    $274 = $x1$0$lcssa;
    $275 = HEAP32[$235>>2]|0;
    $276 = (((($275)) + 468|0) + ($i$365<<2)|0);
    HEAPF32[$276>>2] = $274;
    $277 = $239 * 0.083333335816860198;
    $278 = $277;
    $279 = $278 + -1.0;
    $280 = $279 * 7.0;
    $281 = $239 > 12.0;
    if ($281) {
     $282 = $280 + 1.0;
     $283 = (+Math_log((+$282)));
     $284 = $283 * 3.1000000000000001;
     $285 = $284 + 1.0;
     $286 = $285 * $280;
     $x1$2 = $286;
    } else {
     $x1$2 = $280;
    }
    $287 = $239 < 12.0;
    if ($287) {
     $288 = 1.0 - $x1$2;
     $289 = (+Math_log((+$288)));
     $290 = $289 * 2.2999999999999998;
     $291 = $290 + 1.0;
     $292 = $291 * $x1$2;
     $x1$3 = $292;
    } else {
     $x1$3 = $x1$2;
    }
    $293 = $x1$3 > 6.0;
    $x1$4 = $293 ? 30.0 : $x1$3;
    $294 = $x1$4 < $236;
    $x1$5 = $294 ? $236 : $x1$4;
    $295 = HEAP32[$3>>2]|0;
    $296 = ($295|0)<(44000);
    $x1$5$op = $x1$5 + -8.0;
    $x1$5$op$op = $x1$5$op * 0.10000000000000001;
    $297 = $296 ? 2.2000000000000002 : $x1$5$op$op;
    $298 = (+Math_pow(10.0,(+$297)));
    $299 = (+($300|0));
    $301 = $299 * $298;
    $302 = $301;
    $303 = (($237) + ($i$365<<2)|0);
    HEAPF32[$303>>2] = $302;
    $304 = (($i$365) + 1)|0;
    $305 = HEAP32[$202>>2]|0;
    $306 = ($304|0)<($305|0);
    if ($306) {
     $i$365 = $304;$j$564 = $j$6$lcssa;
    } else {
     $$lcssa20 = $305;
     break;
    }
   }
  } else {
   $$lcssa20 = $$pre109;
  }
 } else {
  $$lcssa20 = $203;
 }
 $307 = ((($12)) + 4316|0);
 $308 = ((($12)) + 3364|0);
 $309 = (_init_s3_values($307,$308,$$lcssa20,$bval,$bval_width,$norm)|0);
 $310 = ($309|0)==(0);
 if (!($310)) {
  $$0 = $309;
  STACKTOP = sp;return ($$0|0);
 }
 HEAPF32[11528>>2] = 3.6517412662506104;
 HEAPF32[11576>>2] = 31.622776031494141;
 _init_fft($1);
 $311 = $5;
 $312 = -44209.633785485676 / $311;
 $313 = (+Math_exp((+$312)));
 $314 = $313;
 $315 = ((($12)) + 6496|0);
 HEAPF32[$315>>2] = $314;
 $316 = ((($1)) + 96|0);
 $317 = HEAP32[$316>>2]|0;
 $318 = ($317|0)!=(0);
 $$ = $318 ? 1.0 : 3.5;
 $319 = ((($1)) + 192|0);
 $320 = +HEAPF32[$319>>2];
 $321 = ($320 != $320) | (0.0 != 0.0) |($320 == 0.0);
 $msfix$0 = $321 ? $$ : $320;
 HEAPF32[$319>>2] = $msfix$0;
 $322 = HEAP32[$108>>2]|0;
 $323 = ($322|0)>(0);
 if ($323) {
  $324 = (($322) + -1)|0;
  $b$051 = 0;
  while(1) {
   $325 = (((($144) + ($b$051<<3)|0)) + 4|0);
   $326 = HEAP32[$325>>2]|0;
   $327 = ($326|0)>($324|0);
   if ($327) {
    HEAP32[$325>>2] = $324;
   }
   $328 = (($b$051) + 1)|0;
   $329 = ($328|0)<($322|0);
   if ($329) {
    $b$051 = $328;
   } else {
    break;
   }
  }
 }
 $330 = ((($1)) + 76|0);
 $331 = HEAP32[$330>>2]|0;
 $332 = (+($331|0));
 $333 = $332 * 576.0;
 $334 = $333 / $311;
 $335 = $334 * -1.2;
 $336 = (+Math_pow(10.0,(+$335)));
 $337 = $336;
 $338 = ((($1)) + 85796|0);
 $339 = HEAP32[$338>>2]|0;
 $340 = ((($339)) + 16|0);
 HEAPF32[$340>>2] = $337;
 $341 = ((($339)) + 8|0);
 HEAPF32[$341>>2] = 0.0099999997764825821;
 $342 = ((($339)) + 12|0);
 HEAPF32[$342>>2] = 1.0;
 $343 = ((($1)) + 208|0);
 $344 = HEAP32[$343>>2]|0;
 $345 = ($344|0)==(-1);
 if (!($345)) {
  $346 = HEAP32[$3>>2]|0;
  $347 = (+($346|0));
  $348 = $347 * 9.765625E-4;
  $eql_balance$049 = 0.0;$freq5$048 = 0.0;$i$450 = 0;
  while(1) {
   $349 = $freq5$048 + $348;
   $350 = (+_ATHformula($2,$349));
   $351 = $350 * 0.10000000149011612;
   $352 = $351;
   $353 = (+Math_pow(10.0,(+$352)));
   $354 = 1.0 / $353;
   $355 = $354;
   $356 = HEAP32[$338>>2]|0;
   $357 = (((($356)) + 724|0) + ($i$450<<2)|0);
   HEAPF32[$357>>2] = $355;
   $358 = $355 + $eql_balance$049;
   $359 = (($i$450) + 1)|0;
   $exitcond101 = ($359|0)==(512);
   if ($exitcond101) {
    $$lcssa = $356;$$lcssa133 = $358;
    break;
   } else {
    $eql_balance$049 = $358;$freq5$048 = $349;$i$450 = $359;
   }
  }
  $360 = 1.0 / $$lcssa133;
  $377 = 511;
  while(1) {
   $376 = (((($$lcssa)) + 724|0) + ($377<<2)|0);
   $378 = +HEAPF32[$376>>2];
   $379 = $378 * $360;
   HEAPF32[$376>>2] = $379;
   $380 = (($377) + -1)|0;
   $381 = ($377|0)>(0);
   if ($381) {
    $377 = $380;
   } else {
    break;
   }
  }
 }
 $361 = HEAP32[$202>>2]|0;
 $362 = ($361|0)>(0);
 $363 = ((($gfp)) + 264|0);
 $364 = +HEAPF32[$363>>2];
 $365 = ((($gfp)) + 268|0);
 $366 = +HEAPF32[$365>>2];
 $367 = $364 < 0.0;
 $x6$0 = $367 ? 4.4000000953674316 : $364;
 $368 = $366 < 0.0;
 $y$0 = $368 ? 25.0 : $366;
 $369 = ((($12)) + 6480|0);
 $370 = ((($12)) + 6488|0);
 HEAPF32[$370>>2] = $x6$0;
 $371 = ((($12)) + 6484|0);
 HEAPF32[$371>>2] = $x6$0;
 HEAPF32[$369>>2] = $x6$0;
 $372 = ((($12)) + 6492|0);
 HEAPF32[$372>>2] = $y$0;
 $373 = ((($gfp)) + 164|0);
 $374 = HEAP32[$373>>2]|0;
 $375 = ($374|0)<(4);
 if ($375) {
  $sk_s$0 = -0.74000000953674316;
 } else {
  $382 = (11720 + ($374<<2)|0);
  $383 = +HEAPF32[$382>>2];
  $384 = ((($gfp)) + 160|0);
  $385 = +HEAPF32[$384>>2];
  $386 = (($374) + 1)|0;
  $387 = (11720 + ($386<<2)|0);
  $388 = +HEAPF32[$387>>2];
  $389 = $383 - $388;
  $390 = $389 * $385;
  $391 = $390 + $383;
  $phitmp = $391 * 0.10000000149011612;
  $sk_s$0 = $phitmp;
 }
 if ($362) {
  $392 = ($361|0)>(1);
  $393 = (+($361|0));
  $b$329 = 0;
  while(1) {
   $395 = (($361) - ($b$329))|0;
   $396 = (+($395|0));
   $397 = $396 / $393;
   $398 = $sk_s$0 * $397;
   $399 = (+Math_pow(10.0,(+$398)));
   $400 = (($200) + ($b$329<<2)|0);
   HEAPF32[$400>>2] = $399;
   $401 = (($b$329) + 1)|0;
   $402 = ($361|0)>($401|0);
   if ($402) {
    $b$329 = $401;
   } else {
    break;
   }
  }
  if ($392) {
   $394 = ($361|0)<(64);
   if ($394) {
    $b$3$lcssa110 = $361;
    label = 50;
   }
  } else {
   $b$3$lcssa110 = 1;
   label = 50;
  }
 } else {
  $b$3$lcssa110 = 0;
  label = 50;
 }
 if ((label|0) == 50) {
  $b$427 = $b$3$lcssa110;
  while(1) {
   $407 = (($200) + ($b$427<<2)|0);
   HEAPF32[$407>>2] = 1.0;
   $408 = (($b$427) + 1)|0;
   $exitcond97 = ($408|0)==(64);
   if ($exitcond97) {
    break;
   } else {
    $b$427 = $408;
   }
  }
 }
 $403 = HEAP32[$108>>2]|0;
 $404 = ($403|0)>(0);
 if ($404) {
  $405 = ($403|0)>(1);
  $406 = (+($403|0));
  $b$525 = 0;
  while(1) {
   $410 = (($403) - ($b$525))|0;
   $411 = (+($410|0));
   $412 = $411 / $406;
   $413 = $sk_s$0 * $412;
   $414 = (+Math_pow(10.0,(+$413)));
   $415 = (($12) + ($b$525<<2)|0);
   HEAPF32[$415>>2] = $414;
   $416 = (($b$525) + 1)|0;
   $417 = ($403|0)>($416|0);
   if ($417) {
    $b$525 = $416;
   } else {
    break;
   }
  }
  if ($405) {
   $409 = ($403|0)<(64);
   if ($409) {
    $b$5$lcssa111 = $403;
    label = 57;
   }
  } else {
   $b$5$lcssa111 = 1;
   label = 57;
  }
 } else {
  $b$5$lcssa111 = 0;
  label = 57;
 }
 if ((label|0) == 57) {
  $b$624 = $b$5$lcssa111;
  while(1) {
   $418 = (($12) + ($b$624<<2)|0);
   HEAPF32[$418>>2] = 1.0;
   $419 = (($b$624) + 1)|0;
   $exitcond = ($419|0)==(64);
   if ($exitcond) {
    break;
   } else {
    $b$624 = $419;
   }
  }
 }
 $420 = ((($12)) + 4320|0);
 _memcpy(($420|0),($12|0),2160)|0;
 _init_numline($420,$5,1024,192,13,$201);
 $$0 = 0;
 STACKTOP = sp;return ($$0|0);
}
function _vbrpsy_compute_MS_thresholds($eb,$thr,$cb_mld,$ath_cb,$athlower,$msfix,$n) {
 $eb = $eb|0;
 $thr = $thr|0;
 $cb_mld = $cb_mld|0;
 $ath_cb = $ath_cb|0;
 $athlower = +$athlower;
 $msfix = +$msfix;
 $n = $n|0;
 var $0 = 0.0, $1 = 0, $10 = 0.0, $11 = 0, $12 = 0.0, $13 = 0, $14 = 0.0, $15 = 0.0, $16 = 0, $17 = 0.0, $18 = 0, $19 = 0, $2 = 0, $20 = 0.0, $21 = 0.0, $22 = 0.0, $23 = 0, $24 = 0.0, $25 = 0, $26 = 0.0;
 var $27 = 0, $28 = 0.0, $29 = 0, $3 = 0, $30 = 0.0, $31 = 0, $32 = 0.0, $33 = 0.0, $34 = 0, $35 = 0.0, $36 = 0, $37 = 0.0, $38 = 0, $39 = 0.0, $4 = 0.0, $40 = 0, $41 = 0.0, $42 = 0.0, $43 = 0, $44 = 0;
 var $45 = 0.0, $46 = 0.0, $47 = 0, $48 = 0.0, $49 = 0.0, $5 = 0, $50 = 0.0, $51 = 0, $52 = 0.0, $53 = 0, $54 = 0.0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0.0, $6 = 0.0, $60 = 0, $61 = 0.0, $62 = 0;
 var $63 = 0.0, $64 = 0, $65 = 0.0, $66 = 0, $67 = 0.0, $68 = 0, $69 = 0.0, $7 = 0, $70 = 0.0, $71 = 0, $72 = 0.0, $73 = 0, $74 = 0, $75 = 0.0, $76 = 0.0, $77 = 0.0, $78 = 0, $79 = 0.0, $8 = 0.0, $80 = 0;
 var $81 = 0.0, $82 = 0, $83 = 0.0, $84 = 0, $85 = 0.0, $86 = 0, $87 = 0, $88 = 0, $9 = 0, $b$02 = 0, $b$02$us = 0, $exitcond = 0, $exitcond3 = 0, $or$cond = 0, $or$cond$us = 0, $rmid$0 = 0.0, $rmid$0$us = 0.0, $rmid$2 = 0.0, $rmid$2$us = 0.0, $rside$0 = 0.0;
 var $rside$0$us = 0.0, $rside$2 = 0.0, $rside$2$us = 0.0, $thmM$0$us = 0.0, $thmS$0$us = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = $msfix * 2.0;
 $1 = ($n|0)>(0);
 if (!($1)) {
  return;
 }
 $2 = $msfix > 0.0;
 if ($2) {
  $b$02$us = 0;
 } else {
  $b$02 = 0;
  while(1) {
   $58 = (((($eb)) + 512|0) + ($b$02<<2)|0);
   $59 = +HEAPF32[$58>>2];
   $60 = (((($eb)) + 768|0) + ($b$02<<2)|0);
   $61 = +HEAPF32[$60>>2];
   $62 = (($thr) + ($b$02<<2)|0);
   $63 = +HEAPF32[$62>>2];
   $64 = (((($thr)) + 256|0) + ($b$02<<2)|0);
   $65 = +HEAPF32[$64>>2];
   $66 = (((($thr)) + 512|0) + ($b$02<<2)|0);
   $67 = +HEAPF32[$66>>2];
   $68 = (((($thr)) + 768|0) + ($b$02<<2)|0);
   $69 = +HEAPF32[$68>>2];
   $70 = $65 * 1.5800000429153442;
   $71 = !($63 <= $70);
   $72 = $63 * 1.5800000429153442;
   $73 = !($65 <= $72);
   $or$cond = $73 | $71;
   if ($or$cond) {
    $rmid$0 = $67;$rside$0 = $69;
   } else {
    $74 = (($cb_mld) + ($b$02<<2)|0);
    $75 = +HEAPF32[$74>>2];
    $76 = $75 * $61;
    $77 = $75 * $59;
    $78 = $69 < $76;
    $79 = $78 ? $69 : $76;
    $80 = $67 < $77;
    $81 = $80 ? $67 : $77;
    $82 = $67 > $79;
    $83 = $82 ? $67 : $79;
    $84 = $69 > $81;
    $85 = $84 ? $69 : $81;
    $rmid$0 = $83;$rside$0 = $85;
   }
   $86 = $rmid$0 > $59;
   $rmid$2 = $86 ? $59 : $rmid$0;
   $87 = $rside$0 > $61;
   $rside$2 = $87 ? $61 : $rside$0;
   HEAPF32[$66>>2] = $rmid$2;
   HEAPF32[$68>>2] = $rside$2;
   $88 = (($b$02) + 1)|0;
   $exitcond = ($88|0)==($n|0);
   if ($exitcond) {
    break;
   } else {
    $b$02 = $88;
   }
  }
  return;
 }
 while(1) {
  $3 = (((($eb)) + 512|0) + ($b$02$us<<2)|0);
  $4 = +HEAPF32[$3>>2];
  $5 = (((($eb)) + 768|0) + ($b$02$us<<2)|0);
  $6 = +HEAPF32[$5>>2];
  $7 = (($thr) + ($b$02$us<<2)|0);
  $8 = +HEAPF32[$7>>2];
  $9 = (((($thr)) + 256|0) + ($b$02$us<<2)|0);
  $10 = +HEAPF32[$9>>2];
  $11 = (((($thr)) + 512|0) + ($b$02$us<<2)|0);
  $12 = +HEAPF32[$11>>2];
  $13 = (((($thr)) + 768|0) + ($b$02$us<<2)|0);
  $14 = +HEAPF32[$13>>2];
  $15 = $10 * 1.5800000429153442;
  $16 = !($8 <= $15);
  $17 = $8 * 1.5800000429153442;
  $18 = !($10 <= $17);
  $or$cond$us = $18 | $16;
  if ($or$cond$us) {
   $rmid$0$us = $12;$rside$0$us = $14;
  } else {
   $19 = (($cb_mld) + ($b$02$us<<2)|0);
   $20 = +HEAPF32[$19>>2];
   $21 = $20 * $6;
   $22 = $20 * $4;
   $23 = $14 < $21;
   $24 = $23 ? $14 : $21;
   $25 = $12 < $22;
   $26 = $25 ? $12 : $22;
   $27 = $12 > $24;
   $28 = $27 ? $12 : $24;
   $29 = $14 > $26;
   $30 = $29 ? $14 : $26;
   $rmid$0$us = $28;$rside$0$us = $30;
  }
  $31 = (($ath_cb) + ($b$02$us<<2)|0);
  $32 = +HEAPF32[$31>>2];
  $33 = $32 * $athlower;
  $34 = $8 > $33;
  $35 = $34 ? $8 : $33;
  $36 = $10 > $33;
  $37 = $36 ? $10 : $33;
  $38 = $rmid$0$us > $33;
  $39 = $38 ? $rmid$0$us : $33;
  $40 = $rside$0$us > $33;
  $41 = $40 ? $rside$0$us : $33;
  $42 = $39 + $41;
  $43 = $42 > 0.0;
  if ($43) {
   $44 = $35 < $37;
   $45 = $44 ? $35 : $37;
   $46 = $0 * $45;
   $47 = $46 < $42;
   if ($47) {
    $48 = $46 / $42;
    $49 = $48 * $39;
    $50 = $48 * $41;
    $thmM$0$us = $49;$thmS$0$us = $50;
   } else {
    $thmM$0$us = $39;$thmS$0$us = $41;
   }
  } else {
   $thmM$0$us = $39;$thmS$0$us = $41;
  }
  $51 = $thmM$0$us < $rmid$0$us;
  $52 = $51 ? $thmM$0$us : $rmid$0$us;
  $53 = $thmS$0$us < $rside$0$us;
  $54 = $53 ? $thmS$0$us : $rside$0$us;
  $55 = $52 > $4;
  $rmid$2$us = $55 ? $4 : $52;
  $56 = $54 > $6;
  $rside$2$us = $56 ? $6 : $54;
  HEAPF32[$11>>2] = $rmid$2$us;
  HEAPF32[$13>>2] = $rside$2$us;
  $57 = (($b$02$us) + 1)|0;
  $exitcond3 = ($57|0)==($n|0);
  if ($exitcond3) {
   break;
  } else {
   $b$02$us = $57;
  }
 }
 return;
}
function _convert_partition2scalefac($gd,$eb,$thr,$enn_out,$thm_out) {
 $gd = $gd|0;
 $eb = $eb|0;
 $thr = $thr|0;
 $enn_out = $enn_out|0;
 $thm_out = $thm_out|0;
 var $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0.0, $17 = 0.0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0.0, $25 = 0.0;
 var $26 = 0, $27 = 0.0, $28 = 0.0, $29 = 0.0, $3 = 0, $30 = 0, $31 = 0.0, $32 = 0.0, $33 = 0.0, $34 = 0, $35 = 0, $36 = 0.0, $37 = 0.0, $38 = 0.0, $39 = 0.0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $b$011 = 0, $b$1$lcssa = 0, $b$13 = 0, $enn$014 = 0.0, $enn$1$lcssa = 0.0, $enn$1$lcssa$lcssa = 0.0, $enn$15 = 0.0, $exitcond = 0, $exitcond26 = 0, $sb$012 = 0, $sb$012$lcssa = 0, $sb$1$ph = 0, $sb$12 = 0;
 var $thmm$013 = 0.0, $thmm$1$lcssa = 0.0, $thmm$1$lcssa$lcssa = 0.0, $thmm$14 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($gd)) + 2152|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)>(0);
 L1: do {
  if ($2) {
   $3 = ((($gd)) + 2148|0);
   $$pre = HEAP32[$3>>2]|0;
   $b$011 = 0;$enn$014 = 0.0;$sb$012 = 0;$thmm$013 = 0.0;
   while(1) {
    $5 = (((($gd)) + 2060|0) + ($sb$012<<2)|0);
    $6 = HEAP32[$5>>2]|0;
    $7 = ($6|0)<($$pre|0);
    $8 = $7 ? $6 : $$pre;
    $9 = ($b$011|0)<($8|0);
    if ($9) {
     $10 = ($$pre|0)>($6|0);
     $11 = $10 ? $6 : $$pre;
     $b$13 = $b$011;$enn$15 = $enn$014;$thmm$14 = $thmm$013;
     while(1) {
      $12 = (($eb) + ($b$13<<2)|0);
      $13 = +HEAPF32[$12>>2];
      $14 = $13 + $enn$15;
      $15 = (($thr) + ($b$13<<2)|0);
      $16 = +HEAPF32[$15>>2];
      $17 = $16 + $thmm$14;
      $18 = (($b$13) + 1)|0;
      $exitcond26 = ($18|0)==($11|0);
      if ($exitcond26) {
       $b$1$lcssa = $11;$enn$1$lcssa = $14;$thmm$1$lcssa = $17;
       break;
      } else {
       $b$13 = $18;$enn$15 = $14;$thmm$14 = $17;
      }
     }
    } else {
     $b$1$lcssa = $b$011;$enn$1$lcssa = $enn$014;$thmm$1$lcssa = $thmm$013;
    }
    $19 = ($b$1$lcssa|0)<($$pre|0);
    if (!($19)) {
     $enn$1$lcssa$lcssa = $enn$1$lcssa;$sb$012$lcssa = $sb$012;$thmm$1$lcssa$lcssa = $thmm$1$lcssa;
     break;
    }
    $23 = (((($gd)) + 1112|0) + ($sb$012<<2)|0);
    $24 = +HEAPF32[$23>>2];
    $25 = 1.0 - $24;
    $26 = (($eb) + ($b$1$lcssa<<2)|0);
    $27 = +HEAPF32[$26>>2];
    $28 = $27 * $24;
    $29 = $28 + $enn$1$lcssa;
    $30 = (($thr) + ($b$1$lcssa<<2)|0);
    $31 = +HEAPF32[$30>>2];
    $32 = $31 * $24;
    $33 = $32 + $thmm$1$lcssa;
    $34 = (($enn_out) + ($sb$012<<2)|0);
    HEAPF32[$34>>2] = $29;
    $35 = (($thm_out) + ($sb$012<<2)|0);
    HEAPF32[$35>>2] = $33;
    $36 = +HEAPF32[$26>>2];
    $37 = $36 * $25;
    $38 = +HEAPF32[$30>>2];
    $39 = $38 * $25;
    $40 = (($b$1$lcssa) + 1)|0;
    $41 = (($sb$012) + 1)|0;
    $42 = ($41|0)<($1|0);
    if ($42) {
     $b$011 = $40;$enn$014 = $37;$sb$012 = $41;$thmm$013 = $39;
    } else {
     $sb$1$ph = $41;
     break L1;
    }
   }
   $20 = (($enn_out) + ($sb$012$lcssa<<2)|0);
   HEAPF32[$20>>2] = $enn$1$lcssa$lcssa;
   $21 = (($thm_out) + ($sb$012$lcssa<<2)|0);
   HEAPF32[$21>>2] = $thmm$1$lcssa$lcssa;
   $22 = (($sb$012$lcssa) + 1)|0;
   $sb$1$ph = $22;
  } else {
   $sb$1$ph = 0;
  }
 } while(0);
 $4 = ($sb$1$ph|0)<($1|0);
 if ($4) {
  $sb$12 = $sb$1$ph;
 } else {
  return;
 }
 while(1) {
  $43 = (($enn_out) + ($sb$12<<2)|0);
  HEAPF32[$43>>2] = 0.0;
  $44 = (($thm_out) + ($sb$12<<2)|0);
  HEAPF32[$44>>2] = 0.0;
  $45 = (($sb$12) + 1)|0;
  $exitcond = ($45|0)==($1|0);
  if ($exitcond) {
   break;
  } else {
   $sb$12 = $45;
  }
 }
 return;
}
function _init_numline($gd,$sfreq,$fft_size,$mdct_size,$sbmax,$scalepos) {
 $gd = $gd|0;
 $sfreq = +$sfreq;
 $fft_size = $fft_size|0;
 $mdct_size = $mdct_size|0;
 $sbmax = $sbmax|0;
 $scalepos = $scalepos|0;
 var $$ = 0, $$2 = 0, $$lcssa = 0, $$op$op$i = 0.0, $$op$op$i3 = 0.0, $0 = 0.0, $1 = 0.0, $10 = 0.0, $100 = 0.0, $101 = 0, $102 = 0, $103 = 0, $104 = 0.0, $105 = 0.0, $106 = 0.0, $107 = 0.0, $108 = 0, $109 = 0.0, $11 = 0, $110 = 0.0;
 var $111 = 0.0, $112 = 0.0, $113 = 0.0, $114 = 0.0, $115 = 0.0, $116 = 0, $12 = 0.0, $13 = 0.0, $14 = 0.0, $15 = 0.0, $16 = 0.0, $17 = 0, $18 = 0, $19 = 0, $2 = 0.0, $20 = 0, $21 = 0, $22 = 0, $23 = 0.0, $24 = 0.0;
 var $25 = 0.0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0.0, $30 = 0, $31 = 0, $32 = 0.0, $33 = 0.0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0.0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0.0, $44 = 0.0, $45 = 0.0, $46 = 0.0, $47 = 0, $48 = 0.0, $49 = 0.0, $5 = 0.0, $50 = 0.0, $51 = 0.0, $52 = 0.0, $53 = 0.0, $54 = 0.0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0.0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0.0, $7 = 0, $70 = 0.0, $71 = 0.0, $72 = 0.0, $73 = 0.0, $74 = 0, $75 = 0, $76 = 0.0, $77 = 0.0, $78 = 0.0, $79 = 0.0;
 var $8 = 0.0, $80 = 0.0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0.0, $90 = 0, $91 = 0.0, $92 = 0.0, $93 = 0, $94 = 0.0, $95 = 0.0, $96 = 0, $97 = 0;
 var $98 = 0.0, $99 = 0.0, $b_frq = 0, $bo_w$0 = 0.0, $exitcond = 0, $exitcond17 = 0, $exitcond18 = 0, $i$29 = 0, $i$36 = 0, $j$0 = 0, $j$1$lcssa = 0, $j$112 = 0, $j$2 = 0, $j$38 = 0, $j2$0 = 0, $j2$0$lcssa = 0, $ni$0 = 0, $ni$1 = 0, $or$cond = 0, $partition = 0;
 var $sfb$05 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 2320|0;
 $b_frq = sp + 2052|0;
 $partition = sp;
 $0 = (+($mdct_size|0));
 $1 = $0 * 2.0;
 $2 = $sfreq / $1;
 $3 = (+($fft_size|0));
 $4 = $3 / $1;
 _memset(($partition|0),0,2052)|0;
 $5 = $sfreq / $3;
 $6 = (($fft_size|0) / 2)&-1;
 $j$0 = 0;$ni$0 = 0;
 while(1) {
  $7 = ($ni$0|0)<(64);
  if (!($7)) {
   $j$2 = $j$0;$ni$1 = $ni$0;
   break;
  }
  $8 = (+($j$0|0));
  $9 = $8 * $5;
  $10 = (+_freq2bark($9));
  $11 = (($b_frq) + ($ni$0<<2)|0);
  HEAPF32[$11>>2] = $9;
  $j2$0 = $j$0;
  while(1) {
   $12 = (+($j2$0|0));
   $13 = $12 * $5;
   $14 = (+_freq2bark($13));
   $15 = $14 - $10;
   $16 = $15;
   $17 = !($16 < 0.34000000000000002);
   $18 = ($j2$0|0)>($6|0);
   $or$cond = $18 | $17;
   $19 = (($j2$0) + 1)|0;
   if ($or$cond) {
    $j2$0$lcssa = $j2$0;
    break;
   } else {
    $j2$0 = $19;
   }
  }
  $20 = (($j2$0$lcssa) - ($j$0))|0;
  $21 = (((($gd)) + 1716|0) + ($ni$0<<2)|0);
  HEAP32[$21>>2] = $20;
  $22 = ($20|0)>(0);
  $23 = (+($20|0));
  $24 = 1.0 / $23;
  $25 = $22 ? $24 : 0.0;
  $26 = (((($gd)) + 512|0) + ($ni$0<<2)|0);
  HEAPF32[$26>>2] = $25;
  $27 = (($ni$0) + 1)|0;
  $28 = ($j2$0$lcssa|0)>($j$0|0);
  if ($28) {
   $j$112 = $j$0;
   while(1) {
    $29 = (($j$112) + 1)|0;
    $30 = (($partition) + ($j$112<<2)|0);
    HEAP32[$30>>2] = $ni$0;
    $exitcond18 = ($29|0)==($j2$0$lcssa|0);
    if ($exitcond18) {
     $j$1$lcssa = $j2$0$lcssa;
     break;
    } else {
     $j$112 = $29;
    }
   }
  } else {
   $j$1$lcssa = $j$0;
  }
  $31 = ($j$1$lcssa|0)>($6|0);
  if ($31) {
   $j$2 = $6;$ni$1 = $27;
   break;
  } else {
   $j$0 = $j$1$lcssa;$ni$0 = $27;
  }
 }
 $32 = (+($j$2|0));
 $33 = $32 * $5;
 $34 = (($b_frq) + ($ni$1<<2)|0);
 HEAPF32[$34>>2] = $33;
 $35 = ((($gd)) + 2152|0);
 HEAP32[$35>>2] = $sbmax;
 $36 = ((($gd)) + 2148|0);
 HEAP32[$36>>2] = $ni$1;
 $37 = ($ni$1|0)>(0);
 if ($37) {
  $i$29 = 0;$j$38 = 0;
  while(1) {
   $39 = (((($gd)) + 1716|0) + ($i$29<<2)|0);
   $40 = HEAP32[$39>>2]|0;
   $41 = (($40|0) / 2)&-1;
   $42 = (($41) + ($j$38))|0;
   $43 = (+($42|0));
   $44 = $43 * $5;
   $45 = (+_freq2bark($44));
   $46 = $45;
   $47 = $45 < 15.5;
   $$op$op$i = $46 * 0.2026833970057931;
   $48 = $47 ? $$op$op$i : 3.1415926535897931;
   $49 = (+Math_cos((+$48)));
   $50 = 1.0 - $49;
   $51 = $50 * 1.25;
   $52 = $51 + -2.5;
   $53 = (+Math_pow(10.0,(+$52)));
   $54 = $53;
   $55 = (((($gd)) + 768|0) + ($i$29<<2)|0);
   HEAPF32[$55>>2] = $54;
   $56 = (($40) + ($j$38))|0;
   $57 = (($i$29) + 1)|0;
   $58 = HEAP32[$36>>2]|0;
   $59 = ($57|0)<($58|0);
   if ($59) {
    $i$29 = $57;$j$38 = $56;
   } else {
    $$lcssa = $57;
    break;
   }
  }
  $38 = ($$lcssa|0)<(64);
  if ($38) {
   $i$36 = $$lcssa;
   label = 13;
  }
 } else {
  $i$36 = 0;
  label = 13;
 }
 if ((label|0) == 13) {
  while(1) {
   label = 0;
   $62 = (((($gd)) + 768|0) + ($i$36<<2)|0);
   HEAPF32[$62>>2] = 1.0;
   $63 = (($i$36) + 1)|0;
   $exitcond17 = ($63|0)==(64);
   if ($exitcond17) {
    break;
   } else {
    $i$36 = $63;
    label = 13;
   }
  }
 }
 $60 = ($sbmax|0)>(0);
 if (!($60)) {
  STACKTOP = sp;return;
 }
 $61 = $4;
 $sfb$05 = 0;
 while(1) {
  $64 = (($scalepos) + ($sfb$05<<2)|0);
  $65 = HEAP32[$64>>2]|0;
  $66 = (($sfb$05) + 1)|0;
  $67 = (($scalepos) + ($66<<2)|0);
  $68 = HEAP32[$67>>2]|0;
  $69 = (+($65|0));
  $70 = $69 + -0.5;
  $71 = $70 * $61;
  $72 = $71 + 0.5;
  $73 = (+Math_floor((+$72)));
  $74 = (~~(($73)));
  $75 = ($74|0)<(0);
  $$ = $75 ? 0 : $74;
  $76 = (+($68|0));
  $77 = $76 + -0.5;
  $78 = $77 * $61;
  $79 = $78 + 0.5;
  $80 = (+Math_floor((+$79)));
  $81 = (~~(($80)));
  $82 = ($81|0)>($6|0);
  $$2 = $82 ? $6 : $81;
  $83 = (($partition) + ($$2<<2)|0);
  $84 = HEAP32[$83>>2]|0;
  $85 = (($partition) + ($$<<2)|0);
  $86 = HEAP32[$85>>2]|0;
  $87 = (($86) + ($84))|0;
  $88 = (($87|0) / 2)&-1;
  $89 = (((($gd)) + 1972|0) + ($sfb$05<<2)|0);
  HEAP32[$89>>2] = $88;
  $90 = (((($gd)) + 2060|0) + ($sfb$05<<2)|0);
  HEAP32[$90>>2] = $84;
  $91 = (+($68|0));
  $92 = $91 * $2;
  $93 = (($b_frq) + ($84<<2)|0);
  $94 = +HEAPF32[$93>>2];
  $95 = $92 - $94;
  $96 = (($84) + 1)|0;
  $97 = (($b_frq) + ($96<<2)|0);
  $98 = +HEAPF32[$97>>2];
  $99 = $98 - $94;
  $100 = $95 / $99;
  $101 = $100 < 0.0;
  if ($101) {
   $bo_w$0 = 0.0;
  } else {
   $102 = $100 > 1.0;
   if ($102) {
    $bo_w$0 = 1.0;
   } else {
    $bo_w$0 = $100;
   }
  }
  $103 = (((($gd)) + 1112|0) + ($sfb$05<<2)|0);
  HEAPF32[$103>>2] = $bo_w$0;
  $104 = (+($65|0));
  $105 = $104 * $2;
  $106 = (+_freq2bark($105));
  $107 = $106;
  $108 = $106 < 15.5;
  $$op$op$i3 = $107 * 0.2026833970057931;
  $109 = $108 ? $$op$op$i3 : 3.1415926535897931;
  $110 = (+Math_cos((+$109)));
  $111 = 1.0 - $110;
  $112 = $111 * 1.25;
  $113 = $112 + -2.5;
  $114 = (+Math_pow(10.0,(+$113)));
  $115 = $114;
  $116 = (((($gd)) + 1024|0) + ($sfb$05<<2)|0);
  HEAPF32[$116>>2] = $115;
  $exitcond = ($66|0)==($sbmax|0);
  if ($exitcond) {
   break;
  } else {
   $sfb$05 = $66;
  }
 }
 STACKTOP = sp;return;
}
function _init_s3_values($p,$s3ind,$npart,$bval,$bval_width,$norm) {
 $p = $p|0;
 $s3ind = $s3ind|0;
 $npart = $npart|0;
 $bval = $bval|0;
 $bval_width = $bval_width|0;
 $norm = $norm|0;
 var $$0 = 0, $$0$i = 0.0, $$lcssa = 0, $$mux = 0, $$not = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0.0, $13 = 0.0, $14 = 0.0, $15 = 0.0, $16 = 0.0, $17 = 0.0, $18 = 0.0, $19 = 0.0, $2 = 0.0, $20 = 0.0, $21 = 0.0;
 var $22 = 0.0, $23 = 0.0, $24 = 0.0, $25 = 0.0, $26 = 0.0, $27 = 0.0, $28 = 0.0, $29 = 0.0, $3 = 0, $30 = 0.0, $31 = 0.0, $32 = 0, $33 = 0.0, $34 = 0.0, $35 = 0.0, $36 = 0.0, $37 = 0.0, $38 = 0.0, $39 = 0.0, $4 = 0.0;
 var $40 = 0.0, $41 = 0, $42 = 0.0, $43 = 0.0, $44 = 0.0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0.0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0.0, $58 = 0;
 var $59 = 0, $6 = 0.0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0.0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0;
 var $77 = 0, $8 = 0, $9 = 0.0, $brmerge = 0, $exitcond = 0, $exitcond34 = 0, $exitcond35 = 0, $exitcond36 = 0, $i$024 = 0, $i$117 = 0, $i$27 = 0, $j$021 = 0, $j$111 = 0, $j$2 = 0, $j$2$in = 0, $j$2$in$lcssa = 0, $j$2$lcssa = 0, $k$09 = 0, $k$1$lcssa = 0, $numberOfNoneZero$0$lcssa = 0;
 var $numberOfNoneZero$018 = 0, $or$cond$i = 0, $phitmp = 0, $s3 = 0, $scevgep = 0, $scevgep31 = 0, $tempx$0$i = 0.0, $tempx$0$v$i = 0.0, $x$0$i = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16384|0;
 $s3 = sp;
 _memset(($s3|0),0,16384)|0;
 $0 = ($npart|0)>(0);
 if ($0) {
  $i$024 = 0;
  while(1) {
   $1 = (($bval) + ($i$024<<2)|0);
   $2 = +HEAPF32[$1>>2];
   $3 = (($norm) + ($i$024<<2)|0);
   $4 = +HEAPF32[$3>>2];
   $j$021 = 0;
   while(1) {
    $5 = (($bval) + ($j$021<<2)|0);
    $6 = +HEAPF32[$5>>2];
    $7 = $2 - $6;
    $8 = !($7 >= 0.0);
    $tempx$0$v$i = $8 ? 1.5 : 3.0;
    $tempx$0$i = $7 * $tempx$0$v$i;
    $9 = $tempx$0$i;
    $10 = !($tempx$0$i >= 0.5);
    $11 = !($tempx$0$i <= 2.5);
    $or$cond$i = $10 | $11;
    if ($or$cond$i) {
     $x$0$i = 0.0;
    } else {
     $12 = $tempx$0$i + -0.5;
     $13 = $12 * $12;
     $14 = $13;
     $15 = $12;
     $16 = $15 * 2.0;
     $17 = $14 - $16;
     $18 = $17 * 8.0;
     $19 = $18;
     $x$0$i = $19;
    }
    $20 = $9 + 0.47399999999999998;
    $21 = $20;
    $22 = $21;
    $23 = $22 * 7.5;
    $24 = $23 + 15.811389;
    $25 = $21 * $21;
    $26 = $25;
    $27 = $26 + 1.0;
    $28 = (+Math_sqrt((+$27)));
    $29 = $28 * 17.5;
    $30 = $24 - $29;
    $31 = $30;
    $32 = !($31 <= -60.0);
    if ($32) {
     $33 = $31 + $x$0$i;
     $34 = $33;
     $35 = $34 * 0.23025850929940458;
     $36 = (+Math_exp((+$35)));
     $37 = $36;
     $38 = $37;
     $39 = $38 * 1.5130440282194817;
     $40 = $39;
     $$0$i = $40;
    } else {
     $$0$i = 0.0;
    }
    $41 = (($bval_width) + ($j$021<<2)|0);
    $42 = +HEAPF32[$41>>2];
    $43 = $42 * $$0$i;
    $44 = $43 * $4;
    $45 = ((($s3) + ($i$024<<8)|0) + ($j$021<<2)|0);
    HEAPF32[$45>>2] = $44;
    $46 = (($j$021) + 1)|0;
    $exitcond35 = ($46|0)==($npart|0);
    if ($exitcond35) {
     break;
    } else {
     $j$021 = $46;
    }
   }
   $47 = (($i$024) + 1)|0;
   $exitcond36 = ($47|0)==($npart|0);
   if ($exitcond36) {
    break;
   } else {
    $i$024 = $47;
   }
  }
  if ($0) {
   $i$117 = 0;$numberOfNoneZero$018 = 0;
   while(1) {
    $j$111 = 0;
    while(1) {
     $48 = ((($s3) + ($i$117<<8)|0) + ($j$111<<2)|0);
     $49 = +HEAPF32[$48>>2];
     $50 = $49 > 0.0;
     if ($50) {
      $54 = $j$111;
      break;
     }
     $51 = (($j$111) + 1)|0;
     $52 = ($51|0)<($npart|0);
     if ($52) {
      $j$111 = $51;
     } else {
      $54 = $51;
      break;
     }
    }
    $53 = (($s3ind) + ($i$117<<3)|0);
    HEAP32[$53>>2] = $54;
    $j$2$in = $npart;
    while(1) {
     $j$2 = (($j$2$in) + -1)|0;
     $55 = ($j$2$in|0)>(1);
     if (!($55)) {
      $j$2$in$lcssa = $j$2$in;$j$2$lcssa = $j$2;
      break;
     }
     $56 = ((($s3) + ($i$117<<8)|0) + ($j$2<<2)|0);
     $57 = +HEAPF32[$56>>2];
     $58 = $57 > 0.0;
     if ($58) {
      $j$2$in$lcssa = $j$2$in;$j$2$lcssa = $j$2;
      break;
     } else {
      $j$2$in = $j$2;
     }
    }
    $59 = (((($s3ind) + ($i$117<<3)|0)) + 4|0);
    HEAP32[$59>>2] = $j$2$lcssa;
    $60 = (($numberOfNoneZero$018) + ($j$2$in$lcssa))|0;
    $61 = (($60) - ($54))|0;
    $62 = (($i$117) + 1)|0;
    $exitcond34 = ($62|0)==($npart|0);
    if ($exitcond34) {
     $$lcssa = $61;
     break;
    } else {
     $i$117 = $62;$numberOfNoneZero$018 = $61;
    }
   }
   $phitmp = $$lcssa << 2;
   $numberOfNoneZero$0$lcssa = $phitmp;
  } else {
   $numberOfNoneZero$0$lcssa = 0;
  }
 } else {
  $numberOfNoneZero$0$lcssa = 0;
 }
 $63 = (_malloc($numberOfNoneZero$0$lcssa)|0);
 HEAP32[$p>>2] = $63;
 $64 = ($63|0)==(0|0);
 $$not = $0 ^ 1;
 $brmerge = $64 | $$not;
 $$mux = $64 << 31 >> 31;
 if ($brmerge) {
  $$0 = $$mux;
  STACKTOP = sp;return ($$0|0);
 } else {
  $i$27 = 0;$k$09 = 0;
 }
 while(1) {
  $65 = (($s3ind) + ($i$27<<3)|0);
  $66 = HEAP32[$65>>2]|0;
  $67 = (((($s3ind) + ($i$27<<3)|0)) + 4|0);
  $68 = HEAP32[$67>>2]|0;
  $69 = ($66|0)>($68|0);
  if ($69) {
   $k$1$lcssa = $k$09;
  } else {
   $70 = HEAP32[$p>>2]|0;
   $71 = (($k$09) + 1)|0;
   $72 = (($71) + ($68))|0;
   $scevgep = (($70) + ($k$09<<2)|0);
   $scevgep31 = ((($s3) + ($i$27<<8)|0) + ($66<<2)|0);
   $73 = (($68) + 1)|0;
   $74 = (($73) - ($66))|0;
   $75 = $74 << 2;
   _memcpy(($scevgep|0),($scevgep31|0),($75|0))|0;
   $76 = (($72) - ($66))|0;
   $k$1$lcssa = $76;
  }
  $77 = (($i$27) + 1)|0;
  $exitcond = ($77|0)==($npart|0);
  if ($exitcond) {
   $$0 = 0;
   break;
  } else {
   $i$27 = $77;$k$09 = $k$1$lcssa;
  }
 }
 STACKTOP = sp;return ($$0|0);
}
function _init_xrpow_core_init($gfc) {
 $gfc = $gfc|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $init_xrpow_core_c$init_xrpow_core_sse = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($gfc)) + 85824|0);
 $1 = ((($gfc)) + 85756|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = $2 & 4;
 $4 = ($3|0)==(0);
 $init_xrpow_core_c$init_xrpow_core_sse = $4 ? 6 : 5;
 HEAP32[$0>>2] = $init_xrpow_core_c$init_xrpow_core_sse;
 return;
}
function _VBR_old_iteration_loop($gfc,$pe,$ms_ener_ratio,$ratio) {
 $gfc = $gfc|0;
 $pe = $pe|0;
 $ms_ener_ratio = $ms_ener_ratio|0;
 $ratio = $ratio|0;
 var $$$i = 0, $$$i6 = 0.0, $$0$i1 = 0, $$01$i = 0, $$1$i = 0, $$12$i = 0, $$lcssa = 0, $$lcssa63 = 0, $$lobit$i = 0, $$pre$i = 0, $$pre$phiZ2D = 0, $$pre$pre = 0, $$pre$pre$pre = 0, $$pre29$i = 0, $$pre29$i$lcssa = 0, $$pre34 = 0, $$pre35 = 0, $$pre38 = 0, $0 = 0, $1 = 0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0.0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0.0, $206 = 0.0, $207 = 0.0;
 var $208 = 0.0, $209 = 0, $21 = 0, $210 = 0.0, $211 = 0.0, $212 = 0.0, $213 = 0.0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0.0, $222 = 0.0, $223 = 0.0, $224 = 0.0, $225 = 0;
 var $226 = 0.0, $227 = 0.0, $228 = 0.0, $229 = 0.0, $23 = 0, $230 = 0, $231 = 0.0, $232 = 0.0, $233 = 0.0, $234 = 0.0, $235 = 0, $236 = 0.0, $237 = 0.0, $238 = 0.0, $239 = 0.0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0.0;
 var $244 = 0, $245 = 0, $246 = 0.0, $247 = 0.0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0;
 var $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0;
 var $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0.0, $5 = 0, $50 = 0, $51 = 0.0, $52 = 0.0;
 var $53 = 0.0, $54 = 0.0, $55 = 0.0, $56 = 0, $57 = 0, $58 = 0.0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0.0, $68 = 0.0, $69 = 0.0, $7 = 0, $70 = 0.0;
 var $71 = 0.0, $72 = 0.0, $73 = 0.0, $74 = 0.0, $75 = 0.0, $76 = 0.0, $77 = 0.0, $78 = 0.0, $79 = 0.0, $8 = 0, $80 = 0.0, $81 = 0.0, $82 = 0.0, $83 = 0.0, $84 = 0.0, $85 = 0.0, $86 = 0.0, $87 = 0, $88 = 0, $89 = 0;
 var $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $analog_silence$0$lcssa34$i = 0, $analog_silence$023$i = 0, $analog_silence$1$$i = 0, $analog_silence$1$lcssa$i = 0, $analog_silence$1$lcssa$i$lcssa = 0, $analog_silence$115$i = 0, $bits$024$i = 0, $bits$1$lcssa$i = 0, $bits$1$lcssa$i$lcssa = 0;
 var $bits$116$i = 0, $bst_cod_info$i = 0, $bst_xrpow$i = 0, $ch$014$i = 0, $ch$022 = 0, $ch$07$i = 0, $ch$115 = 0, $ch$16$i = 0, $ch$16$us$us$i = 0, $dbits$0$i = 0, $exitcond = 0, $exitcond$i = 0, $exitcond$i$i = 0, $found$0$i = 0, $found$1$i = 0, $found$1$i$lcssa = 0, $frameBits = 0, $gr$0 = 0, $gr$010$i = 0, $gr$020$i = 0;
 var $gr$116 = 0, $gr$17$i = 0, $gr$17$us$i = 0, $i$01$i = 0, $i$01$i$i = 0, $i$01$i2$i = 0, $indvars$iv$i = 0, $indvars$iv13$i = 0, $l3_xmin = 0, $masking_lower_db$0$i = 0.0, $max_bits = 0, $mean_bits = 0, $min_bits = 0, $pxmin$0$lcssa$i = 0, $pxmin$02$i = 0, $pxmin$14$i = 0, $scevgep$i = 0, $scevgep14$i = 0, $scevgep15$i = 0, $sfb$01$i = 0;
 var $sfb$13$i = 0, $smax$i = 0, $storemerge = 0, $this_bits$0$i = 0, $this_bits$1$i = 0, $used_bits$0 = 0, $used_bits$1$lcssa = 0, $used_bits$124 = 0, $used_bits$2 = 0, $used_bits$2$lcssa = 0, $xrpow = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 10592|0;
 $bst_cod_info$i = sp + 5336|0;
 $bst_xrpow$i = sp + 3032|0;
 $l3_xmin = sp + 2408|0;
 $xrpow = sp + 104|0;
 $frameBits = sp + 40|0;
 $min_bits = sp + 24|0;
 $max_bits = sp + 8|0;
 $mean_bits = sp;
 $0 = ((($gfc)) + 116|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($gfc)) + 84744|0);
 HEAP32[$2>>2] = $1;
 $3 = (_ResvFrameBegin($gfc,$bst_xrpow$i)|0);
 $4 = ((($gfc)) + 76|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = (($3|0) / ($5|0))&-1;
 HEAP32[$bst_xrpow$i>>2] = $6;
 $7 = ((($gfc)) + 112|0);
 $8 = HEAP32[$7>>2]|0;
 HEAP32[$2>>2] = $8;
 HEAP32[$2>>2] = 1;
 $9 = (_getframebits($gfc)|0);
 HEAP32[$bst_cod_info$i>>2] = $9;
 $10 = HEAP32[$0>>2]|0;
 $11 = ($10|0)<(1);
 if (!($11)) {
  $i$01$i$i = 1;
  while(1) {
   HEAP32[$2>>2] = $i$01$i$i;
   $12 = (_ResvFrameBegin($gfc,$bst_cod_info$i)|0);
   $13 = (($frameBits) + ($i$01$i$i<<2)|0);
   HEAP32[$13>>2] = $12;
   $14 = (($i$01$i$i) + 1)|0;
   $15 = HEAP32[$0>>2]|0;
   $16 = ($i$01$i$i|0)<($15|0);
   if ($16) {
    $i$01$i$i = $14;
   } else {
    break;
   }
  }
 }
 $17 = HEAP32[$4>>2]|0;
 $18 = ($17|0)>(0);
 L5: do {
  if ($18) {
   $19 = ((($gfc)) + 84756|0);
   $20 = ((($gfc)) + 72|0);
   $21 = ((($gfc)) + 84916|0);
   $22 = ((($gfc)) + 84908|0);
   $23 = ((($gfc)) + 84912|0);
   $analog_silence$023$i = 1;$bits$024$i = 0;$gr$020$i = 0;
   while(1) {
    $43 = (($max_bits) + ($gr$020$i<<3)|0);
    $44 = HEAP32[$bst_xrpow$i>>2]|0;
    $45 = (_on_pe($gfc,$pe,$43,$44,$gr$020$i,0)|0);
    $46 = HEAP32[$19>>2]|0;
    $47 = ($46|0)==(2);
    if ($47) {
     $i$01$i2$i = 0;
     while(1) {
      $48 = ((((($gfc)) + 304|0) + (($gr$020$i*10504)|0)|0) + ($i$01$i2$i<<2)|0);
      $49 = +HEAPF32[$48>>2];
      $50 = ((((((($gfc)) + 304|0) + (($gr$020$i*10504)|0)|0)) + 5252|0) + ($i$01$i2$i<<2)|0);
      $51 = +HEAPF32[$50>>2];
      $52 = $51 + $49;
      $53 = $52 * 0.70710676908493042;
      HEAPF32[$48>>2] = $53;
      $54 = $49 - $51;
      $55 = $54 * 0.70710676908493042;
      HEAPF32[$50>>2] = $55;
      $56 = (($i$01$i2$i) + 1)|0;
      $exitcond$i$i = ($56|0)==(576);
      if ($exitcond$i$i) {
       break;
      } else {
       $i$01$i2$i = $56;
      }
     }
     $57 = (($ms_ener_ratio) + ($gr$020$i<<2)|0);
     $58 = +HEAPF32[$57>>2];
     $59 = HEAP32[$bst_xrpow$i>>2]|0;
     _reduce_side($43,$58,$59,$45);
    }
    $60 = HEAP32[$20>>2]|0;
    $61 = ($60|0)>(0);
    if ($61) {
     $analog_silence$115$i = $analog_silence$023$i;$bits$116$i = $bits$024$i;$ch$014$i = 0;
     while(1) {
      $62 = ((((($gfc)) + 304|0) + (($gr$020$i*10504)|0)|0) + (($ch$014$i*5252)|0)|0);
      $63 = ((((((($gfc)) + 304|0) + (($gr$020$i*10504)|0)|0) + (($ch$014$i*5252)|0)|0)) + 4788|0);
      $64 = HEAP32[$63>>2]|0;
      $65 = ($64|0)==(2);
      $66 = ((($pe) + ($gr$020$i<<3)|0) + ($ch$014$i<<2)|0);
      $67 = +HEAPF32[$66>>2];
      $68 = $67;
      $69 = $68 * 0.0033333333333333335;
      $70 = 3.5 - $69;
      $71 = (+Math_exp((+$70)));
      $72 = $71 + 1.0;
      if ($65) {
       $78 = 2.5600000000000001 / $72;
       $79 = $78 + -0.14000000000000001;
       $80 = $79;
       $81 = +HEAPF32[$21>>2];
       $82 = $81 - $80;
       $masking_lower_db$0$i = $82;
      } else {
       $73 = 1.28 / $72;
       $74 = $73 + -0.050000000000000003;
       $75 = $74;
       $76 = +HEAPF32[$23>>2];
       $77 = $76 - $75;
       $masking_lower_db$0$i = $77;
      }
      $83 = $masking_lower_db$0$i;
      $84 = $83 * 0.10000000000000001;
      $85 = (+Math_pow(10.0,(+$84)));
      $86 = $85;
      HEAPF32[$22>>2] = $86;
      _init_outer_loop($gfc,$62);
      $87 = ((($ratio) + (($gr$020$i*976)|0)|0) + (($ch$014$i*488)|0)|0);
      $88 = ((($l3_xmin) + (($gr$020$i*312)|0)|0) + (($ch$014$i*156)|0)|0);
      $89 = (_calc_xmin($gfc,$87,$62,$88)|0);
      $90 = ($89|0)==(0);
      $analog_silence$1$$i = $90 ? $analog_silence$115$i : 0;
      $91 = ((($min_bits) + ($gr$020$i<<3)|0) + ($ch$014$i<<2)|0);
      HEAP32[$91>>2] = 126;
      $92 = ((($max_bits) + ($gr$020$i<<3)|0) + ($ch$014$i<<2)|0);
      $93 = HEAP32[$92>>2]|0;
      $94 = (($93) + ($bits$116$i))|0;
      $95 = (($ch$014$i) + 1)|0;
      $96 = HEAP32[$20>>2]|0;
      $97 = ($95|0)<($96|0);
      if ($97) {
       $analog_silence$115$i = $analog_silence$1$$i;$bits$116$i = $94;$ch$014$i = $95;
      } else {
       $$pre29$i = $96;$analog_silence$1$lcssa$i = $analog_silence$1$$i;$bits$1$lcssa$i = $94;
       break;
      }
     }
    } else {
     $$pre29$i = $60;$analog_silence$1$lcssa$i = $analog_silence$023$i;$bits$1$lcssa$i = $bits$024$i;
    }
    $98 = (($gr$020$i) + 1)|0;
    $99 = HEAP32[$4>>2]|0;
    $100 = ($98|0)<($99|0);
    if ($100) {
     $analog_silence$023$i = $analog_silence$1$lcssa$i;$bits$024$i = $bits$1$lcssa$i;$gr$020$i = $98;
    } else {
     $$lcssa63 = $99;$$pre29$i$lcssa = $$pre29$i;$analog_silence$1$lcssa$i$lcssa = $analog_silence$1$lcssa$i;$bits$1$lcssa$i$lcssa = $bits$1$lcssa$i;
     break;
    }
   }
   $24 = ($$lcssa63|0)>(0);
   if ($24) {
    $25 = ($bits$1$lcssa$i$lcssa|0)>(0);
    if (!($25)) {
     $101 = $$pre29$i$lcssa;$267 = $$pre29$i$lcssa;$gr$17$i = 0;
     while(1) {
      $102 = ($101|0)>(0);
      if ($102) {
       $268 = $267;$ch$16$i = 0;
       while(1) {
        $103 = ((($min_bits) + ($gr$17$i<<3)|0) + ($ch$16$i<<2)|0);
        $104 = HEAP32[$103>>2]|0;
        $105 = ((($max_bits) + ($gr$17$i<<3)|0) + ($ch$16$i<<2)|0);
        $106 = HEAP32[$105>>2]|0;
        $107 = ($104|0)>($106|0);
        if ($107) {
         HEAP32[$103>>2] = $106;
         $110 = $$pre29$i$lcssa;
        } else {
         $110 = $268;
        }
        $108 = (($ch$16$i) + 1)|0;
        $109 = ($108|0)<($110|0);
        if ($109) {
         $268 = $110;$ch$16$i = $108;
        } else {
         $269 = $110;$270 = $110;
         break;
        }
       }
      } else {
       $269 = $267;$270 = $101;
      }
      $111 = (($gr$17$i) + 1)|0;
      $112 = ($111|0)<($$lcssa63|0);
      if ($112) {
       $101 = $270;$267 = $269;$gr$17$i = $111;
      } else {
       $$pre$phiZ2D = $20;$266 = $$lcssa63;$analog_silence$0$lcssa34$i = $analog_silence$1$lcssa$i$lcssa;
       break L5;
      }
     }
    }
    $26 = ($$pre29$i$lcssa|0)>(0);
    $gr$17$us$i = 0;
    while(1) {
     if ($26) {
      $27 = HEAP32[$0>>2]|0;
      $28 = (($frameBits) + ($27<<2)|0);
      $29 = HEAP32[$28>>2]|0;
      $30 = ($bits$1$lcssa$i$lcssa|0)>($29|0);
      $ch$16$us$us$i = 0;
      while(1) {
       $33 = ((($max_bits) + ($gr$17$us$i<<3)|0) + ($ch$16$us$us$i<<2)|0);
       $34 = HEAP32[$33>>2]|0;
       if ($30) {
        $35 = Math_imul($34, $29)|0;
        $36 = (($35|0) / ($bits$1$lcssa$i$lcssa|0))&-1;
        HEAP32[$33>>2] = $36;
        $40 = $36;
       } else {
        $40 = $34;
       }
       $37 = ((($min_bits) + ($gr$17$us$i<<3)|0) + ($ch$16$us$us$i<<2)|0);
       $38 = HEAP32[$37>>2]|0;
       $39 = ($38|0)>($40|0);
       if ($39) {
        HEAP32[$37>>2] = $40;
       }
       $41 = (($ch$16$us$us$i) + 1)|0;
       $42 = ($41|0)<($$pre29$i$lcssa|0);
       if ($42) {
        $ch$16$us$us$i = $41;
       } else {
        break;
       }
      }
     }
     $31 = (($gr$17$us$i) + 1)|0;
     $32 = ($31|0)<($$lcssa63|0);
     if ($32) {
      $gr$17$us$i = $31;
     } else {
      $$pre$phiZ2D = $20;$266 = $$lcssa63;$analog_silence$0$lcssa34$i = $analog_silence$1$lcssa$i$lcssa;
      break;
     }
    }
   } else {
    $$pre$phiZ2D = $20;$266 = $$lcssa63;$analog_silence$0$lcssa34$i = $analog_silence$1$lcssa$i$lcssa;
   }
  } else {
   $$pre38 = ((($gfc)) + 72|0);
   $$pre$phiZ2D = $$pre38;$266 = $17;$analog_silence$0$lcssa34$i = 1;
  }
 } while(0);
 $113 = ($analog_silence$0$lcssa34$i|0)==(0);
 $114 = ((($gfc)) + 124|0);
 $115 = ((($gfc)) + 85824|0);
 $116 = ((($gfc)) + 85096|0);
 $117 = ((($gfc)) + 85092|0);
 $118 = ((($bst_cod_info$i)) + 2304|0);
 $120 = $266;$gr$0 = 0;$used_bits$0 = 0;
 L50: while(1) {
  $119 = ($gr$0|0)<($120|0);
  if (!($119)) {
   if ($113) {
    label = 55;
   } else {
    $182 = HEAP32[$114>>2]|0;
    $183 = ($182|0)==(0);
    if ($183) {
     $storemerge = 1;
    } else {
     label = 55;
    }
   }
   if ((label|0) == 55) {
    label = 0;
    $184 = HEAP32[$7>>2]|0;
    $storemerge = $184;
   }
   HEAP32[$2>>2] = $storemerge;
   $185 = HEAP32[$0>>2]|0;
   $186 = ($storemerge|0)<($185|0);
   L59: do {
    if ($186) {
     $188 = $storemerge;
     while(1) {
      $187 = (($frameBits) + ($188<<2)|0);
      $189 = HEAP32[$187>>2]|0;
      $190 = ($used_bits$0|0)>($189|0);
      if (!($190)) {
       break L59;
      }
      $191 = (($188) + 1)|0;
      HEAP32[$2>>2] = $191;
      $192 = ($191|0)<($185|0);
      if ($192) {
       $188 = $191;
      } else {
       break;
      }
     }
    }
   } while(0);
   $193 = (_ResvFrameBegin($gfc,$mean_bits)|0);
   $194 = ($used_bits$0|0)>($193|0);
   $195 = HEAP32[$4>>2]|0;
   $196 = ($195|0)>(0);
   if (!($194)) {
    break;
   }
   if (!($196)) {
    $120 = $195;$gr$0 = 0;$used_bits$0 = 0;
    continue;
   }
   $$pre$i = HEAP32[$$pre$phiZ2D>>2]|0;
   $199 = ($$pre$i|0)>(0);
   $gr$010$i = 0;$indvars$iv$i = $l3_xmin;
   while(1) {
    if ($199) {
     $ch$07$i = 0;$indvars$iv13$i = $indvars$iv$i;
     while(1) {
      $200 = ((($l3_xmin) + (($gr$010$i*312)|0)|0) + (($ch$07$i*156)|0)|0);
      $201 = ((((((($gfc)) + 304|0) + (($gr$010$i*10504)|0)|0) + (($ch$07$i*5252)|0)|0)) + 4856|0);
      $202 = HEAP32[$201>>2]|0;
      $203 = ($202|0)>(0);
      if ($203) {
       $204 = ($202|0)>(1);
       $pxmin$02$i = $200;$sfb$01$i = 0;
       while(1) {
        $205 = (+($sfb$01$i|0));
        $206 = $205 * $205;
        $207 = $206 * 5.9917355371900827E-5;
        $208 = $207 + 1.0;
        $209 = ((($pxmin$02$i)) + 4|0);
        $210 = +HEAPF32[$pxmin$02$i>>2];
        $211 = $210;
        $212 = $208 * $211;
        $213 = $212;
        HEAPF32[$pxmin$02$i>>2] = $213;
        $214 = (($sfb$01$i) + 1)|0;
        $exitcond = ($214|0)==($202|0);
        if ($exitcond) {
         break;
        } else {
         $pxmin$02$i = $209;$sfb$01$i = $214;
        }
       }
       $smax$i = $204 ? $202 : 1;
       $scevgep15$i = (($indvars$iv13$i) + ($smax$i<<2)|0);
       $pxmin$0$lcssa$i = $scevgep15$i;
      } else {
       $pxmin$0$lcssa$i = $200;
      }
      $215 = ((((((($gfc)) + 304|0) + (($gr$010$i*10504)|0)|0) + (($ch$07$i*5252)|0)|0)) + 4788|0);
      $216 = HEAP32[$215>>2]|0;
      $217 = ($216|0)==(2);
      if ($217) {
       $218 = ((((((($gfc)) + 304|0) + (($gr$010$i*10504)|0)|0) + (($ch$07$i*5252)|0)|0)) + 4852|0);
       $219 = HEAP32[$218>>2]|0;
       $220 = ($219|0)<(13);
       if ($220) {
        $pxmin$14$i = $pxmin$0$lcssa$i;$sfb$13$i = $219;
        while(1) {
         $221 = (+($sfb$13$i|0));
         $222 = $221 * $221;
         $223 = $222 * 1.7159763313609469E-4;
         $224 = $223 + 1.0;
         $225 = ((($pxmin$14$i)) + 4|0);
         $226 = +HEAPF32[$pxmin$14$i>>2];
         $227 = $226;
         $228 = $224 * $227;
         $229 = $228;
         HEAPF32[$pxmin$14$i>>2] = $229;
         $230 = ((($pxmin$14$i)) + 8|0);
         $231 = +HEAPF32[$225>>2];
         $232 = $231;
         $233 = $224 * $232;
         $234 = $233;
         HEAPF32[$225>>2] = $234;
         $235 = ((($pxmin$14$i)) + 12|0);
         $236 = +HEAPF32[$230>>2];
         $237 = $236;
         $238 = $237 * $224;
         $239 = $238;
         HEAPF32[$230>>2] = $239;
         $240 = (($sfb$13$i) + 1)|0;
         $exitcond$i = ($240|0)==(13);
         if ($exitcond$i) {
          break;
         } else {
          $pxmin$14$i = $235;$sfb$13$i = $240;
         }
        }
       }
      }
      $241 = ((($min_bits) + ($gr$010$i<<3)|0) + ($ch$07$i<<2)|0);
      $242 = HEAP32[$241>>2]|0;
      $243 = (+($242|0));
      $244 = ((($max_bits) + ($gr$010$i<<3)|0) + ($ch$07$i<<2)|0);
      $245 = HEAP32[$244>>2]|0;
      $246 = (+($245|0));
      $247 = $246 * 0.90000000000000002;
      $248 = $243 > $247;
      $$$i6 = $248 ? $243 : $247;
      $249 = (~~(($$$i6)));
      HEAP32[$244>>2] = $249;
      $250 = (($ch$07$i) + 1)|0;
      $251 = ($250|0)<($$pre$i|0);
      $scevgep14$i = ((($indvars$iv13$i)) + 156|0);
      if ($251) {
       $ch$07$i = $250;$indvars$iv13$i = $scevgep14$i;
      } else {
       break;
      }
     }
    }
    $252 = (($gr$010$i) + 1)|0;
    $253 = ($252|0)<($195|0);
    $scevgep$i = ((($indvars$iv$i)) + 312|0);
    if ($253) {
     $gr$010$i = $252;$indvars$iv$i = $scevgep$i;
    } else {
     $120 = $195;$gr$0 = 0;$used_bits$0 = 0;
     continue L50;
    }
   }
  }
  $121 = HEAP32[$$pre$phiZ2D>>2]|0;
  $122 = ($121|0)>(0);
  if ($122) {
   $ch$022 = 0;$used_bits$124 = $used_bits$0;
   while(1) {
    $123 = ((((($gfc)) + 304|0) + (($gr$0*10504)|0)|0) + (($ch$022*5252)|0)|0);
    HEAPF32[$bst_cod_info$i>>2] = 0.0;
    $124 = ((((((($gfc)) + 304|0) + (($gr$0*10504)|0)|0) + (($ch$022*5252)|0)|0)) + 5208|0);
    $125 = HEAP32[$124>>2]|0;
    $126 = ((((((($gfc)) + 304|0) + (($gr$0*10504)|0)|0) + (($ch$022*5252)|0)|0)) + 4764|0);
    HEAPF32[$126>>2] = 0.0;
    $127 = (($xrpow) + ($125<<2)|0);
    $128 = (576 - ($125))|0;
    $129 = $128 << 2;
    _memset(($127|0),0,($129|0))|0;
    $130 = HEAP32[$115>>2]|0;
    FUNCTION_TABLE_viiii[$130 & 7]($123,$xrpow,$125,$bst_cod_info$i);
    $131 = +HEAPF32[$bst_cod_info$i>>2];
    $132 = $131 > 9.9999996826552254E-21;
    if ($132) {
     $133 = HEAP32[$116>>2]|0;
     $134 = $133 >>> 1;
     $$lobit$i = $134 & 1;
     $135 = ((((((($gfc)) + 304|0) + (($gr$0*10504)|0)|0) + (($ch$022*5252)|0)|0)) + 4864|0);
     $136 = HEAP32[$135>>2]|0;
     $137 = ($136|0)>(0);
     if ($137) {
      $i$01$i = 0;
      while(1) {
       $138 = (((($gfc)) + 84936|0) + ($i$01$i<<2)|0);
       HEAP32[$138>>2] = $$lobit$i;
       $139 = (($i$01$i) + 1)|0;
       $140 = HEAP32[$135>>2]|0;
       $141 = ($139|0)<($140|0);
       if ($141) {
        $i$01$i = $139;
       } else {
        break;
       }
      }
     }
     $143 = ((($max_bits) + ($gr$0<<3)|0) + ($ch$022<<2)|0);
     $144 = HEAP32[$143>>2]|0;
     $145 = ($144|0)==(0);
     if ($145) {
      $used_bits$2 = $used_bits$124;
     } else {
      $146 = ((($l3_xmin) + (($gr$0*312)|0)|0) + (($ch$022*156)|0)|0);
      $147 = ((($min_bits) + ($gr$0<<3)|0) + ($ch$022<<2)|0);
      $148 = HEAP32[$147>>2]|0;
      $149 = (($148) + ($144))|0;
      $150 = (($149|0) / 2)&-1;
      $151 = HEAP32[$117>>2]|0;
      _memset(($118|0),0,2304)|0;
      $152 = (($144) + -42)|0;
      $153 = ((((((($gfc)) + 304|0) + (($gr$0*10504)|0)|0) + (($ch$022*5252)|0)|0)) + 4768|0);
      $$0$i1 = $148;$$01$i = $144;$found$0$i = 0;$this_bits$0$i = $150;
      while(1) {
       $154 = ($this_bits$0$i|0)>($152|0);
       $$$i = $154 ? 0 : $151;
       HEAP32[$117>>2] = $$$i;
       $155 = (_outer_loop($gfc,$123,$146,$xrpow,$ch$022,$this_bits$0$i)|0);
       $156 = ($155|0)<(1);
       if ($156) {
        $157 = HEAP32[$153>>2]|0;
        _memcpy(($bst_cod_info$i|0),($123|0),5252)|0;
        _memcpy(($bst_xrpow$i|0),($xrpow|0),2304)|0;
        $158 = (($157) + -32)|0;
        $159 = (($158) - ($$0$i1))|0;
        $160 = (($158) + ($$0$i1))|0;
        $161 = (($160|0) / 2)&-1;
        $$1$i = $$0$i1;$$12$i = $158;$dbits$0$i = $159;$found$1$i = 1;$this_bits$1$i = $161;
       } else {
        $162 = (($this_bits$0$i) + 32)|0;
        $163 = (($$01$i) - ($162))|0;
        $164 = (($$01$i) + ($162))|0;
        $165 = (($164|0) / 2)&-1;
        $166 = ($found$0$i|0)==(0);
        if ($166) {
         $$1$i = $162;$$12$i = $$01$i;$dbits$0$i = $163;$found$1$i = 0;$this_bits$1$i = $165;
        } else {
         _memcpy(($123|0),($bst_cod_info$i|0),5252)|0;
         _memcpy(($xrpow|0),($bst_xrpow$i|0),2304)|0;
         $$1$i = $162;$$12$i = $$01$i;$dbits$0$i = $163;$found$1$i = 2;$this_bits$1$i = $165;
        }
       }
       $167 = ($dbits$0$i|0)>(12);
       if ($167) {
        $$0$i1 = $$1$i;$$01$i = $$12$i;$found$0$i = $found$1$i;$this_bits$0$i = $this_bits$1$i;
       } else {
        $found$1$i$lcssa = $found$1$i;
        break;
       }
      }
      HEAP32[$117>>2] = $151;
      $168 = ($found$1$i$lcssa|0)==(2);
      if ($168) {
       $169 = ((((((($gfc)) + 304|0) + (($gr$0*10504)|0)|0) + (($ch$022*5252)|0)|0)) + 2304|0);
       _memcpy(($169|0),($118|0),2304)|0;
      }
      $170 = HEAP32[$116>>2]|0;
      $171 = $170 & 1;
      $172 = ($171|0)==(0);
      if (!($172)) {
       _trancate_smallspectrums($gfc,$123,$146,$xrpow);
      }
      $173 = HEAP32[$153>>2]|0;
      $174 = ((((((($gfc)) + 304|0) + (($gr$0*10504)|0)|0) + (($ch$022*5252)|0)|0)) + 4844|0);
      $175 = HEAP32[$174>>2]|0;
      $176 = (($173) + ($used_bits$124))|0;
      $177 = (($176) + ($175))|0;
      $used_bits$2 = $177;
     }
    } else {
     $142 = ((((((($gfc)) + 304|0) + (($gr$0*10504)|0)|0) + (($ch$022*5252)|0)|0)) + 2304|0);
     _memset(($142|0),0,2304)|0;
     $used_bits$2 = $used_bits$124;
    }
    $178 = (($ch$022) + 1)|0;
    $179 = HEAP32[$$pre$phiZ2D>>2]|0;
    $180 = ($178|0)<($179|0);
    if ($180) {
     $ch$022 = $178;$used_bits$124 = $used_bits$2;
    } else {
     $used_bits$2$lcssa = $used_bits$2;
     break;
    }
   }
   $$pre$pre$pre = HEAP32[$4>>2]|0;
   $$pre$pre = $$pre$pre$pre;$used_bits$1$lcssa = $used_bits$2$lcssa;
  } else {
   $$pre$pre = $120;$used_bits$1$lcssa = $used_bits$0;
  }
  $181 = (($gr$0) + 1)|0;
  $120 = $$pre$pre;$gr$0 = $181;$used_bits$0 = $used_bits$1$lcssa;
 }
 if (!($196)) {
  $265 = HEAP32[$mean_bits>>2]|0;
  _ResvFrameEnd($gfc,$265);
  STACKTOP = sp;return;
 }
 $197 = ((($gfc)) + 304|0);
 $198 = ((($gfc)) + 36|0);
 $$pre34 = HEAP32[$$pre$phiZ2D>>2]|0;
 $254 = $$pre34;$271 = $195;$gr$116 = 0;
 while(1) {
  $255 = ($254|0)>(0);
  if ($255) {
   $ch$115 = 0;
   while(1) {
    $256 = ((((($gfc)) + 304|0) + (($gr$116*10504)|0)|0) + (($ch$115*5252)|0)|0);
    _best_scalefac_store($gfc,$gr$116,$ch$115,$197);
    $257 = HEAP32[$198>>2]|0;
    $258 = ($257|0)==(1);
    if ($258) {
     _best_huffman_divide($gfc,$256);
    }
    _ResvAdjust($gfc,$256);
    $259 = (($ch$115) + 1)|0;
    $260 = HEAP32[$$pre$phiZ2D>>2]|0;
    $261 = ($259|0)<($260|0);
    if ($261) {
     $ch$115 = $259;
    } else {
     $$lcssa = $260;
     break;
    }
   }
   $$pre35 = HEAP32[$4>>2]|0;
   $264 = $$pre35;$272 = $$lcssa;
  } else {
   $264 = $271;$272 = $254;
  }
  $262 = (($gr$116) + 1)|0;
  $263 = ($262|0)<($264|0);
  if ($263) {
   $254 = $272;$271 = $264;$gr$116 = $262;
  } else {
   break;
  }
 }
 $265 = HEAP32[$mean_bits>>2]|0;
 _ResvFrameEnd($gfc,$265);
 STACKTOP = sp;return;
}
function _VBR_new_iteration_loop($gfc,$pe,$ms_ener_ratio,$ratio) {
 $gfc = $gfc|0;
 $pe = $pe|0;
 $ms_ener_ratio = $ms_ener_ratio|0;
 $ratio = $ratio|0;
 var $$i$0 = 0, $$lcssa = 0, $$lcssa65 = 0, $$lcssa69 = 0, $$lobit$i = 0, $$pre = 0, $$pre$i = 0, $$pre$i$lcssa = 0, $$pre44 = 0, $$pre45 = 0, $$pre46 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0;
 var $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0;
 var $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0;
 var $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0;
 var $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0.0, $41 = 0, $42 = 0.0;
 var $43 = 0.0, $44 = 0.0, $45 = 0.0, $46 = 0.0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0.0, $52 = 0.0, $53 = 0.0, $54 = 0.0, $55 = 0.0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0.0;
 var $98 = 0, $99 = 0, $analog_silence$0$lcssa2526$i = 0, $analog_silence$0$lcssa2527$i = 0, $analog_silence$014$i = 0, $analog_silence$1$$i = 0, $analog_silence$1$lcssa$i = 0, $analog_silence$1$lcssa$i$lcssa = 0, $analog_silence$110$i = 0, $avg$i = 0, $bits$015$i = 0, $bits$1$lcssa$i = 0, $bits$1$lcssa$i$lcssa = 0, $bits$111$i = 0, $ch$026 = 0, $ch$09$i = 0, $ch$15$i = 0, $ch$19 = 0, $exitcond$i$i = 0, $frameBits = 0;
 var $gr$016$i = 0, $gr$029 = 0, $gr$110 = 0, $gr$16$i = 0, $i$0$lcssa = 0, $i$0$ph = 0, $i$01$i = 0, $i$01$i$i = 0, $i$01$i2$i = 0, $i$018 = 0, $j$0$lcssa = 0, $j$013 = 0, $l3_xmin = 0, $max_bits = 0, $maximum_framebits$0$i = 0, $mean_bits = 0, $or$cond$i = 0, $sum$i = 0, $vararg_buffer = 0, $xrpow = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 9936|0;
 $vararg_buffer = sp;
 $sum$i = sp + 9932|0;
 $avg$i = sp + 9928|0;
 $l3_xmin = sp + 9304|0;
 $xrpow = sp + 88|0;
 $frameBits = sp + 24|0;
 $max_bits = sp + 8|0;
 $mean_bits = sp + 4|0;
 _memset(($xrpow|0),0,9216)|0;
 $0 = ((($gfc)) + 152|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)==(0);
 if ($2) {
  $3 = ((($gfc)) + 116|0);
  $4 = HEAP32[$3>>2]|0;
  $5 = ((($gfc)) + 84744|0);
  HEAP32[$5>>2] = $4;
  (_ResvFrameBegin($gfc,$avg$i)|0);
  $6 = ((($gfc)) + 52144|0);
  $7 = HEAP32[$6>>2]|0;
  $8 = ((($gfc)) + 112|0);
  $9 = HEAP32[$8>>2]|0;
  HEAP32[$5>>2] = $9;
  HEAP32[$5>>2] = 1;
  $10 = (_getframebits($gfc)|0);
  HEAP32[$sum$i>>2] = $10;
  $11 = HEAP32[$3>>2]|0;
  $12 = ($11|0)<(1);
  if ($12) {
   $19 = $11;
  } else {
   $i$01$i$i = 1;
   while(1) {
    HEAP32[$5>>2] = $i$01$i$i;
    $13 = (_ResvFrameBegin($gfc,$sum$i)|0);
    $14 = (($frameBits) + ($i$01$i$i<<2)|0);
    HEAP32[$14>>2] = $13;
    $15 = (($i$01$i$i) + 1)|0;
    $16 = HEAP32[$3>>2]|0;
    $17 = ($i$01$i$i|0)<($16|0);
    if ($17) {
     $i$01$i$i = $15;
    } else {
     $19 = $16;
     break;
    }
   }
  }
  $18 = (($frameBits) + ($19<<2)|0);
  $20 = HEAP32[$18>>2]|0;
  $163 = $7;$maximum_framebits$0$i = $20;
 } else {
  $21 = ((($gfc)) + 84744|0);
  HEAP32[$21>>2] = 0;
  $22 = (_ResvFrameBegin($gfc,$avg$i)|0);
  HEAP32[$frameBits>>2] = $22;
  $23 = ((($gfc)) + 52144|0);
  $24 = HEAP32[$23>>2]|0;
  $163 = $24;$maximum_framebits$0$i = $22;
 }
 $25 = ((($gfc)) + 76|0);
 $26 = HEAP32[$25>>2]|0;
 $27 = ($26|0)>(0);
 if ($27) {
  $28 = ((($gfc)) + 84756|0);
  $29 = ((($gfc)) + 72|0);
  $30 = ((($gfc)) + 84912|0);
  $31 = ((($gfc)) + 84908|0);
  $analog_silence$014$i = 1;$bits$015$i = 0;$gr$016$i = 0;
  while(1) {
   $35 = (($max_bits) + ($gr$016$i<<3)|0);
   $36 = HEAP32[$avg$i>>2]|0;
   (_on_pe($gfc,$pe,$35,$36,$gr$016$i,0)|0);
   $37 = HEAP32[$28>>2]|0;
   $38 = ($37|0)==(2);
   if ($38) {
    $i$01$i2$i = 0;
    while(1) {
     $39 = ((((($gfc)) + 304|0) + (($gr$016$i*10504)|0)|0) + ($i$01$i2$i<<2)|0);
     $40 = +HEAPF32[$39>>2];
     $41 = ((((((($gfc)) + 304|0) + (($gr$016$i*10504)|0)|0)) + 5252|0) + ($i$01$i2$i<<2)|0);
     $42 = +HEAPF32[$41>>2];
     $43 = $42 + $40;
     $44 = $43 * 0.70710676908493042;
     HEAPF32[$39>>2] = $44;
     $45 = $40 - $42;
     $46 = $45 * 0.70710676908493042;
     HEAPF32[$41>>2] = $46;
     $47 = (($i$01$i2$i) + 1)|0;
     $exitcond$i$i = ($47|0)==(576);
     if ($exitcond$i$i) {
      break;
     } else {
      $i$01$i2$i = $47;
     }
    }
   }
   $48 = HEAP32[$29>>2]|0;
   $49 = ($48|0)>(0);
   if ($49) {
    $analog_silence$110$i = $analog_silence$014$i;$bits$111$i = $bits$015$i;$ch$09$i = 0;
    while(1) {
     $50 = ((((($gfc)) + 304|0) + (($gr$016$i*10504)|0)|0) + (($ch$09$i*5252)|0)|0);
     $51 = +HEAPF32[$30>>2];
     $52 = $51;
     $53 = $52 * 0.10000000000000001;
     $54 = (+Math_pow(10.0,(+$53)));
     $55 = $54;
     HEAPF32[$31>>2] = $55;
     _init_outer_loop($gfc,$50);
     $56 = ((($ratio) + (($gr$016$i*976)|0)|0) + (($ch$09$i*488)|0)|0);
     $57 = ((($l3_xmin) + (($gr$016$i*312)|0)|0) + (($ch$09$i*156)|0)|0);
     $58 = (_calc_xmin($gfc,$56,$50,$57)|0);
     $59 = ($58|0)==(0);
     $analog_silence$1$$i = $59 ? $analog_silence$110$i : 0;
     $60 = ((($max_bits) + ($gr$016$i<<3)|0) + ($ch$09$i<<2)|0);
     $61 = HEAP32[$60>>2]|0;
     $62 = (($61) + ($bits$111$i))|0;
     $63 = (($ch$09$i) + 1)|0;
     $64 = HEAP32[$29>>2]|0;
     $65 = ($63|0)<($64|0);
     if ($65) {
      $analog_silence$110$i = $analog_silence$1$$i;$bits$111$i = $62;$ch$09$i = $63;
     } else {
      $$pre$i = $64;$analog_silence$1$lcssa$i = $analog_silence$1$$i;$bits$1$lcssa$i = $62;
      break;
     }
    }
   } else {
    $$pre$i = $48;$analog_silence$1$lcssa$i = $analog_silence$014$i;$bits$1$lcssa$i = $bits$015$i;
   }
   $66 = (($gr$016$i) + 1)|0;
   $67 = HEAP32[$25>>2]|0;
   $68 = ($66|0)<($67|0);
   if ($68) {
    $analog_silence$014$i = $analog_silence$1$lcssa$i;$bits$015$i = $bits$1$lcssa$i;$gr$016$i = $66;
   } else {
    $$lcssa69 = $67;$$pre$i$lcssa = $$pre$i;$analog_silence$1$lcssa$i$lcssa = $analog_silence$1$lcssa$i;$bits$1$lcssa$i$lcssa = $bits$1$lcssa$i;
    break;
   }
  }
  $32 = ($$lcssa69|0)>(0);
  if ($32) {
   $33 = ($bits$1$lcssa$i$lcssa|0)>($maximum_framebits$0$i|0);
   $34 = ($bits$1$lcssa$i$lcssa|0)>(0);
   $or$cond$i = $33 & $34;
   $69 = $$pre$i$lcssa;$gr$16$i = 0;
   while(1) {
    $70 = ($69|0)>(0);
    if ($70) {
     $165 = $69;$ch$15$i = 0;
     while(1) {
      if ($or$cond$i) {
       $71 = ((($max_bits) + ($gr$16$i<<3)|0) + ($ch$15$i<<2)|0);
       $72 = HEAP32[$71>>2]|0;
       $73 = Math_imul($72, $maximum_framebits$0$i)|0;
       $74 = (($73|0) / ($bits$1$lcssa$i$lcssa|0))&-1;
       HEAP32[$71>>2] = $74;
       $77 = $$pre$i$lcssa;
      } else {
       $77 = $165;
      }
      $75 = (($ch$15$i) + 1)|0;
      $76 = ($75|0)<($77|0);
      if ($76) {
       $165 = $77;$ch$15$i = $75;
      } else {
       $166 = $77;
       break;
      }
     }
    } else {
     $166 = $69;
    }
    $78 = (($gr$16$i) + 1)|0;
    $79 = ($78|0)<($$lcssa69|0);
    if ($79) {
     $69 = $166;$gr$16$i = $78;
    } else {
     break;
    }
   }
  }
  $80 = ($analog_silence$1$lcssa$i$lcssa|0)==(0);
  if ($80) {
   $134 = $163;$81 = $$lcssa69;$analog_silence$0$lcssa2527$i = 0;
  } else {
   $164 = $$lcssa69;$analog_silence$0$lcssa2526$i = $analog_silence$1$lcssa$i$lcssa;
   label = 21;
  }
 } else {
  $164 = $26;$analog_silence$0$lcssa2526$i = 1;
  label = 21;
 }
 if ((label|0) == 21) {
  $134 = 0;$81 = $164;$analog_silence$0$lcssa2527$i = $analog_silence$0$lcssa2526$i;
 }
 $82 = ($81|0)>(0);
 if ($82) {
  $83 = ((($gfc)) + 72|0);
  $84 = ((($gfc)) + 85824|0);
  $85 = ((($gfc)) + 85096|0);
  $$pre = HEAP32[$83>>2]|0;
  $167 = $81;$86 = $$pre;$gr$029 = 0;
  while(1) {
   $87 = ($86|0)>(0);
   if ($87) {
    $ch$026 = 0;
    while(1) {
     $88 = ((((($gfc)) + 304|0) + (($gr$029*10504)|0)|0) + (($ch$026*5252)|0)|0);
     $89 = ((($xrpow) + (($gr$029*4608)|0)|0) + (($ch$026*2304)|0)|0);
     HEAPF32[$sum$i>>2] = 0.0;
     $90 = ((((((($gfc)) + 304|0) + (($gr$029*10504)|0)|0) + (($ch$026*5252)|0)|0)) + 5208|0);
     $91 = HEAP32[$90>>2]|0;
     $92 = ((((((($gfc)) + 304|0) + (($gr$029*10504)|0)|0) + (($ch$026*5252)|0)|0)) + 4764|0);
     HEAPF32[$92>>2] = 0.0;
     $93 = (((($xrpow) + (($gr$029*4608)|0)|0) + (($ch$026*2304)|0)|0) + ($91<<2)|0);
     $94 = (576 - ($91))|0;
     $95 = $94 << 2;
     _memset(($93|0),0,($95|0))|0;
     $96 = HEAP32[$84>>2]|0;
     FUNCTION_TABLE_viiii[$96 & 7]($88,$89,$91,$sum$i);
     $97 = +HEAPF32[$sum$i>>2];
     $98 = $97 > 9.9999996826552254E-21;
     if ($98) {
      $99 = HEAP32[$85>>2]|0;
      $100 = $99 >>> 1;
      $$lobit$i = $100 & 1;
      $101 = ((((((($gfc)) + 304|0) + (($gr$029*10504)|0)|0) + (($ch$026*5252)|0)|0)) + 4864|0);
      $102 = HEAP32[$101>>2]|0;
      $103 = ($102|0)>(0);
      if ($103) {
       $i$01$i = 0;
       while(1) {
        $104 = (((($gfc)) + 84936|0) + ($i$01$i<<2)|0);
        HEAP32[$104>>2] = $$lobit$i;
        $105 = (($i$01$i) + 1)|0;
        $106 = HEAP32[$101>>2]|0;
        $107 = ($105|0)<($106|0);
        if ($107) {
         $i$01$i = $105;
        } else {
         break;
        }
       }
      }
     } else {
      $108 = ((((((($gfc)) + 304|0) + (($gr$029*10504)|0)|0) + (($ch$026*5252)|0)|0)) + 2304|0);
      _memset(($108|0),0,2304)|0;
      $109 = ((($max_bits) + ($gr$029<<3)|0) + ($ch$026<<2)|0);
      HEAP32[$109>>2] = 0;
     }
     $110 = (($ch$026) + 1)|0;
     $111 = HEAP32[$83>>2]|0;
     $112 = ($110|0)<($111|0);
     if ($112) {
      $ch$026 = $110;
     } else {
      $$lcssa65 = $111;
      break;
     }
    }
    $$pre44 = HEAP32[$25>>2]|0;
    $115 = $$pre44;$168 = $$lcssa65;
   } else {
    $115 = $167;$168 = $86;
   }
   $113 = (($gr$029) + 1)|0;
   $114 = ($113|0)<($115|0);
   if ($114) {
    $167 = $115;$86 = $168;$gr$029 = $113;
   } else {
    break;
   }
  }
 }
 $116 = (_VBR_encode_frame(($gfc|0),($xrpow|0),($l3_xmin|0),($max_bits|0))|0);
 $117 = HEAP32[$0>>2]|0;
 $118 = ($117|0)==(0);
 do {
  if ($118) {
   $119 = ($analog_silence$0$lcssa2527$i|0)==(0);
   if ($119) {
    label = 36;
   } else {
    $120 = ((($gfc)) + 124|0);
    $121 = HEAP32[$120>>2]|0;
    $122 = ($121|0)==(0);
    if ($122) {
     $i$0$ph = 1;
    } else {
     label = 36;
    }
   }
   if ((label|0) == 36) {
    $123 = ((($gfc)) + 112|0);
    $124 = HEAP32[$123>>2]|0;
    $i$0$ph = $124;
   }
   $125 = ((($gfc)) + 116|0);
   $126 = HEAP32[$125>>2]|0;
   $127 = ($i$0$ph|0)<($126|0);
   L63: do {
    if ($127) {
     $i$018 = $i$0$ph;
     while(1) {
      $128 = (($frameBits) + ($i$018<<2)|0);
      $129 = HEAP32[$128>>2]|0;
      $130 = ($116|0)>($129|0);
      if (!($130)) {
       $i$0$lcssa = $i$018;
       break L63;
      }
      $131 = (($i$018) + 1)|0;
      $132 = ($131|0)<($126|0);
      if ($132) {
       $i$018 = $131;
      } else {
       $i$0$lcssa = $131;
       break;
      }
     }
    } else {
     $i$0$lcssa = $i$0$ph;
    }
   } while(0);
   $133 = ($i$0$lcssa|0)>($126|0);
   $$i$0 = $133 ? $126 : $i$0$lcssa;
   $135 = ($134|0)>(0);
   if (!($135)) {
    $144 = ((($gfc)) + 84744|0);
    HEAP32[$144>>2] = $$i$0;
    $147 = $$i$0;
    break;
   }
   $136 = ($126|0)>($$i$0|0);
   L71: do {
    if ($136) {
     $j$013 = $126;
     while(1) {
      $137 = (($frameBits) + ($j$013<<2)|0);
      $138 = HEAP32[$137>>2]|0;
      $139 = (($138) - ($116))|0;
      $140 = ($139|0)>($134|0);
      if (!($140)) {
       $j$0$lcssa = $j$013;
       break L71;
      }
      $141 = (($j$013) + -1)|0;
      $142 = ($141|0)>($$i$0|0);
      if ($142) {
       $j$013 = $141;
      } else {
       $j$0$lcssa = $141;
       break;
      }
     }
    } else {
     $j$0$lcssa = $126;
    }
   } while(0);
   $143 = ((($gfc)) + 84744|0);
   HEAP32[$143>>2] = $j$0$lcssa;
   $147 = $j$0$lcssa;
  } else {
   $145 = ((($gfc)) + 84744|0);
   HEAP32[$145>>2] = 0;
   $147 = 0;
  }
 } while(0);
 $146 = (($frameBits) + ($147<<2)|0);
 $148 = HEAP32[$146>>2]|0;
 $149 = ($116|0)>($148|0);
 if ($149) {
  _lame_errorf($gfc,11768,$vararg_buffer);
  _exit(-1);
  // unreachable;
 }
 (_ResvFrameBegin($gfc,$mean_bits)|0);
 $150 = HEAP32[$25>>2]|0;
 $151 = ($150|0)>(0);
 if (!($151)) {
  $162 = HEAP32[$mean_bits>>2]|0;
  _ResvFrameEnd($gfc,$162);
  STACKTOP = sp;return;
 }
 $152 = ((($gfc)) + 72|0);
 $$pre45 = HEAP32[$152>>2]|0;
 $153 = $$pre45;$169 = $150;$gr$110 = 0;
 while(1) {
  $154 = ($153|0)>(0);
  if ($154) {
   $ch$19 = 0;
   while(1) {
    $155 = ((((($gfc)) + 304|0) + (($gr$110*10504)|0)|0) + (($ch$19*5252)|0)|0);
    _ResvAdjust($gfc,$155);
    $156 = (($ch$19) + 1)|0;
    $157 = HEAP32[$152>>2]|0;
    $158 = ($156|0)<($157|0);
    if ($158) {
     $ch$19 = $156;
    } else {
     $$lcssa = $157;
     break;
    }
   }
   $$pre46 = HEAP32[$25>>2]|0;
   $161 = $$pre46;$170 = $$lcssa;
  } else {
   $161 = $169;$170 = $153;
  }
  $159 = (($gr$110) + 1)|0;
  $160 = ($159|0)<($161|0);
  if ($160) {
   $153 = $170;$169 = $161;$gr$110 = $159;
  } else {
   break;
  }
 }
 $162 = HEAP32[$mean_bits>>2]|0;
 _ResvFrameEnd($gfc,$162);
 STACKTOP = sp;return;
}
function _ABR_iteration_loop($gfc,$pe,$ms_ener_ratio,$ratio) {
 $gfc = $gfc|0;
 $pe = $pe|0;
 $ms_ener_ratio = $ms_ener_ratio|0;
 $ratio = $ratio|0;
 var $$add_bits$0$i = 0, $$lcssa39 = 0, $$lobit$i = 0, $$pre = 0, $$pre$i = 0, $$pre37$i = 0, $$pre38$i = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0;
 var $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0;
 var $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0.0, $132 = 0, $133 = 0.0, $134 = 0.0, $135 = 0.0, $136 = 0.0, $137 = 0.0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0.0;
 var $146 = 0.0, $147 = 0.0, $148 = 0.0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0.0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0;
 var $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0;
 var $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0.0, $26 = 0.0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0.0, $36 = 0.0, $37 = 0.0, $38 = 0.0, $39 = 0.0, $4 = 0, $40 = 0.0, $41 = 0.0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0.0, $46 = 0.0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0.0, $55 = 0, $56 = 0.0, $57 = 0.0, $58 = 0.0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0.0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0.0, $97 = 0, $98 = 0, $99 = 0;
 var $add_bits$0$i = 0, $add_bits$1$i = 0, $ch$013 = 0, $ch$023$i = 0, $ch$128$i = 0, $ch$212$i = 0, $ch$39$i = 0, $exitcond$i = 0, $gr$015 = 0, $gr$030$i = 0, $gr$217$i = 0, $gr$310$i = 0, $i$01$i = 0, $i$01$i1 = 0, $l3_xmin = 0, $masking_lower_db$0 = 0.0, $masking_lower_db$0$in = 0, $mean_bits = 0, $or$cond$i = 0, $res_factor$0$i = 0.0;
 var $res_factor$1$i = 0.0, $sum$024$i = 0, $sum$i = 0, $targ_bits = 0, $totbits$016$i = 0, $totbits$1$lcssa$i = 0, $totbits$1$lcssa$i$lcssa = 0, $totbits$113$i = 0, $xrpow = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 2496|0;
 $sum$i = sp + 2484|0;
 $l3_xmin = sp + 2328|0;
 $xrpow = sp + 24|0;
 $targ_bits = sp + 8|0;
 $mean_bits = sp;
 $0 = ((($gfc)) + 304|0);
 HEAP32[$mean_bits>>2] = 0;
 $1 = ((($gfc)) + 76|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($gfc)) + 116|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ((($gfc)) + 84744|0);
 HEAP32[$5>>2] = $4;
 $6 = (_ResvFrameBegin($gfc,$sum$i)|0);
 HEAP32[$5>>2] = 1;
 $7 = (_getframebits($gfc)|0);
 $8 = ((($gfc)) + 24|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = $9 << 3;
 $11 = (($7) - ($10))|0;
 $12 = HEAP32[$1>>2]|0;
 $13 = ((($gfc)) + 72|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = Math_imul($14, $12)|0;
 $16 = (($11|0) / ($15|0))&-1;
 $17 = ((($gfc)) + 108|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($2*576000)|0;
 $20 = Math_imul($19, $18)|0;
 HEAP32[$sum$i>>2] = $20;
 $21 = ((($gfc)) + 85096|0);
 $22 = HEAP32[$21>>2]|0;
 $23 = $22 & 1;
 $24 = ($23|0)==(0);
 if ($24) {
  $31 = $20;
 } else {
  $25 = (+($20|0));
  $26 = $25 * 1.0900000000000001;
  $27 = (~~(($26)));
  HEAP32[$sum$i>>2] = $27;
  $31 = $27;
 }
 $28 = ((($gfc)) + 64|0);
 $29 = HEAP32[$28>>2]|0;
 $30 = (($31|0) / ($29|0))&-1;
 $32 = (($30) - ($10))|0;
 $33 = (($32|0) / ($15|0))&-1;
 HEAP32[$sum$i>>2] = $33;
 $34 = ((($gfc)) + 244|0);
 $35 = +HEAPF32[$34>>2];
 $36 = $35;
 $37 = 11.0 - $36;
 $38 = $37 * 0.012727272727272728;
 $39 = $38 + 0.93000000000000005;
 $40 = $39;
 $41 = $40;
 $42 = $41 < 0.90000000000000002;
 $res_factor$0$i = $42 ? 0.89999997615814208 : $40;
 $43 = ($12|0)>(0);
 if ($43) {
  $44 = $res_factor$0$i > 1.0;
  $res_factor$1$i = $44 ? 1.0 : $res_factor$0$i;
  $45 = (+($33|0));
  $46 = $res_factor$1$i * $45;
  $47 = (~~(($46)));
  $48 = (($33|0) / 2)&-1;
  $49 = ($33*3)|0;
  $50 = (($49|0) / 2)&-1;
  $51 = ($14|0)>(0);
  $gr$030$i = 0;
  while(1) {
   if ($51) {
    $ch$023$i = 0;$sum$024$i = 0;
    while(1) {
     $52 = ((($targ_bits) + ($gr$030$i<<3)|0) + ($ch$023$i<<2)|0);
     HEAP32[$52>>2] = $47;
     $53 = ((($pe) + ($gr$030$i<<3)|0) + ($ch$023$i<<2)|0);
     $54 = +HEAPF32[$53>>2];
     $55 = $54 > 700.0;
     if ($55) {
      $56 = $54 + -700.0;
      $57 = $56;
      $58 = $57 * 0.7142857142857143;
      $59 = (~~(($58)));
      $60 = ((((((($gfc)) + 304|0) + (($gr$030$i*10504)|0)|0) + (($ch$023$i*5252)|0)|0)) + 4788|0);
      $61 = HEAP32[$60>>2]|0;
      $62 = ($61|0)==(2);
      $63 = ($59|0)<($48|0);
      $64 = $63 & $62;
      $add_bits$0$i = $64 ? $48 : $59;
      $65 = ($add_bits$0$i|0)>($50|0);
      $66 = ($add_bits$0$i|0)<(0);
      $$add_bits$0$i = $66 ? 0 : $add_bits$0$i;
      $add_bits$1$i = $65 ? $50 : $$add_bits$0$i;
      $67 = (($add_bits$1$i) + ($47))|0;
      HEAP32[$52>>2] = $67;
      $68 = $67;
     } else {
      $68 = $47;
     }
     $69 = ($68|0)>(4095);
     if ($69) {
      HEAP32[$52>>2] = 4095;
      $71 = 4095;
     } else {
      $71 = $68;
     }
     $70 = (($71) + ($sum$024$i))|0;
     $72 = (($ch$023$i) + 1)|0;
     $73 = ($72|0)<($14|0);
     if ($73) {
      $ch$023$i = $72;$sum$024$i = $70;
     } else {
      $$lcssa39 = $70;
      break;
     }
    }
    $74 = ($$lcssa39|0)>(7680);
    if ($74) {
     $ch$128$i = 0;
     while(1) {
      $75 = ((($targ_bits) + ($gr$030$i<<3)|0) + ($ch$128$i<<2)|0);
      $76 = HEAP32[$75>>2]|0;
      $77 = ($76*7680)|0;
      $78 = (($77|0) / ($$lcssa39|0))&-1;
      HEAP32[$75>>2] = $78;
      $79 = (($ch$128$i) + 1)|0;
      $80 = ($79|0)<($14|0);
      if ($80) {
       $ch$128$i = $79;
      } else {
       break;
      }
     }
    }
   }
   $81 = (($gr$030$i) + 1)|0;
   $82 = ($81|0)<($12|0);
   if ($82) {
    $gr$030$i = $81;
   } else {
    break;
   }
  }
 }
 $83 = ((($gfc)) + 84756|0);
 $84 = HEAP32[$83>>2]|0;
 $85 = ($84|0)==(2);
 if ($85) {
  if ($43) {
   $86 = +HEAPF32[$ms_ener_ratio>>2];
   $87 = Math_imul($33, $14)|0;
   _reduce_side($targ_bits,$86,$87,7680);
   $88 = HEAP32[$1>>2]|0;
   $89 = ($88|0)>(1);
   if ($89) {
    $94 = 1;
    while(1) {
     $$pre$i = HEAP32[$sum$i>>2]|0;
     $$pre37$i = HEAP32[$13>>2]|0;
     $93 = (($targ_bits) + ($94<<3)|0);
     $95 = (($ms_ener_ratio) + ($94<<2)|0);
     $96 = +HEAPF32[$95>>2];
     $97 = Math_imul($$pre$i, $$pre37$i)|0;
     _reduce_side($93,$96,$97,7680);
     $98 = (($94) + 1)|0;
     $99 = HEAP32[$1>>2]|0;
     $100 = ($98|0)<($99|0);
     if ($100) {
      $94 = $98;
     } else {
      $90 = $99;
      label = 17;
      break;
     }
    }
   } else {
    $90 = $88;
    label = 17;
   }
  } else {
   label = 30;
  }
 } else {
  $90 = $12;
  label = 17;
 }
 if ((label|0) == 17) {
  $91 = ($90|0)>(0);
  if ($91) {
   $$pre38$i = HEAP32[$13>>2]|0;
   $92 = ($$pre38$i|0)>(0);
   $gr$217$i = 0;$totbits$016$i = 0;
   while(1) {
    if ($92) {
     $ch$212$i = 0;$totbits$113$i = $totbits$016$i;
     while(1) {
      $101 = ((($targ_bits) + ($gr$217$i<<3)|0) + ($ch$212$i<<2)|0);
      $102 = HEAP32[$101>>2]|0;
      $103 = ($102|0)>(4095);
      if ($103) {
       HEAP32[$101>>2] = 4095;
       $105 = 4095;
      } else {
       $105 = $102;
      }
      $104 = (($105) + ($totbits$113$i))|0;
      $106 = (($ch$212$i) + 1)|0;
      $107 = ($106|0)<($$pre38$i|0);
      if ($107) {
       $ch$212$i = $106;$totbits$113$i = $104;
      } else {
       $totbits$1$lcssa$i = $104;
       break;
      }
     }
    } else {
     $totbits$1$lcssa$i = $totbits$016$i;
    }
    $108 = (($gr$217$i) + 1)|0;
    $109 = ($108|0)<($90|0);
    if ($109) {
     $gr$217$i = $108;$totbits$016$i = $totbits$1$lcssa$i;
    } else {
     $totbits$1$lcssa$i$lcssa = $totbits$1$lcssa$i;
     break;
    }
   }
   $110 = ($totbits$1$lcssa$i$lcssa|0)>($6|0);
   $111 = ($totbits$1$lcssa$i$lcssa|0)>(0);
   $or$cond$i = $111 & $110;
   if ($or$cond$i) {
    $112 = ($$pre38$i|0)>(0);
    $192 = $90;$gr$310$i = 0;
    while(1) {
     if ($112) {
      $ch$39$i = 0;
      while(1) {
       $113 = ((($targ_bits) + ($gr$310$i<<3)|0) + ($ch$39$i<<2)|0);
       $114 = HEAP32[$113>>2]|0;
       $115 = Math_imul($114, $6)|0;
       $116 = (($115|0) / ($totbits$1$lcssa$i$lcssa|0))&-1;
       HEAP32[$113>>2] = $116;
       $117 = (($ch$39$i) + 1)|0;
       $118 = ($117|0)<($$pre38$i|0);
       if ($118) {
        $ch$39$i = $117;
       } else {
        $121 = $90;
        break;
       }
      }
     } else {
      $121 = $192;
     }
     $119 = (($gr$310$i) + 1)|0;
     $120 = ($119|0)<($121|0);
     if ($120) {
      $192 = $121;$gr$310$i = $119;
     } else {
      break;
     }
    }
   }
   $122 = ($90|0)>(0);
   if ($122) {
    $123 = ((($gfc)) + 84912|0);
    $124 = ((($gfc)) + 84916|0);
    $125 = ((($gfc)) + 84908|0);
    $126 = ((($gfc)) + 85824|0);
    $127 = ((($gfc)) + 36|0);
    $gr$015 = 0;
    while(1) {
     $128 = HEAP32[$83>>2]|0;
     $129 = ($128|0)==(2);
     if ($129) {
      $i$01$i = 0;
      while(1) {
       $130 = ((((($gfc)) + 304|0) + (($gr$015*10504)|0)|0) + ($i$01$i<<2)|0);
       $131 = +HEAPF32[$130>>2];
       $132 = ((((((($gfc)) + 304|0) + (($gr$015*10504)|0)|0)) + 5252|0) + ($i$01$i<<2)|0);
       $133 = +HEAPF32[$132>>2];
       $134 = $133 + $131;
       $135 = $134 * 0.70710676908493042;
       HEAPF32[$130>>2] = $135;
       $136 = $131 - $133;
       $137 = $136 * 0.70710676908493042;
       HEAPF32[$132>>2] = $137;
       $138 = (($i$01$i) + 1)|0;
       $exitcond$i = ($138|0)==(576);
       if ($exitcond$i) {
        break;
       } else {
        $i$01$i = $138;
       }
      }
     }
     $139 = HEAP32[$13>>2]|0;
     $140 = ($139|0)>(0);
     if ($140) {
      $ch$013 = 0;
      while(1) {
       $141 = ((((($gfc)) + 304|0) + (($gr$015*10504)|0)|0) + (($ch$013*5252)|0)|0);
       $142 = ((((((($gfc)) + 304|0) + (($gr$015*10504)|0)|0) + (($ch$013*5252)|0)|0)) + 4788|0);
       $143 = HEAP32[$142>>2]|0;
       $144 = ($143|0)==(2);
       $masking_lower_db$0$in = $144 ? $124 : $123;
       $masking_lower_db$0 = +HEAPF32[$masking_lower_db$0$in>>2];
       $145 = $masking_lower_db$0;
       $146 = $145 * 0.10000000000000001;
       $147 = (+Math_pow(10.0,(+$146)));
       $148 = $147;
       HEAPF32[$125>>2] = $148;
       _init_outer_loop($gfc,$141);
       HEAPF32[$sum$i>>2] = 0.0;
       $149 = ((((((($gfc)) + 304|0) + (($gr$015*10504)|0)|0) + (($ch$013*5252)|0)|0)) + 5208|0);
       $150 = HEAP32[$149>>2]|0;
       $151 = ((((((($gfc)) + 304|0) + (($gr$015*10504)|0)|0) + (($ch$013*5252)|0)|0)) + 4764|0);
       HEAPF32[$151>>2] = 0.0;
       $152 = (($xrpow) + ($150<<2