export const CountryType = {
	GERMANY: 0,
	EU: 1,
	OTHER: 2,
}
export const DecimalSeparator = {
	COMMA: 0,
	DOT: 1,
	UNKNOWN: 2,
}
/**
 * parameter names are shortened to reduce size
 */
export type Country = {
	/** name */
	n: string
	/** abbreviation */
	a: string
	/** type */
	t: number
	/** ??? */
	d: number
}
// taken from https://en.wikipedia.org/wiki/ISO_3166-1
export const Countries: ReadonlyArray<Country> = Object.freeze([
	{
		n: "Afghanistan",
		a: "AF",
		t: 2,
		d: 2,
	},
	{
		n: "Åland Islands",
		a: "AX",
		t: 2,
		d: 2,
	},
	{
		n: "Albania",
		a: "AL",
		t: 2,
		d: 0,
	},
	{
		n: "Algeria",
		a: "DZ",
		t: 2,
		d: 0,
	},
	{
		n: "American Samoa",
		a: "AS",
		t: 2,
		d: 2,
	},
	{
		n: "Andorra",
		a: "AD",
		t: 2,
		d: 0,
	},
	{
		n: "Angola",
		a: "AO",
		t: 2,
		d: 0,
	},
	{
		n: "Anguilla",
		a: "AI",
		t: 2,
		d: 2,
	},
	{
		n: "Antarctica",
		a: "AQ",
		t: 2,
		d: 2,
	},
	{
		n: "Antigua and Barbuda",
		a: "AG",
		t: 2,
		d: 2,
	},
	{
		n: "Argentina",
		a: "AR",
		t: 2,
		d: 0,
	},
	{
		n: "Armenia",
		a: "AM",
		t: 2,
		d: 0,
	},
	{
		n: "Aruba",
		a: "AW",
		t: 2,
		d: 2,
	},
	{
		n: "Australia",
		a: "AU",
		t: 2,
		d: 1,
	},
	{
		n: "Azerbaijan",
		a: "AZ",
		t: 2,
		d: 0,
	},
	{
		n: "Bahamas",
		a: "BS",
		t: 2,
		d: 2,
	},
	{
		n: "Bahrain",
		a: "BH",
		t: 2,
		d: 2,
	},
	{
		n: "Bangladesh",
		a: "BD",
		t: 2,
		d: 1,
	},
	{
		n: "Barbados",
		a: "BB",
		t: 2,
		d: 2,
	},
	{
		n: "Belarus",
		a: "BY",
		t: 2,
		d: 0,
	},
	{
		n: "Belgium",
		a: "BE",
		t: 1,
		d: 0,
	},
	{
		n: "Belize",
		a: "BZ",
		t: 2,
		d: 2,
	},
	{
		n: "Benin",
		a: "BJ",
		t: 2,
		d: 2,
	},
	{
		n: "Bermuda",
		a: "BM",
		t: 2,
		d: 2,
	},
	{
		n: "Bhutan",
		a: "BT",
		t: 2,
		d: 2,
	},
	{
		n: "Bolivia (Plurinational State of)",
		a: "BO",
		t: 2,
		d: 0,
	},
	{
		n: "Bonaire",
		a: "BQ",
		t: 2,
		d: 2,
	},
	{
		n: "Bosnia and Herzegovina",
		a: "BA",
		t: 2,
		d: 0,
	},
	{
		n: "Botswana",
		a: "BW",
		t: 2,
		d: 1,
	},
	{
		n: "Bouvet Island",
		a: "BV",
		t: 2,
		d: 2,
	},
	{
		n: "Brazil",
		a: "BR",
		t: 2,
		d: 0,
	},
	{
		n: "British Indian Ocean Territory",
		a: "IO",
		t: 2,
		d: 2,
	},
	{
		n: "Brunei Darussalam",
		a: "BN",
		t: 2,
		d: 1,
	},
	{
		n: "Bulgaria",
		a: "BG",
		t: 1,
		d: 0,
	},
	{
		n: "Burkina Faso",
		a: "BF",
		t: 2,
		d: 2,
	},
	{
		n: "Burundi",
		a: "BI",
		t: 2,
		d: 2,
	},
	{
		n: "Cabo Verde",
		a: "CV",
		t: 2,
		d: 2,
	},
	{
		n: "Cambodia",
		a: "KH",
		t: 2,
		d: 1,
	},
	{
		n: "Cameroon",
		a: "CM",
		t: 2,
		d: 0,
	},
	{
		n: "Canada",
		a: "CA",
		t: 2,
		d: 1,
	},
	{
		n: "Cayman Islands",
		a: "KY",
		t: 2,
		d: 2,
	},
	{
		n: "Central African Republic",
		a: "CF",
		t: 2,
		d: 2,
	},
	{
		n: "Chad",
		a: "TD",
		t: 2,
		d: 2,
	},
	{
		n: "Chile",
		a: "CL",
		t: 2,
		d: 0,
	},
	{
		n: "China",
		a: "CN",
		t: 2,
		d: 1,
	},
	{
		n: "Christmas Island",
		a: "CX",
		t: 2,
		d: 2,
	},
	{
		n: "Cocos (Keeling) Islands",
		a: "CC",
		t: 2,
		d: 2,
	},
	{
		n: "Colombia",
		a: "CO",
		t: 2,
		d: 0,
	},
	{
		n: "Comoros",
		a: "KM",
		t: 2,
		d: 2,
	},
	{
		n: "Congo",
		a: "CG",
		t: 2,
		d: 2,
	},
	{
		n: "Congo (Democratic Republic of the)",
		a: "CD",
		t: 2,
		d: 2,
	},
	{
		n: "Cook Islands",
		a: "CK",
		t: 2,
		d: 2,
	},
	{
		n: "Costa Rica",
		a: "CR",
		t: 2,
		d: 0,
	},
	{
		n: "Côte d'Ivoire",
		a: "CI",
		t: 2,
		d: 2,
	},
	{
		n: "Croatia",
		a: "HR",
		t: 1,
		d: 0,
	},
	{
		n: "Cuba",
		a: "CU",
		t: 2,
		d: 0,
	},
	{
		n: "Curaçao",
		a: "CW",
		t: 2,
		d: 2,
	},
	{
		n: "Cyprus",
		a: "CY",
		t: 1,
		d: 0,
	},
	{
		n: "Czech Republic",
		a: "CZ",
		t: 1,
		d: 0,
	},
	{
		n: "Denmark",
		a: "DK",
		t: 1,
		d: 0,
	},
	{
		n: "Deutschland",
		a: "DE",
		t: 0,
		d: 0,
	},
	{
		n: "Djibouti",
		a: "DJ",
		t: 2,
		d: 2,
	},
	{
		n: "Dominica",
		a: "DM",
		t: 2,
		d: 2,
	},
	{
		n: "Dominican Republic",
		a: "DO",
		t: 2,
		d: 1,
	},
	{
		n: "Ecuador",
		a: "EC",
		t: 2,
		d: 0,
	},
	{
		n: "Egypt",
		a: "EG",
		t: 2,
		d: 1,
	},
	{
		n: "El Salvador",
		a: "SV",
		t: 2,
		d: 1,
	},
	{
		n: "Equatorial Guinea",
		a: "GQ",
		t: 2,
		d: 2,
	},
	{
		n: "Eritrea",
		a: "ER",
		t: 2,
		d: 2,
	},
	{
		n: "Estonia",
		a: "EE",
		t: 1,
		d: 0,
	},
	{
		n: "Ethiopia",
		a: "ET",
		t: 2,
		d: 2,
	},
	{
		n: "Falkland Islands (Malvinas)",
		a: "FK",
		t: 2,
		d: 2,
	},
	{
		n: "Faroe Islands",
		a: "FO",
		t: 2,
		d: 0,
	},
	{
		n: "Fiji",
		a: "FJ",
		t: 2,
		d: 2,
	},
	{
		n: "Finland",
		a: "FI",
		t: 1,
		d: 0,
	},
	{
		n: "France",
		a: "FR",
		t: 1,
		d: 0,
	},
	{
		n: "French Guiana",
		a: "GF",
		t: 2,
		d: 2,
	},
	{
		n: "French Polynesia",
		a: "PF",
		t: 2,
		d: 2,
	},
	{
		n: "French Southern Territories",
		a: "TF",
		t: 2,
		d: 2,
	},
	{
		n: "Gabon",
		a: "GA",
		t: 2,
		d: 2,
	},
	{
		n: "Gambia",
		a: "GM",
		t: 2,
		d: 2,
	},
	{
		n: "Georgia",
		a: "GE",
		t: 2,
		d: 0,
	},
	{
		n: "Ghana",
		a: "GH",
		t: 2,
		d: 1,
	},
	{
		n: "Gibraltar",
		a: "GI",
		t: 2,
		d: 2,
	},
	{
		n: "Greece",
		a: "GR",
		t: 1,
		d: 0,
	},
	{
		n: "Greenland",
		a: "GL",
		t: 2,
		d: 0,
	},
	{
		n: "Grenada",
		a: "GD",
		t: 2,
		d: 2,
	},
	{
		n: "Guadeloupe",
		a: "GP",
		t: 2,
		d: 2,
	},
	{
		n: "Guam",
		a: "GU",
		t: 2,
		d: 2,
	},
	{
		n: "Guatemala",
		a: "GT",
		t: 2,
		d: 1,
	},
	{
		n: "Guernsey",
		a: "GG",
		t: 2,
		d: 2,
	},
	{
		n: "Guinea",
		a: "GN",
		t: 2,
		d: 2,
	},
	{
		n: "Guinea-Bissau",
		a: "GW",
		t: 2,
		d: 2,
	},
	{
		n: "Guyana",
		a: "GY",
		t: 2,
		d: 2,
	},
	{
		n: "Haiti",
		a: "HT",
		t: 2,
		d: 2,
	},
	{
		n: "Heard Island and McDonald Islands",
		a: "HM",
		t: 2,
		d: 2,
	},
	{
		n: "Holy See",
		a: "VA",
		t: 2,
		d: 2,
	},
	{
		n: "Honduras",
		a: "HN",
		t: 2,
		d: 1,
	},
	{
		n: "Hong Kong",
		a: "HK",
		t: 2,
		d: 1,
	},
	{
		n: "Hungary",
		a: "HU",
		t: 1,
		d: 0,
	},
	{
		n: "Iceland",
		a: "IS",
		t: 2,
		d: 0,
	},
	{
		n: "India",
		a: "IN",
		t: 2,
		d: 1,
	},
	{
		n: "Indonesia",
		a: "ID",
		t: 2,
		d: 0,
	},
	{
		n: "Iran (Islamic Republic of)",
		a: "IR",
		t: 2,
		d: 2,
	},
	{
		n: "Iraq",
		a: "IQ",
		t: 2,
		d: 2,
	},
	{
		n: "Ireland",
		a: "IE",
		t: 1,
		d: 1,
	},
	{
		n: "Isle of Man",
		a: "IM",
		t: 2,
		d: 2,
	},
	{
		n: "Israel",
		a: "IL",
		t: 2,
		d: 1,
	},
	{
		n: "Italy",
		a: "IT",
		t: 1,
		d: 0,
	},
	{
		n: "Jamaica",
		a: "JM",
		t: 2,
		d: 2,
	},
	{
		n: "Japan",
		a: "JP",
		t: 2,
		d: 1,
	},
	{
		n: "Jersey",
		a: "JE",
		t: 2,
		d: 2,
	},
	{
		n: "Jordan",
		a: "JO",
		t: 2,
		d: 1,
	},
	{
		n: "Kazakhstan",
		a: "KZ",
		t: 2,
		d: 0,
	},
	{
		n: "Kenya",
		a: "KE",
		t: 2,
		d: 1,
	},
	{
		n: "Kiribati",
		a: "KI",
		t: 2,
		d: 2,
	},
	{
		n: "Korea (Democratic People's Republic of)",
		a: "KP",
		t: 2,
		d: 1,
	},
	{
		n: "Korea (Republic of)",
		a: "KR",
		t: 2,
		d: 1,
	},
	{
		n: "Kuwait",
		a: "KW",
		t: 2,
		d: 2,
	},
	{
		n: "Kyrgyzstan",
		a: "KG",
		t: 2,
		d: 0,
	},
	{
		n: "Lao People's Democratic Republic",
		a: "LA",
		t: 2,
		d: 2,
	},
	{
		n: "Latvia",
		a: "LV",
		t: 1,
		d: 0,
	},
	{
		n: "Lebanon",
		a: "LB",
		t: 2,
		d: 2,
	},
	{
		n: "Lesotho",
		a: "LS",
		t: 2,
		d: 2,
	},
	{
		n: "Liberia",
		a: "LR",
		t: 2,
		d: 2,
	},
	{
		n: "Libya",
		a: "LY",
		t: 2,
		d: 2,
	},
	{
		n: "Liechtenstein",
		a: "LI",
		t: 2,
		d: 2,
	},
	{
		n: "Lithuania",
		a: "LT",
		t: 1,
		d: 0,
	},
	{
		n: "Luxembourg",
		a: "LU",
		t: 1,
		d: 2,
	},
	{
		n: "Macao",
		a: "MO",
		t: 2,
		d: 2,
	},
	{
		n: "Macedonia",
		a: "MK",
		t: 2,
		d: 0,
	},
	{
		n: "Madagascar",
		a: "MG",
		t: 2,
		d: 2,
	},
	{
		n: "Malawi",
		a: "MW",
		t: 2,
		d: 2,
	},
	{
		n: "Malaysia",
		a: "MY",
		t: 2,
		d: 1,
	},
	{
		n: "Maldives",
		a: "MV",
		t: 2,
		d: 2,
	},
	{
		n: "Mali",
		a: "ML",
		t: 2,
		d: 2,
	},
	{
		n: "Malta",
		a: "MT",
		t: 1,
		d: 1,
	},
	{
		n: "Marshall Islands",
		a: "MH",
		t: 2,
		d: 2,
	},
	{
		n: "Martinique",
		a: "MQ",
		t: 2,
		d: 2,
	},
	{
		n: "Mauritania",
		a: "MR",
		t: 2,
		d: 2,
	},
	{
		n: "Mauritius",
		a: "MU",
		t: 2,
		d: 2,
	},
	{
		n: "Mayotte",
		a: "YT",
		t: 2,
		d: 2,
	},
	{
		n: "Mexico",
		a: "MX",
		t: 2,
		d: 1,
	},
	{
		n: "Micronesia (Federated States of)",
		a: "FM",
		t: 2,
		d: 2,
	},
	{
		n: "Moldova (Republic of)",
		a: "MD",
		t: 2,
		d: 0,
	},
	{
		n: "Monaco",
		a: "MC",
		t: 2,
		d: 2,
	},
	{
		n: "Mongolia",
		a: "MN",
		t: 2,
		d: 2,
	},
	{
		n: "Montenegro",
		a: "ME",
		t: 2,
		d: 2,
	},
	{
		n: "Montserrat",
		a: "MS",
		t: 2,
		d: 2,
	},
	{
		n: "Morocco",
		a: "MA",
		t: 2,
		d: 0,
	},
	{
		n: "Mozambique",
		a: "MZ",
		t: 2,
		d: 0,
	},
	{
		n: "Myanmar",
		a: "MM",
		t: 2,
		d: 1,
	},
	{
		n: "Namibia",
		a: "NA",
		t: 2,
		d: 0,
	},
	{
		n: "Nauru",
		a: "NR",
		t: 2,
		d: 2,
	},
	{
		n: "Nepal",
		a: "NP",
		t: 2,
		d: 1,
	},
	{
		n: "Netherlands",
		a: "NL",
		t: 1,
		d: 0,
	},
	{
		n: "New Caledonia",
		a: "NC",
		t: 2,
		d: 2,
	},
	{
		n: "New Zealand",
		a: "NZ",
		t: 2,
		d: 1,
	},
	{
		n: "Nicaragua",
		a: "NI",
		t: 2,
		d: 1,
	},
	{
		n: "Niger",
		a: "NE",
		t: 2,
		d: 2,
	},
	{
		n: "Nigeria",
		a: "NG",
		t: 2,
		d: 1,
	},
	{
		n: "Niue",
		a: "NU",
		t: 2,
		d: 2,
	},
	{
		n: "Norfolk Island",
		a: "NF",
		t: 2,
		d: 2,
	},
	{
		n: "Northern Mariana Islands",
		a: "MP",
		t: 2,
		d: 2,
	},
	{
		n: "Norway",
		a: "NO",
		t: 2,
		d: 0,
	},
	{
		n: "Oman",
		a: "OM",
		t: 2,
		d: 2,
	},
	{
		n: "Österreich",
		a: "AT",
		t: 1,
		d: 0,
	},
	{
		n: "Pakistan",
		a: "PK",
		t: 2,
		d: 1,
	},
	{
		n: "Palau",
		a: "PW",
		t: 2,
		d: 2,
	},
	{
		n: "Palestine",
		a: "PS",
		t: 2,
		d: 1,
	},
	{
		n: "Panama",
		a: "PA",
		t: 2,
		d: 1,
	},
	{
		n: "Papua New Guinea",
		a: "PG",
		t: 2,
		d: 2,
	},
	{
		n: "Paraguay",
		a: "PY",
		t: 2,
		d: 0,
	},
	{
		n: "Peru",
		a: "PE",
		t: 2,
		d: 0,
	},
	{
		n: "Philippines",
		a: "PH",
		t: 2,
		d: 1,
	},
	{
		n: "Pitcairn",
		a: "PN",
		t: 2,
		d: 2,
	},
	{
		n: "Poland",
		a: "PL",
		t: 1,
		d: 0,
	},
	{
		n: "Portugal",
		a: "PT",
		t: 1,
		d: 0,
	},
	{
		n: "Puerto Rico",
		a: "PR",
		t: 2,
		d: 1,
	},
	{
		n: "Qatar",
		a: "QA",
		t: 2,
		d: 2,
	},
	{
		n: "Réunion",
		a: "RE",
		t: 2,
		d: 2,
	},
	{
		n: "Romania",
		a: "RO",
		t: 1,
		d: 0,
	},
	{
		n: "Russian Federation",
		a: "RU",
		t: 2,
		d: 0,
	},
	{
		n: "Rwanda",
		a: "RW",
		t: 2,
		d: 2,
	},
	{
		n: "Saint Barthélemy",
		a: "BL",
		t: 2,
		d: 2,
	},
	{
		n: "Saint Helena",
		a: "SH",
		t: 2,
		d: 2,
	},
	{
		n: "Saint Kitts and Nevis",
		a: "KN",
		t: 2,
		d: 2,
	},
	{
		n: "Saint Lucia",
		a: "LC",
		t: 2,
		d: 2,
	},
	{
		n: "Saint Martin (French part)",
		a: "MF",
		t: 2,
		d: 2,
	},
	{
		n: "Saint Pierre and Miquelon",
		a: "PM",
		t: 2,
		d: 2,
	},
	{
		n: "Saint Vincent and the Grenadines",
		a: "VC",
		t: 2,
		d: 2,
	},
	{
		n: "Samoa",
		a: "WS",
		t: 2,
		d: 2,
	},
	{
		n: "San Marino",
		a: "SM",
		t: 2,
		d: 2,
	},
	{
		n: "Sao Tome and Principe",
		a: "ST",
		t: 2,
		d: 2,
	},
	{
		n: "Saudi Arabia",
		a: "SA",
		t: 2,
		d: 2,
	},
	{
		n: "Senegal",
		a: "SN",
		t: 2,
		d: 2,
	},
	{
		n: "Serbia",
		a: "RS",
		t: 2,
		d: 0,
	},
	{
		n: "Seychelles",
		a: "SC",
		t: 2,
		d: 2,
	},
	{
		n: "Sierra Leone",
		a: "SL",
		t: 2,
		d: 2,
	},
	{
		n: "Singapore",
		a: "SG",
		t: 2,
		d: 1,
	},
	{
		n: "Sint Maarten (Dutch part)",
		a: "SX",
		t: 2,
		d: 2,
	},
	{
		n: "Slovakia",
		a: "SK",
		t: 1,
		d: 0,
	},
	{
		n: "Slovenia",
		a: "SI",
		t: 1,
		d: 0,
	},
	{
		n: "Solomon Islands",
		a: "SB",
		t: 2,
		d: 2,
	},
	{
		n: "Somalia",
		a: "SO",
		t: 2,
		d: 2,
	},
	{
		n: "South Africa",
		a: "ZA",
		t: 2,
		d: 0,
	},
	{
		n: "South Georgia and the South Sandwich Islands",
		a: "GS",
		t: 2,
		d: 2,
	},
	{
		n: "South Sudan",
		a: "SS",
		t: 2,
		d: 2,
	},
	{
		n: "Spain",
		a: "ES",
		t: 1,
		d: 0,
	},
	{
		n: "Sri Lanka",
		a: "LK",
		t: 2,
		d: 1,
	},
	{
		n: "Sudan",
		a: "SD",
		t: 2,
		d: 2,
	},
	{
		n: "Suriname",
		a: "SR",
		t: 2,
		d: 2,
	},
	{
		n: "Svalbard and Jan Mayen",
		a: "SJ",
		t: 2,
		d: 2,
	},
	{
		n: "Swaziland",
		a: "SZ",
		t: 2,
		d: 2,
	},
	{
		n: "Sweden",
		a: "SE",
		t: 1,
		d: 0,
	},
	{
		n: "Switzerland",
		a: "CH",
		t: 2,
		d: 0,
	},
	{
		n: "Syrian Arab Republic",
		a: "SY",
		t: 2,
		d: 2,
	},
	{
		n: "Taiwan",
		a: "TW",
		t: 2,
		d: 1,
	},
	{
		n: "Tajikistan",
		a: "TJ",
		t: 2,
		d: 2,
	},
	{
		n: "Tanzania",
		a: "TZ",
		t: 2,
		d: 1,
	},
	{
		n: "Thailand",
		a: "TH",
		t: 2,
		d: 1,
	},
	{
		n: "Timor-Leste",
		a: "TL",
		t: 2,
		d: 0,
	},
	{
		n: "Togo",
		a: "TG",
		t: 2,
		d: 2,
	},
	{
		n: "Tokelau",
		a: "TK",
		t: 2,
		d: 2,
	},
	{
		n: "Tonga",
		a: "TO",
		t: 2,
		d: 2,
	},
	{
		n: "Trinidad and Tobago",
		a: "TT",
		t: 2,
		d: 2,
	},
	{
		n: "Tunisia",
		a: "TN",
		t: 2,
		d: 0,
	},
	{
		n: "Turkey",
		a: "TR",
		t: 2,
		d: 0,
	},
	{
		n: "Turkmenistan",
		a: "TM",
		t: 2,
		d: 2,
	},
	{
		n: "Turks and Caicos Islands",
		a: "TC",
		t: 2,
		d: 2,
	},
	{
		n: "Tuvalu",
		a: "TV",
		t: 2,
		d: 2,
	},
	{
		n: "Uganda",
		a: "UG",
		t: 2,
		d: 1,
	},
	{
		n: "Ukraine",
		a: "UA",
		t: 2,
		d: 0,
	},
	{
		n: "United Arab Emirates",
		a: "AE",
		t: 2,
		d: 2,
	},
	{
		n: "United Kingdom",
		a: "GB",
		t: 2,
		d: 1,
	},
	{
		n: "United States Minor Outlying Islands",
		a: "UM",
		t: 2,
		d: 2,
	},
	{
		n: "United States of America",
		a: "US",
		t: 2,
		d: 1,
	},
	{
		n: "Uruguay",
		a: "UY",
		t: 2,
		d: 0,
	},
	{
		n: "Uzbekistan",
		a: "UZ",
		t: 2,
		d: 0,
	},
	{
		n: "Vanuatu",
		a: "VU",
		t: 2,
		d: 2,
	},
	{
		n: "Venezuela (Bolivarian Republic of)",
		a: "VE",
		t: 2,
		d: 0,
	},
	{
		n: "Viet Nam",
		a: "VN",
		t: 2,
		d: 0,
	},
	{
		n: "Virgin Islands (British)",
		a: "VG",
		t: 2,
		d: 2,
	},
	{
		n: "Virgin Islands (U.S.)",
		a: "VI",
		t: 2,
		d: 2,
	},
	{
		n: "Wallis and Futuna",
		a: "WF",
		t: 2,
		d: 2,
	},
	{
		n: "Western Sahara",
		a: "EH",
		t: 2,
		d: 2,
	},
	{
		n: "Yemen",
		a: "YE",
		t: 2,
		d: 2,
	},
	{
		n: "Zambia",
		a: "ZM",
		t: 2,
		d: 2,
	},
	{
		n: "Zimbabwe",
		a: "ZW",
		t: 2,
		d: 1,
	},
])

export function getByAbbreviation(abbreviation: string): Country | null {
	return Countries.find((c) => c.a === abbreviation) ?? null
}

export function getDecimalSeparator(abbreviation: string): string {
	let country = getByAbbreviation(abbreviation)

	if (country) {
		return country.d === DecimalSeparator.DOT ? "." : ","
	} else {
		return ","
	}
}
